"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_cognito_1 = require("@aws-cdk/aws-cognito");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
test('use user pool domain as record target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const zone = new aws_route53_1.PublicHostedZone(stack, 'HostedZone', { zoneName: 'test.public' });
    const userPool = new aws_cognito_1.UserPool(stack, 'UserPool');
    const domain = new aws_cognito_1.UserPoolDomain(stack, 'UserPoolDomain', {
        userPool,
        cognitoDomain: { domainPrefix: 'domain-prefix' },
    });
    // WHEN
    new aws_route53_1.ARecord(zone, 'Alias', {
        zone,
        target: aws_route53_1.RecordTarget.fromAlias(new lib_1.UserPoolDomainTarget(domain)),
    });
    // THEN
    expect(stack).toHaveResource('AWS::Route53::RecordSet', {
        AliasTarget: {
            DNSName: { 'Fn::GetAtt': [
                    'UserPoolDomainCloudFrontDomainName0B254952',
                    'DomainDescription.CloudFrontDistribution',
                ] },
            HostedZoneId: 'Z2FDTNDATAQYW2',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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