/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERUniversalTagOctets;
import java.util.Arrays;

class DERInteger
extends DERASN1Type {
    private long value;

    DERInteger(long l) {
        this.value = l;
        this.octets = this.calcOctets(this.value);
    }

    DERInteger(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    DERInteger(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    DERInteger(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    DERInteger(byte[] byArray, int n, int n2, boolean bl) {
        this.parse(byArray, n, n2, bl);
    }

    protected void parse(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new DERException("Illegal values are passed.");
        }
        if (bl) {
            this.octets = new byte[n2];
            System.arraycopy(byArray, n, this.octets, 0, n2);
        } else {
            super.parseExplicitOctets(byArray, n);
        }
        this.value = this.getValueOf(this.octets);
    }

    byte[] getUniveralTagOctets() {
        return DERUniversalTagOctets.INTEGER;
    }

    private final byte[] calcOctets(long l) {
        long l2 = l < 0L ? l ^ 0xFFFFFFFFFFFFFFFFL : l;
        int n = 0;
        for (long i = l2; i > 0L; i >>= 1) {
            ++n;
        }
        int n2 = n / 8 + 1;
        byte[] byArray = new byte[n2];
        l2 = l;
        for (int i = n2 - 1; i >= 0; --i) {
            byArray[i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    private final long getValueOf(byte[] byArray) {
        byte[] byArray2 = new byte[4];
        if ((byArray[0] & 0x80) != 0) {
            Arrays.fill(byArray2, (byte)-1);
        } else {
            Arrays.fill(byArray2, (byte)0);
        }
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        long l = 0L;
        for (int i = 0; i < byArray2.length; ++i) {
            l <<= 8;
            l |= (long)(byArray2[i] & 0xFF);
        }
        return l;
    }

    protected final boolean isConstructed() {
        return false;
    }

    long getValue() {
        return this.value;
    }
}

