"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from .batchshipmentcreaterequest import BatchShipmentCreateRequest
from .labelfiletypeenum import LabelFileTypeEnum
from dataclasses_json import Undefined, dataclass_json
from shippo import utils
from typing import List, Optional


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class BatchCreateRequest:
    default_carrier_account: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('default_carrier_account') }})
    r"""ID of the Carrier Account object to use as the default for all shipments in this Batch.
    The carrier account can be changed on a per-shipment basis by changing the carrier_account in the 
    corresponding BatchShipment object.
    """
    default_servicelevel_token: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('default_servicelevel_token') }})
    r"""Token of the service level to use as the default for all shipments in this Batch.
    The servicelevel can be changed on a per-shipment basis by changing the servicelevel_token in the 
    corresponding BatchShipment object. <a href=\"#tag/Service-Levels\">Servicelevel tokens can be found here.</a>
    """
    batch_shipments: List[BatchShipmentCreateRequest] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('batch_shipments') }})
    r"""Array of BatchShipment objects. The response keeps the same order as in the request array."""
    label_filetype: Optional[LabelFileTypeEnum] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('label_filetype'), 'exclude': lambda f: f is None }})
    r"""Print format of the <a href=\\"https://docs.goshippo.com/docs/shipments/shippinglabelsizes/\\">label</a>. If empty, will use the default format set from
    <a href=\"https://apps.goshippo.com/settings/labels\">the Shippo dashboard.</a>
    """
    metadata: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata'), 'exclude': lambda f: f is None }})
    r"""A string of up to 100 characters that can be filled with any additional information you want to attach to the object."""
    

