/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;

public class HtmlWriter
extends TurtleWriter {
    private boolean inActiveContext;
    private Resource currentContext;
    private String openPart;
    private Set<String> usedPrefixes;
    private boolean indentContexts = true;
    public static RDFFormat HTML_FORMAT = new RDFFormat("TriG HTML", "text/html", Charset.forName("UTF8"), "html", true, true);

    public HtmlWriter(OutputStream out, boolean indentContexts) {
        super(out);
        this.indentContexts = indentContexts;
    }

    public HtmlWriter(OutputStream out) {
        super(out);
    }

    public HtmlWriter(Writer writer, boolean indentContexts) {
        super(writer);
        this.indentContexts = indentContexts;
    }

    public HtmlWriter(Writer writer) {
        super(writer);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return HTML_FORMAT;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.writer.setIndentationString("&nbsp;&nbsp;");
        this.inActiveContext = false;
        this.currentContext = null;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        super.endRDF();
        try {
            this.closeActiveContext();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            Resource context = st.getContext();
            if (this.inActiveContext && !HtmlWriter.contextsEquals(context, this.currentContext)) {
                this.closePreviousStatement();
                this.closeActiveContext();
            }
            if (!this.inActiveContext) {
                if (this.openPart != null) {
                    this.writer.write(this.openPart);
                    this.writer.writeEOL();
                    this.openPart = null;
                }
                this.writer.write("<span class=\"nanopub-context-switch\">");
                if (context != null) {
                    this.writeResource(context, false);
                    this.writer.write(" ");
                }
                this.writer.write("{<br/></span>");
                this.writer.writeEOL();
                if (this.indentContexts) {
                    this.writer.increaseIndentation();
                }
                this.currentContext = context;
                this.inActiveContext = true;
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (subj.equals(this.lastWrittenSubject)) {
                if (pred.equals(this.lastWrittenPredicate)) {
                    this.writer.write(" , ");
                } else {
                    this.writer.write(" ;<br/>");
                    this.writer.writeEOL();
                    this.writePredicate(pred);
                    this.writer.write(" ");
                    this.lastWrittenPredicate = pred;
                }
            } else {
                this.closePreviousStatement();
                this.writeResource(subj, false);
                this.writer.write(" ");
                this.lastWrittenSubject = subj;
                this.writePredicate(pred);
                this.writer.write(" ");
                this.lastWrittenPredicate = pred;
                this.statementClosed = false;
                this.writer.increaseIndentation();
            }
            this.writeValue(obj, false);
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    protected void writeCommentLine(String line) throws IOException {
        this.closeActiveContext();
    }

    @Override
    protected void writeNamespace(String prefix, String name) throws IOException {
        this.closeActiveContext();
        if (this.openPart != null) {
            this.writer.write(this.openPart);
            this.writer.writeEOL();
            this.openPart = null;
        }
        this.writer.write("@prefix ");
        this.writer.write(prefix);
        this.writer.write(": &lt;");
        String uriString = StringEscapeUtils.escapeHtml4(TurtleUtil.encodeURIString(name));
        this.writer.write("<a href=\"" + uriString + "\">");
        this.writer.write(uriString);
        this.writer.write("</a>");
        this.writer.write("&gt; .<br/>");
        this.writer.writeEOL();
    }

    protected void closeActiveContext() throws IOException {
        if (this.inActiveContext) {
            if (this.indentContexts) {
                this.writer.decreaseIndentation();
            }
            this.writer.write("<span class=\"nanopub-context-switch\">}<br/></span>");
            this.writer.writeEOL();
            this.inActiveContext = false;
            this.currentContext = null;
        }
    }

    @Override
    protected void writePredicate(IRI predicate) throws IOException {
        if (predicate.equals(RDF.TYPE)) {
            this.writer.write("<a href=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\">a</a>");
        } else {
            this.writeURI(predicate);
        }
    }

    @Override
    protected void writeURI(IRI uri) throws IOException {
        String namespace;
        String p;
        String namespace2;
        String p2;
        String namespace3;
        String p3;
        String uriString = uri.toString();
        String prefix = (String)this.namespaceTable.get(uriString);
        if (prefix != null) {
            this.writer.write("<a href=\"" + StringEscapeUtils.escapeHtml4(uriString) + "\">");
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write("</a>");
            if (this.usedPrefixes != null) {
                this.usedPrefixes.add(prefix);
            }
            return;
        }
        prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (!TurtleUtil.isNameEndChar(uriString.charAt(uriString.length() - 1))) {
            splitIdx = -1;
        }
        if (splitIdx > 0) {
            String namespace4 = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace4);
        }
        int splitIdxDot = uriString.lastIndexOf(".") + 1;
        if (uriString.length() == splitIdxDot) {
            splitIdxDot = -1;
        }
        if (splitIdx > 0 && splitIdxDot > splitIdx && (p3 = (String)this.namespaceTable.get(namespace3 = uriString.substring(0, splitIdxDot))) != null) {
            splitIdx = splitIdxDot;
            prefix = p3;
        }
        int splitIdxColon = uriString.lastIndexOf(":") + 1;
        if (uriString.length() == splitIdxColon) {
            splitIdxColon = -1;
        }
        if (splitIdx > 0 && splitIdxColon > splitIdx && (p2 = (String)this.namespaceTable.get(namespace2 = uriString.substring(0, splitIdxColon))) != null) {
            splitIdx = splitIdxColon;
            prefix = p2;
        }
        int splitIdxUnderscore = uriString.lastIndexOf("_") + 1;
        if (uriString.length() == splitIdxUnderscore) {
            splitIdxUnderscore = -1;
        }
        if (splitIdx > 0 && splitIdxUnderscore > splitIdx && (p = (String)this.namespaceTable.get(namespace = uriString.substring(0, splitIdxUnderscore))) != null) {
            splitIdx = splitIdxUnderscore;
            prefix = p;
        }
        if (uriString.endsWith(".")) {
            prefix = null;
        }
        if (prefix != null) {
            this.writer.write("<a href=\"" + StringEscapeUtils.escapeHtml4(uriString) + "\">");
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(StringEscapeUtils.escapeHtml4(uriString.substring(splitIdx)));
            this.writer.write("</a>");
        } else {
            this.writer.write("&lt;");
            this.writer.write("<a href=\"" + StringEscapeUtils.escapeHtml4(uriString) + "\">");
            this.writer.write(StringEscapeUtils.escapeHtml4(TurtleUtil.encodeURIString(uriString)));
            this.writer.write("</a>");
            this.writer.write("&gt;");
        }
    }

    @Override
    protected void writeBNode(BNode bNode) throws IOException {
        throw new RuntimeException("Unexpected blank node");
    }

    @Override
    protected void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        IRI datatype = lit.getDatatype();
        if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue() && (XMLSchema.INTEGER.equals(datatype) || XMLSchema.DECIMAL.equals(datatype) || XMLSchema.DOUBLE.equals(datatype) || XMLSchema.BOOLEAN.equals(datatype))) {
            try {
                this.writer.write(StringEscapeUtils.escapeHtml4(XMLDatatypeUtil.normalize(label, datatype)));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            this.writer.write("\"\"\"");
            this.writer.write(StringEscapeUtils.escapeHtml4(TurtleUtil.encodeLongString(label)).replace("  ", "&nbsp; ").replace("  ", " &nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp").replace("\n", "<br/>"));
            this.writer.write("\"\"\"");
        } else {
            this.writer.write("\"");
            this.writer.write(StringEscapeUtils.escapeHtml4(TurtleUtil.encodeString(label)).replace("  ", "&nbsp; ").replace("  ", " &nbsp;"));
            this.writer.write("\"");
        }
        if (Literals.isLanguageLiteral(lit)) {
            this.writer.write("@");
            this.writer.write(lit.getLanguage().get());
        } else if (!XMLSchema.STRING.equals(datatype) || !this.xsdStringToPlainLiteral()) {
            this.writer.write("^^");
            this.writeURI(datatype);
        }
    }

    @Override
    protected void closePreviousStatement() throws IOException {
        if (!this.statementClosed) {
            this.writer.write(" . <br/>");
            this.writer.writeEOL();
            this.writer.decreaseIndentation();
            this.statementClosed = true;
            this.lastWrittenSubject = null;
            this.lastWrittenPredicate = null;
        }
    }

    public void startPart(String partName) throws IOException {
        this.closePreviousStatement();
        this.closeActiveContext();
        this.openPart = this.openPart != null ? this.openPart + "\n<div class=\"" + partName + "\">" : "<div class=\"" + partName + "\">";
    }

    public void endPart() throws IOException {
        this.closePreviousStatement();
        this.closeActiveContext();
        this.writer.write("</div>");
        this.writer.writeEOL();
    }

    public void writeHtmlStart() throws IOException {
        this.writenl("<!DOCTYPE html>");
        this.writenl("<html lang=\"en\">");
        this.writenl("<head>");
        this.writenl("<meta charset=\"utf-8\">");
        this.writenl("<title>Nanopublications</title>");
        this.writenl("<style>");
        this.writenl("body { margin: 20px; font-family: monaco,monospace; font-size: 11pt; color: #444; }");
        this.writenl("a { color: #000; text-decoration: none; }");
        this.writenl("a:hover { color: #666; }");
        this.writenl(".nanopub { margin: 0 0 30px 0; padding: 0px 10px 10px 10px; border-radius: 10px; border: solid; border-width: 1px; }");
        this.writenl(".nanopub-prefixes { margin-top: 10px; }");
        this.writenl(".nanopub-head { background: #e8e8e8; padding: 10px; margin-top: 10px; border-radius: 10px; }");
        this.writenl(".nanopub-assertion { background: #99ccff; padding: 10px; margin-top: 10px; border-radius: 10px; }");
        this.writenl(".nanopub-provenance { background: #f3a08c; padding: 10px; margin-top: 10px; border-radius: 10px; }");
        this.writenl(".nanopub-pubinfo { background: #ffff66; padding: 10px; margin-top: 10px; border-radius: 10px; }");
        this.writenl("</style>");
        this.writenl("</head>");
        this.writenl("<body>");
    }

    public void writeHtmlEnd() throws IOException {
        this.writenl("</body>");
        this.writenl("</htmls>");
    }

    private void writenl(String s) throws IOException {
        this.writer.write(s);
        this.writer.writeEOL();
    }

    private boolean xsdStringToPlainLiteral() {
        return this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
    }

    private static final boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals(context2);
    }
}

