/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.index;

import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.extra.index.NanopubIndex;
import org.nanopub.extra.index.NanopubIndexImpl;

public class IndexUtils {
    private IndexUtils() {
    }

    public static boolean isIndex(Nanopub np) {
        for (Statement st : np.getPubinfo()) {
            if (!st.getSubject().equals(np.getUri()) || !st.getPredicate().equals(RDF.TYPE) || !st.getObject().equals(NanopubIndex.NANOPUB_INDEX_URI)) continue;
            return true;
        }
        return false;
    }

    public static NanopubIndex castToIndex(Nanopub np) throws MalformedNanopubException {
        if (np instanceof NanopubIndex) {
            return (NanopubIndex)np;
        }
        return new NanopubIndexImpl(np);
    }
}

