/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.trustyuri.TrustyUriUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.nanopub.Nanopub;
import org.nanopub.extra.security.CryptoElement;
import org.nanopub.extra.security.KeyDeclaration;
import org.nanopub.extra.security.MalformedCryptoElementException;
import org.nanopub.extra.server.GetNanopub;

public class IntroNanopub {
    static HttpClient defaultHttpClient;
    private Nanopub nanopub;
    private IRI user;
    private String name;
    private Map<IRI, KeyDeclaration> keyDeclarations = new HashMap<IRI, KeyDeclaration>();

    public static IntroNanopub get(String userId) throws IOException, RDF4JException {
        return IntroNanopub.get(userId, (HttpClient)null);
    }

    public static IntroNanopub get(String userId, HttpClient httpClient) throws IOException, RDF4JException {
        IntroExtractor ie = IntroNanopub.extract(userId, httpClient);
        if (ie != null) {
            return new IntroNanopub(ie.getIntroNanopub(), ie.getName(), SimpleValueFactory.getInstance().createIRI(userId));
        }
        return null;
    }

    public static IntroNanopub get(String userId, IntroExtractor ie) {
        return new IntroNanopub(ie.getIntroNanopub(), ie.getName(), SimpleValueFactory.getInstance().createIRI(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntroExtractor extract(String userId, HttpClient httpClient) throws IOException, RDF4JException {
        if (httpClient == null) {
            httpClient = defaultHttpClient;
        }
        HttpGet get = new HttpGet(userId);
        get.setHeader("Accept", "text/turtle");
        try (InputStream in = null;){
            HttpResponse resp = httpClient.execute(get);
            if (!IntroNanopub.wasSuccessful(resp)) {
                EntityUtils.consumeQuietly(resp.getEntity());
                throw new IOException(resp.getStatusLine().toString());
            }
            in = resp.getEntity().getContent();
            IntroExtractor ie = new IntroExtractor(userId);
            TurtleParser parser = new TurtleParser();
            parser.setRDFHandler(ie);
            parser.parse(in, userId);
            IntroExtractor introExtractor = ie;
            return introExtractor;
        }
    }

    public IntroNanopub(Nanopub nanopub, IRI user) {
        this(nanopub, null, user);
    }

    public IntroNanopub(Nanopub nanopub, String name, IRI user) {
        KeyDeclaration d;
        IRI subj;
        this.nanopub = nanopub;
        this.user = user;
        for (Statement st : nanopub.getAssertion()) {
            if (!st.getPredicate().equals(KeyDeclaration.DECLARED_BY) || !(st.getObject() instanceof IRI)) continue;
            subj = (IRI)st.getSubject();
            if (this.keyDeclarations.containsKey(subj)) {
                d = this.keyDeclarations.get(subj);
            } else {
                d = new KeyDeclaration(subj);
                this.keyDeclarations.put(subj, d);
            }
            d.addDeclarer((IRI)st.getObject());
        }
        for (Statement st : nanopub.getAssertion()) {
            subj = (IRI)st.getSubject();
            if (!this.keyDeclarations.containsKey(subj)) continue;
            d = this.keyDeclarations.get(subj);
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            if (pred.equals(CryptoElement.HAS_ALGORITHM) && obj instanceof Literal) {
                try {
                    d.setAlgorithm((Literal)obj);
                }
                catch (MalformedCryptoElementException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!pred.equals(CryptoElement.HAS_PUBLIC_KEY) || !(obj instanceof Literal)) continue;
            try {
                d.setPublicKeyLiteral((Literal)obj);
            }
            catch (MalformedCryptoElementException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Nanopub getNanopub() {
        return this.nanopub;
    }

    public IRI getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public List<KeyDeclaration> getKeyDeclarations() {
        return new ArrayList<KeyDeclaration>(this.keyDeclarations.values());
    }

    private static boolean wasSuccessful(HttpResponse resp) {
        int c = resp.getStatusLine().getStatusCode();
        return c >= 200 && c < 300;
    }

    static {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(100).setSocketTimeout(1000).build();
        defaultHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public static class IntroExtractor
    extends AbstractRDFHandler {
        private String userId;
        private Nanopub introNanopub;
        private String name;

        public IntroExtractor(String userId) {
            this.userId = userId;
        }

        @Override
        public void handleStatement(Statement st) throws RDFHandlerException {
            if (this.introNanopub != null) {
                return;
            }
            if (!st.getSubject().stringValue().equals(this.userId)) {
                return;
            }
            if (st.getPredicate().stringValue().equals(FOAF.PAGE.stringValue())) {
                String o = st.getObject().stringValue();
                if (TrustyUriUtils.isPotentialTrustyUri(o)) {
                    this.introNanopub = GetNanopub.get(o);
                }
            } else if (st.getPredicate().stringValue().equals(RDFS.LABEL.stringValue())) {
                this.name = st.getObject().stringValue();
            }
        }

        public Nanopub getIntroNanopub() {
            return this.introNanopub;
        }

        public String getName() {
            return this.name;
        }
    }
}

