/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.trustyuri.TrustyUriUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubUtils;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;
import org.nanopub.extra.server.GetNanopub;
import org.nanopub.extra.server.NanopubSurfacePattern;
import org.nanopub.extra.server.ServerInfo;
import org.nanopub.extra.server.ServerIterator;

public class FetchIndex {
    public static final int maxParallelRequestsPerServer = 5;
    private OutputStream out;
    private RDFFormat format;
    private boolean writeIndex;
    private boolean writeContent;
    private boolean running = false;
    private List<FetchNanopubTask> fetchTasks;
    private List<ServerInfo> servers;
    private ServerInfo localServerInfo;
    private Map<String, Set<FetchNanopubTask>> serverLoad;
    private Map<String, NanopubSurfacePattern> serverPatterns;
    private Map<String, Integer> serverUsage;
    private int nanopubCount;
    private Listener listener;
    private HttpClient httpClient;

    protected FetchIndex() {
    }

    public FetchIndex(String indexUri, OutputStream out, RDFFormat format, boolean writeIndex, boolean writeContent, String localServer) {
        this.out = out;
        this.format = format;
        this.writeIndex = writeIndex;
        this.writeContent = writeContent;
        this.fetchTasks = new ArrayList<FetchNanopubTask>();
        this.fetchTasks.add(new FetchNanopubTask(indexUri, true, new FetchNanopubTask[0]));
        this.servers = new ArrayList<ServerInfo>();
        this.serverLoad = new HashMap<String, Set<FetchNanopubTask>>();
        this.serverPatterns = new HashMap<String, NanopubSurfacePattern>();
        this.serverUsage = new HashMap<String, Integer>();
        ServerIterator serverIterator = new ServerIterator();
        while (serverIterator.hasNext()) {
            ServerInfo serverInfo = serverIterator.next();
            this.servers.add(serverInfo);
            this.serverLoad.put(serverInfo.getPublicUrl(), new HashSet());
            this.serverPatterns.put(serverInfo.getPublicUrl(), new NanopubSurfacePattern(serverInfo));
            this.serverUsage.put(serverInfo.getPublicUrl(), 0);
        }
        try {
            ServerIterator.writeCachedServers(this.servers);
        }
        catch (Exception serverInfo) {
            // empty catch block
        }
        if (localServer != null) {
            try {
                this.localServerInfo = ServerInfo.load(localServer);
                this.servers.add(this.localServerInfo);
                this.serverLoad.put(localServer, new HashSet());
                this.serverPatterns.put(localServer, new NanopubSurfacePattern(this.localServerInfo));
                this.serverUsage.put(localServer, 0);
            }
            catch (ServerInfo.ServerInfoException ex) {
                ex.printStackTrace();
                return;
            }
        }
        this.nanopubCount = 0;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(100).setSocketTimeout(2000).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(10);
        connManager.setMaxTotal(1000);
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager(connManager).build();
    }

    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        while (!this.fetchTasks.isEmpty()) {
            this.checkTasks();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void checkTasks() {
        block4: for (FetchNanopubTask task : new ArrayList<FetchNanopubTask>(this.fetchTasks)) {
            if (task.isRunning()) continue;
            if (task.isCancelled()) {
                this.fetchTasks.remove(task);
                continue;
            }
            if (task.getLastServerUrl() != null) {
                this.serverLoad.get(task.getLastServerUrl()).remove(task);
            }
            if (task.getNanopub() == null) {
                if (task.getTriedServersCount() == this.servers.size()) {
                    System.err.println("Failed to get " + task.getNanopubUri());
                    this.fetchTasks.remove(task);
                    continue;
                }
                if (this.localServerInfo != null && !task.hasServerBeenTried(this.localServerInfo.getPublicUrl())) {
                    this.assignTask(task, this.localServerInfo.getPublicUrl());
                    break;
                }
                ArrayList<ServerInfo> shuffledServers = new ArrayList<ServerInfo>(this.servers);
                Collections.shuffle(shuffledServers);
                for (ServerInfo serverInfo : shuffledServers) {
                    String serverUrl = serverInfo.getPublicUrl();
                    if (task.hasServerBeenTried(serverUrl)) continue;
                    if (!this.serverPatterns.get(serverUrl).matchesUri(task.getNanopubUri())) {
                        task.ignoreServer(serverUrl);
                        continue;
                    }
                    int load = this.serverLoad.get(serverUrl).size();
                    if (load >= 5) continue;
                    this.assignTask(task, serverUrl);
                    continue block4;
                }
                continue;
            }
            if (task.isIndex()) {
                if (this.fetchTasks.size() >= 3000) continue;
                try {
                    Nanopub np = task.getNanopub();
                    if (!IndexUtils.isIndex(np)) {
                        throw new RuntimeException("NOT AN INDEX: " + np.getUri());
                    }
                    NanopubIndex npi = IndexUtils.castToIndex(np);
                    if (this.writeIndex) {
                        this.writeNanopub(npi);
                    }
                    if (this.writeContent) {
                        for (IRI elementUri : npi.getElements()) {
                            this.fetchTasks.add(new FetchNanopubTask(elementUri.toString(), false, new FetchNanopubTask[0]));
                        }
                    }
                    for (IRI subIndexUri : npi.getSubIndexes()) {
                        FetchNanopubTask t1 = new FetchNanopubTask(subIndexUri.toString(), true, new FetchNanopubTask[0]);
                        this.fetchTasks.add(0, t1);
                        FetchNanopubTask t2 = new FetchNanopubTask(subIndexUri.toString(), true, t1);
                        this.fetchTasks.add(0, t2);
                        FetchNanopubTask t3 = new FetchNanopubTask(subIndexUri.toString(), true, t1, t2);
                        this.fetchTasks.add(0, t3);
                    }
                    if (npi.getAppendedIndex() != null) {
                        FetchNanopubTask fetchNanopubTask = new FetchNanopubTask(npi.getAppendedIndex().toString(), true, new FetchNanopubTask[0]);
                        this.fetchTasks.add(0, fetchNanopubTask);
                        FetchNanopubTask t2 = new FetchNanopubTask(npi.getAppendedIndex().toString(), true, fetchNanopubTask);
                        this.fetchTasks.add(0, t2);
                        FetchNanopubTask t3 = new FetchNanopubTask(npi.getAppendedIndex().toString(), true, fetchNanopubTask, t2);
                        this.fetchTasks.add(0, t3);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.fetchTasks.remove(task);
                continue;
            }
            try {
                this.writeNanopub(task.getNanopub());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.fetchTasks.remove(task);
        }
    }

    private void writeNanopub(Nanopub np) throws RDFHandlerException {
        ++this.nanopubCount;
        if (this.listener != null && this.nanopubCount % 100 == 0) {
            this.listener.progress(this.nanopubCount);
        }
        NanopubUtils.writeToStream(np, this.out, this.format);
    }

    public int getNanopubCount() {
        return this.nanopubCount;
    }

    public List<ServerInfo> getServers() {
        return new ArrayList<ServerInfo>(this.servers);
    }

    public int getServerUsage(ServerInfo si) {
        return this.serverUsage.get(si.getPublicUrl());
    }

    public void setProgressListener(Listener l) {
        this.listener = l;
    }

    private void assignTask(final FetchNanopubTask task, final String serverUrl) {
        task.prepareForTryingServer(serverUrl);
        this.serverLoad.get(serverUrl).add(task);
        Runnable runFetchTask = new Runnable(){

            @Override
            public void run() {
                task.tryServer(serverUrl);
            }
        };
        Thread thread = new Thread(runFetchTask);
        thread.start();
    }

    public static interface Listener {
        public void progress(int var1);

        public void exceptionHappened(Exception var1, String var2, String var3);
    }

    private class FetchNanopubTask {
        private String npUri;
        private boolean isIndex;
        private Nanopub nanopub;
        private Set<String> servers = new HashSet<String>();
        private boolean running = false;
        private boolean cancelled = false;
        private String lastServerUrl;
        private Set<FetchNanopubTask> siblings;

        public FetchNanopubTask(String npUri, boolean isIndex, FetchNanopubTask ... siblings) {
            this.npUri = npUri;
            this.isIndex = isIndex;
            this.siblings = new HashSet<FetchNanopubTask>(Arrays.asList(siblings));
            for (FetchNanopubTask s : siblings) {
                s.siblings.add(this);
            }
        }

        public boolean isIndex() {
            return this.isIndex;
        }

        public Nanopub getNanopub() {
            return this.nanopub;
        }

        public String getNanopubUri() {
            return this.npUri;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean hasServerBeenTried(String serverUrl) {
            return this.servers.contains(serverUrl);
        }

        public int getTriedServersCount() {
            return this.servers.size();
        }

        public String getLastServerUrl() {
            return this.lastServerUrl;
        }

        public void ignoreServer(String serverUrl) {
            this.servers.add(serverUrl);
        }

        public void prepareForTryingServer(String serverUrl) {
            this.servers.add(serverUrl);
            this.lastServerUrl = serverUrl;
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void tryServer(String serverUrl) {
            boolean serverTried = false;
            try {
                serverTried = true;
                this.nanopub = GetNanopub.get(TrustyUriUtils.getArtifactCode(this.npUri), serverUrl, FetchIndex.this.httpClient);
                this.running = false;
                if (!serverTried) return;
                Class<FetchIndex> clazz = FetchIndex.class;
            }
            catch (ConnectionPoolTimeoutException ex2222222) {
                serverTried = false;
                this.running = false;
                if (!serverTried) return;
                Class<FetchIndex> ex2222222 = FetchIndex.class;
                synchronized (FetchIndex.class) {
                    if (this.cancelled) return;
                    for (FetchNanopubTask s : this.siblings) {
                        s.cancelled = true;
                    }
                    FetchIndex.this.serverUsage.put(serverUrl, (Integer)FetchIndex.this.serverUsage.get(serverUrl) + 1);
                    // ** MonitorExit[ex] (shouldn't be in output)
                    return;
                }
            }
            catch (Exception ex) {
                if (FetchIndex.this.listener != null) {
                    FetchIndex.this.listener.exceptionHappened(ex, serverUrl, TrustyUriUtils.getArtifactCode(this.npUri));
                }
                this.running = false;
                if (!serverTried) return;
                Class<FetchIndex> clazz = FetchIndex.class;
                synchronized (FetchIndex.class) {
                    if (this.cancelled) return;
                    for (FetchNanopubTask s : this.siblings) {
                        s.cancelled = true;
                    }
                    FetchIndex.this.serverUsage.put(serverUrl, (Integer)FetchIndex.this.serverUsage.get(serverUrl) + 1);
                    // ** MonitorExit[var3_7] (shouldn't be in output)
                    return;
                }
                {
                    catch (Throwable throwable) {
                        this.running = false;
                        if (!serverTried) throw throwable;
                        Class<FetchIndex> clazz2 = FetchIndex.class;
                        synchronized (FetchIndex.class) {
                            if (this.cancelled) throw throwable;
                            for (FetchNanopubTask s : this.siblings) {
                                s.cancelled = true;
                            }
                            FetchIndex.this.serverUsage.put(serverUrl, (Integer)FetchIndex.this.serverUsage.get(serverUrl) + 1);
                            // ** MonitorExit[var10_18] (shouldn't be in output)
                            throw throwable;
                        }
                    }
                }
            }
            synchronized (FetchIndex.class) {
                if (this.cancelled) return;
                for (FetchNanopubTask s : this.siblings) {
                    s.cancelled = true;
                }
                FetchIndex.this.serverUsage.put(serverUrl, (Integer)FetchIndex.this.serverUsage.get(serverUrl) + 1);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

