/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubCreator;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;

public class Build {
    @Parameter(description="input-rdf-files", required=true)
    private List<File> inputRdfdFiles = new ArrayList<File>();
    @Parameter(names={"-d"}, description="Point to the URI of the resource the created nanopublications are derived from")
    private String derivedFrom;
    @Parameter(names={"-c"}, description="Creator of nanopublication")
    private List<String> creators = new ArrayList<String>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input RDF files: ttl, jsonld, nt, ttl.gz, ...")
    private String inFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    private RDFFormat rdfInFormat;
    private RDFFormat rdfOutFormat;
    private OutputStream outputStream = System.out;
    private Random random = new Random();
    private NanopubCreator npCreator;
    private IRI nanopubIri;
    private IRI assertionIri;
    private Resource previousSubj;
    private IRI derivedFromUri;
    private List<Pair<String, String>> namespaces = new ArrayList<Pair<String, String>>();
    private static SimpleValueFactory vf = SimpleValueFactory.getInstance();

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Build obj = new Build();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.outputFile == null) {
            if (this.outFormat == null) {
                this.outFormat = "trig";
            }
            this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
        } else {
            this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
            this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
        }
        if (this.derivedFrom != null) {
            this.derivedFromUri = vf.createIRI(this.derivedFrom);
        }
        for (File inputFile : this.inputRdfdFiles) {
            String dummyFileName = this.inFormat != null ? "file." + this.inFormat : inputFile.toString();
            this.rdfInFormat = Rio.getParserFormatForFileName(dummyFileName).orElse(null);
            FilterInputStream inputStream = dummyFileName.matches(".*\\.(gz|gzip)") ? new GZIPInputStream(new BufferedInputStream(new FileInputStream(inputFile))) : new BufferedInputStream(new FileInputStream(inputFile));
            RDFParser parser = Rio.createParser(this.rdfInFormat);
            parser.setRDFHandler(new RDFHandler(){

                @Override
                public void startRDF() throws RDFHandlerException {
                }

                @Override
                public void handleStatement(Statement st) throws RDFHandlerException {
                    Build.this.processStatement(st);
                }

                @Override
                public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                    Build.this.processNamespace(prefix, uri);
                }

                @Override
                public void handleComment(String comment) throws RDFHandlerException {
                }

                @Override
                public void endRDF() throws RDFHandlerException {
                }
            });
            parser.parse(inputStream, "http://example.com/baseuri");
            ((InputStream)inputStream).close();
        }
        if (this.previousSubj != null) {
            this.finalizeNanopub();
        }
        this.outputStream.flush();
        if (this.outputStream != System.out) {
            this.outputStream.close();
        }
    }

    private void processStatement(Statement st) {
        this.prepareCreator(st.getSubject());
        this.npCreator.addAssertionStatements(st);
    }

    private void processNamespace(String prefix, String uri) {
        this.prepareCreator(null);
        this.namespaces.add(Pair.of(prefix, uri));
        this.npCreator.addNamespace(prefix, uri);
    }

    private void prepareCreator(Resource subj) {
        if (this.previousSubj != null && subj != null && !subj.equals(this.previousSubj)) {
            this.finalizeNanopub();
        }
        if (this.npCreator == null) {
            this.initNanopub();
        }
        this.previousSubj = subj;
    }

    private void initNanopub() {
        String npUriString = "http://purl.org/nanopub/temp/" + Math.abs(this.random.nextInt()) + "/";
        this.nanopubIri = vf.createIRI(npUriString);
        this.assertionIri = vf.createIRI(npUriString + "assertion");
        if (this.creators.isEmpty()) {
            this.creators.add(npUriString + "creator");
        }
        this.npCreator = new NanopubCreator(this.nanopubIri);
        this.npCreator.setAssertionUri(this.assertionIri);
        this.npCreator.addDefaultNamespaces();
        for (Pair<String, String> p : this.namespaces) {
            this.npCreator.addNamespace(p.getLeft(), p.getRight());
        }
        if (this.derivedFromUri != null) {
            this.npCreator.addProvenanceStatement(vf.createIRI("http://www.w3.org/ns/prov#wasDerivedFrom"), this.derivedFromUri);
        } else {
            for (String c : this.creators) {
                this.npCreator.addProvenanceStatement(vf.createIRI("http://www.w3.org/ns/prov#hadPrimarySource"), vf.createIRI(c));
            }
        }
        for (String c : this.creators) {
            this.npCreator.addCreator(vf.createIRI(c));
        }
    }

    private void finalizeNanopub() {
        this.npCreator.addTimestampNow();
        this.npCreator.setRemoveUnusedPrefixesEnabled(true);
        try {
            Nanopub np = this.npCreator.finalizeNanopub();
            NanopubUtils.writeToStream(np, this.outputStream, this.rdfOutFormat);
        }
        catch (MalformedNanopubException ex) {
            throw new RuntimeException(ex);
        }
        this.npCreator = null;
    }
}

