/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.op.fingerprint.DefaultFingerprints;
import org.nanopub.op.fingerprint.FingerprintHandler;

public class Fingerprint {
    @Parameter(description="input-nanopubs")
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"--ignore-head"}, description="Ignore the head graph for fingerprint calculation")
    private boolean ignoreHead;
    @Parameter(names={"--ignore-prov"}, description="Ignore the provenance graph for fingerprint calculation")
    private boolean ignoreProv;
    @Parameter(names={"--ignore-pubinfo"}, description="Ignore the publication info graph for fingerprint calculation")
    private boolean ignorePubinfo;
    @Parameter(names={"-h"}, description="Fingerprint handler class")
    private String handlerClass;
    private RDFFormat rdfInFormat;
    private OutputStream outputStream = System.out;
    private BufferedWriter writer;
    private FingerprintHandler fingerprintHandler;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Fingerprint obj = new Fingerprint();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        obj.init();
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Fingerprint getInstance(String args) throws ParameterException {
        NanopubImpl.ensureLoaded();
        if (args == null) {
            args = "";
        }
        Fingerprint obj = new Fingerprint();
        JCommander jc = new JCommander(obj);
        jc.parse(args.trim().split(" "));
        obj.init();
        return obj;
    }

    private void init() {
        if (this.handlerClass != null && !this.handlerClass.isEmpty()) {
            String detectorClassName = this.handlerClass;
            if (!this.handlerClass.contains(".")) {
                detectorClassName = "org.nanopub.op.fingerprint." + this.handlerClass;
            }
            try {
                this.fingerprintHandler = (FingerprintHandler)Class.forName(detectorClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.fingerprintHandler = new DefaultFingerprints(this.ignoreHead, this.ignoreProv, this.ignorePubinfo);
        }
    }

    public void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.inputNanopubs == null || this.inputNanopubs.isEmpty()) {
            throw new ParameterException("No input files given");
        }
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile != null) {
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Fingerprint.this.writer.write(np.getUri() + " " + Fingerprint.this.getFingerprint(np) + "\n");
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.writer.flush();
            if (this.outputStream == System.out) continue;
            this.writer.close();
        }
    }

    public String getFingerprint(Nanopub np) throws RDFHandlerException, IOException {
        return this.fingerprintHandler.getFingerprint(np);
    }
}

