/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op.topic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.nanopub.Nanopub;
import org.nanopub.op.Topic;

public class DefaultTopics
implements Topic.TopicHandler {
    private Map<String, Boolean> ignore = new HashMap<String, Boolean>();

    public DefaultTopics(String ignoreProperties) {
        if (ignoreProperties != null) {
            for (String s : ignoreProperties.trim().split("\\|")) {
                if (s.isEmpty()) continue;
                this.ignore.put(s, true);
            }
        }
    }

    @Override
    public String getTopic(Nanopub np) {
        HashMap<Resource, Integer> resourceCount = new HashMap<Resource, Integer>();
        for (Statement st : np.getAssertion()) {
            Resource subj = st.getSubject();
            if (subj.equals(np.getUri()) || this.ignore.containsKey(st.getPredicate().stringValue())) continue;
            if (!resourceCount.containsKey(subj)) {
                resourceCount.put(subj, 0);
            }
            resourceCount.put(subj, (Integer)resourceCount.get(subj) + 1);
        }
        int max = 0;
        Resource topic = null;
        for (Resource r : resourceCount.keySet()) {
            int c = (Integer)resourceCount.get(r);
            if (c > max) {
                topic = r;
                max = c;
                continue;
            }
            if (c != max) continue;
            topic = null;
        }
        return topic + "";
    }
}

