from typing import Callable, Dict

import data_factory_testing_framework._functions.functions_collection_implementation as collection_functions
import data_factory_testing_framework._functions.functions_conversion_implementation as conversion_functions
import data_factory_testing_framework._functions.functions_date_implementation as date_functions
import data_factory_testing_framework._functions.functions_logical_implementation as logical_functions
import data_factory_testing_framework._functions.functions_math_implementation as math_functions
import data_factory_testing_framework._functions.functions_string_implementation as string_functions


class FunctionsRepository:
    _functions: Dict[str, Callable] = {
        "add": math_functions.add,
        "addDays": date_functions.add_days,
        "addHours": date_functions.add_hours,
        "addMinutes": date_functions.add_minutes,
        "addSeconds": date_functions.add_seconds,
        "addToTime": date_functions.add_to_time,
        "array": conversion_functions.array,
        "base64": conversion_functions.base64,
        "base64ToBinary": conversion_functions.base64_to_binary,
        "base64ToString": conversion_functions.base64_to_string,
        "binary": conversion_functions.binary,
        "bool": conversion_functions.bool_,
        "coalesce": conversion_functions.coalesce,
        "concat": string_functions.concat,
        "contains": collection_functions.contains,
        "convertFromUtc": date_functions.convert_from_utc,
        "convertTimeZone": date_functions.convert_time_zone,
        "convertToUtc": date_functions.convert_to_utc,
        "createArray": conversion_functions.create_array,
        "dataUri": conversion_functions.data_uri,
        "dataUriToBinary": conversion_functions.data_uri_to_binary,
        "dataUriToString": conversion_functions.data_uri_to_string,
        "dayOfMonth": date_functions.day_of_month,
        "dayOfWeek": date_functions.day_of_week,
        "dayOfYear": date_functions.day_of_year,
        "decodeBase64": conversion_functions.decode_base64,
        "decodeDataUri": conversion_functions.decode_data_uri,
        "decodeUriComponent": conversion_functions.decode_uri_component,
        "div": math_functions.div,
        "encodeUriComponent": conversion_functions.encode_uri_component,
        "empty": collection_functions.empty,
        "endsWith": string_functions.ends_with,
        "equals": logical_functions.equals,
        "first": collection_functions.first,
        "float": conversion_functions.float_,
        "formatDateTime": date_functions.format_date_time,
        "getFutureTime": date_functions.get_future_time,
        "getPastTime": date_functions.get_past_time,
        "greater": logical_functions.greater,
        "greaterOrEquals": logical_functions.greater_or_equals,
        "guid": string_functions.guid,
        "indexOf": string_functions.index_of,
        "int": conversion_functions.int_,
        "json": conversion_functions.json,
        "intersection": collection_functions.intersection,
        "join": collection_functions.join,
        "last": collection_functions.last,
        "lastIndexOf": string_functions.last_index_of,
        "length": collection_functions.length,
        "less": logical_functions.less,
        "lessOrEquals": logical_functions.less_or_equals,
        "max": math_functions.max_,
        "min": math_functions.min_,
        "mod": math_functions.mod,
        "mul": math_functions.mul,
        "not": logical_functions.not_,
        "rand": math_functions.rand,
        "range": math_functions.range_,
        "replace": string_functions.replace,
        "skip": collection_functions.skip,
        "split": string_functions.split,
        "startOfDay": date_functions.start_of_day,
        "startOfHour": date_functions.start_of_hour,
        "startOfMonth": date_functions.start_of_month,
        "startsWith": string_functions.starts_with,
        "string": conversion_functions.string,
        "sub": math_functions.sub,
        "substring": string_functions.substring,
        "subtractFromTime": date_functions.subtract_from_time,
        "take": collection_functions.take,
        "ticks": date_functions.ticks,
        "toLower": string_functions.to_lower,
        "toUpper": string_functions.to_upper,
        "trim": string_functions.trim,
        "union": collection_functions.union,
        "uriComponent": conversion_functions.uri_component,
        "uriComponentToBinary": conversion_functions.uri_component_to_binary,
        "uriComponentToString": conversion_functions.uri_component_to_string,
        "utcNow": date_functions.utcnow,
        "utcnow": date_functions.utcnow,
        "xml": conversion_functions.xml,
        "xpath": conversion_functions.xpath,
    }

    @staticmethod
    def register(function_name: str, function: Callable) -> None:
        FunctionsRepository._functions[function_name] = function
