"""
    some constants for YouTube
"""

CHANNEL_RESOURCE_PROPERTIES = {
    'id', 'brandingSettings', 'contentDetails', 'localizations', 'snippet',
    'statistics', 'status', 'topicDetails'
}

PLAYLIST_RESOURCE_PROPERTIES = {
    'id', 'contentDetails', 'localizations',
    'snippet', 'status'
}

PLAYLIST_ITEM_RESOURCE_PROPERTIES = {
    'id', 'contentDetails', 'snippet', 'status'
}

VIDEO_RESOURCE_PROPERTIES = {
    'id', 'contentDetails', 'snippet', 'statistics', 'status',
    'topicDetails',
}

COMMENT_THREAD_RESOURCE_PROPERTIES = {
    'id', 'replies', 'snippet'
}

COMMENT_RESOURCE_PROPERTIES = {
    'id', 'snippet'
}

VIDEO_CATEGORY_RESOURCE_PROPERTIES = {
    'id', 'snippet'
}

GUIDE_CATEGORY_RESOURCE_PROPERTIES = {
    'id', 'snippet'
}

RESOURCE_PARTS_MAPPING = {
    'channels': CHANNEL_RESOURCE_PROPERTIES,
    'playlists': PLAYLIST_RESOURCE_PROPERTIES,
    'playlistItems': PLAYLIST_ITEM_RESOURCE_PROPERTIES,
    'videos': VIDEO_RESOURCE_PROPERTIES,
    'commentTreads': COMMENT_THREAD_RESOURCE_PROPERTIES,
    'comments': COMMENT_RESOURCE_PROPERTIES,
    'videoCategories': VIDEO_CATEGORY_RESOURCE_PROPERTIES,
    'guideCategories': GUIDE_CATEGORY_RESOURCE_PROPERTIES
}

CHANNEL_TOPICS = {
    # Music topics
    '/m/04rlf': 'Music (parent topic)',
    '/m/02mscn': 'Christian music',
    '/m/0ggq0m': 'Classical music',
    '/m/01lyv': 'Country',
    '/m/02lkt': 'Electronic music',
    '/m/0glt670': 'Hip hop music',
    '/m/05rwpb': 'Independent music',
    '/m/03_d0': 'Jazz',
    '/m/028sqc': 'Music of Asia',
    '/m/0g293': 'Music of Latin America',
    '/m/064t9': 'Pop music',
    '/m/06cqb': 'Reggae',
    '/m/06j6l': 'Rhythm and blues',
    '/m/06by7': 'Rock music',
    '/m/0gywn': 'Soul music',
    # Gaming topics
    '/m/0bzvm2': 'Gaming (parent topic)',
    '/m/025zzc': 'Action game',
    '/m/02ntfj': 'Action-adventure game',
    '/m/0b1vjn': 'Casual game',
    '/m/02hygl': 'Music video game',
    '/m/04q1x3q': 'Puzzle video game',
    '/m/01sjng': 'Racing video game',
    '/m/0403l3g': 'Role-playing video game',
    '/m/021bp2': 'Simulation video game',
    '/m/022dc6': 'Sports game',
    '/m/03hf_rm': 'Strategy video game',
    # Sports topics
    '/m/06ntj': 'Sports (parent topic)',
    '/m/0jm_': 'American football',
    '/m/018jz': 'Baseball',
    '/m/018w8': 'Basketball',
    '/m/01cgz': 'Boxing',
    '/m/09xp_': 'Cricket',
    '/m/02vx4': 'Football',
    '/m/037hz': 'Golf',
    '/m/03tmr': 'Ice hockey',
    '/m/01h7lh': 'Mixed martial arts',
    '/m/0410tth': 'Motorsport',
    '/m/07bs0': 'Tennis',
    '/m/07_53': 'Volleyball',
    # Entertainment topics
    '/m/02jjt': 'Entertainment (parent topic)',
    '/m/09kqc': 'Humor',
    '/m/02vxn': 'Movies',
    '/m/05qjc': 'Performing arts',
    '/m/066wd': 'Professional wrestling',
    '/m/0f2f9': 'TV shows',
    # Lifestyle topics
    '/m/019_rr': 'Lifestyle (parent topic)',
    '/m/032tl': 'Fashion',
    '/m/027x7n': 'Fitness',
    '/m/02wbm': 'Food',
    '/m/03glg': 'Hobby',
    '/m/068hy': 'Pets',
    '/m/041xxh': 'Physical attractiveness [Beauty]',
    '/m/07c1v': 'Technology',
    '/m/07bxq': 'Tourism',
    '/m/07yv9': 'Vehicles',
    # Society topics
    '/m/098wr': 'Society (parent topic)',
    '/m/09s1f': 'Business',
    '/m/0kt51': 'Health',
    '/m/01h6rj': 'Military',
    '/m/05qt0': 'Politics',
    '/m/06bvp': 'Religion',
    # Other topics
    '/m/01k8wb': 'Knowledge'
}
