# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_core.ipynb (unless otherwise specified).

__all__ = ['RXNFingerprintContainer', 'FingerprintGenerator']

# Cell
from abc import ABC, abstractmethod
from typing import List


# Cell
class RXNFingerprintContainer(ABC):
    """
    Base class for RXN fingerprint containers
    - Should facilitate the creation of a LSHForest.
    - Query nearest neighbors
    """

    @abstractmethod
    def add_fingerprints(self, fingerprints: List, aux_info: List):
        """
        Add fingerprints to the container
        """

    @abstractmethod
    def save(self, save_path: str):
        """
        Convert batch of rxn_smiles to fingerprints
        """

    @abstractmethod
    def load(self, load_path: str):
        """
        Convert batch of rxn_smiles to fingerprints
        """

    @abstractmethod
    def query_nearest_neighbors(self, fingerprint):
        """
        Convert batch of rxn_smiles to fingerprints
        """


# Cell
class FingerprintGenerator(ABC):
    """
    Base class for FingerprintGenerator
    """

    @abstractmethod
    def convert(self, rxn_smiles: str) -> List[float]:
        """
        Convert rxn_smiles to fingerprint
        """

    @abstractmethod
    def convert_batch(self, rxn_smiles_batch: List[str]) -> List:
        """
        Convert batch of rxn_smiles to fingerprints
        """

