# coding: utf-8

"""
    trivium-cash

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.2.9
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from trivium_python_sdk.models.deposit_instructions import DepositInstructions
from trivium_python_sdk.models.provider_details import ProviderDetails
from typing import Optional, Set
from typing_extensions import Self

class PendingFixedDeposit(BaseModel):
    """
    PendingFixedDeposit
    """ # noqa: E501
    placement_id: StrictStr = Field(alias="placementId")
    currency_code: StrictStr = Field(alias="currencyCode")
    provider_details: ProviderDetails = Field(alias="providerDetails")
    term: StrictStr = Field(description="Serialized as P{period}, e.g. 2 weeks = P14D, 3 months = P3M, 1 year = P1Y")
    deposit_instructions: DepositInstructions = Field(alias="depositInstructions")
    type: StrictStr
    __properties: ClassVar[List[str]] = ["placementId", "currencyCode", "providerDetails", "term", "depositInstructions", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PendingFixedDeposit']):
            raise ValueError("must be one of enum values ('PendingFixedDeposit')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PendingFixedDeposit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider_details
        if self.provider_details:
            _dict['providerDetails'] = self.provider_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deposit_instructions
        if self.deposit_instructions:
            _dict['depositInstructions'] = self.deposit_instructions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PendingFixedDeposit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "placementId": obj.get("placementId"),
            "currencyCode": obj.get("currencyCode"),
            "providerDetails": ProviderDetails.from_dict(obj["providerDetails"]) if obj.get("providerDetails") is not None else None,
            "term": obj.get("term"),
            "depositInstructions": DepositInstructions.from_dict(obj["depositInstructions"]) if obj.get("depositInstructions") is not None else None,
            "type": obj.get("type")
        })
        return _obj


