#
# Copyright (C) 2021-2022 by TeamYukki@Github, < https://github.com/TeamYukki >.
#
# This file is part of < https://github.com/TeamYukki/YukkiMusicBot > project,
# and is released under the "GNU v3.0 License Agreement".
# Please see < https://github.com/TeamYukki/YukkiMusicBot/blob/master/LICENSE >
#
# All rights reserved.

import asyncio
import os
import time
from datetime import datetime, timedelta
from typing import Union

import fipper
from fipper.types import (
    InlineKeyboardButton,
    InlineKeyboardMarkup,
    Message,
    Voice
)


class TeleAPI:
    chars_limit = 4096
    downloader = {}

    async def send_split_text_telegram(self: 'fipper.Client', message, string):
        n = self.chars_limit
        out = [(string[i : i + n]) for i in range(0, len(string), n)]
        j = 0
        for x in out:
            if j <= 2:
                j += 1
                await message.reply_text(x)
        return True

    async def get_link_telegram(self: 'fipper.Client', message: Message):
        if message.chat.username:
            link = f"https://t.me/{message.chat.username}/{message.reply_to_message.id}"
        else:
            xf = str((message.chat.id))[4:]
            link = f"https://t.me/c/{xf}/{message.reply_to_message.id}"
        return link

    async def get_filename_telegram(
        self: 'fipper.Client', file, audio: Union[bool, str] = None
    ):
        try:
            file_name = file.file_name
            if file_name is None:
                file_name = (
                    "Telegram Audio File"
                    if audio
                    else "Telegram Video File"
                )

        except:
            file_name = (
                "Telegram Audio File"
                if audio
                else "Telegram Video File"
            )
        return file_name

    async def get_duration_telegram(self: 'fipper.Client', file):
        try:
            dur = self.seconds_to_min(file.duration)
        except:
            dur = "Unknown"
        return dur

    async def get_filepath_telegram(
        self: 'fipper.Client',
        audio: Union[bool, str] = None,
        video: Union[bool, str] = None,
    ):
        if audio:
            try:
                file_name = (
                    audio.file_unique_id
                    + "."
                    + (
                        (audio.file_name.split(".")[-1])
                        if (not isinstance(audio, Voice))
                        else "ogg"
                    )
                )
            except:
                file_name = audio.file_unique_id + "." + ".ogg"
            file_name = os.path.join(
                os.path.realpath("downloads"), file_name
            )
        if video:
            try:
                file_name = (
                    video.file_unique_id
                    + "."
                    + (video.file_name.split(".")[-1])
                )
            except:
                file_name = video.file_unique_id + "." + "mp4"
            file_name = os.path.join(
                os.path.realpath("downloads"), file_name
            )
        return file_name

    async def download_telegram(
        self: 'fipper.Client',
        message: Message,
        mystic,
        fname
    ):
        left_time = {}
        speed_counter = {}
        if os.path.exists(fname):
            return True

        async def down_load():
            async def progress(current, total):
                if current == total:
                    return
                current_time = time.time()
                start_time = speed_counter.get(message.id)
                check_time = current_time - start_time
                upl = InlineKeyboardMarkup(
                    [
                        [
                            InlineKeyboardButton(
                                text="🚦 Cancel Downloading",
                                callback_data="stop_downloading",
                            ),
                        ]
                    ]
                )
                if datetime.now() > left_time.get(message.id):
                    percentage = current * 100 / total
                    percentage = str(round(percentage, 2))
                    speed = current / check_time
                    eta = int((total - current) / speed)
                    self.downloader[message.id] = eta
                    eta = self.get_readable_time(eta)
                    if not eta:
                        eta = "0 sec"
                    total_size = self.convert_bytes(total)
                    completed_size = self.convert_bytes(current)
                    speed = self.convert_bytes(speed)
                    text = f"""
**{self.me.first_name.upper()} Telegram Media Downloader**

**Total FileSize:** {total_size}
**Completed:** {completed_size} 
**Percentage:** {percentage[:5]}%

**Speed:** {speed}/s
**ETA:** {eta}"""
                    try:
                        await mystic.edit_text(text, reply_markup=upl)
                    except:
                        pass
                    left_time[
                        message.id
                    ] = datetime.now() + timedelta(seconds=3)

            speed_counter[message.id] = time.time()
            left_time[message.id] = datetime.now()

            try:
                await self.download_media(
                    message.reply_to_message,
                    file_name=fname,
                    progress=progress,
                )
                await mystic.edit_text(
                    "Successfully Downloaded.. Processing file now"
                )
                self.downloader.pop(message.id)
            except:
                await mystic.edit_text("Gagal mengunduh media dari telegram.")

        if len(self.downloader) > 10:
            timers = []
            for x in self.downloader:
                timers.append(self.downloader[x])
            try:
                low = min(timers)
                eta = self.get_readable_time(low)
            except:
                eta = "Unknown"
            await mystic.edit_text(f"Bot **kelebihan beban** dengan unduhan sekarang.\n\n**Coba Setelah:** {eta} (__waktu yang diharapkan__)")
            return False

        task = asyncio.create_task(down_load())
        self.lyrical[mystic.id] = task
        await task
        downloaded = self.downloader.get(message.id)
        if downloaded:
            self.downloader.pop(message.id)
            return False
        verify = self.lyrical.get(mystic.id)
        if not verify:
            return False
        self.lyrical.pop(mystic.id)
        return True
