/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.tools.util;

import com.datapps.linkoopdb.jdbc.tools.FieldMeta;
import java.util.ArrayList;
import java.util.List;

public class TableUtil {
    public static String queryColumnTypeSql(String schema, String table) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COLUMN_NAME,CHAR_OCTET_LENGTH, TYPE_NAME, COLUMN_SIZE, DECIMAL_DIGITS,IS_NULLABLE,COLUMN_DEF");
        stringBuilder.append(" FROM INFORMATION_SCHEMA.SYSTEM_COLUMNS ");
        stringBuilder.append(" WHERE TABLE_SCHEM='");
        stringBuilder.append(schema);
        stringBuilder.append("' AND TABLE_NAME='");
        stringBuilder.append(table);
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public static String queryTablePrimaryKey(String schema, String table) {
        String sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS WHERE TABLE_SCHEM = '" + schema + "' AND TABLE_NAME='" + table + "'";
        return sql;
    }

    public static String createExternalTableSql(String columnSql, String filePath, boolean isSkipCsvHeader, String delimiter) {
        StringBuilder externalTableSql = new StringBuilder();
        externalTableSql.append("CREATE EXTERNAL TABLE").append(" ").append(columnSql).append(" ").append("LOCATION").append(" ").append("(").append("'").append(filePath).append("'").append(")").append(" ").append("FORMAT").append(" ").append("'").append("csv").append("'").append(" ").append("(").append("DELIMITER").append(" ").append("'").append(delimiter).append("'").append(" header '").append(isSkipCsvHeader).append("'").append(")").append(";");
        return externalTableSql.toString();
    }

    public static String createExternalTableForLocation(String externalTableDefine, String filePath, boolean isSkipCsvHeader, String delimiter, char escape, char quote) {
        StringBuilder externalTableSql = new StringBuilder();
        externalTableSql.append(externalTableDefine).append("LOCATION").append(" ").append("(").append("'").append(filePath).append("'").append(")").append(" ").append("FORMAT").append(" ").append("'").append("csv").append("'").append(" ").append("(").append("DELIMITER").append(" ").append("'").append(delimiter).append("'").append(" ESCAPE ").append("'" + escape + "'").append(" QUOTE ").append("'" + quote + "'").append(" header '").append(isSkipCsvHeader).append("'").append(")").append(";");
        return externalTableSql.toString();
    }

    public static String createTableFiledSql(String schema, String tableName, String exTableName, List<FieldMeta> fieldMetaList, List<String> primaryList) {
        StringBuilder sql = new StringBuilder();
        StringBuilder createSql = new StringBuilder();
        createSql.append(schema).append(".").append(exTableName).append("(");
        ArrayList<String> columnList = new ArrayList<String>();
        if (fieldMetaList == null || fieldMetaList.size() == 0) {
            return null;
        }
        for (FieldMeta fieldMeta : fieldMetaList) {
            StringBuilder columnSql = new StringBuilder();
            String columnName = fieldMeta.getColumnName();
            String columnType = fieldMeta.getDataType();
            columnSql.append(columnName).append(" ").append(columnType);
            if (fieldMeta.getLength() != null && fieldMeta.getLength() > 0) {
                columnSql.append(" (").append(fieldMeta.getLength()).append(")");
            }
            if (fieldMeta.getPrecision() != null && fieldMeta.getScale() != null) {
                columnSql.append("(").append(fieldMeta.getPrecision()).append(",").append(fieldMeta.getScale()).append(")");
            } else if (fieldMeta.getPrecision() != null) {
                columnSql.append("(").append(fieldMeta.getPrecision()).append(") ");
            }
            columnList.add(columnSql.toString());
        }
        createSql.append(TableUtil.joinStr(columnList, ","));
        StringBuilder primarySql = new StringBuilder();
        if (primaryList != null && primaryList.size() > 0) {
            primarySql.append(" PRIMARY KEY ").append("(");
            primarySql.append(TableUtil.joinStr(primaryList, ","));
            createSql.append(",").append((CharSequence)primarySql).append(")");
        }
        createSql.append(")");
        return createSql.toString();
    }

    private static String joinStr(List<String> strList, String separator) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int max = strList.size();
        for (String item : strList) {
            if (++i < max) {
                builder.append(item);
                builder.append(separator);
                continue;
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String dropTableSql(String schema, String table) {
        StringBuilder droptableSql = new StringBuilder();
        droptableSql.append("drop table").append(" ").append(schema).append(".").append(table);
        return droptableSql.toString();
    }
}

