var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// dist/web-ifc-mt.js
var require_web_ifc_mt = __commonJS({
  "dist/web-ifc-mt.js"(exports, module2) {
    var WebIFCWasm2 = (() => {
      var _scriptDir = typeof document !== "undefined" && document.currentScript ? document.currentScript.src : void 0;
      return function(moduleArg = {}) {
        function GROWABLE_HEAP_I8() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAP8;
        }
        function GROWABLE_HEAP_U8() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAPU8;
        }
        function GROWABLE_HEAP_I16() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAP16;
        }
        function GROWABLE_HEAP_U16() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAPU16;
        }
        function GROWABLE_HEAP_I32() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAP32;
        }
        function GROWABLE_HEAP_U32() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAPU32;
        }
        function GROWABLE_HEAP_F32() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAPF32;
        }
        function GROWABLE_HEAP_F64() {
          if (wasmMemory.buffer != HEAP8.buffer) {
            updateMemoryViews();
          }
          return HEAPF64;
        }
        var Module = moduleArg;
        var readyPromiseResolve, readyPromiseReject;
        Module["ready"] = new Promise((resolve, reject) => {
          readyPromiseResolve = resolve;
          readyPromiseReject = reject;
        });
        var moduleOverrides = Object.assign({}, Module);
        var arguments_ = [];
        var thisProgram = "./this.program";
        var quit_ = (status, toThrow) => {
          throw toThrow;
        };
        var ENVIRONMENT_IS_WEB = typeof window == "object";
        var ENVIRONMENT_IS_WORKER = typeof importScripts == "function";
        var ENVIRONMENT_IS_NODE = typeof process == "object" && typeof process.versions == "object" && typeof process.versions.node == "string";
        var ENVIRONMENT_IS_PTHREAD = Module["ENVIRONMENT_IS_PTHREAD"] || false;
        var scriptDirectory = "";
        function locateFile(path) {
          if (Module["locateFile"]) {
            return Module["locateFile"](path, scriptDirectory);
          }
          return scriptDirectory + path;
        }
        var read_, readAsync, readBinary, setWindowTitle;
        if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
          if (ENVIRONMENT_IS_WORKER) {
            scriptDirectory = self.location.href;
          } else if (typeof document != "undefined" && document.currentScript) {
            scriptDirectory = document.currentScript.src;
          }
          if (_scriptDir) {
            scriptDirectory = _scriptDir;
          }
          if (scriptDirectory.indexOf("blob:") !== 0) {
            scriptDirectory = scriptDirectory.substr(0, scriptDirectory.replace(/[?#].*/, "").lastIndexOf("/") + 1);
          } else {
            scriptDirectory = "";
          }
          {
            read_ = (url) => {
              var xhr = new XMLHttpRequest();
              xhr.open("GET", url, false);
              xhr.send(null);
              return xhr.responseText;
            };
            if (ENVIRONMENT_IS_WORKER) {
              readBinary = (url) => {
                var xhr = new XMLHttpRequest();
                xhr.open("GET", url, false);
                xhr.responseType = "arraybuffer";
                xhr.send(null);
                return new Uint8Array(xhr.response);
              };
            }
            readAsync = (url, onload, onerror) => {
              var xhr = new XMLHttpRequest();
              xhr.open("GET", url, true);
              xhr.responseType = "arraybuffer";
              xhr.onload = () => {
                if (xhr.status == 200 || xhr.status == 0 && xhr.response) {
                  onload(xhr.response);
                  return;
                }
                onerror();
              };
              xhr.onerror = onerror;
              xhr.send(null);
            };
          }
          setWindowTitle = (title) => document.title = title;
        } else {
        }
        var out = Module["print"] || console.log.bind(console);
        var err = Module["printErr"] || console.error.bind(console);
        Object.assign(Module, moduleOverrides);
        moduleOverrides = null;
        if (Module["arguments"])
          arguments_ = Module["arguments"];
        if (Module["thisProgram"])
          thisProgram = Module["thisProgram"];
        if (Module["quit"])
          quit_ = Module["quit"];
        var wasmBinary;
        if (Module["wasmBinary"])
          wasmBinary = Module["wasmBinary"];
        var noExitRuntime = Module["noExitRuntime"] || true;
        if (typeof WebAssembly != "object") {
          abort("no native wasm support detected");
        }
        var wasmMemory;
        var wasmExports;
        var wasmModule;
        var ABORT = false;
        var EXITSTATUS;
        function assert(condition, text) {
          if (!condition) {
            abort(text);
          }
        }
        var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
        function updateMemoryViews() {
          var b = wasmMemory.buffer;
          Module["HEAP8"] = HEAP8 = new Int8Array(b);
          Module["HEAP16"] = HEAP16 = new Int16Array(b);
          Module["HEAP32"] = HEAP32 = new Int32Array(b);
          Module["HEAPU8"] = HEAPU8 = new Uint8Array(b);
          Module["HEAPU16"] = HEAPU16 = new Uint16Array(b);
          Module["HEAPU32"] = HEAPU32 = new Uint32Array(b);
          Module["HEAPF32"] = HEAPF32 = new Float32Array(b);
          Module["HEAPF64"] = HEAPF64 = new Float64Array(b);
        }
        var INITIAL_MEMORY = Module["INITIAL_MEMORY"] || 16777216;
        assert(INITIAL_MEMORY >= 5242880, "INITIAL_MEMORY should be larger than STACK_SIZE, was " + INITIAL_MEMORY + "! (STACK_SIZE=" + 5242880 + ")");
        if (ENVIRONMENT_IS_PTHREAD) {
          wasmMemory = Module["wasmMemory"];
        } else {
          if (Module["wasmMemory"]) {
            wasmMemory = Module["wasmMemory"];
          } else {
            wasmMemory = new WebAssembly.Memory({ "initial": INITIAL_MEMORY / 65536, "maximum": 4294967296 / 65536, "shared": true });
            if (!(wasmMemory.buffer instanceof SharedArrayBuffer)) {
              err("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag");
              if (ENVIRONMENT_IS_NODE) {
                err("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and/or recent version)");
              }
              throw Error("bad memory");
            }
          }
        }
        updateMemoryViews();
        INITIAL_MEMORY = wasmMemory.buffer.byteLength;
        var wasmTable;
        var __ATPRERUN__ = [];
        var __ATINIT__ = [];
        var __ATPOSTRUN__ = [];
        var runtimeInitialized = false;
        var runtimeKeepaliveCounter = 0;
        function keepRuntimeAlive() {
          return noExitRuntime || runtimeKeepaliveCounter > 0;
        }
        function preRun() {
          if (Module["preRun"]) {
            if (typeof Module["preRun"] == "function")
              Module["preRun"] = [Module["preRun"]];
            while (Module["preRun"].length) {
              addOnPreRun(Module["preRun"].shift());
            }
          }
          callRuntimeCallbacks(__ATPRERUN__);
        }
        function initRuntime() {
          runtimeInitialized = true;
          if (ENVIRONMENT_IS_PTHREAD)
            return;
          if (!Module["noFSInit"] && !FS.init.initialized)
            FS.init();
          FS.ignorePermissions = false;
          TTY.init();
          callRuntimeCallbacks(__ATINIT__);
        }
        function postRun() {
          if (ENVIRONMENT_IS_PTHREAD)
            return;
          if (Module["postRun"]) {
            if (typeof Module["postRun"] == "function")
              Module["postRun"] = [Module["postRun"]];
            while (Module["postRun"].length) {
              addOnPostRun(Module["postRun"].shift());
            }
          }
          callRuntimeCallbacks(__ATPOSTRUN__);
        }
        function addOnPreRun(cb) {
          __ATPRERUN__.unshift(cb);
        }
        function addOnInit(cb) {
          __ATINIT__.unshift(cb);
        }
        function addOnPostRun(cb) {
          __ATPOSTRUN__.unshift(cb);
        }
        var runDependencies = 0;
        var runDependencyWatcher = null;
        var dependenciesFulfilled = null;
        function getUniqueRunDependency(id) {
          return id;
        }
        function addRunDependency(id) {
          runDependencies++;
          if (Module["monitorRunDependencies"]) {
            Module["monitorRunDependencies"](runDependencies);
          }
        }
        function removeRunDependency(id) {
          runDependencies--;
          if (Module["monitorRunDependencies"]) {
            Module["monitorRunDependencies"](runDependencies);
          }
          if (runDependencies == 0) {
            if (runDependencyWatcher !== null) {
              clearInterval(runDependencyWatcher);
              runDependencyWatcher = null;
            }
            if (dependenciesFulfilled) {
              var callback = dependenciesFulfilled;
              dependenciesFulfilled = null;
              callback();
            }
          }
        }
        function abort(what) {
          if (Module["onAbort"]) {
            Module["onAbort"](what);
          }
          what = "Aborted(" + what + ")";
          err(what);
          ABORT = true;
          EXITSTATUS = 1;
          what += ". Build with -sASSERTIONS for more info.";
          var e = new WebAssembly.RuntimeError(what);
          readyPromiseReject(e);
          throw e;
        }
        var dataURIPrefix = "data:application/octet-stream;base64,";
        function isDataURI(filename) {
          return filename.startsWith(dataURIPrefix);
        }
        var wasmBinaryFile;
        wasmBinaryFile = "web-ifc-mt.wasm";
        if (!isDataURI(wasmBinaryFile)) {
          wasmBinaryFile = locateFile(wasmBinaryFile);
        }
        function getBinarySync(file) {
          if (file == wasmBinaryFile && wasmBinary) {
            return new Uint8Array(wasmBinary);
          }
          if (readBinary) {
            return readBinary(file);
          }
          throw "both async and sync fetching of the wasm failed";
        }
        function getBinaryPromise(binaryFile) {
          if (!wasmBinary && (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER)) {
            if (typeof fetch == "function") {
              return fetch(binaryFile, { credentials: "same-origin" }).then((response) => {
                if (!response["ok"]) {
                  throw "failed to load wasm binary file at '" + binaryFile + "'";
                }
                return response["arrayBuffer"]();
              }).catch(() => getBinarySync(binaryFile));
            }
          }
          return Promise.resolve().then(() => getBinarySync(binaryFile));
        }
        function instantiateArrayBuffer(binaryFile, imports, receiver) {
          return getBinaryPromise(binaryFile).then((binary) => WebAssembly.instantiate(binary, imports)).then((instance) => instance).then(receiver, (reason) => {
            err("failed to asynchronously prepare wasm: " + reason);
            abort(reason);
          });
        }
        function instantiateAsync(binary, binaryFile, imports, callback) {
          if (!binary && typeof WebAssembly.instantiateStreaming == "function" && !isDataURI(binaryFile) && typeof fetch == "function") {
            return fetch(binaryFile, { credentials: "same-origin" }).then((response) => {
              var result = WebAssembly.instantiateStreaming(response, imports);
              return result.then(callback, function(reason) {
                err("wasm streaming compile failed: " + reason);
                err("falling back to ArrayBuffer instantiation");
                return instantiateArrayBuffer(binaryFile, imports, callback);
              });
            });
          }
          return instantiateArrayBuffer(binaryFile, imports, callback);
        }
        function createWasm() {
          var info = { "a": wasmImports };
          function receiveInstance(instance, module3) {
            var exports2 = instance.exports;
            exports2 = applySignatureConversions(exports2);
            wasmExports = exports2;
            registerTLSInit(wasmExports["ma"]);
            wasmTable = wasmExports["ja"];
            addOnInit(wasmExports["ia"]);
            wasmModule = module3;
            removeRunDependency("wasm-instantiate");
            return exports2;
          }
          addRunDependency("wasm-instantiate");
          function receiveInstantiationResult(result) {
            receiveInstance(result["instance"], result["module"]);
          }
          if (Module["instantiateWasm"]) {
            try {
              return Module["instantiateWasm"](info, receiveInstance);
            } catch (e) {
              err("Module.instantiateWasm callback failed with error: " + e);
              readyPromiseReject(e);
            }
          }
          instantiateAsync(wasmBinary, wasmBinaryFile, info, receiveInstantiationResult).catch(readyPromiseReject);
          return {};
        }
        var tempDouble;
        var tempI64;
        function ExitStatus(status) {
          this.name = "ExitStatus";
          this.message = `Program terminated with exit(${status})`;
          this.status = status;
        }
        var terminateWorker = function(worker) {
          worker.terminate();
          worker.onmessage = (e) => {
          };
        };
        function killThread(pthread_ptr) {
          var worker = PThread.pthreads[pthread_ptr];
          delete PThread.pthreads[pthread_ptr];
          terminateWorker(worker);
          __emscripten_thread_free_data(pthread_ptr);
          PThread.runningWorkers.splice(PThread.runningWorkers.indexOf(worker), 1);
          worker.pthread_ptr = 0;
        }
        function cancelThread(pthread_ptr) {
          var worker = PThread.pthreads[pthread_ptr];
          worker.postMessage({ "cmd": "cancel" });
        }
        function cleanupThread(pthread_ptr) {
          var worker = PThread.pthreads[pthread_ptr];
          assert(worker);
          PThread.returnWorkerToPool(worker);
        }
        function spawnThread(threadParams) {
          var worker = PThread.getNewWorker();
          if (!worker) {
            return 6;
          }
          PThread.runningWorkers.push(worker);
          PThread.pthreads[threadParams.pthread_ptr] = worker;
          worker.pthread_ptr = threadParams.pthread_ptr;
          var msg = { "cmd": "run", "start_routine": threadParams.startRoutine, "arg": threadParams.arg, "pthread_ptr": threadParams.pthread_ptr };
          worker.postMessage(msg, threadParams.transferList);
          return 0;
        }
        var PATH = { isAbs: (path) => path.charAt(0) === "/", splitPath: (filename) => {
          var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
          return splitPathRe.exec(filename).slice(1);
        }, normalizeArray: (parts, allowAboveRoot) => {
          var up = 0;
          for (var i = parts.length - 1; i >= 0; i--) {
            var last = parts[i];
            if (last === ".") {
              parts.splice(i, 1);
            } else if (last === "..") {
              parts.splice(i, 1);
              up++;
            } else if (up) {
              parts.splice(i, 1);
              up--;
            }
          }
          if (allowAboveRoot) {
            for (; up; up--) {
              parts.unshift("..");
            }
          }
          return parts;
        }, normalize: (path) => {
          var isAbsolute = PATH.isAbs(path), trailingSlash = path.substr(-1) === "/";
          path = PATH.normalizeArray(path.split("/").filter((p) => !!p), !isAbsolute).join("/");
          if (!path && !isAbsolute) {
            path = ".";
          }
          if (path && trailingSlash) {
            path += "/";
          }
          return (isAbsolute ? "/" : "") + path;
        }, dirname: (path) => {
          var result = PATH.splitPath(path), root = result[0], dir = result[1];
          if (!root && !dir) {
            return ".";
          }
          if (dir) {
            dir = dir.substr(0, dir.length - 1);
          }
          return root + dir;
        }, basename: (path) => {
          if (path === "/")
            return "/";
          path = PATH.normalize(path);
          path = path.replace(/\/$/, "");
          var lastSlash = path.lastIndexOf("/");
          if (lastSlash === -1)
            return path;
          return path.substr(lastSlash + 1);
        }, join: function() {
          var paths = Array.prototype.slice.call(arguments);
          return PATH.normalize(paths.join("/"));
        }, join2: (l, r) => PATH.normalize(l + "/" + r) };
        var initRandomFill = () => {
          if (typeof crypto == "object" && typeof crypto["getRandomValues"] == "function") {
            return (view) => (view.set(crypto.getRandomValues(new Uint8Array(view.byteLength))), view);
          } else
            abort("initRandomDevice");
        };
        var randomFill = (view) => (randomFill = initRandomFill())(view);
        var PATH_FS = { resolve: function() {
          var resolvedPath = "", resolvedAbsolute = false;
          for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
            var path = i >= 0 ? arguments[i] : FS.cwd();
            if (typeof path != "string") {
              throw new TypeError("Arguments to path.resolve must be strings");
            } else if (!path) {
              return "";
            }
            resolvedPath = path + "/" + resolvedPath;
            resolvedAbsolute = PATH.isAbs(path);
          }
          resolvedPath = PATH.normalizeArray(resolvedPath.split("/").filter((p) => !!p), !resolvedAbsolute).join("/");
          return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
        }, relative: (from, to) => {
          from = PATH_FS.resolve(from).substr(1);
          to = PATH_FS.resolve(to).substr(1);
          function trim(arr) {
            var start = 0;
            for (; start < arr.length; start++) {
              if (arr[start] !== "")
                break;
            }
            var end = arr.length - 1;
            for (; end >= 0; end--) {
              if (arr[end] !== "")
                break;
            }
            if (start > end)
              return [];
            return arr.slice(start, end - start + 1);
          }
          var fromParts = trim(from.split("/"));
          var toParts = trim(to.split("/"));
          var length = Math.min(fromParts.length, toParts.length);
          var samePartsLength = length;
          for (var i = 0; i < length; i++) {
            if (fromParts[i] !== toParts[i]) {
              samePartsLength = i;
              break;
            }
          }
          var outputParts = [];
          for (var i = samePartsLength; i < fromParts.length; i++) {
            outputParts.push("..");
          }
          outputParts = outputParts.concat(toParts.slice(samePartsLength));
          return outputParts.join("/");
        } };
        var UTF8Decoder = typeof TextDecoder != "undefined" ? new TextDecoder("utf8") : void 0;
        var UTF8ArrayToString = (heapOrArray, idx, maxBytesToRead) => {
          idx >>>= 0;
          var endIdx = idx + maxBytesToRead;
          var endPtr = idx;
          while (heapOrArray[endPtr] && !(endPtr >= endIdx))
            ++endPtr;
          if (endPtr - idx > 16 && heapOrArray.buffer && UTF8Decoder) {
            return UTF8Decoder.decode(heapOrArray.buffer instanceof SharedArrayBuffer ? heapOrArray.slice(idx, endPtr) : heapOrArray.subarray(idx, endPtr));
          }
          var str = "";
          while (idx < endPtr) {
            var u0 = heapOrArray[idx++];
            if (!(u0 & 128)) {
              str += String.fromCharCode(u0);
              continue;
            }
            var u1 = heapOrArray[idx++] & 63;
            if ((u0 & 224) == 192) {
              str += String.fromCharCode((u0 & 31) << 6 | u1);
              continue;
            }
            var u2 = heapOrArray[idx++] & 63;
            if ((u0 & 240) == 224) {
              u0 = (u0 & 15) << 12 | u1 << 6 | u2;
            } else {
              u0 = (u0 & 7) << 18 | u1 << 12 | u2 << 6 | heapOrArray[idx++] & 63;
            }
            if (u0 < 65536) {
              str += String.fromCharCode(u0);
            } else {
              var ch = u0 - 65536;
              str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
            }
          }
          return str;
        };
        var FS_stdin_getChar_buffer = [];
        var lengthBytesUTF8 = (str) => {
          var len = 0;
          for (var i = 0; i < str.length; ++i) {
            var c = str.charCodeAt(i);
            if (c <= 127) {
              len++;
            } else if (c <= 2047) {
              len += 2;
            } else if (c >= 55296 && c <= 57343) {
              len += 4;
              ++i;
            } else {
              len += 3;
            }
          }
          return len;
        };
        var stringToUTF8Array = (str, heap, outIdx, maxBytesToWrite) => {
          outIdx >>>= 0;
          if (!(maxBytesToWrite > 0))
            return 0;
          var startIdx = outIdx;
          var endIdx = outIdx + maxBytesToWrite - 1;
          for (var i = 0; i < str.length; ++i) {
            var u = str.charCodeAt(i);
            if (u >= 55296 && u <= 57343) {
              var u1 = str.charCodeAt(++i);
              u = 65536 + ((u & 1023) << 10) | u1 & 1023;
            }
            if (u <= 127) {
              if (outIdx >= endIdx)
                break;
              heap[outIdx++ >>> 0] = u;
            } else if (u <= 2047) {
              if (outIdx + 1 >= endIdx)
                break;
              heap[outIdx++ >>> 0] = 192 | u >> 6;
              heap[outIdx++ >>> 0] = 128 | u & 63;
            } else if (u <= 65535) {
              if (outIdx + 2 >= endIdx)
                break;
              heap[outIdx++ >>> 0] = 224 | u >> 12;
              heap[outIdx++ >>> 0] = 128 | u >> 6 & 63;
              heap[outIdx++ >>> 0] = 128 | u & 63;
            } else {
              if (outIdx + 3 >= endIdx)
                break;
              heap[outIdx++ >>> 0] = 240 | u >> 18;
              heap[outIdx++ >>> 0] = 128 | u >> 12 & 63;
              heap[outIdx++ >>> 0] = 128 | u >> 6 & 63;
              heap[outIdx++ >>> 0] = 128 | u & 63;
            }
          }
          heap[outIdx >>> 0] = 0;
          return outIdx - startIdx;
        };
        function intArrayFromString(stringy, dontAddNull, length) {
          var len = length > 0 ? length : lengthBytesUTF8(stringy) + 1;
          var u8array = new Array(len);
          var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
          if (dontAddNull)
            u8array.length = numBytesWritten;
          return u8array;
        }
        var FS_stdin_getChar = () => {
          if (!FS_stdin_getChar_buffer.length) {
            var result = null;
            if (typeof window != "undefined" && typeof window.prompt == "function") {
              result = window.prompt("Input: ");
              if (result !== null) {
                result += "\n";
              }
            } else if (typeof readline == "function") {
              result = readline();
              if (result !== null) {
                result += "\n";
              }
            }
            if (!result) {
              return null;
            }
            FS_stdin_getChar_buffer = intArrayFromString(result, true);
          }
          return FS_stdin_getChar_buffer.shift();
        };
        var TTY = { ttys: [], init: function() {
        }, shutdown: function() {
        }, register: function(dev, ops) {
          TTY.ttys[dev] = { input: [], output: [], ops };
          FS.registerDevice(dev, TTY.stream_ops);
        }, stream_ops: { open: function(stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(43);
          }
          stream.tty = tty;
          stream.seekable = false;
        }, close: function(stream) {
          stream.tty.ops.fsync(stream.tty);
        }, fsync: function(stream) {
          stream.tty.ops.fsync(stream.tty);
        }, read: function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(60);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(29);
            }
            if (result === void 0 && bytesRead === 0) {
              throw new FS.ErrnoError(6);
            }
            if (result === null || result === void 0)
              break;
            bytesRead++;
            buffer[offset + i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        }, write: function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(60);
          }
          try {
            for (var i = 0; i < length; i++) {
              stream.tty.ops.put_char(stream.tty, buffer[offset + i]);
            }
          } catch (e) {
            throw new FS.ErrnoError(29);
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        } }, default_tty_ops: { get_char: function(tty) {
          return FS_stdin_getChar();
        }, put_char: function(tty, val) {
          if (val === null || val === 10) {
            out(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0)
              tty.output.push(val);
          }
        }, fsync: function(tty) {
          if (tty.output && tty.output.length > 0) {
            out(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }, ioctl_tcgets: function(tty) {
          return { c_iflag: 25856, c_oflag: 5, c_cflag: 191, c_lflag: 35387, c_cc: [3, 28, 127, 21, 4, 0, 1, 0, 17, 19, 26, 0, 18, 15, 23, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] };
        }, ioctl_tcsets: function(tty, optional_actions, data) {
          return 0;
        }, ioctl_tiocgwinsz: function(tty) {
          return [24, 80];
        } }, default_tty1_ops: { put_char: function(tty, val) {
          if (val === null || val === 10) {
            err(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0)
              tty.output.push(val);
          }
        }, fsync: function(tty) {
          if (tty.output && tty.output.length > 0) {
            err(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        } } };
        var mmapAlloc = (size) => {
          abort();
        };
        var MEMFS = { ops_table: null, mount(mount) {
          return MEMFS.createNode(null, "/", 16384 | 511, 0);
        }, createNode(parent, name, mode, dev) {
          if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
            throw new FS.ErrnoError(63);
          }
          if (!MEMFS.ops_table) {
            MEMFS.ops_table = { dir: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr, lookup: MEMFS.node_ops.lookup, mknod: MEMFS.node_ops.mknod, rename: MEMFS.node_ops.rename, unlink: MEMFS.node_ops.unlink, rmdir: MEMFS.node_ops.rmdir, readdir: MEMFS.node_ops.readdir, symlink: MEMFS.node_ops.symlink }, stream: { llseek: MEMFS.stream_ops.llseek } }, file: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr }, stream: { llseek: MEMFS.stream_ops.llseek, read: MEMFS.stream_ops.read, write: MEMFS.stream_ops.write, allocate: MEMFS.stream_ops.allocate, mmap: MEMFS.stream_ops.mmap, msync: MEMFS.stream_ops.msync } }, link: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr, readlink: MEMFS.node_ops.readlink }, stream: {} }, chrdev: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr }, stream: FS.chrdev_stream_ops } };
          }
          var node = FS.createNode(parent, name, mode, dev);
          if (FS.isDir(node.mode)) {
            node.node_ops = MEMFS.ops_table.dir.node;
            node.stream_ops = MEMFS.ops_table.dir.stream;
            node.contents = {};
          } else if (FS.isFile(node.mode)) {
            node.node_ops = MEMFS.ops_table.file.node;
            node.stream_ops = MEMFS.ops_table.file.stream;
            node.usedBytes = 0;
            node.contents = null;
          } else if (FS.isLink(node.mode)) {
            node.node_ops = MEMFS.ops_table.link.node;
            node.stream_ops = MEMFS.ops_table.link.stream;
          } else if (FS.isChrdev(node.mode)) {
            node.node_ops = MEMFS.ops_table.chrdev.node;
            node.stream_ops = MEMFS.ops_table.chrdev.stream;
          }
          node.timestamp = Date.now();
          if (parent) {
            parent.contents[name] = node;
            parent.timestamp = node.timestamp;
          }
          return node;
        }, getFileDataAsTypedArray(node) {
          if (!node.contents)
            return new Uint8Array(0);
          if (node.contents.subarray)
            return node.contents.subarray(0, node.usedBytes);
          return new Uint8Array(node.contents);
        }, expandFileStorage(node, newCapacity) {
          var prevCapacity = node.contents ? node.contents.length : 0;
          if (prevCapacity >= newCapacity)
            return;
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125) >>> 0);
          if (prevCapacity != 0)
            newCapacity = Math.max(newCapacity, 256);
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity);
          if (node.usedBytes > 0)
            node.contents.set(oldContents.subarray(0, node.usedBytes), 0);
        }, resizeFileStorage(node, newSize) {
          if (node.usedBytes == newSize)
            return;
          if (newSize == 0) {
            node.contents = null;
            node.usedBytes = 0;
          } else {
            var oldContents = node.contents;
            node.contents = new Uint8Array(newSize);
            if (oldContents) {
              node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes)));
            }
            node.usedBytes = newSize;
          }
        }, node_ops: { getattr(node) {
          var attr = {};
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        }, setattr(node, attr) {
          if (attr.mode !== void 0) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== void 0) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== void 0) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        }, lookup(parent, name) {
          throw FS.genericErrors[44];
        }, mknod(parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        }, rename(old_node, new_dir, new_name) {
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(55);
              }
            }
          }
          delete old_node.parent.contents[old_node.name];
          old_node.parent.timestamp = Date.now();
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          new_dir.timestamp = old_node.parent.timestamp;
          old_node.parent = new_dir;
        }, unlink(parent, name) {
          delete parent.contents[name];
          parent.timestamp = Date.now();
        }, rmdir(parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(55);
          }
          delete parent.contents[name];
          parent.timestamp = Date.now();
        }, readdir(node) {
          var entries = [".", ".."];
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        }, symlink(parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 | 40960, 0);
          node.link = oldpath;
          return node;
        }, readlink(node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(28);
          }
          return node.link;
        } }, stream_ops: { read(stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes)
            return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          if (size > 8 && contents.subarray) {
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++)
              buffer[offset + i] = contents[position + i];
          }
          return size;
        }, write(stream, buffer, offset, length, position, canOwn) {
          if (buffer.buffer === GROWABLE_HEAP_I8().buffer) {
            canOwn = false;
          }
          if (!length)
            return 0;
          var node = stream.node;
          node.timestamp = Date.now();
          if (buffer.subarray && (!node.contents || node.contents.subarray)) {
            if (canOwn) {
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) {
              node.contents = buffer.slice(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) {
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
          MEMFS.expandFileStorage(node, position + length);
          if (node.contents.subarray && buffer.subarray) {
            node.contents.set(buffer.subarray(offset, offset + length), position);
          } else {
            for (var i = 0; i < length; i++) {
              node.contents[position + i] = buffer[offset + i];
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position + length);
          return length;
        }, llseek(stream, offset, whence) {
          var position = offset;
          if (whence === 1) {
            position += stream.position;
          } else if (whence === 2) {
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(28);
          }
          return position;
        }, allocate(stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        }, mmap(stream, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          if (!(flags & 2) && contents.buffer === GROWABLE_HEAP_I8().buffer) {
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = mmapAlloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(48);
            }
            GROWABLE_HEAP_I8().set(contents, ptr >>> 0);
          }
          return { ptr, allocated };
        }, msync(stream, buffer, offset, length, mmapFlags) {
          MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          return 0;
        } } };
        var asyncLoad = (url, onload, onerror, noRunDep) => {
          var dep = !noRunDep ? getUniqueRunDependency(`al ${url}`) : "";
          readAsync(url, (arrayBuffer) => {
            assert(arrayBuffer, `Loading data file "${url}" failed (no arrayBuffer).`);
            onload(new Uint8Array(arrayBuffer));
            if (dep)
              removeRunDependency(dep);
          }, (event) => {
            if (onerror) {
              onerror();
            } else {
              throw `Loading data file "${url}" failed.`;
            }
          });
          if (dep)
            addRunDependency(dep);
        };
        var preloadPlugins = Module["preloadPlugins"] || [];
        function FS_handledByPreloadPlugin(byteArray, fullname, finish, onerror) {
          if (typeof Browser != "undefined")
            Browser.init();
          var handled = false;
          preloadPlugins.forEach(function(plugin) {
            if (handled)
              return;
            if (plugin["canHandle"](fullname)) {
              plugin["handle"](byteArray, fullname, finish, onerror);
              handled = true;
            }
          });
          return handled;
        }
        function FS_createPreloadedFile(parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
          var fullname = name ? PATH_FS.resolve(PATH.join2(parent, name)) : parent;
          var dep = getUniqueRunDependency(`cp ${fullname}`);
          function processData(byteArray) {
            function finish(byteArray2) {
              if (preFinish)
                preFinish();
              if (!dontCreateFile) {
                FS.createDataFile(parent, name, byteArray2, canRead, canWrite, canOwn);
              }
              if (onload)
                onload();
              removeRunDependency(dep);
            }
            if (FS_handledByPreloadPlugin(byteArray, fullname, finish, () => {
              if (onerror)
                onerror();
              removeRunDependency(dep);
            })) {
              return;
            }
            finish(byteArray);
          }
          addRunDependency(dep);
          if (typeof url == "string") {
            asyncLoad(url, (byteArray) => processData(byteArray), onerror);
          } else {
            processData(url);
          }
        }
        function FS_modeStringToFlags(str) {
          var flagModes = { "r": 0, "r+": 2, "w": 512 | 64 | 1, "w+": 512 | 64 | 2, "a": 1024 | 64 | 1, "a+": 1024 | 64 | 2 };
          var flags = flagModes[str];
          if (typeof flags == "undefined") {
            throw new Error(`Unknown file open mode: ${str}`);
          }
          return flags;
        }
        function FS_getMode(canRead, canWrite) {
          var mode = 0;
          if (canRead)
            mode |= 292 | 73;
          if (canWrite)
            mode |= 146;
          return mode;
        }
        var FS = { root: null, mounts: [], devices: {}, streams: [], nextInode: 1, nameTable: null, currentPath: "/", initialized: false, ignorePermissions: true, ErrnoError: null, genericErrors: {}, filesystems: null, syncFSRequests: 0, lookupPath: (path, opts = {}) => {
          path = PATH_FS.resolve(path);
          if (!path)
            return { path: "", node: null };
          var defaults = { follow_mount: true, recurse_count: 0 };
          opts = Object.assign(defaults, opts);
          if (opts.recurse_count > 8) {
            throw new FS.ErrnoError(32);
          }
          var parts = path.split("/").filter((p) => !!p);
          var current = FS.root;
          var current_path = "/";
          for (var i = 0; i < parts.length; i++) {
            var islast = i === parts.length - 1;
            if (islast && opts.parent) {
              break;
            }
            current = FS.lookupNode(current, parts[i]);
            current_path = PATH.join2(current_path, parts[i]);
            if (FS.isMountpoint(current)) {
              if (!islast || islast && opts.follow_mount) {
                current = current.mounted.root;
              }
            }
            if (!islast || opts.follow) {
              var count = 0;
              while (FS.isLink(current.mode)) {
                var link = FS.readlink(current_path);
                current_path = PATH_FS.resolve(PATH.dirname(current_path), link);
                var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count + 1 });
                current = lookup.node;
                if (count++ > 40) {
                  throw new FS.ErrnoError(32);
                }
              }
            }
          }
          return { path: current_path, node: current };
        }, getPath: (node) => {
          var path;
          while (true) {
            if (FS.isRoot(node)) {
              var mount = node.mount.mountpoint;
              if (!path)
                return mount;
              return mount[mount.length - 1] !== "/" ? `${mount}/${path}` : mount + path;
            }
            path = path ? `${node.name}/${path}` : node.name;
            node = node.parent;
          }
        }, hashName: (parentid, name) => {
          var hash = 0;
          for (var i = 0; i < name.length; i++) {
            hash = (hash << 5) - hash + name.charCodeAt(i) | 0;
          }
          return (parentid + hash >>> 0) % FS.nameTable.length;
        }, hashAddNode: (node) => {
          var hash = FS.hashName(node.parent.id, node.name);
          node.name_next = FS.nameTable[hash];
          FS.nameTable[hash] = node;
        }, hashRemoveNode: (node) => {
          var hash = FS.hashName(node.parent.id, node.name);
          if (FS.nameTable[hash] === node) {
            FS.nameTable[hash] = node.name_next;
          } else {
            var current = FS.nameTable[hash];
            while (current) {
              if (current.name_next === node) {
                current.name_next = node.name_next;
                break;
              }
              current = current.name_next;
            }
          }
        }, lookupNode: (parent, name) => {
          var errCode = FS.mayLookup(parent);
          if (errCode) {
            throw new FS.ErrnoError(errCode, parent);
          }
          var hash = FS.hashName(parent.id, name);
          for (var node = FS.nameTable[hash]; node; node = node.name_next) {
            var nodeName = node.name;
            if (node.parent.id === parent.id && nodeName === name) {
              return node;
            }
          }
          return FS.lookup(parent, name);
        }, createNode: (parent, name, mode, rdev) => {
          var node = new FS.FSNode(parent, name, mode, rdev);
          FS.hashAddNode(node);
          return node;
        }, destroyNode: (node) => {
          FS.hashRemoveNode(node);
        }, isRoot: (node) => node === node.parent, isMountpoint: (node) => !!node.mounted, isFile: (mode) => (mode & 61440) === 32768, isDir: (mode) => (mode & 61440) === 16384, isLink: (mode) => (mode & 61440) === 40960, isChrdev: (mode) => (mode & 61440) === 8192, isBlkdev: (mode) => (mode & 61440) === 24576, isFIFO: (mode) => (mode & 61440) === 4096, isSocket: (mode) => (mode & 49152) === 49152, flagsToPermissionString: (flag) => {
          var perms = ["r", "w", "rw"][flag & 3];
          if (flag & 512) {
            perms += "w";
          }
          return perms;
        }, nodePermissions: (node, perms) => {
          if (FS.ignorePermissions) {
            return 0;
          }
          if (perms.includes("r") && !(node.mode & 292)) {
            return 2;
          } else if (perms.includes("w") && !(node.mode & 146)) {
            return 2;
          } else if (perms.includes("x") && !(node.mode & 73)) {
            return 2;
          }
          return 0;
        }, mayLookup: (dir) => {
          var errCode = FS.nodePermissions(dir, "x");
          if (errCode)
            return errCode;
          if (!dir.node_ops.lookup)
            return 2;
          return 0;
        }, mayCreate: (dir, name) => {
          try {
            var node = FS.lookupNode(dir, name);
            return 20;
          } catch (e) {
          }
          return FS.nodePermissions(dir, "wx");
        }, mayDelete: (dir, name, isdir) => {
          var node;
          try {
            node = FS.lookupNode(dir, name);
          } catch (e) {
            return e.errno;
          }
          var errCode = FS.nodePermissions(dir, "wx");
          if (errCode) {
            return errCode;
          }
          if (isdir) {
            if (!FS.isDir(node.mode)) {
              return 54;
            }
            if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
              return 10;
            }
          } else {
            if (FS.isDir(node.mode)) {
              return 31;
            }
          }
          return 0;
        }, mayOpen: (node, flags) => {
          if (!node) {
            return 44;
          }
          if (FS.isLink(node.mode)) {
            return 32;
          } else if (FS.isDir(node.mode)) {
            if (FS.flagsToPermissionString(flags) !== "r" || flags & 512) {
              return 31;
            }
          }
          return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
        }, MAX_OPEN_FDS: 4096, nextfd: () => {
          for (var fd = 0; fd <= FS.MAX_OPEN_FDS; fd++) {
            if (!FS.streams[fd]) {
              return fd;
            }
          }
          throw new FS.ErrnoError(33);
        }, getStreamChecked: (fd) => {
          var stream = FS.getStream(fd);
          if (!stream) {
            throw new FS.ErrnoError(8);
          }
          return stream;
        }, getStream: (fd) => FS.streams[fd], createStream: (stream, fd = -1) => {
          if (!FS.FSStream) {
            FS.FSStream = function() {
              this.shared = {};
            };
            FS.FSStream.prototype = {};
            Object.defineProperties(FS.FSStream.prototype, { object: { get() {
              return this.node;
            }, set(val) {
              this.node = val;
            } }, isRead: { get() {
              return (this.flags & 2097155) !== 1;
            } }, isWrite: { get() {
              return (this.flags & 2097155) !== 0;
            } }, isAppend: { get() {
              return this.flags & 1024;
            } }, flags: { get() {
              return this.shared.flags;
            }, set(val) {
              this.shared.flags = val;
            } }, position: { get() {
              return this.shared.position;
            }, set(val) {
              this.shared.position = val;
            } } });
          }
          stream = Object.assign(new FS.FSStream(), stream);
          if (fd == -1) {
            fd = FS.nextfd();
          }
          stream.fd = fd;
          FS.streams[fd] = stream;
          return stream;
        }, closeStream: (fd) => {
          FS.streams[fd] = null;
        }, chrdev_stream_ops: { open: (stream) => {
          var device = FS.getDevice(stream.node.rdev);
          stream.stream_ops = device.stream_ops;
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        }, llseek: () => {
          throw new FS.ErrnoError(70);
        } }, major: (dev) => dev >> 8, minor: (dev) => dev & 255, makedev: (ma, mi) => ma << 8 | mi, registerDevice: (dev, ops) => {
          FS.devices[dev] = { stream_ops: ops };
        }, getDevice: (dev) => FS.devices[dev], getMounts: (mount) => {
          var mounts = [];
          var check = [mount];
          while (check.length) {
            var m = check.pop();
            mounts.push(m);
            check.push.apply(check, m.mounts);
          }
          return mounts;
        }, syncfs: (populate, callback) => {
          if (typeof populate == "function") {
            callback = populate;
            populate = false;
          }
          FS.syncFSRequests++;
          if (FS.syncFSRequests > 1) {
            err(`warning: ${FS.syncFSRequests} FS.syncfs operations in flight at once, probably just doing extra work`);
          }
          var mounts = FS.getMounts(FS.root.mount);
          var completed = 0;
          function doCallback(errCode) {
            FS.syncFSRequests--;
            return callback(errCode);
          }
          function done(errCode) {
            if (errCode) {
              if (!done.errored) {
                done.errored = true;
                return doCallback(errCode);
              }
              return;
            }
            if (++completed >= mounts.length) {
              doCallback(null);
            }
          }
          mounts.forEach((mount) => {
            if (!mount.type.syncfs) {
              return done(null);
            }
            mount.type.syncfs(mount, populate, done);
          });
        }, mount: (type, opts, mountpoint) => {
          var root = mountpoint === "/";
          var pseudo = !mountpoint;
          var node;
          if (root && FS.root) {
            throw new FS.ErrnoError(10);
          } else if (!root && !pseudo) {
            var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
            mountpoint = lookup.path;
            node = lookup.node;
            if (FS.isMountpoint(node)) {
              throw new FS.ErrnoError(10);
            }
            if (!FS.isDir(node.mode)) {
              throw new FS.ErrnoError(54);
            }
          }
          var mount = { type, opts, mountpoint, mounts: [] };
          var mountRoot = type.mount(mount);
          mountRoot.mount = mount;
          mount.root = mountRoot;
          if (root) {
            FS.root = mountRoot;
          } else if (node) {
            node.mounted = mount;
            if (node.mount) {
              node.mount.mounts.push(mount);
            }
          }
          return mountRoot;
        }, unmount: (mountpoint) => {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
          if (!FS.isMountpoint(lookup.node)) {
            throw new FS.ErrnoError(28);
          }
          var node = lookup.node;
          var mount = node.mounted;
          var mounts = FS.getMounts(mount);
          Object.keys(FS.nameTable).forEach((hash) => {
            var current = FS.nameTable[hash];
            while (current) {
              var next = current.name_next;
              if (mounts.includes(current.mount)) {
                FS.destroyNode(current);
              }
              current = next;
            }
          });
          node.mounted = null;
          var idx = node.mount.mounts.indexOf(mount);
          node.mount.mounts.splice(idx, 1);
        }, lookup: (parent, name) => parent.node_ops.lookup(parent, name), mknod: (path, mode, dev) => {
          var lookup = FS.lookupPath(path, { parent: true });
          var parent = lookup.node;
          var name = PATH.basename(path);
          if (!name || name === "." || name === "..") {
            throw new FS.ErrnoError(28);
          }
          var errCode = FS.mayCreate(parent, name);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.mknod) {
            throw new FS.ErrnoError(63);
          }
          return parent.node_ops.mknod(parent, name, mode, dev);
        }, create: (path, mode) => {
          mode = mode !== void 0 ? mode : 438;
          mode &= 4095;
          mode |= 32768;
          return FS.mknod(path, mode, 0);
        }, mkdir: (path, mode) => {
          mode = mode !== void 0 ? mode : 511;
          mode &= 511 | 512;
          mode |= 16384;
          return FS.mknod(path, mode, 0);
        }, mkdirTree: (path, mode) => {
          var dirs = path.split("/");
          var d = "";
          for (var i = 0; i < dirs.length; ++i) {
            if (!dirs[i])
              continue;
            d += "/" + dirs[i];
            try {
              FS.mkdir(d, mode);
            } catch (e) {
              if (e.errno != 20)
                throw e;
            }
          }
        }, mkdev: (path, mode, dev) => {
          if (typeof dev == "undefined") {
            dev = mode;
            mode = 438;
          }
          mode |= 8192;
          return FS.mknod(path, mode, dev);
        }, symlink: (oldpath, newpath) => {
          if (!PATH_FS.resolve(oldpath)) {
            throw new FS.ErrnoError(44);
          }
          var lookup = FS.lookupPath(newpath, { parent: true });
          var parent = lookup.node;
          if (!parent) {
            throw new FS.ErrnoError(44);
          }
          var newname = PATH.basename(newpath);
          var errCode = FS.mayCreate(parent, newname);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.symlink) {
            throw new FS.ErrnoError(63);
          }
          return parent.node_ops.symlink(parent, newname, oldpath);
        }, rename: (old_path, new_path) => {
          var old_dirname = PATH.dirname(old_path);
          var new_dirname = PATH.dirname(new_path);
          var old_name = PATH.basename(old_path);
          var new_name = PATH.basename(new_path);
          var lookup, old_dir, new_dir;
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
          if (!old_dir || !new_dir)
            throw new FS.ErrnoError(44);
          if (old_dir.mount !== new_dir.mount) {
            throw new FS.ErrnoError(75);
          }
          var old_node = FS.lookupNode(old_dir, old_name);
          var relative = PATH_FS.relative(old_path, new_dirname);
          if (relative.charAt(0) !== ".") {
            throw new FS.ErrnoError(28);
          }
          relative = PATH_FS.relative(new_path, old_dirname);
          if (relative.charAt(0) !== ".") {
            throw new FS.ErrnoError(55);
          }
          var new_node;
          try {
            new_node = FS.lookupNode(new_dir, new_name);
          } catch (e) {
          }
          if (old_node === new_node) {
            return;
          }
          var isdir = FS.isDir(old_node.mode);
          var errCode = FS.mayDelete(old_dir, old_name, isdir);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          errCode = new_node ? FS.mayDelete(new_dir, new_name, isdir) : FS.mayCreate(new_dir, new_name);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!old_dir.node_ops.rename) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isMountpoint(old_node) || new_node && FS.isMountpoint(new_node)) {
            throw new FS.ErrnoError(10);
          }
          if (new_dir !== old_dir) {
            errCode = FS.nodePermissions(old_dir, "w");
            if (errCode) {
              throw new FS.ErrnoError(errCode);
            }
          }
          FS.hashRemoveNode(old_node);
          try {
            old_dir.node_ops.rename(old_node, new_dir, new_name);
          } catch (e) {
            throw e;
          } finally {
            FS.hashAddNode(old_node);
          }
        }, rmdir: (path) => {
          var lookup = FS.lookupPath(path, { parent: true });
          var parent = lookup.node;
          var name = PATH.basename(path);
          var node = FS.lookupNode(parent, name);
          var errCode = FS.mayDelete(parent, name, true);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.rmdir) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(10);
          }
          parent.node_ops.rmdir(parent, name);
          FS.destroyNode(node);
        }, readdir: (path) => {
          var lookup = FS.lookupPath(path, { follow: true });
          var node = lookup.node;
          if (!node.node_ops.readdir) {
            throw new FS.ErrnoError(54);
          }
          return node.node_ops.readdir(node);
        }, unlink: (path) => {
          var lookup = FS.lookupPath(path, { parent: true });
          var parent = lookup.node;
          if (!parent) {
            throw new FS.ErrnoError(44);
          }
          var name = PATH.basename(path);
          var node = FS.lookupNode(parent, name);
          var errCode = FS.mayDelete(parent, name, false);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.unlink) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(10);
          }
          parent.node_ops.unlink(parent, name);
          FS.destroyNode(node);
        }, readlink: (path) => {
          var lookup = FS.lookupPath(path);
          var link = lookup.node;
          if (!link) {
            throw new FS.ErrnoError(44);
          }
          if (!link.node_ops.readlink) {
            throw new FS.ErrnoError(28);
          }
          return PATH_FS.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
        }, stat: (path, dontFollow) => {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          var node = lookup.node;
          if (!node) {
            throw new FS.ErrnoError(44);
          }
          if (!node.node_ops.getattr) {
            throw new FS.ErrnoError(63);
          }
          return node.node_ops.getattr(node);
        }, lstat: (path) => FS.stat(path, true), chmod: (path, mode, dontFollow) => {
          var node;
          if (typeof path == "string") {
            var lookup = FS.lookupPath(path, { follow: !dontFollow });
            node = lookup.node;
          } else {
            node = path;
          }
          if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(63);
          }
          node.node_ops.setattr(node, { mode: mode & 4095 | node.mode & ~4095, timestamp: Date.now() });
        }, lchmod: (path, mode) => {
          FS.chmod(path, mode, true);
        }, fchmod: (fd, mode) => {
          var stream = FS.getStreamChecked(fd);
          FS.chmod(stream.node, mode);
        }, chown: (path, uid, gid, dontFollow) => {
          var node;
          if (typeof path == "string") {
            var lookup = FS.lookupPath(path, { follow: !dontFollow });
            node = lookup.node;
          } else {
            node = path;
          }
          if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(63);
          }
          node.node_ops.setattr(node, { timestamp: Date.now() });
        }, lchown: (path, uid, gid) => {
          FS.chown(path, uid, gid, true);
        }, fchown: (fd, uid, gid) => {
          var stream = FS.getStreamChecked(fd);
          FS.chown(stream.node, uid, gid);
        }, truncate: (path, len) => {
          if (len < 0) {
            throw new FS.ErrnoError(28);
          }
          var node;
          if (typeof path == "string") {
            var lookup = FS.lookupPath(path, { follow: true });
            node = lookup.node;
          } else {
            node = path;
          }
          if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isDir(node.mode)) {
            throw new FS.ErrnoError(31);
          }
          if (!FS.isFile(node.mode)) {
            throw new FS.ErrnoError(28);
          }
          var errCode = FS.nodePermissions(node, "w");
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          node.node_ops.setattr(node, { size: len, timestamp: Date.now() });
        }, ftruncate: (fd, len) => {
          var stream = FS.getStreamChecked(fd);
          if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(28);
          }
          FS.truncate(stream.node, len);
        }, utime: (path, atime, mtime) => {
          var lookup = FS.lookupPath(path, { follow: true });
          var node = lookup.node;
          node.node_ops.setattr(node, { timestamp: Math.max(atime, mtime) });
        }, open: (path, flags, mode) => {
          if (path === "") {
            throw new FS.ErrnoError(44);
          }
          flags = typeof flags == "string" ? FS_modeStringToFlags(flags) : flags;
          mode = typeof mode == "undefined" ? 438 : mode;
          if (flags & 64) {
            mode = mode & 4095 | 32768;
          } else {
            mode = 0;
          }
          var node;
          if (typeof path == "object") {
            node = path;
          } else {
            path = PATH.normalize(path);
            try {
              var lookup = FS.lookupPath(path, { follow: !(flags & 131072) });
              node = lookup.node;
            } catch (e) {
            }
          }
          var created = false;
          if (flags & 64) {
            if (node) {
              if (flags & 128) {
                throw new FS.ErrnoError(20);
              }
            } else {
              node = FS.mknod(path, mode, 0);
              created = true;
            }
          }
          if (!node) {
            throw new FS.ErrnoError(44);
          }
          if (FS.isChrdev(node.mode)) {
            flags &= ~512;
          }
          if (flags & 65536 && !FS.isDir(node.mode)) {
            throw new FS.ErrnoError(54);
          }
          if (!created) {
            var errCode = FS.mayOpen(node, flags);
            if (errCode) {
              throw new FS.ErrnoError(errCode);
            }
          }
          if (flags & 512 && !created) {
            FS.truncate(node, 0);
          }
          flags &= ~(128 | 512 | 131072);
          var stream = FS.createStream({ node, path: FS.getPath(node), flags, seekable: true, position: 0, stream_ops: node.stream_ops, ungotten: [], error: false });
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
          if (Module["logReadFiles"] && !(flags & 1)) {
            if (!FS.readFiles)
              FS.readFiles = {};
            if (!(path in FS.readFiles)) {
              FS.readFiles[path] = 1;
            }
          }
          return stream;
        }, close: (stream) => {
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if (stream.getdents)
            stream.getdents = null;
          try {
            if (stream.stream_ops.close) {
              stream.stream_ops.close(stream);
            }
          } catch (e) {
            throw e;
          } finally {
            FS.closeStream(stream.fd);
          }
          stream.fd = null;
        }, isClosed: (stream) => stream.fd === null, llseek: (stream, offset, whence) => {
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if (!stream.seekable || !stream.stream_ops.llseek) {
            throw new FS.ErrnoError(70);
          }
          if (whence != 0 && whence != 1 && whence != 2) {
            throw new FS.ErrnoError(28);
          }
          stream.position = stream.stream_ops.llseek(stream, offset, whence);
          stream.ungotten = [];
          return stream.position;
        }, read: (stream, buffer, offset, length, position) => {
          if (length < 0 || position < 0) {
            throw new FS.ErrnoError(28);
          }
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(8);
          }
          if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(31);
          }
          if (!stream.stream_ops.read) {
            throw new FS.ErrnoError(28);
          }
          var seeking = typeof position != "undefined";
          if (!seeking) {
            position = stream.position;
          } else if (!stream.seekable) {
            throw new FS.ErrnoError(70);
          }
          var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
          if (!seeking)
            stream.position += bytesRead;
          return bytesRead;
        }, write: (stream, buffer, offset, length, position, canOwn) => {
          if (length < 0 || position < 0) {
            throw new FS.ErrnoError(28);
          }
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(8);
          }
          if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(31);
          }
          if (!stream.stream_ops.write) {
            throw new FS.ErrnoError(28);
          }
          if (stream.seekable && stream.flags & 1024) {
            FS.llseek(stream, 0, 2);
          }
          var seeking = typeof position != "undefined";
          if (!seeking) {
            position = stream.position;
          } else if (!stream.seekable) {
            throw new FS.ErrnoError(70);
          }
          var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
          if (!seeking)
            stream.position += bytesWritten;
          return bytesWritten;
        }, allocate: (stream, offset, length) => {
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if (offset < 0 || length <= 0) {
            throw new FS.ErrnoError(28);
          }
          if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(8);
          }
          if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          if (!stream.stream_ops.allocate) {
            throw new FS.ErrnoError(138);
          }
          stream.stream_ops.allocate(stream, offset, length);
        }, mmap: (stream, length, position, prot, flags) => {
          if ((prot & 2) !== 0 && (flags & 2) === 0 && (stream.flags & 2097155) !== 2) {
            throw new FS.ErrnoError(2);
          }
          if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(2);
          }
          if (!stream.stream_ops.mmap) {
            throw new FS.ErrnoError(43);
          }
          return stream.stream_ops.mmap(stream, length, position, prot, flags);
        }, msync: (stream, buffer, offset, length, mmapFlags) => {
          if (!stream.stream_ops.msync) {
            return 0;
          }
          return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
        }, munmap: (stream) => 0, ioctl: (stream, cmd, arg) => {
          if (!stream.stream_ops.ioctl) {
            throw new FS.ErrnoError(59);
          }
          return stream.stream_ops.ioctl(stream, cmd, arg);
        }, readFile: (path, opts = {}) => {
          opts.flags = opts.flags || 0;
          opts.encoding = opts.encoding || "binary";
          if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
            throw new Error(`Invalid encoding type "${opts.encoding}"`);
          }
          var ret;
          var stream = FS.open(path, opts.flags);
          var stat = FS.stat(path);
          var length = stat.size;
          var buf = new Uint8Array(length);
          FS.read(stream, buf, 0, length, 0);
          if (opts.encoding === "utf8") {
            ret = UTF8ArrayToString(buf, 0);
          } else if (opts.encoding === "binary") {
            ret = buf;
          }
          FS.close(stream);
          return ret;
        }, writeFile: (path, data, opts = {}) => {
          opts.flags = opts.flags || 577;
          var stream = FS.open(path, opts.flags, opts.mode);
          if (typeof data == "string") {
            var buf = new Uint8Array(lengthBytesUTF8(data) + 1);
            var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
            FS.write(stream, buf, 0, actualNumBytes, void 0, opts.canOwn);
          } else if (ArrayBuffer.isView(data)) {
            FS.write(stream, data, 0, data.byteLength, void 0, opts.canOwn);
          } else {
            throw new Error("Unsupported data type");
          }
          FS.close(stream);
        }, cwd: () => FS.currentPath, chdir: (path) => {
          var lookup = FS.lookupPath(path, { follow: true });
          if (lookup.node === null) {
            throw new FS.ErrnoError(44);
          }
          if (!FS.isDir(lookup.node.mode)) {
            throw new FS.ErrnoError(54);
          }
          var errCode = FS.nodePermissions(lookup.node, "x");
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          FS.currentPath = lookup.path;
        }, createDefaultDirectories: () => {
          FS.mkdir("/tmp");
          FS.mkdir("/home");
          FS.mkdir("/home/web_user");
        }, createDefaultDevices: () => {
          FS.mkdir("/dev");
          FS.registerDevice(FS.makedev(1, 3), { read: () => 0, write: (stream, buffer, offset, length, pos) => length });
          FS.mkdev("/dev/null", FS.makedev(1, 3));
          TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
          TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
          FS.mkdev("/dev/tty", FS.makedev(5, 0));
          FS.mkdev("/dev/tty1", FS.makedev(6, 0));
          var randomBuffer = new Uint8Array(1024), randomLeft = 0;
          var randomByte = () => {
            if (randomLeft === 0) {
              randomLeft = randomFill(randomBuffer).byteLength;
            }
            return randomBuffer[--randomLeft];
          };
          FS.createDevice("/dev", "random", randomByte);
          FS.createDevice("/dev", "urandom", randomByte);
          FS.mkdir("/dev/shm");
          FS.mkdir("/dev/shm/tmp");
        }, createSpecialDirectories: () => {
          FS.mkdir("/proc");
          var proc_self = FS.mkdir("/proc/self");
          FS.mkdir("/proc/self/fd");
          FS.mount({ mount: () => {
            var node = FS.createNode(proc_self, "fd", 16384 | 511, 73);
            node.node_ops = { lookup: (parent, name) => {
              var fd = +name;
              var stream = FS.getStreamChecked(fd);
              var ret = { parent: null, mount: { mountpoint: "fake" }, node_ops: { readlink: () => stream.path } };
              ret.parent = ret;
              return ret;
            } };
            return node;
          } }, {}, "/proc/self/fd");
        }, createStandardStreams: () => {
          if (Module["stdin"]) {
            FS.createDevice("/dev", "stdin", Module["stdin"]);
          } else {
            FS.symlink("/dev/tty", "/dev/stdin");
          }
          if (Module["stdout"]) {
            FS.createDevice("/dev", "stdout", null, Module["stdout"]);
          } else {
            FS.symlink("/dev/tty", "/dev/stdout");
          }
          if (Module["stderr"]) {
            FS.createDevice("/dev", "stderr", null, Module["stderr"]);
          } else {
            FS.symlink("/dev/tty1", "/dev/stderr");
          }
          var stdin = FS.open("/dev/stdin", 0);
          var stdout = FS.open("/dev/stdout", 1);
          var stderr = FS.open("/dev/stderr", 1);
        }, ensureErrnoError: () => {
          if (FS.ErrnoError)
            return;
          FS.ErrnoError = function ErrnoError(errno, node) {
            this.name = "ErrnoError";
            this.node = node;
            this.setErrno = function(errno2) {
              this.errno = errno2;
            };
            this.setErrno(errno);
            this.message = "FS error";
          };
          FS.ErrnoError.prototype = new Error();
          FS.ErrnoError.prototype.constructor = FS.ErrnoError;
          [44].forEach((code) => {
            FS.genericErrors[code] = new FS.ErrnoError(code);
            FS.genericErrors[code].stack = "<generic error, no stack>";
          });
        }, staticInit: () => {
          FS.ensureErrnoError();
          FS.nameTable = new Array(4096);
          FS.mount(MEMFS, {}, "/");
          FS.createDefaultDirectories();
          FS.createDefaultDevices();
          FS.createSpecialDirectories();
          FS.filesystems = { "MEMFS": MEMFS };
        }, init: (input, output, error) => {
          FS.init.initialized = true;
          FS.ensureErrnoError();
          Module["stdin"] = input || Module["stdin"];
          Module["stdout"] = output || Module["stdout"];
          Module["stderr"] = error || Module["stderr"];
          FS.createStandardStreams();
        }, quit: () => {
          FS.init.initialized = false;
          for (var i = 0; i < FS.streams.length; i++) {
            var stream = FS.streams[i];
            if (!stream) {
              continue;
            }
            FS.close(stream);
          }
        }, findObject: (path, dontResolveLastLink) => {
          var ret = FS.analyzePath(path, dontResolveLastLink);
          if (!ret.exists) {
            return null;
          }
          return ret.object;
        }, analyzePath: (path, dontResolveLastLink) => {
          try {
            var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
            path = lookup.path;
          } catch (e) {
          }
          var ret = { isRoot: false, exists: false, error: 0, name: null, path: null, object: null, parentExists: false, parentPath: null, parentObject: null };
          try {
            var lookup = FS.lookupPath(path, { parent: true });
            ret.parentExists = true;
            ret.parentPath = lookup.path;
            ret.parentObject = lookup.node;
            ret.name = PATH.basename(path);
            lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
            ret.exists = true;
            ret.path = lookup.path;
            ret.object = lookup.node;
            ret.name = lookup.node.name;
            ret.isRoot = lookup.path === "/";
          } catch (e) {
            ret.error = e.errno;
          }
          return ret;
        }, createPath: (parent, path, canRead, canWrite) => {
          parent = typeof parent == "string" ? parent : FS.getPath(parent);
          var parts = path.split("/").reverse();
          while (parts.length) {
            var part = parts.pop();
            if (!part)
              continue;
            var current = PATH.join2(parent, part);
            try {
              FS.mkdir(current);
            } catch (e) {
            }
            parent = current;
          }
          return current;
        }, createFile: (parent, name, properties, canRead, canWrite) => {
          var path = PATH.join2(typeof parent == "string" ? parent : FS.getPath(parent), name);
          var mode = FS_getMode(canRead, canWrite);
          return FS.create(path, mode);
        }, createDataFile: (parent, name, data, canRead, canWrite, canOwn) => {
          var path = name;
          if (parent) {
            parent = typeof parent == "string" ? parent : FS.getPath(parent);
            path = name ? PATH.join2(parent, name) : parent;
          }
          var mode = FS_getMode(canRead, canWrite);
          var node = FS.create(path, mode);
          if (data) {
            if (typeof data == "string") {
              var arr = new Array(data.length);
              for (var i = 0, len = data.length; i < len; ++i)
                arr[i] = data.charCodeAt(i);
              data = arr;
            }
            FS.chmod(node, mode | 146);
            var stream = FS.open(node, 577);
            FS.write(stream, data, 0, data.length, 0, canOwn);
            FS.close(stream);
            FS.chmod(node, mode);
          }
          return node;
        }, createDevice: (parent, name, input, output) => {
          var path = PATH.join2(typeof parent == "string" ? parent : FS.getPath(parent), name);
          var mode = FS_getMode(!!input, !!output);
          if (!FS.createDevice.major)
            FS.createDevice.major = 64;
          var dev = FS.makedev(FS.createDevice.major++, 0);
          FS.registerDevice(dev, { open: (stream) => {
            stream.seekable = false;
          }, close: (stream) => {
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          }, read: (stream, buffer, offset, length, pos) => {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(29);
              }
              if (result === void 0 && bytesRead === 0) {
                throw new FS.ErrnoError(6);
              }
              if (result === null || result === void 0)
                break;
              bytesRead++;
              buffer[offset + i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          }, write: (stream, buffer, offset, length, pos) => {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset + i]);
              } catch (e) {
                throw new FS.ErrnoError(29);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          } });
          return FS.mkdev(path, mode, dev);
        }, forceLoadFile: (obj) => {
          if (obj.isDevice || obj.isFolder || obj.link || obj.contents)
            return true;
          if (typeof XMLHttpRequest != "undefined") {
            throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
          } else if (read_) {
            try {
              obj.contents = intArrayFromString(read_(obj.url), true);
              obj.usedBytes = obj.contents.length;
            } catch (e) {
              throw new FS.ErrnoError(29);
            }
          } else {
            throw new Error("Cannot load without read() or XMLHttpRequest.");
          }
        }, createLazyFile: (parent, name, url, canRead, canWrite) => {
          function LazyUint8Array() {
            this.lengthKnown = false;
            this.chunks = [];
          }
          LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
            if (idx > this.length - 1 || idx < 0) {
              return void 0;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = idx / this.chunkSize | 0;
            return this.getter(chunkNum)[chunkOffset];
          };
          LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
            this.getter = getter;
          };
          LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
            var xhr = new XMLHttpRequest();
            xhr.open("HEAD", url, false);
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304))
              throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            var datalength = Number(xhr.getResponseHeader("Content-length"));
            var header;
            var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
            var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip";
            var chunkSize = 1024 * 1024;
            if (!hasByteServing)
              chunkSize = datalength;
            var doXHR = (from, to) => {
              if (from > to)
                throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
              if (to > datalength - 1)
                throw new Error("only " + datalength + " bytes available! programmer error!");
              var xhr2 = new XMLHttpRequest();
              xhr2.open("GET", url, false);
              if (datalength !== chunkSize)
                xhr2.setRequestHeader("Range", "bytes=" + from + "-" + to);
              xhr2.responseType = "arraybuffer";
              if (xhr2.overrideMimeType) {
                xhr2.overrideMimeType("text/plain; charset=x-user-defined");
              }
              xhr2.send(null);
              if (!(xhr2.status >= 200 && xhr2.status < 300 || xhr2.status === 304))
                throw new Error("Couldn't load " + url + ". Status: " + xhr2.status);
              if (xhr2.response !== void 0) {
                return new Uint8Array(xhr2.response || []);
              }
              return intArrayFromString(xhr2.responseText || "", true);
            };
            var lazyArray2 = this;
            lazyArray2.setDataGetter((chunkNum) => {
              var start = chunkNum * chunkSize;
              var end = (chunkNum + 1) * chunkSize - 1;
              end = Math.min(end, datalength - 1);
              if (typeof lazyArray2.chunks[chunkNum] == "undefined") {
                lazyArray2.chunks[chunkNum] = doXHR(start, end);
              }
              if (typeof lazyArray2.chunks[chunkNum] == "undefined")
                throw new Error("doXHR failed!");
              return lazyArray2.chunks[chunkNum];
            });
            if (usesGzip || !datalength) {
              chunkSize = datalength = 1;
              datalength = this.getter(0).length;
              chunkSize = datalength;
              out("LazyFiles on gzip forces download of the whole file when length is accessed");
            }
            this._length = datalength;
            this._chunkSize = chunkSize;
            this.lengthKnown = true;
          };
          if (typeof XMLHttpRequest != "undefined") {
            if (!ENVIRONMENT_IS_WORKER)
              throw "Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";
            var lazyArray = new LazyUint8Array();
            Object.defineProperties(lazyArray, { length: { get: function() {
              if (!this.lengthKnown) {
                this.cacheLength();
              }
              return this._length;
            } }, chunkSize: { get: function() {
              if (!this.lengthKnown) {
                this.cacheLength();
              }
              return this._chunkSize;
            } } });
            var properties = { isDevice: false, contents: lazyArray };
          } else {
            var properties = { isDevice: false, url };
          }
          var node = FS.createFile(parent, name, properties, canRead, canWrite);
          if (properties.contents) {
            node.contents = properties.contents;
          } else if (properties.url) {
            node.contents = null;
            node.url = properties.url;
          }
          Object.defineProperties(node, { usedBytes: { get: function() {
            return this.contents.length;
          } } });
          var stream_ops = {};
          var keys = Object.keys(node.stream_ops);
          keys.forEach((key) => {
            var fn = node.stream_ops[key];
            stream_ops[key] = function forceLoadLazyFile() {
              FS.forceLoadFile(node);
              return fn.apply(null, arguments);
            };
          });
          function writeChunks(stream, buffer, offset, length, position) {
            var contents = stream.node.contents;
            if (position >= contents.length)
              return 0;
            var size = Math.min(contents.length - position, length);
            if (contents.slice) {
              for (var i = 0; i < size; i++) {
                buffer[offset + i] = contents[position + i];
              }
            } else {
              for (var i = 0; i < size; i++) {
                buffer[offset + i] = contents.get(position + i);
              }
            }
            return size;
          }
          stream_ops.read = (stream, buffer, offset, length, position) => {
            FS.forceLoadFile(node);
            return writeChunks(stream, buffer, offset, length, position);
          };
          stream_ops.mmap = (stream, length, position, prot, flags) => {
            FS.forceLoadFile(node);
            var ptr = mmapAlloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(48);
            }
            writeChunks(stream, GROWABLE_HEAP_I8(), ptr, length, position);
            return { ptr, allocated: true };
          };
          node.stream_ops = stream_ops;
          return node;
        } };
        var UTF8ToString = (ptr, maxBytesToRead) => {
          ptr >>>= 0;
          return ptr ? UTF8ArrayToString(GROWABLE_HEAP_U8(), ptr, maxBytesToRead) : "";
        };
        var SYSCALLS = { DEFAULT_POLLMASK: 5, calculateAt: function(dirfd, path, allowEmpty) {
          if (PATH.isAbs(path)) {
            return path;
          }
          var dir;
          if (dirfd === -100) {
            dir = FS.cwd();
          } else {
            var dirstream = SYSCALLS.getStreamFromFD(dirfd);
            dir = dirstream.path;
          }
          if (path.length == 0) {
            if (!allowEmpty) {
              throw new FS.ErrnoError(44);
            }
            return dir;
          }
          return PATH.join2(dir, path);
        }, doStat: function(func, path, buf) {
          try {
            var stat = func(path);
          } catch (e) {
            if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
              return -54;
            }
            throw e;
          }
          GROWABLE_HEAP_I32()[buf >>> 2] = stat.dev;
          GROWABLE_HEAP_I32()[buf + 4 >>> 2] = stat.mode;
          GROWABLE_HEAP_U32()[buf + 8 >>> 2] = stat.nlink;
          GROWABLE_HEAP_I32()[buf + 12 >>> 2] = stat.uid;
          GROWABLE_HEAP_I32()[buf + 16 >>> 2] = stat.gid;
          GROWABLE_HEAP_I32()[buf + 20 >>> 2] = stat.rdev;
          tempI64 = [stat.size >>> 0, (tempDouble = stat.size, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[buf + 24 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 28 >>> 2] = tempI64[1];
          GROWABLE_HEAP_I32()[buf + 32 >>> 2] = 4096;
          GROWABLE_HEAP_I32()[buf + 36 >>> 2] = stat.blocks;
          var atime = stat.atime.getTime();
          var mtime = stat.mtime.getTime();
          var ctime = stat.ctime.getTime();
          tempI64 = [Math.floor(atime / 1e3) >>> 0, (tempDouble = Math.floor(atime / 1e3), +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[buf + 40 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 44 >>> 2] = tempI64[1];
          GROWABLE_HEAP_U32()[buf + 48 >>> 2] = atime % 1e3 * 1e3;
          tempI64 = [Math.floor(mtime / 1e3) >>> 0, (tempDouble = Math.floor(mtime / 1e3), +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[buf + 56 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 60 >>> 2] = tempI64[1];
          GROWABLE_HEAP_U32()[buf + 64 >>> 2] = mtime % 1e3 * 1e3;
          tempI64 = [Math.floor(ctime / 1e3) >>> 0, (tempDouble = Math.floor(ctime / 1e3), +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[buf + 72 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 76 >>> 2] = tempI64[1];
          GROWABLE_HEAP_U32()[buf + 80 >>> 2] = ctime % 1e3 * 1e3;
          tempI64 = [stat.ino >>> 0, (tempDouble = stat.ino, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[buf + 88 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[buf + 92 >>> 2] = tempI64[1];
          return 0;
        }, doMsync: function(addr, stream, len, flags, offset) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          if (flags & 2) {
            return 0;
          }
          var buffer = GROWABLE_HEAP_U8().slice(addr, addr + len);
          FS.msync(stream, buffer, offset, len, flags);
        }, varargs: void 0, get() {
          SYSCALLS.varargs += 4;
          var ret = GROWABLE_HEAP_I32()[SYSCALLS.varargs - 4 >>> 2];
          return ret;
        }, getStr(ptr) {
          var ret = UTF8ToString(ptr);
          return ret;
        }, getStreamFromFD: function(fd) {
          var stream = FS.getStreamChecked(fd);
          return stream;
        } };
        function _proc_exit(code) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(1, 1, code);
          EXITSTATUS = code;
          if (!keepRuntimeAlive()) {
            PThread.terminateAllThreads();
            if (Module["onExit"])
              Module["onExit"](code);
            ABORT = true;
          }
          quit_(code, new ExitStatus(code));
        }
        var exitJS = (status, implicit) => {
          EXITSTATUS = status;
          if (ENVIRONMENT_IS_PTHREAD) {
            exitOnMainThread(status);
            throw "unwind";
          }
          _proc_exit(status);
        };
        var _exit = exitJS;
        var handleException = (e) => {
          if (e instanceof ExitStatus || e == "unwind") {
            return EXITSTATUS;
          }
          quit_(1, e);
        };
        var PThread = { unusedWorkers: [], runningWorkers: [], tlsInitFunctions: [], pthreads: {}, init: function() {
          if (ENVIRONMENT_IS_PTHREAD) {
            PThread.initWorker();
          } else {
            PThread.initMainThread();
          }
        }, initMainThread: function() {
          var pthreadPoolSize = navigator.hardwareConcurrency;
          while (pthreadPoolSize--) {
            PThread.allocateUnusedWorker();
          }
          addOnPreRun(() => {
            addRunDependency("loading-workers");
            PThread.loadWasmModuleToAllWorkers(() => removeRunDependency("loading-workers"));
          });
        }, initWorker: function() {
          noExitRuntime = false;
        }, setExitStatus: function(status) {
          EXITSTATUS = status;
        }, terminateAllThreads__deps: ["$terminateWorker"], terminateAllThreads: function() {
          for (var worker of PThread.runningWorkers) {
            terminateWorker(worker);
          }
          for (var worker of PThread.unusedWorkers) {
            terminateWorker(worker);
          }
          PThread.unusedWorkers = [];
          PThread.runningWorkers = [];
          PThread.pthreads = [];
        }, returnWorkerToPool: function(worker) {
          var pthread_ptr = worker.pthread_ptr;
          delete PThread.pthreads[pthread_ptr];
          PThread.unusedWorkers.push(worker);
          PThread.runningWorkers.splice(PThread.runningWorkers.indexOf(worker), 1);
          worker.pthread_ptr = 0;
          __emscripten_thread_free_data(pthread_ptr);
        }, receiveObjectTransfer: function(data) {
        }, threadInitTLS: function() {
          PThread.tlsInitFunctions.forEach((f) => f());
        }, loadWasmModuleToWorker: (worker) => new Promise((onFinishedLoading) => {
          worker.onmessage = (e) => {
            var d = e["data"];
            var cmd = d["cmd"];
            if (d["targetThread"] && d["targetThread"] != _pthread_self()) {
              var targetWorker = PThread.pthreads[d.targetThread];
              if (targetWorker) {
                targetWorker.postMessage(d, d["transferList"]);
              } else {
                err('Internal error! Worker sent a message "' + cmd + '" to target pthread ' + d["targetThread"] + ", but that thread no longer exists!");
              }
              return;
            }
            if (cmd === "checkMailbox") {
              checkMailbox();
            } else if (cmd === "spawnThread") {
              spawnThread(d);
            } else if (cmd === "cleanupThread") {
              cleanupThread(d["thread"]);
            } else if (cmd === "killThread") {
              killThread(d["thread"]);
            } else if (cmd === "cancelThread") {
              cancelThread(d["thread"]);
            } else if (cmd === "loaded") {
              worker.loaded = true;
              onFinishedLoading(worker);
            } else if (cmd === "alert") {
              alert("Thread " + d["threadId"] + ": " + d["text"]);
            } else if (d.target === "setimmediate") {
              worker.postMessage(d);
            } else if (cmd === "callHandler") {
              Module[d["handler"]](...d["args"]);
            } else if (cmd) {
              err("worker sent an unknown command " + cmd);
            }
          };
          worker.onerror = (e) => {
            var message = "worker sent an error!";
            err(message + " " + e.filename + ":" + e.lineno + ": " + e.message);
            throw e;
          };
          var handlers = [];
          var knownHandlers = ["onExit", "onAbort", "print", "printErr"];
          for (var handler of knownHandlers) {
            if (Module.hasOwnProperty(handler)) {
              handlers.push(handler);
            }
          }
          worker.postMessage({ "cmd": "load", "handlers": handlers, "urlOrBlob": Module["mainScriptUrlOrBlob"] || _scriptDir, "wasmMemory": wasmMemory, "wasmModule": wasmModule });
        }), loadWasmModuleToAllWorkers: function(onMaybeReady) {
          if (ENVIRONMENT_IS_PTHREAD) {
            return onMaybeReady();
          }
          let pthreadPoolReady = Promise.all(PThread.unusedWorkers.map(PThread.loadWasmModuleToWorker));
          pthreadPoolReady.then(onMaybeReady);
        }, allocateUnusedWorker: function() {
          var worker;
          var pthreadMainJs = locateFile("web-ifc-mt.worker.js");
          worker = new Worker(pthreadMainJs);
          PThread.unusedWorkers.push(worker);
        }, getNewWorker: function() {
          if (PThread.unusedWorkers.length == 0) {
            PThread.allocateUnusedWorker();
            PThread.loadWasmModuleToWorker(PThread.unusedWorkers[0]);
          }
          return PThread.unusedWorkers.pop();
        } };
        Module["PThread"] = PThread;
        var callRuntimeCallbacks = (callbacks) => {
          while (callbacks.length > 0) {
            callbacks.shift()(Module);
          }
        };
        function establishStackSpace() {
          var pthread_ptr = _pthread_self();
          var stackHigh = GROWABLE_HEAP_I32()[pthread_ptr + 52 >>> 2];
          var stackSize = GROWABLE_HEAP_I32()[pthread_ptr + 56 >>> 2];
          var stackLow = stackHigh - stackSize;
          _emscripten_stack_set_limits(stackHigh, stackLow);
          stackRestore(stackHigh);
        }
        Module["establishStackSpace"] = establishStackSpace;
        function exitOnMainThread(returnCode) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(2, 0, returnCode);
          _exit(returnCode);
        }
        var wasmTableMirror = [];
        var getWasmTableEntry = (funcPtr) => {
          var func = wasmTableMirror[funcPtr];
          if (!func) {
            if (funcPtr >= wasmTableMirror.length)
              wasmTableMirror.length = funcPtr + 1;
            wasmTableMirror[funcPtr] = func = wasmTable.get(funcPtr);
          }
          return func;
        };
        function invokeEntryPoint(ptr, arg) {
          var result = getWasmTableEntry(ptr)(arg);
          function finish(result2) {
            if (keepRuntimeAlive()) {
              PThread.setExitStatus(result2);
            } else {
              __emscripten_thread_exit(result2);
            }
          }
          finish(result);
        }
        Module["invokeEntryPoint"] = invokeEntryPoint;
        function registerTLSInit(tlsInitFunc) {
          PThread.tlsInitFunctions.push(tlsInitFunc);
        }
        function ExceptionInfo(excPtr) {
          this.excPtr = excPtr;
          this.ptr = excPtr - 24;
          this.set_type = function(type) {
            GROWABLE_HEAP_U32()[this.ptr + 4 >>> 2] = type;
          };
          this.get_type = function() {
            return GROWABLE_HEAP_U32()[this.ptr + 4 >>> 2];
          };
          this.set_destructor = function(destructor) {
            GROWABLE_HEAP_U32()[this.ptr + 8 >>> 2] = destructor;
          };
          this.get_destructor = function() {
            return GROWABLE_HEAP_U32()[this.ptr + 8 >>> 2];
          };
          this.set_caught = function(caught) {
            caught = caught ? 1 : 0;
            GROWABLE_HEAP_I8()[this.ptr + 12 >>> 0] = caught;
          };
          this.get_caught = function() {
            return GROWABLE_HEAP_I8()[this.ptr + 12 >>> 0] != 0;
          };
          this.set_rethrown = function(rethrown) {
            rethrown = rethrown ? 1 : 0;
            GROWABLE_HEAP_I8()[this.ptr + 13 >>> 0] = rethrown;
          };
          this.get_rethrown = function() {
            return GROWABLE_HEAP_I8()[this.ptr + 13 >>> 0] != 0;
          };
          this.init = function(type, destructor) {
            this.set_adjusted_ptr(0);
            this.set_type(type);
            this.set_destructor(destructor);
          };
          this.set_adjusted_ptr = function(adjustedPtr) {
            GROWABLE_HEAP_U32()[this.ptr + 16 >>> 2] = adjustedPtr;
          };
          this.get_adjusted_ptr = function() {
            return GROWABLE_HEAP_U32()[this.ptr + 16 >>> 2];
          };
          this.get_exception_ptr = function() {
            var isPointer = ___cxa_is_pointer_type(this.get_type());
            if (isPointer) {
              return GROWABLE_HEAP_U32()[this.excPtr >>> 2];
            }
            var adjusted = this.get_adjusted_ptr();
            if (adjusted !== 0)
              return adjusted;
            return this.excPtr;
          };
        }
        var exceptionLast = 0;
        var uncaughtExceptionCount = 0;
        function convertI32PairToI53Checked(lo, hi) {
          return hi + 2097152 >>> 0 < 4194305 - !!lo ? (lo >>> 0) + hi * 4294967296 : NaN;
        }
        function ___cxa_throw(ptr, type, destructor) {
          ptr >>>= 0;
          type >>>= 0;
          destructor >>>= 0;
          var info = new ExceptionInfo(ptr);
          info.init(type, destructor);
          exceptionLast = ptr;
          uncaughtExceptionCount++;
          throw exceptionLast;
        }
        function ___emscripten_init_main_thread_js(tb) {
          tb >>>= 0;
          __emscripten_thread_init(tb, !ENVIRONMENT_IS_WORKER, 1, !ENVIRONMENT_IS_WEB, 5242880, false);
          PThread.threadInitTLS();
        }
        function ___emscripten_thread_cleanup(thread) {
          thread >>>= 0;
          if (!ENVIRONMENT_IS_PTHREAD)
            cleanupThread(thread);
          else
            postMessage({ "cmd": "cleanupThread", "thread": thread });
        }
        var tupleRegistrations = {};
        function runDestructors(destructors) {
          while (destructors.length) {
            var ptr = destructors.pop();
            var del = destructors.pop();
            del(ptr);
          }
        }
        function simpleReadValueFromPointer(pointer) {
          return this["fromWireType"](GROWABLE_HEAP_I32()[pointer >>> 2]);
        }
        var awaitingDependencies = {};
        var registeredTypes = {};
        var typeDependencies = {};
        var InternalError = void 0;
        function throwInternalError(message) {
          throw new InternalError(message);
        }
        function whenDependentTypesAreResolved(myTypes, dependentTypes, getTypeConverters) {
          myTypes.forEach(function(type) {
            typeDependencies[type] = dependentTypes;
          });
          function onComplete(typeConverters2) {
            var myTypeConverters = getTypeConverters(typeConverters2);
            if (myTypeConverters.length !== myTypes.length) {
              throwInternalError("Mismatched type converter count");
            }
            for (var i = 0; i < myTypes.length; ++i) {
              registerType(myTypes[i], myTypeConverters[i]);
            }
          }
          var typeConverters = new Array(dependentTypes.length);
          var unregisteredTypes = [];
          var registered = 0;
          dependentTypes.forEach((dt, i) => {
            if (registeredTypes.hasOwnProperty(dt)) {
              typeConverters[i] = registeredTypes[dt];
            } else {
              unregisteredTypes.push(dt);
              if (!awaitingDependencies.hasOwnProperty(dt)) {
                awaitingDependencies[dt] = [];
              }
              awaitingDependencies[dt].push(() => {
                typeConverters[i] = registeredTypes[dt];
                ++registered;
                if (registered === unregisteredTypes.length) {
                  onComplete(typeConverters);
                }
              });
            }
          });
          if (unregisteredTypes.length === 0) {
            onComplete(typeConverters);
          }
        }
        function __embind_finalize_value_array(rawTupleType) {
          rawTupleType >>>= 0;
          var reg = tupleRegistrations[rawTupleType];
          delete tupleRegistrations[rawTupleType];
          var elements = reg.elements;
          var elementsLength = elements.length;
          var elementTypes = elements.map(function(elt) {
            return elt.getterReturnType;
          }).concat(elements.map(function(elt) {
            return elt.setterArgumentType;
          }));
          var rawConstructor = reg.rawConstructor;
          var rawDestructor = reg.rawDestructor;
          whenDependentTypesAreResolved([rawTupleType], elementTypes, function(elementTypes2) {
            elements.forEach((elt, i) => {
              var getterReturnType = elementTypes2[i];
              var getter = elt.getter;
              var getterContext = elt.getterContext;
              var setterArgumentType = elementTypes2[i + elementsLength];
              var setter = elt.setter;
              var setterContext = elt.setterContext;
              elt.read = (ptr) => getterReturnType["fromWireType"](getter(getterContext, ptr));
              elt.write = (ptr, o) => {
                var destructors = [];
                setter(setterContext, ptr, setterArgumentType["toWireType"](destructors, o));
                runDestructors(destructors);
              };
            });
            return [{ name: reg.name, "fromWireType": function(ptr) {
              var rv = new Array(elementsLength);
              for (var i = 0; i < elementsLength; ++i) {
                rv[i] = elements[i].read(ptr);
              }
              rawDestructor(ptr);
              return rv;
            }, "toWireType": function(destructors, o) {
              if (elementsLength !== o.length) {
                throw new TypeError(`Incorrect number of tuple elements for ${reg.name}: expected=${elementsLength}, actual=${o.length}`);
              }
              var ptr = rawConstructor();
              for (var i = 0; i < elementsLength; ++i) {
                elements[i].write(ptr, o[i]);
              }
              if (destructors !== null) {
                destructors.push(rawDestructor, ptr);
              }
              return ptr;
            }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: rawDestructor }];
          });
        }
        var structRegistrations = {};
        var __embind_finalize_value_object = function(structType) {
          structType >>>= 0;
          var reg = structRegistrations[structType];
          delete structRegistrations[structType];
          var rawConstructor = reg.rawConstructor;
          var rawDestructor = reg.rawDestructor;
          var fieldRecords = reg.fields;
          var fieldTypes = fieldRecords.map((field) => field.getterReturnType).concat(fieldRecords.map((field) => field.setterArgumentType));
          whenDependentTypesAreResolved([structType], fieldTypes, (fieldTypes2) => {
            var fields = {};
            fieldRecords.forEach((field, i) => {
              var fieldName = field.fieldName;
              var getterReturnType = fieldTypes2[i];
              var getter = field.getter;
              var getterContext = field.getterContext;
              var setterArgumentType = fieldTypes2[i + fieldRecords.length];
              var setter = field.setter;
              var setterContext = field.setterContext;
              fields[fieldName] = { read: (ptr) => getterReturnType["fromWireType"](getter(getterContext, ptr)), write: (ptr, o) => {
                var destructors = [];
                setter(setterContext, ptr, setterArgumentType["toWireType"](destructors, o));
                runDestructors(destructors);
              } };
            });
            return [{ name: reg.name, "fromWireType": function(ptr) {
              var rv = {};
              for (var i in fields) {
                rv[i] = fields[i].read(ptr);
              }
              rawDestructor(ptr);
              return rv;
            }, "toWireType": function(destructors, o) {
              for (var fieldName in fields) {
                if (!(fieldName in o)) {
                  throw new TypeError(`Missing field: "${fieldName}"`);
                }
              }
              var ptr = rawConstructor();
              for (fieldName in fields) {
                fields[fieldName].write(ptr, o[fieldName]);
              }
              if (destructors !== null) {
                destructors.push(rawDestructor, ptr);
              }
              return ptr;
            }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: rawDestructor }];
          });
        };
        function __embind_register_bigint(primitiveType, name, size, minRange, maxRange) {
          primitiveType >>>= 0;
          name >>>= 0;
          size >>>= 0;
        }
        function getShiftFromSize(size) {
          switch (size) {
            case 1:
              return 0;
            case 2:
              return 1;
            case 4:
              return 2;
            case 8:
              return 3;
            default:
              throw new TypeError(`Unknown type size: ${size}`);
          }
        }
        function embind_init_charCodes() {
          var codes = new Array(256);
          for (var i = 0; i < 256; ++i) {
            codes[i] = String.fromCharCode(i);
          }
          embind_charCodes = codes;
        }
        var embind_charCodes = void 0;
        function readLatin1String(ptr) {
          var ret = "";
          var c = ptr;
          while (GROWABLE_HEAP_U8()[c >>> 0]) {
            ret += embind_charCodes[GROWABLE_HEAP_U8()[c++ >>> 0]];
          }
          return ret;
        }
        var BindingError = void 0;
        function throwBindingError(message) {
          throw new BindingError(message);
        }
        function sharedRegisterType(rawType, registeredInstance, options = {}) {
          var name = registeredInstance.name;
          if (!rawType) {
            throwBindingError(`type "${name}" must have a positive integer typeid pointer`);
          }
          if (registeredTypes.hasOwnProperty(rawType)) {
            if (options.ignoreDuplicateRegistrations) {
              return;
            } else {
              throwBindingError(`Cannot register type '${name}' twice`);
            }
          }
          registeredTypes[rawType] = registeredInstance;
          delete typeDependencies[rawType];
          if (awaitingDependencies.hasOwnProperty(rawType)) {
            var callbacks = awaitingDependencies[rawType];
            delete awaitingDependencies[rawType];
            callbacks.forEach((cb) => cb());
          }
        }
        function registerType(rawType, registeredInstance, options = {}) {
          if (!("argPackAdvance" in registeredInstance)) {
            throw new TypeError("registerType registeredInstance requires argPackAdvance");
          }
          return sharedRegisterType(rawType, registeredInstance, options);
        }
        function __embind_register_bool(rawType, name, size, trueValue, falseValue) {
          rawType >>>= 0;
          name >>>= 0;
          size >>>= 0;
          var shift = getShiftFromSize(size);
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": function(wt) {
            return !!wt;
          }, "toWireType": function(destructors, o) {
            return o ? trueValue : falseValue;
          }, "argPackAdvance": 8, "readValueFromPointer": function(pointer) {
            var heap;
            if (size === 1) {
              heap = GROWABLE_HEAP_I8();
            } else if (size === 2) {
              heap = GROWABLE_HEAP_I16();
            } else if (size === 4) {
              heap = GROWABLE_HEAP_I32();
            } else {
              throw new TypeError("Unknown boolean type size: " + name);
            }
            return this["fromWireType"](heap[pointer >>> shift]);
          }, destructorFunction: null });
        }
        function ClassHandle_isAliasOf(other) {
          if (!(this instanceof ClassHandle)) {
            return false;
          }
          if (!(other instanceof ClassHandle)) {
            return false;
          }
          var leftClass = this.$$.ptrType.registeredClass;
          var left = this.$$.ptr;
          var rightClass = other.$$.ptrType.registeredClass;
          var right = other.$$.ptr;
          while (leftClass.baseClass) {
            left = leftClass.upcast(left);
            leftClass = leftClass.baseClass;
          }
          while (rightClass.baseClass) {
            right = rightClass.upcast(right);
            rightClass = rightClass.baseClass;
          }
          return leftClass === rightClass && left === right;
        }
        function shallowCopyInternalPointer(o) {
          return { count: o.count, deleteScheduled: o.deleteScheduled, preservePointerOnDelete: o.preservePointerOnDelete, ptr: o.ptr, ptrType: o.ptrType, smartPtr: o.smartPtr, smartPtrType: o.smartPtrType };
        }
        function throwInstanceAlreadyDeleted(obj) {
          function getInstanceTypeName(handle) {
            return handle.$$.ptrType.registeredClass.name;
          }
          throwBindingError(getInstanceTypeName(obj) + " instance already deleted");
        }
        var finalizationRegistry = false;
        function detachFinalizer(handle) {
        }
        function runDestructor($$) {
          if ($$.smartPtr) {
            $$.smartPtrType.rawDestructor($$.smartPtr);
          } else {
            $$.ptrType.registeredClass.rawDestructor($$.ptr);
          }
        }
        function releaseClassHandle($$) {
          $$.count.value -= 1;
          var toDelete = $$.count.value === 0;
          if (toDelete) {
            runDestructor($$);
          }
        }
        function downcastPointer(ptr, ptrClass, desiredClass) {
          if (ptrClass === desiredClass) {
            return ptr;
          }
          if (desiredClass.baseClass === void 0) {
            return null;
          }
          var rv = downcastPointer(ptr, ptrClass, desiredClass.baseClass);
          if (rv === null) {
            return null;
          }
          return desiredClass.downcast(rv);
        }
        var registeredPointers = {};
        function getInheritedInstanceCount() {
          return Object.keys(registeredInstances).length;
        }
        function getLiveInheritedInstances() {
          var rv = [];
          for (var k in registeredInstances) {
            if (registeredInstances.hasOwnProperty(k)) {
              rv.push(registeredInstances[k]);
            }
          }
          return rv;
        }
        var deletionQueue = [];
        function flushPendingDeletes() {
          while (deletionQueue.length) {
            var obj = deletionQueue.pop();
            obj.$$.deleteScheduled = false;
            obj["delete"]();
          }
        }
        var delayFunction = void 0;
        function setDelayFunction(fn) {
          delayFunction = fn;
          if (deletionQueue.length && delayFunction) {
            delayFunction(flushPendingDeletes);
          }
        }
        function init_embind() {
          Module["getInheritedInstanceCount"] = getInheritedInstanceCount;
          Module["getLiveInheritedInstances"] = getLiveInheritedInstances;
          Module["flushPendingDeletes"] = flushPendingDeletes;
          Module["setDelayFunction"] = setDelayFunction;
        }
        var registeredInstances = {};
        function getBasestPointer(class_, ptr) {
          if (ptr === void 0) {
            throwBindingError("ptr should not be undefined");
          }
          while (class_.baseClass) {
            ptr = class_.upcast(ptr);
            class_ = class_.baseClass;
          }
          return ptr;
        }
        function getInheritedInstance(class_, ptr) {
          ptr = getBasestPointer(class_, ptr);
          return registeredInstances[ptr];
        }
        function makeClassHandle(prototype, record) {
          if (!record.ptrType || !record.ptr) {
            throwInternalError("makeClassHandle requires ptr and ptrType");
          }
          var hasSmartPtrType = !!record.smartPtrType;
          var hasSmartPtr = !!record.smartPtr;
          if (hasSmartPtrType !== hasSmartPtr) {
            throwInternalError("Both smartPtrType and smartPtr must be specified");
          }
          record.count = { value: 1 };
          return attachFinalizer(Object.create(prototype, { $$: { value: record } }));
        }
        function RegisteredPointer_fromWireType(ptr) {
          var rawPointer = this.getPointee(ptr);
          if (!rawPointer) {
            this.destructor(ptr);
            return null;
          }
          var registeredInstance = getInheritedInstance(this.registeredClass, rawPointer);
          if (registeredInstance !== void 0) {
            if (registeredInstance.$$.count.value === 0) {
              registeredInstance.$$.ptr = rawPointer;
              registeredInstance.$$.smartPtr = ptr;
              return registeredInstance["clone"]();
            } else {
              var rv = registeredInstance["clone"]();
              this.destructor(ptr);
              return rv;
            }
          }
          function makeDefaultHandle() {
            if (this.isSmartPointer) {
              return makeClassHandle(this.registeredClass.instancePrototype, { ptrType: this.pointeeType, ptr: rawPointer, smartPtrType: this, smartPtr: ptr });
            } else {
              return makeClassHandle(this.registeredClass.instancePrototype, { ptrType: this, ptr });
            }
          }
          var actualType = this.registeredClass.getActualType(rawPointer);
          var registeredPointerRecord = registeredPointers[actualType];
          if (!registeredPointerRecord) {
            return makeDefaultHandle.call(this);
          }
          var toType;
          if (this.isConst) {
            toType = registeredPointerRecord.constPointerType;
          } else {
            toType = registeredPointerRecord.pointerType;
          }
          var dp = downcastPointer(rawPointer, this.registeredClass, toType.registeredClass);
          if (dp === null) {
            return makeDefaultHandle.call(this);
          }
          if (this.isSmartPointer) {
            return makeClassHandle(toType.registeredClass.instancePrototype, { ptrType: toType, ptr: dp, smartPtrType: this, smartPtr: ptr });
          } else {
            return makeClassHandle(toType.registeredClass.instancePrototype, { ptrType: toType, ptr: dp });
          }
        }
        var attachFinalizer = function(handle) {
          if (typeof FinalizationRegistry === "undefined") {
            attachFinalizer = (handle2) => handle2;
            return handle;
          }
          finalizationRegistry = new FinalizationRegistry((info) => {
            releaseClassHandle(info.$$);
          });
          attachFinalizer = (handle2) => {
            var $$ = handle2.$$;
            var hasSmartPtr = !!$$.smartPtr;
            if (hasSmartPtr) {
              var info = { $$ };
              finalizationRegistry.register(handle2, info, handle2);
            }
            return handle2;
          };
          detachFinalizer = (handle2) => finalizationRegistry.unregister(handle2);
          return attachFinalizer(handle);
        };
        function ClassHandle_clone() {
          if (!this.$$.ptr) {
            throwInstanceAlreadyDeleted(this);
          }
          if (this.$$.preservePointerOnDelete) {
            this.$$.count.value += 1;
            return this;
          } else {
            var clone = attachFinalizer(Object.create(Object.getPrototypeOf(this), { $$: { value: shallowCopyInternalPointer(this.$$) } }));
            clone.$$.count.value += 1;
            clone.$$.deleteScheduled = false;
            return clone;
          }
        }
        function ClassHandle_delete() {
          if (!this.$$.ptr) {
            throwInstanceAlreadyDeleted(this);
          }
          if (this.$$.deleteScheduled && !this.$$.preservePointerOnDelete) {
            throwBindingError("Object already scheduled for deletion");
          }
          detachFinalizer(this);
          releaseClassHandle(this.$$);
          if (!this.$$.preservePointerOnDelete) {
            this.$$.smartPtr = void 0;
            this.$$.ptr = void 0;
          }
        }
        function ClassHandle_isDeleted() {
          return !this.$$.ptr;
        }
        function ClassHandle_deleteLater() {
          if (!this.$$.ptr) {
            throwInstanceAlreadyDeleted(this);
          }
          if (this.$$.deleteScheduled && !this.$$.preservePointerOnDelete) {
            throwBindingError("Object already scheduled for deletion");
          }
          deletionQueue.push(this);
          if (deletionQueue.length === 1 && delayFunction) {
            delayFunction(flushPendingDeletes);
          }
          this.$$.deleteScheduled = true;
          return this;
        }
        function init_ClassHandle() {
          ClassHandle.prototype["isAliasOf"] = ClassHandle_isAliasOf;
          ClassHandle.prototype["clone"] = ClassHandle_clone;
          ClassHandle.prototype["delete"] = ClassHandle_delete;
          ClassHandle.prototype["isDeleted"] = ClassHandle_isDeleted;
          ClassHandle.prototype["deleteLater"] = ClassHandle_deleteLater;
        }
        function ClassHandle() {
        }
        var char_0 = 48;
        var char_9 = 57;
        function makeLegalFunctionName(name) {
          if (name === void 0) {
            return "_unknown";
          }
          name = name.replace(/[^a-zA-Z0-9_]/g, "$");
          var f = name.charCodeAt(0);
          if (f >= char_0 && f <= char_9) {
            return `_${name}`;
          }
          return name;
        }
        function createNamedFunction(name, body) {
          name = makeLegalFunctionName(name);
          return { [name]: function() {
            return body.apply(this, arguments);
          } }[name];
        }
        function ensureOverloadTable(proto, methodName, humanName) {
          if (proto[methodName].overloadTable === void 0) {
            var prevFunc = proto[methodName];
            proto[methodName] = function() {
              if (!proto[methodName].overloadTable.hasOwnProperty(arguments.length)) {
                throwBindingError(`Function '${humanName}' called with an invalid number of arguments (${arguments.length}) - expects one of (${proto[methodName].overloadTable})!`);
              }
              return proto[methodName].overloadTable[arguments.length].apply(this, arguments);
            };
            proto[methodName].overloadTable = [];
            proto[methodName].overloadTable[prevFunc.argCount] = prevFunc;
          }
        }
        function exposePublicSymbol(name, value, numArguments) {
          if (Module.hasOwnProperty(name)) {
            if (numArguments === void 0 || Module[name].overloadTable !== void 0 && Module[name].overloadTable[numArguments] !== void 0) {
              throwBindingError(`Cannot register public name '${name}' twice`);
            }
            ensureOverloadTable(Module, name, name);
            if (Module.hasOwnProperty(numArguments)) {
              throwBindingError(`Cannot register multiple overloads of a function with the same number of arguments (${numArguments})!`);
            }
            Module[name].overloadTable[numArguments] = value;
          } else {
            Module[name] = value;
            if (numArguments !== void 0) {
              Module[name].numArguments = numArguments;
            }
          }
        }
        function RegisteredClass(name, constructor, instancePrototype, rawDestructor, baseClass, getActualType, upcast, downcast) {
          this.name = name;
          this.constructor = constructor;
          this.instancePrototype = instancePrototype;
          this.rawDestructor = rawDestructor;
          this.baseClass = baseClass;
          this.getActualType = getActualType;
          this.upcast = upcast;
          this.downcast = downcast;
          this.pureVirtualFunctions = [];
        }
        function upcastPointer(ptr, ptrClass, desiredClass) {
          while (ptrClass !== desiredClass) {
            if (!ptrClass.upcast) {
              throwBindingError(`Expected null or instance of ${desiredClass.name}, got an instance of ${ptrClass.name}`);
            }
            ptr = ptrClass.upcast(ptr);
            ptrClass = ptrClass.baseClass;
          }
          return ptr;
        }
        function constNoSmartPtrRawPointerToWireType(destructors, handle) {
          if (handle === null) {
            if (this.isReference) {
              throwBindingError(`null is not a valid ${this.name}`);
            }
            return 0;
          }
          if (!handle.$$) {
            throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`);
          }
          if (!handle.$$.ptr) {
            throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`);
          }
          var handleClass = handle.$$.ptrType.registeredClass;
          var ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
          return ptr;
        }
        function genericPointerToWireType(destructors, handle) {
          var ptr;
          if (handle === null) {
            if (this.isReference) {
              throwBindingError(`null is not a valid ${this.name}`);
            }
            if (this.isSmartPointer) {
              ptr = this.rawConstructor();
              if (destructors !== null) {
                destructors.push(this.rawDestructor, ptr);
              }
              return ptr;
            } else {
              return 0;
            }
          }
          if (!handle.$$) {
            throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`);
          }
          if (!handle.$$.ptr) {
            throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`);
          }
          if (!this.isConst && handle.$$.ptrType.isConst) {
            throwBindingError(`Cannot convert argument of type ${handle.$$.smartPtrType ? handle.$$.smartPtrType.name : handle.$$.ptrType.name} to parameter type ${this.name}`);
          }
          var handleClass = handle.$$.ptrType.registeredClass;
          ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
          if (this.isSmartPointer) {
            if (handle.$$.smartPtr === void 0) {
              throwBindingError("Passing raw pointer to smart pointer is illegal");
            }
            switch (this.sharingPolicy) {
              case 0:
                if (handle.$$.smartPtrType === this) {
                  ptr = handle.$$.smartPtr;
                } else {
                  throwBindingError(`Cannot convert argument of type ${handle.$$.smartPtrType ? handle.$$.smartPtrType.name : handle.$$.ptrType.name} to parameter type ${this.name}`);
                }
                break;
              case 1:
                ptr = handle.$$.smartPtr;
                break;
              case 2:
                if (handle.$$.smartPtrType === this) {
                  ptr = handle.$$.smartPtr;
                } else {
                  var clonedHandle = handle["clone"]();
                  ptr = this.rawShare(ptr, Emval.toHandle(function() {
                    clonedHandle["delete"]();
                  }));
                  if (destructors !== null) {
                    destructors.push(this.rawDestructor, ptr);
                  }
                }
                break;
              default:
                throwBindingError("Unsupporting sharing policy");
            }
          }
          return ptr;
        }
        function nonConstNoSmartPtrRawPointerToWireType(destructors, handle) {
          if (handle === null) {
            if (this.isReference) {
              throwBindingError(`null is not a valid ${this.name}`);
            }
            return 0;
          }
          if (!handle.$$) {
            throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`);
          }
          if (!handle.$$.ptr) {
            throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`);
          }
          if (handle.$$.ptrType.isConst) {
            throwBindingError(`Cannot convert argument of type ${handle.$$.ptrType.name} to parameter type ${this.name}`);
          }
          var handleClass = handle.$$.ptrType.registeredClass;
          var ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
          return ptr;
        }
        function RegisteredPointer_getPointee(ptr) {
          if (this.rawGetPointee) {
            ptr = this.rawGetPointee(ptr);
          }
          return ptr;
        }
        function RegisteredPointer_destructor(ptr) {
          if (this.rawDestructor) {
            this.rawDestructor(ptr);
          }
        }
        function RegisteredPointer_deleteObject(handle) {
          if (handle !== null) {
            handle["delete"]();
          }
        }
        function init_RegisteredPointer() {
          RegisteredPointer.prototype.getPointee = RegisteredPointer_getPointee;
          RegisteredPointer.prototype.destructor = RegisteredPointer_destructor;
          RegisteredPointer.prototype["argPackAdvance"] = 8;
          RegisteredPointer.prototype["readValueFromPointer"] = simpleReadValueFromPointer;
          RegisteredPointer.prototype["deleteObject"] = RegisteredPointer_deleteObject;
          RegisteredPointer.prototype["fromWireType"] = RegisteredPointer_fromWireType;
        }
        function RegisteredPointer(name, registeredClass, isReference, isConst, isSmartPointer, pointeeType, sharingPolicy, rawGetPointee, rawConstructor, rawShare, rawDestructor) {
          this.name = name;
          this.registeredClass = registeredClass;
          this.isReference = isReference;
          this.isConst = isConst;
          this.isSmartPointer = isSmartPointer;
          this.pointeeType = pointeeType;
          this.sharingPolicy = sharingPolicy;
          this.rawGetPointee = rawGetPointee;
          this.rawConstructor = rawConstructor;
          this.rawShare = rawShare;
          this.rawDestructor = rawDestructor;
          if (!isSmartPointer && registeredClass.baseClass === void 0) {
            if (isConst) {
              this["toWireType"] = constNoSmartPtrRawPointerToWireType;
              this.destructorFunction = null;
            } else {
              this["toWireType"] = nonConstNoSmartPtrRawPointerToWireType;
              this.destructorFunction = null;
            }
          } else {
            this["toWireType"] = genericPointerToWireType;
          }
        }
        function replacePublicSymbol(name, value, numArguments) {
          if (!Module.hasOwnProperty(name)) {
            throwInternalError("Replacing nonexistant public symbol");
          }
          if (Module[name].overloadTable !== void 0 && numArguments !== void 0) {
            Module[name].overloadTable[numArguments] = value;
          } else {
            Module[name] = value;
            Module[name].argCount = numArguments;
          }
        }
        var dynCallLegacy = (sig, ptr, args) => {
          var f = Module["dynCall_" + sig];
          return args && args.length ? f.apply(null, [ptr].concat(args)) : f.call(null, ptr);
        };
        var dynCall = (sig, ptr, args) => {
          if (sig.includes("j")) {
            return dynCallLegacy(sig, ptr, args);
          }
          var rtn = getWasmTableEntry(ptr).apply(null, args);
          return rtn;
        };
        var getDynCaller = (sig, ptr) => {
          var argCache = [];
          return function() {
            argCache.length = 0;
            Object.assign(argCache, arguments);
            return dynCall(sig, ptr, argCache);
          };
        };
        function embind__requireFunction(signature, rawFunction) {
          signature = readLatin1String(signature);
          function makeDynCaller() {
            if (signature.includes("j")) {
              return getDynCaller(signature, rawFunction);
            }
            return getWasmTableEntry(rawFunction);
          }
          var fp = makeDynCaller();
          if (typeof fp != "function") {
            throwBindingError(`unknown function pointer with signature ${signature}: ${rawFunction}`);
          }
          return fp;
        }
        function extendError(baseErrorType, errorName) {
          var errorClass = createNamedFunction(errorName, function(message) {
            this.name = errorName;
            this.message = message;
            var stack = new Error(message).stack;
            if (stack !== void 0) {
              this.stack = this.toString() + "\n" + stack.replace(/^Error(:[^\n]*)?\n/, "");
            }
          });
          errorClass.prototype = Object.create(baseErrorType.prototype);
          errorClass.prototype.constructor = errorClass;
          errorClass.prototype.toString = function() {
            if (this.message === void 0) {
              return this.name;
            } else {
              return `${this.name}: ${this.message}`;
            }
          };
          return errorClass;
        }
        var UnboundTypeError = void 0;
        function getTypeName(type) {
          var ptr = ___getTypeName(type);
          var rv = readLatin1String(ptr);
          _free(ptr);
          return rv;
        }
        function throwUnboundTypeError(message, types) {
          var unboundTypes = [];
          var seen = {};
          function visit(type) {
            if (seen[type]) {
              return;
            }
            if (registeredTypes[type]) {
              return;
            }
            if (typeDependencies[type]) {
              typeDependencies[type].forEach(visit);
              return;
            }
            unboundTypes.push(type);
            seen[type] = true;
          }
          types.forEach(visit);
          throw new UnboundTypeError(`${message}: ` + unboundTypes.map(getTypeName).join([", "]));
        }
        function __embind_register_class(rawType, rawPointerType, rawConstPointerType, baseClassRawType, getActualTypeSignature, getActualType, upcastSignature, upcast, downcastSignature, downcast, name, destructorSignature, rawDestructor) {
          rawType >>>= 0;
          rawPointerType >>>= 0;
          rawConstPointerType >>>= 0;
          baseClassRawType >>>= 0;
          getActualTypeSignature >>>= 0;
          getActualType >>>= 0;
          upcastSignature >>>= 0;
          upcast >>>= 0;
          downcastSignature >>>= 0;
          downcast >>>= 0;
          name >>>= 0;
          destructorSignature >>>= 0;
          rawDestructor >>>= 0;
          name = readLatin1String(name);
          getActualType = embind__requireFunction(getActualTypeSignature, getActualType);
          if (upcast) {
            upcast = embind__requireFunction(upcastSignature, upcast);
          }
          if (downcast) {
            downcast = embind__requireFunction(downcastSignature, downcast);
          }
          rawDestructor = embind__requireFunction(destructorSignature, rawDestructor);
          var legalFunctionName = makeLegalFunctionName(name);
          exposePublicSymbol(legalFunctionName, function() {
            throwUnboundTypeError(`Cannot construct ${name} due to unbound types`, [baseClassRawType]);
          });
          whenDependentTypesAreResolved([rawType, rawPointerType, rawConstPointerType], baseClassRawType ? [baseClassRawType] : [], function(base) {
            base = base[0];
            var baseClass;
            var basePrototype;
            if (baseClassRawType) {
              baseClass = base.registeredClass;
              basePrototype = baseClass.instancePrototype;
            } else {
              basePrototype = ClassHandle.prototype;
            }
            var constructor = createNamedFunction(legalFunctionName, function() {
              if (Object.getPrototypeOf(this) !== instancePrototype) {
                throw new BindingError("Use 'new' to construct " + name);
              }
              if (registeredClass.constructor_body === void 0) {
                throw new BindingError(name + " has no accessible constructor");
              }
              var body = registeredClass.constructor_body[arguments.length];
              if (body === void 0) {
                throw new BindingError(`Tried to invoke ctor of ${name} with invalid number of parameters (${arguments.length}) - expected (${Object.keys(registeredClass.constructor_body).toString()}) parameters instead!`);
              }
              return body.apply(this, arguments);
            });
            var instancePrototype = Object.create(basePrototype, { constructor: { value: constructor } });
            constructor.prototype = instancePrototype;
            var registeredClass = new RegisteredClass(name, constructor, instancePrototype, rawDestructor, baseClass, getActualType, upcast, downcast);
            if (registeredClass.baseClass) {
              if (registeredClass.baseClass.__derivedClasses === void 0) {
                registeredClass.baseClass.__derivedClasses = [];
              }
              registeredClass.baseClass.__derivedClasses.push(registeredClass);
            }
            var referenceConverter = new RegisteredPointer(name, registeredClass, true, false, false);
            var pointerConverter = new RegisteredPointer(name + "*", registeredClass, false, false, false);
            var constPointerConverter = new RegisteredPointer(name + " const*", registeredClass, false, true, false);
            registeredPointers[rawType] = { pointerType: pointerConverter, constPointerType: constPointerConverter };
            replacePublicSymbol(legalFunctionName, constructor);
            return [referenceConverter, pointerConverter, constPointerConverter];
          });
        }
        function heap32VectorToArray(count, firstElement) {
          var array = [];
          for (var i = 0; i < count; i++) {
            array.push(GROWABLE_HEAP_U32()[firstElement + i * 4 >>> 2]);
          }
          return array;
        }
        function newFunc(constructor, argumentList) {
          if (!(constructor instanceof Function)) {
            throw new TypeError(`new_ called with constructor type ${typeof constructor} which is not a function`);
          }
          var dummy = createNamedFunction(constructor.name || "unknownFunctionName", function() {
          });
          dummy.prototype = constructor.prototype;
          var obj = new dummy();
          var r = constructor.apply(obj, argumentList);
          return r instanceof Object ? r : obj;
        }
        function craftInvokerFunction(humanName, argTypes, classType, cppInvokerFunc, cppTargetFunc, isAsync) {
          var argCount = argTypes.length;
          if (argCount < 2) {
            throwBindingError("argTypes array size mismatch! Must at least get return value and 'this' types!");
          }
          var isClassMethodFunc = argTypes[1] !== null && classType !== null;
          var needsDestructorStack = false;
          for (var i = 1; i < argTypes.length; ++i) {
            if (argTypes[i] !== null && argTypes[i].destructorFunction === void 0) {
              needsDestructorStack = true;
              break;
            }
          }
          var returns = argTypes[0].name !== "void";
          var argsList = "";
          var argsListWired = "";
          for (var i = 0; i < argCount - 2; ++i) {
            argsList += (i !== 0 ? ", " : "") + "arg" + i;
            argsListWired += (i !== 0 ? ", " : "") + "arg" + i + "Wired";
          }
          var invokerFnBody = `
        return function ${makeLegalFunctionName(humanName)}(${argsList}) {
        if (arguments.length !== ${argCount - 2}) {
          throwBindingError('function ${humanName} called with ${arguments.length} arguments, expected ${argCount - 2} args!');
        }`;
          if (needsDestructorStack) {
            invokerFnBody += "var destructors = [];\n";
          }
          var dtorStack = needsDestructorStack ? "destructors" : "null";
          var args1 = ["throwBindingError", "invoker", "fn", "runDestructors", "retType", "classParam"];
          var args2 = [throwBindingError, cppInvokerFunc, cppTargetFunc, runDestructors, argTypes[0], argTypes[1]];
          if (isClassMethodFunc) {
            invokerFnBody += "var thisWired = classParam.toWireType(" + dtorStack + ", this);\n";
          }
          for (var i = 0; i < argCount - 2; ++i) {
            invokerFnBody += "var arg" + i + "Wired = argType" + i + ".toWireType(" + dtorStack + ", arg" + i + "); // " + argTypes[i + 2].name + "\n";
            args1.push("argType" + i);
            args2.push(argTypes[i + 2]);
          }
          if (isClassMethodFunc) {
            argsListWired = "thisWired" + (argsListWired.length > 0 ? ", " : "") + argsListWired;
          }
          invokerFnBody += (returns || isAsync ? "var rv = " : "") + "invoker(fn" + (argsListWired.length > 0 ? ", " : "") + argsListWired + ");\n";
          if (needsDestructorStack) {
            invokerFnBody += "runDestructors(destructors);\n";
          } else {
            for (var i = isClassMethodFunc ? 1 : 2; i < argTypes.length; ++i) {
              var paramName = i === 1 ? "thisWired" : "arg" + (i - 2) + "Wired";
              if (argTypes[i].destructorFunction !== null) {
                invokerFnBody += paramName + "_dtor(" + paramName + "); // " + argTypes[i].name + "\n";
                args1.push(paramName + "_dtor");
                args2.push(argTypes[i].destructorFunction);
              }
            }
          }
          if (returns) {
            invokerFnBody += "var ret = retType.fromWireType(rv);\nreturn ret;\n";
          } else {
          }
          invokerFnBody += "}\n";
          args1.push(invokerFnBody);
          return newFunc(Function, args1).apply(null, args2);
        }
        function __embind_register_class_constructor(rawClassType, argCount, rawArgTypesAddr, invokerSignature, invoker, rawConstructor) {
          rawClassType >>>= 0;
          rawArgTypesAddr >>>= 0;
          invokerSignature >>>= 0;
          invoker >>>= 0;
          rawConstructor >>>= 0;
          var rawArgTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
          invoker = embind__requireFunction(invokerSignature, invoker);
          whenDependentTypesAreResolved([], [rawClassType], function(classType) {
            classType = classType[0];
            var humanName = `constructor ${classType.name}`;
            if (classType.registeredClass.constructor_body === void 0) {
              classType.registeredClass.constructor_body = [];
            }
            if (classType.registeredClass.constructor_body[argCount - 1] !== void 0) {
              throw new BindingError(`Cannot register multiple constructors with identical number of parameters (${argCount - 1}) for class '${classType.name}'! Overload resolution is currently only performed using the parameter count, not actual type info!`);
            }
            classType.registeredClass.constructor_body[argCount - 1] = () => {
              throwUnboundTypeError(`Cannot construct ${classType.name} due to unbound types`, rawArgTypes);
            };
            whenDependentTypesAreResolved([], rawArgTypes, function(argTypes) {
              argTypes.splice(1, 0, null);
              classType.registeredClass.constructor_body[argCount - 1] = craftInvokerFunction(humanName, argTypes, null, invoker, rawConstructor);
              return [];
            });
            return [];
          });
        }
        function __embind_register_class_function(rawClassType, methodName, argCount, rawArgTypesAddr, invokerSignature, rawInvoker, context, isPureVirtual, isAsync) {
          rawClassType >>>= 0;
          methodName >>>= 0;
          rawArgTypesAddr >>>= 0;
          invokerSignature >>>= 0;
          rawInvoker >>>= 0;
          context >>>= 0;
          var rawArgTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
          methodName = readLatin1String(methodName);
          rawInvoker = embind__requireFunction(invokerSignature, rawInvoker);
          whenDependentTypesAreResolved([], [rawClassType], function(classType) {
            classType = classType[0];
            var humanName = `${classType.name}.${methodName}`;
            if (methodName.startsWith("@@")) {
              methodName = Symbol[methodName.substring(2)];
            }
            if (isPureVirtual) {
              classType.registeredClass.pureVirtualFunctions.push(methodName);
            }
            function unboundTypesHandler() {
              throwUnboundTypeError(`Cannot call ${humanName} due to unbound types`, rawArgTypes);
            }
            var proto = classType.registeredClass.instancePrototype;
            var method = proto[methodName];
            if (method === void 0 || method.overloadTable === void 0 && method.className !== classType.name && method.argCount === argCount - 2) {
              unboundTypesHandler.argCount = argCount - 2;
              unboundTypesHandler.className = classType.name;
              proto[methodName] = unboundTypesHandler;
            } else {
              ensureOverloadTable(proto, methodName, humanName);
              proto[methodName].overloadTable[argCount - 2] = unboundTypesHandler;
            }
            whenDependentTypesAreResolved([], rawArgTypes, function(argTypes) {
              var memberFunction = craftInvokerFunction(humanName, argTypes, classType, rawInvoker, context, isAsync);
              if (proto[methodName].overloadTable === void 0) {
                memberFunction.argCount = argCount - 2;
                proto[methodName] = memberFunction;
              } else {
                proto[methodName].overloadTable[argCount - 2] = memberFunction;
              }
              return [];
            });
            return [];
          });
        }
        function handleAllocatorInit() {
          Object.assign(HandleAllocator.prototype, { get(id) {
            return this.allocated[id];
          }, has(id) {
            return this.allocated[id] !== void 0;
          }, allocate(handle) {
            var id = this.freelist.pop() || this.allocated.length;
            this.allocated[id] = handle;
            return id;
          }, free(id) {
            this.allocated[id] = void 0;
            this.freelist.push(id);
          } });
        }
        function HandleAllocator() {
          this.allocated = [void 0];
          this.freelist = [];
        }
        var emval_handles = new HandleAllocator();
        function __emval_decref(handle) {
          handle >>>= 0;
          if (handle >= emval_handles.reserved && --emval_handles.get(handle).refcount === 0) {
            emval_handles.free(handle);
          }
        }
        function count_emval_handles() {
          var count = 0;
          for (var i = emval_handles.reserved; i < emval_handles.allocated.length; ++i) {
            if (emval_handles.allocated[i] !== void 0) {
              ++count;
            }
          }
          return count;
        }
        function init_emval() {
          emval_handles.allocated.push({ value: void 0 }, { value: null }, { value: true }, { value: false });
          emval_handles.reserved = emval_handles.allocated.length;
          Module["count_emval_handles"] = count_emval_handles;
        }
        var Emval = { toValue: (handle) => {
          if (!handle) {
            throwBindingError("Cannot use deleted val. handle = " + handle);
          }
          return emval_handles.get(handle).value;
        }, toHandle: (value) => {
          switch (value) {
            case void 0:
              return 1;
            case null:
              return 2;
            case true:
              return 3;
            case false:
              return 4;
            default: {
              return emval_handles.allocate({ refcount: 1, value });
            }
          }
        } };
        function __embind_register_emval(rawType, name) {
          rawType >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": function(handle) {
            var rv = Emval.toValue(handle);
            __emval_decref(handle);
            return rv;
          }, "toWireType": function(destructors, value) {
            return Emval.toHandle(value);
          }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: null });
        }
        function embindRepr(v) {
          if (v === null) {
            return "null";
          }
          var t = typeof v;
          if (t === "object" || t === "array" || t === "function") {
            return v.toString();
          } else {
            return "" + v;
          }
        }
        function floatReadValueFromPointer(name, shift) {
          switch (shift) {
            case 2:
              return function(pointer) {
                return this["fromWireType"](GROWABLE_HEAP_F32()[pointer >>> 2]);
              };
            case 3:
              return function(pointer) {
                return this["fromWireType"](GROWABLE_HEAP_F64()[pointer >>> 3]);
              };
            default:
              throw new TypeError("Unknown float type: " + name);
          }
        }
        function __embind_register_float(rawType, name, size) {
          rawType >>>= 0;
          name >>>= 0;
          size >>>= 0;
          var shift = getShiftFromSize(size);
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": function(value) {
            return value;
          }, "toWireType": function(destructors, value) {
            return value;
          }, "argPackAdvance": 8, "readValueFromPointer": floatReadValueFromPointer(name, shift), destructorFunction: null });
        }
        function __embind_register_function(name, argCount, rawArgTypesAddr, signature, rawInvoker, fn, isAsync) {
          name >>>= 0;
          rawArgTypesAddr >>>= 0;
          signature >>>= 0;
          rawInvoker >>>= 0;
          fn >>>= 0;
          var argTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
          name = readLatin1String(name);
          rawInvoker = embind__requireFunction(signature, rawInvoker);
          exposePublicSymbol(name, function() {
            throwUnboundTypeError(`Cannot call ${name} due to unbound types`, argTypes);
          }, argCount - 1);
          whenDependentTypesAreResolved([], argTypes, function(argTypes2) {
            var invokerArgsArray = [argTypes2[0], null].concat(argTypes2.slice(1));
            replacePublicSymbol(name, craftInvokerFunction(name, invokerArgsArray, null, rawInvoker, fn, isAsync), argCount - 1);
            return [];
          });
        }
        function integerReadValueFromPointer(name, shift, signed) {
          switch (shift) {
            case 0:
              return signed ? function readS8FromPointer(pointer) {
                return GROWABLE_HEAP_I8()[pointer >>> 0];
              } : function readU8FromPointer(pointer) {
                return GROWABLE_HEAP_U8()[pointer >>> 0];
              };
            case 1:
              return signed ? function readS16FromPointer(pointer) {
                return GROWABLE_HEAP_I16()[pointer >>> 1];
              } : function readU16FromPointer(pointer) {
                return GROWABLE_HEAP_U16()[pointer >>> 1];
              };
            case 2:
              return signed ? function readS32FromPointer(pointer) {
                return GROWABLE_HEAP_I32()[pointer >>> 2];
              } : function readU32FromPointer(pointer) {
                return GROWABLE_HEAP_U32()[pointer >>> 2];
              };
            default:
              throw new TypeError("Unknown integer type: " + name);
          }
        }
        function __embind_register_integer(primitiveType, name, size, minRange, maxRange) {
          primitiveType >>>= 0;
          name >>>= 0;
          size >>>= 0;
          name = readLatin1String(name);
          if (maxRange === -1) {
            maxRange = 4294967295;
          }
          var shift = getShiftFromSize(size);
          var fromWireType = (value) => value;
          if (minRange === 0) {
            var bitshift = 32 - 8 * size;
            fromWireType = (value) => value << bitshift >>> bitshift;
          }
          var isUnsignedType = name.includes("unsigned");
          var checkAssertions = (value, toTypeName) => {
          };
          var toWireType;
          if (isUnsignedType) {
            toWireType = function(destructors, value) {
              checkAssertions(value, this.name);
              return value >>> 0;
            };
          } else {
            toWireType = function(destructors, value) {
              checkAssertions(value, this.name);
              return value;
            };
          }
          registerType(primitiveType, { name, "fromWireType": fromWireType, "toWireType": toWireType, "argPackAdvance": 8, "readValueFromPointer": integerReadValueFromPointer(name, shift, minRange !== 0), destructorFunction: null });
        }
        function __embind_register_memory_view(rawType, dataTypeIndex, name) {
          rawType >>>= 0;
          name >>>= 0;
          var typeMapping = [Int8Array, Uint8Array, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array, Float64Array];
          var TA = typeMapping[dataTypeIndex];
          function decodeMemoryView(handle) {
            handle = handle >> 2;
            var heap = GROWABLE_HEAP_U32();
            var size = heap[handle >>> 0];
            var data = heap[handle + 1 >>> 0];
            return new TA(heap.buffer, data, size);
          }
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": decodeMemoryView, "argPackAdvance": 8, "readValueFromPointer": decodeMemoryView }, { ignoreDuplicateRegistrations: true });
        }
        var stringToUTF8 = (str, outPtr, maxBytesToWrite) => stringToUTF8Array(str, GROWABLE_HEAP_U8(), outPtr, maxBytesToWrite);
        function __embind_register_std_string(rawType, name) {
          rawType >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          var stdStringIsUTF8 = name === "std::string";
          registerType(rawType, { name, "fromWireType": function(value) {
            var length = GROWABLE_HEAP_U32()[value >>> 2];
            var payload = value + 4;
            var str;
            if (stdStringIsUTF8) {
              var decodeStartPtr = payload;
              for (var i = 0; i <= length; ++i) {
                var currentBytePtr = payload + i;
                if (i == length || GROWABLE_HEAP_U8()[currentBytePtr >>> 0] == 0) {
                  var maxRead = currentBytePtr - decodeStartPtr;
                  var stringSegment = UTF8ToString(decodeStartPtr, maxRead);
                  if (str === void 0) {
                    str = stringSegment;
                  } else {
                    str += String.fromCharCode(0);
                    str += stringSegment;
                  }
                  decodeStartPtr = currentBytePtr + 1;
                }
              }
            } else {
              var a = new Array(length);
              for (var i = 0; i < length; ++i) {
                a[i] = String.fromCharCode(GROWABLE_HEAP_U8()[payload + i >>> 0]);
              }
              str = a.join("");
            }
            _free(value);
            return str;
          }, "toWireType": function(destructors, value) {
            if (value instanceof ArrayBuffer) {
              value = new Uint8Array(value);
            }
            var length;
            var valueIsOfTypeString = typeof value == "string";
            if (!(valueIsOfTypeString || value instanceof Uint8Array || value instanceof Uint8ClampedArray || value instanceof Int8Array)) {
              throwBindingError("Cannot pass non-string to std::string");
            }
            if (stdStringIsUTF8 && valueIsOfTypeString) {
              length = lengthBytesUTF8(value);
            } else {
              length = value.length;
            }
            var base = _malloc(4 + length + 1);
            var ptr = base + 4;
            GROWABLE_HEAP_U32()[base >>> 2] = length;
            if (stdStringIsUTF8 && valueIsOfTypeString) {
              stringToUTF8(value, ptr, length + 1);
            } else {
              if (valueIsOfTypeString) {
                for (var i = 0; i < length; ++i) {
                  var charCode = value.charCodeAt(i);
                  if (charCode > 255) {
                    _free(ptr);
                    throwBindingError("String has UTF-16 code units that do not fit in 8 bits");
                  }
                  GROWABLE_HEAP_U8()[ptr + i >>> 0] = charCode;
                }
              } else {
                for (var i = 0; i < length; ++i) {
                  GROWABLE_HEAP_U8()[ptr + i >>> 0] = value[i];
                }
              }
            }
            if (destructors !== null) {
              destructors.push(_free, base);
            }
            return base;
          }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: function(ptr) {
            _free(ptr);
          } });
        }
        var UTF16Decoder = typeof TextDecoder != "undefined" ? new TextDecoder("utf-16le") : void 0;
        var UTF16ToString = (ptr, maxBytesToRead) => {
          var endPtr = ptr;
          var idx = endPtr >> 1;
          var maxIdx = idx + maxBytesToRead / 2;
          while (!(idx >= maxIdx) && GROWABLE_HEAP_U16()[idx >>> 0])
            ++idx;
          endPtr = idx << 1;
          if (endPtr - ptr > 32 && UTF16Decoder)
            return UTF16Decoder.decode(GROWABLE_HEAP_U8().slice(ptr, endPtr));
          var str = "";
          for (var i = 0; !(i >= maxBytesToRead / 2); ++i) {
            var codeUnit = GROWABLE_HEAP_I16()[ptr + i * 2 >>> 1];
            if (codeUnit == 0)
              break;
            str += String.fromCharCode(codeUnit);
          }
          return str;
        };
        var stringToUTF16 = (str, outPtr, maxBytesToWrite) => {
          if (maxBytesToWrite === void 0) {
            maxBytesToWrite = 2147483647;
          }
          if (maxBytesToWrite < 2)
            return 0;
          maxBytesToWrite -= 2;
          var startPtr = outPtr;
          var numCharsToWrite = maxBytesToWrite < str.length * 2 ? maxBytesToWrite / 2 : str.length;
          for (var i = 0; i < numCharsToWrite; ++i) {
            var codeUnit = str.charCodeAt(i);
            GROWABLE_HEAP_I16()[outPtr >>> 1] = codeUnit;
            outPtr += 2;
          }
          GROWABLE_HEAP_I16()[outPtr >>> 1] = 0;
          return outPtr - startPtr;
        };
        var lengthBytesUTF16 = (str) => str.length * 2;
        var UTF32ToString = (ptr, maxBytesToRead) => {
          var i = 0;
          var str = "";
          while (!(i >= maxBytesToRead / 4)) {
            var utf32 = GROWABLE_HEAP_I32()[ptr + i * 4 >>> 2];
            if (utf32 == 0)
              break;
            ++i;
            if (utf32 >= 65536) {
              var ch = utf32 - 65536;
              str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
            } else {
              str += String.fromCharCode(utf32);
            }
          }
          return str;
        };
        var stringToUTF32 = (str, outPtr, maxBytesToWrite) => {
          outPtr >>>= 0;
          if (maxBytesToWrite === void 0) {
            maxBytesToWrite = 2147483647;
          }
          if (maxBytesToWrite < 4)
            return 0;
          var startPtr = outPtr;
          var endPtr = startPtr + maxBytesToWrite - 4;
          for (var i = 0; i < str.length; ++i) {
            var codeUnit = str.charCodeAt(i);
            if (codeUnit >= 55296 && codeUnit <= 57343) {
              var trailSurrogate = str.charCodeAt(++i);
              codeUnit = 65536 + ((codeUnit & 1023) << 10) | trailSurrogate & 1023;
            }
            GROWABLE_HEAP_I32()[outPtr >>> 2] = codeUnit;
            outPtr += 4;
            if (outPtr + 4 > endPtr)
              break;
          }
          GROWABLE_HEAP_I32()[outPtr >>> 2] = 0;
          return outPtr - startPtr;
        };
        var lengthBytesUTF32 = (str) => {
          var len = 0;
          for (var i = 0; i < str.length; ++i) {
            var codeUnit = str.charCodeAt(i);
            if (codeUnit >= 55296 && codeUnit <= 57343)
              ++i;
            len += 4;
          }
          return len;
        };
        var __embind_register_std_wstring = function(rawType, charSize, name) {
          rawType >>>= 0;
          charSize >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          var decodeString, encodeString, getHeap, lengthBytesUTF, shift;
          if (charSize === 2) {
            decodeString = UTF16ToString;
            encodeString = stringToUTF16;
            lengthBytesUTF = lengthBytesUTF16;
            getHeap = () => GROWABLE_HEAP_U16();
            shift = 1;
          } else if (charSize === 4) {
            decodeString = UTF32ToString;
            encodeString = stringToUTF32;
            lengthBytesUTF = lengthBytesUTF32;
            getHeap = () => GROWABLE_HEAP_U32();
            shift = 2;
          }
          registerType(rawType, { name, "fromWireType": function(value) {
            var length = GROWABLE_HEAP_U32()[value >>> 2];
            var HEAP = getHeap();
            var str;
            var decodeStartPtr = value + 4;
            for (var i = 0; i <= length; ++i) {
              var currentBytePtr = value + 4 + i * charSize;
              if (i == length || HEAP[currentBytePtr >>> shift] == 0) {
                var maxReadBytes = currentBytePtr - decodeStartPtr;
                var stringSegment = decodeString(decodeStartPtr, maxReadBytes);
                if (str === void 0) {
                  str = stringSegment;
                } else {
                  str += String.fromCharCode(0);
                  str += stringSegment;
                }
                decodeStartPtr = currentBytePtr + charSize;
              }
            }
            _free(value);
            return str;
          }, "toWireType": function(destructors, value) {
            if (!(typeof value == "string")) {
              throwBindingError(`Cannot pass non-string to C++ string type ${name}`);
            }
            var length = lengthBytesUTF(value);
            var ptr = _malloc(4 + length + charSize);
            GROWABLE_HEAP_U32()[ptr >>> 2] = length >> shift;
            encodeString(value, ptr + 4, length + charSize);
            if (destructors !== null) {
              destructors.push(_free, ptr);
            }
            return ptr;
          }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: function(ptr) {
            _free(ptr);
          } });
        };
        function __embind_register_value_array(rawType, name, constructorSignature, rawConstructor, destructorSignature, rawDestructor) {
          rawType >>>= 0;
          name >>>= 0;
          constructorSignature >>>= 0;
          rawConstructor >>>= 0;
          destructorSignature >>>= 0;
          rawDestructor >>>= 0;
          tupleRegistrations[rawType] = { name: readLatin1String(name), rawConstructor: embind__requireFunction(constructorSignature, rawConstructor), rawDestructor: embind__requireFunction(destructorSignature, rawDestructor), elements: [] };
        }
        function __embind_register_value_array_element(rawTupleType, getterReturnType, getterSignature, getter, getterContext, setterArgumentType, setterSignature, setter, setterContext) {
          rawTupleType >>>= 0;
          getterReturnType >>>= 0;
          getterSignature >>>= 0;
          getter >>>= 0;
          getterContext >>>= 0;
          setterArgumentType >>>= 0;
          setterSignature >>>= 0;
          setter >>>= 0;
          setterContext >>>= 0;
          tupleRegistrations[rawTupleType].elements.push({ getterReturnType, getter: embind__requireFunction(getterSignature, getter), getterContext, setterArgumentType, setter: embind__requireFunction(setterSignature, setter), setterContext });
        }
        function __embind_register_value_object(rawType, name, constructorSignature, rawConstructor, destructorSignature, rawDestructor) {
          rawType >>>= 0;
          name >>>= 0;
          constructorSignature >>>= 0;
          rawConstructor >>>= 0;
          destructorSignature >>>= 0;
          rawDestructor >>>= 0;
          structRegistrations[rawType] = { name: readLatin1String(name), rawConstructor: embind__requireFunction(constructorSignature, rawConstructor), rawDestructor: embind__requireFunction(destructorSignature, rawDestructor), fields: [] };
        }
        function __embind_register_value_object_field(structType, fieldName, getterReturnType, getterSignature, getter, getterContext, setterArgumentType, setterSignature, setter, setterContext) {
          structType >>>= 0;
          fieldName >>>= 0;
          getterReturnType >>>= 0;
          getterSignature >>>= 0;
          getter >>>= 0;
          getterContext >>>= 0;
          setterArgumentType >>>= 0;
          setterSignature >>>= 0;
          setter >>>= 0;
          setterContext >>>= 0;
          structRegistrations[structType].fields.push({ fieldName: readLatin1String(fieldName), getterReturnType, getter: embind__requireFunction(getterSignature, getter), getterContext, setterArgumentType, setter: embind__requireFunction(setterSignature, setter), setterContext });
        }
        function __embind_register_void(rawType, name) {
          rawType >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          registerType(rawType, { isVoid: true, name, "argPackAdvance": 0, "fromWireType": function() {
            return void 0;
          }, "toWireType": function(destructors, o) {
            return void 0;
          } });
        }
        var nowIsMonotonic = true;
        var __emscripten_get_now_is_monotonic = () => nowIsMonotonic;
        var maybeExit = () => {
          if (!keepRuntimeAlive()) {
            try {
              if (ENVIRONMENT_IS_PTHREAD)
                __emscripten_thread_exit(EXITSTATUS);
              else
                _exit(EXITSTATUS);
            } catch (e) {
              handleException(e);
            }
          }
        };
        var callUserCallback = (func) => {
          if (ABORT) {
            return;
          }
          try {
            func();
            maybeExit();
          } catch (e) {
            handleException(e);
          }
        };
        function __emscripten_thread_mailbox_await(pthread_ptr) {
          pthread_ptr >>>= 0;
          if (typeof Atomics.waitAsync === "function") {
            var wait = Atomics.waitAsync(GROWABLE_HEAP_I32(), pthread_ptr >> 2, pthread_ptr);
            wait.value.then(checkMailbox);
            var waitingAsync = pthread_ptr + 128;
            Atomics.store(GROWABLE_HEAP_I32(), waitingAsync >> 2, 1);
          }
        }
        Module["__emscripten_thread_mailbox_await"] = __emscripten_thread_mailbox_await;
        var checkMailbox = function() {
          var pthread_ptr = _pthread_self();
          if (pthread_ptr) {
            __emscripten_thread_mailbox_await(pthread_ptr);
            callUserCallback(() => __emscripten_check_mailbox());
          }
        };
        Module["checkMailbox"] = checkMailbox;
        var __emscripten_notify_mailbox_postmessage = function(targetThreadId, currThreadId, mainThreadId) {
          targetThreadId >>>= 0;
          currThreadId >>>= 0;
          mainThreadId >>>= 0;
          if (targetThreadId == currThreadId) {
            setTimeout(() => checkMailbox());
          } else if (ENVIRONMENT_IS_PTHREAD) {
            postMessage({ "targetThread": targetThreadId, "cmd": "checkMailbox" });
          } else {
            var worker = PThread.pthreads[targetThreadId];
            if (!worker) {
              return;
            }
            worker.postMessage({ "cmd": "checkMailbox" });
          }
        };
        function __emscripten_set_offscreencanvas_size(target, width, height) {
          target >>>= 0;
          return -1;
        }
        function __emscripten_thread_set_strongref(thread) {
          thread >>>= 0;
        }
        function requireRegisteredType(rawType, humanName) {
          var impl = registeredTypes[rawType];
          if (impl === void 0) {
            throwBindingError(humanName + " has unknown type " + getTypeName(rawType));
          }
          return impl;
        }
        function __emval_as(handle, returnType, destructorsRef) {
          handle >>>= 0;
          returnType >>>= 0;
          destructorsRef >>>= 0;
          handle = Emval.toValue(handle);
          returnType = requireRegisteredType(returnType, "emval::as");
          var destructors = [];
          var rd = Emval.toHandle(destructors);
          GROWABLE_HEAP_U32()[destructorsRef >>> 2] = rd;
          return returnType["toWireType"](destructors, handle);
        }
        function emval_lookupTypes(argCount, argTypes) {
          var a = new Array(argCount);
          for (var i = 0; i < argCount; ++i) {
            a[i] = requireRegisteredType(GROWABLE_HEAP_U32()[argTypes + i * 4 >>> 2], "parameter " + i);
          }
          return a;
        }
        function __emval_call(handle, argCount, argTypes, argv) {
          handle >>>= 0;
          argTypes >>>= 0;
          argv >>>= 0;
          handle = Emval.toValue(handle);
          var types = emval_lookupTypes(argCount, argTypes);
          var args = new Array(argCount);
          for (var i = 0; i < argCount; ++i) {
            var type = types[i];
            args[i] = type["readValueFromPointer"](argv);
            argv += type["argPackAdvance"];
          }
          var rv = handle.apply(void 0, args);
          return Emval.toHandle(rv);
        }
        var emval_symbols = {};
        function getStringOrSymbol(address) {
          var symbol = emval_symbols[address];
          if (symbol === void 0) {
            return readLatin1String(address);
          }
          return symbol;
        }
        function emval_get_global() {
          if (typeof globalThis == "object") {
            return globalThis;
          }
          return function() {
            return Function;
          }()("return this")();
        }
        function __emval_get_global(name) {
          name >>>= 0;
          if (name === 0) {
            return Emval.toHandle(emval_get_global());
          } else {
            name = getStringOrSymbol(name);
            return Emval.toHandle(emval_get_global()[name]);
          }
        }
        function __emval_get_property(handle, key) {
          handle >>>= 0;
          key >>>= 0;
          handle = Emval.toValue(handle);
          key = Emval.toValue(key);
          return Emval.toHandle(handle[key]);
        }
        function __emval_incref(handle) {
          handle >>>= 0;
          if (handle > 4) {
            emval_handles.get(handle).refcount += 1;
          }
        }
        function __emval_instanceof(object, constructor) {
          object >>>= 0;
          constructor >>>= 0;
          object = Emval.toValue(object);
          constructor = Emval.toValue(constructor);
          return object instanceof constructor;
        }
        function __emval_is_number(handle) {
          handle >>>= 0;
          handle = Emval.toValue(handle);
          return typeof handle == "number";
        }
        function __emval_is_string(handle) {
          handle >>>= 0;
          handle = Emval.toValue(handle);
          return typeof handle == "string";
        }
        function __emval_new_array() {
          return Emval.toHandle([]);
        }
        function __emval_new_cstring(v) {
          v >>>= 0;
          return Emval.toHandle(getStringOrSymbol(v));
        }
        function __emval_new_object() {
          return Emval.toHandle({});
        }
        function __emval_run_destructors(handle) {
          handle >>>= 0;
          var destructors = Emval.toValue(handle);
          runDestructors(destructors);
          __emval_decref(handle);
        }
        function __emval_set_property(handle, key, value) {
          handle >>>= 0;
          key >>>= 0;
          value >>>= 0;
          handle = Emval.toValue(handle);
          key = Emval.toValue(key);
          value = Emval.toValue(value);
          handle[key] = value;
        }
        function __emval_take_value(type, arg) {
          type >>>= 0;
          arg >>>= 0;
          type = requireRegisteredType(type, "_emval_take_value");
          var v = type["readValueFromPointer"](arg);
          return Emval.toHandle(v);
        }
        function __gmtime_js(time_low, time_high, tmPtr) {
          var time = convertI32PairToI53Checked(time_low, time_high);
          tmPtr >>>= 0;
          var date = new Date(time * 1e3);
          GROWABLE_HEAP_I32()[tmPtr >>> 2] = date.getUTCSeconds();
          GROWABLE_HEAP_I32()[tmPtr + 4 >>> 2] = date.getUTCMinutes();
          GROWABLE_HEAP_I32()[tmPtr + 8 >>> 2] = date.getUTCHours();
          GROWABLE_HEAP_I32()[tmPtr + 12 >>> 2] = date.getUTCDate();
          GROWABLE_HEAP_I32()[tmPtr + 16 >>> 2] = date.getUTCMonth();
          GROWABLE_HEAP_I32()[tmPtr + 20 >>> 2] = date.getUTCFullYear() - 1900;
          GROWABLE_HEAP_I32()[tmPtr + 24 >>> 2] = date.getUTCDay();
          var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
          var yday = (date.getTime() - start) / (1e3 * 60 * 60 * 24) | 0;
          GROWABLE_HEAP_I32()[tmPtr + 28 >>> 2] = yday;
        }
        var isLeapYear = (year) => year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
        var MONTH_DAYS_LEAP_CUMULATIVE = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335];
        var MONTH_DAYS_REGULAR_CUMULATIVE = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        var ydayFromDate = (date) => {
          var leap = isLeapYear(date.getFullYear());
          var monthDaysCumulative = leap ? MONTH_DAYS_LEAP_CUMULATIVE : MONTH_DAYS_REGULAR_CUMULATIVE;
          var yday = monthDaysCumulative[date.getMonth()] + date.getDate() - 1;
          return yday;
        };
        function __localtime_js(time_low, time_high, tmPtr) {
          var time = convertI32PairToI53Checked(time_low, time_high);
          tmPtr >>>= 0;
          var date = new Date(time * 1e3);
          GROWABLE_HEAP_I32()[tmPtr >>> 2] = date.getSeconds();
          GROWABLE_HEAP_I32()[tmPtr + 4 >>> 2] = date.getMinutes();
          GROWABLE_HEAP_I32()[tmPtr + 8 >>> 2] = date.getHours();
          GROWABLE_HEAP_I32()[tmPtr + 12 >>> 2] = date.getDate();
          GROWABLE_HEAP_I32()[tmPtr + 16 >>> 2] = date.getMonth();
          GROWABLE_HEAP_I32()[tmPtr + 20 >>> 2] = date.getFullYear() - 1900;
          GROWABLE_HEAP_I32()[tmPtr + 24 >>> 2] = date.getDay();
          var yday = ydayFromDate(date) | 0;
          GROWABLE_HEAP_I32()[tmPtr + 28 >>> 2] = yday;
          GROWABLE_HEAP_I32()[tmPtr + 36 >>> 2] = -(date.getTimezoneOffset() * 60);
          var start = new Date(date.getFullYear(), 0, 1);
          var summerOffset = new Date(date.getFullYear(), 6, 1).getTimezoneOffset();
          var winterOffset = start.getTimezoneOffset();
          var dst = (summerOffset != winterOffset && date.getTimezoneOffset() == Math.min(winterOffset, summerOffset)) | 0;
          GROWABLE_HEAP_I32()[tmPtr + 32 >>> 2] = dst;
        }
        var stringToNewUTF8 = (str) => {
          var size = lengthBytesUTF8(str) + 1;
          var ret = _malloc(size);
          if (ret)
            stringToUTF8(str, ret, size);
          return ret;
        };
        function __tzset_js(timezone, daylight, tzname) {
          timezone >>>= 0;
          daylight >>>= 0;
          tzname >>>= 0;
          var currentYear = new Date().getFullYear();
          var winter = new Date(currentYear, 0, 1);
          var summer = new Date(currentYear, 6, 1);
          var winterOffset = winter.getTimezoneOffset();
          var summerOffset = summer.getTimezoneOffset();
          var stdTimezoneOffset = Math.max(winterOffset, summerOffset);
          GROWABLE_HEAP_U32()[timezone >>> 2] = stdTimezoneOffset * 60;
          GROWABLE_HEAP_I32()[daylight >>> 2] = Number(winterOffset != summerOffset);
          function extractZone(date) {
            var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
            return match ? match[1] : "GMT";
          }
          var winterName = extractZone(winter);
          var summerName = extractZone(summer);
          var winterNamePtr = stringToNewUTF8(winterName);
          var summerNamePtr = stringToNewUTF8(summerName);
          if (summerOffset < winterOffset) {
            GROWABLE_HEAP_U32()[tzname >>> 2] = winterNamePtr;
            GROWABLE_HEAP_U32()[tzname + 4 >>> 2] = summerNamePtr;
          } else {
            GROWABLE_HEAP_U32()[tzname >>> 2] = summerNamePtr;
            GROWABLE_HEAP_U32()[tzname + 4 >>> 2] = winterNamePtr;
          }
        }
        var _abort = () => {
          abort("");
        };
        var warnOnce = (text) => {
          if (!warnOnce.shown)
            warnOnce.shown = {};
          if (!warnOnce.shown[text]) {
            warnOnce.shown[text] = 1;
            err(text);
          }
        };
        function _emscripten_check_blocking_allowed() {
        }
        function _emscripten_date_now() {
          return Date.now();
        }
        var runtimeKeepalivePush = () => {
          runtimeKeepaliveCounter += 1;
        };
        var _emscripten_exit_with_live_runtime = () => {
          runtimeKeepalivePush();
          throw "unwind";
        };
        var _emscripten_get_now;
        _emscripten_get_now = () => performance.timeOrigin + performance.now();
        var withStackSave = (f) => {
          var stack = stackSave();
          var ret = f();
          stackRestore(stack);
          return ret;
        };
        var proxyToMainThread = function(index, sync) {
          var numCallArgs = arguments.length - 2;
          var outerArgs = arguments;
          return withStackSave(() => {
            var serializedNumCallArgs = numCallArgs;
            var args = stackAlloc(serializedNumCallArgs * 8);
            var b = args >> 3;
            for (var i = 0; i < numCallArgs; i++) {
              var arg = outerArgs[2 + i];
              GROWABLE_HEAP_F64()[b + i >>> 0] = arg;
            }
            return __emscripten_run_in_main_runtime_thread_js(index, serializedNumCallArgs, args, sync);
          });
        };
        var emscripten_receive_on_main_thread_js_callArgs = [];
        function _emscripten_receive_on_main_thread_js(index, callingThread, numCallArgs, args) {
          callingThread >>>= 0;
          args >>>= 0;
          PThread.currentProxiedOperationCallerThread = callingThread;
          emscripten_receive_on_main_thread_js_callArgs.length = numCallArgs;
          var b = args >> 3;
          for (var i = 0; i < numCallArgs; i++) {
            emscripten_receive_on_main_thread_js_callArgs[i] = GROWABLE_HEAP_F64()[b + i >>> 0];
          }
          var func = proxiedFunctionTable[index];
          return func.apply(null, emscripten_receive_on_main_thread_js_callArgs);
        }
        var getHeapMax = () => 4294901760;
        var growMemory = (size) => {
          var b = wasmMemory.buffer;
          var pages = size - b.byteLength + 65535 >>> 16;
          try {
            wasmMemory.grow(pages);
            updateMemoryViews();
            return 1;
          } catch (e) {
          }
        };
        function _emscripten_resize_heap(requestedSize) {
          requestedSize >>>= 0;
          var oldSize = GROWABLE_HEAP_U8().length;
          if (requestedSize <= oldSize) {
            return false;
          }
          var maxHeapSize = getHeapMax();
          if (requestedSize > maxHeapSize) {
            return false;
          }
          var alignUp = (x, multiple) => x + (multiple - x % multiple) % multiple;
          for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {
            var overGrownHeapSize = oldSize * (1 + 0.2 / cutDown);
            overGrownHeapSize = Math.min(overGrownHeapSize, requestedSize + 100663296);
            var newSize = Math.min(maxHeapSize, alignUp(Math.max(requestedSize, overGrownHeapSize), 65536));
            var replacement = growMemory(newSize);
            if (replacement) {
              return true;
            }
          }
          return false;
        }
        var ENV = {};
        var getExecutableName = () => thisProgram || "./this.program";
        var getEnvStrings = () => {
          if (!getEnvStrings.strings) {
            var lang = (typeof navigator == "object" && navigator.languages && navigator.languages[0] || "C").replace("-", "_") + ".UTF-8";
            var env = { "USER": "web_user", "LOGNAME": "web_user", "PATH": "/", "PWD": "/", "HOME": "/home/web_user", "LANG": lang, "_": getExecutableName() };
            for (var x in ENV) {
              if (ENV[x] === void 0)
                delete env[x];
              else
                env[x] = ENV[x];
            }
            var strings = [];
            for (var x in env) {
              strings.push(`${x}=${env[x]}`);
            }
            getEnvStrings.strings = strings;
          }
          return getEnvStrings.strings;
        };
        var stringToAscii = (str, buffer) => {
          for (var i = 0; i < str.length; ++i) {
            GROWABLE_HEAP_I8()[buffer++ >>> 0] = str.charCodeAt(i);
          }
          GROWABLE_HEAP_I8()[buffer >>> 0] = 0;
        };
        function _environ_get(__environ, environ_buf) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(3, 1, __environ, environ_buf);
          __environ >>>= 0;
          environ_buf >>>= 0;
          var bufSize = 0;
          getEnvStrings().forEach(function(string, i) {
            var ptr = environ_buf + bufSize;
            GROWABLE_HEAP_U32()[__environ + i * 4 >>> 2] = ptr;
            stringToAscii(string, ptr);
            bufSize += string.length + 1;
          });
          return 0;
        }
        function _environ_sizes_get(penviron_count, penviron_buf_size) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(4, 1, penviron_count, penviron_buf_size);
          penviron_count >>>= 0;
          penviron_buf_size >>>= 0;
          var strings = getEnvStrings();
          GROWABLE_HEAP_U32()[penviron_count >>> 2] = strings.length;
          var bufSize = 0;
          strings.forEach(function(string) {
            bufSize += string.length + 1;
          });
          GROWABLE_HEAP_U32()[penviron_buf_size >>> 2] = bufSize;
          return 0;
        }
        function _fd_close(fd) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(5, 1, fd);
          try {
            var stream = SYSCALLS.getStreamFromFD(fd);
            FS.close(stream);
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        function _fd_fdstat_get(fd, pbuf) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(6, 1, fd, pbuf);
          pbuf >>>= 0;
          try {
            var rightsBase = 0;
            var rightsInheriting = 0;
            var flags = 0;
            {
              var stream = SYSCALLS.getStreamFromFD(fd);
              var type = stream.tty ? 2 : FS.isDir(stream.mode) ? 3 : FS.isLink(stream.mode) ? 7 : 4;
            }
            GROWABLE_HEAP_I8()[pbuf >>> 0] = type;
            GROWABLE_HEAP_I16()[pbuf + 2 >>> 1] = flags;
            tempI64 = [rightsBase >>> 0, (tempDouble = rightsBase, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[pbuf + 8 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[pbuf + 12 >>> 2] = tempI64[1];
            tempI64 = [rightsInheriting >>> 0, (tempDouble = rightsInheriting, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[pbuf + 16 >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[pbuf + 20 >>> 2] = tempI64[1];
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        var doReadv = (stream, iov, iovcnt, offset) => {
          var ret = 0;
          for (var i = 0; i < iovcnt; i++) {
            var ptr = GROWABLE_HEAP_U32()[iov >>> 2];
            var len = GROWABLE_HEAP_U32()[iov + 4 >>> 2];
            iov += 8;
            var curr = FS.read(stream, GROWABLE_HEAP_I8(), ptr, len, offset);
            if (curr < 0)
              return -1;
            ret += curr;
            if (curr < len)
              break;
            if (typeof offset !== "undefined") {
              offset += curr;
            }
          }
          return ret;
        };
        function _fd_read(fd, iov, iovcnt, pnum) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(7, 1, fd, iov, iovcnt, pnum);
          iov >>>= 0;
          iovcnt >>>= 0;
          pnum >>>= 0;
          try {
            var stream = SYSCALLS.getStreamFromFD(fd);
            var num = doReadv(stream, iov, iovcnt);
            GROWABLE_HEAP_U32()[pnum >>> 2] = num;
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        function _fd_seek(fd, offset_low, offset_high, whence, newOffset) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(8, 1, fd, offset_low, offset_high, whence, newOffset);
          var offset = convertI32PairToI53Checked(offset_low, offset_high);
          newOffset >>>= 0;
          try {
            if (isNaN(offset))
              return 61;
            var stream = SYSCALLS.getStreamFromFD(fd);
            FS.llseek(stream, offset, whence);
            tempI64 = [stream.position >>> 0, (tempDouble = stream.position, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], GROWABLE_HEAP_I32()[newOffset >>> 2] = tempI64[0], GROWABLE_HEAP_I32()[newOffset + 4 >>> 2] = tempI64[1];
            if (stream.getdents && offset === 0 && whence === 0)
              stream.getdents = null;
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        var doWritev = (stream, iov, iovcnt, offset) => {
          var ret = 0;
          for (var i = 0; i < iovcnt; i++) {
            var ptr = GROWABLE_HEAP_U32()[iov >>> 2];
            var len = GROWABLE_HEAP_U32()[iov + 4 >>> 2];
            iov += 8;
            var curr = FS.write(stream, GROWABLE_HEAP_I8(), ptr, len, offset);
            if (curr < 0)
              return -1;
            ret += curr;
            if (typeof offset !== "undefined") {
              offset += curr;
            }
          }
          return ret;
        };
        function _fd_write(fd, iov, iovcnt, pnum) {
          if (ENVIRONMENT_IS_PTHREAD)
            return proxyToMainThread(9, 1, fd, iov, iovcnt, pnum);
          iov >>>= 0;
          iovcnt >>>= 0;
          pnum >>>= 0;
          try {
            var stream = SYSCALLS.getStreamFromFD(fd);
            var num = doWritev(stream, iov, iovcnt);
            GROWABLE_HEAP_U32()[pnum >>> 2] = num;
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        var arraySum = (array, index) => {
          var sum = 0;
          for (var i = 0; i <= index; sum += array[i++]) {
          }
          return sum;
        };
        var MONTH_DAYS_LEAP = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        var MONTH_DAYS_REGULAR = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        var addDays = (date, days) => {
          var newDate = new Date(date.getTime());
          while (days > 0) {
            var leap = isLeapYear(newDate.getFullYear());
            var currentMonth = newDate.getMonth();
            var daysInCurrentMonth = (leap ? MONTH_DAYS_LEAP : MONTH_DAYS_REGULAR)[currentMonth];
            if (days > daysInCurrentMonth - newDate.getDate()) {
              days -= daysInCurrentMonth - newDate.getDate() + 1;
              newDate.setDate(1);
              if (currentMonth < 11) {
                newDate.setMonth(currentMonth + 1);
              } else {
                newDate.setMonth(0);
                newDate.setFullYear(newDate.getFullYear() + 1);
              }
            } else {
              newDate.setDate(newDate.getDate() + days);
              return newDate;
            }
          }
          return newDate;
        };
        var writeArrayToMemory = (array, buffer) => {
          GROWABLE_HEAP_I8().set(array, buffer >>> 0);
        };
        function _strftime(s, maxsize, format, tm) {
          s >>>= 0;
          maxsize >>>= 0;
          format >>>= 0;
          tm >>>= 0;
          var tm_zone = GROWABLE_HEAP_I32()[tm + 40 >>> 2];
          var date = { tm_sec: GROWABLE_HEAP_I32()[tm >>> 2], tm_min: GROWABLE_HEAP_I32()[tm + 4 >>> 2], tm_hour: GROWABLE_HEAP_I32()[tm + 8 >>> 2], tm_mday: GROWABLE_HEAP_I32()[tm + 12 >>> 2], tm_mon: GROWABLE_HEAP_I32()[tm + 16 >>> 2], tm_year: GROWABLE_HEAP_I32()[tm + 20 >>> 2], tm_wday: GROWABLE_HEAP_I32()[tm + 24 >>> 2], tm_yday: GROWABLE_HEAP_I32()[tm + 28 >>> 2], tm_isdst: GROWABLE_HEAP_I32()[tm + 32 >>> 2], tm_gmtoff: GROWABLE_HEAP_I32()[tm + 36 >>> 2], tm_zone: tm_zone ? UTF8ToString(tm_zone) : "" };
          var pattern = UTF8ToString(format);
          var EXPANSION_RULES_1 = { "%c": "%a %b %d %H:%M:%S %Y", "%D": "%m/%d/%y", "%F": "%Y-%m-%d", "%h": "%b", "%r": "%I:%M:%S %p", "%R": "%H:%M", "%T": "%H:%M:%S", "%x": "%m/%d/%y", "%X": "%H:%M:%S", "%Ec": "%c", "%EC": "%C", "%Ex": "%m/%d/%y", "%EX": "%H:%M:%S", "%Ey": "%y", "%EY": "%Y", "%Od": "%d", "%Oe": "%e", "%OH": "%H", "%OI": "%I", "%Om": "%m", "%OM": "%M", "%OS": "%S", "%Ou": "%u", "%OU": "%U", "%OV": "%V", "%Ow": "%w", "%OW": "%W", "%Oy": "%y" };
          for (var rule in EXPANSION_RULES_1) {
            pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_1[rule]);
          }
          var WEEKDAYS = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
          var MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
          function leadingSomething(value, digits, character) {
            var str = typeof value == "number" ? value.toString() : value || "";
            while (str.length < digits) {
              str = character[0] + str;
            }
            return str;
          }
          function leadingNulls(value, digits) {
            return leadingSomething(value, digits, "0");
          }
          function compareByDay(date1, date2) {
            function sgn(value) {
              return value < 0 ? -1 : value > 0 ? 1 : 0;
            }
            var compare;
            if ((compare = sgn(date1.getFullYear() - date2.getFullYear())) === 0) {
              if ((compare = sgn(date1.getMonth() - date2.getMonth())) === 0) {
                compare = sgn(date1.getDate() - date2.getDate());
              }
            }
            return compare;
          }
          function getFirstWeekStartDate(janFourth) {
            switch (janFourth.getDay()) {
              case 0:
                return new Date(janFourth.getFullYear() - 1, 11, 29);
              case 1:
                return janFourth;
              case 2:
                return new Date(janFourth.getFullYear(), 0, 3);
              case 3:
                return new Date(janFourth.getFullYear(), 0, 2);
              case 4:
                return new Date(janFourth.getFullYear(), 0, 1);
              case 5:
                return new Date(janFourth.getFullYear() - 1, 11, 31);
              case 6:
                return new Date(janFourth.getFullYear() - 1, 11, 30);
            }
          }
          function getWeekBasedYear(date2) {
            var thisDate = addDays(new Date(date2.tm_year + 1900, 0, 1), date2.tm_yday);
            var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
            var janFourthNextYear = new Date(thisDate.getFullYear() + 1, 0, 4);
            var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
            var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
            if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
              if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
                return thisDate.getFullYear() + 1;
              }
              return thisDate.getFullYear();
            }
            return thisDate.getFullYear() - 1;
          }
          var EXPANSION_RULES_2 = { "%a": (date2) => WEEKDAYS[date2.tm_wday].substring(0, 3), "%A": (date2) => WEEKDAYS[date2.tm_wday], "%b": (date2) => MONTHS[date2.tm_mon].substring(0, 3), "%B": (date2) => MONTHS[date2.tm_mon], "%C": (date2) => {
            var year = date2.tm_year + 1900;
            return leadingNulls(year / 100 | 0, 2);
          }, "%d": (date2) => leadingNulls(date2.tm_mday, 2), "%e": (date2) => leadingSomething(date2.tm_mday, 2, " "), "%g": (date2) => getWeekBasedYear(date2).toString().substring(2), "%G": (date2) => getWeekBasedYear(date2), "%H": (date2) => leadingNulls(date2.tm_hour, 2), "%I": (date2) => {
            var twelveHour = date2.tm_hour;
            if (twelveHour == 0)
              twelveHour = 12;
            else if (twelveHour > 12)
              twelveHour -= 12;
            return leadingNulls(twelveHour, 2);
          }, "%j": (date2) => leadingNulls(date2.tm_mday + arraySum(isLeapYear(date2.tm_year + 1900) ? MONTH_DAYS_LEAP : MONTH_DAYS_REGULAR, date2.tm_mon - 1), 3), "%m": (date2) => leadingNulls(date2.tm_mon + 1, 2), "%M": (date2) => leadingNulls(date2.tm_min, 2), "%n": () => "\n", "%p": (date2) => {
            if (date2.tm_hour >= 0 && date2.tm_hour < 12) {
              return "AM";
            }
            return "PM";
          }, "%S": (date2) => leadingNulls(date2.tm_sec, 2), "%t": () => "	", "%u": (date2) => date2.tm_wday || 7, "%U": (date2) => {
            var days = date2.tm_yday + 7 - date2.tm_wday;
            return leadingNulls(Math.floor(days / 7), 2);
          }, "%V": (date2) => {
            var val = Math.floor((date2.tm_yday + 7 - (date2.tm_wday + 6) % 7) / 7);
            if ((date2.tm_wday + 371 - date2.tm_yday - 2) % 7 <= 2) {
              val++;
            }
            if (!val) {
              val = 52;
              var dec31 = (date2.tm_wday + 7 - date2.tm_yday - 1) % 7;
              if (dec31 == 4 || dec31 == 5 && isLeapYear(date2.tm_year % 400 - 1)) {
                val++;
              }
            } else if (val == 53) {
              var jan1 = (date2.tm_wday + 371 - date2.tm_yday) % 7;
              if (jan1 != 4 && (jan1 != 3 || !isLeapYear(date2.tm_year)))
                val = 1;
            }
            return leadingNulls(val, 2);
          }, "%w": (date2) => date2.tm_wday, "%W": (date2) => {
            var days = date2.tm_yday + 7 - (date2.tm_wday + 6) % 7;
            return leadingNulls(Math.floor(days / 7), 2);
          }, "%y": (date2) => (date2.tm_year + 1900).toString().substring(2), "%Y": (date2) => date2.tm_year + 1900, "%z": (date2) => {
            var off = date2.tm_gmtoff;
            var ahead = off >= 0;
            off = Math.abs(off) / 60;
            off = off / 60 * 100 + off % 60;
            return (ahead ? "+" : "-") + String("0000" + off).slice(-4);
          }, "%Z": (date2) => date2.tm_zone, "%%": () => "%" };
          pattern = pattern.replace(/%%/g, "\0\0");
          for (var rule in EXPANSION_RULES_2) {
            if (pattern.includes(rule)) {
              pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_2[rule](date));
            }
          }
          pattern = pattern.replace(/\0\0/g, "%");
          var bytes = intArrayFromString(pattern, false);
          if (bytes.length > maxsize) {
            return 0;
          }
          writeArrayToMemory(bytes, s);
          return bytes.length - 1;
        }
        function _strftime_l(s, maxsize, format, tm, loc) {
          s >>>= 0;
          maxsize >>>= 0;
          format >>>= 0;
          tm >>>= 0;
          loc >>>= 0;
          return _strftime(s, maxsize, format, tm);
        }
        PThread.init();
        var FSNode = function(parent, name, mode, rdev) {
          if (!parent) {
            parent = this;
          }
          this.parent = parent;
          this.mount = parent.mount;
          this.mounted = null;
          this.id = FS.nextInode++;
          this.name = name;
          this.mode = mode;
          this.node_ops = {};
          this.stream_ops = {};
          this.rdev = rdev;
        };
        var readMode = 292 | 73;
        var writeMode = 146;
        Object.defineProperties(FSNode.prototype, { read: { get: function() {
          return (this.mode & readMode) === readMode;
        }, set: function(val) {
          val ? this.mode |= readMode : this.mode &= ~readMode;
        } }, write: { get: function() {
          return (this.mode & writeMode) === writeMode;
        }, set: function(val) {
          val ? this.mode |= writeMode : this.mode &= ~writeMode;
        } }, isFolder: { get: function() {
          return FS.isDir(this.mode);
        } }, isDevice: { get: function() {
          return FS.isChrdev(this.mode);
        } } });
        FS.FSNode = FSNode;
        FS.createPreloadedFile = FS_createPreloadedFile;
        FS.staticInit();
        InternalError = Module["InternalError"] = class InternalError extends Error {
          constructor(message) {
            super(message);
            this.name = "InternalError";
          }
        };
        embind_init_charCodes();
        BindingError = Module["BindingError"] = class BindingError extends Error {
          constructor(message) {
            super(message);
            this.name = "BindingError";
          }
        };
        init_ClassHandle();
        init_embind();
        init_RegisteredPointer();
        UnboundTypeError = Module["UnboundTypeError"] = extendError(Error, "UnboundTypeError");
        handleAllocatorInit();
        init_emval();
        var proxiedFunctionTable = [null, _proc_exit, exitOnMainThread, _environ_get, _environ_sizes_get, _fd_close, _fd_fdstat_get, _fd_read, _fd_seek, _fd_write];
        var wasmImports = { g: ___cxa_throw, Y: ___emscripten_init_main_thread_js, B: ___emscripten_thread_cleanup, fa: __embind_finalize_value_array, r: __embind_finalize_value_object, K: __embind_register_bigint, da: __embind_register_bool, q: __embind_register_class, p: __embind_register_class_constructor, c: __embind_register_class_function, ca: __embind_register_emval, D: __embind_register_float, d: __embind_register_function, t: __embind_register_integer, l: __embind_register_memory_view, E: __embind_register_std_string, y: __embind_register_std_wstring, ga: __embind_register_value_array, m: __embind_register_value_array_element, s: __embind_register_value_object, f: __embind_register_value_object_field, ea: __embind_register_void, T: __emscripten_get_now_is_monotonic, R: __emscripten_notify_mailbox_postmessage, W: __emscripten_set_offscreencanvas_size, X: __emscripten_thread_mailbox_await, ba: __emscripten_thread_set_strongref, k: __emval_as, x: __emval_call, b: __emval_decref, A: __emval_get_global, i: __emval_get_property, o: __emval_incref, G: __emval_instanceof, z: __emval_is_number, F: __emval_is_string, ha: __emval_new_array, h: __emval_new_cstring, v: __emval_new_object, j: __emval_run_destructors, n: __emval_set_property, e: __emval_take_value, I: __gmtime_js, J: __localtime_js, Q: __tzset_js, w: _abort, C: _emscripten_check_blocking_allowed, U: _emscripten_date_now, aa: _emscripten_exit_with_live_runtime, u: _emscripten_get_now, V: _emscripten_receive_on_main_thread_js, P: _emscripten_resize_heap, _: _environ_get, $: _environ_sizes_get, L: _exit, N: _fd_close, Z: _fd_fdstat_get, O: _fd_read, H: _fd_seek, S: _fd_write, a: wasmMemory || Module["wasmMemory"], M: _strftime_l };
        var asm = createWasm();
        var ___wasm_call_ctors = () => (___wasm_call_ctors = wasmExports["ia"])();
        var _pthread_self = Module["_pthread_self"] = () => (_pthread_self = Module["_pthread_self"] = wasmExports["ka"])();
        var _malloc = (a0) => (_malloc = wasmExports["la"])(a0);
        var __emscripten_tls_init = Module["__emscripten_tls_init"] = () => (__emscripten_tls_init = Module["__emscripten_tls_init"] = wasmExports["ma"])();
        var ___getTypeName = (a0) => (___getTypeName = wasmExports["na"])(a0);
        var __embind_initialize_bindings = Module["__embind_initialize_bindings"] = () => (__embind_initialize_bindings = Module["__embind_initialize_bindings"] = wasmExports["oa"])();
        var ___errno_location = () => (___errno_location = wasmExports["__errno_location"])();
        var __emscripten_thread_init = Module["__emscripten_thread_init"] = (a0, a1, a2, a3, a4, a5) => (__emscripten_thread_init = Module["__emscripten_thread_init"] = wasmExports["pa"])(a0, a1, a2, a3, a4, a5);
        var __emscripten_thread_crashed = Module["__emscripten_thread_crashed"] = () => (__emscripten_thread_crashed = Module["__emscripten_thread_crashed"] = wasmExports["qa"])();
        var _emscripten_main_thread_process_queued_calls = () => (_emscripten_main_thread_process_queued_calls = wasmExports["emscripten_main_thread_process_queued_calls"])();
        var _emscripten_main_runtime_thread_id = () => (_emscripten_main_runtime_thread_id = wasmExports["emscripten_main_runtime_thread_id"])();
        var __emscripten_run_in_main_runtime_thread_js = (a0, a1, a2, a3) => (__emscripten_run_in_main_runtime_thread_js = wasmExports["ra"])(a0, a1, a2, a3);
        var _emscripten_dispatch_to_thread_ = (a0, a1, a2, a3, a4) => (_emscripten_dispatch_to_thread_ = wasmExports["emscripten_dispatch_to_thread_"])(a0, a1, a2, a3, a4);
        var _free = (a0) => (_free = wasmExports["sa"])(a0);
        var __emscripten_thread_free_data = (a0) => (__emscripten_thread_free_data = wasmExports["ta"])(a0);
        var __emscripten_thread_exit = Module["__emscripten_thread_exit"] = (a0) => (__emscripten_thread_exit = Module["__emscripten_thread_exit"] = wasmExports["ua"])(a0);
        var __emscripten_check_mailbox = Module["__emscripten_check_mailbox"] = () => (__emscripten_check_mailbox = Module["__emscripten_check_mailbox"] = wasmExports["va"])();
        var _emscripten_stack_set_limits = (a0, a1) => (_emscripten_stack_set_limits = wasmExports["wa"])(a0, a1);
        var stackSave = () => (stackSave = wasmExports["xa"])();
        var stackRestore = (a0) => (stackRestore = wasmExports["ya"])(a0);
        var stackAlloc = (a0) => (stackAlloc = wasmExports["za"])(a0);
        var ___cxa_increment_exception_refcount = (a0) => (___cxa_increment_exception_refcount = wasmExports["__cxa_increment_exception_refcount"])(a0);
        var ___cxa_is_pointer_type = (a0) => (___cxa_is_pointer_type = wasmExports["Aa"])(a0);
        var dynCall_jiji = Module["dynCall_jiji"] = (a0, a1, a2, a3, a4) => (dynCall_jiji = Module["dynCall_jiji"] = wasmExports["Ba"])(a0, a1, a2, a3, a4);
        var dynCall_viijii = Module["dynCall_viijii"] = (a0, a1, a2, a3, a4, a5, a6) => (dynCall_viijii = Module["dynCall_viijii"] = wasmExports["Ca"])(a0, a1, a2, a3, a4, a5, a6);
        var dynCall_iiiiij = Module["dynCall_iiiiij"] = (a0, a1, a2, a3, a4, a5, a6) => (dynCall_iiiiij = Module["dynCall_iiiiij"] = wasmExports["Da"])(a0, a1, a2, a3, a4, a5, a6);
        var dynCall_iiiiijj = Module["dynCall_iiiiijj"] = (a0, a1, a2, a3, a4, a5, a6, a7, a8) => (dynCall_iiiiijj = Module["dynCall_iiiiijj"] = wasmExports["Ea"])(a0, a1, a2, a3, a4, a5, a6, a7, a8);
        var dynCall_iiiiiijj = Module["dynCall_iiiiiijj"] = (a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) => (dynCall_iiiiiijj = Module["dynCall_iiiiiijj"] = wasmExports["Fa"])(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        function applySignatureConversions(exports2) {
          exports2 = Object.assign({}, exports2);
          var makeWrapper_p = (f) => () => f() >>> 0;
          var makeWrapper_pp = (f) => (a0) => f(a0) >>> 0;
          exports2["pthread_self"] = makeWrapper_p(exports2["pthread_self"]);
          exports2["malloc"] = makeWrapper_pp(exports2["malloc"]);
          exports2["__getTypeName"] = makeWrapper_pp(exports2["__getTypeName"]);
          exports2["__errno_location"] = makeWrapper_p(exports2["__errno_location"]);
          exports2["stackSave"] = makeWrapper_p(exports2["stackSave"]);
          exports2["stackAlloc"] = makeWrapper_pp(exports2["stackAlloc"]);
          return exports2;
        }
        Module["keepRuntimeAlive"] = keepRuntimeAlive;
        Module["wasmMemory"] = wasmMemory;
        Module["ExitStatus"] = ExitStatus;
        Module["PThread"] = PThread;
        var calledRun;
        dependenciesFulfilled = function runCaller() {
          if (!calledRun)
            run();
          if (!calledRun)
            dependenciesFulfilled = runCaller;
        };
        function run() {
          if (runDependencies > 0) {
            return;
          }
          if (ENVIRONMENT_IS_PTHREAD) {
            readyPromiseResolve(Module);
            initRuntime();
            startWorker(Module);
            return;
          }
          preRun();
          if (runDependencies > 0) {
            return;
          }
          function doRun() {
            if (calledRun)
              return;
            calledRun = true;
            Module["calledRun"] = true;
            if (ABORT)
              return;
            initRuntime();
            readyPromiseResolve(Module);
            if (Module["onRuntimeInitialized"])
              Module["onRuntimeInitialized"]();
            postRun();
          }
          if (Module["setStatus"]) {
            Module["setStatus"]("Running...");
            setTimeout(function() {
              setTimeout(function() {
                Module["setStatus"]("");
              }, 1);
              doRun();
            }, 1);
          } else {
            doRun();
          }
        }
        if (Module["preInit"]) {
          if (typeof Module["preInit"] == "function")
            Module["preInit"] = [Module["preInit"]];
          while (Module["preInit"].length > 0) {
            Module["preInit"].pop()();
          }
        }
        run();
        return moduleArg.ready;
      };
    })();
    if (typeof exports === "object" && typeof module2 === "object")
      module2.exports = WebIFCWasm2;
    else if (typeof define === "function" && define["amd"])
      define([], () => WebIFCWasm2);
  }
});

// dist/web-ifc-node.js
var require_web_ifc_node = __commonJS({
  "dist/web-ifc-node.js"(exports, module2) {
    var WebIFCWasm2 = (() => {
      var _scriptDir = typeof document !== "undefined" && document.currentScript ? document.currentScript.src : void 0;
      if (typeof __filename !== "undefined")
        _scriptDir = _scriptDir || __filename;
      return function(moduleArg = {}) {
        var Module = moduleArg;
        var readyPromiseResolve, readyPromiseReject;
        Module["ready"] = new Promise((resolve, reject) => {
          readyPromiseResolve = resolve;
          readyPromiseReject = reject;
        });
        var moduleOverrides = Object.assign({}, Module);
        var arguments_ = [];
        var thisProgram = "./this.program";
        var quit_ = (status, toThrow) => {
          throw toThrow;
        };
        var ENVIRONMENT_IS_WEB = typeof window == "object";
        var ENVIRONMENT_IS_WORKER = typeof importScripts == "function";
        var ENVIRONMENT_IS_NODE = typeof process == "object" && typeof process.versions == "object" && typeof process.versions.node == "string";
        var scriptDirectory = "";
        function locateFile(path) {
          if (Module["locateFile"]) {
            return Module["locateFile"](path, scriptDirectory);
          }
          return scriptDirectory + path;
        }
        var read_, readAsync, readBinary, setWindowTitle;
        if (ENVIRONMENT_IS_NODE) {
          var fs = require("fs");
          var nodePath = require("path");
          if (ENVIRONMENT_IS_WORKER) {
            scriptDirectory = nodePath.dirname(scriptDirectory) + "/";
          } else {
            scriptDirectory = __dirname + "/";
          }
          read_ = (filename, binary) => {
            filename = isFileURI(filename) ? new URL(filename) : nodePath.normalize(filename);
            return fs.readFileSync(filename, binary ? void 0 : "utf8");
          };
          readBinary = (filename) => {
            var ret = read_(filename, true);
            if (!ret.buffer) {
              ret = new Uint8Array(ret);
            }
            return ret;
          };
          readAsync = (filename, onload, onerror, binary = true) => {
            filename = isFileURI(filename) ? new URL(filename) : nodePath.normalize(filename);
            fs.readFile(filename, binary ? void 0 : "utf8", (err2, data) => {
              if (err2)
                onerror(err2);
              else
                onload(binary ? data.buffer : data);
            });
          };
          if (!Module["thisProgram"] && process.argv.length > 1) {
            thisProgram = process.argv[1].replace(/\\/g, "/");
          }
          arguments_ = process.argv.slice(2);
          quit_ = (status, toThrow) => {
            process.exitCode = status;
            throw toThrow;
          };
          Module["inspect"] = () => "[Emscripten Module object]";
        } else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
          if (ENVIRONMENT_IS_WORKER) {
            scriptDirectory = self.location.href;
          } else if (typeof document != "undefined" && document.currentScript) {
            scriptDirectory = document.currentScript.src;
          }
          if (_scriptDir) {
            scriptDirectory = _scriptDir;
          }
          if (scriptDirectory.indexOf("blob:") !== 0) {
            scriptDirectory = scriptDirectory.substr(0, scriptDirectory.replace(/[?#].*/, "").lastIndexOf("/") + 1);
          } else {
            scriptDirectory = "";
          }
          {
            read_ = (url) => {
              var xhr = new XMLHttpRequest();
              xhr.open("GET", url, false);
              xhr.send(null);
              return xhr.responseText;
            };
            if (ENVIRONMENT_IS_WORKER) {
              readBinary = (url) => {
                var xhr = new XMLHttpRequest();
                xhr.open("GET", url, false);
                xhr.responseType = "arraybuffer";
                xhr.send(null);
                return new Uint8Array(xhr.response);
              };
            }
            readAsync = (url, onload, onerror) => {
              var xhr = new XMLHttpRequest();
              xhr.open("GET", url, true);
              xhr.responseType = "arraybuffer";
              xhr.onload = () => {
                if (xhr.status == 200 || xhr.status == 0 && xhr.response) {
                  onload(xhr.response);
                  return;
                }
                onerror();
              };
              xhr.onerror = onerror;
              xhr.send(null);
            };
          }
          setWindowTitle = (title) => document.title = title;
        } else {
        }
        var out = Module["print"] || console.log.bind(console);
        var err = Module["printErr"] || console.error.bind(console);
        Object.assign(Module, moduleOverrides);
        moduleOverrides = null;
        if (Module["arguments"])
          arguments_ = Module["arguments"];
        if (Module["thisProgram"])
          thisProgram = Module["thisProgram"];
        if (Module["quit"])
          quit_ = Module["quit"];
        var wasmBinary;
        if (Module["wasmBinary"])
          wasmBinary = Module["wasmBinary"];
        var noExitRuntime = Module["noExitRuntime"] || true;
        if (typeof WebAssembly != "object") {
          abort("no native wasm support detected");
        }
        var wasmMemory;
        var wasmExports;
        var ABORT = false;
        var EXITSTATUS;
        function assert(condition, text) {
          if (!condition) {
            abort(text);
          }
        }
        var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
        function updateMemoryViews() {
          var b = wasmMemory.buffer;
          Module["HEAP8"] = HEAP8 = new Int8Array(b);
          Module["HEAP16"] = HEAP16 = new Int16Array(b);
          Module["HEAP32"] = HEAP32 = new Int32Array(b);
          Module["HEAPU8"] = HEAPU8 = new Uint8Array(b);
          Module["HEAPU16"] = HEAPU16 = new Uint16Array(b);
          Module["HEAPU32"] = HEAPU32 = new Uint32Array(b);
          Module["HEAPF32"] = HEAPF32 = new Float32Array(b);
          Module["HEAPF64"] = HEAPF64 = new Float64Array(b);
        }
        var wasmTable;
        var __ATPRERUN__ = [];
        var __ATINIT__ = [];
        var __ATPOSTRUN__ = [];
        var runtimeInitialized = false;
        function preRun() {
          if (Module["preRun"]) {
            if (typeof Module["preRun"] == "function")
              Module["preRun"] = [Module["preRun"]];
            while (Module["preRun"].length) {
              addOnPreRun(Module["preRun"].shift());
            }
          }
          callRuntimeCallbacks(__ATPRERUN__);
        }
        function initRuntime() {
          runtimeInitialized = true;
          if (!Module["noFSInit"] && !FS.init.initialized)
            FS.init();
          FS.ignorePermissions = false;
          TTY.init();
          callRuntimeCallbacks(__ATINIT__);
        }
        function postRun() {
          if (Module["postRun"]) {
            if (typeof Module["postRun"] == "function")
              Module["postRun"] = [Module["postRun"]];
            while (Module["postRun"].length) {
              addOnPostRun(Module["postRun"].shift());
            }
          }
          callRuntimeCallbacks(__ATPOSTRUN__);
        }
        function addOnPreRun(cb) {
          __ATPRERUN__.unshift(cb);
        }
        function addOnInit(cb) {
          __ATINIT__.unshift(cb);
        }
        function addOnPostRun(cb) {
          __ATPOSTRUN__.unshift(cb);
        }
        var runDependencies = 0;
        var runDependencyWatcher = null;
        var dependenciesFulfilled = null;
        function getUniqueRunDependency(id) {
          return id;
        }
        function addRunDependency(id) {
          runDependencies++;
          if (Module["monitorRunDependencies"]) {
            Module["monitorRunDependencies"](runDependencies);
          }
        }
        function removeRunDependency(id) {
          runDependencies--;
          if (Module["monitorRunDependencies"]) {
            Module["monitorRunDependencies"](runDependencies);
          }
          if (runDependencies == 0) {
            if (runDependencyWatcher !== null) {
              clearInterval(runDependencyWatcher);
              runDependencyWatcher = null;
            }
            if (dependenciesFulfilled) {
              var callback = dependenciesFulfilled;
              dependenciesFulfilled = null;
              callback();
            }
          }
        }
        function abort(what) {
          if (Module["onAbort"]) {
            Module["onAbort"](what);
          }
          what = "Aborted(" + what + ")";
          err(what);
          ABORT = true;
          EXITSTATUS = 1;
          what += ". Build with -sASSERTIONS for more info.";
          var e = new WebAssembly.RuntimeError(what);
          readyPromiseReject(e);
          throw e;
        }
        var dataURIPrefix = "data:application/octet-stream;base64,";
        function isDataURI(filename) {
          return filename.startsWith(dataURIPrefix);
        }
        function isFileURI(filename) {
          return filename.startsWith("file://");
        }
        var wasmBinaryFile;
        wasmBinaryFile = "web-ifc-node.wasm";
        if (!isDataURI(wasmBinaryFile)) {
          wasmBinaryFile = locateFile(wasmBinaryFile);
        }
        function getBinarySync(file) {
          if (file == wasmBinaryFile && wasmBinary) {
            return new Uint8Array(wasmBinary);
          }
          if (readBinary) {
            return readBinary(file);
          }
          throw "both async and sync fetching of the wasm failed";
        }
        function getBinaryPromise(binaryFile) {
          if (!wasmBinary && (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER)) {
            if (typeof fetch == "function" && !isFileURI(binaryFile)) {
              return fetch(binaryFile, { credentials: "same-origin" }).then((response) => {
                if (!response["ok"]) {
                  throw "failed to load wasm binary file at '" + binaryFile + "'";
                }
                return response["arrayBuffer"]();
              }).catch(() => getBinarySync(binaryFile));
            } else if (readAsync) {
              return new Promise((resolve, reject) => {
                readAsync(binaryFile, (response) => resolve(new Uint8Array(response)), reject);
              });
            }
          }
          return Promise.resolve().then(() => getBinarySync(binaryFile));
        }
        function instantiateArrayBuffer(binaryFile, imports, receiver) {
          return getBinaryPromise(binaryFile).then((binary) => WebAssembly.instantiate(binary, imports)).then((instance) => instance).then(receiver, (reason) => {
            err("failed to asynchronously prepare wasm: " + reason);
            abort(reason);
          });
        }
        function instantiateAsync(binary, binaryFile, imports, callback) {
          if (!binary && typeof WebAssembly.instantiateStreaming == "function" && !isDataURI(binaryFile) && !isFileURI(binaryFile) && !ENVIRONMENT_IS_NODE && typeof fetch == "function") {
            return fetch(binaryFile, { credentials: "same-origin" }).then((response) => {
              var result = WebAssembly.instantiateStreaming(response, imports);
              return result.then(callback, function(reason) {
                err("wasm streaming compile failed: " + reason);
                err("falling back to ArrayBuffer instantiation");
                return instantiateArrayBuffer(binaryFile, imports, callback);
              });
            });
          }
          return instantiateArrayBuffer(binaryFile, imports, callback);
        }
        function createWasm() {
          var info = { "a": wasmImports };
          function receiveInstance(instance, module3) {
            var exports2 = instance.exports;
            exports2 = applySignatureConversions(exports2);
            wasmExports = exports2;
            wasmMemory = wasmExports["Z"];
            updateMemoryViews();
            wasmTable = wasmExports["$"];
            addOnInit(wasmExports["_"]);
            removeRunDependency("wasm-instantiate");
            return exports2;
          }
          addRunDependency("wasm-instantiate");
          function receiveInstantiationResult(result) {
            receiveInstance(result["instance"]);
          }
          if (Module["instantiateWasm"]) {
            try {
              return Module["instantiateWasm"](info, receiveInstance);
            } catch (e) {
              err("Module.instantiateWasm callback failed with error: " + e);
              readyPromiseReject(e);
            }
          }
          instantiateAsync(wasmBinary, wasmBinaryFile, info, receiveInstantiationResult).catch(readyPromiseReject);
          return {};
        }
        var tempDouble;
        var tempI64;
        var callRuntimeCallbacks = (callbacks) => {
          while (callbacks.length > 0) {
            callbacks.shift()(Module);
          }
        };
        function ExceptionInfo(excPtr) {
          this.excPtr = excPtr;
          this.ptr = excPtr - 24;
          this.set_type = function(type) {
            HEAPU32[this.ptr + 4 >>> 2] = type;
          };
          this.get_type = function() {
            return HEAPU32[this.ptr + 4 >>> 2];
          };
          this.set_destructor = function(destructor) {
            HEAPU32[this.ptr + 8 >>> 2] = destructor;
          };
          this.get_destructor = function() {
            return HEAPU32[this.ptr + 8 >>> 2];
          };
          this.set_caught = function(caught) {
            caught = caught ? 1 : 0;
            HEAP8[this.ptr + 12 >>> 0] = caught;
          };
          this.get_caught = function() {
            return HEAP8[this.ptr + 12 >>> 0] != 0;
          };
          this.set_rethrown = function(rethrown) {
            rethrown = rethrown ? 1 : 0;
            HEAP8[this.ptr + 13 >>> 0] = rethrown;
          };
          this.get_rethrown = function() {
            return HEAP8[this.ptr + 13 >>> 0] != 0;
          };
          this.init = function(type, destructor) {
            this.set_adjusted_ptr(0);
            this.set_type(type);
            this.set_destructor(destructor);
          };
          this.set_adjusted_ptr = function(adjustedPtr) {
            HEAPU32[this.ptr + 16 >>> 2] = adjustedPtr;
          };
          this.get_adjusted_ptr = function() {
            return HEAPU32[this.ptr + 16 >>> 2];
          };
          this.get_exception_ptr = function() {
            var isPointer = ___cxa_is_pointer_type(this.get_type());
            if (isPointer) {
              return HEAPU32[this.excPtr >>> 2];
            }
            var adjusted = this.get_adjusted_ptr();
            if (adjusted !== 0)
              return adjusted;
            return this.excPtr;
          };
        }
        var exceptionLast = 0;
        var uncaughtExceptionCount = 0;
        function convertI32PairToI53Checked(lo, hi) {
          return hi + 2097152 >>> 0 < 4194305 - !!lo ? (lo >>> 0) + hi * 4294967296 : NaN;
        }
        function ___cxa_throw(ptr, type, destructor) {
          ptr >>>= 0;
          type >>>= 0;
          destructor >>>= 0;
          var info = new ExceptionInfo(ptr);
          info.init(type, destructor);
          exceptionLast = ptr;
          uncaughtExceptionCount++;
          throw exceptionLast;
        }
        var tupleRegistrations = {};
        function runDestructors(destructors) {
          while (destructors.length) {
            var ptr = destructors.pop();
            var del = destructors.pop();
            del(ptr);
          }
        }
        function simpleReadValueFromPointer(pointer) {
          return this["fromWireType"](HEAP32[pointer >>> 2]);
        }
        var awaitingDependencies = {};
        var registeredTypes = {};
        var typeDependencies = {};
        var InternalError = void 0;
        function throwInternalError(message) {
          throw new InternalError(message);
        }
        function whenDependentTypesAreResolved(myTypes, dependentTypes, getTypeConverters) {
          myTypes.forEach(function(type) {
            typeDependencies[type] = dependentTypes;
          });
          function onComplete(typeConverters2) {
            var myTypeConverters = getTypeConverters(typeConverters2);
            if (myTypeConverters.length !== myTypes.length) {
              throwInternalError("Mismatched type converter count");
            }
            for (var i = 0; i < myTypes.length; ++i) {
              registerType(myTypes[i], myTypeConverters[i]);
            }
          }
          var typeConverters = new Array(dependentTypes.length);
          var unregisteredTypes = [];
          var registered = 0;
          dependentTypes.forEach((dt, i) => {
            if (registeredTypes.hasOwnProperty(dt)) {
              typeConverters[i] = registeredTypes[dt];
            } else {
              unregisteredTypes.push(dt);
              if (!awaitingDependencies.hasOwnProperty(dt)) {
                awaitingDependencies[dt] = [];
              }
              awaitingDependencies[dt].push(() => {
                typeConverters[i] = registeredTypes[dt];
                ++registered;
                if (registered === unregisteredTypes.length) {
                  onComplete(typeConverters);
                }
              });
            }
          });
          if (unregisteredTypes.length === 0) {
            onComplete(typeConverters);
          }
        }
        function __embind_finalize_value_array(rawTupleType) {
          rawTupleType >>>= 0;
          var reg = tupleRegistrations[rawTupleType];
          delete tupleRegistrations[rawTupleType];
          var elements = reg.elements;
          var elementsLength = elements.length;
          var elementTypes = elements.map(function(elt) {
            return elt.getterReturnType;
          }).concat(elements.map(function(elt) {
            return elt.setterArgumentType;
          }));
          var rawConstructor = reg.rawConstructor;
          var rawDestructor = reg.rawDestructor;
          whenDependentTypesAreResolved([rawTupleType], elementTypes, function(elementTypes2) {
            elements.forEach((elt, i) => {
              var getterReturnType = elementTypes2[i];
              var getter = elt.getter;
              var getterContext = elt.getterContext;
              var setterArgumentType = elementTypes2[i + elementsLength];
              var setter = elt.setter;
              var setterContext = elt.setterContext;
              elt.read = (ptr) => getterReturnType["fromWireType"](getter(getterContext, ptr));
              elt.write = (ptr, o) => {
                var destructors = [];
                setter(setterContext, ptr, setterArgumentType["toWireType"](destructors, o));
                runDestructors(destructors);
              };
            });
            return [{ name: reg.name, "fromWireType": function(ptr) {
              var rv = new Array(elementsLength);
              for (var i = 0; i < elementsLength; ++i) {
                rv[i] = elements[i].read(ptr);
              }
              rawDestructor(ptr);
              return rv;
            }, "toWireType": function(destructors, o) {
              if (elementsLength !== o.length) {
                throw new TypeError(`Incorrect number of tuple elements for ${reg.name}: expected=${elementsLength}, actual=${o.length}`);
              }
              var ptr = rawConstructor();
              for (var i = 0; i < elementsLength; ++i) {
                elements[i].write(ptr, o[i]);
              }
              if (destructors !== null) {
                destructors.push(rawDestructor, ptr);
              }
              return ptr;
            }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: rawDestructor }];
          });
        }
        var structRegistrations = {};
        var __embind_finalize_value_object = function(structType) {
          structType >>>= 0;
          var reg = structRegistrations[structType];
          delete structRegistrations[structType];
          var rawConstructor = reg.rawConstructor;
          var rawDestructor = reg.rawDestructor;
          var fieldRecords = reg.fields;
          var fieldTypes = fieldRecords.map((field) => field.getterReturnType).concat(fieldRecords.map((field) => field.setterArgumentType));
          whenDependentTypesAreResolved([structType], fieldTypes, (fieldTypes2) => {
            var fields = {};
            fieldRecords.forEach((field, i) => {
              var fieldName = field.fieldName;
              var getterReturnType = fieldTypes2[i];
              var getter = field.getter;
              var getterContext = field.getterContext;
              var setterArgumentType = fieldTypes2[i + fieldRecords.length];
              var setter = field.setter;
              var setterContext = field.setterContext;
              fields[fieldName] = { read: (ptr) => getterReturnType["fromWireType"](getter(getterContext, ptr)), write: (ptr, o) => {
                var destructors = [];
                setter(setterContext, ptr, setterArgumentType["toWireType"](destructors, o));
                runDestructors(destructors);
              } };
            });
            return [{ name: reg.name, "fromWireType": function(ptr) {
              var rv = {};
              for (var i in fields) {
                rv[i] = fields[i].read(ptr);
              }
              rawDestructor(ptr);
              return rv;
            }, "toWireType": function(destructors, o) {
              for (var fieldName in fields) {
                if (!(fieldName in o)) {
                  throw new TypeError(`Missing field: "${fieldName}"`);
                }
              }
              var ptr = rawConstructor();
              for (fieldName in fields) {
                fields[fieldName].write(ptr, o[fieldName]);
              }
              if (destructors !== null) {
                destructors.push(rawDestructor, ptr);
              }
              return ptr;
            }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: rawDestructor }];
          });
        };
        function __embind_register_bigint(primitiveType, name, size, minRange, maxRange) {
          primitiveType >>>= 0;
          name >>>= 0;
          size >>>= 0;
        }
        function getShiftFromSize(size) {
          switch (size) {
            case 1:
              return 0;
            case 2:
              return 1;
            case 4:
              return 2;
            case 8:
              return 3;
            default:
              throw new TypeError(`Unknown type size: ${size}`);
          }
        }
        function embind_init_charCodes() {
          var codes = new Array(256);
          for (var i = 0; i < 256; ++i) {
            codes[i] = String.fromCharCode(i);
          }
          embind_charCodes = codes;
        }
        var embind_charCodes = void 0;
        function readLatin1String(ptr) {
          var ret = "";
          var c = ptr;
          while (HEAPU8[c >>> 0]) {
            ret += embind_charCodes[HEAPU8[c++ >>> 0]];
          }
          return ret;
        }
        var BindingError = void 0;
        function throwBindingError(message) {
          throw new BindingError(message);
        }
        function sharedRegisterType(rawType, registeredInstance, options = {}) {
          var name = registeredInstance.name;
          if (!rawType) {
            throwBindingError(`type "${name}" must have a positive integer typeid pointer`);
          }
          if (registeredTypes.hasOwnProperty(rawType)) {
            if (options.ignoreDuplicateRegistrations) {
              return;
            } else {
              throwBindingError(`Cannot register type '${name}' twice`);
            }
          }
          registeredTypes[rawType] = registeredInstance;
          delete typeDependencies[rawType];
          if (awaitingDependencies.hasOwnProperty(rawType)) {
            var callbacks = awaitingDependencies[rawType];
            delete awaitingDependencies[rawType];
            callbacks.forEach((cb) => cb());
          }
        }
        function registerType(rawType, registeredInstance, options = {}) {
          if (!("argPackAdvance" in registeredInstance)) {
            throw new TypeError("registerType registeredInstance requires argPackAdvance");
          }
          return sharedRegisterType(rawType, registeredInstance, options);
        }
        function __embind_register_bool(rawType, name, size, trueValue, falseValue) {
          rawType >>>= 0;
          name >>>= 0;
          size >>>= 0;
          var shift = getShiftFromSize(size);
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": function(wt) {
            return !!wt;
          }, "toWireType": function(destructors, o) {
            return o ? trueValue : falseValue;
          }, "argPackAdvance": 8, "readValueFromPointer": function(pointer) {
            var heap;
            if (size === 1) {
              heap = HEAP8;
            } else if (size === 2) {
              heap = HEAP16;
            } else if (size === 4) {
              heap = HEAP32;
            } else {
              throw new TypeError("Unknown boolean type size: " + name);
            }
            return this["fromWireType"](heap[pointer >>> shift]);
          }, destructorFunction: null });
        }
        function ClassHandle_isAliasOf(other) {
          if (!(this instanceof ClassHandle)) {
            return false;
          }
          if (!(other instanceof ClassHandle)) {
            return false;
          }
          var leftClass = this.$$.ptrType.registeredClass;
          var left = this.$$.ptr;
          var rightClass = other.$$.ptrType.registeredClass;
          var right = other.$$.ptr;
          while (leftClass.baseClass) {
            left = leftClass.upcast(left);
            leftClass = leftClass.baseClass;
          }
          while (rightClass.baseClass) {
            right = rightClass.upcast(right);
            rightClass = rightClass.baseClass;
          }
          return leftClass === rightClass && left === right;
        }
        function shallowCopyInternalPointer(o) {
          return { count: o.count, deleteScheduled: o.deleteScheduled, preservePointerOnDelete: o.preservePointerOnDelete, ptr: o.ptr, ptrType: o.ptrType, smartPtr: o.smartPtr, smartPtrType: o.smartPtrType };
        }
        function throwInstanceAlreadyDeleted(obj) {
          function getInstanceTypeName(handle) {
            return handle.$$.ptrType.registeredClass.name;
          }
          throwBindingError(getInstanceTypeName(obj) + " instance already deleted");
        }
        var finalizationRegistry = false;
        function detachFinalizer(handle) {
        }
        function runDestructor($$) {
          if ($$.smartPtr) {
            $$.smartPtrType.rawDestructor($$.smartPtr);
          } else {
            $$.ptrType.registeredClass.rawDestructor($$.ptr);
          }
        }
        function releaseClassHandle($$) {
          $$.count.value -= 1;
          var toDelete = $$.count.value === 0;
          if (toDelete) {
            runDestructor($$);
          }
        }
        function downcastPointer(ptr, ptrClass, desiredClass) {
          if (ptrClass === desiredClass) {
            return ptr;
          }
          if (desiredClass.baseClass === void 0) {
            return null;
          }
          var rv = downcastPointer(ptr, ptrClass, desiredClass.baseClass);
          if (rv === null) {
            return null;
          }
          return desiredClass.downcast(rv);
        }
        var registeredPointers = {};
        function getInheritedInstanceCount() {
          return Object.keys(registeredInstances).length;
        }
        function getLiveInheritedInstances() {
          var rv = [];
          for (var k in registeredInstances) {
            if (registeredInstances.hasOwnProperty(k)) {
              rv.push(registeredInstances[k]);
            }
          }
          return rv;
        }
        var deletionQueue = [];
        function flushPendingDeletes() {
          while (deletionQueue.length) {
            var obj = deletionQueue.pop();
            obj.$$.deleteScheduled = false;
            obj["delete"]();
          }
        }
        var delayFunction = void 0;
        function setDelayFunction(fn) {
          delayFunction = fn;
          if (deletionQueue.length && delayFunction) {
            delayFunction(flushPendingDeletes);
          }
        }
        function init_embind() {
          Module["getInheritedInstanceCount"] = getInheritedInstanceCount;
          Module["getLiveInheritedInstances"] = getLiveInheritedInstances;
          Module["flushPendingDeletes"] = flushPendingDeletes;
          Module["setDelayFunction"] = setDelayFunction;
        }
        var registeredInstances = {};
        function getBasestPointer(class_, ptr) {
          if (ptr === void 0) {
            throwBindingError("ptr should not be undefined");
          }
          while (class_.baseClass) {
            ptr = class_.upcast(ptr);
            class_ = class_.baseClass;
          }
          return ptr;
        }
        function getInheritedInstance(class_, ptr) {
          ptr = getBasestPointer(class_, ptr);
          return registeredInstances[ptr];
        }
        function makeClassHandle(prototype, record) {
          if (!record.ptrType || !record.ptr) {
            throwInternalError("makeClassHandle requires ptr and ptrType");
          }
          var hasSmartPtrType = !!record.smartPtrType;
          var hasSmartPtr = !!record.smartPtr;
          if (hasSmartPtrType !== hasSmartPtr) {
            throwInternalError("Both smartPtrType and smartPtr must be specified");
          }
          record.count = { value: 1 };
          return attachFinalizer(Object.create(prototype, { $$: { value: record } }));
        }
        function RegisteredPointer_fromWireType(ptr) {
          var rawPointer = this.getPointee(ptr);
          if (!rawPointer) {
            this.destructor(ptr);
            return null;
          }
          var registeredInstance = getInheritedInstance(this.registeredClass, rawPointer);
          if (registeredInstance !== void 0) {
            if (registeredInstance.$$.count.value === 0) {
              registeredInstance.$$.ptr = rawPointer;
              registeredInstance.$$.smartPtr = ptr;
              return registeredInstance["clone"]();
            } else {
              var rv = registeredInstance["clone"]();
              this.destructor(ptr);
              return rv;
            }
          }
          function makeDefaultHandle() {
            if (this.isSmartPointer) {
              return makeClassHandle(this.registeredClass.instancePrototype, { ptrType: this.pointeeType, ptr: rawPointer, smartPtrType: this, smartPtr: ptr });
            } else {
              return makeClassHandle(this.registeredClass.instancePrototype, { ptrType: this, ptr });
            }
          }
          var actualType = this.registeredClass.getActualType(rawPointer);
          var registeredPointerRecord = registeredPointers[actualType];
          if (!registeredPointerRecord) {
            return makeDefaultHandle.call(this);
          }
          var toType;
          if (this.isConst) {
            toType = registeredPointerRecord.constPointerType;
          } else {
            toType = registeredPointerRecord.pointerType;
          }
          var dp = downcastPointer(rawPointer, this.registeredClass, toType.registeredClass);
          if (dp === null) {
            return makeDefaultHandle.call(this);
          }
          if (this.isSmartPointer) {
            return makeClassHandle(toType.registeredClass.instancePrototype, { ptrType: toType, ptr: dp, smartPtrType: this, smartPtr: ptr });
          } else {
            return makeClassHandle(toType.registeredClass.instancePrototype, { ptrType: toType, ptr: dp });
          }
        }
        var attachFinalizer = function(handle) {
          if (typeof FinalizationRegistry === "undefined") {
            attachFinalizer = (handle2) => handle2;
            return handle;
          }
          finalizationRegistry = new FinalizationRegistry((info) => {
            releaseClassHandle(info.$$);
          });
          attachFinalizer = (handle2) => {
            var $$ = handle2.$$;
            var hasSmartPtr = !!$$.smartPtr;
            if (hasSmartPtr) {
              var info = { $$ };
              finalizationRegistry.register(handle2, info, handle2);
            }
            return handle2;
          };
          detachFinalizer = (handle2) => finalizationRegistry.unregister(handle2);
          return attachFinalizer(handle);
        };
        function ClassHandle_clone() {
          if (!this.$$.ptr) {
            throwInstanceAlreadyDeleted(this);
          }
          if (this.$$.preservePointerOnDelete) {
            this.$$.count.value += 1;
            return this;
          } else {
            var clone = attachFinalizer(Object.create(Object.getPrototypeOf(this), { $$: { value: shallowCopyInternalPointer(this.$$) } }));
            clone.$$.count.value += 1;
            clone.$$.deleteScheduled = false;
            return clone;
          }
        }
        function ClassHandle_delete() {
          if (!this.$$.ptr) {
            throwInstanceAlreadyDeleted(this);
          }
          if (this.$$.deleteScheduled && !this.$$.preservePointerOnDelete) {
            throwBindingError("Object already scheduled for deletion");
          }
          detachFinalizer(this);
          releaseClassHandle(this.$$);
          if (!this.$$.preservePointerOnDelete) {
            this.$$.smartPtr = void 0;
            this.$$.ptr = void 0;
          }
        }
        function ClassHandle_isDeleted() {
          return !this.$$.ptr;
        }
        function ClassHandle_deleteLater() {
          if (!this.$$.ptr) {
            throwInstanceAlreadyDeleted(this);
          }
          if (this.$$.deleteScheduled && !this.$$.preservePointerOnDelete) {
            throwBindingError("Object already scheduled for deletion");
          }
          deletionQueue.push(this);
          if (deletionQueue.length === 1 && delayFunction) {
            delayFunction(flushPendingDeletes);
          }
          this.$$.deleteScheduled = true;
          return this;
        }
        function init_ClassHandle() {
          ClassHandle.prototype["isAliasOf"] = ClassHandle_isAliasOf;
          ClassHandle.prototype["clone"] = ClassHandle_clone;
          ClassHandle.prototype["delete"] = ClassHandle_delete;
          ClassHandle.prototype["isDeleted"] = ClassHandle_isDeleted;
          ClassHandle.prototype["deleteLater"] = ClassHandle_deleteLater;
        }
        function ClassHandle() {
        }
        var char_0 = 48;
        var char_9 = 57;
        function makeLegalFunctionName(name) {
          if (name === void 0) {
            return "_unknown";
          }
          name = name.replace(/[^a-zA-Z0-9_]/g, "$");
          var f = name.charCodeAt(0);
          if (f >= char_0 && f <= char_9) {
            return `_${name}`;
          }
          return name;
        }
        function createNamedFunction(name, body) {
          name = makeLegalFunctionName(name);
          return { [name]: function() {
            return body.apply(this, arguments);
          } }[name];
        }
        function ensureOverloadTable(proto, methodName, humanName) {
          if (proto[methodName].overloadTable === void 0) {
            var prevFunc = proto[methodName];
            proto[methodName] = function() {
              if (!proto[methodName].overloadTable.hasOwnProperty(arguments.length)) {
                throwBindingError(`Function '${humanName}' called with an invalid number of arguments (${arguments.length}) - expects one of (${proto[methodName].overloadTable})!`);
              }
              return proto[methodName].overloadTable[arguments.length].apply(this, arguments);
            };
            proto[methodName].overloadTable = [];
            proto[methodName].overloadTable[prevFunc.argCount] = prevFunc;
          }
        }
        function exposePublicSymbol(name, value, numArguments) {
          if (Module.hasOwnProperty(name)) {
            if (numArguments === void 0 || Module[name].overloadTable !== void 0 && Module[name].overloadTable[numArguments] !== void 0) {
              throwBindingError(`Cannot register public name '${name}' twice`);
            }
            ensureOverloadTable(Module, name, name);
            if (Module.hasOwnProperty(numArguments)) {
              throwBindingError(`Cannot register multiple overloads of a function with the same number of arguments (${numArguments})!`);
            }
            Module[name].overloadTable[numArguments] = value;
          } else {
            Module[name] = value;
            if (numArguments !== void 0) {
              Module[name].numArguments = numArguments;
            }
          }
        }
        function RegisteredClass(name, constructor, instancePrototype, rawDestructor, baseClass, getActualType, upcast, downcast) {
          this.name = name;
          this.constructor = constructor;
          this.instancePrototype = instancePrototype;
          this.rawDestructor = rawDestructor;
          this.baseClass = baseClass;
          this.getActualType = getActualType;
          this.upcast = upcast;
          this.downcast = downcast;
          this.pureVirtualFunctions = [];
        }
        function upcastPointer(ptr, ptrClass, desiredClass) {
          while (ptrClass !== desiredClass) {
            if (!ptrClass.upcast) {
              throwBindingError(`Expected null or instance of ${desiredClass.name}, got an instance of ${ptrClass.name}`);
            }
            ptr = ptrClass.upcast(ptr);
            ptrClass = ptrClass.baseClass;
          }
          return ptr;
        }
        function constNoSmartPtrRawPointerToWireType(destructors, handle) {
          if (handle === null) {
            if (this.isReference) {
              throwBindingError(`null is not a valid ${this.name}`);
            }
            return 0;
          }
          if (!handle.$$) {
            throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`);
          }
          if (!handle.$$.ptr) {
            throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`);
          }
          var handleClass = handle.$$.ptrType.registeredClass;
          var ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
          return ptr;
        }
        function genericPointerToWireType(destructors, handle) {
          var ptr;
          if (handle === null) {
            if (this.isReference) {
              throwBindingError(`null is not a valid ${this.name}`);
            }
            if (this.isSmartPointer) {
              ptr = this.rawConstructor();
              if (destructors !== null) {
                destructors.push(this.rawDestructor, ptr);
              }
              return ptr;
            } else {
              return 0;
            }
          }
          if (!handle.$$) {
            throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`);
          }
          if (!handle.$$.ptr) {
            throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`);
          }
          if (!this.isConst && handle.$$.ptrType.isConst) {
            throwBindingError(`Cannot convert argument of type ${handle.$$.smartPtrType ? handle.$$.smartPtrType.name : handle.$$.ptrType.name} to parameter type ${this.name}`);
          }
          var handleClass = handle.$$.ptrType.registeredClass;
          ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
          if (this.isSmartPointer) {
            if (handle.$$.smartPtr === void 0) {
              throwBindingError("Passing raw pointer to smart pointer is illegal");
            }
            switch (this.sharingPolicy) {
              case 0:
                if (handle.$$.smartPtrType === this) {
                  ptr = handle.$$.smartPtr;
                } else {
                  throwBindingError(`Cannot convert argument of type ${handle.$$.smartPtrType ? handle.$$.smartPtrType.name : handle.$$.ptrType.name} to parameter type ${this.name}`);
                }
                break;
              case 1:
                ptr = handle.$$.smartPtr;
                break;
              case 2:
                if (handle.$$.smartPtrType === this) {
                  ptr = handle.$$.smartPtr;
                } else {
                  var clonedHandle = handle["clone"]();
                  ptr = this.rawShare(ptr, Emval.toHandle(function() {
                    clonedHandle["delete"]();
                  }));
                  if (destructors !== null) {
                    destructors.push(this.rawDestructor, ptr);
                  }
                }
                break;
              default:
                throwBindingError("Unsupporting sharing policy");
            }
          }
          return ptr;
        }
        function nonConstNoSmartPtrRawPointerToWireType(destructors, handle) {
          if (handle === null) {
            if (this.isReference) {
              throwBindingError(`null is not a valid ${this.name}`);
            }
            return 0;
          }
          if (!handle.$$) {
            throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`);
          }
          if (!handle.$$.ptr) {
            throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`);
          }
          if (handle.$$.ptrType.isConst) {
            throwBindingError(`Cannot convert argument of type ${handle.$$.ptrType.name} to parameter type ${this.name}`);
          }
          var handleClass = handle.$$.ptrType.registeredClass;
          var ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
          return ptr;
        }
        function RegisteredPointer_getPointee(ptr) {
          if (this.rawGetPointee) {
            ptr = this.rawGetPointee(ptr);
          }
          return ptr;
        }
        function RegisteredPointer_destructor(ptr) {
          if (this.rawDestructor) {
            this.rawDestructor(ptr);
          }
        }
        function RegisteredPointer_deleteObject(handle) {
          if (handle !== null) {
            handle["delete"]();
          }
        }
        function init_RegisteredPointer() {
          RegisteredPointer.prototype.getPointee = RegisteredPointer_getPointee;
          RegisteredPointer.prototype.destructor = RegisteredPointer_destructor;
          RegisteredPointer.prototype["argPackAdvance"] = 8;
          RegisteredPointer.prototype["readValueFromPointer"] = simpleReadValueFromPointer;
          RegisteredPointer.prototype["deleteObject"] = RegisteredPointer_deleteObject;
          RegisteredPointer.prototype["fromWireType"] = RegisteredPointer_fromWireType;
        }
        function RegisteredPointer(name, registeredClass, isReference, isConst, isSmartPointer, pointeeType, sharingPolicy, rawGetPointee, rawConstructor, rawShare, rawDestructor) {
          this.name = name;
          this.registeredClass = registeredClass;
          this.isReference = isReference;
          this.isConst = isConst;
          this.isSmartPointer = isSmartPointer;
          this.pointeeType = pointeeType;
          this.sharingPolicy = sharingPolicy;
          this.rawGetPointee = rawGetPointee;
          this.rawConstructor = rawConstructor;
          this.rawShare = rawShare;
          this.rawDestructor = rawDestructor;
          if (!isSmartPointer && registeredClass.baseClass === void 0) {
            if (isConst) {
              this["toWireType"] = constNoSmartPtrRawPointerToWireType;
              this.destructorFunction = null;
            } else {
              this["toWireType"] = nonConstNoSmartPtrRawPointerToWireType;
              this.destructorFunction = null;
            }
          } else {
            this["toWireType"] = genericPointerToWireType;
          }
        }
        function replacePublicSymbol(name, value, numArguments) {
          if (!Module.hasOwnProperty(name)) {
            throwInternalError("Replacing nonexistant public symbol");
          }
          if (Module[name].overloadTable !== void 0 && numArguments !== void 0) {
            Module[name].overloadTable[numArguments] = value;
          } else {
            Module[name] = value;
            Module[name].argCount = numArguments;
          }
        }
        var dynCallLegacy = (sig, ptr, args) => {
          var f = Module["dynCall_" + sig];
          return args && args.length ? f.apply(null, [ptr].concat(args)) : f.call(null, ptr);
        };
        var wasmTableMirror = [];
        var getWasmTableEntry = (funcPtr) => {
          var func = wasmTableMirror[funcPtr];
          if (!func) {
            if (funcPtr >= wasmTableMirror.length)
              wasmTableMirror.length = funcPtr + 1;
            wasmTableMirror[funcPtr] = func = wasmTable.get(funcPtr);
          }
          return func;
        };
        var dynCall = (sig, ptr, args) => {
          if (sig.includes("j")) {
            return dynCallLegacy(sig, ptr, args);
          }
          var rtn = getWasmTableEntry(ptr).apply(null, args);
          return rtn;
        };
        var getDynCaller = (sig, ptr) => {
          var argCache = [];
          return function() {
            argCache.length = 0;
            Object.assign(argCache, arguments);
            return dynCall(sig, ptr, argCache);
          };
        };
        function embind__requireFunction(signature, rawFunction) {
          signature = readLatin1String(signature);
          function makeDynCaller() {
            if (signature.includes("j")) {
              return getDynCaller(signature, rawFunction);
            }
            return getWasmTableEntry(rawFunction);
          }
          var fp = makeDynCaller();
          if (typeof fp != "function") {
            throwBindingError(`unknown function pointer with signature ${signature}: ${rawFunction}`);
          }
          return fp;
        }
        function extendError(baseErrorType, errorName) {
          var errorClass = createNamedFunction(errorName, function(message) {
            this.name = errorName;
            this.message = message;
            var stack = new Error(message).stack;
            if (stack !== void 0) {
              this.stack = this.toString() + "\n" + stack.replace(/^Error(:[^\n]*)?\n/, "");
            }
          });
          errorClass.prototype = Object.create(baseErrorType.prototype);
          errorClass.prototype.constructor = errorClass;
          errorClass.prototype.toString = function() {
            if (this.message === void 0) {
              return this.name;
            } else {
              return `${this.name}: ${this.message}`;
            }
          };
          return errorClass;
        }
        var UnboundTypeError = void 0;
        function getTypeName(type) {
          var ptr = ___getTypeName(type);
          var rv = readLatin1String(ptr);
          _free(ptr);
          return rv;
        }
        function throwUnboundTypeError(message, types) {
          var unboundTypes = [];
          var seen = {};
          function visit(type) {
            if (seen[type]) {
              return;
            }
            if (registeredTypes[type]) {
              return;
            }
            if (typeDependencies[type]) {
              typeDependencies[type].forEach(visit);
              return;
            }
            unboundTypes.push(type);
            seen[type] = true;
          }
          types.forEach(visit);
          throw new UnboundTypeError(`${message}: ` + unboundTypes.map(getTypeName).join([", "]));
        }
        function __embind_register_class(rawType, rawPointerType, rawConstPointerType, baseClassRawType, getActualTypeSignature, getActualType, upcastSignature, upcast, downcastSignature, downcast, name, destructorSignature, rawDestructor) {
          rawType >>>= 0;
          rawPointerType >>>= 0;
          rawConstPointerType >>>= 0;
          baseClassRawType >>>= 0;
          getActualTypeSignature >>>= 0;
          getActualType >>>= 0;
          upcastSignature >>>= 0;
          upcast >>>= 0;
          downcastSignature >>>= 0;
          downcast >>>= 0;
          name >>>= 0;
          destructorSignature >>>= 0;
          rawDestructor >>>= 0;
          name = readLatin1String(name);
          getActualType = embind__requireFunction(getActualTypeSignature, getActualType);
          if (upcast) {
            upcast = embind__requireFunction(upcastSignature, upcast);
          }
          if (downcast) {
            downcast = embind__requireFunction(downcastSignature, downcast);
          }
          rawDestructor = embind__requireFunction(destructorSignature, rawDestructor);
          var legalFunctionName = makeLegalFunctionName(name);
          exposePublicSymbol(legalFunctionName, function() {
            throwUnboundTypeError(`Cannot construct ${name} due to unbound types`, [baseClassRawType]);
          });
          whenDependentTypesAreResolved([rawType, rawPointerType, rawConstPointerType], baseClassRawType ? [baseClassRawType] : [], function(base) {
            base = base[0];
            var baseClass;
            var basePrototype;
            if (baseClassRawType) {
              baseClass = base.registeredClass;
              basePrototype = baseClass.instancePrototype;
            } else {
              basePrototype = ClassHandle.prototype;
            }
            var constructor = createNamedFunction(legalFunctionName, function() {
              if (Object.getPrototypeOf(this) !== instancePrototype) {
                throw new BindingError("Use 'new' to construct " + name);
              }
              if (registeredClass.constructor_body === void 0) {
                throw new BindingError(name + " has no accessible constructor");
              }
              var body = registeredClass.constructor_body[arguments.length];
              if (body === void 0) {
                throw new BindingError(`Tried to invoke ctor of ${name} with invalid number of parameters (${arguments.length}) - expected (${Object.keys(registeredClass.constructor_body).toString()}) parameters instead!`);
              }
              return body.apply(this, arguments);
            });
            var instancePrototype = Object.create(basePrototype, { constructor: { value: constructor } });
            constructor.prototype = instancePrototype;
            var registeredClass = new RegisteredClass(name, constructor, instancePrototype, rawDestructor, baseClass, getActualType, upcast, downcast);
            if (registeredClass.baseClass) {
              if (registeredClass.baseClass.__derivedClasses === void 0) {
                registeredClass.baseClass.__derivedClasses = [];
              }
              registeredClass.baseClass.__derivedClasses.push(registeredClass);
            }
            var referenceConverter = new RegisteredPointer(name, registeredClass, true, false, false);
            var pointerConverter = new RegisteredPointer(name + "*", registeredClass, false, false, false);
            var constPointerConverter = new RegisteredPointer(name + " const*", registeredClass, false, true, false);
            registeredPointers[rawType] = { pointerType: pointerConverter, constPointerType: constPointerConverter };
            replacePublicSymbol(legalFunctionName, constructor);
            return [referenceConverter, pointerConverter, constPointerConverter];
          });
        }
        function heap32VectorToArray(count, firstElement) {
          var array = [];
          for (var i = 0; i < count; i++) {
            array.push(HEAPU32[firstElement + i * 4 >>> 2]);
          }
          return array;
        }
        function newFunc(constructor, argumentList) {
          if (!(constructor instanceof Function)) {
            throw new TypeError(`new_ called with constructor type ${typeof constructor} which is not a function`);
          }
          var dummy = createNamedFunction(constructor.name || "unknownFunctionName", function() {
          });
          dummy.prototype = constructor.prototype;
          var obj = new dummy();
          var r = constructor.apply(obj, argumentList);
          return r instanceof Object ? r : obj;
        }
        function craftInvokerFunction(humanName, argTypes, classType, cppInvokerFunc, cppTargetFunc, isAsync) {
          var argCount = argTypes.length;
          if (argCount < 2) {
            throwBindingError("argTypes array size mismatch! Must at least get return value and 'this' types!");
          }
          var isClassMethodFunc = argTypes[1] !== null && classType !== null;
          var needsDestructorStack = false;
          for (var i = 1; i < argTypes.length; ++i) {
            if (argTypes[i] !== null && argTypes[i].destructorFunction === void 0) {
              needsDestructorStack = true;
              break;
            }
          }
          var returns = argTypes[0].name !== "void";
          var argsList = "";
          var argsListWired = "";
          for (var i = 0; i < argCount - 2; ++i) {
            argsList += (i !== 0 ? ", " : "") + "arg" + i;
            argsListWired += (i !== 0 ? ", " : "") + "arg" + i + "Wired";
          }
          var invokerFnBody = `
        return function ${makeLegalFunctionName(humanName)}(${argsList}) {
        if (arguments.length !== ${argCount - 2}) {
          throwBindingError('function ${humanName} called with ${arguments.length} arguments, expected ${argCount - 2} args!');
        }`;
          if (needsDestructorStack) {
            invokerFnBody += "var destructors = [];\n";
          }
          var dtorStack = needsDestructorStack ? "destructors" : "null";
          var args1 = ["throwBindingError", "invoker", "fn", "runDestructors", "retType", "classParam"];
          var args2 = [throwBindingError, cppInvokerFunc, cppTargetFunc, runDestructors, argTypes[0], argTypes[1]];
          if (isClassMethodFunc) {
            invokerFnBody += "var thisWired = classParam.toWireType(" + dtorStack + ", this);\n";
          }
          for (var i = 0; i < argCount - 2; ++i) {
            invokerFnBody += "var arg" + i + "Wired = argType" + i + ".toWireType(" + dtorStack + ", arg" + i + "); // " + argTypes[i + 2].name + "\n";
            args1.push("argType" + i);
            args2.push(argTypes[i + 2]);
          }
          if (isClassMethodFunc) {
            argsListWired = "thisWired" + (argsListWired.length > 0 ? ", " : "") + argsListWired;
          }
          invokerFnBody += (returns || isAsync ? "var rv = " : "") + "invoker(fn" + (argsListWired.length > 0 ? ", " : "") + argsListWired + ");\n";
          if (needsDestructorStack) {
            invokerFnBody += "runDestructors(destructors);\n";
          } else {
            for (var i = isClassMethodFunc ? 1 : 2; i < argTypes.length; ++i) {
              var paramName = i === 1 ? "thisWired" : "arg" + (i - 2) + "Wired";
              if (argTypes[i].destructorFunction !== null) {
                invokerFnBody += paramName + "_dtor(" + paramName + "); // " + argTypes[i].name + "\n";
                args1.push(paramName + "_dtor");
                args2.push(argTypes[i].destructorFunction);
              }
            }
          }
          if (returns) {
            invokerFnBody += "var ret = retType.fromWireType(rv);\nreturn ret;\n";
          } else {
          }
          invokerFnBody += "}\n";
          args1.push(invokerFnBody);
          return newFunc(Function, args1).apply(null, args2);
        }
        function __embind_register_class_constructor(rawClassType, argCount, rawArgTypesAddr, invokerSignature, invoker, rawConstructor) {
          rawClassType >>>= 0;
          rawArgTypesAddr >>>= 0;
          invokerSignature >>>= 0;
          invoker >>>= 0;
          rawConstructor >>>= 0;
          var rawArgTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
          invoker = embind__requireFunction(invokerSignature, invoker);
          whenDependentTypesAreResolved([], [rawClassType], function(classType) {
            classType = classType[0];
            var humanName = `constructor ${classType.name}`;
            if (classType.registeredClass.constructor_body === void 0) {
              classType.registeredClass.constructor_body = [];
            }
            if (classType.registeredClass.constructor_body[argCount - 1] !== void 0) {
              throw new BindingError(`Cannot register multiple constructors with identical number of parameters (${argCount - 1}) for class '${classType.name}'! Overload resolution is currently only performed using the parameter count, not actual type info!`);
            }
            classType.registeredClass.constructor_body[argCount - 1] = () => {
              throwUnboundTypeError(`Cannot construct ${classType.name} due to unbound types`, rawArgTypes);
            };
            whenDependentTypesAreResolved([], rawArgTypes, function(argTypes) {
              argTypes.splice(1, 0, null);
              classType.registeredClass.constructor_body[argCount - 1] = craftInvokerFunction(humanName, argTypes, null, invoker, rawConstructor);
              return [];
            });
            return [];
          });
        }
        function __embind_register_class_function(rawClassType, methodName, argCount, rawArgTypesAddr, invokerSignature, rawInvoker, context, isPureVirtual, isAsync) {
          rawClassType >>>= 0;
          methodName >>>= 0;
          rawArgTypesAddr >>>= 0;
          invokerSignature >>>= 0;
          rawInvoker >>>= 0;
          context >>>= 0;
          var rawArgTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
          methodName = readLatin1String(methodName);
          rawInvoker = embind__requireFunction(invokerSignature, rawInvoker);
          whenDependentTypesAreResolved([], [rawClassType], function(classType) {
            classType = classType[0];
            var humanName = `${classType.name}.${methodName}`;
            if (methodName.startsWith("@@")) {
              methodName = Symbol[methodName.substring(2)];
            }
            if (isPureVirtual) {
              classType.registeredClass.pureVirtualFunctions.push(methodName);
            }
            function unboundTypesHandler() {
              throwUnboundTypeError(`Cannot call ${humanName} due to unbound types`, rawArgTypes);
            }
            var proto = classType.registeredClass.instancePrototype;
            var method = proto[methodName];
            if (method === void 0 || method.overloadTable === void 0 && method.className !== classType.name && method.argCount === argCount - 2) {
              unboundTypesHandler.argCount = argCount - 2;
              unboundTypesHandler.className = classType.name;
              proto[methodName] = unboundTypesHandler;
            } else {
              ensureOverloadTable(proto, methodName, humanName);
              proto[methodName].overloadTable[argCount - 2] = unboundTypesHandler;
            }
            whenDependentTypesAreResolved([], rawArgTypes, function(argTypes) {
              var memberFunction = craftInvokerFunction(humanName, argTypes, classType, rawInvoker, context, isAsync);
              if (proto[methodName].overloadTable === void 0) {
                memberFunction.argCount = argCount - 2;
                proto[methodName] = memberFunction;
              } else {
                proto[methodName].overloadTable[argCount - 2] = memberFunction;
              }
              return [];
            });
            return [];
          });
        }
        function handleAllocatorInit() {
          Object.assign(HandleAllocator.prototype, { get(id) {
            return this.allocated[id];
          }, has(id) {
            return this.allocated[id] !== void 0;
          }, allocate(handle) {
            var id = this.freelist.pop() || this.allocated.length;
            this.allocated[id] = handle;
            return id;
          }, free(id) {
            this.allocated[id] = void 0;
            this.freelist.push(id);
          } });
        }
        function HandleAllocator() {
          this.allocated = [void 0];
          this.freelist = [];
        }
        var emval_handles = new HandleAllocator();
        function __emval_decref(handle) {
          handle >>>= 0;
          if (handle >= emval_handles.reserved && --emval_handles.get(handle).refcount === 0) {
            emval_handles.free(handle);
          }
        }
        function count_emval_handles() {
          var count = 0;
          for (var i = emval_handles.reserved; i < emval_handles.allocated.length; ++i) {
            if (emval_handles.allocated[i] !== void 0) {
              ++count;
            }
          }
          return count;
        }
        function init_emval() {
          emval_handles.allocated.push({ value: void 0 }, { value: null }, { value: true }, { value: false });
          emval_handles.reserved = emval_handles.allocated.length;
          Module["count_emval_handles"] = count_emval_handles;
        }
        var Emval = { toValue: (handle) => {
          if (!handle) {
            throwBindingError("Cannot use deleted val. handle = " + handle);
          }
          return emval_handles.get(handle).value;
        }, toHandle: (value) => {
          switch (value) {
            case void 0:
              return 1;
            case null:
              return 2;
            case true:
              return 3;
            case false:
              return 4;
            default: {
              return emval_handles.allocate({ refcount: 1, value });
            }
          }
        } };
        function __embind_register_emval(rawType, name) {
          rawType >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": function(handle) {
            var rv = Emval.toValue(handle);
            __emval_decref(handle);
            return rv;
          }, "toWireType": function(destructors, value) {
            return Emval.toHandle(value);
          }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: null });
        }
        function embindRepr(v) {
          if (v === null) {
            return "null";
          }
          var t = typeof v;
          if (t === "object" || t === "array" || t === "function") {
            return v.toString();
          } else {
            return "" + v;
          }
        }
        function floatReadValueFromPointer(name, shift) {
          switch (shift) {
            case 2:
              return function(pointer) {
                return this["fromWireType"](HEAPF32[pointer >>> 2]);
              };
            case 3:
              return function(pointer) {
                return this["fromWireType"](HEAPF64[pointer >>> 3]);
              };
            default:
              throw new TypeError("Unknown float type: " + name);
          }
        }
        function __embind_register_float(rawType, name, size) {
          rawType >>>= 0;
          name >>>= 0;
          size >>>= 0;
          var shift = getShiftFromSize(size);
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": function(value) {
            return value;
          }, "toWireType": function(destructors, value) {
            return value;
          }, "argPackAdvance": 8, "readValueFromPointer": floatReadValueFromPointer(name, shift), destructorFunction: null });
        }
        function __embind_register_function(name, argCount, rawArgTypesAddr, signature, rawInvoker, fn, isAsync) {
          name >>>= 0;
          rawArgTypesAddr >>>= 0;
          signature >>>= 0;
          rawInvoker >>>= 0;
          fn >>>= 0;
          var argTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
          name = readLatin1String(name);
          rawInvoker = embind__requireFunction(signature, rawInvoker);
          exposePublicSymbol(name, function() {
            throwUnboundTypeError(`Cannot call ${name} due to unbound types`, argTypes);
          }, argCount - 1);
          whenDependentTypesAreResolved([], argTypes, function(argTypes2) {
            var invokerArgsArray = [argTypes2[0], null].concat(argTypes2.slice(1));
            replacePublicSymbol(name, craftInvokerFunction(name, invokerArgsArray, null, rawInvoker, fn, isAsync), argCount - 1);
            return [];
          });
        }
        function integerReadValueFromPointer(name, shift, signed) {
          switch (shift) {
            case 0:
              return signed ? function readS8FromPointer(pointer) {
                return HEAP8[pointer >>> 0];
              } : function readU8FromPointer(pointer) {
                return HEAPU8[pointer >>> 0];
              };
            case 1:
              return signed ? function readS16FromPointer(pointer) {
                return HEAP16[pointer >>> 1];
              } : function readU16FromPointer(pointer) {
                return HEAPU16[pointer >>> 1];
              };
            case 2:
              return signed ? function readS32FromPointer(pointer) {
                return HEAP32[pointer >>> 2];
              } : function readU32FromPointer(pointer) {
                return HEAPU32[pointer >>> 2];
              };
            default:
              throw new TypeError("Unknown integer type: " + name);
          }
        }
        function __embind_register_integer(primitiveType, name, size, minRange, maxRange) {
          primitiveType >>>= 0;
          name >>>= 0;
          size >>>= 0;
          name = readLatin1String(name);
          if (maxRange === -1) {
            maxRange = 4294967295;
          }
          var shift = getShiftFromSize(size);
          var fromWireType = (value) => value;
          if (minRange === 0) {
            var bitshift = 32 - 8 * size;
            fromWireType = (value) => value << bitshift >>> bitshift;
          }
          var isUnsignedType = name.includes("unsigned");
          var checkAssertions = (value, toTypeName) => {
          };
          var toWireType;
          if (isUnsignedType) {
            toWireType = function(destructors, value) {
              checkAssertions(value, this.name);
              return value >>> 0;
            };
          } else {
            toWireType = function(destructors, value) {
              checkAssertions(value, this.name);
              return value;
            };
          }
          registerType(primitiveType, { name, "fromWireType": fromWireType, "toWireType": toWireType, "argPackAdvance": 8, "readValueFromPointer": integerReadValueFromPointer(name, shift, minRange !== 0), destructorFunction: null });
        }
        function __embind_register_memory_view(rawType, dataTypeIndex, name) {
          rawType >>>= 0;
          name >>>= 0;
          var typeMapping = [Int8Array, Uint8Array, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array, Float64Array];
          var TA = typeMapping[dataTypeIndex];
          function decodeMemoryView(handle) {
            handle = handle >> 2;
            var heap = HEAPU32;
            var size = heap[handle >>> 0];
            var data = heap[handle + 1 >>> 0];
            return new TA(heap.buffer, data, size);
          }
          name = readLatin1String(name);
          registerType(rawType, { name, "fromWireType": decodeMemoryView, "argPackAdvance": 8, "readValueFromPointer": decodeMemoryView }, { ignoreDuplicateRegistrations: true });
        }
        var stringToUTF8Array = (str, heap, outIdx, maxBytesToWrite) => {
          outIdx >>>= 0;
          if (!(maxBytesToWrite > 0))
            return 0;
          var startIdx = outIdx;
          var endIdx = outIdx + maxBytesToWrite - 1;
          for (var i = 0; i < str.length; ++i) {
            var u = str.charCodeAt(i);
            if (u >= 55296 && u <= 57343) {
              var u1 = str.charCodeAt(++i);
              u = 65536 + ((u & 1023) << 10) | u1 & 1023;
            }
            if (u <= 127) {
              if (outIdx >= endIdx)
                break;
              heap[outIdx++ >>> 0] = u;
            } else if (u <= 2047) {
              if (outIdx + 1 >= endIdx)
                break;
              heap[outIdx++ >>> 0] = 192 | u >> 6;
              heap[outIdx++ >>> 0] = 128 | u & 63;
            } else if (u <= 65535) {
              if (outIdx + 2 >= endIdx)
                break;
              heap[outIdx++ >>> 0] = 224 | u >> 12;
              heap[outIdx++ >>> 0] = 128 | u >> 6 & 63;
              heap[outIdx++ >>> 0] = 128 | u & 63;
            } else {
              if (outIdx + 3 >= endIdx)
                break;
              heap[outIdx++ >>> 0] = 240 | u >> 18;
              heap[outIdx++ >>> 0] = 128 | u >> 12 & 63;
              heap[outIdx++ >>> 0] = 128 | u >> 6 & 63;
              heap[outIdx++ >>> 0] = 128 | u & 63;
            }
          }
          heap[outIdx >>> 0] = 0;
          return outIdx - startIdx;
        };
        var stringToUTF8 = (str, outPtr, maxBytesToWrite) => stringToUTF8Array(str, HEAPU8, outPtr, maxBytesToWrite);
        var lengthBytesUTF8 = (str) => {
          var len = 0;
          for (var i = 0; i < str.length; ++i) {
            var c = str.charCodeAt(i);
            if (c <= 127) {
              len++;
            } else if (c <= 2047) {
              len += 2;
            } else if (c >= 55296 && c <= 57343) {
              len += 4;
              ++i;
            } else {
              len += 3;
            }
          }
          return len;
        };
        var UTF8Decoder = typeof TextDecoder != "undefined" ? new TextDecoder("utf8") : void 0;
        var UTF8ArrayToString = (heapOrArray, idx, maxBytesToRead) => {
          idx >>>= 0;
          var endIdx = idx + maxBytesToRead;
          var endPtr = idx;
          while (heapOrArray[endPtr] && !(endPtr >= endIdx))
            ++endPtr;
          if (endPtr - idx > 16 && heapOrArray.buffer && UTF8Decoder) {
            return UTF8Decoder.decode(heapOrArray.subarray(idx, endPtr));
          }
          var str = "";
          while (idx < endPtr) {
            var u0 = heapOrArray[idx++];
            if (!(u0 & 128)) {
              str += String.fromCharCode(u0);
              continue;
            }
            var u1 = heapOrArray[idx++] & 63;
            if ((u0 & 224) == 192) {
              str += String.fromCharCode((u0 & 31) << 6 | u1);
              continue;
            }
            var u2 = heapOrArray[idx++] & 63;
            if ((u0 & 240) == 224) {
              u0 = (u0 & 15) << 12 | u1 << 6 | u2;
            } else {
              u0 = (u0 & 7) << 18 | u1 << 12 | u2 << 6 | heapOrArray[idx++] & 63;
            }
            if (u0 < 65536) {
              str += String.fromCharCode(u0);
            } else {
              var ch = u0 - 65536;
              str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
            }
          }
          return str;
        };
        var UTF8ToString = (ptr, maxBytesToRead) => {
          ptr >>>= 0;
          return ptr ? UTF8ArrayToString(HEAPU8, ptr, maxBytesToRead) : "";
        };
        function __embind_register_std_string(rawType, name) {
          rawType >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          var stdStringIsUTF8 = name === "std::string";
          registerType(rawType, { name, "fromWireType": function(value) {
            var length = HEAPU32[value >>> 2];
            var payload = value + 4;
            var str;
            if (stdStringIsUTF8) {
              var decodeStartPtr = payload;
              for (var i = 0; i <= length; ++i) {
                var currentBytePtr = payload + i;
                if (i == length || HEAPU8[currentBytePtr >>> 0] == 0) {
                  var maxRead = currentBytePtr - decodeStartPtr;
                  var stringSegment = UTF8ToString(decodeStartPtr, maxRead);
                  if (str === void 0) {
                    str = stringSegment;
                  } else {
                    str += String.fromCharCode(0);
                    str += stringSegment;
                  }
                  decodeStartPtr = currentBytePtr + 1;
                }
              }
            } else {
              var a = new Array(length);
              for (var i = 0; i < length; ++i) {
                a[i] = String.fromCharCode(HEAPU8[payload + i >>> 0]);
              }
              str = a.join("");
            }
            _free(value);
            return str;
          }, "toWireType": function(destructors, value) {
            if (value instanceof ArrayBuffer) {
              value = new Uint8Array(value);
            }
            var length;
            var valueIsOfTypeString = typeof value == "string";
            if (!(valueIsOfTypeString || value instanceof Uint8Array || value instanceof Uint8ClampedArray || value instanceof Int8Array)) {
              throwBindingError("Cannot pass non-string to std::string");
            }
            if (stdStringIsUTF8 && valueIsOfTypeString) {
              length = lengthBytesUTF8(value);
            } else {
              length = value.length;
            }
            var base = _malloc(4 + length + 1);
            var ptr = base + 4;
            HEAPU32[base >>> 2] = length;
            if (stdStringIsUTF8 && valueIsOfTypeString) {
              stringToUTF8(value, ptr, length + 1);
            } else {
              if (valueIsOfTypeString) {
                for (var i = 0; i < length; ++i) {
                  var charCode = value.charCodeAt(i);
                  if (charCode > 255) {
                    _free(ptr);
                    throwBindingError("String has UTF-16 code units that do not fit in 8 bits");
                  }
                  HEAPU8[ptr + i >>> 0] = charCode;
                }
              } else {
                for (var i = 0; i < length; ++i) {
                  HEAPU8[ptr + i >>> 0] = value[i];
                }
              }
            }
            if (destructors !== null) {
              destructors.push(_free, base);
            }
            return base;
          }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: function(ptr) {
            _free(ptr);
          } });
        }
        var UTF16Decoder = typeof TextDecoder != "undefined" ? new TextDecoder("utf-16le") : void 0;
        var UTF16ToString = (ptr, maxBytesToRead) => {
          var endPtr = ptr;
          var idx = endPtr >> 1;
          var maxIdx = idx + maxBytesToRead / 2;
          while (!(idx >= maxIdx) && HEAPU16[idx >>> 0])
            ++idx;
          endPtr = idx << 1;
          if (endPtr - ptr > 32 && UTF16Decoder)
            return UTF16Decoder.decode(HEAPU8.subarray(ptr >>> 0, endPtr >>> 0));
          var str = "";
          for (var i = 0; !(i >= maxBytesToRead / 2); ++i) {
            var codeUnit = HEAP16[ptr + i * 2 >>> 1];
            if (codeUnit == 0)
              break;
            str += String.fromCharCode(codeUnit);
          }
          return str;
        };
        var stringToUTF16 = (str, outPtr, maxBytesToWrite) => {
          if (maxBytesToWrite === void 0) {
            maxBytesToWrite = 2147483647;
          }
          if (maxBytesToWrite < 2)
            return 0;
          maxBytesToWrite -= 2;
          var startPtr = outPtr;
          var numCharsToWrite = maxBytesToWrite < str.length * 2 ? maxBytesToWrite / 2 : str.length;
          for (var i = 0; i < numCharsToWrite; ++i) {
            var codeUnit = str.charCodeAt(i);
            HEAP16[outPtr >>> 1] = codeUnit;
            outPtr += 2;
          }
          HEAP16[outPtr >>> 1] = 0;
          return outPtr - startPtr;
        };
        var lengthBytesUTF16 = (str) => str.length * 2;
        var UTF32ToString = (ptr, maxBytesToRead) => {
          var i = 0;
          var str = "";
          while (!(i >= maxBytesToRead / 4)) {
            var utf32 = HEAP32[ptr + i * 4 >>> 2];
            if (utf32 == 0)
              break;
            ++i;
            if (utf32 >= 65536) {
              var ch = utf32 - 65536;
              str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
            } else {
              str += String.fromCharCode(utf32);
            }
          }
          return str;
        };
        var stringToUTF32 = (str, outPtr, maxBytesToWrite) => {
          outPtr >>>= 0;
          if (maxBytesToWrite === void 0) {
            maxBytesToWrite = 2147483647;
          }
          if (maxBytesToWrite < 4)
            return 0;
          var startPtr = outPtr;
          var endPtr = startPtr + maxBytesToWrite - 4;
          for (var i = 0; i < str.length; ++i) {
            var codeUnit = str.charCodeAt(i);
            if (codeUnit >= 55296 && codeUnit <= 57343) {
              var trailSurrogate = str.charCodeAt(++i);
              codeUnit = 65536 + ((codeUnit & 1023) << 10) | trailSurrogate & 1023;
            }
            HEAP32[outPtr >>> 2] = codeUnit;
            outPtr += 4;
            if (outPtr + 4 > endPtr)
              break;
          }
          HEAP32[outPtr >>> 2] = 0;
          return outPtr - startPtr;
        };
        var lengthBytesUTF32 = (str) => {
          var len = 0;
          for (var i = 0; i < str.length; ++i) {
            var codeUnit = str.charCodeAt(i);
            if (codeUnit >= 55296 && codeUnit <= 57343)
              ++i;
            len += 4;
          }
          return len;
        };
        var __embind_register_std_wstring = function(rawType, charSize, name) {
          rawType >>>= 0;
          charSize >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          var decodeString, encodeString, getHeap, lengthBytesUTF, shift;
          if (charSize === 2) {
            decodeString = UTF16ToString;
            encodeString = stringToUTF16;
            lengthBytesUTF = lengthBytesUTF16;
            getHeap = () => HEAPU16;
            shift = 1;
          } else if (charSize === 4) {
            decodeString = UTF32ToString;
            encodeString = stringToUTF32;
            lengthBytesUTF = lengthBytesUTF32;
            getHeap = () => HEAPU32;
            shift = 2;
          }
          registerType(rawType, { name, "fromWireType": function(value) {
            var length = HEAPU32[value >>> 2];
            var HEAP = getHeap();
            var str;
            var decodeStartPtr = value + 4;
            for (var i = 0; i <= length; ++i) {
              var currentBytePtr = value + 4 + i * charSize;
              if (i == length || HEAP[currentBytePtr >>> shift] == 0) {
                var maxReadBytes = currentBytePtr - decodeStartPtr;
                var stringSegment = decodeString(decodeStartPtr, maxReadBytes);
                if (str === void 0) {
                  str = stringSegment;
                } else {
                  str += String.fromCharCode(0);
                  str += stringSegment;
                }
                decodeStartPtr = currentBytePtr + charSize;
              }
            }
            _free(value);
            return str;
          }, "toWireType": function(destructors, value) {
            if (!(typeof value == "string")) {
              throwBindingError(`Cannot pass non-string to C++ string type ${name}`);
            }
            var length = lengthBytesUTF(value);
            var ptr = _malloc(4 + length + charSize);
            HEAPU32[ptr >>> 2] = length >> shift;
            encodeString(value, ptr + 4, length + charSize);
            if (destructors !== null) {
              destructors.push(_free, ptr);
            }
            return ptr;
          }, "argPackAdvance": 8, "readValueFromPointer": simpleReadValueFromPointer, destructorFunction: function(ptr) {
            _free(ptr);
          } });
        };
        function __embind_register_value_array(rawType, name, constructorSignature, rawConstructor, destructorSignature, rawDestructor) {
          rawType >>>= 0;
          name >>>= 0;
          constructorSignature >>>= 0;
          rawConstructor >>>= 0;
          destructorSignature >>>= 0;
          rawDestructor >>>= 0;
          tupleRegistrations[rawType] = { name: readLatin1String(name), rawConstructor: embind__requireFunction(constructorSignature, rawConstructor), rawDestructor: embind__requireFunction(destructorSignature, rawDestructor), elements: [] };
        }
        function __embind_register_value_array_element(rawTupleType, getterReturnType, getterSignature, getter, getterContext, setterArgumentType, setterSignature, setter, setterContext) {
          rawTupleType >>>= 0;
          getterReturnType >>>= 0;
          getterSignature >>>= 0;
          getter >>>= 0;
          getterContext >>>= 0;
          setterArgumentType >>>= 0;
          setterSignature >>>= 0;
          setter >>>= 0;
          setterContext >>>= 0;
          tupleRegistrations[rawTupleType].elements.push({ getterReturnType, getter: embind__requireFunction(getterSignature, getter), getterContext, setterArgumentType, setter: embind__requireFunction(setterSignature, setter), setterContext });
        }
        function __embind_register_value_object(rawType, name, constructorSignature, rawConstructor, destructorSignature, rawDestructor) {
          rawType >>>= 0;
          name >>>= 0;
          constructorSignature >>>= 0;
          rawConstructor >>>= 0;
          destructorSignature >>>= 0;
          rawDestructor >>>= 0;
          structRegistrations[rawType] = { name: readLatin1String(name), rawConstructor: embind__requireFunction(constructorSignature, rawConstructor), rawDestructor: embind__requireFunction(destructorSignature, rawDestructor), fields: [] };
        }
        function __embind_register_value_object_field(structType, fieldName, getterReturnType, getterSignature, getter, getterContext, setterArgumentType, setterSignature, setter, setterContext) {
          structType >>>= 0;
          fieldName >>>= 0;
          getterReturnType >>>= 0;
          getterSignature >>>= 0;
          getter >>>= 0;
          getterContext >>>= 0;
          setterArgumentType >>>= 0;
          setterSignature >>>= 0;
          setter >>>= 0;
          setterContext >>>= 0;
          structRegistrations[structType].fields.push({ fieldName: readLatin1String(fieldName), getterReturnType, getter: embind__requireFunction(getterSignature, getter), getterContext, setterArgumentType, setter: embind__requireFunction(setterSignature, setter), setterContext });
        }
        function __embind_register_void(rawType, name) {
          rawType >>>= 0;
          name >>>= 0;
          name = readLatin1String(name);
          registerType(rawType, { isVoid: true, name, "argPackAdvance": 0, "fromWireType": function() {
            return void 0;
          }, "toWireType": function(destructors, o) {
            return void 0;
          } });
        }
        var nowIsMonotonic = true;
        var __emscripten_get_now_is_monotonic = () => nowIsMonotonic;
        function requireRegisteredType(rawType, humanName) {
          var impl = registeredTypes[rawType];
          if (impl === void 0) {
            throwBindingError(humanName + " has unknown type " + getTypeName(rawType));
          }
          return impl;
        }
        function __emval_as(handle, returnType, destructorsRef) {
          handle >>>= 0;
          returnType >>>= 0;
          destructorsRef >>>= 0;
          handle = Emval.toValue(handle);
          returnType = requireRegisteredType(returnType, "emval::as");
          var destructors = [];
          var rd = Emval.toHandle(destructors);
          HEAPU32[destructorsRef >>> 2] = rd;
          return returnType["toWireType"](destructors, handle);
        }
        function emval_lookupTypes(argCount, argTypes) {
          var a = new Array(argCount);
          for (var i = 0; i < argCount; ++i) {
            a[i] = requireRegisteredType(HEAPU32[argTypes + i * 4 >>> 2], "parameter " + i);
          }
          return a;
        }
        function __emval_call(handle, argCount, argTypes, argv) {
          handle >>>= 0;
          argTypes >>>= 0;
          argv >>>= 0;
          handle = Emval.toValue(handle);
          var types = emval_lookupTypes(argCount, argTypes);
          var args = new Array(argCount);
          for (var i = 0; i < argCount; ++i) {
            var type = types[i];
            args[i] = type["readValueFromPointer"](argv);
            argv += type["argPackAdvance"];
          }
          var rv = handle.apply(void 0, args);
          return Emval.toHandle(rv);
        }
        var emval_symbols = {};
        function getStringOrSymbol(address) {
          var symbol = emval_symbols[address];
          if (symbol === void 0) {
            return readLatin1String(address);
          }
          return symbol;
        }
        function emval_get_global() {
          if (typeof globalThis == "object") {
            return globalThis;
          }
          return function() {
            return Function;
          }()("return this")();
        }
        function __emval_get_global(name) {
          name >>>= 0;
          if (name === 0) {
            return Emval.toHandle(emval_get_global());
          } else {
            name = getStringOrSymbol(name);
            return Emval.toHandle(emval_get_global()[name]);
          }
        }
        function __emval_get_property(handle, key) {
          handle >>>= 0;
          key >>>= 0;
          handle = Emval.toValue(handle);
          key = Emval.toValue(key);
          return Emval.toHandle(handle[key]);
        }
        function __emval_incref(handle) {
          handle >>>= 0;
          if (handle > 4) {
            emval_handles.get(handle).refcount += 1;
          }
        }
        function __emval_instanceof(object, constructor) {
          object >>>= 0;
          constructor >>>= 0;
          object = Emval.toValue(object);
          constructor = Emval.toValue(constructor);
          return object instanceof constructor;
        }
        function __emval_is_number(handle) {
          handle >>>= 0;
          handle = Emval.toValue(handle);
          return typeof handle == "number";
        }
        function __emval_is_string(handle) {
          handle >>>= 0;
          handle = Emval.toValue(handle);
          return typeof handle == "string";
        }
        function __emval_new_array() {
          return Emval.toHandle([]);
        }
        function __emval_new_cstring(v) {
          v >>>= 0;
          return Emval.toHandle(getStringOrSymbol(v));
        }
        function __emval_new_object() {
          return Emval.toHandle({});
        }
        function __emval_run_destructors(handle) {
          handle >>>= 0;
          var destructors = Emval.toValue(handle);
          runDestructors(destructors);
          __emval_decref(handle);
        }
        function __emval_set_property(handle, key, value) {
          handle >>>= 0;
          key >>>= 0;
          value >>>= 0;
          handle = Emval.toValue(handle);
          key = Emval.toValue(key);
          value = Emval.toValue(value);
          handle[key] = value;
        }
        function __emval_take_value(type, arg) {
          type >>>= 0;
          arg >>>= 0;
          type = requireRegisteredType(type, "_emval_take_value");
          var v = type["readValueFromPointer"](arg);
          return Emval.toHandle(v);
        }
        function __gmtime_js(time_low, time_high, tmPtr) {
          var time = convertI32PairToI53Checked(time_low, time_high);
          tmPtr >>>= 0;
          var date = new Date(time * 1e3);
          HEAP32[tmPtr >>> 2] = date.getUTCSeconds();
          HEAP32[tmPtr + 4 >>> 2] = date.getUTCMinutes();
          HEAP32[tmPtr + 8 >>> 2] = date.getUTCHours();
          HEAP32[tmPtr + 12 >>> 2] = date.getUTCDate();
          HEAP32[tmPtr + 16 >>> 2] = date.getUTCMonth();
          HEAP32[tmPtr + 20 >>> 2] = date.getUTCFullYear() - 1900;
          HEAP32[tmPtr + 24 >>> 2] = date.getUTCDay();
          var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
          var yday = (date.getTime() - start) / (1e3 * 60 * 60 * 24) | 0;
          HEAP32[tmPtr + 28 >>> 2] = yday;
        }
        var isLeapYear = (year) => year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
        var MONTH_DAYS_LEAP_CUMULATIVE = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335];
        var MONTH_DAYS_REGULAR_CUMULATIVE = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        var ydayFromDate = (date) => {
          var leap = isLeapYear(date.getFullYear());
          var monthDaysCumulative = leap ? MONTH_DAYS_LEAP_CUMULATIVE : MONTH_DAYS_REGULAR_CUMULATIVE;
          var yday = monthDaysCumulative[date.getMonth()] + date.getDate() - 1;
          return yday;
        };
        function __localtime_js(time_low, time_high, tmPtr) {
          var time = convertI32PairToI53Checked(time_low, time_high);
          tmPtr >>>= 0;
          var date = new Date(time * 1e3);
          HEAP32[tmPtr >>> 2] = date.getSeconds();
          HEAP32[tmPtr + 4 >>> 2] = date.getMinutes();
          HEAP32[tmPtr + 8 >>> 2] = date.getHours();
          HEAP32[tmPtr + 12 >>> 2] = date.getDate();
          HEAP32[tmPtr + 16 >>> 2] = date.getMonth();
          HEAP32[tmPtr + 20 >>> 2] = date.getFullYear() - 1900;
          HEAP32[tmPtr + 24 >>> 2] = date.getDay();
          var yday = ydayFromDate(date) | 0;
          HEAP32[tmPtr + 28 >>> 2] = yday;
          HEAP32[tmPtr + 36 >>> 2] = -(date.getTimezoneOffset() * 60);
          var start = new Date(date.getFullYear(), 0, 1);
          var summerOffset = new Date(date.getFullYear(), 6, 1).getTimezoneOffset();
          var winterOffset = start.getTimezoneOffset();
          var dst = (summerOffset != winterOffset && date.getTimezoneOffset() == Math.min(winterOffset, summerOffset)) | 0;
          HEAP32[tmPtr + 32 >>> 2] = dst;
        }
        var stringToNewUTF8 = (str) => {
          var size = lengthBytesUTF8(str) + 1;
          var ret = _malloc(size);
          if (ret)
            stringToUTF8(str, ret, size);
          return ret;
        };
        function __tzset_js(timezone, daylight, tzname) {
          timezone >>>= 0;
          daylight >>>= 0;
          tzname >>>= 0;
          var currentYear = new Date().getFullYear();
          var winter = new Date(currentYear, 0, 1);
          var summer = new Date(currentYear, 6, 1);
          var winterOffset = winter.getTimezoneOffset();
          var summerOffset = summer.getTimezoneOffset();
          var stdTimezoneOffset = Math.max(winterOffset, summerOffset);
          HEAPU32[timezone >>> 2] = stdTimezoneOffset * 60;
          HEAP32[daylight >>> 2] = Number(winterOffset != summerOffset);
          function extractZone(date) {
            var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
            return match ? match[1] : "GMT";
          }
          var winterName = extractZone(winter);
          var summerName = extractZone(summer);
          var winterNamePtr = stringToNewUTF8(winterName);
          var summerNamePtr = stringToNewUTF8(summerName);
          if (summerOffset < winterOffset) {
            HEAPU32[tzname >>> 2] = winterNamePtr;
            HEAPU32[tzname + 4 >>> 2] = summerNamePtr;
          } else {
            HEAPU32[tzname >>> 2] = summerNamePtr;
            HEAPU32[tzname + 4 >>> 2] = winterNamePtr;
          }
        }
        var _abort = () => {
          abort("");
        };
        function _emscripten_date_now() {
          return Date.now();
        }
        var _emscripten_get_now;
        _emscripten_get_now = () => performance.now();
        function _emscripten_memcpy_big(dest, src, num) {
          dest >>>= 0;
          src >>>= 0;
          num >>>= 0;
          return HEAPU8.copyWithin(dest >>> 0, src >>> 0, src + num >>> 0);
        }
        var getHeapMax = () => 4294901760;
        var growMemory = (size) => {
          var b = wasmMemory.buffer;
          var pages = size - b.byteLength + 65535 >>> 16;
          try {
            wasmMemory.grow(pages);
            updateMemoryViews();
            return 1;
          } catch (e) {
          }
        };
        function _emscripten_resize_heap(requestedSize) {
          requestedSize >>>= 0;
          var oldSize = HEAPU8.length;
          var maxHeapSize = getHeapMax();
          if (requestedSize > maxHeapSize) {
            return false;
          }
          var alignUp = (x, multiple) => x + (multiple - x % multiple) % multiple;
          for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {
            var overGrownHeapSize = oldSize * (1 + 0.2 / cutDown);
            overGrownHeapSize = Math.min(overGrownHeapSize, requestedSize + 100663296);
            var newSize = Math.min(maxHeapSize, alignUp(Math.max(requestedSize, overGrownHeapSize), 65536));
            var replacement = growMemory(newSize);
            if (replacement) {
              return true;
            }
          }
          return false;
        }
        var ENV = {};
        var getExecutableName = () => thisProgram || "./this.program";
        var getEnvStrings = () => {
          if (!getEnvStrings.strings) {
            var lang = (typeof navigator == "object" && navigator.languages && navigator.languages[0] || "C").replace("-", "_") + ".UTF-8";
            var env = { "USER": "web_user", "LOGNAME": "web_user", "PATH": "/", "PWD": "/", "HOME": "/home/web_user", "LANG": lang, "_": getExecutableName() };
            for (var x in ENV) {
              if (ENV[x] === void 0)
                delete env[x];
              else
                env[x] = ENV[x];
            }
            var strings = [];
            for (var x in env) {
              strings.push(`${x}=${env[x]}`);
            }
            getEnvStrings.strings = strings;
          }
          return getEnvStrings.strings;
        };
        var stringToAscii = (str, buffer) => {
          for (var i = 0; i < str.length; ++i) {
            HEAP8[buffer++ >>> 0] = str.charCodeAt(i);
          }
          HEAP8[buffer >>> 0] = 0;
        };
        var PATH = { isAbs: (path) => path.charAt(0) === "/", splitPath: (filename) => {
          var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
          return splitPathRe.exec(filename).slice(1);
        }, normalizeArray: (parts, allowAboveRoot) => {
          var up = 0;
          for (var i = parts.length - 1; i >= 0; i--) {
            var last = parts[i];
            if (last === ".") {
              parts.splice(i, 1);
            } else if (last === "..") {
              parts.splice(i, 1);
              up++;
            } else if (up) {
              parts.splice(i, 1);
              up--;
            }
          }
          if (allowAboveRoot) {
            for (; up; up--) {
              parts.unshift("..");
            }
          }
          return parts;
        }, normalize: (path) => {
          var isAbsolute = PATH.isAbs(path), trailingSlash = path.substr(-1) === "/";
          path = PATH.normalizeArray(path.split("/").filter((p) => !!p), !isAbsolute).join("/");
          if (!path && !isAbsolute) {
            path = ".";
          }
          if (path && trailingSlash) {
            path += "/";
          }
          return (isAbsolute ? "/" : "") + path;
        }, dirname: (path) => {
          var result = PATH.splitPath(path), root = result[0], dir = result[1];
          if (!root && !dir) {
            return ".";
          }
          if (dir) {
            dir = dir.substr(0, dir.length - 1);
          }
          return root + dir;
        }, basename: (path) => {
          if (path === "/")
            return "/";
          path = PATH.normalize(path);
          path = path.replace(/\/$/, "");
          var lastSlash = path.lastIndexOf("/");
          if (lastSlash === -1)
            return path;
          return path.substr(lastSlash + 1);
        }, join: function() {
          var paths = Array.prototype.slice.call(arguments);
          return PATH.normalize(paths.join("/"));
        }, join2: (l, r) => PATH.normalize(l + "/" + r) };
        var initRandomFill = () => {
          if (typeof crypto == "object" && typeof crypto["getRandomValues"] == "function") {
            return (view) => crypto.getRandomValues(view);
          } else if (ENVIRONMENT_IS_NODE) {
            try {
              var crypto_module = require("crypto");
              var randomFillSync = crypto_module["randomFillSync"];
              if (randomFillSync) {
                return (view) => crypto_module["randomFillSync"](view);
              }
              var randomBytes = crypto_module["randomBytes"];
              return (view) => (view.set(randomBytes(view.byteLength)), view);
            } catch (e) {
            }
          }
          abort("initRandomDevice");
        };
        var randomFill = (view) => (randomFill = initRandomFill())(view);
        var PATH_FS = { resolve: function() {
          var resolvedPath = "", resolvedAbsolute = false;
          for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
            var path = i >= 0 ? arguments[i] : FS.cwd();
            if (typeof path != "string") {
              throw new TypeError("Arguments to path.resolve must be strings");
            } else if (!path) {
              return "";
            }
            resolvedPath = path + "/" + resolvedPath;
            resolvedAbsolute = PATH.isAbs(path);
          }
          resolvedPath = PATH.normalizeArray(resolvedPath.split("/").filter((p) => !!p), !resolvedAbsolute).join("/");
          return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
        }, relative: (from, to) => {
          from = PATH_FS.resolve(from).substr(1);
          to = PATH_FS.resolve(to).substr(1);
          function trim(arr) {
            var start = 0;
            for (; start < arr.length; start++) {
              if (arr[start] !== "")
                break;
            }
            var end = arr.length - 1;
            for (; end >= 0; end--) {
              if (arr[end] !== "")
                break;
            }
            if (start > end)
              return [];
            return arr.slice(start, end - start + 1);
          }
          var fromParts = trim(from.split("/"));
          var toParts = trim(to.split("/"));
          var length = Math.min(fromParts.length, toParts.length);
          var samePartsLength = length;
          for (var i = 0; i < length; i++) {
            if (fromParts[i] !== toParts[i]) {
              samePartsLength = i;
              break;
            }
          }
          var outputParts = [];
          for (var i = samePartsLength; i < fromParts.length; i++) {
            outputParts.push("..");
          }
          outputParts = outputParts.concat(toParts.slice(samePartsLength));
          return outputParts.join("/");
        } };
        var FS_stdin_getChar_buffer = [];
        function intArrayFromString(stringy, dontAddNull, length) {
          var len = length > 0 ? length : lengthBytesUTF8(stringy) + 1;
          var u8array = new Array(len);
          var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
          if (dontAddNull)
            u8array.length = numBytesWritten;
          return u8array;
        }
        var FS_stdin_getChar = () => {
          if (!FS_stdin_getChar_buffer.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              var BUFSIZE = 256;
              var buf = Buffer.alloc(BUFSIZE);
              var bytesRead = 0;
              var fd = process.stdin.fd;
              try {
                bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, -1);
              } catch (e) {
                if (e.toString().includes("EOF"))
                  bytesRead = 0;
                else
                  throw e;
              }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString("utf-8");
              } else {
                result = null;
              }
            } else if (typeof window != "undefined" && typeof window.prompt == "function") {
              result = window.prompt("Input: ");
              if (result !== null) {
                result += "\n";
              }
            } else if (typeof readline == "function") {
              result = readline();
              if (result !== null) {
                result += "\n";
              }
            }
            if (!result) {
              return null;
            }
            FS_stdin_getChar_buffer = intArrayFromString(result, true);
          }
          return FS_stdin_getChar_buffer.shift();
        };
        var TTY = { ttys: [], init: function() {
        }, shutdown: function() {
        }, register: function(dev, ops) {
          TTY.ttys[dev] = { input: [], output: [], ops };
          FS.registerDevice(dev, TTY.stream_ops);
        }, stream_ops: { open: function(stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(43);
          }
          stream.tty = tty;
          stream.seekable = false;
        }, close: function(stream) {
          stream.tty.ops.fsync(stream.tty);
        }, fsync: function(stream) {
          stream.tty.ops.fsync(stream.tty);
        }, read: function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(60);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(29);
            }
            if (result === void 0 && bytesRead === 0) {
              throw new FS.ErrnoError(6);
            }
            if (result === null || result === void 0)
              break;
            bytesRead++;
            buffer[offset + i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        }, write: function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(60);
          }
          try {
            for (var i = 0; i < length; i++) {
              stream.tty.ops.put_char(stream.tty, buffer[offset + i]);
            }
          } catch (e) {
            throw new FS.ErrnoError(29);
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        } }, default_tty_ops: { get_char: function(tty) {
          return FS_stdin_getChar();
        }, put_char: function(tty, val) {
          if (val === null || val === 10) {
            out(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0)
              tty.output.push(val);
          }
        }, fsync: function(tty) {
          if (tty.output && tty.output.length > 0) {
            out(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }, ioctl_tcgets: function(tty) {
          return { c_iflag: 25856, c_oflag: 5, c_cflag: 191, c_lflag: 35387, c_cc: [3, 28, 127, 21, 4, 0, 1, 0, 17, 19, 26, 0, 18, 15, 23, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] };
        }, ioctl_tcsets: function(tty, optional_actions, data) {
          return 0;
        }, ioctl_tiocgwinsz: function(tty) {
          return [24, 80];
        } }, default_tty1_ops: { put_char: function(tty, val) {
          if (val === null || val === 10) {
            err(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0)
              tty.output.push(val);
          }
        }, fsync: function(tty) {
          if (tty.output && tty.output.length > 0) {
            err(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        } } };
        var mmapAlloc = (size) => {
          abort();
        };
        var MEMFS = { ops_table: null, mount(mount) {
          return MEMFS.createNode(null, "/", 16384 | 511, 0);
        }, createNode(parent, name, mode, dev) {
          if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
            throw new FS.ErrnoError(63);
          }
          if (!MEMFS.ops_table) {
            MEMFS.ops_table = { dir: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr, lookup: MEMFS.node_ops.lookup, mknod: MEMFS.node_ops.mknod, rename: MEMFS.node_ops.rename, unlink: MEMFS.node_ops.unlink, rmdir: MEMFS.node_ops.rmdir, readdir: MEMFS.node_ops.readdir, symlink: MEMFS.node_ops.symlink }, stream: { llseek: MEMFS.stream_ops.llseek } }, file: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr }, stream: { llseek: MEMFS.stream_ops.llseek, read: MEMFS.stream_ops.read, write: MEMFS.stream_ops.write, allocate: MEMFS.stream_ops.allocate, mmap: MEMFS.stream_ops.mmap, msync: MEMFS.stream_ops.msync } }, link: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr, readlink: MEMFS.node_ops.readlink }, stream: {} }, chrdev: { node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr }, stream: FS.chrdev_stream_ops } };
          }
          var node = FS.createNode(parent, name, mode, dev);
          if (FS.isDir(node.mode)) {
            node.node_ops = MEMFS.ops_table.dir.node;
            node.stream_ops = MEMFS.ops_table.dir.stream;
            node.contents = {};
          } else if (FS.isFile(node.mode)) {
            node.node_ops = MEMFS.ops_table.file.node;
            node.stream_ops = MEMFS.ops_table.file.stream;
            node.usedBytes = 0;
            node.contents = null;
          } else if (FS.isLink(node.mode)) {
            node.node_ops = MEMFS.ops_table.link.node;
            node.stream_ops = MEMFS.ops_table.link.stream;
          } else if (FS.isChrdev(node.mode)) {
            node.node_ops = MEMFS.ops_table.chrdev.node;
            node.stream_ops = MEMFS.ops_table.chrdev.stream;
          }
          node.timestamp = Date.now();
          if (parent) {
            parent.contents[name] = node;
            parent.timestamp = node.timestamp;
          }
          return node;
        }, getFileDataAsTypedArray(node) {
          if (!node.contents)
            return new Uint8Array(0);
          if (node.contents.subarray)
            return node.contents.subarray(0, node.usedBytes);
          return new Uint8Array(node.contents);
        }, expandFileStorage(node, newCapacity) {
          var prevCapacity = node.contents ? node.contents.length : 0;
          if (prevCapacity >= newCapacity)
            return;
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125) >>> 0);
          if (prevCapacity != 0)
            newCapacity = Math.max(newCapacity, 256);
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity);
          if (node.usedBytes > 0)
            node.contents.set(oldContents.subarray(0, node.usedBytes), 0);
        }, resizeFileStorage(node, newSize) {
          if (node.usedBytes == newSize)
            return;
          if (newSize == 0) {
            node.contents = null;
            node.usedBytes = 0;
          } else {
            var oldContents = node.contents;
            node.contents = new Uint8Array(newSize);
            if (oldContents) {
              node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes)));
            }
            node.usedBytes = newSize;
          }
        }, node_ops: { getattr(node) {
          var attr = {};
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        }, setattr(node, attr) {
          if (attr.mode !== void 0) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== void 0) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== void 0) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        }, lookup(parent, name) {
          throw FS.genericErrors[44];
        }, mknod(parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        }, rename(old_node, new_dir, new_name) {
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(55);
              }
            }
          }
          delete old_node.parent.contents[old_node.name];
          old_node.parent.timestamp = Date.now();
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          new_dir.timestamp = old_node.parent.timestamp;
          old_node.parent = new_dir;
        }, unlink(parent, name) {
          delete parent.contents[name];
          parent.timestamp = Date.now();
        }, rmdir(parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(55);
          }
          delete parent.contents[name];
          parent.timestamp = Date.now();
        }, readdir(node) {
          var entries = [".", ".."];
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        }, symlink(parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 | 40960, 0);
          node.link = oldpath;
          return node;
        }, readlink(node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(28);
          }
          return node.link;
        } }, stream_ops: { read(stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes)
            return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          if (size > 8 && contents.subarray) {
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++)
              buffer[offset + i] = contents[position + i];
          }
          return size;
        }, write(stream, buffer, offset, length, position, canOwn) {
          if (buffer.buffer === HEAP8.buffer) {
            canOwn = false;
          }
          if (!length)
            return 0;
          var node = stream.node;
          node.timestamp = Date.now();
          if (buffer.subarray && (!node.contents || node.contents.subarray)) {
            if (canOwn) {
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) {
              node.contents = buffer.slice(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) {
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
          MEMFS.expandFileStorage(node, position + length);
          if (node.contents.subarray && buffer.subarray) {
            node.contents.set(buffer.subarray(offset, offset + length), position);
          } else {
            for (var i = 0; i < length; i++) {
              node.contents[position + i] = buffer[offset + i];
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position + length);
          return length;
        }, llseek(stream, offset, whence) {
          var position = offset;
          if (whence === 1) {
            position += stream.position;
          } else if (whence === 2) {
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(28);
          }
          return position;
        }, allocate(stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        }, mmap(stream, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          if (!(flags & 2) && contents.buffer === HEAP8.buffer) {
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = mmapAlloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(48);
            }
            HEAP8.set(contents, ptr >>> 0);
          }
          return { ptr, allocated };
        }, msync(stream, buffer, offset, length, mmapFlags) {
          MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          return 0;
        } } };
        var asyncLoad = (url, onload, onerror, noRunDep) => {
          var dep = !noRunDep ? getUniqueRunDependency(`al ${url}`) : "";
          readAsync(url, (arrayBuffer) => {
            assert(arrayBuffer, `Loading data file "${url}" failed (no arrayBuffer).`);
            onload(new Uint8Array(arrayBuffer));
            if (dep)
              removeRunDependency(dep);
          }, (event) => {
            if (onerror) {
              onerror();
            } else {
              throw `Loading data file "${url}" failed.`;
            }
          });
          if (dep)
            addRunDependency(dep);
        };
        var preloadPlugins = Module["preloadPlugins"] || [];
        function FS_handledByPreloadPlugin(byteArray, fullname, finish, onerror) {
          if (typeof Browser != "undefined")
            Browser.init();
          var handled = false;
          preloadPlugins.forEach(function(plugin) {
            if (handled)
              return;
            if (plugin["canHandle"](fullname)) {
              plugin["handle"](byteArray, fullname, finish, onerror);
              handled = true;
            }
          });
          return handled;
        }
        function FS_createPreloadedFile(parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
          var fullname = name ? PATH_FS.resolve(PATH.join2(parent, name)) : parent;
          var dep = getUniqueRunDependency(`cp ${fullname}`);
          function processData(byteArray) {
            function finish(byteArray2) {
              if (preFinish)
                preFinish();
              if (!dontCreateFile) {
                FS.createDataFile(parent, name, byteArray2, canRead, canWrite, canOwn);
              }
              if (onload)
                onload();
              removeRunDependency(dep);
            }
            if (FS_handledByPreloadPlugin(byteArray, fullname, finish, () => {
              if (onerror)
                onerror();
              removeRunDependency(dep);
            })) {
              return;
            }
            finish(byteArray);
          }
          addRunDependency(dep);
          if (typeof url == "string") {
            asyncLoad(url, (byteArray) => processData(byteArray), onerror);
          } else {
            processData(url);
          }
        }
        function FS_modeStringToFlags(str) {
          var flagModes = { "r": 0, "r+": 2, "w": 512 | 64 | 1, "w+": 512 | 64 | 2, "a": 1024 | 64 | 1, "a+": 1024 | 64 | 2 };
          var flags = flagModes[str];
          if (typeof flags == "undefined") {
            throw new Error(`Unknown file open mode: ${str}`);
          }
          return flags;
        }
        function FS_getMode(canRead, canWrite) {
          var mode = 0;
          if (canRead)
            mode |= 292 | 73;
          if (canWrite)
            mode |= 146;
          return mode;
        }
        var FS = { root: null, mounts: [], devices: {}, streams: [], nextInode: 1, nameTable: null, currentPath: "/", initialized: false, ignorePermissions: true, ErrnoError: null, genericErrors: {}, filesystems: null, syncFSRequests: 0, lookupPath: (path, opts = {}) => {
          path = PATH_FS.resolve(path);
          if (!path)
            return { path: "", node: null };
          var defaults = { follow_mount: true, recurse_count: 0 };
          opts = Object.assign(defaults, opts);
          if (opts.recurse_count > 8) {
            throw new FS.ErrnoError(32);
          }
          var parts = path.split("/").filter((p) => !!p);
          var current = FS.root;
          var current_path = "/";
          for (var i = 0; i < parts.length; i++) {
            var islast = i === parts.length - 1;
            if (islast && opts.parent) {
              break;
            }
            current = FS.lookupNode(current, parts[i]);
            current_path = PATH.join2(current_path, parts[i]);
            if (FS.isMountpoint(current)) {
              if (!islast || islast && opts.follow_mount) {
                current = current.mounted.root;
              }
            }
            if (!islast || opts.follow) {
              var count = 0;
              while (FS.isLink(current.mode)) {
                var link = FS.readlink(current_path);
                current_path = PATH_FS.resolve(PATH.dirname(current_path), link);
                var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count + 1 });
                current = lookup.node;
                if (count++ > 40) {
                  throw new FS.ErrnoError(32);
                }
              }
            }
          }
          return { path: current_path, node: current };
        }, getPath: (node) => {
          var path;
          while (true) {
            if (FS.isRoot(node)) {
              var mount = node.mount.mountpoint;
              if (!path)
                return mount;
              return mount[mount.length - 1] !== "/" ? `${mount}/${path}` : mount + path;
            }
            path = path ? `${node.name}/${path}` : node.name;
            node = node.parent;
          }
        }, hashName: (parentid, name) => {
          var hash = 0;
          for (var i = 0; i < name.length; i++) {
            hash = (hash << 5) - hash + name.charCodeAt(i) | 0;
          }
          return (parentid + hash >>> 0) % FS.nameTable.length;
        }, hashAddNode: (node) => {
          var hash = FS.hashName(node.parent.id, node.name);
          node.name_next = FS.nameTable[hash];
          FS.nameTable[hash] = node;
        }, hashRemoveNode: (node) => {
          var hash = FS.hashName(node.parent.id, node.name);
          if (FS.nameTable[hash] === node) {
            FS.nameTable[hash] = node.name_next;
          } else {
            var current = FS.nameTable[hash];
            while (current) {
              if (current.name_next === node) {
                current.name_next = node.name_next;
                break;
              }
              current = current.name_next;
            }
          }
        }, lookupNode: (parent, name) => {
          var errCode = FS.mayLookup(parent);
          if (errCode) {
            throw new FS.ErrnoError(errCode, parent);
          }
          var hash = FS.hashName(parent.id, name);
          for (var node = FS.nameTable[hash]; node; node = node.name_next) {
            var nodeName = node.name;
            if (node.parent.id === parent.id && nodeName === name) {
              return node;
            }
          }
          return FS.lookup(parent, name);
        }, createNode: (parent, name, mode, rdev) => {
          var node = new FS.FSNode(parent, name, mode, rdev);
          FS.hashAddNode(node);
          return node;
        }, destroyNode: (node) => {
          FS.hashRemoveNode(node);
        }, isRoot: (node) => node === node.parent, isMountpoint: (node) => !!node.mounted, isFile: (mode) => (mode & 61440) === 32768, isDir: (mode) => (mode & 61440) === 16384, isLink: (mode) => (mode & 61440) === 40960, isChrdev: (mode) => (mode & 61440) === 8192, isBlkdev: (mode) => (mode & 61440) === 24576, isFIFO: (mode) => (mode & 61440) === 4096, isSocket: (mode) => (mode & 49152) === 49152, flagsToPermissionString: (flag) => {
          var perms = ["r", "w", "rw"][flag & 3];
          if (flag & 512) {
            perms += "w";
          }
          return perms;
        }, nodePermissions: (node, perms) => {
          if (FS.ignorePermissions) {
            return 0;
          }
          if (perms.includes("r") && !(node.mode & 292)) {
            return 2;
          } else if (perms.includes("w") && !(node.mode & 146)) {
            return 2;
          } else if (perms.includes("x") && !(node.mode & 73)) {
            return 2;
          }
          return 0;
        }, mayLookup: (dir) => {
          var errCode = FS.nodePermissions(dir, "x");
          if (errCode)
            return errCode;
          if (!dir.node_ops.lookup)
            return 2;
          return 0;
        }, mayCreate: (dir, name) => {
          try {
            var node = FS.lookupNode(dir, name);
            return 20;
          } catch (e) {
          }
          return FS.nodePermissions(dir, "wx");
        }, mayDelete: (dir, name, isdir) => {
          var node;
          try {
            node = FS.lookupNode(dir, name);
          } catch (e) {
            return e.errno;
          }
          var errCode = FS.nodePermissions(dir, "wx");
          if (errCode) {
            return errCode;
          }
          if (isdir) {
            if (!FS.isDir(node.mode)) {
              return 54;
            }
            if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
              return 10;
            }
          } else {
            if (FS.isDir(node.mode)) {
              return 31;
            }
          }
          return 0;
        }, mayOpen: (node, flags) => {
          if (!node) {
            return 44;
          }
          if (FS.isLink(node.mode)) {
            return 32;
          } else if (FS.isDir(node.mode)) {
            if (FS.flagsToPermissionString(flags) !== "r" || flags & 512) {
              return 31;
            }
          }
          return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
        }, MAX_OPEN_FDS: 4096, nextfd: () => {
          for (var fd = 0; fd <= FS.MAX_OPEN_FDS; fd++) {
            if (!FS.streams[fd]) {
              return fd;
            }
          }
          throw new FS.ErrnoError(33);
        }, getStreamChecked: (fd) => {
          var stream = FS.getStream(fd);
          if (!stream) {
            throw new FS.ErrnoError(8);
          }
          return stream;
        }, getStream: (fd) => FS.streams[fd], createStream: (stream, fd = -1) => {
          if (!FS.FSStream) {
            FS.FSStream = function() {
              this.shared = {};
            };
            FS.FSStream.prototype = {};
            Object.defineProperties(FS.FSStream.prototype, { object: { get() {
              return this.node;
            }, set(val) {
              this.node = val;
            } }, isRead: { get() {
              return (this.flags & 2097155) !== 1;
            } }, isWrite: { get() {
              return (this.flags & 2097155) !== 0;
            } }, isAppend: { get() {
              return this.flags & 1024;
            } }, flags: { get() {
              return this.shared.flags;
            }, set(val) {
              this.shared.flags = val;
            } }, position: { get() {
              return this.shared.position;
            }, set(val) {
              this.shared.position = val;
            } } });
          }
          stream = Object.assign(new FS.FSStream(), stream);
          if (fd == -1) {
            fd = FS.nextfd();
          }
          stream.fd = fd;
          FS.streams[fd] = stream;
          return stream;
        }, closeStream: (fd) => {
          FS.streams[fd] = null;
        }, chrdev_stream_ops: { open: (stream) => {
          var device = FS.getDevice(stream.node.rdev);
          stream.stream_ops = device.stream_ops;
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        }, llseek: () => {
          throw new FS.ErrnoError(70);
        } }, major: (dev) => dev >> 8, minor: (dev) => dev & 255, makedev: (ma, mi) => ma << 8 | mi, registerDevice: (dev, ops) => {
          FS.devices[dev] = { stream_ops: ops };
        }, getDevice: (dev) => FS.devices[dev], getMounts: (mount) => {
          var mounts = [];
          var check = [mount];
          while (check.length) {
            var m = check.pop();
            mounts.push(m);
            check.push.apply(check, m.mounts);
          }
          return mounts;
        }, syncfs: (populate, callback) => {
          if (typeof populate == "function") {
            callback = populate;
            populate = false;
          }
          FS.syncFSRequests++;
          if (FS.syncFSRequests > 1) {
            err(`warning: ${FS.syncFSRequests} FS.syncfs operations in flight at once, probably just doing extra work`);
          }
          var mounts = FS.getMounts(FS.root.mount);
          var completed = 0;
          function doCallback(errCode) {
            FS.syncFSRequests--;
            return callback(errCode);
          }
          function done(errCode) {
            if (errCode) {
              if (!done.errored) {
                done.errored = true;
                return doCallback(errCode);
              }
              return;
            }
            if (++completed >= mounts.length) {
              doCallback(null);
            }
          }
          mounts.forEach((mount) => {
            if (!mount.type.syncfs) {
              return done(null);
            }
            mount.type.syncfs(mount, populate, done);
          });
        }, mount: (type, opts, mountpoint) => {
          var root = mountpoint === "/";
          var pseudo = !mountpoint;
          var node;
          if (root && FS.root) {
            throw new FS.ErrnoError(10);
          } else if (!root && !pseudo) {
            var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
            mountpoint = lookup.path;
            node = lookup.node;
            if (FS.isMountpoint(node)) {
              throw new FS.ErrnoError(10);
            }
            if (!FS.isDir(node.mode)) {
              throw new FS.ErrnoError(54);
            }
          }
          var mount = { type, opts, mountpoint, mounts: [] };
          var mountRoot = type.mount(mount);
          mountRoot.mount = mount;
          mount.root = mountRoot;
          if (root) {
            FS.root = mountRoot;
          } else if (node) {
            node.mounted = mount;
            if (node.mount) {
              node.mount.mounts.push(mount);
            }
          }
          return mountRoot;
        }, unmount: (mountpoint) => {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
          if (!FS.isMountpoint(lookup.node)) {
            throw new FS.ErrnoError(28);
          }
          var node = lookup.node;
          var mount = node.mounted;
          var mounts = FS.getMounts(mount);
          Object.keys(FS.nameTable).forEach((hash) => {
            var current = FS.nameTable[hash];
            while (current) {
              var next = current.name_next;
              if (mounts.includes(current.mount)) {
                FS.destroyNode(current);
              }
              current = next;
            }
          });
          node.mounted = null;
          var idx = node.mount.mounts.indexOf(mount);
          node.mount.mounts.splice(idx, 1);
        }, lookup: (parent, name) => parent.node_ops.lookup(parent, name), mknod: (path, mode, dev) => {
          var lookup = FS.lookupPath(path, { parent: true });
          var parent = lookup.node;
          var name = PATH.basename(path);
          if (!name || name === "." || name === "..") {
            throw new FS.ErrnoError(28);
          }
          var errCode = FS.mayCreate(parent, name);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.mknod) {
            throw new FS.ErrnoError(63);
          }
          return parent.node_ops.mknod(parent, name, mode, dev);
        }, create: (path, mode) => {
          mode = mode !== void 0 ? mode : 438;
          mode &= 4095;
          mode |= 32768;
          return FS.mknod(path, mode, 0);
        }, mkdir: (path, mode) => {
          mode = mode !== void 0 ? mode : 511;
          mode &= 511 | 512;
          mode |= 16384;
          return FS.mknod(path, mode, 0);
        }, mkdirTree: (path, mode) => {
          var dirs = path.split("/");
          var d = "";
          for (var i = 0; i < dirs.length; ++i) {
            if (!dirs[i])
              continue;
            d += "/" + dirs[i];
            try {
              FS.mkdir(d, mode);
            } catch (e) {
              if (e.errno != 20)
                throw e;
            }
          }
        }, mkdev: (path, mode, dev) => {
          if (typeof dev == "undefined") {
            dev = mode;
            mode = 438;
          }
          mode |= 8192;
          return FS.mknod(path, mode, dev);
        }, symlink: (oldpath, newpath) => {
          if (!PATH_FS.resolve(oldpath)) {
            throw new FS.ErrnoError(44);
          }
          var lookup = FS.lookupPath(newpath, { parent: true });
          var parent = lookup.node;
          if (!parent) {
            throw new FS.ErrnoError(44);
          }
          var newname = PATH.basename(newpath);
          var errCode = FS.mayCreate(parent, newname);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.symlink) {
            throw new FS.ErrnoError(63);
          }
          return parent.node_ops.symlink(parent, newname, oldpath);
        }, rename: (old_path, new_path) => {
          var old_dirname = PATH.dirname(old_path);
          var new_dirname = PATH.dirname(new_path);
          var old_name = PATH.basename(old_path);
          var new_name = PATH.basename(new_path);
          var lookup, old_dir, new_dir;
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
          if (!old_dir || !new_dir)
            throw new FS.ErrnoError(44);
          if (old_dir.mount !== new_dir.mount) {
            throw new FS.ErrnoError(75);
          }
          var old_node = FS.lookupNode(old_dir, old_name);
          var relative = PATH_FS.relative(old_path, new_dirname);
          if (relative.charAt(0) !== ".") {
            throw new FS.ErrnoError(28);
          }
          relative = PATH_FS.relative(new_path, old_dirname);
          if (relative.charAt(0) !== ".") {
            throw new FS.ErrnoError(55);
          }
          var new_node;
          try {
            new_node = FS.lookupNode(new_dir, new_name);
          } catch (e) {
          }
          if (old_node === new_node) {
            return;
          }
          var isdir = FS.isDir(old_node.mode);
          var errCode = FS.mayDelete(old_dir, old_name, isdir);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          errCode = new_node ? FS.mayDelete(new_dir, new_name, isdir) : FS.mayCreate(new_dir, new_name);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!old_dir.node_ops.rename) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isMountpoint(old_node) || new_node && FS.isMountpoint(new_node)) {
            throw new FS.ErrnoError(10);
          }
          if (new_dir !== old_dir) {
            errCode = FS.nodePermissions(old_dir, "w");
            if (errCode) {
              throw new FS.ErrnoError(errCode);
            }
          }
          FS.hashRemoveNode(old_node);
          try {
            old_dir.node_ops.rename(old_node, new_dir, new_name);
          } catch (e) {
            throw e;
          } finally {
            FS.hashAddNode(old_node);
          }
        }, rmdir: (path) => {
          var lookup = FS.lookupPath(path, { parent: true });
          var parent = lookup.node;
          var name = PATH.basename(path);
          var node = FS.lookupNode(parent, name);
          var errCode = FS.mayDelete(parent, name, true);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.rmdir) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(10);
          }
          parent.node_ops.rmdir(parent, name);
          FS.destroyNode(node);
        }, readdir: (path) => {
          var lookup = FS.lookupPath(path, { follow: true });
          var node = lookup.node;
          if (!node.node_ops.readdir) {
            throw new FS.ErrnoError(54);
          }
          return node.node_ops.readdir(node);
        }, unlink: (path) => {
          var lookup = FS.lookupPath(path, { parent: true });
          var parent = lookup.node;
          if (!parent) {
            throw new FS.ErrnoError(44);
          }
          var name = PATH.basename(path);
          var node = FS.lookupNode(parent, name);
          var errCode = FS.mayDelete(parent, name, false);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          if (!parent.node_ops.unlink) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(10);
          }
          parent.node_ops.unlink(parent, name);
          FS.destroyNode(node);
        }, readlink: (path) => {
          var lookup = FS.lookupPath(path);
          var link = lookup.node;
          if (!link) {
            throw new FS.ErrnoError(44);
          }
          if (!link.node_ops.readlink) {
            throw new FS.ErrnoError(28);
          }
          return PATH_FS.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
        }, stat: (path, dontFollow) => {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          var node = lookup.node;
          if (!node) {
            throw new FS.ErrnoError(44);
          }
          if (!node.node_ops.getattr) {
            throw new FS.ErrnoError(63);
          }
          return node.node_ops.getattr(node);
        }, lstat: (path) => FS.stat(path, true), chmod: (path, mode, dontFollow) => {
          var node;
          if (typeof path == "string") {
            var lookup = FS.lookupPath(path, { follow: !dontFollow });
            node = lookup.node;
          } else {
            node = path;
          }
          if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(63);
          }
          node.node_ops.setattr(node, { mode: mode & 4095 | node.mode & ~4095, timestamp: Date.now() });
        }, lchmod: (path, mode) => {
          FS.chmod(path, mode, true);
        }, fchmod: (fd, mode) => {
          var stream = FS.getStreamChecked(fd);
          FS.chmod(stream.node, mode);
        }, chown: (path, uid, gid, dontFollow) => {
          var node;
          if (typeof path == "string") {
            var lookup = FS.lookupPath(path, { follow: !dontFollow });
            node = lookup.node;
          } else {
            node = path;
          }
          if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(63);
          }
          node.node_ops.setattr(node, { timestamp: Date.now() });
        }, lchown: (path, uid, gid) => {
          FS.chown(path, uid, gid, true);
        }, fchown: (fd, uid, gid) => {
          var stream = FS.getStreamChecked(fd);
          FS.chown(stream.node, uid, gid);
        }, truncate: (path, len) => {
          if (len < 0) {
            throw new FS.ErrnoError(28);
          }
          var node;
          if (typeof path == "string") {
            var lookup = FS.lookupPath(path, { follow: true });
            node = lookup.node;
          } else {
            node = path;
          }
          if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(63);
          }
          if (FS.isDir(node.mode)) {
            throw new FS.ErrnoError(31);
          }
          if (!FS.isFile(node.mode)) {
            throw new FS.ErrnoError(28);
          }
          var errCode = FS.nodePermissions(node, "w");
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          node.node_ops.setattr(node, { size: len, timestamp: Date.now() });
        }, ftruncate: (fd, len) => {
          var stream = FS.getStreamChecked(fd);
          if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(28);
          }
          FS.truncate(stream.node, len);
        }, utime: (path, atime, mtime) => {
          var lookup = FS.lookupPath(path, { follow: true });
          var node = lookup.node;
          node.node_ops.setattr(node, { timestamp: Math.max(atime, mtime) });
        }, open: (path, flags, mode) => {
          if (path === "") {
            throw new FS.ErrnoError(44);
          }
          flags = typeof flags == "string" ? FS_modeStringToFlags(flags) : flags;
          mode = typeof mode == "undefined" ? 438 : mode;
          if (flags & 64) {
            mode = mode & 4095 | 32768;
          } else {
            mode = 0;
          }
          var node;
          if (typeof path == "object") {
            node = path;
          } else {
            path = PATH.normalize(path);
            try {
              var lookup = FS.lookupPath(path, { follow: !(flags & 131072) });
              node = lookup.node;
            } catch (e) {
            }
          }
          var created = false;
          if (flags & 64) {
            if (node) {
              if (flags & 128) {
                throw new FS.ErrnoError(20);
              }
            } else {
              node = FS.mknod(path, mode, 0);
              created = true;
            }
          }
          if (!node) {
            throw new FS.ErrnoError(44);
          }
          if (FS.isChrdev(node.mode)) {
            flags &= ~512;
          }
          if (flags & 65536 && !FS.isDir(node.mode)) {
            throw new FS.ErrnoError(54);
          }
          if (!created) {
            var errCode = FS.mayOpen(node, flags);
            if (errCode) {
              throw new FS.ErrnoError(errCode);
            }
          }
          if (flags & 512 && !created) {
            FS.truncate(node, 0);
          }
          flags &= ~(128 | 512 | 131072);
          var stream = FS.createStream({ node, path: FS.getPath(node), flags, seekable: true, position: 0, stream_ops: node.stream_ops, ungotten: [], error: false });
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
          if (Module["logReadFiles"] && !(flags & 1)) {
            if (!FS.readFiles)
              FS.readFiles = {};
            if (!(path in FS.readFiles)) {
              FS.readFiles[path] = 1;
            }
          }
          return stream;
        }, close: (stream) => {
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if (stream.getdents)
            stream.getdents = null;
          try {
            if (stream.stream_ops.close) {
              stream.stream_ops.close(stream);
            }
          } catch (e) {
            throw e;
          } finally {
            FS.closeStream(stream.fd);
          }
          stream.fd = null;
        }, isClosed: (stream) => stream.fd === null, llseek: (stream, offset, whence) => {
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if (!stream.seekable || !stream.stream_ops.llseek) {
            throw new FS.ErrnoError(70);
          }
          if (whence != 0 && whence != 1 && whence != 2) {
            throw new FS.ErrnoError(28);
          }
          stream.position = stream.stream_ops.llseek(stream, offset, whence);
          stream.ungotten = [];
          return stream.position;
        }, read: (stream, buffer, offset, length, position) => {
          if (length < 0 || position < 0) {
            throw new FS.ErrnoError(28);
          }
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(8);
          }
          if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(31);
          }
          if (!stream.stream_ops.read) {
            throw new FS.ErrnoError(28);
          }
          var seeking = typeof position != "undefined";
          if (!seeking) {
            position = stream.position;
          } else if (!stream.seekable) {
            throw new FS.ErrnoError(70);
          }
          var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
          if (!seeking)
            stream.position += bytesRead;
          return bytesRead;
        }, write: (stream, buffer, offset, length, position, canOwn) => {
          if (length < 0 || position < 0) {
            throw new FS.ErrnoError(28);
          }
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(8);
          }
          if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(31);
          }
          if (!stream.stream_ops.write) {
            throw new FS.ErrnoError(28);
          }
          if (stream.seekable && stream.flags & 1024) {
            FS.llseek(stream, 0, 2);
          }
          var seeking = typeof position != "undefined";
          if (!seeking) {
            position = stream.position;
          } else if (!stream.seekable) {
            throw new FS.ErrnoError(70);
          }
          var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
          if (!seeking)
            stream.position += bytesWritten;
          return bytesWritten;
        }, allocate: (stream, offset, length) => {
          if (FS.isClosed(stream)) {
            throw new FS.ErrnoError(8);
          }
          if (offset < 0 || length <= 0) {
            throw new FS.ErrnoError(28);
          }
          if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(8);
          }
          if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          if (!stream.stream_ops.allocate) {
            throw new FS.ErrnoError(138);
          }
          stream.stream_ops.allocate(stream, offset, length);
        }, mmap: (stream, length, position, prot, flags) => {
          if ((prot & 2) !== 0 && (flags & 2) === 0 && (stream.flags & 2097155) !== 2) {
            throw new FS.ErrnoError(2);
          }
          if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(2);
          }
          if (!stream.stream_ops.mmap) {
            throw new FS.ErrnoError(43);
          }
          return stream.stream_ops.mmap(stream, length, position, prot, flags);
        }, msync: (stream, buffer, offset, length, mmapFlags) => {
          if (!stream.stream_ops.msync) {
            return 0;
          }
          return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
        }, munmap: (stream) => 0, ioctl: (stream, cmd, arg) => {
          if (!stream.stream_ops.ioctl) {
            throw new FS.ErrnoError(59);
          }
          return stream.stream_ops.ioctl(stream, cmd, arg);
        }, readFile: (path, opts = {}) => {
          opts.flags = opts.flags || 0;
          opts.encoding = opts.encoding || "binary";
          if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
            throw new Error(`Invalid encoding type "${opts.encoding}"`);
          }
          var ret;
          var stream = FS.open(path, opts.flags);
          var stat = FS.stat(path);
          var length = stat.size;
          var buf = new Uint8Array(length);
          FS.read(stream, buf, 0, length, 0);
          if (opts.encoding === "utf8") {
            ret = UTF8ArrayToString(buf, 0);
          } else if (opts.encoding === "binary") {
            ret = buf;
          }
          FS.close(stream);
          return ret;
        }, writeFile: (path, data, opts = {}) => {
          opts.flags = opts.flags || 577;
          var stream = FS.open(path, opts.flags, opts.mode);
          if (typeof data == "string") {
            var buf = new Uint8Array(lengthBytesUTF8(data) + 1);
            var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
            FS.write(stream, buf, 0, actualNumBytes, void 0, opts.canOwn);
          } else if (ArrayBuffer.isView(data)) {
            FS.write(stream, data, 0, data.byteLength, void 0, opts.canOwn);
          } else {
            throw new Error("Unsupported data type");
          }
          FS.close(stream);
        }, cwd: () => FS.currentPath, chdir: (path) => {
          var lookup = FS.lookupPath(path, { follow: true });
          if (lookup.node === null) {
            throw new FS.ErrnoError(44);
          }
          if (!FS.isDir(lookup.node.mode)) {
            throw new FS.ErrnoError(54);
          }
          var errCode = FS.nodePermissions(lookup.node, "x");
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
          FS.currentPath = lookup.path;
        }, createDefaultDirectories: () => {
          FS.mkdir("/tmp");
          FS.mkdir("/home");
          FS.mkdir("/home/web_user");
        }, createDefaultDevices: () => {
          FS.mkdir("/dev");
          FS.registerDevice(FS.makedev(1, 3), { read: () => 0, write: (stream, buffer, offset, length, pos) => length });
          FS.mkdev("/dev/null", FS.makedev(1, 3));
          TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
          TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
          FS.mkdev("/dev/tty", FS.makedev(5, 0));
          FS.mkdev("/dev/tty1", FS.makedev(6, 0));
          var randomBuffer = new Uint8Array(1024), randomLeft = 0;
          var randomByte = () => {
            if (randomLeft === 0) {
              randomLeft = randomFill(randomBuffer).byteLength;
            }
            return randomBuffer[--randomLeft];
          };
          FS.createDevice("/dev", "random", randomByte);
          FS.createDevice("/dev", "urandom", randomByte);
          FS.mkdir("/dev/shm");
          FS.mkdir("/dev/shm/tmp");
        }, createSpecialDirectories: () => {
          FS.mkdir("/proc");
          var proc_self = FS.mkdir("/proc/self");
          FS.mkdir("/proc/self/fd");
          FS.mount({ mount: () => {
            var node = FS.createNode(proc_self, "fd", 16384 | 511, 73);
            node.node_ops = { lookup: (parent, name) => {
              var fd = +name;
              var stream = FS.getStreamChecked(fd);
              var ret = { parent: null, mount: { mountpoint: "fake" }, node_ops: { readlink: () => stream.path } };
              ret.parent = ret;
              return ret;
            } };
            return node;
          } }, {}, "/proc/self/fd");
        }, createStandardStreams: () => {
          if (Module["stdin"]) {
            FS.createDevice("/dev", "stdin", Module["stdin"]);
          } else {
            FS.symlink("/dev/tty", "/dev/stdin");
          }
          if (Module["stdout"]) {
            FS.createDevice("/dev", "stdout", null, Module["stdout"]);
          } else {
            FS.symlink("/dev/tty", "/dev/stdout");
          }
          if (Module["stderr"]) {
            FS.createDevice("/dev", "stderr", null, Module["stderr"]);
          } else {
            FS.symlink("/dev/tty1", "/dev/stderr");
          }
          var stdin = FS.open("/dev/stdin", 0);
          var stdout = FS.open("/dev/stdout", 1);
          var stderr = FS.open("/dev/stderr", 1);
        }, ensureErrnoError: () => {
          if (FS.ErrnoError)
            return;
          FS.ErrnoError = function ErrnoError(errno, node) {
            this.name = "ErrnoError";
            this.node = node;
            this.setErrno = function(errno2) {
              this.errno = errno2;
            };
            this.setErrno(errno);
            this.message = "FS error";
          };
          FS.ErrnoError.prototype = new Error();
          FS.ErrnoError.prototype.constructor = FS.ErrnoError;
          [44].forEach((code) => {
            FS.genericErrors[code] = new FS.ErrnoError(code);
            FS.genericErrors[code].stack = "<generic error, no stack>";
          });
        }, staticInit: () => {
          FS.ensureErrnoError();
          FS.nameTable = new Array(4096);
          FS.mount(MEMFS, {}, "/");
          FS.createDefaultDirectories();
          FS.createDefaultDevices();
          FS.createSpecialDirectories();
          FS.filesystems = { "MEMFS": MEMFS };
        }, init: (input, output, error) => {
          FS.init.initialized = true;
          FS.ensureErrnoError();
          Module["stdin"] = input || Module["stdin"];
          Module["stdout"] = output || Module["stdout"];
          Module["stderr"] = error || Module["stderr"];
          FS.createStandardStreams();
        }, quit: () => {
          FS.init.initialized = false;
          for (var i = 0; i < FS.streams.length; i++) {
            var stream = FS.streams[i];
            if (!stream) {
              continue;
            }
            FS.close(stream);
          }
        }, findObject: (path, dontResolveLastLink) => {
          var ret = FS.analyzePath(path, dontResolveLastLink);
          if (!ret.exists) {
            return null;
          }
          return ret.object;
        }, analyzePath: (path, dontResolveLastLink) => {
          try {
            var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
            path = lookup.path;
          } catch (e) {
          }
          var ret = { isRoot: false, exists: false, error: 0, name: null, path: null, object: null, parentExists: false, parentPath: null, parentObject: null };
          try {
            var lookup = FS.lookupPath(path, { parent: true });
            ret.parentExists = true;
            ret.parentPath = lookup.path;
            ret.parentObject = lookup.node;
            ret.name = PATH.basename(path);
            lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
            ret.exists = true;
            ret.path = lookup.path;
            ret.object = lookup.node;
            ret.name = lookup.node.name;
            ret.isRoot = lookup.path === "/";
          } catch (e) {
            ret.error = e.errno;
          }
          return ret;
        }, createPath: (parent, path, canRead, canWrite) => {
          parent = typeof parent == "string" ? parent : FS.getPath(parent);
          var parts = path.split("/").reverse();
          while (parts.length) {
            var part = parts.pop();
            if (!part)
              continue;
            var current = PATH.join2(parent, part);
            try {
              FS.mkdir(current);
            } catch (e) {
            }
            parent = current;
          }
          return current;
        }, createFile: (parent, name, properties, canRead, canWrite) => {
          var path = PATH.join2(typeof parent == "string" ? parent : FS.getPath(parent), name);
          var mode = FS_getMode(canRead, canWrite);
          return FS.create(path, mode);
        }, createDataFile: (parent, name, data, canRead, canWrite, canOwn) => {
          var path = name;
          if (parent) {
            parent = typeof parent == "string" ? parent : FS.getPath(parent);
            path = name ? PATH.join2(parent, name) : parent;
          }
          var mode = FS_getMode(canRead, canWrite);
          var node = FS.create(path, mode);
          if (data) {
            if (typeof data == "string") {
              var arr = new Array(data.length);
              for (var i = 0, len = data.length; i < len; ++i)
                arr[i] = data.charCodeAt(i);
              data = arr;
            }
            FS.chmod(node, mode | 146);
            var stream = FS.open(node, 577);
            FS.write(stream, data, 0, data.length, 0, canOwn);
            FS.close(stream);
            FS.chmod(node, mode);
          }
          return node;
        }, createDevice: (parent, name, input, output) => {
          var path = PATH.join2(typeof parent == "string" ? parent : FS.getPath(parent), name);
          var mode = FS_getMode(!!input, !!output);
          if (!FS.createDevice.major)
            FS.createDevice.major = 64;
          var dev = FS.makedev(FS.createDevice.major++, 0);
          FS.registerDevice(dev, { open: (stream) => {
            stream.seekable = false;
          }, close: (stream) => {
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          }, read: (stream, buffer, offset, length, pos) => {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(29);
              }
              if (result === void 0 && bytesRead === 0) {
                throw new FS.ErrnoError(6);
              }
              if (result === null || result === void 0)
                break;
              bytesRead++;
              buffer[offset + i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          }, write: (stream, buffer, offset, length, pos) => {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset + i]);
              } catch (e) {
                throw new FS.ErrnoError(29);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          } });
          return FS.mkdev(path, mode, dev);
        }, forceLoadFile: (obj) => {
          if (obj.isDevice || obj.isFolder || obj.link || obj.contents)
            return true;
          if (typeof XMLHttpRequest != "undefined") {
            throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
          } else if (read_) {
            try {
              obj.contents = intArrayFromString(read_(obj.url), true);
              obj.usedBytes = obj.contents.length;
            } catch (e) {
              throw new FS.ErrnoError(29);
            }
          } else {
            throw new Error("Cannot load without read() or XMLHttpRequest.");
          }
        }, createLazyFile: (parent, name, url, canRead, canWrite) => {
          function LazyUint8Array() {
            this.lengthKnown = false;
            this.chunks = [];
          }
          LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
            if (idx > this.length - 1 || idx < 0) {
              return void 0;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = idx / this.chunkSize | 0;
            return this.getter(chunkNum)[chunkOffset];
          };
          LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
            this.getter = getter;
          };
          LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
            var xhr = new XMLHttpRequest();
            xhr.open("HEAD", url, false);
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304))
              throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            var datalength = Number(xhr.getResponseHeader("Content-length"));
            var header;
            var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
            var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip";
            var chunkSize = 1024 * 1024;
            if (!hasByteServing)
              chunkSize = datalength;
            var doXHR = (from, to) => {
              if (from > to)
                throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
              if (to > datalength - 1)
                throw new Error("only " + datalength + " bytes available! programmer error!");
              var xhr2 = new XMLHttpRequest();
              xhr2.open("GET", url, false);
              if (datalength !== chunkSize)
                xhr2.setRequestHeader("Range", "bytes=" + from + "-" + to);
              xhr2.responseType = "arraybuffer";
              if (xhr2.overrideMimeType) {
                xhr2.overrideMimeType("text/plain; charset=x-user-defined");
              }
              xhr2.send(null);
              if (!(xhr2.status >= 200 && xhr2.status < 300 || xhr2.status === 304))
                throw new Error("Couldn't load " + url + ". Status: " + xhr2.status);
              if (xhr2.response !== void 0) {
                return new Uint8Array(xhr2.response || []);
              }
              return intArrayFromString(xhr2.responseText || "", true);
            };
            var lazyArray2 = this;
            lazyArray2.setDataGetter((chunkNum) => {
              var start = chunkNum * chunkSize;
              var end = (chunkNum + 1) * chunkSize - 1;
              end = Math.min(end, datalength - 1);
              if (typeof lazyArray2.chunks[chunkNum] == "undefined") {
                lazyArray2.chunks[chunkNum] = doXHR(start, end);
              }
              if (typeof lazyArray2.chunks[chunkNum] == "undefined")
                throw new Error("doXHR failed!");
              return lazyArray2.chunks[chunkNum];
            });
            if (usesGzip || !datalength) {
              chunkSize = datalength = 1;
              datalength = this.getter(0).length;
              chunkSize = datalength;
              out("LazyFiles on gzip forces download of the whole file when length is accessed");
            }
            this._length = datalength;
            this._chunkSize = chunkSize;
            this.lengthKnown = true;
          };
          if (typeof XMLHttpRequest != "undefined") {
            if (!ENVIRONMENT_IS_WORKER)
              throw "Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";
            var lazyArray = new LazyUint8Array();
            Object.defineProperties(lazyArray, { length: { get: function() {
              if (!this.lengthKnown) {
                this.cacheLength();
              }
              return this._length;
            } }, chunkSize: { get: function() {
              if (!this.lengthKnown) {
                this.cacheLength();
              }
              return this._chunkSize;
            } } });
            var properties = { isDevice: false, contents: lazyArray };
          } else {
            var properties = { isDevice: false, url };
          }
          var node = FS.createFile(parent, name, properties, canRead, canWrite);
          if (properties.contents) {
            node.contents = properties.contents;
          } else if (properties.url) {
            node.contents = null;
            node.url = properties.url;
          }
          Object.defineProperties(node, { usedBytes: { get: function() {
            return this.contents.length;
          } } });
          var stream_ops = {};
          var keys = Object.keys(node.stream_ops);
          keys.forEach((key) => {
            var fn = node.stream_ops[key];
            stream_ops[key] = function forceLoadLazyFile() {
              FS.forceLoadFile(node);
              return fn.apply(null, arguments);
            };
          });
          function writeChunks(stream, buffer, offset, length, position) {
            var contents = stream.node.contents;
            if (position >= contents.length)
              return 0;
            var size = Math.min(contents.length - position, length);
            if (contents.slice) {
              for (var i = 0; i < size; i++) {
                buffer[offset + i] = contents[position + i];
              }
            } else {
              for (var i = 0; i < size; i++) {
                buffer[offset + i] = contents.get(position + i);
              }
            }
            return size;
          }
          stream_ops.read = (stream, buffer, offset, length, position) => {
            FS.forceLoadFile(node);
            return writeChunks(stream, buffer, offset, length, position);
          };
          stream_ops.mmap = (stream, length, position, prot, flags) => {
            FS.forceLoadFile(node);
            var ptr = mmapAlloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(48);
            }
            writeChunks(stream, HEAP8, ptr, length, position);
            return { ptr, allocated: true };
          };
          node.stream_ops = stream_ops;
          return node;
        } };
        var SYSCALLS = { DEFAULT_POLLMASK: 5, calculateAt: function(dirfd, path, allowEmpty) {
          if (PATH.isAbs(path)) {
            return path;
          }
          var dir;
          if (dirfd === -100) {
            dir = FS.cwd();
          } else {
            var dirstream = SYSCALLS.getStreamFromFD(dirfd);
            dir = dirstream.path;
          }
          if (path.length == 0) {
            if (!allowEmpty) {
              throw new FS.ErrnoError(44);
            }
            return dir;
          }
          return PATH.join2(dir, path);
        }, doStat: function(func, path, buf) {
          try {
            var stat = func(path);
          } catch (e) {
            if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
              return -54;
            }
            throw e;
          }
          HEAP32[buf >>> 2] = stat.dev;
          HEAP32[buf + 4 >>> 2] = stat.mode;
          HEAPU32[buf + 8 >>> 2] = stat.nlink;
          HEAP32[buf + 12 >>> 2] = stat.uid;
          HEAP32[buf + 16 >>> 2] = stat.gid;
          HEAP32[buf + 20 >>> 2] = stat.rdev;
          tempI64 = [stat.size >>> 0, (tempDouble = stat.size, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[buf + 24 >>> 2] = tempI64[0], HEAP32[buf + 28 >>> 2] = tempI64[1];
          HEAP32[buf + 32 >>> 2] = 4096;
          HEAP32[buf + 36 >>> 2] = stat.blocks;
          var atime = stat.atime.getTime();
          var mtime = stat.mtime.getTime();
          var ctime = stat.ctime.getTime();
          tempI64 = [Math.floor(atime / 1e3) >>> 0, (tempDouble = Math.floor(atime / 1e3), +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[buf + 40 >>> 2] = tempI64[0], HEAP32[buf + 44 >>> 2] = tempI64[1];
          HEAPU32[buf + 48 >>> 2] = atime % 1e3 * 1e3;
          tempI64 = [Math.floor(mtime / 1e3) >>> 0, (tempDouble = Math.floor(mtime / 1e3), +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[buf + 56 >>> 2] = tempI64[0], HEAP32[buf + 60 >>> 2] = tempI64[1];
          HEAPU32[buf + 64 >>> 2] = mtime % 1e3 * 1e3;
          tempI64 = [Math.floor(ctime / 1e3) >>> 0, (tempDouble = Math.floor(ctime / 1e3), +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[buf + 72 >>> 2] = tempI64[0], HEAP32[buf + 76 >>> 2] = tempI64[1];
          HEAPU32[buf + 80 >>> 2] = ctime % 1e3 * 1e3;
          tempI64 = [stat.ino >>> 0, (tempDouble = stat.ino, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[buf + 88 >>> 2] = tempI64[0], HEAP32[buf + 92 >>> 2] = tempI64[1];
          return 0;
        }, doMsync: function(addr, stream, len, flags, offset) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          if (flags & 2) {
            return 0;
          }
          var buffer = HEAPU8.slice(addr, addr + len);
          FS.msync(stream, buffer, offset, len, flags);
        }, varargs: void 0, get() {
          SYSCALLS.varargs += 4;
          var ret = HEAP32[SYSCALLS.varargs - 4 >>> 2];
          return ret;
        }, getStr(ptr) {
          var ret = UTF8ToString(ptr);
          return ret;
        }, getStreamFromFD: function(fd) {
          var stream = FS.getStreamChecked(fd);
          return stream;
        } };
        function _environ_get(__environ, environ_buf) {
          __environ >>>= 0;
          environ_buf >>>= 0;
          var bufSize = 0;
          getEnvStrings().forEach(function(string, i) {
            var ptr = environ_buf + bufSize;
            HEAPU32[__environ + i * 4 >>> 2] = ptr;
            stringToAscii(string, ptr);
            bufSize += string.length + 1;
          });
          return 0;
        }
        function _environ_sizes_get(penviron_count, penviron_buf_size) {
          penviron_count >>>= 0;
          penviron_buf_size >>>= 0;
          var strings = getEnvStrings();
          HEAPU32[penviron_count >>> 2] = strings.length;
          var bufSize = 0;
          strings.forEach(function(string) {
            bufSize += string.length + 1;
          });
          HEAPU32[penviron_buf_size >>> 2] = bufSize;
          return 0;
        }
        function _fd_close(fd) {
          try {
            var stream = SYSCALLS.getStreamFromFD(fd);
            FS.close(stream);
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        function _fd_fdstat_get(fd, pbuf) {
          pbuf >>>= 0;
          try {
            var rightsBase = 0;
            var rightsInheriting = 0;
            var flags = 0;
            {
              var stream = SYSCALLS.getStreamFromFD(fd);
              var type = stream.tty ? 2 : FS.isDir(stream.mode) ? 3 : FS.isLink(stream.mode) ? 7 : 4;
            }
            HEAP8[pbuf >>> 0] = type;
            HEAP16[pbuf + 2 >>> 1] = flags;
            tempI64 = [rightsBase >>> 0, (tempDouble = rightsBase, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[pbuf + 8 >>> 2] = tempI64[0], HEAP32[pbuf + 12 >>> 2] = tempI64[1];
            tempI64 = [rightsInheriting >>> 0, (tempDouble = rightsInheriting, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[pbuf + 16 >>> 2] = tempI64[0], HEAP32[pbuf + 20 >>> 2] = tempI64[1];
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        var doReadv = (stream, iov, iovcnt, offset) => {
          var ret = 0;
          for (var i = 0; i < iovcnt; i++) {
            var ptr = HEAPU32[iov >>> 2];
            var len = HEAPU32[iov + 4 >>> 2];
            iov += 8;
            var curr = FS.read(stream, HEAP8, ptr, len, offset);
            if (curr < 0)
              return -1;
            ret += curr;
            if (curr < len)
              break;
            if (typeof offset !== "undefined") {
              offset += curr;
            }
          }
          return ret;
        };
        function _fd_read(fd, iov, iovcnt, pnum) {
          iov >>>= 0;
          iovcnt >>>= 0;
          pnum >>>= 0;
          try {
            var stream = SYSCALLS.getStreamFromFD(fd);
            var num = doReadv(stream, iov, iovcnt);
            HEAPU32[pnum >>> 2] = num;
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        function _fd_seek(fd, offset_low, offset_high, whence, newOffset) {
          var offset = convertI32PairToI53Checked(offset_low, offset_high);
          newOffset >>>= 0;
          try {
            if (isNaN(offset))
              return 61;
            var stream = SYSCALLS.getStreamFromFD(fd);
            FS.llseek(stream, offset, whence);
            tempI64 = [stream.position >>> 0, (tempDouble = stream.position, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? +Math.floor(tempDouble / 4294967296) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)], HEAP32[newOffset >>> 2] = tempI64[0], HEAP32[newOffset + 4 >>> 2] = tempI64[1];
            if (stream.getdents && offset === 0 && whence === 0)
              stream.getdents = null;
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        var doWritev = (stream, iov, iovcnt, offset) => {
          var ret = 0;
          for (var i = 0; i < iovcnt; i++) {
            var ptr = HEAPU32[iov >>> 2];
            var len = HEAPU32[iov + 4 >>> 2];
            iov += 8;
            var curr = FS.write(stream, HEAP8, ptr, len, offset);
            if (curr < 0)
              return -1;
            ret += curr;
            if (typeof offset !== "undefined") {
              offset += curr;
            }
          }
          return ret;
        };
        function _fd_write(fd, iov, iovcnt, pnum) {
          iov >>>= 0;
          iovcnt >>>= 0;
          pnum >>>= 0;
          try {
            var stream = SYSCALLS.getStreamFromFD(fd);
            var num = doWritev(stream, iov, iovcnt);
            HEAPU32[pnum >>> 2] = num;
            return 0;
          } catch (e) {
            if (typeof FS == "undefined" || !(e.name === "ErrnoError"))
              throw e;
            return e.errno;
          }
        }
        var arraySum = (array, index) => {
          var sum = 0;
          for (var i = 0; i <= index; sum += array[i++]) {
          }
          return sum;
        };
        var MONTH_DAYS_LEAP = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        var MONTH_DAYS_REGULAR = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        var addDays = (date, days) => {
          var newDate = new Date(date.getTime());
          while (days > 0) {
            var leap = isLeapYear(newDate.getFullYear());
            var currentMonth = newDate.getMonth();
            var daysInCurrentMonth = (leap ? MONTH_DAYS_LEAP : MONTH_DAYS_REGULAR)[currentMonth];
            if (days > daysInCurrentMonth - newDate.getDate()) {
              days -= daysInCurrentMonth - newDate.getDate() + 1;
              newDate.setDate(1);
              if (currentMonth < 11) {
                newDate.setMonth(currentMonth + 1);
              } else {
                newDate.setMonth(0);
                newDate.setFullYear(newDate.getFullYear() + 1);
              }
            } else {
              newDate.setDate(newDate.getDate() + days);
              return newDate;
            }
          }
          return newDate;
        };
        var writeArrayToMemory = (array, buffer) => {
          HEAP8.set(array, buffer >>> 0);
        };
        function _strftime(s, maxsize, format, tm) {
          s >>>= 0;
          maxsize >>>= 0;
          format >>>= 0;
          tm >>>= 0;
          var tm_zone = HEAP32[tm + 40 >>> 2];
          var date = { tm_sec: HEAP32[tm >>> 2], tm_min: HEAP32[tm + 4 >>> 2], tm_hour: HEAP32[tm + 8 >>> 2], tm_mday: HEAP32[tm + 12 >>> 2], tm_mon: HEAP32[tm + 16 >>> 2], tm_year: HEAP32[tm + 20 >>> 2], tm_wday: HEAP32[tm + 24 >>> 2], tm_yday: HEAP32[tm + 28 >>> 2], tm_isdst: HEAP32[tm + 32 >>> 2], tm_gmtoff: HEAP32[tm + 36 >>> 2], tm_zone: tm_zone ? UTF8ToString(tm_zone) : "" };
          var pattern = UTF8ToString(format);
          var EXPANSION_RULES_1 = { "%c": "%a %b %d %H:%M:%S %Y", "%D": "%m/%d/%y", "%F": "%Y-%m-%d", "%h": "%b", "%r": "%I:%M:%S %p", "%R": "%H:%M", "%T": "%H:%M:%S", "%x": "%m/%d/%y", "%X": "%H:%M:%S", "%Ec": "%c", "%EC": "%C", "%Ex": "%m/%d/%y", "%EX": "%H:%M:%S", "%Ey": "%y", "%EY": "%Y", "%Od": "%d", "%Oe": "%e", "%OH": "%H", "%OI": "%I", "%Om": "%m", "%OM": "%M", "%OS": "%S", "%Ou": "%u", "%OU": "%U", "%OV": "%V", "%Ow": "%w", "%OW": "%W", "%Oy": "%y" };
          for (var rule in EXPANSION_RULES_1) {
            pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_1[rule]);
          }
          var WEEKDAYS = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
          var MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
          function leadingSomething(value, digits, character) {
            var str = typeof value == "number" ? value.toString() : value || "";
            while (str.length < digits) {
              str = character[0] + str;
            }
            return str;
          }
          function leadingNulls(value, digits) {
            return leadingSomething(value, digits, "0");
          }
          function compareByDay(date1, date2) {
            function sgn(value) {
              return value < 0 ? -1 : value > 0 ? 1 : 0;
            }
            var compare;
            if ((compare = sgn(date1.getFullYear() - date2.getFullYear())) === 0) {
              if ((compare = sgn(date1.getMonth() - date2.getMonth())) === 0) {
                compare = sgn(date1.getDate() - date2.getDate());
              }
            }
            return compare;
          }
          function getFirstWeekStartDate(janFourth) {
            switch (janFourth.getDay()) {
              case 0:
                return new Date(janFourth.getFullYear() - 1, 11, 29);
              case 1:
                return janFourth;
              case 2:
                return new Date(janFourth.getFullYear(), 0, 3);
              case 3:
                return new Date(janFourth.getFullYear(), 0, 2);
              case 4:
                return new Date(janFourth.getFullYear(), 0, 1);
              case 5:
                return new Date(janFourth.getFullYear() - 1, 11, 31);
              case 6:
                return new Date(janFourth.getFullYear() - 1, 11, 30);
            }
          }
          function getWeekBasedYear(date2) {
            var thisDate = addDays(new Date(date2.tm_year + 1900, 0, 1), date2.tm_yday);
            var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
            var janFourthNextYear = new Date(thisDate.getFullYear() + 1, 0, 4);
            var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
            var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
            if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
              if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
                return thisDate.getFullYear() + 1;
              }
              return thisDate.getFullYear();
            }
            return thisDate.getFullYear() - 1;
          }
          var EXPANSION_RULES_2 = { "%a": (date2) => WEEKDAYS[date2.tm_wday].substring(0, 3), "%A": (date2) => WEEKDAYS[date2.tm_wday], "%b": (date2) => MONTHS[date2.tm_mon].substring(0, 3), "%B": (date2) => MONTHS[date2.tm_mon], "%C": (date2) => {
            var year = date2.tm_year + 1900;
            return leadingNulls(year / 100 | 0, 2);
          }, "%d": (date2) => leadingNulls(date2.tm_mday, 2), "%e": (date2) => leadingSomething(date2.tm_mday, 2, " "), "%g": (date2) => getWeekBasedYear(date2).toString().substring(2), "%G": (date2) => getWeekBasedYear(date2), "%H": (date2) => leadingNulls(date2.tm_hour, 2), "%I": (date2) => {
            var twelveHour = date2.tm_hour;
            if (twelveHour == 0)
              twelveHour = 12;
            else if (twelveHour > 12)
              twelveHour -= 12;
            return leadingNulls(twelveHour, 2);
          }, "%j": (date2) => leadingNulls(date2.tm_mday + arraySum(isLeapYear(date2.tm_year + 1900) ? MONTH_DAYS_LEAP : MONTH_DAYS_REGULAR, date2.tm_mon - 1), 3), "%m": (date2) => leadingNulls(date2.tm_mon + 1, 2), "%M": (date2) => leadingNulls(date2.tm_min, 2), "%n": () => "\n", "%p": (date2) => {
            if (date2.tm_hour >= 0 && date2.tm_hour < 12) {
              return "AM";
            }
            return "PM";
          }, "%S": (date2) => leadingNulls(date2.tm_sec, 2), "%t": () => "	", "%u": (date2) => date2.tm_wday || 7, "%U": (date2) => {
            var days = date2.tm_yday + 7 - date2.tm_wday;
            return leadingNulls(Math.floor(days / 7), 2);
          }, "%V": (date2) => {
            var val = Math.floor((date2.tm_yday + 7 - (date2.tm_wday + 6) % 7) / 7);
            if ((date2.tm_wday + 371 - date2.tm_yday - 2) % 7 <= 2) {
              val++;
            }
            if (!val) {
              val = 52;
              var dec31 = (date2.tm_wday + 7 - date2.tm_yday - 1) % 7;
              if (dec31 == 4 || dec31 == 5 && isLeapYear(date2.tm_year % 400 - 1)) {
                val++;
              }
            } else if (val == 53) {
              var jan1 = (date2.tm_wday + 371 - date2.tm_yday) % 7;
              if (jan1 != 4 && (jan1 != 3 || !isLeapYear(date2.tm_year)))
                val = 1;
            }
            return leadingNulls(val, 2);
          }, "%w": (date2) => date2.tm_wday, "%W": (date2) => {
            var days = date2.tm_yday + 7 - (date2.tm_wday + 6) % 7;
            return leadingNulls(Math.floor(days / 7), 2);
          }, "%y": (date2) => (date2.tm_year + 1900).toString().substring(2), "%Y": (date2) => date2.tm_year + 1900, "%z": (date2) => {
            var off = date2.tm_gmtoff;
            var ahead = off >= 0;
            off = Math.abs(off) / 60;
            off = off / 60 * 100 + off % 60;
            return (ahead ? "+" : "-") + String("0000" + off).slice(-4);
          }, "%Z": (date2) => date2.tm_zone, "%%": () => "%" };
          pattern = pattern.replace(/%%/g, "\0\0");
          for (var rule in EXPANSION_RULES_2) {
            if (pattern.includes(rule)) {
              pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_2[rule](date));
            }
          }
          pattern = pattern.replace(/\0\0/g, "%");
          var bytes = intArrayFromString(pattern, false);
          if (bytes.length > maxsize) {
            return 0;
          }
          writeArrayToMemory(bytes, s);
          return bytes.length - 1;
        }
        function _strftime_l(s, maxsize, format, tm, loc) {
          s >>>= 0;
          maxsize >>>= 0;
          format >>>= 0;
          tm >>>= 0;
          loc >>>= 0;
          return _strftime(s, maxsize, format, tm);
        }
        InternalError = Module["InternalError"] = class InternalError extends Error {
          constructor(message) {
            super(message);
            this.name = "InternalError";
          }
        };
        embind_init_charCodes();
        BindingError = Module["BindingError"] = class BindingError extends Error {
          constructor(message) {
            super(message);
            this.name = "BindingError";
          }
        };
        init_ClassHandle();
        init_embind();
        init_RegisteredPointer();
        UnboundTypeError = Module["UnboundTypeError"] = extendError(Error, "UnboundTypeError");
        handleAllocatorInit();
        init_emval();
        var FSNode = function(parent, name, mode, rdev) {
          if (!parent) {
            parent = this;
          }
          this.parent = parent;
          this.mount = parent.mount;
          this.mounted = null;
          this.id = FS.nextInode++;
          this.name = name;
          this.mode = mode;
          this.node_ops = {};
          this.stream_ops = {};
          this.rdev = rdev;
        };
        var readMode = 292 | 73;
        var writeMode = 146;
        Object.defineProperties(FSNode.prototype, { read: { get: function() {
          return (this.mode & readMode) === readMode;
        }, set: function(val) {
          val ? this.mode |= readMode : this.mode &= ~readMode;
        } }, write: { get: function() {
          return (this.mode & writeMode) === writeMode;
        }, set: function(val) {
          val ? this.mode |= writeMode : this.mode &= ~writeMode;
        } }, isFolder: { get: function() {
          return FS.isDir(this.mode);
        } }, isDevice: { get: function() {
          return FS.isChrdev(this.mode);
        } } });
        FS.FSNode = FSNode;
        FS.createPreloadedFile = FS_createPreloadedFile;
        FS.staticInit();
        var wasmImports = { f: ___cxa_throw, W: __embind_finalize_value_array, q: __embind_finalize_value_object, G: __embind_register_bigint, U: __embind_register_bool, p: __embind_register_class, o: __embind_register_class_constructor, b: __embind_register_class_function, T: __embind_register_emval, z: __embind_register_float, c: __embind_register_function, s: __embind_register_integer, k: __embind_register_memory_view, A: __embind_register_std_string, w: __embind_register_std_wstring, X: __embind_register_value_array, l: __embind_register_value_array_element, r: __embind_register_value_object, e: __embind_register_value_object_field, V: __embind_register_void, N: __emscripten_get_now_is_monotonic, j: __emval_as, v: __emval_call, a: __emval_decref, y: __emval_get_global, h: __emval_get_property, n: __emval_incref, C: __emval_instanceof, x: __emval_is_number, B: __emval_is_string, Y: __emval_new_array, g: __emval_new_cstring, t: __emval_new_object, i: __emval_run_destructors, m: __emval_set_property, d: __emval_take_value, E: __gmtime_js, F: __localtime_js, L: __tzset_js, u: _abort, O: _emscripten_date_now, S: _emscripten_memcpy_big, K: _emscripten_resize_heap, Q: _environ_get, R: _environ_sizes_get, I: _fd_close, P: _fd_fdstat_get, J: _fd_read, D: _fd_seek, M: _fd_write, H: _strftime_l };
        var asm = createWasm();
        var ___wasm_call_ctors = () => (___wasm_call_ctors = wasmExports["_"])();
        var _malloc = (a0) => (_malloc = wasmExports["aa"])(a0);
        var ___getTypeName = (a0) => (___getTypeName = wasmExports["ba"])(a0);
        var __embind_initialize_bindings = Module["__embind_initialize_bindings"] = () => (__embind_initialize_bindings = Module["__embind_initialize_bindings"] = wasmExports["ca"])();
        var ___errno_location = () => (___errno_location = wasmExports["__errno_location"])();
        var _free = (a0) => (_free = wasmExports["da"])(a0);
        var ___cxa_increment_exception_refcount = (a0) => (___cxa_increment_exception_refcount = wasmExports["__cxa_increment_exception_refcount"])(a0);
        var ___cxa_is_pointer_type = (a0) => (___cxa_is_pointer_type = wasmExports["ea"])(a0);
        var dynCall_jiji = Module["dynCall_jiji"] = (a0, a1, a2, a3, a4) => (dynCall_jiji = Module["dynCall_jiji"] = wasmExports["fa"])(a0, a1, a2, a3, a4);
        var dynCall_viijii = Module["dynCall_viijii"] = (a0, a1, a2, a3, a4, a5, a6) => (dynCall_viijii = Module["dynCall_viijii"] = wasmExports["ga"])(a0, a1, a2, a3, a4, a5, a6);
        var dynCall_iiiiij = Module["dynCall_iiiiij"] = (a0, a1, a2, a3, a4, a5, a6) => (dynCall_iiiiij = Module["dynCall_iiiiij"] = wasmExports["ha"])(a0, a1, a2, a3, a4, a5, a6);
        var dynCall_iiiiijj = Module["dynCall_iiiiijj"] = (a0, a1, a2, a3, a4, a5, a6, a7, a8) => (dynCall_iiiiijj = Module["dynCall_iiiiijj"] = wasmExports["ia"])(a0, a1, a2, a3, a4, a5, a6, a7, a8);
        var dynCall_iiiiiijj = Module["dynCall_iiiiiijj"] = (a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) => (dynCall_iiiiiijj = Module["dynCall_iiiiiijj"] = wasmExports["ja"])(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        function applySignatureConversions(exports2) {
          exports2 = Object.assign({}, exports2);
          var makeWrapper_pp = (f) => (a0) => f(a0) >>> 0;
          var makeWrapper_p = (f) => () => f() >>> 0;
          exports2["malloc"] = makeWrapper_pp(exports2["malloc"]);
          exports2["__getTypeName"] = makeWrapper_pp(exports2["__getTypeName"]);
          exports2["__errno_location"] = makeWrapper_p(exports2["__errno_location"]);
          exports2["stackSave"] = makeWrapper_p(exports2["stackSave"]);
          exports2["stackAlloc"] = makeWrapper_pp(exports2["stackAlloc"]);
          return exports2;
        }
        var calledRun;
        dependenciesFulfilled = function runCaller() {
          if (!calledRun)
            run();
          if (!calledRun)
            dependenciesFulfilled = runCaller;
        };
        function run() {
          if (runDependencies > 0) {
            return;
          }
          preRun();
          if (runDependencies > 0) {
            return;
          }
          function doRun() {
            if (calledRun)
              return;
            calledRun = true;
            Module["calledRun"] = true;
            if (ABORT)
              return;
            initRuntime();
            readyPromiseResolve(Module);
            if (Module["onRuntimeInitialized"])
              Module["onRuntimeInitialized"]();
            postRun();
          }
          if (Module["setStatus"]) {
            Module["setStatus"]("Running...");
            setTimeout(function() {
              setTimeout(function() {
                Module["setStatus"]("");
              }, 1);
              doRun();
            }, 1);
          } else {
            doRun();
          }
        }
        if (Module["preInit"]) {
          if (typeof Module["preInit"] == "function")
            Module["preInit"] = [Module["preInit"]];
          while (Module["preInit"].length > 0) {
            Module["preInit"].pop()();
          }
        }
        run();
        return moduleArg.ready;
      };
    })();
    if (typeof exports === "object" && typeof module2 === "object")
      module2.exports = WebIFCWasm2;
    else if (typeof define === "function" && define["amd"])
      define([], () => WebIFCWasm2);
  }
});

// dist/web-ifc-api.ts
__export(exports, {
  Constructors: () => Constructors,
  EMPTY: () => EMPTY,
  ENUM: () => ENUM,
  FILE_DESCRIPTION: () => FILE_DESCRIPTION,
  FILE_NAME: () => FILE_NAME,
  FILE_SCHEMA: () => FILE_SCHEMA,
  FromRawLineData: () => FromRawLineData,
  Handle: () => Handle,
  IFC2DCOMPOSITECURVE: () => IFC2DCOMPOSITECURVE,
  IFC2X3: () => IFC2X3,
  IFC4: () => IFC4,
  IFC4X3: () => IFC4X3,
  IFCABSORBEDDOSEMEASURE: () => IFCABSORBEDDOSEMEASURE,
  IFCACCELERATIONMEASURE: () => IFCACCELERATIONMEASURE,
  IFCACTIONREQUEST: () => IFCACTIONREQUEST,
  IFCACTOR: () => IFCACTOR,
  IFCACTORROLE: () => IFCACTORROLE,
  IFCACTUATOR: () => IFCACTUATOR,
  IFCACTUATORTYPE: () => IFCACTUATORTYPE,
  IFCADDRESS: () => IFCADDRESS,
  IFCADVANCEDBREP: () => IFCADVANCEDBREP,
  IFCADVANCEDBREPWITHVOIDS: () => IFCADVANCEDBREPWITHVOIDS,
  IFCADVANCEDFACE: () => IFCADVANCEDFACE,
  IFCAIRTERMINAL: () => IFCAIRTERMINAL,
  IFCAIRTERMINALBOX: () => IFCAIRTERMINALBOX,
  IFCAIRTERMINALBOXTYPE: () => IFCAIRTERMINALBOXTYPE,
  IFCAIRTERMINALTYPE: () => IFCAIRTERMINALTYPE,
  IFCAIRTOAIRHEATRECOVERY: () => IFCAIRTOAIRHEATRECOVERY,
  IFCAIRTOAIRHEATRECOVERYTYPE: () => IFCAIRTOAIRHEATRECOVERYTYPE,
  IFCALARM: () => IFCALARM,
  IFCALARMTYPE: () => IFCALARMTYPE,
  IFCALIGNMENT: () => IFCALIGNMENT,
  IFCALIGNMENTCANT: () => IFCALIGNMENTCANT,
  IFCALIGNMENTCANTSEGMENT: () => IFCALIGNMENTCANTSEGMENT,
  IFCALIGNMENTHORIZONTAL: () => IFCALIGNMENTHORIZONTAL,
  IFCALIGNMENTHORIZONTALSEGMENT: () => IFCALIGNMENTHORIZONTALSEGMENT,
  IFCALIGNMENTPARAMETERSEGMENT: () => IFCALIGNMENTPARAMETERSEGMENT,
  IFCALIGNMENTSEGMENT: () => IFCALIGNMENTSEGMENT,
  IFCALIGNMENTVERTICAL: () => IFCALIGNMENTVERTICAL,
  IFCALIGNMENTVERTICALSEGMENT: () => IFCALIGNMENTVERTICALSEGMENT,
  IFCAMOUNTOFSUBSTANCEMEASURE: () => IFCAMOUNTOFSUBSTANCEMEASURE,
  IFCANGULARDIMENSION: () => IFCANGULARDIMENSION,
  IFCANGULARVELOCITYMEASURE: () => IFCANGULARVELOCITYMEASURE,
  IFCANNOTATION: () => IFCANNOTATION,
  IFCANNOTATIONCURVEOCCURRENCE: () => IFCANNOTATIONCURVEOCCURRENCE,
  IFCANNOTATIONFILLAREA: () => IFCANNOTATIONFILLAREA,
  IFCANNOTATIONFILLAREAOCCURRENCE: () => IFCANNOTATIONFILLAREAOCCURRENCE,
  IFCANNOTATIONOCCURRENCE: () => IFCANNOTATIONOCCURRENCE,
  IFCANNOTATIONSURFACE: () => IFCANNOTATIONSURFACE,
  IFCANNOTATIONSURFACEOCCURRENCE: () => IFCANNOTATIONSURFACEOCCURRENCE,
  IFCANNOTATIONSYMBOLOCCURRENCE: () => IFCANNOTATIONSYMBOLOCCURRENCE,
  IFCANNOTATIONTEXTOCCURRENCE: () => IFCANNOTATIONTEXTOCCURRENCE,
  IFCAPPLICATION: () => IFCAPPLICATION,
  IFCAPPLIEDVALUE: () => IFCAPPLIEDVALUE,
  IFCAPPLIEDVALUERELATIONSHIP: () => IFCAPPLIEDVALUERELATIONSHIP,
  IFCAPPROVAL: () => IFCAPPROVAL,
  IFCAPPROVALACTORRELATIONSHIP: () => IFCAPPROVALACTORRELATIONSHIP,
  IFCAPPROVALPROPERTYRELATIONSHIP: () => IFCAPPROVALPROPERTYRELATIONSHIP,
  IFCAPPROVALRELATIONSHIP: () => IFCAPPROVALRELATIONSHIP,
  IFCARBITRARYCLOSEDPROFILEDEF: () => IFCARBITRARYCLOSEDPROFILEDEF,
  IFCARBITRARYOPENPROFILEDEF: () => IFCARBITRARYOPENPROFILEDEF,
  IFCARBITRARYPROFILEDEFWITHVOIDS: () => IFCARBITRARYPROFILEDEFWITHVOIDS,
  IFCARCINDEX: () => IFCARCINDEX,
  IFCAREADENSITYMEASURE: () => IFCAREADENSITYMEASURE,
  IFCAREAMEASURE: () => IFCAREAMEASURE,
  IFCASSET: () => IFCASSET,
  IFCASYMMETRICISHAPEPROFILEDEF: () => IFCASYMMETRICISHAPEPROFILEDEF,
  IFCAUDIOVISUALAPPLIANCE: () => IFCAUDIOVISUALAPPLIANCE,
  IFCAUDIOVISUALAPPLIANCETYPE: () => IFCAUDIOVISUALAPPLIANCETYPE,
  IFCAXIS1PLACEMENT: () => IFCAXIS1PLACEMENT,
  IFCAXIS2PLACEMENT2D: () => IFCAXIS2PLACEMENT2D,
  IFCAXIS2PLACEMENT3D: () => IFCAXIS2PLACEMENT3D,
  IFCAXIS2PLACEMENTLINEAR: () => IFCAXIS2PLACEMENTLINEAR,
  IFCBEAM: () => IFCBEAM,
  IFCBEAMSTANDARDCASE: () => IFCBEAMSTANDARDCASE,
  IFCBEAMTYPE: () => IFCBEAMTYPE,
  IFCBEARING: () => IFCBEARING,
  IFCBEARINGTYPE: () => IFCBEARINGTYPE,
  IFCBEZIERCURVE: () => IFCBEZIERCURVE,
  IFCBINARY: () => IFCBINARY,
  IFCBLOBTEXTURE: () => IFCBLOBTEXTURE,
  IFCBLOCK: () => IFCBLOCK,
  IFCBOILER: () => IFCBOILER,
  IFCBOILERTYPE: () => IFCBOILERTYPE,
  IFCBOOLEAN: () => IFCBOOLEAN,
  IFCBOOLEANCLIPPINGRESULT: () => IFCBOOLEANCLIPPINGRESULT,
  IFCBOOLEANRESULT: () => IFCBOOLEANRESULT,
  IFCBOREHOLE: () => IFCBOREHOLE,
  IFCBOUNDARYCONDITION: () => IFCBOUNDARYCONDITION,
  IFCBOUNDARYCURVE: () => IFCBOUNDARYCURVE,
  IFCBOUNDARYEDGECONDITION: () => IFCBOUNDARYEDGECONDITION,
  IFCBOUNDARYFACECONDITION: () => IFCBOUNDARYFACECONDITION,
  IFCBOUNDARYNODECONDITION: () => IFCBOUNDARYNODECONDITION,
  IFCBOUNDARYNODECONDITIONWARPING: () => IFCBOUNDARYNODECONDITIONWARPING,
  IFCBOUNDEDCURVE: () => IFCBOUNDEDCURVE,
  IFCBOUNDEDSURFACE: () => IFCBOUNDEDSURFACE,
  IFCBOUNDINGBOX: () => IFCBOUNDINGBOX,
  IFCBOXALIGNMENT: () => IFCBOXALIGNMENT,
  IFCBOXEDHALFSPACE: () => IFCBOXEDHALFSPACE,
  IFCBRIDGE: () => IFCBRIDGE,
  IFCBRIDGEPART: () => IFCBRIDGEPART,
  IFCBSPLINECURVE: () => IFCBSPLINECURVE,
  IFCBSPLINECURVEWITHKNOTS: () => IFCBSPLINECURVEWITHKNOTS,
  IFCBSPLINESURFACE: () => IFCBSPLINESURFACE,
  IFCBSPLINESURFACEWITHKNOTS: () => IFCBSPLINESURFACEWITHKNOTS,
  IFCBUILDING: () => IFCBUILDING,
  IFCBUILDINGELEMENT: () => IFCBUILDINGELEMENT,
  IFCBUILDINGELEMENTCOMPONENT: () => IFCBUILDINGELEMENTCOMPONENT,
  IFCBUILDINGELEMENTPART: () => IFCBUILDINGELEMENTPART,
  IFCBUILDINGELEMENTPARTTYPE: () => IFCBUILDINGELEMENTPARTTYPE,
  IFCBUILDINGELEMENTPROXY: () => IFCBUILDINGELEMENTPROXY,
  IFCBUILDINGELEMENTPROXYTYPE: () => IFCBUILDINGELEMENTPROXYTYPE,
  IFCBUILDINGELEMENTTYPE: () => IFCBUILDINGELEMENTTYPE,
  IFCBUILDINGSTOREY: () => IFCBUILDINGSTOREY,
  IFCBUILDINGSYSTEM: () => IFCBUILDINGSYSTEM,
  IFCBUILTELEMENT: () => IFCBUILTELEMENT,
  IFCBUILTELEMENTTYPE: () => IFCBUILTELEMENTTYPE,
  IFCBUILTSYSTEM: () => IFCBUILTSYSTEM,
  IFCBURNER: () => IFCBURNER,
  IFCBURNERTYPE: () => IFCBURNERTYPE,
  IFCCABLECARRIERFITTING: () => IFCCABLECARRIERFITTING,
  IFCCABLECARRIERFITTINGTYPE: () => IFCCABLECARRIERFITTINGTYPE,
  IFCCABLECARRIERSEGMENT: () => IFCCABLECARRIERSEGMENT,
  IFCCABLECARRIERSEGMENTTYPE: () => IFCCABLECARRIERSEGMENTTYPE,
  IFCCABLEFITTING: () => IFCCABLEFITTING,
  IFCCABLEFITTINGTYPE: () => IFCCABLEFITTINGTYPE,
  IFCCABLESEGMENT: () => IFCCABLESEGMENT,
  IFCCABLESEGMENTTYPE: () => IFCCABLESEGMENTTYPE,
  IFCCAISSONFOUNDATION: () => IFCCAISSONFOUNDATION,
  IFCCAISSONFOUNDATIONTYPE: () => IFCCAISSONFOUNDATIONTYPE,
  IFCCALENDARDATE: () => IFCCALENDARDATE,
  IFCCARDINALPOINTREFERENCE: () => IFCCARDINALPOINTREFERENCE,
  IFCCARTESIANPOINT: () => IFCCARTESIANPOINT,
  IFCCARTESIANPOINTLIST: () => IFCCARTESIANPOINTLIST,
  IFCCARTESIANPOINTLIST2D: () => IFCCARTESIANPOINTLIST2D,
  IFCCARTESIANPOINTLIST3D: () => IFCCARTESIANPOINTLIST3D,
  IFCCARTESIANTRANSFORMATIONOPERATOR: () => IFCCARTESIANTRANSFORMATIONOPERATOR,
  IFCCARTESIANTRANSFORMATIONOPERATOR2D: () => IFCCARTESIANTRANSFORMATIONOPERATOR2D,
  IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM: () => IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM,
  IFCCARTESIANTRANSFORMATIONOPERATOR3D: () => IFCCARTESIANTRANSFORMATIONOPERATOR3D,
  IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM: () => IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM,
  IFCCENTERLINEPROFILEDEF: () => IFCCENTERLINEPROFILEDEF,
  IFCCHAMFEREDGEFEATURE: () => IFCCHAMFEREDGEFEATURE,
  IFCCHILLER: () => IFCCHILLER,
  IFCCHILLERTYPE: () => IFCCHILLERTYPE,
  IFCCHIMNEY: () => IFCCHIMNEY,
  IFCCHIMNEYTYPE: () => IFCCHIMNEYTYPE,
  IFCCIRCLE: () => IFCCIRCLE,
  IFCCIRCLEHOLLOWPROFILEDEF: () => IFCCIRCLEHOLLOWPROFILEDEF,
  IFCCIRCLEPROFILEDEF: () => IFCCIRCLEPROFILEDEF,
  IFCCIVILELEMENT: () => IFCCIVILELEMENT,
  IFCCIVILELEMENTTYPE: () => IFCCIVILELEMENTTYPE,
  IFCCLASSIFICATION: () => IFCCLASSIFICATION,
  IFCCLASSIFICATIONITEM: () => IFCCLASSIFICATIONITEM,
  IFCCLASSIFICATIONITEMRELATIONSHIP: () => IFCCLASSIFICATIONITEMRELATIONSHIP,
  IFCCLASSIFICATIONNOTATION: () => IFCCLASSIFICATIONNOTATION,
  IFCCLASSIFICATIONNOTATIONFACET: () => IFCCLASSIFICATIONNOTATIONFACET,
  IFCCLASSIFICATIONREFERENCE: () => IFCCLASSIFICATIONREFERENCE,
  IFCCLOSEDSHELL: () => IFCCLOSEDSHELL,
  IFCCLOTHOID: () => IFCCLOTHOID,
  IFCCOIL: () => IFCCOIL,
  IFCCOILTYPE: () => IFCCOILTYPE,
  IFCCOLOURRGB: () => IFCCOLOURRGB,
  IFCCOLOURRGBLIST: () => IFCCOLOURRGBLIST,
  IFCCOLOURSPECIFICATION: () => IFCCOLOURSPECIFICATION,
  IFCCOLUMN: () => IFCCOLUMN,
  IFCCOLUMNSTANDARDCASE: () => IFCCOLUMNSTANDARDCASE,
  IFCCOLUMNTYPE: () => IFCCOLUMNTYPE,
  IFCCOMMUNICATIONSAPPLIANCE: () => IFCCOMMUNICATIONSAPPLIANCE,
  IFCCOMMUNICATIONSAPPLIANCETYPE: () => IFCCOMMUNICATIONSAPPLIANCETYPE,
  IFCCOMPLEXNUMBER: () => IFCCOMPLEXNUMBER,
  IFCCOMPLEXPROPERTY: () => IFCCOMPLEXPROPERTY,
  IFCCOMPLEXPROPERTYTEMPLATE: () => IFCCOMPLEXPROPERTYTEMPLATE,
  IFCCOMPOSITECURVE: () => IFCCOMPOSITECURVE,
  IFCCOMPOSITECURVEONSURFACE: () => IFCCOMPOSITECURVEONSURFACE,
  IFCCOMPOSITECURVESEGMENT: () => IFCCOMPOSITECURVESEGMENT,
  IFCCOMPOSITEPROFILEDEF: () => IFCCOMPOSITEPROFILEDEF,
  IFCCOMPOUNDPLANEANGLEMEASURE: () => IFCCOMPOUNDPLANEANGLEMEASURE,
  IFCCOMPRESSOR: () => IFCCOMPRESSOR,
  IFCCOMPRESSORTYPE: () => IFCCOMPRESSORTYPE,
  IFCCONDENSER: () => IFCCONDENSER,
  IFCCONDENSERTYPE: () => IFCCONDENSERTYPE,
  IFCCONDITION: () => IFCCONDITION,
  IFCCONDITIONCRITERION: () => IFCCONDITIONCRITERION,
  IFCCONIC: () => IFCCONIC,
  IFCCONNECTEDFACESET: () => IFCCONNECTEDFACESET,
  IFCCONNECTIONCURVEGEOMETRY: () => IFCCONNECTIONCURVEGEOMETRY,
  IFCCONNECTIONGEOMETRY: () => IFCCONNECTIONGEOMETRY,
  IFCCONNECTIONPOINTECCENTRICITY: () => IFCCONNECTIONPOINTECCENTRICITY,
  IFCCONNECTIONPOINTGEOMETRY: () => IFCCONNECTIONPOINTGEOMETRY,
  IFCCONNECTIONPORTGEOMETRY: () => IFCCONNECTIONPORTGEOMETRY,
  IFCCONNECTIONSURFACEGEOMETRY: () => IFCCONNECTIONSURFACEGEOMETRY,
  IFCCONNECTIONVOLUMEGEOMETRY: () => IFCCONNECTIONVOLUMEGEOMETRY,
  IFCCONSTRAINT: () => IFCCONSTRAINT,
  IFCCONSTRAINTAGGREGATIONRELATIONSHIP: () => IFCCONSTRAINTAGGREGATIONRELATIONSHIP,
  IFCCONSTRAINTCLASSIFICATIONRELATIONSHIP: () => IFCCONSTRAINTCLASSIFICATIONRELATIONSHIP,
  IFCCONSTRAINTRELATIONSHIP: () => IFCCONSTRAINTRELATIONSHIP,
  IFCCONSTRUCTIONEQUIPMENTRESOURCE: () => IFCCONSTRUCTIONEQUIPMENTRESOURCE,
  IFCCONSTRUCTIONEQUIPMENTRESOURCETYPE: () => IFCCONSTRUCTIONEQUIPMENTRESOURCETYPE,
  IFCCONSTRUCTIONMATERIALRESOURCE: () => IFCCONSTRUCTIONMATERIALRESOURCE,
  IFCCONSTRUCTIONMATERIALRESOURCETYPE: () => IFCCONSTRUCTIONMATERIALRESOURCETYPE,
  IFCCONSTRUCTIONPRODUCTRESOURCE: () => IFCCONSTRUCTIONPRODUCTRESOURCE,
  IFCCONSTRUCTIONPRODUCTRESOURCETYPE: () => IFCCONSTRUCTIONPRODUCTRESOURCETYPE,
  IFCCONSTRUCTIONRESOURCE: () => IFCCONSTRUCTIONRESOURCE,
  IFCCONSTRUCTIONRESOURCETYPE: () => IFCCONSTRUCTIONRESOURCETYPE,
  IFCCONTEXT: () => IFCCONTEXT,
  IFCCONTEXTDEPENDENTMEASURE: () => IFCCONTEXTDEPENDENTMEASURE,
  IFCCONTEXTDEPENDENTUNIT: () => IFCCONTEXTDEPENDENTUNIT,
  IFCCONTROL: () => IFCCONTROL,
  IFCCONTROLLER: () => IFCCONTROLLER,
  IFCCONTROLLERTYPE: () => IFCCONTROLLERTYPE,
  IFCCONVERSIONBASEDUNIT: () => IFCCONVERSIONBASEDUNIT,
  IFCCONVERSIONBASEDUNITWITHOFFSET: () => IFCCONVERSIONBASEDUNITWITHOFFSET,
  IFCCONVEYORSEGMENT: () => IFCCONVEYORSEGMENT,
  IFCCONVEYORSEGMENTTYPE: () => IFCCONVEYORSEGMENTTYPE,
  IFCCOOLEDBEAM: () => IFCCOOLEDBEAM,
  IFCCOOLEDBEAMTYPE: () => IFCCOOLEDBEAMTYPE,
  IFCCOOLINGTOWER: () => IFCCOOLINGTOWER,
  IFCCOOLINGTOWERTYPE: () => IFCCOOLINGTOWERTYPE,
  IFCCOORDINATEDUNIVERSALTIMEOFFSET: () => IFCCOORDINATEDUNIVERSALTIMEOFFSET,
  IFCCOORDINATEOPERATION: () => IFCCOORDINATEOPERATION,
  IFCCOORDINATEREFERENCESYSTEM: () => IFCCOORDINATEREFERENCESYSTEM,
  IFCCOSINESPIRAL: () => IFCCOSINESPIRAL,
  IFCCOSTITEM: () => IFCCOSTITEM,
  IFCCOSTSCHEDULE: () => IFCCOSTSCHEDULE,
  IFCCOSTVALUE: () => IFCCOSTVALUE,
  IFCCOUNTMEASURE: () => IFCCOUNTMEASURE,
  IFCCOURSE: () => IFCCOURSE,
  IFCCOURSETYPE: () => IFCCOURSETYPE,
  IFCCOVERING: () => IFCCOVERING,
  IFCCOVERINGTYPE: () => IFCCOVERINGTYPE,
  IFCCRANERAILASHAPEPROFILEDEF: () => IFCCRANERAILASHAPEPROFILEDEF,
  IFCCRANERAILFSHAPEPROFILEDEF: () => IFCCRANERAILFSHAPEPROFILEDEF,
  IFCCREWRESOURCE: () => IFCCREWRESOURCE,
  IFCCREWRESOURCETYPE: () => IFCCREWRESOURCETYPE,
  IFCCSGPRIMITIVE3D: () => IFCCSGPRIMITIVE3D,
  IFCCSGSOLID: () => IFCCSGSOLID,
  IFCCSHAPEPROFILEDEF: () => IFCCSHAPEPROFILEDEF,
  IFCCURRENCYRELATIONSHIP: () => IFCCURRENCYRELATIONSHIP,
  IFCCURTAINWALL: () => IFCCURTAINWALL,
  IFCCURTAINWALLTYPE: () => IFCCURTAINWALLTYPE,
  IFCCURVATUREMEASURE: () => IFCCURVATUREMEASURE,
  IFCCURVE: () => IFCCURVE,
  IFCCURVEBOUNDEDPLANE: () => IFCCURVEBOUNDEDPLANE,
  IFCCURVEBOUNDEDSURFACE: () => IFCCURVEBOUNDEDSURFACE,
  IFCCURVESEGMENT: () => IFCCURVESEGMENT,
  IFCCURVESTYLE: () => IFCCURVESTYLE,
  IFCCURVESTYLEFONT: () => IFCCURVESTYLEFONT,
  IFCCURVESTYLEFONTANDSCALING: () => IFCCURVESTYLEFONTANDSCALING,
  IFCCURVESTYLEFONTPATTERN: () => IFCCURVESTYLEFONTPATTERN,
  IFCCYLINDRICALSURFACE: () => IFCCYLINDRICALSURFACE,
  IFCDAMPER: () => IFCDAMPER,
  IFCDAMPERTYPE: () => IFCDAMPERTYPE,
  IFCDATE: () => IFCDATE,
  IFCDATEANDTIME: () => IFCDATEANDTIME,
  IFCDATETIME: () => IFCDATETIME,
  IFCDAYINMONTHNUMBER: () => IFCDAYINMONTHNUMBER,
  IFCDAYINWEEKNUMBER: () => IFCDAYINWEEKNUMBER,
  IFCDAYLIGHTSAVINGHOUR: () => IFCDAYLIGHTSAVINGHOUR,
  IFCDEEPFOUNDATION: () => IFCDEEPFOUNDATION,
  IFCDEEPFOUNDATIONTYPE: () => IFCDEEPFOUNDATIONTYPE,
  IFCDEFINEDSYMBOL: () => IFCDEFINEDSYMBOL,
  IFCDERIVEDPROFILEDEF: () => IFCDERIVEDPROFILEDEF,
  IFCDERIVEDUNIT: () => IFCDERIVEDUNIT,
  IFCDERIVEDUNITELEMENT: () => IFCDERIVEDUNITELEMENT,
  IFCDESCRIPTIVEMEASURE: () => IFCDESCRIPTIVEMEASURE,
  IFCDIAMETERDIMENSION: () => IFCDIAMETERDIMENSION,
  IFCDIMENSIONALEXPONENTS: () => IFCDIMENSIONALEXPONENTS,
  IFCDIMENSIONCALLOUTRELATIONSHIP: () => IFCDIMENSIONCALLOUTRELATIONSHIP,
  IFCDIMENSIONCOUNT: () => IFCDIMENSIONCOUNT,
  IFCDIMENSIONCURVE: () => IFCDIMENSIONCURVE,
  IFCDIMENSIONCURVEDIRECTEDCALLOUT: () => IFCDIMENSIONCURVEDIRECTEDCALLOUT,
  IFCDIMENSIONCURVETERMINATOR: () => IFCDIMENSIONCURVETERMINATOR,
  IFCDIMENSIONPAIR: () => IFCDIMENSIONPAIR,
  IFCDIRECTION: () => IFCDIRECTION,
  IFCDIRECTRIXCURVESWEPTAREASOLID: () => IFCDIRECTRIXCURVESWEPTAREASOLID,
  IFCDIRECTRIXDERIVEDREFERENCESWEPTAREASOLID: () => IFCDIRECTRIXDERIVEDREFERENCESWEPTAREASOLID,
  IFCDISCRETEACCESSORY: () => IFCDISCRETEACCESSORY,
  IFCDISCRETEACCESSORYTYPE: () => IFCDISCRETEACCESSORYTYPE,
  IFCDISTRIBUTIONBOARD: () => IFCDISTRIBUTIONBOARD,
  IFCDISTRIBUTIONBOARDTYPE: () => IFCDISTRIBUTIONBOARDTYPE,
  IFCDISTRIBUTIONCHAMBERELEMENT: () => IFCDISTRIBUTIONCHAMBERELEMENT,
  IFCDISTRIBUTIONCHAMBERELEMENTTYPE: () => IFCDISTRIBUTIONCHAMBERELEMENTTYPE,
  IFCDISTRIBUTIONCIRCUIT: () => IFCDISTRIBUTIONCIRCUIT,
  IFCDISTRIBUTIONCONTROLELEMENT: () => IFCDISTRIBUTIONCONTROLELEMENT,
  IFCDISTRIBUTIONCONTROLELEMENTTYPE: () => IFCDISTRIBUTIONCONTROLELEMENTTYPE,
  IFCDISTRIBUTIONELEMENT: () => IFCDISTRIBUTIONELEMENT,
  IFCDISTRIBUTIONELEMENTTYPE: () => IFCDISTRIBUTIONELEMENTTYPE,
  IFCDISTRIBUTIONFLOWELEMENT: () => IFCDISTRIBUTIONFLOWELEMENT,
  IFCDISTRIBUTIONFLOWELEMENTTYPE: () => IFCDISTRIBUTIONFLOWELEMENTTYPE,
  IFCDISTRIBUTIONPORT: () => IFCDISTRIBUTIONPORT,
  IFCDISTRIBUTIONSYSTEM: () => IFCDISTRIBUTIONSYSTEM,
  IFCDOCUMENTELECTRONICFORMAT: () => IFCDOCUMENTELECTRONICFORMAT,
  IFCDOCUMENTINFORMATION: () => IFCDOCUMENTINFORMATION,
  IFCDOCUMENTINFORMATIONRELATIONSHIP: () => IFCDOCUMENTINFORMATIONRELATIONSHIP,
  IFCDOCUMENTREFERENCE: () => IFCDOCUMENTREFERENCE,
  IFCDOOR: () => IFCDOOR,
  IFCDOORLININGPROPERTIES: () => IFCDOORLININGPROPERTIES,
  IFCDOORPANELPROPERTIES: () => IFCDOORPANELPROPERTIES,
  IFCDOORSTANDARDCASE: () => IFCDOORSTANDARDCASE,
  IFCDOORSTYLE: () => IFCDOORSTYLE,
  IFCDOORTYPE: () => IFCDOORTYPE,
  IFCDOSEEQUIVALENTMEASURE: () => IFCDOSEEQUIVALENTMEASURE,
  IFCDRAUGHTINGCALLOUT: () => IFCDRAUGHTINGCALLOUT,
  IFCDRAUGHTINGCALLOUTRELATIONSHIP: () => IFCDRAUGHTINGCALLOUTRELATIONSHIP,
  IFCDRAUGHTINGPREDEFINEDCOLOUR: () => IFCDRAUGHTINGPREDEFINEDCOLOUR,
  IFCDRAUGHTINGPREDEFINEDCURVEFONT: () => IFCDRAUGHTINGPREDEFINEDCURVEFONT,
  IFCDRAUGHTINGPREDEFINEDTEXTFONT: () => IFCDRAUGHTINGPREDEFINEDTEXTFONT,
  IFCDUCTFITTING: () => IFCDUCTFITTING,
  IFCDUCTFITTINGTYPE: () => IFCDUCTFITTINGTYPE,
  IFCDUCTSEGMENT: () => IFCDUCTSEGMENT,
  IFCDUCTSEGMENTTYPE: () => IFCDUCTSEGMENTTYPE,
  IFCDUCTSILENCER: () => IFCDUCTSILENCER,
  IFCDUCTSILENCERTYPE: () => IFCDUCTSILENCERTYPE,
  IFCDURATION: () => IFCDURATION,
  IFCDYNAMICVISCOSITYMEASURE: () => IFCDYNAMICVISCOSITYMEASURE,
  IFCEARTHWORKSCUT: () => IFCEARTHWORKSCUT,
  IFCEARTHWORKSELEMENT: () => IFCEARTHWORKSELEMENT,
  IFCEARTHWORKSFILL: () => IFCEARTHWORKSFILL,
  IFCEDGE: () => IFCEDGE,
  IFCEDGECURVE: () => IFCEDGECURVE,
  IFCEDGEFEATURE: () => IFCEDGEFEATURE,
  IFCEDGELOOP: () => IFCEDGELOOP,
  IFCELECTRICALBASEPROPERTIES: () => IFCELECTRICALBASEPROPERTIES,
  IFCELECTRICALCIRCUIT: () => IFCELECTRICALCIRCUIT,
  IFCELECTRICALELEMENT: () => IFCELECTRICALELEMENT,
  IFCELECTRICAPPLIANCE: () => IFCELECTRICAPPLIANCE,
  IFCELECTRICAPPLIANCETYPE: () => IFCELECTRICAPPLIANCETYPE,
  IFCELECTRICCAPACITANCEMEASURE: () => IFCELECTRICCAPACITANCEMEASURE,
  IFCELECTRICCHARGEMEASURE: () => IFCELECTRICCHARGEMEASURE,
  IFCELECTRICCONDUCTANCEMEASURE: () => IFCELECTRICCONDUCTANCEMEASURE,
  IFCELECTRICCURRENTMEASURE: () => IFCELECTRICCURRENTMEASURE,
  IFCELECTRICDISTRIBUTIONBOARD: () => IFCELECTRICDISTRIBUTIONBOARD,
  IFCELECTRICDISTRIBUTIONBOARDTYPE: () => IFCELECTRICDISTRIBUTIONBOARDTYPE,
  IFCELECTRICDISTRIBUTIONPOINT: () => IFCELECTRICDISTRIBUTIONPOINT,
  IFCELECTRICFLOWSTORAGEDEVICE: () => IFCELECTRICFLOWSTORAGEDEVICE,
  IFCELECTRICFLOWSTORAGEDEVICETYPE: () => IFCELECTRICFLOWSTORAGEDEVICETYPE,
  IFCELECTRICFLOWTREATMENTDEVICE: () => IFCELECTRICFLOWTREATMENTDEVICE,
  IFCELECTRICFLOWTREATMENTDEVICETYPE: () => IFCELECTRICFLOWTREATMENTDEVICETYPE,
  IFCELECTRICGENERATOR: () => IFCELECTRICGENERATOR,
  IFCELECTRICGENERATORTYPE: () => IFCELECTRICGENERATORTYPE,
  IFCELECTRICHEATERTYPE: () => IFCELECTRICHEATERTYPE,
  IFCELECTRICMOTOR: () => IFCELECTRICMOTOR,
  IFCELECTRICMOTORTYPE: () => IFCELECTRICMOTORTYPE,
  IFCELECTRICRESISTANCEMEASURE: () => IFCELECTRICRESISTANCEMEASURE,
  IFCELECTRICTIMECONTROL: () => IFCELECTRICTIMECONTROL,
  IFCELECTRICTIMECONTROLTYPE: () => IFCELECTRICTIMECONTROLTYPE,
  IFCELECTRICVOLTAGEMEASURE: () => IFCELECTRICVOLTAGEMEASURE,
  IFCELEMENT: () => IFCELEMENT,
  IFCELEMENTARYSURFACE: () => IFCELEMENTARYSURFACE,
  IFCELEMENTASSEMBLY: () => IFCELEMENTASSEMBLY,
  IFCELEMENTASSEMBLYTYPE: () => IFCELEMENTASSEMBLYTYPE,
  IFCELEMENTCOMPONENT: () => IFCELEMENTCOMPONENT,
  IFCELEMENTCOMPONENTTYPE: () => IFCELEMENTCOMPONENTTYPE,
  IFCELEMENTQUANTITY: () => IFCELEMENTQUANTITY,
  IFCELEMENTTYPE: () => IFCELEMENTTYPE,
  IFCELLIPSE: () => IFCELLIPSE,
  IFCELLIPSEPROFILEDEF: () => IFCELLIPSEPROFILEDEF,
  IFCENERGYCONVERSIONDEVICE: () => IFCENERGYCONVERSIONDEVICE,
  IFCENERGYCONVERSIONDEVICETYPE: () => IFCENERGYCONVERSIONDEVICETYPE,
  IFCENERGYMEASURE: () => IFCENERGYMEASURE,
  IFCENERGYPROPERTIES: () => IFCENERGYPROPERTIES,
  IFCENGINE: () => IFCENGINE,
  IFCENGINETYPE: () => IFCENGINETYPE,
  IFCENVIRONMENTALIMPACTVALUE: () => IFCENVIRONMENTALIMPACTVALUE,
  IFCEQUIPMENTELEMENT: () => IFCEQUIPMENTELEMENT,
  IFCEQUIPMENTSTANDARD: () => IFCEQUIPMENTSTANDARD,
  IFCEVAPORATIVECOOLER: () => IFCEVAPORATIVECOOLER,
  IFCEVAPORATIVECOOLERTYPE: () => IFCEVAPORATIVECOOLERTYPE,
  IFCEVAPORATOR: () => IFCEVAPORATOR,
  IFCEVAPORATORTYPE: () => IFCEVAPORATORTYPE,
  IFCEVENT: () => IFCEVENT,
  IFCEVENTTIME: () => IFCEVENTTIME,
  IFCEVENTTYPE: () => IFCEVENTTYPE,
  IFCEXTENDEDMATERIALPROPERTIES: () => IFCEXTENDEDMATERIALPROPERTIES,
  IFCEXTENDEDPROPERTIES: () => IFCEXTENDEDPROPERTIES,
  IFCEXTERNALINFORMATION: () => IFCEXTERNALINFORMATION,
  IFCEXTERNALLYDEFINEDHATCHSTYLE: () => IFCEXTERNALLYDEFINEDHATCHSTYLE,
  IFCEXTERNALLYDEFINEDSURFACESTYLE: () => IFCEXTERNALLYDEFINEDSURFACESTYLE,
  IFCEXTERNALLYDEFINEDSYMBOL: () => IFCEXTERNALLYDEFINEDSYMBOL,
  IFCEXTERNALLYDEFINEDTEXTFONT: () => IFCEXTERNALLYDEFINEDTEXTFONT,
  IFCEXTERNALREFERENCE: () => IFCEXTERNALREFERENCE,
  IFCEXTERNALREFERENCERELATIONSHIP: () => IFCEXTERNALREFERENCERELATIONSHIP,
  IFCEXTERNALSPATIALELEMENT: () => IFCEXTERNALSPATIALELEMENT,
  IFCEXTERNALSPATIALSTRUCTUREELEMENT: () => IFCEXTERNALSPATIALSTRUCTUREELEMENT,
  IFCEXTRUDEDAREASOLID: () => IFCEXTRUDEDAREASOLID,
  IFCEXTRUDEDAREASOLIDTAPERED: () => IFCEXTRUDEDAREASOLIDTAPERED,
  IFCFACE: () => IFCFACE,
  IFCFACEBASEDSURFACEMODEL: () => IFCFACEBASEDSURFACEMODEL,
  IFCFACEBOUND: () => IFCFACEBOUND,
  IFCFACEOUTERBOUND: () => IFCFACEOUTERBOUND,
  IFCFACESURFACE: () => IFCFACESURFACE,
  IFCFACETEDBREP: () => IFCFACETEDBREP,
  IFCFACETEDBREPWITHVOIDS: () => IFCFACETEDBREPWITHVOIDS,
  IFCFACILITY: () => IFCFACILITY,
  IFCFACILITYPART: () => IFCFACILITYPART,
  IFCFACILITYPARTCOMMON: () => IFCFACILITYPARTCOMMON,
  IFCFAILURECONNECTIONCONDITION: () => IFCFAILURECONNECTIONCONDITION,
  IFCFAN: () => IFCFAN,
  IFCFANTYPE: () => IFCFANTYPE,
  IFCFASTENER: () => IFCFASTENER,
  IFCFASTENERTYPE: () => IFCFASTENERTYPE,
  IFCFEATUREELEMENT: () => IFCFEATUREELEMENT,
  IFCFEATUREELEMENTADDITION: () => IFCFEATUREELEMENTADDITION,
  IFCFEATUREELEMENTSUBTRACTION: () => IFCFEATUREELEMENTSUBTRACTION,
  IFCFILLAREASTYLE: () => IFCFILLAREASTYLE,
  IFCFILLAREASTYLEHATCHING: () => IFCFILLAREASTYLEHATCHING,
  IFCFILLAREASTYLETILES: () => IFCFILLAREASTYLETILES,
  IFCFILLAREASTYLETILESYMBOLWITHSTYLE: () => IFCFILLAREASTYLETILESYMBOLWITHSTYLE,
  IFCFILTER: () => IFCFILTER,
  IFCFILTERTYPE: () => IFCFILTERTYPE,
  IFCFIRESUPPRESSIONTERMINAL: () => IFCFIRESUPPRESSIONTERMINAL,
  IFCFIRESUPPRESSIONTERMINALTYPE: () => IFCFIRESUPPRESSIONTERMINALTYPE,
  IFCFIXEDREFERENCESWEPTAREASOLID: () => IFCFIXEDREFERENCESWEPTAREASOLID,
  IFCFLOWCONTROLLER: () => IFCFLOWCONTROLLER,
  IFCFLOWCONTROLLERTYPE: () => IFCFLOWCONTROLLERTYPE,
  IFCFLOWFITTING: () => IFCFLOWFITTING,
  IFCFLOWFITTINGTYPE: () => IFCFLOWFITTINGTYPE,
  IFCFLOWINSTRUMENT: () => IFCFLOWINSTRUMENT,
  IFCFLOWINSTRUMENTTYPE: () => IFCFLOWINSTRUMENTTYPE,
  IFCFLOWMETER: () => IFCFLOWMETER,
  IFCFLOWMETERTYPE: () => IFCFLOWMETERTYPE,
  IFCFLOWMOVINGDEVICE: () => IFCFLOWMOVINGDEVICE,
  IFCFLOWMOVINGDEVICETYPE: () => IFCFLOWMOVINGDEVICETYPE,
  IFCFLOWSEGMENT: () => IFCFLOWSEGMENT,
  IFCFLOWSEGMENTTYPE: () => IFCFLOWSEGMENTTYPE,
  IFCFLOWSTORAGEDEVICE: () => IFCFLOWSTORAGEDEVICE,
  IFCFLOWSTORAGEDEVICETYPE: () => IFCFLOWSTORAGEDEVICETYPE,
  IFCFLOWTERMINAL: () => IFCFLOWTERMINAL,
  IFCFLOWTERMINALTYPE: () => IFCFLOWTERMINALTYPE,
  IFCFLOWTREATMENTDEVICE: () => IFCFLOWTREATMENTDEVICE,
  IFCFLOWTREATMENTDEVICETYPE: () => IFCFLOWTREATMENTDEVICETYPE,
  IFCFLUIDFLOWPROPERTIES: () => IFCFLUIDFLOWPROPERTIES,
  IFCFONTSTYLE: () => IFCFONTSTYLE,
  IFCFONTVARIANT: () => IFCFONTVARIANT,
  IFCFONTWEIGHT: () => IFCFONTWEIGHT,
  IFCFOOTING: () => IFCFOOTING,
  IFCFOOTINGTYPE: () => IFCFOOTINGTYPE,
  IFCFORCEMEASURE: () => IFCFORCEMEASURE,
  IFCFREQUENCYMEASURE: () => IFCFREQUENCYMEASURE,
  IFCFUELPROPERTIES: () => IFCFUELPROPERTIES,
  IFCFURNISHINGELEMENT: () => IFCFURNISHINGELEMENT,
  IFCFURNISHINGELEMENTTYPE: () => IFCFURNISHINGELEMENTTYPE,
  IFCFURNITURE: () => IFCFURNITURE,
  IFCFURNITURESTANDARD: () => IFCFURNITURESTANDARD,
  IFCFURNITURETYPE: () => IFCFURNITURETYPE,
  IFCGASTERMINALTYPE: () => IFCGASTERMINALTYPE,
  IFCGENERALMATERIALPROPERTIES: () => IFCGENERALMATERIALPROPERTIES,
  IFCGENERALPROFILEPROPERTIES: () => IFCGENERALPROFILEPROPERTIES,
  IFCGEOGRAPHICELEMENT: () => IFCGEOGRAPHICELEMENT,
  IFCGEOGRAPHICELEMENTTYPE: () => IFCGEOGRAPHICELEMENTTYPE,
  IFCGEOMETRICCURVESET: () => IFCGEOMETRICCURVESET,
  IFCGEOMETRICREPRESENTATIONCONTEXT: () => IFCGEOMETRICREPRESENTATIONCONTEXT,
  IFCGEOMETRICREPRESENTATIONITEM: () => IFCGEOMETRICREPRESENTATIONITEM,
  IFCGEOMETRICREPRESENTATIONSUBCONTEXT: () => IFCGEOMETRICREPRESENTATIONSUBCONTEXT,
  IFCGEOMETRICSET: () => IFCGEOMETRICSET,
  IFCGEOMODEL: () => IFCGEOMODEL,
  IFCGEOSLICE: () => IFCGEOSLICE,
  IFCGEOTECHNICALASSEMBLY: () => IFCGEOTECHNICALASSEMBLY,
  IFCGEOTECHNICALELEMENT: () => IFCGEOTECHNICALELEMENT,
  IFCGEOTECHNICALSTRATUM: () => IFCGEOTECHNICALSTRATUM,
  IFCGLOBALLYUNIQUEID: () => IFCGLOBALLYUNIQUEID,
  IFCGRADIENTCURVE: () => IFCGRADIENTCURVE,
  IFCGRID: () => IFCGRID,
  IFCGRIDAXIS: () => IFCGRIDAXIS,
  IFCGRIDPLACEMENT: () => IFCGRIDPLACEMENT,
  IFCGROUP: () => IFCGROUP,
  IFCHALFSPACESOLID: () => IFCHALFSPACESOLID,
  IFCHEATEXCHANGER: () => IFCHEATEXCHANGER,
  IFCHEATEXCHANGERTYPE: () => IFCHEATEXCHANGERTYPE,
  IFCHEATFLUXDENSITYMEASURE: () => IFCHEATFLUXDENSITYMEASURE,
  IFCHEATINGVALUEMEASURE: () => IFCHEATINGVALUEMEASURE,
  IFCHOURINDAY: () => IFCHOURINDAY,
  IFCHUMIDIFIER: () => IFCHUMIDIFIER,
  IFCHUMIDIFIERTYPE: () => IFCHUMIDIFIERTYPE,
  IFCHYGROSCOPICMATERIALPROPERTIES: () => IFCHYGROSCOPICMATERIALPROPERTIES,
  IFCIDENTIFIER: () => IFCIDENTIFIER,
  IFCILLUMINANCEMEASURE: () => IFCILLUMINANCEMEASURE,
  IFCIMAGETEXTURE: () => IFCIMAGETEXTURE,
  IFCIMPACTPROTECTIONDEVICE: () => IFCIMPACTPROTECTIONDEVICE,
  IFCIMPACTPROTECTIONDEVICETYPE: () => IFCIMPACTPROTECTIONDEVICETYPE,
  IFCINDEXEDCOLOURMAP: () => IFCINDEXEDCOLOURMAP,
  IFCINDEXEDPOLYCURVE: () => IFCINDEXEDPOLYCURVE,
  IFCINDEXEDPOLYGONALFACE: () => IFCINDEXEDPOLYGONALFACE,
  IFCINDEXEDPOLYGONALFACEWITHVOIDS: () => IFCINDEXEDPOLYGONALFACEWITHVOIDS,
  IFCINDEXEDPOLYGONALTEXTUREMAP: () => IFCINDEXEDPOLYGONALTEXTUREMAP,
  IFCINDEXEDTEXTUREMAP: () => IFCINDEXEDTEXTUREMAP,
  IFCINDEXEDTRIANGLETEXTUREMAP: () => IFCINDEXEDTRIANGLETEXTUREMAP,
  IFCINDUCTANCEMEASURE: () => IFCINDUCTANCEMEASURE,
  IFCINTEGER: () => IFCINTEGER,
  IFCINTEGERCOUNTRATEMEASURE: () => IFCINTEGERCOUNTRATEMEASURE,
  IFCINTERCEPTOR: () => IFCINTERCEPTOR,
  IFCINTERCEPTORTYPE: () => IFCINTERCEPTORTYPE,
  IFCINTERSECTIONCURVE: () => IFCINTERSECTIONCURVE,
  IFCINVENTORY: () => IFCINVENTORY,
  IFCIONCONCENTRATIONMEASURE: () => IFCIONCONCENTRATIONMEASURE,
  IFCIRREGULARTIMESERIES: () => IFCIRREGULARTIMESERIES,
  IFCIRREGULARTIMESERIESVALUE: () => IFCIRREGULARTIMESERIESVALUE,
  IFCISHAPEPROFILEDEF: () => IFCISHAPEPROFILEDEF,
  IFCISOTHERMALMOISTURECAPACITYMEASURE: () => IFCISOTHERMALMOISTURECAPACITYMEASURE,
  IFCJUNCTIONBOX: () => IFCJUNCTIONBOX,
  IFCJUNCTIONBOXTYPE: () => IFCJUNCTIONBOXTYPE,
  IFCKERB: () => IFCKERB,
  IFCKERBTYPE: () => IFCKERBTYPE,
  IFCKINEMATICVISCOSITYMEASURE: () => IFCKINEMATICVISCOSITYMEASURE,
  IFCLABEL: () => IFCLABEL,
  IFCLABORRESOURCE: () => IFCLABORRESOURCE,
  IFCLABORRESOURCETYPE: () => IFCLABORRESOURCETYPE,
  IFCLAGTIME: () => IFCLAGTIME,
  IFCLAMP: () => IFCLAMP,
  IFCLAMPTYPE: () => IFCLAMPTYPE,
  IFCLANGUAGEID: () => IFCLANGUAGEID,
  IFCLENGTHMEASURE: () => IFCLENGTHMEASURE,
  IFCLIBRARYINFORMATION: () => IFCLIBRARYINFORMATION,
  IFCLIBRARYREFERENCE: () => IFCLIBRARYREFERENCE,
  IFCLIGHTDISTRIBUTIONDATA: () => IFCLIGHTDISTRIBUTIONDATA,
  IFCLIGHTFIXTURE: () => IFCLIGHTFIXTURE,
  IFCLIGHTFIXTURETYPE: () => IFCLIGHTFIXTURETYPE,
  IFCLIGHTINTENSITYDISTRIBUTION: () => IFCLIGHTINTENSITYDISTRIBUTION,
  IFCLIGHTSOURCE: () => IFCLIGHTSOURCE,
  IFCLIGHTSOURCEAMBIENT: () => IFCLIGHTSOURCEAMBIENT,
  IFCLIGHTSOURCEDIRECTIONAL: () => IFCLIGHTSOURCEDIRECTIONAL,
  IFCLIGHTSOURCEGONIOMETRIC: () => IFCLIGHTSOURCEGONIOMETRIC,
  IFCLIGHTSOURCEPOSITIONAL: () => IFCLIGHTSOURCEPOSITIONAL,
  IFCLIGHTSOURCESPOT: () => IFCLIGHTSOURCESPOT,
  IFCLINE: () => IFCLINE,
  IFCLINEARDIMENSION: () => IFCLINEARDIMENSION,
  IFCLINEARELEMENT: () => IFCLINEARELEMENT,
  IFCLINEARFORCEMEASURE: () => IFCLINEARFORCEMEASURE,
  IFCLINEARMOMENTMEASURE: () => IFCLINEARMOMENTMEASURE,
  IFCLINEARPLACEMENT: () => IFCLINEARPLACEMENT,
  IFCLINEARPOSITIONINGELEMENT: () => IFCLINEARPOSITIONINGELEMENT,
  IFCLINEARSTIFFNESSMEASURE: () => IFCLINEARSTIFFNESSMEASURE,
  IFCLINEARVELOCITYMEASURE: () => IFCLINEARVELOCITYMEASURE,
  IFCLINEINDEX: () => IFCLINEINDEX,
  IFCLIQUIDTERMINAL: () => IFCLIQUIDTERMINAL,
  IFCLIQUIDTERMINALTYPE: () => IFCLIQUIDTERMINALTYPE,
  IFCLOCALPLACEMENT: () => IFCLOCALPLACEMENT,
  IFCLOCALTIME: () => IFCLOCALTIME,
  IFCLOGICAL: () => IFCLOGICAL,
  IFCLOOP: () => IFCLOOP,
  IFCLSHAPEPROFILEDEF: () => IFCLSHAPEPROFILEDEF,
  IFCLUMINOUSFLUXMEASURE: () => IFCLUMINOUSFLUXMEASURE,
  IFCLUMINOUSINTENSITYDISTRIBUTIONMEASURE: () => IFCLUMINOUSINTENSITYDISTRIBUTIONMEASURE,
  IFCLUMINOUSINTENSITYMEASURE: () => IFCLUMINOUSINTENSITYMEASURE,
  IFCMAGNETICFLUXDENSITYMEASURE: () => IFCMAGNETICFLUXDENSITYMEASURE,
  IFCMAGNETICFLUXMEASURE: () => IFCMAGNETICFLUXMEASURE,
  IFCMANIFOLDSOLIDBREP: () => IFCMANIFOLDSOLIDBREP,
  IFCMAPCONVERSION: () => IFCMAPCONVERSION,
  IFCMAPPEDITEM: () => IFCMAPPEDITEM,
  IFCMARINEFACILITY: () => IFCMARINEFACILITY,
  IFCMARINEPART: () => IFCMARINEPART,
  IFCMASSDENSITYMEASURE: () => IFCMASSDENSITYMEASURE,
  IFCMASSFLOWRATEMEASURE: () => IFCMASSFLOWRATEMEASURE,
  IFCMASSMEASURE: () => IFCMASSMEASURE,
  IFCMASSPERLENGTHMEASURE: () => IFCMASSPERLENGTHMEASURE,
  IFCMATERIAL: () => IFCMATERIAL,
  IFCMATERIALCLASSIFICATIONRELATIONSHIP: () => IFCMATERIALCLASSIFICATIONRELATIONSHIP,
  IFCMATERIALCONSTITUENT: () => IFCMATERIALCONSTITUENT,
  IFCMATERIALCONSTITUENTSET: () => IFCMATERIALCONSTITUENTSET,
  IFCMATERIALDEFINITION: () => IFCMATERIALDEFINITION,
  IFCMATERIALDEFINITIONREPRESENTATION: () => IFCMATERIALDEFINITIONREPRESENTATION,
  IFCMATERIALLAYER: () => IFCMATERIALLAYER,
  IFCMATERIALLAYERSET: () => IFCMATERIALLAYERSET,
  IFCMATERIALLAYERSETUSAGE: () => IFCMATERIALLAYERSETUSAGE,
  IFCMATERIALLAYERWITHOFFSETS: () => IFCMATERIALLAYERWITHOFFSETS,
  IFCMATERIALLIST: () => IFCMATERIALLIST,
  IFCMATERIALPROFILE: () => IFCMATERIALPROFILE,
  IFCMATERIALPROFILESET: () => IFCMATERIALPROFILESET,
  IFCMATERIALPROFILESETUSAGE: () => IFCMATERIALPROFILESETUSAGE,
  IFCMATERIALPROFILESETUSAGETAPERING: () => IFCMATERIALPROFILESETUSAGETAPERING,
  IFCMATERIALPROFILEWITHOFFSETS: () => IFCMATERIALPROFILEWITHOFFSETS,
  IFCMATERIALPROPERTIES: () => IFCMATERIALPROPERTIES,
  IFCMATERIALRELATIONSHIP: () => IFCMATERIALRELATIONSHIP,
  IFCMATERIALUSAGEDEFINITION: () => IFCMATERIALUSAGEDEFINITION,
  IFCMEASUREWITHUNIT: () => IFCMEASUREWITHUNIT,
  IFCMECHANICALCONCRETEMATERIALPROPERTIES: () => IFCMECHANICALCONCRETEMATERIALPROPERTIES,
  IFCMECHANICALFASTENER: () => IFCMECHANICALFASTENER,
  IFCMECHANICALFASTENERTYPE: () => IFCMECHANICALFASTENERTYPE,
  IFCMECHANICALMATERIALPROPERTIES: () => IFCMECHANICALMATERIALPROPERTIES,
  IFCMECHANICALSTEELMATERIALPROPERTIES: () => IFCMECHANICALSTEELMATERIALPROPERTIES,
  IFCMEDICALDEVICE: () => IFCMEDICALDEVICE,
  IFCMEDICALDEVICETYPE: () => IFCMEDICALDEVICETYPE,
  IFCMEMBER: () => IFCMEMBER,
  IFCMEMBERSTANDARDCASE: () => IFCMEMBERSTANDARDCASE,
  IFCMEMBERTYPE: () => IFCMEMBERTYPE,
  IFCMETRIC: () => IFCMETRIC,
  IFCMINUTEINHOUR: () => IFCMINUTEINHOUR,
  IFCMIRROREDPROFILEDEF: () => IFCMIRROREDPROFILEDEF,
  IFCMOBILETELECOMMUNICATIONSAPPLIANCE: () => IFCMOBILETELECOMMUNICATIONSAPPLIANCE,
  IFCMOBILETELECOMMUNICATIONSAPPLIANCETYPE: () => IFCMOBILETELECOMMUNICATIONSAPPLIANCETYPE,
  IFCMODULUSOFELASTICITYMEASURE: () => IFCMODULUSOFELASTICITYMEASURE,
  IFCMODULUSOFLINEARSUBGRADEREACTIONMEASURE: () => IFCMODULUSOFLINEARSUBGRADEREACTIONMEASURE,
  IFCMODULUSOFROTATIONALSUBGRADEREACTIONMEASURE: () => IFCMODULUSOFROTATIONALSUBGRADEREACTIONMEASURE,
  IFCMODULUSOFSUBGRADEREACTIONMEASURE: () => IFCMODULUSOFSUBGRADEREACTIONMEASURE,
  IFCMOISTUREDIFFUSIVITYMEASURE: () => IFCMOISTUREDIFFUSIVITYMEASURE,
  IFCMOLECULARWEIGHTMEASURE: () => IFCMOLECULARWEIGHTMEASURE,
  IFCMOMENTOFINERTIAMEASURE: () => IFCMOMENTOFINERTIAMEASURE,
  IFCMONETARYMEASURE: () => IFCMONETARYMEASURE,
  IFCMONETARYUNIT: () => IFCMONETARYUNIT,
  IFCMONTHINYEARNUMBER: () => IFCMONTHINYEARNUMBER,
  IFCMOORINGDEVICE: () => IFCMOORINGDEVICE,
  IFCMOORINGDEVICETYPE: () => IFCMOORINGDEVICETYPE,
  IFCMOTORCONNECTION: () => IFCMOTORCONNECTION,
  IFCMOTORCONNECTIONTYPE: () => IFCMOTORCONNECTIONTYPE,
  IFCMOVE: () => IFCMOVE,
  IFCNAMEDUNIT: () => IFCNAMEDUNIT,
  IFCNAVIGATIONELEMENT: () => IFCNAVIGATIONELEMENT,
  IFCNAVIGATIONELEMENTTYPE: () => IFCNAVIGATIONELEMENTTYPE,
  IFCNONNEGATIVELENGTHMEASURE: () => IFCNONNEGATIVELENGTHMEASURE,
  IFCNORMALISEDRATIOMEASURE: () => IFCNORMALISEDRATIOMEASURE,
  IFCNUMERICMEASURE: () => IFCNUMERICMEASURE,
  IFCOBJECT: () => IFCOBJECT,
  IFCOBJECTDEFINITION: () => IFCOBJECTDEFINITION,
  IFCOBJECTIVE: () => IFCOBJECTIVE,
  IFCOBJECTPLACEMENT: () => IFCOBJECTPLACEMENT,
  IFCOCCUPANT: () => IFCOCCUPANT,
  IFCOFFSETCURVE: () => IFCOFFSETCURVE,
  IFCOFFSETCURVE2D: () => IFCOFFSETCURVE2D,
  IFCOFFSETCURVE3D: () => IFCOFFSETCURVE3D,
  IFCOFFSETCURVEBYDISTANCES: () => IFCOFFSETCURVEBYDISTANCES,
  IFCONEDIRECTIONREPEATFACTOR: () => IFCONEDIRECTIONREPEATFACTOR,
  IFCOPENCROSSPROFILEDEF: () => IFCOPENCROSSPROFILEDEF,
  IFCOPENINGELEMENT: () => IFCOPENINGELEMENT,
  IFCOPENINGSTANDARDCASE: () => IFCOPENINGSTANDARDCASE,
  IFCOPENSHELL: () => IFCOPENSHELL,
  IFCOPTICALMATERIALPROPERTIES: () => IFCOPTICALMATERIALPROPERTIES,
  IFCORDERACTION: () => IFCORDERACTION,
  IFCORGANIZATION: () => IFCORGANIZATION,
  IFCORGANIZATIONRELATIONSHIP: () => IFCORGANIZATIONRELATIONSHIP,
  IFCORIENTEDEDGE: () => IFCORIENTEDEDGE,
  IFCOUTERBOUNDARYCURVE: () => IFCOUTERBOUNDARYCURVE,
  IFCOUTLET: () => IFCOUTLET,
  IFCOUTLETTYPE: () => IFCOUTLETTYPE,
  IFCOWNERHISTORY: () => IFCOWNERHISTORY,
  IFCPARAMETERIZEDPROFILEDEF: () => IFCPARAMETERIZEDPROFILEDEF,
  IFCPARAMETERVALUE: () => IFCPARAMETERVALUE,
  IFCPATH: () => IFCPATH,
  IFCPAVEMENT: () => IFCPAVEMENT,
  IFCPAVEMENTTYPE: () => IFCPAVEMENTTYPE,
  IFCPCURVE: () => IFCPCURVE,
  IFCPERFORMANCEHISTORY: () => IFCPERFORMANCEHISTORY,
  IFCPERMEABLECOVERINGPROPERTIES: () => IFCPERMEABLECOVERINGPROPERTIES,
  IFCPERMIT: () => IFCPERMIT,
  IFCPERSON: () => IFCPERSON,
  IFCPERSONANDORGANIZATION: () => IFCPERSONANDORGANIZATION,
  IFCPHMEASURE: () => IFCPHMEASURE,
  IFCPHYSICALCOMPLEXQUANTITY: () => IFCPHYSICALCOMPLEXQUANTITY,
  IFCPHYSICALQUANTITY: () => IFCPHYSICALQUANTITY,
  IFCPHYSICALSIMPLEQUANTITY: () => IFCPHYSICALSIMPLEQUANTITY,
  IFCPILE: () => IFCPILE,
  IFCPILETYPE: () => IFCPILETYPE,
  IFCPIPEFITTING: () => IFCPIPEFITTING,
  IFCPIPEFITTINGTYPE: () => IFCPIPEFITTINGTYPE,
  IFCPIPESEGMENT: () => IFCPIPESEGMENT,
  IFCPIPESEGMENTTYPE: () => IFCPIPESEGMENTTYPE,
  IFCPIXELTEXTURE: () => IFCPIXELTEXTURE,
  IFCPLACEMENT: () => IFCPLACEMENT,
  IFCPLANARBOX: () => IFCPLANARBOX,
  IFCPLANAREXTENT: () => IFCPLANAREXTENT,
  IFCPLANARFORCEMEASURE: () => IFCPLANARFORCEMEASURE,
  IFCPLANE: () => IFCPLANE,
  IFCPLANEANGLEMEASURE: () => IFCPLANEANGLEMEASURE,
  IFCPLATE: () => IFCPLATE,
  IFCPLATESTANDARDCASE: () => IFCPLATESTANDARDCASE,
  IFCPLATETYPE: () => IFCPLATETYPE,
  IFCPOINT: () => IFCPOINT,
  IFCPOINTBYDISTANCEEXPRESSION: () => IFCPOINTBYDISTANCEEXPRESSION,
  IFCPOINTONCURVE: () => IFCPOINTONCURVE,
  IFCPOINTONSURFACE: () => IFCPOINTONSURFACE,
  IFCPOLYGONALBOUNDEDHALFSPACE: () => IFCPOLYGONALBOUNDEDHALFSPACE,
  IFCPOLYGONALFACESET: () => IFCPOLYGONALFACESET,
  IFCPOLYLINE: () => IFCPOLYLINE,
  IFCPOLYLOOP: () => IFCPOLYLOOP,
  IFCPOLYNOMIALCURVE: () => IFCPOLYNOMIALCURVE,
  IFCPORT: () => IFCPORT,
  IFCPOSITIONINGELEMENT: () => IFCPOSITIONINGELEMENT,
  IFCPOSITIVEINTEGER: () => IFCPOSITIVEINTEGER,
  IFCPOSITIVELENGTHMEASURE: () => IFCPOSITIVELENGTHMEASURE,
  IFCPOSITIVEPLANEANGLEMEASURE: () => IFCPOSITIVEPLANEANGLEMEASURE,
  IFCPOSITIVERATIOMEASURE: () => IFCPOSITIVERATIOMEASURE,
  IFCPOSTALADDRESS: () => IFCPOSTALADDRESS,
  IFCPOWERMEASURE: () => IFCPOWERMEASURE,
  IFCPREDEFINEDCOLOUR: () => IFCPREDEFINEDCOLOUR,
  IFCPREDEFINEDCURVEFONT: () => IFCPREDEFINEDCURVEFONT,
  IFCPREDEFINEDDIMENSIONSYMBOL: () => IFCPREDEFINEDDIMENSIONSYMBOL,
  IFCPREDEFINEDITEM: () => IFCPREDEFINEDITEM,
  IFCPREDEFINEDPOINTMARKERSYMBOL: () => IFCPREDEFINEDPOINTMARKERSYMBOL,
  IFCPREDEFINEDPROPERTIES: () => IFCPREDEFINEDPROPERTIES,
  IFCPREDEFINEDPROPERTYSET: () => IFCPREDEFINEDPROPERTYSET,
  IFCPREDEFINEDSYMBOL: () => IFCPREDEFINEDSYMBOL,
  IFCPREDEFINEDTERMINATORSYMBOL: () => IFCPREDEFINEDTERMINATORSYMBOL,
  IFCPREDEFINEDTEXTFONT: () => IFCPREDEFINEDTEXTFONT,
  IFCPRESENTABLETEXT: () => IFCPRESENTABLETEXT,
  IFCPRESENTATIONITEM: () => IFCPRESENTATIONITEM,
  IFCPRESENTATIONLAYERASSIGNMENT: () => IFCPRESENTATIONLAYERASSIGNMENT,
  IFCPRESENTATIONLAYERWITHSTYLE: () => IFCPRESENTATIONLAYERWITHSTYLE,
  IFCPRESENTATIONSTYLE: () => IFCPRESENTATIONSTYLE,
  IFCPRESENTATIONSTYLEASSIGNMENT: () => IFCPRESENTATIONSTYLEASSIGNMENT,
  IFCPRESSUREMEASURE: () => IFCPRESSUREMEASURE,
  IFCPROCEDURE: () => IFCPROCEDURE,
  IFCPROCEDURETYPE: () => IFCPROCEDURETYPE,
  IFCPROCESS: () => IFCPROCESS,
  IFCPRODUCT: () => IFCPRODUCT,
  IFCPRODUCTDEFINITIONSHAPE: () => IFCPRODUCTDEFINITIONSHAPE,
  IFCPRODUCTREPRESENTATION: () => IFCPRODUCTREPRESENTATION,
  IFCPRODUCTSOFCOMBUSTIONPROPERTIES: () => IFCPRODUCTSOFCOMBUSTIONPROPERTIES,
  IFCPROFILEDEF: () => IFCPROFILEDEF,
  IFCPROFILEPROPERTIES: () => IFCPROFILEPROPERTIES,
  IFCPROJECT: () => IFCPROJECT,
  IFCPROJECTEDCRS: () => IFCPROJECTEDCRS,
  IFCPROJECTIONCURVE: () => IFCPROJECTIONCURVE,
  IFCPROJECTIONELEMENT: () => IFCPROJECTIONELEMENT,
  IFCPROJECTLIBRARY: () => IFCPROJECTLIBRARY,
  IFCPROJECTORDER: () => IFCPROJECTORDER,
  IFCPROJECTORDERRECORD: () => IFCPROJECTORDERRECORD,
  IFCPROPERTY: () => IFCPROPERTY,
  IFCPROPERTYABSTRACTION: () => IFCPROPERTYABSTRACTION,
  IFCPROPERTYBOUNDEDVALUE: () => IFCPROPERTYBOUNDEDVALUE,
  IFCPROPERTYCONSTRAINTRELATIONSHIP: () => IFCPROPERTYCONSTRAINTRELATIONSHIP,
  IFCPROPERTYDEFINITION: () => IFCPROPERTYDEFINITION,
  IFCPROPERTYDEPENDENCYRELATIONSHIP: () => IFCPROPERTYDEPENDENCYRELATIONSHIP,
  IFCPROPERTYENUMERATEDVALUE: () => IFCPROPERTYENUMERATEDVALUE,
  IFCPROPERTYENUMERATION: () => IFCPROPERTYENUMERATION,
  IFCPROPERTYLISTVALUE: () => IFCPROPERTYLISTVALUE,
  IFCPROPERTYREFERENCEVALUE: () => IFCPROPERTYREFERENCEVALUE,
  IFCPROPERTYSET: () => IFCPROPERTYSET,
  IFCPROPERTYSETDEFINITION: () => IFCPROPERTYSETDEFINITION,
  IFCPROPERTYSETDEFINITIONSET: () => IFCPROPERTYSETDEFINITIONSET,
  IFCPROPERTYSETTEMPLATE: () => IFCPROPERTYSETTEMPLATE,
  IFCPROPERTYSINGLEVALUE: () => IFCPROPERTYSINGLEVALUE,
  IFCPROPERTYTABLEVALUE: () => IFCPROPERTYTABLEVALUE,
  IFCPROPERTYTEMPLATE: () => IFCPROPERTYTEMPLATE,
  IFCPROPERTYTEMPLATEDEFINITION: () => IFCPROPERTYTEMPLATEDEFINITION,
  IFCPROTECTIVEDEVICE: () => IFCPROTECTIVEDEVICE,
  IFCPROTECTIVEDEVICETRIPPINGUNIT: () => IFCPROTECTIVEDEVICETRIPPINGUNIT,
  IFCPROTECTIVEDEVICETRIPPINGUNITTYPE: () => IFCPROTECTIVEDEVICETRIPPINGUNITTYPE,
  IFCPROTECTIVEDEVICETYPE: () => IFCPROTECTIVEDEVICETYPE,
  IFCPROXY: () => IFCPROXY,
  IFCPUMP: () => IFCPUMP,
  IFCPUMPTYPE: () => IFCPUMPTYPE,
  IFCQUANTITYAREA: () => IFCQUANTITYAREA,
  IFCQUANTITYCOUNT: () => IFCQUANTITYCOUNT,
  IFCQUANTITYLENGTH: () => IFCQUANTITYLENGTH,
  IFCQUANTITYNUMBER: () => IFCQUANTITYNUMBER,
  IFCQUANTITYSET: () => IFCQUANTITYSET,
  IFCQUANTITYTIME: () => IFCQUANTITYTIME,
  IFCQUANTITYVOLUME: () => IFCQUANTITYVOLUME,
  IFCQUANTITYWEIGHT: () => IFCQUANTITYWEIGHT,
  IFCRADIOACTIVITYMEASURE: () => IFCRADIOACTIVITYMEASURE,
  IFCRADIUSDIMENSION: () => IFCRADIUSDIMENSION,
  IFCRAIL: () => IFCRAIL,
  IFCRAILING: () => IFCRAILING,
  IFCRAILINGTYPE: () => IFCRAILINGTYPE,
  IFCRAILTYPE: () => IFCRAILTYPE,
  IFCRAILWAY: () => IFCRAILWAY,
  IFCRAILWAYPART: () => IFCRAILWAYPART,
  IFCRAMP: () => IFCRAMP,
  IFCRAMPFLIGHT: () => IFCRAMPFLIGHT,
  IFCRAMPFLIGHTTYPE: () => IFCRAMPFLIGHTTYPE,
  IFCRAMPTYPE: () => IFCRAMPTYPE,
  IFCRATIOMEASURE: () => IFCRATIOMEASURE,
  IFCRATIONALBEZIERCURVE: () => IFCRATIONALBEZIERCURVE,
  IFCRATIONALBSPLINECURVEWITHKNOTS: () => IFCRATIONALBSPLINECURVEWITHKNOTS,
  IFCRATIONALBSPLINESURFACEWITHKNOTS: () => IFCRATIONALBSPLINESURFACEWITHKNOTS,
  IFCREAL: () => IFCREAL,
  IFCRECTANGLEHOLLOWPROFILEDEF: () => IFCRECTANGLEHOLLOWPROFILEDEF,
  IFCRECTANGLEPROFILEDEF: () => IFCRECTANGLEPROFILEDEF,
  IFCRECTANGULARPYRAMID: () => IFCRECTANGULARPYRAMID,
  IFCRECTANGULARTRIMMEDSURFACE: () => IFCRECTANGULARTRIMMEDSURFACE,
  IFCRECURRENCEPATTERN: () => IFCRECURRENCEPATTERN,
  IFCREFERENCE: () => IFCREFERENCE,
  IFCREFERENCESVALUEDOCUMENT: () => IFCREFERENCESVALUEDOCUMENT,
  IFCREFERENT: () => IFCREFERENT,
  IFCREGULARTIMESERIES: () => IFCREGULARTIMESERIES,
  IFCREINFORCEDSOIL: () => IFCREINFORCEDSOIL,
  IFCREINFORCEMENTBARPROPERTIES: () => IFCREINFORCEMENTBARPROPERTIES,
  IFCREINFORCEMENTDEFINITIONPROPERTIES: () => IFCREINFORCEMENTDEFINITIONPROPERTIES,
  IFCREINFORCINGBAR: () => IFCREINFORCINGBAR,
  IFCREINFORCINGBARTYPE: () => IFCREINFORCINGBARTYPE,
  IFCREINFORCINGELEMENT: () => IFCREINFORCINGELEMENT,
  IFCREINFORCINGELEMENTTYPE: () => IFCREINFORCINGELEMENTTYPE,
  IFCREINFORCINGMESH: () => IFCREINFORCINGMESH,
  IFCREINFORCINGMESHTYPE: () => IFCREINFORCINGMESHTYPE,
  IFCRELADHERESTOELEMENT: () => IFCRELADHERESTOELEMENT,
  IFCRELAGGREGATES: () => IFCRELAGGREGATES,
  IFCRELASSIGNS: () => IFCRELASSIGNS,
  IFCRELASSIGNSTASKS: () => IFCRELASSIGNSTASKS,
  IFCRELASSIGNSTOACTOR: () => IFCRELASSIGNSTOACTOR,
  IFCRELASSIGNSTOCONTROL: () => IFCRELASSIGNSTOCONTROL,
  IFCRELASSIGNSTOGROUP: () => IFCRELASSIGNSTOGROUP,
  IFCRELASSIGNSTOGROUPBYFACTOR: () => IFCRELASSIGNSTOGROUPBYFACTOR,
  IFCRELASSIGNSTOPROCESS: () => IFCRELASSIGNSTOPROCESS,
  IFCRELASSIGNSTOPRODUCT: () => IFCRELASSIGNSTOPRODUCT,
  IFCRELASSIGNSTOPROJECTORDER: () => IFCRELASSIGNSTOPROJECTORDER,
  IFCRELASSIGNSTORESOURCE: () => IFCRELASSIGNSTORESOURCE,
  IFCRELASSOCIATES: () => IFCRELASSOCIATES,
  IFCRELASSOCIATESAPPLIEDVALUE: () => IFCRELASSOCIATESAPPLIEDVALUE,
  IFCRELASSOCIATESAPPROVAL: () => IFCRELASSOCIATESAPPROVAL,
  IFCRELASSOCIATESCLASSIFICATION: () => IFCRELASSOCIATESCLASSIFICATION,
  IFCRELASSOCIATESCONSTRAINT: () => IFCRELASSOCIATESCONSTRAINT,
  IFCRELASSOCIATESDOCUMENT: () => IFCRELASSOCIATESDOCUMENT,
  IFCRELASSOCIATESLIBRARY: () => IFCRELASSOCIATESLIBRARY,
  IFCRELASSOCIATESMATERIAL: () => IFCRELASSOCIATESMATERIAL,
  IFCRELASSOCIATESPROFILEDEF: () => IFCRELASSOCIATESPROFILEDEF,
  IFCRELASSOCIATESPROFILEPROPERTIES: () => IFCRELASSOCIATESPROFILEPROPERTIES,
  IFCRELATIONSHIP: () => IFCRELATIONSHIP,
  IFCRELAXATION: () => IFCRELAXATION,
  IFCRELCONNECTS: () => IFCRELCONNECTS,
  IFCRELCONNECTSELEMENTS: () => IFCRELCONNECTSELEMENTS,
  IFCRELCONNECTSPATHELEMENTS: () => IFCRELCONNECTSPATHELEMENTS,
  IFCRELCONNECTSPORTS: () => IFCRELCONNECTSPORTS,
  IFCRELCONNECTSPORTTOELEMENT: () => IFCRELCONNECTSPORTTOELEMENT,
  IFCRELCONNECTSSTRUCTURALACTIVITY: () => IFCRELCONNECTSSTRUCTURALACTIVITY,
  IFCRELCONNECTSSTRUCTURALELEMENT: () => IFCRELCONNECTSSTRUCTURALELEMENT,
  IFCRELCONNECTSSTRUCTURALMEMBER: () => IFCRELCONNECTSSTRUCTURALMEMBER,
  IFCRELCONNECTSWITHECCENTRICITY: () => IFCRELCONNECTSWITHECCENTRICITY,
  IFCRELCONNECTSWITHREALIZINGELEMENTS: () => IFCRELCONNECTSWITHREALIZINGELEMENTS,
  IFCRELCONTAINEDINSPATIALSTRUCTURE: () => IFCRELCONTAINEDINSPATIALSTRUCTURE,
  IFCRELCOVERSBLDGELEMENTS: () => IFCRELCOVERSBLDGELEMENTS,
  IFCRELCOVERSSPACES: () => IFCRELCOVERSSPACES,
  IFCRELDECLARES: () => IFCRELDECLARES,
  IFCRELDECOMPOSES: () => IFCRELDECOMPOSES,
  IFCRELDEFINES: () => IFCRELDEFINES,
  IFCRELDEFINESBYOBJECT: () => IFCRELDEFINESBYOBJECT,
  IFCRELDEFINESBYPROPERTIES: () => IFCRELDEFINESBYPROPERTIES,
  IFCRELDEFINESBYTEMPLATE: () => IFCRELDEFINESBYTEMPLATE,
  IFCRELDEFINESBYTYPE: () => IFCRELDEFINESBYTYPE,
  IFCRELFILLSELEMENT: () => IFCRELFILLSELEMENT,
  IFCRELFLOWCONTROLELEMENTS: () => IFCRELFLOWCONTROLELEMENTS,
  IFCRELINTERACTIONREQUIREMENTS: () => IFCRELINTERACTIONREQUIREMENTS,
  IFCRELINTERFERESELEMENTS: () => IFCRELINTERFERESELEMENTS,
  IFCRELNESTS: () => IFCRELNESTS,
  IFCRELOCCUPIESSPACES: () => IFCRELOCCUPIESSPACES,
  IFCRELOVERRIDESPROPERTIES: () => IFCRELOVERRIDESPROPERTIES,
  IFCRELPOSITIONS: () => IFCRELPOSITIONS,
  IFCRELPROJECTSELEMENT: () => IFCRELPROJECTSELEMENT,
  IFCRELREFERENCEDINSPATIALSTRUCTURE: () => IFCRELREFERENCEDINSPATIALSTRUCTURE,
  IFCRELSCHEDULESCOSTITEMS: () => IFCRELSCHEDULESCOSTITEMS,
  IFCRELSEQUENCE: () => IFCRELSEQUENCE,
  IFCRELSERVICESBUILDINGS: () => IFCRELSERVICESBUILDINGS,
  IFCRELSPACEBOUNDARY: () => IFCRELSPACEBOUNDARY,
  IFCRELSPACEBOUNDARY1STLEVEL: () => IFCRELSPACEBOUNDARY1STLEVEL,
  IFCRELSPACEBOUNDARY2NDLEVEL: () => IFCRELSPACEBOUNDARY2NDLEVEL,
  IFCRELVOIDSELEMENT: () => IFCRELVOIDSELEMENT,
  IFCREPARAMETRISEDCOMPOSITECURVESEGMENT: () => IFCREPARAMETRISEDCOMPOSITECURVESEGMENT,
  IFCREPRESENTATION: () => IFCREPRESENTATION,
  IFCREPRESENTATIONCONTEXT: () => IFCREPRESENTATIONCONTEXT,
  IFCREPRESENTATIONITEM: () => IFCREPRESENTATIONITEM,
  IFCREPRESENTATIONMAP: () => IFCREPRESENTATIONMAP,
  IFCRESOURCE: () => IFCRESOURCE,
  IFCRESOURCEAPPROVALRELATIONSHIP: () => IFCRESOURCEAPPROVALRELATIONSHIP,
  IFCRESOURCECONSTRAINTRELATIONSHIP: () => IFCRESOURCECONSTRAINTRELATIONSHIP,
  IFCRESOURCELEVELRELATIONSHIP: () => IFCRESOURCELEVELRELATIONSHIP,
  IFCRESOURCETIME: () => IFCRESOURCETIME,
  IFCREVOLVEDAREASOLID: () => IFCREVOLVEDAREASOLID,
  IFCREVOLVEDAREASOLIDTAPERED: () => IFCREVOLVEDAREASOLIDTAPERED,
  IFCRIBPLATEPROFILEPROPERTIES: () => IFCRIBPLATEPROFILEPROPERTIES,
  IFCRIGHTCIRCULARCONE: () => IFCRIGHTCIRCULARCONE,
  IFCRIGHTCIRCULARCYLINDER: () => IFCRIGHTCIRCULARCYLINDER,
  IFCROAD: () => IFCROAD,
  IFCROADPART: () => IFCROADPART,
  IFCROOF: () => IFCROOF,
  IFCROOFTYPE: () => IFCROOFTYPE,
  IFCROOT: () => IFCROOT,
  IFCROTATIONALFREQUENCYMEASURE: () => IFCROTATIONALFREQUENCYMEASURE,
  IFCROTATIONALMASSMEASURE: () => IFCROTATIONALMASSMEASURE,
  IFCROTATIONALSTIFFNESSMEASURE: () => IFCROTATIONALSTIFFNESSMEASURE,
  IFCROUNDEDEDGEFEATURE: () => IFCROUNDEDEDGEFEATURE,
  IFCROUNDEDRECTANGLEPROFILEDEF: () => IFCROUNDEDRECTANGLEPROFILEDEF,
  IFCSANITARYTERMINAL: () => IFCSANITARYTERMINAL,
  IFCSANITARYTERMINALTYPE: () => IFCSANITARYTERMINALTYPE,
  IFCSCHEDULETIMECONTROL: () => IFCSCHEDULETIMECONTROL,
  IFCSCHEDULINGTIME: () => IFCSCHEDULINGTIME,
  IFCSEAMCURVE: () => IFCSEAMCURVE,
  IFCSECONDINMINUTE: () => IFCSECONDINMINUTE,
  IFCSECONDORDERPOLYNOMIALSPIRAL: () => IFCSECONDORDERPOLYNOMIALSPIRAL,
  IFCSECTIONALAREAINTEGRALMEASURE: () => IFCSECTIONALAREAINTEGRALMEASURE,
  IFCSECTIONEDSOLID: () => IFCSECTIONEDSOLID,
  IFCSECTIONEDSOLIDHORIZONTAL: () => IFCSECTIONEDSOLIDHORIZONTAL,
  IFCSECTIONEDSPINE: () => IFCSECTIONEDSPINE,
  IFCSECTIONEDSURFACE: () => IFCSECTIONEDSURFACE,
  IFCSECTIONMODULUSMEASURE: () => IFCSECTIONMODULUSMEASURE,
  IFCSECTIONPROPERTIES: () => IFCSECTIONPROPERTIES,
  IFCSECTIONREINFORCEMENTPROPERTIES: () => IFCSECTIONREINFORCEMENTPROPERTIES,
  IFCSEGMENT: () => IFCSEGMENT,
  IFCSEGMENTEDREFERENCECURVE: () => IFCSEGMENTEDREFERENCECURVE,
  IFCSENSOR: () => IFCSENSOR,
  IFCSENSORTYPE: () => IFCSENSORTYPE,
  IFCSERVICELIFE: () => IFCSERVICELIFE,
  IFCSERVICELIFEFACTOR: () => IFCSERVICELIFEFACTOR,
  IFCSEVENTHORDERPOLYNOMIALSPIRAL: () => IFCSEVENTHORDERPOLYNOMIALSPIRAL,
  IFCSHADINGDEVICE: () => IFCSHADINGDEVICE,
  IFCSHADINGDEVICETYPE: () => IFCSHADINGDEVICETYPE,
  IFCSHAPEASPECT: () => IFCSHAPEASPECT,
  IFCSHAPEMODEL: () => IFCSHAPEMODEL,
  IFCSHAPEREPRESENTATION: () => IFCSHAPEREPRESENTATION,
  IFCSHEARMODULUSMEASURE: () => IFCSHEARMODULUSMEASURE,
  IFCSHELLBASEDSURFACEMODEL: () => IFCSHELLBASEDSURFACEMODEL,
  IFCSIGN: () => IFCSIGN,
  IFCSIGNAL: () => IFCSIGNAL,
  IFCSIGNALTYPE: () => IFCSIGNALTYPE,
  IFCSIGNTYPE: () => IFCSIGNTYPE,
  IFCSIMPLEPROPERTY: () => IFCSIMPLEPROPERTY,
  IFCSIMPLEPROPERTYTEMPLATE: () => IFCSIMPLEPROPERTYTEMPLATE,
  IFCSINESPIRAL: () => IFCSINESPIRAL,
  IFCSITE: () => IFCSITE,
  IFCSIUNIT: () => IFCSIUNIT,
  IFCSLAB: () => IFCSLAB,
  IFCSLABELEMENTEDCASE: () => IFCSLABELEMENTEDCASE,
  IFCSLABSTANDARDCASE: () => IFCSLABSTANDARDCASE,
  IFCSLABTYPE: () => IFCSLABTYPE,
  IFCSLIPPAGECONNECTIONCONDITION: () => IFCSLIPPAGECONNECTIONCONDITION,
  IFCSOLARDEVICE: () => IFCSOLARDEVICE,
  IFCSOLARDEVICETYPE: () => IFCSOLARDEVICETYPE,
  IFCSOLIDANGLEMEASURE: () => IFCSOLIDANGLEMEASURE,
  IFCSOLIDMODEL: () => IFCSOLIDMODEL,
  IFCSOUNDPOWERLEVELMEASURE: () => IFCSOUNDPOWERLEVELMEASURE,
  IFCSOUNDPOWERMEASURE: () => IFCSOUNDPOWERMEASURE,
  IFCSOUNDPRESSURELEVELMEASURE: () => IFCSOUNDPRESSURELEVELMEASURE,
  IFCSOUNDPRESSUREMEASURE: () => IFCSOUNDPRESSUREMEASURE,
  IFCSOUNDPROPERTIES: () => IFCSOUNDPROPERTIES,
  IFCSOUNDVALUE: () => IFCSOUNDVALUE,
  IFCSPACE: () => IFCSPACE,
  IFCSPACEHEATER: () => IFCSPACEHEATER,
  IFCSPACEHEATERTYPE: () => IFCSPACEHEATERTYPE,
  IFCSPACEPROGRAM: () => IFCSPACEPROGRAM,
  IFCSPACETHERMALLOADPROPERTIES: () => IFCSPACETHERMALLOADPROPERTIES,
  IFCSPACETYPE: () => IFCSPACETYPE,
  IFCSPATIALELEMENT: () => IFCSPATIALELEMENT,
  IFCSPATIALELEMENTTYPE: () => IFCSPATIALELEMENTTYPE,
  IFCSPATIALSTRUCTUREELEMENT: () => IFCSPATIALSTRUCTUREELEMENT,
  IFCSPATIALSTRUCTUREELEMENTTYPE: () => IFCSPATIALSTRUCTUREELEMENTTYPE,
  IFCSPATIALZONE: () => IFCSPATIALZONE,
  IFCSPATIALZONETYPE: () => IFCSPATIALZONETYPE,
  IFCSPECIFICHEATCAPACITYMEASURE: () => IFCSPECIFICHEATCAPACITYMEASURE,
  IFCSPECULAREXPONENT: () => IFCSPECULAREXPONENT,
  IFCSPECULARROUGHNESS: () => IFCSPECULARROUGHNESS,
  IFCSPHERE: () => IFCSPHERE,
  IFCSPHERICALSURFACE: () => IFCSPHERICALSURFACE,
  IFCSPIRAL: () => IFCSPIRAL,
  IFCSTACKTERMINAL: () => IFCSTACKTERMINAL,
  IFCSTACKTERMINALTYPE: () => IFCSTACKTERMINALTYPE,
  IFCSTAIR: () => IFCSTAIR,
  IFCSTAIRFLIGHT: () => IFCSTAIRFLIGHT,
  IFCSTAIRFLIGHTTYPE: () => IFCSTAIRFLIGHTTYPE,
  IFCSTAIRTYPE: () => IFCSTAIRTYPE,
  IFCSTRUCTURALACTION: () => IFCSTRUCTURALACTION,
  IFCSTRUCTURALACTIVITY: () => IFCSTRUCTURALACTIVITY,
  IFCSTRUCTURALANALYSISMODEL: () => IFCSTRUCTURALANALYSISMODEL,
  IFCSTRUCTURALCONNECTION: () => IFCSTRUCTURALCONNECTION,
  IFCSTRUCTURALCONNECTIONCONDITION: () => IFCSTRUCTURALCONNECTIONCONDITION,
  IFCSTRUCTURALCURVEACTION: () => IFCSTRUCTURALCURVEACTION,
  IFCSTRUCTURALCURVECONNECTION: () => IFCSTRUCTURALCURVECONNECTION,
  IFCSTRUCTURALCURVEMEMBER: () => IFCSTRUCTURALCURVEMEMBER,
  IFCSTRUCTURALCURVEMEMBERVARYING: () => IFCSTRUCTURALCURVEMEMBERVARYING,
  IFCSTRUCTURALCURVEREACTION: () => IFCSTRUCTURALCURVEREACTION,
  IFCSTRUCTURALITEM: () => IFCSTRUCTURALITEM,
  IFCSTRUCTURALLINEARACTION: () => IFCSTRUCTURALLINEARACTION,
  IFCSTRUCTURALLINEARACTIONVARYING: () => IFCSTRUCTURALLINEARACTIONVARYING,
  IFCSTRUCTURALLOAD: () => IFCSTRUCTURALLOAD,
  IFCSTRUCTURALLOADCASE: () => IFCSTRUCTURALLOADCASE,
  IFCSTRUCTURALLOADCONFIGURATION: () => IFCSTRUCTURALLOADCONFIGURATION,
  IFCSTRUCTURALLOADGROUP: () => IFCSTRUCTURALLOADGROUP,
  IFCSTRUCTURALLOADLINEARFORCE: () => IFCSTRUCTURALLOADLINEARFORCE,
  IFCSTRUCTURALLOADORRESULT: () => IFCSTRUCTURALLOADORRESULT,
  IFCSTRUCTURALLOADPLANARFORCE: () => IFCSTRUCTURALLOADPLANARFORCE,
  IFCSTRUCTURALLOADSINGLEDISPLACEMENT: () => IFCSTRUCTURALLOADSINGLEDISPLACEMENT,
  IFCSTRUCTURALLOADSINGLEDISPLACEMENTDISTORTION: () => IFCSTRUCTURALLOADSINGLEDISPLACEMENTDISTORTION,
  IFCSTRUCTURALLOADSINGLEFORCE: () => IFCSTRUCTURALLOADSINGLEFORCE,
  IFCSTRUCTURALLOADSINGLEFORCEWARPING: () => IFCSTRUCTURALLOADSINGLEFORCEWARPING,
  IFCSTRUCTURALLOADSTATIC: () => IFCSTRUCTURALLOADSTATIC,
  IFCSTRUCTURALLOADTEMPERATURE: () => IFCSTRUCTURALLOADTEMPERATURE,
  IFCSTRUCTURALMEMBER: () => IFCSTRUCTURALMEMBER,
  IFCSTRUCTURALPLANARACTION: () => IFCSTRUCTURALPLANARACTION,
  IFCSTRUCTURALPLANARACTIONVARYING: () => IFCSTRUCTURALPLANARACTIONVARYING,
  IFCSTRUCTURALPOINTACTION: () => IFCSTRUCTURALPOINTACTION,
  IFCSTRUCTURALPOINTCONNECTION: () => IFCSTRUCTURALPOINTCONNECTION,
  IFCSTRUCTURALPOINTREACTION: () => IFCSTRUCTURALPOINTREACTION,
  IFCSTRUCTURALPROFILEPROPERTIES: () => IFCSTRUCTURALPROFILEPROPERTIES,
  IFCSTRUCTURALREACTION: () => IFCSTRUCTURALREACTION,
  IFCSTRUCTURALRESULTGROUP: () => IFCSTRUCTURALRESULTGROUP,
  IFCSTRUCTURALSTEELPROFILEPROPERTIES: () => IFCSTRUCTURALSTEELPROFILEPROPERTIES,
  IFCSTRUCTURALSURFACEACTION: () => IFCSTRUCTURALSURFACEACTION,
  IFCSTRUCTURALSURFACECONNECTION: () => IFCSTRUCTURALSURFACECONNECTION,
  IFCSTRUCTURALSURFACEMEMBER: () => IFCSTRUCTURALSURFACEMEMBER,
  IFCSTRUCTURALSURFACEMEMBERVARYING: () => IFCSTRUCTURALSURFACEMEMBERVARYING,
  IFCSTRUCTURALSURFACEREACTION: () => IFCSTRUCTURALSURFACEREACTION,
  IFCSTRUCTUREDDIMENSIONCALLOUT: () => IFCSTRUCTUREDDIMENSIONCALLOUT,
  IFCSTYLEDITEM: () => IFCSTYLEDITEM,
  IFCSTYLEDREPRESENTATION: () => IFCSTYLEDREPRESENTATION,
  IFCSTYLEMODEL: () => IFCSTYLEMODEL,
  IFCSUBCONTRACTRESOURCE: () => IFCSUBCONTRACTRESOURCE,
  IFCSUBCONTRACTRESOURCETYPE: () => IFCSUBCONTRACTRESOURCETYPE,
  IFCSUBEDGE: () => IFCSUBEDGE,
  IFCSURFACE: () => IFCSURFACE,
  IFCSURFACECURVE: () => IFCSURFACECURVE,
  IFCSURFACECURVESWEPTAREASOLID: () => IFCSURFACECURVESWEPTAREASOLID,
  IFCSURFACEFEATURE: () => IFCSURFACEFEATURE,
  IFCSURFACEOFLINEAREXTRUSION: () => IFCSURFACEOFLINEAREXTRUSION,
  IFCSURFACEOFREVOLUTION: () => IFCSURFACEOFREVOLUTION,
  IFCSURFACEREINFORCEMENTAREA: () => IFCSURFACEREINFORCEMENTAREA,
  IFCSURFACESTYLE: () => IFCSURFACESTYLE,
  IFCSURFACESTYLELIGHTING: () => IFCSURFACESTYLELIGHTING,
  IFCSURFACESTYLEREFRACTION: () => IFCSURFACESTYLEREFRACTION,
  IFCSURFACESTYLERENDERING: () => IFCSURFACESTYLERENDERING,
  IFCSURFACESTYLESHADING: () => IFCSURFACESTYLESHADING,
  IFCSURFACESTYLEWITHTEXTURES: () => IFCSURFACESTYLEWITHTEXTURES,
  IFCSURFACETEXTURE: () => IFCSURFACETEXTURE,
  IFCSWEPTAREASOLID: () => IFCSWEPTAREASOLID,
  IFCSWEPTDISKSOLID: () => IFCSWEPTDISKSOLID,
  IFCSWEPTDISKSOLIDPOLYGONAL: () => IFCSWEPTDISKSOLIDPOLYGONAL,
  IFCSWEPTSURFACE: () => IFCSWEPTSURFACE,
  IFCSWITCHINGDEVICE: () => IFCSWITCHINGDEVICE,
  IFCSWITCHINGDEVICETYPE: () => IFCSWITCHINGDEVICETYPE,
  IFCSYMBOLSTYLE: () => IFCSYMBOLSTYLE,
  IFCSYSTEM: () => IFCSYSTEM,
  IFCSYSTEMFURNITUREELEMENT: () => IFCSYSTEMFURNITUREELEMENT,
  IFCSYSTEMFURNITUREELEMENTTYPE: () => IFCSYSTEMFURNITUREELEMENTTYPE,
  IFCTABLE: () => IFCTABLE,
  IFCTABLECOLUMN: () => IFCTABLECOLUMN,
  IFCTABLEROW: () => IFCTABLEROW,
  IFCTANK: () => IFCTANK,
  IFCTANKTYPE: () => IFCTANKTYPE,
  IFCTASK: () => IFCTASK,
  IFCTASKTIME: () => IFCTASKTIME,
  IFCTASKTIMERECURRING: () => IFCTASKTIMERECURRING,
  IFCTASKTYPE: () => IFCTASKTYPE,
  IFCTELECOMADDRESS: () => IFCTELECOMADDRESS,
  IFCTEMPERATUREGRADIENTMEASURE: () => IFCTEMPERATUREGRADIENTMEASURE,
  IFCTEMPERATURERATEOFCHANGEMEASURE: () => IFCTEMPERATURERATEOFCHANGEMEASURE,
  IFCTENDON: () => IFCTENDON,
  IFCTENDONANCHOR: () => IFCTENDONANCHOR,
  IFCTENDONANCHORTYPE: () => IFCTENDONANCHORTYPE,
  IFCTENDONCONDUIT: () => IFCTENDONCONDUIT,
  IFCTENDONCONDUITTYPE: () => IFCTENDONCONDUITTYPE,
  IFCTENDONTYPE: () => IFCTENDONTYPE,
  IFCTERMINATORSYMBOL: () => IFCTERMINATORSYMBOL,
  IFCTESSELLATEDFACESET: () => IFCTESSELLATEDFACESET,
  IFCTESSELLATEDITEM: () => IFCTESSELLATEDITEM,
  IFCTEXT: () => IFCTEXT,
  IFCTEXTALIGNMENT: () => IFCTEXTALIGNMENT,
  IFCTEXTDECORATION: () => IFCTEXTDECORATION,
  IFCTEXTFONTNAME: () => IFCTEXTFONTNAME,
  IFCTEXTLITERAL: () => IFCTEXTLITERAL,
  IFCTEXTLITERALWITHEXTENT: () => IFCTEXTLITERALWITHEXTENT,
  IFCTEXTSTYLE: () => IFCTEXTSTYLE,
  IFCTEXTSTYLEFONTMODEL: () => IFCTEXTSTYLEFONTMODEL,
  IFCTEXTSTYLEFORDEFINEDFONT: () => IFCTEXTSTYLEFORDEFINEDFONT,
  IFCTEXTSTYLETEXTMODEL: () => IFCTEXTSTYLETEXTMODEL,
  IFCTEXTSTYLEWITHBOXCHARACTERISTICS: () => IFCTEXTSTYLEWITHBOXCHARACTERISTICS,
  IFCTEXTTRANSFORMATION: () => IFCTEXTTRANSFORMATION,
  IFCTEXTURECOORDINATE: () => IFCTEXTURECOORDINATE,
  IFCTEXTURECOORDINATEGENERATOR: () => IFCTEXTURECOORDINATEGENERATOR,
  IFCTEXTURECOORDINATEINDICES: () => IFCTEXTURECOORDINATEINDICES,
  IFCTEXTURECOORDINATEINDICESWITHVOIDS: () => IFCTEXTURECOORDINATEINDICESWITHVOIDS,
  IFCTEXTUREMAP: () => IFCTEXTUREMAP,
  IFCTEXTUREVERTEX: () => IFCTEXTUREVERTEX,
  IFCTEXTUREVERTEXLIST: () => IFCTEXTUREVERTEXLIST,
  IFCTHERMALADMITTANCEMEASURE: () => IFCTHERMALADMITTANCEMEASURE,
  IFCTHERMALCONDUCTIVITYMEASURE: () => IFCTHERMALCONDUCTIVITYMEASURE,
  IFCTHERMALEXPANSIONCOEFFICIENTMEASURE: () => IFCTHERMALEXPANSIONCOEFFICIENTMEASURE,
  IFCTHERMALMATERIALPROPERTIES: () => IFCTHERMALMATERIALPROPERTIES,
  IFCTHERMALRESISTANCEMEASURE: () => IFCTHERMALRESISTANCEMEASURE,
  IFCTHERMALTRANSMITTANCEMEASURE: () => IFCTHERMALTRANSMITTANCEMEASURE,
  IFCTHERMODYNAMICTEMPERATUREMEASURE: () => IFCTHERMODYNAMICTEMPERATUREMEASURE,
  IFCTHIRDORDERPOLYNOMIALSPIRAL: () => IFCTHIRDORDERPOLYNOMIALSPIRAL,
  IFCTIME: () => IFCTIME,
  IFCTIMEMEASURE: () => IFCTIMEMEASURE,
  IFCTIMEPERIOD: () => IFCTIMEPERIOD,
  IFCTIMESERIES: () => IFCTIMESERIES,
  IFCTIMESERIESREFERENCERELATIONSHIP: () => IFCTIMESERIESREFERENCERELATIONSHIP,
  IFCTIMESERIESSCHEDULE: () => IFCTIMESERIESSCHEDULE,
  IFCTIMESERIESVALUE: () => IFCTIMESERIESVALUE,
  IFCTIMESTAMP: () => IFCTIMESTAMP,
  IFCTOPOLOGICALREPRESENTATIONITEM: () => IFCTOPOLOGICALREPRESENTATIONITEM,
  IFCTOPOLOGYREPRESENTATION: () => IFCTOPOLOGYREPRESENTATION,
  IFCTOROIDALSURFACE: () => IFCTOROIDALSURFACE,
  IFCTORQUEMEASURE: () => IFCTORQUEMEASURE,
  IFCTRACKELEMENT: () => IFCTRACKELEMENT,
  IFCTRACKELEMENTTYPE: () => IFCTRACKELEMENTTYPE,
  IFCTRANSFORMER: () => IFCTRANSFORMER,
  IFCTRANSFORMERTYPE: () => IFCTRANSFORMERTYPE,
  IFCTRANSPORTATIONDEVICE: () => IFCTRANSPORTATIONDEVICE,
  IFCTRANSPORTATIONDEVICETYPE: () => IFCTRANSPORTATIONDEVICETYPE,
  IFCTRANSPORTELEMENT: () => IFCTRANSPORTELEMENT,
  IFCTRANSPORTELEMENTTYPE: () => IFCTRANSPORTELEMENTTYPE,
  IFCTRAPEZIUMPROFILEDEF: () => IFCTRAPEZIUMPROFILEDEF,
  IFCTRIANGULATEDFACESET: () => IFCTRIANGULATEDFACESET,
  IFCTRIANGULATEDIRREGULARNETWORK: () => IFCTRIANGULATEDIRREGULARNETWORK,
  IFCTRIMMEDCURVE: () => IFCTRIMMEDCURVE,
  IFCTSHAPEPROFILEDEF: () => IFCTSHAPEPROFILEDEF,
  IFCTUBEBUNDLE: () => IFCTUBEBUNDLE,
  IFCTUBEBUNDLETYPE: () => IFCTUBEBUNDLETYPE,
  IFCTWODIRECTIONREPEATFACTOR: () => IFCTWODIRECTIONREPEATFACTOR,
  IFCTYPEOBJECT: () => IFCTYPEOBJECT,
  IFCTYPEPROCESS: () => IFCTYPEPROCESS,
  IFCTYPEPRODUCT: () => IFCTYPEPRODUCT,
  IFCTYPERESOURCE: () => IFCTYPERESOURCE,
  IFCUNITARYCONTROLELEMENT: () => IFCUNITARYCONTROLELEMENT,
  IFCUNITARYCONTROLELEMENTTYPE: () => IFCUNITARYCONTROLELEMENTTYPE,
  IFCUNITARYEQUIPMENT: () => IFCUNITARYEQUIPMENT,
  IFCUNITARYEQUIPMENTTYPE: () => IFCUNITARYEQUIPMENTTYPE,
  IFCUNITASSIGNMENT: () => IFCUNITASSIGNMENT,
  IFCURIREFERENCE: () => IFCURIREFERENCE,
  IFCUSHAPEPROFILEDEF: () => IFCUSHAPEPROFILEDEF,
  IFCVALVE: () => IFCVALVE,
  IFCVALVETYPE: () => IFCVALVETYPE,
  IFCVAPORPERMEABILITYMEASURE: () => IFCVAPORPERMEABILITYMEASURE,
  IFCVECTOR: () => IFCVECTOR,
  IFCVEHICLE: () => IFCVEHICLE,
  IFCVEHICLETYPE: () => IFCVEHICLETYPE,
  IFCVERTEX: () => IFCVERTEX,
  IFCVERTEXBASEDTEXTUREMAP: () => IFCVERTEXBASEDTEXTUREMAP,
  IFCVERTEXLOOP: () => IFCVERTEXLOOP,
  IFCVERTEXPOINT: () => IFCVERTEXPOINT,
  IFCVIBRATIONDAMPER: () => IFCVIBRATIONDAMPER,
  IFCVIBRATIONDAMPERTYPE: () => IFCVIBRATIONDAMPERTYPE,
  IFCVIBRATIONISOLATOR: () => IFCVIBRATIONISOLATOR,
  IFCVIBRATIONISOLATORTYPE: () => IFCVIBRATIONISOLATORTYPE,
  IFCVIRTUALELEMENT: () => IFCVIRTUALELEMENT,
  IFCVIRTUALGRIDINTERSECTION: () => IFCVIRTUALGRIDINTERSECTION,
  IFCVOIDINGFEATURE: () => IFCVOIDINGFEATURE,
  IFCVOLUMEMEASURE: () => IFCVOLUMEMEASURE,
  IFCVOLUMETRICFLOWRATEMEASURE: () => IFCVOLUMETRICFLOWRATEMEASURE,
  IFCWALL: () => IFCWALL,
  IFCWALLELEMENTEDCASE: () => IFCWALLELEMENTEDCASE,
  IFCWALLSTANDARDCASE: () => IFCWALLSTANDARDCASE,
  IFCWALLTYPE: () => IFCWALLTYPE,
  IFCWARPINGCONSTANTMEASURE: () => IFCWARPINGCONSTANTMEASURE,
  IFCWARPINGMOMENTMEASURE: () => IFCWARPINGMOMENTMEASURE,
  IFCWASTETERMINAL: () => IFCWASTETERMINAL,
  IFCWASTETERMINALTYPE: () => IFCWASTETERMINALTYPE,
  IFCWATERPROPERTIES: () => IFCWATERPROPERTIES,
  IFCWINDOW: () => IFCWINDOW,
  IFCWINDOWLININGPROPERTIES: () => IFCWINDOWLININGPROPERTIES,
  IFCWINDOWPANELPROPERTIES: () => IFCWINDOWPANELPROPERTIES,
  IFCWINDOWSTANDARDCASE: () => IFCWINDOWSTANDARDCASE,
  IFCWINDOWSTYLE: () => IFCWINDOWSTYLE,
  IFCWINDOWTYPE: () => IFCWINDOWTYPE,
  IFCWORKCALENDAR: () => IFCWORKCALENDAR,
  IFCWORKCONTROL: () => IFCWORKCONTROL,
  IFCWORKPLAN: () => IFCWORKPLAN,
  IFCWORKSCHEDULE: () => IFCWORKSCHEDULE,
  IFCWORKTIME: () => IFCWORKTIME,
  IFCYEARNUMBER: () => IFCYEARNUMBER,
  IFCZONE: () => IFCZONE,
  IFCZSHAPEPROFILEDEF: () => IFCZSHAPEPROFILEDEF,
  INTEGER: () => INTEGER,
  IfcAPI: () => IfcAPI2,
  IfcLineObject: () => IfcLineObject,
  InheritanceDef: () => InheritanceDef,
  InversePropertyDef: () => InversePropertyDef,
  LABEL: () => LABEL,
  LINE_END: () => LINE_END,
  LogLevel: () => LogLevel,
  Properties: () => Properties,
  REAL: () => REAL,
  REF: () => REF,
  SET_BEGIN: () => SET_BEGIN,
  SET_END: () => SET_END,
  STRING: () => STRING,
  SchemaNames: () => SchemaNames,
  Schemas: () => Schemas,
  ToRawLineData: () => ToRawLineData,
  TypeInitialisers: () => TypeInitialisers,
  UNKNOWN: () => UNKNOWN,
  logical: () => logical,
  ms: () => ms
});

// dist/ifc-schema.ts
var IFCURIREFERENCE = 950732822;
var IFCTIME = 4075327185;
var IFCTEMPERATURERATEOFCHANGEMEASURE = 1209108979;
var IFCSOUNDPRESSURELEVELMEASURE = 3457685358;
var IFCSOUNDPOWERLEVELMEASURE = 4157543285;
var IFCPROPERTYSETDEFINITIONSET = 2798247006;
var IFCPOSITIVEINTEGER = 1790229001;
var IFCNONNEGATIVELENGTHMEASURE = 525895558;
var IFCLINEINDEX = 1774176899;
var IFCLANGUAGEID = 1275358634;
var IFCDURATION = 2541165894;
var IFCDAYINWEEKNUMBER = 3701338814;
var IFCDATETIME = 2195413836;
var IFCDATE = 937566702;
var IFCCARDINALPOINTREFERENCE = 1683019596;
var IFCBINARY = 2314439260;
var IFCAREADENSITYMEASURE = 1500781891;
var IFCARCINDEX = 3683503648;
var IFCYEARNUMBER = 4065007721;
var IFCWARPINGMOMENTMEASURE = 1718600412;
var IFCWARPINGCONSTANTMEASURE = 51269191;
var IFCVOLUMETRICFLOWRATEMEASURE = 2593997549;
var IFCVOLUMEMEASURE = 3458127941;
var IFCVAPORPERMEABILITYMEASURE = 3345633955;
var IFCTORQUEMEASURE = 1278329552;
var IFCTIMESTAMP = 2591213694;
var IFCTIMEMEASURE = 2726807636;
var IFCTHERMODYNAMICTEMPERATUREMEASURE = 743184107;
var IFCTHERMALTRANSMITTANCEMEASURE = 2016195849;
var IFCTHERMALRESISTANCEMEASURE = 857959152;
var IFCTHERMALEXPANSIONCOEFFICIENTMEASURE = 2281867870;
var IFCTHERMALCONDUCTIVITYMEASURE = 2645777649;
var IFCTHERMALADMITTANCEMEASURE = 232962298;
var IFCTEXTTRANSFORMATION = 296282323;
var IFCTEXTFONTNAME = 603696268;
var IFCTEXTDECORATION = 3490877962;
var IFCTEXTALIGNMENT = 1460886941;
var IFCTEXT = 2801250643;
var IFCTEMPERATUREGRADIENTMEASURE = 58845555;
var IFCSPECULARROUGHNESS = 361837227;
var IFCSPECULAREXPONENT = 2757832317;
var IFCSPECIFICHEATCAPACITYMEASURE = 3477203348;
var IFCSOUNDPRESSUREMEASURE = 993287707;
var IFCSOUNDPOWERMEASURE = 846465480;
var IFCSOLIDANGLEMEASURE = 3471399674;
var IFCSHEARMODULUSMEASURE = 408310005;
var IFCSECTIONALAREAINTEGRALMEASURE = 2190458107;
var IFCSECTIONMODULUSMEASURE = 3467162246;
var IFCSECONDINMINUTE = 2766185779;
var IFCROTATIONALSTIFFNESSMEASURE = 3211557302;
var IFCROTATIONALMASSMEASURE = 1755127002;
var IFCROTATIONALFREQUENCYMEASURE = 2133746277;
var IFCREAL = 200335297;
var IFCRATIOMEASURE = 96294661;
var IFCRADIOACTIVITYMEASURE = 3972513137;
var IFCPRESSUREMEASURE = 3665567075;
var IFCPRESENTABLETEXT = 2169031380;
var IFCPOWERMEASURE = 1364037233;
var IFCPOSITIVERATIOMEASURE = 1245737093;
var IFCPOSITIVEPLANEANGLEMEASURE = 3054510233;
var IFCPOSITIVELENGTHMEASURE = 2815919920;
var IFCPLANEANGLEMEASURE = 4042175685;
var IFCPLANARFORCEMEASURE = 2642773653;
var IFCPARAMETERVALUE = 2260317790;
var IFCPHMEASURE = 929793134;
var IFCNUMERICMEASURE = 2395907400;
var IFCNORMALISEDRATIOMEASURE = 2095195183;
var IFCMONTHINYEARNUMBER = 765770214;
var IFCMONETARYMEASURE = 2615040989;
var IFCMOMENTOFINERTIAMEASURE = 3114022597;
var IFCMOLECULARWEIGHTMEASURE = 1648970520;
var IFCMOISTUREDIFFUSIVITYMEASURE = 3177669450;
var IFCMODULUSOFSUBGRADEREACTIONMEASURE = 1753493141;
var IFCMODULUSOFROTATIONALSUBGRADEREACTIONMEASURE = 1052454078;
var IFCMODULUSOFLINEARSUBGRADEREACTIONMEASURE = 2173214787;
var IFCMODULUSOFELASTICITYMEASURE = 3341486342;
var IFCMINUTEINHOUR = 102610177;
var IFCMASSPERLENGTHMEASURE = 3531705166;
var IFCMASSMEASURE = 3124614049;
var IFCMASSFLOWRATEMEASURE = 4017473158;
var IFCMASSDENSITYMEASURE = 1477762836;
var IFCMAGNETICFLUXMEASURE = 2486716878;
var IFCMAGNETICFLUXDENSITYMEASURE = 286949696;
var IFCLUMINOUSINTENSITYMEASURE = 151039812;
var IFCLUMINOUSINTENSITYDISTRIBUTIONMEASURE = 2755797622;
var IFCLUMINOUSFLUXMEASURE = 2095003142;
var IFCLOGICAL = 503418787;
var IFCLINEARVELOCITYMEASURE = 3086160713;
var IFCLINEARSTIFFNESSMEASURE = 1307019551;
var IFCLINEARMOMENTMEASURE = 2128979029;
var IFCLINEARFORCEMEASURE = 191860431;
var IFCLENGTHMEASURE = 1243674935;
var IFCLABEL = 3258342251;
var IFCKINEMATICVISCOSITYMEASURE = 2054016361;
var IFCISOTHERMALMOISTURECAPACITYMEASURE = 3192672207;
var IFCIONCONCENTRATIONMEASURE = 3686016028;
var IFCINTEGERCOUNTRATEMEASURE = 3809634241;
var IFCINTEGER = 1939436016;
var IFCINDUCTANCEMEASURE = 2679005408;
var IFCILLUMINANCEMEASURE = 3358199106;
var IFCIDENTIFIER = 983778844;
var IFCHOURINDAY = 2589826445;
var IFCHEATINGVALUEMEASURE = 1158859006;
var IFCHEATFLUXDENSITYMEASURE = 3113092358;
var IFCGLOBALLYUNIQUEID = 3064340077;
var IFCFREQUENCYMEASURE = 3044325142;
var IFCFORCEMEASURE = 1361398929;
var IFCFONTWEIGHT = 2590844177;
var IFCFONTVARIANT = 2715512545;
var IFCFONTSTYLE = 1102727119;
var IFCENERGYMEASURE = 2078135608;
var IFCELECTRICVOLTAGEMEASURE = 2506197118;
var IFCELECTRICRESISTANCEMEASURE = 2951915441;
var IFCELECTRICCURRENTMEASURE = 3790457270;
var IFCELECTRICCONDUCTANCEMEASURE = 2093906313;
var IFCELECTRICCHARGEMEASURE = 3818826038;
var IFCELECTRICCAPACITANCEMEASURE = 1827137117;
var IFCDYNAMICVISCOSITYMEASURE = 69416015;
var IFCDOSEEQUIVALENTMEASURE = 524656162;
var IFCDIMENSIONCOUNT = 4134073009;
var IFCDESCRIPTIVEMEASURE = 1514641115;
var IFCDAYLIGHTSAVINGHOUR = 300323983;
var IFCDAYINMONTHNUMBER = 86635668;
var IFCCURVATUREMEASURE = 94842927;
var IFCCOUNTMEASURE = 1778710042;
var IFCCONTEXTDEPENDENTMEASURE = 3238673880;
var IFCCOMPOUNDPLANEANGLEMEASURE = 3812528620;
var IFCCOMPLEXNUMBER = 2991860651;
var IFCBOXALIGNMENT = 1867003952;
var IFCBOOLEAN = 2735952531;
var IFCAREAMEASURE = 2650437152;
var IFCANGULARVELOCITYMEASURE = 632304761;
var IFCAMOUNTOFSUBSTANCEMEASURE = 360377573;
var IFCACCELERATIONMEASURE = 4182062534;
var IFCABSORBEDDOSEMEASURE = 3699917729;
var IFCGEOSLICE = 1971632696;
var IFCGEOMODEL = 2680139844;
var IFCELECTRICFLOWTREATMENTDEVICE = 24726584;
var IFCDISTRIBUTIONBOARD = 3693000487;
var IFCCONVEYORSEGMENT = 3460952963;
var IFCCAISSONFOUNDATION = 3999819293;
var IFCBOREHOLE = 3314249567;
var IFCBEARING = 4196446775;
var IFCALIGNMENT = 325726236;
var IFCTRACKELEMENT = 3425753595;
var IFCSIGNAL = 991950508;
var IFCREINFORCEDSOIL = 3798194928;
var IFCRAIL = 3290496277;
var IFCPAVEMENT = 1383356374;
var IFCNAVIGATIONELEMENT = 2182337498;
var IFCMOORINGDEVICE = 234836483;
var IFCMOBILETELECOMMUNICATIONSAPPLIANCE = 2078563270;
var IFCLIQUIDTERMINAL = 1638804497;
var IFCLINEARPOSITIONINGELEMENT = 1154579445;
var IFCKERB = 2696325953;
var IFCGEOTECHNICALASSEMBLY = 2713699986;
var IFCELECTRICFLOWTREATMENTDEVICETYPE = 2142170206;
var IFCEARTHWORKSFILL = 3376911765;
var IFCEARTHWORKSELEMENT = 1077100507;
var IFCEARTHWORKSCUT = 3071239417;
var IFCDISTRIBUTIONBOARDTYPE = 479945903;
var IFCDEEPFOUNDATION = 3426335179;
var IFCCOURSE = 1502416096;
var IFCCONVEYORSEGMENTTYPE = 2940368186;
var IFCCAISSONFOUNDATIONTYPE = 3203706013;
var IFCBUILTSYSTEM = 3862327254;
var IFCBUILTELEMENT = 1876633798;
var IFCBRIDGEPART = 963979645;
var IFCBRIDGE = 644574406;
var IFCBEARINGTYPE = 3649138523;
var IFCALIGNMENTVERTICAL = 1662888072;
var IFCALIGNMENTSEGMENT = 317615605;
var IFCALIGNMENTHORIZONTAL = 1545765605;
var IFCALIGNMENTCANT = 4266260250;
var IFCVIBRATIONDAMPERTYPE = 3956297820;
var IFCVIBRATIONDAMPER = 1530820697;
var IFCVEHICLE = 840318589;
var IFCTRANSPORTATIONDEVICE = 1953115116;
var IFCTRACKELEMENTTYPE = 618700268;
var IFCTENDONCONDUITTYPE = 2281632017;
var IFCTENDONCONDUIT = 3663046924;
var IFCSINESPIRAL = 42703149;
var IFCSIGNALTYPE = 1894708472;
var IFCSIGNTYPE = 3599934289;
var IFCSIGN = 33720170;
var IFCSEVENTHORDERPOLYNOMIALSPIRAL = 1027922057;
var IFCSEGMENTEDREFERENCECURVE = 544395925;
var IFCSECONDORDERPOLYNOMIALSPIRAL = 3649235739;
var IFCROADPART = 550521510;
var IFCROAD = 146592293;
var IFCRELADHERESTOELEMENT = 3818125796;
var IFCREFERENT = 4021432810;
var IFCRAILWAYPART = 1891881377;
var IFCRAILWAY = 3992365140;
var IFCRAILTYPE = 1763565496;
var IFCPOSITIONINGELEMENT = 1946335990;
var IFCPAVEMENTTYPE = 514975943;
var IFCNAVIGATIONELEMENTTYPE = 506776471;
var IFCMOORINGDEVICETYPE = 710110818;
var IFCMOBILETELECOMMUNICATIONSAPPLIANCETYPE = 1950438474;
var IFCMARINEPART = 976884017;
var IFCMARINEFACILITY = 525669439;
var IFCLIQUIDTERMINALTYPE = 1770583370;
var IFCLINEARELEMENT = 2176059722;
var IFCKERBTYPE = 679976338;
var IFCIMPACTPROTECTIONDEVICETYPE = 3948183225;
var IFCIMPACTPROTECTIONDEVICE = 2568555532;
var IFCGRADIENTCURVE = 2898700619;
var IFCGEOTECHNICALSTRATUM = 1594536857;
var IFCGEOTECHNICALELEMENT = 4230923436;
var IFCFACILITYPARTCOMMON = 4228831410;
var IFCFACILITYPART = 1310830890;
var IFCFACILITY = 24185140;
var IFCDIRECTRIXDERIVEDREFERENCESWEPTAREASOLID = 4234616927;
var IFCDEEPFOUNDATIONTYPE = 1306400036;
var IFCCOURSETYPE = 4189326743;
var IFCCOSINESPIRAL = 2000195564;
var IFCCLOTHOID = 3497074424;
var IFCBUILTELEMENTTYPE = 1626504194;
var IFCVEHICLETYPE = 3651464721;
var IFCTRIANGULATEDIRREGULARNETWORK = 1229763772;
var IFCTRANSPORTATIONDEVICETYPE = 3665877780;
var IFCTHIRDORDERPOLYNOMIALSPIRAL = 782932809;
var IFCSPIRAL = 2735484536;
var IFCSECTIONEDSURFACE = 1356537516;
var IFCSECTIONEDSOLIDHORIZONTAL = 1290935644;
var IFCSECTIONEDSOLID = 1862484736;
var IFCRELPOSITIONS = 1441486842;
var IFCRELASSOCIATESPROFILEDEF = 1033248425;
var IFCPOLYNOMIALCURVE = 3381221214;
var IFCOFFSETCURVEBYDISTANCES = 2485787929;
var IFCOFFSETCURVE = 590820931;
var IFCINDEXEDPOLYGONALTEXTUREMAP = 3465909080;
var IFCDIRECTRIXCURVESWEPTAREASOLID = 593015953;
var IFCCURVESEGMENT = 4212018352;
var IFCAXIS2PLACEMENTLINEAR = 3425423356;
var IFCSEGMENT = 823603102;
var IFCPOINTBYDISTANCEEXPRESSION = 2165702409;
var IFCOPENCROSSPROFILEDEF = 182550632;
var IFCLINEARPLACEMENT = 388784114;
var IFCALIGNMENTHORIZONTALSEGMENT = 536804194;
var IFCALIGNMENTCANTSEGMENT = 3752311538;
var IFCTEXTURECOORDINATEINDICESWITHVOIDS = 1010789467;
var IFCTEXTURECOORDINATEINDICES = 222769930;
var IFCQUANTITYNUMBER = 2691318326;
var IFCALIGNMENTVERTICALSEGMENT = 3633395639;
var IFCALIGNMENTPARAMETERSEGMENT = 2879124712;
var IFCCONTROLLER = 25142252;
var IFCALARM = 3087945054;
var IFCACTUATOR = 4288193352;
var IFCUNITARYCONTROLELEMENT = 630975310;
var IFCSENSOR = 4086658281;
var IFCPROTECTIVEDEVICETRIPPINGUNIT = 2295281155;
var IFCFLOWINSTRUMENT = 182646315;
var IFCFIRESUPPRESSIONTERMINAL = 1426591983;
var IFCFILTER = 819412036;
var IFCFAN = 3415622556;
var IFCELECTRICTIMECONTROL = 1003880860;
var IFCELECTRICMOTOR = 402227799;
var IFCELECTRICGENERATOR = 264262732;
var IFCELECTRICFLOWSTORAGEDEVICE = 3310460725;
var IFCELECTRICDISTRIBUTIONBOARD = 862014818;
var IFCELECTRICAPPLIANCE = 1904799276;
var IFCDUCTSILENCER = 1360408905;
var IFCDUCTSEGMENT = 3518393246;
var IFCDUCTFITTING = 342316401;
var IFCDISTRIBUTIONCIRCUIT = 562808652;
var IFCDAMPER = 4074379575;
var IFCCOOLINGTOWER = 3640358203;
var IFCCOOLEDBEAM = 4136498852;
var IFCCONDENSER = 2272882330;
var IFCCOMPRESSOR = 3571504051;
var IFCCOMMUNICATIONSAPPLIANCE = 3221913625;
var IFCCOIL = 639361253;
var IFCCHILLER = 3902619387;
var IFCCABLESEGMENT = 4217484030;
var IFCCABLEFITTING = 1051757585;
var IFCCABLECARRIERSEGMENT = 3758799889;
var IFCCABLECARRIERFITTING = 635142910;
var IFCBURNER = 2938176219;
var IFCBOILER = 32344328;
var IFCBEAMSTANDARDCASE = 2906023776;
var IFCAUDIOVISUALAPPLIANCE = 277319702;
var IFCAIRTOAIRHEATRECOVERY = 2056796094;
var IFCAIRTERMINALBOX = 177149247;
var IFCAIRTERMINAL = 1634111441;
var IFCWINDOWSTANDARDCASE = 486154966;
var IFCWASTETERMINAL = 4237592921;
var IFCWALLELEMENTEDCASE = 4156078855;
var IFCVALVE = 4207607924;
var IFCUNITARYEQUIPMENT = 4292641817;
var IFCUNITARYCONTROLELEMENTTYPE = 3179687236;
var IFCTUBEBUNDLE = 3026737570;
var IFCTRANSFORMER = 3825984169;
var IFCTANK = 812556717;
var IFCSWITCHINGDEVICE = 1162798199;
var IFCSTRUCTURALLOADCASE = 385403989;
var IFCSTACKTERMINAL = 1404847402;
var IFCSPACEHEATER = 1999602285;
var IFCSOLARDEVICE = 3420628829;
var IFCSLABSTANDARDCASE = 3027962421;
var IFCSLABELEMENTEDCASE = 3127900445;
var IFCSHADINGDEVICE = 1329646415;
var IFCSANITARYTERMINAL = 3053780830;
var IFCREINFORCINGBARTYPE = 2572171363;
var IFCRATIONALBSPLINECURVEWITHKNOTS = 1232101972;
var IFCPUMP = 90941305;
var IFCPROTECTIVEDEVICETRIPPINGUNITTYPE = 655969474;
var IFCPROTECTIVEDEVICE = 738039164;
var IFCPLATESTANDARDCASE = 1156407060;
var IFCPIPESEGMENT = 3612865200;
var IFCPIPEFITTING = 310824031;
var IFCOUTLET = 3694346114;
var IFCOUTERBOUNDARYCURVE = 144952367;
var IFCMOTORCONNECTION = 2474470126;
var IFCMEMBERSTANDARDCASE = 1911478936;
var IFCMEDICALDEVICE = 1437502449;
var IFCLIGHTFIXTURE = 629592764;
var IFCLAMP = 76236018;
var IFCJUNCTIONBOX = 2176052936;
var IFCINTERCEPTOR = 4175244083;
var IFCHUMIDIFIER = 2068733104;
var IFCHEATEXCHANGER = 3319311131;
var IFCFLOWMETER = 2188021234;
var IFCEXTERNALSPATIALELEMENT = 1209101575;
var IFCEVAPORATOR = 484807127;
var IFCEVAPORATIVECOOLER = 3747195512;
var IFCENGINE = 2814081492;
var IFCELECTRICDISTRIBUTIONBOARDTYPE = 2417008758;
var IFCDOORSTANDARDCASE = 3242481149;
var IFCDISTRIBUTIONSYSTEM = 3205830791;
var IFCCOMMUNICATIONSAPPLIANCETYPE = 400855858;
var IFCCOLUMNSTANDARDCASE = 905975707;
var IFCCIVILELEMENT = 1677625105;
var IFCCHIMNEY = 3296154744;
var IFCCABLEFITTINGTYPE = 2674252688;
var IFCBURNERTYPE = 2188180465;
var IFCBUILDINGSYSTEM = 1177604601;
var IFCBUILDINGELEMENTPARTTYPE = 39481116;
var IFCBOUNDARYCURVE = 1136057603;
var IFCBSPLINECURVEWITHKNOTS = 2461110595;
var IFCAUDIOVISUALAPPLIANCETYPE = 1532957894;
var IFCWORKCALENDAR = 4088093105;
var IFCWINDOWTYPE = 4009809668;
var IFCVOIDINGFEATURE = 926996030;
var IFCVIBRATIONISOLATOR = 2391383451;
var IFCTENDONTYPE = 2415094496;
var IFCTENDONANCHORTYPE = 3081323446;
var IFCSYSTEMFURNITUREELEMENT = 413509423;
var IFCSURFACEFEATURE = 3101698114;
var IFCSTRUCTURALSURFACEACTION = 3657597509;
var IFCSTRUCTURALCURVEREACTION = 2757150158;
var IFCSTRUCTURALCURVEACTION = 1004757350;
var IFCSTAIRTYPE = 338393293;
var IFCSOLARDEVICETYPE = 1072016465;
var IFCSHADINGDEVICETYPE = 4074543187;
var IFCSEAMCURVE = 2157484638;
var IFCROOFTYPE = 2781568857;
var IFCREINFORCINGMESHTYPE = 2310774935;
var IFCREINFORCINGELEMENTTYPE = 964333572;
var IFCRATIONALBSPLINESURFACEWITHKNOTS = 683857671;
var IFCRAMPTYPE = 1469900589;
var IFCPOLYGONALFACESET = 2839578677;
var IFCPILETYPE = 1158309216;
var IFCOPENINGSTANDARDCASE = 3079942009;
var IFCMEDICALDEVICETYPE = 1114901282;
var IFCINTERSECTIONCURVE = 3113134337;
var IFCINTERCEPTORTYPE = 3946677679;
var IFCINDEXEDPOLYCURVE = 2571569899;
var IFCGEOGRAPHICELEMENT = 3493046030;
var IFCFURNITURE = 1509553395;
var IFCFOOTINGTYPE = 1893162501;
var IFCEXTERNALSPATIALSTRUCTUREELEMENT = 2853485674;
var IFCEVENT = 4148101412;
var IFCENGINETYPE = 132023988;
var IFCELEMENTASSEMBLYTYPE = 2397081782;
var IFCDOORTYPE = 2323601079;
var IFCCYLINDRICALSURFACE = 1213902940;
var IFCCONSTRUCTIONPRODUCTRESOURCETYPE = 1525564444;
var IFCCONSTRUCTIONMATERIALRESOURCETYPE = 4105962743;
var IFCCONSTRUCTIONEQUIPMENTRESOURCETYPE = 2185764099;
var IFCCOMPOSITECURVEONSURFACE = 15328376;
var IFCCOMPLEXPROPERTYTEMPLATE = 3875453745;
var IFCCIVILELEMENTTYPE = 3893394355;
var IFCCHIMNEYTYPE = 2197970202;
var IFCBSPLINESURFACEWITHKNOTS = 167062518;
var IFCBSPLINESURFACE = 2887950389;
var IFCADVANCEDBREPWITHVOIDS = 2603310189;
var IFCADVANCEDBREP = 1635779807;
var IFCTRIANGULATEDFACESET = 2916149573;
var IFCTOROIDALSURFACE = 1935646853;
var IFCTESSELLATEDFACESET = 2387106220;
var IFCTASKTYPE = 3206491090;
var IFCSURFACECURVE = 699246055;
var IFCSUBCONTRACTRESOURCETYPE = 4095615324;
var IFCSTRUCTURALSURFACEREACTION = 603775116;
var IFCSPHERICALSURFACE = 4015995234;
var IFCSPATIALZONETYPE = 2481509218;
var IFCSPATIALZONE = 463610769;
var IFCSPATIALELEMENTTYPE = 710998568;
var IFCSPATIALELEMENT = 1412071761;
var IFCSIMPLEPROPERTYTEMPLATE = 3663146110;
var IFCREVOLVEDAREASOLIDTAPERED = 3243963512;
var IFCREPARAMETRISEDCOMPOSITECURVESEGMENT = 816062949;
var IFCRELSPACEBOUNDARY2NDLEVEL = 1521410863;
var IFCRELSPACEBOUNDARY1STLEVEL = 3523091289;
var IFCRELINTERFERESELEMENTS = 427948657;
var IFCRELDEFINESBYTEMPLATE = 307848117;
var IFCRELDEFINESBYOBJECT = 1462361463;
var IFCRELDECLARES = 2565941209;
var IFCRELASSIGNSTOGROUPBYFACTOR = 1027710054;
var IFCPROPERTYTEMPLATE = 3521284610;
var IFCPROPERTYSETTEMPLATE = 492091185;
var IFCPROJECTLIBRARY = 653396225;
var IFCPROCEDURETYPE = 569719735;
var IFCPREDEFINEDPROPERTYSET = 3967405729;
var IFCPCURVE = 1682466193;
var IFCLABORRESOURCETYPE = 428585644;
var IFCINDEXEDPOLYGONALFACEWITHVOIDS = 2294589976;
var IFCINDEXEDPOLYGONALFACE = 178912537;
var IFCGEOGRAPHICELEMENTTYPE = 4095422895;
var IFCFIXEDREFERENCESWEPTAREASOLID = 2652556860;
var IFCEXTRUDEDAREASOLIDTAPERED = 2804161546;
var IFCEVENTTYPE = 4024345920;
var IFCCURVEBOUNDEDSURFACE = 2629017746;
var IFCCREWRESOURCETYPE = 1815067380;
var IFCCONTEXT = 3419103109;
var IFCCONSTRUCTIONRESOURCETYPE = 2574617495;
var IFCCARTESIANPOINTLIST3D = 2059837836;
var IFCCARTESIANPOINTLIST2D = 1675464909;
var IFCCARTESIANPOINTLIST = 574549367;
var IFCADVANCEDFACE = 3406155212;
var IFCTYPERESOURCE = 3698973494;
var IFCTYPEPROCESS = 3736923433;
var IFCTESSELLATEDITEM = 901063453;
var IFCSWEPTDISKSOLIDPOLYGONAL = 1096409881;
var IFCRESOURCETIME = 1042787934;
var IFCRESOURCECONSTRAINTRELATIONSHIP = 1608871552;
var IFCRESOURCEAPPROVALRELATIONSHIP = 2943643501;
var IFCQUANTITYSET = 2090586900;
var IFCPROPERTYTEMPLATEDEFINITION = 1482703590;
var IFCPREDEFINEDPROPERTIES = 3778827333;
var IFCMIRROREDPROFILEDEF = 2998442950;
var IFCMATERIALRELATIONSHIP = 853536259;
var IFCMATERIALPROFILESETUSAGETAPERING = 3404854881;
var IFCMATERIALPROFILESETUSAGE = 3079605661;
var IFCMATERIALCONSTITUENTSET = 2852063980;
var IFCMATERIALCONSTITUENT = 3708119e3;
var IFCLAGTIME = 1585845231;
var IFCINDEXEDTRIANGLETEXTUREMAP = 2133299955;
var IFCINDEXEDTEXTUREMAP = 1437953363;
var IFCINDEXEDCOLOURMAP = 3570813810;
var IFCEXTERNALREFERENCERELATIONSHIP = 1437805879;
var IFCEXTENDEDPROPERTIES = 297599258;
var IFCEVENTTIME = 211053100;
var IFCCONVERSIONBASEDUNITWITHOFFSET = 2713554722;
var IFCCOLOURRGBLIST = 3285139300;
var IFCWORKTIME = 1236880293;
var IFCTIMEPERIOD = 1199560280;
var IFCTEXTUREVERTEXLIST = 3611470254;
var IFCTASKTIMERECURRING = 2771591690;
var IFCTASKTIME = 1549132990;
var IFCTABLECOLUMN = 2043862942;
var IFCSURFACEREINFORCEMENTAREA = 2934153892;
var IFCSTRUCTURALLOADORRESULT = 609421318;
var IFCSTRUCTURALLOADCONFIGURATION = 3478079324;
var IFCSCHEDULINGTIME = 1054537805;
var IFCRESOURCELEVELRELATIONSHIP = 2439245199;
var IFCREFERENCE = 2433181523;
var IFCRECURRENCEPATTERN = 3915482550;
var IFCPROPERTYABSTRACTION = 986844984;
var IFCPROJECTEDCRS = 3843373140;
var IFCPRESENTATIONITEM = 677532197;
var IFCMATERIALUSAGEDEFINITION = 1507914824;
var IFCMATERIALPROFILEWITHOFFSETS = 552965576;
var IFCMATERIALPROFILESET = 164193824;
var IFCMATERIALPROFILE = 2235152071;
var IFCMATERIALLAYERWITHOFFSETS = 1847252529;
var IFCMATERIALDEFINITION = 760658860;
var IFCMAPCONVERSION = 3057273783;
var IFCEXTERNALINFORMATION = 4294318154;
var IFCCOORDINATEREFERENCESYSTEM = 1466758467;
var IFCCOORDINATEOPERATION = 1785450214;
var IFCCONNECTIONVOLUMEGEOMETRY = 775493141;
var IFCREINFORCINGBAR = 979691226;
var IFCELECTRICDISTRIBUTIONPOINT = 3700593921;
var IFCDISTRIBUTIONCONTROLELEMENT = 1062813311;
var IFCDISTRIBUTIONCHAMBERELEMENT = 1052013943;
var IFCCONTROLLERTYPE = 578613899;
var IFCCHAMFEREDGEFEATURE = 2454782716;
var IFCBEAM = 753842376;
var IFCALARMTYPE = 3001207471;
var IFCACTUATORTYPE = 2874132201;
var IFCWINDOW = 3304561284;
var IFCWALLSTANDARDCASE = 3512223829;
var IFCWALL = 2391406946;
var IFCVIBRATIONISOLATORTYPE = 3313531582;
var IFCTENDONANCHOR = 2347447852;
var IFCTENDON = 3824725483;
var IFCSTRUCTURALANALYSISMODEL = 2515109513;
var IFCSTAIRFLIGHT = 4252922144;
var IFCSTAIR = 331165859;
var IFCSLAB = 1529196076;
var IFCSENSORTYPE = 1783015770;
var IFCROUNDEDEDGEFEATURE = 1376911519;
var IFCROOF = 2016517767;
var IFCREINFORCINGMESH = 2320036040;
var IFCREINFORCINGELEMENT = 3027567501;
var IFCRATIONALBEZIERCURVE = 3055160366;
var IFCRAMPFLIGHT = 3283111854;
var IFCRAMP = 3024970846;
var IFCRAILING = 2262370178;
var IFCPLATE = 3171933400;
var IFCPILE = 1687234759;
var IFCMEMBER = 1073191201;
var IFCFOOTING = 900683007;
var IFCFLOWTREATMENTDEVICE = 3508470533;
var IFCFLOWTERMINAL = 2223149337;
var IFCFLOWSTORAGEDEVICE = 707683696;
var IFCFLOWSEGMENT = 987401354;
var IFCFLOWMOVINGDEVICE = 3132237377;
var IFCFLOWINSTRUMENTTYPE = 4037862832;
var IFCFLOWFITTING = 4278956645;
var IFCFLOWCONTROLLER = 2058353004;
var IFCFIRESUPPRESSIONTERMINALTYPE = 4222183408;
var IFCFILTERTYPE = 1810631287;
var IFCFANTYPE = 346874300;
var IFCENERGYCONVERSIONDEVICE = 1658829314;
var IFCELECTRICALELEMENT = 857184966;
var IFCELECTRICALCIRCUIT = 1634875225;
var IFCELECTRICTIMECONTROLTYPE = 712377611;
var IFCELECTRICMOTORTYPE = 1217240411;
var IFCELECTRICHEATERTYPE = 1365060375;
var IFCELECTRICGENERATORTYPE = 1534661035;
var IFCELECTRICFLOWSTORAGEDEVICETYPE = 3277789161;
var IFCELECTRICAPPLIANCETYPE = 663422040;
var IFCEDGEFEATURE = 855621170;
var IFCDUCTSILENCERTYPE = 2030761528;
var IFCDUCTSEGMENTTYPE = 3760055223;
var IFCDUCTFITTINGTYPE = 869906466;
var IFCDOOR = 395920057;
var IFCDISTRIBUTIONPORT = 3041715199;
var IFCDISTRIBUTIONFLOWELEMENT = 3040386961;
var IFCDISTRIBUTIONELEMENT = 1945004755;
var IFCDISTRIBUTIONCONTROLELEMENTTYPE = 2063403501;
var IFCDISTRIBUTIONCHAMBERELEMENTTYPE = 1599208980;
var IFCDISCRETEACCESSORYTYPE = 2635815018;
var IFCDISCRETEACCESSORY = 1335981549;
var IFCDIAMETERDIMENSION = 4147604152;
var IFCDAMPERTYPE = 3961806047;
var IFCCURTAINWALL = 3495092785;
var IFCCOVERING = 1973544240;
var IFCCOOLINGTOWERTYPE = 2954562838;
var IFCCOOLEDBEAMTYPE = 335055490;
var IFCCONSTRUCTIONPRODUCTRESOURCE = 488727124;
var IFCCONSTRUCTIONMATERIALRESOURCE = 1060000209;
var IFCCONSTRUCTIONEQUIPMENTRESOURCE = 3898045240;
var IFCCONDITIONCRITERION = 1163958913;
var IFCCONDITION = 2188551683;
var IFCCONDENSERTYPE = 2816379211;
var IFCCOMPRESSORTYPE = 3850581409;
var IFCCOLUMN = 843113511;
var IFCCOILTYPE = 2301859152;
var IFCCIRCLE = 2611217952;
var IFCCHILLERTYPE = 2951183804;
var IFCCABLESEGMENTTYPE = 1285652485;
var IFCCABLECARRIERSEGMENTTYPE = 3293546465;
var IFCCABLECARRIERFITTINGTYPE = 395041908;
var IFCBUILDINGELEMENTPROXYTYPE = 1909888760;
var IFCBUILDINGELEMENTPROXY = 1095909175;
var IFCBUILDINGELEMENTPART = 2979338954;
var IFCBUILDINGELEMENTCOMPONENT = 52481810;
var IFCBUILDINGELEMENT = 3299480353;
var IFCBOILERTYPE = 231477066;
var IFCBEZIERCURVE = 1916977116;
var IFCBEAMTYPE = 819618141;
var IFCBSPLINECURVE = 1967976161;
var IFCASSET = 3460190687;
var IFCANGULARDIMENSION = 2470393545;
var IFCAIRTOAIRHEATRECOVERYTYPE = 1871374353;
var IFCAIRTERMINALTYPE = 3352864051;
var IFCAIRTERMINALBOXTYPE = 1411407467;
var IFCACTIONREQUEST = 3821786052;
var IFC2DCOMPOSITECURVE = 1213861670;
var IFCZONE = 1033361043;
var IFCWORKSCHEDULE = 3342526732;
var IFCWORKPLAN = 4218914973;
var IFCWORKCONTROL = 1028945134;
var IFCWASTETERMINALTYPE = 1133259667;
var IFCWALLTYPE = 1898987631;
var IFCVIRTUALELEMENT = 2769231204;
var IFCVALVETYPE = 728799441;
var IFCUNITARYEQUIPMENTTYPE = 1911125066;
var IFCTUBEBUNDLETYPE = 1600972822;
var IFCTRIMMEDCURVE = 3593883385;
var IFCTRANSPORTELEMENT = 1620046519;
var IFCTRANSFORMERTYPE = 1692211062;
var IFCTIMESERIESSCHEDULE = 1637806684;
var IFCTANKTYPE = 5716631;
var IFCSYSTEM = 2254336722;
var IFCSWITCHINGDEVICETYPE = 2315554128;
var IFCSUBCONTRACTRESOURCE = 148013059;
var IFCSTRUCTURALSURFACECONNECTION = 1975003073;
var IFCSTRUCTURALRESULTGROUP = 2986769608;
var IFCSTRUCTURALPOINTREACTION = 1235345126;
var IFCSTRUCTURALPOINTCONNECTION = 734778138;
var IFCSTRUCTURALPOINTACTION = 2082059205;
var IFCSTRUCTURALPLANARACTIONVARYING = 3987759626;
var IFCSTRUCTURALPLANARACTION = 1621171031;
var IFCSTRUCTURALLOADGROUP = 1252848954;
var IFCSTRUCTURALLINEARACTIONVARYING = 1721250024;
var IFCSTRUCTURALLINEARACTION = 1807405624;
var IFCSTRUCTURALCURVEMEMBERVARYING = 2445595289;
var IFCSTRUCTURALCURVEMEMBER = 214636428;
var IFCSTRUCTURALCURVECONNECTION = 4243806635;
var IFCSTRUCTURALCONNECTION = 1179482911;
var IFCSTRUCTURALACTION = 682877961;
var IFCSTAIRFLIGHTTYPE = 1039846685;
var IFCSTACKTERMINALTYPE = 3112655638;
var IFCSPACETYPE = 3812236995;
var IFCSPACEPROGRAM = 652456506;
var IFCSPACEHEATERTYPE = 1305183839;
var IFCSPACE = 3856911033;
var IFCSLABTYPE = 2533589738;
var IFCSITE = 4097777520;
var IFCSERVICELIFE = 4105383287;
var IFCSCHEDULETIMECONTROL = 3517283431;
var IFCSANITARYTERMINALTYPE = 1768891740;
var IFCRELASSIGNSTASKS = 2863920197;
var IFCRELAGGREGATES = 160246688;
var IFCRAMPFLIGHTTYPE = 2324767716;
var IFCRAILINGTYPE = 2893384427;
var IFCRADIUSDIMENSION = 3248260540;
var IFCPUMPTYPE = 2250791053;
var IFCPROTECTIVEDEVICETYPE = 1842657554;
var IFCPROJECTIONELEMENT = 3651124850;
var IFCPROJECTORDERRECORD = 3642467123;
var IFCPROJECTORDER = 2904328755;
var IFCPROCEDURE = 2744685151;
var IFCPORT = 3740093272;
var IFCPOLYLINE = 3724593414;
var IFCPLATETYPE = 4017108033;
var IFCPIPESEGMENTTYPE = 4231323485;
var IFCPIPEFITTINGTYPE = 804291784;
var IFCPERMIT = 3327091369;
var IFCPERFORMANCEHISTORY = 2382730787;
var IFCOUTLETTYPE = 2837617999;
var IFCORDERACTION = 3425660407;
var IFCOPENINGELEMENT = 3588315303;
var IFCOCCUPANT = 4143007308;
var IFCMOVE = 1916936684;
var IFCMOTORCONNECTIONTYPE = 977012517;
var IFCMEMBERTYPE = 3181161470;
var IFCMECHANICALFASTENERTYPE = 2108223431;
var IFCMECHANICALFASTENER = 377706215;
var IFCLINEARDIMENSION = 2506943328;
var IFCLIGHTFIXTURETYPE = 1161773419;
var IFCLAMPTYPE = 1051575348;
var IFCLABORRESOURCE = 3827777499;
var IFCJUNCTIONBOXTYPE = 4288270099;
var IFCINVENTORY = 2391368822;
var IFCHUMIDIFIERTYPE = 1806887404;
var IFCHEATEXCHANGERTYPE = 1251058090;
var IFCGROUP = 2706460486;
var IFCGRID = 3009204131;
var IFCGASTERMINALTYPE = 200128114;
var IFCFURNITURESTANDARD = 814719939;
var IFCFURNISHINGELEMENT = 263784265;
var IFCFLOWTREATMENTDEVICETYPE = 3009222698;
var IFCFLOWTERMINALTYPE = 2297155007;
var IFCFLOWSTORAGEDEVICETYPE = 1339347760;
var IFCFLOWSEGMENTTYPE = 1834744321;
var IFCFLOWMOVINGDEVICETYPE = 1482959167;
var IFCFLOWMETERTYPE = 3815607619;
var IFCFLOWFITTINGTYPE = 3198132628;
var IFCFLOWCONTROLLERTYPE = 3907093117;
var IFCFEATUREELEMENTSUBTRACTION = 1287392070;
var IFCFEATUREELEMENTADDITION = 2143335405;
var IFCFEATUREELEMENT = 2827207264;
var IFCFASTENERTYPE = 2489546625;
var IFCFASTENER = 647756555;
var IFCFACETEDBREPWITHVOIDS = 3737207727;
var IFCFACETEDBREP = 807026263;
var IFCEVAPORATORTYPE = 3390157468;
var IFCEVAPORATIVECOOLERTYPE = 3174744832;
var IFCEQUIPMENTSTANDARD = 3272907226;
var IFCEQUIPMENTELEMENT = 1962604670;
var IFCENERGYCONVERSIONDEVICETYPE = 2107101300;
var IFCELLIPSE = 1704287377;
var IFCELEMENTCOMPONENTTYPE = 2590856083;
var IFCELEMENTCOMPONENT = 1623761950;
var IFCELEMENTASSEMBLY = 4123344466;
var IFCELEMENT = 1758889154;
var IFCELECTRICALBASEPROPERTIES = 360485395;
var IFCDISTRIBUTIONFLOWELEMENTTYPE = 3849074793;
var IFCDISTRIBUTIONELEMENTTYPE = 3256556792;
var IFCDIMENSIONCURVEDIRECTEDCALLOUT = 681481545;
var IFCCURTAINWALLTYPE = 1457835157;
var IFCCREWRESOURCE = 3295246426;
var IFCCOVERINGTYPE = 1916426348;
var IFCCOSTSCHEDULE = 1419761937;
var IFCCOSTITEM = 3895139033;
var IFCCONTROL = 3293443760;
var IFCCONSTRUCTIONRESOURCE = 2559216714;
var IFCCONIC = 2510884976;
var IFCCOMPOSITECURVE = 3732776249;
var IFCCOLUMNTYPE = 300633059;
var IFCCIRCLEHOLLOWPROFILEDEF = 2937912522;
var IFCBUILDINGSTOREY = 3124254112;
var IFCBUILDINGELEMENTTYPE = 1950629157;
var IFCBUILDING = 4031249490;
var IFCBOUNDEDCURVE = 1260505505;
var IFCBOOLEANCLIPPINGRESULT = 3649129432;
var IFCBLOCK = 1334484129;
var IFCASYMMETRICISHAPEPROFILEDEF = 3207858831;
var IFCANNOTATION = 1674181508;
var IFCACTOR = 2296667514;
var IFCTRANSPORTELEMENTTYPE = 2097647324;
var IFCTASK = 3473067441;
var IFCSYSTEMFURNITUREELEMENTTYPE = 1580310250;
var IFCSURFACEOFREVOLUTION = 4124788165;
var IFCSURFACEOFLINEAREXTRUSION = 2809605785;
var IFCSURFACECURVESWEPTAREASOLID = 2028607225;
var IFCSTRUCTUREDDIMENSIONCALLOUT = 4070609034;
var IFCSTRUCTURALSURFACEMEMBERVARYING = 2218152070;
var IFCSTRUCTURALSURFACEMEMBER = 3979015343;
var IFCSTRUCTURALREACTION = 3689010777;
var IFCSTRUCTURALMEMBER = 530289379;
var IFCSTRUCTURALITEM = 3136571912;
var IFCSTRUCTURALACTIVITY = 3544373492;
var IFCSPHERE = 451544542;
var IFCSPATIALSTRUCTUREELEMENTTYPE = 3893378262;
var IFCSPATIALSTRUCTUREELEMENT = 2706606064;
var IFCRIGHTCIRCULARCYLINDER = 3626867408;
var IFCRIGHTCIRCULARCONE = 4158566097;
var IFCREVOLVEDAREASOLID = 1856042241;
var IFCRESOURCE = 2914609552;
var IFCRELVOIDSELEMENT = 1401173127;
var IFCRELSPACEBOUNDARY = 3451746338;
var IFCRELSERVICESBUILDINGS = 366585022;
var IFCRELSEQUENCE = 4122056220;
var IFCRELSCHEDULESCOSTITEMS = 1058617721;
var IFCRELREFERENCEDINSPATIALSTRUCTURE = 1245217292;
var IFCRELPROJECTSELEMENT = 750771296;
var IFCRELOVERRIDESPROPERTIES = 202636808;
var IFCRELOCCUPIESSPACES = 2051452291;
var IFCRELNESTS = 3268803585;
var IFCRELINTERACTIONREQUIREMENTS = 4189434867;
var IFCRELFLOWCONTROLELEMENTS = 279856033;
var IFCRELFILLSELEMENT = 3940055652;
var IFCRELDEFINESBYTYPE = 781010003;
var IFCRELDEFINESBYPROPERTIES = 4186316022;
var IFCRELDEFINES = 693640335;
var IFCRELDECOMPOSES = 2551354335;
var IFCRELCOVERSSPACES = 2802773753;
var IFCRELCOVERSBLDGELEMENTS = 886880790;
var IFCRELCONTAINEDINSPATIALSTRUCTURE = 3242617779;
var IFCRELCONNECTSWITHREALIZINGELEMENTS = 3678494232;
var IFCRELCONNECTSWITHECCENTRICITY = 504942748;
var IFCRELCONNECTSSTRUCTURALMEMBER = 1638771189;
var IFCRELCONNECTSSTRUCTURALELEMENT = 3912681535;
var IFCRELCONNECTSSTRUCTURALACTIVITY = 2127690289;
var IFCRELCONNECTSPORTS = 3190031847;
var IFCRELCONNECTSPORTTOELEMENT = 4201705270;
var IFCRELCONNECTSPATHELEMENTS = 3945020480;
var IFCRELCONNECTSELEMENTS = 1204542856;
var IFCRELCONNECTS = 826625072;
var IFCRELASSOCIATESPROFILEPROPERTIES = 2851387026;
var IFCRELASSOCIATESMATERIAL = 2655215786;
var IFCRELASSOCIATESLIBRARY = 3840914261;
var IFCRELASSOCIATESDOCUMENT = 982818633;
var IFCRELASSOCIATESCONSTRAINT = 2728634034;
var IFCRELASSOCIATESCLASSIFICATION = 919958153;
var IFCRELASSOCIATESAPPROVAL = 4095574036;
var IFCRELASSOCIATESAPPLIEDVALUE = 1327628568;
var IFCRELASSOCIATES = 1865459582;
var IFCRELASSIGNSTORESOURCE = 205026976;
var IFCRELASSIGNSTOPROJECTORDER = 3372526763;
var IFCRELASSIGNSTOPRODUCT = 2857406711;
var IFCRELASSIGNSTOPROCESS = 4278684876;
var IFCRELASSIGNSTOGROUP = 1307041759;
var IFCRELASSIGNSTOCONTROL = 2495723537;
var IFCRELASSIGNSTOACTOR = 1683148259;
var IFCRELASSIGNS = 3939117080;
var IFCRECTANGULARTRIMMEDSURFACE = 3454111270;
var IFCRECTANGULARPYRAMID = 2798486643;
var IFCRECTANGLEHOLLOWPROFILEDEF = 2770003689;
var IFCPROXY = 3219374653;
var IFCPROPERTYSET = 1451395588;
var IFCPROJECTIONCURVE = 4194566429;
var IFCPROJECT = 103090709;
var IFCPRODUCT = 4208778838;
var IFCPROCESS = 2945172077;
var IFCPLANE = 220341763;
var IFCPLANARBOX = 603570806;
var IFCPERMEABLECOVERINGPROPERTIES = 3566463478;
var IFCOFFSETCURVE3D = 3505215534;
var IFCOFFSETCURVE2D = 3388369263;
var IFCOBJECT = 3888040117;
var IFCMANIFOLDSOLIDBREP = 1425443689;
var IFCLINE = 1281925730;
var IFCLSHAPEPROFILEDEF = 572779678;
var IFCISHAPEPROFILEDEF = 1484403080;
var IFCGEOMETRICCURVESET = 987898635;
var IFCFURNITURETYPE = 1268542332;
var IFCFURNISHINGELEMENTTYPE = 4238390223;
var IFCFLUIDFLOWPROPERTIES = 3455213021;
var IFCFILLAREASTYLETILES = 315944413;
var IFCFILLAREASTYLETILESYMBOLWITHSTYLE = 4203026998;
var IFCFILLAREASTYLEHATCHING = 374418227;
var IFCFACEBASEDSURFACEMODEL = 2047409740;
var IFCEXTRUDEDAREASOLID = 477187591;
var IFCENERGYPROPERTIES = 80994333;
var IFCELLIPSEPROFILEDEF = 2835456948;
var IFCELEMENTARYSURFACE = 2777663545;
var IFCELEMENTTYPE = 339256511;
var IFCELEMENTQUANTITY = 1883228015;
var IFCEDGELOOP = 1472233963;
var IFCDRAUGHTINGPREDEFINEDCURVEFONT = 4006246654;
var IFCDRAUGHTINGPREDEFINEDCOLOUR = 445594917;
var IFCDRAUGHTINGCALLOUT = 3073041342;
var IFCDOORSTYLE = 526551008;
var IFCDOORPANELPROPERTIES = 1714330368;
var IFCDOORLININGPROPERTIES = 2963535650;
var IFCDIRECTION = 32440307;
var IFCDIMENSIONCURVETERMINATOR = 4054601972;
var IFCDIMENSIONCURVE = 606661476;
var IFCDEFINEDSYMBOL = 693772133;
var IFCCURVEBOUNDEDPLANE = 2827736869;
var IFCCURVE = 2601014836;
var IFCCSGSOLID = 2147822146;
var IFCCSGPRIMITIVE3D = 2506170314;
var IFCCRANERAILFSHAPEPROFILEDEF = 194851669;
var IFCCRANERAILASHAPEPROFILEDEF = 4133800736;
var IFCCOMPOSITECURVESEGMENT = 2485617015;
var IFCCLOSEDSHELL = 2205249479;
var IFCCIRCLEPROFILEDEF = 1383045692;
var IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM = 1416205885;
var IFCCARTESIANTRANSFORMATIONOPERATOR3D = 3331915920;
var IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM = 3486308946;
var IFCCARTESIANTRANSFORMATIONOPERATOR2D = 3749851601;
var IFCCARTESIANTRANSFORMATIONOPERATOR = 59481748;
var IFCCARTESIANPOINT = 1123145078;
var IFCCSHAPEPROFILEDEF = 2898889636;
var IFCBOXEDHALFSPACE = 2713105998;
var IFCBOUNDINGBOX = 2581212453;
var IFCBOUNDEDSURFACE = 4182860854;
var IFCBOOLEANRESULT = 2736907675;
var IFCAXIS2PLACEMENT3D = 2740243338;
var IFCAXIS2PLACEMENT2D = 3125803723;
var IFCAXIS1PLACEMENT = 4261334040;
var IFCANNOTATIONSURFACE = 1302238472;
var IFCANNOTATIONFILLAREAOCCURRENCE = 2265737646;
var IFCANNOTATIONFILLAREA = 669184980;
var IFCANNOTATIONCURVEOCCURRENCE = 3288037868;
var IFCZSHAPEPROFILEDEF = 2543172580;
var IFCWINDOWSTYLE = 1299126871;
var IFCWINDOWPANELPROPERTIES = 512836454;
var IFCWINDOWLININGPROPERTIES = 336235671;
var IFCVERTEXLOOP = 2759199220;
var IFCVECTOR = 1417489154;
var IFCUSHAPEPROFILEDEF = 427810014;
var IFCTYPEPRODUCT = 2347495698;
var IFCTYPEOBJECT = 1628702193;
var IFCTWODIRECTIONREPEATFACTOR = 1345879162;
var IFCTRAPEZIUMPROFILEDEF = 2715220739;
var IFCTEXTLITERALWITHEXTENT = 3124975700;
var IFCTEXTLITERAL = 4282788508;
var IFCTERMINATORSYMBOL = 3028897424;
var IFCTSHAPEPROFILEDEF = 3071757647;
var IFCSWEPTSURFACE = 230924584;
var IFCSWEPTDISKSOLID = 1260650574;
var IFCSWEPTAREASOLID = 2247615214;
var IFCSURFACESTYLERENDERING = 1878645084;
var IFCSURFACE = 2513912981;
var IFCSUBEDGE = 2233826070;
var IFCSTRUCTURALSTEELPROFILEPROPERTIES = 3653947884;
var IFCSTRUCTURALPROFILEPROPERTIES = 3843319758;
var IFCSTRUCTURALLOADSINGLEFORCEWARPING = 1190533807;
var IFCSTRUCTURALLOADSINGLEFORCE = 1597423693;
var IFCSTRUCTURALLOADSINGLEDISPLACEMENTDISTORTION = 1973038258;
var IFCSTRUCTURALLOADSINGLEDISPLACEMENT = 2473145415;
var IFCSTRUCTURALLOADPLANARFORCE = 2668620305;
var IFCSTRUCTURALLOADLINEARFORCE = 1595516126;
var IFCSPACETHERMALLOADPROPERTIES = 390701378;
var IFCSOUNDVALUE = 1202362311;
var IFCSOUNDPROPERTIES = 2485662743;
var IFCSOLIDMODEL = 723233188;
var IFCSLIPPAGECONNECTIONCONDITION = 2609359061;
var IFCSHELLBASEDSURFACEMODEL = 4124623270;
var IFCSERVICELIFEFACTOR = 2411513650;
var IFCSECTIONEDSPINE = 1509187699;
var IFCROUNDEDRECTANGLEPROFILEDEF = 2778083089;
var IFCRELATIONSHIP = 478536968;
var IFCREINFORCEMENTDEFINITIONPROPERTIES = 3765753017;
var IFCREGULARTIMESERIES = 3413951693;
var IFCRECTANGLEPROFILEDEF = 3615266464;
var IFCPROPERTYTABLEVALUE = 110355661;
var IFCPROPERTYSINGLEVALUE = 3650150729;
var IFCPROPERTYSETDEFINITION = 3357820518;
var IFCPROPERTYREFERENCEVALUE = 941946838;
var IFCPROPERTYLISTVALUE = 2752243245;
var IFCPROPERTYENUMERATEDVALUE = 4166981789;
var IFCPROPERTYDEFINITION = 1680319473;
var IFCPROPERTYBOUNDEDVALUE = 871118103;
var IFCPRODUCTDEFINITIONSHAPE = 673634403;
var IFCPREDEFINEDPOINTMARKERSYMBOL = 179317114;
var IFCPREDEFINEDDIMENSIONSYMBOL = 433424934;
var IFCPREDEFINEDCURVEFONT = 2559016684;
var IFCPREDEFINEDCOLOUR = 759155922;
var IFCPOLYGONALBOUNDEDHALFSPACE = 2775532180;
var IFCPOLYLOOP = 2924175390;
var IFCPOINTONSURFACE = 1423911732;
var IFCPOINTONCURVE = 4022376103;
var IFCPOINT = 2067069095;
var IFCPLANAREXTENT = 1663979128;
var IFCPLACEMENT = 2004835150;
var IFCPIXELTEXTURE = 597895409;
var IFCPHYSICALCOMPLEXQUANTITY = 3021840470;
var IFCPATH = 2519244187;
var IFCPARAMETERIZEDPROFILEDEF = 2529465313;
var IFCORIENTEDEDGE = 1029017970;
var IFCOPENSHELL = 2665983363;
var IFCONEDIRECTIONREPEATFACTOR = 2833995503;
var IFCOBJECTDEFINITION = 219451334;
var IFCMECHANICALCONCRETEMATERIALPROPERTIES = 1430189142;
var IFCMATERIALDEFINITIONREPRESENTATION = 2022407955;
var IFCMAPPEDITEM = 2347385850;
var IFCLOOP = 1008929658;
var IFCLOCALPLACEMENT = 2624227202;
var IFCLIGHTSOURCESPOT = 3422422726;
var IFCLIGHTSOURCEPOSITIONAL = 1520743889;
var IFCLIGHTSOURCEGONIOMETRIC = 4266656042;
var IFCLIGHTSOURCEDIRECTIONAL = 2604431987;
var IFCLIGHTSOURCEAMBIENT = 125510826;
var IFCLIGHTSOURCE = 1402838566;
var IFCIRREGULARTIMESERIES = 3741457305;
var IFCIMAGETEXTURE = 3905492369;
var IFCHYGROSCOPICMATERIALPROPERTIES = 2445078500;
var IFCHALFSPACESOLID = 812098782;
var IFCGRIDPLACEMENT = 178086475;
var IFCGEOMETRICSET = 3590301190;
var IFCGEOMETRICREPRESENTATIONSUBCONTEXT = 4142052618;
var IFCGEOMETRICREPRESENTATIONITEM = 2453401579;
var IFCGEOMETRICREPRESENTATIONCONTEXT = 3448662350;
var IFCGENERALPROFILEPROPERTIES = 1446786286;
var IFCGENERALMATERIALPROPERTIES = 803998398;
var IFCFUELPROPERTIES = 3857492461;
var IFCFILLAREASTYLE = 738692330;
var IFCFAILURECONNECTIONCONDITION = 4219587988;
var IFCFACESURFACE = 3008276851;
var IFCFACEOUTERBOUND = 803316827;
var IFCFACEBOUND = 1809719519;
var IFCFACE = 2556980723;
var IFCEXTENDEDMATERIALPROPERTIES = 1860660968;
var IFCEDGECURVE = 476780140;
var IFCEDGE = 3900360178;
var IFCDRAUGHTINGPREDEFINEDTEXTFONT = 4170525392;
var IFCDOCUMENTREFERENCE = 3732053477;
var IFCDIMENSIONPAIR = 1694125774;
var IFCDIMENSIONCALLOUTRELATIONSHIP = 2273265877;
var IFCDERIVEDPROFILEDEF = 3632507154;
var IFCCURVESTYLE = 3800577675;
var IFCCONVERSIONBASEDUNIT = 2889183280;
var IFCCONTEXTDEPENDENTUNIT = 3050246964;
var IFCCONNECTIONPOINTECCENTRICITY = 45288368;
var IFCCONNECTIONCURVEGEOMETRY = 1981873012;
var IFCCONNECTEDFACESET = 370225590;
var IFCCOMPOSITEPROFILEDEF = 1485152156;
var IFCCOMPLEXPROPERTY = 2542286263;
var IFCCOLOURRGB = 776857604;
var IFCCLASSIFICATIONREFERENCE = 647927063;
var IFCCENTERLINEPROFILEDEF = 3150382593;
var IFCBLOBTEXTURE = 616511568;
var IFCARBITRARYPROFILEDEFWITHVOIDS = 2705031697;
var IFCARBITRARYOPENPROFILEDEF = 1310608509;
var IFCARBITRARYCLOSEDPROFILEDEF = 3798115385;
var IFCANNOTATIONTEXTOCCURRENCE = 2297822566;
var IFCANNOTATIONSYMBOLOCCURRENCE = 3612888222;
var IFCANNOTATIONSURFACEOCCURRENCE = 962685235;
var IFCANNOTATIONOCCURRENCE = 2442683028;
var IFCWATERPROPERTIES = 1065908215;
var IFCVIRTUALGRIDINTERSECTION = 891718957;
var IFCVERTEXPOINT = 1907098498;
var IFCVERTEXBASEDTEXTUREMAP = 3304826586;
var IFCVERTEX = 2799835756;
var IFCUNITASSIGNMENT = 180925521;
var IFCTOPOLOGYREPRESENTATION = 1735638870;
var IFCTOPOLOGICALREPRESENTATIONITEM = 1377556343;
var IFCTIMESERIESVALUE = 581633288;
var IFCTIMESERIESREFERENCERELATIONSHIP = 1718945513;
var IFCTIMESERIES = 3101149627;
var IFCTHERMALMATERIALPROPERTIES = 3317419933;
var IFCTEXTUREVERTEX = 1210645708;
var IFCTEXTUREMAP = 2552916305;
var IFCTEXTURECOORDINATEGENERATOR = 1742049831;
var IFCTEXTURECOORDINATE = 280115917;
var IFCTEXTSTYLEWITHBOXCHARACTERISTICS = 1484833681;
var IFCTEXTSTYLETEXTMODEL = 1640371178;
var IFCTEXTSTYLEFORDEFINEDFONT = 2636378356;
var IFCTEXTSTYLEFONTMODEL = 1983826977;
var IFCTEXTSTYLE = 1447204868;
var IFCTELECOMADDRESS = 912023232;
var IFCTABLEROW = 531007025;
var IFCTABLE = 985171141;
var IFCSYMBOLSTYLE = 1290481447;
var IFCSURFACETEXTURE = 626085974;
var IFCSURFACESTYLEWITHTEXTURES = 1351298697;
var IFCSURFACESTYLESHADING = 846575682;
var IFCSURFACESTYLEREFRACTION = 1607154358;
var IFCSURFACESTYLELIGHTING = 3303107099;
var IFCSURFACESTYLE = 1300840506;
var IFCSTYLEDREPRESENTATION = 3049322572;
var IFCSTYLEDITEM = 3958052878;
var IFCSTYLEMODEL = 2830218821;
var IFCSTRUCTURALLOADTEMPERATURE = 3408363356;
var IFCSTRUCTURALLOADSTATIC = 2525727697;
var IFCSTRUCTURALLOAD = 2162789131;
var IFCSTRUCTURALCONNECTIONCONDITION = 2273995522;
var IFCSIMPLEPROPERTY = 3692461612;
var IFCSHAPEREPRESENTATION = 4240577450;
var IFCSHAPEMODEL = 3982875396;
var IFCSHAPEASPECT = 867548509;
var IFCSECTIONREINFORCEMENTPROPERTIES = 4165799628;
var IFCSECTIONPROPERTIES = 2042790032;
var IFCSIUNIT = 448429030;
var IFCROOT = 2341007311;
var IFCRIBPLATEPROFILEPROPERTIES = 3679540991;
var IFCREPRESENTATIONMAP = 1660063152;
var IFCREPRESENTATIONITEM = 3008791417;
var IFCREPRESENTATIONCONTEXT = 3377609919;
var IFCREPRESENTATION = 1076942058;
var IFCRELAXATION = 1222501353;
var IFCREINFORCEMENTBARPROPERTIES = 1580146022;
var IFCREFERENCESVALUEDOCUMENT = 2692823254;
var IFCQUANTITYWEIGHT = 825690147;
var IFCQUANTITYVOLUME = 2405470396;
var IFCQUANTITYTIME = 3252649465;
var IFCQUANTITYLENGTH = 931644368;
var IFCQUANTITYCOUNT = 2093928680;
var IFCQUANTITYAREA = 2044713172;
var IFCPROPERTYENUMERATION = 3710013099;
var IFCPROPERTYDEPENDENCYRELATIONSHIP = 148025276;
var IFCPROPERTYCONSTRAINTRELATIONSHIP = 3896028662;
var IFCPROPERTY = 2598011224;
var IFCPROFILEPROPERTIES = 2802850158;
var IFCPROFILEDEF = 3958567839;
var IFCPRODUCTSOFCOMBUSTIONPROPERTIES = 2267347899;
var IFCPRODUCTREPRESENTATION = 2095639259;
var IFCPRESENTATIONSTYLEASSIGNMENT = 2417041796;
var IFCPRESENTATIONSTYLE = 3119450353;
var IFCPRESENTATIONLAYERWITHSTYLE = 1304840413;
var IFCPRESENTATIONLAYERASSIGNMENT = 2022622350;
var IFCPREDEFINEDTEXTFONT = 1775413392;
var IFCPREDEFINEDTERMINATORSYMBOL = 3213052703;
var IFCPREDEFINEDSYMBOL = 990879717;
var IFCPREDEFINEDITEM = 3727388367;
var IFCPOSTALADDRESS = 3355820592;
var IFCPHYSICALSIMPLEQUANTITY = 2226359599;
var IFCPHYSICALQUANTITY = 2483315170;
var IFCPERSONANDORGANIZATION = 101040310;
var IFCPERSON = 2077209135;
var IFCOWNERHISTORY = 1207048766;
var IFCORGANIZATIONRELATIONSHIP = 1411181986;
var IFCORGANIZATION = 4251960020;
var IFCOPTICALMATERIALPROPERTIES = 1227763645;
var IFCOBJECTIVE = 2251480897;
var IFCOBJECTPLACEMENT = 3701648758;
var IFCNAMEDUNIT = 1918398963;
var IFCMONETARYUNIT = 2706619895;
var IFCMETRIC = 3368373690;
var IFCMECHANICALSTEELMATERIALPROPERTIES = 677618848;
var IFCMECHANICALMATERIALPROPERTIES = 4256014907;
var IFCMEASUREWITHUNIT = 2597039031;
var IFCMATERIALPROPERTIES = 3265635763;
var IFCMATERIALLIST = 2199411900;
var IFCMATERIALLAYERSETUSAGE = 1303795690;
var IFCMATERIALLAYERSET = 3303938423;
var IFCMATERIALLAYER = 248100487;
var IFCMATERIALCLASSIFICATIONRELATIONSHIP = 1847130766;
var IFCMATERIAL = 1838606355;
var IFCLOCALTIME = 30780891;
var IFCLIGHTINTENSITYDISTRIBUTION = 1566485204;
var IFCLIGHTDISTRIBUTIONDATA = 4162380809;
var IFCLIBRARYREFERENCE = 3452421091;
var IFCLIBRARYINFORMATION = 2655187982;
var IFCIRREGULARTIMESERIESVALUE = 3020489413;
var IFCGRIDAXIS = 852622518;
var IFCEXTERNALLYDEFINEDTEXTFONT = 3548104201;
var IFCEXTERNALLYDEFINEDSYMBOL = 3207319532;
var IFCEXTERNALLYDEFINEDSURFACESTYLE = 1040185647;
var IFCEXTERNALLYDEFINEDHATCHSTYLE = 2242383968;
var IFCEXTERNALREFERENCE = 3200245327;
var IFCENVIRONMENTALIMPACTVALUE = 1648886627;
var IFCDRAUGHTINGCALLOUTRELATIONSHIP = 3796139169;
var IFCDOCUMENTINFORMATIONRELATIONSHIP = 770865208;
var IFCDOCUMENTINFORMATION = 1154170062;
var IFCDOCUMENTELECTRONICFORMAT = 1376555844;
var IFCDIMENSIONALEXPONENTS = 2949456006;
var IFCDERIVEDUNITELEMENT = 1045800335;
var IFCDERIVEDUNIT = 1765591967;
var IFCDATEANDTIME = 1072939445;
var IFCCURVESTYLEFONTPATTERN = 3510044353;
var IFCCURVESTYLEFONTANDSCALING = 2367409068;
var IFCCURVESTYLEFONT = 1105321065;
var IFCCURRENCYRELATIONSHIP = 539742890;
var IFCCOSTVALUE = 602808272;
var IFCCOORDINATEDUNIVERSALTIMEOFFSET = 1065062679;
var IFCCONSTRAINTRELATIONSHIP = 347226245;
var IFCCONSTRAINTCLASSIFICATIONRELATIONSHIP = 613356794;
var IFCCONSTRAINTAGGREGATIONRELATIONSHIP = 1658513725;
var IFCCONSTRAINT = 1959218052;
var IFCCONNECTIONSURFACEGEOMETRY = 2732653382;
var IFCCONNECTIONPORTGEOMETRY = 4257277454;
var IFCCONNECTIONPOINTGEOMETRY = 2614616156;
var IFCCONNECTIONGEOMETRY = 2859738748;
var IFCCOLOURSPECIFICATION = 3264961684;
var IFCCLASSIFICATIONNOTATIONFACET = 3639012971;
var IFCCLASSIFICATIONNOTATION = 938368621;
var IFCCLASSIFICATIONITEMRELATIONSHIP = 1098599126;
var IFCCLASSIFICATIONITEM = 1767535486;
var IFCCLASSIFICATION = 747523909;
var IFCCALENDARDATE = 622194075;
var IFCBOUNDARYNODECONDITIONWARPING = 2069777674;
var IFCBOUNDARYNODECONDITION = 1387855156;
var IFCBOUNDARYFACECONDITION = 3367102660;
var IFCBOUNDARYEDGECONDITION = 1560379544;
var IFCBOUNDARYCONDITION = 4037036970;
var IFCAPPROVALRELATIONSHIP = 3869604511;
var IFCAPPROVALPROPERTYRELATIONSHIP = 390851274;
var IFCAPPROVALACTORRELATIONSHIP = 2080292479;
var IFCAPPROVAL = 130549933;
var IFCAPPLIEDVALUERELATIONSHIP = 1110488051;
var IFCAPPLIEDVALUE = 411424972;
var IFCAPPLICATION = 639542469;
var IFCADDRESS = 618182010;
var IFCACTORROLE = 3630933823;
var FILE_DESCRIPTION = 599546466;
var FILE_NAME = 1390159747;
var FILE_SCHEMA = 1109904537;
var Handle = class {
  constructor(value) {
    this.value = value;
    this.type = 5;
  }
};
var logical;
(function(logical2) {
  logical2[logical2["FALSE"] = 0] = "FALSE";
  logical2[logical2["TRUE"] = 1] = "TRUE";
  logical2[logical2["UNKNOWN"] = 2] = "UNKNOWN";
})(logical || (logical = {}));
var IfcLineObject = class {
  constructor(expressID = -1) {
    this.expressID = expressID;
    this.type = 0;
  }
};
var FromRawLineData = [];
var InversePropertyDef = {};
var InheritanceDef = {};
var Constructors = {};
var ToRawLineData = {};
var TypeInitialisers = {};
var SchemaNames = [];
function TypeInitialiser(schema, tapeItem) {
  if (Array.isArray(tapeItem))
    tapeItem.map((p) => TypeInitialiser(schema, p));
  if (tapeItem.typecode)
    return TypeInitialisers[schema][tapeItem.typecode](tapeItem.value);
  else
    return tapeItem.value;
}
function Labelise(tapeItem) {
  if (tapeItem.label)
    return tapeItem;
  else
    return { value: tapeItem.value.toString(), valueType: tapeItem.type, type: 2, label: tapeItem.name };
}
function BooleanConvert(item) {
  switch (item.toString()) {
    case "true":
      return "T";
    case "false":
      return "F";
    case "0":
      return "F";
    case "1":
      return "T";
    case "2":
      return "U";
  }
}
var Schemas;
(function(Schemas2) {
  Schemas2["IFC2X3"] = "IFC2X3";
  Schemas2["IFC4"] = "IFC4";
  Schemas2["IFC4X3"] = "IFC4X3";
})(Schemas || (Schemas = {}));
SchemaNames[1] = ["IFC2X3", "IFC2X_FINAL"];
FromRawLineData[1] = {
  3630933823: (v) => new IFC2X3.IfcActorRole(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcText(!v[2] ? null : v[2].value)),
  618182010: (v) => new IFC2X3.IfcAddress(v[0], !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  639542469: (v) => new IFC2X3.IfcApplication(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), new IFC2X3.IfcIdentifier(!v[3] ? null : v[3].value)),
  411424972: (v) => new IFC2X3.IfcAppliedValue(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value)),
  1110488051: (v) => {
    var _a;
    return new IFC2X3.IfcAppliedValueRelationship(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[2], !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcText(!v[4] ? null : v[4].value));
  },
  130549933: (v) => new IFC2X3.IfcApproval(!v[0] ? null : new IFC2X3.IfcText(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcText(!v[4] ? null : v[4].value), new IFC2X3.IfcLabel(!v[5] ? null : v[5].value), new IFC2X3.IfcIdentifier(!v[6] ? null : v[6].value)),
  2080292479: (v) => new IFC2X3.IfcApprovalActorRelationship(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  390851274: (v) => {
    var _a;
    return new IFC2X3.IfcApprovalPropertyRelationship(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[1] ? null : v[1].value));
  },
  3869604511: (v) => new IFC2X3.IfcApprovalRelationship(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcText(!v[2] ? null : v[2].value), new IFC2X3.IfcLabel(!v[3] ? null : v[3].value)),
  4037036970: (v) => new IFC2X3.IfcBoundaryCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  1560379544: (v) => new IFC2X3.IfcBoundaryEdgeCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcModulusOfLinearSubgradeReactionMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcModulusOfLinearSubgradeReactionMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcModulusOfLinearSubgradeReactionMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcModulusOfRotationalSubgradeReactionMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcModulusOfRotationalSubgradeReactionMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcModulusOfRotationalSubgradeReactionMeasure(!v[6] ? null : v[6].value)),
  3367102660: (v) => new IFC2X3.IfcBoundaryFaceCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcModulusOfSubgradeReactionMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcModulusOfSubgradeReactionMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcModulusOfSubgradeReactionMeasure(!v[3] ? null : v[3].value)),
  1387855156: (v) => new IFC2X3.IfcBoundaryNodeCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLinearStiffnessMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLinearStiffnessMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLinearStiffnessMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcRotationalStiffnessMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcRotationalStiffnessMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcRotationalStiffnessMeasure(!v[6] ? null : v[6].value)),
  2069777674: (v) => new IFC2X3.IfcBoundaryNodeConditionWarping(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLinearStiffnessMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLinearStiffnessMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLinearStiffnessMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcRotationalStiffnessMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcRotationalStiffnessMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcRotationalStiffnessMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcWarpingMomentMeasure(!v[7] ? null : v[7].value)),
  622194075: (v) => new IFC2X3.IfcCalendarDate(new IFC2X3.IfcDayInMonthNumber(!v[0] ? null : v[0].value), new IFC2X3.IfcMonthInYearNumber(!v[1] ? null : v[1].value), new IFC2X3.IfcYearNumber(!v[2] ? null : v[2].value)),
  747523909: (v) => new IFC2X3.IfcClassification(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcLabel(!v[3] ? null : v[3].value)),
  1767535486: (v) => new IFC2X3.IfcClassificationItem(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  1098599126: (v) => {
    var _a;
    return new IFC2X3.IfcClassificationItemRelationship(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  938368621: (v) => {
    var _a;
    return new IFC2X3.IfcClassificationNotation(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3639012971: (v) => new IFC2X3.IfcClassificationNotationFacet(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  3264961684: (v) => new IFC2X3.IfcColourSpecification(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  2859738748: (_) => new IFC2X3.IfcConnectionGeometry(),
  2614616156: (v) => new IFC2X3.IfcConnectionPointGeometry(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  4257277454: (v) => new IFC2X3.IfcConnectionPortGeometry(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  2732653382: (v) => new IFC2X3.IfcConnectionSurfaceGeometry(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  1959218052: (v) => new IFC2X3.IfcConstraint(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), v[2], !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value)),
  1658513725: (v) => {
    var _a;
    return new IFC2X3.IfcConstraintAggregationRelationship(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[4]);
  },
  613356794: (v) => {
    var _a;
    return new IFC2X3.IfcConstraintClassificationRelationship(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  347226245: (v) => {
    var _a;
    return new IFC2X3.IfcConstraintRelationship(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1065062679: (v) => new IFC2X3.IfcCoordinatedUniversalTimeOffset(new IFC2X3.IfcHourInDay(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcMinuteInHour(!v[1] ? null : v[1].value), v[2]),
  602808272: (v) => new IFC2X3.IfcCostValue(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcText(!v[7] ? null : v[7].value)),
  539742890: (v) => new IFC2X3.IfcCurrencyRelationship(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value)),
  1105321065: (v) => {
    var _a;
    return new IFC2X3.IfcCurveStyleFont(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2367409068: (v) => new IFC2X3.IfcCurveStyleFontAndScaling(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value)),
  3510044353: (v) => new IFC2X3.IfcCurveStyleFontPattern(new IFC2X3.IfcLengthMeasure(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value)),
  1072939445: (v) => new IFC2X3.IfcDateAndTime(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  1765591967: (v) => {
    var _a;
    return new IFC2X3.IfcDerivedUnit(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[1], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  1045800335: (v) => new IFC2X3.IfcDerivedUnitElement(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value),
  2949456006: (v) => new IFC2X3.IfcDimensionalExponents(!v[0] ? null : v[0].value, !v[1] ? null : v[1].value, !v[2] ? null : v[2].value, !v[3] ? null : v[3].value, !v[4] ? null : v[4].value, !v[5] ? null : v[5].value, !v[6] ? null : v[6].value),
  1376555844: (v) => new IFC2X3.IfcDocumentElectronicFormat(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  1154170062: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDocumentInformation(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcText(!v[2] ? null : v[2].value), !v[3] ? null : ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[4] ? null : new IFC2X3.IfcText(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcText(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcText(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new Handle(!v[8] ? null : v[8].value), !v[9] ? null : ((_b = v[9]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[10] ? null : new Handle(!v[10] ? null : v[10].value), !v[11] ? null : new Handle(!v[11] ? null : v[11].value), !v[12] ? null : new Handle(!v[12] ? null : v[12].value), !v[13] ? null : new Handle(!v[13] ? null : v[13].value), !v[14] ? null : new Handle(!v[14] ? null : v[14].value), v[15], v[16]);
  },
  770865208: (v) => {
    var _a;
    return new IFC2X3.IfcDocumentInformationRelationship(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  3796139169: (v) => new IFC2X3.IfcDraughtingCalloutRelationship(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  1648886627: (v) => new IFC2X3.IfcEnvironmentalImpactValue(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value)),
  3200245327: (v) => new IFC2X3.IfcExternalReference(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  2242383968: (v) => new IFC2X3.IfcExternallyDefinedHatchStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  1040185647: (v) => new IFC2X3.IfcExternallyDefinedSurfaceStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  3207319532: (v) => new IFC2X3.IfcExternallyDefinedSymbol(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  3548104201: (v) => new IFC2X3.IfcExternallyDefinedTextFont(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  852622518: (v) => new IFC2X3.IfcGridAxis(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new IFC2X3.IfcBoolean(!v[2] ? null : v[2].value)),
  3020489413: (v) => {
    var _a;
    return new IFC2X3.IfcIrregularTimeSeriesValue(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || []);
  },
  2655187982: (v) => {
    var _a;
    return new IFC2X3.IfcLibraryInformation(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), !v[4] ? null : ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3452421091: (v) => new IFC2X3.IfcLibraryReference(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  4162380809: (v) => {
    var _a, _b;
    return new IFC2X3.IfcLightDistributionData(new IFC2X3.IfcPlaneAngleMeasure(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcPlaneAngleMeasure(p.value) : null)) || [], ((_b = v[2]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLuminousIntensityDistributionMeasure(p.value) : null)) || []);
  },
  1566485204: (v) => {
    var _a;
    return new IFC2X3.IfcLightIntensityDistribution(v[0], ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  30780891: (v) => new IFC2X3.IfcLocalTime(new IFC2X3.IfcHourInDay(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcMinuteInHour(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcSecondInMinute(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcDaylightSavingHour(!v[4] ? null : v[4].value)),
  1838606355: (v) => new IFC2X3.IfcMaterial(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  1847130766: (v) => {
    var _a;
    return new IFC2X3.IfcMaterialClassificationRelationship(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[1] ? null : v[1].value));
  },
  248100487: (v) => new IFC2X3.IfcMaterialLayer(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLogical(!v[2] ? null : v[2].value)),
  3303938423: (v) => {
    var _a;
    return new IFC2X3.IfcMaterialLayerSet(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value));
  },
  1303795690: (v) => new IFC2X3.IfcMaterialLayerSetUsage(new Handle(!v[0] ? null : v[0].value), v[1], v[2], new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value)),
  2199411900: (v) => {
    var _a;
    return new IFC2X3.IfcMaterialList(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3265635763: (v) => new IFC2X3.IfcMaterialProperties(new Handle(!v[0] ? null : v[0].value)),
  2597039031: (v) => new IFC2X3.IfcMeasureWithUnit(TypeInitialiser(1, v[0]), new Handle(!v[1] ? null : v[1].value)),
  4256014907: (v) => new IFC2X3.IfcMechanicalMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcDynamicViscosityMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcThermalExpansionCoefficientMeasure(!v[5] ? null : v[5].value)),
  677618848: (v) => {
    var _a;
    return new IFC2X3.IfcMechanicalSteelMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcDynamicViscosityMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcThermalExpansionCoefficientMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPressureMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPressureMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPressureMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[11] ? null : v[11].value), !v[12] ? null : ((_a = v[12]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3368373690: (v) => new IFC2X3.IfcMetric(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), v[2], !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), new Handle(!v[9] ? null : v[9].value)),
  2706619895: (v) => new IFC2X3.IfcMonetaryUnit(v[0]),
  1918398963: (v) => new IFC2X3.IfcNamedUnit(new Handle(!v[0] ? null : v[0].value), v[1]),
  3701648758: (_) => new IFC2X3.IfcObjectPlacement(),
  2251480897: (v) => new IFC2X3.IfcObjective(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), v[2], !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), !v[8] ? null : new Handle(!v[8] ? null : v[8].value), v[9], !v[10] ? null : new IFC2X3.IfcLabel(!v[10] ? null : v[10].value)),
  1227763645: (v) => new IFC2X3.IfcOpticalMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[9] ? null : v[9].value)),
  4251960020: (v) => {
    var _a, _b;
    return new IFC2X3.IfcOrganization(!v[0] ? null : new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcText(!v[2] ? null : v[2].value), !v[3] ? null : ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[4] ? null : ((_b = v[4]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1411181986: (v) => {
    var _a;
    return new IFC2X3.IfcOrganizationRelationship(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1207048766: (v) => new IFC2X3.IfcOwnerHistory(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), v[2], v[3], !v[4] ? null : new IFC2X3.IfcTimeStamp(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new IFC2X3.IfcTimeStamp(!v[7] ? null : v[7].value)),
  2077209135: (v) => {
    var _a, _b, _c, _d, _e;
    return new IFC2X3.IfcPerson(!v[0] ? null : new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[4] ? null : ((_b = v[4]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[5] ? null : ((_c = v[5]) == null ? void 0 : _c.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[6] ? null : ((_d = v[6]) == null ? void 0 : _d.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : ((_e = v[7]) == null ? void 0 : _e.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  101040310: (v) => {
    var _a;
    return new IFC2X3.IfcPersonAndOrganization(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2483315170: (v) => new IFC2X3.IfcPhysicalQuantity(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value)),
  2226359599: (v) => new IFC2X3.IfcPhysicalSimpleQuantity(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value)),
  3355820592: (v) => {
    var _a;
    return new IFC2X3.IfcPostalAddress(v[0], !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcLabel(!v[9] ? null : v[9].value));
  },
  3727388367: (v) => new IFC2X3.IfcPreDefinedItem(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  990879717: (v) => new IFC2X3.IfcPreDefinedSymbol(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  3213052703: (v) => new IFC2X3.IfcPreDefinedTerminatorSymbol(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  1775413392: (v) => new IFC2X3.IfcPreDefinedTextFont(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  2022622350: (v) => {
    var _a;
    return new IFC2X3.IfcPresentationLayerAssignment(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[3] ? null : new IFC2X3.IfcIdentifier(!v[3] ? null : v[3].value));
  },
  1304840413: (v) => {
    var _a, _b;
    return new IFC2X3.IfcPresentationLayerWithStyle(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[3] ? null : new IFC2X3.IfcIdentifier(!v[3] ? null : v[3].value), !v[4] ? null : v[4].value, !v[5] ? null : v[5].value, !v[6] ? null : v[6].value, !v[7] ? null : ((_b = v[7]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3119450353: (v) => new IFC2X3.IfcPresentationStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  2417041796: (v) => {
    var _a;
    return new IFC2X3.IfcPresentationStyleAssignment(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2095639259: (v) => {
    var _a;
    return new IFC2X3.IfcProductRepresentation(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2267347899: (v) => new IFC2X3.IfcProductsOfCombustionProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcSpecificHeatCapacityMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[4] ? null : v[4].value)),
  3958567839: (v) => new IFC2X3.IfcProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value)),
  2802850158: (v) => new IFC2X3.IfcProfileProperties(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  2598011224: (v) => new IFC2X3.IfcProperty(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value)),
  3896028662: (v) => {
    var _a;
    return new IFC2X3.IfcPropertyConstraintRelationship(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value));
  },
  148025276: (v) => new IFC2X3.IfcPropertyDependencyRelationship(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcText(!v[4] ? null : v[4].value)),
  3710013099: (v) => {
    var _a;
    return new IFC2X3.IfcPropertyEnumeration(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || [], !v[2] ? null : new Handle(!v[2] ? null : v[2].value));
  },
  2044713172: (v) => new IFC2X3.IfcQuantityArea(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcAreaMeasure(!v[3] ? null : v[3].value)),
  2093928680: (v) => new IFC2X3.IfcQuantityCount(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcCountMeasure(!v[3] ? null : v[3].value)),
  931644368: (v) => new IFC2X3.IfcQuantityLength(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value)),
  3252649465: (v) => new IFC2X3.IfcQuantityTime(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcTimeMeasure(!v[3] ? null : v[3].value)),
  2405470396: (v) => new IFC2X3.IfcQuantityVolume(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcVolumeMeasure(!v[3] ? null : v[3].value)),
  825690147: (v) => new IFC2X3.IfcQuantityWeight(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcMassMeasure(!v[3] ? null : v[3].value)),
  2692823254: (v) => {
    var _a;
    return new IFC2X3.IfcReferencesValueDocument(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value));
  },
  1580146022: (v) => new IFC2X3.IfcReinforcementBarProperties(new IFC2X3.IfcAreaMeasure(!v[0] ? null : v[0].value), new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), v[2], !v[3] ? null : new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcCountMeasure(!v[5] ? null : v[5].value)),
  1222501353: (v) => new IFC2X3.IfcRelaxation(new IFC2X3.IfcNormalisedRatioMeasure(!v[0] ? null : v[0].value), new IFC2X3.IfcNormalisedRatioMeasure(!v[1] ? null : v[1].value)),
  1076942058: (v) => {
    var _a;
    return new IFC2X3.IfcRepresentation(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3377609919: (v) => new IFC2X3.IfcRepresentationContext(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value)),
  3008791417: (_) => new IFC2X3.IfcRepresentationItem(),
  1660063152: (v) => new IFC2X3.IfcRepresentationMap(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  3679540991: (v) => new IFC2X3.IfcRibPlateProfileProperties(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), v[6]),
  2341007311: (v) => new IFC2X3.IfcRoot(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value)),
  448429030: (v) => new IFC2X3.IfcSIUnit(v[0], v[1], v[2]),
  2042790032: (v) => new IFC2X3.IfcSectionProperties(v[0], new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value)),
  4165799628: (v) => {
    var _a;
    return new IFC2X3.IfcSectionReinforcementProperties(new IFC2X3.IfcLengthMeasure(!v[0] ? null : v[0].value), new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLengthMeasure(!v[2] ? null : v[2].value), v[3], new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  867548509: (v) => {
    var _a;
    return new IFC2X3.IfcShapeAspect(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcText(!v[2] ? null : v[2].value), !v[3] ? null : v[3].value, new Handle(!v[4] ? null : v[4].value));
  },
  3982875396: (v) => {
    var _a;
    return new IFC2X3.IfcShapeModel(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  4240577450: (v) => {
    var _a;
    return new IFC2X3.IfcShapeRepresentation(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3692461612: (v) => new IFC2X3.IfcSimpleProperty(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value)),
  2273995522: (v) => new IFC2X3.IfcStructuralConnectionCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  2162789131: (v) => new IFC2X3.IfcStructuralLoad(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  2525727697: (v) => new IFC2X3.IfcStructuralLoadStatic(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  3408363356: (v) => new IFC2X3.IfcStructuralLoadTemperature(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[3] ? null : v[3].value)),
  2830218821: (v) => {
    var _a;
    return new IFC2X3.IfcStyleModel(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3958052878: (v) => {
    var _a;
    return new IFC2X3.IfcStyledItem(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  3049322572: (v) => {
    var _a;
    return new IFC2X3.IfcStyledRepresentation(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1300840506: (v) => {
    var _a;
    return new IFC2X3.IfcSurfaceStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), v[1], ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3303107099: (v) => new IFC2X3.IfcSurfaceStyleLighting(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  1607154358: (v) => new IFC2X3.IfcSurfaceStyleRefraction(!v[0] ? null : new IFC2X3.IfcReal(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcReal(!v[1] ? null : v[1].value)),
  846575682: (v) => new IFC2X3.IfcSurfaceStyleShading(new Handle(!v[0] ? null : v[0].value)),
  1351298697: (v) => {
    var _a;
    return new IFC2X3.IfcSurfaceStyleWithTextures(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  626085974: (v) => new IFC2X3.IfcSurfaceTexture(!v[0] ? null : v[0].value, !v[1] ? null : v[1].value, v[2], !v[3] ? null : new Handle(!v[3] ? null : v[3].value)),
  1290481447: (v) => new IFC2X3.IfcSymbolStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), TypeInitialiser(1, v[1])),
  985171141: (v) => {
    var _a;
    return new IFC2X3.IfcTable(!v[0] ? null : v[0].value, ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  531007025: (v) => {
    var _a;
    return new IFC2X3.IfcTableRow(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || [], !v[1] ? null : v[1].value);
  },
  912023232: (v) => {
    var _a, _b, _c;
    return new IFC2X3.IfcTelecomAddress(v[0], !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[4] ? null : ((_b = v[4]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value), !v[6] ? null : ((_c = v[6]) == null ? void 0 : _c.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLabel(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value));
  },
  1447204868: (v) => new IFC2X3.IfcTextStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  1983826977: (v) => {
    var _a;
    return new IFC2X3.IfcTextStyleFontModel(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcTextFontName(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcFontStyle(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcFontVariant(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcFontWeight(!v[4] ? null : v[4].value), TypeInitialiser(1, v[5]));
  },
  2636378356: (v) => new IFC2X3.IfcTextStyleForDefinedFont(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  1640371178: (v) => new IFC2X3.IfcTextStyleTextModel(!v[0] ? null : TypeInitialiser(1, v[0]), !v[1] ? null : new IFC2X3.IfcTextAlignment(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcTextDecoration(!v[2] ? null : v[2].value), !v[3] ? null : TypeInitialiser(1, v[3]), !v[4] ? null : TypeInitialiser(1, v[4]), !v[5] ? null : new IFC2X3.IfcTextTransformation(!v[5] ? null : v[5].value), !v[6] ? null : TypeInitialiser(1, v[6])),
  1484833681: (v) => new IFC2X3.IfcTextStyleWithBoxCharacteristics(!v[0] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[3] ? null : v[3].value), !v[4] ? null : TypeInitialiser(1, v[4])),
  280115917: (_) => new IFC2X3.IfcTextureCoordinate(),
  1742049831: (v) => {
    var _a;
    return new IFC2X3.IfcTextureCoordinateGenerator(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || []);
  },
  2552916305: (v) => {
    var _a;
    return new IFC2X3.IfcTextureMap(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1210645708: (v) => {
    var _a;
    return new IFC2X3.IfcTextureVertex(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcParameterValue(p.value) : null)) || []);
  },
  3317419933: (v) => new IFC2X3.IfcThermalMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcSpecificHeatCapacityMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcThermalConductivityMeasure(!v[4] ? null : v[4].value)),
  3101149627: (v) => new IFC2X3.IfcTimeSeries(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value), v[4], v[5], !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value)),
  1718945513: (v) => {
    var _a;
    return new IFC2X3.IfcTimeSeriesReferenceRelationship(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  581633288: (v) => {
    var _a;
    return new IFC2X3.IfcTimeSeriesValue(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || []);
  },
  1377556343: (_) => new IFC2X3.IfcTopologicalRepresentationItem(),
  1735638870: (v) => {
    var _a;
    return new IFC2X3.IfcTopologyRepresentation(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  180925521: (v) => {
    var _a;
    return new IFC2X3.IfcUnitAssignment(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2799835756: (_) => new IFC2X3.IfcVertex(),
  3304826586: (v) => {
    var _a, _b;
    return new IFC2X3.IfcVertexBasedTextureMap(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], ((_b = v[1]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1907098498: (v) => new IFC2X3.IfcVertexPoint(new Handle(!v[0] ? null : v[0].value)),
  891718957: (v) => {
    var _a, _b;
    return new IFC2X3.IfcVirtualGridIntersection(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], ((_b = v[1]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLengthMeasure(p.value) : null)) || []);
  },
  1065908215: (v) => new IFC2X3.IfcWaterProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : !v[1] ? null : v[1].value, !v[2] ? null : new IFC2X3.IfcIonConcentrationMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcIonConcentrationMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcIonConcentrationMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPHMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[7] ? null : v[7].value)),
  2442683028: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationOccurrence(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  962685235: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationSurfaceOccurrence(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  3612888222: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationSymbolOccurrence(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  2297822566: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationTextOccurrence(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  3798115385: (v) => new IFC2X3.IfcArbitraryClosedProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  1310608509: (v) => new IFC2X3.IfcArbitraryOpenProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  2705031697: (v) => {
    var _a;
    return new IFC2X3.IfcArbitraryProfileDefWithVoids(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  616511568: (v) => new IFC2X3.IfcBlobTexture(!v[0] ? null : v[0].value, !v[1] ? null : v[1].value, v[2], !v[3] ? null : new Handle(!v[3] ? null : v[3].value), new IFC2X3.IfcIdentifier(!v[4] ? null : v[4].value), !v[5] ? null : v[5].value),
  3150382593: (v) => new IFC2X3.IfcCenterLineProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value)),
  647927063: (v) => new IFC2X3.IfcClassificationReference(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value)),
  776857604: (v) => new IFC2X3.IfcColourRgb(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new IFC2X3.IfcNormalisedRatioMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value)),
  2542286263: (v) => {
    var _a;
    return new IFC2X3.IfcComplexProperty(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new IFC2X3.IfcIdentifier(!v[2] ? null : v[2].value), ((_a = v[3]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1485152156: (v) => {
    var _a;
    return new IFC2X3.IfcCompositeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[3] ? null : new IFC2X3.IfcLabel(!v[3] ? null : v[3].value));
  },
  370225590: (v) => {
    var _a;
    return new IFC2X3.IfcConnectedFaceSet(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1981873012: (v) => new IFC2X3.IfcConnectionCurveGeometry(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  45288368: (v) => new IFC2X3.IfcConnectionPointEccentricity(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLengthMeasure(!v[4] ? null : v[4].value)),
  3050246964: (v) => new IFC2X3.IfcContextDependentUnit(new Handle(!v[0] ? null : v[0].value), v[1], new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  2889183280: (v) => new IFC2X3.IfcConversionBasedUnit(new Handle(!v[0] ? null : v[0].value), v[1], new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  3800577675: (v) => new IFC2X3.IfcCurveStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : TypeInitialiser(1, v[2]), !v[3] ? null : new Handle(!v[3] ? null : v[3].value)),
  3632507154: (v) => new IFC2X3.IfcDerivedProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  2273265877: (v) => new IFC2X3.IfcDimensionCalloutRelationship(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  1694125774: (v) => new IFC2X3.IfcDimensionPair(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  3732053477: (v) => new IFC2X3.IfcDocumentReference(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcIdentifier(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value)),
  4170525392: (v) => new IFC2X3.IfcDraughtingPreDefinedTextFont(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  3900360178: (v) => new IFC2X3.IfcEdge(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  476780140: (v) => new IFC2X3.IfcEdgeCurve(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : v[3].value),
  1860660968: (v) => {
    var _a;
    return new IFC2X3.IfcExtendedMaterialProperties(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcText(!v[2] ? null : v[2].value), new IFC2X3.IfcLabel(!v[3] ? null : v[3].value));
  },
  2556980723: (v) => {
    var _a;
    return new IFC2X3.IfcFace(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1809719519: (v) => new IFC2X3.IfcFaceBound(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value),
  803316827: (v) => new IFC2X3.IfcFaceOuterBound(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value),
  3008276851: (v) => {
    var _a;
    return new IFC2X3.IfcFaceSurface(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[1] ? null : v[1].value), !v[2] ? null : v[2].value);
  },
  4219587988: (v) => new IFC2X3.IfcFailureConnectionCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcForceMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcForceMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcForceMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcForceMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcForceMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcForceMeasure(!v[6] ? null : v[6].value)),
  738692330: (v) => {
    var _a;
    return new IFC2X3.IfcFillAreaStyle(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3857492461: (v) => new IFC2X3.IfcFuelProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcHeatingValueMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcHeatingValueMeasure(!v[4] ? null : v[4].value)),
  803998398: (v) => new IFC2X3.IfcGeneralMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcMolecularWeightMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcMassDensityMeasure(!v[3] ? null : v[3].value)),
  1446786286: (v) => new IFC2X3.IfcGeneralProfileProperties(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcMassPerLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcAreaMeasure(!v[6] ? null : v[6].value)),
  3448662350: (v) => new IFC2X3.IfcGeometricRepresentationContext(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new IFC2X3.IfcDimensionCount(!v[2] ? null : v[2].value), !v[3] ? null : !v[3] ? null : v[3].value, new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value)),
  2453401579: (_) => new IFC2X3.IfcGeometricRepresentationItem(),
  4142052618: (v) => new IFC2X3.IfcGeometricRepresentationSubContext(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[3] ? null : v[3].value), v[4], !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value)),
  3590301190: (v) => {
    var _a;
    return new IFC2X3.IfcGeometricSet(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  178086475: (v) => new IFC2X3.IfcGridPlacement(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  812098782: (v) => new IFC2X3.IfcHalfSpaceSolid(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value),
  2445078500: (v) => new IFC2X3.IfcHygroscopicMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcIsothermalMoistureCapacityMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcVaporPermeabilityMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcMoistureDiffusivityMeasure(!v[5] ? null : v[5].value)),
  3905492369: (v) => new IFC2X3.IfcImageTexture(!v[0] ? null : v[0].value, !v[1] ? null : v[1].value, v[2], !v[3] ? null : new Handle(!v[3] ? null : v[3].value), new IFC2X3.IfcIdentifier(!v[4] ? null : v[4].value)),
  3741457305: (v) => {
    var _a;
    return new IFC2X3.IfcIrregularTimeSeries(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value), v[4], v[5], !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), ((_a = v[8]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1402838566: (v) => new IFC2X3.IfcLightSource(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value)),
  125510826: (v) => new IFC2X3.IfcLightSourceAmbient(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value)),
  2604431987: (v) => new IFC2X3.IfcLightSourceDirectional(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value)),
  4266656042: (v) => new IFC2X3.IfcLightSourceGoniometric(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[6] ? null : v[6].value), new IFC2X3.IfcLuminousFluxMeasure(!v[7] ? null : v[7].value), v[8], new Handle(!v[9] ? null : v[9].value)),
  1520743889: (v) => new IFC2X3.IfcLightSourcePositional(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcReal(!v[6] ? null : v[6].value), new IFC2X3.IfcReal(!v[7] ? null : v[7].value), new IFC2X3.IfcReal(!v[8] ? null : v[8].value)),
  3422422726: (v) => new IFC2X3.IfcLightSourceSpot(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcReal(!v[6] ? null : v[6].value), new IFC2X3.IfcReal(!v[7] ? null : v[7].value), new IFC2X3.IfcReal(!v[8] ? null : v[8].value), new Handle(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcReal(!v[10] ? null : v[10].value), new IFC2X3.IfcPositivePlaneAngleMeasure(!v[11] ? null : v[11].value), new IFC2X3.IfcPositivePlaneAngleMeasure(!v[12] ? null : v[12].value)),
  2624227202: (v) => new IFC2X3.IfcLocalPlacement(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  1008929658: (_) => new IFC2X3.IfcLoop(),
  2347385850: (v) => new IFC2X3.IfcMappedItem(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  2022407955: (v) => {
    var _a;
    return new IFC2X3.IfcMaterialDefinitionRepresentation(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[3] ? null : v[3].value));
  },
  1430189142: (v) => new IFC2X3.IfcMechanicalConcreteMaterialProperties(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcDynamicViscosityMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcModulusOfElasticityMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcThermalExpansionCoefficientMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPressureMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcText(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcText(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcText(!v[11] ? null : v[11].value)),
  219451334: (v) => new IFC2X3.IfcObjectDefinition(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value)),
  2833995503: (v) => new IFC2X3.IfcOneDirectionRepeatFactor(new Handle(!v[0] ? null : v[0].value)),
  2665983363: (v) => {
    var _a;
    return new IFC2X3.IfcOpenShell(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1029017970: (v) => new IFC2X3.IfcOrientedEdge(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value),
  2529465313: (v) => new IFC2X3.IfcParameterizedProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  2519244187: (v) => {
    var _a;
    return new IFC2X3.IfcPath(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3021840470: (v) => {
    var _a;
    return new IFC2X3.IfcPhysicalComplexQuantity(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new IFC2X3.IfcLabel(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value));
  },
  597895409: (v) => {
    var _a;
    return new IFC2X3.IfcPixelTexture(!v[0] ? null : v[0].value, !v[1] ? null : v[1].value, v[2], !v[3] ? null : new Handle(!v[3] ? null : v[3].value), new IFC2X3.IfcInteger(!v[4] ? null : v[4].value), new IFC2X3.IfcInteger(!v[5] ? null : v[5].value), new IFC2X3.IfcInteger(!v[6] ? null : v[6].value), ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? Number(p.value) : null)) || []);
  },
  2004835150: (v) => new IFC2X3.IfcPlacement(new Handle(!v[0] ? null : v[0].value)),
  1663979128: (v) => new IFC2X3.IfcPlanarExtent(new IFC2X3.IfcLengthMeasure(!v[0] ? null : v[0].value), new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value)),
  2067069095: (_) => new IFC2X3.IfcPoint(),
  4022376103: (v) => new IFC2X3.IfcPointOnCurve(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcParameterValue(!v[1] ? null : v[1].value)),
  1423911732: (v) => new IFC2X3.IfcPointOnSurface(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcParameterValue(!v[1] ? null : v[1].value), new IFC2X3.IfcParameterValue(!v[2] ? null : v[2].value)),
  2924175390: (v) => {
    var _a;
    return new IFC2X3.IfcPolyLoop(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2775532180: (v) => new IFC2X3.IfcPolygonalBoundedHalfSpace(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value, new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  759155922: (v) => new IFC2X3.IfcPreDefinedColour(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  2559016684: (v) => new IFC2X3.IfcPreDefinedCurveFont(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  433424934: (v) => new IFC2X3.IfcPreDefinedDimensionSymbol(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  179317114: (v) => new IFC2X3.IfcPreDefinedPointMarkerSymbol(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  673634403: (v) => {
    var _a;
    return new IFC2X3.IfcProductDefinitionShape(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  871118103: (v) => new IFC2X3.IfcPropertyBoundedValue(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : TypeInitialiser(1, v[2]), !v[3] ? null : TypeInitialiser(1, v[3]), !v[4] ? null : new Handle(!v[4] ? null : v[4].value)),
  1680319473: (v) => new IFC2X3.IfcPropertyDefinition(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value)),
  4166981789: (v) => {
    var _a;
    return new IFC2X3.IfcPropertyEnumeratedValue(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || [], !v[3] ? null : new Handle(!v[3] ? null : v[3].value));
  },
  2752243245: (v) => {
    var _a;
    return new IFC2X3.IfcPropertyListValue(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || [], !v[3] ? null : new Handle(!v[3] ? null : v[3].value));
  },
  941946838: (v) => new IFC2X3.IfcPropertyReferenceValue(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value)),
  3357820518: (v) => new IFC2X3.IfcPropertySetDefinition(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value)),
  3650150729: (v) => new IFC2X3.IfcPropertySingleValue(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), !v[2] ? null : TypeInitialiser(1, v[2]), !v[3] ? null : new Handle(!v[3] ? null : v[3].value)),
  110355661: (v) => {
    var _a, _b;
    return new IFC2X3.IfcPropertyTableValue(new IFC2X3.IfcIdentifier(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || [], ((_b = v[3]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? TypeInitialiser(1, p) : null)) || [], !v[4] ? null : new IFC2X3.IfcText(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value));
  },
  3615266464: (v) => new IFC2X3.IfcRectangleProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value)),
  3413951693: (v) => {
    var _a;
    return new IFC2X3.IfcRegularTimeSeries(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcText(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value), v[4], v[5], !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), new IFC2X3.IfcTimeMeasure(!v[8] ? null : v[8].value), ((_a = v[9]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3765753017: (v) => {
    var _a;
    return new IFC2X3.IfcReinforcementDefinitionProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  478536968: (v) => new IFC2X3.IfcRelationship(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value)),
  2778083089: (v) => new IFC2X3.IfcRoundedRectangleProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value)),
  1509187699: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSectionedSpine(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], ((_b = v[2]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2411513650: (v) => new IFC2X3.IfcServiceLifeFactor(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), v[4], !v[5] ? null : TypeInitialiser(1, v[5]), TypeInitialiser(1, v[6]), !v[7] ? null : TypeInitialiser(1, v[7])),
  4124623270: (v) => {
    var _a;
    return new IFC2X3.IfcShellBasedSurfaceModel(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2609359061: (v) => new IFC2X3.IfcSlippageConnectionCondition(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value)),
  723233188: (_) => new IFC2X3.IfcSolidModel(),
  2485662743: (v) => {
    var _a;
    return new IFC2X3.IfcSoundProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new IFC2X3.IfcBoolean(!v[4] ? null : v[4].value), v[5], ((_a = v[6]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1202362311: (v) => new IFC2X3.IfcSoundValue(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), new IFC2X3.IfcFrequencyMeasure(!v[5] ? null : v[5].value), !v[6] ? null : TypeInitialiser(1, v[6])),
  390701378: (v) => new IFC2X3.IfcSpaceThermalLoadProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[4] ? null : v[4].value), v[5], v[6], !v[7] ? null : new IFC2X3.IfcText(!v[7] ? null : v[7].value), new IFC2X3.IfcPowerMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPowerMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new Handle(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcLabel(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcLabel(!v[12] ? null : v[12].value), v[13]),
  1595516126: (v) => new IFC2X3.IfcStructuralLoadLinearForce(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLinearForceMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLinearForceMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLinearForceMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLinearMomentMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcLinearMomentMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLinearMomentMeasure(!v[6] ? null : v[6].value)),
  2668620305: (v) => new IFC2X3.IfcStructuralLoadPlanarForce(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcPlanarForceMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPlanarForceMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPlanarForceMeasure(!v[3] ? null : v[3].value)),
  2473145415: (v) => new IFC2X3.IfcStructuralLoadSingleDisplacement(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[6] ? null : v[6].value)),
  1973038258: (v) => new IFC2X3.IfcStructuralLoadSingleDisplacementDistortion(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcCurvatureMeasure(!v[7] ? null : v[7].value)),
  1597423693: (v) => new IFC2X3.IfcStructuralLoadSingleForce(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcForceMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcForceMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcForceMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcTorqueMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcTorqueMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcTorqueMeasure(!v[6] ? null : v[6].value)),
  1190533807: (v) => new IFC2X3.IfcStructuralLoadSingleForceWarping(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcForceMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcForceMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcForceMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcTorqueMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcTorqueMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcTorqueMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcWarpingMomentMeasure(!v[7] ? null : v[7].value)),
  3843319758: (v) => new IFC2X3.IfcStructuralProfileProperties(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcMassPerLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcAreaMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcWarpingConstantMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcLengthMeasure(!v[12] ? null : v[12].value), !v[13] ? null : new IFC2X3.IfcLengthMeasure(!v[13] ? null : v[13].value), !v[14] ? null : new IFC2X3.IfcAreaMeasure(!v[14] ? null : v[14].value), !v[15] ? null : new IFC2X3.IfcAreaMeasure(!v[15] ? null : v[15].value), !v[16] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[16] ? null : v[16].value), !v[17] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[17] ? null : v[17].value), !v[18] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[18] ? null : v[18].value), !v[19] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[19] ? null : v[19].value), !v[20] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[20] ? null : v[20].value), !v[21] ? null : new IFC2X3.IfcLengthMeasure(!v[21] ? null : v[21].value), !v[22] ? null : new IFC2X3.IfcLengthMeasure(!v[22] ? null : v[22].value)),
  3653947884: (v) => new IFC2X3.IfcStructuralSteelProfileProperties(!v[0] ? null : new IFC2X3.IfcLabel(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcMassPerLengthMeasure(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcAreaMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcMomentOfInertiaMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcWarpingConstantMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcLengthMeasure(!v[12] ? null : v[12].value), !v[13] ? null : new IFC2X3.IfcLengthMeasure(!v[13] ? null : v[13].value), !v[14] ? null : new IFC2X3.IfcAreaMeasure(!v[14] ? null : v[14].value), !v[15] ? null : new IFC2X3.IfcAreaMeasure(!v[15] ? null : v[15].value), !v[16] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[16] ? null : v[16].value), !v[17] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[17] ? null : v[17].value), !v[18] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[18] ? null : v[18].value), !v[19] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[19] ? null : v[19].value), !v[20] ? null : new IFC2X3.IfcSectionModulusMeasure(!v[20] ? null : v[20].value), !v[21] ? null : new IFC2X3.IfcLengthMeasure(!v[21] ? null : v[21].value), !v[22] ? null : new IFC2X3.IfcLengthMeasure(!v[22] ? null : v[22].value), !v[23] ? null : new IFC2X3.IfcAreaMeasure(!v[23] ? null : v[23].value), !v[24] ? null : new IFC2X3.IfcAreaMeasure(!v[24] ? null : v[24].value), !v[25] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[25] ? null : v[25].value), !v[26] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[26] ? null : v[26].value)),
  2233826070: (v) => new IFC2X3.IfcSubedge(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  2513912981: (_) => new IFC2X3.IfcSurface(),
  1878645084: (v) => new IFC2X3.IfcSurfaceStyleRendering(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : TypeInitialiser(1, v[7]), v[8]),
  2247615214: (v) => new IFC2X3.IfcSweptAreaSolid(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  1260650574: (v) => new IFC2X3.IfcSweptDiskSolid(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value), new IFC2X3.IfcParameterValue(!v[3] ? null : v[3].value), new IFC2X3.IfcParameterValue(!v[4] ? null : v[4].value)),
  230924584: (v) => new IFC2X3.IfcSweptSurface(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  3071757647: (v) => new IFC2X3.IfcTShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[12] ? null : v[12].value)),
  3028897424: (v) => {
    var _a;
    return new IFC2X3.IfcTerminatorSymbol(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value));
  },
  4282788508: (v) => new IFC2X3.IfcTextLiteral(new IFC2X3.IfcPresentableText(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), v[2]),
  3124975700: (v) => new IFC2X3.IfcTextLiteralWithExtent(new IFC2X3.IfcPresentableText(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), v[2], new Handle(!v[3] ? null : v[3].value), new IFC2X3.IfcBoxAlignment(!v[4] ? null : v[4].value)),
  2715220739: (v) => new IFC2X3.IfcTrapeziumProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcLengthMeasure(!v[6] ? null : v[6].value)),
  1345879162: (v) => new IFC2X3.IfcTwoDirectionRepeatFactor(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  1628702193: (v) => {
    var _a;
    return new IFC2X3.IfcTypeObject(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2347495698: (v) => {
    var _a, _b;
    return new IFC2X3.IfcTypeProduct(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value));
  },
  427810014: (v) => new IFC2X3.IfcUShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value)),
  1417489154: (v) => new IFC2X3.IfcVector(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value)),
  2759199220: (v) => new IFC2X3.IfcVertexLoop(new Handle(!v[0] ? null : v[0].value)),
  336235671: (v) => new IFC2X3.IfcWindowLiningProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new Handle(!v[12] ? null : v[12].value)),
  512836454: (v) => new IFC2X3.IfcWindowPanelProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), v[4], v[5], !v[6] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  1299126871: (v) => {
    var _a, _b;
    return new IFC2X3.IfcWindowStyle(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8], v[9], !v[10] ? null : v[10].value, !v[11] ? null : v[11].value);
  },
  2543172580: (v) => new IFC2X3.IfcZShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value)),
  3288037868: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationCurveOccurrence(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  669184980: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationFillArea(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2265737646: (v) => {
    var _a;
    return new IFC2X3.IfcAnnotationFillAreaOccurrence(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), v[4]);
  },
  1302238472: (v) => new IFC2X3.IfcAnnotationSurface(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  4261334040: (v) => new IFC2X3.IfcAxis1Placement(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  3125803723: (v) => new IFC2X3.IfcAxis2Placement2D(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value)),
  2740243338: (v) => new IFC2X3.IfcAxis2Placement3D(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value)),
  2736907675: (v) => new IFC2X3.IfcBooleanResult(v[0], new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  4182860854: (_) => new IFC2X3.IfcBoundedSurface(),
  2581212453: (v) => new IFC2X3.IfcBoundingBox(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value)),
  2713105998: (v) => new IFC2X3.IfcBoxedHalfSpace(new Handle(!v[0] ? null : v[0].value), !v[1] ? null : v[1].value, new Handle(!v[2] ? null : v[2].value)),
  2898889636: (v) => new IFC2X3.IfcCShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value)),
  1123145078: (v) => {
    var _a;
    return new IFC2X3.IfcCartesianPoint(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcLengthMeasure(p.value) : null)) || []);
  },
  59481748: (v) => new IFC2X3.IfcCartesianTransformationOperator(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : !v[3] ? null : v[3].value),
  3749851601: (v) => new IFC2X3.IfcCartesianTransformationOperator2D(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : !v[3] ? null : v[3].value),
  3486308946: (v) => new IFC2X3.IfcCartesianTransformationOperator2DnonUniform(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : !v[3] ? null : v[3].value, !v[4] ? null : !v[4] ? null : v[4].value),
  3331915920: (v) => new IFC2X3.IfcCartesianTransformationOperator3D(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : !v[3] ? null : v[3].value, !v[4] ? null : new Handle(!v[4] ? null : v[4].value)),
  1416205885: (v) => new IFC2X3.IfcCartesianTransformationOperator3DnonUniform(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), !v[1] ? null : new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), !v[3] ? null : !v[3] ? null : v[3].value, !v[4] ? null : new Handle(!v[4] ? null : v[4].value), !v[5] ? null : !v[5] ? null : v[5].value, !v[6] ? null : !v[6] ? null : v[6].value),
  1383045692: (v) => new IFC2X3.IfcCircleProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value)),
  2205249479: (v) => {
    var _a;
    return new IFC2X3.IfcClosedShell(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2485617015: (v) => new IFC2X3.IfcCompositeCurveSegment(v[0], !v[1] ? null : v[1].value, new Handle(!v[2] ? null : v[2].value)),
  4133800736: (v) => new IFC2X3.IfcCraneRailAShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value), new IFC2X3.IfcPositiveLengthMeasure(!v[11] ? null : v[11].value), new IFC2X3.IfcPositiveLengthMeasure(!v[12] ? null : v[12].value), new IFC2X3.IfcPositiveLengthMeasure(!v[13] ? null : v[13].value), !v[14] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[14] ? null : v[14].value)),
  194851669: (v) => new IFC2X3.IfcCraneRailFShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[11] ? null : v[11].value)),
  2506170314: (v) => new IFC2X3.IfcCsgPrimitive3D(new Handle(!v[0] ? null : v[0].value)),
  2147822146: (v) => new IFC2X3.IfcCsgSolid(new Handle(!v[0] ? null : v[0].value)),
  2601014836: (_) => new IFC2X3.IfcCurve(),
  2827736869: (v) => {
    var _a;
    return new IFC2X3.IfcCurveBoundedPlane(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : ((_a = v[2]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  693772133: (v) => new IFC2X3.IfcDefinedSymbol(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  606661476: (v) => {
    var _a;
    return new IFC2X3.IfcDimensionCurve(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  4054601972: (v) => {
    var _a;
    return new IFC2X3.IfcDimensionCurveTerminator(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), new Handle(!v[3] ? null : v[3].value), v[4]);
  },
  32440307: (v) => {
    var _a;
    return new IFC2X3.IfcDirection(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? Number(p.value) : null)) || []);
  },
  2963535650: (v) => new IFC2X3.IfcDoorLiningProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcLengthMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcLengthMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[12] ? null : v[12].value), !v[13] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[13] ? null : v[13].value), !v[14] ? null : new Handle(!v[14] ? null : v[14].value)),
  1714330368: (v) => new IFC2X3.IfcDoorPanelProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), v[5], !v[6] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  526551008: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDoorStyle(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8], v[9], !v[10] ? null : v[10].value, !v[11] ? null : v[11].value);
  },
  3073041342: (v) => {
    var _a;
    return new IFC2X3.IfcDraughtingCallout(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  445594917: (v) => new IFC2X3.IfcDraughtingPreDefinedColour(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  4006246654: (v) => new IFC2X3.IfcDraughtingPreDefinedCurveFont(new IFC2X3.IfcLabel(!v[0] ? null : v[0].value)),
  1472233963: (v) => {
    var _a;
    return new IFC2X3.IfcEdgeLoop(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1883228015: (v) => {
    var _a;
    return new IFC2X3.IfcElementQuantity(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  339256511: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  2777663545: (v) => new IFC2X3.IfcElementarySurface(new Handle(!v[0] ? null : v[0].value)),
  2835456948: (v) => new IFC2X3.IfcEllipseProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value)),
  80994333: (v) => new IFC2X3.IfcEnergyProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), v[4], !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value)),
  477187591: (v) => new IFC2X3.IfcExtrudedAreaSolid(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value)),
  2047409740: (v) => {
    var _a;
    return new IFC2X3.IfcFaceBasedSurfaceModel(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  374418227: (v) => new IFC2X3.IfcFillAreaStyleHatching(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new Handle(!v[2] ? null : v[2].value), !v[3] ? null : new Handle(!v[3] ? null : v[3].value), new IFC2X3.IfcPlaneAngleMeasure(!v[4] ? null : v[4].value)),
  4203026998: (v) => new IFC2X3.IfcFillAreaStyleTileSymbolWithStyle(new Handle(!v[0] ? null : v[0].value)),
  315944413: (v) => {
    var _a;
    return new IFC2X3.IfcFillAreaStyleTiles(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new IFC2X3.IfcPositiveRatioMeasure(!v[2] ? null : v[2].value));
  },
  3455213021: (v) => new IFC2X3.IfcFluidFlowProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), v[4], !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), new Handle(!v[8] ? null : v[8].value), !v[9] ? null : new Handle(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcLabel(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcThermodynamicTemperatureMeasure(!v[12] ? null : v[12].value), !v[13] ? null : new Handle(!v[13] ? null : v[13].value), !v[14] ? null : new Handle(!v[14] ? null : v[14].value), !v[15] ? null : TypeInitialiser(1, v[15]), !v[16] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[16] ? null : v[16].value), !v[17] ? null : new IFC2X3.IfcLinearVelocityMeasure(!v[17] ? null : v[17].value), !v[18] ? null : new IFC2X3.IfcPressureMeasure(!v[18] ? null : v[18].value)),
  4238390223: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFurnishingElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1268542332: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFurnitureType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  987898635: (v) => {
    var _a;
    return new IFC2X3.IfcGeometricCurveSet(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1484403080: (v) => new IFC2X3.IfcIShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value)),
  572779678: (v) => new IFC2X3.IfcLShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPlaneAngleMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value)),
  1281925730: (v) => new IFC2X3.IfcLine(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value)),
  1425443689: (v) => new IFC2X3.IfcManifoldSolidBrep(new Handle(!v[0] ? null : v[0].value)),
  3888040117: (v) => new IFC2X3.IfcObject(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  3388369263: (v) => new IFC2X3.IfcOffsetCurve2D(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : v[2].value),
  3505215534: (v) => new IFC2X3.IfcOffsetCurve3D(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), !v[2] ? null : v[2].value, new Handle(!v[3] ? null : v[3].value)),
  3566463478: (v) => new IFC2X3.IfcPermeableCoveringProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), v[4], v[5], !v[6] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  603570806: (v) => new IFC2X3.IfcPlanarBox(new IFC2X3.IfcLengthMeasure(!v[0] ? null : v[0].value), new IFC2X3.IfcLengthMeasure(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  220341763: (v) => new IFC2X3.IfcPlane(new Handle(!v[0] ? null : v[0].value)),
  2945172077: (v) => new IFC2X3.IfcProcess(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  4208778838: (v) => new IFC2X3.IfcProduct(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value)),
  103090709: (v) => {
    var _a;
    return new IFC2X3.IfcProject(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[8] ? null : v[8].value));
  },
  4194566429: (v) => {
    var _a;
    return new IFC2X3.IfcProjectionCurve(!v[0] ? null : new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value));
  },
  1451395588: (v) => {
    var _a;
    return new IFC2X3.IfcPropertySet(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3219374653: (v) => new IFC2X3.IfcProxy(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value)),
  2770003689: (v) => new IFC2X3.IfcRectangleHollowProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value)),
  2798486643: (v) => new IFC2X3.IfcRectangularPyramid(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value)),
  3454111270: (v) => new IFC2X3.IfcRectangularTrimmedSurface(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcParameterValue(!v[1] ? null : v[1].value), new IFC2X3.IfcParameterValue(!v[2] ? null : v[2].value), new IFC2X3.IfcParameterValue(!v[3] ? null : v[3].value), new IFC2X3.IfcParameterValue(!v[4] ? null : v[4].value), !v[5] ? null : v[5].value, !v[6] ? null : v[6].value),
  3939117080: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssigns(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5]);
  },
  1683148259: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToActor(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value));
  },
  2495723537: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToControl(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value));
  },
  1307041759: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToGroup(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value));
  },
  4278684876: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToProcess(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value));
  },
  2857406711: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToProduct(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value));
  },
  3372526763: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToProjectOrder(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value));
  },
  205026976: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsToResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value));
  },
  1865459582: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociates(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1327628568: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesAppliedValue(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  4095574036: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesApproval(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  919958153: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesClassification(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  2728634034: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesConstraint(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new IFC2X3.IfcLabel(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value));
  },
  982818633: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesDocument(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  3840914261: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesLibrary(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  2655215786: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesMaterial(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  2851387026: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssociatesProfileProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value));
  },
  826625072: (v) => new IFC2X3.IfcRelConnects(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value)),
  1204542856: (v) => new IFC2X3.IfcRelConnectsElements(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value)),
  3945020480: (v) => {
    var _a, _b;
    return new IFC2X3.IfcRelConnectsPathElements(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value), !v[7] ? null : ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? Number(p.value) : null)) || [], !v[8] ? null : ((_b = v[8]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? Number(p.value) : null)) || [], v[9], v[10]);
  },
  4201705270: (v) => new IFC2X3.IfcRelConnectsPortToElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  3190031847: (v) => new IFC2X3.IfcRelConnectsPorts(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value)),
  2127690289: (v) => new IFC2X3.IfcRelConnectsStructuralActivity(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  3912681535: (v) => new IFC2X3.IfcRelConnectsStructuralElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  1638771189: (v) => new IFC2X3.IfcRelConnectsStructuralMember(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new Handle(!v[9] ? null : v[9].value)),
  504942748: (v) => new IFC2X3.IfcRelConnectsWithEccentricity(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new Handle(!v[9] ? null : v[9].value), new Handle(!v[10] ? null : v[10].value)),
  3678494232: (v) => {
    var _a;
    return new IFC2X3.IfcRelConnectsWithRealizingElements(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value), ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3242617779: (v) => {
    var _a;
    return new IFC2X3.IfcRelContainedInSpatialStructure(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  886880790: (v) => {
    var _a;
    return new IFC2X3.IfcRelCoversBldgElements(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2802773753: (v) => {
    var _a;
    return new IFC2X3.IfcRelCoversSpaces(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2551354335: (v) => {
    var _a;
    return new IFC2X3.IfcRelDecomposes(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  693640335: (v) => {
    var _a;
    return new IFC2X3.IfcRelDefines(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  4186316022: (v) => {
    var _a;
    return new IFC2X3.IfcRelDefinesByProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  781010003: (v) => {
    var _a;
    return new IFC2X3.IfcRelDefinesByType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  3940055652: (v) => new IFC2X3.IfcRelFillsElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  279856033: (v) => {
    var _a;
    return new IFC2X3.IfcRelFlowControlElements(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  4189434867: (v) => new IFC2X3.IfcRelInteractionRequirements(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcCountMeasure(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), new Handle(!v[8] ? null : v[8].value)),
  3268803585: (v) => {
    var _a;
    return new IFC2X3.IfcRelNests(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2051452291: (v) => {
    var _a;
    return new IFC2X3.IfcRelOccupiesSpaces(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value));
  },
  202636808: (v) => {
    var _a, _b;
    return new IFC2X3.IfcRelOverridesProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value), ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  750771296: (v) => new IFC2X3.IfcRelProjectsElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  1245217292: (v) => {
    var _a;
    return new IFC2X3.IfcRelReferencedInSpatialStructure(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[5] ? null : v[5].value));
  },
  1058617721: (v) => {
    var _a;
    return new IFC2X3.IfcRelSchedulesCostItems(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value));
  },
  4122056220: (v) => new IFC2X3.IfcRelSequence(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), new IFC2X3.IfcTimeMeasure(!v[6] ? null : v[6].value), v[7]),
  366585022: (v) => {
    var _a;
    return new IFC2X3.IfcRelServicesBuildings(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3451746338: (v) => new IFC2X3.IfcRelSpaceBoundary(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7], v[8]),
  1401173127: (v) => new IFC2X3.IfcRelVoidsElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  2914609552: (v) => new IFC2X3.IfcResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  1856042241: (v) => new IFC2X3.IfcRevolvedAreaSolid(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPlaneAngleMeasure(!v[3] ? null : v[3].value)),
  4158566097: (v) => new IFC2X3.IfcRightCircularCone(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value)),
  3626867408: (v) => new IFC2X3.IfcRightCircularCylinder(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value)),
  2706606064: (v) => new IFC2X3.IfcSpatialStructureElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8]),
  3893378262: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSpatialStructureElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  451544542: (v) => new IFC2X3.IfcSphere(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value)),
  3544373492: (v) => new IFC2X3.IfcStructuralActivity(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8]),
  3136571912: (v) => new IFC2X3.IfcStructuralItem(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value)),
  530289379: (v) => new IFC2X3.IfcStructuralMember(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value)),
  3689010777: (v) => new IFC2X3.IfcStructuralReaction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8]),
  3979015343: (v) => new IFC2X3.IfcStructuralSurfaceMember(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value)),
  2218152070: (v) => {
    var _a;
    return new IFC2X3.IfcStructuralSurfaceMemberVarying(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), ((_a = v[9]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcPositiveLengthMeasure(p.value) : null)) || [], new Handle(!v[10] ? null : v[10].value));
  },
  4070609034: (v) => {
    var _a;
    return new IFC2X3.IfcStructuredDimensionCallout(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2028607225: (v) => new IFC2X3.IfcSurfaceCurveSweptAreaSolid(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcParameterValue(!v[3] ? null : v[3].value), new IFC2X3.IfcParameterValue(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  2809605785: (v) => new IFC2X3.IfcSurfaceOfLinearExtrusion(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcLengthMeasure(!v[3] ? null : v[3].value)),
  4124788165: (v) => new IFC2X3.IfcSurfaceOfRevolution(new Handle(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  1580310250: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSystemFurnitureElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3473067441: (v) => new IFC2X3.IfcTask(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : v[8].value, !v[9] ? null : !v[9] ? null : v[9].value),
  2097647324: (v) => {
    var _a, _b;
    return new IFC2X3.IfcTransportElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2296667514: (v) => new IFC2X3.IfcActor(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value)),
  1674181508: (v) => new IFC2X3.IfcAnnotation(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value)),
  3207858831: (v) => new IFC2X3.IfcAsymmetricIShapeProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value), new IFC2X3.IfcPositiveLengthMeasure(!v[5] ? null : v[5].value), new IFC2X3.IfcPositiveLengthMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[7] ? null : v[7].value), new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[11] ? null : v[11].value)),
  1334484129: (v) => new IFC2X3.IfcBlock(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value)),
  3649129432: (v) => new IFC2X3.IfcBooleanClippingResult(v[0], new Handle(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value)),
  1260505505: (_) => new IFC2X3.IfcBoundedCurve(),
  4031249490: (v) => new IFC2X3.IfcBuilding(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8], !v[9] ? null : new IFC2X3.IfcLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcLengthMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new Handle(!v[11] ? null : v[11].value)),
  1950629157: (v) => {
    var _a, _b;
    return new IFC2X3.IfcBuildingElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3124254112: (v) => new IFC2X3.IfcBuildingStorey(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8], !v[9] ? null : new IFC2X3.IfcLengthMeasure(!v[9] ? null : v[9].value)),
  2937912522: (v) => new IFC2X3.IfcCircleHollowProfileDef(v[0], !v[1] ? null : new IFC2X3.IfcLabel(!v[1] ? null : v[1].value), new Handle(!v[2] ? null : v[2].value), new IFC2X3.IfcPositiveLengthMeasure(!v[3] ? null : v[3].value), new IFC2X3.IfcPositiveLengthMeasure(!v[4] ? null : v[4].value)),
  300633059: (v) => {
    var _a, _b;
    return new IFC2X3.IfcColumnType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3732776249: (v) => {
    var _a;
    return new IFC2X3.IfcCompositeCurve(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[1] ? null : v[1].value);
  },
  2510884976: (v) => new IFC2X3.IfcConic(new Handle(!v[0] ? null : v[0].value)),
  2559216714: (v) => new IFC2X3.IfcConstructionResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  3293443760: (v) => new IFC2X3.IfcControl(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  3895139033: (v) => new IFC2X3.IfcCostItem(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  1419761937: (v) => {
    var _a;
    return new IFC2X3.IfcCostSchedule(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), !v[9] ? null : ((_a = v[9]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[10] ? null : new Handle(!v[10] ? null : v[10].value), new IFC2X3.IfcIdentifier(!v[11] ? null : v[11].value), v[12]);
  },
  1916426348: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCoveringType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3295246426: (v) => new IFC2X3.IfcCrewResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  1457835157: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCurtainWallType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  681481545: (v) => {
    var _a;
    return new IFC2X3.IfcDimensionCurveDirectedCallout(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3256556792: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDistributionElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3849074793: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDistributionFlowElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  360485395: (v) => new IFC2X3.IfcElectricalBaseProperties(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), v[4], !v[5] ? null : new IFC2X3.IfcLabel(!v[5] ? null : v[5].value), v[6], new IFC2X3.IfcElectricVoltageMeasure(!v[7] ? null : v[7].value), new IFC2X3.IfcFrequencyMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcElectricCurrentMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcElectricCurrentMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPowerMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcPowerMeasure(!v[12] ? null : v[12].value), !v[13] ? null : v[13].value),
  1758889154: (v) => new IFC2X3.IfcElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  4123344466: (v) => new IFC2X3.IfcElementAssembly(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8], v[9]),
  1623761950: (v) => new IFC2X3.IfcElementComponent(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2590856083: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElementComponentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1704287377: (v) => new IFC2X3.IfcEllipse(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value), new IFC2X3.IfcPositiveLengthMeasure(!v[2] ? null : v[2].value)),
  2107101300: (v) => {
    var _a, _b;
    return new IFC2X3.IfcEnergyConversionDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1962604670: (v) => new IFC2X3.IfcEquipmentElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3272907226: (v) => new IFC2X3.IfcEquipmentStandard(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  3174744832: (v) => {
    var _a, _b;
    return new IFC2X3.IfcEvaporativeCoolerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3390157468: (v) => {
    var _a, _b;
    return new IFC2X3.IfcEvaporatorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  807026263: (v) => new IFC2X3.IfcFacetedBrep(new Handle(!v[0] ? null : v[0].value)),
  3737207727: (v) => {
    var _a;
    return new IFC2X3.IfcFacetedBrepWithVoids(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  647756555: (v) => new IFC2X3.IfcFastener(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2489546625: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFastenerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  2827207264: (v) => new IFC2X3.IfcFeatureElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2143335405: (v) => new IFC2X3.IfcFeatureElementAddition(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1287392070: (v) => new IFC2X3.IfcFeatureElementSubtraction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3907093117: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowControllerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3198132628: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowFittingType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3815607619: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowMeterType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1482959167: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowMovingDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1834744321: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowSegmentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1339347760: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowStorageDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  2297155007: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3009222698: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowTreatmentDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  263784265: (v) => new IFC2X3.IfcFurnishingElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  814719939: (v) => new IFC2X3.IfcFurnitureStandard(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  200128114: (v) => {
    var _a, _b;
    return new IFC2X3.IfcGasTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3009204131: (v) => {
    var _a, _b, _c;
    return new IFC2X3.IfcGrid(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], ((_b = v[8]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[9] ? null : ((_c = v[9]) == null ? void 0 : _c.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2706460486: (v) => new IFC2X3.IfcGroup(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  1251058090: (v) => {
    var _a, _b;
    return new IFC2X3.IfcHeatExchangerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1806887404: (v) => {
    var _a, _b;
    return new IFC2X3.IfcHumidifierType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2391368822: (v) => {
    var _a;
    return new IFC2X3.IfcInventory(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), v[5], new Handle(!v[6] ? null : v[6].value), ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], new Handle(!v[8] ? null : v[8].value), !v[9] ? null : new Handle(!v[9] ? null : v[9].value), !v[10] ? null : new Handle(!v[10] ? null : v[10].value));
  },
  4288270099: (v) => {
    var _a, _b;
    return new IFC2X3.IfcJunctionBoxType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3827777499: (v) => new IFC2X3.IfcLaborResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcText(!v[9] ? null : v[9].value)),
  1051575348: (v) => {
    var _a, _b;
    return new IFC2X3.IfcLampType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1161773419: (v) => {
    var _a, _b;
    return new IFC2X3.IfcLightFixtureType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2506943328: (v) => {
    var _a;
    return new IFC2X3.IfcLinearDimension(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  377706215: (v) => new IFC2X3.IfcMechanicalFastener(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value)),
  2108223431: (v) => {
    var _a, _b;
    return new IFC2X3.IfcMechanicalFastenerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  3181161470: (v) => {
    var _a, _b;
    return new IFC2X3.IfcMemberType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  977012517: (v) => {
    var _a, _b;
    return new IFC2X3.IfcMotorConnectionType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1916936684: (v) => {
    var _a;
    return new IFC2X3.IfcMove(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : v[8].value, !v[9] ? null : !v[9] ? null : v[9].value, new Handle(!v[10] ? null : v[10].value), new Handle(!v[11] ? null : v[11].value), !v[12] ? null : ((_a = v[12]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new IFC2X3.IfcText(p.value) : null)) || []);
  },
  4143007308: (v) => new IFC2X3.IfcOccupant(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), v[6]),
  3588315303: (v) => new IFC2X3.IfcOpeningElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3425660407: (v) => new IFC2X3.IfcOrderAction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : v[8].value, !v[9] ? null : !v[9] ? null : v[9].value, new IFC2X3.IfcIdentifier(!v[10] ? null : v[10].value)),
  2837617999: (v) => {
    var _a, _b;
    return new IFC2X3.IfcOutletType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2382730787: (v) => new IFC2X3.IfcPerformanceHistory(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcLabel(!v[5] ? null : v[5].value)),
  3327091369: (v) => new IFC2X3.IfcPermit(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value)),
  804291784: (v) => {
    var _a, _b;
    return new IFC2X3.IfcPipeFittingType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  4231323485: (v) => {
    var _a, _b;
    return new IFC2X3.IfcPipeSegmentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  4017108033: (v) => {
    var _a, _b;
    return new IFC2X3.IfcPlateType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3724593414: (v) => {
    var _a;
    return new IFC2X3.IfcPolyline(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3740093272: (v) => new IFC2X3.IfcPort(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value)),
  2744685151: (v) => new IFC2X3.IfcProcedure(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), v[6], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value)),
  2904328755: (v) => new IFC2X3.IfcProjectOrder(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), v[6], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value)),
  3642467123: (v) => {
    var _a;
    return new IFC2X3.IfcProjectOrderRecord(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[6]);
  },
  3651124850: (v) => new IFC2X3.IfcProjectionElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1842657554: (v) => {
    var _a, _b;
    return new IFC2X3.IfcProtectiveDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2250791053: (v) => {
    var _a, _b;
    return new IFC2X3.IfcPumpType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3248260540: (v) => {
    var _a;
    return new IFC2X3.IfcRadiusDimension(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2893384427: (v) => {
    var _a, _b;
    return new IFC2X3.IfcRailingType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2324767716: (v) => {
    var _a, _b;
    return new IFC2X3.IfcRampFlightType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  160246688: (v) => {
    var _a;
    return new IFC2X3.IfcRelAggregates(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), new Handle(!v[4] ? null : v[4].value), ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2863920197: (v) => {
    var _a;
    return new IFC2X3.IfcRelAssignsTasks(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), ((_a = v[4]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[5], new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value));
  },
  1768891740: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSanitaryTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3517283431: (v) => new IFC2X3.IfcScheduleTimeControl(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value), !v[8] ? null : new Handle(!v[8] ? null : v[8].value), !v[9] ? null : new Handle(!v[9] ? null : v[9].value), !v[10] ? null : new Handle(!v[10] ? null : v[10].value), !v[11] ? null : new Handle(!v[11] ? null : v[11].value), !v[12] ? null : new Handle(!v[12] ? null : v[12].value), !v[13] ? null : new IFC2X3.IfcTimeMeasure(!v[13] ? null : v[13].value), !v[14] ? null : new IFC2X3.IfcTimeMeasure(!v[14] ? null : v[14].value), !v[15] ? null : new IFC2X3.IfcTimeMeasure(!v[15] ? null : v[15].value), !v[16] ? null : new IFC2X3.IfcTimeMeasure(!v[16] ? null : v[16].value), !v[17] ? null : new IFC2X3.IfcTimeMeasure(!v[17] ? null : v[17].value), !v[18] ? null : !v[18] ? null : v[18].value, !v[19] ? null : new Handle(!v[19] ? null : v[19].value), !v[20] ? null : new IFC2X3.IfcTimeMeasure(!v[20] ? null : v[20].value), !v[21] ? null : new IFC2X3.IfcTimeMeasure(!v[21] ? null : v[21].value), !v[22] ? null : new IFC2X3.IfcPositiveRatioMeasure(!v[22] ? null : v[22].value)),
  4105383287: (v) => new IFC2X3.IfcServiceLife(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), v[5], new IFC2X3.IfcTimeMeasure(!v[6] ? null : v[6].value)),
  4097777520: (v) => new IFC2X3.IfcSite(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8], !v[9] ? null : new IFC2X3.IfcCompoundPlaneAngleMeasure(v[9].map((x) => x.value)), !v[10] ? null : new IFC2X3.IfcCompoundPlaneAngleMeasure(v[10].map((x) => x.value)), !v[11] ? null : new IFC2X3.IfcLengthMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcLabel(!v[12] ? null : v[12].value), !v[13] ? null : new Handle(!v[13] ? null : v[13].value)),
  2533589738: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSlabType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3856911033: (v) => new IFC2X3.IfcSpace(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), v[8], v[9], !v[10] ? null : new IFC2X3.IfcLengthMeasure(!v[10] ? null : v[10].value)),
  1305183839: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSpaceHeaterType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  652456506: (v) => new IFC2X3.IfcSpaceProgram(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcAreaMeasure(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcAreaMeasure(!v[7] ? null : v[7].value), !v[8] ? null : new Handle(!v[8] ? null : v[8].value), new IFC2X3.IfcAreaMeasure(!v[9] ? null : v[9].value)),
  3812236995: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSpaceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3112655638: (v) => {
    var _a, _b;
    return new IFC2X3.IfcStackTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1039846685: (v) => {
    var _a, _b;
    return new IFC2X3.IfcStairFlightType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  682877961: (v) => new IFC2X3.IfcStructuralAction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8], !v[9] ? null : v[9].value, !v[10] ? null : new Handle(!v[10] ? null : v[10].value)),
  1179482911: (v) => new IFC2X3.IfcStructuralConnection(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value)),
  4243806635: (v) => new IFC2X3.IfcStructuralCurveConnection(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value)),
  214636428: (v) => new IFC2X3.IfcStructuralCurveMember(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7]),
  2445595289: (v) => new IFC2X3.IfcStructuralCurveMemberVarying(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7]),
  1807405624: (v) => new IFC2X3.IfcStructuralLinearAction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8], !v[9] ? null : v[9].value, !v[10] ? null : new Handle(!v[10] ? null : v[10].value), v[11]),
  1721250024: (v) => {
    var _a;
    return new IFC2X3.IfcStructuralLinearActionVarying(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8], !v[9] ? null : v[9].value, !v[10] ? null : new Handle(!v[10] ? null : v[10].value), v[11], new Handle(!v[12] ? null : v[12].value), ((_a = v[13]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1252848954: (v) => new IFC2X3.IfcStructuralLoadGroup(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), v[5], v[6], v[7], !v[8] ? null : new IFC2X3.IfcRatioMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcLabel(!v[9] ? null : v[9].value)),
  1621171031: (v) => new IFC2X3.IfcStructuralPlanarAction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8], !v[9] ? null : v[9].value, !v[10] ? null : new Handle(!v[10] ? null : v[10].value), v[11]),
  3987759626: (v) => {
    var _a;
    return new IFC2X3.IfcStructuralPlanarActionVarying(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8], !v[9] ? null : v[9].value, !v[10] ? null : new Handle(!v[10] ? null : v[10].value), v[11], new Handle(!v[12] ? null : v[12].value), ((_a = v[13]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  2082059205: (v) => new IFC2X3.IfcStructuralPointAction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8], !v[9] ? null : v[9].value, !v[10] ? null : new Handle(!v[10] ? null : v[10].value)),
  734778138: (v) => new IFC2X3.IfcStructuralPointConnection(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value)),
  1235345126: (v) => new IFC2X3.IfcStructuralPointReaction(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), v[8]),
  2986769608: (v) => new IFC2X3.IfcStructuralResultGroup(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), v[5], !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : v[7].value),
  1975003073: (v) => new IFC2X3.IfcStructuralSurfaceConnection(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new Handle(!v[7] ? null : v[7].value)),
  148013059: (v) => new IFC2X3.IfcSubContractResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value), !v[9] ? null : new Handle(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcText(!v[10] ? null : v[10].value)),
  2315554128: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSwitchingDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2254336722: (v) => new IFC2X3.IfcSystem(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  5716631: (v) => {
    var _a, _b;
    return new IFC2X3.IfcTankType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1637806684: (v) => {
    var _a;
    return new IFC2X3.IfcTimeSeriesSchedule(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[6], new Handle(!v[7] ? null : v[7].value));
  },
  1692211062: (v) => {
    var _a, _b;
    return new IFC2X3.IfcTransformerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1620046519: (v) => new IFC2X3.IfcTransportElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8], !v[9] ? null : new IFC2X3.IfcMassMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcCountMeasure(!v[10] ? null : v[10].value)),
  3593883385: (v) => {
    var _a, _b;
    return new IFC2X3.IfcTrimmedCurve(new Handle(!v[0] ? null : v[0].value), ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], ((_b = v[2]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[3] ? null : v[3].value, v[4]);
  },
  1600972822: (v) => {
    var _a, _b;
    return new IFC2X3.IfcTubeBundleType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1911125066: (v) => {
    var _a, _b;
    return new IFC2X3.IfcUnitaryEquipmentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  728799441: (v) => {
    var _a, _b;
    return new IFC2X3.IfcValveType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2769231204: (v) => new IFC2X3.IfcVirtualElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1898987631: (v) => {
    var _a, _b;
    return new IFC2X3.IfcWallType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1133259667: (v) => {
    var _a, _b;
    return new IFC2X3.IfcWasteTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1028945134: (v) => {
    var _a;
    return new IFC2X3.IfcWorkControl(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value), !v[7] ? null : ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcTimeMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcTimeMeasure(!v[10] ? null : v[10].value), new Handle(!v[11] ? null : v[11].value), !v[12] ? null : new Handle(!v[12] ? null : v[12].value), v[13], !v[14] ? null : new IFC2X3.IfcLabel(!v[14] ? null : v[14].value));
  },
  4218914973: (v) => {
    var _a;
    return new IFC2X3.IfcWorkPlan(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value), !v[7] ? null : ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcTimeMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcTimeMeasure(!v[10] ? null : v[10].value), new Handle(!v[11] ? null : v[11].value), !v[12] ? null : new Handle(!v[12] ? null : v[12].value), v[13], !v[14] ? null : new IFC2X3.IfcLabel(!v[14] ? null : v[14].value));
  },
  3342526732: (v) => {
    var _a;
    return new IFC2X3.IfcWorkSchedule(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value), !v[7] ? null : ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcTimeMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcTimeMeasure(!v[10] ? null : v[10].value), new Handle(!v[11] ? null : v[11].value), !v[12] ? null : new Handle(!v[12] ? null : v[12].value), v[13], !v[14] ? null : new IFC2X3.IfcLabel(!v[14] ? null : v[14].value));
  },
  1033361043: (v) => new IFC2X3.IfcZone(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  1213861670: (v) => {
    var _a;
    return new IFC2X3.Ifc2DCompositeCurve(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[1] ? null : v[1].value);
  },
  3821786052: (v) => new IFC2X3.IfcActionRequest(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value)),
  1411407467: (v) => {
    var _a, _b;
    return new IFC2X3.IfcAirTerminalBoxType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3352864051: (v) => {
    var _a, _b;
    return new IFC2X3.IfcAirTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1871374353: (v) => {
    var _a, _b;
    return new IFC2X3.IfcAirToAirHeatRecoveryType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2470393545: (v) => {
    var _a;
    return new IFC2X3.IfcAngularDimension(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3460190687: (v) => new IFC2X3.IfcAsset(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value), new Handle(!v[7] ? null : v[7].value), new Handle(!v[8] ? null : v[8].value), new Handle(!v[9] ? null : v[9].value), new Handle(!v[10] ? null : v[10].value), new Handle(!v[11] ? null : v[11].value), new Handle(!v[12] ? null : v[12].value), new Handle(!v[13] ? null : v[13].value)),
  1967976161: (v) => {
    var _a;
    return new IFC2X3.IfcBSplineCurve(!v[0] ? null : v[0].value, ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[2], !v[3] ? null : v[3].value, !v[4] ? null : v[4].value);
  },
  819618141: (v) => {
    var _a, _b;
    return new IFC2X3.IfcBeamType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1916977116: (v) => {
    var _a;
    return new IFC2X3.IfcBezierCurve(!v[0] ? null : v[0].value, ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[2], !v[3] ? null : v[3].value, !v[4] ? null : v[4].value);
  },
  231477066: (v) => {
    var _a, _b;
    return new IFC2X3.IfcBoilerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3299480353: (v) => new IFC2X3.IfcBuildingElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  52481810: (v) => new IFC2X3.IfcBuildingElementComponent(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2979338954: (v) => new IFC2X3.IfcBuildingElementPart(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1095909175: (v) => new IFC2X3.IfcBuildingElementProxy(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  1909888760: (v) => {
    var _a, _b;
    return new IFC2X3.IfcBuildingElementProxyType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  395041908: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCableCarrierFittingType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3293546465: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCableCarrierSegmentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1285652485: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCableSegmentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2951183804: (v) => {
    var _a, _b;
    return new IFC2X3.IfcChillerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2611217952: (v) => new IFC2X3.IfcCircle(new Handle(!v[0] ? null : v[0].value), new IFC2X3.IfcPositiveLengthMeasure(!v[1] ? null : v[1].value)),
  2301859152: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCoilType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  843113511: (v) => new IFC2X3.IfcColumn(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3850581409: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCompressorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2816379211: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCondenserType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2188551683: (v) => new IFC2X3.IfcCondition(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  1163958913: (v) => new IFC2X3.IfcConditionCriterion(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), new Handle(!v[5] ? null : v[5].value), new Handle(!v[6] ? null : v[6].value)),
  3898045240: (v) => new IFC2X3.IfcConstructionEquipmentResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  1060000209: (v) => {
    var _a;
    return new IFC2X3.IfcConstructionMaterialResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value), !v[9] ? null : ((_a = v[9]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[10] ? null : new IFC2X3.IfcRatioMeasure(!v[10] ? null : v[10].value));
  },
  488727124: (v) => new IFC2X3.IfcConstructionProductResource(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new IFC2X3.IfcIdentifier(!v[5] ? null : v[5].value), !v[6] ? null : new IFC2X3.IfcLabel(!v[6] ? null : v[6].value), v[7], !v[8] ? null : new Handle(!v[8] ? null : v[8].value)),
  335055490: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCooledBeamType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2954562838: (v) => {
    var _a, _b;
    return new IFC2X3.IfcCoolingTowerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1973544240: (v) => new IFC2X3.IfcCovering(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  3495092785: (v) => new IFC2X3.IfcCurtainWall(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3961806047: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDamperType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  4147604152: (v) => {
    var _a;
    return new IFC2X3.IfcDiameterDimension(((_a = v[0]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  1335981549: (v) => new IFC2X3.IfcDiscreteAccessory(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2635815018: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDiscreteAccessoryType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1599208980: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDistributionChamberElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2063403501: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDistributionControlElementType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value));
  },
  1945004755: (v) => new IFC2X3.IfcDistributionElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3040386961: (v) => new IFC2X3.IfcDistributionFlowElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3041715199: (v) => new IFC2X3.IfcDistributionPort(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), v[7]),
  395920057: (v) => new IFC2X3.IfcDoor(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value)),
  869906466: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDuctFittingType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3760055223: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDuctSegmentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2030761528: (v) => {
    var _a, _b;
    return new IFC2X3.IfcDuctSilencerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  855621170: (v) => new IFC2X3.IfcEdgeFeature(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value)),
  663422040: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElectricApplianceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3277789161: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElectricFlowStorageDeviceType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1534661035: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElectricGeneratorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1365060375: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElectricHeaterType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1217240411: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElectricMotorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  712377611: (v) => {
    var _a, _b;
    return new IFC2X3.IfcElectricTimeControlType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1634875225: (v) => new IFC2X3.IfcElectricalCircuit(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value)),
  857184966: (v) => new IFC2X3.IfcElectricalElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1658829314: (v) => new IFC2X3.IfcEnergyConversionDevice(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  346874300: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFanType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1810631287: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFilterType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  4222183408: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFireSuppressionTerminalType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2058353004: (v) => new IFC2X3.IfcFlowController(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  4278956645: (v) => new IFC2X3.IfcFlowFitting(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  4037862832: (v) => {
    var _a, _b;
    return new IFC2X3.IfcFlowInstrumentType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3132237377: (v) => new IFC2X3.IfcFlowMovingDevice(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  987401354: (v) => new IFC2X3.IfcFlowSegment(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  707683696: (v) => new IFC2X3.IfcFlowStorageDevice(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2223149337: (v) => new IFC2X3.IfcFlowTerminal(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3508470533: (v) => new IFC2X3.IfcFlowTreatmentDevice(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  900683007: (v) => new IFC2X3.IfcFooting(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  1073191201: (v) => new IFC2X3.IfcMember(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1687234759: (v) => new IFC2X3.IfcPile(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8], v[9]),
  3171933400: (v) => new IFC2X3.IfcPlate(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2262370178: (v) => new IFC2X3.IfcRailing(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  3024970846: (v) => new IFC2X3.IfcRamp(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  3283111854: (v) => new IFC2X3.IfcRampFlight(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3055160366: (v) => {
    var _a, _b;
    return new IFC2X3.IfcRationalBezierCurve(!v[0] ? null : v[0].value, ((_a = v[1]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], v[2], !v[3] ? null : v[3].value, !v[4] ? null : v[4].value, ((_b = v[5]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? Number(p.value) : null)) || []);
  },
  3027567501: (v) => new IFC2X3.IfcReinforcingElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value)),
  2320036040: (v) => new IFC2X3.IfcReinforcingMesh(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value), new IFC2X3.IfcPositiveLengthMeasure(!v[11] ? null : v[11].value), new IFC2X3.IfcPositiveLengthMeasure(!v[12] ? null : v[12].value), new IFC2X3.IfcAreaMeasure(!v[13] ? null : v[13].value), new IFC2X3.IfcAreaMeasure(!v[14] ? null : v[14].value), new IFC2X3.IfcPositiveLengthMeasure(!v[15] ? null : v[15].value), new IFC2X3.IfcPositiveLengthMeasure(!v[16] ? null : v[16].value)),
  2016517767: (v) => new IFC2X3.IfcRoof(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  1376911519: (v) => new IFC2X3.IfcRoundedEdgeFeature(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value)),
  1783015770: (v) => {
    var _a, _b;
    return new IFC2X3.IfcSensorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1529196076: (v) => new IFC2X3.IfcSlab(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  331165859: (v) => new IFC2X3.IfcStair(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8]),
  4252922144: (v) => new IFC2X3.IfcStairFlight(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : !v[8] ? null : v[8].value, !v[9] ? null : !v[9] ? null : v[9].value, !v[10] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[11] ? null : v[11].value)),
  2515109513: (v) => {
    var _a, _b;
    return new IFC2X3.IfcStructuralAnalysisModel(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), v[5], !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : ((_a = v[7]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[8] ? null : ((_b = v[8]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || []);
  },
  3824725483: (v) => new IFC2X3.IfcTendon(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9], new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value), new IFC2X3.IfcAreaMeasure(!v[11] ? null : v[11].value), !v[12] ? null : new IFC2X3.IfcForceMeasure(!v[12] ? null : v[12].value), !v[13] ? null : new IFC2X3.IfcPressureMeasure(!v[13] ? null : v[13].value), !v[14] ? null : new IFC2X3.IfcNormalisedRatioMeasure(!v[14] ? null : v[14].value), !v[15] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[15] ? null : v[15].value), !v[16] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[16] ? null : v[16].value)),
  2347447852: (v) => new IFC2X3.IfcTendonAnchor(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value)),
  3313531582: (v) => {
    var _a, _b;
    return new IFC2X3.IfcVibrationIsolatorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  2391406946: (v) => new IFC2X3.IfcWall(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3512223829: (v) => new IFC2X3.IfcWallStandardCase(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  3304561284: (v) => new IFC2X3.IfcWindow(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value)),
  2874132201: (v) => {
    var _a, _b;
    return new IFC2X3.IfcActuatorType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  3001207471: (v) => {
    var _a, _b;
    return new IFC2X3.IfcAlarmType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  753842376: (v) => new IFC2X3.IfcBeam(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  2454782716: (v) => new IFC2X3.IfcChamferEdgeFeature(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[8] ? null : v[8].value), !v[9] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), !v[10] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[10] ? null : v[10].value)),
  578613899: (v) => {
    var _a, _b;
    return new IFC2X3.IfcControllerType(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : ((_a = v[5]) == null ? void 0 : _a.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[6] ? null : ((_b = v[6]) == null ? void 0 : _b.map((p) => (p == null ? void 0 : p.value) ? new Handle(p.value) : null)) || [], !v[7] ? null : new IFC2X3.IfcLabel(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), v[9]);
  },
  1052013943: (v) => new IFC2X3.IfcDistributionChamberElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value)),
  1062813311: (v) => new IFC2X3.IfcDistributionControlElement(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcIdentifier(!v[8] ? null : v[8].value)),
  3700593921: (v) => new IFC2X3.IfcElectricDistributionPoint(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), v[8], !v[9] ? null : new IFC2X3.IfcLabel(!v[9] ? null : v[9].value)),
  979691226: (v) => new IFC2X3.IfcReinforcingBar(new IFC2X3.IfcGloballyUniqueId(!v[0] ? null : v[0].value), new Handle(!v[1] ? null : v[1].value), !v[2] ? null : new IFC2X3.IfcLabel(!v[2] ? null : v[2].value), !v[3] ? null : new IFC2X3.IfcText(!v[3] ? null : v[3].value), !v[4] ? null : new IFC2X3.IfcLabel(!v[4] ? null : v[4].value), !v[5] ? null : new Handle(!v[5] ? null : v[5].value), !v[6] ? null : new Handle(!v[6] ? null : v[6].value), !v[7] ? null : new IFC2X3.IfcIdentifier(!v[7] ? null : v[7].value), !v[8] ? null : new IFC2X3.IfcLabel(!v[8] ? null : v[8].value), new IFC2X3.IfcPositiveLengthMeasure(!v[9] ? null : v[9].value), new IFC2X3.IfcAreaMeasure(!v[10] ? null : v[10].value), !v[11] ? null : new IFC2X3.IfcPositiveLengthMeasure(!v[11] ? null : v[11].value), v[12], v[13])
};
InheritanceDef[1] = {
  618182010: [IFCTELECOMADDRESS, IFCPOSTALADDRESS],
  411424972: [IFCENVIRONMENTALIMPACTVALUE, IFCCOSTVALUE],
  4037036970: [IFCBOUNDARYNODECONDITIONWARPING, IFCBOUNDARYNODECONDITION, IFCBOUNDARYFACECONDITION, IFCBOUNDARYEDGECONDITION],
  1387855156: [IFCBOUNDARYNODECONDITIONWARPING],
  3264961684: [IFCCOLOURRGB],
  2859738748: [IFCCONNECTIONCURVEGEOMETRY, IFCCONNECTIONSURFACEGEOMETRY, IFCCONNECTIONPORTGEOMETRY, IFCCONNECTIONPOINTECCENTRICITY, IFCCONNECTIONPOINTGEOMETRY],
  2614616156: [IFCCONNECTIONPOINTECCENTRICITY],
  1959218052: [IFCOBJECTIVE, IFCMETRIC],
  3796139169: [IFCDIMENSIONPAIR, IFCDIMENSIONCALLOUTRELATIONSHIP],
  3200245327: [IFCDOCUMENTREFERENCE, IFCCLASSIFICATIONREFERENCE, IFCLIBRARYREFERENCE, IFCEXTERNALLYDEFINEDTEXTFONT, IFCEXTERNALLYDEFINEDSYMBOL, IFCEXTERNALLYDEFINEDSURFACESTYLE, IFCEXTERNALLYDEFINEDHATCHSTYLE],
  3265635763: [IFCHYGROSCOPICMATERIALPROPERTIES, IFCGENERALMATERIALPROPERTIES, IFCFUELPROPERTIES, IFCEXTENDEDMATERIALPROPERTIES, IFCWATERPROPERTIES, IFCTHERMALMATERIALPROPERTIES, IFCPRODUCTSOFCOMBUSTIONPROPERTIES, IFCOPTICALMATERIALPROPERTIES, IFCMECHANICALCONCRETEMATERIALPROPERTIES, IFCMECHANICALSTEELMATERIALPROPERTIES, IFCMECHANICALMATERIALPROPERTIES],
  4256014907: [IFCMECHANICALCONCRETEMATERIALPROPERTIES, IFCMECHANICALSTEELMATERIALPROPERTIES],
  1918398963: [IFCCONVERSIONBASEDUNIT, IFCCONTEXTDEPENDENTUNIT, IFCSIUNIT],
  3701648758: [IFCLOCALPLACEMENT, IFCGRIDPLACEMENT],
  2483315170: [IFCPHYSICALCOMPLEXQUANTITY, IFCQUANTITYWEIGHT, IFCQUANTITYVOLUME, IFCQUANTITYTIME, IFCQUANTITYLENGTH, IFCQUANTITYCOUNT, IFCQUANTITYAREA, IFCPHYSICALSIMPLEQUANTITY],
  2226359599: [IFCQUANTITYWEIGHT, IFCQUANTITYVOLUME, IFCQUANTITYTIME, IFCQUANTITYLENGTH, IFCQUANTITYCOUNT, IFCQUANTITYAREA],
  3727388367: [IFCDRAUGHTINGPREDEFINEDCURVEFONT, IFCPREDEFINEDCURVEFONT, IFCDRAUGHTINGPREDEFINEDCOLOUR, IFCPREDEFINEDCOLOUR, IFCDRAUGHTINGPREDEFINEDTEXTFONT, IFCTEXTSTYLEFONTMODEL, IFCPREDEFINEDTEXTFONT, IFCPREDEFINEDPOINTMARKERSYMBOL, IFCPREDEFINEDDIMENSIONSYMBOL, IFCPREDEFINEDTERMINATORSYMBOL, IFCPREDEFINEDSYMBOL],
  990879717: [IFCPREDEFINEDPOINTMARKERSYMBOL, IFCPREDEFINEDDIMENSIONSYMBOL, IFCPREDEFINEDTERMINATORSYMBOL],
  1775413392: [IFCDRAUGHTINGPREDEFINEDTEXTFONT, IFCTEXTSTYLEFONTMODEL],
  2022622350: [IFCPRESENTATIONLAYERWITHSTYLE],
  3119450353: [IFCFILLAREASTYLE, IFCCURVESTYLE, IFCTEXTSTYLE, IFCSYMBOLSTYLE, IFCSURFACESTYLE],
  2095639259: [IFCPRODUCTDEFINITIONSHAPE, IFCMATERIALDEFINITIONREPRESENTATION],
  3958567839: [IFCLSHAPEPROFILEDEF, IFCASYMMETRICISHAPEPROFILEDEF, IFCISHAPEPROFILEDEF, IFCELLIPSEPROFILEDEF, IFCCRANERAILFSHAPEPROFILEDEF, IFCCRANERAILASHAPEPROFILEDEF, IFCCIRCLEHOLLOWPROFILEDEF, IFCCIRCLEPROFILEDEF, IFCCSHAPEPROFILEDEF, IFCZSHAPEPROFILEDEF, IFCUSHAPEPROFILEDEF, IFCTRAPEZIUMPROFILEDEF, IFCTSHAPEPROFILEDEF, IFCRECTANGLEHOLLOWPROFILEDEF, IFCROUNDEDRECTANGLEPROFILEDEF, IFCRECTANGLEPROFILEDEF, IFCPARAMETERIZEDPROFILEDEF, IFCDERIVEDPROFILEDEF, IFCCOMPOSITEPROFILEDEF, IFCCENTERLINEPROFILEDEF, IFCARBITRARYOPENPROFILEDEF, IFCARBITRARYPROFILEDEFWITHVOIDS, IFCARBITRARYCLOSEDPROFILEDEF],
  2802850158: [IFCSTRUCTURALSTEELPROFILEPROPERTIES, IFCSTRUCTURALPROFILEPROPERTIES, IFCGENERALPROFILEPROPERTIES, IFCRIBPLATEPROFILEPROPERTIES],
  2598011224: [IFCCOMPLEXPROPERTY, IFCPROPERTYTABLEVALUE, IFCPROPERTYSINGLEVALUE, IFCPROPERTYREFERENCEVALUE, IFCPROPERTYLISTVALUE, IFCPROPERTYENUMERATEDVALUE, IFCPROPERTYBOUNDEDVALUE, IFCSIMPLEPROPERTY],
  1076942058: [IFCSTYLEDREPRESENTATION, IFCSTYLEMODEL, IFCTOPOLOGYREPRESENTATION, IFCSHAPEREPRESENTATION, IFCSHAPEMODEL],
  3377609919: [IFCGEOMETRICREPRESENTATIONSUBCONTEXT, IFCGEOMETRICREPRESENTATIONCONTEXT],
  3008791417: [IFCMAPPEDITEM, IFCFILLAREASTYLETILES, IFCFILLAREASTYLETILESYMBOLWITHSTYLE, IFCFILLAREASTYLEHATCHING, IFCFACEBASEDSURFACEMODEL, IFCDIAMETERDIMENSION, IFCANGULARDIMENSION, IFCRADIUSDIMENSION, IFCLINEARDIMENSION, IFCDIMENSIONCURVEDIRECTEDCALLOUT, IFCSTRUCTUREDDIMENSIONCALLOUT, IFCDRAUGHTINGCALLOUT, IFCDIRECTION, IFCDEFINEDSYMBOL, IFCCIRCLE, IFCELLIPSE, IFCCONIC, IFCRATIONALBEZIERCURVE, IFCBEZIERCURVE, IFCBSPLINECURVE, IFCTRIMMEDCURVE, IFCPOLYLINE, IFC2DCOMPOSITECURVE, IFCCOMPOSITECURVE, IFCBOUNDEDCURVE, IFCOFFSETCURVE3D, IFCOFFSETCURVE2D, IFCLINE, IFCCURVE, IFCBLOCK, IFCSPHERE, IFCRIGHTCIRCULARCYLINDER, IFCRIGHTCIRCULARCONE, IFCRECTANGULARPYRAMID, IFCCSGPRIMITIVE3D, IFCCOMPOSITECURVESEGMENT, IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM, IFCCARTESIANTRANSFORMATIONOPERATOR3D, IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM, IFCCARTESIANTRANSFORMATIONOPERATOR2D, IFCCARTESIANTRANSFORMATIONOPERATOR, IFCBOUNDINGBOX, IFCBOOLEANCLIPPINGRESULT, IFCBOOLEANRESULT, IFCANNOTATIONSURFACE, IFCANNOTATIONFILLAREA, IFCVECTOR, IFCTEXTLITERALWITHEXTENT, IFCTEXTLITERAL, IFCPLANE, IFCELEMENTARYSURFACE, IFCRECTANGULARTRIMMEDSURFACE, IFCCURVEBOUNDEDPLANE, IFCBOUNDEDSURFACE, IFCSURFACEOFREVOLUTION, IFCSURFACEOFLINEAREXTRUSION, IFCSWEPTSURFACE, IFCSURFACE, IFCFACETEDBREPWITHVOIDS, IFCFACETEDBREP, IFCMANIFOLDSOLIDBREP, IFCCSGSOLID, IFCSWEPTDISKSOLID, IFCSURFACECURVESWEPTAREASOLID, IFCREVOLVEDAREASOLID, IFCEXTRUDEDAREASOLID, IFCSWEPTAREASOLID, IFCSOLIDMODEL, IFCSHELLBASEDSURFACEMODEL, IFCSECTIONEDSPINE, IFCCARTESIANPOINT, IFCPOINTONSURFACE, IFCPOINTONCURVE, IFCPOINT, IFCPLANARBOX, IFCPLANAREXTENT, IFCAXIS2PLACEMENT3D, IFCAXIS2PLACEMENT2D, IFCAXIS1PLACEMENT, IFCPLACEMENT, IFCTWODIRECTIONREPEATFACTOR, IFCONEDIRECTIONREPEATFACTOR, IFCLIGHTSOURCESPOT, IFCLIGHTSOURCEPOSITIONAL, IFCLIGHTSOURCEGONIOMETRIC, IFCLIGHTSOURCEDIRECTIONAL, IFCLIGHTSOURCEAMBIENT, IFCLIGHTSOURCE, IFCBOXEDHALFSPACE, IFCPOLYGONALBOUNDEDHALFSPACE, IFCHALFSPACESOLID, IFCGEOMETRICCURVESET, IFCGEOMETRICSET, IFCGEOMETRICREPRESENTATIONITEM, IFCPATH, IFCEDGELOOP, IFCVERTEXLOOP, IFCPOLYLOOP, IFCLOOP, IFCFACEOUTERBOUND, IFCFACEBOUND, IFCFACESURFACE, IFCFACE, IFCSUBEDGE, IFCORIENTEDEDGE, IFCEDGECURVE, IFCEDGE, IFCCLOSEDSHELL, IFCOPENSHELL, IFCCONNECTEDFACESET, IFCVERTEXPOINT, IFCVERTEX, IFCTOPOLOGICALREPRESENTATIONITEM, IFCANNOTATIONFILLAREAOCCURRENCE, IFCPROJECTIONCURVE, IFCDIMENSIONCURVE, IFCANNOTATIONCURVEOCCURRENCE, IFCANNOTATIONTEXTOCCURRENCE, IFCDIMENSIONCURVETERMINATOR, IFCTERMINATORSYMBOL, IFCANNOTATIONSYMBOLOCCURRENCE, IFCANNOTATIONSURFACEOCCURRENCE, IFCANNOTATIONOCCURRENCE, IFCSTYLEDITEM],
  2341007311: [IFCRELDEFINESBYTYPE, IFCRELOVERRIDESPROPERTIES, IFCRELDEFINESBYPROPERTIES, IFCRELDEFINES, IFCRELAGGREGATES, IFCRELNESTS, IFCRELDECOMPOSES, IFCRELVOIDSELEMENT, IFCRELSPACEBOUNDARY, IFCRELSERVICESBUILDINGS, IFCRELSEQUENCE, IFCRELREFERENCEDINSPATIALSTRUCTURE, IFCRELPROJECTSELEMENT, IFCRELINTERACTIONREQUIREMENTS, IFCRELFLOWCONTROLELEMENTS, IFCRELFILLSELEMENT, IFCRELCOVERSSPACES, IFCRELCOVERSBLDGELEMENTS, IFCRELCONTAINEDINSPATIALSTRUCTURE, IFCRELCONNECTSWITHECCENTRICITY, IFCRELCONNECTSSTRUCTURALMEMBER, IFCRELCONNECTSSTRUCTURALELEMENT, IFCRELCONNECTSSTRUCTURALACTIVITY, IFCRELCONNECTSPORTS, IFCRELCONNECTSPORTTOELEMENT, IFCRELCONNECTSWITHREALIZINGELEMENTS, IFCRELCONNECTSPATHELEMENTS, IFCRELCONNECTSELEMENTS, IFCRELCONNECTS, IFCRELASSOCIATESPROFILEPROPERTIES, IFCRELASSOCIATESMATERIAL, IFCRELASSOCIATESLIBRARY, IFCRELASSOCIATESDOCUMENT, IFCRELASSOCIATESCONSTRAINT, IFCRELASSOCIATESCLASSIFICATION, IFCRELASSOCIATESAPPROVAL, IFCRELASSOCIATESAPPLIEDVALUE, IFCRELASSOCIATES, IFCRELASSIGNSTORESOURCE, IFCRELASSIGNSTOPRODUCT, IFCRELASSIGNSTOPROCESS, IFCRELASSIGNSTOGROUP, IFCRELASSIGNSTASKS, IFCRELSCHEDULESCOSTITEMS, IFCRELASSIGNSTOPROJECTORDER, IFCRELASSIGNSTOCONTROL, IFCRELOCCUPIESSPACES, IFCRELASSIGNSTOACTOR, IFCRELASSIGNS, IFCRELATIONSHIP, IFCPROPERTYSET, IFCPERMEABLECOVERINGPROPERTIES, IFCFLUIDFLOWPROPERTIES, IFCELECTRICALBASEPROPERTIES, IFCENERGYPROPERTIES, IFCELEMENTQUANTITY, IFCDOORPANELPROPERTIES, IFCDOORLININGPROPERTIES, IFCWINDOWPANELPROPERTIES, IFCWINDOWLININGPROPERTIES, IFCSPACETHERMALLOADPROPERTIES, IFCSOUNDVALUE, IFCSOUNDPROPERTIES, IFCSERVICELIFEFACTOR, IFCREINFORCEMENTDEFINITIONPROPERTIES, IFCPROPERTYSETDEFINITION, IFCPROPERTYDEFINITION, IFCCONDITION, IFCASSET, IFCZONE, IFCSTRUCTURALANALYSISMODEL, IFCELECTRICALCIRCUIT, IFCSYSTEM, IFCSTRUCTURALRESULTGROUP, IFCSTRUCTURALLOADGROUP, IFCINVENTORY, IFCGROUP, IFCCONDITIONCRITERION, IFCACTIONREQUEST, IFCWORKSCHEDULE, IFCWORKPLAN, IFCWORKCONTROL, IFCTIMESERIESSCHEDULE, IFCSPACEPROGRAM, IFCSERVICELIFE, IFCSCHEDULETIMECONTROL, IFCPROJECTORDERRECORD, IFCPROJECTORDER, IFCPERMIT, IFCPERFORMANCEHISTORY, IFCFURNITURESTANDARD, IFCEQUIPMENTSTANDARD, IFCCOSTSCHEDULE, IFCCOSTITEM, IFCCONTROL, IFCOCCUPANT, IFCACTOR, IFCCONSTRUCTIONPRODUCTRESOURCE, IFCCONSTRUCTIONMATERIALRESOURCE, IFCCONSTRUCTIONEQUIPMENTRESOURCE, IFCSUBCONTRACTRESOURCE, IFCLABORRESOURCE, IFCCREWRESOURCE, IFCCONSTRUCTIONRESOURCE, IFCRESOURCE, IFCPROJECT, IFCDISTRIBUTIONPORT, IFCPORT, IFCGRID, IFCELECTRICALELEMENT, IFCDISTRIBUTIONCONTROLELEMENT, IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE, IFCDISTRIBUTIONFLOWELEMENT, IFCDISTRIBUTIONELEMENT, IFCBEAM, IFCWINDOW, IFCWALLSTANDARDCASE, IFCWALL, IFCSTAIRFLIGHT, IFCSTAIR, IFCSLAB, IFCROOF, IFCRAMPFLIGHT, IFCRAMP, IFCRAILING, IFCPLATE, IFCPILE, IFCMEMBER, IFCFOOTING, IFCDOOR, IFCCURTAINWALL, IFCCOVERING, IFCCOLUMN, IFCBUILDINGELEMENTPROXY, IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART, IFCBUILDINGELEMENTCOMPONENT, IFCBUILDINGELEMENT, IFCVIRTUALELEMENT, IFCTRANSPORTELEMENT, IFCFURNISHINGELEMENT, IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT, IFCFEATUREELEMENTSUBTRACTION, IFCPROJECTIONELEMENT, IFCFEATUREELEMENTADDITION, IFCFEATUREELEMENT, IFCEQUIPMENTELEMENT, IFCDISCRETEACCESSORY, IFCMECHANICALFASTENER, IFCFASTENER, IFCELEMENTCOMPONENT, IFCELEMENTASSEMBLY, IFCELEMENT, IFCANNOTATION, IFCSTRUCTURALSURFACECONNECTION, IFCSTRUCTURALPOINTCONNECTION, IFCSTRUCTURALCURVECONNECTION, IFCSTRUCTURALCONNECTION, IFCSTRUCTURALCURVEMEMBERVARYING, IFCSTRUCTURALCURVEMEMBER, IFCSTRUCTURALSURFACEMEMBERVARYING, IFCSTRUCTURALSURFACEMEMBER, IFCSTRUCTURALMEMBER, IFCSTRUCTURALITEM, IFCSTRUCTURALPOINTACTION, IFCSTRUCTURALPLANARACTIONVARYING, IFCSTRUCTURALPLANARACTION, IFCSTRUCTURALLINEARACTIONVARYING, IFCSTRUCTURALLINEARACTION, IFCSTRUCTURALACTION, IFCSTRUCTURALPOINTREACTION, IFCSTRUCTURALREACTION, IFCSTRUCTURALACTIVITY, IFCSPACE, IFCSITE, IFCBUILDINGSTOREY, IFCBUILDING, IFCSPATIALSTRUCTUREELEMENT, IFCPROXY, IFCPRODUCT, IFCPROCEDURE, IFCORDERACTION, IFCMOVE, IFCTASK, IFCPROCESS, IFCOBJECT, IFCVIBRATIONISOLATORTYPE, IFCDISCRETEACCESSORYTYPE, IFCMECHANICALFASTENERTYPE, IFCFASTENERTYPE, IFCELEMENTCOMPONENTTYPE, IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE, IFCDISTRIBUTIONCONTROLELEMENTTYPE, IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE, IFCDISTRIBUTIONFLOWELEMENTTYPE, IFCDISTRIBUTIONELEMENTTYPE, IFCBUILDINGELEMENTPROXYTYPE, IFCBEAMTYPE, IFCWALLTYPE, IFCSTAIRFLIGHTTYPE, IFCSLABTYPE, IFCRAMPFLIGHTTYPE, IFCRAILINGTYPE, IFCPLATETYPE, IFCMEMBERTYPE, IFCCURTAINWALLTYPE, IFCCOVERINGTYPE, IFCCOLUMNTYPE, IFCBUILDINGELEMENTTYPE, IFCTRANSPORTELEMENTTYPE, IFCSPACETYPE, IFCSPATIALSTRUCTUREELEMENTTYPE, IFCSYSTEMFURNITUREELEMENTTYPE, IFCFURNITURETYPE, IFCFURNISHINGELEMENTTYPE, IFCELEMENTTYPE, IFCDOORSTYLE, IFCWINDOWSTYLE, IFCTYPEPRODUCT, IFCTYPEOBJECT, IFCOBJECTDEFINITION],
  3982875396: [IFCTOPOLOGYREPRESENTATION, IFCSHAPEREPRESENTATION],
  3692461612: [IFCPROPERTYTABLEVALUE, IFCPROPERTYSINGLEVALUE, IFCPROPERTYREFERENCEVALUE, IFCPROPERTYLISTVALUE, IFCPROPERTYENUMERATEDVALUE, IFCPROPERTYBOUNDEDVALUE],
  2273995522: [IFCSLIPPAGECONNECTIONCONDITION, IFCFAILURECONNECTIONCONDITION],
  2162789131: [IFCSTRUCTURALLOADSINGLEFORCEWARPING, IFCSTRUCTURALLOADSINGLEFORCE, IFCSTRUCTURALLOADSINGLEDISPLACEMENTDISTORTION, IFCSTRUCTURALLOADSINGLEDISPLACEMENT, IFCSTRUCTURALLOADPLANARFORCE, IFCSTRUCTURALLOADLINEARFORCE, IFCSTRUCTURALLOADTEMPERATURE, IFCSTRUCTURALLOADSTATIC],
  2525727697: [IFCSTRUCTURALLOADSINGLEFORCEWARPING, IFCSTRUCTURALLOADSINGLEFORCE, IFCSTRUCTURALLOADSINGLEDISPLACEMENTDISTORTION, IFCSTRUCTURALLOADSINGLEDISPLACEMENT, IFCSTRUCTURALLOADPLANARFORCE, IFCSTRUCTURALLOADLINEARFORCE, IFCSTRUCTURALLOADTEMPERATURE],
  2830218821: [IFCSTYLEDREPRESENTATION],
  3958052878: [IFCANNOTATIONFILLAREAOCCURRENCE, IFCPROJECTIONCURVE, IFCDIMENSIONCURVE, IFCANNOTATIONCURVEOCCURRENCE, IFCANNOTATIONTEXTOCCURRENCE, IFCDIMENSIONCURVETERMINATOR, IFCTERMINATORSYMBOL, IFCANNOTATIONSYMBOLOCCURRENCE, IFCANNOTATIONSURFACEOCCURRENCE, IFCANNOTATIONOCCURRENCE],
  846575682: [IFCSURFACESTYLERENDERING],
  626085974: [IFCPIXELTEXTURE, IFCIMAGETEXTURE, IFCBLOBTEXTURE],
  280115917: [IFCTEXTUREMAP, IFCTEXTURECOORDINATEGENERATOR],
  3101149627: [IFCREGULARTIMESERIES, IFCIRREGULARTIMESERIES],
  1377556343: [IFCPATH, IFCEDGELOOP, IFCVERTEXLOOP, IFCPOLYLOOP, IFCLOOP, IFCFACEOUTERBOUND, IFCFACEBOUND, IFCFACESURFACE, IFCFACE, IFCSUBEDGE, IFCORIENTEDEDGE, IFCEDGECURVE, IFCEDGE, IFCCLOSEDSHELL, IFCOPENSHELL, IFCCONNECTEDFACESET, IFCVERTEXPOINT, IFCVERTEX],
  2799835756: [IFCVERTEXPOINT],
  2442683028: [IFCANNOTATIONFILLAREAOCCURRENCE, IFCPROJECTIONCURVE, IFCDIMENSIONCURVE, IFCANNOTATIONCURVEOCCURRENCE, IFCANNOTATIONTEXTOCCURRENCE, IFCDIMENSIONCURVETERMINATOR, IFCTERMINATORSYMBOL, IFCANNOTATIONSYMBOLOCCURRENCE, IFCANNOTATIONSURFACEOCCURRENCE],
  3612888222: [IFCDIMENSIONCURVETERMINATOR, IFCTERMINATORSYMBOL],
  3798115385: [IFCARBITRARYPROFILEDEFWITHVOIDS],
  1310608509: [IFCCENTERLINEPROFILEDEF],
  370225590: [IFCCLOSEDSHELL, IFCOPENSHELL],
  3900360178: [IFCSUBEDGE, IFCORIENTEDEDGE, IFCEDGECURVE],
  2556980723: [IFCFACESURFACE],
  1809719519: [IFCFACEOUTERBOUND],
  1446786286: [IFCSTRUCTURALSTEELPROFILEPROPERTIES, IFCSTRUCTURALPROFILEPROPERTIES],
  3448662350: [IFCGEOMETRICREPRESENTATIONSUBCONTEXT],
  2453401579: [IFCFILLAREASTYLETILES, IFCFILLAREASTYLETILESYMBOLWITHSTYLE, IFCFILLAREASTYLEHATCHING, IFCFACEBASEDSURFACEMODEL, IFCDIAMETERDIMENSION, IFCANGULARDIMENSION, IFCRADIUSDIMENSION, IFCLINEARDIMENSION, IFCDIMENSIONCURVEDIRECTEDCALLOUT, IFCSTRUCTUREDDIMENSIONCALLOUT, IFCDRAUGHTINGCALLOUT, IFCDIRECTION, IFCDEFINEDSYMBOL, IFCCIRCLE, IFCELLIPSE, IFCCONIC, IFCRATIONALBEZIERCURVE, IFCBEZIERCURVE, IFCBSPLINECURVE, IFCTRIMMEDCURVE, IFCPOLYLINE, IFC2DCOMPOSITECURVE, IFCCOMPOSITECURVE, IFCBOUNDEDCURVE, IFCOFFSETCURVE3D, IFCOFFSETCURVE2D, IFCLINE, IFCCURVE, IFCBLOCK, IFCSPHERE, IFCRIGHTCIRCULARCYLINDER, IFCRIGHTCIRCULARCONE, IFCRECTANGULARPYRAMID, IFCCSGPRIMITIVE3D, IFCCOMPOSITECURVESEGMENT, IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM, IFCCARTESIANTRANSFORMATIONOPERATOR3D, IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM, IFCCARTESIANTRANSFORMATIONOPERATOR2D, IFCCARTESIANTRANSFORMATIONOPERATOR, IFCBOUNDINGBOX, IFCBOOLEANCLIPPINGRESULT, IFCBOOLEANRESULT, IFCANNOTATIONSURFACE, IFCANNOTATIONFILLAREA, IFCVECTOR, IFCTEXTLITERALWITHEXTENT, IFCTEXTLITERAL, IFCPLANE, IFCELEMENTARYSURFACE, IFCRECTANGULARTRIMMEDSURFACE, IFCCURVEBOUNDEDPLANE, IFCBOUNDEDSURFACE, IFCSURFACEOFREVOLUTION, IFCSURFACEOFLINEAREXTRUSION, IFCSWEPTSURFACE, IFCSURFACE, IFCFACETEDBREPWITHVOIDS, IFCFACETEDBREP, IFCMANIFOLDSOLIDBREP, IFCCSGSOLID, IFCSWEPTDISKSOLID, IFCSURFACECURVESWEPTAREASOLID, IFCREVOLVEDAREASOLID, IFCEXTRUDEDAREASOLID, IFCSWEPTAREASOLID, IFCSOLIDMODEL, IFCSHELLBASEDSURFACEMODEL, IFCSECTIONEDSPINE, IFCCARTESIANPOINT, IFCPOINTONSURFACE, IFCPOINTONCURVE, IFCPOINT, IFCPLANARBOX, IFCPLANAREXTENT, IFCAXIS2PLACEMENT3D, IFCAXIS2PLACEMENT2D, IFCAXIS1PLACEMENT, IFCPLACEMENT, IFCTWODIRECTIONREPEATFACTOR, IFCONEDIRECTIONREPEATFACTOR, IFCLIGHTSOURCESPOT, IFCLIGHTSOURCEPOSITIONAL, IFCLIGHTSOURCEGONIOMETRIC, IFCLIGHTSOURCEDIRECTIONAL, IFCLIGHTSOURCEAMBIENT, IFCLIGHTSOURCE, IFCBOXEDHALFSPACE, IFCPOLYGONALBOUNDEDHALFSPACE, IFCHALFSPACESOLID, IFCGEOMETRICCURVESET, IFCGEOMETRICSET],
  3590301190: [IFCGEOMETRICCURVESET],
  812098782: [IFCBOXEDHALFSPACE, IFCPOLYGONALBOUNDEDHALFSPACE],
  1402838566: [IFCLIGHTSOURCESPOT, IFCLIGHTSOURCEPOSITIONAL, IFCLIGHTSOURCEGONIOMETRIC, IFCLIGHTSOURCEDIRECTIONAL, IFCLIGHTSOURCEAMBIENT],
  1520743889: [IFCLIGHTSOURCESPOT],
  1008929658: [IFCEDGELOOP, IFCVERTEXLOOP, IFCPOLYLOOP],
  219451334: [IFCCONDITION, IFCASSET, IFCZONE, IFCSTRUCTURALANALYSISMODEL, IFCELECTRICALCIRCUIT, IFCSYSTEM, IFCSTRUCTURALRESULTGROUP, IFCSTRUCTURALLOADGROUP, IFCINVENTORY, IFCGROUP, IFCCONDITIONCRITERION, IFCACTIONREQUEST, IFCWORKSCHEDULE, IFCWORKPLAN, IFCWORKCONTROL, IFCTIMESERIESSCHEDULE, IFCSPACEPROGRAM, IFCSERVICELIFE, IFCSCHEDULETIMECONTROL, IFCPROJECTORDERRECORD, IFCPROJECTORDER, IFCPERMIT, IFCPERFORMANCEHISTORY, IFCFURNITURESTANDARD, IFCEQUIPMENTSTANDARD, IFCCOSTSCHEDULE, IFCCOSTITEM, IFCCONTROL, IFCOCCUPANT, IFCACTOR, IFCCONSTRUCTIONPRODUCTRESOURCE, IFCCONSTRUCTIONMATERIALRESOURCE, IFCCONSTRUCTIONEQUIPMENTRESOURCE, IFCSUBCONTRACTRESOURCE, IFCLABORRESOURCE, IFCCREWRESOURCE, IFCCONSTRUCTIONRESOURCE, IFCRESOURCE, IFCPROJECT, IFCDISTRIBUTIONPORT, IFCPORT, IFCGRID, IFCELECTRICALELEMENT, IFCDISTRIBUTIONCONTROLELEMENT, IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE, IFCDISTRIBUTIONFLOWELEMENT, IFCDISTRIBUTIONELEMENT, IFCBEAM, IFCWINDOW, IFCWALLSTANDARDCASE, IFCWALL, IFCSTAIRFLIGHT, IFCSTAIR, IFCSLAB, IFCROOF, IFCRAMPFLIGHT, IFCRAMP, IFCRAILING, IFCPLATE, IFCPILE, IFCMEMBER, IFCFOOTING, IFCDOOR, IFCCURTAINWALL, IFCCOVERING, IFCCOLUMN, IFCBUILDINGELEMENTPROXY, IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART, IFCBUILDINGELEMENTCOMPONENT, IFCBUILDINGELEMENT, IFCVIRTUALELEMENT, IFCTRANSPORTELEMENT, IFCFURNISHINGELEMENT, IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT, IFCFEATUREELEMENTSUBTRACTION, IFCPROJECTIONELEMENT, IFCFEATUREELEMENTADDITION, IFCFEATUREELEMENT, IFCEQUIPMENTELEMENT, IFCDISCRETEACCESSORY, IFCMECHANICALFASTENER, IFCFASTENER, IFCELEMENTCOMPONENT, IFCELEMENTASSEMBLY, IFCELEMENT, IFCANNOTATION, IFCSTRUCTURALSURFACECONNECTION, IFCSTRUCTURALPOINTCONNECTION, IFCSTRUCTURALCURVECONNECTION, IFCSTRUCTURALCONNECTION, IFCSTRUCTURALCURVEMEMBERVARYING, IFCSTRUCTURALCURVEMEMBER, IFCSTRUCTURALSURFACEMEMBERVARYING, IFCSTRUCTURALSURFACEMEMBER, IFCSTRUCTURALMEMBER, IFCSTRUCTURALITEM, IFCSTRUCTURALPOINTACTION, IFCSTRUCTURALPLANARACTIONVARYING, IFCSTRUCTURALPLANARACTION, IFCSTRUCTURALLINEARACTIONVARYING, IFCSTRUCTURALLINEARACTION, IFCSTRUCTURALACTION, IFCSTRUCTURALPOINTREACTION, IFCSTRUCTURALREACTION, IFCSTRUCTURALACTIVITY, IFCSPACE, IFCSITE, IFCBUILDINGSTOREY, IFCBUILDING, IFCSPATIALSTRUCTUREELEMENT, IFCPROXY, IFCPRODUCT, IFCPROCEDURE, IFCORDERACTION, IFCMOVE, IFCTASK, IFCPROCESS, IFCOBJECT, IFCVIBRATIONISOLATORTYPE, IFCDISCRETEACCESSORYTYPE, IFCMECHANICALFASTENERTYPE, IFCFASTENERTYPE, IFCELEMENTCOMPONENTTYPE, IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE, IFCDISTRIBUTIONCONTROLELEMENTTYPE, IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE, IFCDISTRIBUTIONFLOWELEMENTTYPE, IFCDISTRIBUTIONELEMENTTYPE, IFCBUILDINGELEMENTPROXYTYPE, IFCBEAMTYPE, IFCWALLTYPE, IFCSTAIRFLIGHTTYPE, IFCSLABTYPE, IFCRAMPFLIGHTTYPE, IFCRAILINGTYPE, IFCPLATETYPE, IFCMEMBERTYPE, IFCCURTAINWALLTYPE, IFCCOVERINGTYPE, IFCCOLUMNTYPE, IFCBUILDINGELEMENTTYPE, IFCTRANSPORTELEMENTTYPE, IFCSPACETYPE, IFCSPATIALSTRUCTUREELEMENTTYPE, IFCSYSTEMFURNITUREELEMENTTYPE, IFCFURNITURETYPE, IFCFURNISHINGELEMENTTYPE, IFCELEMENTTYPE, IFCDOORSTYLE, IFCWINDOWSTYLE, IFCTYPEPRODUCT, IFCTYPEOBJECT],
  2833995503: [IFCTWODIRECTIONREPEATFACTOR],
  2529465313: [IFCLSHAPEPROFILEDEF, IFCASYMMETRICISHAPEPROFILEDEF, IFCISHAPEPROFILEDEF, IFCELLIPSEPROFILEDEF, IFCCRANERAILFSHAPEPROFILEDEF, IFCCRANERAILASHAPEPROFILEDEF, IFCCIRCLEHOLLOWPROFILEDEF, IFCCIRCLEPROFILEDEF, IFCCSHAPEPROFILEDEF, IFCZSHAPEPROFILEDEF, IFCUSHAPEPROFILEDEF, IFCTRAPEZIUMPROFILEDEF, IFCTSHAPEPROFILEDEF, IFCRECTANGLEHOLLOWPROFILEDEF, IFCROUNDEDRECTANGLEPROFILEDEF, IFCRECTANGLEPROFILEDEF],
  2004835150: [IFCAXIS2PLACEMENT3D, IFCAXIS2PLACEMENT2D, IFCAXIS1PLACEMENT],
  1663979128: [IFCPLANARBOX],
  2067069095: [IFCCARTESIANPOINT, IFCPOINTONSURFACE, IFCPOINTONCURVE],
  759155922: [IFCDRAUGHTINGPREDEFINEDCOLOUR],
  2559016684: [IFCDRAUGHTINGPREDEFINEDCURVEFONT],
  1680319473: [IFCPROPERTYSET, IFCPERMEABLECOVERINGPROPERTIES, IFCFLUIDFLOWPROPERTIES, IFCELECTRICALBASEPROPERTIES, IFCENERGYPROPERTIES, IFCELEMENTQUANTITY, IFCDOORPANELPROPERTIES, IFCDOORLININGPROPERTIES, IFCWINDOWPANELPROPERTIES, IFCWINDOWLININGPROPERTIES, IFCSPACETHERMALLOADPROPERTIES, IFCSOUNDVALUE, IFCSOUNDPROPERTIES, IFCSERVICELIFEFACTOR, IFCREINFORCEMENTDEFINITIONPROPERTIES, IFCPROPERTYSETDEFINITION],
  3357820518: [IFCPROPERTYSET, IFCPERMEABLECOVERINGPROPERTIES, IFCFLUIDFLOWPROPERTIES, IFCELECTRICALBASEPROPERTIES, IFCENERGYPROPERTIES, IFCELEMENTQUANTITY, IFCDOORPANELPROPERTIES, IFCDOORLININGPROPERTIES, IFCWINDOWPANELPROPERTIES, IFCWINDOWLININGPROPERTIES, IFCSPACETHERMALLOADPROPERTIES, IFCSOUNDVALUE, IFCSOUNDPROPERTIES, IFCSERVICELIFEFACTOR, IFCREINFORCEMENTDEFINITIONPROPERTIES],
  3615266464: [IFCRECTANGLEHOLLOWPROFILEDEF, IFCROUNDEDRECTANGLEPROFILEDEF],
  478536968: [IFCRELDEFINESBYTYPE, IFCRELOVERRIDESPROPERTIES, IFCRELDEFINESBYPROPERTIES, IFCRELDEFINES, IFCRELAGGREGATES, IFCRELNESTS, IFCRELDECOMPOSES, IFCRELVOIDSELEMENT, IFCRELSPACEBOUNDARY, IFCRELSERVICESBUILDINGS, IFCRELSEQUENCE, IFCRELREFERENCEDINSPATIALSTRUCTURE, IFCRELPROJECTSELEMENT, IFCRELINTERACTIONREQUIREMENTS, IFCRELFLOWCONTROLELEMENTS, IFCRELFILLSELEMENT, IFCRELCOVERSSPACES, IFCRELCOVERSBLDGELEMENTS, IFCRELCONTAINEDINSPATIALSTRUCTURE, IFCRELCONNECTSWITHECCENTRICITY, IFCRELCONNECTSSTRUCTURALMEMBER, IFCRELCONNECTSSTRUCTURALELEMENT, IFCRELCONNECTSSTRUCTURALACTIVITY, IFCRELCONNECTSPORTS, IFCRELCONNECTSPORTTOELEMENT, IFCRELCONNECTSWITHREALIZINGELEMENTS, IFCRELCONNECTSPATHELEMENTS, IFCRELCONNECTSELEMENTS, IFCRELCONNECTS, IFCRELASSOCIATESPROFILEPROPERTIES, IFCRELASSOCIATESMATERIAL, IFCRELASSOCIATESLIBRARY, IFCRELASSOCIATESDOCUMENT, IFCRELASSOCIATESCONSTRAINT, IFCRELASSOCIATESCLASSIFICATION, IFCRELASSOCIATESAPPROVAL, IFCRELASSOCIATESAPPLIEDVALUE, IFCRELASSOCIATES, IFCRELASSIGNSTORESOURCE, IFCRELASSIGNSTOPRODUCT, IFCRELASSIGNSTOPROCESS, IFCRELASSIGNSTOGROUP, IFCRELASSIGNSTASKS, IFCRELSCHEDULESCOSTITEMS, IFCRELASSIGNSTOPROJECTORDER, IFCRELASSIGNSTOCONTROL, IFCRELOCCUPIESSPACES, IFCRELASSIGNSTOACTOR, IFCRELASSIGNS],
  723233188: [IFCFACETEDBREPWITHVOIDS, IFCFACETEDBREP, IFCMANIFOLDSOLIDBREP, IFCCSGSOLID, IFCSWEPTDISKSOLID, IFCSURFACECURVESWEPTAREASOLID, IFCREVOLVEDAREASOLID, IFCEXTRUDEDAREASOLID, IFCSWEPTAREASOLID],
  2473145415: [IFCSTRUCTURALLOADSINGLEDISPLACEMENTDISTORTION],
  1597423693: [IFCSTRUCTURALLOADSINGLEFORCEWARPING],
  3843319758: [IFCSTRUCTURALSTEELPROFILEPROPERTIES],
  2513912981: [IFCPLANE, IFCELEMENTARYSURFACE, IFCRECTANGULARTRIMMEDSURFACE, IFCCURVEBOUNDEDPLANE, IFCBOUNDEDSURFACE, IFCSURFACEOFREVOLUTION, IFCSURFACEOFLINEAREXTRUSION, IFCSWEPTSURFACE],
  2247615214: [IFCSURFACECURVESWEPTAREASOLID, IFCREVOLVEDAREASOLID, IFCEXTRUDEDAREASOLID],
  230924584: [IFCSURFACEOFREVOLUTION, IFCSURFACEOFLINEAREXTRUSION],
  3028897424: [IFCDIMENSIONCURVETERMINATOR],
  4282788508: [IFCTEXTLITERALWITHEXTENT],
  1628702193: [IFCVIBRATIONISOLATORTYPE, IFCDISCRETEACCESSORYTYPE, IFCMECHANICALFASTENERTYPE, IFCFASTENERTYPE, IFCELEMENTCOMPONENTTYPE, IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE, IFCDISTRIBUTIONCONTROLELEMENTTYPE, IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE, IFCDISTRIBUTIONFLOWELEMENTTYPE, IFCDISTRIBUTIONELEMENTTYPE, IFCBUILDINGELEMENTPROXYTYPE, IFCBEAMTYPE, IFCWALLTYPE, IFCSTAIRFLIGHTTYPE, IFCSLABTYPE, IFCRAMPFLIGHTTYPE, IFCRAILINGTYPE, IFCPLATETYPE, IFCMEMBERTYPE, IFCCURTAINWALLTYPE, IFCCOVERINGTYPE, IFCCOLUMNTYPE, IFCBUILDINGELEMENTTYPE, IFCTRANSPORTELEMENTTYPE, IFCSPACETYPE, IFCSPATIALSTRUCTUREELEMENTTYPE, IFCSYSTEMFURNITUREELEMENTTYPE, IFCFURNITURETYPE, IFCFURNISHINGELEMENTTYPE, IFCELEMENTTYPE, IFCDOORSTYLE, IFCWINDOWSTYLE, IFCTYPEPRODUCT],
  2347495698: [IFCVIBRATIONISOLATORTYPE, IFCDISCRETEACCESSORYTYPE, IFCMECHANICALFASTENERTYPE, IFCFASTENERTYPE, IFCELEMENTCOMPONENTTYPE, IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE, IFCDISTRIBUTIONCONTROLELEMENTTYPE, IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE, IFCDISTRIBUTIONFLOWELEMENTTYPE, IFCDISTRIBUTIONELEMENTTYPE, IFCBUILDINGELEMENTPROXYTYPE, IFCBEAMTYPE, IFCWALLTYPE, IFCSTAIRFLIGHTTYPE, IFCSLABTYPE, IFCRAMPFLIGHTTYPE, IFCRAILINGTYPE, IFCPLATETYPE, IFCMEMBERTYPE, IFCCURTAINWALLTYPE, IFCCOVERINGTYPE, IFCCOLUMNTYPE, IFCBUILDINGELEMENTTYPE, IFCTRANSPORTELEMENTTYPE, IFCSPACETYPE, IFCSPATIALSTRUCTUREELEMENTTYPE, IFCSYSTEMFURNITUREELEMENTTYPE, IFCFURNITURETYPE, IFCFURNISHINGELEMENTTYPE, IFCELEMENTTYPE, IFCDOORSTYLE, IFCWINDOWSTYLE],
  3288037868: [IFCPROJECTIONCURVE, IFCDIMENSIONCURVE],
  2736907675: [IFCBOOLEANCLIPPINGRESULT],
  4182860854: [IFCRECTANGULARTRIMMEDSURFACE, IFCCURVEBOUNDEDPLANE],
  59481748: [IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM, IFCCARTESIANTRANSFORMATIONOPERATOR3D, IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM, IFCCARTESIANTRANSFORMATIONOPERATOR2D],
  3749851601: [IFCCARTESIANTRANSFORMATIONOPERATOR2DNONUNIFORM],
  3331915920: [IFCCARTESIANTRANSFORMATIONOPERATOR3DNONUNIFORM],
  1383045692: [IFCCIRCLEHOLLOWPROFILEDEF],
  2506170314: [IFCBLOCK, IFCSPHERE, IFCRIGHTCIRCULARCYLINDER, IFCRIGHTCIRCULARCONE, IFCRECTANGULARPYRAMID],
  2601014836: [IFCCIRCLE, IFCELLIPSE, IFCCONIC, IFCRATIONALBEZIERCURVE, IFCBEZIERCURVE, IFCBSPLINECURVE, IFCTRIMMEDCURVE, IFCPOLYLINE, IFC2DCOMPOSITECURVE, IFCCOMPOSITECURVE, IFCBOUNDEDCURVE, IFCOFFSETCURVE3D, IFCOFFSETCURVE2D, IFCLINE],
  3073041342: [IFCDIAMETERDIMENSION, IFCANGULARDIMENSION, IFCRADIUSDIMENSION, IFCLINEARDIMENSION, IFCDIMENSIONCURVEDIRECTEDCALLOUT, IFCSTRUCTUREDDIMENSIONCALLOUT],
  339256511: [IFCVIBRATIONISOLATORTYPE, IFCDISCRETEACCESSORYTYPE, IFCMECHANICALFASTENERTYPE, IFCFASTENERTYPE, IFCELEMENTCOMPONENTTYPE, IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE, IFCDISTRIBUTIONCONTROLELEMENTTYPE, IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE, IFCDISTRIBUTIONFLOWELEMENTTYPE, IFCDISTRIBUTIONELEMENTTYPE, IFCBUILDINGELEMENTPROXYTYPE, IFCBEAMTYPE, IFCWALLTYPE, IFCSTAIRFLIGHTTYPE, IFCSLABTYPE, IFCRAMPFLIGHTTYPE, IFCRAILINGTYPE, IFCPLATETYPE, IFCMEMBERTYPE, IFCCURTAINWALLTYPE, IFCCOVERINGTYPE, IFCCOLUMNTYPE, IFCBUILDINGELEMENTTYPE, IFCTRANSPORTELEMENTTYPE, IFCSPACETYPE, IFCSPATIALSTRUCTUREELEMENTTYPE, IFCSYSTEMFURNITUREELEMENTTYPE, IFCFURNITURETYPE, IFCFURNISHINGELEMENTTYPE],
  2777663545: [IFCPLANE],
  80994333: [IFCELECTRICALBASEPROPERTIES],
  4238390223: [IFCSYSTEMFURNITUREELEMENTTYPE, IFCFURNITURETYPE],
  1484403080: [IFCASYMMETRICISHAPEPROFILEDEF],
  1425443689: [IFCFACETEDBREPWITHVOIDS, IFCFACETEDBREP],
  3888040117: [IFCCONDITION, IFCASSET, IFCZONE, IFCSTRUCTURALANALYSISMODEL, IFCELECTRICALCIRCUIT, IFCSYSTEM, IFCSTRUCTURALRESULTGROUP, IFCSTRUCTURALLOADGROUP, IFCINVENTORY, IFCGROUP, IFCCONDITIONCRITERION, IFCACTIONREQUEST, IFCWORKSCHEDULE, IFCWORKPLAN, IFCWORKCONTROL, IFCTIMESERIESSCHEDULE, IFCSPACEPROGRAM, IFCSERVICELIFE, IFCSCHEDULETIMECONTROL, IFCPROJECTORDERRECORD, IFCPROJECTORDER, IFCPERMIT, IFCPERFORMANCEHISTORY, IFCFURNITURESTANDARD, IFCEQUIPMENTSTANDARD, IFCCOSTSCHEDULE, IFCCOSTITEM, IFCCONTROL, IFCOCCUPANT, IFCACTOR, IFCCONSTRUCTIONPRODUCTRESOURCE, IFCCONSTRUCTIONMATERIALRESOURCE, IFCCONSTRUCTIONEQUIPMENTRESOURCE, IFCSUBCONTRACTRESOURCE, IFCLABORRESOURCE, IFCCREWRESOURCE, IFCCONSTRUCTIONRESOURCE, IFCRESOURCE, IFCPROJECT, IFCDISTRIBUTIONPORT, IFCPORT, IFCGRID, IFCELECTRICALELEMENT, IFCDISTRIBUTIONCONTROLELEMENT, IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE, IFCDISTRIBUTIONFLOWELEMENT, IFCDISTRIBUTIONELEMENT, IFCBEAM, IFCWINDOW, IFCWALLSTANDARDCASE, IFCWALL, IFCSTAIRFLIGHT, IFCSTAIR, IFCSLAB, IFCROOF, IFCRAMPFLIGHT, IFCRAMP, IFCRAILING, IFCPLATE, IFCPILE, IFCMEMBER, IFCFOOTING, IFCDOOR, IFCCURTAINWALL, IFCCOVERING, IFCCOLUMN, IFCBUILDINGELEMENTPROXY, IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART, IFCBUILDINGELEMENTCOMPONENT, IFCBUILDINGELEMENT, IFCVIRTUALELEMENT, IFCTRANSPORTELEMENT, IFCFURNISHINGELEMENT, IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT, IFCFEATUREELEMENTSUBTRACTION, IFCPROJECTIONELEMENT, IFCFEATUREELEMENTADDITION, IFCFEATUREELEMENT, IFCEQUIPMENTELEMENT, IFCDISCRETEACCESSORY, IFCMECHANICALFASTENER, IFCFASTENER, IFCELEMENTCOMPONENT, IFCELEMENTASSEMBLY, IFCELEMENT, IFCANNOTATION, IFCSTRUCTURALSURFACECONNECTION, IFCSTRUCTURALPOINTCONNECTION, IFCSTRUCTURALCURVECONNECTION, IFCSTRUCTURALCONNECTION, IFCSTRUCTURALCURVEMEMBERVARYING, IFCSTRUCTURALCURVEMEMBER, IFCSTRUCTURALSURFACEMEMBERVARYING, IFCSTRUCTURALSURFACEMEMBER, IFCSTRUCTURALMEMBER, IFCSTRUCTURALITEM, IFCSTRUCTURALPOINTACTION, IFCSTRUCTURALPLANARACTIONVARYING, IFCSTRUCTURALPLANARACTION, IFCSTRUCTURALLINEARACTIONVARYING, IFCSTRUCTURALLINEARACTION, IFCSTRUCTURALACTION, IFCSTRUCTURALPOINTREACTION, IFCSTRUCTURALREACTION, IFCSTRUCTURALACTIVITY, IFCSPACE, IFCSITE, IFCBUILDINGSTOREY, IFCBUILDING, IFCSPATIALSTRUCTUREELEMENT, IFCPROXY, IFCPRODUCT, IFCPROCEDURE, IFCORDERACTION, IFCMOVE, IFCTASK, IFCPROCESS],
  2945172077: [IFCPROCEDURE, IFCORDERACTION, IFCMOVE, IFCTASK],
  4208778838: [IFCDISTRIBUTIONPORT, IFCPORT, IFCGRID, IFCELECTRICALELEMENT, IFCDISTRIBUTIONCONTROLELEMENT, IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE, IFCDISTRIBUTIONFLOWELEMENT, IFCDISTRIBUTIONELEMENT, IFCBEAM, IFCWINDOW, IFCWALLSTANDARDCASE, IFCWALL, IFCSTAIRFLIGHT, IFCSTAIR, IFCSLAB, IFCROOF, IFCRAMPFLIGHT, IFCRAMP, IFCRAILING, IFCPLATE, IFCPILE, IFCMEMBER, IFCFOOTING, IFCDOOR, IFCCURTAINWALL, IFCCOVERING, IFCCOLUMN, IFCBUILDINGELEMENTPROXY, IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART, IFCBUILDINGELEMENTCOMPONENT, IFCBUILDINGELEMENT, IFCVIRTUALELEMENT, IFCTRANSPORTELEMENT, IFCFURNISHINGELEMENT, IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT, IFCFEATUREELEMENTSUBTRACTION, IFCPROJECTIONELEMENT, IFCFEATUREELEMENTADDITION, IFCFEATUREELEMENT, IFCEQUIPMENTELEMENT, IFCDISCRETEACCESSORY, IFCMECHANICALFASTENER, IFCFASTENER, IFCELEMENTCOMPONENT, IFCELEMENTASSEMBLY, IFCELEMENT, IFCANNOTATION, IFCSTRUCTURALSURFACECONNECTION, IFCSTRUCTURALPOINTCONNECTION, IFCSTRUCTURALCURVECONNECTION, IFCSTRUCTURALCONNECTION, IFCSTRUCTURALCURVEMEMBERVARYING, IFCSTRUCTURALCURVEMEMBER, IFCSTRUCTURALSURFACEMEMBERVARYING, IFCSTRUCTURALSURFACEMEMBER, IFCSTRUCTURALMEMBER, IFCSTRUCTURALITEM, IFCSTRUCTURALPOINTACTION, IFCSTRUCTURALPLANARACTIONVARYING, IFCSTRUCTURALPLANARACTION, IFCSTRUCTURALLINEARACTIONVARYING, IFCSTRUCTURALLINEARACTION, IFCSTRUCTURALACTION, IFCSTRUCTURALPOINTREACTION, IFCSTRUCTURALREACTION, IFCSTRUCTURALACTIVITY, IFCSPACE, IFCSITE, IFCBUILDINGSTOREY, IFCBUILDING, IFCSPATIALSTRUCTUREELEMENT, IFCPROXY],
  3939117080: [IFCRELASSIGNSTORESOURCE, IFCRELASSIGNSTOPRODUCT, IFCRELASSIGNSTOPROCESS, IFCRELASSIGNSTOGROUP, IFCRELASSIGNSTASKS, IFCRELSCHEDULESCOSTITEMS, IFCRELASSIGNSTOPROJECTORDER, IFCRELASSIGNSTOCONTROL, IFCRELOCCUPIESSPACES, IFCRELASSIGNSTOACTOR],
  1683148259: [IFCRELOCCUPIESSPACES],
  2495723537: [IFCRELASSIGNSTASKS, IFCRELSCHEDULESCOSTITEMS, IFCRELASSIGNSTOPROJECTORDER],
  1865459582: [IFCRELASSOCIATESPROFILEPROPERTIES, IFCRELASSOCIATESMATERIAL, IFCRELASSOCIATESLIBRARY, IFCRELASSOCIATESDOCUMENT, IFCRELASSOCIATESCONSTRAINT, IFCRELASSOCIATESCLASSIFICATION, IFCRELASSOCIATESAPPROVAL, IFCRELASSOCIATESAPPLIEDVALUE],
  826625072: [IFCRELVOIDSELEMENT, IFCRELSPACEBOUNDARY, IFCRELSERVICESBUILDINGS, IFCRELSEQUENCE, IFCRELREFERENCEDINSPATIALSTRUCTURE, IFCRELPROJECTSELEMENT, IFCRELINTERACTIONREQUIREMENTS, IFCRELFLOWCONTROLELEMENTS, IFCRELFILLSELEMENT, IFCRELCOVERSSPACES, IFCRELCOVERSBLDGELEMENTS, IFCRELCONTAINEDINSPATIALSTRUCTURE, IFCRELCONNECTSWITHECCENTRICITY, IFCRELCONNECTSSTRUCTURALMEMBER, IFCRELCONNECTSSTRUCTURALELEMENT, IFCRELCONNECTSSTRUCTURALACTIVITY, IFCRELCONNECTSPORTS, IFCRELCONNECTSPORTTOELEMENT, IFCRELCONNECTSWITHREALIZINGELEMENTS, IFCRELCONNECTSPATHELEMENTS, IFCRELCONNECTSELEMENTS],
  1204542856: [IFCRELCONNECTSWITHREALIZINGELEMENTS, IFCRELCONNECTSPATHELEMENTS],
  1638771189: [IFCRELCONNECTSWITHECCENTRICITY],
  2551354335: [IFCRELAGGREGATES, IFCRELNESTS],
  693640335: [IFCRELDEFINESBYTYPE, IFCRELOVERRIDESPROPERTIES, IFCRELDEFINESBYPROPERTIES],
  4186316022: [IFCRELOVERRIDESPROPERTIES],
  2914609552: [IFCCONSTRUCTIONPRODUCTRESOURCE, IFCCONSTRUCTIONMATERIALRESOURCE, IFCCONSTRUCTIONEQUIPMENTRESOURCE, IFCSUBCONTRACTRESOURCE, IFCLABORRESOURCE, IFCCREWRESOURCE, IFCCONSTRUCTIONRESOURCE],
  2706606064: [IFCSPACE, IFCSITE, IFCBUILDINGSTOREY, IFCBUILDING],
  3893378262: [IFCSPACETYPE],
  3544373492: [IFCSTRUCTURALPOINTACTION, IFCSTRUCTURALPLANARACTIONVARYING, IFCSTRUCTURALPLANARACTION, IFCSTRUCTURALLINEARACTIONVARYING, IFCSTRUCTURALLINEARACTION, IFCSTRUCTURALACTION, IFCSTRUCTURALPOINTREACTION, IFCSTRUCTURALREACTION],
  3136571912: [IFCSTRUCTURALSURFACECONNECTION, IFCSTRUCTURALPOINTCONNECTION, IFCSTRUCTURALCURVECONNECTION, IFCSTRUCTURALCONNECTION, IFCSTRUCTURALCURVEMEMBERVARYING, IFCSTRUCTURALCURVEMEMBER, IFCSTRUCTURALSURFACEMEMBERVARYING, IFCSTRUCTURALSURFACEMEMBER, IFCSTRUCTURALMEMBER],
  530289379: [IFCSTRUCTURALCURVEMEMBERVARYING, IFCSTRUCTURALCURVEMEMBER, IFCSTRUCTURALSURFACEMEMBERVARYING, IFCSTRUCTURALSURFACEMEMBER],
  3689010777: [IFCSTRUCTURALPOINTREACTION],
  3979015343: [IFCSTRUCTURALSURFACEMEMBERVARYING],
  3473067441: [IFCORDERACTION, IFCMOVE],
  2296667514: [IFCOCCUPANT],
  1260505505: [IFCRATIONALBEZIERCURVE, IFCBEZIERCURVE, IFCBSPLINECURVE, IFCTRIMMEDCURVE, IFCPOLYLINE, IFC2DCOMPOSITECURVE, IFCCOMPOSITECURVE],
  1950629157: [IFCBUILDINGELEMENTPROXYTYPE, IFCBEAMTYPE, IFCWALLTYPE, IFCSTAIRFLIGHTTYPE, IFCSLABTYPE, IFCRAMPFLIGHTTYPE, IFCRAILINGTYPE, IFCPLATETYPE, IFCMEMBERTYPE, IFCCURTAINWALLTYPE, IFCCOVERINGTYPE, IFCCOLUMNTYPE],
  3732776249: [IFC2DCOMPOSITECURVE],
  2510884976: [IFCCIRCLE, IFCELLIPSE],
  2559216714: [IFCCONSTRUCTIONPRODUCTRESOURCE, IFCCONSTRUCTIONMATERIALRESOURCE, IFCCONSTRUCTIONEQUIPMENTRESOURCE, IFCSUBCONTRACTRESOURCE, IFCLABORRESOURCE, IFCCREWRESOURCE],
  3293443760: [IFCCONDITIONCRITERION, IFCACTIONREQUEST, IFCWORKSCHEDULE, IFCWORKPLAN, IFCWORKCONTROL, IFCTIMESERIESSCHEDULE, IFCSPACEPROGRAM, IFCSERVICELIFE, IFCSCHEDULETIMECONTROL, IFCPROJECTORDERRECORD, IFCPROJECTORDER, IFCPERMIT, IFCPERFORMANCEHISTORY, IFCFURNITURESTANDARD, IFCEQUIPMENTSTANDARD, IFCCOSTSCHEDULE, IFCCOSTITEM],
  681481545: [IFCDIAMETERDIMENSION, IFCANGULARDIMENSION, IFCRADIUSDIMENSION, IFCLINEARDIMENSION],
  3256556792: [IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE, IFCDISTRIBUTIONCONTROLELEMENTTYPE, IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE, IFCDISTRIBUTIONFLOWELEMENTTYPE],
  3849074793: [IFCDISTRIBUTIONCHAMBERELEMENTTYPE, IFCFILTERTYPE, IFCDUCTSILENCERTYPE, IFCFLOWTREATMENTDEVICETYPE, IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE, IFCFLOWTERMINALTYPE, IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE, IFCFLOWSTORAGEDEVICETYPE, IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE, IFCFLOWSEGMENTTYPE, IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE, IFCFLOWMOVINGDEVICETYPE, IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE, IFCFLOWFITTINGTYPE, IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE, IFCFLOWCONTROLLERTYPE, IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE, IFCENERGYCONVERSIONDEVICETYPE],
  1758889154: [IFCELECTRICALELEMENT, IFCDISTRIBUTIONCONTROLELEMENT, IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE, IFCDISTRIBUTIONFLOWELEMENT, IFCDISTRIBUTIONELEMENT, IFCBEAM, IFCWINDOW, IFCWALLSTANDARDCASE, IFCWALL, IFCSTAIRFLIGHT, IFCSTAIR, IFCSLAB, IFCROOF, IFCRAMPFLIGHT, IFCRAMP, IFCRAILING, IFCPLATE, IFCPILE, IFCMEMBER, IFCFOOTING, IFCDOOR, IFCCURTAINWALL, IFCCOVERING, IFCCOLUMN, IFCBUILDINGELEMENTPROXY, IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART, IFCBUILDINGELEMENTCOMPONENT, IFCBUILDINGELEMENT, IFCVIRTUALELEMENT, IFCTRANSPORTELEMENT, IFCFURNISHINGELEMENT, IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT, IFCFEATUREELEMENTSUBTRACTION, IFCPROJECTIONELEMENT, IFCFEATUREELEMENTADDITION, IFCFEATUREELEMENT, IFCEQUIPMENTELEMENT, IFCDISCRETEACCESSORY, IFCMECHANICALFASTENER, IFCFASTENER, IFCELEMENTCOMPONENT, IFCELEMENTASSEMBLY],
  1623761950: [IFCDISCRETEACCESSORY, IFCMECHANICALFASTENER, IFCFASTENER],
  2590856083: [IFCVIBRATIONISOLATORTYPE, IFCDISCRETEACCESSORYTYPE, IFCMECHANICALFASTENERTYPE, IFCFASTENERTYPE],
  2107101300: [IFCELECTRICMOTORTYPE, IFCELECTRICGENERATORTYPE, IFCCOOLINGTOWERTYPE, IFCCOOLEDBEAMTYPE, IFCCONDENSERTYPE, IFCCOILTYPE, IFCCHILLERTYPE, IFCBOILERTYPE, IFCAIRTOAIRHEATRECOVERYTYPE, IFCUNITARYEQUIPMENTTYPE, IFCTUBEBUNDLETYPE, IFCTRANSFORMERTYPE, IFCSPACEHEATERTYPE, IFCMOTORCONNECTIONTYPE, IFCHUMIDIFIERTYPE, IFCHEATEXCHANGERTYPE, IFCEVAPORATORTYPE, IFCEVAPORATIVECOOLERTYPE],
  647756555: [IFCMECHANICALFASTENER],
  2489546625: [IFCMECHANICALFASTENERTYPE],
  2827207264: [IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT, IFCFEATUREELEMENTSUBTRACTION, IFCPROJECTIONELEMENT, IFCFEATUREELEMENTADDITION],
  2143335405: [IFCPROJECTIONELEMENT],
  1287392070: [IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE, IFCEDGEFEATURE, IFCOPENINGELEMENT],
  3907093117: [IFCELECTRICTIMECONTROLTYPE, IFCDAMPERTYPE, IFCAIRTERMINALBOXTYPE, IFCVALVETYPE, IFCSWITCHINGDEVICETYPE, IFCPROTECTIVEDEVICETYPE, IFCFLOWMETERTYPE],
  3198132628: [IFCDUCTFITTINGTYPE, IFCCABLECARRIERFITTINGTYPE, IFCPIPEFITTINGTYPE, IFCJUNCTIONBOXTYPE],
  1482959167: [IFCFANTYPE, IFCCOMPRESSORTYPE, IFCPUMPTYPE],
  1834744321: [IFCDUCTSEGMENTTYPE, IFCCABLESEGMENTTYPE, IFCCABLECARRIERSEGMENTTYPE, IFCPIPESEGMENTTYPE],
  1339347760: [IFCELECTRICFLOWSTORAGEDEVICETYPE, IFCTANKTYPE],
  2297155007: [IFCFIRESUPPRESSIONTERMINALTYPE, IFCELECTRICHEATERTYPE, IFCELECTRICAPPLIANCETYPE, IFCAIRTERMINALTYPE, IFCWASTETERMINALTYPE, IFCSTACKTERMINALTYPE, IFCSANITARYTERMINALTYPE, IFCOUTLETTYPE, IFCLIGHTFIXTURETYPE, IFCLAMPTYPE, IFCGASTERMINALTYPE],
  3009222698: [IFCFILTERTYPE, IFCDUCTSILENCERTYPE],
  2706460486: [IFCCONDITION, IFCASSET, IFCZONE, IFCSTRUCTURALANALYSISMODEL, IFCELECTRICALCIRCUIT, IFCSYSTEM, IFCSTRUCTURALRESULTGROUP, IFCSTRUCTURALLOADGROUP, IFCINVENTORY],
  3740093272: [IFCDISTRIBUTIONPORT],
  682877961: [IFCSTRUCTURALPOINTACTION, IFCSTRUCTURALPLANARACTIONVARYING, IFCSTRUCTURALPLANARACTION, IFCSTRUCTURALLINEARACTIONVARYING, IFCSTRUCTURALLINEARACTION],
  1179482911: [IFCSTRUCTURALSURFACECONNECTION, IFCSTRUCTURALPOINTCONNECTION, IFCSTRUCTURALCURVECONNECTION],
  214636428: [IFCSTRUCTURALCURVEMEMBERVARYING],
  1807405624: [IFCSTRUCTURALLINEARACTIONVARYING],
  1621171031: [IFCSTRUCTURALPLANARACTIONVARYING],
  2254336722: [IFCSTRUCTURALANALYSISMODEL, IFCELECTRICALCIRCUIT],
  1028945134: [IFCWORKSCHEDULE, IFCWORKPLAN],
  1967976161: [IFCRATIONALBEZIERCURVE, IFCBEZIERCURVE],
  1916977116: [IFCRATIONALBEZIERCURVE],
  3299480353: [IFCBEAM, IFCWINDOW, IFCWALLSTANDARDCASE, IFCWALL, IFCSTAIRFLIGHT, IFCSTAIR, IFCSLAB, IFCROOF, IFCRAMPFLIGHT, IFCRAMP, IFCRAILING, IFCPLATE, IFCPILE, IFCMEMBER, IFCFOOTING, IFCDOOR, IFCCURTAINWALL, IFCCOVERING, IFCCOLUMN, IFCBUILDINGELEMENTPROXY, IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART, IFCBUILDINGELEMENTCOMPONENT],
  52481810: [IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH, IFCREINFORCINGELEMENT, IFCBUILDINGELEMENTPART],
  2635815018: [IFCVIBRATIONISOLATORTYPE],
  2063403501: [IFCCONTROLLERTYPE, IFCALARMTYPE, IFCACTUATORTYPE, IFCSENSORTYPE, IFCFLOWINSTRUMENTTYPE],
  1945004755: [IFCDISTRIBUTIONCONTROLELEMENT, IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE, IFCDISTRIBUTIONFLOWELEMENT],
  3040386961: [IFCDISTRIBUTIONCHAMBERELEMENT, IFCFLOWTREATMENTDEVICE, IFCFLOWTERMINAL, IFCFLOWSTORAGEDEVICE, IFCFLOWSEGMENT, IFCFLOWMOVINGDEVICE, IFCFLOWFITTING, IFCELECTRICDISTRIBUTIONPOINT, IFCFLOWCONTROLLER, IFCENERGYCONVERSIONDEVICE],
  855621170: [IFCCHAMFEREDGEFEATURE, IFCROUNDEDEDGEFEATURE],
  2058353004: [IFCELECTRICDISTRIBUTIONPOINT],
  3027567501: [IFCREINFORCINGBAR, IFCTENDONANCHOR, IFCTENDON, IFCREINFORCINGMESH],
  2391406946: [IFCWALLSTANDARDCASE]
};
InversePropertyDef[1] = {
  618182010: [["OfPerson", IFCPERSON, 7, true], ["OfOrganization", IFCORGANIZATION, 4, true]],
  411424972: [["ValuesReferenced", IFCREFERENCESVALUEDOCUMENT, 1, true], ["ValueOfComponents", IFCAPPLIEDVALUERELATIONSHIP, 0, true], ["IsComponentIn", IFCAPPLIEDVALUERELATIONSHIP, 1, true]],
  130549933: [["Actors", IFCAPPROVALACTORRELATIONSHIP, 1, true], ["IsRelatedWith", IFCAPPROVALRELATIONSHIP, 0, true], ["Relates", IFCAPPROVALRELATIONSHIP, 1, true]],
  747523909: [["Contains", IFCCLASSIFICATIONITEM, 1, true]],
  1767535486: [["IsClassifiedItemIn", IFCCLASSIFICATIONITEMRELATIONSHIP, 1, true], ["IsClassifyingItemIn", IFCCLASSIFICATIONITEMRELATIONSHIP, 0, true]],
  1959218052: [["ClassifiedAs", IFCCONSTRAINTCLASSIFICATIONRELATIONSHIP, 0, true], ["RelatesConstraints", IFCCONSTRAINTRELATIONSHIP, 2, true], ["IsRelatedWith", IFCCONSTRAINTRELATIONSHIP, 3, true], ["PropertiesForConstraint", IFCPROPERTYCONSTRAINTRELATIONSHIP, 0, true], ["Aggregates", IFCCONSTRAINTAGGREGATIONRELATIONSHIP, 2, true], ["IsAggregatedIn", IFCCONSTRAINTAGGREGATIONRELATIONSHIP, 3, true]],
  602808272: [["ValuesReferenced", IFCREFERENCESVALUEDOCUMENT, 1, true], ["ValueOfComponents", IFCAPPLIEDVALUERELATIONSHIP, 0, true], ["IsComponentIn", IFCAPPLIEDVALUERELATIONSHIP, 1, true]],
  1154170062: [["IsPointedTo", IFCDOCUMENTINFORMATIONRELATIONSHIP, 1, true], ["IsPointer", IFCDOCUMENTINFORMATIONRELATIONSHIP, 0, true]],
  1648886627: [["ValuesReferenced", IFCREFERENCESVALUEDOCUMENT, 1, true], ["ValueOfComponents", IFCAPPLIEDVALUERELATIONSHIP, 0, true], ["IsComponentIn", IFCAPPLIEDVALUERELATIONSHIP, 1, true]],
  852622518: [["PartOfW", IFCGRID, 9, true], ["PartOfV", IFCGRID, 8, true], ["PartOfU", IFCGRID, 7, true], ["HasIntersections", IFCVIRTUALGRIDINTERSECTION, 0, true]],
  3452421091: [["ReferenceIntoLibrary", IFCLIBRARYINFORMATION, 4, true]],
  1838606355: [["HasRepresentation", IFCMATERIALDEFINITIONREPRESENTATION, 3, true], ["ClassifiedAs", IFCMATERIALCLASSIFICATIONRELATIONSHIP, 1, true]],
  248100487: [["ToMaterialLayerSet", IFCMATERIALLAYERSET, 0, false]],
  3368373690: [["ClassifiedAs", IFCCONSTRAINTCLASSIFICATIONRELATIONSHIP, 0, true], ["RelatesConstraints", IFCCONSTRAINTRELATIONSHIP, 2, true], ["IsRelatedWith", IFCCONSTRAINTRELATIONSHIP, 3, true], ["PropertiesForConstraint", IFCPROPERTYCONSTRAINTRELATIONSHIP, 0, true], ["Aggregates", IFCCONSTRAINTAGGREGATIONRELATIONSHIP, 2, true], ["IsAggregatedIn", IFCCONSTRAINTAGGREGATIONRELATIONSHIP, 3, true]],
  3701648758: [["PlacesObject", IFCPRODUCT, 5, true], ["ReferencedByPlacements", IFCLOCALPLACEMENT, 0, true]],
  2251480897: [["ClassifiedAs", IFCCONSTRAINTCLASSIFICATIONRELATIONSHIP, 0, true], ["RelatesConstraints", IFCCONSTRAINTRELATIONSHIP, 2, true], ["IsRelatedWith", IFCCONSTRAINTRELATIONSHIP, 3, true], ["PropertiesForConstraint", IFCPROPERTYCONSTRAINTRELATIONSHIP, 0, true], ["Aggregates", IFCCONSTRAINTAGGREGATIONRELATIONSHIP, 2, true], ["IsAggregatedIn", IFCCONSTRAINTAGGREGATIONRELATIONSHIP, 3, true]],
  4251960020: [["IsRelatedBy", IFCORGANIZATIONRELATIONSHIP, 3, true], ["Relates", IFCORGANIZATIONRELATIONSHIP, 2, true], ["Engages", IFCPERSONANDORGANIZATION, 1, true]],
  2077209135: [["EngagedIn", IFCPERSONANDORGANIZATION, 0, true]],
  2483315170: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  2226359599: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  3355820592: [["OfPerson", IFCPERSON, 7, true], ["OfOrganization", IFCORGANIZATION, 4, true]],
  2598011224: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  2044713172: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  2093928680: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  931644368: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  3252649465: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  2405470396: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  825690147: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  1076942058: [["RepresentationMap", IFCREPRESENTATIONMAP, 1, true], ["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["OfProductRepresentation", IFCPRODUCTREPRESENTATION, 2, true]],
  3377609919: [["RepresentationsInContext", IFCREPRESENTATION, 0, true]],
  3008791417: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1660063152: [["MapUsage", IFCMAPPEDITEM, 0, true]],
  3982875396: [["RepresentationMap", IFCREPRESENTATIONMAP, 1, true], ["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["OfProductRepresentation", IFCPRODUCTREPRESENTATION, 2, true], ["OfShapeAspect", IFCSHAPEASPECT, 0, true]],
  4240577450: [["RepresentationMap", IFCREPRESENTATIONMAP, 1, true], ["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["OfProductRepresentation", IFCPRODUCTREPRESENTATION, 2, true], ["OfShapeAspect", IFCSHAPEASPECT, 0, true]],
  3692461612: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  2830218821: [["RepresentationMap", IFCREPRESENTATIONMAP, 1, true], ["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["OfProductRepresentation", IFCPRODUCTREPRESENTATION, 2, true]],
  3958052878: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3049322572: [["RepresentationMap", IFCREPRESENTATIONMAP, 1, true], ["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["OfProductRepresentation", IFCPRODUCTREPRESENTATION, 2, true]],
  531007025: [["OfTable", IFCTABLE, 1, false]],
  912023232: [["OfPerson", IFCPERSON, 7, true], ["OfOrganization", IFCORGANIZATION, 4, true]],
  280115917: [["AnnotatedSurface", IFCANNOTATIONSURFACE, 1, true]],
  1742049831: [["AnnotatedSurface", IFCANNOTATIONSURFACE, 1, true]],
  2552916305: [["AnnotatedSurface", IFCANNOTATIONSURFACE, 1, true]],
  3101149627: [["DocumentedBy", IFCTIMESERIESREFERENCERELATIONSHIP, 0, true]],
  1377556343: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1735638870: [["RepresentationMap", IFCREPRESENTATIONMAP, 1, true], ["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["OfProductRepresentation", IFCPRODUCTREPRESENTATION, 2, true], ["OfShapeAspect", IFCSHAPEASPECT, 0, true]],
  2799835756: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1907098498: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2442683028: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  962685235: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3612888222: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2297822566: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2542286263: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  370225590: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3732053477: [["ReferenceToDocument", IFCDOCUMENTINFORMATION, 3, true]],
  3900360178: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  476780140: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2556980723: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1809719519: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  803316827: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3008276851: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3448662350: [["RepresentationsInContext", IFCREPRESENTATION, 0, true], ["HasSubContexts", IFCGEOMETRICREPRESENTATIONSUBCONTEXT, 6, true]],
  2453401579: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4142052618: [["RepresentationsInContext", IFCREPRESENTATION, 0, true], ["HasSubContexts", IFCGEOMETRICREPRESENTATIONSUBCONTEXT, 6, true]],
  3590301190: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  178086475: [["PlacesObject", IFCPRODUCT, 5, true], ["ReferencedByPlacements", IFCLOCALPLACEMENT, 0, true]],
  812098782: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3741457305: [["DocumentedBy", IFCTIMESERIESREFERENCERELATIONSHIP, 0, true]],
  1402838566: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  125510826: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2604431987: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4266656042: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1520743889: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3422422726: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2624227202: [["PlacesObject", IFCPRODUCT, 5, true], ["ReferencedByPlacements", IFCLOCALPLACEMENT, 0, true]],
  1008929658: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2347385850: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  219451334: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true]],
  2833995503: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2665983363: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1029017970: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2519244187: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3021840470: [["PartOfComplex", IFCPHYSICALCOMPLEXQUANTITY, 2, true]],
  2004835150: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1663979128: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2067069095: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4022376103: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1423911732: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2924175390: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2775532180: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  673634403: [["ShapeOfProduct", IFCPRODUCT, 6, true], ["HasShapeAspects", IFCSHAPEASPECT, 4, true]],
  871118103: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  1680319473: [["HasAssociations", IFCRELASSOCIATES, 4, true]],
  4166981789: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  2752243245: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  941946838: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  3357820518: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  3650150729: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  110355661: [["PropertyForDependance", IFCPROPERTYDEPENDENCYRELATIONSHIP, 0, true], ["PropertyDependsOn", IFCPROPERTYDEPENDENCYRELATIONSHIP, 1, true], ["PartOfComplex", IFCCOMPLEXPROPERTY, 3, true]],
  3413951693: [["DocumentedBy", IFCTIMESERIESREFERENCERELATIONSHIP, 0, true]],
  3765753017: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  1509187699: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2411513650: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  4124623270: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  723233188: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2485662743: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  1202362311: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  390701378: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  2233826070: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2513912981: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2247615214: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1260650574: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  230924584: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3028897424: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4282788508: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3124975700: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1345879162: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1628702193: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2347495698: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1417489154: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2759199220: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  336235671: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  512836454: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  1299126871: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3288037868: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  669184980: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2265737646: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1302238472: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4261334040: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3125803723: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2740243338: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2736907675: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4182860854: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2581212453: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2713105998: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1123145078: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  59481748: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3749851601: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3486308946: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3331915920: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1416205885: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2205249479: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2485617015: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["UsingCurves", IFCCOMPOSITECURVE, 0, true]],
  2506170314: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2147822146: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2601014836: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2827736869: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  693772133: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  606661476: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["AnnotatedBySymbols", IFCTERMINATORSYMBOL, 3, true]],
  4054601972: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  32440307: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2963535650: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  1714330368: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  526551008: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3073041342: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  1472233963: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1883228015: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  339256511: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2777663545: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  80994333: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  477187591: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2047409740: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  374418227: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4203026998: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  315944413: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3455213021: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  4238390223: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1268542332: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  987898635: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1281925730: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1425443689: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3888040117: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true]],
  3388369263: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3505215534: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3566463478: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  603570806: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  220341763: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2945172077: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["OperatesOn", IFCRELASSIGNSTOPROCESS, 6, true], ["IsSuccessorFrom", IFCRELSEQUENCE, 5, true], ["IsPredecessorTo", IFCRELSEQUENCE, 4, true]],
  4208778838: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true]],
  103090709: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true]],
  4194566429: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1451395588: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  3219374653: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true]],
  2798486643: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3454111270: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2914609552: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  1856042241: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4158566097: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3626867408: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2706606064: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ReferencesElements", IFCRELREFERENCEDINSPATIALSTRUCTURE, 5, true], ["ServicedBySystems", IFCRELSERVICESBUILDINGS, 5, true], ["ContainsElements", IFCRELCONTAINEDINSPATIALSTRUCTURE, 5, true]],
  3893378262: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  451544542: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3544373492: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  3136571912: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true]],
  530289379: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ReferencesElement", IFCRELCONNECTSSTRUCTURALELEMENT, 5, true], ["ConnectedBy", IFCRELCONNECTSSTRUCTURALMEMBER, 4, true]],
  3689010777: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false], ["Causes", IFCSTRUCTURALACTION, 10, true]],
  3979015343: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ReferencesElement", IFCRELCONNECTSSTRUCTURALELEMENT, 5, true], ["ConnectedBy", IFCRELCONNECTSSTRUCTURALMEMBER, 4, true]],
  2218152070: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ReferencesElement", IFCRELCONNECTSSTRUCTURALELEMENT, 5, true], ["ConnectedBy", IFCRELCONNECTSSTRUCTURALMEMBER, 4, true]],
  4070609034: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  2028607225: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2809605785: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4124788165: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1580310250: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3473067441: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["OperatesOn", IFCRELASSIGNSTOPROCESS, 6, true], ["IsSuccessorFrom", IFCRELSEQUENCE, 5, true], ["IsPredecessorTo", IFCRELSEQUENCE, 4, true]],
  2097647324: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2296667514: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsActingUpon", IFCRELASSIGNSTOACTOR, 6, true]],
  1674181508: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1334484129: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3649129432: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1260505505: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  4031249490: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ReferencesElements", IFCRELREFERENCEDINSPATIALSTRUCTURE, 5, true], ["ServicedBySystems", IFCRELSERVICESBUILDINGS, 5, true], ["ContainsElements", IFCRELCONTAINEDINSPATIALSTRUCTURE, 5, true]],
  1950629157: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3124254112: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ReferencesElements", IFCRELREFERENCEDINSPATIALSTRUCTURE, 5, true], ["ServicedBySystems", IFCRELSERVICESBUILDINGS, 5, true], ["ContainsElements", IFCRELCONTAINEDINSPATIALSTRUCTURE, 5, true]],
  300633059: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3732776249: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2510884976: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2559216714: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  3293443760: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3895139033: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  1419761937: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  1916426348: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3295246426: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  1457835157: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  681481545: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  3256556792: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3849074793: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  360485395: [["HasAssociations", IFCRELASSOCIATES, 4, true], ["PropertyDefinitionOf", IFCRELDEFINESBYPROPERTIES, 5, true], ["DefinesType", IFCTYPEOBJECT, 5, true]],
  1758889154: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  4123344466: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1623761950: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2590856083: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1704287377: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2107101300: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1962604670: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3272907226: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3174744832: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3390157468: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  807026263: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3737207727: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  647756555: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2489546625: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2827207264: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2143335405: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["ProjectsElements", IFCRELPROJECTSELEMENT, 5, false]],
  1287392070: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["VoidsElements", IFCRELVOIDSELEMENT, 5, false]],
  3907093117: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3198132628: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3815607619: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1482959167: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1834744321: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1339347760: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2297155007: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3009222698: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  263784265: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  814719939: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  200128114: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3009204131: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2706460486: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false]],
  1251058090: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1806887404: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2391368822: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false]],
  4288270099: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3827777499: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  1051575348: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1161773419: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2506943328: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  377706215: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2108223431: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3181161470: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  977012517: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1916936684: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["OperatesOn", IFCRELASSIGNSTOPROCESS, 6, true], ["IsSuccessorFrom", IFCRELSEQUENCE, 5, true], ["IsPredecessorTo", IFCRELSEQUENCE, 4, true]],
  4143007308: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsActingUpon", IFCRELASSIGNSTOACTOR, 6, true]],
  3588315303: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["VoidsElements", IFCRELVOIDSELEMENT, 5, false], ["HasFillings", IFCRELFILLSELEMENT, 4, true]],
  3425660407: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["OperatesOn", IFCRELASSIGNSTOPROCESS, 6, true], ["IsSuccessorFrom", IFCRELSEQUENCE, 5, true], ["IsPredecessorTo", IFCRELSEQUENCE, 4, true]],
  2837617999: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2382730787: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3327091369: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  804291784: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  4231323485: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  4017108033: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3724593414: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3740093272: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ContainedIn", IFCRELCONNECTSPORTTOELEMENT, 4, false], ["ConnectedFrom", IFCRELCONNECTSPORTS, 5, true], ["ConnectedTo", IFCRELCONNECTSPORTS, 4, true]],
  2744685151: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["OperatesOn", IFCRELASSIGNSTOPROCESS, 6, true], ["IsSuccessorFrom", IFCRELSEQUENCE, 5, true], ["IsPredecessorTo", IFCRELSEQUENCE, 4, true]],
  2904328755: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3642467123: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3651124850: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["ProjectsElements", IFCRELPROJECTSELEMENT, 5, false]],
  1842657554: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2250791053: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3248260540: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  2893384427: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2324767716: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1768891740: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3517283431: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true], ["ScheduleTimeControlAssigned", IFCRELASSIGNSTASKS, 7, false]],
  4105383287: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  4097777520: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ReferencesElements", IFCRELREFERENCEDINSPATIALSTRUCTURE, 5, true], ["ServicedBySystems", IFCRELSERVICESBUILDINGS, 5, true], ["ContainsElements", IFCRELCONTAINEDINSPATIALSTRUCTURE, 5, true]],
  2533589738: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3856911033: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ReferencesElements", IFCRELREFERENCEDINSPATIALSTRUCTURE, 5, true], ["ServicedBySystems", IFCRELSERVICESBUILDINGS, 5, true], ["ContainsElements", IFCRELCONTAINEDINSPATIALSTRUCTURE, 5, true], ["HasCoverings", IFCRELCOVERSSPACES, 4, true], ["BoundedBy", IFCRELSPACEBOUNDARY, 4, true]],
  1305183839: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  652456506: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true], ["HasInteractionReqsFrom", IFCRELINTERACTIONREQUIREMENTS, 7, true], ["HasInteractionReqsTo", IFCRELINTERACTIONREQUIREMENTS, 8, true]],
  3812236995: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3112655638: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1039846685: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  682877961: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  1179482911: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ConnectsStructuralMembers", IFCRELCONNECTSSTRUCTURALMEMBER, 5, true]],
  4243806635: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ConnectsStructuralMembers", IFCRELCONNECTSSTRUCTURALMEMBER, 5, true]],
  214636428: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ReferencesElement", IFCRELCONNECTSSTRUCTURALELEMENT, 5, true], ["ConnectedBy", IFCRELCONNECTSSTRUCTURALMEMBER, 4, true]],
  2445595289: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ReferencesElement", IFCRELCONNECTSSTRUCTURALELEMENT, 5, true], ["ConnectedBy", IFCRELCONNECTSSTRUCTURALMEMBER, 4, true]],
  1807405624: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  1721250024: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  1252848954: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false], ["SourceOfResultGroup", IFCSTRUCTURALRESULTGROUP, 6, true], ["LoadGroupFor", IFCSTRUCTURALANALYSISMODEL, 7, true]],
  1621171031: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  3987759626: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  2082059205: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false]],
  734778138: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ConnectsStructuralMembers", IFCRELCONNECTSSTRUCTURALMEMBER, 5, true]],
  1235345126: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedToStructuralItem", IFCRELCONNECTSSTRUCTURALACTIVITY, 5, false], ["Causes", IFCSTRUCTURALACTION, 10, true]],
  2986769608: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false], ["ResultGroupFor", IFCSTRUCTURALANALYSISMODEL, 8, true]],
  1975003073: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["AssignedStructuralActivity", IFCRELCONNECTSSTRUCTURALACTIVITY, 4, true], ["ConnectsStructuralMembers", IFCRELCONNECTSSTRUCTURALMEMBER, 5, true]],
  148013059: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  2315554128: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2254336722: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false], ["ServicesBuildings", IFCRELSERVICESBUILDINGS, 4, true]],
  5716631: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1637806684: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  1692211062: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1620046519: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3593883385: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  1600972822: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1911125066: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  728799441: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2769231204: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1898987631: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1133259667: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1028945134: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  4218914973: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3342526732: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  1033361043: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false]],
  1213861670: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3821786052: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  1411407467: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3352864051: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1871374353: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2470393545: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  3460190687: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false]],
  1967976161: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  819618141: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1916977116: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  231477066: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3299480353: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  52481810: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2979338954: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1095909175: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1909888760: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  395041908: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3293546465: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1285652485: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2951183804: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2611217952: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  2301859152: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  843113511: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3850581409: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2816379211: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2188551683: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false]],
  1163958913: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["Controls", IFCRELASSIGNSTOCONTROL, 6, true]],
  3898045240: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  1060000209: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  488727124: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ResourceOf", IFCRELASSIGNSTORESOURCE, 6, true]],
  335055490: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2954562838: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1973544240: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["CoversSpaces", IFCRELCOVERSSPACES, 5, true], ["Covers", IFCRELCOVERSBLDGELEMENTS, 5, true]],
  3495092785: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3961806047: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  4147604152: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true], ["IsRelatedFromCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 3, true], ["IsRelatedToCallout", IFCDRAUGHTINGCALLOUTRELATIONSHIP, 2, true]],
  1335981549: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2635815018: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1599208980: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2063403501: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1945004755: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3040386961: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  3041715199: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["ContainedIn", IFCRELCONNECTSPORTTOELEMENT, 4, false], ["ConnectedFrom", IFCRELCONNECTSPORTS, 5, true], ["ConnectedTo", IFCRELCONNECTSPORTS, 4, true]],
  395920057: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  869906466: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3760055223: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2030761528: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  855621170: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["VoidsElements", IFCRELVOIDSELEMENT, 5, false]],
  663422040: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3277789161: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1534661035: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1365060375: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1217240411: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  712377611: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1634875225: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false], ["ServicesBuildings", IFCRELSERVICESBUILDINGS, 4, true]],
  857184966: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1658829314: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  346874300: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1810631287: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  4222183408: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2058353004: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  4278956645: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  4037862832: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3132237377: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  987401354: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  707683696: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  2223149337: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  3508470533: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  900683007: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1073191201: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1687234759: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3171933400: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2262370178: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3024970846: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3283111854: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3055160366: [["LayerAssignments", IFCPRESENTATIONLAYERASSIGNMENT, 2, true], ["StyledByItem", IFCSTYLEDITEM, 0, true]],
  3027567501: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2320036040: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2016517767: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  1376911519: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["VoidsElements", IFCRELVOIDSELEMENT, 5, false]],
  1783015770: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1529196076: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  331165859: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  4252922144: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2515109513: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["IsGroupedBy", IFCRELASSIGNSTOGROUP, 6, false], ["ServicesBuildings", IFCRELSERVICESBUILDINGS, 4, true]],
  3824725483: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2347447852: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3313531582: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  2391406946: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3512223829: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  3304561284: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2874132201: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  3001207471: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  753842376: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]],
  2454782716: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["VoidsElements", IFCRELVOIDSELEMENT, 5, false]],
  578613899: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["ObjectTypeOf", IFCRELDEFINESBYTYPE, 5, true]],
  1052013943: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  1062813311: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["AssignedToFlowElement", IFCRELFLOWCONTROLELEMENTS, 4, true]],
  3700593921: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true], ["HasControlElements", IFCRELFLOWCONTROLELEMENTS, 5, true]],
  979691226: [["HasAssignments", IFCRELASSIGNS, 4, true], ["IsDecomposedBy", IFCRELDECOMPOSES, 4, true], ["Decomposes", IFCRELDECOMPOSES, 5, true], ["HasAssociations", IFCRELASSOCIATES, 4, true], ["IsDefinedBy", IFCRELDEFINES, 4, true], ["ReferencedBy", IFCRELASSIGNSTOPRODUCT, 6, true], ["HasStructuralMember", IFCRELCONNECTSSTRUCTURALELEMENT, 4, true], ["FillsVoids", IFCRELFILLSELEMENT, 5, true], ["ConnectedTo", IFCRELCONNECTSELEMENTS, 5, true], ["HasCoverings", IFCRELCOVERSBLDGELEMENTS, 4, true], ["HasProjections", IFCRELPROJECTSELEMENT, 4, true], ["ReferencedInStructures", IFCRELREFERENCEDINSPATIALSTRUCTURE, 4, true], ["HasPorts", IFCRELCONNECTSPORTTOELEMENT, 5, true], ["HasOpenings", IFCRELVOIDSELEMENT, 4, true], ["IsConnectionRealization", IFCRELCONNECTSWITHREALIZINGELEMENTS, 7, true], ["ProvidesBoundaries", IFCRELSPACEBOUNDARY, 5, true], ["ConnectedFrom", IFCRELCONNECTSELEMENTS, 6, true], ["ContainedInStructure", IFCRELCONTAINEDINSPATIALSTRUCTURE, 4, true]]
};
Constructors[1] = {
  3630933823: (a) => new IFC2X3.IfcActorRole(a[0], a[1], a[2]),
  618182010: (a) => new IFC2X3.IfcAddress(a[0], a[1], a[2]),
  639542469: (a) => new IFC2X3.IfcApplication(a[0], a[1], a[2], a[3]),
  411424972: (a) => new IFC2X3.IfcAppliedValue(a[0], a[1], a[2], a[3], a[4], a[5]),
  1110488051: (a) => new IFC2X3.IfcAppliedValueRelationship(a[0], a[1], a[2], a[3], a[4]),
  130549933: (a) => new IFC2X3.IfcApproval(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  2080292479: (a) => new IFC2X3.IfcApprovalActorRelationship(a[0], a[1], a[2]),
  390851274: (a) => new IFC2X3.IfcApprovalPropertyRelationship(a[0], a[1]),
  3869604511: (a) => new IFC2X3.IfcApprovalRelationship(a[0], a[1], a[2], a[3]),
  4037036970: (a) => new IFC2X3.IfcBoundaryCondition(a[0]),
  1560379544: (a) => new IFC2X3.IfcBoundaryEdgeCondition(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  3367102660: (a) => new IFC2X3.IfcBoundaryFaceCondition(a[0], a[1], a[2], a[3]),
  1387855156: (a) => new IFC2X3.IfcBoundaryNodeCondition(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  2069777674: (a) => new IFC2X3.IfcBoundaryNodeConditionWarping(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  622194075: (a) => new IFC2X3.IfcCalendarDate(a[0], a[1], a[2]),
  747523909: (a) => new IFC2X3.IfcClassification(a[0], a[1], a[2], a[3]),
  1767535486: (a) => new IFC2X3.IfcClassificationItem(a[0], a[1], a[2]),
  1098599126: (a) => new IFC2X3.IfcClassificationItemRelationship(a[0], a[1]),
  938368621: (a) => new IFC2X3.IfcClassificationNotation(a[0]),
  3639012971: (a) => new IFC2X3.IfcClassificationNotationFacet(a[0]),
  3264961684: (a) => new IFC2X3.IfcColourSpecification(a[0]),
  2859738748: (_) => new IFC2X3.IfcConnectionGeometry(),
  2614616156: (a) => new IFC2X3.IfcConnectionPointGeometry(a[0], a[1]),
  4257277454: (a) => new IFC2X3.IfcConnectionPortGeometry(a[0], a[1], a[2]),
  2732653382: (a) => new IFC2X3.IfcConnectionSurfaceGeometry(a[0], a[1]),
  1959218052: (a) => new IFC2X3.IfcConstraint(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1658513725: (a) => new IFC2X3.IfcConstraintAggregationRelationship(a[0], a[1], a[2], a[3], a[4]),
  613356794: (a) => new IFC2X3.IfcConstraintClassificationRelationship(a[0], a[1]),
  347226245: (a) => new IFC2X3.IfcConstraintRelationship(a[0], a[1], a[2], a[3]),
  1065062679: (a) => new IFC2X3.IfcCoordinatedUniversalTimeOffset(a[0], a[1], a[2]),
  602808272: (a) => new IFC2X3.IfcCostValue(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  539742890: (a) => new IFC2X3.IfcCurrencyRelationship(a[0], a[1], a[2], a[3], a[4]),
  1105321065: (a) => new IFC2X3.IfcCurveStyleFont(a[0], a[1]),
  2367409068: (a) => new IFC2X3.IfcCurveStyleFontAndScaling(a[0], a[1], a[2]),
  3510044353: (a) => new IFC2X3.IfcCurveStyleFontPattern(a[0], a[1]),
  1072939445: (a) => new IFC2X3.IfcDateAndTime(a[0], a[1]),
  1765591967: (a) => new IFC2X3.IfcDerivedUnit(a[0], a[1], a[2]),
  1045800335: (a) => new IFC2X3.IfcDerivedUnitElement(a[0], a[1]),
  2949456006: (a) => new IFC2X3.IfcDimensionalExponents(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1376555844: (a) => new IFC2X3.IfcDocumentElectronicFormat(a[0], a[1], a[2]),
  1154170062: (a) => new IFC2X3.IfcDocumentInformation(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15], a[16]),
  770865208: (a) => new IFC2X3.IfcDocumentInformationRelationship(a[0], a[1], a[2]),
  3796139169: (a) => new IFC2X3.IfcDraughtingCalloutRelationship(a[0], a[1], a[2], a[3]),
  1648886627: (a) => new IFC2X3.IfcEnvironmentalImpactValue(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]),
  3200245327: (a) => new IFC2X3.IfcExternalReference(a[0], a[1], a[2]),
  2242383968: (a) => new IFC2X3.IfcExternallyDefinedHatchStyle(a[0], a[1], a[2]),
  1040185647: (a) => new IFC2X3.IfcExternallyDefinedSurfaceStyle(a[0], a[1], a[2]),
  3207319532: (a) => new IFC2X3.IfcExternallyDefinedSymbol(a[0], a[1], a[2]),
  3548104201: (a) => new IFC2X3.IfcExternallyDefinedTextFont(a[0], a[1], a[2]),
  852622518: (a) => new IFC2X3.IfcGridAxis(a[0], a[1], a[2]),
  3020489413: (a) => new IFC2X3.IfcIrregularTimeSeriesValue(a[0], a[1]),
  2655187982: (a) => new IFC2X3.IfcLibraryInformation(a[0], a[1], a[2], a[3], a[4]),
  3452421091: (a) => new IFC2X3.IfcLibraryReference(a[0], a[1], a[2]),
  4162380809: (a) => new IFC2X3.IfcLightDistributionData(a[0], a[1], a[2]),
  1566485204: (a) => new IFC2X3.IfcLightIntensityDistribution(a[0], a[1]),
  30780891: (a) => new IFC2X3.IfcLocalTime(a[0], a[1], a[2], a[3], a[4]),
  1838606355: (a) => new IFC2X3.IfcMaterial(a[0]),
  1847130766: (a) => new IFC2X3.IfcMaterialClassificationRelationship(a[0], a[1]),
  248100487: (a) => new IFC2X3.IfcMaterialLayer(a[0], a[1], a[2]),
  3303938423: (a) => new IFC2X3.IfcMaterialLayerSet(a[0], a[1]),
  1303795690: (a) => new IFC2X3.IfcMaterialLayerSetUsage(a[0], a[1], a[2], a[3]),
  2199411900: (a) => new IFC2X3.IfcMaterialList(a[0]),
  3265635763: (a) => new IFC2X3.IfcMaterialProperties(a[0]),
  2597039031: (a) => new IFC2X3.IfcMeasureWithUnit(a[0], a[1]),
  4256014907: (a) => new IFC2X3.IfcMechanicalMaterialProperties(a[0], a[1], a[2], a[3], a[4], a[5]),
  677618848: (a) => new IFC2X3.IfcMechanicalSteelMaterialProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12]),
  3368373690: (a) => new IFC2X3.IfcMetric(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]),
  2706619895: (a) => new IFC2X3.IfcMonetaryUnit(a[0]),
  1918398963: (a) => new IFC2X3.IfcNamedUnit(a[0], a[1]),
  3701648758: (_) => new IFC2X3.IfcObjectPlacement(),
  2251480897: (a) => new IFC2X3.IfcObjective(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10]),
  1227763645: (a) => new IFC2X3.IfcOpticalMaterialProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]),
  4251960020: (a) => new IFC2X3.IfcOrganization(a[0], a[1], a[2], a[3], a[4]),
  1411181986: (a) => new IFC2X3.IfcOrganizationRelationship(a[0], a[1], a[2], a[3]),
  1207048766: (a) => new IFC2X3.IfcOwnerHistory(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  2077209135: (a) => new IFC2X3.IfcPerson(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  101040310: (a) => new IFC2X3.IfcPersonAndOrganization(a[0], a[1], a[2]),
  2483315170: (a) => new IFC2X3.IfcPhysicalQuantity(a[0], a[1]),
  2226359599: (a) => new IFC2X3.IfcPhysicalSimpleQuantity(a[0], a[1], a[2]),
  3355820592: (a) => new IFC2X3.IfcPostalAddress(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]),
  3727388367: (a) => new IFC2X3.IfcPreDefinedItem(a[0]),
  990879717: (a) => new IFC2X3.IfcPreDefinedSymbol(a[0]),
  3213052703: (a) => new IFC2X3.IfcPreDefinedTerminatorSymbol(a[0]),
  1775413392: (a) => new IFC2X3.IfcPreDefinedTextFont(a[0]),
  2022622350: (a) => new IFC2X3.IfcPresentationLayerAssignment(a[0], a[1], a[2], a[3]),
  1304840413: (a) => new IFC2X3.IfcPresentationLayerWithStyle(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  3119450353: (a) => new IFC2X3.IfcPresentationStyle(a[0]),
  2417041796: (a) => new IFC2X3.IfcPresentationStyleAssignment(a[0]),
  2095639259: (a) => new IFC2X3.IfcProductRepresentation(a[0], a[1], a[2]),
  2267347899: (a) => new IFC2X3.IfcProductsOfCombustionProperties(a[0], a[1], a[2], a[3], a[4]),
  3958567839: (a) => new IFC2X3.IfcProfileDef(a[0], a[1]),
  2802850158: (a) => new IFC2X3.IfcProfileProperties(a[0], a[1]),
  2598011224: (a) => new IFC2X3.IfcProperty(a[0], a[1]),
  3896028662: (a) => new IFC2X3.IfcPropertyConstraintRelationship(a[0], a[1], a[2], a[3]),
  148025276: (a) => new IFC2X3.IfcPropertyDependencyRelationship(a[0], a[1], a[2], a[3], a[4]),
  3710013099: (a) => new IFC2X3.IfcPropertyEnumeration(a[0], a[1], a[2]),
  2044713172: (a) => new IFC2X3.IfcQuantityArea(a[0], a[1], a[2], a[3]),
  2093928680: (a) => new IFC2X3.IfcQuantityCount(a[0], a[1], a[2], a[3]),
  931644368: (a) => new IFC2X3.IfcQuantityLength(a[0], a[1], a[2], a[3]),
  3252649465: (a) => new IFC2X3.IfcQuantityTime(a[0], a[1], a[2], a[3]),
  2405470396: (a) => new IFC2X3.IfcQuantityVolume(a[0], a[1], a[2], a[3]),
  825690147: (a) => new IFC2X3.IfcQuantityWeight(a[0], a[1], a[2], a[3]),
  2692823254: (a) => new IFC2X3.IfcReferencesValueDocument(a[0], a[1], a[2], a[3]),
  1580146022: (a) => new IFC2X3.IfcReinforcementBarProperties(a[0], a[1], a[2], a[3], a[4], a[5]),
  1222501353: (a) => new IFC2X3.IfcRelaxation(a[0], a[1]),
  1076942058: (a) => new IFC2X3.IfcRepresentation(a[0], a[1], a[2], a[3]),
  3377609919: (a) => new IFC2X3.IfcRepresentationContext(a[0], a[1]),
  3008791417: (_) => new IFC2X3.IfcRepresentationItem(),
  1660063152: (a) => new IFC2X3.IfcRepresentationMap(a[0], a[1]),
  3679540991: (a) => new IFC2X3.IfcRibPlateProfileProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  2341007311: (a) => new IFC2X3.IfcRoot(a[0], a[1], a[2], a[3]),
  448429030: (a) => new IFC2X3.IfcSIUnit(a[0], a[1], a[2]),
  2042790032: (a) => new IFC2X3.IfcSectionProperties(a[0], a[1], a[2]),
  4165799628: (a) => new IFC2X3.IfcSectionReinforcementProperties(a[0], a[1], a[2], a[3], a[4], a[5]),
  867548509: (a) => new IFC2X3.IfcShapeAspect(a[0], a[1], a[2], a[3], a[4]),
  3982875396: (a) => new IFC2X3.IfcShapeModel(a[0], a[1], a[2], a[3]),
  4240577450: (a) => new IFC2X3.IfcShapeRepresentation(a[0], a[1], a[2], a[3]),
  3692461612: (a) => new IFC2X3.IfcSimpleProperty(a[0], a[1]),
  2273995522: (a) => new IFC2X3.IfcStructuralConnectionCondition(a[0]),
  2162789131: (a) => new IFC2X3.IfcStructuralLoad(a[0]),
  2525727697: (a) => new IFC2X3.IfcStructuralLoadStatic(a[0]),
  3408363356: (a) => new IFC2X3.IfcStructuralLoadTemperature(a[0], a[1], a[2], a[3]),
  2830218821: (a) => new IFC2X3.IfcStyleModel(a[0], a[1], a[2], a[3]),
  3958052878: (a) => new IFC2X3.IfcStyledItem(a[0], a[1], a[2]),
  3049322572: (a) => new IFC2X3.IfcStyledRepresentation(a[0], a[1], a[2], a[3]),
  1300840506: (a) => new IFC2X3.IfcSurfaceStyle(a[0], a[1], a[2]),
  3303107099: (a) => new IFC2X3.IfcSurfaceStyleLighting(a[0], a[1], a[2], a[3]),
  1607154358: (a) => new IFC2X3.IfcSurfaceStyleRefraction(a[0], a[1]),
  846575682: (a) => new IFC2X3.IfcSurfaceStyleShading(a[0]),
  1351298697: (a) => new IFC2X3.IfcSurfaceStyleWithTextures(a[0]),
  626085974: (a) => new IFC2X3.IfcSurfaceTexture(a[0], a[1], a[2], a[3]),
  1290481447: (a) => new IFC2X3.IfcSymbolStyle(a[0], a[1]),
  985171141: (a) => new IFC2X3.IfcTable(a[0], a[1]),
  531007025: (a) => new IFC2X3.IfcTableRow(a[0], a[1]),
  912023232: (a) => new IFC2X3.IfcTelecomAddress(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  1447204868: (a) => new IFC2X3.IfcTextStyle(a[0], a[1], a[2], a[3]),
  1983826977: (a) => new IFC2X3.IfcTextStyleFontModel(a[0], a[1], a[2], a[3], a[4], a[5]),
  2636378356: (a) => new IFC2X3.IfcTextStyleForDefinedFont(a[0], a[1]),
  1640371178: (a) => new IFC2X3.IfcTextStyleTextModel(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1484833681: (a) => new IFC2X3.IfcTextStyleWithBoxCharacteristics(a[0], a[1], a[2], a[3], a[4]),
  280115917: (_) => new IFC2X3.IfcTextureCoordinate(),
  1742049831: (a) => new IFC2X3.IfcTextureCoordinateGenerator(a[0], a[1]),
  2552916305: (a) => new IFC2X3.IfcTextureMap(a[0]),
  1210645708: (a) => new IFC2X3.IfcTextureVertex(a[0]),
  3317419933: (a) => new IFC2X3.IfcThermalMaterialProperties(a[0], a[1], a[2], a[3], a[4]),
  3101149627: (a) => new IFC2X3.IfcTimeSeries(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  1718945513: (a) => new IFC2X3.IfcTimeSeriesReferenceRelationship(a[0], a[1]),
  581633288: (a) => new IFC2X3.IfcTimeSeriesValue(a[0]),
  1377556343: (_) => new IFC2X3.IfcTopologicalRepresentationItem(),
  1735638870: (a) => new IFC2X3.IfcTopologyRepresentation(a[0], a[1], a[2], a[3]),
  180925521: (a) => new IFC2X3.IfcUnitAssignment(a[0]),
  2799835756: (_) => new IFC2X3.IfcVertex(),
  3304826586: (a) => new IFC2X3.IfcVertexBasedTextureMap(a[0], a[1]),
  1907098498: (a) => new IFC2X3.IfcVertexPoint(a[0]),
  891718957: (a) => new IFC2X3.IfcVirtualGridIntersection(a[0], a[1]),
  1065908215: (a) => new IFC2X3.IfcWaterProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  2442683028: (a) => new IFC2X3.IfcAnnotationOccurrence(a[0], a[1], a[2]),
  962685235: (a) => new IFC2X3.IfcAnnotationSurfaceOccurrence(a[0], a[1], a[2]),
  3612888222: (a) => new IFC2X3.IfcAnnotationSymbolOccurrence(a[0], a[1], a[2]),
  2297822566: (a) => new IFC2X3.IfcAnnotationTextOccurrence(a[0], a[1], a[2]),
  3798115385: (a) => new IFC2X3.IfcArbitraryClosedProfileDef(a[0], a[1], a[2]),
  1310608509: (a) => new IFC2X3.IfcArbitraryOpenProfileDef(a[0], a[1], a[2]),
  2705031697: (a) => new IFC2X3.IfcArbitraryProfileDefWithVoids(a[0], a[1], a[2], a[3]),
  616511568: (a) => new IFC2X3.IfcBlobTexture(a[0], a[1], a[2], a[3], a[4], a[5]),
  3150382593: (a) => new IFC2X3.IfcCenterLineProfileDef(a[0], a[1], a[2], a[3]),
  647927063: (a) => new IFC2X3.IfcClassificationReference(a[0], a[1], a[2], a[3]),
  776857604: (a) => new IFC2X3.IfcColourRgb(a[0], a[1], a[2], a[3]),
  2542286263: (a) => new IFC2X3.IfcComplexProperty(a[0], a[1], a[2], a[3]),
  1485152156: (a) => new IFC2X3.IfcCompositeProfileDef(a[0], a[1], a[2], a[3]),
  370225590: (a) => new IFC2X3.IfcConnectedFaceSet(a[0]),
  1981873012: (a) => new IFC2X3.IfcConnectionCurveGeometry(a[0], a[1]),
  45288368: (a) => new IFC2X3.IfcConnectionPointEccentricity(a[0], a[1], a[2], a[3], a[4]),
  3050246964: (a) => new IFC2X3.IfcContextDependentUnit(a[0], a[1], a[2]),
  2889183280: (a) => new IFC2X3.IfcConversionBasedUnit(a[0], a[1], a[2], a[3]),
  3800577675: (a) => new IFC2X3.IfcCurveStyle(a[0], a[1], a[2], a[3]),
  3632507154: (a) => new IFC2X3.IfcDerivedProfileDef(a[0], a[1], a[2], a[3], a[4]),
  2273265877: (a) => new IFC2X3.IfcDimensionCalloutRelationship(a[0], a[1], a[2], a[3]),
  1694125774: (a) => new IFC2X3.IfcDimensionPair(a[0], a[1], a[2], a[3]),
  3732053477: (a) => new IFC2X3.IfcDocumentReference(a[0], a[1], a[2]),
  4170525392: (a) => new IFC2X3.IfcDraughtingPreDefinedTextFont(a[0]),
  3900360178: (a) => new IFC2X3.IfcEdge(a[0], a[1]),
  476780140: (a) => new IFC2X3.IfcEdgeCurve(a[0], a[1], a[2], a[3]),
  1860660968: (a) => new IFC2X3.IfcExtendedMaterialProperties(a[0], a[1], a[2], a[3]),
  2556980723: (a) => new IFC2X3.IfcFace(a[0]),
  1809719519: (a) => new IFC2X3.IfcFaceBound(a[0], a[1]),
  803316827: (a) => new IFC2X3.IfcFaceOuterBound(a[0], a[1]),
  3008276851: (a) => new IFC2X3.IfcFaceSurface(a[0], a[1], a[2]),
  4219587988: (a) => new IFC2X3.IfcFailureConnectionCondition(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  738692330: (a) => new IFC2X3.IfcFillAreaStyle(a[0], a[1]),
  3857492461: (a) => new IFC2X3.IfcFuelProperties(a[0], a[1], a[2], a[3], a[4]),
  803998398: (a) => new IFC2X3.IfcGeneralMaterialProperties(a[0], a[1], a[2], a[3]),
  1446786286: (a) => new IFC2X3.IfcGeneralProfileProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  3448662350: (a) => new IFC2X3.IfcGeometricRepresentationContext(a[0], a[1], a[2], a[3], a[4], a[5]),
  2453401579: (_) => new IFC2X3.IfcGeometricRepresentationItem(),
  4142052618: (a) => new IFC2X3.IfcGeometricRepresentationSubContext(a[0], a[1], a[2], a[3], a[4], a[5]),
  3590301190: (a) => new IFC2X3.IfcGeometricSet(a[0]),
  178086475: (a) => new IFC2X3.IfcGridPlacement(a[0], a[1]),
  812098782: (a) => new IFC2X3.IfcHalfSpaceSolid(a[0], a[1]),
  2445078500: (a) => new IFC2X3.IfcHygroscopicMaterialProperties(a[0], a[1], a[2], a[3], a[4], a[5]),
  3905492369: (a) => new IFC2X3.IfcImageTexture(a[0], a[1], a[2], a[3], a[4]),
  3741457305: (a) => new IFC2X3.IfcIrregularTimeSeries(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]),
  1402838566: (a) => new IFC2X3.IfcLightSource(a[0], a[1], a[2], a[3]),
  125510826: (a) => new IFC2X3.IfcLightSourceAmbient(a[0], a[1], a[2], a[3]),
  2604431987: (a) => new IFC2X3.IfcLightSourceDirectional(a[0], a[1], a[2], a[3], a[4]),
  4266656042: (a) => new IFC2X3.IfcLightSourceGoniometric(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]),
  1520743889: (a) => new IFC2X3.IfcLightSourcePositional(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]),
  3422422726: (a) => new IFC2X3.IfcLightSourceSpot(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12]),
  2624227202: (a) => new IFC2X3.IfcLocalPlacement(a[0], a[1]),
  1008929658: (_) => new IFC2X3.IfcLoop(),
  2347385850: (a) => new IFC2X3.IfcMappedItem(a[0], a[1]),
  2022407955: (a) => new IFC2X3.IfcMaterialDefinitionRepresentation(a[0], a[1], a[2], a[3]),
  1430189142: (a) => new IFC2X3.IfcMechanicalConcreteMaterialProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11]),
  219451334: (a) => new IFC2X3.IfcObjectDefinition(a[0], a[1], a[2], a[3]),
  2833995503: (a) => new IFC2X3.IfcOneDirectionRepeatFactor(a[0]),
  2665983363: (a) => new IFC2X3.IfcOpenShell(a[0]),
  1029017970: (a) => new IFC2X3.IfcOrientedEdge(a[0], a[1]),
  2529465313: (a) => new IFC2X3.IfcParameterizedProfileDef(a[0], a[1], a[2]),
  2519244187: (a) => new IFC2X3.IfcPath(a[0]),
  3021840470: (a) => new IFC2X3.IfcPhysicalComplexQuantity(a[0], a[1], a[2], a[3], a[4], a[5]),
  597895409: (a) => new IFC2X3.IfcPixelTexture(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  2004835150: (a) => new IFC2X3.IfcPlacement(a[0]),
  1663979128: (a) => new IFC2X3.IfcPlanarExtent(a[0], a[1]),
  2067069095: (_) => new IFC2X3.IfcPoint(),
  4022376103: (a) => new IFC2X3.IfcPointOnCurve(a[0], a[1]),
  1423911732: (a) => new IFC2X3.IfcPointOnSurface(a[0], a[1], a[2]),
  2924175390: (a) => new IFC2X3.IfcPolyLoop(a[0]),
  2775532180: (a) => new IFC2X3.IfcPolygonalBoundedHalfSpace(a[0], a[1], a[2], a[3]),
  759155922: (a) => new IFC2X3.IfcPreDefinedColour(a[0]),
  2559016684: (a) => new IFC2X3.IfcPreDefinedCurveFont(a[0]),
  433424934: (a) => new IFC2X3.IfcPreDefinedDimensionSymbol(a[0]),
  179317114: (a) => new IFC2X3.IfcPreDefinedPointMarkerSymbol(a[0]),
  673634403: (a) => new IFC2X3.IfcProductDefinitionShape(a[0], a[1], a[2]),
  871118103: (a) => new IFC2X3.IfcPropertyBoundedValue(a[0], a[1], a[2], a[3], a[4]),
  1680319473: (a) => new IFC2X3.IfcPropertyDefinition(a[0], a[1], a[2], a[3]),
  4166981789: (a) => new IFC2X3.IfcPropertyEnumeratedValue(a[0], a[1], a[2], a[3]),
  2752243245: (a) => new IFC2X3.IfcPropertyListValue(a[0], a[1], a[2], a[3]),
  941946838: (a) => new IFC2X3.IfcPropertyReferenceValue(a[0], a[1], a[2], a[3]),
  3357820518: (a) => new IFC2X3.IfcPropertySetDefinition(a[0], a[1], a[2], a[3]),
  3650150729: (a) => new IFC2X3.IfcPropertySingleValue(a[0], a[1], a[2], a[3]),
  110355661: (a) => new IFC2X3.IfcPropertyTableValue(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  3615266464: (a) => new IFC2X3.IfcRectangleProfileDef(a[0], a[1], a[2], a[3], a[4]),
  3413951693: (a) => new IFC2X3.IfcRegularTimeSeries(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]),
  3765753017: (a) => new IFC2X3.IfcReinforcementDefinitionProperties(a[0], a[1], a[2], a[3], a[4], a[5]),
  478536968: (a) => new IFC2X3.IfcRelationship(a[0], a[1], a[2], a[3]),
  2778083089: (a) => new IFC2X3.IfcRoundedRectangleProfileDef(a[0], a[1], a[2], a[3], a[4], a[5]),
  1509187699: (a) => new IFC2X3.IfcSectionedSpine(a[0], a[1], a[2]),
  2411513650: (a) => new IFC2X3.IfcServiceLifeFactor(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  4124623270: (a) => new IFC2X3.IfcShellBasedSurfaceModel(a[0]),
  2609359061: (a) => new IFC2X3.IfcSlippageConnectionCondition(a[0], a[1], a[2], a[3]),
  723233188: (_) => new IFC2X3.IfcSolidModel(),
  2485662743: (a) => new IFC2X3.IfcSoundProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1202362311: (a) => new IFC2X3.IfcSoundValue(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  390701378: (a) => new IFC2X3.IfcSpaceThermalLoadProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13]),
  1595516126: (a) => new IFC2X3.IfcStructuralLoadLinearForce(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  2668620305: (a) => new IFC2X3.IfcStructuralLoadPlanarForce(a[0], a[1], a[2], a[3]),
  2473145415: (a) => new IFC2X3.IfcStructuralLoadSingleDisplacement(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1973038258: (a) => new IFC2X3.IfcStructuralLoadSingleDisplacementDistortion(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  1597423693: (a) => new IFC2X3.IfcStructuralLoadSingleForce(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1190533807: (a) => new IFC2X3.IfcStructuralLoadSingleForceWarping(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  3843319758: (a) => new IFC2X3.IfcStructuralProfileProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15], a[16], a[17], a[18], a[19], a[20], a[21], a[22]),
  3653947884: (a) => new IFC2X3.IfcStructuralSteelProfileProperties(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15], a[16], a[17], a[18], a[19], a[20], a[21], a[22], a[23], a[24], a[25], a[26]),
  2233826070: (a) => new IFC2X3.IfcSubedge(a[0], a[1], a[2]),
  2513912981: (_) => new IFC2X3.IfcSurface(),
  1878645084: (a) => new IFC2X3.IfcSurfaceStyleRendering(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]),
  2247615214: (a) => new IFC2X3.IfcSweptAreaSolid(a[0], a[1]),
  1260650574: (a) => new IFC2X3.IfcSweptDiskSolid(a[0], a[1], a[2], a[3], a[4]),
  230924584: (a) => new IFC2X3.IfcSweptSurface(a[0], a[1]),
  3071757647: (a) => new IFC2X3.IfcTShapeProfileDef(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12]),
  3028897424: (a) => new IFC2X3.IfcTerminatorSymbol(a[0], a[1], a[2], a[3]),
  4282788508: (a) => new IFC2X3.IfcTextLiteral(a[0], a[1], a[2]),
  3124975700: (a) => new IFC2X3.IfcTextLiteralWithExtent(a[0], a[1], a[2], a[3], a[4]),
  2715220739: (a) => new IFC2X3.IfcTrapeziumProfileDef(a[0], a[1], a[2], a[3], a[4], a[5], a[6]),
  1345879162: (a) => new IFC2X3.IfcTwoDirectionRepeatFactor(a[0], a[1]),
  1628702193: (a) => new IFC2X3.IfcTypeObject(a[0], a[1], a[2], a[3], a[4], a[5]),
  2347495698: (a) => new IFC2X3.IfcTypeProduct(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]),
  427810014: (a) => new IFC2X3.IfcUShapeProfi