"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
// eslint-disable-next-line import/no-extraneous-dependencies
const pg_1 = require("pg");
const util_1 = require("./util");
const adminSecretArn = process.env.ADMIN_SECRET_ARN;
const databaseName = process.env.DATABASE_NAME;
const secretsManagerClient = new client_secrets_manager_1.SecretsManagerClient({});
const handler = async () => {
    const adminSecret = await util_1.fetchSecret(adminSecretArn, secretsManagerClient);
    const client = new pg_1.Client({
        host: adminSecret.host,
        port: adminSecret.port,
        user: adminSecret.username,
        password: adminSecret.password,
        database: databaseName,
        ssl: true,
    });
    await client.connect();
    console.log("About to close the connection");
    await client.end();
    console.log("Connection closed");
};
module.exports = { handler };
//# sourceMappingURL=data:application/json;base64,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