"""init database

Revision ID: a55b1fb4f129
Revises: 
Create Date: 2023-05-22 18:35:51.474565

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'a55b1fb4f129'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('group',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('name', sa.String(length=100), nullable=False, comment='名称'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('user',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('name', sa.String(length=100), nullable=False, comment='名称'),
    sa.Column('nickname', sa.String(length=100), nullable=False, comment='别名'),
    sa.Column('email', sa.String(length=200), nullable=False, comment='邮箱'),
    sa.Column('email_verified', sa.Boolean(), nullable=True, comment='邮箱验证情况'),
    sa.Column('picture', sa.String(length=1000), nullable=False, comment='头像图片'),
    sa.Column('active', sa.Boolean(), nullable=True, comment='在线状态'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('group_user_map',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('group_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['group_id'], ['group.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('session',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('platform_name', sa.String(length=40), nullable=False, comment='平台名称'),
    sa.Column('token_type', sa.String(length=40), nullable=False, comment='token类型'),
    sa.Column('access_token', sa.String(length=200), nullable=False, comment='token'),
    sa.Column('refresh_token', sa.String(length=200), nullable=False, comment='刷新token'),
    sa.Column('expires_at', sa.BigInteger(), nullable=True, comment='过期时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('session')
    op.drop_table('group_user_map')
    op.drop_table('user')
    op.drop_table('group')
    # ### end Alembic commands ###
