from typing import Dict, List, Tuple


HRIR_CHECKSUMS: Dict[str, Dict[str, List[Tuple[str, str]]]] = {
    'cipic': {
        '': [
            ('subject_003.sofa', '2330ab8f3beea3d43ab962a089f38588'),
            ('subject_008.sofa', 'b26e2b18778e2ce48f75a1e6fc66f964'),
            ('subject_009.sofa', '9ef4858ef8f77f6c70b5913a39675fd4'),
            ('subject_010.sofa', '0c6c578e35b7a071f77a442d8f0be6f1'),
            ('subject_011.sofa', '2347675c41285e5db7654336716c5a3b'),
            ('subject_012.sofa', '3d0654feada956ffcc71ed6e86274f62'),
            ('subject_015.sofa', '7c1a539cf3075b2e9c3da9393f9caca1'),
            ('subject_017.sofa', '434283135360e08b781933f0347a0899'),
            ('subject_018.sofa', '80ef370c32b35b209cf40d31a5b5302c'),
            ('subject_019.sofa', '971bdd77602b9789b09d59c4c9a07c9c'),
            ('subject_020.sofa', 'b3d68d63b11079e128983e57ac026821'),
            ('subject_021.sofa', '886356543c282b0d6b5ca1f7134a5688'),
            ('subject_027.sofa', '4088b1ded6198dcbd113860571af69e2'),
            ('subject_028.sofa', 'e48520b4a85b234e4a7a747271bb2f8f'),
            ('subject_033.sofa', '53da34a33c2c92373e312088e9d80a3c'),
            ('subject_040.sofa', 'a6f4bee3bfd5d71141f6b306a0eff47c'),
            ('subject_044.sofa', '5f4722661ebe990538a25d362f2bd86c'),
            ('subject_048.sofa', '7f24a888613f3e28f3994f6a5dbd57f0'),
            ('subject_050.sofa', 'a151d7ee69c412938760fe2c9f02c8db'),
            ('subject_051.sofa', 'cc66ab2e4914a5121b8b7e680e497152'),
            ('subject_058.sofa', 'dbde770217017d81c773c44a063e4392'),
            ('subject_059.sofa', 'fbae21b1c9ee99a1edbb3fd6984c26fa'),
            ('subject_060.sofa', 'c7056a44dd80d637fd7e7232d31448d4'),
            ('subject_061.sofa', 'bb403cf19e9a18824b94cc0dd88dc7a9'),
            ('subject_065.sofa', 'd911c574b8e978af507ee0ade8c7dfaa'),
            ('subject_119.sofa', 'c96d06a1380d53fa6a4ead7528a4378e'),
            ('subject_124.sofa', 'd514ccf38a17fd502addc50ef47da0d4'),
            ('subject_126.sofa', '5d4ca736c336c2dd1381b83885e29d37'),
            ('subject_127.sofa', '7f0980e7dd7fa130cd17a0ca2cd2a266'),
            ('subject_131.sofa', 'f8e7b687ed78250afb65d4b956cd8b2e'),
            ('subject_133.sofa', 'ba92bbfd8691b7fe84a77c4b85643cb7'),
            ('subject_134.sofa', 'f2412727a0f963b62270485b84a34427'),
            ('subject_135.sofa', 'bf7c99647d4662c56db34a07f6ac13e1'),
            ('subject_137.sofa', '2c56b47ccf56a9ea2ec79e9186d7038f'),
            ('subject_147.sofa', 'e52a0d97c93a161e8aa2562910bdc98a'),
            ('subject_148.sofa', '8194c45e5f52154a5cd6a11dbcf2f1f1'),
            ('subject_152.sofa', '0e799a56f8710cc0f171cd76e0c26cb1'),
            ('subject_153.sofa', '4c1a87d26bc03f225166f058ed1f15bd'),
            ('subject_154.sofa', 'bb6c692ef4a7a10dd170630591ac2e07'),
            ('subject_155.sofa', '74d7719d3cf013df91cdb5c22bec0d91'),
            ('subject_156.sofa', 'a2bc3fc7a0b130ed09ff808f4bc04a87'),
            ('subject_158.sofa', '9d9187bb671e6c82936ce8215f6c8fd3'),
            ('subject_162.sofa', '1444640e1ee80c65308b053b041d60ae'),
            ('subject_163.sofa', '8ce8adbe02713249697977930e3f5c2a'),
            ('subject_165.sofa', 'e4f27b36c47b003c15e750cc91994573'),
        ],
    },
    'ari': {
        '': [
            ('hrtf b_nh2.sofa', '1b960eca26e4f3fbedc1875dd9918398'),
            ('hrtf b_nh4.sofa', '6fed8624c12ad07a102d555062d32477'),
            ('hrtf b_nh5.sofa', 'c260ea084762ee8f44f99b2481b1c837'),
            ('hrtf b_nh8.sofa', '4ef72908d3f413bf41bbf1b517164140'),
            ('hrtf b_nh10.sofa', 'a0159c0e53533e39fb1b8885418d6667'),
            ('hrtf b_nh11.sofa', '29131cf6dffc7936b485a80076bee8a5'),
            ('hrtf b_nh12.sofa', 'a47d5094151bda30f7c89f241063a1d6'),
            ('hrtf b_nh13.sofa', '5fba85bdb5c27a2312961b93e7e6594f'),
            ('hrtf b_nh14.sofa', '4c5adb7e604c22ab79f1aebed1b0bca0'),
            ('hrtf b_nh15.sofa', 'fcd0a1dbb8953ded1a06ee9efd81f156'),
            ('hrtf b_nh16.sofa', 'c014a0c33bd652fa473f51b6b8b2bdf7'),
            ('hrtf b_nh17.sofa', '552878348160817f1954bd28153e6a29'),
            ('hrtf b_nh18.sofa', '677c04834331bad4eecfa633828073b7'),
            ('hrtf b_nh19.sofa', 'e4cf0486aabc06a55998f40bd3b21b36'),
            ('hrtf b_nh21.sofa', '3a7c8da3c9cd9e2ef28dbe39bd78546d'),
            ('hrtf b_nh22.sofa', 'c3f4f54b2e3d71a91b7fd2694747d6e7'),
            ('hrtf b_nh25.sofa', '18215b3e0a1c782d5d650b062fd4921c'),
            ('hrtf b_nh27.sofa', '64a0b9b00d40e78ee64377c204639c61'),
            ('hrtf b_nh28.sofa', 'd5553b94d4625dc2605a4cae29c72953'),
            ('hrtf b_nh29.sofa', 'd2713797a084965317322a875b7d9a34'),
            ('hrtf b_nh30.sofa', '0bef5b1bdf741ff2d2fe0524271130f0'),
            ('hrtf b_nh31.sofa', '8f13e1330063b3caf7beef5d87584ede'),
            ('hrtf b_nh32.sofa', 'ccd1784c79f6425e10302e9e6477fb65'),
            ('hrtf b_nh33.sofa', 'fa6b75bf8ee0b47795248afd55d8df25'),
            ('hrtf b_nh34.sofa', '63fabdef8b676c9ab80e0a471caad366'),
            ('hrtf b_nh35.sofa', '12346031d6a7a8665f017f3e43fdc123'),
            ('hrtf b_nh36.sofa', '49b32e5b8adaf36e0b701d05c9065cda'),
            ('hrtf b_nh38.sofa', 'df38a8461a88470ba0998bb0fe676871'),
            ('hrtf b_nh39.sofa', '4f4918b5d2c377cfe5d01d28cc9a7544'),
            ('hrtf b_nh40.sofa', 'fcf3a5ace5036e93ae52366490b0c78f'),
            ('hrtf b_nh41.sofa', 'b91f335bbc6b5741cbd4d4f7cb88a47d'),
            ('hrtf b_nh42.sofa', 'dc63c41905d94f7a897d7af4bd2dd1e5'),
            ('hrtf b_nh43.sofa', 'ce74067ab5946d82197e7d889c77c39e'),
            ('hrtf b_nh46.sofa', '7ce5c03535aa5ebcde41e74d0cab41ab'),
            ('hrtf b_nh47.sofa', 'bed1236b7f3b06d717fabf522287645e'),
            ('hrtf b_nh52.sofa', '9dcc90beb0cd7333f22f29747f311185'),
            ('hrtf b_nh53.sofa', '29c7e25c6907d904b5ad478661ce4a01'),
            ('hrtf b_nh54.sofa', 'ac6ba25ae03458c024f3cae201889e7a'),
            ('hrtf b_nh55.sofa', 'b2e6892fc0d8432f0d72a70e04a5c5eb'),
            ('hrtf b_nh56.sofa', 'a9b6a076a962da48dc4228e79046cef7'),
            ('hrtf b_nh57.sofa', 'f712538bae2608b14cf228e7300f0a22'),
            ('hrtf b_nh58.sofa', 'a47a79285bfb10f460df4a3a74034ad9'),
            ('hrtf b_nh59.sofa', '4b9762088bece5b5fee4a618aa6ecb07'),
            ('hrtf b_nh60.sofa', 'c63c8eb9100b003daf77235e8114afa5'),
            ('hrtf b_nh61.sofa', '9e56fedc0788fd03ae20702468055e4f'),
            ('hrtf b_nh62.sofa', '84606a373de617f3ed4a3402d19cb1af'),
            ('hrtf b_nh63.sofa', '416d031686cb86368d6ce5a6c4fad6cd'),
            ('hrtf b_nh64.sofa', '9afdf5f7f6008c27426087f403b71b86'),
            ('hrtf b_nh65.sofa', '6081131c1ab6643029d7539fea92542e'),
            ('hrtf b_nh66.sofa', 'e3fb7e32de004b3f169df6af0df05615'),
            ('hrtf b_nh68.sofa', '5621577ee4d05ab20f2b5fdf6d9f975b'),
            ('hrtf b_nh70.sofa', '3dc29b5066819ef56013161ce7e80ee2'),
            ('hrtf b_nh71.sofa', '48720550b8e25cadbca84891b33bf659'),
            ('hrtf b_nh72.sofa', '7a7207be7fe6fd5e0fbeb5905ce55e7f'),
            ('hrtf b_nh74.sofa', '85ecd96710b8f789cc4091bafe905eb1'),
            ('hrtf b_nh89.sofa', 'ea1fe9f0339010550bbe812e70be4985'),
            ('hrtf b_nh90.sofa', '9ede9d57f56928632eb3c492797a3ec9'),
            ('hrtf b_nh91.sofa', '5029108886cc3899ec2c4ad20432e689'),
            ('hrtf b_nh92.sofa', '44d8ad09777fa71380f08f8c1ba9074d'),
            ('hrtf b_nh93.sofa', '2b6990bf4cef6d737e75d24ac4af3b1d'),
            ('hrtf b_nh94.sofa', '9e88bc4d17b153d1f968ca36b7390090'),
            ('hrtf b_nh95.sofa', '94726da7a0ef6a5ebdf8b21a31e04e98'),
            ('hrtf b_nh96.sofa', '6e1217ea0b4aaaf66c89014712e71583'),
            ('hrtf b_nh102.sofa', '94e78ce9644978328e777868091cf343'),
            ('hrtf b_nh103.sofa', 'cf4932d423fdc9c1c50771889ad7a0ad'),
            ('hrtf b_nh104.sofa', '62fb2345604805113da53d025a4c3f77'),
            ('hrtf b_nh110.sofa', 'b2569b4651e8604ad662af2e7d83bc76'),
            ('hrtf b_nh111.sofa', 'd95f2e59f8856992b93c04ce2a911761'),
            ('hrtf b_nh115.sofa', 'f8a96511ee91388dea5eb0404bb34769'),
            ('hrtf b_nh120.sofa', '58ec3aa17aa5ffda08779832db99f9f6'),
            ('hrtf b_nh122.sofa', 'a062df3016211cfea65a54760939aa25'),
            ('hrtf b_nh123.sofa', '5fad506c3fc1d12fdc574858341b44a2'),
            ('hrtf b_nh128.sofa', 'a675837880102392743f04248201e98a'),
            ('hrtf b_nh129.sofa', 'f012d1bcb268c5de2eabebc0afb56bb7'),
            ('hrtf b_nh130.sofa', '8289df0dbbb577e9f31343d2e65c94c7'),
            ('hrtf b_nh131.sofa', '29258743978a488affbdb533e80df4f7'),
            ('hrtf b_nh132.sofa', '45fc2665f0c3e435aea97c5fcdfac805'),
            ('hrtf b_nh133.sofa', '47e9311e6b408c0d5993b866e78877d9'),
            ('hrtf b_nh134.sofa', '2dc802d46abaaa481793501cc28cd308'),
            ('hrtf b_nh135.sofa', '8042ccfa60abe040dc71edb4d28aacae'),
            ('hrtf b_nh136.sofa', '5bf658c6767fbf870bb1b397daecaf8e'),
            ('hrtf b_nh137.sofa', '2214ccb8f6d9c568151e9586063cbd30'),
            ('hrtf b_nh138.sofa', '5fa439bd7ca6d489d8f4339d5eb4f51e'),
            ('hrtf b_nh139.sofa', '6a0cdeb13c5be228d77861c4d6df3da6'),
            ('hrtf b_nh140.sofa', '09f0c670954d0750053dba6872e46b8a'),
            ('hrtf b_nh143.sofa', '51db9bd5dba6a4de5953f9ce84df42bd'),
            ('hrtf b_nh146.sofa', '2402fb13439859fa4cb6e6b5793f403c'),
            ('hrtf b_nh154.sofa', '45a1a8b0799750b703abd3fa9d6ba11b'),
            ('hrtf b_nh156.sofa', '0dcfbee52aa819c19560365673477762'),
            ('hrtf b_nh157.sofa', '62ae8da0afc5c4482fb4116e82edd670'),
            ('hrtf b_nh158.sofa', 'e52a6926df2bfd706a6002a847177ee7'),
            ('hrtf b_nh159.sofa', '0d5f2f395930cb65429ec16b830d32a6'),
            ('hrtf b_nh160.sofa', '563deb8eb82b54f6b3fc81403b52bb66'),
            ('hrtf b_nh161.sofa', '4f28b22ea080b74fa2e0ba3116eae702'),
            ('hrtf b_nh162.sofa', 'e202d5318ed7e759483c17d9b879788f'),
            ('hrtf b_nh163.sofa', 'd1b141fd7e32f652cd03592315eca5d5'),
            ('hrtf b_nh164.sofa', '88a2ed655c329c78d79ed2ce1634e65d'),
            ('hrtf b_nh165.sofa', 'aa8976a3e7ea941f469f0945f0f0a868'),
            ('hrtf b_nh166.sofa', '554da84c1c0b39f0df3f59aed32378df'),
            ('hrtf b_nh167.sofa', 'cc5c54ab32e7e1c2d5e0bb669eaa01f2'),
            ('hrtf b_nh168.sofa', '24e04a7533ad94a50bfc37a4f039343c'),
            ('hrtf b_nh170.sofa', 'd24530a5ec61b92b0eb7013483506134'),
            ('hrtf b_nh173.sofa', '6f98a255a80eaeb5401c9fb1ebed0fcb'),
            ('hrtf b_nh174.sofa', 'c954228a4d39f060ed1e9cc996dc1a0d'),
            ('hrtf b_nh206.sofa', '528cb12d36eec75719191bd89124bee8'),
            ('hrtf b_nh207.sofa', 'c7e5bc0795e890a13686b59d6df0180b'),
            ('hrtf b_nh209.sofa', '7610160048a75fada9607b5f44d97dce'),
            ('hrtf b_nh210.sofa', '8d34b144315e5b92af9420e37618e17a'),
            ('hrtf b_nh211.sofa', '562fbd3a416379380f86a9dcb501d848'),
            ('hrtf b_nh225.sofa', 'f08faaaf5adeea6812879296e9d70dd8'),
            ('hrtf b_nh226.sofa', '28b0548d4f557f091115660d8b3bb9ba'),
            ('hrtf b_nh227.sofa', '6cfc7b59f90b41a564fde681b85f8eac'),
            ('hrtf b_nh228.sofa', '268d15959317d6ce977620663c777dfc'),
            ('hrtf b_nh229.sofa', '679e2e84c725981000bfd7747ae54c6f'),
            ('hrtf b_nh230.sofa', '96902ee7b139d16c9c1d5dcdb6ba0dea'),
            ('hrtf b_nh231.sofa', '967ec3c5f8e2c119b772d5a27641531f'),
            ('hrtf b_nh232.sofa', '12976ba293c80317442a8ca6bae373f0'),
            ('hrtf b_nh233.sofa', 'a9171b8a9c6f264afa3ea7c6c1f71bf6'),
            ('hrtf b_nh234.sofa', '6d108313942c0a2d7b4310a463e9aca9'),
            ('hrtf b_nh235.sofa', '6ce2371dcc3baa8f3b80833535159d53'),
            ('hrtf b_nh236.sofa', '7a53996ff34d7dd33f11c461e2178dde'),
            ('hrtf b_nh240.sofa', '4972e47fe65410ba5e065ccbd3c4e2c7'),
            ('hrtf b_nh241.sofa', '283fe76fd6d077aa5eadfd1b539f90e7'),
            ('hrtf b_nh242.sofa', 'a758d15ac96978998b06b390e234fc0a'),
            ('hrtf b_nh246.sofa', '71870b975bc938a305b9ed50c8e5794d'),
            ('hrtf b_nh249.sofa', '3a9358ee92ac16e3887fd08d9968ba64'),
            ('hrtf b_nh251.sofa', 'bbd6b0bccd422cc006300630d633813a'),
            ('hrtf b_nh252.sofa', '9cae693cbdede8a0954216bba2d15198'),
            ('hrtf b_nh253.sofa', '776aae990c9c32e2385db52e4e250f3e'),
            ('hrtf b_nh257.sofa', '2662cfacd74e8a43ee2bf597a3f8ed9d'),
            ('hrtf b_nh258.sofa', 'd09012610666a2596a75fe271d6c8406'),
            ('hrtf b_nh259.sofa', 'b25efce8feeeeaf335ef41d88643e7c9'),
            ('hrtf b_nh677.sofa', 'ba23256f07c0570d82be226a2ca3ba52'),
            ('hrtf b_nh690.sofa', 'f2d256f041d0c37341eb2e8bf6c59661'),
            ('hrtf b_nh708.sofa', 'a3a73c1da77ea7abead343c342476c39'),
            ('hrtf b_nh709.sofa', 'd85e45492782f3917dafa5bca0cd601b'),
            ('hrtf b_nh710.sofa', '7800fae01b723d697acf1933690d2aac'),
            ('hrtf b_nh711.sofa', '84147f44c80b5ba813246a0a69f7a77d'),
            ('hrtf b_nh719.sofa', '96ef41d4e5ef91179eac681df8f62f1c'),
            ('hrtf b_nh720.sofa', 'f2503d3cad23b336972c54a68fbe349a'),
            ('hrtf b_nh724.sofa', 'f80f99d02971516f9f1487fa1559b4e5'),
            ('hrtf b_nh740.sofa', 'f0fbd50a87e1de21fc8be437e61d19fe'),
            ('hrtf b_nh741.sofa', '5a9eda8503d6b560711fd4d398447d17'),
            ('hrtf b_nh742.sofa', 'c7c6de0e756f732234325c600576ed39'),
            ('hrtf b_nh768.sofa', '0453072e9850888fbd0244a46e879f1e'),
            ('hrtf b_nh769.sofa', '569e16b601a736c713888e10f92b90df'),
            ('hrtf b_nh770.sofa', 'edf8b9cbbff59975f6c45b0a232e14dd'),
            ('hrtf b_nh771.sofa', '7f3cb6ce4473f9c6bc05095feaecefb1'),
            ('hrtf b_nh772.sofa', 'ec4b780be96f201aecdc584b16aadf9c'),
            ('hrtf b_nh777.sofa', 'dffb1166184b0a8f622f96b818b845cd'),
            ('hrtf b_nh778.sofa', 'f87ee84260338a9524e5d4531a5f162c'),
            ('hrtf b_nh779.sofa', 'd0e15493e63f8009d1f00ea667b4a171'),
            ('hrtf b_nh780.sofa', '8de45b4b1dc6b8619bf91fce7bcf5902'),
            ('hrtf b_nh781.sofa', 'a20af644f755c73e212a5336b0fa9f64'),
            ('hrtf b_nh783.sofa', '0b205ee267323d3be02e153bb376ecdd'),
            ('hrtf b_nh784.sofa', '99da6e6d6d237c476f0ae1b2005bda58'),
            ('hrtf b_nh785.sofa', '1686823e79cb2902b6e56eae19bb0ff2'),
            ('hrtf b_nh786.sofa', '21817178ba936976fc980a8b3a695195'),
            ('hrtf b_nh787.sofa', '4c3682efe99cabeae32e102ef444d582'),
            ('hrtf b_nh788.sofa', '8125c42b32e6c193e7c10e601b026599'),
            ('hrtf b_nh789.sofa', '92b7827bf2934b3076107fd2edcf3c58'),
            ('hrtf b_nh790.sofa', 'f51159f0b4f94f42cee35e73bc62a162'),
            ('hrtf b_nh791.sofa', '87ceb40bfa6eed5779a591e1c6da9c8c'),
            ('hrtf b_nh792.sofa', '6f0be2c9b5dceeca767a0a678483a883'),
            ('hrtf b_nh793.sofa', '33abf0f4b440fdccb832289c4ec2bf52'),
            ('hrtf b_nh794.sofa', 'a44a7e2b5d9a174dc954abf583364577'),
            ('hrtf b_nh795.sofa', 'd3adca69afbb9628b10e4d4eff01d212'),
            ('hrtf b_nh796.sofa', 'c09e5e6879d3865162f14a361cbee082'),
            ('hrtf b_nh805.sofa', '79fb30f29245ac72a7bb74fd04bb2d68'),
            ('hrtf b_nh821.sofa', '61377c617b45b7feb099509ba87f34c6'),
            ('hrtf b_nh822.sofa', 'be86ed5f2d71666e176a5d16b178513c'),
            ('hrtf b_nh825.sofa', '0f9a0e4f1ea9a2f04748107f4d72f09c'),
            ('hrtf b_nh826.sofa', '6c1fe93a3a8e6a3591a99b44cb1daf7e'),
            ('hrtf b_nh827.sofa', '1aa884cadd3b50612b2798cd561b79e0'),
            ('hrtf b_nh828.sofa', 'd0964940d8e948da424c4dee91157cd0'),
            ('hrtf b_nh829.sofa', '07e4827014b21c41f55b373fe8ffe71e'),
            ('hrtf b_nh830.sofa', '2806f4bd8e6fe33096965a43608340a0'),
            ('hrtf c_nh676.sofa', '0e39d382ac023a7337a9eef14ddfb2d9'),
            ('hrtf c_nh831.sofa', '5267117a7d9918290a11d5c441655795'),
            ('hrtf c_nh834.sofa', 'bede71695b0dfefaffb7814dae0e4bba'),
            ('hrtf c_nh838.sofa', 'fd755cc4c2caccbffdd322cda0698361'),
            ('hrtf c_nh839.sofa', 'd193a998975ddc1196addcf91798752b'),
            ('hrtf c_nh840.sofa', '2aaa28ca1202580882e98badf40803af'),
            ('hrtf c_nh841.sofa', '0ddbb8da5eea32db1afb92804539b951'),
            ('hrtf c_nh842.sofa', '7eddbce2ca25740437d8eef408e49a74'),
            ('hrtf c_nh843.sofa', '006427b2675e8b013d8ce77495f9e9b3'),
            ('hrtf c_nh849.sofa', 'e9871f09e32e6d3fe052512cbb9579bd'),
            ('hrtf c_nh852.sofa', '1e915c2203e49bd67bbfcd30cb9d118a'),
            ('hrtf c_nh853.sofa', 'f31bc3693a6398fc90fa62865f49cf66'),
            ('hrtf c_nh854.sofa', '9896aed8cb860289cce0c873aa31fa93'),
            ('hrtf c_nh855.sofa', '731789429df1167773352cafeb74fbc7'),
            ('hrtf c_nh856.sofa', '5c5fe61e6ec53432705dc9f37a379758'),
            ('hrtf c_nh857.sofa', '7ea7c0b8015da2cd4631ab8aa93c69c2'),
            ('hrtf c_nh858.sofa', 'c19015199968aa2a0678bd35d3987da1'),
            ('hrtf c_nh859.sofa', 'd280933376bfefebf4a22258fea78cdd'),
            ('hrtf c_nh860.sofa', '1847824d62cbd02da763635aa07a90de'),
            ('hrtf c_nh868.sofa', '839d331a81542053bf678e4acb418f00'),
            ('hrtf c_nh869.sofa', '51a3c585355ea49104c23df48cae25bf'),
            ('hrtf c_nh873.sofa', 'eae1cdc30137a333e2c9146f1f46611c'),
            ('hrtf c_nh874.sofa', 'e7d72825aca7ab3d32cc2c9e7d5b6b8c'),
            ('hrtf c_nh877.sofa', 'c7cb07a96585be00daccd09e1139a8fd'),
            ('hrtf c_nh879.sofa', 'fc1923e4b96264ff4cd42d09ff628314'),
            ('hrtf c_nh881.sofa', '51822d1a7da95dc4b77585dd0a6f90dc'),
            ('hrtf c_nh882.sofa', 'a1c3ee8d1f125a19a50f4bb37e5f1b7e'),
            ('hrtf c_nh883.sofa', '0d0e653d8ff9401ba5665f1554ffdeb4'),
            ('hrtf c_nh884.sofa', '92890bf451022fcc92cb66e8ee361882'),
            ('hrtf c_nh885.sofa', 'ff2c80ff9aea66da0a5040437cbc7c9e'),
            ('hrtf c_nh887.sofa', 'e9ff9f0c09eaed7c8817837f1a586bfb'),
            ('hrtf c_nh888.sofa', '3a57ea62eeeea2c4aca7d356b75848b5'),
            ('hrtf c_nh889.sofa', '5d5d4a954785e12edc1196376a097590'),
            ('hrtf c_nh890.sofa', 'ae765bb8f7efc85440b861e4b7a1ddd5'),
            ('hrtf c_nh891.sofa', 'f8c5ead1267d05c78fce20827698b37e'),
            ('hrtf c_nh892.sofa', '8988d38344a308c87a43ebc934eaa00c'),
            ('hrtf c_nh896.sofa', '27d076186efd6b484dedeabb0f33dc0f'),
            ('hrtf c_nh898.sofa', 'a314e928f8217edf4a50cba32eb2e77c'),
            ('hrtf c_nh899.sofa', '041b3c2d27954dcf6b76780b5330099f'),
            ('hrtf c_nh903.sofa', '9b47968c1696592660cf21c43181ebed'),
            ('hrtf c_nh904.sofa', '2e88e8b082ac0d0492dc941364b7ca4f'),
            ('hrtf c_nh905.sofa', 'edd030cc1fba929679878344e0750dcd'),
            ('hrtf c_nh906.sofa', '3195dda5fab96d4d29b281f47fd30cc9'),
            ('hrtf c_nh911.sofa', '404e1951a663b92af2a40f8fefa4d80a'),
            ('hrtf c_nh912.sofa', 'aabeb5cd139c6302f5470944811b79e9'),
            ('hrtf c_nh951.sofa', 'fa1edd3d6d5078df04e04161a79c11c4'),
            ('hrtf c_nh952.sofa', '85e099e75e3f1d05fb745dd86b302e99'),
        ],
    },
    'listen': {
        'raw': [
            ('raw/44100/IRC_1002_R_44100.sofa', '1e832c9437d0e1ec7f856f802df1c08f'),
            ('raw/44100/IRC_1003_R_44100.sofa', '542542e4a77b7fee689a239f7d8f6bb4'),
            ('raw/44100/IRC_1004_R_44100.sofa', '748c3b5b4af7d99d32be1e86d8b1641c'),
            ('raw/44100/IRC_1005_R_44100.sofa', '28ae0106b61038bd6d40df36d965803d'),
            ('raw/44100/IRC_1006_R_44100.sofa', 'ce8f583629f9578d9b923d4143f1beb6'),
            ('raw/44100/IRC_1007_R_44100.sofa', 'f2e7729f6b48d7b2428976b34e344594'),
            ('raw/44100/IRC_1008_R_44100.sofa', '7e748d2bed0cd8d259475de6f5d09e3b'),
            ('raw/44100/IRC_1009_R_44100.sofa', 'cc6503af721275944eac7b7301f54032'),
            ('raw/44100/IRC_1012_R_44100.sofa', '91c96578ebaccc40c82c58f416568ba9'),
            ('raw/44100/IRC_1013_R_44100.sofa', 'bea639df8d87f2beae9797e49b8807c1'),
            ('raw/44100/IRC_1014_R_44100.sofa', '0b13acccd2b80f6f8fe81e31a7df3ee5'),
            ('raw/44100/IRC_1015_R_44100.sofa', '5148e951e0cef593b438b0e3eba16200'),
            ('raw/44100/IRC_1016_R_44100.sofa', 'd1d383819082a9eb80c790620470c962'),
            ('raw/44100/IRC_1017_R_44100.sofa', '674756011ab8052be461024472fa51e0'),
            ('raw/44100/IRC_1018_R_44100.sofa', '1fd15d3b5042320893c022aa5b75076a'),
            ('raw/44100/IRC_1020_R_44100.sofa', '7e68da7b175537c4003cd3ea22176123'),
            ('raw/44100/IRC_1021_R_44100.sofa', 'eb212f4f79dd6c6ac27198082c428978'),
            ('raw/44100/IRC_1022_R_44100.sofa', '73f95ec21dd030917f289d2334163558'),
            ('raw/44100/IRC_1023_R_44100.sofa', '0978665db25284c51960d022c6224388'),
            ('raw/44100/IRC_1025_R_44100.sofa', 'f59e279261687d9a73d04d8044b5b13f'),
            ('raw/44100/IRC_1026_R_44100.sofa', 'd7d141f98039d16fc5dd94f049e3d859'),
            ('raw/44100/IRC_1028_R_44100.sofa', '642733b256269bdb09bdb857cd73cc7a'),
            ('raw/44100/IRC_1029_R_44100.sofa', 'b498ffe7985e536f42488dd3f67c3087'),
            ('raw/44100/IRC_1030_R_44100.sofa', '6484e778968933911a58343084424baa'),
            ('raw/44100/IRC_1031_R_44100.sofa', 'd522e972664852d7862224352801ea99'),
            ('raw/44100/IRC_1032_R_44100.sofa', 'ac868edbdd98f8af19f7de4682ba2e39'),
            ('raw/44100/IRC_1033_R_44100.sofa', '8f470842407ca9dfe7e79dfca886d12c'),
            ('raw/44100/IRC_1037_R_44100.sofa', 'c67bac5acf10388669289fdf0a569005'),
            ('raw/44100/IRC_1038_R_44100.sofa', '1f93a742007258211bbe3df4c9190998'),
            ('raw/44100/IRC_1039_R_44100.sofa', '339aabb1ec85567dcab1083aa2dfe958'),
            ('raw/44100/IRC_1040_R_44100.sofa', 'a95fb606befa8e2cabbf33126efc66bb'),
            ('raw/44100/IRC_1041_R_44100.sofa', 'ad7fd9d3cea1869959efa386392d19c0'),
            ('raw/44100/IRC_1042_R_44100.sofa', '788dd0999d354dc8b69d7a080027f977'),
            ('raw/44100/IRC_1043_R_44100.sofa', 'aab1a0c0c81df3b0a2a7c43faf4d8a8b'),
            ('raw/44100/IRC_1044_R_44100.sofa', 'd96a962d69625a81139b87464d9c9ae9'),
            ('raw/44100/IRC_1045_R_44100.sofa', 'fbd9da10565d69783e3fe834ddfcab6d'),
            ('raw/44100/IRC_1046_R_44100.sofa', 'bbb8b9cfcc6ada9250dd4cc73ef55b1d'),
            ('raw/44100/IRC_1047_R_44100.sofa', '469a394f253daa58b9936541b050c7f5'),
            ('raw/44100/IRC_1048_R_44100.sofa', '3643601942431cc6ee56440555ae0997'),
            ('raw/44100/IRC_1049_R_44100.sofa', 'b5d27fc3b6703a658a245809e6ca84d5'),
            ('raw/44100/IRC_1050_R_44100.sofa', '3cfb043ba89c5fc40437b7253cf7420b'),
            ('raw/44100/IRC_1051_R_44100.sofa', '2011c8f4ac56d46f29ce0428051ab16b'),
            ('raw/44100/IRC_1052_R_44100.sofa', 'bf7d528bf8ac3c87aedfbdf08a487a7c'),
            ('raw/44100/IRC_1053_R_44100.sofa', '88e1701dd85c01efe86ff3326439c517'),
            ('raw/44100/IRC_1054_R_44100.sofa', '1b97b22f14355c06e5e29947ced7a2fb'),
            ('raw/44100/IRC_1055_R_44100.sofa', '6a44cc57fce2380fcd7c1ff866adaac6'),
            ('raw/44100/IRC_1056_R_44100.sofa', '8e4e2b1ae6eee1d4391f64fa8cc33ff0'),
            ('raw/44100/IRC_1057_R_44100.sofa', '5fa9cccdc0d35b22f182f2474869d1aa'),
            ('raw/44100/IRC_1058_R_44100.sofa', '2b129e0bbb6dc4c3d02af3c8683f4922'),
            ('raw/44100/IRC_1059_R_44100.sofa', 'bce7bd08fc48164771fe96d61d273f52'),
        ],
        'compensated': [
            ('compensated/44100/IRC_1002_C_44100.sofa', 'ebbf7f2380197236ec2a7054be0e9837'),
            ('compensated/44100/IRC_1003_C_44100.sofa', '602ca24914499f5748de40afd29246b1'),
            ('compensated/44100/IRC_1004_C_44100.sofa', '48066640a5689baedd3211d92562d350'),
            ('compensated/44100/IRC_1005_C_44100.sofa', 'b9d6b4522b95e93270297fcfedff8187'),
            ('compensated/44100/IRC_1006_C_44100.sofa', '800e9c26dea76acf128e14ca08c48802'),
            ('compensated/44100/IRC_1007_C_44100.sofa', '3d16aeaaa7ac1015f44bfb49e0cd0767'),
            ('compensated/44100/IRC_1008_C_44100.sofa', 'b962c4cf0baf6d3f1c13fe1630ea60a3'),
            ('compensated/44100/IRC_1009_C_44100.sofa', 'c9e000408657eb2b7a8e18cf25f0cd4c'),
            ('compensated/44100/IRC_1012_C_44100.sofa', 'd5091fbde526fcc82c9a66eaa5b19cb3'),
            ('compensated/44100/IRC_1013_C_44100.sofa', '35fd2b3111b76503423972648955f6b3'),
            ('compensated/44100/IRC_1014_C_44100.sofa', 'aae89c41bdc3b3f9e727900e030f917a'),
            ('compensated/44100/IRC_1015_C_44100.sofa', '07b49772092b69dfe67189df562bc2af'),
            ('compensated/44100/IRC_1016_C_44100.sofa', 'fd1ae685026aa76091787d6567d942e7'),
            ('compensated/44100/IRC_1017_C_44100.sofa', 'ce1e94253445a5b70585cc15b6695fd2'),
            ('compensated/44100/IRC_1018_C_44100.sofa', '6eb4b64a0fa4cfbc7341bad5fc152cff'),
            ('compensated/44100/IRC_1020_C_44100.sofa', '63d661059cae5866ccd366c1cd5e4955'),
            ('compensated/44100/IRC_1021_C_44100.sofa', '3d9ff45108bc42f7da081e3627784ee1'),
            ('compensated/44100/IRC_1022_C_44100.sofa', 'aed0ffec8fea6399b60f3236912d5bed'),
            ('compensated/44100/IRC_1023_C_44100.sofa', '78b61c25f3cfd5cb6b8077d221ceedae'),
            ('compensated/44100/IRC_1025_C_44100.sofa', '8869e00fd3bd9c6fce40b171361b934c'),
            ('compensated/44100/IRC_1026_C_44100.sofa', '1f15b62feec1cdb25f040e3c33e5a960'),
            ('compensated/44100/IRC_1028_C_44100.sofa', '7bfa2085feb5066fedcff39bb0815b69'),
            ('compensated/44100/IRC_1029_C_44100.sofa', '4add36a4864dcfe89afa76c769093a6e'),
            ('compensated/44100/IRC_1030_C_44100.sofa', '960d1360ad1e7f25808f190eb77be82f'),
            ('compensated/44100/IRC_1031_C_44100.sofa', '7b59d61aa3326d41e706846c0a99321e'),
            ('compensated/44100/IRC_1032_C_44100.sofa', '6412cf3b8892e734b7d527d3d52cb5e5'),
            ('compensated/44100/IRC_1033_C_44100.sofa', 'f5f2b827e0cbe2f089ea7e360d493f03'),
            ('compensated/44100/IRC_1037_C_44100.sofa', 'fcb184a61f20fc09f26824585b6654f5'),
            ('compensated/44100/IRC_1038_C_44100.sofa', '09e60ed080440ee9a425c6e39d54dff3'),
            ('compensated/44100/IRC_1039_C_44100.sofa', '5d5f30a12f0c33cb126d1b58c907106f'),
            ('compensated/44100/IRC_1040_C_44100.sofa', 'e1de5d2d1b4ccc102c5cac436e23fc41'),
            ('compensated/44100/IRC_1041_C_44100.sofa', '325ec2bea098624c87ff7ed6da294a12'),
            ('compensated/44100/IRC_1042_C_44100.sofa', '7fd088ccfca10bc47596d8e0afb6bf89'),
            ('compensated/44100/IRC_1043_C_44100.sofa', '8680f8d6222fb230c3eb6f8f4e9e2db4'),
            ('compensated/44100/IRC_1044_C_44100.sofa', 'd411fe212e5d46a182d4ee26ad0dee4b'),
            ('compensated/44100/IRC_1045_C_44100.sofa', 'ad40e13eee3224a6b131081a9e012b33'),
            ('compensated/44100/IRC_1046_C_44100.sofa', '61663505c3f5ce056267575b2b171547'),
            ('compensated/44100/IRC_1047_C_44100.sofa', '261ba933de9cd8a4932ec6d3ea113bc0'),
            ('compensated/44100/IRC_1048_C_44100.sofa', '3fb1ae0cca14100caafd25e59444b86d'),
            ('compensated/44100/IRC_1049_C_44100.sofa', '299d7b9fb10fe108d690b0af0a7814e5'),
            ('compensated/44100/IRC_1050_C_44100.sofa', '9a21aa2c4e1d97e271b0813a20f7f05d'),
            ('compensated/44100/IRC_1051_C_44100.sofa', 'eb11dbf357316470821e0353594f14ea'),
            ('compensated/44100/IRC_1052_C_44100.sofa', '6883f5af4bc96a138a289a44f8d10e7e'),
            ('compensated/44100/IRC_1053_C_44100.sofa', '54ae5d0dc67e152453308405457e4a2b'),
            ('compensated/44100/IRC_1054_C_44100.sofa', '5907ccea6c7b51b59874d6d6594cd66d'),
            ('compensated/44100/IRC_1055_C_44100.sofa', '1beb30245b45da8df890ed462585441a'),
            ('compensated/44100/IRC_1056_C_44100.sofa', 'be8f7ba23ff5edbb02c52cd9d5ce54fb'),
            ('compensated/44100/IRC_1057_C_44100.sofa', '8add0302bfe61c94ba331a2f9d97be16'),
            ('compensated/44100/IRC_1058_C_44100.sofa', '006af61b1566d41842e8a572a2929dd4'),
            ('compensated/44100/IRC_1059_C_44100.sofa', '769b21eb151ab8d3c964c9342ec5af07'),
        ],
    },
    'crossmod': {
        'raw': [
            ('raw/44100/IRC_1062_R_44100.sofa', 'c7ffa051719fb959ecd766a7f7384404'),
            ('raw/44100/IRC_1063_R_44100.sofa', '9b8f3ae822b5e17205d05e91e7774f50'),
            ('raw/44100/IRC_1065_R_44100.sofa', '08cb5fbb67a2d43761fed497b86002f9'),
            ('raw/44100/IRC_1066_R_44100.sofa', 'bfac373c0d547ce52a58e2f766d1a1d3'),
            ('raw/44100/IRC_1067_R_44100.sofa', 'b74d61012ddf7db92148115cfc5df475'),
            ('raw/44100/IRC_1068_R_44100.sofa', '93e2cf812c2eefad57a3622aeb291345'),
            ('raw/44100/IRC_1069_R_44100.sofa', '7a079262a9ca07b62cde166e7ad82121'),
            ('raw/44100/IRC_1070_R_44100.sofa', '7a2df48d4c7b04eb53db5d89f9b5208e'),
            ('raw/44100/IRC_1071_R_44100.sofa', 'c22fbdc8da261248f206a3ab25ea25c0'),
            ('raw/44100/IRC_1073_R_44100.sofa', 'af8d3cf679a4d1214bb596b80e4869fb'),
            ('raw/44100/IRC_1074_R_44100.sofa', '50d4760655eae70466d6086cca7d4d1f'),
            ('raw/44100/IRC_1075_R_44100.sofa', 'fa8f5745f1b912526e3812d0375fe686'),
            ('raw/44100/IRC_1076_R_44100.sofa', '5613a990822f2a5771e5863a19079b12'),
            ('raw/44100/IRC_1077_R_44100.sofa', 'd932be7cb226354344cdc5d4dd5d06e8'),
            ('raw/44100/IRC_1078_R_44100.sofa', '6f889cb1772d52782db3b83d45c22b71'),
            ('raw/44100/IRC_1079_R_44100.sofa', 'b634f8892648e98c83d9e62865504fe3'),
            ('raw/44100/IRC_1082_R_44100.sofa', '08595d8136806e8e400b394fda421432'),
            ('raw/44100/IRC_1083_R_44100.sofa', '1134126c950ecd7ffc3b26a82ae2eebf'),
            ('raw/44100/IRC_1084_R_44100.sofa', '706a40cec38eb7e1bafdcbdd6c0d881e'),
            ('raw/44100/IRC_1085_R_44100.sofa', 'e3df51d41a25ac6bdd35918edf5ab187'),
            ('raw/44100/IRC_1086_R_44100.sofa', '70258efbec175b86c169b228bf787c96'),
            ('raw/44100/IRC_1087_R_44100.sofa', '8b25236c0e492dc9233cd8142e03fd16'),
            ('raw/44100/IRC_1088_R_44100.sofa', 'b7cc0e45c03674beebc3e8cd21684199'),
            ('raw/44100/IRC_1089_R_44100.sofa', '110b799f544c3663b62b22bfacfaf671'),
        ],
        'compensated': [
            ('compensated/44100/IRC_1062_C_44100.sofa', '1606b3e1780933d84616ce896094e958'),
            ('compensated/44100/IRC_1063_C_44100.sofa', '88b9dc6ad76e0c5489d3629957065e0f'),
            ('compensated/44100/IRC_1065_C_44100.sofa', '8f0a40aafe9f9f0b2c1110ced64cfc3b'),
            ('compensated/44100/IRC_1066_C_44100.sofa', 'ceb70fbccc0af335f383e314af99b5ec'),
            ('compensated/44100/IRC_1067_C_44100.sofa', '80b4db89cf2c770d652f74e90a7df36c'),
            ('compensated/44100/IRC_1068_C_44100.sofa', 'e7691498585bb90a0a4c36c7db72f7c6'),
            ('compensated/44100/IRC_1069_C_44100.sofa', '1cec683acf7647733da5654c330038d8'),
            ('compensated/44100/IRC_1070_C_44100.sofa', 'cf590383de34d182b285aee505c4e2ca'),
            ('compensated/44100/IRC_1071_C_44100.sofa', '2c07f4718aaf9e01aea84bf1eec81504'),
            ('compensated/44100/IRC_1073_C_44100.sofa', '566db84b593ac782332c090d2c6058ba'),
            ('compensated/44100/IRC_1074_C_44100.sofa', 'b52ed4e6d7559399eb8360af471191f4'),
            ('compensated/44100/IRC_1075_C_44100.sofa', '244d0f66ec2bc5803d33774de121c171'),
            ('compensated/44100/IRC_1076_C_44100.sofa', 'ebd180364dbc7c89f160ff74209a8e0d'),
            ('compensated/44100/IRC_1077_C_44100.sofa', '43ba1f0104a261dd21ee18fa70c92746'),
            ('compensated/44100/IRC_1078_C_44100.sofa', '8501f492237968c8d2593b30708a4c49'),
            ('compensated/44100/IRC_1079_C_44100.sofa', 'f811923b81e07ae25bf2e5063e7f068c'),
            ('compensated/44100/IRC_1082_C_44100.sofa', '6a0d5c70b0fc52da2d032b98b6c70933'),
            ('compensated/44100/IRC_1083_C_44100.sofa', 'e733ba9ed9745a58fb8e4b6706ac4c99'),
            ('compensated/44100/IRC_1084_C_44100.sofa', 'af1562a87fb1d993cce430cb4d835c3e'),
            ('compensated/44100/IRC_1085_C_44100.sofa', '4f6b9d4dc0e22ad2eba111e75ba371fa'),
            ('compensated/44100/IRC_1086_C_44100.sofa', '12c9374c19cc94cbe74df55c59369941'),
            ('compensated/44100/IRC_1087_C_44100.sofa', '29c120496c27501ac81b4c435641289c'),
            ('compensated/44100/IRC_1088_C_44100.sofa', 'd1926721fdc1f1271c1fe5b90121def3'),
            ('compensated/44100/IRC_1089_C_44100.sofa', '7606ad5b0b51bc7223ba4f2c5ae9effd'),
        ],
    },
    'bili': {
        'raw-96000': [
            ('raw/96000/IRC_1100_R_HRIR_96000.sofa', 'df42fe68b5f72a2a317e08165df5e88f'),
            ('raw/96000/IRC_1101_R_HRIR_96000.sofa', '29f739b16260e70b4684351e9a9319ec'),
            ('raw/96000/IRC_1102_R_HRIR_96000.sofa', 'efa1ef9e215b0dd1ef64cc76c7e69a22'),
            ('raw/96000/IRC_1103_R_HRIR_96000.sofa', '9f238c1b66c033365d0077714cd33f4b'),
            ('raw/96000/IRC_1104_R_HRIR_96000.sofa', 'd4ef94e257e37eab8b0e83dc84e8aebc'),
            ('raw/96000/IRC_1105_R_HRIR_96000.sofa', 'b758b81e230628284c72bb6811737130'),
            ('raw/96000/IRC_1106_R_HRIR_96000.sofa', 'a22ffb223d5d9a8de9d9140cf9345c9c'),
            ('raw/96000/IRC_1107_R_HRIR_96000.sofa', '35390072c8564cba9c1802143088505b'),
            ('raw/96000/IRC_1108_R_HRIR_96000.sofa', '3f3d98af2596a0adb33846082b5da370'),
            ('raw/96000/IRC_1109_R_HRIR_96000.sofa', '2af4731b2fa6f3657b9339608f1f204d'),
            ('raw/96000/IRC_1110_R_HRIR_96000.sofa', 'b7faabd5cd40d630b0bb0965a84bff9e'),
            ('raw/96000/IRC_1111_R_HRIR_96000.sofa', '9e6e8f4286a793e9ee5d27f8cc277704'),
            ('raw/96000/IRC_1112_R_HRIR_96000.sofa', 'f92f199d493c8e08ab6c6032522c9742'),
            ('raw/96000/IRC_1113_R_HRIR_96000.sofa', '7c6f5b935d056c8743462bfea525d6b2'),
            ('raw/96000/IRC_1114_R_HRIR_96000.sofa', '35a05c09b2462eb4a1e60e92a63b0636'),
            ('raw/96000/IRC_1115_R_HRIR_96000.sofa', '758d2a50f32551b69b64ba3ee4fbe19f'),
            ('raw/96000/IRC_1116_R_HRIR_96000.sofa', '7d53d569ac804351bebd93c4930e9dcc'),
            ('raw/96000/IRC_1117_R_HRIR_96000.sofa', '296ad4b7e5678baf1b6f896dd46dbe2e'),
            ('raw/96000/IRC_1118_R_HRIR_96000.sofa', 'f16c46b6cd969ebf7ea5ec4efafe211a'),
            ('raw/96000/IRC_1119_R_HRIR_96000.sofa', '87fd8fc30c0edd19140e243e51361e97'),
            ('raw/96000/IRC_1120_R_HRIR_96000.sofa', '70e282c5eb882b7b093d6ac99d044e84'),
            ('raw/96000/IRC_1121_R_HRIR_96000.sofa', 'c287c076a660c175366e6e46eb80b7bd'),
            ('raw/96000/IRC_1122_R_HRIR_96000.sofa', '04d1817a317a44c408cfc03bca9e8ef8'),
            ('raw/96000/IRC_1124_R_HRIR_96000.sofa', '661efdbf5a55b2814f8c2576577483ce'),
            ('raw/96000/IRC_1125_R_HRIR_96000.sofa', 'd043e3bf10837c1db493557ac5bb9920'),
            ('raw/96000/IRC_1126_R_HRIR_96000.sofa', '0e02c41cb5304de827176a496bd18561'),
            ('raw/96000/IRC_1127_R_HRIR_96000.sofa', '73143c4fd4d0bf6f228683c5699aee76'),
            ('raw/96000/IRC_1128_R_HRIR_96000.sofa', 'c23b852274e6a465de7ad92ff2cc59fb'),
            ('raw/96000/IRC_1129_R_HRIR_96000.sofa', '188e02add0b92cbc916d9882588e2e8e'),
            ('raw/96000/IRC_1130_R_HRIR_96000.sofa', '9ae9970790d355ba26af5bd309cee355'),
            ('raw/96000/IRC_1131_R_HRIR_96000.sofa', 'ec2874a43c9d4270b4948d365e771754'),
            ('raw/96000/IRC_1132_R_HRIR_96000.sofa', 'bf6ad3595b03f13426a714b3d0b2f30d'),
            ('raw/96000/IRC_1133_R_HRIR_96000.sofa', '10e69b2b536a3c876e4a3541a12d7072'),
            ('raw/96000/IRC_1134_R_HRIR_96000.sofa', 'ba02858c73dcb210c86f9b0f5d65e43f'),
            ('raw/96000/IRC_1135_R_HRIR_96000.sofa', 'bff6abac03d3ada4a65c6fbe0d67f2de'),
            ('raw/96000/IRC_1136_R_HRIR_96000.sofa', 'e548c6d9225a640d3f6157b036c25bd0'),
            ('raw/96000/IRC_1137_R_HRIR_96000.sofa', '164584814313738e5dbe02039f3df8e3'),
            ('raw/96000/IRC_1138_R_HRIR_96000.sofa', '70f566486a40193f010e361fd949d980'),
            ('raw/96000/IRC_1139_R_HRIR_96000.sofa', '06db1503388bd5558b11a50da0b8b238'),
            ('raw/96000/IRC_1140_R_HRIR_96000.sofa', 'e304ac1bbaa5c6a893df64ed8e60926b'),
            ('raw/96000/IRC_1141_R_HRIR_96000.sofa', '4a5d2e971aed93c482f2701accabbc7e'),
            ('raw/96000/IRC_1142_R_HRIR_96000.sofa', 'bde059bee765cdbe53df2d483ea441e2'),
            ('raw/96000/IRC_1143_R_HRIR_96000.sofa', 'e5eb46195cb845e479125be75cac094f'),
            ('raw/96000/IRC_1144_R_HRIR_96000.sofa', 'befa471fcf879a7a5072a16889b2736d'),
            ('raw/96000/IRC_1145_R_HRIR_96000.sofa', '430ea999e9cf4f0537bfbb7abcd9301b'),
            ('raw/96000/IRC_1146_R_HRIR_96000.sofa', '4b6d668b8b438b43c565bced276dda94'),
            ('raw/96000/IRC_1147_R_HRIR_96000.sofa', 'd24a21c9e0d611bf70f57c99bdbac475'),
            ('raw/96000/IRC_1148_R_HRIR_96000.sofa', '8019478ef10997a375781140db34c0c5'),
            ('raw/96000/IRC_1149_R_HRIR_96000.sofa', '5ef40046881fd6066830c7257a9ba339'),
            ('raw/96000/IRC_1150_R_HRIR_96000.sofa', 'fe35d2d66ddbe666f8b8e727922d9eee'),
            ('raw/96000/IRC_1151_R_HRIR_96000.sofa', '77c5629ae922df958737b454ef2232c6'),
            ('raw/96000/IRC_1152_R_HRIR_96000.sofa', 'eabd25a81906f4e9e6361dfde343b131'),
            ('raw/96000/IRC_1153_R_HRIR_96000.sofa', '4b22a1168c1a07bbd1b3f78111749868'),
            ('raw/96000/IRC_1154_R_HRIR_96000.sofa', '1ad38ff96baffc8340b3bc5ed9b4f2a8'),
            ('raw/96000/IRC_1155_R_HRIR_96000.sofa', 'f987035f54355ea1dc6f4f42efa8f68f'),
            ('raw/96000/IRC_1156_R_HRIR_96000.sofa', 'e759e9f030b26924d5c0e9c3c71c1881'),
        ],
        'compensated-96000': [
            ('compensated/96000/IRC_1101_C_HRIR_96000.sofa', 'daaaf104525df05b574c2ad7e1298663'),
            ('compensated/96000/IRC_1102_C_HRIR_96000.sofa', 'f62d919c62768f6ecba9b4d624ba60e7'),
            ('compensated/96000/IRC_1103_C_HRIR_96000.sofa', '1cbaa451fe28f1ca41780eda6abe4cd6'),
            ('compensated/96000/IRC_1104_C_HRIR_96000.sofa', '3b844bf2d05ce024bbe92f9778cb0021'),
            ('compensated/96000/IRC_1105_C_HRIR_96000.sofa', '8560dcc9dfa0916b9b6af4d9a178c753'),
            ('compensated/96000/IRC_1106_C_HRIR_96000.sofa', 'a363e09edb62c70cda71d5c18743ac05'),
            ('compensated/96000/IRC_1107_C_HRIR_96000.sofa', 'e7520666d637405138e941759194199a'),
            ('compensated/96000/IRC_1108_C_HRIR_96000.sofa', '6f7ed91bb8391a446bbaf6b62195037b'),
            ('compensated/96000/IRC_1109_C_HRIR_96000.sofa', 'd20e23459a5fca63bb15f8d1be859aef'),
            ('compensated/96000/IRC_1110_C_HRIR_96000.sofa', '3766a695b6d7d727d7a552fe6fbb897d'),
            ('compensated/96000/IRC_1111_C_HRIR_96000.sofa', 'd8e7363e697b3c8f18397ca320dace31'),
            ('compensated/96000/IRC_1112_C_HRIR_96000.sofa', 'ab837e6d543321d6926c1654c9478891'),
            ('compensated/96000/IRC_1113_C_HRIR_96000.sofa', 'b2fd214d4c0c46b146c2728951001620'),
            ('compensated/96000/IRC_1114_C_HRIR_96000.sofa', '56b55081b1bd7522553cae8304666361'),
            ('compensated/96000/IRC_1115_C_HRIR_96000.sofa', '2319a68885eb54c638ac9dc20ac79c58'),
            ('compensated/96000/IRC_1116_C_HRIR_96000.sofa', 'cf15caafd7f277f7e6b5de22f3bfbfbe'),
            ('compensated/96000/IRC_1117_C_HRIR_96000.sofa', '138bd97cf366551cd1e028003560cf41'),
            ('compensated/96000/IRC_1118_C_HRIR_96000.sofa', '006abc7c4a8e05990a05fe86dc738378'),
            ('compensated/96000/IRC_1119_C_HRIR_96000.sofa', 'd5618e60a9f4a994deafe76a52260618'),
            ('compensated/96000/IRC_1120_C_HRIR_96000.sofa', '0a548417f9e1b2442efca81338d68454'),
            ('compensated/96000/IRC_1121_C_HRIR_96000.sofa', '956c1d7b1d8505406fb62c1c25e43f63'),
            ('compensated/96000/IRC_1122_C_HRIR_96000.sofa', '6130b0af014fa32732f8742b9dc84e0d'),
            ('compensated/96000/IRC_1124_C_HRIR_96000.sofa', 'b1c758844cdfe77a1bf341b249b5f96b'),
            ('compensated/96000/IRC_1125_C_HRIR_96000.sofa', '3c587b45f8568f7a19cd90f5cd33d6bd'),
            ('compensated/96000/IRC_1126_C_HRIR_96000.sofa', '53aa22e85cae34551dc5f8d626a9ff70'),
            ('compensated/96000/IRC_1127_C_HRIR_96000.sofa', 'e87450b74c7ef006c6468b5330df4e81'),
            ('compensated/96000/IRC_1128_C_HRIR_96000.sofa', '5eecd875ddb9d4cd64ff3478e16f0ca8'),
            ('compensated/96000/IRC_1129_C_HRIR_96000.sofa', 'ccb7dd7bae180d4815bf0f36ae6e6b5d'),
            ('compensated/96000/IRC_1130_C_HRIR_96000.sofa', '564b49b19afd5a04435762f0b0f4154c'),
            ('compensated/96000/IRC_1131_C_HRIR_96000.sofa', 'ed12274eeab91b7aa8d4a13ed23f4a25'),
            ('compensated/96000/IRC_1132_C_HRIR_96000.sofa', '3865d5cf9f08a6e3c861df7a43cb7491'),
            ('compensated/96000/IRC_1133_C_HRIR_96000.sofa', 'ab952ffecab6d99616cccc4d41d36752'),
            ('compensated/96000/IRC_1134_C_HRIR_96000.sofa', 'ca69de33f94fcc0167f25783092c82b2'),
            ('compensated/96000/IRC_1135_C_HRIR_96000.sofa', '816a872a68bd4c3389af2abeb9380782'),
            ('compensated/96000/IRC_1136_C_HRIR_96000.sofa', '8e482c299fbac922c7aff63889294a45'),
            ('compensated/96000/IRC_1137_C_HRIR_96000.sofa', '7cd0770a73f42ba9a3c301817b48497f'),
            ('compensated/96000/IRC_1138_C_HRIR_96000.sofa', '78fe7a6b661bc0c5075622409d6bbba3'),
            ('compensated/96000/IRC_1139_C_HRIR_96000.sofa', 'fa3fa5719e0e646f1110dd40865b05b6'),
            ('compensated/96000/IRC_1140_C_HRIR_96000.sofa', 'e1caf6a3d7b4a55a229d350e27e96ebb'),
            ('compensated/96000/IRC_1141_C_HRIR_96000.sofa', 'e38605e168352d3025defd525d05087c'),
            ('compensated/96000/IRC_1142_C_HRIR_96000.sofa', '3bb81fffca0cb6d796fa1a1e4d217647'),
            ('compensated/96000/IRC_1143_C_HRIR_96000.sofa', '06d9fb11bcdbaa479cb91a67aa4508bb'),
            ('compensated/96000/IRC_1144_C_HRIR_96000.sofa', '08356a91c4de6f617c45afc1d2896395'),
            ('compensated/96000/IRC_1145_C_HRIR_96000.sofa', '90afcd8ac5c0cbeb17ccb43c0c63e5e0'),
            ('compensated/96000/IRC_1146_C_HRIR_96000.sofa', '6659764d5568027f53196c0dba62b508'),
            ('compensated/96000/IRC_1147_C_HRIR_96000.sofa', '1bdbab882a557b823e8b0b4e8655fd67'),
            ('compensated/96000/IRC_1148_C_HRIR_96000.sofa', '8a362c2422fd10198e3fa7ded3266976'),
            ('compensated/96000/IRC_1149_C_HRIR_96000.sofa', 'e5d85ce36c7bdc042afd93e6b5adf764'),
            ('compensated/96000/IRC_1150_C_HRIR_96000.sofa', '03ed03610f52a6e76ea9c8b63d62d77d'),
            ('compensated/96000/IRC_1151_C_HRIR_96000.sofa', '01313c49b92e3ce83b7ec4967c139d80'),
            ('compensated/96000/IRC_1152_C_HRIR_96000.sofa', '89d31415537374865c8333bb2edd0278'),
            ('compensated/96000/IRC_1153_C_HRIR_96000.sofa', 'b5448ae217c776d26f032c9a6bce8d8d'),
            ('compensated/96000/IRC_1154_C_HRIR_96000.sofa', 'c04047ec8d9c3bbddd8be3482a1d84e5'),
            ('compensated/96000/IRC_1155_C_HRIR_96000.sofa', 'edf600e5e89399092fa2a2f06e87e381'),
            ('compensated/96000/IRC_1156_C_HRIR_96000.sofa', 'd2491b8dcec64981157e8039b80d68cf'),
        ],
        'compensated-interpolated-44100': [
            ('compensated-interpolated/44100/IRC_1100_I_HRIR_44100.sofa', '80a23b303a740272a46816117a61c588'),
            ('compensated-interpolated/44100/IRC_1101_I_HRIR_44100.sofa', '9e20d517f69105b845a6df4f41099aee'),
            ('compensated-interpolated/44100/IRC_1102_I_HRIR_44100.sofa', 'f0253472dc67f8c38f98815b780fd3fd'),
            ('compensated-interpolated/44100/IRC_1103_I_HRIR_44100.sofa', '48ff7393521385663f5470feaa9eac7e'),
            ('compensated-interpolated/44100/IRC_1104_I_HRIR_44100.sofa', '169df022ff2e4bbfc971b2e0f933c5d6'),
            ('compensated-interpolated/44100/IRC_1105_I_HRIR_44100.sofa', '5ca53027f315f81b47c692c65a9ef3a9'),
            ('compensated-interpolated/44100/IRC_1106_I_HRIR_44100.sofa', '8ed7d180071d6ba60bbe7c3bd6f566da'),
            ('compensated-interpolated/44100/IRC_1107_I_HRIR_44100.sofa', '900cdebfc339f17b67231d9520a45577'),
            ('compensated-interpolated/44100/IRC_1108_I_HRIR_44100.sofa', '79508110677f28581d9acfe4332297ec'),
            ('compensated-interpolated/44100/IRC_1109_I_HRIR_44100.sofa', '6be72d4df071fa35d3b5360a737809eb'),
            ('compensated-interpolated/44100/IRC_1110_I_HRIR_44100.sofa', 'da7c21f95231064c46c4a32eb7d0f6ea'),
            ('compensated-interpolated/44100/IRC_1111_I_HRIR_44100.sofa', '5f9f39b7efbed0605d4b7bfefa661f4e'),
            ('compensated-interpolated/44100/IRC_1112_I_HRIR_44100.sofa', '4d2c106e6b7e38c6c70dc97d930307af'),
            ('compensated-interpolated/44100/IRC_1113_I_HRIR_44100.sofa', '2d4d0fcfb23d5d866a696c844b29d3db'),
            ('compensated-interpolated/44100/IRC_1114_I_HRIR_44100.sofa', 'fb56794428114b550b257b9a6953f43f'),
            ('compensated-interpolated/44100/IRC_1115_I_HRIR_44100.sofa', '496b41f29fc1699727fa4afe130300dd'),
            ('compensated-interpolated/44100/IRC_1116_I_HRIR_44100.sofa', '1cb7ac7b9225e1e057b842af68b55564'),
            ('compensated-interpolated/44100/IRC_1117_I_HRIR_44100.sofa', '929bbae2a2e7a4c325efafdad858fb31'),
            ('compensated-interpolated/44100/IRC_1118_I_HRIR_44100.sofa', '30bdbe465b86cf5f3f07ea32e34e4832'),
            ('compensated-interpolated/44100/IRC_1119_I_HRIR_44100.sofa', '3161b49ca86010d1b2fd822003b813cb'),
            ('compensated-interpolated/44100/IRC_1120_I_HRIR_44100.sofa', '11febf3b364ae3b3be900bcaf1204669'),
            ('compensated-interpolated/44100/IRC_1121_I_HRIR_44100.sofa', 'c46f0a028659d6e375486d1691233d4c'),
            ('compensated-interpolated/44100/IRC_1122_I_HRIR_44100.sofa', '027976cc34ca04572320321e7edba91f'),
            ('compensated-interpolated/44100/IRC_1124_I_HRIR_44100.sofa', '8bf5d8a7e6743c83992a9befb77fe5b4'),
            ('compensated-interpolated/44100/IRC_1125_I_HRIR_44100.sofa', 'b456039499bb3175df5af9f7154fe143'),
            ('compensated-interpolated/44100/IRC_1126_I_HRIR_44100.sofa', 'e7b9dc8ac3019719eaf5b6fc38dcfd93'),
            ('compensated-interpolated/44100/IRC_1127_I_HRIR_44100.sofa', '445682709ed4e05457d892eca57fb645'),
            ('compensated-interpolated/44100/IRC_1128_I_HRIR_44100.sofa', '7abc532ddf3c79d86ac7bed4292ae859'),
            ('compensated-interpolated/44100/IRC_1129_I_HRIR_44100.sofa', '1bb0440afc78647b111f52d62309fb0c'),
            ('compensated-interpolated/44100/IRC_1130_I_HRIR_44100.sofa', '8dceed725de1d74643011f0c118542fe'),
            ('compensated-interpolated/44100/IRC_1131_I_HRIR_44100.sofa', 'c4137ffef0e78f605d590386239cf900'),
            ('compensated-interpolated/44100/IRC_1132_I_HRIR_44100.sofa', '916627bf6047498fc7404bd165a28648'),
            ('compensated-interpolated/44100/IRC_1133_I_HRIR_44100.sofa', 'f674c32c868af9420e0df424c4a933b7'),
            ('compensated-interpolated/44100/IRC_1134_I_HRIR_44100.sofa', '8714f896308ae97b496491212818681a'),
            ('compensated-interpolated/44100/IRC_1135_I_HRIR_44100.sofa', '0c88e4f48578eee0d722afa4c452fcbd'),
            ('compensated-interpolated/44100/IRC_1136_I_HRIR_44100.sofa', '082b1059706fe4e12daf47e02126dd11'),
            ('compensated-interpolated/44100/IRC_1137_I_HRIR_44100.sofa', '64367e5575aab56304122c8473935ff6'),
            ('compensated-interpolated/44100/IRC_1138_I_HRIR_44100.sofa', 'afc896d2731d69f6c2e1c2cb2d510f4a'),
            ('compensated-interpolated/44100/IRC_1139_I_HRIR_44100.sofa', '5f460d9a6f9f598dfbf5167e136fc51a'),
            ('compensated-interpolated/44100/IRC_1140_I_HRIR_44100.sofa', '527b7b27dbe220d1d52883a19aa07acf'),
            ('compensated-interpolated/44100/IRC_1141_I_HRIR_44100.sofa', 'bc07a631b79e911472bb7a72fa1b0f2a'),
            ('compensated-interpolated/44100/IRC_1142_I_HRIR_44100.sofa', '82bd8467d621218ce83d4264a67fb2d9'),
            ('compensated-interpolated/44100/IRC_1143_I_HRIR_44100.sofa', 'ebf56aec45a3216013f9100b453ec876'),
            ('compensated-interpolated/44100/IRC_1144_I_HRIR_44100.sofa', '1df497186f417000de4b6c32e22ed4f7'),
            ('compensated-interpolated/44100/IRC_1145_I_HRIR_44100.sofa', '9b5c38c3ea58cd6d72106cdd03ca987f'),
            ('compensated-interpolated/44100/IRC_1146_I_HRIR_44100.sofa', '4f638cfc3c8cd94baa4caf5f408f0b77'),
            ('compensated-interpolated/44100/IRC_1147_I_HRIR_44100.sofa', '20861d322f7bfca6e2b93d941b14c55d'),
            ('compensated-interpolated/44100/IRC_1148_I_HRIR_44100.sofa', '1efab6379a47bd60239683fb99e6a0d5'),
            ('compensated-interpolated/44100/IRC_1149_I_HRIR_44100.sofa', 'd5d334049e6e1531ec08da2812e61e86'),
            ('compensated-interpolated/44100/IRC_1150_I_HRIR_44100.sofa', '7a39051778d8fb2f04d19f16a0d0559c'),
            ('compensated-interpolated/44100/IRC_1151_I_HRIR_44100.sofa', 'e386f7cfc302f1f9b330c7bf8c06aa21'),
            ('compensated-interpolated/44100/IRC_1152_I_HRIR_44100.sofa', '5560fc4aaf7ba5662028723e6289321d'),
            ('compensated-interpolated/44100/IRC_1153_I_HRIR_44100.sofa', '4f864f967f37fbff09c4ec6ba394fa80'),
            ('compensated-interpolated/44100/IRC_1154_I_HRIR_44100.sofa', '2ee9cb8cf6ec9a9017581817a1980857'),
            ('compensated-interpolated/44100/IRC_1155_I_HRIR_44100.sofa', '12dbe6c6398ecf0e40711d4ff28bd864'),
            ('compensated-interpolated/44100/IRC_1156_I_HRIR_44100.sofa', '8ccb30e8d257846f66c0cda45a5c2b0f'),
        ],
        'compensated-interpolated-48000': [
            ('compensated-interpolated/48000/IRC_1100_I_HRIR_48000.sofa', '2053a54984960ce96f14a1d3750dbbc9'),
            ('compensated-interpolated/48000/IRC_1101_I_HRIR_48000.sofa', 'aa4e97b5e08c7d32aa48d63a2dda72fe'),
            ('compensated-interpolated/48000/IRC_1102_I_HRIR_48000.sofa', 'ae81e47cf3ae2890a59737d01853ca23'),
            ('compensated-interpolated/48000/IRC_1103_I_HRIR_48000.sofa', '4c648f83357180f7e30c410dccc112f8'),
            ('compensated-interpolated/48000/IRC_1104_I_HRIR_48000.sofa', '959154b8abc069de8ec35131b690d673'),
            ('compensated-interpolated/48000/IRC_1105_I_HRIR_48000.sofa', 'ad32d0d752757526230b9ad7bf571b76'),
            ('compensated-interpolated/48000/IRC_1106_I_HRIR_48000.sofa', '545040436c730c47f19e861dc08a6eb9'),
            ('compensated-interpolated/48000/IRC_1107_I_HRIR_48000.sofa', '19b26119995e0928ccd488304a6fecc7'),
            ('compensated-interpolated/48000/IRC_1108_I_HRIR_48000.sofa', '3e4aec49be521aaa9418a212e14688da'),
            ('compensated-interpolated/48000/IRC_1109_I_HRIR_48000.sofa', '224ca61c76cd4b0dc743e2c54f63e3b5'),
            ('compensated-interpolated/48000/IRC_1110_I_HRIR_48000.sofa', 'adc88980b5bd6be97eebad8d444d8bb5'),
            ('compensated-interpolated/48000/IRC_1111_I_HRIR_48000.sofa', '87397df741fdfc67fd2918ea9a4be5ed'),
            ('compensated-interpolated/48000/IRC_1112_I_HRIR_48000.sofa', '587a8010dbdc54ecd8c3ec33adb4a360'),
            ('compensated-interpolated/48000/IRC_1113_I_HRIR_48000.sofa', '353f467678e3c2897ac8ca8fe8838f8a'),
            ('compensated-interpolated/48000/IRC_1114_I_HRIR_48000.sofa', '7a068a686a3fb750783476d5453bdfe1'),
            ('compensated-interpolated/48000/IRC_1115_I_HRIR_48000.sofa', 'c9374eefd8a07d86caba04b902b712bc'),
            ('compensated-interpolated/48000/IRC_1116_I_HRIR_48000.sofa', '5663b48179b733c281cf6a6bb7c578e2'),
            ('compensated-interpolated/48000/IRC_1117_I_HRIR_48000.sofa', '50ea4d8f02c42bad5cae93d01794fffc'),
            ('compensated-interpolated/48000/IRC_1118_I_HRIR_48000.sofa', 'aab3a86d1ce733142c66c69a89a67476'),
            ('compensated-interpolated/48000/IRC_1119_I_HRIR_48000.sofa', '2f1013ae9add32e81851618c99375068'),
            ('compensated-interpolated/48000/IRC_1120_I_HRIR_48000.sofa', 'a0504c629776e67e1dc12ec1f7c98ff5'),
            ('compensated-interpolated/48000/IRC_1121_I_HRIR_48000.sofa', '16846ec31c303d7b031a28370a8b15b2'),
            ('compensated-interpolated/48000/IRC_1122_I_HRIR_48000.sofa', '0ebbd18d202dfd1dbc75f72db7275c5c'),
            ('compensated-interpolated/48000/IRC_1124_I_HRIR_48000.sofa', 'b74bfa3f72f1e54906f65e1c80498c77'),
            ('compensated-interpolated/48000/IRC_1125_I_HRIR_48000.sofa', '00b43060f38db4a71c2a2403d7bfebaf'),
            ('compensated-interpolated/48000/IRC_1126_I_HRIR_48000.sofa', '60aec03c4a2a54c2dbfe1f1906d7b3bf'),
            ('compensated-interpolated/48000/IRC_1127_I_HRIR_48000.sofa', 'de7d513842929acb56d9dc86d109140e'),
            ('compensated-interpolated/48000/IRC_1128_I_HRIR_48000.sofa', 'b47abd39016a84cf3c074602b4e2f536'),
            ('compensated-interpolated/48000/IRC_1129_I_HRIR_48000.sofa', '8dde32d79d76ccf4e911626d19ec4c77'),
            ('compensated-interpolated/48000/IRC_1130_I_HRIR_48000.sofa', '867756fb10e06c35274616f45f4bd28b'),
            ('compensated-interpolated/48000/IRC_1131_I_HRIR_48000.sofa', 'd1b2aff850c8a654203a777f8d67fe09'),
            ('compensated-interpolated/48000/IRC_1132_I_HRIR_48000.sofa', '3fc79b437a28ba1508cabf8f08c100b2'),
            ('compensated-interpolated/48000/IRC_1133_I_HRIR_48000.sofa', 'bd8b70c371af76322ad6d8463ba11dcb'),
            ('compensated-interpolated/48000/IRC_1134_I_HRIR_48000.sofa', 'c91b5ce8ce21038734b92de5bc363b80'),
            ('compensated-interpolated/48000/IRC_1135_I_HRIR_48000.sofa', '55c7280b719f1700a313d55683c64769'),
            ('compensated-interpolated/48000/IRC_1136_I_HRIR_48000.sofa', '8315fa7c19a88ebe6dc68b08b38218cd'),
            ('compensated-interpolated/48000/IRC_1137_I_HRIR_48000.sofa', 'c21d428130fcc62f6238a6bfcc03cda5'),
            ('compensated-interpolated/48000/IRC_1138_I_HRIR_48000.sofa', '6ad68ee972c8e9bec282fe8f53d64ead'),
            ('compensated-interpolated/48000/IRC_1139_I_HRIR_48000.sofa', 'f122c737c3eb9a362b96a1e6847b6b31'),
            ('compensated-interpolated/48000/IRC_1140_I_HRIR_48000.sofa', '78ecd0a13c29727bc632aaed24d534bb'),
            ('compensated-interpolated/48000/IRC_1141_I_HRIR_48000.sofa', 'f5daf05aef3e002cd0bd9728a73ce274'),
            ('compensated-interpolated/48000/IRC_1142_I_HRIR_48000.sofa', '045f99daf388de3eb802d6a8fc0eba5a'),
            ('compensated-interpolated/48000/IRC_1143_I_HRIR_48000.sofa', 'fa4723bd1fc6f437d4525a356b1d6ddd'),
            ('compensated-interpolated/48000/IRC_1144_I_HRIR_48000.sofa', 'bcfeff575f04acf717165eea0a076a03'),
            ('compensated-interpolated/48000/IRC_1145_I_HRIR_48000.sofa', 'f42b92fbc8af7c5cca7f05d23676a8f7'),
            ('compensated-interpolated/48000/IRC_1146_I_HRIR_48000.sofa', 'fae5e83a9ddd3512636674b29c94a232'),
            ('compensated-interpolated/48000/IRC_1147_I_HRIR_48000.sofa', '6115cba776e7aba32b5dd7dc500880d1'),
            ('compensated-interpolated/48000/IRC_1148_I_HRIR_48000.sofa', '9f1c2dbe625d16cbf182dea1c5e1e7a3'),
            ('compensated-interpolated/48000/IRC_1149_I_HRIR_48000.sofa', '71ef458e473c0cdd9991fcd6cc72cfd3'),
            ('compensated-interpolated/48000/IRC_1150_I_HRIR_48000.sofa', '714d155ffcbd9681afa9c1f27f86bd7e'),
            ('compensated-interpolated/48000/IRC_1151_I_HRIR_48000.sofa', '78f72c4ad83cd3d25205191f86e43e53'),
            ('compensated-interpolated/48000/IRC_1152_I_HRIR_48000.sofa', '364c2028f93d83c7cb7b61873f999119'),
            ('compensated-interpolated/48000/IRC_1153_I_HRIR_48000.sofa', 'aa4239d5f44acc090a6993cd4d6dad14'),
            ('compensated-interpolated/48000/IRC_1154_I_HRIR_48000.sofa', '73689a53df5c396c7cdfc9fe6e7cefdb'),
            ('compensated-interpolated/48000/IRC_1155_I_HRIR_48000.sofa', '923ea95d5634dff4d6e10a5dd842c5cf'),
            ('compensated-interpolated/48000/IRC_1156_I_HRIR_48000.sofa', 'a8d5bf5d1821f42e54c6553cb50420f7'),
        ],
        'compensated-interpolated-96000': [
            ('compensated-interpolated/96000/IRC_1100_I_HRIR_96000.sofa', 'b73ed970a6011a6429917a435095323c'),
            ('compensated-interpolated/96000/IRC_1101_I_HRIR_96000.sofa', 'a1d53a929387e63725c258ab97d29e90'),
            ('compensated-interpolated/96000/IRC_1102_I_HRIR_96000.sofa', '950edf191fa231c462166a95ae5601b6'),
            ('compensated-interpolated/96000/IRC_1103_I_HRIR_96000.sofa', '3d70251c64658b4e7ed638b7fdbd4e73'),
            ('compensated-interpolated/96000/IRC_1104_I_HRIR_96000.sofa', 'c8ac7f99705549e127dab96e7399a59e'),
            ('compensated-interpolated/96000/IRC_1105_I_HRIR_96000.sofa', 'c6fee03b0eb16b26df45baf8618ea1f5'),
            ('compensated-interpolated/96000/IRC_1106_I_HRIR_96000.sofa', '4a62ec7cc66e2488ffab0a9e7c7ab330'),
            ('compensated-interpolated/96000/IRC_1107_I_HRIR_96000.sofa', '337a27f9e14e120331a36d3d94b8e234'),
            ('compensated-interpolated/96000/IRC_1108_I_HRIR_96000.sofa', 'c6c99a74f1834f972ff5ce490ee6e361'),
            ('compensated-interpolated/96000/IRC_1109_I_HRIR_96000.sofa', '644d0ec942af654ef71c1e9c2e76468a'),
            ('compensated-interpolated/96000/IRC_1110_I_HRIR_96000.sofa', 'c2e9246bb6626fd51c0aad70753ac575'),
            ('compensated-interpolated/96000/IRC_1111_I_HRIR_96000.sofa', 'e4a8f7b5addd94e3a752e7176a303b8d'),
            ('compensated-interpolated/96000/IRC_1112_I_HRIR_96000.sofa', '5cea11542d1cd486744c86b6f2801025'),
            ('compensated-interpolated/96000/IRC_1113_I_HRIR_96000.sofa', '6ee3b6406ace081aee3134791d2b3e84'),
            ('compensated-interpolated/96000/IRC_1114_I_HRIR_96000.sofa', '511f853ea4571b3fc4bf2a458d3b36c0'),
            ('compensated-interpolated/96000/IRC_1115_I_HRIR_96000.sofa', '29293fe3a8f89541ba5f663c860c631a'),
            ('compensated-interpolated/96000/IRC_1116_I_HRIR_96000.sofa', '441adbb1eef00cd0cf9b5321e5d1798b'),
            ('compensated-interpolated/96000/IRC_1117_I_HRIR_96000.sofa', 'aedf561c230cdcd25f7042bc883b36b4'),
            ('compensated-interpolated/96000/IRC_1118_I_HRIR_96000.sofa', '0364ebcbad649ba165b38f52efaea393'),
            ('compensated-interpolated/96000/IRC_1119_I_HRIR_96000.sofa', 'cf5724733368206a1b6338965dc62a6d'),
            ('compensated-interpolated/96000/IRC_1120_I_HRIR_96000.sofa', 'c2b28d66412cecaf4215304ab558e07e'),
            ('compensated-interpolated/96000/IRC_1121_I_HRIR_96000.sofa', '5a679ada1b34da8563861a988f4d5385'),
            ('compensated-interpolated/96000/IRC_1122_I_HRIR_96000.sofa', '14493f2326fb46e0a9a967c1edee8dfd'),
            ('compensated-interpolated/96000/IRC_1124_I_HRIR_96000.sofa', 'd772b9d0e4a38b1b7bbafc43fe0b9ed5'),
            ('compensated-interpolated/96000/IRC_1125_I_HRIR_96000.sofa', '4f93809409a521a2511cd6d67693e9c2'),
            ('compensated-interpolated/96000/IRC_1126_I_HRIR_96000.sofa', 'e05ced148d7ef94f5448f0e79c88564e'),
            ('compensated-interpolated/96000/IRC_1127_I_HRIR_96000.sofa', 'eb19bc0300b20ef1929784a52ed5853b'),
            ('compensated-interpolated/96000/IRC_1128_I_HRIR_96000.sofa', '206d50661a2141e699666f113f04d403'),
            ('compensated-interpolated/96000/IRC_1129_I_HRIR_96000.sofa', '127596bf001905418fa65d074c7b0fb0'),
            ('compensated-interpolated/96000/IRC_1130_I_HRIR_96000.sofa', '7092d7f70b177490bbdf22589b93692a'),
            ('compensated-interpolated/96000/IRC_1131_I_HRIR_96000.sofa', '190085d110a17a11b9d32443ceac9404'),
            ('compensated-interpolated/96000/IRC_1132_I_HRIR_96000.sofa', 'f72e2d9b68fb7641299d9c8ca9a7e425'),
            ('compensated-interpolated/96000/IRC_1133_I_HRIR_96000.sofa', '9657d8b6769645629687d60854811117'),
            ('compensated-interpolated/96000/IRC_1134_I_HRIR_96000.sofa', 'ffce19d44391af6ebb819e59c124cd9b'),
            ('compensated-interpolated/96000/IRC_1135_I_HRIR_96000.sofa', '4d2698fc14370025847763d94695a77e'),
            ('compensated-interpolated/96000/IRC_1136_I_HRIR_96000.sofa', '416b2b0f0f216d52c40469b5302730c3'),
            ('compensated-interpolated/96000/IRC_1137_I_HRIR_96000.sofa', '73292963b21041503b0fa58ea00a2f22'),
            ('compensated-interpolated/96000/IRC_1138_I_HRIR_96000.sofa', '37364342db252970a89b4e46011f5931'),
            ('compensated-interpolated/96000/IRC_1139_I_HRIR_96000.sofa', '36a64efb88f1fdad100450865d7c4df9'),
            ('compensated-interpolated/96000/IRC_1140_I_HRIR_96000.sofa', 'a9d09e748f9b6fb134e339456aafe5f4'),
            ('compensated-interpolated/96000/IRC_1141_I_HRIR_96000.sofa', '3015248db20d70ef8e7e61a0772852d5'),
            ('compensated-interpolated/96000/IRC_1142_I_HRIR_96000.sofa', 'c4add625654c77d2fad1fb765af8baa0'),
            ('compensated-interpolated/96000/IRC_1143_I_HRIR_96000.sofa', '9a08fda26a22979d1e7c03d0652a8da6'),
            ('compensated-interpolated/96000/IRC_1144_I_HRIR_96000.sofa', '5ae66262f9ca9596da2dfdb196a86dad'),
            ('compensated-interpolated/96000/IRC_1145_I_HRIR_96000.sofa', 'f6c987de7473bde64349d022eacad267'),
            ('compensated-interpolated/96000/IRC_1146_I_HRIR_96000.sofa', '191021dc629abe6afda9bf2837b7d506'),
            ('compensated-interpolated/96000/IRC_1147_I_HRIR_96000.sofa', '6b4f22f64352771ea5be939f99dc19ac'),
            ('compensated-interpolated/96000/IRC_1148_I_HRIR_96000.sofa', '8dbeec3d1e7452b50c08a3742d33726f'),
            ('compensated-interpolated/96000/IRC_1149_I_HRIR_96000.sofa', '338172f947a25fd13ac554847d136733'),
            ('compensated-interpolated/96000/IRC_1150_I_HRIR_96000.sofa', '86c6ec42db9df7067525ee47181d4d22'),
            ('compensated-interpolated/96000/IRC_1151_I_HRIR_96000.sofa', 'e41749af93db091c7d945439ec297e90'),
            ('compensated-interpolated/96000/IRC_1152_I_HRIR_96000.sofa', '4915ea3104903623c1878059d544e98a'),
            ('compensated-interpolated/96000/IRC_1153_I_HRIR_96000.sofa', '62ee84905067b6d70017d788f7f5493e'),
            ('compensated-interpolated/96000/IRC_1154_I_HRIR_96000.sofa', '91d002251a341fc29612d308495f720d'),
            ('compensated-interpolated/96000/IRC_1155_I_HRIR_96000.sofa', '0547e6686af40193c547423712be96de'),
            ('compensated-interpolated/96000/IRC_1156_I_HRIR_96000.sofa', 'aa6df0b123a57f5803bbecec3c46f53b'),
        ],
    },
    'ita': {
        '': [
            ('MRT01.sofa', 'f98c21ddd4d5c386a60ee07d064995bf'),
            ('MRT02.sofa', 'f98678bf7ad4862f793c5016c9f1a672'),
            ('MRT03.sofa', 'ccfd9ce8d99bd31471e57b47d90045bb'),
            ('MRT04.sofa', 'b08eda9058d76edf9721fe3a531d6d0b'),
            ('MRT05.sofa', '738d407152a3f740d71903db98fbf5c0'),
            ('MRT06.sofa', '28c645319365c40a24e17f5475093f94'),
            ('MRT07.sofa', 'ffae7ddcc6530d045da664ec8abde3b6'),
            ('MRT08.sofa', '10d217dd8bf107a7c9faef5cc2c15955'),
            ('MRT09.sofa', '22ab54bba8c6b6ed084b14f7f23bf4d8'),
            ('MRT10.sofa', '407a30983f4d53388860d3dc80bdaeaa'),
            ('MRT11.sofa', '797957ed32991d5a8b3961924ea2083b'),
            ('MRT12.sofa', 'a13322c9b78b5d1f8737b850908576bd'),
            ('MRT13.sofa', '602fec190ad87ad5bd83119f7c554f28'),
            ('MRT14.sofa', '9da56bd311af2c965a862e608f59d0cc'),
            ('MRT15.sofa', 'df83ec2fe0e790f4643041ff2270f5d0'),
            ('MRT16.sofa', '33554add0d5bb272e966e844f059a522'),
            ('MRT17.sofa', '7340f2354bf84ef1a19374ceb2671b85'),
            ('MRT18.sofa', '51eebeff5c775ee6ef46f2cc4df8f05d'),
            ('MRT19.sofa', '0498a8acfcc2bf20940eb79be2fd5e82'),
            ('MRT20.sofa', '68590554aa4bfedde4e0ad314fcc505a'),
            ('MRT21.sofa', 'c7fd041bf45f9dc2f02579bd5dcad22e'),
            ('MRT22.sofa', '578ac1a3f0b6b8b2fe2f33da9ab9e2ed'),
            ('MRT23.sofa', 'e02082c830c5e21e2d5fd927a0e04a2b'),
            ('MRT24.sofa', 'c9b8e7be653348cc4a8a4052b84a9f55'),
            ('MRT25.sofa', '1bf0256af5f177886d30de350b90a16f'),
            ('MRT26.sofa', '0696a292e8630c6fb7bf7c98326f2464'),
            ('MRT27.sofa', 'e3c789bdc6f766fc8866e9fce82d60f5'),
            ('MRT28.sofa', 'e28b48c04edc657072357c8782d572e8'),
            ('MRT29.sofa', '05d66312c30dff5f54a2c56c578110e6'),
            ('MRT30.sofa', '68cde9eda325352cccee46c0e7b97763'),
            ('MRT31.sofa', '125d3f06c512fc0dd7ad22b1e5012d6f'),
            ('MRT32.sofa', 'b669b0032bf3e0e27c25f6b58512e3aa'),
            ('MRT33.sofa', 'a43bb7692bff85eeab847b3dca514147'),
            ('MRT34.sofa', 'f271dc4166b4926147c35a243f976c61'),
            ('MRT35.sofa', 'db1c1922c5a21febf5181857017cd92f'),
            ('MRT36.sofa', 'f4f16ad223e5e4f6c168338da9c7111e'),
            ('MRT37.sofa', '160ce715140ed2cb432838d93e8d4e73'),
            ('MRT38.sofa', '289e35cb18a99a928747da67ccc00248'),
            ('MRT39.sofa', '948a445d6f4a4ecb9c105b6d90967b88'),
            ('MRT40.sofa', 'e4ee21ad97336f1ed5cb973e45da0047'),
            ('MRT41.sofa', 'e32076ba682ac151f185f29a236914f1'),
            ('MRT42.sofa', 'ff8eb16a85003b0dab2bfb46e5d406f3'),
            ('MRT43.sofa', '412b56ed885aa6668137a71b8e2bb8c2'),
            ('MRT44.sofa', 'aad3527460ca2ddad1c13c7fd8e32550'),
            ('MRT45.sofa', 'bdecc617bfe84106084b8d2f22435df1'),
            ('MRT46.sofa', '8e3d44a3b5159506f1dde5066e7a3baa'),
            ('MRT47.sofa', 'd58775ece75a0086707fa4afc16f7e21'),
            ('MRT48.sofa', '7a95b6541328d6d55293ac2c4512df8c'),
        ],
    },
    'hutubs': {
        'acoustic': [
            ('pp1_HRIRs_measured.sofa', '8bbf12f193a9296eb5ba2e2f68a81c09'),
            ('pp2_HRIRs_measured.sofa', '3639bf7e82c704f9531204b62d68a4f3'),
            ('pp3_HRIRs_measured.sofa', 'c17096043c53214eb972a29b3f21edfd'),
            ('pp4_HRIRs_measured.sofa', '1311bd4d95c7633e703d3b7e587e3af4'),
            ('pp5_HRIRs_measured.sofa', '7d29dba50e36e2b6a1ef4986862e1f3c'),
            ('pp6_HRIRs_measured.sofa', 'be445ee1ce89e04828b758f7fe7d17eb'),
            ('pp7_HRIRs_measured.sofa', 'dcdae86560367ca0e4b8bef7dc1e5355'),
            ('pp8_HRIRs_measured.sofa', 'd8700fed36272f3506de718c452653db'),
            ('pp9_HRIRs_measured.sofa', 'eeea330f7e82316ad06fe08941aa3e14'),
            ('pp10_HRIRs_measured.sofa', 'b0d1e524e665c55f3860c290c6d5c1b8'),
            ('pp11_HRIRs_measured.sofa', '2171ac8cde771e912c628b42926dfe1b'),
            ('pp12_HRIRs_measured.sofa', '005cec8e85e155a1e1dbd8e758035edc'),
            ('pp13_HRIRs_measured.sofa', 'c9690d1823cfee6a55a394106ed895ac'),
            ('pp14_HRIRs_measured.sofa', '81d87586e95a9e5a2d0b4a6b9c28e29e'),
            ('pp15_HRIRs_measured.sofa', '8a35e702222351ac9da7885c21301dfd'),
            ('pp16_HRIRs_measured.sofa', '665568e56d233ce56f4898d424f99d1d'),
            ('pp17_HRIRs_measured.sofa', '48fc083c38360601e1c0b49ea4d1a8ad'),
            ('pp18_HRIRs_measured.sofa', 'df809ce9f86995e9ac5d3220a180b213'),
            ('pp19_HRIRs_measured.sofa', 'e519eea5bf45d9fe7ff5e28c7a809287'),
            ('pp20_HRIRs_measured.sofa', 'bf5b2c3fb53b955c14f28c953b1db17b'),
            ('pp21_HRIRs_measured.sofa', 'bb9f70f40fa4c7224f20aef3bb90b707'),
            ('pp22_HRIRs_measured.sofa', '362aa189b57c923d99fda852c2b7d7b3'),
            ('pp23_HRIRs_measured.sofa', '6ef7d15230050ab7f00018b57d0543a6'),
            ('pp24_HRIRs_measured.sofa', '48e072ac5d2784381c6000d47e96e00f'),
            ('pp25_HRIRs_measured.sofa', 'd7ddecfbbaaa1e2c6eef17d6810748fb'),
            ('pp26_HRIRs_measured.sofa', 'fa30faf5eddebea3d662c7fcb0fdf4dd'),
            ('pp27_HRIRs_measured.sofa', 'c81f95d5bc6425ec6b3a45c1e4e5e08e'),
            ('pp28_HRIRs_measured.sofa', 'b999403c49fdf21d7bd4020d7d34d474'),
            ('pp29_HRIRs_measured.sofa', 'e691fd2c22ad80da29182e087755bff3'),
            ('pp30_HRIRs_measured.sofa', '493c53687533685f002929e830cca243'),
            ('pp31_HRIRs_measured.sofa', 'c61b891a13c9c7f57273191650aed3a7'),
            ('pp32_HRIRs_measured.sofa', '9838724e4d72de0d8c6c4ca0193d39f0'),
            ('pp33_HRIRs_measured.sofa', 'a4add2d6c4891851033ba3354047d250'),
            ('pp34_HRIRs_measured.sofa', '463626abab6ff15b9ebf993cbbac589b'),
            ('pp35_HRIRs_measured.sofa', '7842f050afeaea9c858afba39526cdac'),
            ('pp36_HRIRs_measured.sofa', '0c4683a7add1ca74e704b5ea9defb4c3'),
            ('pp37_HRIRs_measured.sofa', '9e6aa2af34d534bf8008e20fd8c8b88b'),
            ('pp38_HRIRs_measured.sofa', '5f28faa65f31786f2e54c7300d06bcc9'),
            ('pp39_HRIRs_measured.sofa', 'f9523e3cea2dbd5ee79831bac55187a5'),
            ('pp40_HRIRs_measured.sofa', '1ee6afb3f87fbc2faaa4d0014e0d03a9'),
            ('pp41_HRIRs_measured.sofa', '200d9279a6f861266a7b549c9cd81d19'),
            ('pp42_HRIRs_measured.sofa', 'b705a26e59180ce1c5c1cd7ee9e49062'),
            ('pp43_HRIRs_measured.sofa', '352302672234e54da151ec4c538d076f'),
            ('pp44_HRIRs_measured.sofa', 'e282921536dd0a9033f2adbe8b1314b1'),
            ('pp45_HRIRs_measured.sofa', '180ac70ce387e65c9fc3bd8c586b3d5e'),
            ('pp46_HRIRs_measured.sofa', '32659e0f9abc0582874c3e81c672faa0'),
            ('pp47_HRIRs_measured.sofa', '3ddfe9fe3b346c998a081249b0c56a85'),
            ('pp48_HRIRs_measured.sofa', '5a0716a4887420b5025b7780d5b3a2b0'),
            ('pp49_HRIRs_measured.sofa', '3291c1ecae54e8eabfa0013e6e21c6d9'),
            ('pp50_HRIRs_measured.sofa', 'd87794d5972ab8aa2da1aeced0e22470'),
            ('pp51_HRIRs_measured.sofa', '2a7c6ccfbbd3668b6fb6924caa0d10fa'),
            ('pp52_HRIRs_measured.sofa', 'be0999dc60a8c41c3fde5935d882e38b'),
            ('pp53_HRIRs_measured.sofa', '8a18364b5f4b85207e088d7b41d34b8f'),
            ('pp54_HRIRs_measured.sofa', '571684a864768cbacd000670fb612d31'),
            ('pp55_HRIRs_measured.sofa', '76c4f93787175edf94e421c6900032ef'),
            ('pp56_HRIRs_measured.sofa', 'b2fd23d675a872bdbe2203a5d685ef0a'),
            ('pp57_HRIRs_measured.sofa', 'f3148cdac568155d37467334d3919890'),
            ('pp58_HRIRs_measured.sofa', '5e7bc3e9c9676b0355fb57c7b2925434'),
            ('pp59_HRIRs_measured.sofa', 'eb520c61da3c2bc645a73b5d56a0e822'),
            ('pp60_HRIRs_measured.sofa', '4e1cff7ed8611d0f93820b7600c9b3fb'),
            ('pp61_HRIRs_measured.sofa', 'c48314d88b4bab38dbbf50a4b486e2c6'),
            ('pp62_HRIRs_measured.sofa', 'cee984ae225219b814fc3752f64ed6ab'),
            ('pp63_HRIRs_measured.sofa', 'c33b638a49af57f9ecd916a18c9bb2ab'),
            ('pp64_HRIRs_measured.sofa', '1868d3f77a85dbe1bc05fd3631cfbae4'),
            ('pp65_HRIRs_measured.sofa', '1875444c11dd7139db3889e3b01a495a'),
            ('pp66_HRIRs_measured.sofa', '6af209715241ab2173131bcd346d4e28'),
            ('pp67_HRIRs_measured.sofa', '3feac17721df892f2ea70e79c1e62dee'),
            ('pp68_HRIRs_measured.sofa', 'e2e4ef79dbf012e6608ea6b0ffce2b61'),
            ('pp69_HRIRs_measured.sofa', '4e634080df92d41b432f83fea58230de'),
            ('pp70_HRIRs_measured.sofa', '3d6348d597ba133f82b185e1bcd3f033'),
            ('pp71_HRIRs_measured.sofa', '8233337bc150af2042d2073bfe9ece40'),
            ('pp72_HRIRs_measured.sofa', '11d40a04994ac588d52e6da088064ccc'),
            ('pp73_HRIRs_measured.sofa', '7da82626008da0c2338e2cd18d090995'),
            ('pp74_HRIRs_measured.sofa', 'd238f3a555ace4f1f88a8524a0e67018'),
            ('pp75_HRIRs_measured.sofa', '40c37682202732b152c9c114ca7c4540'),
            ('pp76_HRIRs_measured.sofa', '80354f15d03688b432c834c42bdc1281'),
            ('pp77_HRIRs_measured.sofa', '879a8c29fe0743f573be2399c57eaacf'),
            ('pp78_HRIRs_measured.sofa', 'ba3bc7bbb746070ab8ff4f80a6348229'),
            ('pp79_HRIRs_measured.sofa', '198a3a7eef5f6bf48b799ff265732904'),
            ('pp80_HRIRs_measured.sofa', 'cd205d9e5c06b784c07933151d31ea1a'),
            ('pp81_HRIRs_measured.sofa', '93703440c2f79f58654bf8e5415deb39'),
            ('pp82_HRIRs_measured.sofa', '648b72cfc85e61aa282a2115bc84d4cb'),
            ('pp83_HRIRs_measured.sofa', 'b3c16a57b588608c0c4a5efae5b24c7e'),
            ('pp84_HRIRs_measured.sofa', 'b971fa177c3526420a3fc95ee574c308'),
            ('pp85_HRIRs_measured.sofa', '736e04ae2c191426c2b85b5e879269e3'),
            ('pp86_HRIRs_measured.sofa', '3402cedc5834fef3e0a4942349e40145'),
            ('pp87_HRIRs_measured.sofa', '04e7685d8f70bb5bff7a25be3946ef64'),
            ('pp88_HRIRs_measured.sofa', 'ec141fd7dc1b08c36bab1a4fe31ee905'),
            ('pp89_HRIRs_measured.sofa', 'bbc52d776c877d29b375e05dc1987583'),
            ('pp90_HRIRs_measured.sofa', '4735eb9e3121096226a8483649007d2c'),
            ('pp91_HRIRs_measured.sofa', 'c3c1b086ab27124a45935abc269c559e'),
            ('pp92_HRIRs_measured.sofa', '99608bc4b0397cfd5dacf63ec4d353a9'),
            ('pp93_HRIRs_measured.sofa', '3054740b8be467a0f4f3dfc03a330273'),
            ('pp94_HRIRs_measured.sofa', 'bc2129a8a70cb6e67ac9930337ffff6a'),
            ('pp95_HRIRs_measured.sofa', '7abc9520af3c2701a870f76ead5648b8'),
            ('pp96_HRIRs_measured.sofa', '215ff83351fd03839ca8e9c1e25289d4'),
        ],
        'simulated': [
            ('pp1_HRIRs_simulated.sofa', '45749c999f2b7c080b42dcc1fc9d030b'),
            ('pp2_HRIRs_simulated.sofa', '40bb009e5cc4cc0e930170f569fd69f5'),
            ('pp3_HRIRs_simulated.sofa', '27be1e46f1c8d01394dad7f3815fc7e2'),
            ('pp4_HRIRs_simulated.sofa', '82cae958d7f2fb6ce8e1f80ae4a0590a'),
            ('pp5_HRIRs_simulated.sofa', '5eadf717daf411e50762412af3e22a92'),
            ('pp6_HRIRs_simulated.sofa', '70e517b033b4c9ae291cb84901933e5a'),
            ('pp7_HRIRs_simulated.sofa', 'a5633aacb791c14f0f2a38bfcf2a9af3'),
            ('pp8_HRIRs_simulated.sofa', 'ae1ceb8754a43bc01da57b82497d984a'),
            ('pp9_HRIRs_simulated.sofa', '78d06d4f2fffa25e0cfbefa34e7a9822'),
            ('pp10_HRIRs_simulated.sofa', '6d8bfab8b6866a7e3198f9b3a0624137'),
            ('pp11_HRIRs_simulated.sofa', 'e67485585f86fe57545f365045be08b2'),
            ('pp12_HRIRs_simulated.sofa', '52a6babff8ef0354ef079e174966626a'),
            ('pp13_HRIRs_simulated.sofa', 'd01c54fb85e5d2f62fa726768b2a8f34'),
            ('pp14_HRIRs_simulated.sofa', '80aa0224cb453de43c8687e7cfb865bb'),
            ('pp15_HRIRs_simulated.sofa', '8b8496839474b5fab9094065d459db3e'),
            ('pp16_HRIRs_simulated.sofa', 'd84a9b06df515df0511fc4258333d82a'),
            ('pp17_HRIRs_simulated.sofa', '7696ca297e6cb9a1d570a2da3417d07f'),
            ('pp18_HRIRs_simulated.sofa', 'f22d8f33aaa0172c74c80292019337d6'),
            ('pp19_HRIRs_simulated.sofa', 'd486d0b33b9de9e06298ceb30bfd5977'),
            ('pp20_HRIRs_simulated.sofa', '7291fcc7a7335cb793d3636fdbe767a5'),
            ('pp21_HRIRs_simulated.sofa', '75f953cc44c639eb588789b2bda4fef1'),
            ('pp22_HRIRs_simulated.sofa', '01e11d58f5e672912fd8db34edd704e8'),
            ('pp23_HRIRs_simulated.sofa', 'da9d8a9e938fa81a077414b1e47df6af'),
            ('pp24_HRIRs_simulated.sofa', 'f04d158d4bd750d463f4b11ed775bd12'),
            ('pp25_HRIRs_simulated.sofa', 'b327503d23b18cf9bf3ecb5a52f75728'),
            ('pp26_HRIRs_simulated.sofa', '09bead4c2ee6279b1d8d6a56bc3c3dd3'),
            ('pp27_HRIRs_simulated.sofa', 'c4ff01cc87e2749ec766180c662ffd7a'),
            ('pp28_HRIRs_simulated.sofa', '9b9475caff0a498bf0745a25055d4fe3'),
            ('pp29_HRIRs_simulated.sofa', 'b2259388ae259b73fc0195f85e18016f'),
            ('pp30_HRIRs_simulated.sofa', 'be0e723113915255c0fddf6518d9118a'),
            ('pp31_HRIRs_simulated.sofa', '4f7260a34fe6f654b3f473980f4fbe0e'),
            ('pp32_HRIRs_simulated.sofa', '0fd58f79302726e791ba006d85938037'),
            ('pp33_HRIRs_simulated.sofa', '59ced3966fa1947bc9c94522a5a5bc0c'),
            ('pp34_HRIRs_simulated.sofa', '699247b394ead09662b39eba51b28e02'),
            ('pp35_HRIRs_simulated.sofa', '20760d2197f5ccbf16aca196852c1bad'),
            ('pp36_HRIRs_simulated.sofa', '393500324dc00d4d39b67241d9100515'),
            ('pp37_HRIRs_simulated.sofa', 'e70bedb6cd42d7854d75f6cb26bd9a1f'),
            ('pp38_HRIRs_simulated.sofa', 'add6444818fa9cf25046f268ab94ab0e'),
            ('pp39_HRIRs_simulated.sofa', '2efd5db7d966674fd02306d8219e9e16'),
            ('pp40_HRIRs_simulated.sofa', '4feddf9a7376a6f2bac607e237843e21'),
            ('pp41_HRIRs_simulated.sofa', '307c70c0d3a027e818f5f016063da369'),
            ('pp42_HRIRs_simulated.sofa', 'bfe9e81801e279a709ce5a3b7ec8900a'),
            ('pp43_HRIRs_simulated.sofa', '14ba33de2e8f5fccb23328a7165a632f'),
            ('pp44_HRIRs_simulated.sofa', '408eec681c35c8e857a3daf03999ab01'),
            ('pp45_HRIRs_simulated.sofa', '7d4df25d2c346a184a81aad4537e6f93'),
            ('pp46_HRIRs_simulated.sofa', 'c4fa9d681aeaa658470a15e5181d9385'),
            ('pp47_HRIRs_simulated.sofa', 'e7d7a507c0a9e52f6871f980a62f9254'),
            ('pp48_HRIRs_simulated.sofa', 'f5bfac789f352c2b1045d1fb862db1ec'),
            ('pp49_HRIRs_simulated.sofa', 'c8668574f8174c0c1792b5c172ce76df'),
            ('pp50_HRIRs_simulated.sofa', '0753135b0a3627ddbaa8f6eb2f287ea5'),
            ('pp51_HRIRs_simulated.sofa', 'b824e9eb4068a8c629741e2809869ea3'),
            ('pp52_HRIRs_simulated.sofa', '44c27fb137ad27028e629ddf1093ed0a'),
            ('pp53_HRIRs_simulated.sofa', '9b99e51e32c8d3dada37a7d4b94ea776'),
            ('pp54_HRIRs_simulated.sofa', 'e1370ba8dbc706a2eb22b7597d9ea912'),
            ('pp55_HRIRs_simulated.sofa', 'c4a27932b0f01acd668454d4c25dd898'),
            ('pp56_HRIRs_simulated.sofa', '4e8bdc872764ccf05235a72fc13b052d'),
            ('pp57_HRIRs_simulated.sofa', '174014d5ea1ed3909bb44900bc6ab650'),
            ('pp58_HRIRs_simulated.sofa', '39e490228282afb1f0ba2cdd00a4f114'),
            ('pp59_HRIRs_simulated.sofa', '0a120479404e46ecdc53f2f0a385dde3'),
            ('pp60_HRIRs_simulated.sofa', 'ed0b200332ea9b9c21a7250f4376a67e'),
            ('pp61_HRIRs_simulated.sofa', '4375d9cb2c50e739a9c02d97baef87de'),
            ('pp62_HRIRs_simulated.sofa', 'a0cacde6e75f56972b74316ef703904d'),
            ('pp63_HRIRs_simulated.sofa', 'fe29ded0e922510397e0f116d6074f68'),
            ('pp64_HRIRs_simulated.sofa', '04990154a6a9e3984e9f87d07a2ad715'),
            ('pp65_HRIRs_simulated.sofa', '62fdd80fc21e5c848ce78e0b2d24a972'),
            ('pp66_HRIRs_simulated.sofa', 'c0efb7309e91b2c45c73f9bd5375a12d'),
            ('pp67_HRIRs_simulated.sofa', '8c451fd8f2f0a80d9d5fc521415281a6'),
            ('pp68_HRIRs_simulated.sofa', 'a47fc3b6a33027d7090452695059161e'),
            ('pp69_HRIRs_simulated.sofa', '052e678462cb6bf422185f0b563e1db8'),
            ('pp70_HRIRs_simulated.sofa', '7311816aaf53c91ab96a7df548a46f01'),
            ('pp71_HRIRs_simulated.sofa', '79068b5a544b4fa93c4a6b2998fcb7a6'),
            ('pp72_HRIRs_simulated.sofa', 'c720c3bee2af831eb5794232131006e5'),
            ('pp73_HRIRs_simulated.sofa', 'd166c71b636128c3c52cad58d0fb220a'),
            ('pp74_HRIRs_simulated.sofa', '0e4e5607190477703a560d60ad8bbca1'),
            ('pp75_HRIRs_simulated.sofa', '29c79307c08c671cd97e01f2087defab'),
            ('pp76_HRIRs_simulated.sofa', 'e77be9ed427ee597ac89d07be4290ae3'),
            ('pp77_HRIRs_simulated.sofa', '215272d8e7a3449a188213872b13279b'),
            ('pp78_HRIRs_simulated.sofa', '99fe955bf76c460aee209803b99567cb'),
            ('pp79_HRIRs_simulated.sofa', 'df42bee528505ec5d2cf30ee57ebea06'),
            ('pp80_HRIRs_simulated.sofa', '17cf33b88178cc6dbf913440e222da6e'),
            ('pp81_HRIRs_simulated.sofa', '017f04ee37076d7633a103a426525631'),
            ('pp82_HRIRs_simulated.sofa', '2e31b952ad99196e7111d803d69fbc01'),
            ('pp83_HRIRs_simulated.sofa', '0be038d49071c73107d21d9b21e11db0'),
            ('pp84_HRIRs_simulated.sofa', '22d80e3c610166070995b2b26e57de9e'),
            ('pp85_HRIRs_simulated.sofa', '94b5cd8af7199878819c9aabcb89c261'),
            ('pp86_HRIRs_simulated.sofa', 'd92490c928315b491db8a5e743c22f7d'),
            ('pp87_HRIRs_simulated.sofa', 'c2f2bd8f39fd29bdcc1c659754a21134'),
            ('pp88_HRIRs_simulated.sofa', '647e36a43a69e0ef7622b4d702d6908a'),
            ('pp89_HRIRs_simulated.sofa', '3a018cadadcca927a2763edaaefb7039'),
            ('pp90_HRIRs_simulated.sofa', 'ebab5694e542dbc5d0311fc455e5f019'),
            ('pp91_HRIRs_simulated.sofa', '02c2d4337a3d4c5220fd60b07ff90418'),
            ('pp92_HRIRs_simulated.sofa', 'd2422337e470366f555c88968116c31c'),
            ('pp93_HRIRs_simulated.sofa', '1e96d06f998a149324a16a8f7e6a812c'),
            ('pp94_HRIRs_simulated.sofa', '2b883f5ecc92fd668b969b0bee13e6dc'),
            ('pp95_HRIRs_simulated.sofa', '0d1dd1c340fae4a7492161094c815daf'),
            ('pp96_HRIRs_simulated.sofa', '3a5a24a4d0d7672b17d8cc882161766a'),
        ],
    },
    'riec': {
        '': [
            ('RIEC_hrir_subject_001.sofa', '5b0df7949cdf9245289e3366490a5f36'),
            ('RIEC_hrir_subject_002.sofa', 'a461dfe968cf3569692c708a662239c2'),
            ('RIEC_hrir_subject_003.sofa', '9ba4b2b10517105b774f10a74cdaf69e'),
            ('RIEC_hrir_subject_004.sofa', 'e6ec4330860cf93f481accf5161faa56'),
            ('RIEC_hrir_subject_005.sofa', 'e98f52da02a5de8074aa2de45b8f6771'),
            ('RIEC_hrir_subject_006.sofa', '9edc6764d97dc76ca2c7d43b6c8788c6'),
            ('RIEC_hrir_subject_007.sofa', 'ad26a097b9f861caeeac1c6da9697524'),
            ('RIEC_hrir_subject_008.sofa', '9dcb17face3e2c1ccdf3e4c48b8d0880'),
            ('RIEC_hrir_subject_009.sofa', 'ff2566159498becfe37da39fbdbdff03'),
            ('RIEC_hrir_subject_010.sofa', '38854839ab9edb594802eb40eff6ddfe'),
            ('RIEC_hrir_subject_011.sofa', 'a0a3161629cd7ee6a8d08a98f7068a99'),
            ('RIEC_hrir_subject_012.sofa', '4cff404e02874a7bd31df8e33a1aa511'),
            ('RIEC_hrir_subject_013.sofa', '819ab313bf4303ff7db19a9723525ad2'),
            ('RIEC_hrir_subject_014.sofa', '8fbf268ddd8e54fc6e878ab5feb810d3'),
            ('RIEC_hrir_subject_015.sofa', 'bd92744def49907f9250179370562c52'),
            ('RIEC_hrir_subject_016.sofa', '399d3b728d8109da3de2457ba82b6eeb'),
            ('RIEC_hrir_subject_017.sofa', '9de3512ab053a9e0062eae417a94a62b'),
            ('RIEC_hrir_subject_018.sofa', '3b6e3a76cc8f5e23f7f6cdd56f1507bb'),
            ('RIEC_hrir_subject_019.sofa', '60e8e91af99ddd8987cf890b59f81e2a'),
            ('RIEC_hrir_subject_020.sofa', 'ae218181a665ef9f8670dfb509559803'),
            ('RIEC_hrir_subject_021.sofa', 'bd0ad17d22076443b8c1dc4575e79227'),
            ('RIEC_hrir_subject_022.sofa', 'b7eb10b1c03164bba671eb65d0511d07'),
            ('RIEC_hrir_subject_023.sofa', '1e3ad699e1196a7a011868792703886d'),
            ('RIEC_hrir_subject_024.sofa', '5fe2fad3ec3567d792e9a6c3000c86d3'),
            ('RIEC_hrir_subject_025.sofa', '080416f9d0a9382c4bbbb8f6ccd827d5'),
            ('RIEC_hrir_subject_026.sofa', 'f776539cc912589a2923ef52bad78c98'),
            ('RIEC_hrir_subject_027.sofa', '0743bd71170e5d8e0fa8f0729f056589'),
            ('RIEC_hrir_subject_028.sofa', 'cee6df6c615cd5dcff579a8ebcdaaa26'),
            ('RIEC_hrir_subject_029.sofa', 'c60e3ef0c123acc111a7b917242fb564'),
            ('RIEC_hrir_subject_030.sofa', 'e0d36bb5915d21bec0ed28bebb87f925'),
            ('RIEC_hrir_subject_031.sofa', '353d28103630a0d5e373875a63509569'),
            ('RIEC_hrir_subject_032.sofa', 'e49976e2b39c477900852ccb3e9b3da4'),
            ('RIEC_hrir_subject_033.sofa', '224d286b38c8123470241777e45740b7'),
            ('RIEC_hrir_subject_034.sofa', 'eefd1c9f0ee73dfd411ec6eb819cede6'),
            ('RIEC_hrir_subject_035.sofa', '0c8538efa375f15248610db0bdb1bd4d'),
            ('RIEC_hrir_subject_036.sofa', '849f4bfc2517db29cc169365bf69abcf'),
            ('RIEC_hrir_subject_037.sofa', 'b366ae179d952be5cb828632f6ff0165'),
            ('RIEC_hrir_subject_038.sofa', 'addace59829cf68be74f945eea4cd7d5'),
            ('RIEC_hrir_subject_039.sofa', 'c1cfd0135d8fb61d40bf83e55da087b1'),
            ('RIEC_hrir_subject_040.sofa', '455135a25bab0ebc858a247d63d74420'),
            ('RIEC_hrir_subject_041.sofa', '14732681201c3c7ef00686b44db8aff4'),
            ('RIEC_hrir_subject_042.sofa', '23c01ffb1110c301362830085753e3f6'),
            ('RIEC_hrir_subject_043.sofa', '0ce7712c1f838ea0e7830cb55d61486c'),
            ('RIEC_hrir_subject_044.sofa', '704343d6ec587d913c8a5090c489a0a8'),
            ('RIEC_hrir_subject_045.sofa', '50a0e23ad435fad81c95b3bf55763508'),
            ('RIEC_hrir_subject_046.sofa', 'a3512155f2124af46146eded01e551e8'),
            ('RIEC_hrir_subject_047.sofa', '2862b0278dd3571e3b64457d9a0c1681'),
            ('RIEC_hrir_subject_048.sofa', '8e9044d5a589ccd8850748a029a47582'),
            ('RIEC_hrir_subject_049.sofa', '4204f8d5c67462aea8c06a4fae53d40d'),
            ('RIEC_hrir_subject_050.sofa', '0b2fedd44e1a403ac968ca0530450d6c'),
            ('RIEC_hrir_subject_051.sofa', '7785c7b9c1aafea224722a6f5a72e203'),
            ('RIEC_hrir_subject_052.sofa', '58645502f61b31374332898e8a81fab2'),
            ('RIEC_hrir_subject_053.sofa', '479f19f60c0b487a25cce037f6d6b2a7'),
            ('RIEC_hrir_subject_054.sofa', '7a82c2f1d3b61623f330cea6154cf094'),
            ('RIEC_hrir_subject_055.sofa', '02cf718179abe394d778f35219c08b69'),
            ('RIEC_hrir_subject_056.sofa', '434049b56dbc495f88d4451d73514507'),
            ('RIEC_hrir_subject_057.sofa', '9f3d90df6cbf44c69817fabfb53ba060'),
            ('RIEC_hrir_subject_058.sofa', '1d255896117b68505dddff0726f33849'),
            ('RIEC_hrir_subject_059.sofa', '467e81141b1408393c94e551a1e3b647'),
            ('RIEC_hrir_subject_060.sofa', 'b53c247ea4843e41c1257993ff6626e8'),
            ('RIEC_hrir_subject_061.sofa', '157d0550d0e4881e1bd871525c6402a0'),
            ('RIEC_hrir_subject_062.sofa', '15e34740ab483d11cbf32dcd9ffbc0a1'),
            ('RIEC_hrir_subject_063.sofa', 'f1cf1e75b5c26cf988e389265df2e748'),
            ('RIEC_hrir_subject_064.sofa', 'fac6d16cfbe4027582b54120fd3258cb'),
            ('RIEC_hrir_subject_065.sofa', '7c8c2dde86b754d09d4c57ef7b67300d'),
            ('RIEC_hrir_subject_066.sofa', '690b77b1f9925f5a09330ae4e7cc4d5d'),
            ('RIEC_hrir_subject_067.sofa', 'f0ae633bcf11419a51253453403ea1b1'),
            ('RIEC_hrir_subject_068.sofa', '681bb145fceedbd226bfd7ca1f9145ed'),
            ('RIEC_hrir_subject_069.sofa', '24ce307e00222f6fbfeea08fd5d1d104'),
            ('RIEC_hrir_subject_070.sofa', '235396e335b3bef26ce7396b440dd29d'),
            ('RIEC_hrir_subject_071.sofa', '22464c5a0b5641b091c11351d2fc6e90'),
            ('RIEC_hrir_subject_072.sofa', '9f956e125e452c727805dc1dc48cb104'),
            ('RIEC_hrir_subject_073.sofa', 'd4a27c9f96d5711fe99e2222ae5f679c'),
            ('RIEC_hrir_subject_074.sofa', 'ca83d8b0bc5737ce04608ea17652d207'),
            ('RIEC_hrir_subject_075.sofa', '13fc248c9185f4e146dc420360f22678'),
            ('RIEC_hrir_subject_076.sofa', 'b012b95310c0926a2a45687a728ad6cf'),
            ('RIEC_hrir_subject_077.sofa', 'd4b04706c568faba4c52f7b5ceb737ac'),
            ('RIEC_hrir_subject_078.sofa', 'b08020bc26264f775ea4ccb812fbfe4e'),
            ('RIEC_hrir_subject_079.sofa', '78f8647b6de7dee8396bb59f83080f85'),
            ('RIEC_hrir_subject_080.sofa', 'b0b10fab033a97b5cb49a82e5b5e8b5b'),
            ('RIEC_hrir_subject_081.sofa', '76ee91627ee0ecd310e2ad0d3b4082a4'),
            ('RIEC_hrir_subject_082.sofa', '53721a5ecf52885183f6a7ad052b6c87'),
            ('RIEC_hrir_subject_083.sofa', '3703e7092f719adcf308269a9ddf996b'),
            ('RIEC_hrir_subject_084.sofa', '152f32e7a0104a971c158ba64e7b0d5d'),
            ('RIEC_hrir_subject_085.sofa', '3ccf9e392c9add481ea6a3312794fb71'),
            ('RIEC_hrir_subject_086.sofa', '9dbf06765b4e9f70f2d935f65bd7ed26'),
            ('RIEC_hrir_subject_087.sofa', '2fa1bc84f79cf530b75b40bf6a8e3854'),
            ('RIEC_hrir_subject_088.sofa', '618104e49b1d493157258ebf968eb713'),
            ('RIEC_hrir_subject_089.sofa', 'b36300172e90ccdc81201937fac0027c'),
            ('RIEC_hrir_subject_090.sofa', 'fb74d080bfcb28e58906bf3f87187b28'),
            ('RIEC_hrir_subject_091.sofa', 'fd4336fbca4ba79ecb17bd51d03fb039'),
            ('RIEC_hrir_subject_092.sofa', 'bc24fb423714baaab7c934689c8e5ea1'),
            ('RIEC_hrir_subject_093.sofa', 'def0cbdd4ba35be65b3c37714523be76'),
            ('RIEC_hrir_subject_094.sofa', 'c9dbfcf87a0c84040a5630a3d08636b8'),
            ('RIEC_hrir_subject_095.sofa', '82b4209d82178e12cc0a369f9ffe35a9'),
            ('RIEC_hrir_subject_096.sofa', '323cda76855dcaa79832dae3473f9f2d'),
            ('RIEC_hrir_subject_097.sofa', 'bc2d5d5d575aa96f1bfa4c37ba26881f'),
            ('RIEC_hrir_subject_098.sofa', '5ebf687f6149b51c412f189f16a5cd59'),
            ('RIEC_hrir_subject_099.sofa', 'd1f92fd5ea940d953bfda403744e7569'),
            ('RIEC_hrir_subject_100.sofa', '7a40615f98dc4331aa1532cc9d5c9d5f'),
            ('RIEC_hrir_subject_101.sofa', 'c7719875493247e5b48fa7e964861e69'),
            ('RIEC_hrir_subject_102.sofa', '53885aa281f1d6ee16b343bd11b68c45'),
            ('RIEC_hrir_subject_103.sofa', '87c0c9e32bce040ecb6a86d639794fbb'),
            ('RIEC_hrir_subject_104.sofa', '2a132659bf08457cbde423adc90aa767'),
            ('RIEC_hrir_subject_105.sofa', 'e9f4856c5a1fa84012a5b08d26066be3'),
        ],
    },
    'chedar': {
        '02m': [
            ('02m/chedar_0001_UV02m.sofa', '8432497f63870b9461675680092521cb'),
            ('02m/chedar_0002_UV02m.sofa', '6390363a39ce9aa618b954fa8ee34095'),
            ('02m/chedar_0003_UV02m.sofa', 'd6eec50f1dc05b485957197c9012870d'),
            ('02m/chedar_0004_UV02m.sofa', 'c1c5159bc4f94a2de7dbbd51f0e859c9'),
            ('02m/chedar_0005_UV02m.sofa', 'e67db4cbd95fd785b5d3c0cdf9bd949c'),
            ('02m/chedar_0006_UV02m.sofa', '9bfae067c86138e48751c6c7d1960cf4'),
            ('02m/chedar_0007_UV02m.sofa', 'b90e11405eec2c0a2adeff0d344c7580'),
            ('02m/chedar_0008_UV02m.sofa', '95bfddfbff2a2ad7f0f4f6221fe0af31'),
            ('02m/chedar_0009_UV02m.sofa', 'b767f28e48b1f9cb969c466679e15197'),
            ('02m/chedar_0010_UV02m.sofa', '513f698b5394a3a1b7917646309efdf1'),
            ('02m/chedar_0011_UV02m.sofa', '554952d06982c81786173e39db857cf9'),
            ('02m/chedar_0012_UV02m.sofa', '424ba6b7e8a9ab84cf60e4564dd42261'),
            ('02m/chedar_0013_UV02m.sofa', 'f0575368e7a2a4b78ade33eb461cf144'),
            ('02m/chedar_0014_UV02m.sofa', '4f1ca2e65e25d57d1e4fbf22a46c82ca'),
            ('02m/chedar_0015_UV02m.sofa', '828247f6a97cdbd4cf934f6bb7483ec5'),
            ('02m/chedar_0016_UV02m.sofa', '224bf13e10c444b5ac4914b9045f72cf'),
            ('02m/chedar_0017_UV02m.sofa', '85be6bd94f1feb481d536e611eb8a901'),
            ('02m/chedar_0018_UV02m.sofa', 'bf1acc59c3ee1b930d79e621bab25c28'),
            ('02m/chedar_0019_UV02m.sofa', '585c8b95e79a54e192ae87951a0082e2'),
            ('02m/chedar_0020_UV02m.sofa', 'd36c767791f23a2091ea5231c610dd0b'),
            ('02m/chedar_0021_UV02m.sofa', 'd52f6417703bf269aeba6061693e4f2b'),
            ('02m/chedar_0022_UV02m.sofa', '587879ee5625abc9236f71c386e74ea7'),
            ('02m/chedar_0023_UV02m.sofa', '85c36bcc9b757eec3d964be6c38b42cc'),
            ('02m/chedar_0024_UV02m.sofa', 'd4ef69845fe7994c1d3aecdc8a665ea1'),
            ('02m/chedar_0025_UV02m.sofa', 'd53637d765fcbd4f92eacc78b1b560c8'),
            ('02m/chedar_0026_UV02m.sofa', 'ba5f67478e1ce170ef3109bf9c5086a9'),
            ('02m/chedar_0027_UV02m.sofa', '05dd6f21bf9029580a201d6a584273c5'),
            ('02m/chedar_0028_UV02m.sofa', '927cf08927eef8a59611d58b0d6a6933'),
            ('02m/chedar_0029_UV02m.sofa', '640a0419b4aa5742382a24ad1d9b5780'),
            ('02m/chedar_0030_UV02m.sofa', '6506ff9dc41e31ae4cf9dab76dc21a01'),
            ('02m/chedar_0031_UV02m.sofa', '23b783330dd8d733d1ab9a1e3db4841b'),
            ('02m/chedar_0032_UV02m.sofa', '675e93bd0b0d0ce5c39f76fe4cc02d04'),
            ('02m/chedar_0033_UV02m.sofa', '9dc9989aeda8fe5a2337d55b1f3cc4c0'),
            ('02m/chedar_0034_UV02m.sofa', '6cee11284f48856f04fd0f5f9e67c530'),
            ('02m/chedar_0035_UV02m.sofa', '27f1275b505cf977c775a879712ba9de'),
            ('02m/chedar_0036_UV02m.sofa', '76030174913c34140ce578139030d11d'),
            ('02m/chedar_0037_UV02m.sofa', 'a53e1f3f2e9a3629f9526d4b49a9ded7'),
            ('02m/chedar_0038_UV02m.sofa', 'fb04e1f179bc2a7fb70e3993c0aedf7d'),
            ('02m/chedar_0039_UV02m.sofa', '1d7af255c9dd813863b5dfa7288686c1'),
            ('02m/chedar_0040_UV02m.sofa', 'dce6dfa542c19bcb422916fc4fde5b7c'),
            ('02m/chedar_0041_UV02m.sofa', '8eb8ca38946af5a019109bdc11278728'),
            ('02m/chedar_0042_UV02m.sofa', '8778523e87330d6ba3022decbe0aebb0'),
            ('02m/chedar_0043_UV02m.sofa', 'ee91fdfd640c975463662820f796ac5c'),
            ('02m/chedar_0044_UV02m.sofa', '2fe503c2f448437cb0fe0350e2ae595a'),
            ('02m/chedar_0045_UV02m.sofa', '5128b9ba3611fdd25c6d2176744342d7'),
            ('02m/chedar_0046_UV02m.sofa', 'c08d175fcb43211c9708bda8ee815a99'),
            ('02m/chedar_0047_UV02m.sofa', '11e9f9916a1a4881068d538da3905eba'),
            ('02m/chedar_0048_UV02m.sofa', '5d3dd1f7a096dc2b86644ab87e294488'),
            ('02m/chedar_0049_UV02m.sofa', '0c75511fffad5b94098bb77f0441cdfa'),
            ('02m/chedar_0050_UV02m.sofa', '78e61f7e09f4c97bc251fea356063999'),
            ('02m/chedar_0051_UV02m.sofa', '1c8cc0c0ac8abb4d033ff14471001c39'),
            ('02m/chedar_0052_UV02m.sofa', '831cab1ef9f91a5644ad92ea19a65ea3'),
            ('02m/chedar_0053_UV02m.sofa', 'dd7bd657df321228597676baa8cdffb2'),
            ('02m/chedar_0054_UV02m.sofa', '08d8677062065dd970a3ed4539ef7dfc'),
            ('02m/chedar_0055_UV02m.sofa', '1b5a9ab18f2f90daba3940b8483ab636'),
            ('02m/chedar_0056_UV02m.sofa', '04da7e2b104ab49e45f1ba319af2ac3d'),
            ('02m/chedar_0057_UV02m.sofa', 'e67e89d9e0b586a2959e644f827dfbdb'),
            ('02m/chedar_0058_UV02m.sofa', '04c3b05af66440719c1b45453f55015b'),
            ('02m/chedar_0059_UV02m.sofa', '8b86b49f1ae4562fdc796da35fef34ca'),
            ('02m/chedar_0060_UV02m.sofa', '8efa83ebee42338029cb73972c3dd085'),
            ('02m/chedar_0061_UV02m.sofa', '96e98b0d6722daf129886071ffdf703b'),
            ('02m/chedar_0062_UV02m.sofa', '5551653f52c1e21941327d2cd3bda041'),
            ('02m/chedar_0063_UV02m.sofa', '7aa98d9ae618ae51da813f41f6a5f4a5'),
            ('02m/chedar_0064_UV02m.sofa', '8ab6ed8f29a77202d3af1490cb2db065'),
            ('02m/chedar_0065_UV02m.sofa', 'd221f4730aba3c41e0544a6646e5f8fe'),
            ('02m/chedar_0066_UV02m.sofa', '5f47d55d816ddc5b8f8d024b938b5402'),
            ('02m/chedar_0067_UV02m.sofa', 'ee3a7b5fda7f6d7b9f64529028a966b7'),
            ('02m/chedar_0068_UV02m.sofa', 'c2e86c6ec3f37f86ee7560f1c2e1fdf1'),
            ('02m/chedar_0069_UV02m.sofa', '97e58f6621fff057155a226ec488cd1d'),
            ('02m/chedar_0070_UV02m.sofa', 'f95034b2065f391318fb4b662dca1b7e'),
            ('02m/chedar_0071_UV02m.sofa', '04a6d4366d3926f9c01d02a3d937340e'),
            ('02m/chedar_0072_UV02m.sofa', '239b80fabf44aed0d57e9297cd317c70'),
            ('02m/chedar_0073_UV02m.sofa', '61242e81815d178d531754c13f99bb87'),
            ('02m/chedar_0074_UV02m.sofa', '45b6a1f400da9087e534f7c86c629d0d'),
            ('02m/chedar_0075_UV02m.sofa', '2217d3d2f160fadb5132369d73a34341'),
            ('02m/chedar_0076_UV02m.sofa', '9f820f6149830ae19b7bd32960d92a57'),
            ('02m/chedar_0077_UV02m.sofa', '5904c1bd3b88f569a3dac30056fd61da'),
            ('02m/chedar_0078_UV02m.sofa', '46b089312309b92ec1334db74d0ecc81'),
            ('02m/chedar_0079_UV02m.sofa', '3ac74573d22a1ea86e9343994a176871'),
            ('02m/chedar_0080_UV02m.sofa', '47a0a08faaf0b312c7fff4360cf8f5db'),
            ('02m/chedar_0081_UV02m.sofa', 'b82764dcb7aeef80e8784c2bce94642c'),
            ('02m/chedar_0082_UV02m.sofa', '83fe4d36a56e068bbaeec33693af3c6a'),
            ('02m/chedar_0083_UV02m.sofa', '58f4151a8893e567792852f866560f1a'),
            ('02m/chedar_0084_UV02m.sofa', 'e1ac66e92658ebad00edb35a28e5b0b4'),
            ('02m/chedar_0085_UV02m.sofa', 'ee2f33f56fe4f17aa9aef9980c8fa4bd'),
            ('02m/chedar_0086_UV02m.sofa', '911810fa939c01e5746bb17d74f682d2'),
            ('02m/chedar_0087_UV02m.sofa', '531cee9ed98a5bd34edc3b1c19c85ae6'),
            ('02m/chedar_0088_UV02m.sofa', 'adbe84a6e78c7994470a0a2cd82d49fb'),
            ('02m/chedar_0089_UV02m.sofa', '8d5430980effb1d58801312e9a431d91'),
            ('02m/chedar_0090_UV02m.sofa', 'daf4f3b17b452cbbbea6fc7cf2973206'),
            ('02m/chedar_0091_UV02m.sofa', '393111264e21aa60772271674bb900c2'),
            ('02m/chedar_0092_UV02m.sofa', 'f295c363df5db32b99cd6305cb033953'),
            ('02m/chedar_0093_UV02m.sofa', '5e3b19961d80994af5c38430142c792c'),
            ('02m/chedar_0094_UV02m.sofa', 'e0a5c75b0e06f25cf9ea8649361f5ae7'),
            ('02m/chedar_0095_UV02m.sofa', '288c89777eae4903e2758e749ad1c234'),
            ('02m/chedar_0096_UV02m.sofa', '6a8ee61a5f2f74cda906270f3cf83eef'),
            ('02m/chedar_0097_UV02m.sofa', 'a5d54e3db1e593481a6a0a67abf55b4f'),
            ('02m/chedar_0098_UV02m.sofa', '6c1066f29702a317ad9e67bec0947d8b'),
            ('02m/chedar_0099_UV02m.sofa', '513b41d122ff14437b71eb9f99ef0021'),
            ('02m/chedar_0100_UV02m.sofa', 'cc74af2429cfbae6f7800d82f51c72a9'),
            ('02m/chedar_0101_UV02m.sofa', '059b7f391c74f55d7ac3d3312c0bdbf7'),
            ('02m/chedar_0102_UV02m.sofa', '2598d232bbcc08357a6cbe895f38d551'),
            ('02m/chedar_0103_UV02m.sofa', 'e17691a4b54da307451cd64a9accf87b'),
            ('02m/chedar_0104_UV02m.sofa', '2128359512a5ba39213bcd64e033f518'),
            ('02m/chedar_0105_UV02m.sofa', 'd7bc0d28f73be77acf24392e018ed783'),
            ('02m/chedar_0106_UV02m.sofa', '8b1836e36a4eadef4abbb031d7f2dd40'),
            ('02m/chedar_0107_UV02m.sofa', 'a04c56a8a53d385aab12db7a25f3d103'),
            ('02m/chedar_0108_UV02m.sofa', '3bcc8e6b1fd787bbf6deb2b9f3ec41bf'),
            ('02m/chedar_0109_UV02m.sofa', 'fb8220ef0f4179fe494c8b46fd8a7410'),
            ('02m/chedar_0110_UV02m.sofa', '2510a3ac88661f3aee2e4f1be18015d3'),
            ('02m/chedar_0111_UV02m.sofa', '3f91bb1e628bc833a9d96637371d4674'),
            ('02m/chedar_0112_UV02m.sofa', '79f0dbd7573e73c2f0e2840276305cc8'),
            ('02m/chedar_0113_UV02m.sofa', '66c8e4967f3acebc1904663dda981408'),
            ('02m/chedar_0114_UV02m.sofa', '62ddffe0c222d6cf8a19347f2fc1ea61'),
            ('02m/chedar_0115_UV02m.sofa', '586f9269fed68ada09175aa3121d406b'),
            ('02m/chedar_0116_UV02m.sofa', '5141e0eb02e90ab2d99861e5f6613c76'),
            ('02m/chedar_0117_UV02m.sofa', '64360df2a939bbc9e370d992ed3e092f'),
            ('02m/chedar_0118_UV02m.sofa', 'eaac6883167f009199076ab8eeff764d'),
            ('02m/chedar_0119_UV02m.sofa', '9a6cb4145bfc89a7a28d3a40e80623ee'),
            ('02m/chedar_0120_UV02m.sofa', '6b9aa4ce6cd6feef62f93fa630ef32f2'),
            ('02m/chedar_0121_UV02m.sofa', '80bdeea95e3b0b170c227eaa592e1bf8'),
            ('02m/chedar_0122_UV02m.sofa', '71dd4bdbe0a92982d1eeb3c5c501967c'),
            ('02m/chedar_0123_UV02m.sofa', 'ae2c532d27e7a52486a055f38bbaa770'),
            ('02m/chedar_0124_UV02m.sofa', '34edac8ed4b65fb7acb910c95eba440e'),
            ('02m/chedar_0125_UV02m.sofa', 'b7f44db41b36650bd1029d770546c8dd'),
            ('02m/chedar_0126_UV02m.sofa', '8e33536cbfccce25735812dac40627c2'),
            ('02m/chedar_0127_UV02m.sofa', '53ebcbf50f11fcc4f33340099690736c'),
            ('02m/chedar_0128_UV02m.sofa', '0281b20619ef8ac4a67cf058ac757f19'),
            ('02m/chedar_0129_UV02m.sofa', '34a502fbb2eb2c9fc556700616ce7d40'),
            ('02m/chedar_0130_UV02m.sofa', '5b06917b9316ddea4d3b8c32fad08ba8'),
            ('02m/chedar_0131_UV02m.sofa', '535ffe94fcb669602635985187e06673'),
            ('02m/chedar_0132_UV02m.sofa', '84bf0e0971daabaa52c2a4bf70708172'),
            ('02m/chedar_0133_UV02m.sofa', '06491074224b66cea87606e2eb2a40a2'),
            ('02m/chedar_0134_UV02m.sofa', '633a6f06062d186d3b364a1c5f9960a1'),
            ('02m/chedar_0135_UV02m.sofa', 'c378966adbd03deb3d67f67e792a3139'),
            ('02m/chedar_0136_UV02m.sofa', '0a5f4bf585c09bba296084674513bd24'),
            ('02m/chedar_0137_UV02m.sofa', 'b94d00c33a6d27a1c35015035d313420'),
            ('02m/chedar_0138_UV02m.sofa', '58e120a2e3f7a9f76073497dd4a58a0a'),
            ('02m/chedar_0139_UV02m.sofa', 'b663f72b912cb58e860ef597bd6d617e'),
            ('02m/chedar_0140_UV02m.sofa', 'ddd3b994d052a1245df7010adbdeb6f9'),
            ('02m/chedar_0141_UV02m.sofa', 'b7f5e8ae96bfd172808cd599ab4bc127'),
            ('02m/chedar_0142_UV02m.sofa', '4295595bf7fec522649ff5579e1ed571'),
            ('02m/chedar_0143_UV02m.sofa', '91b3571ce29f2f113a6f84034f72b9b4'),
            ('02m/chedar_0144_UV02m.sofa', '6cc3ecdf632f0964b4858aed1d86d4a1'),
            ('02m/chedar_0145_UV02m.sofa', '640c87c56e5cf53eba82fa134c4fa4b7'),
            ('02m/chedar_0146_UV02m.sofa', '15ffec928d96e7ad422a802ad6402d4a'),
            ('02m/chedar_0147_UV02m.sofa', 'f0169fafc89d6747eb0b4da2c9d1ce0c'),
            ('02m/chedar_0148_UV02m.sofa', '96d09e3a1a6101c7e73ad3b4a33da38c'),
            ('02m/chedar_0149_UV02m.sofa', '7f8b3d0131584f55b854c269b7b19663'),
            ('02m/chedar_0150_UV02m.sofa', '80247f8f85280abb64f713c6a0d653bd'),
            ('02m/chedar_0151_UV02m.sofa', 'eee5fe987cf01ae3b21a55e5f04695de'),
            ('02m/chedar_0152_UV02m.sofa', '3f2259b61b858b201a486ca6a15692e8'),
            ('02m/chedar_0153_UV02m.sofa', '00a69e5c0083ea6239aaa0c52f60938c'),
            ('02m/chedar_0154_UV02m.sofa', '6d0d9faf6adf27bc7bd9fa350662841e'),
            ('02m/chedar_0155_UV02m.sofa', '7f693b5dd0a43bf3eb0a36d59fc60568'),
            ('02m/chedar_0156_UV02m.sofa', '372271c6cb41a91cffc1f8079d5aedb9'),
            ('02m/chedar_0157_UV02m.sofa', 'fadcbee38e7a7956516d8183f73d34b6'),
            ('02m/chedar_0158_UV02m.sofa', 'aec4388e9844fc09642b9914ee5649f3'),
            ('02m/chedar_0159_UV02m.sofa', 'b2aefbf987eb11b59f81c3bc61b48f24'),
            ('02m/chedar_0160_UV02m.sofa', 'e4784469f7a0c0a20a79e9778750a085'),
            ('02m/chedar_0161_UV02m.sofa', 'dad26f9d530a6529e8210e478cb77850'),
            ('02m/chedar_0162_UV02m.sofa', 'ff29d5b3ab9afba3a9501754aacd4a3d'),
            ('02m/chedar_0163_UV02m.sofa', '3ae46e197779cdb9b2511e89bfdba9ac'),
            ('02m/chedar_0164_UV02m.sofa', '65be89f41197e3629086fbb6c657ec30'),
            ('02m/chedar_0165_UV02m.sofa', 'adefe332faf0fe51c9237347251b9f77'),
            ('02m/chedar_0166_UV02m.sofa', '69384c6877a311637c6c17a4462d92e1'),
            ('02m/chedar_0167_UV02m.sofa', '40be6d140db7161aeb4fc4a3f4d142d6'),
            ('02m/chedar_0168_UV02m.sofa', '19083d15921cd09b2ceda58ec47b88ae'),
            ('02m/chedar_0169_UV02m.sofa', '257e8dd171ba683fc6c19c959865dd12'),
            ('02m/chedar_0170_UV02m.sofa', 'f83ebad3e9c1abad4efb0ba5604bc5cd'),
            ('02m/chedar_0171_UV02m.sofa', 'e166b2bbcccf119abec096dee597aa2b'),
            ('02m/chedar_0172_UV02m.sofa', 'adade4c659975263c3386016dd6fa89f'),
            ('02m/chedar_0173_UV02m.sofa', 'eccddc7392a11a1a5b956a3341880673'),
            ('02m/chedar_0174_UV02m.sofa', '30ea56e2ec12305c35557682731da9ad'),
            ('02m/chedar_0175_UV02m.sofa', 'f360e37eea46fbdeb73aa806e4e791a1'),
            ('02m/chedar_0176_UV02m.sofa', '4a5c07f91b3afbf76ae386df29a17da0'),
            ('02m/chedar_0177_UV02m.sofa', '43ea382623e6a337a94ca6f464645105'),
            ('02m/chedar_0178_UV02m.sofa', '38717d8826faea710c0b9b60d1ce1593'),
            ('02m/chedar_0179_UV02m.sofa', '8b85509ac370e4399e178037ebb17c24'),
            ('02m/chedar_0180_UV02m.sofa', 'f643cc54e1ed513ec83aa368f3ec66c5'),
            ('02m/chedar_0181_UV02m.sofa', '4a639fc22d1537a2556f14d3376ae255'),
            ('02m/chedar_0182_UV02m.sofa', '7b36a31e174903f2614bf37afb2d6898'),
            ('02m/chedar_0183_UV02m.sofa', 'aa594cf1ff9bbbd0b75264de7238ab30'),
            ('02m/chedar_0184_UV02m.sofa', '0739dfc90918efa2e42cf2450c5c33ce'),
            ('02m/chedar_0185_UV02m.sofa', 'd6b799d2e6411a164ef4f24ac95e8e16'),
            ('02m/chedar_0186_UV02m.sofa', '9c25071cf4f11fe1face95feb828feb5'),
            ('02m/chedar_0187_UV02m.sofa', 'ebbb39e3755712dfd7961b3742416be5'),
            ('02m/chedar_0188_UV02m.sofa', 'aff7f3deccce0affa261b2e7f5bec528'),
            ('02m/chedar_0189_UV02m.sofa', 'b373e0cff05862b3863bfe5ebc60d8bd'),
            ('02m/chedar_0190_UV02m.sofa', 'c025d4982c57c766bb4dfdbfadf378a7'),
            ('02m/chedar_0191_UV02m.sofa', '81a5f31d0d7ca1d46675db4a90a2e741'),
            ('02m/chedar_0192_UV02m.sofa', '2056924701314b2b555fa17960b8a859'),
            ('02m/chedar_0193_UV02m.sofa', '113d61a3679616adeecd95ff7454092c'),
            ('02m/chedar_0194_UV02m.sofa', 'a2846362b9a0a2fae82c7766f0341184'),
            ('02m/chedar_0195_UV02m.sofa', '1cad7295f7ea3ebd139a225cc45096ef'),
            ('02m/chedar_0196_UV02m.sofa', '1aa6ebc6e12eeb7a5bb22a4135973975'),
            ('02m/chedar_0197_UV02m.sofa', '850a3f12f01ee27f385150714b6f0987'),
            ('02m/chedar_0198_UV02m.sofa', 'e49a35a6983a98f401741727f595d346'),
            ('02m/chedar_0199_UV02m.sofa', '810dd81ceae6828aa6d0f0b6ded3d0ad'),
            ('02m/chedar_0200_UV02m.sofa', 'f26754ce45e64de835ab7d2218027a8d'),
            ('02m/chedar_0201_UV02m.sofa', 'a35028a7d1e4e488bb0783be2c6dd788'),
            ('02m/chedar_0202_UV02m.sofa', '86a3a4b740630b3baf370223ae85675d'),
            ('02m/chedar_0203_UV02m.sofa', 'e35838aaeb32d104ba1615bd1a8ede73'),
            ('02m/chedar_0204_UV02m.sofa', 'faaf6cb0ed0f6a97dc134334de4c8fda'),
            ('02m/chedar_0205_UV02m.sofa', 'f989898ed0c3604d2b821e19150e6e77'),
            ('02m/chedar_0206_UV02m.sofa', '42ad5fe06581afb97e3c575f0a25bf74'),
            ('02m/chedar_0207_UV02m.sofa', 'b84df4431aeae821af2d455133f623c7'),
            ('02m/chedar_0208_UV02m.sofa', 'cbba9918dfe5d0a5c48fdf3834ee2777'),
            ('02m/chedar_0209_UV02m.sofa', 'e9ba96bc2e851e0f7a0db0be44e9f604'),
            ('02m/chedar_0210_UV02m.sofa', 'd55527cd073a24809362df37761bbb17'),
            ('02m/chedar_0211_UV02m.sofa', 'b4dab41c61d9c4f17471d000fa76f26c'),
            ('02m/chedar_0212_UV02m.sofa', '818830c03ad2b8bf3e1062101379b2b0'),
            ('02m/chedar_0213_UV02m.sofa', '3b0c0c0f1311b2da5e44895a8912ed0d'),
            ('02m/chedar_0214_UV02m.sofa', 'ec02331eda89dc74a22ee9c5e13b9dc0'),
            ('02m/chedar_0215_UV02m.sofa', 'c2f83253835c7c9fd9a540bf70da2613'),
            ('02m/chedar_0216_UV02m.sofa', '2f23f3be848cee1298ef80364c6e2493'),
            ('02m/chedar_0217_UV02m.sofa', '43170e438f07f4906b5c6a325a11af23'),
            ('02m/chedar_0218_UV02m.sofa', '9a63f7ca4462607ebed4acb98299dc49'),
            ('02m/chedar_0219_UV02m.sofa', '87440eb5e1c8faa50f3ce7905ee011d5'),
            ('02m/chedar_0220_UV02m.sofa', '6c5189b49071ae20b52607499e1951fc'),
            ('02m/chedar_0221_UV02m.sofa', '1e6e1e3615c2f5173ca825b7b1c6f0ba'),
            ('02m/chedar_0222_UV02m.sofa', '12205d1f952c3765fcf122def5e685e6'),
            ('02m/chedar_0223_UV02m.sofa', '9cc620700806771da9ca5d6bcfc37027'),
            ('02m/chedar_0224_UV02m.sofa', 'e816c274b1598db9fad5acdadb47497b'),
            ('02m/chedar_0225_UV02m.sofa', 'fae1f32b17d6348b275a6dd70588c799'),
            ('02m/chedar_0226_UV02m.sofa', 'f815f224ae11c44d4433d3bb9c8c307a'),
            ('02m/chedar_0227_UV02m.sofa', 'e14209a16a336d18941192f52e278268'),
            ('02m/chedar_0228_UV02m.sofa', '2cf3b47bb8c02a44da9a09102854d32e'),
            ('02m/chedar_0229_UV02m.sofa', '5935f7dd446bc0ee778357a13ea2730b'),
            ('02m/chedar_0230_UV02m.sofa', '706325715b5f6eb3a9ea3d7b1d94dc21'),
            ('02m/chedar_0231_UV02m.sofa', '9068b728f2f910d12b91a29068fe4734'),
            ('02m/chedar_0232_UV02m.sofa', 'f6f660609ea7a1dbb617d02f7b919a41'),
            ('02m/chedar_0233_UV02m.sofa', 'fb6027d21c6abc2d588dcdc39497c1e3'),
            ('02m/chedar_0234_UV02m.sofa', '3825fdcd7d99b505631801c3e4e55866'),
            ('02m/chedar_0235_UV02m.sofa', 'cbb420b25427b3d71869d43425491436'),
            ('02m/chedar_0236_UV02m.sofa', '29a0c4c67ffa0727c1e641844ae3811d'),
            ('02m/chedar_0237_UV02m.sofa', 'af8d41949c6548597ea8c3e686cf6785'),
            ('02m/chedar_0238_UV02m.sofa', '6c5d75d5309b4913ac53f6e5ea0801c6'),
            ('02m/chedar_0239_UV02m.sofa', '8863aec0bac4684b314703dfa7b0d826'),
            ('02m/chedar_0240_UV02m.sofa', 'e264f42922907472b8b093c9e81e639b'),
            ('02m/chedar_0241_UV02m.sofa', '0f8639c6df7b69785816f65c9bb7e405'),
            ('02m/chedar_0242_UV02m.sofa', '7128ebb374e376ecffbc4baed388a3d1'),
            ('02m/chedar_0243_UV02m.sofa', '0d0e40f1e8edb41282dcce41dc220262'),
            ('02m/chedar_0244_UV02m.sofa', 'b7944c2cf3b200a2c04dee8abf5ab890'),
            ('02m/chedar_0245_UV02m.sofa', '036a2224217a620b1ab7274cb43bb206'),
            ('02m/chedar_0246_UV02m.sofa', 'ce52eed71997f1631aa46279c19784e9'),
            ('02m/chedar_0247_UV02m.sofa', '2b360930b14491d69a1cb291da0fb68b'),
            ('02m/chedar_0248_UV02m.sofa', '58ab6df8b03c633cc182ad0aeddef9f7'),
            ('02m/chedar_0249_UV02m.sofa', '175432815db36a61ab858e712632b64c'),
            ('02m/chedar_0250_UV02m.sofa', 'd04e7ae92d1a6f4510405d034fd1e5ce'),
            ('02m/chedar_0251_UV02m.sofa', 'f6d2cf87acad363c2bbc37fd1f410f90'),
            ('02m/chedar_0252_UV02m.sofa', 'db2fcbb51111039dd5896b2040191cb7'),
            ('02m/chedar_0253_UV02m.sofa', 'a9605506263f423be45d3b6e184ca6ef'),
            ('02m/chedar_0254_UV02m.sofa', 'cdd01bd852e551f887047aa2c6c6aa6f'),
            ('02m/chedar_0255_UV02m.sofa', 'cfe6bdb3b30bc4ce8a9c4827dbbf466d'),
            ('02m/chedar_0256_UV02m.sofa', '6575132367befad9e5bdf235a6d01827'),
            ('02m/chedar_0257_UV02m.sofa', '5587d55c7324bc17f4f0b13dc949c1a6'),
            ('02m/chedar_0258_UV02m.sofa', 'ad6e42d96ee81f895e5d78270f242afb'),
            ('02m/chedar_0259_UV02m.sofa', '12729119c42c54d43594038b4c3ab45c'),
            ('02m/chedar_0260_UV02m.sofa', 'f0166905131f9b8526bdc5f0ed527328'),
            ('02m/chedar_0261_UV02m.sofa', '95326238e190b81630c0c39175d422ea'),
            ('02m/chedar_0262_UV02m.sofa', 'e7d328fa3955325c72737b7d92db47f9'),
            ('02m/chedar_0263_UV02m.sofa', 'ab2336c48be35545a5cbe1d587face97'),
            ('02m/chedar_0264_UV02m.sofa', '0b177591ccca4283398a792b69fea631'),
            ('02m/chedar_0265_UV02m.sofa', '49fdded6c4b036d6344b77211e6e86e8'),
            ('02m/chedar_0266_UV02m.sofa', '8ba6b557d931a199856d47c616deda49'),
            ('02m/chedar_0267_UV02m.sofa', 'f3bafbf2abb4ae5a180459ffe8c71327'),
            ('02m/chedar_0268_UV02m.sofa', '88a5291c4a3e71e3621e57cf7386afda'),
            ('02m/chedar_0269_UV02m.sofa', '4d6918d2814b6a2d2515bdc32ce7b46c'),
            ('02m/chedar_0270_UV02m.sofa', '7a3b5c6840afe005c57211ff9e54ba7f'),
            ('02m/chedar_0271_UV02m.sofa', '9d82f9f88be44b50392701eb567c70e7'),
            ('02m/chedar_0272_UV02m.sofa', 'dcbd3eafca70cf1fec556d28477bf18f'),
            ('02m/chedar_0273_UV02m.sofa', 'a382b22ee03588470b621b3d6c335c59'),
            ('02m/chedar_0274_UV02m.sofa', 'fc68940aa0568f8aee9edc424f1b1191'),
            ('02m/chedar_0275_UV02m.sofa', '54f99ca1939474aed008de50471c6738'),
            ('02m/chedar_0276_UV02m.sofa', '297caf5647bce112799a2b60c61dbb2a'),
            ('02m/chedar_0277_UV02m.sofa', '37c15b9d7e2a9b4a371788c0c2f10ff8'),
            ('02m/chedar_0278_UV02m.sofa', '407f91161039f5b342e187a719a113c5'),
            ('02m/chedar_0279_UV02m.sofa', '9fab4377b2bb8a27756d06767b245383'),
            ('02m/chedar_0280_UV02m.sofa', '00a0dc20d36adc13176638c1136bec6b'),
            ('02m/chedar_0281_UV02m.sofa', '4e27428d2bd709ed803919ad0804554b'),
            ('02m/chedar_0282_UV02m.sofa', 'd4e2f842203f239163eba0066016d562'),
            ('02m/chedar_0283_UV02m.sofa', '99c00cda70e9185cbc661ed3072350a0'),
            ('02m/chedar_0284_UV02m.sofa', 'df72d6983185ba32ef9c2bbdab1bb32a'),
            ('02m/chedar_0285_UV02m.sofa', '04148e54efcf0b2ca0083f55c56c11eb'),
            ('02m/chedar_0286_UV02m.sofa', 'edf72b178a3dd30dce08f3dfd1742051'),
            ('02m/chedar_0287_UV02m.sofa', 'f76887994bbaab0601d9e13a7df05219'),
            ('02m/chedar_0288_UV02m.sofa', '6b479a39057ddc4689b746fc12ce0dbf'),
            ('02m/chedar_0289_UV02m.sofa', '64e27f5b96a740b5cd19fbc76e04b011'),
            ('02m/chedar_0290_UV02m.sofa', '687db6438f9c687239476d458a097df5'),
            ('02m/chedar_0291_UV02m.sofa', '42a055e5d1fceeedb283ff8092c99379'),
            ('02m/chedar_0292_UV02m.sofa', '732b537ad9c8da07af0b71291ad4f312'),
            ('02m/chedar_0293_UV02m.sofa', '7b2103ab2f0f04f5b6bea099328a17b5'),
            ('02m/chedar_0294_UV02m.sofa', 'e473a2b12490f67ffe3d041055a55ad1'),
            ('02m/chedar_0295_UV02m.sofa', '6b9eca83b0d0aff7910683959e4fe466'),
            ('02m/chedar_0296_UV02m.sofa', '41dd0f4139f82ed8bba6dc3bf82d330b'),
            ('02m/chedar_0297_UV02m.sofa', '0ebccea61f3d03fdb09b7505b9b73719'),
            ('02m/chedar_0298_UV02m.sofa', 'd8a19e3742bb1c257d1f93dc4fc78e3e'),
            ('02m/chedar_0299_UV02m.sofa', '89ca896bb8553de3b9c8c9516f73bec0'),
            ('02m/chedar_0300_UV02m.sofa', '39acd065c1c781b031b4bb86e3928369'),
            ('02m/chedar_0301_UV02m.sofa', 'd8e0874ef09defb15857bf8957f1013c'),
            ('02m/chedar_0302_UV02m.sofa', 'b47eeb6c11cc67ff039d000656f37e92'),
            ('02m/chedar_0303_UV02m.sofa', '8986d171b1a66ae3655e47d2bb66a446'),
            ('02m/chedar_0304_UV02m.sofa', 'cd133851bbf43aae79cb738a73384620'),
            ('02m/chedar_0305_UV02m.sofa', '106b140315a08879d1a73e5f0c8fad17'),
            ('02m/chedar_0306_UV02m.sofa', '7c805d54abd29561da4a5d44b96532b4'),
            ('02m/chedar_0307_UV02m.sofa', '61c00f6f8ed7c5e90e754fb5229d82ed'),
            ('02m/chedar_0308_UV02m.sofa', 'cd837e75f929c4028cd6adfc5f87dc6a'),
            ('02m/chedar_0309_UV02m.sofa', '0398203f28932ceba549b33e913ed9f0'),
            ('02m/chedar_0310_UV02m.sofa', 'f6235f5fc2e68f5968b606ecf7c1c854'),
            ('02m/chedar_0311_UV02m.sofa', 'da90d8629b5d8d4ed9e4bd5c71040de4'),
            ('02m/chedar_0312_UV02m.sofa', '55ee4a21e28b82e8545fafc795cd99c7'),
            ('02m/chedar_0313_UV02m.sofa', 'cb2a89e7b72939e81b3a497d2b5c1363'),
            ('02m/chedar_0314_UV02m.sofa', '6aa86736179db129c53215c1feac10ea'),
            ('02m/chedar_0315_UV02m.sofa', 'd690736154d1f2c502d46a0d15e810c2'),
            ('02m/chedar_0316_UV02m.sofa', 'd985f0d4ba96f2ea33c12ac236583320'),
            ('02m/chedar_0317_UV02m.sofa', '58ea95e86dd7c79f9f5425a288cf35b6'),
            ('02m/chedar_0318_UV02m.sofa', '2e54865c678c9404386af7132152a154'),
            ('02m/chedar_0319_UV02m.sofa', 'a917b9e176d8b45f31d96102d9589de9'),
            ('02m/chedar_0320_UV02m.sofa', '65e7a29039477d0dacbfb79373e3ecc4'),
            ('02m/chedar_0321_UV02m.sofa', '807482181c9f1c0fe582f68a2fd56943'),
            ('02m/chedar_0322_UV02m.sofa', '987caf1a5d50eeffb0eef47fd1b18328'),
            ('02m/chedar_0323_UV02m.sofa', 'fe8807083a6897e26d999c09e2d53d58'),
            ('02m/chedar_0324_UV02m.sofa', 'b82b75abc9cb0b85af38d6637d5f677b'),
            ('02m/chedar_0325_UV02m.sofa', '05b7e2889d17140f0f1d43fa0f0b6bf4'),
            ('02m/chedar_0326_UV02m.sofa', 'c3306190e8f9592332018dde503f9687'),
            ('02m/chedar_0327_UV02m.sofa', 'ceeb072f4adb3846e7c74f3e063d23c7'),
            ('02m/chedar_0328_UV02m.sofa', '29f51c661e1f4c3bc4a6ee5e24551315'),
            ('02m/chedar_0329_UV02m.sofa', '9c89c2d8f744dfcd866967e26134b442'),
            ('02m/chedar_0330_UV02m.sofa', '48cc049ab097d3668880b599b4c8f5b6'),
            ('02m/chedar_0331_UV02m.sofa', '97da2c320df8e3ca52a8dc0981ab375d'),
            ('02m/chedar_0332_UV02m.sofa', '6a09b904f6fe242665023d9211e2b252'),
            ('02m/chedar_0333_UV02m.sofa', '340eef02d730f5c180876bf1d67e3d90'),
            ('02m/chedar_0334_UV02m.sofa', '99ab588786babfeba12c8af6def4341d'),
            ('02m/chedar_0335_UV02m.sofa', '0ddf05efd879edccd2c95e238ab537a3'),
            ('02m/chedar_0336_UV02m.sofa', '891db1795972d6db0c58d6fb4bf7c865'),
            ('02m/chedar_0337_UV02m.sofa', 'fb38057df731b94dbe670ba8a78d44a2'),
            ('02m/chedar_0338_UV02m.sofa', '4ef162ec5753a7a3b74d1791b5a4c6f4'),
            ('02m/chedar_0339_UV02m.sofa', 'd494eacca838236636defb40ab0a01db'),
            ('02m/chedar_0340_UV02m.sofa', '8f326b6b9d28a8dec958dc44abc622ae'),
            ('02m/chedar_0341_UV02m.sofa', 'f16782e09d54369df0aa8852ebc04b01'),
            ('02m/chedar_0342_UV02m.sofa', '028686c35c789d8c01f94441906f6d96'),
            ('02m/chedar_0343_UV02m.sofa', '70d2f5c57e14cd430de0cca5375550bb'),
            ('02m/chedar_0344_UV02m.sofa', 'b27ca4700b9d1e0eac7ccd29ff7b6804'),
            ('02m/chedar_0345_UV02m.sofa', '98988eab22787435a2904ac5aba1e2e1'),
            ('02m/chedar_0346_UV02m.sofa', 'ae06cd3b57b5155ee0629bbc0966d5be'),
            ('02m/chedar_0347_UV02m.sofa', '8f419b78e21f785c56482450f7ae8b23'),
            ('02m/chedar_0348_UV02m.sofa', '663c0eab8d1df19340e812075437b4fa'),
            ('02m/chedar_0349_UV02m.sofa', '5ba2037f01f00261e42df3a39d9e0999'),
            ('02m/chedar_0350_UV02m.sofa', 'd717dfd4942d793ae6216afae1490e3d'),
            ('02m/chedar_0351_UV02m.sofa', '93fd5d06c1444796d45bafdd5d945ccc'),
            ('02m/chedar_0352_UV02m.sofa', '6f01ada7c416c7ca0e39abd5248ab11a'),
            ('02m/chedar_0353_UV02m.sofa', '6c1f46a4e4d43af79d39d0ce16f49729'),
            ('02m/chedar_0354_UV02m.sofa', '2c8c9729c1250bc6a03a14a26b0094b0'),
            ('02m/chedar_0355_UV02m.sofa', 'b4774c09ee9224901b3fba3fba78bfb9'),
            ('02m/chedar_0356_UV02m.sofa', '0466296bba69197167cee0bcd603affc'),
            ('02m/chedar_0357_UV02m.sofa', '8bd488b59b0b98c4dc08f8d84e91988c'),
            ('02m/chedar_0358_UV02m.sofa', '435856453510c0cd6b38382b68f300f3'),
            ('02m/chedar_0359_UV02m.sofa', 'd1bf0211101bc78daa52b408db1bbccc'),
            ('02m/chedar_0360_UV02m.sofa', 'c9db70a09da72b7e33a6037dfaef9843'),
            ('02m/chedar_0361_UV02m.sofa', '0305c71215263908deeac17aa9d3bb6f'),
            ('02m/chedar_0362_UV02m.sofa', '41874fe4c9d64a6dea9d4e82cdb237a4'),
            ('02m/chedar_0363_UV02m.sofa', '517c22de279a3ecae072b682d926f4e1'),
            ('02m/chedar_0364_UV02m.sofa', '1f26e0eccf7b019dca4bb3c2e141f26b'),
            ('02m/chedar_0365_UV02m.sofa', '0acea22b91bdce3688e71311f9a50529'),
            ('02m/chedar_0366_UV02m.sofa', '5d3b59160dd658b0838be9e74956004d'),
            ('02m/chedar_0367_UV02m.sofa', '3845872344f45206ba500e55a556e168'),
            ('02m/chedar_0368_UV02m.sofa', 'f63080555a55691b892dddce556e476a'),
            ('02m/chedar_0369_UV02m.sofa', 'e7c4f1c4b115c0190ef2163f74b49c96'),
            ('02m/chedar_0370_UV02m.sofa', '619cee04a4a5e2598c6b662cfcd9caa1'),
            ('02m/chedar_0371_UV02m.sofa', '183482394693655f31383cb33d71d7ef'),
            ('02m/chedar_0372_UV02m.sofa', 'b8b299f3c96420e29c1680768cebd1eb'),
            ('02m/chedar_0373_UV02m.sofa', '0fa571941a61ba2bbf1270530dfb9f0e'),
            ('02m/chedar_0374_UV02m.sofa', '62a95fd67c0d5626216f6d33a0a41ca1'),
            ('02m/chedar_0375_UV02m.sofa', 'e8aeb107fbcc3b6c49db4e49a9b28e55'),
            ('02m/chedar_0376_UV02m.sofa', 'e193e2de987966d45f87b214df16bb16'),
            ('02m/chedar_0377_UV02m.sofa', 'dfc2c58c02034a6d0c42994287868969'),
            ('02m/chedar_0378_UV02m.sofa', 'f018a38c617830a785bba13dcee483ea'),
            ('02m/chedar_0379_UV02m.sofa', '344dc46fd252fd071b66b01573742c5b'),
            ('02m/chedar_0380_UV02m.sofa', '54d772ccf4405130a856ab89d1c3c30b'),
            ('02m/chedar_0381_UV02m.sofa', 'fe566f83b8d97262e337d78cfdde60fc'),
            ('02m/chedar_0382_UV02m.sofa', '83cdcc6bf0e058b87b54a92936482038'),
            ('02m/chedar_0383_UV02m.sofa', 'ea80efd9455bf9f6101fe3ab47cbe0aa'),
            ('02m/chedar_0384_UV02m.sofa', 'd1545e524a68fabd1d4f23b3e8e3034f'),
            ('02m/chedar_0385_UV02m.sofa', '7967665a4d295fd0840eeed01b4027a4'),
            ('02m/chedar_0386_UV02m.sofa', 'd0eb362707eb2c328395da5929fae43f'),
            ('02m/chedar_0387_UV02m.sofa', '9e544bdcb674b655a522081287e3a948'),
            ('02m/chedar_0388_UV02m.sofa', 'a58ef6275ab26890a98148d2d2b8bc5d'),
            ('02m/chedar_0389_UV02m.sofa', 'c9437d86ae33590d16aaafdc0bc71d7a'),
            ('02m/chedar_0390_UV02m.sofa', '6c242deae1cd12b53cc30858167b46d5'),
            ('02m/chedar_0391_UV02m.sofa', 'd0c51421fe8fbc5bcd027b50f1ae1aa1'),
            ('02m/chedar_0392_UV02m.sofa', 'd78883b8a678162da2771a862981da04'),
            ('02m/chedar_0393_UV02m.sofa', '26d1943812c71b6d81f1f0a39fcae682'),
            ('02m/chedar_0394_UV02m.sofa', '9fdc12c2fc379a415cfa6b0827af85e1'),
            ('02m/chedar_0395_UV02m.sofa', 'f1c010fda0fbc7f5c483c617cd4e9b58'),
            ('02m/chedar_0396_UV02m.sofa', 'b602aee059a5aaed9b952c89bfceef6e'),
            ('02m/chedar_0397_UV02m.sofa', '15e78975189481b8d5672bea6d65ecee'),
            ('02m/chedar_0398_UV02m.sofa', '15ad3e379964eeef9eda79baf4260343'),
            ('02m/chedar_0399_UV02m.sofa', '9aa67cba1d9051661f5f5ff85c756160'),
            ('02m/chedar_0400_UV02m.sofa', 'c571a81be5782b3bc63a54ea5ebce188'),
            ('02m/chedar_0401_UV02m.sofa', '97ea3b0fabb5a80a86de8ed905281c20'),
            ('02m/chedar_0402_UV02m.sofa', '4ecd3747b298983fc07d2918ba881df7'),
            ('02m/chedar_0403_UV02m.sofa', '962924dce18aa8639800a1c1b3b7aaae'),
            ('02m/chedar_0404_UV02m.sofa', '36b8ba68a9b8158b3f342868e7edbe61'),
            ('02m/chedar_0405_UV02m.sofa', 'b08a0b527dfaa480c60520c786c048bc'),
            ('02m/chedar_0406_UV02m.sofa', '358a44d0cc86bfff66bd6987d81d36b6'),
            ('02m/chedar_0407_UV02m.sofa', 'e70c9c95635f9a04797942f46603ecce'),
            ('02m/chedar_0408_UV02m.sofa', '41674f43bcb5f41a3f862039dd458fd6'),
            ('02m/chedar_0409_UV02m.sofa', '91746aadd5ac86070b859a6bb121d4e4'),
            ('02m/chedar_0410_UV02m.sofa', '6cdf054bc2f1b95973ee79b1d14e8c3a'),
            ('02m/chedar_0411_UV02m.sofa', 'a218562b107e689cd8dfbe3036000331'),
            ('02m/chedar_0412_UV02m.sofa', '697c4daedb1178d1a883da3ef77907f6'),
            ('02m/chedar_0413_UV02m.sofa', 'b8ab398f49ad482de7813d2cc1f564d6'),
            ('02m/chedar_0414_UV02m.sofa', 'ddb0bbe48560d914194d536c3030884b'),
            ('02m/chedar_0415_UV02m.sofa', '8d755453d8e63b112c286aa001522ce0'),
            ('02m/chedar_0416_UV02m.sofa', '141f78343a0b87e169027a34f2a1f82b'),
            ('02m/chedar_0417_UV02m.sofa', '741905ebffe95bed763def37e1a256f2'),
            ('02m/chedar_0418_UV02m.sofa', '70e4e08e724a383a6907e2dabd34cc00'),
            ('02m/chedar_0419_UV02m.sofa', '93879729a589ba5cdc992b1f7009fe68'),
            ('02m/chedar_0420_UV02m.sofa', '928d0780584bef2b0e7008acb8937ad5'),
            ('02m/chedar_0421_UV02m.sofa', 'ad19d0e6b2210350e65e0aa557d3f506'),
            ('02m/chedar_0422_UV02m.sofa', 'eca5dd5e5fcff5c5b0b942968a970b49'),
            ('02m/chedar_0423_UV02m.sofa', 'd96795daf23d523fa3555851d5938bf9'),
            ('02m/chedar_0424_UV02m.sofa', 'b1d8e494d935446f31a63dd30cc2fead'),
            ('02m/chedar_0425_UV02m.sofa', 'c3721bfc5db3f59b03963b0770b6f9c8'),
            ('02m/chedar_0426_UV02m.sofa', '13b175a04df88b768117c3d273f7f952'),
            ('02m/chedar_0427_UV02m.sofa', 'ea9f0e92542d7a7efd94161f370ccb73'),
            ('02m/chedar_0428_UV02m.sofa', 'c2bf1a9bec86c8d201d65623a33d3c46'),
            ('02m/chedar_0429_UV02m.sofa', '06e1d9e8b7f9acfaa4640b0bb9719f46'),
            ('02m/chedar_0430_UV02m.sofa', '20cfcb3d7e4744d9ddc917df201b5798'),
            ('02m/chedar_0431_UV02m.sofa', 'b000fa92f9a70277fc7f9c987740c95b'),
            ('02m/chedar_0432_UV02m.sofa', '3f5f3925dceb03952750a93ad0c4fb71'),
            ('02m/chedar_0433_UV02m.sofa', '681c0326a49dc70be10bf940859dbbf6'),
            ('02m/chedar_0434_UV02m.sofa', 'c4b8687d03cb0360163070c5c7085abf'),
            ('02m/chedar_0435_UV02m.sofa', '2eace13864a9e3eeabc91991fc38f9dd'),
            ('02m/chedar_0436_UV02m.sofa', '766bb84d244f269076817c2f1cfe0b41'),
            ('02m/chedar_0437_UV02m.sofa', '6ca34aca3addfa350b963e2d5482d2d7'),
            ('02m/chedar_0438_UV02m.sofa', '219eab180418468d8b4dca3cf8ceb647'),
            ('02m/chedar_0439_UV02m.sofa', 'cd811dd0e5c19dcba0806912ee28aa4d'),
            ('02m/chedar_0440_UV02m.sofa', 'e05235359754ac40de9dbd7308cdbb0a'),
            ('02m/chedar_0441_UV02m.sofa', '74baf270b3b5f99782b544edad0ef5b5'),
            ('02m/chedar_0442_UV02m.sofa', '018b39f095948f0fc92854001f713d51'),
            ('02m/chedar_0443_UV02m.sofa', '15e4b5bd6a366319b49c3f943b19a971'),
            ('02m/chedar_0444_UV02m.sofa', '5e1e55071d2fd4c5e7ef8737db5a6c36'),
            ('02m/chedar_0445_UV02m.sofa', '9ae11a3f2824140f54bab2030f068321'),
            ('02m/chedar_0446_UV02m.sofa', '7cfed09dd5eea0d452d1d6ac2688b653'),
            ('02m/chedar_0447_UV02m.sofa', 'ddd2923072fa00ff6ad8337b459ef54e'),
            ('02m/chedar_0448_UV02m.sofa', '1688c2710db81254b135361b98fc5002'),
            ('02m/chedar_0449_UV02m.sofa', 'b161be4ea7ea5836a629a6387de3440a'),
            ('02m/chedar_0450_UV02m.sofa', '5b62eb21313430951751fe9f60f2501b'),
            ('02m/chedar_0451_UV02m.sofa', 'c65064a2dc7241a1e729cefefa754c86'),
            ('02m/chedar_0452_UV02m.sofa', '28d5c0846ec608063de37b8d07f80f0f'),
            ('02m/chedar_0453_UV02m.sofa', 'cb401388fff100d9b08070857e02f777'),
            ('02m/chedar_0454_UV02m.sofa', 'a81e48311973c4f18a5b1d0658c47b48'),
            ('02m/chedar_0455_UV02m.sofa', 'f6476ea3e34d47e49cc6479f6e507a6d'),
            ('02m/chedar_0456_UV02m.sofa', '721be689b2329c36265141881fc4c1eb'),
            ('02m/chedar_0457_UV02m.sofa', '2e5391dcf1e257bb1dca88b2da46c455'),
            ('02m/chedar_0458_UV02m.sofa', '440164d56e0b4a1064450280a28ac55d'),
            ('02m/chedar_0459_UV02m.sofa', '24a05207cd927eae6521b8fb7ba7f6e6'),
            ('02m/chedar_0460_UV02m.sofa', '0eee8e9bf392137aaab77a8189b58cd5'),
            ('02m/chedar_0461_UV02m.sofa', 'aed2f541f1b398bd8e67ab0c1085329a'),
            ('02m/chedar_0462_UV02m.sofa', '03bad1b3f7e9df7bc5eb0f846aebca51'),
            ('02m/chedar_0463_UV02m.sofa', 'cf6285c29b41ab684f093ac604ecd903'),
            ('02m/chedar_0464_UV02m.sofa', 'd90af338f81af6f0e0b14f3797495812'),
            ('02m/chedar_0465_UV02m.sofa', '26872b1b40b7fdf8a6675724be001f01'),
            ('02m/chedar_0466_UV02m.sofa', '5804b0c71fe8f2689d58d3664a3e47ab'),
            ('02m/chedar_0467_UV02m.sofa', 'a7ddc26fd856dd7380228d59198bc2c4'),
            ('02m/chedar_0468_UV02m.sofa', 'c333c749fbb9c0e6ea71567d89f6f7bb'),
            ('02m/chedar_0469_UV02m.sofa', '5ffe7b39c492aabd8e43f95a80d7d47c'),
            ('02m/chedar_0470_UV02m.sofa', '94810e10336c2c117ec134ce304a682c'),
            ('02m/chedar_0471_UV02m.sofa', '565f020df64b04bf45958ee716a8d3ea'),
            ('02m/chedar_0472_UV02m.sofa', '558c91115b99f991d91936425950d583'),
            ('02m/chedar_0473_UV02m.sofa', '2d0e54e1f0b1e6c20265bd214de2ebf8'),
            ('02m/chedar_0474_UV02m.sofa', 'a18554bc3b97a8ae9e2ea0e583bdc768'),
            ('02m/chedar_0475_UV02m.sofa', '0d6e992af3a51c19917e7f12e1ea5134'),
            ('02m/chedar_0476_UV02m.sofa', '94d02c0cb7d81dd4df45fbefc64a33fc'),
            ('02m/chedar_0477_UV02m.sofa', '9b5f261dd0b6b6f7c619ba0845ed32af'),
            ('02m/chedar_0478_UV02m.sofa', '3efaf0e527aebdadbd1d67f422316499'),
            ('02m/chedar_0479_UV02m.sofa', '817b30078c7151362229b38231926e7c'),
            ('02m/chedar_0480_UV02m.sofa', 'd2cae3c9c5b522cea8cfd9a42a593545'),
            ('02m/chedar_0481_UV02m.sofa', '0f5f7b6d038ff2548c5cd3a671203049'),
            ('02m/chedar_0482_UV02m.sofa', '8a43583730e4dc9e424ad990a1791810'),
            ('02m/chedar_0483_UV02m.sofa', '9322d84c305ec1a82b8f321a8387446d'),
            ('02m/chedar_0484_UV02m.sofa', '98eeae0c8cf5746d4e302ef5d8183c3d'),
            ('02m/chedar_0485_UV02m.sofa', '42948c0dbcf0a9111009eb0a413fa5d1'),
            ('02m/chedar_0486_UV02m.sofa', '76cc5b51d28166202d29280885f2d7e4'),
            ('02m/chedar_0487_UV02m.sofa', '11559cd5206d55350ba484731161b7ed'),
            ('02m/chedar_0488_UV02m.sofa', '77d4abf741de292b2bed0560f24a640f'),
            ('02m/chedar_0489_UV02m.sofa', '8421fe90736525d0e24dca68674b94a5'),
            ('02m/chedar_0490_UV02m.sofa', '7ba7276b0c707ba4ed7615f8cd087cd3'),
            ('02m/chedar_0491_UV02m.sofa', 'e046bc45eaa122f34000c6d0bd4976b7'),
            ('02m/chedar_0492_UV02m.sofa', '0d582eff811381ef71b9c7a49e32e972'),
            ('02m/chedar_0493_UV02m.sofa', '31b8ff8d80ab647bf4157409b7bf2918'),
            ('02m/chedar_0494_UV02m.sofa', 'bb6754e94229e59502eb61a3879d6e0f'),
            ('02m/chedar_0495_UV02m.sofa', '55c0ce533724640b0fb81adfe1747160'),
            ('02m/chedar_0496_UV02m.sofa', '9c688590a78272336c66844fbe684a43'),
            ('02m/chedar_0497_UV02m.sofa', 'f89435f8c96d5db59f801690d975c7c1'),
            ('02m/chedar_0498_UV02m.sofa', 'b5085eb74c5d43b4f3a6646eb11b187e'),
            ('02m/chedar_0499_UV02m.sofa', '0d371274082833732d0761728b99ca50'),
            ('02m/chedar_0500_UV02m.sofa', '2b4992987c0462371af5f7ae02e9545f'),
            ('02m/chedar_0501_UV02m.sofa', 'f138fd50a0a7750a2377bab8194701c2'),
            ('02m/chedar_0502_UV02m.sofa', '9416a111d39a3ca7901ae7331d6f3ec4'),
            ('02m/chedar_0503_UV02m.sofa', '92fff97a60187f476ad590d4f2a0742e'),
            ('02m/chedar_0504_UV02m.sofa', 'f69c2b86eee2c30fbcb7e3b683bfd4e4'),
            ('02m/chedar_0505_UV02m.sofa', 'f811385b62eef5af81405f7e0af0be46'),
            ('02m/chedar_0506_UV02m.sofa', '078a407d235ce4a70043ae0027c5fb71'),
            ('02m/chedar_0507_UV02m.sofa', '01af57b0f804fb6cf1520cc71aa32f6e'),
            ('02m/chedar_0508_UV02m.sofa', '0762116ac26e6d016e659b0198146277'),
            ('02m/chedar_0509_UV02m.sofa', '4c9b4b6a26298cc9ee294d5c99aad912'),
            ('02m/chedar_0510_UV02m.sofa', '229d9394e3566120985732e0f2a2100d'),
            ('02m/chedar_0511_UV02m.sofa', '16752e1a3cf841352263a3db9cb5e2f6'),
            ('02m/chedar_0512_UV02m.sofa', '24fa1a64b4f4c05999d3b321f948d151'),
            ('02m/chedar_0513_UV02m.sofa', '3d8c2ea4333c6d4f902815acaebbad3c'),
            ('02m/chedar_0514_UV02m.sofa', 'c9f6ccb6e8e3ae2c9ac7003cea9aee08'),
            ('02m/chedar_0515_UV02m.sofa', '0e9ffd258c6b0fa115a24f2437bc508b'),
            ('02m/chedar_0516_UV02m.sofa', 'be12b9b3f61c4ead0a866f7c3eb3c1b6'),
            ('02m/chedar_0517_UV02m.sofa', 'cb5c35d387f2133adf8e85a7e6c00f34'),
            ('02m/chedar_0518_UV02m.sofa', 'b2336770df49e3fac7d26567487fede4'),
            ('02m/chedar_0519_UV02m.sofa', '590f0949761fe8463267039acd3026fa'),
            ('02m/chedar_0520_UV02m.sofa', 'bc1dc1a85a4e1e34f00e7b3d1ee7df16'),
            ('02m/chedar_0521_UV02m.sofa', '33969fe5658820c1bf9bb7d67b3a0bd1'),
            ('02m/chedar_0522_UV02m.sofa', 'fbb57ea4c14a886c90f34124bb9e43ca'),
            ('02m/chedar_0523_UV02m.sofa', '89b983e9bef38f245c8c674992777e4b'),
            ('02m/chedar_0524_UV02m.sofa', '574912962e3eecb064ea20bfbf3c904a'),
            ('02m/chedar_0525_UV02m.sofa', 'a58332029e137ca46eabae24deb0ff62'),
            ('02m/chedar_0526_UV02m.sofa', 'f7a7fa495b5fb850a8eece971a4bb7fd'),
            ('02m/chedar_0527_UV02m.sofa', 'e1e4cce4e72e79f83c8d64f2e9e632cd'),
            ('02m/chedar_0528_UV02m.sofa', 'f4f8046eee1a285e48d43a49bd1effc1'),
            ('02m/chedar_0529_UV02m.sofa', '468790e8346102874b177c4f820085c1'),
            ('02m/chedar_0530_UV02m.sofa', '20f76066662c8793853f1b4b3c033d24'),
            ('02m/chedar_0531_UV02m.sofa', '460d2e3a555a9b48836719e122d8d9c4'),
            ('02m/chedar_0532_UV02m.sofa', 'fd325898320a0060fddece2a18676aba'),
            ('02m/chedar_0533_UV02m.sofa', 'd58b759ccf0b30b562a2fa29ce08fc25'),
            ('02m/chedar_0534_UV02m.sofa', 'e90c1d8c36e77ba016a37e24a8c5d908'),
            ('02m/chedar_0535_UV02m.sofa', '1c4bf30697fbcf535ae69103451a5734'),
            ('02m/chedar_0536_UV02m.sofa', '4a85f75f04dfec8bc11b13de77195e4f'),
            ('02m/chedar_0537_UV02m.sofa', 'ab6bdf4f1f882b3f7118f2f48e3c0327'),
            ('02m/chedar_0538_UV02m.sofa', 'ea000f90e8cd88f4b62b8561f37b1415'),
            ('02m/chedar_0539_UV02m.sofa', '5cf8f6e9c24fdb698be2a78d55c0d8c8'),
            ('02m/chedar_0540_UV02m.sofa', '40cadd840f6fa42eb216817b7c7a966f'),
            ('02m/chedar_0541_UV02m.sofa', 'f13625b728a8fa026d2c41cedb954e46'),
            ('02m/chedar_0542_UV02m.sofa', '81d8b3915118115ddf48200c7678a013'),
            ('02m/chedar_0543_UV02m.sofa', '652894efdaf265ab03983cfee1d9a3dd'),
            ('02m/chedar_0544_UV02m.sofa', 'c8d9a3cf2922c81faab3d733c4517334'),
            ('02m/chedar_0545_UV02m.sofa', '0f5ab71377314f124d149403bd0109d2'),
            ('02m/chedar_0546_UV02m.sofa', '6c72c5579f26edd02e29df9bfa4b6849'),
            ('02m/chedar_0547_UV02m.sofa', 'd0aa8935e814ca1840584be9228778d8'),
            ('02m/chedar_0548_UV02m.sofa', '50200b9b06b3bae91c24f1b5e6950d99'),
            ('02m/chedar_0549_UV02m.sofa', '9256ac19755d2de3255a0e05fdbea751'),
            ('02m/chedar_0550_UV02m.sofa', '2dab01f9f2115cc85edceb62fc3cf165'),
            ('02m/chedar_0551_UV02m.sofa', 'cd19e44099f424b4a72fdad4eb97c738'),
            ('02m/chedar_0552_UV02m.sofa', 'abb820d41c0a8053bcd1872ea876b3cf'),
            ('02m/chedar_0553_UV02m.sofa', 'c391d98a90908b24dc2b013e88e356a6'),
            ('02m/chedar_0554_UV02m.sofa', '10f2b3ba6fbd9b0dfda9f649e814bdc3'),
            ('02m/chedar_0555_UV02m.sofa', '6715c3a7f98bcd93b0318c8e013c0c61'),
            ('02m/chedar_0556_UV02m.sofa', '38d779b5695e28f92f93672bc490ad96'),
            ('02m/chedar_0557_UV02m.sofa', 'fc580673bb7e6cf1e8f1c7a93011dfed'),
            ('02m/chedar_0558_UV02m.sofa', '43736f0cb96243fbea7889ab558aaee5'),
            ('02m/chedar_0559_UV02m.sofa', 'b164e5d0669770628f2e57dd778cbfe6'),
            ('02m/chedar_0560_UV02m.sofa', '1a994ba4e5ef85731bba7085c3f490ac'),
            ('02m/chedar_0561_UV02m.sofa', '10a603cabe75fa504c4c344aa57851c5'),
            ('02m/chedar_0562_UV02m.sofa', 'c0b2cde474053668b3ad1943a00b9df6'),
            ('02m/chedar_0563_UV02m.sofa', '961ced6736e913d10a4bb36faab25a76'),
            ('02m/chedar_0564_UV02m.sofa', 'a1b80f912c9ac2466dd09dfa1bfc0051'),
            ('02m/chedar_0565_UV02m.sofa', 'fda209822e356d9d08713772b7d21fe1'),
            ('02m/chedar_0566_UV02m.sofa', '566ca1df774a766c3955f9cf3d89b965'),
            ('02m/chedar_0567_UV02m.sofa', '2cfa53d58f11506a16d5318efd01fa03'),
            ('02m/chedar_0568_UV02m.sofa', '2fc613b285acc5375d92355c5f57752a'),
            ('02m/chedar_0569_UV02m.sofa', '332319fcd0e3ad2f721c0062d95b4482'),
            ('02m/chedar_0570_UV02m.sofa', '49d116704a9543f53461eef7b7375486'),
            ('02m/chedar_0571_UV02m.sofa', 'a50a758df4489762065aaf494c7d25e5'),
            ('02m/chedar_0572_UV02m.sofa', '363beb8ac26a2c27b6e8358907acc88d'),
            ('02m/chedar_0573_UV02m.sofa', 'e72d5eef5be7e9ee3d28262eedb55697'),
            ('02m/chedar_0574_UV02m.sofa', '543681ab3bd6105fe592df03073f6fdc'),
            ('02m/chedar_0575_UV02m.sofa', '51bdd3b9ada99a0800b5b0ad6a5f25a0'),
            ('02m/chedar_0576_UV02m.sofa', '962d5238e39027a057900d04a6279c3a'),
            ('02m/chedar_0577_UV02m.sofa', '8f77807067c69956be8d6e64db3d3a60'),
            ('02m/chedar_0578_UV02m.sofa', 'ed199a77776382807a6b64198498c4de'),
            ('02m/chedar_0579_UV02m.sofa', '3a48fa560b6fe9239ade315e6a3f9409'),
            ('02m/chedar_0580_UV02m.sofa', 'dae647ef573d58ca292fb3973edd99ab'),
            ('02m/chedar_0581_UV02m.sofa', '3268222d663177a6455df16714a4c9c3'),
            ('02m/chedar_0582_UV02m.sofa', 'fe9a0db82ee027aeae46433f6eacf535'),
            ('02m/chedar_0583_UV02m.sofa', '4fbc35d893050dc3bbb7d38d8448f6ee'),
            ('02m/chedar_0584_UV02m.sofa', '19705812480b835eade8f44d8a1ad227'),
            ('02m/chedar_0585_UV02m.sofa', '8ed2dab62658d1d93d029db5e3427221'),
            ('02m/chedar_0586_UV02m.sofa', 'd510b21fcb3c476c2b778565b2bf50bc'),
            ('02m/chedar_0587_UV02m.sofa', 'c359aa6126686ebfc3ce062ac5396833'),
            ('02m/chedar_0588_UV02m.sofa', '2885f025af1b3785fe40408cb9df6cae'),
            ('02m/chedar_0589_UV02m.sofa', '02f424aa98c4aa338fbad7aa8adc0120'),
            ('02m/chedar_0590_UV02m.sofa', '6e2fd0da3bdb4eb0196a0f3118711fa4'),
            ('02m/chedar_0591_UV02m.sofa', 'd16ce483574c0513eae7ebe4ce6dc653'),
            ('02m/chedar_0592_UV02m.sofa', '09e8e3e96263ca5844a9b3f69fe61df2'),
            ('02m/chedar_0593_UV02m.sofa', 'c7b8eb6c70bf4830f833eee357aac51f'),
            ('02m/chedar_0594_UV02m.sofa', '42829b88b7bfa476531ebd964ee406e6'),
            ('02m/chedar_0595_UV02m.sofa', '981df5a1d1eba1010383c70141616d40'),
            ('02m/chedar_0596_UV02m.sofa', 'a883aef183e1abca125ef99139a899a4'),
            ('02m/chedar_0597_UV02m.sofa', '30ed443a79d55d719445981888372226'),
            ('02m/chedar_0598_UV02m.sofa', '9c771bde01a1cc2f7eb5b2b03bf232e8'),
            ('02m/chedar_0599_UV02m.sofa', '031a7bf04fcb8804b88a836e494f9cf2'),
            ('02m/chedar_0600_UV02m.sofa', 'f4f2326010940aa424b2233136cf8d33'),
            ('02m/chedar_0601_UV02m.sofa', '145b7002c569ba0f5e793b181950e1ac'),
            ('02m/chedar_0602_UV02m.sofa', '6922947e038ec2e075d538b9cf300fa4'),
            ('02m/chedar_0603_UV02m.sofa', '1d97f00935535458bfa02e71e9e1f6b1'),
            ('02m/chedar_0604_UV02m.sofa', 'c27f548ad8b11d0958e9ad64c8ba7a95'),
            ('02m/chedar_0605_UV02m.sofa', '466ea741eec909f91b4e45339839b5c3'),
            ('02m/chedar_0606_UV02m.sofa', '72d8f5a46bf39c7cf486655648218a61'),
            ('02m/chedar_0607_UV02m.sofa', 'a8e33065933e1a7705193f95d98d7688'),
            ('02m/chedar_0608_UV02m.sofa', '034e4c8846bafd3ce47f4bc1edd1c5a3'),
            ('02m/chedar_0609_UV02m.sofa', '02253f4c54d534332e76332717dfb960'),
            ('02m/chedar_0610_UV02m.sofa', '81c61f93077b8bb364e27138b05f61ac'),
            ('02m/chedar_0611_UV02m.sofa', '88cbf4dbcb4c9d5db2c2628d2807a079'),
            ('02m/chedar_0612_UV02m.sofa', '9252f3e95a4fa458b1e945c44d6c58ea'),
            ('02m/chedar_0613_UV02m.sofa', '71755848d2e9e6fb52d15aaa5df0d6bc'),
            ('02m/chedar_0614_UV02m.sofa', '943dbc7707141634a2c9bfb3e9d24d3a'),
            ('02m/chedar_0615_UV02m.sofa', 'c346e77748b65cd68847094464196e5d'),
            ('02m/chedar_0616_UV02m.sofa', '6b75eeadf7e69b5fe6ce36e98331175a'),
            ('02m/chedar_0617_UV02m.sofa', '80a2e294c51da6e856d825209e99df5f'),
            ('02m/chedar_0618_UV02m.sofa', '9b788270b1d04236d9062856f99ea3b1'),
            ('02m/chedar_0619_UV02m.sofa', '13ac1572d69c58df1caf0a695146101c'),
            ('02m/chedar_0620_UV02m.sofa', '69521330d83cd4a095099fa0104df60a'),
            ('02m/chedar_0621_UV02m.sofa', 'a647b11afd7424e18899f2e96a4e4f63'),
            ('02m/chedar_0622_UV02m.sofa', 'f52ca8033fbc52499a551cfbe6a9904d'),
            ('02m/chedar_0623_UV02m.sofa', 'b1300a9d3b4bc94de46eb652950aba4b'),
            ('02m/chedar_0624_UV02m.sofa', '45c85430b79386e5604784fd522efb53'),
            ('02m/chedar_0625_UV02m.sofa', '9ebc43e2baca9dd72953bb2d06f55f54'),
            ('02m/chedar_0626_UV02m.sofa', '692896f3c0c84edb118d8fc316d47fe3'),
            ('02m/chedar_0627_UV02m.sofa', '12e402fe3474e045f5c90c724c77c411'),
            ('02m/chedar_0628_UV02m.sofa', '10bf184977321720a2c73b059c4269f1'),
            ('02m/chedar_0629_UV02m.sofa', '496fd808241d15a04970f45648fa1c67'),
            ('02m/chedar_0630_UV02m.sofa', 'ad649d89826c4279d7bb4893d18b3f43'),
            ('02m/chedar_0631_UV02m.sofa', '248001624e028aa3c7f5f13843584c27'),
            ('02m/chedar_0632_UV02m.sofa', '4ec642bd7fe009755604000d8b03c014'),
            ('02m/chedar_0633_UV02m.sofa', 'f6acf4bea7b93617383c7028a2b41287'),
            ('02m/chedar_0634_UV02m.sofa', 'dc1cd51609c7f0a87db727543bde3d1c'),
            ('02m/chedar_0635_UV02m.sofa', 'abda311a1e82172ca6ab506b57e69a12'),
            ('02m/chedar_0636_UV02m.sofa', '9f6b4cd3069885f2a7db6187a500cbba'),
            ('02m/chedar_0637_UV02m.sofa', '35915d2ba842e83a47d017a72d110825'),
            ('02m/chedar_0638_UV02m.sofa', '1b7e352d952ae331cb122bc4f6e2bdbb'),
            ('02m/chedar_0639_UV02m.sofa', '8464642a9231783b7125c446c66a5296'),
            ('02m/chedar_0640_UV02m.sofa', '0fb6749498414d97a43bafe7ba7cba92'),
            ('02m/chedar_0641_UV02m.sofa', '0394be563f63f65689cdd35fdd211b38'),
            ('02m/chedar_0642_UV02m.sofa', 'b9a4245e7903454dc49ee3385891371d'),
            ('02m/chedar_0643_UV02m.sofa', '81e0922a4cbe6fdf21754331d13f5fe4'),
            ('02m/chedar_0644_UV02m.sofa', '95c39354382590fd7b7b64b44151dc91'),
            ('02m/chedar_0645_UV02m.sofa', '50a6ce7a9b717d785daee41e70dd82f3'),
            ('02m/chedar_0646_UV02m.sofa', 'dcd2209c8beaf85fc6c28e7ac88618db'),
            ('02m/chedar_0647_UV02m.sofa', 'c712a5f7dfb6bc1da7112ede68d6109e'),
            ('02m/chedar_0648_UV02m.sofa', '74727021a590145c57ca671667377b8e'),
            ('02m/chedar_0649_UV02m.sofa', '977fefd1a411d37100001a3ca4d4c16c'),
            ('02m/chedar_0650_UV02m.sofa', '8fa112efd76edcda4ddf82fb433ae341'),
            ('02m/chedar_0651_UV02m.sofa', 'caef47f55ae7eef457a514557c2eb3f9'),
            ('02m/chedar_0652_UV02m.sofa', '14ce9bff87269abff6c80ebbc2c8ca63'),
            ('02m/chedar_0653_UV02m.sofa', '03bc50bd13586d1bf3c70f48c165f4b6'),
            ('02m/chedar_0654_UV02m.sofa', '51165b3166ef0e308efcba510fa0277f'),
            ('02m/chedar_0655_UV02m.sofa', '3f32481b0b6157d12ec6c8778d9d4431'),
            ('02m/chedar_0656_UV02m.sofa', 'd302299ecd0469195ca6c609c478f1df'),
            ('02m/chedar_0657_UV02m.sofa', '6c283dd4a2266efc3cd5bfd4d6172f00'),
            ('02m/chedar_0658_UV02m.sofa', 'ed2852856acf1c10fa13776a495d8e9c'),
            ('02m/chedar_0659_UV02m.sofa', '34283362711474bf4fc21bfa7f1ee64c'),
            ('02m/chedar_0660_UV02m.sofa', '2f63bbd16da55b438a8d6d5553fa3488'),
            ('02m/chedar_0661_UV02m.sofa', '527a3b5a00b9f7640b1beef44b81948f'),
            ('02m/chedar_0662_UV02m.sofa', 'a4d256df000a83513f38ea56d6e35dcc'),
            ('02m/chedar_0663_UV02m.sofa', 'bdfef7f1aad1974d3e5c930c6c28da0f'),
            ('02m/chedar_0664_UV02m.sofa', '348afee863fca99ac7be08fdc73977e5'),
            ('02m/chedar_0665_UV02m.sofa', '7e7131fc43aea55f8d949ee8878e6dad'),
            ('02m/chedar_0666_UV02m.sofa', '5bcf8f1b1003258818bcc55e625daad2'),
            ('02m/chedar_0667_UV02m.sofa', '0234b7dc758df24520677c9b2597feaf'),
            ('02m/chedar_0668_UV02m.sofa', '4854267cf1b09a2f52f700ad45a63bad'),
            ('02m/chedar_0669_UV02m.sofa', '482ea6934b86547d04c589ef0d8b04ca'),
            ('02m/chedar_0670_UV02m.sofa', 'e754c18df8305644f53d2c84fb3150d8'),
            ('02m/chedar_0671_UV02m.sofa', '4b1ac2a4cd4c4a9296ce383ffc81dcee'),
            ('02m/chedar_0672_UV02m.sofa', '3f8a3a18e6adca0be4521f6676f58e78'),
            ('02m/chedar_0673_UV02m.sofa', '7c6ad892007ee77d394362aa1b1fc5dc'),
            ('02m/chedar_0674_UV02m.sofa', '055db9608fa865c2a9ae087db942a65c'),
            ('02m/chedar_0675_UV02m.sofa', '7fd75c821f93b9d3df6c880b7446eeac'),
            ('02m/chedar_0676_UV02m.sofa', '9957f0c36aeafa40ebb0a9c656e47efe'),
            ('02m/chedar_0677_UV02m.sofa', 'd62e24bc259ae92808d18665ef63b47a'),
            ('02m/chedar_0678_UV02m.sofa', '63e0af34229ee5bbf069060e7956e184'),
            ('02m/chedar_0679_UV02m.sofa', '5636a8d33d22a5abae173bad2e681282'),
            ('02m/chedar_0680_UV02m.sofa', '83f28a634071c1014bbe72e9af6b63e0'),
            ('02m/chedar_0681_UV02m.sofa', '6ea51b722a26931b847ee6b96989f04e'),
            ('02m/chedar_0682_UV02m.sofa', 'd0df7649addbda7cd6b46c8b7359e36b'),
            ('02m/chedar_0683_UV02m.sofa', 'dd42e678e7ff895c74a29a2949544964'),
            ('02m/chedar_0684_UV02m.sofa', 'b0497db42ccb2ad4a301107fbfd2f189'),
            ('02m/chedar_0685_UV02m.sofa', '82296530750fc99cde0555919a51faba'),
            ('02m/chedar_0686_UV02m.sofa', 'fd4e4e03fe3b19359ffb114cad0fb3be'),
            ('02m/chedar_0687_UV02m.sofa', 'ccebaf7b86de46a4f607fd5bb140effe'),
            ('02m/chedar_0688_UV02m.sofa', 'e3b99b38b50a3f0198611cdf4296c04d'),
            ('02m/chedar_0689_UV02m.sofa', '6c3f6deac686d03d8c7ff68976d56f3f'),
            ('02m/chedar_0690_UV02m.sofa', 'f40d93cb2159c2bda8beb2048485323c'),
            ('02m/chedar_0691_UV02m.sofa', 'b2470efb4b9fc62659f4056749ee97c0'),
            ('02m/chedar_0692_UV02m.sofa', '0f2a6c393bac93db38b1f494beaf6ee3'),
            ('02m/chedar_0693_UV02m.sofa', 'efa46b378510af47082600193db1e2f4'),
            ('02m/chedar_0694_UV02m.sofa', 'ff5d63035c32cf9c336386e3459d1745'),
            ('02m/chedar_0695_UV02m.sofa', '16e2e2ad0c636c75a182191e664474b8'),
            ('02m/chedar_0696_UV02m.sofa', '157f7870bab74b1e6ebcae5688ec57d1'),
            ('02m/chedar_0697_UV02m.sofa', '9fe0cfcefe89be9fd5746d9bf56fbaa8'),
            ('02m/chedar_0698_UV02m.sofa', 'e573fa06c639354168d99d9ccfe0b223'),
            ('02m/chedar_0699_UV02m.sofa', '26800f9a39d7934c18d4d962da3c106d'),
            ('02m/chedar_0700_UV02m.sofa', '3b350dfc4a3d15f89388db9a5ef40da2'),
            ('02m/chedar_0701_UV02m.sofa', 'f99990bab884e51c64461ff6bca1ff16'),
            ('02m/chedar_0702_UV02m.sofa', 'eed14b593b65e4180f1696f9511b5912'),
            ('02m/chedar_0703_UV02m.sofa', 'bc30003ecc7aef391550575535770d3a'),
            ('02m/chedar_0704_UV02m.sofa', '4d07fd698cfae0f79aad9f443160e343'),
            ('02m/chedar_0705_UV02m.sofa', 'd66e8ff52fde8dbaae1a481a28e595ef'),
            ('02m/chedar_0706_UV02m.sofa', '2cd106994784b22cc27c95601b734ba9'),
            ('02m/chedar_0707_UV02m.sofa', '0d5c2b16953207e4b617fd0b8750a035'),
            ('02m/chedar_0708_UV02m.sofa', '4a59c55283e12acb3c7bcc037696de5c'),
            ('02m/chedar_0709_UV02m.sofa', '56374fec205ea78b72e0ee9b18a316ad'),
            ('02m/chedar_0710_UV02m.sofa', '412544497ce12cd46e1cda63fab05260'),
            ('02m/chedar_0711_UV02m.sofa', '16291b2353bb546bb36a3a2e0c8d1ff4'),
            ('02m/chedar_0712_UV02m.sofa', '2aa861357d9e160cbeb4c5660ed1b8b6'),
            ('02m/chedar_0713_UV02m.sofa', 'd8ffc2fbf1b7ffdee873b035d38489e3'),
            ('02m/chedar_0714_UV02m.sofa', '34c491f34cfe81ed5f394400083c6938'),
            ('02m/chedar_0715_UV02m.sofa', '2d2ee7b4d09d4d2e638595b0f10e48bb'),
            ('02m/chedar_0716_UV02m.sofa', '92eb6b210d379aa088665f98a127cb44'),
            ('02m/chedar_0717_UV02m.sofa', '213609a68c3d7d4ad327fd8e62938a35'),
            ('02m/chedar_0718_UV02m.sofa', '496284bafec9f5e8c21064ab465a8b87'),
            ('02m/chedar_0719_UV02m.sofa', '0632193b9ea5a1d49933d48cfa868fed'),
            ('02m/chedar_0720_UV02m.sofa', '26b42a4feb5c04447e93f12949d16b98'),
            ('02m/chedar_0721_UV02m.sofa', '255b048b852c20f4ce3f0141cc4ac442'),
            ('02m/chedar_0722_UV02m.sofa', 'cb411b05d15c525c2cb21e4befee41d5'),
            ('02m/chedar_0723_UV02m.sofa', 'cfdf432623f80bca01534dd692acf3bd'),
            ('02m/chedar_0724_UV02m.sofa', 'ca1ee2d0b2436d79aceb1780a7f31e94'),
            ('02m/chedar_0725_UV02m.sofa', 'ed96429251f5fcaac44b439541f86705'),
            ('02m/chedar_0726_UV02m.sofa', '2b78f938cc57fb5c42f4e76382d7f3ff'),
            ('02m/chedar_0727_UV02m.sofa', 'dfbd9ff06e19444b467e94c5ff295f61'),
            ('02m/chedar_0728_UV02m.sofa', '2170cd39dafab554242b313fd02c0673'),
            ('02m/chedar_0729_UV02m.sofa', 'a324fa85fca8ab4caec60213a955ff9c'),
            ('02m/chedar_0730_UV02m.sofa', '6b4e2fba671ccd46edc9427060594940'),
            ('02m/chedar_0731_UV02m.sofa', '44a6b5c923b83ac4e7660f16b42b8ec5'),
            ('02m/chedar_0732_UV02m.sofa', 'da56364f2763b20f05f0d35be2422d1e'),
            ('02m/chedar_0733_UV02m.sofa', '00359fb7cbdc4115d2255a5b085e1d9e'),
            ('02m/chedar_0734_UV02m.sofa', '0c5beb6b8393c1381f31f2b3191db879'),
            ('02m/chedar_0735_UV02m.sofa', '69dc6a7ed3184f1f648f676ad82f5202'),
            ('02m/chedar_0736_UV02m.sofa', 'bf8a11a523c23c57fac08b4bdfcf6aa7'),
            ('02m/chedar_0737_UV02m.sofa', '053de3af7b0189a64d2eef68cfda094a'),
            ('02m/chedar_0738_UV02m.sofa', '7c6ec2b988ec3fda5125cb4b72e76329'),
            ('02m/chedar_0739_UV02m.sofa', 'ab2fdcc53ef0402f5fa96c48a7e293e7'),
            ('02m/chedar_0740_UV02m.sofa', 'a0260b96a384fa5db0f310e246851d00'),
            ('02m/chedar_0741_UV02m.sofa', '14b0857e6deb3b52ada27117fece64a3'),
            ('02m/chedar_0742_UV02m.sofa', '40f325d975c076d083f0ac86ef221145'),
            ('02m/chedar_0743_UV02m.sofa', 'f4c75b385c1a0cb21ba0921340dd9530'),
            ('02m/chedar_0744_UV02m.sofa', 'ebd46e477186862163f6c7c91592456c'),
            ('02m/chedar_0745_UV02m.sofa', 'd4c6c75f6d93791da889964c06c16aff'),
            ('02m/chedar_0746_UV02m.sofa', '86c9a7a9cb71c2f8abe324bdffe0d999'),
            ('02m/chedar_0747_UV02m.sofa', '7a4e0256db539f2c1e6d98e9ebe0d346'),
            ('02m/chedar_0748_UV02m.sofa', '92502acdf4aeb2a91ffa6934fb393b32'),
            ('02m/chedar_0749_UV02m.sofa', '8b6f163890e3f0cbd511828327bf9e25'),
            ('02m/chedar_0750_UV02m.sofa', 'b515207827cc80b3cee2cb5214df4070'),
            ('02m/chedar_0751_UV02m.sofa', 'fa3ce06c987995f0dfe423f670330f1f'),
            ('02m/chedar_0752_UV02m.sofa', 'c4b18ba68d18cb845cb949bc21701c80'),
            ('02m/chedar_0753_UV02m.sofa', '9f6071b8b1f865a6cdbd56613f18da8e'),
            ('02m/chedar_0754_UV02m.sofa', 'd9824b10bb2fcdc79845befe8524ba05'),
            ('02m/chedar_0755_UV02m.sofa', 'e6e55d1ff9317642cf0701d2386056ea'),
            ('02m/chedar_0756_UV02m.sofa', '0a0fbab22c3747bac89c16526ccd3e05'),
            ('02m/chedar_0757_UV02m.sofa', '356109e59f4a5e3ab9fddd6740679e1b'),
            ('02m/chedar_0758_UV02m.sofa', '08abbf1c0084ffa0d8602b55d6feca8b'),
            ('02m/chedar_0759_UV02m.sofa', '1d1e2f5066029cd843dea78bf8cfad1e'),
            ('02m/chedar_0760_UV02m.sofa', '31e44c103b9668bfdf62f20623ab4767'),
            ('02m/chedar_0761_UV02m.sofa', '4c3a39f4d340717567179f6a62aadaa6'),
            ('02m/chedar_0762_UV02m.sofa', '33dd3a9e209f8a7a59ddbd3662641f48'),
            ('02m/chedar_0763_UV02m.sofa', 'c1be0ee372b050ab14e19770782fccd0'),
            ('02m/chedar_0764_UV02m.sofa', '299653198bd9f4bc916b6ba608ce6569'),
            ('02m/chedar_0765_UV02m.sofa', '43627f2aa07dfb19574987bafd38f25d'),
            ('02m/chedar_0766_UV02m.sofa', '8b2bc9131e7182dc5c50d0461880114b'),
            ('02m/chedar_0767_UV02m.sofa', 'd4083409bc57ece5e1631e83c65a1102'),
            ('02m/chedar_0768_UV02m.sofa', '0690c2d02897338a44d2b64f95972e1d'),
            ('02m/chedar_0769_UV02m.sofa', 'b491637defc4678e13fdd6a7e71ee1d8'),
            ('02m/chedar_0770_UV02m.sofa', 'e718ee854207da8807851bc26761487f'),
            ('02m/chedar_0771_UV02m.sofa', '2ab71ac3c55fef20e0b7df799be5895d'),
            ('02m/chedar_0772_UV02m.sofa', 'a3a8b347a3f1ce5ad0556ae134e06c07'),
            ('02m/chedar_0773_UV02m.sofa', '7a3fb46f3ef82b904890397f03332578'),
            ('02m/chedar_0774_UV02m.sofa', '9f5459611e5c24073415bab250b9a6ae'),
            ('02m/chedar_0775_UV02m.sofa', 'e475946131b0ed1a9bb7ae1b651808d0'),
            ('02m/chedar_0776_UV02m.sofa', '714dccc9a4f083d4b98828e5305c854a'),
            ('02m/chedar_0777_UV02m.sofa', '1c6d5147e21c79d35cb4489709757096'),
            ('02m/chedar_0778_UV02m.sofa', 'e830281d98545d6035ea222a36d74677'),
            ('02m/chedar_0779_UV02m.sofa', 'b58be2d6e76a4ef96f43e879677e9208'),
            ('02m/chedar_0780_UV02m.sofa', '5a7fc43d103cd96b61c0eafdb8a75fc3'),
            ('02m/chedar_0781_UV02m.sofa', 'edac74cca963169fb0250f9e0c985dbe'),
            ('02m/chedar_0782_UV02m.sofa', '1a4649d8b7ec8c591789fe75765658b6'),
            ('02m/chedar_0783_UV02m.sofa', 'd759d2496a72f3c1e17996cf42b3c24c'),
            ('02m/chedar_0784_UV02m.sofa', 'bf569568cfcab5e73728cfafc2c57fc3'),
            ('02m/chedar_0785_UV02m.sofa', '0a1dc300fb227b1bad79e51f9bf44636'),
            ('02m/chedar_0786_UV02m.sofa', '60f36bfb4b6726d1fd2ab066cb77707f'),
            ('02m/chedar_0787_UV02m.sofa', 'dc55ff98a7fa6bbcc295f6f2e78b5790'),
            ('02m/chedar_0788_UV02m.sofa', 'e910c974a53613f7a436279fc8014e19'),
            ('02m/chedar_0789_UV02m.sofa', 'bd1597db628598fc8dc399ede9703eb9'),
            ('02m/chedar_0790_UV02m.sofa', '9012a0b350d09abeb1988b5bbb4f738f'),
            ('02m/chedar_0791_UV02m.sofa', 'b51dbf0c24011036fc704dd15db54c82'),
            ('02m/chedar_0792_UV02m.sofa', '3f21451312a8c74edf8be54721bbb2a1'),
            ('02m/chedar_0793_UV02m.sofa', 'ba2db0bf26aefbea18886cbe61f08ad8'),
            ('02m/chedar_0794_UV02m.sofa', '4bac8a46a02ab952ff0fca22f867fac5'),
            ('02m/chedar_0795_UV02m.sofa', 'cfefeaca45bb4ec0bb27ff3b0edeb7c4'),
            ('02m/chedar_0796_UV02m.sofa', '4dff39359166175874059f51998655bb'),
            ('02m/chedar_0797_UV02m.sofa', 'f4f43975fbf45bb9d9d3fe3084457104'),
            ('02m/chedar_0798_UV02m.sofa', '61e0450d44e479c46fb15025d39cc5be'),
            ('02m/chedar_0799_UV02m.sofa', '3fe7ebab606faf7e95a5b79965e2ff39'),
            ('02m/chedar_0800_UV02m.sofa', '0ffc37068158c059fa9bcd292acfa410'),
            ('02m/chedar_0801_UV02m.sofa', '3e2ac2b666a3ccdecb1a696ba42df837'),
            ('02m/chedar_0802_UV02m.sofa', '99a77a68b90909cc9dac9899428101ee'),
            ('02m/chedar_0803_UV02m.sofa', 'f656de3d0e08f332a90c447b533c8529'),
            ('02m/chedar_0804_UV02m.sofa', '81ad73fdff1dbbb2b4dc1b7116772153'),
            ('02m/chedar_0805_UV02m.sofa', 'a3d6d34aecd0a65e29e34ed225be84fe'),
            ('02m/chedar_0806_UV02m.sofa', '640bdb4c8b21644676278c9c36e04a3c'),
            ('02m/chedar_0807_UV02m.sofa', 'c3d0954b3003369216b29c0093cf488c'),
            ('02m/chedar_0808_UV02m.sofa', '760264161ee0bef83795660b728cbce6'),
            ('02m/chedar_0809_UV02m.sofa', '787a222db2736ecffcdd387658eed5b1'),
            ('02m/chedar_0810_UV02m.sofa', 'd9dfeb5415af227bab33e6968cc3d16d'),
            ('02m/chedar_0811_UV02m.sofa', 'd75ed83e3ceae50d509b5194ea959500'),
            ('02m/chedar_0812_UV02m.sofa', 'd4066bbf36230e52c4ccfb20fa61edac'),
            ('02m/chedar_0813_UV02m.sofa', 'c39bf5e584e7da817eea544698a516e3'),
            ('02m/chedar_0814_UV02m.sofa', '7d3cf4dfa62cb955cafbfb4a657aca84'),
            ('02m/chedar_0815_UV02m.sofa', 'f0a358a433ca2ec5e6ce9b9b00a89b1c'),
            ('02m/chedar_0816_UV02m.sofa', 'fb32ab05c0eb3134ec17cafe4a8e0057'),
            ('02m/chedar_0817_UV02m.sofa', 'ed0a212a4e89290fb01bf953d63ec294'),
            ('02m/chedar_0818_UV02m.sofa', '58dcc27a1ad8fd4a7bc7d6258228cff5'),
            ('02m/chedar_0819_UV02m.sofa', '0868f93bc17c27dbe29ad5ec9352fb73'),
            ('02m/chedar_0820_UV02m.sofa', 'e8a684cb0f91125318261942b87726c0'),
            ('02m/chedar_0821_UV02m.sofa', '0651ffb1d36182ec98c3cf2fe6ca9e5d'),
            ('02m/chedar_0822_UV02m.sofa', '9daac0b9ab1e63d697e3d039503569dc'),
            ('02m/chedar_0823_UV02m.sofa', 'b63c2455b2a34b6fb651f36ea2e20845'),
            ('02m/chedar_0824_UV02m.sofa', '075a9ff2628e74ccb74fbeeeb73b433c'),
            ('02m/chedar_0825_UV02m.sofa', '9f9a071f5d8891a16c3f86da021ac074'),
            ('02m/chedar_0826_UV02m.sofa', '87ea326b55af3952af7d027607c4c5dd'),
            ('02m/chedar_0827_UV02m.sofa', 'ba285f8fc5318f419cdf29fc83fcf6d1'),
            ('02m/chedar_0828_UV02m.sofa', '8704a07cc4b1a5fbc4743fb0a7bde6a8'),
            ('02m/chedar_0829_UV02m.sofa', 'bb2b72646699ea362e4d83e046d373b6'),
            ('02m/chedar_0830_UV02m.sofa', '239b5f733ad70660d6add61556164799'),
            ('02m/chedar_0831_UV02m.sofa', 'aaa4ea5614f0ece90f35906687a5166f'),
            ('02m/chedar_0832_UV02m.sofa', '00f6b4407854cf0b2e9d212321f82ace'),
            ('02m/chedar_0833_UV02m.sofa', '50982fc10b04e53d8b9f6594f19d1915'),
            ('02m/chedar_0834_UV02m.sofa', 'ae32f6694378fb4ef6a7f25526b84344'),
            ('02m/chedar_0835_UV02m.sofa', 'bcc8972a4f6effc2da8f35d2453231de'),
            ('02m/chedar_0836_UV02m.sofa', '9fc442f7f957392388ccc3355af826de'),
            ('02m/chedar_0837_UV02m.sofa', '27c03a016e51467b2c30a24bb5bf7994'),
            ('02m/chedar_0838_UV02m.sofa', 'c047c9eddfd0afeafca5a1aa230ff2c7'),
            ('02m/chedar_0839_UV02m.sofa', '98370c215300ef0595056c4bc4436364'),
            ('02m/chedar_0840_UV02m.sofa', '018d76b60abb96f7ceb95330015439ac'),
            ('02m/chedar_0841_UV02m.sofa', '55e25b822db0aceeeba001ac0c623aa8'),
            ('02m/chedar_0842_UV02m.sofa', '019cdc78a8b9cac59caca0dd251b632f'),
            ('02m/chedar_0843_UV02m.sofa', '2847e5185348c4145b87ad4506d96c2f'),
            ('02m/chedar_0844_UV02m.sofa', '274d23c64303244c16be7e31069e92fc'),
            ('02m/chedar_0845_UV02m.sofa', '3e55d52d5251482220d5e78b1d4e8011'),
            ('02m/chedar_0846_UV02m.sofa', '8ea45feadd5ef9c946204ab2e8e1e94b'),
            ('02m/chedar_0847_UV02m.sofa', '5f9f2b7c0e33e72bd4d06ca7c88519a0'),
            ('02m/chedar_0848_UV02m.sofa', 'd802e8e86f6b66342a3698be36fae4db'),
            ('02m/chedar_0849_UV02m.sofa', '5512f4f93c52f358c523fc9e82804eb5'),
            ('02m/chedar_0850_UV02m.sofa', '1dfa5ac3eef0da28c65a4bd0ce47e3b3'),
            ('02m/chedar_0851_UV02m.sofa', '9879c0d9ed810e41ecb67b3bae3dc069'),
            ('02m/chedar_0852_UV02m.sofa', '48dd25b99b912a9340562eef9a3a9d0a'),
            ('02m/chedar_0853_UV02m.sofa', '0361614e5120335c3dd4f0a86be5f036'),
            ('02m/chedar_0854_UV02m.sofa', '5b2aa79d64c663e17757637733901347'),
            ('02m/chedar_0855_UV02m.sofa', '9c5788baf4171eb025fb8b2af7495342'),
            ('02m/chedar_0856_UV02m.sofa', '712841c1cbe0242c8b75fe75e8a611fd'),
            ('02m/chedar_0857_UV02m.sofa', 'e2fc74a202421c391f2bb8133c5894f1'),
            ('02m/chedar_0858_UV02m.sofa', '358d4982b10bbe3d4cf548762784fc13'),
            ('02m/chedar_0859_UV02m.sofa', '58a4b9df6dc3239a15d1fd187edd9ab1'),
            ('02m/chedar_0860_UV02m.sofa', '024baffb4523778c5077bfbd255d4dc7'),
            ('02m/chedar_0861_UV02m.sofa', '860ff4e26a3bdeba01b93dd372b55630'),
            ('02m/chedar_0862_UV02m.sofa', '76509212c823d947e4b622bda1310eb3'),
            ('02m/chedar_0863_UV02m.sofa', 'e7941169cabc2ce2b12487b1b8b2e2f2'),
            ('02m/chedar_0864_UV02m.sofa', 'f4ed96971ead11396b58c1e5a4a0c535'),
            ('02m/chedar_0865_UV02m.sofa', 'abdc33afe6e3ce9f5af3aabeef95fec9'),
            ('02m/chedar_0866_UV02m.sofa', 'c5ad90ec105b32e4a1da32158e273c37'),
            ('02m/chedar_0867_UV02m.sofa', '644b27d940abaf27cffe477896aa3471'),
            ('02m/chedar_0868_UV02m.sofa', 'c5213a0bead0ac1af7673d999e1b7ba9'),
            ('02m/chedar_0869_UV02m.sofa', '307559d62ec2efabd9704c4eff42624e'),
            ('02m/chedar_0870_UV02m.sofa', 'a7ae8ebdcd6c0c774910b2d4619909b1'),
            ('02m/chedar_0871_UV02m.sofa', '8b582130faa3f4f4743ccb1a4a7ee37d'),
            ('02m/chedar_0872_UV02m.sofa', '96b14663044fb863d886692b6e2ce923'),
            ('02m/chedar_0873_UV02m.sofa', 'f5afc49a4931b24378205a55f9b6118c'),
            ('02m/chedar_0874_UV02m.sofa', 'ef1805e9e2ab9c857c07825277f65290'),
            ('02m/chedar_0875_UV02m.sofa', '1535dd4a8a74274e101d51ede992502f'),
            ('02m/chedar_0876_UV02m.sofa', '5564a3b60808e90d4485d7bc3b7e38ab'),
            ('02m/chedar_0877_UV02m.sofa', '3a845fa31d6ca896c6e399d5d3f42d4c'),
            ('02m/chedar_0878_UV02m.sofa', '1feaa570f9bc1c90a5f97eadcf010b8a'),
            ('02m/chedar_0879_UV02m.sofa', '154abb11d3a2e6415ef4b70223c529c8'),
            ('02m/chedar_0880_UV02m.sofa', 'af061ef9593b0f12b0865ade5b824ac6'),
            ('02m/chedar_0881_UV02m.sofa', '020df338c8a0d9532ac1032a4d19745c'),
            ('02m/chedar_0882_UV02m.sofa', 'b0c56ab661f3f6566923b4674401ad20'),
            ('02m/chedar_0883_UV02m.sofa', 'f31093d9b08500a4c1fbbb987a5966bd'),
            ('02m/chedar_0884_UV02m.sofa', '7d810eafcebf71d202f7829072a17f2f'),
            ('02m/chedar_0885_UV02m.sofa', 'd3f7e83e41b95861e6a533ac1d8f77e7'),
            ('02m/chedar_0886_UV02m.sofa', 'bf5edd5460dc7b500bfe71697d237135'),
            ('02m/chedar_0887_UV02m.sofa', '755bc8a9319a24501e305ca8a9cf9dd4'),
            ('02m/chedar_0888_UV02m.sofa', '00a10ec377f0b6adb7a8fe8fa1969360'),
            ('02m/chedar_0889_UV02m.sofa', '419caa80b8f230fdadb838c99d6514dd'),
            ('02m/chedar_0890_UV02m.sofa', '9c3b6d9e85eb8eb699e92bb94d02d74d'),
            ('02m/chedar_0891_UV02m.sofa', '50f5a459e9a25a5a97bf30ed37663270'),
            ('02m/chedar_0892_UV02m.sofa', '37c3b8eb0cc1804004c23597e38408d6'),
            ('02m/chedar_0893_UV02m.sofa', '7909b7d87bd78c8b5b74dbfb069b45b1'),
            ('02m/chedar_0894_UV02m.sofa', 'eac36e362d6a9848a35bc7a5a5686062'),
            ('02m/chedar_0895_UV02m.sofa', 'd17f9854382865669081e59145c1951b'),
            ('02m/chedar_0896_UV02m.sofa', '92c781d5d7492855dee89ad1630a256f'),
            ('02m/chedar_0897_UV02m.sofa', '29a622a30e6e2360096664748da3c12a'),
            ('02m/chedar_0898_UV02m.sofa', '9ced34ed57bbded025495ab388cbeff1'),
            ('02m/chedar_0899_UV02m.sofa', 'ea45af5ab920edda2bd0f305b0956045'),
            ('02m/chedar_0900_UV02m.sofa', '5a4913c2ca5161cc36febf833296cf62'),
            ('02m/chedar_0901_UV02m.sofa', 'ebafb8b069407f2e8b3da067ad33c32f'),
            ('02m/chedar_0902_UV02m.sofa', '9f313e3724f9e237a65477e6bafe81ea'),
            ('02m/chedar_0903_UV02m.sofa', '7c877acf7481ebf204e7015e9675a5d1'),
            ('02m/chedar_0904_UV02m.sofa', '099cef825f34026233fb4b6c8a2c7b45'),
            ('02m/chedar_0905_UV02m.sofa', '8f95a7c3bff6ecaaff4d0a9f8493cb48'),
            ('02m/chedar_0906_UV02m.sofa', '47526839475f1f8b8fe313c7d448345d'),
            ('02m/chedar_0907_UV02m.sofa', '96e36f2d256621498ff88ff7c5dced41'),
            ('02m/chedar_0908_UV02m.sofa', 'e8c5dfafb6a83f369c58797f093dc2ba'),
            ('02m/chedar_0909_UV02m.sofa', '3ca7ee999f7059d87ae6e67927338349'),
            ('02m/chedar_0910_UV02m.sofa', 'e3412415f914ff017f46a7bf2e6b6d5e'),
            ('02m/chedar_0911_UV02m.sofa', '2730183c2d96635be03667b5d44eb3c4'),
            ('02m/chedar_0912_UV02m.sofa', '45ebb001ea81531cb0dfaebfe9b9652d'),
            ('02m/chedar_0913_UV02m.sofa', 'c27865815b4d05027b6c7506e5009909'),
            ('02m/chedar_0914_UV02m.sofa', '9f73f0c1e30e15bab0a1f0766b638ec9'),
            ('02m/chedar_0915_UV02m.sofa', '6c98a2b38bcb70b689609414a70f440c'),
            ('02m/chedar_0916_UV02m.sofa', '47ef78b6f98671c64dfb3fc77e3ac6ad'),
            ('02m/chedar_0917_UV02m.sofa', '13526130f8945842374e5b97e158dc31'),
            ('02m/chedar_0918_UV02m.sofa', 'e25969b062020c6da612833091cfdd9a'),
            ('02m/chedar_0919_UV02m.sofa', '8fa3454eb5f9f9df4dfa41ed1c94d21f'),
            ('02m/chedar_0920_UV02m.sofa', '5ee30b62f9424c001f6fcfd0023d2dfc'),
            ('02m/chedar_0921_UV02m.sofa', 'ade5d1decb818629c6e2539cd3795dfd'),
            ('02m/chedar_0922_UV02m.sofa', '251115493c24650b7cdb0220c5238927'),
            ('02m/chedar_0923_UV02m.sofa', 'b5d8a50b581f8779c5375d98d342ccf0'),
            ('02m/chedar_0924_UV02m.sofa', 'f98dd88f6c83142463b93aa70454a9ce'),
            ('02m/chedar_0925_UV02m.sofa', '902ee5774e5e355d14f7ad3943b25f1a'),
            ('02m/chedar_0926_UV02m.sofa', '21c99afda4b76d3a0d0c9b7509e6a56a'),
            ('02m/chedar_0927_UV02m.sofa', 'd7307fa67ea6861e3fe4a5125549615f'),
            ('02m/chedar_0928_UV02m.sofa', 'f8f0ab86e910c2202a25296cd89c638a'),
            ('02m/chedar_0929_UV02m.sofa', 'c90153f51b1eb5b497df4bc3c8f764f3'),
            ('02m/chedar_0930_UV02m.sofa', '3e6b956c01e9919b1097b239541c9ba9'),
            ('02m/chedar_0931_UV02m.sofa', '421e7af86217402e248f6651db954a13'),
            ('02m/chedar_0932_UV02m.sofa', 'fbb8157de9bd26df2a64aa4ffc63f893'),
            ('02m/chedar_0933_UV02m.sofa', '4d118712fc00a4dfbb5e893607a42d3c'),
            ('02m/chedar_0934_UV02m.sofa', 'da9b40ba81ed81538c7191136a66eac1'),
            ('02m/chedar_0935_UV02m.sofa', '79821cecc359492026e56088d3337794'),
            ('02m/chedar_0936_UV02m.sofa', '853274359eddb754071d7f242ae4f7e3'),
            ('02m/chedar_0937_UV02m.sofa', '44f8a66cd8844a88d2fe474d56e42374'),
            ('02m/chedar_0938_UV02m.sofa', '5ae2ffd445245ef07ce839fc12f8f0c7'),
            ('02m/chedar_0939_UV02m.sofa', '6a9c1c3a50296c486f7f4474e9a42c26'),
            ('02m/chedar_0940_UV02m.sofa', '12fa1efe7367e34e2b10e89117c1cc55'),
            ('02m/chedar_0941_UV02m.sofa', 'f01f101d935d9260a69a0109708c342e'),
            ('02m/chedar_0942_UV02m.sofa', 'e2fdc92e33215b6fb8af04984add924d'),
            ('02m/chedar_0943_UV02m.sofa', '8cefbeda20028f0440a4413dc181727e'),
            ('02m/chedar_0944_UV02m.sofa', 'ed2b4ba25708afe3b4c888748443aa5e'),
            ('02m/chedar_0945_UV02m.sofa', 'a8eb855f2c692857df67c9d7ca99bc2a'),
            ('02m/chedar_0946_UV02m.sofa', '49d9259506e9c69db95ba2b8228bce26'),
            ('02m/chedar_0947_UV02m.sofa', 'b1205c36047d713642bcaee9d15b6941'),
            ('02m/chedar_0948_UV02m.sofa', '72d59216418062ca33cc74a43740b6b2'),
            ('02m/chedar_0949_UV02m.sofa', '6f908b1ee8157dd0f5fe7287147a0c52'),
            ('02m/chedar_0950_UV02m.sofa', '3e14231bd7938cb7621fbf7d0c223427'),
            ('02m/chedar_0951_UV02m.sofa', '4ab1bd78ee4aa858bc9ee5e309d7c842'),
            ('02m/chedar_0952_UV02m.sofa', 'bd85069246ed07d02c775970914043d8'),
            ('02m/chedar_0953_UV02m.sofa', 'fb231c09dbe9c9fbe70d57b4f6d43732'),
            ('02m/chedar_0954_UV02m.sofa', '5bc1d98bde5f2276789c2b9ca5c143f4'),
            ('02m/chedar_0955_UV02m.sofa', '2b5156a06962cd8913f4f9c0caeae922'),
            ('02m/chedar_0956_UV02m.sofa', '0dc1c15cb7338cf89fc3756184cfc446'),
            ('02m/chedar_0957_UV02m.sofa', 'b04a6bbda37f1b8b05593ff0fd16615b'),
            ('02m/chedar_0958_UV02m.sofa', 'cec472559d4b9571c001b5aaf3a2c66e'),
            ('02m/chedar_0959_UV02m.sofa', '2fd4141dcbca1878ec7d60d70050b30b'),
            ('02m/chedar_0960_UV02m.sofa', '8f4e3c30dea76deba97c7fa3b2c80659'),
            ('02m/chedar_0961_UV02m.sofa', '561be10bf8e5d48a62079dcede1dd037'),
            ('02m/chedar_0962_UV02m.sofa', '6dfdc6f26689d7014cf31d53d75071bc'),
            ('02m/chedar_0963_UV02m.sofa', '89ae4846dbcaf27525eb5fff693d10b1'),
            ('02m/chedar_0964_UV02m.sofa', '3899657c01bf88ddc71124d76f4dd7e3'),
            ('02m/chedar_0965_UV02m.sofa', '583aa777eea8b97b091b5632fca932a9'),
            ('02m/chedar_0966_UV02m.sofa', 'bfcc4904d9a04a6c4eb6f9de11651f9f'),
            ('02m/chedar_0967_UV02m.sofa', '09b719bf9f6260bee9343b31669afb6e'),
            ('02m/chedar_0968_UV02m.sofa', 'e2f1213c00d3a08327d5d9e38d6fefcd'),
            ('02m/chedar_0969_UV02m.sofa', '5ba575c681b3c02c1a970599b6faa251'),
            ('02m/chedar_0970_UV02m.sofa', 'cbf917f597aba82ae68b2992415b9b57'),
            ('02m/chedar_0971_UV02m.sofa', '0d6289c1bd927982698ec9210ce7cc88'),
            ('02m/chedar_0972_UV02m.sofa', '8f455274c6d4593d750f4cb5b4daeabd'),
            ('02m/chedar_0973_UV02m.sofa', 'acbb6f620a0cdd83624ea0420af00b38'),
            ('02m/chedar_0974_UV02m.sofa', '4c161c4308842f02e300d33f9fc953b6'),
            ('02m/chedar_0975_UV02m.sofa', 'cca7997d7a743b79f98eb9ac5b545400'),
            ('02m/chedar_0976_UV02m.sofa', '74bd9581711abcd7291673a1c8cee3d5'),
            ('02m/chedar_0977_UV02m.sofa', '721a471d18b29014157aac2dc173078e'),
            ('02m/chedar_0978_UV02m.sofa', 'd3fa80b9697db21ab49062ec63e5d512'),
            ('02m/chedar_0979_UV02m.sofa', 'a66d6ab2008008aab8ef6e471020adde'),
            ('02m/chedar_0980_UV02m.sofa', 'ad4a4f3fef43a01b6845252b5fa7ecb4'),
            ('02m/chedar_0981_UV02m.sofa', 'e3cb2b38c359a263813437feec319c0b'),
            ('02m/chedar_0982_UV02m.sofa', '6f6e9d0121d70a701dff819aa6a63b97'),
            ('02m/chedar_0983_UV02m.sofa', '121fda29ff93c08cdf4ff4b61db4cb51'),
            ('02m/chedar_0984_UV02m.sofa', '827282db6efefe3de96af2de1f577581'),
            ('02m/chedar_0985_UV02m.sofa', 'f192e5353f2519d7f85384acf06f5ad0'),
            ('02m/chedar_0986_UV02m.sofa', 'dc1d127ab2f34f3e63a3aee1a0e6df43'),
            ('02m/chedar_0987_UV02m.sofa', '127ffbed37ef06852c0ca73f51edf6ac'),
            ('02m/chedar_0988_UV02m.sofa', 'e1e746707d4893839973ac932e89f42a'),
            ('02m/chedar_0989_UV02m.sofa', '6429dc5373c5647b7b17fe0ece982447'),
            ('02m/chedar_0990_UV02m.sofa', '1cc21ca2e7b65f5781545a254c130621'),
            ('02m/chedar_0991_UV02m.sofa', 'a8838c11e60265be0c154ba487c7474b'),
            ('02m/chedar_0992_UV02m.sofa', 'a406e07c2b7cd2771e42c78568937157'),
            ('02m/chedar_0993_UV02m.sofa', '188d6139840f84286eb494fb74078c48'),
            ('02m/chedar_0994_UV02m.sofa', '6a72de7708a24ec61b8f926567bfaf43'),
            ('02m/chedar_0995_UV02m.sofa', 'd5a2f30b653009c8206133a32c51187e'),
            ('02m/chedar_0996_UV02m.sofa', '28d4d12d2f47750b49ff7903af5f9f1a'),
            ('02m/chedar_0997_UV02m.sofa', '258da882ecbc7556f25a5a21fd28b836'),
            ('02m/chedar_0998_UV02m.sofa', '9f57fa30c5ad6379cc108a02ae555e64'),
            ('02m/chedar_0999_UV02m.sofa', '5295b46e4a2a5207bd59405cf8e5d421'),
            ('02m/chedar_1000_UV02m.sofa', '5919f391e53345b576539ac39e96d3f1'),
            ('02m/chedar_1001_UV02m.sofa', '0fdc6ff42d941316680e77e2a4226225'),
            ('02m/chedar_1002_UV02m.sofa', '168cfa046114adf04666853cfcb28de8'),
            ('02m/chedar_1003_UV02m.sofa', 'e4ac8d97e3566cdff5822ed46de09b2a'),
            ('02m/chedar_1004_UV02m.sofa', 'e34ca4125670706bc2b9d19fe5de4ae2'),
            ('02m/chedar_1005_UV02m.sofa', '639f136d06baefc0c5429abdac2d94cf'),
            ('02m/chedar_1006_UV02m.sofa', '9b7e8e26014de82fa34a00e6d0b5979b'),
            ('02m/chedar_1007_UV02m.sofa', '7766ec9627ba3adea2d94be3f956b780'),
            ('02m/chedar_1008_UV02m.sofa', '57c01a47962204b231a6e47b7b8b5e41'),
            ('02m/chedar_1009_UV02m.sofa', '8ef627c5f49c950314a138c4d8efd563'),
            ('02m/chedar_1010_UV02m.sofa', '10b4783849be74abe66d0183fb2c917e'),
            ('02m/chedar_1011_UV02m.sofa', 'f4da9a92fe88bced043be7febf940717'),
            ('02m/chedar_1012_UV02m.sofa', 'f9b92d1265a709e99cae5951de739e23'),
            ('02m/chedar_1013_UV02m.sofa', '226df0afeb9893617b067e641de5e654'),
            ('02m/chedar_1014_UV02m.sofa', '45c951880645a0f41383301186613652'),
            ('02m/chedar_1015_UV02m.sofa', 'e58b0097b0359b1c24ef61bbe1cb5803'),
            ('02m/chedar_1016_UV02m.sofa', 'd84e5306b522f5080e383f2bd4077586'),
            ('02m/chedar_1017_UV02m.sofa', 'c9461bf192b7c59c0f8325ee4b667eee'),
            ('02m/chedar_1018_UV02m.sofa', '5c0401fcff1945b74364174d18951e37'),
            ('02m/chedar_1019_UV02m.sofa', '3390d8e483997eccf4aec571eed5117c'),
            ('02m/chedar_1020_UV02m.sofa', '08113d8650f756663e7c8c60853bcc39'),
            ('02m/chedar_1021_UV02m.sofa', '949891da0ac0852feae47a4e6e566a17'),
            ('02m/chedar_1022_UV02m.sofa', '637caafcbedc8305125e4e699ad13c98'),
            ('02m/chedar_1023_UV02m.sofa', 'b491b15c1b19c4dc8e7450c789855396'),
            ('02m/chedar_1024_UV02m.sofa', 'c48d0be6c96ea6ed6e9c03237632fe92'),
            ('02m/chedar_1025_UV02m.sofa', '0cdf5441f07c2742e198c25929bef045'),
            ('02m/chedar_1026_UV02m.sofa', 'cd7cd122ea7939ad1eb59e8fe0290e56'),
            ('02m/chedar_1027_UV02m.sofa', '3bd0eba1db1693f2960cb4de44b1f124'),
            ('02m/chedar_1028_UV02m.sofa', 'd51145d7b7f11e810ef2c998a57b949c'),
            ('02m/chedar_1029_UV02m.sofa', '590d91fa8e5797318eb165e9158e670d'),
            ('02m/chedar_1030_UV02m.sofa', 'a31d0237126df723e3efaa226caa13b8'),
            ('02m/chedar_1031_UV02m.sofa', '721ba3f96a9f4feb0c4fd5a15b9bc001'),
            ('02m/chedar_1032_UV02m.sofa', '2326299137ad81d5e845bccfbadf022f'),
            ('02m/chedar_1033_UV02m.sofa', '7cc64f7ec0eb6146bec8ed97c71dc5ed'),
            ('02m/chedar_1034_UV02m.sofa', '90a72d2c6d02870d196ffb7b359f7708'),
            ('02m/chedar_1035_UV02m.sofa', 'e59414fdfe6919de467734a435b6b49a'),
            ('02m/chedar_1036_UV02m.sofa', 'e4d4027657034292481d8eeb847a9eb9'),
            ('02m/chedar_1037_UV02m.sofa', '5f8a3de26defa2d2f5c00b8ef91bfc51'),
            ('02m/chedar_1038_UV02m.sofa', '066a0fe7ff5218e62eaa64c7f07b4b3f'),
            ('02m/chedar_1039_UV02m.sofa', '7ed360e0968f9054e3954ebcee511d44'),
            ('02m/chedar_1040_UV02m.sofa', 'dc92eb8b00de9311348969f8b11fd678'),
            ('02m/chedar_1041_UV02m.sofa', '4ef5726921b207b0e2673a0390317db4'),
            ('02m/chedar_1042_UV02m.sofa', 'c731ad2d0146e4eb9a71e736400843e3'),
            ('02m/chedar_1043_UV02m.sofa', '86f9e3cd88a6103422201b9a5faa37c4'),
            ('02m/chedar_1044_UV02m.sofa', 'd67f7c543fd5bc4889858b0503401b17'),
            ('02m/chedar_1045_UV02m.sofa', '3697562c41794b47ef35a64a4e8922fd'),
            ('02m/chedar_1046_UV02m.sofa', 'a79d601f217d8c1ae753f36c4b17b43e'),
            ('02m/chedar_1047_UV02m.sofa', 'ccd603c9dcf0264feb557ac1f826b9b2'),
            ('02m/chedar_1048_UV02m.sofa', '17ac95a249ff9744719d7fe3816d2c2f'),
            ('02m/chedar_1049_UV02m.sofa', '45a06fce956c9b3fb0e17d178dc6abf3'),
            ('02m/chedar_1050_UV02m.sofa', '2c70cb5ecac10370c92aa82d5df62fc8'),
            ('02m/chedar_1051_UV02m.sofa', 'e7ecbdf976a12422fce6f76c9706fde5'),
            ('02m/chedar_1052_UV02m.sofa', '080f2b371dedb723c31bee95f89f66ea'),
            ('02m/chedar_1053_UV02m.sofa', '878f75a09c5b83e25485ad42eeb570e1'),
            ('02m/chedar_1054_UV02m.sofa', 'fa2697b5b8b63368cee7b0d93b8c3b42'),
            ('02m/chedar_1055_UV02m.sofa', '74ed7c05f2d9b20213e9dea143c782a1'),
            ('02m/chedar_1056_UV02m.sofa', '677f5a98bc274e6905a9a80159f14de5'),
            ('02m/chedar_1057_UV02m.sofa', 'd0e6109fe302a94a19bec5fad135c2e1'),
            ('02m/chedar_1058_UV02m.sofa', 'c773126036c9a111d3e33061e39ad69e'),
            ('02m/chedar_1059_UV02m.sofa', '672bba4b06f135eaa22c87f9480974a4'),
            ('02m/chedar_1060_UV02m.sofa', '8d0e7e1834e91f56c10118e88bec9136'),
            ('02m/chedar_1061_UV02m.sofa', '96a5c3620c7da5d6cfabe3663622f721'),
            ('02m/chedar_1062_UV02m.sofa', '827c09f896020ab33a9ef1335b9aadef'),
            ('02m/chedar_1063_UV02m.sofa', 'b7251acbd006cc8d7ba5c5001bdd825a'),
            ('02m/chedar_1064_UV02m.sofa', '543ded8e27cdab2631ecc64f09b30623'),
            ('02m/chedar_1065_UV02m.sofa', '019acd435c908517cb5d9e79577ee3bf'),
            ('02m/chedar_1066_UV02m.sofa', '07a3e0bd0c0182e7ecc0aed43ccd6e12'),
            ('02m/chedar_1067_UV02m.sofa', '0b613586d20f53c1870110fae84c93f2'),
            ('02m/chedar_1068_UV02m.sofa', 'ee18eb4e00d85a531af64f635cfbed64'),
            ('02m/chedar_1069_UV02m.sofa', 'c0811f14c921991375f160d4ccfc1bee'),
            ('02m/chedar_1070_UV02m.sofa', 'e6ef08b661a1afef46d90e3f49be42d7'),
            ('02m/chedar_1071_UV02m.sofa', 'cb565e04929f731592b0efdfd8fe4db5'),
            ('02m/chedar_1072_UV02m.sofa', '081a38c389b17e2fbfc8c0b8fce5ac94'),
            ('02m/chedar_1073_UV02m.sofa', 'f83c8f082f60082832e38abb8ca6e869'),
            ('02m/chedar_1074_UV02m.sofa', 'd56af8ea95432c1539b7df16b2d4df15'),
            ('02m/chedar_1075_UV02m.sofa', '088f226b3ca4749921be489bae57639e'),
            ('02m/chedar_1076_UV02m.sofa', '72c4f4bceed341b6cda0e298753c85be'),
            ('02m/chedar_1077_UV02m.sofa', '87ad197307e7349c2bee1922bd1befbf'),
            ('02m/chedar_1078_UV02m.sofa', 'bb5ef765189e5293b9b80176250ad792'),
            ('02m/chedar_1079_UV02m.sofa', '5f5c1add766cf6dfb3f9b33b23abfa7d'),
            ('02m/chedar_1080_UV02m.sofa', 'b04e96102c6a0081c1c6e213be411793'),
            ('02m/chedar_1081_UV02m.sofa', '92596d1abd8d1678f29043bf8b7ead34'),
            ('02m/chedar_1082_UV02m.sofa', '0ddf17cf46d2f0e83aed541aaf2f2f1f'),
            ('02m/chedar_1083_UV02m.sofa', 'd234412c543ca00ad316de07f24340af'),
            ('02m/chedar_1084_UV02m.sofa', '5c615f30fd96912c05b7ea5b5515958a'),
            ('02m/chedar_1085_UV02m.sofa', '53ab4920ca535ae1288c76e5a41e0d0f'),
            ('02m/chedar_1086_UV02m.sofa', '65b8b4426266170cd1795ffef6606aca'),
            ('02m/chedar_1087_UV02m.sofa', 'e5768ec96c6b91126b252bcf4c801233'),
            ('02m/chedar_1088_UV02m.sofa', '9db7ce3f52cb9436de448724ef2483ed'),
            ('02m/chedar_1089_UV02m.sofa', 'effaa694c3eb2d22cc1d3fa7dc216826'),
            ('02m/chedar_1090_UV02m.sofa', '38c6c0c2d12338aab1131661b7274d1d'),
            ('02m/chedar_1091_UV02m.sofa', '1362bbd7f67717eb5d09a04ee8276304'),
            ('02m/chedar_1092_UV02m.sofa', '8474c9e5d66e6f88e0c780ebd4fb8b73'),
            ('02m/chedar_1093_UV02m.sofa', '45a692d4a3675d4441c8e6820b7632f9'),
            ('02m/chedar_1094_UV02m.sofa', 'd150834f9103fd5e52fbf259b8c15b47'),
            ('02m/chedar_1095_UV02m.sofa', '251e598b089140da0851726d013fd991'),
            ('02m/chedar_1096_UV02m.sofa', 'befc668502e822fe26e6162d3b1ad966'),
            ('02m/chedar_1097_UV02m.sofa', 'd43dbabdef83b6f5d68868d1391cc65b'),
            ('02m/chedar_1098_UV02m.sofa', '8ffc244db93844a7668c9b4ca1e9f508'),
            ('02m/chedar_1099_UV02m.sofa', '642d37234eda8e961936f4292db00d27'),
            ('02m/chedar_1100_UV02m.sofa', '37475ffb43a1c48fea5f736f57415aa8'),
            ('02m/chedar_1101_UV02m.sofa', 'ff2e59a269968a1c6fae807cf6225a08'),
            ('02m/chedar_1102_UV02m.sofa', 'ff4f92e15701e63e49b859b01e3910ab'),
            ('02m/chedar_1103_UV02m.sofa', 'f120d890a87e68b2c0568544ff5f52aa'),
            ('02m/chedar_1104_UV02m.sofa', '1c304dd85feb442e4473781928fe6472'),
            ('02m/chedar_1105_UV02m.sofa', 'b95f9fa3770b01d0a0c5a839f8547391'),
            ('02m/chedar_1106_UV02m.sofa', 'ee4d00869bcb6e1e540344f2fedff401'),
            ('02m/chedar_1107_UV02m.sofa', 'a4b31b73dfd3a3496e29327f656c6110'),
            ('02m/chedar_1108_UV02m.sofa', 'f15ff3f867f75d3be1d21dcb193e0e94'),
            ('02m/chedar_1109_UV02m.sofa', '644d636e39f4123b6731459d7e10f30a'),
            ('02m/chedar_1110_UV02m.sofa', '19efd73b119556cb477af9f762915820'),
            ('02m/chedar_1111_UV02m.sofa', 'ddc8a916db915cb96d5556a58fc078d1'),
            ('02m/chedar_1112_UV02m.sofa', '22747e7e6226321f8d8af9858aa18b0e'),
            ('02m/chedar_1113_UV02m.sofa', '598b0403f8016c59d863c6a3e69fdf2f'),
            ('02m/chedar_1114_UV02m.sofa', '04cb1c7031774e62e4e92507c8ce012a'),
            ('02m/chedar_1115_UV02m.sofa', 'b7c1f5cf0ef2a76bbf26f32937296081'),
            ('02m/chedar_1116_UV02m.sofa', 'b1a6e6f35604f392a8e044a17abfe911'),
            ('02m/chedar_1117_UV02m.sofa', '8d06ac8a0a6a65b3770a9fbc4ced1c1f'),
            ('02m/chedar_1118_UV02m.sofa', 'a9e9320c0279beb01b500b1b73ac1134'),
            ('02m/chedar_1119_UV02m.sofa', 'c437195d19f3a91f6a6eb64a12412abc'),
            ('02m/chedar_1120_UV02m.sofa', 'cabaeed4e3935ca1cfb491bf9d098acc'),
            ('02m/chedar_1121_UV02m.sofa', 'eeb4ffeed32832a3d65ec481c23ee696'),
            ('02m/chedar_1122_UV02m.sofa', '3d614cba305b54cc3611a14af3a191b9'),
            ('02m/chedar_1123_UV02m.sofa', 'b94e1207e2aa8423e1cc9e7b68ae5dc2'),
            ('02m/chedar_1124_UV02m.sofa', '4fecdda4c3d7ea733da8ffffc365b9da'),
            ('02m/chedar_1125_UV02m.sofa', 'b4437a37ff6eb6259e6337a5ef744826'),
            ('02m/chedar_1126_UV02m.sofa', 'a26f1a187a48eaf9ba80d55569d01f7d'),
            ('02m/chedar_1127_UV02m.sofa', 'f8d83c26bc11d474ce75e6cd5833bdf6'),
            ('02m/chedar_1128_UV02m.sofa', '899332a463ede9b32661de307a24296f'),
            ('02m/chedar_1129_UV02m.sofa', '48f7cf18662989f3d7dcafa7cc7adf0b'),
            ('02m/chedar_1130_UV02m.sofa', '7ac8fe0c30e9ff7de04d99c1834e1a09'),
            ('02m/chedar_1131_UV02m.sofa', 'e29c9af3df6d2a3d20306de108bff7cd'),
            ('02m/chedar_1132_UV02m.sofa', '33c3660855be16f1be63c25f77ff5c2f'),
            ('02m/chedar_1133_UV02m.sofa', '6bf70318029332c3255468ed530bfdda'),
            ('02m/chedar_1134_UV02m.sofa', '9013b7263e14a47080f8db0aabc0a403'),
            ('02m/chedar_1135_UV02m.sofa', 'd0bcd9b99cc495c7785ae8dd30ddd4b2'),
            ('02m/chedar_1136_UV02m.sofa', 'b2266a791b969ae2d4c3d942bbcda972'),
            ('02m/chedar_1137_UV02m.sofa', '92699f52ea632439a2323eca959aed34'),
            ('02m/chedar_1138_UV02m.sofa', 'd008b8c68bdddbb3d9ec9066ac2af58d'),
            ('02m/chedar_1139_UV02m.sofa', '2e30a736b93497e77045518d8f88dd0d'),
            ('02m/chedar_1140_UV02m.sofa', '0cdccc18d1422d8a88a6004e4718b0b9'),
            ('02m/chedar_1141_UV02m.sofa', '54ae4b19e2a47395617a139d310a0d57'),
            ('02m/chedar_1142_UV02m.sofa', 'f428a67c7d274d23173a6db8df832733'),
            ('02m/chedar_1143_UV02m.sofa', '7cce3578c9c13b8e91d29702b2087cb4'),
            ('02m/chedar_1144_UV02m.sofa', '58c1c2f71299c4f2a02c0c306371d9f8'),
            ('02m/chedar_1145_UV02m.sofa', '8ce23b1cba195877d1cb2a723825037d'),
            ('02m/chedar_1146_UV02m.sofa', 'f9d652a2b73d1f1f406c8ad0a5b3f9ea'),
            ('02m/chedar_1147_UV02m.sofa', '20dea94e21238681f75463090046ccb0'),
            ('02m/chedar_1148_UV02m.sofa', '12b090198bcb3c7ceea377089f4839ea'),
            ('02m/chedar_1149_UV02m.sofa', 'f90c99a90e6473a4fd9be47a5367277f'),
            ('02m/chedar_1150_UV02m.sofa', 'd46af0b72918c41d13a924d3b8897a66'),
            ('02m/chedar_1151_UV02m.sofa', '8c419775e83baf37ee60c913ce9ea925'),
            ('02m/chedar_1152_UV02m.sofa', '66988cf69aa7bc033cadcc4563b40bff'),
            ('02m/chedar_1153_UV02m.sofa', '1f6bbba8ae23d9e6984e99ea786e7b45'),
            ('02m/chedar_1154_UV02m.sofa', '6ec4bf5aecf9c499d476a45f21372b57'),
            ('02m/chedar_1155_UV02m.sofa', '8fa4e49c6701ec0a6686ddfa26c25c65'),
            ('02m/chedar_1156_UV02m.sofa', '560786e9ac3d2eb7c10c03363f1840d5'),
            ('02m/chedar_1157_UV02m.sofa', '1a3eb53e55e2e925294d03723b9c0290'),
            ('02m/chedar_1158_UV02m.sofa', 'aaab3d6960b68ff166547276c19c87ec'),
            ('02m/chedar_1159_UV02m.sofa', 'e5c8f147204b41974b587e3fd14d9f62'),
            ('02m/chedar_1160_UV02m.sofa', '46faaa4bb652b59318e31ec6214aa2c4'),
            ('02m/chedar_1161_UV02m.sofa', '24d9193dd1b2adcc793109ac82309548'),
            ('02m/chedar_1162_UV02m.sofa', '45881367399d63f3e0e8d56ea7562b80'),
            ('02m/chedar_1163_UV02m.sofa', '97f7738a8877130609ae9984ca4308de'),
            ('02m/chedar_1164_UV02m.sofa', '1716bfa64a782cb13b12b2d340daadc8'),
            ('02m/chedar_1165_UV02m.sofa', '78c521087d17791f2b2d8720c8e13b5a'),
            ('02m/chedar_1166_UV02m.sofa', 'd4d587399ee4c003502aa5afacfe4c24'),
            ('02m/chedar_1167_UV02m.sofa', 'd1a0df583949441775cb57c16183d12e'),
            ('02m/chedar_1168_UV02m.sofa', 'c2877c5e838e002bc13dc0a25d5e022b'),
            ('02m/chedar_1169_UV02m.sofa', '41aa5a2a7d8d139e97880e55f00419f7'),
            ('02m/chedar_1170_UV02m.sofa', '1eb527362d0c800d089a5d077155500a'),
            ('02m/chedar_1171_UV02m.sofa', '34d0c3738eb86c5ef3fbd069ffd14c91'),
            ('02m/chedar_1172_UV02m.sofa', '0b4c0df07ee7bd326cac5e485461bad8'),
            ('02m/chedar_1173_UV02m.sofa', '85a8515ce2edd0ad13e8722dbbb70a0b'),
            ('02m/chedar_1174_UV02m.sofa', '5863f9cade32f1dd31f687ed7b03603e'),
            ('02m/chedar_1175_UV02m.sofa', '135ae0b313073ca2484a075be965fc0b'),
            ('02m/chedar_1176_UV02m.sofa', '5b6c6e2bc8c3249e3b7afdbef95ef3cf'),
            ('02m/chedar_1177_UV02m.sofa', '8d02e8fc1ed41b9ddf556d6a22ef7fca'),
            ('02m/chedar_1178_UV02m.sofa', 'a57cf30872ab6cf1062c71e30f56c1d9'),
            ('02m/chedar_1179_UV02m.sofa', 'fa3b471cf94cb40ef1da19d87d6feb85'),
            ('02m/chedar_1180_UV02m.sofa', '4ae280791ebb388e9817b247e9ae50f9'),
            ('02m/chedar_1181_UV02m.sofa', '932df24fab39aeffa1fee29744418407'),
            ('02m/chedar_1182_UV02m.sofa', 'e20ee76edf6d289c1599e750433e8db0'),
            ('02m/chedar_1183_UV02m.sofa', '4f1ccbb7f592c75c40267a8993fabd48'),
            ('02m/chedar_1184_UV02m.sofa', 'ee5d42c38cbc23403e14401a5a73d6fb'),
            ('02m/chedar_1185_UV02m.sofa', '07eeb26c4ca1b032553c2bdfd59eb593'),
            ('02m/chedar_1186_UV02m.sofa', 'd6457e92b7bef51ca696941885c1b1a2'),
            ('02m/chedar_1187_UV02m.sofa', '36bf39e7ced01c7b8662d71b63555224'),
            ('02m/chedar_1188_UV02m.sofa', '675af0e6c9daaaecd8b6ad6d760ff599'),
            ('02m/chedar_1189_UV02m.sofa', '4f55a674eb8b8da3eae62984df94ef2a'),
            ('02m/chedar_1190_UV02m.sofa', '9140b93843acfcda5d892a090ff756f9'),
            ('02m/chedar_1191_UV02m.sofa', 'b1ce3ee86a2f168a831a92bb2357cb77'),
            ('02m/chedar_1192_UV02m.sofa', '1ecbd5735fe8609d4f588d0d53af1b9d'),
            ('02m/chedar_1193_UV02m.sofa', '29e6116c833065fab7c1795ab158861c'),
            ('02m/chedar_1194_UV02m.sofa', '71f7863fd4e437d180b997e22cc15fe3'),
            ('02m/chedar_1195_UV02m.sofa', '487c1d434b696edea5051bb928aaf419'),
            ('02m/chedar_1196_UV02m.sofa', '929b89065d9846bef1865e6318b9f183'),
            ('02m/chedar_1197_UV02m.sofa', '9047483610f6b3c303791a30bb7f871a'),
            ('02m/chedar_1198_UV02m.sofa', 'ee8be75b6c357448304a4b9494f0046a'),
            ('02m/chedar_1199_UV02m.sofa', 'b863af5817331b013f049263e157bbff'),
            ('02m/chedar_1200_UV02m.sofa', '02dd776a97c81a7b213926b712ac49f4'),
            ('02m/chedar_1201_UV02m.sofa', '0fbb059b9d79b92068a019d74e124f4f'),
            ('02m/chedar_1202_UV02m.sofa', 'e6a71bff2c3b08f91d89bbf25cde6a19'),
            ('02m/chedar_1203_UV02m.sofa', 'e67be018eb751c735d85d32c12a4913a'),
            ('02m/chedar_1204_UV02m.sofa', 'b1fa7549cfbc5c3efadeddf70ef85d34'),
            ('02m/chedar_1205_UV02m.sofa', '868cf4e1c4921f828084130bc7ab5556'),
            ('02m/chedar_1206_UV02m.sofa', '68ea86a9fa6e6fc97137e059195a9d25'),
            ('02m/chedar_1207_UV02m.sofa', '2915afaa755dccd071cb29223eff9cb8'),
            ('02m/chedar_1208_UV02m.sofa', 'b4421bd7efd37e5983e0458895743fa9'),
            ('02m/chedar_1209_UV02m.sofa', 'd79815b3ae991c82d1980feca4396170'),
            ('02m/chedar_1210_UV02m.sofa', '2cae3c571a158fe6afc2720d69f6d3eb'),
            ('02m/chedar_1211_UV02m.sofa', 'a6305cd3fbe8d79a679973a1d56e2368'),
            ('02m/chedar_1212_UV02m.sofa', '58ffee62a8df9a6c165efd7f552dad30'),
            ('02m/chedar_1213_UV02m.sofa', '40bc9316633774c6fe26cd680cdd4407'),
            ('02m/chedar_1214_UV02m.sofa', 'b089e75c3b1f499a16bd81e45de847fc'),
            ('02m/chedar_1215_UV02m.sofa', 'd62228c894be572f23a1392a90c6135a'),
            ('02m/chedar_1216_UV02m.sofa', '55fdd17cedf2fdd9ce6762bc32bd5708'),
            ('02m/chedar_1217_UV02m.sofa', '68a481ef8d9977957f094e32088f510a'),
            ('02m/chedar_1218_UV02m.sofa', 'e77488fccee7a364a4bb30a7fef9c048'),
            ('02m/chedar_1219_UV02m.sofa', '8dfa4198f291317223b7820ead303473'),
            ('02m/chedar_1220_UV02m.sofa', '08b53d6707486f1b5f6c26249e7c8ce9'),
            ('02m/chedar_1221_UV02m.sofa', '49371bc416cc24a420e7d768bdbfeb40'),
            ('02m/chedar_1222_UV02m.sofa', 'e6dd0672a7ae585a2442bd5802b7262f'),
            ('02m/chedar_1223_UV02m.sofa', 'b156871de7ff919dad9e9966f72921e6'),
            ('02m/chedar_1224_UV02m.sofa', '83b44b1164817d0dd716aeeab2bb6dab'),
            ('02m/chedar_1225_UV02m.sofa', '34c4760d85ea7cdf253961de0c4a486f'),
            ('02m/chedar_1226_UV02m.sofa', '8d1d9d851e664e0e304503bf649faca8'),
            ('02m/chedar_1227_UV02m.sofa', 'b4e4eb16e7ae85f08212001c4c69e3bf'),
            ('02m/chedar_1228_UV02m.sofa', 'e704fe18e3e2b66e0ff3054dfd3bf73b'),
            ('02m/chedar_1229_UV02m.sofa', '1f76f55dcb338d5903e66c2d9495e78d'),
            ('02m/chedar_1230_UV02m.sofa', 'f60b36ae5fb256a14b08d1509a99db0f'),
            ('02m/chedar_1231_UV02m.sofa', '777b0c2f037f4f73bb148732b2a0ce4a'),
            ('02m/chedar_1232_UV02m.sofa', '3e26e276e9f4fd059666325a7a663d68'),
            ('02m/chedar_1233_UV02m.sofa', '7f7caabbf6cb3f3d69110002278ffa10'),
            ('02m/chedar_1234_UV02m.sofa', '7c4c8330cddb13adce55b442a107a5cc'),
            ('02m/chedar_1235_UV02m.sofa', 'eea63bc46d24e45f1e0d2d01ba6f3f6a'),
            ('02m/chedar_1236_UV02m.sofa', '32c6cc5fe24cc6912283d29f7343eb95'),
            ('02m/chedar_1237_UV02m.sofa', '3ab001af1481c3d0daf923c1fd3ae51e'),
            ('02m/chedar_1238_UV02m.sofa', '9b2cb90193287fa0e801d47367070a3f'),
            ('02m/chedar_1239_UV02m.sofa', '2301568a53a71a7014d8029ca6f872ec'),
            ('02m/chedar_1240_UV02m.sofa', '829808e0bb6089ec3124596594e21c5b'),
            ('02m/chedar_1241_UV02m.sofa', 'cafef5d40b38f27db37d584daff73a73'),
            ('02m/chedar_1242_UV02m.sofa', '648f3f5ec19f9603e0b304aea0bd3ba1'),
            ('02m/chedar_1243_UV02m.sofa', '3b3cf36ac548959d60bf1898b2710567'),
            ('02m/chedar_1244_UV02m.sofa', '2b827f7e684a5227589ff856f063af7a'),
            ('02m/chedar_1245_UV02m.sofa', 'f33bf8fd134ef5c217d4aca9173bb443'),
            ('02m/chedar_1246_UV02m.sofa', 'df90317cfcc42601b9ba4643a6b93fc1'),
            ('02m/chedar_1247_UV02m.sofa', 'd2b84f60dca0ca059c38492a286d6c8d'),
            ('02m/chedar_1248_UV02m.sofa', '5e1aa65f4fbbe485786547e91931428e'),
            ('02m/chedar_1249_UV02m.sofa', 'd4fdbbd49e5766d2d48e4d751a4583f5'),
            ('02m/chedar_1250_UV02m.sofa', 'f4fcc9d23e558eeada580c8bb8622f6f'),
            ('02m/chedar_1251_UV02m.sofa', '45054ca72fd96146b56316583e6bcf91'),
            ('02m/chedar_1252_UV02m.sofa', '28104303f55abb4460f113acfa55c027'),
            ('02m/chedar_1253_UV02m.sofa', '1d0c30e4e63c9960050832790aa3c2a4'),
        ],
        '05m': [
            ('05m/chedar_0001_UV05m.sofa', 'a41e13e07d100af42524f039ccec8438'),
            ('05m/chedar_0002_UV05m.sofa', '6322a96d36e39b03c6e9c8cf80eedcba'),
            ('05m/chedar_0003_UV05m.sofa', 'e6a10fc0b297aa6bced772a8371932ec'),
            ('05m/chedar_0004_UV05m.sofa', '059e5fb9102765140d4d9e980e842ed1'),
            ('05m/chedar_0005_UV05m.sofa', '6058ff25522fc9f123970a6d8c2dff8f'),
            ('05m/chedar_0006_UV05m.sofa', '17fa7e9fc9d76d2f8e34eaf9a25c06cc'),
            ('05m/chedar_0007_UV05m.sofa', '4f555210a4e854c2bd882499c89213d2'),
            ('05m/chedar_0008_UV05m.sofa', '2958a19807d4ee0e032cd22e7b09fe25'),
            ('05m/chedar_0009_UV05m.sofa', '9d682d2259da55e8eeb0f3f31c113ccb'),
            ('05m/chedar_0010_UV05m.sofa', '4edba5af7f732c4d529b1429c5f9e67a'),
            ('05m/chedar_0011_UV05m.sofa', '5b8cfbc2afdfabec52353aa8c6d85b05'),
            ('05m/chedar_0012_UV05m.sofa', '43edf89feb8b702148478df5521dd99f'),
            ('05m/chedar_0013_UV05m.sofa', 'ab3765112f0db1bdff988702bebd40d7'),
            ('05m/chedar_0014_UV05m.sofa', 'bddc236cf60f56180d1da7cdb1e5b8f0'),
            ('05m/chedar_0015_UV05m.sofa', '86ca9e9920d2a0b452a28c1b68903f7b'),
            ('05m/chedar_0016_UV05m.sofa', '53fbbac681ba1a958f60d05f63a67c39'),
            ('05m/chedar_0017_UV05m.sofa', '2c0e530b151b1cb731f2380b8d444ecc'),
            ('05m/chedar_0018_UV05m.sofa', '522372151bdc8d9155d1da6888ed420a'),
            ('05m/chedar_0019_UV05m.sofa', '44bfe36a912007438c6dca179b45d735'),
            ('05m/chedar_0020_UV05m.sofa', 'af472823228ab361c56d766a17d93f23'),
            ('05m/chedar_0021_UV05m.sofa', '8567140194ce547b0e9755ef0865a038'),
            ('05m/chedar_0022_UV05m.sofa', 'c5cfa85b63f83ca3781ea1033eee8e5e'),
            ('05m/chedar_0023_UV05m.sofa', 'f93cd0fe2ffc25ad0e2e0b9667f10da1'),
            ('05m/chedar_0024_UV05m.sofa', 'd4937080aef71488ea4c96c573cab17f'),
            ('05m/chedar_0025_UV05m.sofa', '61f30fc64303578879fa8797852f5327'),
            ('05m/chedar_0026_UV05m.sofa', '526ad34064ff6244e165cc2a85f95ec6'),
            ('05m/chedar_0027_UV05m.sofa', '2bda33ff2c678e34fdae26b45c96413e'),
            ('05m/chedar_0028_UV05m.sofa', 'ecc8fa5ad8a1e2192de0b530f1e8e54c'),
            ('05m/chedar_0029_UV05m.sofa', 'b3b2261ac0b57eef60ee9012fa0fd853'),
            ('05m/chedar_0030_UV05m.sofa', 'bfe50efc13b7311d0b38d57b46d892b2'),
            ('05m/chedar_0031_UV05m.sofa', '805a583b29a2e6020e434083b5da1bee'),
            ('05m/chedar_0032_UV05m.sofa', '131b41c2305d9935e219149e5213df5d'),
            ('05m/chedar_0033_UV05m.sofa', 'e443f7bc65c102086c8a44fc9737d4d1'),
            ('05m/chedar_0034_UV05m.sofa', '2548238b516d99f7b4059519a929530e'),
            ('05m/chedar_0035_UV05m.sofa', '23eb464d80c1ea68cde9713465790f27'),
            ('05m/chedar_0036_UV05m.sofa', 'dfcc80c3a39aab123352884fec52485a'),
            ('05m/chedar_0037_UV05m.sofa', '8bb3962eaf145bcafe7a716f46568fa4'),
            ('05m/chedar_0038_UV05m.sofa', '8996f70847a5c2de151a24a6651cb6c1'),
            ('05m/chedar_0039_UV05m.sofa', '040a94c79e2309f1015be549ef4ce96b'),
            ('05m/chedar_0040_UV05m.sofa', '2d45d06f6870b717d61d76888698248b'),
            ('05m/chedar_0041_UV05m.sofa', '54ebd96ecc6fbc946cbfad944300c782'),
            ('05m/chedar_0042_UV05m.sofa', '33fffeaec750fff52615c0052b9641c7'),
            ('05m/chedar_0043_UV05m.sofa', '97a2eea730be38d04b91a446b2321275'),
            ('05m/chedar_0044_UV05m.sofa', 'e6365d35b7b6a115a075a4b5128ef9bb'),
            ('05m/chedar_0045_UV05m.sofa', 'ecd06361edec4d673080046483888dac'),
            ('05m/chedar_0046_UV05m.sofa', '5e3a6c52a965572e29d0d8495b9dd3e5'),
            ('05m/chedar_0047_UV05m.sofa', 'cc8f57de28e9fc76753fd99920dff458'),
            ('05m/chedar_0048_UV05m.sofa', 'b3980a2576e731fcf76733bd5af20482'),
            ('05m/chedar_0049_UV05m.sofa', '4864716f89d33841a0123308bb024cba'),
            ('05m/chedar_0050_UV05m.sofa', 'c1033376e81d94e1e9ca7e7b1b88c171'),
            ('05m/chedar_0051_UV05m.sofa', 'd0b2838b55a8f6ba8395f7a777c17c31'),
            ('05m/chedar_0052_UV05m.sofa', 'dabd615ff9e5bdd4582010883eb0819a'),
            ('05m/chedar_0053_UV05m.sofa', '10233485e0c319e53aebd8c3e945bfc3'),
            ('05m/chedar_0054_UV05m.sofa', 'ecefc27c7b78f6edc5a615367f8fde51'),
            ('05m/chedar_0055_UV05m.sofa', '406e87e292bf6994af456c441ecb2d52'),
            ('05m/chedar_0056_UV05m.sofa', 'e5ac7f61d286ec9794782fe3ced92591'),
            ('05m/chedar_0057_UV05m.sofa', '5ce5b1ea65ec5aae5d4fa34f39408d5d'),
            ('05m/chedar_0058_UV05m.sofa', '3fa9fa833deca6d8890b0c56d2eceaf4'),
            ('05m/chedar_0059_UV05m.sofa', '85cbf1764ba316c81fcbcdcdfbca702b'),
            ('05m/chedar_0060_UV05m.sofa', '1d76c86fc74070c5338fc0d2ae88919d'),
            ('05m/chedar_0061_UV05m.sofa', '7f8bd0562974ad5053ddbe426b3fddd6'),
            ('05m/chedar_0062_UV05m.sofa', '99634a3cf7453f5888840f6e790b9a80'),
            ('05m/chedar_0063_UV05m.sofa', '17e5fa60ed0221339844af9eb78db94d'),
            ('05m/chedar_0064_UV05m.sofa', '9f64e39c8648a53f1465ccc8a6c2976c'),
            ('05m/chedar_0065_UV05m.sofa', '83e2002c403a51fdb305b9777ec44a66'),
            ('05m/chedar_0066_UV05m.sofa', '0cf22cef7f030e7f57892716b5420496'),
            ('05m/chedar_0067_UV05m.sofa', '38710d32398dc36c98d1b646dce02769'),
            ('05m/chedar_0068_UV05m.sofa', 'a5cf58173317e8f35b2cffec896d419a'),
            ('05m/chedar_0069_UV05m.sofa', '3ce2e18b33b66aca95ff50f08afce084'),
            ('05m/chedar_0070_UV05m.sofa', '429b9faf7e365b9e2cbae81b78443205'),
            ('05m/chedar_0071_UV05m.sofa', '906cd0166ec3190fa8ae0a241d84a865'),
            ('05m/chedar_0072_UV05m.sofa', 'f6854566718721a46d0176119d327cdb'),
            ('05m/chedar_0073_UV05m.sofa', '78198a64fcd507fc0455752531665230'),
            ('05m/chedar_0074_UV05m.sofa', 'fc5fb3fa51d059dae7a17c7070e10bb1'),
            ('05m/chedar_0075_UV05m.sofa', '6cc82662670d1e35120daec3f3ab1244'),
            ('05m/chedar_0076_UV05m.sofa', '8cfd14288a56d86073196a66de8e9a73'),
            ('05m/chedar_0077_UV05m.sofa', '154ae9dfd5ee198639d193868ee045a0'),
            ('05m/chedar_0078_UV05m.sofa', '16caca7688b6814b6b8969a81a9d1342'),
            ('05m/chedar_0079_UV05m.sofa', '119a147f3a4e7db359f6116fcf0fa6d0'),
            ('05m/chedar_0080_UV05m.sofa', '3f0d90fa14ded68066a32242ec4aafe5'),
            ('05m/chedar_0081_UV05m.sofa', 'f00fa932cae2e2cde68d25b66c4a04da'),
            ('05m/chedar_0082_UV05m.sofa', '1ff5787afe47b948a7a1833874acf2b3'),
            ('05m/chedar_0083_UV05m.sofa', 'c942a2453bb99eddd5ff786321ac1885'),
            ('05m/chedar_0084_UV05m.sofa', 'e52c0d98ed87c7ae0244979269ca33a1'),
            ('05m/chedar_0085_UV05m.sofa', '908e4b7f2d22c870d974de0299321600'),
            ('05m/chedar_0086_UV05m.sofa', '4fcd3ca715f1b2ecb99265e89279ffc7'),
            ('05m/chedar_0087_UV05m.sofa', '40bbb164ebde29f34b2804a57dfc1f4d'),
            ('05m/chedar_0088_UV05m.sofa', '68b307bf5c863e1a19bbfef75582a777'),
            ('05m/chedar_0089_UV05m.sofa', 'b512570c701e2268daa2367109bf9fc6'),
            ('05m/chedar_0090_UV05m.sofa', 'a0f3b6d803e315869b692140ebc3fcaf'),
            ('05m/chedar_0091_UV05m.sofa', '536c71dbd451098616f15afa63a795fb'),
            ('05m/chedar_0092_UV05m.sofa', '84254168e325b7d2d08ce2733bd462eb'),
            ('05m/chedar_0093_UV05m.sofa', 'bbcb7e247a6fb4fb5248ef8f1db12fc0'),
            ('05m/chedar_0094_UV05m.sofa', 'f38fc47eaff2dc9c51806e31be5c4260'),
            ('05m/chedar_0095_UV05m.sofa', 'd67ac1a5e7c815d815f00294ae2f75a3'),
            ('05m/chedar_0096_UV05m.sofa', 'e1afb010b3cef1b42d376901a2fad9e1'),
            ('05m/chedar_0097_UV05m.sofa', '9c45d400d993997c0441f8f8682bcf79'),
            ('05m/chedar_0098_UV05m.sofa', '14301c04aeb2ae0c8051b9b87d6dbf03'),
            ('05m/chedar_0099_UV05m.sofa', 'fe5bea93959e0e4c69c940669b6e5b77'),
            ('05m/chedar_0100_UV05m.sofa', 'c537f0b3d2c5458d44ce87197a0d42a9'),
            ('05m/chedar_0101_UV05m.sofa', '4f4387627cbb0e48a3c309eaab333ee6'),
            ('05m/chedar_0102_UV05m.sofa', '8001d2f4f289e38f355f1a4d455d8988'),
            ('05m/chedar_0103_UV05m.sofa', 'c4171bf8bfe6df6e7566e12d514ba75d'),
            ('05m/chedar_0104_UV05m.sofa', 'aa9709626bdb1f2bee4e9ffaed75b4ee'),
            ('05m/chedar_0105_UV05m.sofa', 'b5ad277469833a22d34551cab2e1b2e0'),
            ('05m/chedar_0106_UV05m.sofa', '77b133341c4fdf7274635ff322d3aa59'),
            ('05m/chedar_0107_UV05m.sofa', '955eab62a589d2440c8df29c4b828429'),
            ('05m/chedar_0108_UV05m.sofa', '530cebdd736f28b04a40f7831cd14b38'),
            ('05m/chedar_0109_UV05m.sofa', 'cc367192bc9ac782cabb901d3b650244'),
            ('05m/chedar_0110_UV05m.sofa', '749eff67a24f69e34bb05ff0f8654de5'),
            ('05m/chedar_0111_UV05m.sofa', 'f34fa4695dc1b0b51dfc513febf9908e'),
            ('05m/chedar_0112_UV05m.sofa', '6c197b8104e7b42141337c1a13505703'),
            ('05m/chedar_0113_UV05m.sofa', '386aa2c5e4e69d8b4fc1b16f73cfd106'),
            ('05m/chedar_0114_UV05m.sofa', '2614293e829391d91feab91d8c5643e3'),
            ('05m/chedar_0115_UV05m.sofa', '25b2cbfdb901850563b046a23ee19961'),
            ('05m/chedar_0116_UV05m.sofa', 'be3bb0c63fa8f507d81404b0a47a1508'),
            ('05m/chedar_0117_UV05m.sofa', 'b20c1b6cd3b6d03a07c146257858ed57'),
            ('05m/chedar_0118_UV05m.sofa', 'b559652ca59ab8157cc176dc814236f8'),
            ('05m/chedar_0119_UV05m.sofa', '5bc6949f218aa9aeff52c7abc64f496c'),
            ('05m/chedar_0120_UV05m.sofa', '0ebd7b21def9753d24e6c02c32d7169b'),
            ('05m/chedar_0121_UV05m.sofa', '4ee00e6b3030a5987ed1983e1f10fdac'),
            ('05m/chedar_0122_UV05m.sofa', 'aa50dbabbc0d12fe66453dd0b16a6962'),
            ('05m/chedar_0123_UV05m.sofa', 'db047ae4226d75c515df682873ad79a3'),
            ('05m/chedar_0124_UV05m.sofa', 'ae696c4465cd94fdf22e76af416f4281'),
            ('05m/chedar_0125_UV05m.sofa', '1ec8de1ec01a3102f7d3f78a28289f9e'),
            ('05m/chedar_0126_UV05m.sofa', 'eea4c5391ee1ee3b16c279edcfb0c6da'),
            ('05m/chedar_0127_UV05m.sofa', '4dfb9be536cf0911779d8bd225f8d363'),
            ('05m/chedar_0128_UV05m.sofa', '61aee13da192fa01090a6cec67e36711'),
            ('05m/chedar_0129_UV05m.sofa', '1f96356bf11176d67d6c53f8a7c14e9c'),
            ('05m/chedar_0130_UV05m.sofa', '4d805111ced9fadcadfe34765c00264b'),
            ('05m/chedar_0131_UV05m.sofa', '851116d3d5c2cc7920e8efe5fc5218f5'),
            ('05m/chedar_0132_UV05m.sofa', '873bd96694660414e69839588b7af000'),
            ('05m/chedar_0133_UV05m.sofa', 'd2cd3149577705f7c471894d8b673e0f'),
            ('05m/chedar_0134_UV05m.sofa', 'ce41ff52df436a8ac82271dca5f39896'),
            ('05m/chedar_0135_UV05m.sofa', 'c1a5b4ff5a33494656cce462271e66a2'),
            ('05m/chedar_0136_UV05m.sofa', '1b84cba8d3a3d3c69b574e2a5c9f9f46'),
            ('05m/chedar_0137_UV05m.sofa', '23d5df18c3c8b6a27454ff2802b11ce2'),
            ('05m/chedar_0138_UV05m.sofa', 'decf06a14af3e5900a0d425169cd2dbe'),
            ('05m/chedar_0139_UV05m.sofa', '60eca28227e2d54ef084ef35afd14041'),
            ('05m/chedar_0140_UV05m.sofa', '722bc6c5e894bbb7dc289480519afcba'),
            ('05m/chedar_0141_UV05m.sofa', '268c6fca6cc18c6a374cbb141759d6d9'),
            ('05m/chedar_0142_UV05m.sofa', '4cc64dc0dd98ea71018a4fc50b68021b'),
            ('05m/chedar_0143_UV05m.sofa', '44bc3cb4a6f812291d7deb7aa2c6e34b'),
            ('05m/chedar_0144_UV05m.sofa', '647c8bec00903511fe9be26870117aed'),
            ('05m/chedar_0145_UV05m.sofa', '76e013fbe1e8e8efb4aa7e523f9cacab'),
            ('05m/chedar_0146_UV05m.sofa', '5f6a187089602f78fd7d3e4ebbe2cd16'),
            ('05m/chedar_0147_UV05m.sofa', '2739394cf717322d67f385034417b0d9'),
            ('05m/chedar_0148_UV05m.sofa', '9a60ec8abbbaceecd182fcc7b4268b2c'),
            ('05m/chedar_0149_UV05m.sofa', 'c90abd2c9ca16792fb47b0be791fdc25'),
            ('05m/chedar_0150_UV05m.sofa', 'fe2c744baec7cc269591cb5ddb100205'),
            ('05m/chedar_0151_UV05m.sofa', '38bd05441f8daafcc934856e96d5ea52'),
            ('05m/chedar_0152_UV05m.sofa', '1f5d0dd0744266a91564fa7820e96a38'),
            ('05m/chedar_0153_UV05m.sofa', 'ff379df96b47769775ba6d93250782a8'),
            ('05m/chedar_0154_UV05m.sofa', 'a09ac15c9027a65f223d19514e22fbf6'),
            ('05m/chedar_0155_UV05m.sofa', '8f30509aaa5fffab9cff630e74e68392'),
            ('05m/chedar_0156_UV05m.sofa', 'bfeb3180c22a816beadd94847cfd599a'),
            ('05m/chedar_0157_UV05m.sofa', '79cfa44898569b678c706088e52edcc5'),
            ('05m/chedar_0158_UV05m.sofa', '6e0ee3018267a0ea5277ed1e89bb086c'),
            ('05m/chedar_0159_UV05m.sofa', 'd3feac05db8fe4bdd064ca3ad0f4a6b9'),
            ('05m/chedar_0160_UV05m.sofa', '20719c600e24bf99dff74d33eedef938'),
            ('05m/chedar_0161_UV05m.sofa', '97e758978bad64f10c3b475d7b5496f9'),
            ('05m/chedar_0162_UV05m.sofa', '23dfb23527ef335fd8b9f9872cf12738'),
            ('05m/chedar_0163_UV05m.sofa', '1faca4e66db91bbd969bf23765aa359e'),
            ('05m/chedar_0164_UV05m.sofa', '0b606c9f52a49cdb7748e43366275fe5'),
            ('05m/chedar_0165_UV05m.sofa', '187464e82eaac74cbd22630baa0d1f16'),
            ('05m/chedar_0166_UV05m.sofa', '094ef2aa404530df7ec874a5dad21819'),
            ('05m/chedar_0167_UV05m.sofa', 'ea429289266913eccd8795d54ae4522f'),
            ('05m/chedar_0168_UV05m.sofa', '72b2dfa31531ddb69a2e64bb6ba75cdf'),
            ('05m/chedar_0169_UV05m.sofa', '6fbb50ba71d32a319215c4e1b89e7da0'),
            ('05m/chedar_0170_UV05m.sofa', '8bcb80640c37dbe81101df0a793ee977'),
            ('05m/chedar_0171_UV05m.sofa', '581958b4b07f9ddaa5cf7f03575cb160'),
            ('05m/chedar_0172_UV05m.sofa', '759cbaa677ee099fa654e0fa95fd76ae'),
            ('05m/chedar_0173_UV05m.sofa', '1d692fe1928ba4b1cf674a262a05e094'),
            ('05m/chedar_0174_UV05m.sofa', 'f21bc44c2b724ad26e15a45a15fe0aa4'),
            ('05m/chedar_0175_UV05m.sofa', 'd5ca18efdec8285f77eac2fe7583b38c'),
            ('05m/chedar_0176_UV05m.sofa', '6cce86cad4a1229b689084384b58c7c4'),
            ('05m/chedar_0177_UV05m.sofa', '2fb771721b69dd8389641ff23f09320e'),
            ('05m/chedar_0178_UV05m.sofa', '6ca59af7a1569b7454f77070acc421a0'),
            ('05m/chedar_0179_UV05m.sofa', '1d831d0358da84e8be44d7a0f5e3796c'),
            ('05m/chedar_0180_UV05m.sofa', '0fe853921a664a1b068488c3dad43f6b'),
            ('05m/chedar_0181_UV05m.sofa', '96f7c472b91ffa8aff7ef6038719eab6'),
            ('05m/chedar_0182_UV05m.sofa', '0386ec5ea23e44b72b95b6c1c84f668b'),
            ('05m/chedar_0183_UV05m.sofa', '6434513a722cb47a298d0b64aaf8595e'),
            ('05m/chedar_0184_UV05m.sofa', '8dedd0aa45993a0103ae4d7bf1df3894'),
            ('05m/chedar_0185_UV05m.sofa', 'e3a8be60c59446d905e376b56c2b79ac'),
            ('05m/chedar_0186_UV05m.sofa', '6d520c14c4efdb162bd4dafa96c5caf5'),
            ('05m/chedar_0187_UV05m.sofa', 'e28a530e08ac01454cee4bd106be217d'),
            ('05m/chedar_0188_UV05m.sofa', '4f981944ed672c5db6b1f363fc90dbad'),
            ('05m/chedar_0189_UV05m.sofa', '90ca1751a1d2336d80fa908ed07d2e20'),
            ('05m/chedar_0190_UV05m.sofa', '1e3a77104073bdfab9f74c973482982b'),
            ('05m/chedar_0191_UV05m.sofa', 'c70dc053e091bd114b7edb3adbcdc394'),
            ('05m/chedar_0192_UV05m.sofa', 'e17ce4d39fef28707bcc76328fd1a87b'),
            ('05m/chedar_0193_UV05m.sofa', 'cde5495de9dbdb7267b432fe7205bdd5'),
            ('05m/chedar_0194_UV05m.sofa', '046e5d1c9229373f74a2db3a47e76601'),
            ('05m/chedar_0195_UV05m.sofa', 'ce06dd22a7f1d653b3d50d6e5a24ec3c'),
            ('05m/chedar_0196_UV05m.sofa', 'dfbcfc137a11ae69d13bfc5417287387'),
            ('05m/chedar_0197_UV05m.sofa', 'c64106c7922eeb4a28a721ee280bb797'),
            ('05m/chedar_0198_UV05m.sofa', 'f04dfe4435b02678a339ef8960c943f9'),
            ('05m/chedar_0199_UV05m.sofa', '000ebe8365a8a78f7aa175c415fbe2a4'),
            ('05m/chedar_0200_UV05m.sofa', 'dfbc8cd5f69819d9b4c585c3410092d2'),
            ('05m/chedar_0201_UV05m.sofa', '3d92262962d57fbf079594c93b127e71'),
            ('05m/chedar_0202_UV05m.sofa', '180fcbd23227f5856575d322350e7833'),
            ('05m/chedar_0203_UV05m.sofa', '58fd81ddd933008b1c6b0d9eb36cdd8d'),
            ('05m/chedar_0204_UV05m.sofa', '1a464810316d4b6ba27eda4d80ca7f75'),
            ('05m/chedar_0205_UV05m.sofa', '747769da3997ea6e4cd76705bb343d98'),
            ('05m/chedar_0206_UV05m.sofa', '6d1efd45fa3d6e99229c9b66c96049ec'),
            ('05m/chedar_0207_UV05m.sofa', '56c5a865caee7e52b50445bbf62548a3'),
            ('05m/chedar_0208_UV05m.sofa', '5841b1726fc6ae801bbbf1e0802ec74f'),
            ('05m/chedar_0209_UV05m.sofa', '740181ac59afd45f17ad8e7a5266456b'),
            ('05m/chedar_0210_UV05m.sofa', '3534593b502d2c5e3cd6f136860c7944'),
            ('05m/chedar_0211_UV05m.sofa', 'ea95b1c8b80dbcc81593b6fe03efcdbc'),
            ('05m/chedar_0212_UV05m.sofa', 'd2ac71f03b2f93fdeb95759d0f11af0a'),
            ('05m/chedar_0213_UV05m.sofa', '447264c1f7a8f529a753a29f23d89359'),
            ('05m/chedar_0214_UV05m.sofa', '115da60f630df4b0b0a93107b8dd7f35'),
            ('05m/chedar_0215_UV05m.sofa', '1b94a0bb5322b2e928feeee08515c7ca'),
            ('05m/chedar_0216_UV05m.sofa', '3ff75071dec70f4241057e3ee7d38d40'),
            ('05m/chedar_0217_UV05m.sofa', 'bc034de1b11e581f3b5583c97f313797'),
            ('05m/chedar_0218_UV05m.sofa', '881af728319ec79cce0db86ac9cdb582'),
            ('05m/chedar_0219_UV05m.sofa', '1dd225f96d4040f13727b07018ab86c4'),
            ('05m/chedar_0220_UV05m.sofa', '6564062a01265ce9e6f25ccad182328f'),
            ('05m/chedar_0221_UV05m.sofa', '5e7bb43b4d9c25dbb884ff683a829121'),
            ('05m/chedar_0222_UV05m.sofa', '055efe0528a3a7cd275f7b12e64d7e9f'),
            ('05m/chedar_0223_UV05m.sofa', 'cc2651be99a22c9d7ebfbca639607fd8'),
            ('05m/chedar_0224_UV05m.sofa', 'a53bc94bc474f5db62ff9651c6748d9c'),
            ('05m/chedar_0225_UV05m.sofa', '8b7fbc00ff654fa4e60fc8234d5367bb'),
            ('05m/chedar_0226_UV05m.sofa', '3bbe2e601131157dff37ed2afa4152b4'),
            ('05m/chedar_0227_UV05m.sofa', 'b1a58663d2e8b80e56b6a750fbf3a257'),
            ('05m/chedar_0228_UV05m.sofa', '80e8cbe5719f1a43a811949af58aa70b'),
            ('05m/chedar_0229_UV05m.sofa', '747976bb9838eae8e9c23583f9d938bb'),
            ('05m/chedar_0230_UV05m.sofa', '66426a4592d59de4216b159c2b72e9b1'),
            ('05m/chedar_0231_UV05m.sofa', 'fc0c40923fdc7b6b1efede60568eccf2'),
            ('05m/chedar_0232_UV05m.sofa', 'f2d288469f6102280af472a4fbd858d3'),
            ('05m/chedar_0233_UV05m.sofa', 'c2747d2919f31d3a5c56415596cc011c'),
            ('05m/chedar_0234_UV05m.sofa', '70759dff9d34a12f13c916ae2e5d4e39'),
            ('05m/chedar_0235_UV05m.sofa', 'b1ff230b5762e427a1233f9c817cf060'),
            ('05m/chedar_0236_UV05m.sofa', '16de5f2a605fbf1f82840a9097e368ca'),
            ('05m/chedar_0237_UV05m.sofa', 'eb7caf84c0bf4d3f1ea3706a9ae921a5'),
            ('05m/chedar_0238_UV05m.sofa', '44723d0c1db41cbd6f589ee324ec9fc7'),
            ('05m/chedar_0239_UV05m.sofa', 'fd25d103e5228c4b59e1d5d6c567b8db'),
            ('05m/chedar_0240_UV05m.sofa', '67761fefdaf496988946bcec69fa4c12'),
            ('05m/chedar_0241_UV05m.sofa', '003596d036324d44920a670bd4a4d460'),
            ('05m/chedar_0242_UV05m.sofa', 'f0f853744dbb6312f6c8f341ec1cf07c'),
            ('05m/chedar_0243_UV05m.sofa', 'b696ca4328a7ce8590ff5731bcfdd27c'),
            ('05m/chedar_0244_UV05m.sofa', 'adad0049d9d3fd3a9326991ba73eff4b'),
            ('05m/chedar_0245_UV05m.sofa', 'b762dc941b3935ed70743edb4833c4c7'),
            ('05m/chedar_0246_UV05m.sofa', 'b7a3b2f6d9dc144426c1fc906515ea66'),
            ('05m/chedar_0247_UV05m.sofa', 'f5cb1710cdd18b36b9f2d98ff36e2cee'),
            ('05m/chedar_0248_UV05m.sofa', 'a8f7505526a2eabe50ebeb71d9493733'),
            ('05m/chedar_0249_UV05m.sofa', 'd6492e69a5f90837b962ff021015b583'),
            ('05m/chedar_0250_UV05m.sofa', '7aa27e00c5bbd8a6b5dd93d66e70cfe9'),
            ('05m/chedar_0251_UV05m.sofa', 'b6db86e213bc620828e1dbb78f33a096'),
            ('05m/chedar_0252_UV05m.sofa', 'ab70ae4a947e67ca97c23a6189be37e9'),
            ('05m/chedar_0253_UV05m.sofa', 'fcf63ceec2912b1d077ea1bfceecedac'),
            ('05m/chedar_0254_UV05m.sofa', '904c6198166fcbf3bb82c32d8617ebf1'),
            ('05m/chedar_0255_UV05m.sofa', 'cedcdf9679a9be25e3f34a7da1005f3c'),
            ('05m/chedar_0256_UV05m.sofa', '580191a3eb3582ab18bf9c99b025b56f'),
            ('05m/chedar_0257_UV05m.sofa', '2e862c58c0e077b39db93e138bdf0ac4'),
            ('05m/chedar_0258_UV05m.sofa', '9b6a894d4d2be218a96c25d9a37df165'),
            ('05m/chedar_0259_UV05m.sofa', '57a745764a169ae843dd767034288926'),
            ('05m/chedar_0260_UV05m.sofa', '7ac53ed99d63213ea83b20b44c94d9a6'),
            ('05m/chedar_0261_UV05m.sofa', 'cf0ecd9e32753ba65c115730153e2da2'),
            ('05m/chedar_0262_UV05m.sofa', 'a65891dfee0aa0faea5f4b8a5033be47'),
            ('05m/chedar_0263_UV05m.sofa', '44187e1ecb6f304275a31a5d4b488c1b'),
            ('05m/chedar_0264_UV05m.sofa', '41595a1986af0783640441231e7575ab'),
            ('05m/chedar_0265_UV05m.sofa', '83bd5eb89aa78923bd4d853be4a64931'),
            ('05m/chedar_0266_UV05m.sofa', 'c01f1ad8d405ceda3ec28d2a3d94f054'),
            ('05m/chedar_0267_UV05m.sofa', '0e38b2edfadaaaf4eaded9b3a59ca9dc'),
            ('05m/chedar_0268_UV05m.sofa', '1e954fb9144f9a9f3e960688c011a18f'),
            ('05m/chedar_0269_UV05m.sofa', '5384203eb8174ecaea7bb8fdbbe379e8'),
            ('05m/chedar_0270_UV05m.sofa', '4851390462602698c220db0505e260fe'),
            ('05m/chedar_0271_UV05m.sofa', 'e959139c5dbda9aafaa1c54d052c4584'),
            ('05m/chedar_0272_UV05m.sofa', 'babb16e142567d8df89c5be0bb51cf35'),
            ('05m/chedar_0273_UV05m.sofa', '90893e86dd75b7f4262dfc9af03215a1'),
            ('05m/chedar_0274_UV05m.sofa', '2d6833e49098373ee275dc976abc2866'),
            ('05m/chedar_0275_UV05m.sofa', '0037e99c7311a2fd29d5a41eb7924f0a'),
            ('05m/chedar_0276_UV05m.sofa', '65e427597545f3aa27956ab8edc620b3'),
            ('05m/chedar_0277_UV05m.sofa', '138076f990afc2e6bd95d1e891a0c030'),
            ('05m/chedar_0278_UV05m.sofa', '999dafd0dbff13de1c3a5a3a94286077'),
            ('05m/chedar_0279_UV05m.sofa', 'ea28f61ce0144f0159257bf305684b44'),
            ('05m/chedar_0280_UV05m.sofa', '27e38a89144704017cbf2739bd5ad60b'),
            ('05m/chedar_0281_UV05m.sofa', '52064afa5a71b46da9322f4052d5d03e'),
            ('05m/chedar_0282_UV05m.sofa', '543a25045eb057c9ea31f15062d58ca7'),
            ('05m/chedar_0283_UV05m.sofa', 'd9f2ed61ba533cd9bfedbb7a57a5369a'),
            ('05m/chedar_0284_UV05m.sofa', 'f3baf4033bab08bd37ddcdb2c25bd7ad'),
            ('05m/chedar_0285_UV05m.sofa', 'c4bcc6e898bdbe7773783a7add019df4'),
            ('05m/chedar_0286_UV05m.sofa', '8db2bb29d94b7c835c54d4696d893a15'),
            ('05m/chedar_0287_UV05m.sofa', '132519217246b05778c49448d5e04c9d'),
            ('05m/chedar_0288_UV05m.sofa', '334f17f96e459d6f18331cdbccbdfe82'),
            ('05m/chedar_0289_UV05m.sofa', '6ff1ae665edc34c9c7ed74fa47ab0b6b'),
            ('05m/chedar_0290_UV05m.sofa', '4bf0cb881d3abff3aea8f6af30be8896'),
            ('05m/chedar_0291_UV05m.sofa', '951ea7d5e8701723e6333de13325b3c2'),
            ('05m/chedar_0292_UV05m.sofa', '327e08b100ee911547feaecd2ab38b8b'),
            ('05m/chedar_0293_UV05m.sofa', 'ce44b3195572b9cbaaaaa6f675db5f72'),
            ('05m/chedar_0294_UV05m.sofa', '7f50ed1a98d3d0c8957f0f4c35579961'),
            ('05m/chedar_0295_UV05m.sofa', '60178ad1cac603148a0df0a907878af3'),
            ('05m/chedar_0296_UV05m.sofa', '3f7d2a4ff18bd2318489ec666307350b'),
            ('05m/chedar_0297_UV05m.sofa', '9e4aa2f59c5e0ed7a1a82961fc688975'),
            ('05m/chedar_0298_UV05m.sofa', '8b91ca9c757ac10506af017db7acb69d'),
            ('05m/chedar_0299_UV05m.sofa', 'a24c032b15d451a3fb6050dc7df9919b'),
            ('05m/chedar_0300_UV05m.sofa', 'c03714a8ff73184d78491f726c88cdc5'),
            ('05m/chedar_0301_UV05m.sofa', '3afdcbaa80f1bf66d212b5ef84b684a5'),
            ('05m/chedar_0302_UV05m.sofa', '0f455178fcda59853d38992b29936211'),
            ('05m/chedar_0303_UV05m.sofa', 'ca93793da6506cfc2f8b4283e6b4eb71'),
            ('05m/chedar_0304_UV05m.sofa', '2d5b7774a72a5be5632985110f24f383'),
            ('05m/chedar_0305_UV05m.sofa', '6568ffbfaf4685ad280ebaf0344051c3'),
            ('05m/chedar_0306_UV05m.sofa', 'fef9fcd3b9dce4bed9497d4224533888'),
            ('05m/chedar_0307_UV05m.sofa', '25efcefd3c5ce7490b8d94ff21f9c3a2'),
            ('05m/chedar_0308_UV05m.sofa', '3cb1df82d7d8bd217aaa821c4250ca2d'),
            ('05m/chedar_0309_UV05m.sofa', '8c416384648a424f0ab2385376d56434'),
            ('05m/chedar_0310_UV05m.sofa', '5779a83a82b3507219d4621dcbd90281'),
            ('05m/chedar_0311_UV05m.sofa', '9d68cae235adeb6c85ba6c4491900456'),
            ('05m/chedar_0312_UV05m.sofa', '85d9ffa0060fdfb798d3b7a214731539'),
            ('05m/chedar_0313_UV05m.sofa', '1dfd34a13a66856449ba6db3069becd5'),
            ('05m/chedar_0314_UV05m.sofa', 'd393515a3ec0a2f34a0c178738fb8b43'),
            ('05m/chedar_0315_UV05m.sofa', '3189abce9bfe5928249d204d3493b846'),
            ('05m/chedar_0316_UV05m.sofa', 'e022c67e583bb7a6336ac8a24957c9fe'),
            ('05m/chedar_0317_UV05m.sofa', 'b66dfc5e10a9b3383766145b384a655d'),
            ('05m/chedar_0318_UV05m.sofa', '022553ccd12340b7f20c48986ab35545'),
            ('05m/chedar_0319_UV05m.sofa', '263775fdfe1108743090012d59e06a98'),
            ('05m/chedar_0320_UV05m.sofa', 'cbb636934730fbf7286a8fa7b3301b5e'),
            ('05m/chedar_0321_UV05m.sofa', '866bd7a2d181ab3e2da7efd65fae9e86'),
            ('05m/chedar_0322_UV05m.sofa', '80e783c3234e93c4d58e928a2206047c'),
            ('05m/chedar_0323_UV05m.sofa', 'cb47a54d4d7bab767c61d021d139e6fb'),
            ('05m/chedar_0324_UV05m.sofa', '86fc045c71d325be266b894c470612bf'),
            ('05m/chedar_0325_UV05m.sofa', '816c50b5b149aac5d7c7326136a17078'),
            ('05m/chedar_0326_UV05m.sofa', '35399d0cee5a0597e80e73e24fbedc7a'),
            ('05m/chedar_0327_UV05m.sofa', '062f0cc094e0144d982003f99226a31b'),
            ('05m/chedar_0328_UV05m.sofa', 'f1990a8dad3102e50fbac582c21d9d6f'),
            ('05m/chedar_0329_UV05m.sofa', '6e1507e774c50143bbdd395e8afaa34e'),
            ('05m/chedar_0330_UV05m.sofa', '78717eda7bd3de83c74ee0464aa9055c'),
            ('05m/chedar_0331_UV05m.sofa', '87bcf791e0edc511cac3cece6a44ea05'),
            ('05m/chedar_0332_UV05m.sofa', '7a725d6eb86a75fef1016e4d736c1542'),
            ('05m/chedar_0333_UV05m.sofa', '8a9841d84734621dc26b85068bc0b77d'),
            ('05m/chedar_0334_UV05m.sofa', '5a7f726435cacde1f7b71ddba3076c82'),
            ('05m/chedar_0335_UV05m.sofa', '6878dcdb14783440993dc6554b84b042'),
            ('05m/chedar_0336_UV05m.sofa', '4db10a76d2e9333f08a57620571b4484'),
            ('05m/chedar_0337_UV05m.sofa', 'f7eb340eeecf6b9825f86f13b23f3091'),
            ('05m/chedar_0338_UV05m.sofa', '41f2813a069e395732b79c4a2796e84c'),
            ('05m/chedar_0339_UV05m.sofa', '4b09afe8ede95cb8c518954edd1a2a5d'),
            ('05m/chedar_0340_UV05m.sofa', 'be1954d767ec0484ff3493f32de7fbee'),
            ('05m/chedar_0341_UV05m.sofa', 'cdbaa55815756224baaf85e8eb7ab061'),
            ('05m/chedar_0342_UV05m.sofa', 'e147140c3a0847e1e090be6fa0c94276'),
            ('05m/chedar_0343_UV05m.sofa', 'd7ac713ab872aca8952d1931b16562cd'),
            ('05m/chedar_0344_UV05m.sofa', '67bc7e79dc333afe86741ce0d623ff0a'),
            ('05m/chedar_0345_UV05m.sofa', '0f38a66d3897972510e2300f60383e30'),
            ('05m/chedar_0346_UV05m.sofa', '0588e8e5de40c60b1967d106135e8941'),
            ('05m/chedar_0347_UV05m.sofa', 'ba67bdf225d9f24a171cc1293a838036'),
            ('05m/chedar_0348_UV05m.sofa', 'ac5c15fcbf22107b3250b340e89dc1b9'),
            ('05m/chedar_0349_UV05m.sofa', '4e2b85d89a162956264bb3e8186264c8'),
            ('05m/chedar_0350_UV05m.sofa', '442376f77b5ddf872954b879f3c0d24f'),
            ('05m/chedar_0351_UV05m.sofa', 'f095edabfc7101f6f37b925e8b1e90b0'),
            ('05m/chedar_0352_UV05m.sofa', 'cf5d6ec28f89bed3a30b9c7ad81565b5'),
            ('05m/chedar_0353_UV05m.sofa', 'b2343c4ea20ba4304bf02464f7207235'),
            ('05m/chedar_0354_UV05m.sofa', 'b1dbed50dd3f6094bd12c3a104a727f7'),
            ('05m/chedar_0355_UV05m.sofa', '9f92d91f736b62f0b3217f7070a3b0e0'),
            ('05m/chedar_0356_UV05m.sofa', 'acc3bba94f7426f7ef30278a7bf837d5'),
            ('05m/chedar_0357_UV05m.sofa', '011b5800c43c8317b937900370f5384b'),
            ('05m/chedar_0358_UV05m.sofa', '3a54ac605aba42752281149dc2cba6a2'),
            ('05m/chedar_0359_UV05m.sofa', 'eaa90e5ad3c0d54f4d5d4fe774deb1ac'),
            ('05m/chedar_0360_UV05m.sofa', '312e4639d37fcc0dc630782c28c43969'),
            ('05m/chedar_0361_UV05m.sofa', 'e490f00d8ceb8eddd35aa1028abe200f'),
            ('05m/chedar_0362_UV05m.sofa', '605c731accb96384fbbfecb2be3aefe2'),
            ('05m/chedar_0363_UV05m.sofa', '991c09029b6623215a6fd1b753cde741'),
            ('05m/chedar_0364_UV05m.sofa', '3db439ed0375d5defdddab67f6bb68e7'),
            ('05m/chedar_0365_UV05m.sofa', 'afabdd225bb3ae81d8e632c45776594a'),
            ('05m/chedar_0366_UV05m.sofa', '8a6a39287d1df72cee0c361fdaffddfd'),
            ('05m/chedar_0367_UV05m.sofa', 'cb7593d57613581be2560cb148fa93af'),
            ('05m/chedar_0368_UV05m.sofa', 'b31226a721401f42d48af25ea8e43e72'),
            ('05m/chedar_0369_UV05m.sofa', '2ade95d6ee4c029f0020cc0c7966de57'),
            ('05m/chedar_0370_UV05m.sofa', '46a39671f05f1c663c931b5c54808aaa'),
            ('05m/chedar_0371_UV05m.sofa', '15987b3d25f0d9f35174b3459ea5b9f6'),
            ('05m/chedar_0372_UV05m.sofa', 'efbd013b024f81488f710a5583762572'),
            ('05m/chedar_0373_UV05m.sofa', '37e14c559c43c898284420a09312cfac'),
            ('05m/chedar_0374_UV05m.sofa', 'aa2c791420d5f2428f200dacbaf67407'),
            ('05m/chedar_0375_UV05m.sofa', '939e8ac40f09181517a505ad5a485394'),
            ('05m/chedar_0376_UV05m.sofa', '1aecb75ef520d5879d44aaf3499e4af1'),
            ('05m/chedar_0377_UV05m.sofa', '2413c4f817b619d96b237e331a1b06bb'),
            ('05m/chedar_0378_UV05m.sofa', '5cbb436624cf99b91b3e5c075464c500'),
            ('05m/chedar_0379_UV05m.sofa', '682d882a71c2e425acccf5e6ade87b09'),
            ('05m/chedar_0380_UV05m.sofa', '8ccc46f53cd813f8c9a40c14f1b4fe04'),
            ('05m/chedar_0381_UV05m.sofa', '77bd7387bac1da634d1ead073f4a68bd'),
            ('05m/chedar_0382_UV05m.sofa', '2f46db54db6b15d28cd6a9629b500e4d'),
            ('05m/chedar_0383_UV05m.sofa', '08e19171554ab280a5a0751e50c474ee'),
            ('05m/chedar_0384_UV05m.sofa', 'e6369a33cec65f3a48a95511a9cb554d'),
            ('05m/chedar_0385_UV05m.sofa', '89fef2ca49dfaf47ae9553eae31d32bd'),
            ('05m/chedar_0386_UV05m.sofa', '3fc30c1c71e46169aabb789268ad1b86'),
            ('05m/chedar_0387_UV05m.sofa', '14b6ad29e66c732ef0672d41a7f16cfd'),
            ('05m/chedar_0388_UV05m.sofa', '3b7014951c8e6b3927dc41001bff229e'),
            ('05m/chedar_0389_UV05m.sofa', 'b54e0ccfaac531096e85ddd4f0f80a9b'),
            ('05m/chedar_0390_UV05m.sofa', '91ba4c56797aba4bb4d7f127b2d916cf'),
            ('05m/chedar_0391_UV05m.sofa', 'cadee09616d251691a404cf1f5c17335'),
            ('05m/chedar_0392_UV05m.sofa', 'e97e315e190c763d5ef457594e504e74'),
            ('05m/chedar_0393_UV05m.sofa', 'e1a8e5e9cb1dba1f6f115af269115e0f'),
            ('05m/chedar_0394_UV05m.sofa', 'f4ca7f6ca5701c11bf1abab135ee3196'),
            ('05m/chedar_0395_UV05m.sofa', '37ce4fcc86eece2484d08772de09fb15'),
            ('05m/chedar_0396_UV05m.sofa', '45710952e03eba0fbccfe9987941843e'),
            ('05m/chedar_0397_UV05m.sofa', 'f72e22ced40c58b9731bddf02c1e0862'),
            ('05m/chedar_0398_UV05m.sofa', '27c78e2bc2a0379635e7772630822ec8'),
            ('05m/chedar_0399_UV05m.sofa', 'aa73068a0bb584ceaed376a6ce60f707'),
            ('05m/chedar_0400_UV05m.sofa', '4782ce1a38757fa9f3b585a87aa23d07'),
            ('05m/chedar_0401_UV05m.sofa', '18745d59a672c6143b5074f9896237b1'),
            ('05m/chedar_0402_UV05m.sofa', '2dea1906d7799f38662ed5f52f9a6724'),
            ('05m/chedar_0403_UV05m.sofa', '199e139114f87b49d206c1ef88ac82d4'),
            ('05m/chedar_0404_UV05m.sofa', '37d864bb85edeb6e6f18c9dae98f6586'),
            ('05m/chedar_0405_UV05m.sofa', '028e76a8622c08bd2fbad71e1458209f'),
            ('05m/chedar_0406_UV05m.sofa', '19480f459b572d62870d40b357ee5238'),
            ('05m/chedar_0407_UV05m.sofa', '447d878f2f1410befe0c7cc0a2a65719'),
            ('05m/chedar_0408_UV05m.sofa', 'c312d0ce0f2f8db8b7fc1bb18c4a4b96'),
            ('05m/chedar_0409_UV05m.sofa', 'eeaa969ec384587e861f9d790c27bd9c'),
            ('05m/chedar_0410_UV05m.sofa', 'd87fb95da6af66caf43b8f485afd9685'),
            ('05m/chedar_0411_UV05m.sofa', 'cd333daa0c8ec14197a320bfc01cd1fd'),
            ('05m/chedar_0412_UV05m.sofa', 'ce31d0038aff58775e39c7bea864e15c'),
            ('05m/chedar_0413_UV05m.sofa', '493289f73a866f32a53e2e16bd868fda'),
            ('05m/chedar_0414_UV05m.sofa', '908e05cde55b9f6a3af016721127d4a1'),
            ('05m/chedar_0415_UV05m.sofa', '22db9c73c73edef7e9d0698939e88bda'),
            ('05m/chedar_0416_UV05m.sofa', 'afc5c2b1ace56be0ffbf82de7f921859'),
            ('05m/chedar_0417_UV05m.sofa', '975f8747fa1daa7a5f3f3d9b1e9e0bed'),
            ('05m/chedar_0418_UV05m.sofa', '2ad0c77256b53394dd414be3c037e557'),
            ('05m/chedar_0419_UV05m.sofa', '43b0bb43b485b2492590e3b29fe1a66a'),
            ('05m/chedar_0420_UV05m.sofa', '02dcc488a2850d9641000e09b8e44414'),
            ('05m/chedar_0421_UV05m.sofa', '9304ba881a686d35c1bf1e842265ce9d'),
            ('05m/chedar_0422_UV05m.sofa', '4b31b26f308e575a778ef019509e3b63'),
            ('05m/chedar_0423_UV05m.sofa', '0b6dfc42e4b85558a7ee28083de10b36'),
            ('05m/chedar_0424_UV05m.sofa', 'ad45dc64a289c8132322f90ca2c3c189'),
            ('05m/chedar_0425_UV05m.sofa', 'a87378e8ec998be0deba469f83d8d3d8'),
            ('05m/chedar_0426_UV05m.sofa', '20a4052445e2431c5363e45311e9b051'),
            ('05m/chedar_0427_UV05m.sofa', '773ca02266b23feb4cfef1fd0b6e4e86'),
            ('05m/chedar_0428_UV05m.sofa', '312a32e708266ca666966bb28c65d4e8'),
            ('05m/chedar_0429_UV05m.sofa', 'ebf400b183e1bcac7b2ced6c53d81595'),
            ('05m/chedar_0430_UV05m.sofa', 'b7a7991620e9659e3c5acd557bf174be'),
            ('05m/chedar_0431_UV05m.sofa', 'ba5049bb09d3b58ece8d50a5da181f2d'),
            ('05m/chedar_0432_UV05m.sofa', 'e6861d94c6c9214c5549f8b810d295f4'),
            ('05m/chedar_0433_UV05m.sofa', '7c62417ec9240843309fd8c252a773ea'),
            ('05m/chedar_0434_UV05m.sofa', '1bd3ab323d3132dbce72ba4ba43cbc10'),
            ('05m/chedar_0435_UV05m.sofa', '53fd6fc827899308a1ecb76fe20e8705'),
            ('05m/chedar_0436_UV05m.sofa', '33773782f695fa3a54f89b131ee33864'),
            ('05m/chedar_0437_UV05m.sofa', '5bcc9a4e998fac4d7b5fe91c5ecf225b'),
            ('05m/chedar_0438_UV05m.sofa', '6a8431dbb7943b907e6f6e7ebf6805d4'),
            ('05m/chedar_0439_UV05m.sofa', '222101f912bdad61159d1c1d4be59b52'),
            ('05m/chedar_0440_UV05m.sofa', 'bfab3be2b1c78340e663b9112a9cbebb'),
            ('05m/chedar_0441_UV05m.sofa', 'e8027ab8cfb66857aa2fef1ba50dfdf7'),
            ('05m/chedar_0442_UV05m.sofa', '35375697461ded0f23838fe76f5ef142'),
            ('05m/chedar_0443_UV05m.sofa', 'b282053d2726dc712797fc807f50fcac'),
            ('05m/chedar_0444_UV05m.sofa', 'dacb7d84401e1992627318ebdda12190'),
            ('05m/chedar_0445_UV05m.sofa', 'ce460f171fc8ebeba4637e644381b1b5'),
            ('05m/chedar_0446_UV05m.sofa', '825c301535b95d30577b279b598d7bb3'),
            ('05m/chedar_0447_UV05m.sofa', 'f43268a4b3db734d02d3b86062e8daa1'),
            ('05m/chedar_0448_UV05m.sofa', 'ca765393488864778bb7eafa6fbc12b3'),
            ('05m/chedar_0449_UV05m.sofa', '1e036ead47973eb288ed29a60d29712f'),
            ('05m/chedar_0450_UV05m.sofa', '2ce34adefe9a16e960d30013e7dd8a97'),
            ('05m/chedar_0451_UV05m.sofa', '1d64ec0953dad1b88aaa126fb550d5cf'),
            ('05m/chedar_0452_UV05m.sofa', '4d69cb44a22d6c6f306fab66938c8722'),
            ('05m/chedar_0453_UV05m.sofa', '709928507f591074d6ff69dde0ef6ed0'),
            ('05m/chedar_0454_UV05m.sofa', 'b1bf787b561755f80514cf8ce1a84052'),
            ('05m/chedar_0455_UV05m.sofa', 'bca09141b664c076eeb43fffc5578ae1'),
            ('05m/chedar_0456_UV05m.sofa', 'c357ac20b5120018a929aa24f36d6a2a'),
            ('05m/chedar_0457_UV05m.sofa', 'cbb31d870b3059a97a81ef66aa3ec6b6'),
            ('05m/chedar_0458_UV05m.sofa', 'fd239a315ddaa5ba3f6fdc11e8c35df1'),
            ('05m/chedar_0459_UV05m.sofa', '89051ae5156fc12ed91370b90d98e924'),
            ('05m/chedar_0460_UV05m.sofa', 'e2ffc496359588ed5542cc884d7bcbf5'),
            ('05m/chedar_0461_UV05m.sofa', '8964359c8a9c5155ee9ed7bed3f26d62'),
            ('05m/chedar_0462_UV05m.sofa', '0b0f1cbb83ba17c574b5e8accb33245d'),
            ('05m/chedar_0463_UV05m.sofa', 'da17cac5e3fe7d8999429c93812dc1ef'),
            ('05m/chedar_0464_UV05m.sofa', '16f7bcc5cb4a7764bde8441e61a98e4e'),
            ('05m/chedar_0465_UV05m.sofa', '2fb728bd8f5bea4d398b550f7e03088b'),
            ('05m/chedar_0466_UV05m.sofa', '2f23513006da5a55e2a5405f7bf0c74d'),
            ('05m/chedar_0467_UV05m.sofa', '82af956d84ea4c8dd8aa85b6e83596ae'),
            ('05m/chedar_0468_UV05m.sofa', '8f8df5270f9d2fc00cccbd595a42bdbd'),
            ('05m/chedar_0469_UV05m.sofa', '1c06cec7afca71eb18a1b186106708fe'),
            ('05m/chedar_0470_UV05m.sofa', '83d47ca7fba9ce2140777f2e1abd6414'),
            ('05m/chedar_0471_UV05m.sofa', '469ae106ce3a5257c68a3205ed1a110a'),
            ('05m/chedar_0472_UV05m.sofa', '0d65a8ed8210815d48c60ed73af5691d'),
            ('05m/chedar_0473_UV05m.sofa', 'd00730e0cbb726719234e397749cd01a'),
            ('05m/chedar_0474_UV05m.sofa', '324ecd97ecb96bbadcb62fa8656c4e03'),
            ('05m/chedar_0475_UV05m.sofa', '37cfe17373689069f470f75ed4f52555'),
            ('05m/chedar_0476_UV05m.sofa', '658bc54710070409398cbebdedb75104'),
            ('05m/chedar_0477_UV05m.sofa', 'b2f359fa6dde48b395d000757da1da6b'),
            ('05m/chedar_0478_UV05m.sofa', '41b2869a380a3a64c4a88c1f09a61839'),
            ('05m/chedar_0479_UV05m.sofa', '981b3d45243edfd84bd1a1f6e41b441a'),
            ('05m/chedar_0480_UV05m.sofa', 'ec42697a2fa54a350fc9399ad2beab80'),
            ('05m/chedar_0481_UV05m.sofa', 'fc2f9249936dc2ae076e6949255ce07f'),
            ('05m/chedar_0482_UV05m.sofa', 'bd8c2b2c38fe79a89270ecaacc09c8eb'),
            ('05m/chedar_0483_UV05m.sofa', '62614fe5a064c701569c7faf9f68d067'),
            ('05m/chedar_0484_UV05m.sofa', '1a8b13327f843e3a973007128496ee22'),
            ('05m/chedar_0485_UV05m.sofa', '8598a5cc4b9f53fc14a8ca48965a7ab7'),
            ('05m/chedar_0486_UV05m.sofa', 'f0bcaf0c5d3aee380ad7341a436b00f0'),
            ('05m/chedar_0487_UV05m.sofa', '9be8283aef47b90d64c52d1b5b08e52a'),
            ('05m/chedar_0488_UV05m.sofa', '6cb13a9e79fe094adbc2a3f28ae917a9'),
            ('05m/chedar_0489_UV05m.sofa', '0483d5ac2d8625579cefec78d45d0dd0'),
            ('05m/chedar_0490_UV05m.sofa', '0eb06fd7e256627fae064d32dcc40ad7'),
            ('05m/chedar_0491_UV05m.sofa', '65e48218b3941ed75a4616bb5bb43949'),
            ('05m/chedar_0492_UV05m.sofa', 'f4b23f51c230bbc1a29d7177654c31b5'),
            ('05m/chedar_0493_UV05m.sofa', '05ad7b52c4c271c8f4a64fab935206e6'),
            ('05m/chedar_0494_UV05m.sofa', '42a933198e43aea7c44595b321c8f950'),
            ('05m/chedar_0495_UV05m.sofa', '3cff9fc620c9c4fb341d6ed20ab769ef'),
            ('05m/chedar_0496_UV05m.sofa', '0fa14962f833af9efbeea2e67279d011'),
            ('05m/chedar_0497_UV05m.sofa', '922c2086825cfae74731e5fac220017b'),
            ('05m/chedar_0498_UV05m.sofa', 'ca42565d60d8351e7bd5940f5320274e'),
            ('05m/chedar_0499_UV05m.sofa', '9e2957dec92df836896564ba90398aa1'),
            ('05m/chedar_0500_UV05m.sofa', '46784fc7d6e464ba34f82b3ee05cd067'),
            ('05m/chedar_0501_UV05m.sofa', '1b1add1c9336086657246024aa20b27f'),
            ('05m/chedar_0502_UV05m.sofa', '905ccbef46c772c78696c9185f8a3ec8'),
            ('05m/chedar_0503_UV05m.sofa', 'c6cd819e483b160a3c3077825fe13cfd'),
            ('05m/chedar_0504_UV05m.sofa', '3253d5185bfbe302975e923268924fd7'),
            ('05m/chedar_0505_UV05m.sofa', '80f6713fcb9976b74888245b76b82538'),
            ('05m/chedar_0506_UV05m.sofa', '6e7ab4ee890c5c1e138fcebb0876aac3'),
            ('05m/chedar_0507_UV05m.sofa', '729b86507b33e69f9674207bf4d0290a'),
            ('05m/chedar_0508_UV05m.sofa', '10458ea2c99248e5999e80ce8aa59f36'),
            ('05m/chedar_0509_UV05m.sofa', 'bcfec3c589c6685d2bfa339128ae42c2'),
            ('05m/chedar_0510_UV05m.sofa', 'bc17c40b5f08e2262730f6bcf5ad4428'),
            ('05m/chedar_0511_UV05m.sofa', '20034496a26cfa918b7c064c9b365116'),
            ('05m/chedar_0512_UV05m.sofa', 'c3c1285743099121d407045195e82aef'),
            ('05m/chedar_0513_UV05m.sofa', '1758cbde36c682bc18b489bd0f1338dd'),
            ('05m/chedar_0514_UV05m.sofa', 'f05b49123d695f9241ffdfeeeea74e1c'),
            ('05m/chedar_0515_UV05m.sofa', 'c9435ba025465018066c7b20da3c00c6'),
            ('05m/chedar_0516_UV05m.sofa', 'dfa10ee0f541c6ad3569d94cd752bd72'),
            ('05m/chedar_0517_UV05m.sofa', '367bc2b8f14c62441035946adbf4300a'),
            ('05m/chedar_0518_UV05m.sofa', 'e12cd7d4bba96fcf207d79a5c7f0ae90'),
            ('05m/chedar_0519_UV05m.sofa', 'c6772fee51f5b7f88540fb2f18f259d9'),
            ('05m/chedar_0520_UV05m.sofa', '8dfa86da3b091334ab4162209834fb1f'),
            ('05m/chedar_0521_UV05m.sofa', '8e11520d53ef3f26778136960c36b0f3'),
            ('05m/chedar_0522_UV05m.sofa', '45baa4d9099c1145d4ff89293a5fe9a4'),
            ('05m/chedar_0523_UV05m.sofa', 'fccc4f519efc8c0a03272426ca27d21e'),
            ('05m/chedar_0524_UV05m.sofa', 'e2efd9b964d7257bdcf21b66ab4012d0'),
            ('05m/chedar_0525_UV05m.sofa', '9bd104e9fb46a9769de4af175092a434'),
            ('05m/chedar_0526_UV05m.sofa', '2db7c9c643ee0f08547ad91eb3cb6460'),
            ('05m/chedar_0527_UV05m.sofa', 'de66a3dc867ac1a8d3ab75895b0571a9'),
            ('05m/chedar_0528_UV05m.sofa', '33ab1ce62038b50c9ecfa22411221461'),
            ('05m/chedar_0529_UV05m.sofa', '696a68783cd0c247a74d8f8deb5c558b'),
            ('05m/chedar_0530_UV05m.sofa', '559a6f437bd63f6fd2cc94f7370dbd06'),
            ('05m/chedar_0531_UV05m.sofa', '356a5deb1607c6fb2543b41f1207e866'),
            ('05m/chedar_0532_UV05m.sofa', 'bea246b7e1a46b6090a947a062f359e1'),
            ('05m/chedar_0533_UV05m.sofa', 'e01eeb9a4d86ac062acd8eca716541a2'),
            ('05m/chedar_0534_UV05m.sofa', 'e6f924d4975cb4b990e89d1911a918d2'),
            ('05m/chedar_0535_UV05m.sofa', '21d2799f15f608b64f82d8bc8dda96d5'),
            ('05m/chedar_0536_UV05m.sofa', '048bd8e7864ecd4172a271662f024bf4'),
            ('05m/chedar_0537_UV05m.sofa', '2b5a7d74bfaa01c07af67278a1262ff7'),
            ('05m/chedar_0538_UV05m.sofa', '397740daa361ec1e35c678abe2916c04'),
            ('05m/chedar_0539_UV05m.sofa', 'eb2b0d43c405fa4837a8505f36601605'),
            ('05m/chedar_0540_UV05m.sofa', '0ddc76ea11796b39e2528fb5bde379b0'),
            ('05m/chedar_0541_UV05m.sofa', 'b344985e157590c966029ed51c0610e6'),
            ('05m/chedar_0542_UV05m.sofa', '440dd73f2cfc0f4178b3824adcf9e88a'),
            ('05m/chedar_0543_UV05m.sofa', '7bfae3ffd704a2563311daeef2035032'),
            ('05m/chedar_0544_UV05m.sofa', '257e85abf5b75398fdece3239889b7f9'),
            ('05m/chedar_0545_UV05m.sofa', 'a41e044540735f8f5eada9cf43368b75'),
            ('05m/chedar_0546_UV05m.sofa', '2a62010600ae34eee377e1ffdb64093d'),
            ('05m/chedar_0547_UV05m.sofa', '0b95eaa1cfd09bb58126c9e3bd376086'),
            ('05m/chedar_0548_UV05m.sofa', '2a9b664042c19f90b53ffc2ac92147d2'),
            ('05m/chedar_0549_UV05m.sofa', '809ad7a261f065a4a0c5c139e9b5bcbe'),
            ('05m/chedar_0550_UV05m.sofa', 'd8566d182147b41371c368052916b3b2'),
            ('05m/chedar_0551_UV05m.sofa', 'edc3b0308c06cf9dbe1dbae1a8c386e5'),
            ('05m/chedar_0552_UV05m.sofa', '68348f20facf24b2a98722ffa7de40c2'),
            ('05m/chedar_0553_UV05m.sofa', '679cffe8d9974077c788d460bc22f926'),
            ('05m/chedar_0554_UV05m.sofa', '3f07b5d5900bda42d6597f9327164536'),
            ('05m/chedar_0555_UV05m.sofa', '2c0a729ec5ba3377d44b22658b6e2a12'),
            ('05m/chedar_0556_UV05m.sofa', 'b1c8cad2461a803a1d613e8955fc1bdb'),
            ('05m/chedar_0557_UV05m.sofa', '4f328a5f1e88f3223b476150856da300'),
            ('05m/chedar_0558_UV05m.sofa', '9c8d128e9a5655398ba2b58dffc28b58'),
            ('05m/chedar_0559_UV05m.sofa', '3f49ff76e7474f42bed37c93124842f8'),
            ('05m/chedar_0560_UV05m.sofa', '79b80da732ef11bab1ccf0bda7f037ac'),
            ('05m/chedar_0561_UV05m.sofa', 'd7d50b58cd22f87404df34c94b8682d5'),
            ('05m/chedar_0562_UV05m.sofa', '125679ae88e66f20577bc0f925539bdf'),
            ('05m/chedar_0563_UV05m.sofa', 'a4e616f73c8bb11306f7aeb464f9a1fb'),
            ('05m/chedar_0564_UV05m.sofa', '358c3b8ab18f024a2118ee4bd945e019'),
            ('05m/chedar_0565_UV05m.sofa', '580c5b84f77cdc075cd4900f139290a1'),
            ('05m/chedar_0566_UV05m.sofa', '266d4b2d98c9cf9062101b8c31be9ccc'),
            ('05m/chedar_0567_UV05m.sofa', 'a555e1ddecf0b4cf805da353dac8875f'),
            ('05m/chedar_0568_UV05m.sofa', '6f026d5cb4744947f8bae4c2a3427a0d'),
            ('05m/chedar_0569_UV05m.sofa', 'ad96cd9b57df87b3a593f3ed667e5210'),
            ('05m/chedar_0570_UV05m.sofa', 'bbff9f8f378749dfac278157e4e29c82'),
            ('05m/chedar_0571_UV05m.sofa', 'bb3422c03df413019e1e16925c0851a4'),
            ('05m/chedar_0572_UV05m.sofa', 'b06ace4dd24307dd68fae289e2bd78b5'),
            ('05m/chedar_0573_UV05m.sofa', '4f7683b093e145f15b444ebb4aed8ebd'),
            ('05m/chedar_0574_UV05m.sofa', 'b271eb7fc03742afed412d570fc4db74'),
            ('05m/chedar_0575_UV05m.sofa', '6e650778ad5051d04579443f6f52f795'),
            ('05m/chedar_0576_UV05m.sofa', 'ab206d11cd147809c87eb5ae4af5b9fe'),
            ('05m/chedar_0577_UV05m.sofa', '048a410239abf503430ed8889a575ba6'),
            ('05m/chedar_0578_UV05m.sofa', '89cd4c2b389c71c31d17b98fe25027e3'),
            ('05m/chedar_0579_UV05m.sofa', '9ef92a683d23b5232770004b4641cdae'),
            ('05m/chedar_0580_UV05m.sofa', '8bed5dc61d4215f15e8f825044f2b3e2'),
            ('05m/chedar_0581_UV05m.sofa', '04b7d7f568a2eb645e8ee099f809c5dd'),
            ('05m/chedar_0582_UV05m.sofa', '4ca6ad79476134de67dc8d9a297027c5'),
            ('05m/chedar_0583_UV05m.sofa', '1e0518183963eaaa77e89aaf356df422'),
            ('05m/chedar_0584_UV05m.sofa', 'eb3aa2468e5ae3627a8ac3d5072cc760'),
            ('05m/chedar_0585_UV05m.sofa', '2187eba71df4b660b1a38235d8bef37a'),
            ('05m/chedar_0586_UV05m.sofa', 'b25f56647656d14d3f357ffd179ec69b'),
            ('05m/chedar_0587_UV05m.sofa', '20ebcb197d1c0d65c4ced0bfdf14ab25'),
            ('05m/chedar_0588_UV05m.sofa', '6afddd9fa8c56b781bd9a0780311da18'),
            ('05m/chedar_0589_UV05m.sofa', '49533c5bc20330d8b6d27660de150569'),
            ('05m/chedar_0590_UV05m.sofa', '0d1c4a6e0355d83d0869d64232d5f97b'),
            ('05m/chedar_0591_UV05m.sofa', 'c77cbed517c13575b0a7e3884b3ba779'),
            ('05m/chedar_0592_UV05m.sofa', '33ebe5313f462397715899087a12372a'),
            ('05m/chedar_0593_UV05m.sofa', 'ac81b5b2a581c9aea89747a068673285'),
            ('05m/chedar_0594_UV05m.sofa', 'b6830850eb92a261f78cfff588f8dda8'),
            ('05m/chedar_0595_UV05m.sofa', '470da1a8c392481a9a962dad89ba6ef3'),
            ('05m/chedar_0596_UV05m.sofa', '5ad5ce3832fc183b66cf8ca0b5b0b41a'),
            ('05m/chedar_0597_UV05m.sofa', 'c98fa64608d69b260c3f466c32d83f3c'),
            ('05m/chedar_0598_UV05m.sofa', 'e9f60a68584deb36d2ae6e0232ddc3ce'),
            ('05m/chedar_0599_UV05m.sofa', '6177122d5cf7a35716385e2244fc2e4b'),
            ('05m/chedar_0600_UV05m.sofa', '0afa4120de65aafe634c7fba4309c130'),
            ('05m/chedar_0601_UV05m.sofa', 'e554f8fdbc4dca12d751ec39d42d0bfe'),
            ('05m/chedar_0602_UV05m.sofa', '6703712bc60c2bf4a8448307cfba9d6d'),
            ('05m/chedar_0603_UV05m.sofa', '60de751c0c49c90437c0c5255a20008b'),
            ('05m/chedar_0604_UV05m.sofa', 'e57e5c478e1afc5c5b6190ace16716c0'),
            ('05m/chedar_0605_UV05m.sofa', '4af52b3001fb1c8b7f160a452be05089'),
            ('05m/chedar_0606_UV05m.sofa', '8e757e29942d191d0b737502956e51dc'),
            ('05m/chedar_0607_UV05m.sofa', '89ec5de9c2f04f4bdda96625f72ff7c8'),
            ('05m/chedar_0608_UV05m.sofa', 'd9aab9b67787c600a4964c58c8376874'),
            ('05m/chedar_0609_UV05m.sofa', '6c1c77dc27e3d816aba8c1061860e088'),
            ('05m/chedar_0610_UV05m.sofa', '76854df281abc3839344c7a1653eff58'),
            ('05m/chedar_0611_UV05m.sofa', '9190cf633bd8ce1dc564330fef773fa1'),
            ('05m/chedar_0612_UV05m.sofa', 'd1fa9f1b38a74db9762a74d2a75620e7'),
            ('05m/chedar_0613_UV05m.sofa', '6a7f6f43b53a0b90c4b4ff32bbd59817'),
            ('05m/chedar_0614_UV05m.sofa', '7e771f344e492f5630f944775bac42fb'),
            ('05m/chedar_0615_UV05m.sofa', '612dfa33de97a022b26d64826de9bc70'),
            ('05m/chedar_0616_UV05m.sofa', '680a8fe277e4e224d0d65053c06c1e5a'),
            ('05m/chedar_0617_UV05m.sofa', '67c859ab8549b3e0fb705b9d57dc83ea'),
            ('05m/chedar_0618_UV05m.sofa', '532b4d60157636b03e19753abf57ec2e'),
            ('05m/chedar_0619_UV05m.sofa', '1038691a4428fdcb9e75a1d097f08535'),
            ('05m/chedar_0620_UV05m.sofa', '98c451f8dcbb5a9d15a6e82af5eef2c4'),
            ('05m/chedar_0621_UV05m.sofa', 'b43fcdb6b9925cc086c7e37f5d80af94'),
            ('05m/chedar_0622_UV05m.sofa', '5596ad1769dd8e0ccb7155af8e95d4f3'),
            ('05m/chedar_0623_UV05m.sofa', '25ebf3bd28f98111735f0a632811ea70'),
            ('05m/chedar_0624_UV05m.sofa', '23e843acaa32ba2f527289ab034227b0'),
            ('05m/chedar_0625_UV05m.sofa', 'aac134fdbcc628e316e0086b0a295200'),
            ('05m/chedar_0626_UV05m.sofa', '64ce088752d93941a0e3c72f56a82a0f'),
            ('05m/chedar_0627_UV05m.sofa', '7d14cdde08bea5af88c0eb117e79ff16'),
            ('05m/chedar_0628_UV05m.sofa', '1ce1c499f82e3a2a70a0451c9b1a97af'),
            ('05m/chedar_0629_UV05m.sofa', '643944f1bb80e44150ddc451bbbec4cc'),
            ('05m/chedar_0630_UV05m.sofa', '6f5470788942296902c608f096cfa4cf'),
            ('05m/chedar_0631_UV05m.sofa', 'bd975a403ec628abedde44f74e9217f6'),
            ('05m/chedar_0632_UV05m.sofa', '21d68119f36917f709dc1ca34bdd8d22'),
            ('05m/chedar_0633_UV05m.sofa', 'e190d9520b5a0314991d59b199f2c1cf'),
            ('05m/chedar_0634_UV05m.sofa', 'eece4ef8032fd7f4c9ffc59d90e6f44e'),
            ('05m/chedar_0635_UV05m.sofa', '26631a36b8554471c627071d3da40b5a'),
            ('05m/chedar_0636_UV05m.sofa', '718fa51ebeef25d6da862e4d3ba078f3'),
            ('05m/chedar_0637_UV05m.sofa', '3be0f10dcc143832e7ce1f24cc6317f3'),
            ('05m/chedar_0638_UV05m.sofa', '8faa469b4981eb06510e17c84a7d9a0d'),
            ('05m/chedar_0639_UV05m.sofa', '3b2812e209ca0dcb3ee700eea5f4d2ca'),
            ('05m/chedar_0640_UV05m.sofa', '6783f338d78ac64b760f0a74a403381c'),
            ('05m/chedar_0641_UV05m.sofa', '4b912b6cf5c330cbf48830c2f8946d17'),
            ('05m/chedar_0642_UV05m.sofa', '8c6ec8cc67696e0bc376796be1be0402'),
            ('05m/chedar_0643_UV05m.sofa', 'ba4c6442f233bea371a95de47818f262'),
            ('05m/chedar_0644_UV05m.sofa', '29cea9407f0bea26853f405b3a9b5d14'),
            ('05m/chedar_0645_UV05m.sofa', 'a899dbf95fd6372a055cbda0f6b1ee04'),
            ('05m/chedar_0646_UV05m.sofa', '9e8f68e81c5031244baff090b6b8ea2d'),
            ('05m/chedar_0647_UV05m.sofa', '81fa0daaa90b07449f954aef66107253'),
            ('05m/chedar_0648_UV05m.sofa', '0112d3023e4fb12ffd9a05738b671378'),
            ('05m/chedar_0649_UV05m.sofa', '115b6dab53af7dbd8013112123ffe4d4'),
            ('05m/chedar_0650_UV05m.sofa', '7567285b5897bc941dc25dfc2818da88'),
            ('05m/chedar_0651_UV05m.sofa', '048b82dcb5fc856e398edd1b017ae71a'),
            ('05m/chedar_0652_UV05m.sofa', 'cc9c8e06c55d422fed6b704dc0bbe357'),
            ('05m/chedar_0653_UV05m.sofa', 'a1e42e2088908c25ec54c9059fd329c0'),
            ('05m/chedar_0654_UV05m.sofa', 'b23fed5110d344cda11300af14ab3344'),
            ('05m/chedar_0655_UV05m.sofa', '2ebf2f96da1218ff29c157e4c53de760'),
            ('05m/chedar_0656_UV05m.sofa', '0802c2b853876085aab0891a4b754294'),
            ('05m/chedar_0657_UV05m.sofa', 'f53345497fc70c98125f962d76c6fe17'),
            ('05m/chedar_0658_UV05m.sofa', '0a10490e4ffb5af987c952862e014a16'),
            ('05m/chedar_0659_UV05m.sofa', '32f2aab64f5ca7aa6ca511cd6645988a'),
            ('05m/chedar_0660_UV05m.sofa', '8a4d8163da6ea30cd53409a219299fd0'),
            ('05m/chedar_0661_UV05m.sofa', '50c259dfe5992fde1232d88f8830e21b'),
            ('05m/chedar_0662_UV05m.sofa', 'af5aa8c15990d0469582b7ccbd17adf1'),
            ('05m/chedar_0663_UV05m.sofa', '578a21c97a061ef0a7d6ac03f659a008'),
            ('05m/chedar_0664_UV05m.sofa', '0fc984bfa58fe012809c6160ed0a44b3'),
            ('05m/chedar_0665_UV05m.sofa', 'c49355577f00d66e3735431bd344c1fc'),
            ('05m/chedar_0666_UV05m.sofa', 'c542daa0099bc226741e097e97707f44'),
            ('05m/chedar_0667_UV05m.sofa', 'b304a33fcc4c30263a4670da40358de1'),
            ('05m/chedar_0668_UV05m.sofa', 'adc0b69efecc2556acc3f10ed10968f8'),
            ('05m/chedar_0669_UV05m.sofa', '3a5585912d1f7b50f06c0256cfd7de28'),
            ('05m/chedar_0670_UV05m.sofa', 'c5f1608fa812a12d036f1ab202dfa8a7'),
            ('05m/chedar_0671_UV05m.sofa', '6e3d20074bc2ead77c888f634cb70bac'),
            ('05m/chedar_0672_UV05m.sofa', '9c4e38ac6468a0432cc41d9933adc785'),
            ('05m/chedar_0673_UV05m.sofa', '6d5d05303393e1f188e490f06d204b42'),
            ('05m/chedar_0674_UV05m.sofa', 'fc3ab793205d19ca62ff951b22ab0075'),
            ('05m/chedar_0675_UV05m.sofa', '1f22854d2076c3bb8c11cdeb8a7b276c'),
            ('05m/chedar_0676_UV05m.sofa', '14e6d047e050f59f7ee6df3d02354e78'),
            ('05m/chedar_0677_UV05m.sofa', 'b098f1b16622b91f1f54db5cb2e19f85'),
            ('05m/chedar_0678_UV05m.sofa', '893900e59aea74f9a93bb6a30360cf50'),
            ('05m/chedar_0679_UV05m.sofa', '900181e1159364b8f29aa1cbd9f27821'),
            ('05m/chedar_0680_UV05m.sofa', '9dc6b10cb78fb037a6e6f0f5e45397fc'),
            ('05m/chedar_0681_UV05m.sofa', '4a7c2f30b0309291f5a716f8f9c75799'),
            ('05m/chedar_0682_UV05m.sofa', 'de2395767acf86dc9a65cbab191c8e2f'),
            ('05m/chedar_0683_UV05m.sofa', '2f0d469e2c1f96858f478a46d67509a9'),
            ('05m/chedar_0684_UV05m.sofa', 'f2969cd9c1d5b501ed1ac7bbecb72284'),
            ('05m/chedar_0685_UV05m.sofa', '30c8b43f1dd9b280f33e7884f153cc6f'),
            ('05m/chedar_0686_UV05m.sofa', '31594c91bffae2c3bcf00e43a90fc91c'),
            ('05m/chedar_0687_UV05m.sofa', '0e57480a89d49b8aa609ab1f8520e7d4'),
            ('05m/chedar_0688_UV05m.sofa', 'df591ab575ba4844511f55afd34a95d5'),
            ('05m/chedar_0689_UV05m.sofa', '5e2a6af51080db2cb1bbfa33cbea0780'),
            ('05m/chedar_0690_UV05m.sofa', '6603b38cdd9e238c86794cd9f1dfb352'),
            ('05m/chedar_0691_UV05m.sofa', 'b13c73e6a1520894bb84a6cfbfa9349a'),
            ('05m/chedar_0692_UV05m.sofa', '1d0210a511b370e85cfd9e236e036339'),
            ('05m/chedar_0693_UV05m.sofa', '4c8e2ba3ca3f41093e3dc53e593dfe11'),
            ('05m/chedar_0694_UV05m.sofa', '8d5fa16cf0b16c2c3ab082e3060e0352'),
            ('05m/chedar_0695_UV05m.sofa', '8b45250cc00bb44f6ab64dde66651f4a'),
            ('05m/chedar_0696_UV05m.sofa', 'fff5131a6d53d3e7b95884f146c55998'),
            ('05m/chedar_0697_UV05m.sofa', '297a9e96bfb510bfd14d76db18bb6d9f'),
            ('05m/chedar_0698_UV05m.sofa', 'a0811e2af7ea035ebd82e6226b433a66'),
            ('05m/chedar_0699_UV05m.sofa', '17c5372be7413025ee6e3d375e2149b7'),
            ('05m/chedar_0700_UV05m.sofa', '5d87314e46e388f392b221f723985287'),
            ('05m/chedar_0701_UV05m.sofa', 'e29c6e90099681d28f9959ab612f14d5'),
            ('05m/chedar_0702_UV05m.sofa', '0d07f118f0cde182d595c556967b0140'),
            ('05m/chedar_0703_UV05m.sofa', '19eb12abe2eb105b69fc46988aea7eab'),
            ('05m/chedar_0704_UV05m.sofa', '30cd9780184bafb4e7a0ef0a73f73253'),
            ('05m/chedar_0705_UV05m.sofa', '4eee4687ef164ab2009ccad26ebab7ee'),
            ('05m/chedar_0706_UV05m.sofa', '696c1203c9d85a9a3ca01fbf62d57d21'),
            ('05m/chedar_0707_UV05m.sofa', '296475329f60835acb4651e81cfa2ad7'),
            ('05m/chedar_0708_UV05m.sofa', '6eec3faaf4602992b1f5a76a69e7e17f'),
            ('05m/chedar_0709_UV05m.sofa', '69e24826e958e9d917411c0e0c121ff5'),
            ('05m/chedar_0710_UV05m.sofa', '2c12d144a3cf0dd09e5fc2a1d2e18bd5'),
            ('05m/chedar_0711_UV05m.sofa', '69f3361a78c9c61bf53c4707d4cb4382'),
            ('05m/chedar_0712_UV05m.sofa', 'ed599e9a6a697c2082bd1e5053e9d273'),
            ('05m/chedar_0713_UV05m.sofa', '7f39d92069bd598268c7737c3c1e2301'),
            ('05m/chedar_0714_UV05m.sofa', 'e23ff6f3689ad69219b7ec4cea829e40'),
            ('05m/chedar_0715_UV05m.sofa', 'a36e1060f1aed7e0929b3611f453f6d8'),
            ('05m/chedar_0716_UV05m.sofa', '7b393bb2a993aec38ed616ed5c591d2f'),
            ('05m/chedar_0717_UV05m.sofa', '6bffeb34c83f358845f87dd6ec6ef6cf'),
            ('05m/chedar_0718_UV05m.sofa', '0c246c0dbfff5a65c876281a18a2356b'),
            ('05m/chedar_0719_UV05m.sofa', 'f0241e5c26be356fb8bb1b70ab8885ac'),
            ('05m/chedar_0720_UV05m.sofa', 'a1b5b73c915b77b482e82a97015a6982'),
            ('05m/chedar_0721_UV05m.sofa', 'e54ed29330c818c1e84c244113bb1798'),
            ('05m/chedar_0722_UV05m.sofa', '3ae0670bce87e457b24cc9e40a6cd8f4'),
            ('05m/chedar_0723_UV05m.sofa', '80117bc7ffa3eee079e232593a12ed12'),
            ('05m/chedar_0724_UV05m.sofa', '3a8e26eee36517fad5fdc0e106b45a36'),
            ('05m/chedar_0725_UV05m.sofa', 'f97394f7bbfc63ebe9a18d28d6805227'),
            ('05m/chedar_0726_UV05m.sofa', '618108af746005163a1e1bea8128e5e7'),
            ('05m/chedar_0727_UV05m.sofa', 'fa7155d2d56a365434ec51cbcf1caf6c'),
            ('05m/chedar_0728_UV05m.sofa', '6b2d5054e307ba71e3e91968b04fcb76'),
            ('05m/chedar_0729_UV05m.sofa', '2c18773c3e9eb8fbd2a0009726cbe05c'),
            ('05m/chedar_0730_UV05m.sofa', 'c0ff80cefe2f380efb453d52d51ae5a2'),
            ('05m/chedar_0731_UV05m.sofa', 'ed172310215499590c289b1e9d681d4a'),
            ('05m/chedar_0732_UV05m.sofa', '2bc68d2eeb1a5c9f39f8e117f7fbe560'),
            ('05m/chedar_0733_UV05m.sofa', 'c8219bdccafdc9b08a598e9b258e0673'),
            ('05m/chedar_0734_UV05m.sofa', 'f8d1c4e88191d80173bf4afe5dba6cd7'),
            ('05m/chedar_0735_UV05m.sofa', '12e5b88c6e78e08d69467b28121ee7f5'),
            ('05m/chedar_0736_UV05m.sofa', 'ccb7eef7531392dc8bb49b47a0afbdb2'),
            ('05m/chedar_0737_UV05m.sofa', 'd1c29a607c8c03f7239e80cea0a0736a'),
            ('05m/chedar_0738_UV05m.sofa', '63e55a4cebdbdda4690c8ff73b3d098b'),
            ('05m/chedar_0739_UV05m.sofa', '4e06ceb25e77d8b3e9c3e3cb02d9bdc3'),
            ('05m/chedar_0740_UV05m.sofa', '08bc0d6573b44a1b0c4fdb9016c702e8'),
            ('05m/chedar_0741_UV05m.sofa', '7f4dc1608df531df2c13a8654caf8f6b'),
            ('05m/chedar_0742_UV05m.sofa', 'e34efb98e81591f805829aaf22da7cf4'),
            ('05m/chedar_0743_UV05m.sofa', '6065f65596feea3407e283a6809001bc'),
            ('05m/chedar_0744_UV05m.sofa', '456a80e33c296305c842dfb018bf78b8'),
            ('05m/chedar_0745_UV05m.sofa', '53411d4038be49c54aca6c00771a6e94'),
            ('05m/chedar_0746_UV05m.sofa', '3f71da1f705280cf3fb433cba4dd40d8'),
            ('05m/chedar_0747_UV05m.sofa', '33618123f56d752ca8461b257656c827'),
            ('05m/chedar_0748_UV05m.sofa', 'a725322d1a83a5e89cc11ddccc280ac0'),
            ('05m/chedar_0749_UV05m.sofa', '5e6650ef9d55f959098abdbf28fd2199'),
            ('05m/chedar_0750_UV05m.sofa', '26742712a51551becb3a7fe6440033d4'),
            ('05m/chedar_0751_UV05m.sofa', 'eb35ff1507eaca005dde8370479328b6'),
            ('05m/chedar_0752_UV05m.sofa', 'b972b6ac0b61e67d399e716ca55fc5e5'),
            ('05m/chedar_0753_UV05m.sofa', 'ddeb7b61583eba48016a54e2e8766ce3'),
            ('05m/chedar_0754_UV05m.sofa', '72f2e678135fa6d5397fac1c90867d1d'),
            ('05m/chedar_0755_UV05m.sofa', '29e26e7c877ab1da94abc40b0659631c'),
            ('05m/chedar_0756_UV05m.sofa', 'e0af4e573ecea1def53c0373a8a74f2b'),
            ('05m/chedar_0757_UV05m.sofa', '1cc38b388e24d0dfb1721772c1ab94a2'),
            ('05m/chedar_0758_UV05m.sofa', '0c2d60c03cb2b4a9d3f58616e3a852da'),
            ('05m/chedar_0759_UV05m.sofa', '582ce1930d1714974942af605f7ff9e9'),
            ('05m/chedar_0760_UV05m.sofa', '70d3854730aee438f5aa586c82409435'),
            ('05m/chedar_0761_UV05m.sofa', '114a1c63858133837712d712dcfc8f42'),
            ('05m/chedar_0762_UV05m.sofa', '5377621f476d9db732206597e2f05f26'),
            ('05m/chedar_0763_UV05m.sofa', 'da3659f6be868dc8d1eef13def98806a'),
            ('05m/chedar_0764_UV05m.sofa', '94cdc69c1e724dffb6bb23aa0fd6cabb'),
            ('05m/chedar_0765_UV05m.sofa', '592e6231070ce8241f9e072cb322543d'),
            ('05m/chedar_0766_UV05m.sofa', 'a1783c22426253c32d66af735ac6303a'),
            ('05m/chedar_0767_UV05m.sofa', '5ca181554d3285d102385d44cb07698d'),
            ('05m/chedar_0768_UV05m.sofa', 'ae009e1762fdb5284255a7e8916d84b4'),
            ('05m/chedar_0769_UV05m.sofa', 'bcf2fc42d260ffdf21fdec95880e5f5e'),
            ('05m/chedar_0770_UV05m.sofa', '538807081f4fa89cd8a16efb020db679'),
            ('05m/chedar_0771_UV05m.sofa', 'ea8b95e6b58d8749892df7d1dd5ed46d'),
            ('05m/chedar_0772_UV05m.sofa', 'a06a2896840afbce754ba8761e2fe358'),
            ('05m/chedar_0773_UV05m.sofa', '80302a24175bd6420e6df9d005efa113'),
            ('05m/chedar_0774_UV05m.sofa', 'b58508ed81f8204c657c7dafd21482a7'),
            ('05m/chedar_0775_UV05m.sofa', 'afcd67a25190273344ede46780ced1fd'),
            ('05m/chedar_0776_UV05m.sofa', 'd5801c8195e34acb1d45432e9d1730da'),
            ('05m/chedar_0777_UV05m.sofa', 'c1d15a4ad804785779055697726aa25b'),
            ('05m/chedar_0778_UV05m.sofa', '5450f719ca1749597c19b2be5d5fe973'),
            ('05m/chedar_0779_UV05m.sofa', '07bd671015dd1f4192be4dda099f0ed7'),
            ('05m/chedar_0780_UV05m.sofa', 'f8665e12b66a3beebe9b0f2f990902c9'),
            ('05m/chedar_0781_UV05m.sofa', '331d486052610ed9584331b9da4a942a'),
            ('05m/chedar_0782_UV05m.sofa', '1607abdc327ef3ea76a2f510b69043a2'),
            ('05m/chedar_0783_UV05m.sofa', '48a43ce8485dc048bc19b180a6f13f18'),
            ('05m/chedar_0784_UV05m.sofa', 'da983ec1bae4c5a49a3dd877af70116a'),
            ('05m/chedar_0785_UV05m.sofa', 'f149aa4110d6651fc6bf100d044e60e9'),
            ('05m/chedar_0786_UV05m.sofa', 'b5432b4ce5ae8ebfb5ca7570f5db2e60'),
            ('05m/chedar_0787_UV05m.sofa', '8c4846c9b03c5b4b111fbac2d4b37933'),
            ('05m/chedar_0788_UV05m.sofa', '3086e0c779c9d8923de24383feada535'),
            ('05m/chedar_0789_UV05m.sofa', '14e4fa8e03a6612dbcbfad98fb48f41c'),
            ('05m/chedar_0790_UV05m.sofa', '009e6095e1f724bfc30fd982e5f991f3'),
            ('05m/chedar_0791_UV05m.sofa', '3d4e1689ce4e2abe599fcf03d3e31001'),
            ('05m/chedar_0792_UV05m.sofa', '1b5bc7a4d87fcc51601c545de4914c47'),
            ('05m/chedar_0793_UV05m.sofa', '6569cf491a7834b2952c0093d3a0e3d0'),
            ('05m/chedar_0794_UV05m.sofa', '78aff002d2e2a276fae75146ce7ec447'),
            ('05m/chedar_0795_UV05m.sofa', 'f7c0701b64bf8cc03e3bf2fd3ef48a10'),
            ('05m/chedar_0796_UV05m.sofa', '04a6f6dd985ee8d83b0244682f7389d8'),
            ('05m/chedar_0797_UV05m.sofa', '651ad431a4ea831e1405273e8225fcae'),
            ('05m/chedar_0798_UV05m.sofa', 'a0f90cd557f5ab1e47fd79467e31542c'),
            ('05m/chedar_0799_UV05m.sofa', '3d0149275adf53ee91ee3f8fd5fe4d5f'),
            ('05m/chedar_0800_UV05m.sofa', 'c73b615c6eaffd522353aead19845ac7'),
            ('05m/chedar_0801_UV05m.sofa', '871acae923c0c58342e839735b587d0b'),
            ('05m/chedar_0802_UV05m.sofa', '9a5a5f71df1427f7591ed1e4c1f28e02'),
            ('05m/chedar_0803_UV05m.sofa', '8c74885a7cc82befbdb41fbfe46cb768'),
            ('05m/chedar_0804_UV05m.sofa', '65ab6ea1c08bd8de306107cbd267a437'),
            ('05m/chedar_0805_UV05m.sofa', 'bc128377c5e39eb98c179799e7fdf75b'),
            ('05m/chedar_0806_UV05m.sofa', '34516cb466f1f2e73520f657f29029f4'),
            ('05m/chedar_0807_UV05m.sofa', '1079daa63797b54b47e0bcaad2ab7d84'),
            ('05m/chedar_0808_UV05m.sofa', 'be20cf46db7f9b2f7fd1bfae3a6f706c'),
            ('05m/chedar_0809_UV05m.sofa', '69c67482febc624094f67f601b34623c'),
            ('05m/chedar_0810_UV05m.sofa', 'd28b9bdf68fe2f1fe4d106787d57ed3e'),
            ('05m/chedar_0811_UV05m.sofa', 'e2c326b0ec6be3055bd382b091c96cc4'),
            ('05m/chedar_0812_UV05m.sofa', '86959fc5a399073b86334b04f5a68cd7'),
            ('05m/chedar_0813_UV05m.sofa', '1c5848ec1be050a9999affb0790eaabc'),
            ('05m/chedar_0814_UV05m.sofa', 'ed9c146eb487446941087c4fad121c82'),
            ('05m/chedar_0815_UV05m.sofa', '294d5267e43b9f176a009582e48bd4bd'),
            ('05m/chedar_0816_UV05m.sofa', 'ab3a4ce09e8431c17ba20a8f205d1e77'),
            ('05m/chedar_0817_UV05m.sofa', '7ac8138cbc7422e765b6a67b63b34222'),
            ('05m/chedar_0818_UV05m.sofa', 'b60039e99971a7b228bdebdb5a751dff'),
            ('05m/chedar_0819_UV05m.sofa', '7e2b72f4ae6b452148418891677973d0'),
            ('05m/chedar_0820_UV05m.sofa', '1c95f99ebffa1b283c6490a5680b23a5'),
            ('05m/chedar_0821_UV05m.sofa', '6f4e66ce17d76abdda0baa14c10fa788'),
            ('05m/chedar_0822_UV05m.sofa', '09549ea77fe2882ab0ac228c1039bd1b'),
            ('05m/chedar_0823_UV05m.sofa', '0e44cadbf594f7b11e2668313160d44e'),
            ('05m/chedar_0824_UV05m.sofa', 'c53babdd12571c6d2e9e9e33f4d14256'),
            ('05m/chedar_0825_UV05m.sofa', '3604a0f23c3e35e09c9d20ad8b52872d'),
            ('05m/chedar_0826_UV05m.sofa', '6afeb27ad482ef66bc2b9ca913425700'),
            ('05m/chedar_0827_UV05m.sofa', '22c3f7e055f49fb586e19de8d7a642db'),
            ('05m/chedar_0828_UV05m.sofa', '0a797e881fd0c1097ea0522a2d07b1bd'),
            ('05m/chedar_0829_UV05m.sofa', '030d622bf24283df69db165cd4ed9983'),
            ('05m/chedar_0830_UV05m.sofa', 'b2b47eb27ca12788e4ac3a34a2a36e04'),
            ('05m/chedar_0831_UV05m.sofa', 'a63c411836cc1aaed6dd259f0454b251'),
            ('05m/chedar_0832_UV05m.sofa', 'befba5af1d72f8687e149a14d143df79'),
            ('05m/chedar_0833_UV05m.sofa', '51f39c0db84b64bb28a1837f09d16eb5'),
            ('05m/chedar_0834_UV05m.sofa', '5c5faf3e284ab7eb36b61bb31fc82d10'),
            ('05m/chedar_0835_UV05m.sofa', '6678b7c671504ccaebb206bc1201a6b9'),
            ('05m/chedar_0836_UV05m.sofa', '5d571f13c298a0afc98bf3b834150f87'),
            ('05m/chedar_0837_UV05m.sofa', 'bcb7c9fa125198fc6766fd340014ccd1'),
            ('05m/chedar_0838_UV05m.sofa', '0d1b5b0823e7456824b48f3df56b18e9'),
            ('05m/chedar_0839_UV05m.sofa', '1bdd73dbd9b9094c85eeefa15e9251a9'),
            ('05m/chedar_0840_UV05m.sofa', '7f2ca641d6f62741039673b7f4276e97'),
            ('05m/chedar_0841_UV05m.sofa', '3ff789e125bf3a643ce15d489ac66cf6'),
            ('05m/chedar_0842_UV05m.sofa', 'fe3a7067f1034e892366b7d355ef63a2'),
            ('05m/chedar_0843_UV05m.sofa', 'cb4a07d945b5a5bffd3340ab976c769d'),
            ('05m/chedar_0844_UV05m.sofa', '95f71c9bb41e4924c553a16a55bfc89f'),
            ('05m/chedar_0845_UV05m.sofa', 'e607cd178d9c79101dd56c0e818ed888'),
            ('05m/chedar_0846_UV05m.sofa', '61272c158c9fce7211455ed349d81123'),
            ('05m/chedar_0847_UV05m.sofa', '19862c5eeead35ccf923df09cbd5b837'),
            ('05m/chedar_0848_UV05m.sofa', '6ef72b310304b1d138c57dff61823f1c'),
            ('05m/chedar_0849_UV05m.sofa', '07e8753b470fe836cf73b2bc96e443d8'),
            ('05m/chedar_0850_UV05m.sofa', '2253d11503784a7987badff33962567a'),
            ('05m/chedar_0851_UV05m.sofa', '7eb75e9eaf655038ab7cb75f118bc8cf'),
            ('05m/chedar_0852_UV05m.sofa', '262c3fbd99bf569822e597c3244bfb6a'),
            ('05m/chedar_0853_UV05m.sofa', '14f43468c4704e95cdfb53c4a1d26ec4'),
            ('05m/chedar_0854_UV05m.sofa', '64c413c5b1683276014180f861a9d2e4'),
            ('05m/chedar_0855_UV05m.sofa', '5aaa76c3fcf304f820e3f150f96e8100'),
            ('05m/chedar_0856_UV05m.sofa', '9a90c4f7b27967455b35165a23dd7aad'),
            ('05m/chedar_0857_UV05m.sofa', '5244a1e7b8caf391d9c9cd2e0666cc85'),
            ('05m/chedar_0858_UV05m.sofa', 'a3a9837d34168e6bc09cf33c452a484a'),
            ('05m/chedar_0859_UV05m.sofa', '303ebd144ee68ad6dd937fb52e7b16fa'),
            ('05m/chedar_0860_UV05m.sofa', '6a6527ed79aedc10188f0c016b985cb7'),
            ('05m/chedar_0861_UV05m.sofa', 'f179471a4c323a313e80119800d3d45b'),
            ('05m/chedar_0862_UV05m.sofa', 'f97377b5d92c86967f4154a56219d6be'),
            ('05m/chedar_0863_UV05m.sofa', '6ca7b83db6a546116cbd9f43ab9ce6eb'),
            ('05m/chedar_0864_UV05m.sofa', 'f24d73481896c080523571ac96c7a1f7'),
            ('05m/chedar_0865_UV05m.sofa', 'e7a7fe03d6ee2f237592dd29868f4022'),
            ('05m/chedar_0866_UV05m.sofa', '863061453e8bed18d535cb14b8a7d86c'),
            ('05m/chedar_0867_UV05m.sofa', '1b3c5ed1edd1c54c7e382504985ab8c7'),
            ('05m/chedar_0868_UV05m.sofa', '796d646968fc9106487b2e7781ee6bdb'),
            ('05m/chedar_0869_UV05m.sofa', '7b9d1004a381d952947b64c8bc3c6ebc'),
            ('05m/chedar_0870_UV05m.sofa', '9f6538d333fbffa0b602bd8421b904b1'),
            ('05m/chedar_0871_UV05m.sofa', '74bfe045f72335e111e5d4c3f8020ec2'),
            ('05m/chedar_0872_UV05m.sofa', 'b365feecf8ebfb1e42aca2c6640ec89d'),
            ('05m/chedar_0873_UV05m.sofa', 'c919164c8deddec8deb09edb5a0db72d'),
            ('05m/chedar_0874_UV05m.sofa', '18031284855d376bcbf5e77586f24df2'),
            ('05m/chedar_0875_UV05m.sofa', '9416f2093e5cf818378534c3b6f26591'),
            ('05m/chedar_0876_UV05m.sofa', 'd7f1df2c41a6598ce69a3067c43dc598'),
            ('05m/chedar_0877_UV05m.sofa', 'f94b321aac488a4d318de11bda3b3c41'),
            ('05m/chedar_0878_UV05m.sofa', '8239b4a69745592b385126e18c3f0ca4'),
            ('05m/chedar_0879_UV05m.sofa', '9419a89e1a32e1c00fd9a612dfa9386e'),
            ('05m/chedar_0880_UV05m.sofa', 'ca84c7bce8e384c90a3887ba5f9a8e62'),
            ('05m/chedar_0881_UV05m.sofa', '274d2a680383f605a7540f57c28fefda'),
            ('05m/chedar_0882_UV05m.sofa', '8ad32c77cc8f2f7a03205a5c58b33f0b'),
            ('05m/chedar_0883_UV05m.sofa', 'cc92618823eebee9f5cebc0833a206a9'),
            ('05m/chedar_0884_UV05m.sofa', '1a76662dc2d38763d04f665025b3242b'),
            ('05m/chedar_0885_UV05m.sofa', '299b4899860e4fb7c7d0d6617a5c65cb'),
            ('05m/chedar_0886_UV05m.sofa', '83eacfc04666bc25789d2493e58cb860'),
            ('05m/chedar_0887_UV05m.sofa', 'd660e8014304d57eb733af1d7140500f'),
            ('05m/chedar_0888_UV05m.sofa', '9e36fd62e5ae2bb2be8b4d076b8b0c9e'),
            ('05m/chedar_0889_UV05m.sofa', '69d4013ffd5f8ac8ff2dadc073f91c0e'),
            ('05m/chedar_0890_UV05m.sofa', '50d89e21cf7bbab64e8afa6a45cd66f5'),
            ('05m/chedar_0891_UV05m.sofa', '8cd990c9306c6d5f2ae6d5390f7da4f3'),
            ('05m/chedar_0892_UV05m.sofa', '3b9669ff80efc4d55769f20259c2bc9c'),
            ('05m/chedar_0893_UV05m.sofa', 'ae3cfb49e094aad812c7feb2193c63a9'),
            ('05m/chedar_0894_UV05m.sofa', 'ac8bf10d3f4f672ab297dc75368ba921'),
            ('05m/chedar_0895_UV05m.sofa', 'e81b01656cbd00d98d19c5b0951dc1a4'),
            ('05m/chedar_0896_UV05m.sofa', '28cebbcf7eddb791e6c81841050532fc'),
            ('05m/chedar_0897_UV05m.sofa', 'caaecebbf372ddbcd8bc16435f493bfd'),
            ('05m/chedar_0898_UV05m.sofa', '744422eac1974d2b0f25c11ce3844047'),
            ('05m/chedar_0899_UV05m.sofa', 'fdaccb9b8f2199a63b0ae45ccac0387e'),
            ('05m/chedar_0900_UV05m.sofa', '58dc63657a81abb2f233463572c9b094'),
            ('05m/chedar_0901_UV05m.sofa', 'a2006619ab7c9616a51e37adad554306'),
            ('05m/chedar_0902_UV05m.sofa', '385104e622a5672e684c87637dc8c27f'),
            ('05m/chedar_0903_UV05m.sofa', 'ca8516920342e09204c4b58a0b03a197'),
            ('05m/chedar_0904_UV05m.sofa', 'e0d67528071541c4f95e1cf4251b26bc'),
            ('05m/chedar_0905_UV05m.sofa', 'ae0c467bc46d10c8bfd13d9d15e7209d'),
            ('05m/chedar_0906_UV05m.sofa', '51c4f70742db08b0002d1533ae91998d'),
            ('05m/chedar_0907_UV05m.sofa', 'd53c96b30a3ca0770e094e37b11074cb'),
            ('05m/chedar_0908_UV05m.sofa', '5c049482c8c0db08b5a713c5185ba3da'),
            ('05m/chedar_0909_UV05m.sofa', 'dff95dfe8b1d5589354f9dc38196c64d'),
            ('05m/chedar_0910_UV05m.sofa', '8b10331f3f1ee1974bf643c9531efa93'),
            ('05m/chedar_0911_UV05m.sofa', 'b24cf46ce418581043ed8e580ab24ad2'),
            ('05m/chedar_0912_UV05m.sofa', '45ffac1417be111e6e5ff0406311269d'),
            ('05m/chedar_0913_UV05m.sofa', 'f98054f697364176d5f9474a51671873'),
            ('05m/chedar_0914_UV05m.sofa', '9bf799fecd6c05420017090d07c24ede'),
            ('05m/chedar_0915_UV05m.sofa', '6133ee9735cb8fae48a650956887efed'),
            ('05m/chedar_0916_UV05m.sofa', 'c62d7cd38746a2835a2af03b720d218a'),
            ('05m/chedar_0917_UV05m.sofa', 'b56b237dd80f17f2204e5ff4d52937d1'),
            ('05m/chedar_0918_UV05m.sofa', '7a9de72003bab2e6bf77af7eb4f339e1'),
            ('05m/chedar_0919_UV05m.sofa', 'dc5fc5f89f1eb77b8e5e940ec77f502d'),
            ('05m/chedar_0920_UV05m.sofa', 'ceb851210f05ea759d02fd759f50b7ec'),
            ('05m/chedar_0921_UV05m.sofa', '8cb9f82aa41c0a5a7216a743316a1803'),
            ('05m/chedar_0922_UV05m.sofa', '0210722091440f21d331fd3909cff389'),
            ('05m/chedar_0923_UV05m.sofa', '5f8abce71af79e016ace53e3d833e98f'),
            ('05m/chedar_0924_UV05m.sofa', '70bb5962e7885435924dea2ee8f4bf8f'),
            ('05m/chedar_0925_UV05m.sofa', 'a6e30006cf0cee1e79754ecb0f430dee'),
            ('05m/chedar_0926_UV05m.sofa', '0f37cdb916c480088730a5153709d826'),
            ('05m/chedar_0927_UV05m.sofa', 'fb50d4aefa199213f976ef12786d32b9'),
            ('05m/chedar_0928_UV05m.sofa', '863d8794536f153e7f1579ee3f675b3d'),
            ('05m/chedar_0929_UV05m.sofa', '78f784cc7837bc48eb108f9b52a510e9'),
            ('05m/chedar_0930_UV05m.sofa', '82b14a579da25163962e8bf0f59d3a3a'),
            ('05m/chedar_0931_UV05m.sofa', 'ea8f19e320c246f317b6bfaa0c5ff664'),
            ('05m/chedar_0932_UV05m.sofa', '6f311f1b69a2d57250f6971dd256fb81'),
            ('05m/chedar_0933_UV05m.sofa', '072f5f3e06140c401e98faecdd312ac0'),
            ('05m/chedar_0934_UV05m.sofa', '271f92b8ad818cc25bd761f75dfb7949'),
            ('05m/chedar_0935_UV05m.sofa', 'd014c3aa47a7bb86fc4c35e796e28c12'),
            ('05m/chedar_0936_UV05m.sofa', '9a8f6cf53426439cc42807ced25224ab'),
            ('05m/chedar_0937_UV05m.sofa', 'ac01b50642635adacadd6e4edeb5e00e'),
            ('05m/chedar_0938_UV05m.sofa', '325524d7efc87d8feebe402284b8d574'),
            ('05m/chedar_0939_UV05m.sofa', 'e05fc0a7e122fc045c24f1fa87c9aa30'),
            ('05m/chedar_0940_UV05m.sofa', '516bfccf925a1d35b0faf5ddf199452e'),
            ('05m/chedar_0941_UV05m.sofa', 'dd461c29c5df2c502a3633d591cc6cc1'),
            ('05m/chedar_0942_UV05m.sofa', '18903595722528c25a8c253824bff1a3'),
            ('05m/chedar_0943_UV05m.sofa', 'c4883c074c52cf9ef880d6a7a09e34e3'),
            ('05m/chedar_0944_UV05m.sofa', '03383c89cb35a11af9dde24616d05d46'),
            ('05m/chedar_0945_UV05m.sofa', '689f9f523c2b2de091f72d200e474d8a'),
            ('05m/chedar_0946_UV05m.sofa', 'cd94c951ba2df479474299c2ff5dafc6'),
            ('05m/chedar_0947_UV05m.sofa', '912d1ab690df03918e395d8749110305'),
            ('05m/chedar_0948_UV05m.sofa', 'c82f8c1ed4690f00bb37c9a2d1abd9fc'),
            ('05m/chedar_0949_UV05m.sofa', 'c20d712260bf06ace98c87318e5e8e34'),
            ('05m/chedar_0950_UV05m.sofa', 'a26d845898aac3a3fc18990c06561bc9'),
            ('05m/chedar_0951_UV05m.sofa', 'f318f7465ccaf7c75ebf12f3dbe2ac2d'),
            ('05m/chedar_0952_UV05m.sofa', '4781ea837a44fbca78dfd04b10cc66c0'),
            ('05m/chedar_0953_UV05m.sofa', '3708be16484aa28d43c55bc4e4426eee'),
            ('05m/chedar_0954_UV05m.sofa', 'b5b4b11fb32be49481a1fd2755edfe8d'),
            ('05m/chedar_0955_UV05m.sofa', '05b164f1da3509811c47c93151d0e519'),
            ('05m/chedar_0956_UV05m.sofa', '532e92b994572b983930f0e227c4d192'),
            ('05m/chedar_0957_UV05m.sofa', '835907874d6611038524b10b24039e6c'),
            ('05m/chedar_0958_UV05m.sofa', '5fb38eb60cd89e8e1e1da090ed4b8a54'),
            ('05m/chedar_0959_UV05m.sofa', '278be1bd9a41fedc15ab92e5b29801ae'),
            ('05m/chedar_0960_UV05m.sofa', '60950460bdf2e1a119167a5994cdb6bc'),
            ('05m/chedar_0961_UV05m.sofa', '2ca1b6aec689beb773229886ec5b32e1'),
            ('05m/chedar_0962_UV05m.sofa', 'f8035b8404f68368252b6fbf87443f59'),
            ('05m/chedar_0963_UV05m.sofa', 'a46d7b7b6849442109113c4180c6cdf3'),
            ('05m/chedar_0964_UV05m.sofa', '386202017351bfea5bb72c81c619d126'),
            ('05m/chedar_0965_UV05m.sofa', 'd60f1922ecb6dc3a908bc84e2e697ef1'),
            ('05m/chedar_0966_UV05m.sofa', 'e0cee5e2f903a30500cdcf82d818d5f4'),
            ('05m/chedar_0967_UV05m.sofa', '8fa819dd84c38b2014d2b96885d7e795'),
            ('05m/chedar_0968_UV05m.sofa', '89ec4dcbcb8459a4699eaef7580dd825'),
            ('05m/chedar_0969_UV05m.sofa', '1a7c5f8b7e4a2d39596ff1d6f5b8cf13'),
            ('05m/chedar_0970_UV05m.sofa', '2b83db82829919ddba9035bb2beb786c'),
            ('05m/chedar_0971_UV05m.sofa', 'fca45a97414a1a450f24b356e9acaa31'),
            ('05m/chedar_0972_UV05m.sofa', '7c7fc81f40f53721e5372d5ca8d8a72c'),
            ('05m/chedar_0973_UV05m.sofa', 'f41269e441187cc63baee93e1c88a7ed'),
            ('05m/chedar_0974_UV05m.sofa', '04285af64a59abf01b6443f857cbd3c7'),
            ('05m/chedar_0975_UV05m.sofa', '424219789f20ce5da4c4d47d5e3e5461'),
            ('05m/chedar_0976_UV05m.sofa', '6a0992493ccb222a177e23b038bbac32'),
            ('05m/chedar_0977_UV05m.sofa', 'fec9fbcad834ce84ac76507a5ae24b20'),
            ('05m/chedar_0978_UV05m.sofa', '4edb80d4777ff862fea1892569415b86'),
            ('05m/chedar_0979_UV05m.sofa', 'bb647ef4050bb1751b3d1db45d9fbf28'),
            ('05m/chedar_0980_UV05m.sofa', '9c31290b95aa320899beaa9e414c5337'),
            ('05m/chedar_0981_UV05m.sofa', 'd1d0b065aa93d7f30a0c2099fbcf2152'),
            ('05m/chedar_0982_UV05m.sofa', '2f3fd191f8c3c6f8b5c4784f908a23db'),
            ('05m/chedar_0983_UV05m.sofa', '2da3f57c126d60e9db0dc9f76f003e48'),
            ('05m/chedar_0984_UV05m.sofa', '26a4600e80dbc471461973be2dfb131c'),
            ('05m/chedar_0985_UV05m.sofa', '510238c98bb9497d39206916e4dbff92'),
            ('05m/chedar_0986_UV05m.sofa', 'a74901e64196d4c6e36bdd42d3112cab'),
            ('05m/chedar_0987_UV05m.sofa', 'fb108d41f435fa7fb2e8a3f293f84b06'),
            ('05m/chedar_0988_UV05m.sofa', 'ac667038b63f5b65d7bddf9bfa8bf0ae'),
            ('05m/chedar_0989_UV05m.sofa', '422a759c3936b9b983dfac4e613f6cbe'),
            ('05m/chedar_0990_UV05m.sofa', '107d7bba4ee4f9c3b42c3cd7c6bb1b42'),
            ('05m/chedar_0991_UV05m.sofa', '41461481db8f58d7aced781d597d1178'),
            ('05m/chedar_0992_UV05m.sofa', '67bf5855f4e54264f08f3d081e9629c9'),
            ('05m/chedar_0993_UV05m.sofa', '741c4454114acc0539590cea4dd07b91'),
            ('05m/chedar_0994_UV05m.sofa', '34ea61e44adc525f43304bb8aef3f062'),
            ('05m/chedar_0995_UV05m.sofa', 'cb0fe98ac5fec0f909ad036990b9868f'),
            ('05m/chedar_0996_UV05m.sofa', '2ff2bfd119885710b26d857b64909ad6'),
            ('05m/chedar_0997_UV05m.sofa', 'ed642486b38e9024641642041d4eec86'),
            ('05m/chedar_0998_UV05m.sofa', 'f44e2210c4de3b8aec00c57b1613f368'),
            ('05m/chedar_0999_UV05m.sofa', 'c09fd6910b8bca460411461c15cbc367'),
            ('05m/chedar_1000_UV05m.sofa', '6eece0c04697bb5d79fff46ab0e633fc'),
            ('05m/chedar_1001_UV05m.sofa', '4ad9036b66f26466591716866c37d061'),
            ('05m/chedar_1002_UV05m.sofa', 'd7e161d39351f0a866c9693f03308fda'),
            ('05m/chedar_1003_UV05m.sofa', 'da64e99c9f050f0fb1cc7a32950e4162'),
            ('05m/chedar_1004_UV05m.sofa', '47dab6b8e0d7b4a8774f860f78b4f3c5'),
            ('05m/chedar_1005_UV05m.sofa', '49ad2cc390784e06ebf001a75079b253'),
            ('05m/chedar_1006_UV05m.sofa', '3ff6de1269ad4ab434b7540a3ad91d27'),
            ('05m/chedar_1007_UV05m.sofa', '502369968b367853ca2e7a174e638576'),
            ('05m/chedar_1008_UV05m.sofa', '16b6e5c1b4ac396e0d5514fdbfa87bdf'),
            ('05m/chedar_1009_UV05m.sofa', 'e26ff28ef3f6233ccf05048ce0a6f069'),
            ('05m/chedar_1010_UV05m.sofa', 'f21611ac8560ac14a7be79c26c0c12cd'),
            ('05m/chedar_1011_UV05m.sofa', 'f9c81cbe8bae6ec677de22db1e979d37'),
            ('05m/chedar_1012_UV05m.sofa', '8b0831fab24acbcc9e9f867540c38868'),
            ('05m/chedar_1013_UV05m.sofa', '7cf30bce028820d893732b4aaa357ac5'),
            ('05m/chedar_1014_UV05m.sofa', '60d55e9c9b0a5cf9a7bfd97ab7b7658c'),
            ('05m/chedar_1015_UV05m.sofa', 'a724678c929f479bf51d22d6875f2ed9'),
            ('05m/chedar_1016_UV05m.sofa', 'f9f3d13c47aeefc36f9d12e9400cc6d4'),
            ('05m/chedar_1017_UV05m.sofa', 'aeddbbff5cecfca6644bcba8d3f0005d'),
            ('05m/chedar_1018_UV05m.sofa', '58db8dcc982e11d764a28a6d3cb4ed11'),
            ('05m/chedar_1019_UV05m.sofa', 'cf759af8de01dddbd2cf9a904d68507c'),
            ('05m/chedar_1020_UV05m.sofa', '3ba6a82062707bd66887e11356a2d175'),
            ('05m/chedar_1021_UV05m.sofa', 'f401dee659cbaf098003af0020f0722e'),
            ('05m/chedar_1022_UV05m.sofa', '9c6605758244b5f18a8424042a49259a'),
            ('05m/chedar_1023_UV05m.sofa', '1a04a0c3cd58fb2eea45f280e66de8b5'),
            ('05m/chedar_1024_UV05m.sofa', '0f8e966aaf814fd0151bd3e204b23fba'),
            ('05m/chedar_1025_UV05m.sofa', 'ffe6e0c84b2b2cd7b3991ff32dd4a065'),
            ('05m/chedar_1026_UV05m.sofa', '7ed4fda6d0d099e894d25f16b5760fe2'),
            ('05m/chedar_1027_UV05m.sofa', '398c14ff6ff687800f7b0267923370e0'),
            ('05m/chedar_1028_UV05m.sofa', '9501b3be5aed3b5cfb31f351208f3d84'),
            ('05m/chedar_1029_UV05m.sofa', 'a8671900c0e3bbc29051b3413eda64d0'),
            ('05m/chedar_1030_UV05m.sofa', '00972f597ef59a9dbcf0bab5a5069fa2'),
            ('05m/chedar_1031_UV05m.sofa', '133b98dd42b6613f95f95704aa703bd7'),
            ('05m/chedar_1032_UV05m.sofa', '601817dbb740f07760217dcec386c630'),
            ('05m/chedar_1033_UV05m.sofa', 'e89ddb1bd8c13286f8daa2c64d406c38'),
            ('05m/chedar_1034_UV05m.sofa', '2aebd230bb0d5f13cbd8b3228788c68b'),
            ('05m/chedar_1035_UV05m.sofa', 'f42f63d16c251a267a8a5992b592eec5'),
            ('05m/chedar_1036_UV05m.sofa', '2b86ce9f26d5e014ed3b10bdd10f9d24'),
            ('05m/chedar_1037_UV05m.sofa', '4f59a0041ccc468ba0077e728c2bd7e1'),
            ('05m/chedar_1038_UV05m.sofa', '47be1143f2cb9c6f90c19bf70a9ea7c5'),
            ('05m/chedar_1039_UV05m.sofa', 'a304b53401cf56b20d5523338c3d5ad2'),
            ('05m/chedar_1040_UV05m.sofa', 'e70ebbe946db01cadc075745c3cc3dab'),
            ('05m/chedar_1041_UV05m.sofa', '1deca834a804203ce124d3f592d43913'),
            ('05m/chedar_1042_UV05m.sofa', 'e41386c80c776c74948b130b94f52abb'),
            ('05m/chedar_1043_UV05m.sofa', '50655a0446a94a74eae961288ef32b29'),
            ('05m/chedar_1044_UV05m.sofa', '2bff5eca364f792305b83b421cd6022f'),
            ('05m/chedar_1045_UV05m.sofa', '6867f4d97b8866488d5e9db802f7ef64'),
            ('05m/chedar_1046_UV05m.sofa', 'a8f78a252e649e5bbef129327c3003a6'),
            ('05m/chedar_1047_UV05m.sofa', '818942b906ee14bcf693d7713fe520ff'),
            ('05m/chedar_1048_UV05m.sofa', '2f3249a707a41cef36d56106c02b7cb8'),
            ('05m/chedar_1049_UV05m.sofa', 'b675b107759ede9006acddc1e898ca2a'),
            ('05m/chedar_1050_UV05m.sofa', 'd837c1e74865f30063b84fec73b94193'),
            ('05m/chedar_1051_UV05m.sofa', '9add3915d4f5537eb4abc1e5e8ce4ca4'),
            ('05m/chedar_1052_UV05m.sofa', '5fd30881b4056fbb1990ca5815719d1a'),
            ('05m/chedar_1053_UV05m.sofa', 'fe0c184caa4abf555c290ff4a77dceee'),
            ('05m/chedar_1054_UV05m.sofa', 'e407b7925860127699b2037f7e8b5328'),
            ('05m/chedar_1055_UV05m.sofa', 'ce53800f9ffd9a581d0bba7ddb0049e4'),
            ('05m/chedar_1056_UV05m.sofa', '79140bb2b3704dca15ddd98f675022f8'),
            ('05m/chedar_1057_UV05m.sofa', 'cc51c91ab9f2c6f37a48603194e72f1a'),
            ('05m/chedar_1058_UV05m.sofa', '287e9ef0a7bb6c31be8d62d7d590ccd2'),
            ('05m/chedar_1059_UV05m.sofa', '36813fe8dddf786df1662abce190d2aa'),
            ('05m/chedar_1060_UV05m.sofa', 'ac23401a3bd334e03936d07b9fe9986c'),
            ('05m/chedar_1061_UV05m.sofa', 'aa8bc2ddcacfc573405b1bc32f12913e'),
            ('05m/chedar_1062_UV05m.sofa', '1fdd1426dda9c2354d12490e7d01e22e'),
            ('05m/chedar_1063_UV05m.sofa', '603531ac6ad48839f41c6f26a3df4817'),
            ('05m/chedar_1064_UV05m.sofa', '9433e39a740c43304e5297ff34abbcbe'),
            ('05m/chedar_1065_UV05m.sofa', '2b235ae6673bc9e5d3ffdd2c62d705b3'),
            ('05m/chedar_1066_UV05m.sofa', '8d69228d32098b0514c8533e1f2c6faf'),
            ('05m/chedar_1067_UV05m.sofa', '27de76e736df99684f81f01e9cff44b0'),
            ('05m/chedar_1068_UV05m.sofa', 'fbb3657a75689815822b88fcc1026ac4'),
            ('05m/chedar_1069_UV05m.sofa', '1e9413f3bfbf3e32fc57609b2758dcea'),
            ('05m/chedar_1070_UV05m.sofa', 'f66d11737a7cd5cee68adfc7f8f1fb2b'),
            ('05m/chedar_1071_UV05m.sofa', '4c807ca2e22a412701a2f61213621334'),
            ('05m/chedar_1072_UV05m.sofa', '3b6853d8628a644200919fedd1bff433'),
            ('05m/chedar_1073_UV05m.sofa', 'b1bf77ecde5c88581f9f8bfee6fbb7a6'),
            ('05m/chedar_1074_UV05m.sofa', '02955f6c8d0b752090ea55c5d8bc8a92'),
            ('05m/chedar_1075_UV05m.sofa', '4d86b532b34a234b61f17fe1b5e8ded3'),
            ('05m/chedar_1076_UV05m.sofa', '546c379abf10f8740f1a1078ce61ce07'),
            ('05m/chedar_1077_UV05m.sofa', '451577d18177dc0d0da97d5e01d0f690'),
            ('05m/chedar_1078_UV05m.sofa', 'aca6ee901191204a92e849885afdd326'),
            ('05m/chedar_1079_UV05m.sofa', '541fa377040c775861725367e5c0fd0d'),
            ('05m/chedar_1080_UV05m.sofa', 'cda55950c11e965b662ba97623b5715c'),
            ('05m/chedar_1081_UV05m.sofa', 'fce7b6b1da4adcfe437d050e58040e37'),
            ('05m/chedar_1082_UV05m.sofa', 'adffafd7c09208c552a1390e9b073636'),
            ('05m/chedar_1083_UV05m.sofa', '3d72ed5dbb84d95aad20f59555ee23b1'),
            ('05m/chedar_1084_UV05m.sofa', 'a035e9c5452ca94897cdbe7f205fa07f'),
            ('05m/chedar_1085_UV05m.sofa', '15997f7b5cddd15210f5077c7cbf44f6'),
            ('05m/chedar_1086_UV05m.sofa', 'a960b369fe3444002b6a5d809ceb60be'),
            ('05m/chedar_1087_UV05m.sofa', '55122f5a5f8b3b808374b2d3f8fafe70'),
            ('05m/chedar_1088_UV05m.sofa', '09a3aff35251fbb18b733ad15e05074b'),
            ('05m/chedar_1089_UV05m.sofa', 'f5ab8207431281874dc5bf38a00953db'),
            ('05m/chedar_1090_UV05m.sofa', 'f2a80b72895a2faf2bf22ec4aef84c7f'),
            ('05m/chedar_1091_UV05m.sofa', 'efb1f99d516f68f3c8d879bbde889e4f'),
            ('05m/chedar_1092_UV05m.sofa', '0901b394c217b0336e79afe1ba9dc6aa'),
            ('05m/chedar_1093_UV05m.sofa', 'e2e693d2cd74dd126994d8a655615c2e'),
            ('05m/chedar_1094_UV05m.sofa', '8dc9dcf84ba17981d435c2221069d0b1'),
            ('05m/chedar_1095_UV05m.sofa', '0720b9a8841477d8f716386c49aa25df'),
            ('05m/chedar_1096_UV05m.sofa', '6c17fbee739df18ac198f44de99c5eab'),
            ('05m/chedar_1097_UV05m.sofa', 'd656d9c4c798bc0c5b1ecafa7d78706f'),
            ('05m/chedar_1098_UV05m.sofa', '620a5005f2671c69a0a5527d08bb90a7'),
            ('05m/chedar_1099_UV05m.sofa', '052e407d2a97ad81a82a0877369f0bd5'),
            ('05m/chedar_1100_UV05m.sofa', '55215e95624fc2053583a3b1bba2887d'),
            ('05m/chedar_1101_UV05m.sofa', 'e3a6c3572f23c71dfd5b37293024cf25'),
            ('05m/chedar_1102_UV05m.sofa', '238d1088f6439a1c46561832e95afef0'),
            ('05m/chedar_1103_UV05m.sofa', '20c2109f8da78bb29fb28f4d77cc866c'),
            ('05m/chedar_1104_UV05m.sofa', 'e1a565d73664148c3f313fe74ef33d62'),
            ('05m/chedar_1105_UV05m.sofa', '275ba79d224167d94e5ca38d24c1187d'),
            ('05m/chedar_1106_UV05m.sofa', 'e6a38543e5518e2af7fa125edcc1c1df'),
            ('05m/chedar_1107_UV05m.sofa', '7d95f21976d521b8272bec5ea374a2b5'),
            ('05m/chedar_1108_UV05m.sofa', 'ef645332c3bb711c78866c46a3205914'),
            ('05m/chedar_1109_UV05m.sofa', '006e68d24216787c2cd45ed4c34123cc'),
            ('05m/chedar_1110_UV05m.sofa', 'cd3d1af6da4498e0a7581a94e945224b'),
            ('05m/chedar_1111_UV05m.sofa', '8a136c7d9f089b30af13f9eff87b58bf'),
            ('05m/chedar_1112_UV05m.sofa', '54ad182d4d22fc15bfd93fcdb64f1562'),
            ('05m/chedar_1113_UV05m.sofa', '6a5983b2ed9127de6e53548fe4fae9f5'),
            ('05m/chedar_1114_UV05m.sofa', '2555bfa4d5181cd8aa627077f814f316'),
            ('05m/chedar_1115_UV05m.sofa', '92f22997f73f137198e5757d23486ebe'),
            ('05m/chedar_1116_UV05m.sofa', 'b2377ac022209c2e97a2e8239ce26a02'),
            ('05m/chedar_1117_UV05m.sofa', 'ba629ef7c2d27076ae51d2019c49b86d'),
            ('05m/chedar_1118_UV05m.sofa', '93b494a6014b2c608e219c83f2bcf797'),
            ('05m/chedar_1119_UV05m.sofa', '62fac988287a921667f57f08f7ca23e2'),
            ('05m/chedar_1120_UV05m.sofa', '87f58d51334b3eaef68a89994d6da5dc'),
            ('05m/chedar_1121_UV05m.sofa', '547daa34e95f82174a16a23681a93017'),
            ('05m/chedar_1122_UV05m.sofa', 'abaeee807c6863b000bc83994d5b5756'),
            ('05m/chedar_1123_UV05m.sofa', 'a4a3cf26d5bac2736648630e19605a3e'),
            ('05m/chedar_1124_UV05m.sofa', '24a41cfe2f19972c236d76bbfcc804ed'),
            ('05m/chedar_1125_UV05m.sofa', 'c079c4016306ce038ce5f48d303e0ef0'),
            ('05m/chedar_1126_UV05m.sofa', '4d95a1e13727e771d2fd051ccf1f8254'),
            ('05m/chedar_1127_UV05m.sofa', 'b1fe986947151dd99a419b2799c20b1d'),
            ('05m/chedar_1128_UV05m.sofa', 'cd91c676bf925692370f46785e82ccc3'),
            ('05m/chedar_1129_UV05m.sofa', '567cf954049c7f6fc8c6ceb4dee451bc'),
            ('05m/chedar_1130_UV05m.sofa', '3107096e07e0ab39953e8cd97016c1e0'),
            ('05m/chedar_1131_UV05m.sofa', 'a78df136615d1da124a0fba0be171f0b'),
            ('05m/chedar_1132_UV05m.sofa', '02a2fd89f88f231e15f88c88efc8ef4c'),
            ('05m/chedar_1133_UV05m.sofa', 'c7179ba6a743553dc9861c369821e3bb'),
            ('05m/chedar_1134_UV05m.sofa', 'b79ea9e797bcced121240fb0ba9195d4'),
            ('05m/chedar_1135_UV05m.sofa', 'dc7cf44aa8141b0d9c4000050ab430a6'),
            ('05m/chedar_1136_UV05m.sofa', 'f617c57bc17e2b21ade80ca2d48bef85'),
            ('05m/chedar_1137_UV05m.sofa', '3c3d5f07719815544e0ab575ed58abf8'),
            ('05m/chedar_1138_UV05m.sofa', '1d504e0a2c24f62fef064f976c8b53fa'),
            ('05m/chedar_1139_UV05m.sofa', '191d7cf6925695ac616b0616f723a488'),
            ('05m/chedar_1140_UV05m.sofa', '269fdecdcef3d83b1532b8ccc35232ec'),
            ('05m/chedar_1141_UV05m.sofa', '3c6a16f754b0fd7d5abb323b92a9b3eb'),
            ('05m/chedar_1142_UV05m.sofa', '853ac61092acc780ec1f65aa5215e988'),
            ('05m/chedar_1143_UV05m.sofa', 'ec2dfc7a11d6c12588ee4e66e067e0b5'),
            ('05m/chedar_1144_UV05m.sofa', '9c006ce3b0998d2510a1a0869d8b44b0'),
            ('05m/chedar_1145_UV05m.sofa', '041a932e1c25864befe8509726f2c750'),
            ('05m/chedar_1146_UV05m.sofa', 'bb76cbc3a5282c79f6e19f9c580868db'),
            ('05m/chedar_1147_UV05m.sofa', '56303dc5fec19e914a170db05f85a8b1'),
            ('05m/chedar_1148_UV05m.sofa', 'f06932abbb13aabe337c58efa16df698'),
            ('05m/chedar_1149_UV05m.sofa', '69e2d133d14456cbf8e47850fed39936'),
            ('05m/chedar_1150_UV05m.sofa', '4a9ed31592d91e119e6506ad3bac4132'),
            ('05m/chedar_1151_UV05m.sofa', '702b65de4e4cdf0ce519378468210585'),
            ('05m/chedar_1152_UV05m.sofa', '54a092b2cf42b8a11f0f6edc40dd249f'),
            ('05m/chedar_1153_UV05m.sofa', '69dec40ebcb4a200ad39ea35450687b7'),
            ('05m/chedar_1154_UV05m.sofa', '057db4c939108a8c23ed17b92ac8da83'),
            ('05m/chedar_1155_UV05m.sofa', '9429508af43ca0dda2196db34ec45faf'),
            ('05m/chedar_1156_UV05m.sofa', 'b5aa392a72059b384f36ad7da408e3dc'),
            ('05m/chedar_1157_UV05m.sofa', '691261e4cdd1f50c5edec2bdb1338d3c'),
            ('05m/chedar_1158_UV05m.sofa', 'a676db8298e01ff91709bf3f042bcaa1'),
            ('05m/chedar_1159_UV05m.sofa', '5d5f2745cf215882d26bb1e9db6b6482'),
            ('05m/chedar_1160_UV05m.sofa', '61ad2058e4fcff1568580cbe3ccef887'),
            ('05m/chedar_1161_UV05m.sofa', '21a8b9277c425123722996c560fbc270'),
            ('05m/chedar_1162_UV05m.sofa', 'c69f3ff3fc61e782af0e63f7f2a476c7'),
            ('05m/chedar_1163_UV05m.sofa', 'aebb95de18a870e5fbc35ab8fa51b576'),
            ('05m/chedar_1164_UV05m.sofa', 'f021ed8f7669b2962abf369e43b2a5a6'),
            ('05m/chedar_1165_UV05m.sofa', 'e4ce05e003064db6f28d6156a35e51fc'),
            ('05m/chedar_1166_UV05m.sofa', '7a16bc15ab71dc21d46a411636e599c9'),
            ('05m/chedar_1167_UV05m.sofa', 'a65698a4130f19cb188b0084681790ec'),
            ('05m/chedar_1168_UV05m.sofa', 'c1871a43fa2afd3de32af3575eec154f'),
            ('05m/chedar_1169_UV05m.sofa', '5effdddf251ed83e9539e8f8471ca89e'),
            ('05m/chedar_1170_UV05m.sofa', '52318c74d46ce55c8ba3456b69336b5e'),
            ('05m/chedar_1171_UV05m.sofa', '63b8837fabb67bdeaf7a61dcb05f76c7'),
            ('05m/chedar_1172_UV05m.sofa', '9caa88534afb020dd5d5eae8b305df5e'),
            ('05m/chedar_1173_UV05m.sofa', 'a1a02385845813b4336b8a426f5df1cf'),
            ('05m/chedar_1174_UV05m.sofa', 'b2d09bbc01a35ad4ca39ee793ad00958'),
            ('05m/chedar_1175_UV05m.sofa', 'c69fdab7d859c454723b73f3fb58610e'),
            ('05m/chedar_1176_UV05m.sofa', 'ff13603d4345971287a216adebe0d1fb'),
            ('05m/chedar_1177_UV05m.sofa', '9541831670062e1bfc0a1d3ab4e1ab0e'),
            ('05m/chedar_1178_UV05m.sofa', 'da2b45f8e60c0dec6e0486055646408a'),
            ('05m/chedar_1179_UV05m.sofa', 'dd5eb86b4ac22d6a41469135553d611d'),
            ('05m/chedar_1180_UV05m.sofa', '12498de59b576bbae9029d7c76499a25'),
            ('05m/chedar_1181_UV05m.sofa', '50186a146907373acf6d34a136f14011'),
            ('05m/chedar_1182_UV05m.sofa', '43bbd985f8f8ad4187e00f879ea20539'),
            ('05m/chedar_1183_UV05m.sofa', '68db5bbb647031e6b615c42f250134ae'),
            ('05m/chedar_1184_UV05m.sofa', '9ad2d9f003e597e9f63dfa6ae8982bf2'),
            ('05m/chedar_1185_UV05m.sofa', 'c4a8f9109768573b17022a0964bbe0e7'),
            ('05m/chedar_1186_UV05m.sofa', 'cbebf536adf6e4dc4f3e30a540f21acb'),
            ('05m/chedar_1187_UV05m.sofa', '13e8f971e239c2f5deb9d64a3d1de6a1'),
            ('05m/chedar_1188_UV05m.sofa', '30b70ec4b1b289e801c419688d6aa26f'),
            ('05m/chedar_1189_UV05m.sofa', 'f7011f56fde8ece059fa6e3259f6e21d'),
            ('05m/chedar_1190_UV05m.sofa', '8591ac94ced1165c5561801cc12d889a'),
            ('05m/chedar_1191_UV05m.sofa', '0eaec85a2fa36ed906ad77ba0374a8dc'),
            ('05m/chedar_1192_UV05m.sofa', '52b991cb69e5d901a7f87eff07f98780'),
            ('05m/chedar_1193_UV05m.sofa', 'bf86a997ed37717de2ce347c3d418c6a'),
            ('05m/chedar_1194_UV05m.sofa', 'cdcec002dce4f6c3bab752aa18e6393b'),
            ('05m/chedar_1195_UV05m.sofa', 'c871f8a9134e1197106f7ad1794cce65'),
            ('05m/chedar_1196_UV05m.sofa', '0d88cc2b366dca63f5b7706a32ec6852'),
            ('05m/chedar_1197_UV05m.sofa', '0827b4203cae42c6bbda908ec85325e6'),
            ('05m/chedar_1198_UV05m.sofa', '85a5f550e650632760087ca421d39e2b'),
            ('05m/chedar_1199_UV05m.sofa', '8bf8bd924a2ac47d2f91df0ba046972d'),
            ('05m/chedar_1200_UV05m.sofa', 'afd1b6a241d158da1df516651c996b85'),
            ('05m/chedar_1201_UV05m.sofa', '282b4dcdeff37e785eca5c3b85510027'),
            ('05m/chedar_1202_UV05m.sofa', 'c3da1432f8fe087e91eee1de8fa4e044'),
            ('05m/chedar_1203_UV05m.sofa', 'dc0d1ec824c2d982a7ab3f185d77448a'),
            ('05m/chedar_1204_UV05m.sofa', 'fc221599746a727ce7aca34f29e8dd78'),
            ('05m/chedar_1205_UV05m.sofa', '07cee5904367bf91a4a90659e9b6aa4e'),
            ('05m/chedar_1206_UV05m.sofa', '66683c1498ed41f1880f86cb470f6de2'),
            ('05m/chedar_1207_UV05m.sofa', 'a56d67fc8bda0f987186b7d52fc1f8e5'),
            ('05m/chedar_1208_UV05m.sofa', 'b328b561dc56184c3caedd6039dab5c5'),
            ('05m/chedar_1209_UV05m.sofa', '89c0760457544b7315e8dcfe2571b3ae'),
            ('05m/chedar_1210_UV05m.sofa', '618c59e0e17da9f1824f96880b629b7f'),
            ('05m/chedar_1211_UV05m.sofa', '3ccb37176c8ffbe19f03fcb02493aa50'),
            ('05m/chedar_1212_UV05m.sofa', 'bcd91087661117be28bf55fe944c7d9b'),
            ('05m/chedar_1213_UV05m.sofa', 'fb101b6780b25a8945e1455aba803d1d'),
            ('05m/chedar_1214_UV05m.sofa', 'dda3be7b594df9c40a88c6ae206b31d4'),
            ('05m/chedar_1215_UV05m.sofa', '375578aea879ddb3659994472274bf43'),
            ('05m/chedar_1216_UV05m.sofa', 'a984808589c678b821269027cabd5e6f'),
            ('05m/chedar_1217_UV05m.sofa', '41ceec29f1eedcd5853a43e690141584'),
            ('05m/chedar_1218_UV05m.sofa', '626540163b0443677ced921da1cafc30'),
            ('05m/chedar_1219_UV05m.sofa', '9c679c72b9216a23a0bcede0015ba9c6'),
            ('05m/chedar_1220_UV05m.sofa', 'd1d91214516c102ac7ac3a92c40ff891'),
            ('05m/chedar_1221_UV05m.sofa', 'c370f41f6985f41496459611e9d76902'),
            ('05m/chedar_1222_UV05m.sofa', '6852989182556144331663122809a340'),
            ('05m/chedar_1223_UV05m.sofa', 'e85e04c5b28e1b87e86ca2203334f7b1'),
            ('05m/chedar_1224_UV05m.sofa', '058fd405e23d3b2cab8c960af946a980'),
            ('05m/chedar_1225_UV05m.sofa', '554b049b1b420825a4b4a9ddeb955aef'),
            ('05m/chedar_1226_UV05m.sofa', 'dfb0154c4ccb2e370a1b88f1fc92f5ee'),
            ('05m/chedar_1227_UV05m.sofa', '1465e85ee8fb5162d632a014a48160ca'),
            ('05m/chedar_1228_UV05m.sofa', 'bd4f3e9d305315e3bc830092829fb5ef'),
            ('05m/chedar_1229_UV05m.sofa', '042f4b1fdddd7334554d5ede95f94f07'),
            ('05m/chedar_1230_UV05m.sofa', 'cb7e77bb08e358007ffde8b76e875e9d'),
            ('05m/chedar_1231_UV05m.sofa', '5cd1078008d22e661b4ae62442c7a515'),
            ('05m/chedar_1232_UV05m.sofa', '97e57d1e8b381aab2ee2f8a3a5d946ef'),
            ('05m/chedar_1233_UV05m.sofa', 'e7ea92b739a208f7b60ac038e53168ca'),
            ('05m/chedar_1234_UV05m.sofa', 'f8714bafc946fe02f4a6d1f038168366'),
            ('05m/chedar_1235_UV05m.sofa', 'd3eecd462c6ce44b76196a1031caea83'),
            ('05m/chedar_1236_UV05m.sofa', '438d64984e35211205675b25dbe89ec3'),
            ('05m/chedar_1237_UV05m.sofa', 'f6884480e45e8928da3a64070eba0be5'),
            ('05m/chedar_1238_UV05m.sofa', '84578c9241de46241298618525d7d4b7'),
            ('05m/chedar_1239_UV05m.sofa', '01891530d0b1fa1bfbc6c2d22baa6637'),
            ('05m/chedar_1240_UV05m.sofa', '712666997e9d2aff1ac84e0113f65657'),
            ('05m/chedar_1241_UV05m.sofa', '6b988522ea98e007e025025065b1b6b8'),
            ('05m/chedar_1242_UV05m.sofa', '24aeb78886b42f1503af147de2d8931a'),
            ('05m/chedar_1243_UV05m.sofa', 'c606eace273b3d72b61a0f88b9622d0b'),
            ('05m/chedar_1244_UV05m.sofa', '53fc8fcb3f036033f86dabb979981d03'),
            ('05m/chedar_1245_UV05m.sofa', '5ed2d1ad710a58c3b8a72aa659ac1fbb'),
            ('05m/chedar_1246_UV05m.sofa', '82947bd508bf487f5043e439c395f64c'),
            ('05m/chedar_1247_UV05m.sofa', '9616088efa249a1f6df83e9de5c95d4e'),
            ('05m/chedar_1248_UV05m.sofa', 'b69f0e8d5bf7032ed889d912d477cdc8'),
            ('05m/chedar_1249_UV05m.sofa', '9aaaf76cf12bb3ce133e5eb70eaeb59a'),
            ('05m/chedar_1250_UV05m.sofa', 'fd67a1e16a5c58f917acb093ff8af46f'),
            ('05m/chedar_1251_UV05m.sofa', '0371a502edf1ecb8e79d18e6102f0d35'),
            ('05m/chedar_1252_UV05m.sofa', '9aef739018fd404cacbd176cb61b2728'),
            ('05m/chedar_1253_UV05m.sofa', '13b82c174cf163679c4bcaccd8b2eaf8'),
        ],
        '1m': [
            ('1m/chedar_0001_UV1m.sofa', '513f7bba41962645c11917227f131166'),
            ('1m/chedar_0002_UV1m.sofa', 'f7efbfe2ce4f3ec516f751adfa5eba57'),
            ('1m/chedar_0003_UV1m.sofa', '5a7425d084074f5f9fb06c6dca263352'),
            ('1m/chedar_0004_UV1m.sofa', 'cb165efa4e20e48733e112f98d97574b'),
            ('1m/chedar_0005_UV1m.sofa', '78e29005c5a188ef887dc7fca58cc04d'),
            ('1m/chedar_0006_UV1m.sofa', 'cdbbc14044cbadce623c27857025094c'),
            ('1m/chedar_0007_UV1m.sofa', 'fc4322f51c9f76a13f1f4e8269a5b6a4'),
            ('1m/chedar_0008_UV1m.sofa', '1a5f50dbc5c91e5aabfd5215c68425e7'),
            ('1m/chedar_0009_UV1m.sofa', '8eeec3f5b8abbb4e172182cf96d98558'),
            ('1m/chedar_0010_UV1m.sofa', '5401badfc80e0ff5dd75594e32680740'),
            ('1m/chedar_0011_UV1m.sofa', '244508ad1d44caab0b4b83ef7549e66f'),
            ('1m/chedar_0012_UV1m.sofa', 'fcd9f720c3fb34f33099935999aa1624'),
            ('1m/chedar_0013_UV1m.sofa', '082140c94783050db5c8caf0bf61861f'),
            ('1m/chedar_0014_UV1m.sofa', 'e4896176ec01e495b0ff64647d432fb6'),
            ('1m/chedar_0015_UV1m.sofa', 'de76af67b7dd5da6b8e8d9df781d4128'),
            ('1m/chedar_0016_UV1m.sofa', '5c05435089f500a3293c13d560577dbe'),
            ('1m/chedar_0017_UV1m.sofa', 'dae0693c50cd93ea188e322ef204d800'),
            ('1m/chedar_0018_UV1m.sofa', '45208969662654740cb9f4e6880d30b4'),
            ('1m/chedar_0019_UV1m.sofa', 'a5a253c05d1c30e9c458795f1b4953ed'),
            ('1m/chedar_0020_UV1m.sofa', 'a3cc6aa907d02ed08c2feedc2682abd7'),
            ('1m/chedar_0021_UV1m.sofa', 'f625dafca26feb87f239fe92d6d94bab'),
            ('1m/chedar_0022_UV1m.sofa', '08ff56c76432af0b15caf886dfd9436c'),
            ('1m/chedar_0023_UV1m.sofa', 'fa8f6d8985b666a56603b3089137a4e0'),
            ('1m/chedar_0024_UV1m.sofa', '53044866522203de4639f3cfeceb114b'),
            ('1m/chedar_0025_UV1m.sofa', '40c8677d510e1da80f8b93864d1dcfcd'),
            ('1m/chedar_0026_UV1m.sofa', 'bcec6561689a4ed7f844ab29ba559216'),
            ('1m/chedar_0027_UV1m.sofa', '1af608bf9d30cac8a03a6889a42f3757'),
            ('1m/chedar_0028_UV1m.sofa', '520c15e0635c35d3417f628bd16f93f8'),
            ('1m/chedar_0029_UV1m.sofa', '2fdf00da6cd76425051ab9d8a42fa4cd'),
            ('1m/chedar_0030_UV1m.sofa', 'a63d05124b0b808d5d3b753da60f6d4f'),
            ('1m/chedar_0031_UV1m.sofa', '8115a2db2fce8979e12cebc4ded3d77a'),
            ('1m/chedar_0032_UV1m.sofa', '18de05b9b1973ebd2d2d2bb63f156047'),
            ('1m/chedar_0033_UV1m.sofa', 'ae875a85b8ed0d36f75b904d21ff2a31'),
            ('1m/chedar_0034_UV1m.sofa', 'af2ac7fbeabd937504410c3e413a0857'),
            ('1m/chedar_0035_UV1m.sofa', '4c73b368d57433eca9a16549879d08a9'),
            ('1m/chedar_0036_UV1m.sofa', '62fe8d9fd0b5ea59070eab84c4d5daf7'),
            ('1m/chedar_0037_UV1m.sofa', 'e3ecdc7f6024043845522b6228560d4d'),
            ('1m/chedar_0038_UV1m.sofa', '31d68070b0c757653de8ac3134d0d0fd'),
            ('1m/chedar_0039_UV1m.sofa', 'de8b78047e3adf8e2c5edce1f5275e53'),
            ('1m/chedar_0040_UV1m.sofa', '82fb3558a73bd2dbbf3019253a846144'),
            ('1m/chedar_0041_UV1m.sofa', '18547a42109486e4a45cd741d0349c70'),
            ('1m/chedar_0042_UV1m.sofa', 'c4d2896c3ed7e304573f35416751adb3'),
            ('1m/chedar_0043_UV1m.sofa', '3cb8a2400f36e1d65906f049dcd8f5ce'),
            ('1m/chedar_0044_UV1m.sofa', '06c1b103177ae695c60eb03d6a13d7a6'),
            ('1m/chedar_0045_UV1m.sofa', 'ea5cdcc6aabd7ec23558dd61fc32764c'),
            ('1m/chedar_0046_UV1m.sofa', '91ed319bcecfedcd6fd894d29f30960a'),
            ('1m/chedar_0047_UV1m.sofa', 'cd49a3719f1303e0be539e61002e276d'),
            ('1m/chedar_0048_UV1m.sofa', 'ab8a5efd8681641185e8e1a4f6d4cf5d'),
            ('1m/chedar_0049_UV1m.sofa', '9454bfbc2c5045aa907a60d3c7af2f1c'),
            ('1m/chedar_0050_UV1m.sofa', 'ddbb228b3c33f6b935f882fb7ac4c6a3'),
            ('1m/chedar_0051_UV1m.sofa', '0774480703f316b0db2afcf6313c119c'),
            ('1m/chedar_0052_UV1m.sofa', 'e512bf980b304c87abc52d47a1164ab5'),
            ('1m/chedar_0053_UV1m.sofa', '1bf0179d05fe607a2dc5910f994a3edf'),
            ('1m/chedar_0054_UV1m.sofa', 'b01328b178d9832ec7b0acef30ca308a'),
            ('1m/chedar_0055_UV1m.sofa', '7c4a6874ae0d0a7e592c75ef34196b81'),
            ('1m/chedar_0056_UV1m.sofa', 'b8d175cc70335b6e71673ba2a45370ed'),
            ('1m/chedar_0057_UV1m.sofa', 'bf3b9c4c2194e94ebfaf25d7a3840c87'),
            ('1m/chedar_0058_UV1m.sofa', '20f573351aac70e22612449e4e554fde'),
            ('1m/chedar_0059_UV1m.sofa', 'b93b1ac4a96288a9af253fe1ea376ba4'),
            ('1m/chedar_0060_UV1m.sofa', '3496f8c35581e7f619a9e43c70632347'),
            ('1m/chedar_0061_UV1m.sofa', '11b72b3efad385441bf39324e0f13022'),
            ('1m/chedar_0062_UV1m.sofa', '2dcdaf45972954ba1ba9aee7c8e53a19'),
            ('1m/chedar_0063_UV1m.sofa', '264c96f47fea5e86e63e6c36b8b0cf63'),
            ('1m/chedar_0064_UV1m.sofa', '79aebbebe52d9c8fdda12ea334dbc03a'),
            ('1m/chedar_0065_UV1m.sofa', 'c2cd38e22de39da66447103bfbcc12f0'),
            ('1m/chedar_0066_UV1m.sofa', 'a08d340f303d799396eef4991335201c'),
            ('1m/chedar_0067_UV1m.sofa', 'b444420dd6af8c00665331e031065b18'),
            ('1m/chedar_0068_UV1m.sofa', '150abd17dfda575e350c5190370d0c5b'),
            ('1m/chedar_0069_UV1m.sofa', '8df25c1c3853bb8efdd4c800dd1de9d3'),
            ('1m/chedar_0070_UV1m.sofa', '22edb94ab098bfa318227665b504dc3e'),
            ('1m/chedar_0071_UV1m.sofa', 'f0d9a7d5300ee8727d4fd85ba59a519b'),
            ('1m/chedar_0072_UV1m.sofa', '8d4459a72ed18a8ade7f2fac16bdd167'),
            ('1m/chedar_0073_UV1m.sofa', 'd1536390bf9125be7383ddf97674b52d'),
            ('1m/chedar_0074_UV1m.sofa', '950b0ddab3acbf396886de09eeeaa225'),
            ('1m/chedar_0075_UV1m.sofa', 'ee275ab6a05cdfd53f5bab005e0ed8cf'),
            ('1m/chedar_0076_UV1m.sofa', 'fad39142ec2fd7bd5e096e76a83fa232'),
            ('1m/chedar_0077_UV1m.sofa', 'e70d19ef90cb6c16ab114ce693964901'),
            ('1m/chedar_0078_UV1m.sofa', '5a0b448ae9d579afd9d6610b38914815'),
            ('1m/chedar_0079_UV1m.sofa', 'ac04857276fdfd2d9a135338796caed1'),
            ('1m/chedar_0080_UV1m.sofa', 'e7d2ce0f723047256dddc1cc75ccf0b8'),
            ('1m/chedar_0081_UV1m.sofa', '5ffe4ee44b9c9f3184a7a037fde4a4e4'),
            ('1m/chedar_0082_UV1m.sofa', 'e83223dd11502b915f72d1e3064c1792'),
            ('1m/chedar_0083_UV1m.sofa', '2846b3da4da5173bab6758eb847c04a3'),
            ('1m/chedar_0084_UV1m.sofa', '2c5a3fada91f5cd9c1df8caea6ea0037'),
            ('1m/chedar_0085_UV1m.sofa', 'b8b0e50b4a7214fe1e3b5ee1ad39d118'),
            ('1m/chedar_0086_UV1m.sofa', '8902d30b5a6fb0bd151ddba616c5d151'),
            ('1m/chedar_0087_UV1m.sofa', '102190790056ab08365cf5ed0d9783c4'),
            ('1m/chedar_0088_UV1m.sofa', '968f6349e3180c9af2fb8f4548c06900'),
            ('1m/chedar_0089_UV1m.sofa', '6f853946c0a3cd98944cf6644397bc01'),
            ('1m/chedar_0090_UV1m.sofa', '2c4795cac49a15741025c47cf857033c'),
            ('1m/chedar_0091_UV1m.sofa', '8f73f816cd0c33e29b93f32f43a224dd'),
            ('1m/chedar_0092_UV1m.sofa', 'afb5ab7952a976db798e997f6246a3fc'),
            ('1m/chedar_0093_UV1m.sofa', '2b2555a806c4aaa445a386d514ba89f7'),
            ('1m/chedar_0094_UV1m.sofa', '41525acd28f01ac591db7da54f125a1f'),
            ('1m/chedar_0095_UV1m.sofa', '721b2a5fb4187a8e58d65f447e824408'),
            ('1m/chedar_0096_UV1m.sofa', 'c8bfee639ffe7409cb2670f49cc6d0a3'),
            ('1m/chedar_0097_UV1m.sofa', 'ef0b4b57e9e5101c349cc8b646b6b6df'),
            ('1m/chedar_0098_UV1m.sofa', '365242bcb24c3405b806593f1e2d94f9'),
            ('1m/chedar_0099_UV1m.sofa', 'f1d35e809729057933aef5421184371f'),
            ('1m/chedar_0100_UV1m.sofa', 'cb3a5122d2b5b20f510a929ccea98f24'),
            ('1m/chedar_0101_UV1m.sofa', 'ae29dfa56face09e48eea8f07231ed68'),
            ('1m/chedar_0102_UV1m.sofa', 'b3505af32d732755b93c3ebae49f7b4e'),
            ('1m/chedar_0103_UV1m.sofa', 'dac5229857f913ed516f0286a4a7fa36'),
            ('1m/chedar_0104_UV1m.sofa', '03ec368ae518010c7755c3fb71399cff'),
            ('1m/chedar_0105_UV1m.sofa', '0e1829ce86a5a8e7058989da402333eb'),
            ('1m/chedar_0106_UV1m.sofa', '221bb30dcba3fb53def4e1a0a9b89ac2'),
            ('1m/chedar_0107_UV1m.sofa', 'ac981bf56a8748bd8841a989e07b6ed7'),
            ('1m/chedar_0108_UV1m.sofa', 'abf2c13cd31b66bc3dba1c0b66acd900'),
            ('1m/chedar_0109_UV1m.sofa', 'b841c95e126b2cb2f199ad650e2905ea'),
            ('1m/chedar_0110_UV1m.sofa', 'c29c384e18694054fb164d1a40e19378'),
            ('1m/chedar_0111_UV1m.sofa', '2fa7792513a819b5bad3729393b43b99'),
            ('1m/chedar_0112_UV1m.sofa', '7a2882acdba67cc8611d1faef2312d0b'),
            ('1m/chedar_0113_UV1m.sofa', '1ca79f1f8bb21ee1940d03b9e79dcc2a'),
            ('1m/chedar_0114_UV1m.sofa', 'ed17e2aa3491fb35506837957ef2d641'),
            ('1m/chedar_0115_UV1m.sofa', '0cb31cb6cbdba96f368065da0d154ef3'),
            ('1m/chedar_0116_UV1m.sofa', '32b5908d3e6041a4d02acf7c5896b8df'),
            ('1m/chedar_0117_UV1m.sofa', 'acf01ae9ca3e253678e72a33605b31f2'),
            ('1m/chedar_0118_UV1m.sofa', 'ea70d1e8514d8f309be76b2148787eeb'),
            ('1m/chedar_0119_UV1m.sofa', 'f226597bb229da689055efafefceb36b'),
            ('1m/chedar_0120_UV1m.sofa', 'cafa16de4cc594452f753fc43035dfa6'),
            ('1m/chedar_0121_UV1m.sofa', 'aecb1f703fbc2904ee5f18533b7b4580'),
            ('1m/chedar_0122_UV1m.sofa', '5777d7e59cfb1ca1eaeb344e2a8bd327'),
            ('1m/chedar_0123_UV1m.sofa', '33f199457b173bb2d3a62b930aa6172f'),
            ('1m/chedar_0124_UV1m.sofa', 'a3e89977e228331087a92883057b914e'),
            ('1m/chedar_0125_UV1m.sofa', '499a142e65d945c2438b3d5678b6a824'),
            ('1m/chedar_0126_UV1m.sofa', 'c93bda0c612838055661781f73c899bd'),
            ('1m/chedar_0127_UV1m.sofa', 'd4f1c368f2fd9ae94185c869b3bb16b5'),
            ('1m/chedar_0128_UV1m.sofa', 'c46744cdb0d7e0284e24c32133a8c9af'),
            ('1m/chedar_0129_UV1m.sofa', '44fd676682cd3a4501a7e11a43d5350f'),
            ('1m/chedar_0130_UV1m.sofa', 'a461b006828018c0747ab36103d79920'),
            ('1m/chedar_0131_UV1m.sofa', '2f885ee357b6ef29b29c99c2276bd072'),
            ('1m/chedar_0132_UV1m.sofa', '4ed2dd9b9d718caf005b1a83d656b231'),
            ('1m/chedar_0133_UV1m.sofa', 'b71b32447295786b8934bfa743e4a402'),
            ('1m/chedar_0134_UV1m.sofa', 'ae5d8eb8ceaa0ede32ce20201e7c0c03'),
            ('1m/chedar_0135_UV1m.sofa', 'f9ad6b8cee9e57da315736137bbc6700'),
            ('1m/chedar_0136_UV1m.sofa', '944a995514745a82408a38d95d7e33b0'),
            ('1m/chedar_0137_UV1m.sofa', '3857457b8aaceb7558f1d6ba6da0129a'),
            ('1m/chedar_0138_UV1m.sofa', '2aa4be20a37302c3d2ee7733c14aef2b'),
            ('1m/chedar_0139_UV1m.sofa', '12992c496cdfbc3fa25cf1428578e35f'),
            ('1m/chedar_0140_UV1m.sofa', '52f9e4ef4fa560ec3aeab9e435bebe69'),
            ('1m/chedar_0141_UV1m.sofa', '82a972b9d04183b9d64b054882c20738'),
            ('1m/chedar_0142_UV1m.sofa', '97ece0bde31dc787b7c6d825214b8394'),
            ('1m/chedar_0143_UV1m.sofa', 'b22548660b21bbd8f09b7b92e17c7e8e'),
            ('1m/chedar_0144_UV1m.sofa', '0385b86286405c9bddf38fa9f425e02b'),
            ('1m/chedar_0145_UV1m.sofa', '67c814f2778fa1764d1fb284910858a0'),
            ('1m/chedar_0146_UV1m.sofa', '47dcec3aeb392338637b04a535085ad7'),
            ('1m/chedar_0147_UV1m.sofa', 'cf0c327e4a403f225e48847e3a7f6754'),
            ('1m/chedar_0148_UV1m.sofa', '25fdef94f817f12d4d032884769532b0'),
            ('1m/chedar_0149_UV1m.sofa', 'bd16f23325218605cd8cfce940cbf5a6'),
            ('1m/chedar_0150_UV1m.sofa', '2630135081f0dfd43f8c1f12ea01c0f8'),
            ('1m/chedar_0151_UV1m.sofa', '48dda985f534cb93fcc1f4cfdb6d18d4'),
            ('1m/chedar_0152_UV1m.sofa', 'ec010f8fa9147a2131732a5d0cfb6556'),
            ('1m/chedar_0153_UV1m.sofa', '8f69e460995e854e31ce392fe339fc55'),
            ('1m/chedar_0154_UV1m.sofa', '7a4c3c22c517c215848a2d7bceabbb8f'),
            ('1m/chedar_0155_UV1m.sofa', '2a6fb66ba8c8b005d7e8830e88321b4a'),
            ('1m/chedar_0156_UV1m.sofa', '760afca7a02eab21b72e8dd3182df176'),
            ('1m/chedar_0157_UV1m.sofa', 'ea273587b3fe36d452e79303085c0848'),
            ('1m/chedar_0158_UV1m.sofa', 'f197e97110428422da1ee77d831e336a'),
            ('1m/chedar_0159_UV1m.sofa', '2132f4f9c88328ff7f7dca3336e09670'),
            ('1m/chedar_0160_UV1m.sofa', '0278a33a85705d739f4d1031f8a1a34c'),
            ('1m/chedar_0161_UV1m.sofa', '80d85f290d34c1231aa7566dfcb6c419'),
            ('1m/chedar_0162_UV1m.sofa', 'b7d75a84af279e2cf5a09e44e037c12b'),
            ('1m/chedar_0163_UV1m.sofa', 'c063cd56658794a1e186c8043e4dcc79'),
            ('1m/chedar_0164_UV1m.sofa', 'eda37e6e90f838eab48c765ca5fa540e'),
            ('1m/chedar_0165_UV1m.sofa', '69e158b3ba204b4f9aa9a88ea95becd1'),
            ('1m/chedar_0166_UV1m.sofa', 'a4f6b3c0316c731b51cfd2978be9a345'),
            ('1m/chedar_0167_UV1m.sofa', '2c6b1d33271baa2c919373761fd2b21e'),
            ('1m/chedar_0168_UV1m.sofa', '9cc23379982727496579e35da4a04eb6'),
            ('1m/chedar_0169_UV1m.sofa', 'bb027766011cd610248dc7406385edd1'),
            ('1m/chedar_0170_UV1m.sofa', '2cbe18b87422035f255d3c49328be837'),
            ('1m/chedar_0171_UV1m.sofa', 'd51ba83f8d9bd6981f7e9cd88c014eef'),
            ('1m/chedar_0172_UV1m.sofa', '316fda81a201c04dbff806a20f99e0e8'),
            ('1m/chedar_0173_UV1m.sofa', 'ae10c7cb9d1c587b4537352312b320ef'),
            ('1m/chedar_0174_UV1m.sofa', 'd51f1da01519af2cd07e62c86f814553'),
            ('1m/chedar_0175_UV1m.sofa', 'cdac56e049fb0ed731f103a392cc4d70'),
            ('1m/chedar_0176_UV1m.sofa', '137114f619b531e5f16eca3d33d7f486'),
            ('1m/chedar_0177_UV1m.sofa', '8fb08150268982c6442a673c6d539314'),
            ('1m/chedar_0178_UV1m.sofa', 'f1fb15f51fcd71e6ab822723a4782dac'),
            ('1m/chedar_0179_UV1m.sofa', 'cfc96569e758cecccf3d2c414935eaa4'),
            ('1m/chedar_0180_UV1m.sofa', 'ba654dfd2f45fb384f3ed049286400ff'),
            ('1m/chedar_0181_UV1m.sofa', '1d5f450eb3ded1f01b5069a4c0c9a34a'),
            ('1m/chedar_0182_UV1m.sofa', 'e2446ea78ae9c6876195fe04125d0162'),
            ('1m/chedar_0183_UV1m.sofa', 'a98f22964fa600046dec08466d4efe9a'),
            ('1m/chedar_0184_UV1m.sofa', 'c7f98f50b67b137e4037335b2a43f628'),
            ('1m/chedar_0185_UV1m.sofa', '663e7c2391473cab84fc542ae20c234c'),
            ('1m/chedar_0186_UV1m.sofa', '8c8969c5752c5dacfa43e71e619f68f6'),
            ('1m/chedar_0187_UV1m.sofa', 'ac46234ad963c2d85ab6421ef76a813a'),
            ('1m/chedar_0188_UV1m.sofa', '6d377d866c2a6c4d72a08929ca806074'),
            ('1m/chedar_0189_UV1m.sofa', 'c6260cc05bd1e34d4a108b9ba604cc8a'),
            ('1m/chedar_0190_UV1m.sofa', 'd7d45c2f459a34d78471c9bdbfa69376'),
            ('1m/chedar_0191_UV1m.sofa', '0e4be1ec414e24f9c2849b62df8fdb53'),
            ('1m/chedar_0192_UV1m.sofa', '6a21e7f1e8eeb9ff49bf5232a009b8b9'),
            ('1m/chedar_0193_UV1m.sofa', '55f21bb0c9278607fbe2d7e936a42312'),
            ('1m/chedar_0194_UV1m.sofa', 'ffc76dfe57e5b1e3e85fe46fa974f931'),
            ('1m/chedar_0195_UV1m.sofa', 'b1fe517445ffd8aa59c2cb4cf3c5a3fb'),
            ('1m/chedar_0196_UV1m.sofa', 'fc0b7391d40a2e82795b034451d870bf'),
            ('1m/chedar_0197_UV1m.sofa', '2f3fb08c607330cf73ff8bb4c8440d71'),
            ('1m/chedar_0198_UV1m.sofa', '884703a9eeaaeb7ed3b9b248282c141a'),
            ('1m/chedar_0199_UV1m.sofa', '7598ba7d1e4be015cd36caaa9711a171'),
            ('1m/chedar_0200_UV1m.sofa', '07828c08f79c0c59a7e0eb3821d6d6c3'),
            ('1m/chedar_0201_UV1m.sofa', 'f1bb60e6f8d7db30d63bf5165488825e'),
            ('1m/chedar_0202_UV1m.sofa', '3198f1692f6597b7846bc96bbeb2af95'),
            ('1m/chedar_0203_UV1m.sofa', '889184c14835f5b0e92b6a0297536cfd'),
            ('1m/chedar_0204_UV1m.sofa', '3e79a09376f7c797d0d483ef0608fd48'),
            ('1m/chedar_0205_UV1m.sofa', 'f601ef7cd7af5ad6d68cf70a53c9cf47'),
            ('1m/chedar_0206_UV1m.sofa', '17dc520f50bf9645f189078b6d3bb533'),
            ('1m/chedar_0207_UV1m.sofa', 'eca01e13b03bd11d3fb2a694b50d6659'),
            ('1m/chedar_0208_UV1m.sofa', '87c2ee6b68eba370d3a3850b7a46cf1e'),
            ('1m/chedar_0209_UV1m.sofa', 'd8b56d96f9e942500c92d2ca1ed4dd4d'),
            ('1m/chedar_0210_UV1m.sofa', '22c7c815901723095e894a55eb7bdf1b'),
            ('1m/chedar_0211_UV1m.sofa', '17e0441443646974b103cfe9ac8779fe'),
            ('1m/chedar_0212_UV1m.sofa', 'ce1d9f7bdd75d6c14aa0226e5be42f00'),
            ('1m/chedar_0213_UV1m.sofa', '85509cd45db6b8746dc5db8f33de684b'),
            ('1m/chedar_0214_UV1m.sofa', '2620b76460d38aeaf443fc87366f8c0c'),
            ('1m/chedar_0215_UV1m.sofa', '6c69e2aa4b3bafc338d2609465314b68'),
            ('1m/chedar_0216_UV1m.sofa', '9f7941d5af3fde967e67f7834c1a1594'),
            ('1m/chedar_0217_UV1m.sofa', 'b2ac0f05d48d2e7143bdcd518bf99090'),
            ('1m/chedar_0218_UV1m.sofa', 'a4b4b5fd884bd7e418e1209ccb351cda'),
            ('1m/chedar_0219_UV1m.sofa', '7a110e2b48b8ea8b55517f1471d5ad3b'),
            ('1m/chedar_0220_UV1m.sofa', '423aa49f7db968a5358d3e01ca642374'),
            ('1m/chedar_0221_UV1m.sofa', 'ec474c6862bdbe59e4ead50f3a646adc'),
            ('1m/chedar_0222_UV1m.sofa', '3c3b761487ba8637da6b98fc86da3723'),
            ('1m/chedar_0223_UV1m.sofa', '831dfd1f6dbfcfa614c1bae5b3fbeafe'),
            ('1m/chedar_0224_UV1m.sofa', '09c68116737b7448fdb0e01ed408b20b'),
            ('1m/chedar_0225_UV1m.sofa', 'fb02d15ec017223730cdeada4e613178'),
            ('1m/chedar_0226_UV1m.sofa', 'f1e0bbd532158ae824c44d35ae60ab8e'),
            ('1m/chedar_0227_UV1m.sofa', 'eb0e2e8ce5dac5162af428cf279cb147'),
            ('1m/chedar_0228_UV1m.sofa', 'f6da82527c96ed6685533796db856e16'),
            ('1m/chedar_0229_UV1m.sofa', 'a58318ea202a0baa18172acbce8cd333'),
            ('1m/chedar_0230_UV1m.sofa', 'd98051e736377c76dbd667fbeb960269'),
            ('1m/chedar_0231_UV1m.sofa', '2e05fc9e486a6a69fa21a8556e5d577f'),
            ('1m/chedar_0232_UV1m.sofa', 'b05bad67b8042a9ac63ffc77644d5aac'),
            ('1m/chedar_0233_UV1m.sofa', 'a66bd209da3484260838ab6df51f65cc'),
            ('1m/chedar_0234_UV1m.sofa', '24bb50b2cd88fad4185fbc5617e7e86f'),
            ('1m/chedar_0235_UV1m.sofa', '501c8b0e5f1063d2e7fefa98e6be192a'),
            ('1m/chedar_0236_UV1m.sofa', '37572dc765cf9dba75d6d90fa2181791'),
            ('1m/chedar_0237_UV1m.sofa', '26d476c592a0fa793f8942e1a14f0052'),
            ('1m/chedar_0238_UV1m.sofa', '188323b0acc23d0709c24eb4683cb5c3'),
            ('1m/chedar_0239_UV1m.sofa', '1b3cedc0f6ef02ba883684c84860c614'),
            ('1m/chedar_0240_UV1m.sofa', '850f10f78c4dbcab228cdce965281d14'),
            ('1m/chedar_0241_UV1m.sofa', '95608dc67201e4bd04ab1743a82e891d'),
            ('1m/chedar_0242_UV1m.sofa', 'edf2ed58d48a47c1f5fe8f612877dc86'),
            ('1m/chedar_0243_UV1m.sofa', '0d19b31f2ec5fe707cc0128e15a245da'),
            ('1m/chedar_0244_UV1m.sofa', 'd6a783073d89e52e89b20a2538af1530'),
            ('1m/chedar_0245_UV1m.sofa', '8c5d891f6f49f11d08f5baf4df9804af'),
            ('1m/chedar_0246_UV1m.sofa', 'e3eca0315ef04b7c9e99ffd762d52625'),
            ('1m/chedar_0247_UV1m.sofa', 'e1fc125b51c3ad2ab61332cbd1415240'),
            ('1m/chedar_0248_UV1m.sofa', '9812694250ade3bff14e616bb6109281'),
            ('1m/chedar_0249_UV1m.sofa', '96f1585bffc3deea0c7e738dd71cd4a0'),
            ('1m/chedar_0250_UV1m.sofa', '2f53e3da442c6fae2b243021cc9ceb0c'),
            ('1m/chedar_0251_UV1m.sofa', 'f3eaabdeea165e25e039477d89376012'),
            ('1m/chedar_0252_UV1m.sofa', '37347e93cb1dd26fc4601a60a2e0e02c'),
            ('1m/chedar_0253_UV1m.sofa', 'a78515973ec78eadb44b45f3f91a8c7e'),
            ('1m/chedar_0254_UV1m.sofa', '217fca95600d93fe3015696b003200fb'),
            ('1m/chedar_0255_UV1m.sofa', 'd76d2e5be4bbc0b36b9136c5d9300b23'),
            ('1m/chedar_0256_UV1m.sofa', '273dbc39a9826cec437ad2eb455552a3'),
            ('1m/chedar_0257_UV1m.sofa', 'ea95af90bb065d979d650fd1f309cb75'),
            ('1m/chedar_0258_UV1m.sofa', 'f0d8ce028eed04ab420cbc22ad1ce10c'),
            ('1m/chedar_0259_UV1m.sofa', 'edf31040c32f5c89f29a618f6cc2277e'),
            ('1m/chedar_0260_UV1m.sofa', 'a8cb325bc4cd98c4f2bbe8b6bfc95126'),
            ('1m/chedar_0261_UV1m.sofa', 'd604d3c80aed136c917089d3cb971b76'),
            ('1m/chedar_0262_UV1m.sofa', 'be85e47b2b58a1e1d49c75fe1e47eb2d'),
            ('1m/chedar_0263_UV1m.sofa', 'aecdb6648cb3aba5cb6cda86a8ef090d'),
            ('1m/chedar_0264_UV1m.sofa', 'c83b89a08d5317a051072720e56d13d8'),
            ('1m/chedar_0265_UV1m.sofa', 'aaa1000cb11bebfeca85430da1084265'),
            ('1m/chedar_0266_UV1m.sofa', 'b92066ce07a57c0816adc55051603c7c'),
            ('1m/chedar_0267_UV1m.sofa', '3b2e4df8fe3eb525134a0c3b06d139da'),
            ('1m/chedar_0268_UV1m.sofa', '72c5856e62d801da9dcd6ba56bc9461a'),
            ('1m/chedar_0269_UV1m.sofa', '4db3fa09f719272ed9a698751ed1862d'),
            ('1m/chedar_0270_UV1m.sofa', '157ee1b7df6bded5961d862ed2b59eca'),
            ('1m/chedar_0271_UV1m.sofa', '1e76046b0e25810459e96330c09d12f5'),
            ('1m/chedar_0272_UV1m.sofa', '8941d73c00a939fc8d9044741e849c3b'),
            ('1m/chedar_0273_UV1m.sofa', '6524c8b59fb0f0e3a8c3c3205dde0dec'),
            ('1m/chedar_0274_UV1m.sofa', '600be1349b963ba78f723c449b47d47b'),
            ('1m/chedar_0275_UV1m.sofa', 'e80ce75c2e05da567771f960cf2ef0db'),
            ('1m/chedar_0276_UV1m.sofa', '2812ab34ebee77d3f835e32becc56f4d'),
            ('1m/chedar_0277_UV1m.sofa', '80fc249c12c512af49de03f94427cb1c'),
            ('1m/chedar_0278_UV1m.sofa', '956ed66335112af40f74f845f26474b7'),
            ('1m/chedar_0279_UV1m.sofa', '6dccf68b844a7bcf4e836f222bd2e120'),
            ('1m/chedar_0280_UV1m.sofa', '2ff3668139d6c111831713e4afd362af'),
            ('1m/chedar_0281_UV1m.sofa', '6f004c31f2c229b175dffd05d7c33b9b'),
            ('1m/chedar_0282_UV1m.sofa', 'b50f1374c6cf489f17b8af831436f7bb'),
            ('1m/chedar_0283_UV1m.sofa', '21fcca3528623cc62c368b8e8e992a2f'),
            ('1m/chedar_0284_UV1m.sofa', '5d4ccd0e1cd85c86d5a0cd053ca5938e'),
            ('1m/chedar_0285_UV1m.sofa', '2bc58c514ffd110f4f9708c2b3e464af'),
            ('1m/chedar_0286_UV1m.sofa', '211432b1cea2720925c178b0acfcaf95'),
            ('1m/chedar_0287_UV1m.sofa', '42375a50b5088878d1c073dda98f9f1b'),
            ('1m/chedar_0288_UV1m.sofa', 'ef8e472b92f1bcc0987c42c442b1a36e'),
            ('1m/chedar_0289_UV1m.sofa', '4694d7e3b4173c1cfed9e93f50d280d7'),
            ('1m/chedar_0290_UV1m.sofa', '9f245b8700bc76b5cd1c4eaeec329b05'),
            ('1m/chedar_0291_UV1m.sofa', '7711d5aa2d82ff403b20390fce742504'),
            ('1m/chedar_0292_UV1m.sofa', '48f56cdee8cd8430494d36be21a03952'),
            ('1m/chedar_0293_UV1m.sofa', 'f363eadc44095f194d7ffb81b5c30b67'),
            ('1m/chedar_0294_UV1m.sofa', 'f52640cd75ccd08ab2c821faf3d62cba'),
            ('1m/chedar_0295_UV1m.sofa', '5caff6b7138fa9b776ac0120b0c3db39'),
            ('1m/chedar_0296_UV1m.sofa', 'efc92186e40983757c0e3000d5f0169a'),
            ('1m/chedar_0297_UV1m.sofa', '1b9575e6500b8eaadc64d5fdf71111fe'),
            ('1m/chedar_0298_UV1m.sofa', '17e98a098fab1629fe6ec724aed85506'),
            ('1m/chedar_0299_UV1m.sofa', '8b27457beb9af494887c160d901e4a33'),
            ('1m/chedar_0300_UV1m.sofa', 'd9eed7ea3af08d0ff024a80bc045a23b'),
            ('1m/chedar_0301_UV1m.sofa', 'c6bf6053fc5bf1c18103238c64ecc03f'),
            ('1m/chedar_0302_UV1m.sofa', 'f4947099accb5a489097eff4c13c284a'),
            ('1m/chedar_0303_UV1m.sofa', '24ef0ad6ae098b7a2f60e0845adc1e92'),
            ('1m/chedar_0304_UV1m.sofa', '5319c42cc8b97cb3eb1ae455a5dabf1d'),
            ('1m/chedar_0305_UV1m.sofa', 'c54aa88c91f7974b6ff0db41c5c6fa4c'),
            ('1m/chedar_0306_UV1m.sofa', '42c2dd832a67b4acf6f4e7a40a687629'),
            ('1m/chedar_0307_UV1m.sofa', 'a665064f19fbc51d0d38945672c19dfd'),
            ('1m/chedar_0308_UV1m.sofa', '3cec8c535f27ea0a1f8c8f6bd3cd161f'),
            ('1m/chedar_0309_UV1m.sofa', '23bdcb8df36b27585b2fbcbc5aa2c4be'),
            ('1m/chedar_0310_UV1m.sofa', '5c628ace53f27e554e44b09668ca32c3'),
            ('1m/chedar_0311_UV1m.sofa', '04e975e468667cb36cbb1debdbc75a41'),
            ('1m/chedar_0312_UV1m.sofa', '59b613e0145ffe4ac476996ce9ba1f3e'),
            ('1m/chedar_0313_UV1m.sofa', '0490bac4fb5c864d87a7fc2105a8e2f4'),
            ('1m/chedar_0314_UV1m.sofa', '5f021c838c2e8597e9f7bc931a3e097e'),
            ('1m/chedar_0315_UV1m.sofa', '9de32637d49f11a638d979091dbbf9f4'),
            ('1m/chedar_0316_UV1m.sofa', '3a2b5dc9cb05a8c896989df4855a1d18'),
            ('1m/chedar_0317_UV1m.sofa', '6f574f0c4dec661a701ee4b08e53e4dd'),
            ('1m/chedar_0318_UV1m.sofa', '903074f864de42c42abee3a25391b500'),
            ('1m/chedar_0319_UV1m.sofa', 'f45e11ff255711ecd34f1be33a1fabd4'),
            ('1m/chedar_0320_UV1m.sofa', 'da3384f09dd7cacb24834a132069f11c'),
            ('1m/chedar_0321_UV1m.sofa', 'ad859f8abb927d432b82809f406767c2'),
            ('1m/chedar_0322_UV1m.sofa', '5cdea380e09e105b01dadabe9a0715f1'),
            ('1m/chedar_0323_UV1m.sofa', '637108b25d1023c0953dd57cd7dae539'),
            ('1m/chedar_0324_UV1m.sofa', 'b80d8bd4ba01a81a97b406e45c0456f4'),
            ('1m/chedar_0325_UV1m.sofa', 'daa26243611cf466b19058a78f18cf00'),
            ('1m/chedar_0326_UV1m.sofa', 'a4b0311601897ae389f8ef6372919186'),
            ('1m/chedar_0327_UV1m.sofa', '27700834d9ed36c465219e635cd297f5'),
            ('1m/chedar_0328_UV1m.sofa', 'feaa078a82bf9797bf87ab6a4e789cd3'),
            ('1m/chedar_0329_UV1m.sofa', 'c5b11956b67b4c0e9a9201a2e2b386f2'),
            ('1m/chedar_0330_UV1m.sofa', 'ad16859e39b1dac3e1d6cb9ad21e096d'),
            ('1m/chedar_0331_UV1m.sofa', '0da58350a4b1d4287f7deaac023418be'),
            ('1m/chedar_0332_UV1m.sofa', '70a7d2bfad6b7cc65725b2ab6301d917'),
            ('1m/chedar_0333_UV1m.sofa', 'f88146609fe432b35b752a6f63fbb56f'),
            ('1m/chedar_0334_UV1m.sofa', '99eb6cebbf5a5a92f882e11747127327'),
            ('1m/chedar_0335_UV1m.sofa', 'bc4309b4c42f0cf774c5f0428c81e47f'),
            ('1m/chedar_0336_UV1m.sofa', '3c7cc53b11d6ca6e29750d81255f63b3'),
            ('1m/chedar_0337_UV1m.sofa', '3f8a0438b8489eccd89416efba1eb806'),
            ('1m/chedar_0338_UV1m.sofa', '2653fb78f0cb64c777992f3d4af66c2b'),
            ('1m/chedar_0339_UV1m.sofa', '3ae395f7ac8432df07f42966ef21f9af'),
            ('1m/chedar_0340_UV1m.sofa', '6e1d6d876239fb13fcfac38c10b4b30d'),
            ('1m/chedar_0341_UV1m.sofa', 'ca74955c2d44d6a1ddb357086628817b'),
            ('1m/chedar_0342_UV1m.sofa', '99317e9d05628b205768e135c01950cc'),
            ('1m/chedar_0343_UV1m.sofa', '8ad7e9019c4cd0203f895ddf75933710'),
            ('1m/chedar_0344_UV1m.sofa', 'a2720ba423a2ab0ae9ccd4e082753c91'),
            ('1m/chedar_0345_UV1m.sofa', '3958ca3194d6f3d973791f16c66fac7b'),
            ('1m/chedar_0346_UV1m.sofa', 'ee6e2637cd76ddfb32cfe670b3845c1d'),
            ('1m/chedar_0347_UV1m.sofa', 'ce57194b80dd59b621472b83eaa0bb52'),
            ('1m/chedar_0348_UV1m.sofa', '97707f52a3212ec7d79b543477b5bf3e'),
            ('1m/chedar_0349_UV1m.sofa', '383dfca3bd4f74becf3d7c0f48df0f32'),
            ('1m/chedar_0350_UV1m.sofa', '3c8def73f98b3d32eba45e29c2d7465f'),
            ('1m/chedar_0351_UV1m.sofa', 'bcf51a1ec174538d35ff90506cac4484'),
            ('1m/chedar_0352_UV1m.sofa', '858168405c7bf7667f45b89492902914'),
            ('1m/chedar_0353_UV1m.sofa', 'f77a21521ac93aef6a8fcd5633d4481b'),
            ('1m/chedar_0354_UV1m.sofa', '7fc2de948141780bd66b7ba2c395b33c'),
            ('1m/chedar_0355_UV1m.sofa', '7a94a463185b3b367017a7406b4c06ab'),
            ('1m/chedar_0356_UV1m.sofa', '0fa76c8aae3cb0e134ad9a73ed9cf21b'),
            ('1m/chedar_0357_UV1m.sofa', 'b1d52eb290d082eac508d98adddf7dfa'),
            ('1m/chedar_0358_UV1m.sofa', 'fc702cd061efb9a1cc4efe3160d2f0e0'),
            ('1m/chedar_0359_UV1m.sofa', '8dfe91b777c4310634647651bd0ed03b'),
            ('1m/chedar_0360_UV1m.sofa', '8d62c1957855f415c7dedd3af16efca7'),
            ('1m/chedar_0361_UV1m.sofa', '900ffd3435f24f1c279a332da47c99ef'),
            ('1m/chedar_0362_UV1m.sofa', '88c8ff0327888164c61a9b2981f57618'),
            ('1m/chedar_0363_UV1m.sofa', '26097c4fa2e3783f13525f9bba826867'),
            ('1m/chedar_0364_UV1m.sofa', '3cc5b60307483457de933edf02b794ec'),
            ('1m/chedar_0365_UV1m.sofa', 'b45a9f51063b2fa797ea65a80a2d95d0'),
            ('1m/chedar_0366_UV1m.sofa', '0151754ea79f8b0b5a54b73eb61e156a'),
            ('1m/chedar_0367_UV1m.sofa', '6d9467ff6fd01c2751994856401cb6e7'),
            ('1m/chedar_0368_UV1m.sofa', '5652858c57e2ba00e4e79e9303526c58'),
            ('1m/chedar_0369_UV1m.sofa', 'd76756e4ccae5999b894f776a4b8bc9c'),
            ('1m/chedar_0370_UV1m.sofa', 'fa307d3183c66357965fcf859f681f11'),
            ('1m/chedar_0371_UV1m.sofa', '7e21a20ba118be120f7597309d39d79e'),
            ('1m/chedar_0372_UV1m.sofa', 'a2edae77d9df57bc3666bba4fdbefc67'),
            ('1m/chedar_0373_UV1m.sofa', 'c49e8301e242bb5c5a9916b5ceede8dc'),
            ('1m/chedar_0374_UV1m.sofa', 'd437ddaf6234f5986d2fcba110dfee0d'),
            ('1m/chedar_0375_UV1m.sofa', 'ebb2c4071dc02102546e417692cb9091'),
            ('1m/chedar_0376_UV1m.sofa', 'c050fcd108ebab21ba88a8210fe08ac7'),
            ('1m/chedar_0377_UV1m.sofa', 'dd21ee2e0406ab27f93546ab4d6f9a2d'),
            ('1m/chedar_0378_UV1m.sofa', '28923799e21c394584f603e5e23967e7'),
            ('1m/chedar_0379_UV1m.sofa', 'adcec3fc127059a2e7b05d4f7e5a3c8f'),
            ('1m/chedar_0380_UV1m.sofa', '7a0e7c8c3fe66d6e838fa7a590375b90'),
            ('1m/chedar_0381_UV1m.sofa', 'd4492da634f7490c7aa17a8b0fcf33f7'),
            ('1m/chedar_0382_UV1m.sofa', 'a2e2f315f24040ea7fd74fcf76ca6647'),
            ('1m/chedar_0383_UV1m.sofa', '630cd58b48c7259183cb80f0b242e11f'),
            ('1m/chedar_0384_UV1m.sofa', '007ec7e0c8a3d78dabb87b4f19becdb3'),
            ('1m/chedar_0385_UV1m.sofa', '6b7b1fb7c64117d85b59b67d32ce0ee5'),
            ('1m/chedar_0386_UV1m.sofa', 'a8a5752244d52acd863d30b7e407dfa2'),
            ('1m/chedar_0387_UV1m.sofa', 'b5bdd0ec3def51791dd8712e5c37ee02'),
            ('1m/chedar_0388_UV1m.sofa', '51d757661d343399e53a4eb15534d241'),
            ('1m/chedar_0389_UV1m.sofa', '85a6ad9b19ea0c3d7cb52561d4a17248'),
            ('1m/chedar_0390_UV1m.sofa', 'ebee24ebd2f05e8dfdb985c0a53f8fcd'),
            ('1m/chedar_0391_UV1m.sofa', '078193684809685b6930c621740645cb'),
            ('1m/chedar_0392_UV1m.sofa', 'f0e7163e7e02a4eb67d3ba80297ea834'),
            ('1m/chedar_0393_UV1m.sofa', '3765f16c1375ea261878131e7e83847c'),
            ('1m/chedar_0394_UV1m.sofa', '423d7c92ee32f5dbfd66112cac3b59e9'),
            ('1m/chedar_0395_UV1m.sofa', '5c052cbfde9529d5ed98ec52743c08e0'),
            ('1m/chedar_0396_UV1m.sofa', 'dcb7a01f28e3a2cc8a145164c05967a7'),
            ('1m/chedar_0397_UV1m.sofa', '4533588db7c764e29d1454e0ee3f4fba'),
            ('1m/chedar_0398_UV1m.sofa', '516f8d358ac0fe64f21eb3a50ed25979'),
            ('1m/chedar_0399_UV1m.sofa', '7628d76d7871ac336fb4c63d8fd94524'),
            ('1m/chedar_0400_UV1m.sofa', 'ca9b255bfb0ab0d11e6b6e327a1f4cf7'),
            ('1m/chedar_0401_UV1m.sofa', 'b3275c2f993454545a57a97c1f4d4d85'),
            ('1m/chedar_0402_UV1m.sofa', '2f6ebd297144a942b2e4d3b2c147210c'),
            ('1m/chedar_0403_UV1m.sofa', '2a69ddae38c4c54579079c215c708b91'),
            ('1m/chedar_0404_UV1m.sofa', 'd5d4c7586336e1cd91d65feeafcdabe8'),
            ('1m/chedar_0405_UV1m.sofa', '6c94e2268c87f69fb1bb47a94bfd7d51'),
            ('1m/chedar_0406_UV1m.sofa', '203ab391ae4598d8fcc97d5af97120f3'),
            ('1m/chedar_0407_UV1m.sofa', '94c584ba950549569c9faf3ca73cfdce'),
            ('1m/chedar_0408_UV1m.sofa', 'cb082a7daf36db788f00c2ef59e9eea7'),
            ('1m/chedar_0409_UV1m.sofa', '6a77a00a0457ba5f29e9b120997b60fc'),
            ('1m/chedar_0410_UV1m.sofa', 'dbf9ff1ea75e8b0b69834ba912d735e1'),
            ('1m/chedar_0411_UV1m.sofa', 'ea041db080895d97e7d527758395806c'),
            ('1m/chedar_0412_UV1m.sofa', '22f732f9db34614e49152ca7812df937'),
            ('1m/chedar_0413_UV1m.sofa', '11ce13710d5ec18708f84a568771604b'),
            ('1m/chedar_0414_UV1m.sofa', 'ccddd341605db346e4af16cccc5c3019'),
            ('1m/chedar_0415_UV1m.sofa', '8d447280e50c460ec084202ed4301c57'),
            ('1m/chedar_0416_UV1m.sofa', 'bda2db65ba75f55aeb99d8da846f5e1c'),
            ('1m/chedar_0417_UV1m.sofa', '9a97762be8743a476a107bbf967b4be6'),
            ('1m/chedar_0418_UV1m.sofa', '1111f0a6072b6b6ee0873a2717490605'),
            ('1m/chedar_0419_UV1m.sofa', 'f42f03cb1724ed63ebf8e3a05a10fc82'),
            ('1m/chedar_0420_UV1m.sofa', '0913e3561d0c94e930b520e589569b13'),
            ('1m/chedar_0421_UV1m.sofa', '14f07fdad8b5aeac92bda4220b6c3a28'),
            ('1m/chedar_0422_UV1m.sofa', '9e16fed73ad6f86729898b026d4a70af'),
            ('1m/chedar_0423_UV1m.sofa', '60705a5e60212ec7713a0dbbe82c3c14'),
            ('1m/chedar_0424_UV1m.sofa', 'c31172c15326b94c1109695ca7f6db73'),
            ('1m/chedar_0425_UV1m.sofa', 'c3e15387f0dad52336c6f1d468cc4fea'),
            ('1m/chedar_0426_UV1m.sofa', '86bd96d7ff95b21a5c38b2e2bf021d15'),
            ('1m/chedar_0427_UV1m.sofa', '24135bddcff53cccd527f34e8fd55c8a'),
            ('1m/chedar_0428_UV1m.sofa', '41a7c77fb66d664c64d9ef9025f871ef'),
            ('1m/chedar_0429_UV1m.sofa', '36beaeb30ae894412fa4e8db76c358c8'),
            ('1m/chedar_0430_UV1m.sofa', 'da912cf7c0d1efcb6d0ac096a6c10336'),
            ('1m/chedar_0431_UV1m.sofa', '5c9590979daed3082d20ef4d268152e8'),
            ('1m/chedar_0432_UV1m.sofa', 'f3ee5cf41a3add4fdf177123bda181dc'),
            ('1m/chedar_0433_UV1m.sofa', 'b6044627e847b29264746dc5de603093'),
            ('1m/chedar_0434_UV1m.sofa', '6d0cb6de4dcf598b51eb6379a619885e'),
            ('1m/chedar_0435_UV1m.sofa', '09565e3651583e4554a81e05acd77b0d'),
            ('1m/chedar_0436_UV1m.sofa', 'fe2d3280747c3b0c30d0ff24efc86803'),
            ('1m/chedar_0437_UV1m.sofa', '03da11efa482338ace87c43e7d456f23'),
            ('1m/chedar_0438_UV1m.sofa', '952f4663973d5b9b6467b8b97c0c4e61'),
            ('1m/chedar_0439_UV1m.sofa', '6b41e24c601086c962e677e72a307a16'),
            ('1m/chedar_0440_UV1m.sofa', '3d0c9cf9e7fd604d1017783ab63c5ebb'),
            ('1m/chedar_0441_UV1m.sofa', '28b837aa2d87dbde6accf68ae56920c9'),
            ('1m/chedar_0442_UV1m.sofa', '48ab30772cc6119e3415e4d4be25ba45'),
            ('1m/chedar_0443_UV1m.sofa', 'add403d9d55ddc79cd2e6d21f7cb57fc'),
            ('1m/chedar_0444_UV1m.sofa', 'c80f2729714b8b309565e4b8ecd21766'),
            ('1m/chedar_0445_UV1m.sofa', 'c75746f2c5b37052ba09904f487c67ff'),
            ('1m/chedar_0446_UV1m.sofa', '0151b079f46c8632f9acff016daaeb18'),
            ('1m/chedar_0447_UV1m.sofa', '9be00659a2742871a78afd4bb401a475'),
            ('1m/chedar_0448_UV1m.sofa', 'd45c55c82f9a920b14248c650f53b098'),
            ('1m/chedar_0449_UV1m.sofa', '99f061016c7602ce7f8bf429bb395e38'),
            ('1m/chedar_0450_UV1m.sofa', 'daad9727d077c205ced9d92167943618'),
            ('1m/chedar_0451_UV1m.sofa', '9ec83f6d640d24e9790b8395c3b3ab19'),
            ('1m/chedar_0452_UV1m.sofa', 'bf43cdc98fc29f2000d543813d9b067d'),
            ('1m/chedar_0453_UV1m.sofa', '411d696ac4dbd40266dda3d1deb448f4'),
            ('1m/chedar_0454_UV1m.sofa', '6fbba513a7c84c3d8511310daa887e5f'),
            ('1m/chedar_0455_UV1m.sofa', '79cc4285fca791a5b7d32cbfe5c4bd4d'),
            ('1m/chedar_0456_UV1m.sofa', 'b8159fc0a5a7549eda02933dfa4a912e'),
            ('1m/chedar_0457_UV1m.sofa', '8a43f79974a1358d706293ba6e28a49e'),
            ('1m/chedar_0458_UV1m.sofa', '61a2398a32b5984e16fef88e12327180'),
            ('1m/chedar_0459_UV1m.sofa', 'fcef6ec4a2727d5fe47a871e09f42106'),
            ('1m/chedar_0460_UV1m.sofa', 'f17425340aef523ccaee3a1debc2950d'),
            ('1m/chedar_0461_UV1m.sofa', '39e835349e8a09ba6bd5bdccb423f326'),
            ('1m/chedar_0462_UV1m.sofa', 'e1caf289e30e806dd71ddb334b13d0b7'),
            ('1m/chedar_0463_UV1m.sofa', 'c6ed1820e929d053ff8ab8b5d98eb3e4'),
            ('1m/chedar_0464_UV1m.sofa', 'c094291eeafd870b01f0d56ab2126831'),
            ('1m/chedar_0465_UV1m.sofa', 'a9a7b4dfd222bb032ccfea60be814a19'),
            ('1m/chedar_0466_UV1m.sofa', '8e33f9016b29dac57d47a6bb3f700b30'),
            ('1m/chedar_0467_UV1m.sofa', 'a122d89684b50ca8417910f7720af855'),
            ('1m/chedar_0468_UV1m.sofa', 'fd3fc9820a2777b00cdc336dccfe05b7'),
            ('1m/chedar_0469_UV1m.sofa', '885db6e39a9d8ef3af834f12b914bf4c'),
            ('1m/chedar_0470_UV1m.sofa', '94df56fafaf80fbeb64f1002d2a7d2f8'),
            ('1m/chedar_0471_UV1m.sofa', '1f9205b860f76613734dfdaa4bb1b39b'),
            ('1m/chedar_0472_UV1m.sofa', '4b3efcda8a57c6b8541aae8b8ef08946'),
            ('1m/chedar_0473_UV1m.sofa', 'd3a76e080231bdff2f9c286a637f5643'),
            ('1m/chedar_0474_UV1m.sofa', '47d75977ee1937cafe27ab298155447c'),
            ('1m/chedar_0475_UV1m.sofa', 'd4986f4313bb6ca051a29de572c85922'),
            ('1m/chedar_0476_UV1m.sofa', 'a3e639d84f7092868b9c94351cd1360b'),
            ('1m/chedar_0477_UV1m.sofa', '4aeda55a5c22ba1ac4a7630f1a05ac5f'),
            ('1m/chedar_0478_UV1m.sofa', '8ce8543bd38d760ab35adbed25a92a18'),
            ('1m/chedar_0479_UV1m.sofa', '011cf73745fb38cb0cd3eef534fede58'),
            ('1m/chedar_0480_UV1m.sofa', 'cecef3c274ba7b5175a474ea38e46bff'),
            ('1m/chedar_0481_UV1m.sofa', 'ca2ab8cf251d608fe531a3e57b8079ed'),
            ('1m/chedar_0482_UV1m.sofa', 'f113abb40bacd348b680e35d8b8ab9b5'),
            ('1m/chedar_0483_UV1m.sofa', 'd9b0e8da331a86765912782f020487c5'),
            ('1m/chedar_0484_UV1m.sofa', '2f005971030f797d7714eeb4652dcce2'),
            ('1m/chedar_0485_UV1m.sofa', '1fb213f99d4aa0c12bc8c7637e54cbea'),
            ('1m/chedar_0486_UV1m.sofa', 'c1dcb1f33fb1e566475bf807fa5ef1e0'),
            ('1m/chedar_0487_UV1m.sofa', '625ca29360429f0169e53870d61a3e00'),
            ('1m/chedar_0488_UV1m.sofa', '8fa24fc390f8fe2e0fafabb4957cb32c'),
            ('1m/chedar_0489_UV1m.sofa', 'c076c5457c30fadd2c14d7eb8844d9bb'),
            ('1m/chedar_0490_UV1m.sofa', '507a389329c7a44ecf7021473697fd9d'),
            ('1m/chedar_0491_UV1m.sofa', 'b35d58ed7ed9169c61876e1ac9b8d0fb'),
            ('1m/chedar_0492_UV1m.sofa', 'ebbaf215fc994dd519ac87c98e160982'),
            ('1m/chedar_0493_UV1m.sofa', 'd7f36665b99024d85f314cbab68b5e5e'),
            ('1m/chedar_0494_UV1m.sofa', '9942dd4a368d68a960094c5bd3e3adaa'),
            ('1m/chedar_0495_UV1m.sofa', 'ba082b415dff221f9356b3c18f13a66d'),
            ('1m/chedar_0496_UV1m.sofa', '044b4008ad87e1658d84c974c7cde808'),
            ('1m/chedar_0497_UV1m.sofa', '78807cfa564f1ab9299d97ec53d40a57'),
            ('1m/chedar_0498_UV1m.sofa', '170f4b0ddd7407a5ff154696c49dddfe'),
            ('1m/chedar_0499_UV1m.sofa', 'ab90661d0a1896dd23bea3b72145c2d6'),
            ('1m/chedar_0500_UV1m.sofa', '3403f32fdaaa96f2fccf4f9f5e04656e'),
            ('1m/chedar_0501_UV1m.sofa', '498b1bee5369d789bc5bba571a3b747f'),
            ('1m/chedar_0502_UV1m.sofa', 'c8a944fcc876203950bf6523c4c8fa78'),
            ('1m/chedar_0503_UV1m.sofa', 'c678c93df33f90e75fa33ffd30afb51a'),
            ('1m/chedar_0504_UV1m.sofa', '048564ff9dff4e339eff0108f535b037'),
            ('1m/chedar_0505_UV1m.sofa', '1f97f18f6e5e8af1c6c4df5e3d9c7827'),
            ('1m/chedar_0506_UV1m.sofa', 'd50018e2e59d987f38c0ed6c75deeb71'),
            ('1m/chedar_0507_UV1m.sofa', 'eb64090cd427e12e3ac3fa303b6c906e'),
            ('1m/chedar_0508_UV1m.sofa', '737cc63de62f6b2c735dd0acb2cd815c'),
            ('1m/chedar_0509_UV1m.sofa', '9f8a8f2b4e9b6959c539fa7526d3000d'),
            ('1m/chedar_0510_UV1m.sofa', '75990630dc07387518e2dc3958be62e8'),
            ('1m/chedar_0511_UV1m.sofa', 'b4fe45ceadff3811b8902500d5e5d8e6'),
            ('1m/chedar_0512_UV1m.sofa', 'a820a34b54fd6e28a6ad4f7504a43133'),
            ('1m/chedar_0513_UV1m.sofa', '7708b322f5493e8fe5f05a15f31aef77'),
            ('1m/chedar_0514_UV1m.sofa', '600f38d53b47a98072751394fc29a31b'),
            ('1m/chedar_0515_UV1m.sofa', 'aeec19d41ab1e2581e8b26b8f1dc3361'),
            ('1m/chedar_0516_UV1m.sofa', '27b893c945d8b26c14b95945d4353631'),
            ('1m/chedar_0517_UV1m.sofa', 'e87eb2ba8809fbe71408ae56e2ae5878'),
            ('1m/chedar_0518_UV1m.sofa', 'c536a5ed91fa00704c6d1b0498b2f14d'),
            ('1m/chedar_0519_UV1m.sofa', 'f65cc812220c47b22e8254ac2cd708e1'),
            ('1m/chedar_0520_UV1m.sofa', 'fd7ef73e5bc1ef37c93f14ceb927ebea'),
            ('1m/chedar_0521_UV1m.sofa', '789f15cd2c2dd3a5c708096d8e06add4'),
            ('1m/chedar_0522_UV1m.sofa', '609b9acfd25e003f41ba25d7d59ebcdf'),
            ('1m/chedar_0523_UV1m.sofa', 'a8cb3f6b06c7d1826b3bf3c78a76ed72'),
            ('1m/chedar_0524_UV1m.sofa', '6e33a0591465a32b068a0591c9b54a7a'),
            ('1m/chedar_0525_UV1m.sofa', 'be9b69ae506a1e5b1eb59b49252fef80'),
            ('1m/chedar_0526_UV1m.sofa', 'f48f7b0c5b3dd4bb7dd375b08b4831df'),
            ('1m/chedar_0527_UV1m.sofa', '6bea0eecd1a9d561533ff88afadd8eb5'),
            ('1m/chedar_0528_UV1m.sofa', '03d3e8c456d557812b0d982dd5ef4c38'),
            ('1m/chedar_0529_UV1m.sofa', 'f40d9aa38b51b236d1e09ce86fa735b4'),
            ('1m/chedar_0530_UV1m.sofa', '3cae5dad5ffb226f2bca8d8974c8c0ac'),
            ('1m/chedar_0531_UV1m.sofa', '2b16cb0b2b79ade69d6f38ca1eff600f'),
            ('1m/chedar_0532_UV1m.sofa', '3f967856581bb1d22d3615c0a3333a06'),
            ('1m/chedar_0533_UV1m.sofa', '4bb62349c1f17cb5a1cc3f75c6194b14'),
            ('1m/chedar_0534_UV1m.sofa', '03402e2aeb9089cb82fe1b07e075d1be'),
            ('1m/chedar_0535_UV1m.sofa', 'a3ad165b9ca3e3b35d2fcb7dd859ee52'),
            ('1m/chedar_0536_UV1m.sofa', '1b42f9c2cb983f4136d5ab9e383c5aff'),
            ('1m/chedar_0537_UV1m.sofa', '07a54826575a0f286dfb2abb43efb41b'),
            ('1m/chedar_0538_UV1m.sofa', 'caf935cca976af2ddbcb409a49d0c12d'),
            ('1m/chedar_0539_UV1m.sofa', 'c5914e7240d225335895baaeb370ab1e'),
            ('1m/chedar_0540_UV1m.sofa', '6571712ef6b9ca16804282a4ac7d430f'),
            ('1m/chedar_0541_UV1m.sofa', 'd4ae27af43b2543248c41be929690b0e'),
            ('1m/chedar_0542_UV1m.sofa', 'd8551fd439a6c5629cd9a17f5de5f5c6'),
            ('1m/chedar_0543_UV1m.sofa', 'fb9ddd28e15d30befe02533b57e0528b'),
            ('1m/chedar_0544_UV1m.sofa', '2ec0ae57b2d9858ab32c4fcc4bff3e04'),
            ('1m/chedar_0545_UV1m.sofa', '51503862f0e61ba63ad6e68f6a5515d6'),
            ('1m/chedar_0546_UV1m.sofa', 'f2e0b52895fd4fe803bbc65b65fbb69b'),
            ('1m/chedar_0547_UV1m.sofa', '9c618d62491d453896c8b60914befc92'),
            ('1m/chedar_0548_UV1m.sofa', '170c55ddc2dd25f7695aaff370f71c3d'),
            ('1m/chedar_0549_UV1m.sofa', 'db815fc929d6845edeb1db5ec93bf72c'),
            ('1m/chedar_0550_UV1m.sofa', 'aecf5fa7bfdcbb9a6f56851427fc4be3'),
            ('1m/chedar_0551_UV1m.sofa', '2fd6711a2d74e35c319c2fa974541ecb'),
            ('1m/chedar_0552_UV1m.sofa', '0d58308d953e65914b7787677f95adb4'),
            ('1m/chedar_0553_UV1m.sofa', '8fad855858e32ac3bc8a8233aadf04e6'),
            ('1m/chedar_0554_UV1m.sofa', '0c74d91dc49669ef46d305619337d6f6'),
            ('1m/chedar_0555_UV1m.sofa', 'bc96042fba3569838eb54767126d74df'),
            ('1m/chedar_0556_UV1m.sofa', 'a129f8077983941cc9a3fd7154839341'),
            ('1m/chedar_0557_UV1m.sofa', 'fd7b24bb844a5061e9e7b66b7a089f9c'),
            ('1m/chedar_0558_UV1m.sofa', '5e41dd7b57abbfddba65e05311539dca'),
            ('1m/chedar_0559_UV1m.sofa', '475ec3a47ebb234d2df04e2000bfb1c0'),
            ('1m/chedar_0560_UV1m.sofa', '3eb1edee080ca90f8c0f2ec6f05ae5f3'),
            ('1m/chedar_0561_UV1m.sofa', '0489c0bcb0f1f107b012cc668c76abe5'),
            ('1m/chedar_0562_UV1m.sofa', 'c1e745e2c96943fd97434f0592ff084b'),
            ('1m/chedar_0563_UV1m.sofa', '620c86b31e5868cd7990d6d334b8d1d3'),
            ('1m/chedar_0564_UV1m.sofa', '53a0d535ac5272e6af5f9f252949c977'),
            ('1m/chedar_0565_UV1m.sofa', 'd2463ad75bbd170253f562222ca7da54'),
            ('1m/chedar_0566_UV1m.sofa', '54035ced716deaec269037b6b0871daa'),
            ('1m/chedar_0567_UV1m.sofa', 'c03994e269da437f262ead80a4bdbc6b'),
            ('1m/chedar_0568_UV1m.sofa', '0d7801e7f7262141b1c47c271b3c438f'),
            ('1m/chedar_0569_UV1m.sofa', '1dd720ca1416967eb2cba43d0de35652'),
            ('1m/chedar_0570_UV1m.sofa', '5617a1b15ee521cec8a5347ffc4b9dfe'),
            ('1m/chedar_0571_UV1m.sofa', '4f4be8191dd579f4f9d2be7f4b307e00'),
            ('1m/chedar_0572_UV1m.sofa', '6eb6407fa48cd231f6213500bfc35e13'),
            ('1m/chedar_0573_UV1m.sofa', '0079b94448c9df647c189546ef39b579'),
            ('1m/chedar_0574_UV1m.sofa', '506bb4dc26ec953b956dc74167294011'),
            ('1m/chedar_0575_UV1m.sofa', '8216d859d75fdc782e0f7b78ff748406'),
            ('1m/chedar_0576_UV1m.sofa', '6395d1a632b6778bea21a2f550c473c1'),
            ('1m/chedar_0577_UV1m.sofa', '528f5ee252f7a9761980e93fd81b7833'),
            ('1m/chedar_0578_UV1m.sofa', '0376b9b6d5a06df803db2a962b60baac'),
            ('1m/chedar_0579_UV1m.sofa', 'eff45d3232621711da0baefd1af3d5dc'),
            ('1m/chedar_0580_UV1m.sofa', 'e773a3aefc5d99db85f77a2a4e2a69f8'),
            ('1m/chedar_0581_UV1m.sofa', 'da8907cc3fa3849eb4ca0bae1cc34124'),
            ('1m/chedar_0582_UV1m.sofa', '7992498c05292ec69cbef5f974ee7ebc'),
            ('1m/chedar_0583_UV1m.sofa', 'd8ca49e3e5ff4911cf36f11015ebc505'),
            ('1m/chedar_0584_UV1m.sofa', 'ba0f2bf35710b252fc00640465f91595'),
            ('1m/chedar_0585_UV1m.sofa', '291891074030d795299f810e16b60c81'),
            ('1m/chedar_0586_UV1m.sofa', '25797e55222c2070394fd63271355e4e'),
            ('1m/chedar_0587_UV1m.sofa', 'ef2008f4cf1da00d84e7b7c55d1f42ee'),
            ('1m/chedar_0588_UV1m.sofa', 'a773fb2813e8f1eec133b6a3beb45b61'),
            ('1m/chedar_0589_UV1m.sofa', '5185b262b7d363c0365076bd19ff6cd0'),
            ('1m/chedar_0590_UV1m.sofa', '356e3842dbc3344180557fa45c79b22a'),
            ('1m/chedar_0591_UV1m.sofa', 'c8804a5de5faba98bb4fd9d91e2c2cd9'),
            ('1m/chedar_0592_UV1m.sofa', '3e1bdd7b3d6bbc84c45dd775a522ebdd'),
            ('1m/chedar_0593_UV1m.sofa', 'e27d1f9c5cceb7d208f9938513926639'),
            ('1m/chedar_0594_UV1m.sofa', '17dd22cd7d186fc89645e1677e9194b1'),
            ('1m/chedar_0595_UV1m.sofa', '13b6ec0a34bea852a3ea8655cac2a61c'),
            ('1m/chedar_0596_UV1m.sofa', 'e2adae4c866ac9dc519981c48cec72b4'),
            ('1m/chedar_0597_UV1m.sofa', 'e699372b577164caa75ef83e5b4796f6'),
            ('1m/chedar_0598_UV1m.sofa', '96863035b52a8d962ff281e2d750b732'),
            ('1m/chedar_0599_UV1m.sofa', '748b14553abe22fb65650292a181d4d4'),
            ('1m/chedar_0600_UV1m.sofa', '51677f8d3f5df47eec95b9e027bc5e40'),
            ('1m/chedar_0601_UV1m.sofa', 'e0ed638547944797e512b23b835be69d'),
            ('1m/chedar_0602_UV1m.sofa', '807360559de11132e3e329ae066ab929'),
            ('1m/chedar_0603_UV1m.sofa', 'fe0d66e9e9b913b5e0db60f749c03249'),
            ('1m/chedar_0604_UV1m.sofa', 'de0153ddcdc01185634e1c51fdf50f29'),
            ('1m/chedar_0605_UV1m.sofa', 'db2a2212cf27f54991fe06385ce9a60c'),
            ('1m/chedar_0606_UV1m.sofa', 'd17ef44d5d1503e692a2f6538a42ad49'),
            ('1m/chedar_0607_UV1m.sofa', '00a1b2a7d66ceb3e391cfeb582d75605'),
            ('1m/chedar_0608_UV1m.sofa', 'e1007daa67de0a3a3f615d8fd31e27da'),
            ('1m/chedar_0609_UV1m.sofa', '479b8bb785b84e1288c294d6233f672e'),
            ('1m/chedar_0610_UV1m.sofa', 'b7d8c8e7cb728e2748954e1384acd519'),
            ('1m/chedar_0611_UV1m.sofa', '07fa6952969c4d2e2d2e7523697a2b79'),
            ('1m/chedar_0612_UV1m.sofa', 'fe5a1bf5ef6d2eae630fe3ad55fb12bb'),
            ('1m/chedar_0613_UV1m.sofa', 'fc137960c8adfdbb66132c99495e3312'),
            ('1m/chedar_0614_UV1m.sofa', '30b5be1f3a46a618ee2491ee6ccd9535'),
            ('1m/chedar_0615_UV1m.sofa', '8fc98fb0068f9e5348ba7b9fa943da5a'),
            ('1m/chedar_0616_UV1m.sofa', '48f2d6060b9ffbf28ff72824ffd4e2ac'),
            ('1m/chedar_0617_UV1m.sofa', '7c9825e0379a55b213097124359cf409'),
            ('1m/chedar_0618_UV1m.sofa', 'fc1313b38c29021905a1d9bca7c3c5b0'),
            ('1m/chedar_0619_UV1m.sofa', 'fc13daf7cf2df7d059ff321fe51615ec'),
            ('1m/chedar_0620_UV1m.sofa', 'f6bb67e9ab47ceed6c574cc8e438cf70'),
            ('1m/chedar_0621_UV1m.sofa', 'e0ea005eb80f409c33dcdb00aef1a6df'),
            ('1m/chedar_0622_UV1m.sofa', 'b4189ae5c5f1511185a4a045538fd622'),
            ('1m/chedar_0623_UV1m.sofa', '3c9f528b6f31aba19eecca0917e5eb1a'),
            ('1m/chedar_0624_UV1m.sofa', '902eff50e96c34e369b3e7d8f306533b'),
            ('1m/chedar_0625_UV1m.sofa', 'd10a2c85b9af107d29a4bada9abcbe01'),
            ('1m/chedar_0626_UV1m.sofa', '6dbd23e8c4ea890e6e6f28a8a5ea2da6'),
            ('1m/chedar_0627_UV1m.sofa', '02ba3993bbdb7244a40d39e0e4c89fce'),
            ('1m/chedar_0628_UV1m.sofa', '1d8e071050379e75fccea33eb87e1c4d'),
            ('1m/chedar_0629_UV1m.sofa', '284f4020da94555989e380540a87eaa7'),
            ('1m/chedar_0630_UV1m.sofa', '0b923e63d568b468f95e42196d06e8e3'),
            ('1m/chedar_0631_UV1m.sofa', 'df26d862996016f8e90bb82457217174'),
            ('1m/chedar_0632_UV1m.sofa', '60f8be0da7f6736ddbfecc18040632c4'),
            ('1m/chedar_0633_UV1m.sofa', 'fcc5369d98e54243efc690871d97a3dc'),
            ('1m/chedar_0634_UV1m.sofa', 'e0248e518b08081a279814db7a9130e8'),
            ('1m/chedar_0635_UV1m.sofa', '9484e0039310c2d035d31eee8561f32b'),
            ('1m/chedar_0636_UV1m.sofa', '21c1618d832b2477d4c496f62294beda'),
            ('1m/chedar_0637_UV1m.sofa', '35164f0e2eaf15346579e78f2d854a1d'),
            ('1m/chedar_0638_UV1m.sofa', '843edd3edaa90fd645a9810955c135fd'),
            ('1m/chedar_0639_UV1m.sofa', '44e63f69eca635ecb382c46eca57dcc2'),
            ('1m/chedar_0640_UV1m.sofa', '4ec2d70c25face32cf65bd8861c6fa81'),
            ('1m/chedar_0641_UV1m.sofa', '5775ef2c7310c69e9cdf91c6aeffab0e'),
            ('1m/chedar_0642_UV1m.sofa', 'e28c20dd5e0f3ba9ea63f82745fe2006'),
            ('1m/chedar_0643_UV1m.sofa', '652ae84f2f77006c6253bf3d55d08d42'),
            ('1m/chedar_0644_UV1m.sofa', '0a008f2a30c64f8720c46d8b97a00216'),
            ('1m/chedar_0645_UV1m.sofa', 'cc25e61b3dcbeda8cc1b1ca3f90c1268'),
            ('1m/chedar_0646_UV1m.sofa', 'd6232c9c358e916c431ce4542c1c0986'),
            ('1m/chedar_0647_UV1m.sofa', '346438e82f4cb89e4069edcf38eaa340'),
            ('1m/chedar_0648_UV1m.sofa', 'a08e30be3205c73662127782dc90d26e'),
            ('1m/chedar_0649_UV1m.sofa', 'a22b39238c971fc08e13032b0d96480b'),
            ('1m/chedar_0650_UV1m.sofa', 'aa9d9cd21c4d56ff750c94a35a09ba9e'),
            ('1m/chedar_0651_UV1m.sofa', '8b50d6f897b9a4067950c4572ee83dae'),
            ('1m/chedar_0652_UV1m.sofa', 'a362139495b19b8d7220d41dae6675b9'),
            ('1m/chedar_0653_UV1m.sofa', '9a36eb78baa4fec25c09bb775fe61b60'),
            ('1m/chedar_0654_UV1m.sofa', 'cffc9c2e85662ceabb02a70172e081fe'),
            ('1m/chedar_0655_UV1m.sofa', '97ab658baf352d7a404d6db16a7ae45b'),
            ('1m/chedar_0656_UV1m.sofa', 'fd691df5354acd90bab8f0a3cacf3abc'),
            ('1m/chedar_0657_UV1m.sofa', '4974df3b5eb29f3cdb426e2105b18658'),
            ('1m/chedar_0658_UV1m.sofa', 'd3ad47314f32b37cc52351371c4488f4'),
            ('1m/chedar_0659_UV1m.sofa', '0914922aff155127756a21ffb4a05c66'),
            ('1m/chedar_0660_UV1m.sofa', '773d03033d0061787f78a06339863d7b'),
            ('1m/chedar_0661_UV1m.sofa', '36e94f704a399e81d1d49fee74c00e31'),
            ('1m/chedar_0662_UV1m.sofa', '07aa6b70ae1f8e538c8cf70fe0ee998d'),
            ('1m/chedar_0663_UV1m.sofa', '6e5911d3cd7aa645e5d856766ebfe984'),
            ('1m/chedar_0664_UV1m.sofa', '370ceb82617f092aed2ba89ef689a507'),
            ('1m/chedar_0665_UV1m.sofa', '2fe0c2be05eae843f16ce485fe82c181'),
            ('1m/chedar_0666_UV1m.sofa', '43d903b4dcaa31efca5a1706c1c07974'),
            ('1m/chedar_0667_UV1m.sofa', 'c8904890c29c49bc9ac4560dc0475016'),
            ('1m/chedar_0668_UV1m.sofa', '249308d295e93db6e50a78a3560fd68e'),
            ('1m/chedar_0669_UV1m.sofa', '66d371f976618abfaaf814153638d3f5'),
            ('1m/chedar_0670_UV1m.sofa', 'cd63c46b7911f1f15f8d281fa950647b'),
            ('1m/chedar_0671_UV1m.sofa', 'b996c4ea0666aa87faf7520b5318350d'),
            ('1m/chedar_0672_UV1m.sofa', '8f932a6e8a47459619e60335969d6fc9'),
            ('1m/chedar_0673_UV1m.sofa', '1732eeb2e8dfd940f3515a7d251c120d'),
            ('1m/chedar_0674_UV1m.sofa', 'ebe9eba1e394d18a397d9744b2e14116'),
            ('1m/chedar_0675_UV1m.sofa', 'dd51616adbc674fd0ae6226e3fd71ebd'),
            ('1m/chedar_0676_UV1m.sofa', '595c29f45baf36bcc91120f37b7883a1'),
            ('1m/chedar_0677_UV1m.sofa', '1c2696fb88f0c00187804c9362d6a4c5'),
            ('1m/chedar_0678_UV1m.sofa', '904cb3e8fd5158692c0329c1ac7fa6f1'),
            ('1m/chedar_0679_UV1m.sofa', 'db3291e4eee27551f4eba51c4cc0ed0c'),
            ('1m/chedar_0680_UV1m.sofa', '20607450dc6b7ac098875b11a05b9c67'),
            ('1m/chedar_0681_UV1m.sofa', 'f4401f25843f0676378703d228ac7a58'),
            ('1m/chedar_0682_UV1m.sofa', 'a816362cb6a848679beeb7fa370e0df8'),
            ('1m/chedar_0683_UV1m.sofa', 'a54c3b50f18daae905dbd2396ce9a2ee'),
            ('1m/chedar_0684_UV1m.sofa', 'e06fccc979ff72b404dd6414c481bcd3'),
            ('1m/chedar_0685_UV1m.sofa', 'f356a28be8ef6c7ff8ef0b76817d22f7'),
            ('1m/chedar_0686_UV1m.sofa', '2025749da34f081604bea59914dc4cc2'),
            ('1m/chedar_0687_UV1m.sofa', '927c8797b5add4b62a40439f267050e9'),
            ('1m/chedar_0688_UV1m.sofa', '7676f66953c6a6cbe4631d47d08568c4'),
            ('1m/chedar_0689_UV1m.sofa', '70a1df73da3bc473e96ca180f397b2c0'),
            ('1m/chedar_0690_UV1m.sofa', 'e32625bbf80ea0ef0f41a8dccda28d06'),
            ('1m/chedar_0691_UV1m.sofa', '5e043021a04a53c21b91e232cc54081d'),
            ('1m/chedar_0692_UV1m.sofa', '0106be18b06bd642a792d54c0f3a0d4f'),
            ('1m/chedar_0693_UV1m.sofa', 'ab7644018425223153699b2cf4cf7366'),
            ('1m/chedar_0694_UV1m.sofa', 'a0082e1e1d365580d708505c26f2c57d'),
            ('1m/chedar_0695_UV1m.sofa', '92f3369835937a0d593bcc8ed615eecd'),
            ('1m/chedar_0696_UV1m.sofa', '4481ea1ebf5828f56e09b022ad0bb5ad'),
            ('1m/chedar_0697_UV1m.sofa', '9692bf35796e8525423a0e37cf4a2c7a'),
            ('1m/chedar_0698_UV1m.sofa', 'ea20c9e6e921bb52139c2d59416c98da'),
            ('1m/chedar_0699_UV1m.sofa', '622a45f82228bd9311e7099456332086'),
            ('1m/chedar_0700_UV1m.sofa', 'f909a4a625779f96d6cfb82795416255'),
            ('1m/chedar_0701_UV1m.sofa', 'ea11b8c559fd80d8af77414ed3fa9e70'),
            ('1m/chedar_0702_UV1m.sofa', '4d0730a3b89d4d57cd567258089d19d3'),
            ('1m/chedar_0703_UV1m.sofa', 'f86b14dc7ae9a8c3f1977256b44ff752'),
            ('1m/chedar_0704_UV1m.sofa', 'd83279753208407989f444d541450e5c'),
            ('1m/chedar_0705_UV1m.sofa', '409bd2944258b08bafb53d97b28dbe95'),
            ('1m/chedar_0706_UV1m.sofa', '47b6d16a0a511a20ad0e3ecc8068588d'),
            ('1m/chedar_0707_UV1m.sofa', 'b4e1d08dfeb5f1b1c5a5d53f0e5a3936'),
            ('1m/chedar_0708_UV1m.sofa', 'a1494e21c30692965468da26ecbb2bfd'),
            ('1m/chedar_0709_UV1m.sofa', 'd2ee59fe0b09a4a0d11c381b16194a98'),
            ('1m/chedar_0710_UV1m.sofa', '55fa9d010ac34d0a897825d179dc0ba0'),
            ('1m/chedar_0711_UV1m.sofa', '81c27d583838af2df395bdace0d078d5'),
            ('1m/chedar_0712_UV1m.sofa', 'ea15671700d600d78afc493f4d96d1a5'),
            ('1m/chedar_0713_UV1m.sofa', '3f8124d6130abe26980b8eb9fa13685b'),
            ('1m/chedar_0714_UV1m.sofa', 'bde33c3b4173a72bd1608c60fb07b1d7'),
            ('1m/chedar_0715_UV1m.sofa', '1e3a35c0816bc70e10c404c6d8c8ef31'),
            ('1m/chedar_0716_UV1m.sofa', 'd05a4e7c60b73093f6d50a233fdb8e3d'),
            ('1m/chedar_0717_UV1m.sofa', '5c9ffefa464c5991d43dc28162a2f58a'),
            ('1m/chedar_0718_UV1m.sofa', 'c3448f818944ba2216c1bad2f18c98fe'),
            ('1m/chedar_0719_UV1m.sofa', '72617658c9360ae666723d6599207325'),
            ('1m/chedar_0720_UV1m.sofa', '15483ee9c6887a60910c61d2b567f0f4'),
            ('1m/chedar_0721_UV1m.sofa', '87a78cd1a4acf69707a76fdff873c315'),
            ('1m/chedar_0722_UV1m.sofa', '4c8f519bbbf28e1e440e70f8b829b9ac'),
            ('1m/chedar_0723_UV1m.sofa', '376f1ff9235c4fb1b6de8d40a4f57b5c'),
            ('1m/chedar_0724_UV1m.sofa', '7911c7f047113812775d7b9f32172cd3'),
            ('1m/chedar_0725_UV1m.sofa', '8dd771404fa40c43468d8b44c76a269e'),
            ('1m/chedar_0726_UV1m.sofa', 'fd116960df3e11f8849c31d585b7d20f'),
            ('1m/chedar_0727_UV1m.sofa', 'ec93775093189ec90ea22dd04d2cdb09'),
            ('1m/chedar_0728_UV1m.sofa', 'b79f6802f13372521657b1c8b319f143'),
            ('1m/chedar_0729_UV1m.sofa', '0aeef0622529fe25fb5f9cd354f75a35'),
            ('1m/chedar_0730_UV1m.sofa', 'f3a80bd0c29be1aff87fcf9eccb24f16'),
            ('1m/chedar_0731_UV1m.sofa', 'c01add88b3df1e57b56ecc962c275686'),
            ('1m/chedar_0732_UV1m.sofa', '0eabdd3237df0e67269a9286bde7d136'),
            ('1m/chedar_0733_UV1m.sofa', '9fdccf9944dce6350db43789a338db45'),
            ('1m/chedar_0734_UV1m.sofa', 'f32de46d5b73a60d9ca2d16d16983ad6'),
            ('1m/chedar_0735_UV1m.sofa', '5945b01cc3422fe176e91d70cdef3317'),
            ('1m/chedar_0736_UV1m.sofa', 'c6804090360cfffec3b905cb77450c05'),
            ('1m/chedar_0737_UV1m.sofa', '73a38b87531fb3fb7a3619d63c65458d'),
            ('1m/chedar_0738_UV1m.sofa', '07885d586bf4eb2fb450556f7ee7265f'),
            ('1m/chedar_0739_UV1m.sofa', 'f4bc019325d08a6ca64e0424b242c3eb'),
            ('1m/chedar_0740_UV1m.sofa', '838dcaa3fff7f4fcc2b2ef5f812767b9'),
            ('1m/chedar_0741_UV1m.sofa', '308350eedcd9c0b73574205e2f258bc7'),
            ('1m/chedar_0742_UV1m.sofa', 'a6ada02e834f08b994b2d300aea454c2'),
            ('1m/chedar_0743_UV1m.sofa', '23eac173fef87240a47400767505b112'),
            ('1m/chedar_0744_UV1m.sofa', 'bdc290ad607ec905bfabc41106be1a18'),
            ('1m/chedar_0745_UV1m.sofa', '2997ba446cd4567c1411fa49da7e065b'),
            ('1m/chedar_0746_UV1m.sofa', '81329a1ae6839e2d46ac01e6c53f4c7d'),
            ('1m/chedar_0747_UV1m.sofa', '9b21d9051f86142e3ad0a8961866540c'),
            ('1m/chedar_0748_UV1m.sofa', '8aae3858033501f826b90f3cd48ccbda'),
            ('1m/chedar_0749_UV1m.sofa', '846b3a83888ce9b40fa5b60492831704'),
            ('1m/chedar_0750_UV1m.sofa', '981452cac77a2648f8484920f6878d16'),
            ('1m/chedar_0751_UV1m.sofa', '7cb3e3580bd0f02e3cb126e9aa5094f5'),
            ('1m/chedar_0752_UV1m.sofa', 'c12a3dbd263abadea2393b01bb34ea88'),
            ('1m/chedar_0753_UV1m.sofa', 'd26658b620ed36468385ed865d41eae9'),
            ('1m/chedar_0754_UV1m.sofa', '3ffd78fb5896544046bd53a9ee730a80'),
            ('1m/chedar_0755_UV1m.sofa', '7125d6d59ea4af856af8ea9a095af5c2'),
            ('1m/chedar_0756_UV1m.sofa', '513304e823338dd60c4500098d9d1b0b'),
            ('1m/chedar_0757_UV1m.sofa', '621cf6dbc36758ff0081be55a12f972e'),
            ('1m/chedar_0758_UV1m.sofa', '645e9c2c6bf60986542a33b29a85098c'),
            ('1m/chedar_0759_UV1m.sofa', '6df40461a2453c9da829204f9b510893'),
            ('1m/chedar_0760_UV1m.sofa', '0e14001732c14c4a0d48af857f5db6fb'),
            ('1m/chedar_0761_UV1m.sofa', '6c083e5725d07d32ba029c7f51b305cd'),
            ('1m/chedar_0762_UV1m.sofa', '59b06607385f7b472cdb8e2d724b2a45'),
            ('1m/chedar_0763_UV1m.sofa', 'e38564c13de3e073b67b9ff52fc5e7b2'),
            ('1m/chedar_0764_UV1m.sofa', 'faf4164932c9bc022fb13c3322b352b8'),
            ('1m/chedar_0765_UV1m.sofa', '9d931c24b1361cbfb077cb002238e03d'),
            ('1m/chedar_0766_UV1m.sofa', '16b78af3b3535f2e58281bf2231cb2a1'),
            ('1m/chedar_0767_UV1m.sofa', '70db803a3678156a9144f3288110eeab'),
            ('1m/chedar_0768_UV1m.sofa', '168315d72a88bce910802a9b4bac3413'),
            ('1m/chedar_0769_UV1m.sofa', '0a89e22749ea4e147ed82ad6e5b7a650'),
            ('1m/chedar_0770_UV1m.sofa', '96f1a8f022e1e46a9ea44a8165531a4f'),
            ('1m/chedar_0771_UV1m.sofa', 'e1764b14e8b135f72fed9608cbd7688a'),
            ('1m/chedar_0772_UV1m.sofa', '9c74ad230b260bbb38c4a256280eca9b'),
            ('1m/chedar_0773_UV1m.sofa', 'a4ac51b5f054333a496e84fe28f88af2'),
            ('1m/chedar_0774_UV1m.sofa', '65e965f491e225bc78cb51b869e4295d'),
            ('1m/chedar_0775_UV1m.sofa', '0f1d8f78bc0959def771b392530ae725'),
            ('1m/chedar_0776_UV1m.sofa', 'e6160d618d9863195687ba6038b9485f'),
            ('1m/chedar_0777_UV1m.sofa', 'd7237ca87d63f2dec68a92c0f47966f6'),
            ('1m/chedar_0778_UV1m.sofa', '6f361bb563441e9c578ca5e1da54bccb'),
            ('1m/chedar_0779_UV1m.sofa', '772dc7424ac874ba2d075a10f1520d8b'),
            ('1m/chedar_0780_UV1m.sofa', 'e5695006059a64de3873938257011dbf'),
            ('1m/chedar_0781_UV1m.sofa', 'a35272c1ec1eee5a7f793cfd3561accc'),
            ('1m/chedar_0782_UV1m.sofa', '0966ae88e72ec8ae6ada42a2950b440d'),
            ('1m/chedar_0783_UV1m.sofa', '57bce1d9654683b18df8a60dddbdd4b7'),
            ('1m/chedar_0784_UV1m.sofa', '883d001f80bdefc89a6392a98dee9f2a'),
            ('1m/chedar_0785_UV1m.sofa', 'eff22f1bd6b5c860d37c76164cd98126'),
            ('1m/chedar_0786_UV1m.sofa', '648c74bbc6f28f511d3bf4be1dff11f0'),
            ('1m/chedar_0787_UV1m.sofa', 'd8b23043b338d4db6b70929f4e2b1ec1'),
            ('1m/chedar_0788_UV1m.sofa', '1ac425bf9dc50132352d6595a54e0a70'),
            ('1m/chedar_0789_UV1m.sofa', 'ebba798933793323546abd9fa03f8d77'),
            ('1m/chedar_0790_UV1m.sofa', '44217a8dbac3a65b6635f25a0c48ae37'),
            ('1m/chedar_0791_UV1m.sofa', '9f85b55ceec60465901a275d3a917f27'),
            ('1m/chedar_0792_UV1m.sofa', '293f1656b3ec2acf472751fb0c3ee80f'),
            ('1m/chedar_0793_UV1m.sofa', 'ce82b5487ddfb51ebee46f35c2f79fca'),
            ('1m/chedar_0794_UV1m.sofa', '78a69d0326002b07aaaac51becab9028'),
            ('1m/chedar_0795_UV1m.sofa', '9880aaef4d46a583faa37caef2ce1002'),
            ('1m/chedar_0796_UV1m.sofa', '5f31a909b7c7267f30771a3ecf7f7cb5'),
            ('1m/chedar_0797_UV1m.sofa', '7f9a1d5041669580e86136dd61d8b497'),
            ('1m/chedar_0798_UV1m.sofa', '1540682b41fc5225fe3cc5f26d1c0bad'),
            ('1m/chedar_0799_UV1m.sofa', '3869bd68577caa1da153cdc63dba436f'),
            ('1m/chedar_0800_UV1m.sofa', 'dce28f9a3d9cc31bb6062a5c6149e959'),
            ('1m/chedar_0801_UV1m.sofa', 'dd1935f24eae8e31232dc3f560ae97f3'),
            ('1m/chedar_0802_UV1m.sofa', 'a48128a6518e5f14fea7d7a89494ba2b'),
            ('1m/chedar_0803_UV1m.sofa', 'c15184a6ed7aca4835e58227c6d03829'),
            ('1m/chedar_0804_UV1m.sofa', 'a3bf0ae61227b543d74687c767971969'),
            ('1m/chedar_0805_UV1m.sofa', '9cecef549fbb14f2a3f15b1fc3e43e39'),
            ('1m/chedar_0806_UV1m.sofa', 'c4dd6b5af86908eea4a5de5f263e4228'),
            ('1m/chedar_0807_UV1m.sofa', '7058a0e6d77c18dbc263e45328305f97'),
            ('1m/chedar_0808_UV1m.sofa', 'b93ff045262ccce22982afb8a97e4694'),
            ('1m/chedar_0809_UV1m.sofa', 'cc1d9abca120fa58487dad4de3bc496d'),
            ('1m/chedar_0810_UV1m.sofa', '69e83f65d409ada200c3cf53a3b4ab3e'),
            ('1m/chedar_0811_UV1m.sofa', '910b31eba5f78016118b04d5b0bd3538'),
            ('1m/chedar_0812_UV1m.sofa', '95bdd751aa6a7c19aff89e40295dd657'),
            ('1m/chedar_0813_UV1m.sofa', '9cf8096c576567fc2dcdb3c8f0f01dcb'),
            ('1m/chedar_0814_UV1m.sofa', 'f05f5d0650529646c240de0bb097db01'),
            ('1m/chedar_0815_UV1m.sofa', 'ba2fdae0f70ddc2e94289093fb55573c'),
            ('1m/chedar_0816_UV1m.sofa', 'eff7c894c1d50c1d048b9b15a736ea54'),
            ('1m/chedar_0817_UV1m.sofa', '0246ed0231e81b3c5c83b8e97856e8c7'),
            ('1m/chedar_0818_UV1m.sofa', 'efa0ef5ac1a6f392624826f525221a29'),
            ('1m/chedar_0819_UV1m.sofa', '389eb9a3825ebcc94f1fb245ab0a5355'),
            ('1m/chedar_0820_UV1m.sofa', '49b97108bb8f9d762b7282bafba06bd0'),
            ('1m/chedar_0821_UV1m.sofa', '09c89f7f0afa6b8387102ee855be3133'),
            ('1m/chedar_0822_UV1m.sofa', '1c2fed96b0eccd411860ed4118454346'),
            ('1m/chedar_0823_UV1m.sofa', 'c13fb82b3d791702b2c827ab949ea77a'),
            ('1m/chedar_0824_UV1m.sofa', '9c8d8e10449b3a16cd4f09433030556b'),
            ('1m/chedar_0825_UV1m.sofa', 'c5c6509253c04500a4f8695476dfb146'),
            ('1m/chedar_0826_UV1m.sofa', 'f73d34d7ee72a05d8f437c8b7f7fd8df'),
            ('1m/chedar_0827_UV1m.sofa', '9d8ec3f3b5c8c59e6f68de57a5cdf362'),
            ('1m/chedar_0828_UV1m.sofa', '967841ed4a4f73babcd622da802d740c'),
            ('1m/chedar_0829_UV1m.sofa', '939fff1df0bae3ee44ac66c9676d7ff8'),
            ('1m/chedar_0830_UV1m.sofa', '23cd0c8cfbfc0bd5b21df01dc37a1a63'),
            ('1m/chedar_0831_UV1m.sofa', '87823965f9860bb3792a39f3ad9d0467'),
            ('1m/chedar_0832_UV1m.sofa', 'efc0b7d6ac36fbeee2c733a6fcdbf8fc'),
            ('1m/chedar_0833_UV1m.sofa', '6340d4464ad73d4d6106b15bea453c0b'),
            ('1m/chedar_0834_UV1m.sofa', 'f8f1c8db3e5fc04ec6fb91bb47e05c9e'),
            ('1m/chedar_0835_UV1m.sofa', 'fbdddf2498fa86924123fd42916db504'),
            ('1m/chedar_0836_UV1m.sofa', 'e72b835687401cc062c5b17e1f4e6e9a'),
            ('1m/chedar_0837_UV1m.sofa', '3a0c65deb33e306ce5fe68b951dc45f5'),
            ('1m/chedar_0838_UV1m.sofa', '06b100d8c41247f5f3a5c94fd74e9f44'),
            ('1m/chedar_0839_UV1m.sofa', 'd3611742f8b676f66b8a695bda4a4bfa'),
            ('1m/chedar_0840_UV1m.sofa', 'd16f06365bd8b4bfe90dcd17c91f1854'),
            ('1m/chedar_0841_UV1m.sofa', '0e01815438eabe6e52d4fd71a72b05b0'),
            ('1m/chedar_0842_UV1m.sofa', '00a793477c0da1950da5642aa2e5bbdc'),
            ('1m/chedar_0843_UV1m.sofa', '34e4d8ca887236c76a054d6caabc5d62'),
            ('1m/chedar_0844_UV1m.sofa', 'd471ba369476c71230f28f17f97f7f35'),
            ('1m/chedar_0845_UV1m.sofa', '400b1cb0d3820ab5b007bd214b689db4'),
            ('1m/chedar_0846_UV1m.sofa', '8488fc906b7d658d8bfe3b9d2a80a0ab'),
            ('1m/chedar_0847_UV1m.sofa', 'dacd549dff521031cb4f7dc75a99c810'),
            ('1m/chedar_0848_UV1m.sofa', 'f5049236938526493b67adf2475d20f0'),
            ('1m/chedar_0849_UV1m.sofa', '51d392f95279915d639ce63efc26c5e2'),
            ('1m/chedar_0850_UV1m.sofa', 'a5ec7d2e00555494887ea49868d6ee6c'),
            ('1m/chedar_0851_UV1m.sofa', '75d4d3336153cd12483ddf8a9f6397b7'),
            ('1m/chedar_0852_UV1m.sofa', '6ae1765adc5e803ae0b1ce949bfbd4cd'),
            ('1m/chedar_0853_UV1m.sofa', '672e7cb318a4fad953bbb7616ccc3fc7'),
            ('1m/chedar_0854_UV1m.sofa', '0dc12a1f3a5eb3f886aba5f6d5a76d4b'),
            ('1m/chedar_0855_UV1m.sofa', '31697bd86c70e39f6482f0af3f00ec35'),
            ('1m/chedar_0856_UV1m.sofa', '92d8a50b7184ba3dbf3faa035893b36e'),
            ('1m/chedar_0857_UV1m.sofa', '9a9e3a33c1c0ebc602ecef1056d71559'),
            ('1m/chedar_0858_UV1m.sofa', '68461f7efe3f1f5c296b0ef43e708f44'),
            ('1m/chedar_0859_UV1m.sofa', '086b35a529d41120f2944f496142c73d'),
            ('1m/chedar_0860_UV1m.sofa', '4ecc33c9a2a806e39a0de7c379e9a73f'),
            ('1m/chedar_0861_UV1m.sofa', '0ef3136a08387086e0079c0df9dc2527'),
            ('1m/chedar_0862_UV1m.sofa', 'bfccbc6b8ccfc3d729af11c7b385eb28'),
            ('1m/chedar_0863_UV1m.sofa', '9b384e621ec3274722f11a24d85b04e2'),
            ('1m/chedar_0864_UV1m.sofa', '9307568a8c2314b5cad5c367725f313f'),
            ('1m/chedar_0865_UV1m.sofa', '613881e3c24c6bb7bea6115d569e10b9'),
            ('1m/chedar_0866_UV1m.sofa', '6658db322ae61a7e406dab80e8939938'),
            ('1m/chedar_0867_UV1m.sofa', 'b5c5720a7f6480613f0c266e84817a40'),
            ('1m/chedar_0868_UV1m.sofa', '95284411c1a919ca904e4f97bf082cee'),
            ('1m/chedar_0869_UV1m.sofa', 'b7e37b2da00948b22ed45fe6426d8890'),
            ('1m/chedar_0870_UV1m.sofa', '50c5b91a03ab3200f8c8379ca7f5dc42'),
            ('1m/chedar_0871_UV1m.sofa', '074ccf812c3e466030043685d9d1debc'),
            ('1m/chedar_0872_UV1m.sofa', '9d87c3122362d6c343df0bdddcaa8209'),
            ('1m/chedar_0873_UV1m.sofa', 'da424bf3762463e2fbb10098306111f0'),
            ('1m/chedar_0874_UV1m.sofa', 'c8212675d69597aeaf92066857aeb0bb'),
            ('1m/chedar_0875_UV1m.sofa', 'b770dcb5dcddc71a62066435708e97f9'),
            ('1m/chedar_0876_UV1m.sofa', 'c4d01ec310697cc1abcb241608ee2734'),
            ('1m/chedar_0877_UV1m.sofa', 'f2cdefeb044213a7b563406ac9cf3e99'),
            ('1m/chedar_0878_UV1m.sofa', '9893fb943f59f685f5937021f108b74d'),
            ('1m/chedar_0879_UV1m.sofa', '7b39bbcf6d2718410a82bd68ee41c2ad'),
            ('1m/chedar_0880_UV1m.sofa', '2135573dc81a49b7e67885e742cd1506'),
            ('1m/chedar_0881_UV1m.sofa', '44c2d7c59434b158972462370b82db9d'),
            ('1m/chedar_0882_UV1m.sofa', '697c39b9ed226d13108062acc4f5ed71'),
            ('1m/chedar_0883_UV1m.sofa', '73a0fbd993b35788eb885d2483f4816a'),
            ('1m/chedar_0884_UV1m.sofa', '1ccc675b867320b90a80547da7b6feb3'),
            ('1m/chedar_0885_UV1m.sofa', 'f5a6e06e188b95aeb4b6180022097e15'),
            ('1m/chedar_0886_UV1m.sofa', '3ea1e88189c8009a18761935e3dd7743'),
            ('1m/chedar_0887_UV1m.sofa', 'd19232daaaa02ebce1edecc3efea4994'),
            ('1m/chedar_0888_UV1m.sofa', '61f714984fb7f6756e70bc436ce7444e'),
            ('1m/chedar_0889_UV1m.sofa', '862b16daede55e3a0e7f257c5f4bacd3'),
            ('1m/chedar_0890_UV1m.sofa', '25ecfdd0ad906f0426e88c14ed7168fb'),
            ('1m/chedar_0891_UV1m.sofa', '8f62dba391ac8b67181f08b1078950ae'),
            ('1m/chedar_0892_UV1m.sofa', '25a7ea309531065e6cb2f22f669a45d3'),
            ('1m/chedar_0893_UV1m.sofa', '27a57efa2bdeaf090dd5fee7aaf0f815'),
            ('1m/chedar_0894_UV1m.sofa', '94df778117c97f1f575f057e172ec10f'),
            ('1m/chedar_0895_UV1m.sofa', '36e45c8971ca4c891a65cbfeaf692e18'),
            ('1m/chedar_0896_UV1m.sofa', '0673226aca4537e7bd453eab3549a82a'),
            ('1m/chedar_0897_UV1m.sofa', '11367c71fc15d28e3b78fbf3b1c95171'),
            ('1m/chedar_0898_UV1m.sofa', 'd2348f13d492a13803c8ec176c311afd'),
            ('1m/chedar_0899_UV1m.sofa', '8c82e2db4fc9b74ae469bd2517ba01b0'),
            ('1m/chedar_0900_UV1m.sofa', 'ab14974497c57295ec1d54e6c6dd696c'),
            ('1m/chedar_0901_UV1m.sofa', 'cd979a173aa185919b963967c5ade017'),
            ('1m/chedar_0902_UV1m.sofa', 'f63b89f4cb5cdcd17e8ff2740a7e2873'),
            ('1m/chedar_0903_UV1m.sofa', '1faf9b8e409f026c680fce801286d87b'),
            ('1m/chedar_0904_UV1m.sofa', '048c273a43b72c39e24f39e3fbf3a076'),
            ('1m/chedar_0905_UV1m.sofa', '5bd711c1c10ef1e022e84fea752e3a02'),
            ('1m/chedar_0906_UV1m.sofa', '1b1c90864f809aa687969079dfd7a721'),
            ('1m/chedar_0907_UV1m.sofa', 'c1122ab4e6549ff69a3ad981979527e9'),
            ('1m/chedar_0908_UV1m.sofa', 'c419d7cbf0ef3976b2a498183ba65ada'),
            ('1m/chedar_0909_UV1m.sofa', '0ef97a90181061cf89509f0ea9e6a5fc'),
            ('1m/chedar_0910_UV1m.sofa', '1e76e2c1a69ed1bf05968daf4a1f8670'),
            ('1m/chedar_0911_UV1m.sofa', '6911f102ec0808cbe3ab001c89e5fd57'),
            ('1m/chedar_0912_UV1m.sofa', '98f6965d3a6e5fa9b009d3931d7a5720'),
            ('1m/chedar_0913_UV1m.sofa', 'e4c15d14a94af284dcc6e5ac75f8881b'),
            ('1m/chedar_0914_UV1m.sofa', '9721f8e0a2c74af817825451931fc2be'),
            ('1m/chedar_0915_UV1m.sofa', 'd2be099a4f4de378e3ee03e527431d30'),
            ('1m/chedar_0916_UV1m.sofa', 'ce27d29192a94b0dd9a30c6b82188718'),
            ('1m/chedar_0917_UV1m.sofa', '9b0ceae15b7e495137eb9343ded710b5'),
            ('1m/chedar_0918_UV1m.sofa', '4d307f47ac0d8638155fdea8e5e8fe42'),
            ('1m/chedar_0919_UV1m.sofa', '2f2f601c396f3d1e790f2f8570884809'),
            ('1m/chedar_0920_UV1m.sofa', 'f37ab4f05b7a53da85ab78c7b84f7b96'),
            ('1m/chedar_0921_UV1m.sofa', '868dee12eb8cbe6fb9b2b9942e17d727'),
            ('1m/chedar_0922_UV1m.sofa', 'd19cbe89e13750ae6ec1e4d01bea1829'),
            ('1m/chedar_0923_UV1m.sofa', 'f69813540f79f72bfb004dd631740026'),
            ('1m/chedar_0924_UV1m.sofa', '1932de14547cebfd90ce97da37903d09'),
            ('1m/chedar_0925_UV1m.sofa', '7b7b4c4b7c81887f32fa05c9464b4288'),
            ('1m/chedar_0926_UV1m.sofa', 'adb77d0cf4539fdb873241a2f3c785e0'),
            ('1m/chedar_0927_UV1m.sofa', '3246eea110ae48d676e1f6e8a1d2219e'),
            ('1m/chedar_0928_UV1m.sofa', 'e4692acc1d9945a45440779afc794771'),
            ('1m/chedar_0929_UV1m.sofa', '8d51744c4a9c00b73035aee1dc6f7d5c'),
            ('1m/chedar_0930_UV1m.sofa', 'b84dc4e3cd9619823416125545bc438f'),
            ('1m/chedar_0931_UV1m.sofa', 'd41ce2af1866768174aee810803efbac'),
            ('1m/chedar_0932_UV1m.sofa', '0f798aa3925033268cc810b59044d3b0'),
            ('1m/chedar_0933_UV1m.sofa', 'dbfbdcafc7a3da490f50fa1715d8ce7f'),
            ('1m/chedar_0934_UV1m.sofa', '92eba44d6eeb4d04b7c2559b9ace3199'),
            ('1m/chedar_0935_UV1m.sofa', 'aa6982dea401bea30ca2ca6ba7477059'),
            ('1m/chedar_0936_UV1m.sofa', 'b8af7e86fdd91c13a886444816743aa6'),
            ('1m/chedar_0937_UV1m.sofa', '5dc002b41f7cdab26b19912063de6fbc'),
            ('1m/chedar_0938_UV1m.sofa', 'd2a13216e687599cea0f8b636aafa2ae'),
            ('1m/chedar_0939_UV1m.sofa', '3a6f39c5493d89b21ef154a3e4a109c6'),
            ('1m/chedar_0940_UV1m.sofa', 'c6994e24d8266b0998d310ee29de87ed'),
            ('1m/chedar_0941_UV1m.sofa', '42951a249577e2d94a3bb15c1fd3dcbd'),
            ('1m/chedar_0942_UV1m.sofa', '56c20b95a616df744d3f8740600ad3aa'),
            ('1m/chedar_0943_UV1m.sofa', 'e7234dfdd4a9b3da11e63ae4dca91436'),
            ('1m/chedar_0944_UV1m.sofa', '10f619f70aa72329453150b85da733b8'),
            ('1m/chedar_0945_UV1m.sofa', '8517af1004cdaef5e4d57ab5cd34a954'),
            ('1m/chedar_0946_UV1m.sofa', '622bfea4b9be167decc1040256425dd8'),
            ('1m/chedar_0947_UV1m.sofa', '52deb64dea5725bdf7a17ee29e770304'),
            ('1m/chedar_0948_UV1m.sofa', 'dea08a396c8c598d1bbc08fbad7ec230'),
            ('1m/chedar_0949_UV1m.sofa', '8b650c7c1ac6f584b5d16058b98d2464'),
            ('1m/chedar_0950_UV1m.sofa', 'be3131037b55ce35b589cda1fc6e5a8b'),
            ('1m/chedar_0951_UV1m.sofa', 'abd5738a91c867f3f5b4935cfd3e9303'),
            ('1m/chedar_0952_UV1m.sofa', '0307a3b1ebbdced4c399fd45c6212dad'),
            ('1m/chedar_0953_UV1m.sofa', '6b30c0064c85bc604d6d55e2cc320ff9'),
            ('1m/chedar_0954_UV1m.sofa', '117f8a4ac759e29c1ceca69b097de45d'),
            ('1m/chedar_0955_UV1m.sofa', '014c6cb3772b8c1fb642e3fd91e471d2'),
            ('1m/chedar_0956_UV1m.sofa', 'ab69f63d4b5e38ba04bbb263db566a40'),
            ('1m/chedar_0957_UV1m.sofa', '498e8a751c863a9882b4de6b7b2c53fd'),
            ('1m/chedar_0958_UV1m.sofa', 'c0ccb467d43bba721f8a4494c3c6266e'),
            ('1m/chedar_0959_UV1m.sofa', 'eb251dd7cba1d4d0ce592cd0979114e5'),
            ('1m/chedar_0960_UV1m.sofa', 'ebe2ae4ae824fe4f5b8413a0b2cf9673'),
            ('1m/chedar_0961_UV1m.sofa', 'a5f60cf49be753828ed161648c50fde1'),
            ('1m/chedar_0962_UV1m.sofa', 'bd3d424bb4f81fb4ce3d6f46c068e52e'),
            ('1m/chedar_0963_UV1m.sofa', 'c2d54026b45936cb3425794bdcb276e4'),
            ('1m/chedar_0964_UV1m.sofa', 'cedad1baabcef38c2c2766d28ed263da'),
            ('1m/chedar_0965_UV1m.sofa', 'b61824ad27bcf1113c36e8f978f38a34'),
            ('1m/chedar_0966_UV1m.sofa', 'c1d82f7669c6a26c28a9fe937eca20a9'),
            ('1m/chedar_0967_UV1m.sofa', '278fc94187815bf364bf7dc1061a3b3b'),
            ('1m/chedar_0968_UV1m.sofa', 'd9aff79aa9f7efd51a539eb43e4cbc82'),
            ('1m/chedar_0969_UV1m.sofa', '00a6d6d6b51702ad042ae81a69f89621'),
            ('1m/chedar_0970_UV1m.sofa', 'b0b8df830318843cc073751b1b58d533'),
            ('1m/chedar_0971_UV1m.sofa', '4b7928f2a73ccff2511b7c4cca1d793b'),
            ('1m/chedar_0972_UV1m.sofa', '8d2234f01d9726aa807bca7685a8983d'),
            ('1m/chedar_0973_UV1m.sofa', '43a0340dbdafbf5976923bfe050987ed'),
            ('1m/chedar_0974_UV1m.sofa', '17093a7ebfc073d5568577ba79bee5b1'),
            ('1m/chedar_0975_UV1m.sofa', 'd08bdfa467d8303dccfb529e5bfc3054'),
            ('1m/chedar_0976_UV1m.sofa', '03514a585be7f5c2d8d22a945fbcfad3'),
            ('1m/chedar_0977_UV1m.sofa', '8b6b361eac95872619d01912b40f4706'),
            ('1m/chedar_0978_UV1m.sofa', 'abc2b471f0a156a288f2e57cbc8f8bc6'),
            ('1m/chedar_0979_UV1m.sofa', '472138c914d41bc76123e4842b482b03'),
            ('1m/chedar_0980_UV1m.sofa', '65f0b9ff8f58a91d9596dd9b7cc789fa'),
            ('1m/chedar_0981_UV1m.sofa', '86d19d228383ea15b831719aa316ff67'),
            ('1m/chedar_0982_UV1m.sofa', '8c39a0eb376e61d5e906b5697dcbbc39'),
            ('1m/chedar_0983_UV1m.sofa', '19905c7f2adc058ce026536a2ecf726b'),
            ('1m/chedar_0984_UV1m.sofa', 'bfde98161b764b3bcf404df119799d01'),
            ('1m/chedar_0985_UV1m.sofa', '23a6c95c522d14513a7fa0db65bb456e'),
            ('1m/chedar_0986_UV1m.sofa', 'a1c97913807de1529d7cead7a1b2662d'),
            ('1m/chedar_0987_UV1m.sofa', 'ab0048dd792442178ee36f37df7f31b0'),
            ('1m/chedar_0988_UV1m.sofa', '3cea045ca1b8c217dcd327c8e48b545f'),
            ('1m/chedar_0989_UV1m.sofa', '520504caef1d78744f60f54b7cb67fa6'),
            ('1m/chedar_0990_UV1m.sofa', 'c9310458e58058ee3e43d1470bb59bba'),
            ('1m/chedar_0991_UV1m.sofa', 'd2b77b62262394a4618902461afa113b'),
            ('1m/chedar_0992_UV1m.sofa', 'a1dc0d5cd3488499a5dcf2021840f675'),
            ('1m/chedar_0993_UV1m.sofa', '3c750da2d88ee7438cdb856033de11ec'),
            ('1m/chedar_0994_UV1m.sofa', '8f62d9b86b73b3ac927b95b9278c40d4'),
            ('1m/chedar_0995_UV1m.sofa', '9a5e7b14cf74840c99511a478d1db9de'),
            ('1m/chedar_0996_UV1m.sofa', '8502f46b09f12df10ef243427c171f81'),
            ('1m/chedar_0997_UV1m.sofa', 'd14b51f3b03d14357f55b96288b1a226'),
            ('1m/chedar_0998_UV1m.sofa', '7be3a9539ef5a1a5c9ea0639d5b0b0d4'),
            ('1m/chedar_0999_UV1m.sofa', 'eecfda4a6691ad095ad6bd98ef714f4e'),
            ('1m/chedar_1000_UV1m.sofa', 'c4a74d2aeb346ac3ce14437fe417d2a0'),
            ('1m/chedar_1001_UV1m.sofa', '128d1594f39d17bd3de37616aede019e'),
            ('1m/chedar_1002_UV1m.sofa', '64b13f2f72076b939211d2d685084b55'),
            ('1m/chedar_1003_UV1m.sofa', 'eb5983d93245fe2f53d09fc0b20f4fd8'),
            ('1m/chedar_1004_UV1m.sofa', 'ebe4504a6cc048bca0f4296ae9d9e8d3'),
            ('1m/chedar_1005_UV1m.sofa', '14134e339aed407ce47086eb3bba4ec1'),
            ('1m/chedar_1006_UV1m.sofa', 'dbccc6493c1e0547f7da2cc1dc230289'),
            ('1m/chedar_1007_UV1m.sofa', 'f1ce2cf13f9882c8ac754d9faf73ce8f'),
            ('1m/chedar_1008_UV1m.sofa', 'c577c17e3604dbd3b8de9fe9ca4a6a28'),
            ('1m/chedar_1009_UV1m.sofa', '48c4052e743548ff26db93753dbcc7f4'),
            ('1m/chedar_1010_UV1m.sofa', 'efe14a374d932f8bcd9dda378482519f'),
            ('1m/chedar_1011_UV1m.sofa', '2df159780b7fb6fe28509546073159ca'),
            ('1m/chedar_1012_UV1m.sofa', '5790d471f629d7112f10c021bd4fb08f'),
            ('1m/chedar_1013_UV1m.sofa', '6dbbc28312acdc7518afd82726a35a50'),
            ('1m/chedar_1014_UV1m.sofa', 'f268a2b41f5b80f543608278e5bda674'),
            ('1m/chedar_1015_UV1m.sofa', '0de7a99a3248527a297a5f3633562b84'),
            ('1m/chedar_1016_UV1m.sofa', '9f5ecc733f01902c0a3814a0b9a041a1'),
            ('1m/chedar_1017_UV1m.sofa', 'f85b2e7913b7b75be204def5efbd29cd'),
            ('1m/chedar_1018_UV1m.sofa', '988dab804a5467c24622629f71dc3b06'),
            ('1m/chedar_1019_UV1m.sofa', 'bb9a012072d298c659da8d202d77e8d7'),
            ('1m/chedar_1020_UV1m.sofa', '207464886aec518e1f077daeacd514de'),
            ('1m/chedar_1021_UV1m.sofa', '223d8ccea8ef84a88b2fe214a17ce251'),
            ('1m/chedar_1022_UV1m.sofa', '14b9616b36714b8f5810c28760bb39f5'),
            ('1m/chedar_1023_UV1m.sofa', '0b302c0d06b34cf6c4f584d94b8a58b0'),
            ('1m/chedar_1024_UV1m.sofa', '5f48373854f95d0b851dcac44a0ca1df'),
            ('1m/chedar_1025_UV1m.sofa', 'e427327f0c2ff88b38bc50b2947b10d6'),
            ('1m/chedar_1026_UV1m.sofa', 'f6a7e4b72b0acad0f51d34a46ac61638'),
            ('1m/chedar_1027_UV1m.sofa', '178d9193b2bdc21e12dd46cf52aee943'),
            ('1m/chedar_1028_UV1m.sofa', '715df6305ddc86cabfac36f6404509ec'),
            ('1m/chedar_1029_UV1m.sofa', 'f1fd638bb339b267571acc647728f389'),
            ('1m/chedar_1030_UV1m.sofa', '1d381bbe1576907bf9938f400003f9a6'),
            ('1m/chedar_1031_UV1m.sofa', 'a52c240682240fc285ac257449a1a196'),
            ('1m/chedar_1032_UV1m.sofa', 'fed9b2d4e272d15f50e6854c7c380381'),
            ('1m/chedar_1033_UV1m.sofa', '44f53dfcc0ee0f3145078b4e6b14681b'),
            ('1m/chedar_1034_UV1m.sofa', 'bc33a697ca77ec81181dc4642d53d4ef'),
            ('1m/chedar_1035_UV1m.sofa', '5602400ca45f19d89376207143854272'),
            ('1m/chedar_1036_UV1m.sofa', '4a2bb474e7995445eb09a5aa0399cdea'),
            ('1m/chedar_1037_UV1m.sofa', '578828fdd898d2137879b0499123b425'),
            ('1m/chedar_1038_UV1m.sofa', 'e858a1158e4eb113872bc62a86d92ba0'),
            ('1m/chedar_1039_UV1m.sofa', '8be5273db4aa47a081597eb0b059bb29'),
            ('1m/chedar_1040_UV1m.sofa', 'da87d2e89cb02f7d6ba43a47c15ce0e8'),
            ('1m/chedar_1041_UV1m.sofa', '024624cfa04e78474c34a55d9318864c'),
            ('1m/chedar_1042_UV1m.sofa', '879aea01c58ae65ee5e613068f72fca2'),
            ('1m/chedar_1043_UV1m.sofa', '7a71bec63e0b075a8fdc39f8c6f49824'),
            ('1m/chedar_1044_UV1m.sofa', 'cc94c9688d12dfc31e76bfade685cb15'),
            ('1m/chedar_1045_UV1m.sofa', '71a5741ca2fa575eb2dbe91ceb936a40'),
            ('1m/chedar_1046_UV1m.sofa', 'ce4a72a6ceb578b399b135abc1799d0c'),
            ('1m/chedar_1047_UV1m.sofa', '1de7fc617d7d1999c996d94fc9c934ac'),
            ('1m/chedar_1048_UV1m.sofa', '474dae028b15f43d54d9e08e80e48fa2'),
            ('1m/chedar_1049_UV1m.sofa', '55f459bdf8ddbd98950a8cf5e3859116'),
            ('1m/chedar_1050_UV1m.sofa', 'e4e4f6a83cd57d1f063b9bf001638543'),
            ('1m/chedar_1051_UV1m.sofa', 'c5645d4feb569325cb8cb5dec2d04934'),
            ('1m/chedar_1052_UV1m.sofa', '40d1c5f277c5ff0a037c608656840584'),
            ('1m/chedar_1053_UV1m.sofa', '360a296ccd057e353f4827cfee1bc2bf'),
            ('1m/chedar_1054_UV1m.sofa', '65e241237b94fe686f0f8f8d2f29ee31'),
            ('1m/chedar_1055_UV1m.sofa', '4b552319f4772c5f116354656cc74a17'),
            ('1m/chedar_1056_UV1m.sofa', '686fb3e7c06f87c50d1146aa4bd2d4fc'),
            ('1m/chedar_1057_UV1m.sofa', '1da6d7297576671aeb4a4df67ea8e0d5'),
            ('1m/chedar_1058_UV1m.sofa', '3722df931c2d1affc6ca67d22628c749'),
            ('1m/chedar_1059_UV1m.sofa', '51584fbb32969aec7ddf18a5fe348898'),
            ('1m/chedar_1060_UV1m.sofa', '408dee6765baee929ca1477eaae4f35c'),
            ('1m/chedar_1061_UV1m.sofa', 'ce9598068b43cfb01999544f418caf1f'),
            ('1m/chedar_1062_UV1m.sofa', 'c2583c769dddad13f318f307e81b8f43'),
            ('1m/chedar_1063_UV1m.sofa', '590fdb5fabc3207a1885aae9732b5794'),
            ('1m/chedar_1064_UV1m.sofa', 'f79f8ab17ed400d6f199950c2c89e556'),
            ('1m/chedar_1065_UV1m.sofa', '006c19b3b18eaa89dd09b1691f5c5f85'),
            ('1m/chedar_1066_UV1m.sofa', '0ddf09bb34e519f3d94e7d8dfa97e078'),
            ('1m/chedar_1067_UV1m.sofa', 'd4e11d951a97c7fb48077d1a481c54e0'),
            ('1m/chedar_1068_UV1m.sofa', '1a0f478edfa5c664001401c56e0dd3ee'),
            ('1m/chedar_1069_UV1m.sofa', '52027a8898ad65f1f034f05796d48d3c'),
            ('1m/chedar_1070_UV1m.sofa', 'd4566c531765d32f9d1051b6cc74d673'),
            ('1m/chedar_1071_UV1m.sofa', '39995f4ecbc4c41370d8f589e5c1af78'),
            ('1m/chedar_1072_UV1m.sofa', '8a83e315250c01c46d34ffcac934084b'),
            ('1m/chedar_1073_UV1m.sofa', '6fb6757e24e4e368eb4ddced70b8b16d'),
            ('1m/chedar_1074_UV1m.sofa', 'c3cb0e56161ad2d8ff1df3a2d55abcc9'),
            ('1m/chedar_1075_UV1m.sofa', '920ae62ef97aff67c1a793f282d4b37b'),
            ('1m/chedar_1076_UV1m.sofa', '16023fef38ad07472dec5f427d79791a'),
            ('1m/chedar_1077_UV1m.sofa', '61b33b4be53653245df9beb1a9a2e180'),
            ('1m/chedar_1078_UV1m.sofa', 'c0c2d8082f8eaba28f4de29dc0b42577'),
            ('1m/chedar_1079_UV1m.sofa', '1f6943e1681b7d7b34bd107a4935bc67'),
            ('1m/chedar_1080_UV1m.sofa', 'e7628bb748e90147f6afd1a7faa44b72'),
            ('1m/chedar_1081_UV1m.sofa', 'eaba4d80a01c8ba82341bd1a2b6bc5e7'),
            ('1m/chedar_1082_UV1m.sofa', '55d72bd137e4c9fe6a802c1363477368'),
            ('1m/chedar_1083_UV1m.sofa', '0fb60d3e4480b931fb5cb6233d8260e3'),
            ('1m/chedar_1084_UV1m.sofa', '643dc6384f2e32637d759066467f9c3e'),
            ('1m/chedar_1085_UV1m.sofa', '2e2aa14717d6d4d932dd8edc243d6116'),
            ('1m/chedar_1086_UV1m.sofa', 'a59e123eb6364630edd0f27bcb1ddea8'),
            ('1m/chedar_1087_UV1m.sofa', 'cbc13df6a6af0191260cd8e9dc7b1b48'),
            ('1m/chedar_1088_UV1m.sofa', 'c0c2bdca64e96b02b4be7212bdfd7b66'),
            ('1m/chedar_1089_UV1m.sofa', 'f8de4788e7ca2f995f0b860605f78af9'),
            ('1m/chedar_1090_UV1m.sofa', '4c0fdf202028eb422bcb9ffc1c2baea7'),
            ('1m/chedar_1091_UV1m.sofa', '0124a732f2bf1343c6a8962776345221'),
            ('1m/chedar_1092_UV1m.sofa', 'f25d64f4e6d6613e1c29d7086a8c5b70'),
            ('1m/chedar_1093_UV1m.sofa', '4fce8f413402816b634049cf1e63c7fe'),
            ('1m/chedar_1094_UV1m.sofa', '6cd6c1555f4073e500a1243b45ac7915'),
            ('1m/chedar_1095_UV1m.sofa', 'ad940acbf8c0031f68863a48141a6820'),
            ('1m/chedar_1096_UV1m.sofa', 'd45a7a05293fc846ec2669e825a9d1b5'),
            ('1m/chedar_1097_UV1m.sofa', '693de7a092b4b86d6d9a0cebbfe7502d'),
            ('1m/chedar_1098_UV1m.sofa', '5f1ce7c8f631d7b220f7631f1d709e28'),
            ('1m/chedar_1099_UV1m.sofa', 'c20e3773b2f53b94f5002ff3e19d61c4'),
            ('1m/chedar_1100_UV1m.sofa', '86c62dc394459b5a5cd76265d9a07e1b'),
            ('1m/chedar_1101_UV1m.sofa', '120efe8153c569718d75fe1c0aa77d5f'),
            ('1m/chedar_1102_UV1m.sofa', '4bbe324a75ae9d0bfea59de5d089af57'),
            ('1m/chedar_1103_UV1m.sofa', '203130573204c1c10cf7b764914154da'),
            ('1m/chedar_1104_UV1m.sofa', '61d492c62829e507e85658ec1343ed7c'),
            ('1m/chedar_1105_UV1m.sofa', 'ac7f4907ef83de977685fbbbdcf82124'),
            ('1m/chedar_1106_UV1m.sofa', '6484ccfdda8eb3064ab31edc6b9d5ca4'),
            ('1m/chedar_1107_UV1m.sofa', 'b82440faee50ad3b65ed9d4d41a7bc6a'),
            ('1m/chedar_1108_UV1m.sofa', '14652b2a9da6f72210fbb79fce8ad0f9'),
            ('1m/chedar_1109_UV1m.sofa', '24e8a8e77d10e989a7009ffe3b305c03'),
            ('1m/chedar_1110_UV1m.sofa', 'df8fb79623e0d694ebf2fee41d3534d2'),
            ('1m/chedar_1111_UV1m.sofa', '7f1e3b7ae57f565858f51fc5a1b46f99'),
            ('1m/chedar_1112_UV1m.sofa', '911eaad8d14f2f4d0b9f4eab9eb0f6ec'),
            ('1m/chedar_1113_UV1m.sofa', '556ef9b297f54221ac2c4a5838993d65'),
            ('1m/chedar_1114_UV1m.sofa', '598f5ccd9a5aac1997ed332798a51803'),
            ('1m/chedar_1115_UV1m.sofa', '0b4890ecd72797756eec869b793b6e8d'),
            ('1m/chedar_1116_UV1m.sofa', '487365fae7c9da64bf4926885eb60936'),
            ('1m/chedar_1117_UV1m.sofa', 'aef02eb5f2fb2402202e8a2d427e735a'),
            ('1m/chedar_1118_UV1m.sofa', 'd1784504c49e78ed4eb55d21791aca5c'),
            ('1m/chedar_1119_UV1m.sofa', '558cbea8abbb389b3ed99c30901fba29'),
            ('1m/chedar_1120_UV1m.sofa', 'ff9b98697c9b8ff250243ff8ce09351e'),
            ('1m/chedar_1121_UV1m.sofa', 'a263daaf39667a2fa8ea22302f0d6da9'),
            ('1m/chedar_1122_UV1m.sofa', 'e12bb8638f052f22bf542557dcfad873'),
            ('1m/chedar_1123_UV1m.sofa', 'e5a44dc32b09a982d040035a45b1bca8'),
            ('1m/chedar_1124_UV1m.sofa', '80b4eb8220fcaf71e8b29390619a1f22'),
            ('1m/chedar_1125_UV1m.sofa', 'ec51a45de3b1e0b3ab4fc8f93e2ce0ac'),
            ('1m/chedar_1126_UV1m.sofa', '9b23b8c5acd3a7f356953b98fc0a0739'),
            ('1m/chedar_1127_UV1m.sofa', '99910c14248648f688fb277c762ab122'),
            ('1m/chedar_1128_UV1m.sofa', '35772818c6d3e99075064b913c37b6cb'),
            ('1m/chedar_1129_UV1m.sofa', 'bca2f1ae5142e139303cad46b88df8b1'),
            ('1m/chedar_1130_UV1m.sofa', '90693b79f7517f6319e333cf7ec7e7b1'),
            ('1m/chedar_1131_UV1m.sofa', 'a861298c3277c4fdfca6523a203ab4e9'),
            ('1m/chedar_1132_UV1m.sofa', 'ba852de00ff2fc9d4755d458de700fbc'),
            ('1m/chedar_1133_UV1m.sofa', 'bbd8f65924bf0440575ecd697cca49ca'),
            ('1m/chedar_1134_UV1m.sofa', '8c0854f33103336ed344cb1725fcdf7e'),
            ('1m/chedar_1135_UV1m.sofa', '859625b4359d067f512c7e241b983e04'),
            ('1m/chedar_1136_UV1m.sofa', 'd5008166b394e8361377aabbe80cd7b3'),
            ('1m/chedar_1137_UV1m.sofa', '37efe636aaff4c66a9fa008c9d1ca311'),
            ('1m/chedar_1138_UV1m.sofa', '211b13f3240c865587ff49c33ae7d05f'),
            ('1m/chedar_1139_UV1m.sofa', 'c51075d9721333646e19be329d700a7c'),
            ('1m/chedar_1140_UV1m.sofa', '6456c7742b0d85615d78085fa48e12b2'),
            ('1m/chedar_1141_UV1m.sofa', '411fc29b3b030eda25540815ddd21a57'),
            ('1m/chedar_1142_UV1m.sofa', '7dc9cea00e802056495b0b9a201c3ba4'),
            ('1m/chedar_1143_UV1m.sofa', '0710383bce9fbf37a6a736764b5aea13'),
            ('1m/chedar_1144_UV1m.sofa', 'd3e0efb70e44a2a74ac8cc38e0c9cea5'),
            ('1m/chedar_1145_UV1m.sofa', '5094660f7f42449e4ed0b6302abf1f7a'),
            ('1m/chedar_1146_UV1m.sofa', '87de429375403419ac02e7008c80bba8'),
            ('1m/chedar_1147_UV1m.sofa', '9aa4c8ba2468ded285805e536822fc3f'),
            ('1m/chedar_1148_UV1m.sofa', '02e3d2bc56f4846fbc61961bdf1f3c5c'),
            ('1m/chedar_1149_UV1m.sofa', '37845039e063a5ddadfa055a8f1d41c7'),
            ('1m/chedar_1150_UV1m.sofa', '3f57c5aafa7c8433872cd9819281703a'),
            ('1m/chedar_1151_UV1m.sofa', '9254f5fdc278d32ba7124ec3a5349761'),
            ('1m/chedar_1152_UV1m.sofa', 'bb380212d17cfac0cb932f13bc32c42c'),
            ('1m/chedar_1153_UV1m.sofa', '420bb8a2290ebb80cb016abe3d402b32'),
            ('1m/chedar_1154_UV1m.sofa', 'b83dbda93c3d0218b0383487ebce399f'),
            ('1m/chedar_1155_UV1m.sofa', '4a45476cc06b7a7822ae41e454a7bb22'),
            ('1m/chedar_1156_UV1m.sofa', 'b063bc4d4e19d6e59bb0a02224115e73'),
            ('1m/chedar_1157_UV1m.sofa', '14b78118bcb4b2d6385ae1c6422c309c'),
            ('1m/chedar_1158_UV1m.sofa', '8e6650eb2f53824f1a3bbd5598210280'),
            ('1m/chedar_1159_UV1m.sofa', '27061f8f94b86d34f99d7bea7a9c514b'),
            ('1m/chedar_1160_UV1m.sofa', '26f1430a9b8068125e06711d24f38093'),
            ('1m/chedar_1161_UV1m.sofa', 'ae8939adb7a9b15de03bfe232649874a'),
            ('1m/chedar_1162_UV1m.sofa', '088eed6dce52f1054e024eaec2e319a3'),
            ('1m/chedar_1163_UV1m.sofa', 'c3fce40a0fb3dde66e3b0386d659958e'),
            ('1m/chedar_1164_UV1m.sofa', '6f7d1483ea016b97798d73ebbe9230cc'),
            ('1m/chedar_1165_UV1m.sofa', 'e561427efc7fa6c5f411a9d872d0719c'),
            ('1m/chedar_1166_UV1m.sofa', '1e8fd4ae55d63e39e5236de3886c0c56'),
            ('1m/chedar_1167_UV1m.sofa', 'd24f10e6749dfccdad4a8b9808b87575'),
            ('1m/chedar_1168_UV1m.sofa', 'b4d685a0987ce6fc898e2bab8da91f01'),
            ('1m/chedar_1169_UV1m.sofa', 'f24c1685278e33f5da39b01b491035ad'),
            ('1m/chedar_1170_UV1m.sofa', 'eadcc687528f2308d5138e6340962645'),
            ('1m/chedar_1171_UV1m.sofa', '3921d78593fa9cbcfbe9c2d6ac1ffea5'),
            ('1m/chedar_1172_UV1m.sofa', '630e8e5b79d83e9a09734e923204f0ac'),
            ('1m/chedar_1173_UV1m.sofa', '77de48cd78d1dd40a85fab66eb068fde'),
            ('1m/chedar_1174_UV1m.sofa', 'ab5734e0dcb8faae53f28ecbefe50f85'),
            ('1m/chedar_1175_UV1m.sofa', 'b3641454bb2163ec8065bd9b5acbfdc3'),
            ('1m/chedar_1176_UV1m.sofa', 'c122efd0af5bd44a6a61be0ddb7f4fe2'),
            ('1m/chedar_1177_UV1m.sofa', '59b34d1d90241f9e0ad58052ba18d88d'),
            ('1m/chedar_1178_UV1m.sofa', '8ce857545a9b7ecaafef92764ccf679e'),
            ('1m/chedar_1179_UV1m.sofa', 'b755d477d4ec67fc0810e07904e9ecd4'),
            ('1m/chedar_1180_UV1m.sofa', '9770d001ed26269b85acdc6d8975332a'),
            ('1m/chedar_1181_UV1m.sofa', '31dd11978c0c0cafb11ad14a831e4af2'),
            ('1m/chedar_1182_UV1m.sofa', 'ade82398911ab457e0ff31e33ac3b5d5'),
            ('1m/chedar_1183_UV1m.sofa', '2d53fa1dddfbe90bd8a3bcd96399ea86'),
            ('1m/chedar_1184_UV1m.sofa', '3de5cb87b621e1324619ac4d30cc9e5b'),
            ('1m/chedar_1185_UV1m.sofa', '3ac7d189fe6063b57d725b6470b80956'),
            ('1m/chedar_1186_UV1m.sofa', 'c6bcf4f03bf495c429a9d1db6c0ffd87'),
            ('1m/chedar_1187_UV1m.sofa', '19bd19860095389fd6776288eca8dc91'),
            ('1m/chedar_1188_UV1m.sofa', '49be68f67083fbfdacba3bca744db96b'),
            ('1m/chedar_1189_UV1m.sofa', '5c4c54dfa1108a95a6653e1ce10a882f'),
            ('1m/chedar_1190_UV1m.sofa', 'b20b4e0fa84cc3c9d9d5aba925f282c5'),
            ('1m/chedar_1191_UV1m.sofa', '46896b3997534254b85b6f2780f25c60'),
            ('1m/chedar_1192_UV1m.sofa', 'ba87f6d09de22bafbd18b6abf8ba2f74'),
            ('1m/chedar_1193_UV1m.sofa', 'd37075f6afff8b1a36e3405dbb3d97fc'),
            ('1m/chedar_1194_UV1m.sofa', 'c50d338483547a33c004c9833e39a3b5'),
            ('1m/chedar_1195_UV1m.sofa', '2e2e675eefb1fff6d63a2526f44064a1'),
            ('1m/chedar_1196_UV1m.sofa', 'a57578a81eda96ae51534fcaac49782a'),
            ('1m/chedar_1197_UV1m.sofa', 'e7717ec326bcf077bafae8fb94fa5e99'),
            ('1m/chedar_1198_UV1m.sofa', '201743470da7ed78bc10eb1ef1bfbb67'),
            ('1m/chedar_1199_UV1m.sofa', '49ac143dccd62659595f8b5ae9fcca44'),
            ('1m/chedar_1200_UV1m.sofa', '299b110e760c5da54dde5bb630633367'),
            ('1m/chedar_1201_UV1m.sofa', 'cbffb7c2299a0d420f0080885a24e7f4'),
            ('1m/chedar_1202_UV1m.sofa', '62112edd23e7a1aa177c1a4a03061dd0'),
            ('1m/chedar_1203_UV1m.sofa', '48f56cb7ca1055a354a472e3542551a3'),
            ('1m/chedar_1204_UV1m.sofa', '8bdea5fd252785117ba80604f8941fd0'),
            ('1m/chedar_1205_UV1m.sofa', '8a08a0fd171a9651c2c9389c19fee67d'),
            ('1m/chedar_1206_UV1m.sofa', '553bc42ebe7ef79bc59a4f2c59c89e6f'),
            ('1m/chedar_1207_UV1m.sofa', 'dfe10a9b60a0a43708be5c5cab6e6f74'),
            ('1m/chedar_1208_UV1m.sofa', '8ceb281050753e3d5a8eedd39066f8e0'),
            ('1m/chedar_1209_UV1m.sofa', 'fff8a825f5497ace0546ac2909f38969'),
            ('1m/chedar_1210_UV1m.sofa', '00a16266043bb1b0e2bae27698b7a440'),
            ('1m/chedar_1211_UV1m.sofa', '265ca5e555c053600558dbc6baf2a942'),
            ('1m/chedar_1212_UV1m.sofa', 'b8fea02d521a56690eb185c002aa9b10'),
            ('1m/chedar_1213_UV1m.sofa', 'c6fdd3fc9a2049750f4a5059cec6f242'),
            ('1m/chedar_1214_UV1m.sofa', 'ea4f248f5d9d0f583cb97ce10f22bfde'),
            ('1m/chedar_1215_UV1m.sofa', '32ff9ad03a522c8c30c160695500a7a2'),
            ('1m/chedar_1216_UV1m.sofa', 'a0746be506a468c1941bcf9f53cafeff'),
            ('1m/chedar_1217_UV1m.sofa', '9d76ee789f34c701d753c257d52b3210'),
            ('1m/chedar_1218_UV1m.sofa', 'c7c98df964f0e80a20af3cd4de558954'),
            ('1m/chedar_1219_UV1m.sofa', 'de4a303d99ec0ba0cd119dfa734e595c'),
            ('1m/chedar_1220_UV1m.sofa', 'c435ed8f2059ca8b9ab4afd658d199c5'),
            ('1m/chedar_1221_UV1m.sofa', 'bf9a6ea901aef60eb5e5d77902a2681a'),
            ('1m/chedar_1222_UV1m.sofa', '1126ae0081772bcf546e4ed6e0e17535'),
            ('1m/chedar_1223_UV1m.sofa', '8276200cf721704110724b961352132b'),
            ('1m/chedar_1224_UV1m.sofa', '55fa8ffc8b61371ba4d671fe128e7199'),
            ('1m/chedar_1225_UV1m.sofa', '9486b2e4d3fd2a1182aa31eb186ed5ea'),
            ('1m/chedar_1226_UV1m.sofa', '95d816050ed7e6fc23211f59e6137d27'),
            ('1m/chedar_1227_UV1m.sofa', 'b735517ab5c5cbacf4e2519f7a5d6c1a'),
            ('1m/chedar_1228_UV1m.sofa', '784ea588a0d2fc8fccc1e2703e766094'),
            ('1m/chedar_1229_UV1m.sofa', '95af1f3d13dff0d3c820be2315781632'),
            ('1m/chedar_1230_UV1m.sofa', '721b36c9e69995a44c0e34b0ea660c1e'),
            ('1m/chedar_1231_UV1m.sofa', '09b29f7f88afef835dde442864523845'),
            ('1m/chedar_1232_UV1m.sofa', 'd7411cd1e4badb707435f36e145cb5f3'),
            ('1m/chedar_1233_UV1m.sofa', '88cbd7192afa766dc8345736ab316902'),
            ('1m/chedar_1234_UV1m.sofa', '09d05ff06db369e3783574e1895f2dad'),
            ('1m/chedar_1235_UV1m.sofa', '4e6116b18fb354af6c27980105e959e2'),
            ('1m/chedar_1236_UV1m.sofa', '0ecfc5ce5d56280083711d006d3dea97'),
            ('1m/chedar_1237_UV1m.sofa', '89d8aaf4d1e487960dde31463fa088a7'),
            ('1m/chedar_1238_UV1m.sofa', 'ec1997d5f5c12b83953c1c6615a80325'),
            ('1m/chedar_1239_UV1m.sofa', '4ff2e5d6bcc01dcca7b4c8e1edd7a957'),
            ('1m/chedar_1240_UV1m.sofa', 'a1b1456701ddd66210fe8d685ad726e4'),
            ('1m/chedar_1241_UV1m.sofa', '56475ee2a439cfb99f5be7a91fa49ab7'),
            ('1m/chedar_1242_UV1m.sofa', '3cbb6d8d34105a8740c313158bfd3871'),
            ('1m/chedar_1243_UV1m.sofa', 'a8a0b13cb4f4436a4216dd010a0a78d5'),
            ('1m/chedar_1244_UV1m.sofa', '41aac8b4d0c1d540c9198e3a4123c794'),
            ('1m/chedar_1245_UV1m.sofa', 'bac73b8ff5e049103e5fcf71111d5c80'),
            ('1m/chedar_1246_UV1m.sofa', '0c275427ebf77fd83e4cc07e55e9167d'),
            ('1m/chedar_1247_UV1m.sofa', '17dbdd3d276cda898cf7f157eb8b132e'),
            ('1m/chedar_1248_UV1m.sofa', '86388da29ad028701b9d7fb25ee4168c'),
            ('1m/chedar_1249_UV1m.sofa', '8d5832270d779d9b85ae296e5ad5bdaf'),
            ('1m/chedar_1250_UV1m.sofa', '94f54f6accb98fd02ec08ed62e19471e'),
            ('1m/chedar_1251_UV1m.sofa', '69b6e125acb600b2fc7df6fa682772fd'),
            ('1m/chedar_1252_UV1m.sofa', '54e0651766dae7407c95a1fc498a111f'),
            ('1m/chedar_1253_UV1m.sofa', '136d1c3267163317071297a81da2648c'),
        ],
        '2m': [
            ('2m/chedar_0001_UV2m.sofa', '467771dd2efc22212255ac766b7dc36e'),
            ('2m/chedar_0002_UV2m.sofa', 'a2ec2890ba3dc8347d11b82163403deb'),
            ('2m/chedar_0003_UV2m.sofa', '72cba62a82661d0a0c4504be7349acf3'),
            ('2m/chedar_0004_UV2m.sofa', 'e8ea450fcdded8106d63955ae60b5c89'),
            ('2m/chedar_0005_UV2m.sofa', '8cdefd612e735849d8f4a5afca7cadee'),
            ('2m/chedar_0006_UV2m.sofa', '504ee5056d1200ba39893803f8bbc3f4'),
            ('2m/chedar_0007_UV2m.sofa', 'a2e0afb161d5d9e968e6e66d5f11db8c'),
            ('2m/chedar_0008_UV2m.sofa', '5f0a538ff8529144c049b4f127a82f4f'),
            ('2m/chedar_0009_UV2m.sofa', 'fae44ac86c4c9d78ab3dacadc4cf9a53'),
            ('2m/chedar_0010_UV2m.sofa', '403a7808f39220835b9d58f8adc4c99e'),
            ('2m/chedar_0011_UV2m.sofa', '9b82fec73c1f2ab1a1c6e2878768279c'),
            ('2m/chedar_0012_UV2m.sofa', '109f2e8d7fff78b3564ae0a94ac5b4a4'),
            ('2m/chedar_0013_UV2m.sofa', '886270b68092d3fc1ba2693131ba2da0'),
            ('2m/chedar_0014_UV2m.sofa', 'c828049185856529bd914b5ee936f9d0'),
            ('2m/chedar_0015_UV2m.sofa', '047e72916bcb5f9c9e4435396fffef73'),
            ('2m/chedar_0016_UV2m.sofa', '39bf115ca6b07c3393f3d9065beb5a39'),
            ('2m/chedar_0017_UV2m.sofa', 'b0f73722e87ec71c0b00c8582db2adb2'),
            ('2m/chedar_0018_UV2m.sofa', 'dea63ef1eb27e3f5a9b27236a9036cf3'),
            ('2m/chedar_0019_UV2m.sofa', '383395848746ca9d76415e05500f28a4'),
            ('2m/chedar_0020_UV2m.sofa', '3f8f73be0d80309e2c6b0d2bb440e114'),
            ('2m/chedar_0021_UV2m.sofa', '7752aa89cc71d09260db3419533b5898'),
            ('2m/chedar_0022_UV2m.sofa', '1aa0cecb24c95d27e648741f33907dd3'),
            ('2m/chedar_0023_UV2m.sofa', 'e0dff30f66ada49ea55a1719aa8cbe9c'),
            ('2m/chedar_0024_UV2m.sofa', '8d514167d180ff1322ec609dc7c44d48'),
            ('2m/chedar_0025_UV2m.sofa', 'a008483267af0dd749bc8a5d1d58fae9'),
            ('2m/chedar_0026_UV2m.sofa', 'b8f0f1cd4de4c670adf190cc5e9df03c'),
            ('2m/chedar_0027_UV2m.sofa', 'ffd2194dbdf1bbe725a6ae78225cf381'),
            ('2m/chedar_0028_UV2m.sofa', 'd09386ee82556fcebba85d31bb3f4337'),
            ('2m/chedar_0029_UV2m.sofa', '15da9acb638a8eb9e86866117ac8d2ee'),
            ('2m/chedar_0030_UV2m.sofa', '84620ada8f22561b8b918d72a9d581e3'),
            ('2m/chedar_0031_UV2m.sofa', 'e2957116d0224cd6c827dfdca963791b'),
            ('2m/chedar_0032_UV2m.sofa', 'c2f1fa7a471e3c00d4e9aaadc4b4aa18'),
            ('2m/chedar_0033_UV2m.sofa', '0228c886a1a1bfa63b4245f66ece1db7'),
            ('2m/chedar_0034_UV2m.sofa', '4597d8b11f6400ab5921bec99d03db72'),
            ('2m/chedar_0035_UV2m.sofa', 'eefa5337519c28685e6fc5f0d84e575d'),
            ('2m/chedar_0036_UV2m.sofa', '897b3195dd9807c1c619731ed7a7b78c'),
            ('2m/chedar_0037_UV2m.sofa', '52b02f0360e798d4ea88572fed1bd944'),
            ('2m/chedar_0038_UV2m.sofa', '242706403cc927e400e4bbe75f653898'),
            ('2m/chedar_0039_UV2m.sofa', 'debdacbc40823a66a77850301ab377e5'),
            ('2m/chedar_0040_UV2m.sofa', 'f8ccffff06fbeeef3f5d0965d370256d'),
            ('2m/chedar_0041_UV2m.sofa', '1be8e3fd53926ccafbee47de005388aa'),
            ('2m/chedar_0042_UV2m.sofa', '85e1ed01e243b5597b6e7f43aaf36dba'),
            ('2m/chedar_0043_UV2m.sofa', 'b516003f9a363536e1e35bad15800789'),
            ('2m/chedar_0044_UV2m.sofa', '0415b5267f6a6247b3d7c5c353de0f65'),
            ('2m/chedar_0045_UV2m.sofa', '77bfbfcd4a21a95f4e278b8efe9b9ada'),
            ('2m/chedar_0046_UV2m.sofa', '8b2c11a11c66494acf9d0d066e11ad4a'),
            ('2m/chedar_0047_UV2m.sofa', '5877d29b95cc8490381ebbac8f937978'),
            ('2m/chedar_0048_UV2m.sofa', 'dd20fe0b908ece0c20d72d0ad0a03244'),
            ('2m/chedar_0049_UV2m.sofa', 'ddba9a30692054211c53bf07a63d272f'),
            ('2m/chedar_0050_UV2m.sofa', '5cd6a3fdc46b927867f9571f636b9da1'),
            ('2m/chedar_0051_UV2m.sofa', '858ab6ce5fd548b28e68a7ffdcbe79fa'),
            ('2m/chedar_0052_UV2m.sofa', '7951c463c6a359ad1f3ee9fd9999c07d'),
            ('2m/chedar_0053_UV2m.sofa', 'bf4e929eb2cd9faca85c865ab732dcf8'),
            ('2m/chedar_0054_UV2m.sofa', 'b80d4830ed64a2e6f9e3e3574d521ea5'),
            ('2m/chedar_0055_UV2m.sofa', '2fa8000f3c31a7242408c1ba3a7f4a14'),
            ('2m/chedar_0056_UV2m.sofa', '75cf7c244584d0848441d45c592a88aa'),
            ('2m/chedar_0057_UV2m.sofa', 'd2c8c5de7ad418756a6f1a4fb0da1d8c'),
            ('2m/chedar_0058_UV2m.sofa', '087983c9471ce5fb95338e8a7de7110f'),
            ('2m/chedar_0059_UV2m.sofa', '5dd8e3167a46bfc1461ed357e2a49d03'),
            ('2m/chedar_0060_UV2m.sofa', 'ecff4fa847d9584db7c914f545172e2d'),
            ('2m/chedar_0061_UV2m.sofa', '4aa3b9f96c0d4c24779cb1ec4e389eba'),
            ('2m/chedar_0062_UV2m.sofa', '9407257ad14c31eb06f211eefd231af8'),
            ('2m/chedar_0063_UV2m.sofa', '18a88c8d61b669208405d97aff1f132c'),
            ('2m/chedar_0064_UV2m.sofa', '90cff418837f1f7a1218a0277baccff8'),
            ('2m/chedar_0065_UV2m.sofa', '3fa0abb1317bc04a8218fd5c1be4f446'),
            ('2m/chedar_0066_UV2m.sofa', '02a4d1464529dea92b5d9c854bcd8962'),
            ('2m/chedar_0067_UV2m.sofa', '80f1a6e943f5812b5672361f028b3894'),
            ('2m/chedar_0068_UV2m.sofa', '2abeb53e4c8299e36aafd2837015d83f'),
            ('2m/chedar_0069_UV2m.sofa', 'fa70b1d89e51732b9ce9356a24b33b56'),
            ('2m/chedar_0070_UV2m.sofa', 'e0ac0890001975c18e751bd2e2fe797b'),
            ('2m/chedar_0071_UV2m.sofa', '46507bdfe880e464dea806dbf64133da'),
            ('2m/chedar_0072_UV2m.sofa', '1899dcd65c877c17260a6565f37b1827'),
            ('2m/chedar_0073_UV2m.sofa', 'a972592299ca166c5afb1373888b4f53'),
            ('2m/chedar_0074_UV2m.sofa', '3c228af0395f779351018a6e82e1689c'),
            ('2m/chedar_0075_UV2m.sofa', '16c40d7a4a702894d10bfac0840899fc'),
            ('2m/chedar_0076_UV2m.sofa', 'c322ba0531b9c357d4d519d0014cf788'),
            ('2m/chedar_0077_UV2m.sofa', 'aeee934c6ad0136dbe734b5d7ec977fc'),
            ('2m/chedar_0078_UV2m.sofa', '384406177def82f71cba56d142fc7277'),
            ('2m/chedar_0079_UV2m.sofa', 'c3c7fdc11226c576363a490f91c6fd32'),
            ('2m/chedar_0080_UV2m.sofa', 'b6d3491f53d9a614a07848b7f1f0c042'),
            ('2m/chedar_0081_UV2m.sofa', 'a5571308e56921e24f2d7d1ee6184ba1'),
            ('2m/chedar_0082_UV2m.sofa', 'de98cbba394b850f3d18e6da06b78000'),
            ('2m/chedar_0083_UV2m.sofa', 'c3c949f065a9321380caa3dd499a780a'),
            ('2m/chedar_0084_UV2m.sofa', 'ecba9c8d765394f9f28105610372ff8e'),
            ('2m/chedar_0085_UV2m.sofa', '8f0240b987061a737c16c3f72f341203'),
            ('2m/chedar_0086_UV2m.sofa', 'f9ba61fb7c909fbb6f0b0382ae45cd8b'),
            ('2m/chedar_0087_UV2m.sofa', '646373d5698b3ac68c23e4e52d2b02c2'),
            ('2m/chedar_0088_UV2m.sofa', '4f81928bfc671cf47754837c4454b01d'),
            ('2m/chedar_0089_UV2m.sofa', 'c7805af5db8833f4dc0034006e82cee0'),
            ('2m/chedar_0090_UV2m.sofa', 'fa69cce247e647bd435169a8108a16ca'),
            ('2m/chedar_0091_UV2m.sofa', 'd0081a2c9cde889fd027b9fc690625f5'),
            ('2m/chedar_0092_UV2m.sofa', 'bfd775e07725ef7fd1b5952a5356791b'),
            ('2m/chedar_0093_UV2m.sofa', 'a0c9523dd491a541bfb90cee59d97bd3'),
            ('2m/chedar_0094_UV2m.sofa', 'e2a1bdfb6e3a24a10ca994aa25343a6a'),
            ('2m/chedar_0095_UV2m.sofa', '860ac6eecf7f07222b44208461b83153'),
            ('2m/chedar_0096_UV2m.sofa', 'f3a51d8b5270923a6af18dec71c8bd52'),
            ('2m/chedar_0097_UV2m.sofa', 'aa9098cbdec1ce9f08915ff873f9b0a6'),
            ('2m/chedar_0098_UV2m.sofa', 'b9eed646fd18a3609c0c03a000e57d73'),
            ('2m/chedar_0099_UV2m.sofa', 'd1fa6f035c84228bacced4fe7aa95342'),
            ('2m/chedar_0100_UV2m.sofa', '27e73bcf841ec1bc7d38583a4ed021f5'),
            ('2m/chedar_0101_UV2m.sofa', '99acc746a5844f515573efb178ad17d5'),
            ('2m/chedar_0102_UV2m.sofa', '7c88538a050f4509484edb409c0e8d3b'),
            ('2m/chedar_0103_UV2m.sofa', '9db63b8b695a7792d47375a578ec7660'),
            ('2m/chedar_0104_UV2m.sofa', '87d62b1b637b7a0fc8a0cf6d290a8b0b'),
            ('2m/chedar_0105_UV2m.sofa', '842a3a24c9c0d30a18db11a76f60e43c'),
            ('2m/chedar_0106_UV2m.sofa', 'd435c39cd59322fe9d4946ec8a579e9f'),
            ('2m/chedar_0107_UV2m.sofa', 'aa5379fdcf63a73de751a73f7c50622e'),
            ('2m/chedar_0108_UV2m.sofa', '0416da682901bbf4b77924c229329cc0'),
            ('2m/chedar_0109_UV2m.sofa', '23036d9338d406c0f596a3a1539c705c'),
            ('2m/chedar_0110_UV2m.sofa', '1af20e0c9caf5996c74df0bfe4decb43'),
            ('2m/chedar_0111_UV2m.sofa', '43f55f5a09e92d7ba71df639b7ee5e17'),
            ('2m/chedar_0112_UV2m.sofa', 'caf134a483f60fd088ccbe3ebd137e4b'),
            ('2m/chedar_0113_UV2m.sofa', '63e43dea8082df9341179fa4a8599a8d'),
            ('2m/chedar_0114_UV2m.sofa', '15fa0b06fa7a3ce56b1680ed938137b9'),
            ('2m/chedar_0115_UV2m.sofa', 'eac62d845f09c5f8f9ad1540c34fb628'),
            ('2m/chedar_0116_UV2m.sofa', '10c53cc185d5bc310c120d7e17a0bb54'),
            ('2m/chedar_0117_UV2m.sofa', '194482a93a03c82efb8785d4f40e26ea'),
            ('2m/chedar_0118_UV2m.sofa', 'c1c779886704687180cc94ecf7d84a5e'),
            ('2m/chedar_0119_UV2m.sofa', '1975f655dcbcf6f77ebed9f8a5e0b091'),
            ('2m/chedar_0120_UV2m.sofa', '73beaaf74e00a38f21fe717cb2f4e3d4'),
            ('2m/chedar_0121_UV2m.sofa', '58c38ce7d4498874ecd970150ec3fd2e'),
            ('2m/chedar_0122_UV2m.sofa', 'a7deba9b7d323479fb24fd47bcb37bc6'),
            ('2m/chedar_0123_UV2m.sofa', 'a65d49e0fed133397b4363ef88d3414d'),
            ('2m/chedar_0124_UV2m.sofa', '0fd65dfdc2910461f7d717bfeda3ec31'),
            ('2m/chedar_0125_UV2m.sofa', '7d56ddd2cc80328bee2a66d92f0b9104'),
            ('2m/chedar_0126_UV2m.sofa', 'd281b6b08fafab1a65ac9bb8afc2fae2'),
            ('2m/chedar_0127_UV2m.sofa', 'c89dbf7e99d82997c58a0cf148df73d5'),
            ('2m/chedar_0128_UV2m.sofa', '6d8135ae74d3010af994183e87283d7a'),
            ('2m/chedar_0129_UV2m.sofa', '60e90eca192f2f536951b64d2bb7c19f'),
            ('2m/chedar_0130_UV2m.sofa', '64130c3fe062b2ae22901cb9cffc6023'),
            ('2m/chedar_0131_UV2m.sofa', 'e33596dd93143666c75faab7f679e4fa'),
            ('2m/chedar_0132_UV2m.sofa', '8460d369daa93c9df5cb95e788a534e4'),
            ('2m/chedar_0133_UV2m.sofa', '0557929a6493f0ae573542a7ba473681'),
            ('2m/chedar_0134_UV2m.sofa', '51fa2b27baafcba104ba27fdce7f5b29'),
            ('2m/chedar_0135_UV2m.sofa', 'f8e5a657ea05d53cedb2f379aec71294'),
            ('2m/chedar_0136_UV2m.sofa', '20943ad8a433e587ac3e46f89d592cd1'),
            ('2m/chedar_0137_UV2m.sofa', '18c7ebee160b4bf274d36d254b86f6a7'),
            ('2m/chedar_0138_UV2m.sofa', 'fbd428459f5f00b5cc080e3f5563b250'),
            ('2m/chedar_0139_UV2m.sofa', '53c3cffeedc6f7e5a69cc2d9589a74cf'),
            ('2m/chedar_0140_UV2m.sofa', 'af741b289d0b733fef70d7119251bce2'),
            ('2m/chedar_0141_UV2m.sofa', '8a6cd744023f4f90c7f7e2cf4defea4d'),
            ('2m/chedar_0142_UV2m.sofa', '752e73df926f89f8b369253ce8bd69fc'),
            ('2m/chedar_0143_UV2m.sofa', 'a31ce702c83852344915c24c6626318d'),
            ('2m/chedar_0144_UV2m.sofa', '3542932843607edc3f713a4155b078c7'),
            ('2m/chedar_0145_UV2m.sofa', '0a17cd6f4d7db37d602d4d978879a72e'),
            ('2m/chedar_0146_UV2m.sofa', '95df9ff68cc9baa0179125bf2e2f2ef0'),
            ('2m/chedar_0147_UV2m.sofa', 'd80f5d06552d8d3f08815bf9bee6558b'),
            ('2m/chedar_0148_UV2m.sofa', '6c0c0fe33af3615efd6e59fa34548679'),
            ('2m/chedar_0149_UV2m.sofa', '8ca286654a82da2b5e3ced91bfdaf870'),
            ('2m/chedar_0150_UV2m.sofa', 'd8735ecc40ae9cc25d687d6ccf0f7f4a'),
            ('2m/chedar_0151_UV2m.sofa', '70442a051aad099a2ab7dd023f8baded'),
            ('2m/chedar_0152_UV2m.sofa', 'dd15b46dc537cc45a4949d6f9597e6f2'),
            ('2m/chedar_0153_UV2m.sofa', 'd2c8c7cb2320953b01d4dc944a7c921e'),
            ('2m/chedar_0154_UV2m.sofa', '8b0301419bcf6b9267593f92881ba865'),
            ('2m/chedar_0155_UV2m.sofa', '796f0d888d837d9b66c1ba142815ccd6'),
            ('2m/chedar_0156_UV2m.sofa', '8a66c8b13a693d74e9f4fb92946f4f19'),
            ('2m/chedar_0157_UV2m.sofa', 'd8d4e6acb23404437f19cd55891b7d2a'),
            ('2m/chedar_0158_UV2m.sofa', '57f3229023a0506849f35e97ae0b9898'),
            ('2m/chedar_0159_UV2m.sofa', '499ae6c0ecd59be7e02860060e4d9b1a'),
            ('2m/chedar_0160_UV2m.sofa', 'a7d28780c633f7e7ee4869cc6d51847e'),
            ('2m/chedar_0161_UV2m.sofa', 'cc00d094a0f9aa613ff8c369e758349c'),
            ('2m/chedar_0162_UV2m.sofa', '7ebda2c75c521f5d7e2f69ecd1c8c827'),
            ('2m/chedar_0163_UV2m.sofa', '167ce9ca1fa47baefbfbd02e3b130463'),
            ('2m/chedar_0164_UV2m.sofa', 'e97ef5e9a16afc74d95ef6c7abb381a7'),
            ('2m/chedar_0165_UV2m.sofa', '701b5ac02a080592133c127fdc34990a'),
            ('2m/chedar_0166_UV2m.sofa', '1468ce4d7dd82ca12b50b6a6b292bc3a'),
            ('2m/chedar_0167_UV2m.sofa', '66b92c2f71ffaf2c54f23ebfea7a3908'),
            ('2m/chedar_0168_UV2m.sofa', 'dc7a0805be070a89db4df84a87f80b88'),
            ('2m/chedar_0169_UV2m.sofa', '14ac980bf9e62c0c7b2a2eabdb60097f'),
            ('2m/chedar_0170_UV2m.sofa', 'c75cc85e63e5e27bb60900cd2269b745'),
            ('2m/chedar_0171_UV2m.sofa', '29a438d851d7de8a7e5172bbeeec3434'),
            ('2m/chedar_0172_UV2m.sofa', '4f1322743c46042703c5791f6ff05190'),
            ('2m/chedar_0173_UV2m.sofa', '1f200b42bda31383b6a77b9817a90ed5'),
            ('2m/chedar_0174_UV2m.sofa', '4a716af135c157ba6c1e9d9b5a171810'),
            ('2m/chedar_0175_UV2m.sofa', '5a42d4f64b2749440a0f03e1ad1e18c0'),
            ('2m/chedar_0176_UV2m.sofa', '3cf7e0f41cfe632bb1dd241e58f86850'),
            ('2m/chedar_0177_UV2m.sofa', 'a515c8b232e1cff76d80ad7da6c7a3ee'),
            ('2m/chedar_0178_UV2m.sofa', '0bf871ede8299097063d616155e81a63'),
            ('2m/chedar_0179_UV2m.sofa', 'da60312160de31f312f0fa5f03de4f35'),
            ('2m/chedar_0180_UV2m.sofa', '9396aff77cc94f87a62e6ad93e87d0d4'),
            ('2m/chedar_0181_UV2m.sofa', '00410d4f11f1c4911481ed7a0c2120ba'),
            ('2m/chedar_0182_UV2m.sofa', 'cb5f2ce7f42a929af4dd36e90bf57c70'),
            ('2m/chedar_0183_UV2m.sofa', '041e9e7904644a27f992267def163810'),
            ('2m/chedar_0184_UV2m.sofa', '5738d04d2f4a7f74214d99bbb5cedcd9'),
            ('2m/chedar_0185_UV2m.sofa', 'd83443150e73ffb66c0bfe4af999acd3'),
            ('2m/chedar_0186_UV2m.sofa', '721cbb01ceb50540449c6b5b6e0499a5'),
            ('2m/chedar_0187_UV2m.sofa', '1647be00972411bece0d2027e52650a4'),
            ('2m/chedar_0188_UV2m.sofa', 'ff092bb83682e4dd2ce2434c8573759f'),
            ('2m/chedar_0189_UV2m.sofa', '63e5b9b54f5bc5473c63f0b5936442e2'),
            ('2m/chedar_0190_UV2m.sofa', '1e1f3256b54ffe8efff2b3847d47cfec'),
            ('2m/chedar_0191_UV2m.sofa', '96bda366a24514cd4056993fef312f4e'),
            ('2m/chedar_0192_UV2m.sofa', '49b5a52f8620beaa24baed5e6fe6cfea'),
            ('2m/chedar_0193_UV2m.sofa', 'd5d42d390984c8fd7db32ef608c48c4c'),
            ('2m/chedar_0194_UV2m.sofa', '339370eebf5b8cd2a638b4757ac53b36'),
            ('2m/chedar_0195_UV2m.sofa', '09480a5132ccf37f691ca75fa88032c4'),
            ('2m/chedar_0196_UV2m.sofa', 'c3c11759254d8b68f4821140f6d72b3e'),
            ('2m/chedar_0197_UV2m.sofa', '2d58f4c5cda9ded9f75584e9d847dc57'),
            ('2m/chedar_0198_UV2m.sofa', 'b8c4bc633f3c7c2114d067d6630ef2b6'),
            ('2m/chedar_0199_UV2m.sofa', 'c164d2b7f9c82184d86c9b2e24240064'),
            ('2m/chedar_0200_UV2m.sofa', 'a3cf543d54a6852a2c76e9aed2939136'),
            ('2m/chedar_0201_UV2m.sofa', 'a918cc4141235a1b15085c9aca105d03'),
            ('2m/chedar_0202_UV2m.sofa', '62c7da770feb579b54152d16e3ed8d05'),
            ('2m/chedar_0203_UV2m.sofa', '4adc79ab7726e84c1442c32396672fca'),
            ('2m/chedar_0204_UV2m.sofa', '9852f28ccb2c8fb2f0e2bcf470067d0d'),
            ('2m/chedar_0205_UV2m.sofa', '1d83c3b5f5a0597a706eec1dd6f0595f'),
            ('2m/chedar_0206_UV2m.sofa', 'ca531806f29a5e1247fa715a342a03b2'),
            ('2m/chedar_0207_UV2m.sofa', '3f88369169f6c380d4c71accaca9fdcb'),
            ('2m/chedar_0208_UV2m.sofa', '8f7dd9de6db4f9ab936a8eb9cbf456ce'),
            ('2m/chedar_0209_UV2m.sofa', '582abead236d0dc2af0c2348655fc02e'),
            ('2m/chedar_0210_UV2m.sofa', 'f303b50c97b3120f5e2e4fcbf3dae186'),
            ('2m/chedar_0211_UV2m.sofa', '21089eb647209292c2d77f9e8f400ddf'),
            ('2m/chedar_0212_UV2m.sofa', '4a4fd3ceb110fa17146c79e5edcd5507'),
            ('2m/chedar_0213_UV2m.sofa', '08ab56ca1a7644cb5407888352136e46'),
            ('2m/chedar_0214_UV2m.sofa', 'e5bed8d8bf16df6e51a25daeb9643f40'),
            ('2m/chedar_0215_UV2m.sofa', '9370cfd8e6fe10936e35f6669262a155'),
            ('2m/chedar_0216_UV2m.sofa', 'ac47faf0d4d351e70c51c273085548a2'),
            ('2m/chedar_0217_UV2m.sofa', '8056d9322220238ee34402484a02be85'),
            ('2m/chedar_0218_UV2m.sofa', 'eb305821e518d6e0d5daa198feeaa7d3'),
            ('2m/chedar_0219_UV2m.sofa', '060a7bd51a934c40bb031674a3a8bf39'),
            ('2m/chedar_0220_UV2m.sofa', '61909919efdedb960eacb84adc179f29'),
            ('2m/chedar_0221_UV2m.sofa', 'd966be5613807dab73a57870445dc3f7'),
            ('2m/chedar_0222_UV2m.sofa', '77b102018d3c5f2920968213c6c30bae'),
            ('2m/chedar_0223_UV2m.sofa', 'ee55b056891a57088079f37fa6ad183f'),
            ('2m/chedar_0224_UV2m.sofa', 'f0b719db7ac57c549632d81998f07b39'),
            ('2m/chedar_0225_UV2m.sofa', 'f6c09b6610deb6c0f351188e519c4d0c'),
            ('2m/chedar_0226_UV2m.sofa', '9bd547001befe04e5fe77235e83368f0'),
            ('2m/chedar_0227_UV2m.sofa', '1467710dc605beac12c7379eebd0bb2c'),
            ('2m/chedar_0228_UV2m.sofa', '995de41c8fa1aacab7dfebbdc3536d78'),
            ('2m/chedar_0229_UV2m.sofa', 'ede57e9dcf50bc823045e7068d9ee867'),
            ('2m/chedar_0230_UV2m.sofa', '99d6fcb2944e3d62166bf8d09dca0dcb'),
            ('2m/chedar_0231_UV2m.sofa', 'ba21921480ca1085840ace06908758f9'),
            ('2m/chedar_0232_UV2m.sofa', 'c26247fdeb9f7b5cb22f1b60047c05ae'),
            ('2m/chedar_0233_UV2m.sofa', '0bb0876b0c2197321b349d6d0b533975'),
            ('2m/chedar_0234_UV2m.sofa', 'f734a20068b4ba5b133ad0113a49b58a'),
            ('2m/chedar_0235_UV2m.sofa', '5fcdf917cc11908195f137d2cc9911e6'),
            ('2m/chedar_0236_UV2m.sofa', 'a760e58cad6bdd90c4f90e0cd28d579f'),
            ('2m/chedar_0237_UV2m.sofa', '85cd692bf847213ae7cfbbc0274eee19'),
            ('2m/chedar_0238_UV2m.sofa', '73e4d3cac28cdb3cb4ad29bab9d97b1a'),
            ('2m/chedar_0239_UV2m.sofa', '11615dc8ff07ed7778734c8f0a766a50'),
            ('2m/chedar_0240_UV2m.sofa', '3e5f06aeaf581e20e03ee94dc2991ca8'),
            ('2m/chedar_0241_UV2m.sofa', '43a5114c839d3f8704ded4631f491a32'),
            ('2m/chedar_0242_UV2m.sofa', 'f61ade647dccf9877644aa11d2bd1158'),
            ('2m/chedar_0243_UV2m.sofa', '786c9961de23ed1805c40ce66ce1991d'),
            ('2m/chedar_0244_UV2m.sofa', '32a54252e2d179744c005ec500a22e09'),
            ('2m/chedar_0245_UV2m.sofa', '66e48fbba448233a639ddc406e8596fe'),
            ('2m/chedar_0246_UV2m.sofa', '0b612d58c6b53d150be9abbb63def505'),
            ('2m/chedar_0247_UV2m.sofa', '98719255fe260bee69cd4954cd27a3ac'),
            ('2m/chedar_0248_UV2m.sofa', 'bde83f363feb96cb7f121978e9dd57fe'),
            ('2m/chedar_0249_UV2m.sofa', '4bc34206ea2b8b2a531196866689b84b'),
            ('2m/chedar_0250_UV2m.sofa', '32d67f1f0d8c5ee64dcc89582027273c'),
            ('2m/chedar_0251_UV2m.sofa', 'a1b3eeadc44b0728699a1d2f4c901082'),
            ('2m/chedar_0252_UV2m.sofa', 'f754c4b7680fc34cef1fb6adce9e4f03'),
            ('2m/chedar_0253_UV2m.sofa', 'eeb9e28d47f1165218f066f8eacdae78'),
            ('2m/chedar_0254_UV2m.sofa', 'a98d0dab153ae7e81d4b3d82e0c06ff6'),
            ('2m/chedar_0255_UV2m.sofa', '85a3ae3d2f2a6a8f157cd7b945e6e057'),
            ('2m/chedar_0256_UV2m.sofa', 'bf2d0e1993d157ca081055030b2eb0d8'),
            ('2m/chedar_0257_UV2m.sofa', 'c368c7d42cdc6b770b147fc12bcccb4b'),
            ('2m/chedar_0258_UV2m.sofa', '4a0c349eafdb87067b6e8d8a1e8f3fd1'),
            ('2m/chedar_0259_UV2m.sofa', '3f6067a0865609c0c74f8d5628cafa02'),
            ('2m/chedar_0260_UV2m.sofa', '806735e8d52e6d995d03dda3b5973f9e'),
            ('2m/chedar_0261_UV2m.sofa', '16a078bdf97c3475817fa733434dbd41'),
            ('2m/chedar_0262_UV2m.sofa', '2ebd6e2d52f9008723c9dbb582ccb368'),
            ('2m/chedar_0263_UV2m.sofa', '4e58f5d08c4c6dfdd8ac2a35eb5f84c3'),
            ('2m/chedar_0264_UV2m.sofa', '5a03c84daded64b2aa6b253f3379268d'),
            ('2m/chedar_0265_UV2m.sofa', '037b48ee750ad65764dec6c8bca28a06'),
            ('2m/chedar_0266_UV2m.sofa', '35dd0dcfe6933bff05955a6e25f8f199'),
            ('2m/chedar_0267_UV2m.sofa', '4caa1d72b053122e7090a6fda9cfcf40'),
            ('2m/chedar_0268_UV2m.sofa', 'b15da965eb37b371b757c967b8b2809e'),
            ('2m/chedar_0269_UV2m.sofa', '9930b2fead2feee84f167a91f78858f9'),
            ('2m/chedar_0270_UV2m.sofa', '70f8b8fbe52c91fd903c66e58518570b'),
            ('2m/chedar_0271_UV2m.sofa', '3c260952c2bb23d432197ab0b5cd4202'),
            ('2m/chedar_0272_UV2m.sofa', '56c7e80a000fa654c2214b3027662901'),
            ('2m/chedar_0273_UV2m.sofa', 'fcd53b38571ed7415598e970e0a3ba6e'),
            ('2m/chedar_0274_UV2m.sofa', 'a6a9be62d61259b6c0d4068f0241dcbd'),
            ('2m/chedar_0275_UV2m.sofa', 'c0eaa6aacf1995678f3360bcb3e132ed'),
            ('2m/chedar_0276_UV2m.sofa', 'b8e8467a477000fb4d7073d67110c746'),
            ('2m/chedar_0277_UV2m.sofa', '69ff8a323c9f07a8f4ce41d70d078362'),
            ('2m/chedar_0278_UV2m.sofa', '301057c93378851840c2f132f1366a83'),
            ('2m/chedar_0279_UV2m.sofa', 'a1587679cd9666019f5e14e0e9174112'),
            ('2m/chedar_0280_UV2m.sofa', 'f1a55697bab6fc146c288c9a3fa0497a'),
            ('2m/chedar_0281_UV2m.sofa', '86be782e9e35d4a7f740403a29684fe9'),
            ('2m/chedar_0282_UV2m.sofa', 'a741d69b5ed3b28fe1814b212c64b795'),
            ('2m/chedar_0283_UV2m.sofa', 'a6304c706fee26faab7fed3d9586b41a'),
            ('2m/chedar_0284_UV2m.sofa', 'cf79cefeb0ea7fd046c8bbfd9e817332'),
            ('2m/chedar_0285_UV2m.sofa', '43a36ea284ae8da8bca8671e8ac16ac7'),
            ('2m/chedar_0286_UV2m.sofa', '83ca221a9a0f03b79774478c4d287c08'),
            ('2m/chedar_0287_UV2m.sofa', 'd7d9ede8758819e701a4cf2c2ae53e95'),
            ('2m/chedar_0288_UV2m.sofa', '3cf7e3a06b13e2914a3a73b4eaac3f86'),
            ('2m/chedar_0289_UV2m.sofa', 'fbce419c462f26c61dd6c72c50ef3692'),
            ('2m/chedar_0290_UV2m.sofa', '09ef5221d869d7c488bfe2ce10467149'),
            ('2m/chedar_0291_UV2m.sofa', 'fa664869ce279dfa9d182c0be16203ba'),
            ('2m/chedar_0292_UV2m.sofa', 'db45a56f77cd08c7aeac2bfdef92eb9b'),
            ('2m/chedar_0293_UV2m.sofa', '4202b3f550b6a734c9b63f9537000141'),
            ('2m/chedar_0294_UV2m.sofa', '341230c4666925a6319286e3ff1bc175'),
            ('2m/chedar_0295_UV2m.sofa', 'd1a70f528568e221ea3d8700b017c253'),
            ('2m/chedar_0296_UV2m.sofa', 'f2249eaafd86196e7f4c73104680c7b2'),
            ('2m/chedar_0297_UV2m.sofa', '97029c0c473c054782ffa86031ff709a'),
            ('2m/chedar_0298_UV2m.sofa', '5c1c38f1e45dd83bccea5e3a9649ed59'),
            ('2m/chedar_0299_UV2m.sofa', '0bbf834f549206f2cc55b28e2f4f70aa'),
            ('2m/chedar_0300_UV2m.sofa', 'ef84e7bf14aa926d5ea1368fd51e2163'),
            ('2m/chedar_0301_UV2m.sofa', 'd1658f910c5dcab2cb9538d7125699f8'),
            ('2m/chedar_0302_UV2m.sofa', '6f41c20c748b6945581bd63ce75ce91e'),
            ('2m/chedar_0303_UV2m.sofa', '097f69081bcbead81293c1427666bc94'),
            ('2m/chedar_0304_UV2m.sofa', '79180822e205f066b711c9cf127d3c3f'),
            ('2m/chedar_0305_UV2m.sofa', 'f1a4f23e8571bc7420721cf3e755ba00'),
            ('2m/chedar_0306_UV2m.sofa', '34de1c24a514c98e68c8fc1140cdab19'),
            ('2m/chedar_0307_UV2m.sofa', 'b560c216a4ae3c727502b25fe7327ed8'),
            ('2m/chedar_0308_UV2m.sofa', '029ed471aad9dcc47ce3599366c1b06e'),
            ('2m/chedar_0309_UV2m.sofa', 'abebac39ece36ff2d91da735add22350'),
            ('2m/chedar_0310_UV2m.sofa', '5e469ac5198ce70b6644c6e4e3e01d15'),
            ('2m/chedar_0311_UV2m.sofa', '5c52c50c978abbf1dbda9de40bc14ccf'),
            ('2m/chedar_0312_UV2m.sofa', 'bbe566d3ec678074c43a35669753cd1a'),
            ('2m/chedar_0313_UV2m.sofa', 'eca5f5be526ee8971c62f976a0e4d7a0'),
            ('2m/chedar_0314_UV2m.sofa', '2f1d43a0fdecbbede499b71bf05d0028'),
            ('2m/chedar_0315_UV2m.sofa', 'c795a1a0a633e43a4bfca99b23143407'),
            ('2m/chedar_0316_UV2m.sofa', '545c8d0ebc32ec2249348fe017e2ca8a'),
            ('2m/chedar_0317_UV2m.sofa', '312f3248f334783d286dbe230e4564bf'),
            ('2m/chedar_0318_UV2m.sofa', 'fd0c3624fe39cbdb2e1cb7d2691fa051'),
            ('2m/chedar_0319_UV2m.sofa', '05d255f0e86496a5a2c7eb361848c88b'),
            ('2m/chedar_0320_UV2m.sofa', 'f74631a17186a31ceea66384fb2f1941'),
            ('2m/chedar_0321_UV2m.sofa', '1fbf119fb0c2fa554b8306624106a01d'),
            ('2m/chedar_0322_UV2m.sofa', '7c02d7c007ad2c11b29a2d9219e89e57'),
            ('2m/chedar_0323_UV2m.sofa', 'f6c0b07730ec049d98fe953aa0fd4717'),
            ('2m/chedar_0324_UV2m.sofa', '6a35330991c248745fc0ce7c00f3b232'),
            ('2m/chedar_0325_UV2m.sofa', '6c28846262f9dd5eb03ae69e7d6c3350'),
            ('2m/chedar_0326_UV2m.sofa', '466a8225ced233d078603fe25115ef3e'),
            ('2m/chedar_0327_UV2m.sofa', 'd8e02291ba13a5d9fb5f11a2b351ed4f'),
            ('2m/chedar_0328_UV2m.sofa', 'e527b7fc796373a440026377fac92d45'),
            ('2m/chedar_0329_UV2m.sofa', 'dff2b0ac322f366d405c26af86d43c9b'),
            ('2m/chedar_0330_UV2m.sofa', '73262cef88eaba68b1568022c8f5d661'),
            ('2m/chedar_0331_UV2m.sofa', 'b30c52c17790fcbf6802cfbe2df73d08'),
            ('2m/chedar_0332_UV2m.sofa', '91aa6ec0480eed3eeeef57946fb3269e'),
            ('2m/chedar_0333_UV2m.sofa', '44eddb78828fe81a47dab1fa60121ad7'),
            ('2m/chedar_0334_UV2m.sofa', '62d1355dcb5878306f741582ecdbcec1'),
            ('2m/chedar_0335_UV2m.sofa', '923e9e1032f4f579953ece0fbe276928'),
            ('2m/chedar_0336_UV2m.sofa', 'd569e55dbff912b5c2c5677c32486e70'),
            ('2m/chedar_0337_UV2m.sofa', '36a6001ef1561c4fb903680cc0b7db2b'),
            ('2m/chedar_0338_UV2m.sofa', 'ddecdab0c3c9975d95ceb6240a5a8a19'),
            ('2m/chedar_0339_UV2m.sofa', '5ec756ab93122c601a435d14129672b1'),
            ('2m/chedar_0340_UV2m.sofa', '39caf94696f19a5029945d2bdc4322c9'),
            ('2m/chedar_0341_UV2m.sofa', 'e29e1c620d34c443748e82e15d8211dc'),
            ('2m/chedar_0342_UV2m.sofa', '4421372aed1f1a1dc518a3c07b60a04f'),
            ('2m/chedar_0343_UV2m.sofa', '95c6ca274a97809726621d491980b482'),
            ('2m/chedar_0344_UV2m.sofa', '51dd915ea574ef517b51c8466e47576c'),
            ('2m/chedar_0345_UV2m.sofa', 'e0bbbd4fb5bb84c027fa080fa199da41'),
            ('2m/chedar_0346_UV2m.sofa', '37bf5610167c67f6b57edf1bd0af8ea2'),
            ('2m/chedar_0347_UV2m.sofa', '7c6b7b568f0fa7f96065bd9c9911915a'),
            ('2m/chedar_0348_UV2m.sofa', '7ea007cd40855573f941603c3bdd1c59'),
            ('2m/chedar_0349_UV2m.sofa', '33fcfb831cfbe4b7d6f4784f4c6e0974'),
            ('2m/chedar_0350_UV2m.sofa', '7368685f8a644c5a3db30c058a2700b4'),
            ('2m/chedar_0351_UV2m.sofa', '55a8fe2a1e06e0d48bea2e3c2de41c6f'),
            ('2m/chedar_0352_UV2m.sofa', '09068e3d800842ee5a2ec67f1bc92d61'),
            ('2m/chedar_0353_UV2m.sofa', '43443bafdb0393ecd5a1e46dd2dbef6e'),
            ('2m/chedar_0354_UV2m.sofa', '7b0d233e067f8b7058fc581455146706'),
            ('2m/chedar_0355_UV2m.sofa', 'f69e7ec03de9cd15f981c92b7386d71e'),
            ('2m/chedar_0356_UV2m.sofa', '9e5985821b5b56c9cc7572c2257ff938'),
            ('2m/chedar_0357_UV2m.sofa', '4b2796ff7d83f83850b209a02d5d89f6'),
            ('2m/chedar_0358_UV2m.sofa', '4224f5b8dbea62f83938443c2155706e'),
            ('2m/chedar_0359_UV2m.sofa', 'a19b83eceb58b424d8e96ff619ebcfbb'),
            ('2m/chedar_0360_UV2m.sofa', '01a1a1de57842077eed7124f5ea49f7f'),
            ('2m/chedar_0361_UV2m.sofa', '01f356ac97f1150979f0d1fa7f5412f1'),
            ('2m/chedar_0362_UV2m.sofa', '588b4dad41dc82dee380d74583f0eeae'),
            ('2m/chedar_0363_UV2m.sofa', '6a94ccfa870437e2f846fc08a37c6e36'),
            ('2m/chedar_0364_UV2m.sofa', 'f8a56afa50918dc35b2a24b12612c4ad'),
            ('2m/chedar_0365_UV2m.sofa', '50ae26388fdd049aff6c96aca8612be1'),
            ('2m/chedar_0366_UV2m.sofa', '27770593b5afe91f639b2fd1f7c11f13'),
            ('2m/chedar_0367_UV2m.sofa', '1debf322c171eebac3ecbe50c7f9cb8c'),
            ('2m/chedar_0368_UV2m.sofa', '2c453aad396acb6532243d3a19957685'),
            ('2m/chedar_0369_UV2m.sofa', '7472be4dbb65a9eaf5142431f76db27f'),
            ('2m/chedar_0370_UV2m.sofa', 'e770abb745d9d5f160bbfe4078c36009'),
            ('2m/chedar_0371_UV2m.sofa', '566f56aa976a100b896792596be7c2c1'),
            ('2m/chedar_0372_UV2m.sofa', '3e8453f2e5ce77369d5f3e87a4bc8cb5'),
            ('2m/chedar_0373_UV2m.sofa', '2b29796dcd4af03369f3fd3c5e0dff1c'),
            ('2m/chedar_0374_UV2m.sofa', '139419e305e87113518a98f66393976c'),
            ('2m/chedar_0375_UV2m.sofa', '69448a63d666a27913aa2a8d75478454'),
            ('2m/chedar_0376_UV2m.sofa', '53eb3ac7ae6c9086b1245816c8e4b29c'),
            ('2m/chedar_0377_UV2m.sofa', 'abf3b6c7c53c2639c300f129f69730d8'),
            ('2m/chedar_0378_UV2m.sofa', '7f064972fd2f45e3da95c15a7fa034a1'),
            ('2m/chedar_0379_UV2m.sofa', 'e7f9c6fcb1dd24e2bcf596def9d04fc5'),
            ('2m/chedar_0380_UV2m.sofa', '0c4aeebba772c18831436c5e2799ea01'),
            ('2m/chedar_0381_UV2m.sofa', '8488f52575b4eba5089cf285a052257f'),
            ('2m/chedar_0382_UV2m.sofa', '35b178df9fbf5ff6d840a01b764cdc5a'),
            ('2m/chedar_0383_UV2m.sofa', 'b25050a2ad8a81a437e1066ef77bdb39'),
            ('2m/chedar_0384_UV2m.sofa', 'c978e3d706e45ba2dcd5f3c02c7ada9a'),
            ('2m/chedar_0385_UV2m.sofa', '626a125a2e12ebabd41a2a39d30d6c90'),
            ('2m/chedar_0386_UV2m.sofa', '210c0ee4bd32823c65ed1c95be228c31'),
            ('2m/chedar_0387_UV2m.sofa', 'bd2afa41822595f8d2f65eeb729ee692'),
            ('2m/chedar_0388_UV2m.sofa', '41c703a404854f06e1c7849ee989e19f'),
            ('2m/chedar_0389_UV2m.sofa', '46345a6d5cbaaae8fb016af197b8296d'),
            ('2m/chedar_0390_UV2m.sofa', 'a37ef87c0d6e0b29131d8c4722ba4772'),
            ('2m/chedar_0391_UV2m.sofa', '1e06119828e4f67b4f59f43604807969'),
            ('2m/chedar_0392_UV2m.sofa', '1cca1705dc793023d636628d0fbf4aed'),
            ('2m/chedar_0393_UV2m.sofa', 'c053d0aec5245d46c415b40aeab86d84'),
            ('2m/chedar_0394_UV2m.sofa', '079dfc6a925550f7b5bddcd56fe83a6d'),
            ('2m/chedar_0395_UV2m.sofa', '3c1bf8b1f6fae796d38fa41dc9b25b0f'),
            ('2m/chedar_0396_UV2m.sofa', 'e56bcf3ad2216d3ea6a44771f34c74bb'),
            ('2m/chedar_0397_UV2m.sofa', '2962514103658ed5662b3782be32ffdd'),
            ('2m/chedar_0398_UV2m.sofa', 'e31fa47d474ae939db4c609e306c4e0f'),
            ('2m/chedar_0399_UV2m.sofa', '772de33c5872c30ddf1ac53d0018a5e1'),
            ('2m/chedar_0400_UV2m.sofa', 'bbe432af36b918491971ff06dcb56b5d'),
            ('2m/chedar_0401_UV2m.sofa', '6bd7a7c536e1ac04b03104f3eabb7f3a'),
            ('2m/chedar_0402_UV2m.sofa', 'b89b4982a10f8cf77e1c3513c5181efd'),
            ('2m/chedar_0403_UV2m.sofa', '9b00c575c7092a94689d5fc63c530905'),
            ('2m/chedar_0404_UV2m.sofa', 'eba954ee8cd63e2fe30ff2504cdbf9bc'),
            ('2m/chedar_0405_UV2m.sofa', '644f6b63c45fbd37721b4d0dea16a2ea'),
            ('2m/chedar_0406_UV2m.sofa', '8fb34aa57ad87de28e97468a5edfdde3'),
            ('2m/chedar_0407_UV2m.sofa', 'c8f31a6ae0256075bbd86cf35a17dfeb'),
            ('2m/chedar_0408_UV2m.sofa', '103d985189d4020d4187a6451dbef1e5'),
            ('2m/chedar_0409_UV2m.sofa', '7b5e4d471848862447af72db0fb5cf82'),
            ('2m/chedar_0410_UV2m.sofa', 'ec429b4c0dc40c1ae03b67fdb5e8599d'),
            ('2m/chedar_0411_UV2m.sofa', 'b0ea343599d7260f85d664337a6de936'),
            ('2m/chedar_0412_UV2m.sofa', 'bd7f105b14c7489487d4e652e6a5d2fb'),
            ('2m/chedar_0413_UV2m.sofa', '264fc745a855c12464138a6b99156727'),
            ('2m/chedar_0414_UV2m.sofa', '969aa126ed1361a783240919eeed3eda'),
            ('2m/chedar_0415_UV2m.sofa', '3ae1b7ce979e80e1c4405100a69b815e'),
            ('2m/chedar_0416_UV2m.sofa', '6d2da40bd8d6e0ac2c453a3cd4909385'),
            ('2m/chedar_0417_UV2m.sofa', 'a54846f5de9ea72aad0b54312e1e3e93'),
            ('2m/chedar_0418_UV2m.sofa', 'b3cd15c1e1ee3dab0097ead93260b041'),
            ('2m/chedar_0419_UV2m.sofa', 'e8d910f42fe4bbcefbea7dbda0a16f94'),
            ('2m/chedar_0420_UV2m.sofa', '983e2d9f452e456c704e25bd90be529f'),
            ('2m/chedar_0421_UV2m.sofa', '1263f55920aefb07f9e1e381006f7dd4'),
            ('2m/chedar_0422_UV2m.sofa', 'a7047fa9b3bd7b88d5b8f8ee072263b6'),
            ('2m/chedar_0423_UV2m.sofa', '58f2ece2493fa7dc91a25c252ae5964d'),
            ('2m/chedar_0424_UV2m.sofa', 'da860846def0f5ebf794376c8e0ccaa8'),
            ('2m/chedar_0425_UV2m.sofa', 'd887c7ebfeead7b58265c585baac0020'),
            ('2m/chedar_0426_UV2m.sofa', 'bf6da77d0bfd5596b05d9dafdfa8f750'),
            ('2m/chedar_0427_UV2m.sofa', '47801beb29c7776dfb7c7d0e879be91e'),
            ('2m/chedar_0428_UV2m.sofa', '26495e33760a90296edd1cf7f4d9c188'),
            ('2m/chedar_0429_UV2m.sofa', '442cecbd6d250cd1d72519dd2d5288a6'),
            ('2m/chedar_0430_UV2m.sofa', 'aa6a555f4362dd10edc889e0ebce213e'),
            ('2m/chedar_0431_UV2m.sofa', 'c5c709b13d748f126873b6e5bd873a81'),
            ('2m/chedar_0432_UV2m.sofa', 'dd1c4f256fb36603f4bd96304625714d'),
            ('2m/chedar_0433_UV2m.sofa', '01047d9442ed958032c84d6f59f2e320'),
            ('2m/chedar_0434_UV2m.sofa', '9a88bb5bf017de1e45f2d9a3f1ee882b'),
            ('2m/chedar_0435_UV2m.sofa', '0810347dcea6c61af107a0aaa4d59e22'),
            ('2m/chedar_0436_UV2m.sofa', 'b89b2fb16ffba03fb934abb72134b0a4'),
            ('2m/chedar_0437_UV2m.sofa', '3b58035d9055bd82dd67a0bb7803b594'),
            ('2m/chedar_0438_UV2m.sofa', 'e658a8299da478a702c85da5341ee8d8'),
            ('2m/chedar_0439_UV2m.sofa', '04cec1d71f4a0ef30762a405082cfd7f'),
            ('2m/chedar_0440_UV2m.sofa', 'a108c8aee7c087c01e7ca6c85f2e9e0e'),
            ('2m/chedar_0441_UV2m.sofa', '5dc67476babf181afaaebc251e25225f'),
            ('2m/chedar_0442_UV2m.sofa', 'b555e38179fb6e3fef8c3b46d4e6b2b8'),
            ('2m/chedar_0443_UV2m.sofa', '84e81ca59d67e152f7738456a88fc092'),
            ('2m/chedar_0444_UV2m.sofa', 'b64c215ee580b9a890d949cfbd27ab70'),
            ('2m/chedar_0445_UV2m.sofa', 'c6a8afc2bb30e0fc9dae6366cc7862a2'),
            ('2m/chedar_0446_UV2m.sofa', 'a52b4351b52d1d740a44497cbac85095'),
            ('2m/chedar_0447_UV2m.sofa', '9e05b47ae14f4aa32502a7c7cd0ca3e0'),
            ('2m/chedar_0448_UV2m.sofa', '2fbd208b9575086f5329f9f8ad17d26f'),
            ('2m/chedar_0449_UV2m.sofa', 'aaee944a5b1b809e83eb11ccce0c000a'),
            ('2m/chedar_0450_UV2m.sofa', '1ac6734c4b321b75f7434a05caa2d67e'),
            ('2m/chedar_0451_UV2m.sofa', '023dedbffea61b2b08d70befb2df5719'),
            ('2m/chedar_0452_UV2m.sofa', '02d4b5a4b8e5d116a7e7b7e3584cc84e'),
            ('2m/chedar_0453_UV2m.sofa', 'c0f696ca02e023f2d54fac03173b3998'),
            ('2m/chedar_0454_UV2m.sofa', 'c951948e22eb038325f22f26032d22a3'),
            ('2m/chedar_0455_UV2m.sofa', '73deb8964dca38b581ce61b242d3652b'),
            ('2m/chedar_0456_UV2m.sofa', '552b7e7cb6d98ec0a8bf2ec89d0dab09'),
            ('2m/chedar_0457_UV2m.sofa', '946e0dc43db4c3dfa5f835ae1fe48e8d'),
            ('2m/chedar_0458_UV2m.sofa', 'e4946e8b8d2563eb79bdcd50981448c4'),
            ('2m/chedar_0459_UV2m.sofa', '8c5b94cc4cf779b7b3b88683c01dd8a7'),
            ('2m/chedar_0460_UV2m.sofa', '4fef927459cdd3af9eafe27096916b9d'),
            ('2m/chedar_0461_UV2m.sofa', '84e5892929046b45f9fb042ce25147d9'),
            ('2m/chedar_0462_UV2m.sofa', 'f4786f13ab302f0be27fd9804b37dc7a'),
            ('2m/chedar_0463_UV2m.sofa', 'daff34015670084d848e778e93401d48'),
            ('2m/chedar_0464_UV2m.sofa', 'b26348e43d45ff11a7f417c3e5314246'),
            ('2m/chedar_0465_UV2m.sofa', '0a33e4cdfbd36536c1fdcb40fbb9bad8'),
            ('2m/chedar_0466_UV2m.sofa', 'd1a1fd0ca1a65dff6c6e95dca152db39'),
            ('2m/chedar_0467_UV2m.sofa', '29999f0583a7bb308de30e19ea740aca'),
            ('2m/chedar_0468_UV2m.sofa', 'ff5887dd80c06c4991473a3b6c7ef18a'),
            ('2m/chedar_0469_UV2m.sofa', 'bc1ce49543aada87ce4bb67667cbb9c0'),
            ('2m/chedar_0470_UV2m.sofa', '3a742b498245462d21098ccb9e1733ae'),
            ('2m/chedar_0471_UV2m.sofa', 'a49deab6e358f01622da59a17f487fb1'),
            ('2m/chedar_0472_UV2m.sofa', '906e193977dcea1d5c350bc578505642'),
            ('2m/chedar_0473_UV2m.sofa', '1b306e50c78c8d292bacb7db4a1162f1'),
            ('2m/chedar_0474_UV2m.sofa', 'bf8bfe77aab12098b71fcf4f737fb607'),
            ('2m/chedar_0475_UV2m.sofa', '4ddaf06d700c4b8fe16798d1665f0b8e'),
            ('2m/chedar_0476_UV2m.sofa', '6e1000e2829a8637e5b042ad3bc1c69d'),
            ('2m/chedar_0477_UV2m.sofa', 'dc766163e5ddd6b11c3cfd0c102a6da5'),
            ('2m/chedar_0478_UV2m.sofa', '4d023ca0ddc327cd0ddbe4777366b9d6'),
            ('2m/chedar_0479_UV2m.sofa', '816b62cf973d21fafd3c3d0ead2a165b'),
            ('2m/chedar_0480_UV2m.sofa', 'f90e2003708cca8ccf6f30367cc59110'),
            ('2m/chedar_0481_UV2m.sofa', '91a37893075f2d223c90bf0ffdaeb8e8'),
            ('2m/chedar_0482_UV2m.sofa', '38962542581f5cb9b949694d22e8349d'),
            ('2m/chedar_0483_UV2m.sofa', '109fee90cf5096e4775b8ea35c59b454'),
            ('2m/chedar_0484_UV2m.sofa', 'a97d53f17635ceb7600a7a3d37612e37'),
            ('2m/chedar_0485_UV2m.sofa', '7e24818a471aa38eb4802641abcc045d'),
            ('2m/chedar_0486_UV2m.sofa', 'e7380239cd11d791de9723c0e2eae6d0'),
            ('2m/chedar_0487_UV2m.sofa', '0a0606c4d3a827db98b400f9207c7e90'),
            ('2m/chedar_0488_UV2m.sofa', '8a38682aed3812adca811524e5df2269'),
            ('2m/chedar_0489_UV2m.sofa', '63758f1bbebcaf717545ebe47b8bfbe3'),
            ('2m/chedar_0490_UV2m.sofa', '6ff62b2daee2e7df5fd50e5aa2fdeb0d'),
            ('2m/chedar_0491_UV2m.sofa', '5341c7a4286ab9de25386986782d26bd'),
            ('2m/chedar_0492_UV2m.sofa', 'd7905aeaecbee29241914f1febdb495d'),
            ('2m/chedar_0493_UV2m.sofa', 'd5e28128eaa5675f00bdcbaa089e1a99'),
            ('2m/chedar_0494_UV2m.sofa', '0f9bf5606dcf2904cf1d627fcb0971f6'),
            ('2m/chedar_0495_UV2m.sofa', 'f75a95f156da99416ec8a6bb06b542fa'),
            ('2m/chedar_0496_UV2m.sofa', '0eed1b5256ab57df651cc16cfbcfa1b5'),
            ('2m/chedar_0497_UV2m.sofa', '3176f07cf8bdba6492dd40862b6d445e'),
            ('2m/chedar_0498_UV2m.sofa', 'c6d6a3f7b92a1ebb25ca38bd3ffe9a9d'),
            ('2m/chedar_0499_UV2m.sofa', '1166fbffb8f96909673e1d59d1128c7a'),
            ('2m/chedar_0500_UV2m.sofa', 'a808c75cee6bd87f01df9fa84c9db112'),
            ('2m/chedar_0501_UV2m.sofa', '0c6e240838dcb21933ef605dd34ddc4c'),
            ('2m/chedar_0502_UV2m.sofa', '58e2ccb22686151ba04bf110568367fa'),
            ('2m/chedar_0503_UV2m.sofa', '4eab65c6e11b9a582d671e679db7b147'),
            ('2m/chedar_0504_UV2m.sofa', 'b3a115060b13c50af815488f1b63380c'),
            ('2m/chedar_0505_UV2m.sofa', 'ba9c2254e836c3b3017486c6685b2890'),
            ('2m/chedar_0506_UV2m.sofa', 'f98be135b4adfe1878865fa4d564f17e'),
            ('2m/chedar_0507_UV2m.sofa', '04e259f9581249c7e75164413427fd0b'),
            ('2m/chedar_0508_UV2m.sofa', '8646d7cbe361f58d33d5398f230aca5e'),
            ('2m/chedar_0509_UV2m.sofa', '37e9436a4340930a8338d8c4e29781a2'),
            ('2m/chedar_0510_UV2m.sofa', 'f4817544efdbd02f8b207782c843e4c5'),
            ('2m/chedar_0511_UV2m.sofa', '021328499bd17e91aa1638fa16b289b5'),
            ('2m/chedar_0512_UV2m.sofa', 'dcd4514419ab92c7211ecdc3f9def4fc'),
            ('2m/chedar_0513_UV2m.sofa', '8f4faeb18f2ddcaf9fce46527536bd9f'),
            ('2m/chedar_0514_UV2m.sofa', 'a6c2c1a75b8bc1030aa2932cd540d2c8'),
            ('2m/chedar_0515_UV2m.sofa', '3c5666c83e98c518186034d861fc1566'),
            ('2m/chedar_0516_UV2m.sofa', '3ca876bc79eedccd50361c95d2194e43'),
            ('2m/chedar_0517_UV2m.sofa', '6a2b3e54c8444af302582ec194d8399c'),
            ('2m/chedar_0518_UV2m.sofa', '78d2976350bada5f47c293124ba9c840'),
            ('2m/chedar_0519_UV2m.sofa', 'd4fb11fb38c54a708843522d6935e339'),
            ('2m/chedar_0520_UV2m.sofa', '3263d39e2bc3ac731be383cec95e3aed'),
            ('2m/chedar_0521_UV2m.sofa', 'c46fe056f3501c36f104c5ceef58d6ca'),
            ('2m/chedar_0522_UV2m.sofa', 'bb4d9e7fb7ffc65067465295b364819c'),
            ('2m/chedar_0523_UV2m.sofa', '7a53fa7d9a863935a9ed263fdb617d4b'),
            ('2m/chedar_0524_UV2m.sofa', '3d9acc6cc03a0e7dd653ced7745a83ca'),
            ('2m/chedar_0525_UV2m.sofa', '728df7aeac3f1555437748c5a5cab92d'),
            ('2m/chedar_0526_UV2m.sofa', '2a7fd5fe88d4aeffcbfbd393ef25a2b8'),
            ('2m/chedar_0527_UV2m.sofa', '8d70feab638bc87c768f777eb7a5f7d1'),
            ('2m/chedar_0528_UV2m.sofa', '8673d5cdd74b62935a610d6245fe3895'),
            ('2m/chedar_0529_UV2m.sofa', '54eef4a73d9913ca3b2d84bd7903ef9f'),
            ('2m/chedar_0530_UV2m.sofa', 'fb6d88dcf02a00bb9eceefed3c4f673f'),
            ('2m/chedar_0531_UV2m.sofa', 'd9f956de16b9a0043e11c8619b658fa3'),
            ('2m/chedar_0532_UV2m.sofa', '57f0d1e9b310b7842c76205615a3a87c'),
            ('2m/chedar_0533_UV2m.sofa', 'c0d5bd4b4a3809baf4a2efd3b08edaab'),
            ('2m/chedar_0534_UV2m.sofa', '08e64d4aabe3389ca97b577cf958c22c'),
            ('2m/chedar_0535_UV2m.sofa', '85dec2f8dbf636149721eedc41cf0c32'),
            ('2m/chedar_0536_UV2m.sofa', '3a9bbedc69221ff948650194f976bb5d'),
            ('2m/chedar_0537_UV2m.sofa', 'aa691db4fca4dcc4f0e42e90ef34bcbf'),
            ('2m/chedar_0538_UV2m.sofa', 'beed828312cbf01c84bda8d3e430ddc1'),
            ('2m/chedar_0539_UV2m.sofa', '49efd8c558878bb8b75bc0acb302a47c'),
            ('2m/chedar_0540_UV2m.sofa', 'd425473f6be407a40d479ff4003da7c8'),
            ('2m/chedar_0541_UV2m.sofa', '2bced284b23ab7c3b69f32304a55dde6'),
            ('2m/chedar_0542_UV2m.sofa', '47e9000e872b410ea6d3425306402e9b'),
            ('2m/chedar_0543_UV2m.sofa', 'b88288645df2fb63e34db20bb92f3b6a'),
            ('2m/chedar_0544_UV2m.sofa', 'cf1af5b11d89a3077761cc010cff3008'),
            ('2m/chedar_0545_UV2m.sofa', '2f6110fd7f2cce92ebae02a2faed7044'),
            ('2m/chedar_0546_UV2m.sofa', '08a5c038a818880a2139272f819efbc1'),
            ('2m/chedar_0547_UV2m.sofa', '05b224e9b30e9a2084bef64a293ecd4d'),
            ('2m/chedar_0548_UV2m.sofa', 'ad79f95500baa34a47cbfe87e496b0ae'),
            ('2m/chedar_0549_UV2m.sofa', 'dbac33c7741557a773debb61de78978a'),
            ('2m/chedar_0550_UV2m.sofa', '8e1b4fcd7f0454ad142aa61f4f7871bf'),
            ('2m/chedar_0551_UV2m.sofa', '1332076b8148d84bc5497b0fa973df11'),
            ('2m/chedar_0552_UV2m.sofa', '3cc5a41d6ed0443a0fed566821271886'),
            ('2m/chedar_0553_UV2m.sofa', '94d854bf794367c6f6a429fff5c7c4a2'),
            ('2m/chedar_0554_UV2m.sofa', '2f77edca14a28b52a858817823c6f353'),
            ('2m/chedar_0555_UV2m.sofa', '617d6d1561e5600e813f4a09a42b631b'),
            ('2m/chedar_0556_UV2m.sofa', '3e16d4be2a929b1eb5e7717ca37dcccb'),
            ('2m/chedar_0557_UV2m.sofa', '7eff64ebcbb88ad7e013e56b632392f9'),
            ('2m/chedar_0558_UV2m.sofa', 'cc5652e4320a760fbf791d198b37de22'),
            ('2m/chedar_0559_UV2m.sofa', '74991b0a77b2996bafe121d3ae1267b0'),
            ('2m/chedar_0560_UV2m.sofa', '55ff90fc2f42b8a756f12e83eafde769'),
            ('2m/chedar_0561_UV2m.sofa', 'e2db0fc27539a4134958e5c49843607a'),
            ('2m/chedar_0562_UV2m.sofa', 'eceaece7fc9460d77d4e29d6c7afb301'),
            ('2m/chedar_0563_UV2m.sofa', 'd1652ce3c6ff4c13109648dbe8c0b3d8'),
            ('2m/chedar_0564_UV2m.sofa', '175ec0a7fae9bb2487c2d12684a80fec'),
            ('2m/chedar_0565_UV2m.sofa', 'ac70083869bd4e31eaf5db61ba8b4a99'),
            ('2m/chedar_0566_UV2m.sofa', 'b81d003a5bb98003db493b644a166dc5'),
            ('2m/chedar_0567_UV2m.sofa', 'e4b76367ceabb8c845051757af3f00c3'),
            ('2m/chedar_0568_UV2m.sofa', '269058a8fe5bfb8ccb642d31cd45f1d1'),
            ('2m/chedar_0569_UV2m.sofa', 'a1f53a2083349a922b77d2a980253621'),
            ('2m/chedar_0570_UV2m.sofa', 'd4d93129defaf5463f6b2e9f1b3f01e4'),
            ('2m/chedar_0571_UV2m.sofa', '78a3a7e6e22079296311fc19cf8cfb59'),
            ('2m/chedar_0572_UV2m.sofa', '49a44ded6e5e2b8a9893ea8bc2b05117'),
            ('2m/chedar_0573_UV2m.sofa', 'f1b04d64e770a5e549a31dec878005db'),
            ('2m/chedar_0574_UV2m.sofa', '726f1a08b14dbda34ff2fa9f9132ae15'),
            ('2m/chedar_0575_UV2m.sofa', '9442031b6578462be9db32a662558cf0'),
            ('2m/chedar_0576_UV2m.sofa', '2d6ab4890335faefe03d6ac0a3340cef'),
            ('2m/chedar_0577_UV2m.sofa', 'a58f96d3bb8fbb70d16c0474af4e4da4'),
            ('2m/chedar_0578_UV2m.sofa', 'f4741aa0d641ac5ec145dd55dd86fde9'),
            ('2m/chedar_0579_UV2m.sofa', '9d0c68abba9f8654d83657f355e3ff44'),
            ('2m/chedar_0580_UV2m.sofa', '824455ccf4f4c4690318284e10fed527'),
            ('2m/chedar_0581_UV2m.sofa', 'b1d3de9f9ea4ac38c883a64c42007340'),
            ('2m/chedar_0582_UV2m.sofa', '6cdffd35829bfd693c6e2fb96b4ae782'),
            ('2m/chedar_0583_UV2m.sofa', 'dcd5eb651dd3d002564feeb0f0cfea36'),
            ('2m/chedar_0584_UV2m.sofa', 'ecef06f6b755491e8ef03396b0c189c6'),
            ('2m/chedar_0585_UV2m.sofa', '92829002049dd71f35bc1cbb62a57103'),
            ('2m/chedar_0586_UV2m.sofa', '882888196f7d40f18a3660b08dafaecf'),
            ('2m/chedar_0587_UV2m.sofa', 'aa93a95e72a96b48bd022b023782eb45'),
            ('2m/chedar_0588_UV2m.sofa', '36933c98672327202b6afc625196893a'),
            ('2m/chedar_0589_UV2m.sofa', '006c356f084792052cf9c7ec4a898dd1'),
            ('2m/chedar_0590_UV2m.sofa', '97c01927e3cdcec2565361cec153c78b'),
            ('2m/chedar_0591_UV2m.sofa', '428fb81354b5a10a436ec82ca53b5b1a'),
            ('2m/chedar_0592_UV2m.sofa', '50da03b99a3b0ab61b7cc9a20dd0d11b'),
            ('2m/chedar_0593_UV2m.sofa', '1d3b4ec219176f82ce83f87adb54c44b'),
            ('2m/chedar_0594_UV2m.sofa', 'e3ca493679feb97466ee9a68d33bf1dc'),
            ('2m/chedar_0595_UV2m.sofa', '622ac699b2760315f6bc8cd1b99ae7fb'),
            ('2m/chedar_0596_UV2m.sofa', 'd3a7e266447cf3228b80b6ba63da06ef'),
            ('2m/chedar_0597_UV2m.sofa', '759fd948518377fda5897f2e44264aa0'),
            ('2m/chedar_0598_UV2m.sofa', '7214182ac086889a3cafc92172fc7ad1'),
            ('2m/chedar_0599_UV2m.sofa', 'fa53881c3b99e130cdda43376389183f'),
            ('2m/chedar_0600_UV2m.sofa', '4720769f822bdccbbefebbf4f03306e1'),
            ('2m/chedar_0601_UV2m.sofa', 'afb730feac109c84beadbafbb810432b'),
            ('2m/chedar_0602_UV2m.sofa', 'c79d665d97fedc843a2786c4867af4a9'),
            ('2m/chedar_0603_UV2m.sofa', '2dedf538f74db7c3afb42920996409dd'),
            ('2m/chedar_0604_UV2m.sofa', '9c3ecac05c8b69e14a2843edec1870d6'),
            ('2m/chedar_0605_UV2m.sofa', '32393d0dac15b7b3e16c2a4fcae77191'),
            ('2m/chedar_0606_UV2m.sofa', '1968a0833588e197db0d90d1e0d5e1b8'),
            ('2m/chedar_0607_UV2m.sofa', '5a219f06a2b92ac7f28a12f2d23e25c4'),
            ('2m/chedar_0608_UV2m.sofa', '771f4c31137fe8ef4d09eacaed28bcdf'),
            ('2m/chedar_0609_UV2m.sofa', '4c8eaa354572011da37af2dab260b3de'),
            ('2m/chedar_0610_UV2m.sofa', 'e5ac544b0880d7820c875d507ab1cdb0'),
            ('2m/chedar_0611_UV2m.sofa', 'bc11e39c9a54975c6b65a98a3c845220'),
            ('2m/chedar_0612_UV2m.sofa', 'f853cdfd1759961963874e603d93fd69'),
            ('2m/chedar_0613_UV2m.sofa', '5316d44500ab05253e478ff025df5970'),
            ('2m/chedar_0614_UV2m.sofa', '81e8724a09d5349a48ff998b87cf637c'),
            ('2m/chedar_0615_UV2m.sofa', '15a2d757ee5a5b9a0375212dd6fccf27'),
            ('2m/chedar_0616_UV2m.sofa', '5f1dc5a9ef625ab2f83c2a57f60badd5'),
            ('2m/chedar_0617_UV2m.sofa', '6231735f7d93c521f6a90016e4b8bff3'),
            ('2m/chedar_0618_UV2m.sofa', '6446fae94e98ae92ee28de7c8add0fad'),
            ('2m/chedar_0619_UV2m.sofa', '0243e45a09c11ffece83993a9359fb85'),
            ('2m/chedar_0620_UV2m.sofa', 'f34e3f6f4f516b8705143cfc82e10753'),
            ('2m/chedar_0621_UV2m.sofa', '2903a9fbf54076083b5c61f4f61056b6'),
            ('2m/chedar_0622_UV2m.sofa', '6be3de88952eb32ebf24e4ef2b8c1db6'),
            ('2m/chedar_0623_UV2m.sofa', 'd04d5da6a002aa4161edfbefb1372ff1'),
            ('2m/chedar_0624_UV2m.sofa', '2a6e1f55cff84c9c64b68a4de2ef1a8a'),
            ('2m/chedar_0625_UV2m.sofa', '9334a781f70a92466732f91c266240a8'),
            ('2m/chedar_0626_UV2m.sofa', '703510528ffad41b11754e1f42f80edf'),
            ('2m/chedar_0627_UV2m.sofa', '1a5a0dceb59f39dcc1b7f5da44b2d66a'),
            ('2m/chedar_0628_UV2m.sofa', 'e79cff362a36840eeb1345433bd76d7b'),
            ('2m/chedar_0629_UV2m.sofa', '7109f5f6eb1397fc5d7b7b3a64181a96'),
            ('2m/chedar_0630_UV2m.sofa', 'd089802e3bf793c2ae70372165e216e3'),
            ('2m/chedar_0631_UV2m.sofa', '130b4b62642a1de6ebee88503027b114'),
            ('2m/chedar_0632_UV2m.sofa', '2d4392be50294214141a4ddf1db809eb'),
            ('2m/chedar_0633_UV2m.sofa', 'be198fe8f6baec3d0c352c978d7df15d'),
            ('2m/chedar_0634_UV2m.sofa', 'ceedbd34ace33a9c48f086e9190fb1bb'),
            ('2m/chedar_0635_UV2m.sofa', '0ff2bacb3100b06e02a1e46167d9b1ac'),
            ('2m/chedar_0636_UV2m.sofa', 'c82537df38bf9293c0639dea00149359'),
            ('2m/chedar_0637_UV2m.sofa', 'f739dbec8fbd259ee0876cf73adf78e1'),
            ('2m/chedar_0638_UV2m.sofa', '30f56efb4531c273cf46e7107b8ca168'),
            ('2m/chedar_0639_UV2m.sofa', 'c0d95735cddc24f6bed60b09bb12c90b'),
            ('2m/chedar_0640_UV2m.sofa', 'fb599690ce7c3f40900b4289b8376541'),
            ('2m/chedar_0641_UV2m.sofa', '670b997b4807292bd5ff329389967e2e'),
            ('2m/chedar_0642_UV2m.sofa', '1b85a53fed756e9aa9ff147d5a3121cd'),
            ('2m/chedar_0643_UV2m.sofa', 'a13bfefb74fba513f150407eb72087a3'),
            ('2m/chedar_0644_UV2m.sofa', '062653cf5f6cca7d1cfa34e799e4aee1'),
            ('2m/chedar_0645_UV2m.sofa', '98ce34036069bb011db94b4070b1f33d'),
            ('2m/chedar_0646_UV2m.sofa', '1756688d576f98978aea0ef1f9e7b1f0'),
            ('2m/chedar_0647_UV2m.sofa', '784759f25983dd909fad5e805c4bb91a'),
            ('2m/chedar_0648_UV2m.sofa', '1c4086887bac7ea6cf90cab3f708ea71'),
            ('2m/chedar_0649_UV2m.sofa', '646650fc70cc79d1d3df8e268208f07f'),
            ('2m/chedar_0650_UV2m.sofa', '88b15e026d684805983a91e5bd0df1f5'),
            ('2m/chedar_0651_UV2m.sofa', '95975b4558bf24b6f37f7af5f6801450'),
            ('2m/chedar_0652_UV2m.sofa', 'd6059b5116e2427c957d463052a6c0dd'),
            ('2m/chedar_0653_UV2m.sofa', 'db7d299e0a7b473d507c7d37320f97ec'),
            ('2m/chedar_0654_UV2m.sofa', 'dd66f71c6ea0c1c65d70376d1a50b4c4'),
            ('2m/chedar_0655_UV2m.sofa', '4eaf23e0baf8018b82f185b415539e47'),
            ('2m/chedar_0656_UV2m.sofa', '24b8784a922f9cc90539db20a966dd05'),
            ('2m/chedar_0657_UV2m.sofa', '303938b74e8a2cff0e8a70a23f1b3590'),
            ('2m/chedar_0658_UV2m.sofa', '0431de7ecac5295f626423c63ef4aaa9'),
            ('2m/chedar_0659_UV2m.sofa', 'b41641be1b268a2b166c95f54acf02d5'),
            ('2m/chedar_0660_UV2m.sofa', 'de37947ea45b5988338816be42ee4faf'),
            ('2m/chedar_0661_UV2m.sofa', '79e246aa10a0dffddf177f2f3ad9eb81'),
            ('2m/chedar_0662_UV2m.sofa', 'b685a57b902fe847b21537ef67800678'),
            ('2m/chedar_0663_UV2m.sofa', '8d7e812efa1257b7d1b59b7232af705a'),
            ('2m/chedar_0664_UV2m.sofa', '26d67a4d03b140be3dec20e06358f504'),
            ('2m/chedar_0665_UV2m.sofa', 'a333756212d6d46919af1d28c5303cd9'),
            ('2m/chedar_0666_UV2m.sofa', '8180ed9d2aaf605b2b0919e64e260523'),
            ('2m/chedar_0667_UV2m.sofa', '42668840df1358177d97564a86be17c0'),
            ('2m/chedar_0668_UV2m.sofa', '8c3be003e9995155ab2ce87db36cc2f7'),
            ('2m/chedar_0669_UV2m.sofa', '4bc480d06a9f080f68dda809bbd705a7'),
            ('2m/chedar_0670_UV2m.sofa', '19db973db7bd29007c0d2b1cf5dce4c7'),
            ('2m/chedar_0671_UV2m.sofa', 'b6c331e51e22c29393b33f2686a0d18e'),
            ('2m/chedar_0672_UV2m.sofa', '6ca87896f94fa521212aea08965bf17a'),
            ('2m/chedar_0673_UV2m.sofa', 'c41a6474bbd06ec1bb890b73b7d23cd4'),
            ('2m/chedar_0674_UV2m.sofa', 'db00ac40864af2b8cfe8c685bd3576a5'),
            ('2m/chedar_0675_UV2m.sofa', '524e31579e21d875d5ed7c95c1f92b1a'),
            ('2m/chedar_0676_UV2m.sofa', '45b9b83240e0d870e4862456cbbfa124'),
            ('2m/chedar_0677_UV2m.sofa', '36c43fdedfdbaf39fdc89c1d11d47c60'),
            ('2m/chedar_0678_UV2m.sofa', 'dd239b4ef1e6d10f18a0ad7bd97d4f4b'),
            ('2m/chedar_0679_UV2m.sofa', 'e1193719089d6fbc40af75f13834bab6'),
            ('2m/chedar_0680_UV2m.sofa', '1511980616bb3fe10267bfd6783081e5'),
            ('2m/chedar_0681_UV2m.sofa', '1248efc2a7054f28854cd5325a226eb2'),
            ('2m/chedar_0682_UV2m.sofa', '5941cd28feac78fe67ef5ac0da4c7db8'),
            ('2m/chedar_0683_UV2m.sofa', '0649131831f712c6772bb3d07f413e60'),
            ('2m/chedar_0684_UV2m.sofa', '7b6d73ac5ae6062cc16771705dd291a8'),
            ('2m/chedar_0685_UV2m.sofa', '722a8c8f663172dd9f328546630ca101'),
            ('2m/chedar_0686_UV2m.sofa', '9b538e1fe6213a80d8e1715bd2feffe8'),
            ('2m/chedar_0687_UV2m.sofa', '2852cb0ed4639aa142e80f5793d3792a'),
            ('2m/chedar_0688_UV2m.sofa', 'c03c733f33160ce4d5332e7f03683d57'),
            ('2m/chedar_0689_UV2m.sofa', '198d0e35d984ced93d33ccdccd8f41f3'),
            ('2m/chedar_0690_UV2m.sofa', 'e27aa7d62189457ab22792695c3736b6'),
            ('2m/chedar_0691_UV2m.sofa', '7dff9850309fdf253be38115f7c57265'),
            ('2m/chedar_0692_UV2m.sofa', '2afa4cb299ddd0b66ffb85abf717fd1a'),
            ('2m/chedar_0693_UV2m.sofa', 'adbe5d0c6fed1e925b67b275fdf96c95'),
            ('2m/chedar_0694_UV2m.sofa', 'd1b2ed6b92d95f78006a6ff583ee6c70'),
            ('2m/chedar_0695_UV2m.sofa', 'e6f9eeabee5438adf95bca723af1926e'),
            ('2m/chedar_0696_UV2m.sofa', 'e6f4f1ad09600c86b6d0e6a2d24dada4'),
            ('2m/chedar_0697_UV2m.sofa', 'b9c6d054c3cf81c9c3c170ce7887961d'),
            ('2m/chedar_0698_UV2m.sofa', '69a23df67c390c83ee025489caed3d90'),
            ('2m/chedar_0699_UV2m.sofa', 'ad9c38f2c7c3e040f65ffeeaa54fd031'),
            ('2m/chedar_0700_UV2m.sofa', 'fbbab182f12439aa4fa165b2961b2dbe'),
            ('2m/chedar_0701_UV2m.sofa', 'c857191ff5ad66cd5c80f26056a926ab'),
            ('2m/chedar_0702_UV2m.sofa', '088cb48cafe2e113695b0eec707792dd'),
            ('2m/chedar_0703_UV2m.sofa', '50190ee8c77ced4cb0e27e2aa5f69152'),
            ('2m/chedar_0704_UV2m.sofa', 'a3b876b7d5adcc38d8848a02283d3d17'),
            ('2m/chedar_0705_UV2m.sofa', '282f2039ea7ca08e7ce8f79e72fff61e'),
            ('2m/chedar_0706_UV2m.sofa', 'f35e16abf7e7fb1e3db81e432d677aff'),
            ('2m/chedar_0707_UV2m.sofa', 'bbd056ca7d0eeae6fc078f15b5fcbb3c'),
            ('2m/chedar_0708_UV2m.sofa', 'f698426e5295fbf49ad3635c643e8ac6'),
            ('2m/chedar_0709_UV2m.sofa', '408128f87161800a4e2ba4afdefb606d'),
            ('2m/chedar_0710_UV2m.sofa', 'e2cfd1f987ec5db0f7df086c06d71fdc'),
            ('2m/chedar_0711_UV2m.sofa', '37d6981aa668b8301348f528e56482ec'),
            ('2m/chedar_0712_UV2m.sofa', '01bfd0c3d8aadc8330bb650e5719ccc9'),
            ('2m/chedar_0713_UV2m.sofa', '555352f882994f1fa8b41695d044e62c'),
            ('2m/chedar_0714_UV2m.sofa', '4aa4e625c67fe217a399e078451f92f8'),
            ('2m/chedar_0715_UV2m.sofa', '254447305cf0376e8ebe9e55640f9336'),
            ('2m/chedar_0716_UV2m.sofa', 'bbbeddb9224069840da49303fae0b626'),
            ('2m/chedar_0717_UV2m.sofa', '7c3ed69c898ea84d31fc9708c57fa13e'),
            ('2m/chedar_0718_UV2m.sofa', '19ad2326a8c545ad29099ea82b8fff23'),
            ('2m/chedar_0719_UV2m.sofa', '1b018552f9cc75f69a3d572d41043792'),
            ('2m/chedar_0720_UV2m.sofa', 'f283fe78eec959bd597805aa32accf23'),
            ('2m/chedar_0721_UV2m.sofa', '594b056d0a93aa3896c4609b1fb1aa12'),
            ('2m/chedar_0722_UV2m.sofa', '7ed314cee2bb4662191062b5bdb76777'),
            ('2m/chedar_0723_UV2m.sofa', '800a56fda068bb19de50922dff726c9a'),
            ('2m/chedar_0724_UV2m.sofa', 'e47d358147d390b0258a3987c86c15e9'),
            ('2m/chedar_0725_UV2m.sofa', 'ae99ea4717e4e2ea4301d088a07ac72d'),
            ('2m/chedar_0726_UV2m.sofa', '934a3d90d3eb843a2016d4b7fdc0fd6c'),
            ('2m/chedar_0727_UV2m.sofa', '6cfd06cbc3e53833e085725a642a4de8'),
            ('2m/chedar_0728_UV2m.sofa', '34f523e9acc728f08a04787c3afc1ca5'),
            ('2m/chedar_0729_UV2m.sofa', '0b5ef8d1fc1a611aba79921a7b14885b'),
            ('2m/chedar_0730_UV2m.sofa', '184f9b3381c8da3b75fbb2d83188c895'),
            ('2m/chedar_0731_UV2m.sofa', '68412c5c40ad3f358b7748693792335d'),
            ('2m/chedar_0732_UV2m.sofa', 'f44a75ddd24241ce81f444908505e98a'),
            ('2m/chedar_0733_UV2m.sofa', 'ef4777aecfa03fe28d9d763338384b63'),
            ('2m/chedar_0734_UV2m.sofa', '8e47f871e9a8ff4a23bc4fadb8294df6'),
            ('2m/chedar_0735_UV2m.sofa', 'eff34e06f0342135bdb0ef80f9e1f56e'),
            ('2m/chedar_0736_UV2m.sofa', '413fd21bc30f1c1986fe525990a6e97d'),
            ('2m/chedar_0737_UV2m.sofa', 'd614b40b2d9cf364393877c8dfea30d6'),
            ('2m/chedar_0738_UV2m.sofa', '9dd147e63e8b9b0c8dc82a232a676957'),
            ('2m/chedar_0739_UV2m.sofa', '992d5a90ac2df3ce0f3eb193d16585b0'),
            ('2m/chedar_0740_UV2m.sofa', '508f2a81b4fd5b7a09be61d3dc0e439d'),
            ('2m/chedar_0741_UV2m.sofa', '24c6c7dda5612dea1f400a86ca32a7fa'),
            ('2m/chedar_0742_UV2m.sofa', '5c6745d75ea1ed92cfe77a37afd7f8ca'),
            ('2m/chedar_0743_UV2m.sofa', '5696f190988cd970f5c4a54dd9af01a2'),
            ('2m/chedar_0744_UV2m.sofa', '7189d365b3889b3c9eddac4dc3f17057'),
            ('2m/chedar_0745_UV2m.sofa', '5b193de062e348d17bfcbda2b1af6d13'),
            ('2m/chedar_0746_UV2m.sofa', '490b7f2ec9c8d43d95c53b838804f392'),
            ('2m/chedar_0747_UV2m.sofa', '450f9619a8f5ac904d4309f0a8fa937f'),
            ('2m/chedar_0748_UV2m.sofa', 'fb4f2d9a6c22f44e6f288eb239f544aa'),
            ('2m/chedar_0749_UV2m.sofa', '02c416f15f73705e48c255a7b287236d'),
            ('2m/chedar_0750_UV2m.sofa', '7a0d78cbf14cc75e3bf1873dfe209b42'),
            ('2m/chedar_0751_UV2m.sofa', '507d42465e607897b44dd37de9fd82b9'),
            ('2m/chedar_0752_UV2m.sofa', '7cc4b6dcac3e77a22d5c6a19c24c1cd9'),
            ('2m/chedar_0753_UV2m.sofa', 'bc0bf36a9a80566116720fa239cee72a'),
            ('2m/chedar_0754_UV2m.sofa', 'd0938b01cde037228e018d03cf78c758'),
            ('2m/chedar_0755_UV2m.sofa', 'c773ea1ffa7b42c5b357b5514ce623f0'),
            ('2m/chedar_0756_UV2m.sofa', '8af73b0d4a1f159b4dfdda5aab526c0f'),
            ('2m/chedar_0757_UV2m.sofa', 'da12b9bd67af5860e01c7527c93e7b39'),
            ('2m/chedar_0758_UV2m.sofa', '687a3b78a02d2e43a330b40d8362f4bf'),
            ('2m/chedar_0759_UV2m.sofa', '35846fc1f795e5b07a9bca3d6033e882'),
            ('2m/chedar_0760_UV2m.sofa', '98e22a36da23f83dfe1df6264e2a1c07'),
            ('2m/chedar_0761_UV2m.sofa', '491054ca6245cae885ab361c2ab53449'),
            ('2m/chedar_0762_UV2m.sofa', '3058fed277b32a6d1fe3b8c43a68c6c3'),
            ('2m/chedar_0763_UV2m.sofa', '44b2fe98be00eb05db608d3861ddb8c3'),
            ('2m/chedar_0764_UV2m.sofa', 'dc5537644a3116dd2614d4c30858e9a2'),
            ('2m/chedar_0765_UV2m.sofa', '624b8a766dd64cdcfc5eef116f261a03'),
            ('2m/chedar_0766_UV2m.sofa', '075a41ac3bcf93473ac8ad501ac8a76e'),
            ('2m/chedar_0767_UV2m.sofa', 'ad6a1944010164e23821c0d333b8fc29'),
            ('2m/chedar_0768_UV2m.sofa', '7f48f9304238f533d9d9d3a76e816e12'),
            ('2m/chedar_0769_UV2m.sofa', '8e01ec5a3e4f9359c86ed48f921aa223'),
            ('2m/chedar_0770_UV2m.sofa', '3f5006f1de007a20acf15c529388a7dd'),
            ('2m/chedar_0771_UV2m.sofa', 'cec71729ff2b9c1fbe754dbd72d09f96'),
            ('2m/chedar_0772_UV2m.sofa', 'bee82cc3926d68adb25e9d2f3aa3b9c0'),
            ('2m/chedar_0773_UV2m.sofa', 'ad37db0533b00cd289294db3dbe9c1d1'),
            ('2m/chedar_0774_UV2m.sofa', 'afc71c03fd7115a2eeaebfcbe8403984'),
            ('2m/chedar_0775_UV2m.sofa', '0f08ad268e8ce01a2582eb199d6e097c'),
            ('2m/chedar_0776_UV2m.sofa', '5d4a7c4ee763790a6044b2310e407037'),
            ('2m/chedar_0777_UV2m.sofa', 'b0f9e22feecf396372edb2e5d1561823'),
            ('2m/chedar_0778_UV2m.sofa', '325318882a2d6d52b4d45884ae4a01be'),
            ('2m/chedar_0779_UV2m.sofa', '640560a61c0f7de928ae19a17a6345f8'),
            ('2m/chedar_0780_UV2m.sofa', '5a88689d4a8f7b5078167f444d773fb7'),
            ('2m/chedar_0781_UV2m.sofa', '38187d86e1ec0f1f87386619339f13f9'),
            ('2m/chedar_0782_UV2m.sofa', '409465bb88e8e047e1ddab41d01e92c4'),
            ('2m/chedar_0783_UV2m.sofa', 'fed74bb4a79486f431288a00dcb35131'),
            ('2m/chedar_0784_UV2m.sofa', '39eda946bcedaa93370d1dd24cef7b09'),
            ('2m/chedar_0785_UV2m.sofa', '64604cf398d6c3164fcb3db1f3fcf0d7'),
            ('2m/chedar_0786_UV2m.sofa', 'a7e12fb570677f928f0ea6047caa743b'),
            ('2m/chedar_0787_UV2m.sofa', '27d15a920a6e016464afe6307e063bb9'),
            ('2m/chedar_0788_UV2m.sofa', 'ad8b1d6de5a98482d75184365d649240'),
            ('2m/chedar_0789_UV2m.sofa', '2a3a8721320e7f26a44f5d6d9a72a1ee'),
            ('2m/chedar_0790_UV2m.sofa', '1a6d103c1310a4e8fb97e34a59d3d44f'),
            ('2m/chedar_0791_UV2m.sofa', 'd56bf67beeeea43d0f5f968f4c8b873c'),
            ('2m/chedar_0792_UV2m.sofa', '2995707a877eed65b678c4444a14533d'),
            ('2m/chedar_0793_UV2m.sofa', '31288392798625f50c180b6cc51b0774'),
            ('2m/chedar_0794_UV2m.sofa', 'c440f0917694ad3b18f129a2b847c11c'),
            ('2m/chedar_0795_UV2m.sofa', '96ade0bf918a4bdbdafd9911b9d7ff32'),
            ('2m/chedar_0796_UV2m.sofa', '7c4d2a3b1cfcc6df7856fada2e37b604'),
            ('2m/chedar_0797_UV2m.sofa', 'b7b8b690fd3baeb12f29ef1acdd6c28b'),
            ('2m/chedar_0798_UV2m.sofa', '7bdd10ba0d071a6b30daf0094dbd8645'),
            ('2m/chedar_0799_UV2m.sofa', 'f8a64994c7d752ad4bd9a02f8cb08c93'),
            ('2m/chedar_0800_UV2m.sofa', 'be0a485aa74a40d7efb947cd79787c8d'),
            ('2m/chedar_0801_UV2m.sofa', 'b17f3f0ee367dbb7bc2bbfe15f0e4d0e'),
            ('2m/chedar_0802_UV2m.sofa', '51df2621f3a9157d18a6b653029921ea'),
            ('2m/chedar_0803_UV2m.sofa', 'bc11f8af9fc56104b24961f7bb424dda'),
            ('2m/chedar_0804_UV2m.sofa', 'ba49c8ce5ae35d434895daf4b9b2a736'),
            ('2m/chedar_0805_UV2m.sofa', 'b58b36e889ac05ddcfcfa76dbba2ffb7'),
            ('2m/chedar_0806_UV2m.sofa', '748a2484fe9096b43b1e2c405533ae37'),
            ('2m/chedar_0807_UV2m.sofa', '765ba6b9e2561dba22497328e381907c'),
            ('2m/chedar_0808_UV2m.sofa', 'ab6381ff6f28f02bd59d4d2c13f74efd'),
            ('2m/chedar_0809_UV2m.sofa', 'cc80016de3b447c5aa323b8a407148d9'),
            ('2m/chedar_0810_UV2m.sofa', '6c48777bd031021a20abd0c1e0b1eeee'),
            ('2m/chedar_0811_UV2m.sofa', '084f4a0791b0b823e428d256e2c2711c'),
            ('2m/chedar_0812_UV2m.sofa', 'ce42d04a8fac60de56d842f4da0093f9'),
            ('2m/chedar_0813_UV2m.sofa', 'f56667beee886e2c4643ddced3253c87'),
            ('2m/chedar_0814_UV2m.sofa', 'b8c2c12958e40f06be7613785cab4c5e'),
            ('2m/chedar_0815_UV2m.sofa', '231574da5335a026cca61a3452a38d30'),
            ('2m/chedar_0816_UV2m.sofa', '9949c72821bb1911031e17a2f8505ea7'),
            ('2m/chedar_0817_UV2m.sofa', '21fbedc41ded339f3429efd092958dae'),
            ('2m/chedar_0818_UV2m.sofa', '59b774cc42b830cf0a1c33fb69be19e1'),
            ('2m/chedar_0819_UV2m.sofa', 'ad1b89d7207eb44fd6f1080cdd9bfa8a'),
            ('2m/chedar_0820_UV2m.sofa', 'ab9ced70d247bd59dd335b554aeca681'),
            ('2m/chedar_0821_UV2m.sofa', '068248c120d9c56bd81b8f4f436ba49e'),
            ('2m/chedar_0822_UV2m.sofa', 'ac76c9456337205324511b4d31598d20'),
            ('2m/chedar_0823_UV2m.sofa', 'a789b071cbfe25c7680306e719619961'),
            ('2m/chedar_0824_UV2m.sofa', 'de1cae54f1174d63a3aaaf1dead122dd'),
            ('2m/chedar_0825_UV2m.sofa', 'c69f26beb8b8520956903216043b6df5'),
            ('2m/chedar_0826_UV2m.sofa', 'b0a1f6ccaee3e3d2a45dcd419974a9c1'),
            ('2m/chedar_0827_UV2m.sofa', '157461df5df0fbb5958c4baced03987c'),
            ('2m/chedar_0828_UV2m.sofa', '929b36937875083587214d2371f545ed'),
            ('2m/chedar_0829_UV2m.sofa', '5c4c77b6c87ba27ed1a505493409ff75'),
            ('2m/chedar_0830_UV2m.sofa', '3194379c2139a0402a755808ce16a3da'),
            ('2m/chedar_0831_UV2m.sofa', 'f64bb14a929f12fe016c68578d836d90'),
            ('2m/chedar_0832_UV2m.sofa', '049e082d0c2757b6632305fef4b88b19'),
            ('2m/chedar_0833_UV2m.sofa', '5960e743972e3e4b8f1a5234874df3f5'),
            ('2m/chedar_0834_UV2m.sofa', '1e024a9cef9b326990346e16f8221053'),
            ('2m/chedar_0835_UV2m.sofa', 'c8262489ece3e669cdfaa57752e2f656'),
            ('2m/chedar_0836_UV2m.sofa', 'ab32e0315cbe888a97de1eeebd005417'),
            ('2m/chedar_0837_UV2m.sofa', '4410eacf74c258786e6f544f4c912e43'),
            ('2m/chedar_0838_UV2m.sofa', '3f0de9f9a55fef80643669a03d20d30b'),
            ('2m/chedar_0839_UV2m.sofa', '4d16f3bc7200da25b96efdf29de1e4bd'),
            ('2m/chedar_0840_UV2m.sofa', '9a5e94bb39ba414c86e3931ed66f15d1'),
            ('2m/chedar_0841_UV2m.sofa', '9772b3c08b3baa54f34337992ba6d238'),
            ('2m/chedar_0842_UV2m.sofa', 'f9b07f9cf982d981b642216b57e57c7d'),
            ('2m/chedar_0843_UV2m.sofa', '9c7a764a434c4fd1c0dbfa3c37f364e7'),
            ('2m/chedar_0844_UV2m.sofa', 'e21f20c7fd600db5f2c4e0dbf644f180'),
            ('2m/chedar_0845_UV2m.sofa', '116e030d4bdcf79d54a811893b6596b5'),
            ('2m/chedar_0846_UV2m.sofa', '40e4ffe114475b92b04657a980ee6ac6'),
            ('2m/chedar_0847_UV2m.sofa', '8715b2fca831fec547f77e68a2d9a89f'),
            ('2m/chedar_0848_UV2m.sofa', '549100925dce7267406e287386c4b958'),
            ('2m/chedar_0849_UV2m.sofa', '622118ae7cc57dd21b5459fb62b491df'),
            ('2m/chedar_0850_UV2m.sofa', '47e62bf085c4914696e03fc24c3d4390'),
            ('2m/chedar_0851_UV2m.sofa', 'cf1f9580afde05e7487bd5a32aa901bc'),
            ('2m/chedar_0852_UV2m.sofa', '8f6b77dd1797a9fec32eede959db81af'),
            ('2m/chedar_0853_UV2m.sofa', '79453b67b702f6d7f2c5f0ff8981a642'),
            ('2m/chedar_0854_UV2m.sofa', '1576f9904afff030aeb4a734db167433'),
            ('2m/chedar_0855_UV2m.sofa', 'c53abbeb446a291be2c7480f06a26bf4'),
            ('2m/chedar_0856_UV2m.sofa', '3d2a5d6c8b2d2ebf4e86abb34970f521'),
            ('2m/chedar_0857_UV2m.sofa', '0cea6d57a458e76020e83bfc7b3ff2bb'),
            ('2m/chedar_0858_UV2m.sofa', '85ce56c550bad63cc99c5a726f8ee4c0'),
            ('2m/chedar_0859_UV2m.sofa', '3dade1fbfad2d98099a231e5adbc3432'),
            ('2m/chedar_0860_UV2m.sofa', 'f57a9eab44dca228906cfceb9a0b8bbe'),
            ('2m/chedar_0861_UV2m.sofa', '03490d97b3f56b7534b386d1b7546fc6'),
            ('2m/chedar_0862_UV2m.sofa', '6059f07888212415a8fdaf6ffd5c98df'),
            ('2m/chedar_0863_UV2m.sofa', 'd47896db393834c4593403941d645288'),
            ('2m/chedar_0864_UV2m.sofa', '38ae5921691781d5b97ad918db060dc9'),
            ('2m/chedar_0865_UV2m.sofa', '610300d681fa645f23faf104f39bd18a'),
            ('2m/chedar_0866_UV2m.sofa', '06354436898496dfc5573b89d5989ef0'),
            ('2m/chedar_0867_UV2m.sofa', '419c3b4e360958158adcf37f3d95d961'),
            ('2m/chedar_0868_UV2m.sofa', '4d533832fbb7a7982d0ac2c17e02ec8b'),
            ('2m/chedar_0869_UV2m.sofa', '06b6c97e8c05d47578272466af040fad'),
            ('2m/chedar_0870_UV2m.sofa', '27538cd960ae45de6562e24f4c5817ea'),
            ('2m/chedar_0871_UV2m.sofa', '4ee9ecff8e4cdf13e1588e3b206f9a60'),
            ('2m/chedar_0872_UV2m.sofa', '0205459a519890ee4c0a6d48440de337'),
            ('2m/chedar_0873_UV2m.sofa', '0f0af83b88416dd465c8c8d9a2dbab1a'),
            ('2m/chedar_0874_UV2m.sofa', '63cdfef30e3dc77b26b8668cfb6e2f62'),
            ('2m/chedar_0875_UV2m.sofa', 'b31ee9670d11343313f05ad442042bad'),
            ('2m/chedar_0876_UV2m.sofa', '850c4962f0a8fffbdecf2c845b59b715'),
            ('2m/chedar_0877_UV2m.sofa', 'f499025bc49b34ec4f7d6f1413f0de84'),
            ('2m/chedar_0878_UV2m.sofa', 'ad108fcd830518343a4e6268ff53b4c2'),
            ('2m/chedar_0879_UV2m.sofa', '9dec18f659a6356b6a3e81f80d5e23c9'),
            ('2m/chedar_0880_UV2m.sofa', '3dfe63adc435542af6ba153ce859bd38'),
            ('2m/chedar_0881_UV2m.sofa', '9feea8d72d11d8a896816c71351228e4'),
            ('2m/chedar_0882_UV2m.sofa', 'a7b5a67f6a51acdde6a7bb50d57faad4'),
            ('2m/chedar_0883_UV2m.sofa', '68cea89fcfbe8ebcb9f441658e871554'),
            ('2m/chedar_0884_UV2m.sofa', '7a701c80ffef504e5dc586f41c667053'),
            ('2m/chedar_0885_UV2m.sofa', '786c7649ec875f09151aba2b7effeaea'),
            ('2m/chedar_0886_UV2m.sofa', 'fb3103f1898da305c116a7b5588f3851'),
            ('2m/chedar_0887_UV2m.sofa', '02950b4b706074cccd8d504cafa65776'),
            ('2m/chedar_0888_UV2m.sofa', 'f7bfc1623c407f4039e18bbf1dd49b8e'),
            ('2m/chedar_0889_UV2m.sofa', 'e7daca879e2ec163f01a3b3039cf5f11'),
            ('2m/chedar_0890_UV2m.sofa', 'a16dc7537bb241f5a083e0a3b97b9893'),
            ('2m/chedar_0891_UV2m.sofa', '2bbc1e78690c81ea68b96945571e5ea3'),
            ('2m/chedar_0892_UV2m.sofa', '511cb67c7de4317c135bc490c5e3fb2c'),
            ('2m/chedar_0893_UV2m.sofa', 'd2182c2d8ce6137ca55e092c78aff43f'),
            ('2m/chedar_0894_UV2m.sofa', '1c9c557f164c842ad176945b8044f18e'),
            ('2m/chedar_0895_UV2m.sofa', 'f6c3f187e90d5de9a1f03b4787268588'),
            ('2m/chedar_0896_UV2m.sofa', '6e280dcbc595705e4f40105e1add989a'),
            ('2m/chedar_0897_UV2m.sofa', '2d400dc4c20a3c5efdfa40bb87ba5958'),
            ('2m/chedar_0898_UV2m.sofa', 'b7fba45e888606a40795d3f5b33326e0'),
            ('2m/chedar_0899_UV2m.sofa', 'd1dcd35c4ba90e4370cb396f5151fa41'),
            ('2m/chedar_0900_UV2m.sofa', '7a556870eb880a949a61c413b6b73ddd'),
            ('2m/chedar_0901_UV2m.sofa', '7c1370d9f3dcbfa7829037d700ac5f48'),
            ('2m/chedar_0902_UV2m.sofa', '1b9c3e6b4503046594a75ef1e3bf7770'),
            ('2m/chedar_0903_UV2m.sofa', '7c77b10d59adac029e69c0d58aa67008'),
            ('2m/chedar_0904_UV2m.sofa', '0beff87fe038a18e38013a745ba59016'),
            ('2m/chedar_0905_UV2m.sofa', '2518ca279ce2a8b2f0b3afdb3202819c'),
            ('2m/chedar_0906_UV2m.sofa', '989bfcbd5517f9f0d1669185a57d6f0a'),
            ('2m/chedar_0907_UV2m.sofa', 'edfd8f177c33d02e46472e548d35ad20'),
            ('2m/chedar_0908_UV2m.sofa', '115c3d68448333cdaf7f70eebe05e810'),
            ('2m/chedar_0909_UV2m.sofa', 'f48e05e65750b132b8403d1100d28c6b'),
            ('2m/chedar_0910_UV2m.sofa', 'e8387e15f7722ab28c0d377658947469'),
            ('2m/chedar_0911_UV2m.sofa', '080ca217a37423970103158d834566a2'),
            ('2m/chedar_0912_UV2m.sofa', '73e8e1687f65a0cf723566ed50e18728'),
            ('2m/chedar_0913_UV2m.sofa', '636fab3e94089e1b533e0167de5fbe65'),
            ('2m/chedar_0914_UV2m.sofa', 'a3995fe28410d8a0cdb424304e530497'),
            ('2m/chedar_0915_UV2m.sofa', '11d5a974406c0c854300791caee19429'),
            ('2m/chedar_0916_UV2m.sofa', '37b8985a5a7a6418f9c5a25b00ae9121'),
            ('2m/chedar_0917_UV2m.sofa', '560ac72ff3d501504d109bcdac8654a7'),
            ('2m/chedar_0918_UV2m.sofa', '3ed63c30973863823fbdf950037fea1a'),
            ('2m/chedar_0919_UV2m.sofa', '274eb9c1f274fafa33b9fdea3b220da4'),
            ('2m/chedar_0920_UV2m.sofa', '6eb2275554ea44b2b27f5f23ab46397a'),
            ('2m/chedar_0921_UV2m.sofa', '5f3104940cade082a610b418d597a0b8'),
            ('2m/chedar_0922_UV2m.sofa', '8be2f6c86e3f0f1e2ad6d635320133c2'),
            ('2m/chedar_0923_UV2m.sofa', '7e9d7cbab14d0cd94db48db21d5f877f'),
            ('2m/chedar_0924_UV2m.sofa', '42b7b9b4ee29a12895adebd7ca2d91b4'),
            ('2m/chedar_0925_UV2m.sofa', '71cb2a513046acdfe1dd8bd805d7d5ee'),
            ('2m/chedar_0926_UV2m.sofa', 'b19124b238fd4a961fa0ec1526881d8c'),
            ('2m/chedar_0927_UV2m.sofa', 'fd1b25b5b174fa821e8dd0a397200f72'),
            ('2m/chedar_0928_UV2m.sofa', 'a8247d51df962009fd47f79088a5b8d7'),
            ('2m/chedar_0929_UV2m.sofa', 'b80000d63f71acbdf43a84d14e2ee697'),
            ('2m/chedar_0930_UV2m.sofa', '872e0f9ddbd236903b7ba0ff15b576d8'),
            ('2m/chedar_0931_UV2m.sofa', 'b289d800e1fd4511f552577ce65a6ce7'),
            ('2m/chedar_0932_UV2m.sofa', '53763cd06caa5a543482ed10030c0d64'),
            ('2m/chedar_0933_UV2m.sofa', 'd934f5254b08019eede8ee5eba716965'),
            ('2m/chedar_0934_UV2m.sofa', '6991a739b0828a3b0147cd6652607a6d'),
            ('2m/chedar_0935_UV2m.sofa', '403b0388100645b2dfc13dfe0162cb03'),
            ('2m/chedar_0936_UV2m.sofa', '7ea0f314e17384c650efb7fd754ac871'),
            ('2m/chedar_0937_UV2m.sofa', '0c2d48cda87ca9ed47ab69728f63d821'),
            ('2m/chedar_0938_UV2m.sofa', 'bee42d1e94a2f099d2b917c3878f3c10'),
            ('2m/chedar_0939_UV2m.sofa', '45eaffaef89f1a8848b7d28f4a6c57ee'),
            ('2m/chedar_0940_UV2m.sofa', '5f2e93ca6e120a8391488dfdef0a2b52'),
            ('2m/chedar_0941_UV2m.sofa', 'c00c109353fedf972f07e81cf472ffb6'),
            ('2m/chedar_0942_UV2m.sofa', 'eea23b46d7dfe9d337f780d7c022a55f'),
            ('2m/chedar_0943_UV2m.sofa', '6578c4edcfb661aa8ec1add832bf71cd'),
            ('2m/chedar_0944_UV2m.sofa', '8ab96edd4ae69f8bba3649dc56581ce0'),
            ('2m/chedar_0945_UV2m.sofa', '51f1b28466509e469437db8a43f332c9'),
            ('2m/chedar_0946_UV2m.sofa', '69cbb631519ba617f6faddc1ce1adfbf'),
            ('2m/chedar_0947_UV2m.sofa', 'c41107ff10e7a8ebd713fb0d574ca204'),
            ('2m/chedar_0948_UV2m.sofa', '6425b7006ed343c3b4270bb92db5f9ec'),
            ('2m/chedar_0949_UV2m.sofa', 'c6046843219fec7bf8e447f2919f4b9d'),
            ('2m/chedar_0950_UV2m.sofa', 'b908ca080fb47af6cb37c418d8017160'),
            ('2m/chedar_0951_UV2m.sofa', '8d8811c1e6b63281da03df6c2ea72431'),
            ('2m/chedar_0952_UV2m.sofa', 'c32ea7b059abd39916b0ee275652c977'),
            ('2m/chedar_0953_UV2m.sofa', '5a7ca30aafe77c4af496214843939b63'),
            ('2m/chedar_0954_UV2m.sofa', '3bc51877bd5ad0793a6b9790398b325f'),
            ('2m/chedar_0955_UV2m.sofa', 'a037f3d0d58b173ed8c92d03c3b42048'),
            ('2m/chedar_0956_UV2m.sofa', 'd5daba80665df72ea2e46525ecee900b'),
            ('2m/chedar_0957_UV2m.sofa', '6eea9bab2ddf6c47b06d61a5d0da38f5'),
            ('2m/chedar_0958_UV2m.sofa', 'b9619b501d82506364ccc88ceda1ba04'),
            ('2m/chedar_0959_UV2m.sofa', 'c878ca2eb10fd7fa88cf5a3902f7ac66'),
            ('2m/chedar_0960_UV2m.sofa', '2e3166585bdcef0c330f0bb4d72c7561'),
            ('2m/chedar_0961_UV2m.sofa', '61fbe3a8c531fda2a0b3449efab596e8'),
            ('2m/chedar_0962_UV2m.sofa', '4e36ce3630d1579b3eb2532002373fe6'),
            ('2m/chedar_0963_UV2m.sofa', 'ffefc2b424577e3338314cc206b645cc'),
            ('2m/chedar_0964_UV2m.sofa', '186c473eebe0fa9eac293ee94af55a77'),
            ('2m/chedar_0965_UV2m.sofa', '55138be525ab54b94a11ce6f7846a7af'),
            ('2m/chedar_0966_UV2m.sofa', '4c903aaef205431a8013e8b98e1a73f3'),
            ('2m/chedar_0967_UV2m.sofa', 'b5ab6762c239e191dc9977166fc91c9e'),
            ('2m/chedar_0968_UV2m.sofa', '000e190a1b466e3eebf63b769f09eaca'),
            ('2m/chedar_0969_UV2m.sofa', '2bce4f453dea910ff91b1529e44b7fae'),
            ('2m/chedar_0970_UV2m.sofa', '6cd5c9881f99a2acac93b878d82215d8'),
            ('2m/chedar_0971_UV2m.sofa', '870778a48f6cced4ced6e649ebd2df33'),
            ('2m/chedar_0972_UV2m.sofa', 'd7e732770be79993b0fe21565d11d413'),
            ('2m/chedar_0973_UV2m.sofa', '8e0b050d26f8f71150fd2db269d4b3fe'),
            ('2m/chedar_0974_UV2m.sofa', '3986f850275fe2ddd2ce2851c15a4007'),
            ('2m/chedar_0975_UV2m.sofa', 'ba779ced2ea6cdfd91c9fbd1acf620f9'),
            ('2m/chedar_0976_UV2m.sofa', 'be38b0e64917d0d1605474614fa89d9c'),
            ('2m/chedar_0977_UV2m.sofa', 'c31d9f041dc236116ad3bacda8852d31'),
            ('2m/chedar_0978_UV2m.sofa', 'cb62a0a2fa1e15d592c0837cd2b51812'),
            ('2m/chedar_0979_UV2m.sofa', '2611030fee679373686bc639a8ac2e30'),
            ('2m/chedar_0980_UV2m.sofa', 'bb85949a89284bc993afea74821aad7d'),
            ('2m/chedar_0981_UV2m.sofa', 'f2ff1c443b476504098d1ecd97ee43af'),
            ('2m/chedar_0982_UV2m.sofa', 'a421b9244e50e8a55abff25e8e137433'),
            ('2m/chedar_0983_UV2m.sofa', 'cf10c2656ff23ef52ca5d6cb18f8894b'),
            ('2m/chedar_0984_UV2m.sofa', '89ad6e98a9861c5376be591aba7aaab2'),
            ('2m/chedar_0985_UV2m.sofa', 'ec14deed983bbdd8d73b56a031b6bf76'),
            ('2m/chedar_0986_UV2m.sofa', '33a3fcaaf4c80c2a132c75454614ae5c'),
            ('2m/chedar_0987_UV2m.sofa', '3cc462977d0ab738a62fccd8c900d612'),
            ('2m/chedar_0988_UV2m.sofa', 'cfc4acda1280c7e72f31a5f78bfdb6d2'),
            ('2m/chedar_0989_UV2m.sofa', '0c1025a620b6207d23d7db4cd3687bfa'),
            ('2m/chedar_0990_UV2m.sofa', '36535bf039cb158293625a9366c77db5'),
            ('2m/chedar_0991_UV2m.sofa', '43144af477ab341437aba8ea11454ce2'),
            ('2m/chedar_0992_UV2m.sofa', '7ddb17b42b9062da9fea51a3f32c262b'),
            ('2m/chedar_0993_UV2m.sofa', 'b080b4fbdf5c1c9920c98cff548d9eec'),
            ('2m/chedar_0994_UV2m.sofa', 'd7d6ead4c4a79dc7d4e365afdd32aca6'),
            ('2m/chedar_0995_UV2m.sofa', '1ad918f5a5a5d3c031afadd7f6314442'),
            ('2m/chedar_0996_UV2m.sofa', '0c55d086b89007ac8258005c987e8240'),
            ('2m/chedar_0997_UV2m.sofa', '1abe4996c6dbb70c1f3b7c35581d91f7'),
            ('2m/chedar_0998_UV2m.sofa', '3a79fd97880c87742e74b73386821d4b'),
            ('2m/chedar_0999_UV2m.sofa', '0dd33b28723b0b17e421348343735c9f'),
            ('2m/chedar_1000_UV2m.sofa', 'c44a1b90b880f0729252dea702838796'),
            ('2m/chedar_1001_UV2m.sofa', '0fe645f5620517bdbd475eb4e6cf6318'),
            ('2m/chedar_1002_UV2m.sofa', '226a72ebcadbdbe6a678582cf414d2f0'),
            ('2m/chedar_1003_UV2m.sofa', 'ced6ff638e1fae9ad693eceefbabdf6d'),
            ('2m/chedar_1004_UV2m.sofa', '3b56c5761df781ac5c58ad7671e69851'),
            ('2m/chedar_1005_UV2m.sofa', 'ac6d71303d60dba03bb770eacccd96f4'),
            ('2m/chedar_1006_UV2m.sofa', 'dd5b9dc6fd794550585c8e939bceba22'),
            ('2m/chedar_1007_UV2m.sofa', 'e3541f908dac19c4d57b374a65a29226'),
            ('2m/chedar_1008_UV2m.sofa', '8222c9de6ea103a6ed740d6caeedac3f'),
            ('2m/chedar_1009_UV2m.sofa', '38026022ac28bebeaed6cd71c22f6d23'),
            ('2m/chedar_1010_UV2m.sofa', '0fc91508fe574d1cc55c6228e1f5d007'),
            ('2m/chedar_1011_UV2m.sofa', '1bcad8255a68409840eeb59c3e911924'),
            ('2m/chedar_1012_UV2m.sofa', '6a8c55b0a0cb275eeea371b4ea33c198'),
            ('2m/chedar_1013_UV2m.sofa', '8f20665c5183820768b208432ab448f9'),
            ('2m/chedar_1014_UV2m.sofa', '33bfddaaef343c27b428b80d804e44c6'),
            ('2m/chedar_1015_UV2m.sofa', 'c89dc8abbc16d51832029e88f313ddd4'),
            ('2m/chedar_1016_UV2m.sofa', '6920f302fae1e3f3e7b019b470d0b7b5'),
            ('2m/chedar_1017_UV2m.sofa', 'd657724fb5a29b360c182a688013288b'),
            ('2m/chedar_1018_UV2m.sofa', '76f05b20def8565dfa4511632ffc7737'),
            ('2m/chedar_1019_UV2m.sofa', '7b4bc47668d015822979f7b708f382ab'),
            ('2m/chedar_1020_UV2m.sofa', '48ede523b4f11c816fb256f2ad4d45e6'),
            ('2m/chedar_1021_UV2m.sofa', '96a38bce30717179b0268260eeb75013'),
            ('2m/chedar_1022_UV2m.sofa', '4d6b1ea94f9733249a2bf0b6fb65c852'),
            ('2m/chedar_1023_UV2m.sofa', '8442da24d3295407cf94e26bf1cffdff'),
            ('2m/chedar_1024_UV2m.sofa', '507ee57a853b9549ba69697516c54d28'),
            ('2m/chedar_1025_UV2m.sofa', '084bab54a3e5b9d2cc24700cb97dab8f'),
            ('2m/chedar_1026_UV2m.sofa', 'f047bbbf65f854350fe24487d4115d81'),
            ('2m/chedar_1027_UV2m.sofa', '9711f0d67f138323697c651c9f0f3656'),
            ('2m/chedar_1028_UV2m.sofa', '8dcdbbb37820cffe1ecdd20551c72513'),
            ('2m/chedar_1029_UV2m.sofa', '88b5659f9444e8ecaf13b2c57fd9b5b7'),
            ('2m/chedar_1030_UV2m.sofa', '6feea9fddec754dbc3fefb66cfaa680a'),
            ('2m/chedar_1031_UV2m.sofa', 'b2938e8cc9e4dd8f93768bab9bb475bc'),
            ('2m/chedar_1032_UV2m.sofa', 'b2f045e5e7c2135ab65e9c465fedf731'),
            ('2m/chedar_1033_UV2m.sofa', 'bf0e543e35434da6b2cbc87bbe90f7f8'),
            ('2m/chedar_1034_UV2m.sofa', 'cfb8b537b968d096a02953076995d802'),
            ('2m/chedar_1035_UV2m.sofa', 'a2d64f0703e7c3779fef5f1be78efa71'),
            ('2m/chedar_1036_UV2m.sofa', '48be2039621ae1476caa37d2d5b7a40e'),
            ('2m/chedar_1037_UV2m.sofa', '7382d7c1dd90cf228f4921b304823591'),
            ('2m/chedar_1038_UV2m.sofa', '0e353e3d6d4e7d3936f2d04d138ca717'),
            ('2m/chedar_1039_UV2m.sofa', 'd0fbe944749a98b4e06192e48cc1d08a'),
            ('2m/chedar_1040_UV2m.sofa', 'f5268fa406b41301cddfdb3b391341da'),
            ('2m/chedar_1041_UV2m.sofa', 'bbbe38ea337f1e803f80f983980230a4'),
            ('2m/chedar_1042_UV2m.sofa', 'b80507530979ac7006aa4daaee73af59'),
            ('2m/chedar_1043_UV2m.sofa', '48d672ea399e1be5195420ee4b289d24'),
            ('2m/chedar_1044_UV2m.sofa', 'f3f0cc660e23440d37ceaa389667f911'),
            ('2m/chedar_1045_UV2m.sofa', '89fbe767fb47ba87328bef5b92526d58'),
            ('2m/chedar_1046_UV2m.sofa', '732c73018a7cff759d77b0950dce1baa'),
            ('2m/chedar_1047_UV2m.sofa', '103108d99ff7f12f51671c30d04a809b'),
            ('2m/chedar_1048_UV2m.sofa', '41c7e41610a217b7925a2652c9589499'),
            ('2m/chedar_1049_UV2m.sofa', 'e70eb5fd0bfba155441fda1416e9e9fd'),
            ('2m/chedar_1050_UV2m.sofa', 'bd38dd70b27d9530e7aedd72f7f54be9'),
            ('2m/chedar_1051_UV2m.sofa', '6883b373f8d08294e23b1ae154e0437f'),
            ('2m/chedar_1052_UV2m.sofa', '926c2c0ce348fec7d88368baced9362f'),
            ('2m/chedar_1053_UV2m.sofa', 'eee49ce6cee4e27e529c556f0d9a7662'),
            ('2m/chedar_1054_UV2m.sofa', 'd30ccb9bfb69c2d30222e7848ccdb02f'),
            ('2m/chedar_1055_UV2m.sofa', 'ca0e3aa8fb187adc637f64e94e9a0fa7'),
            ('2m/chedar_1056_UV2m.sofa', 'a66ac09b87ddc8ed73282c8e253b46fc'),
            ('2m/chedar_1057_UV2m.sofa', 'e727d9120418dd022fe9b32385583747'),
            ('2m/chedar_1058_UV2m.sofa', 'bcd761e890bc50c7bce9699e7ee8ef18'),
            ('2m/chedar_1059_UV2m.sofa', '63bd5308012fa082baeb13e858538d75'),
            ('2m/chedar_1060_UV2m.sofa', '5c461c8f51981757b161d6dfa917ee8f'),
            ('2m/chedar_1061_UV2m.sofa', '8e4376015116b9b0c997885459e7e1e9'),
            ('2m/chedar_1062_UV2m.sofa', '2df1c5d5993a7c620fca1e3517e6286f'),
            ('2m/chedar_1063_UV2m.sofa', '5af36e3b866cbae6aef24541b7cc3662'),
            ('2m/chedar_1064_UV2m.sofa', '1ddd144a4794e5bf14b82d8c528a0106'),
            ('2m/chedar_1065_UV2m.sofa', '9932b152cc929df81248fb85a0752e44'),
            ('2m/chedar_1066_UV2m.sofa', 'b8527cbcd3d218ec8b8bb2ebafd97d78'),
            ('2m/chedar_1067_UV2m.sofa', '9328229d2a2b6ee547238950b7608d01'),
            ('2m/chedar_1068_UV2m.sofa', '6354c79218df16883a4de4fa74f869fa'),
            ('2m/chedar_1069_UV2m.sofa', '23cacd03354577a6464af13d2dcbcbdb'),
            ('2m/chedar_1070_UV2m.sofa', '37a2f39f89076e56ef2dea7909900a71'),
            ('2m/chedar_1071_UV2m.sofa', '74cb9e04c68bac2566ce46c6c7160500'),
            ('2m/chedar_1072_UV2m.sofa', 'e2061f51faa3eab0f445602adeccd78e'),
            ('2m/chedar_1073_UV2m.sofa', '31ec0895f15e43c93b55aee8a0bbee70'),
            ('2m/chedar_1074_UV2m.sofa', '23e8a0557d3fb42dac89e36d030aaa3d'),
            ('2m/chedar_1075_UV2m.sofa', '5699396d141f6a024fff272c7c155a70'),
            ('2m/chedar_1076_UV2m.sofa', '8cca5efe6d5c08ee5f598566b1e74c54'),
            ('2m/chedar_1077_UV2m.sofa', 'f6c770466219a68ceae4632ea07e6fc4'),
            ('2m/chedar_1078_UV2m.sofa', '2ad2a46893bf305ee4a531196c6fd75b'),
            ('2m/chedar_1079_UV2m.sofa', '58bc1b46fd1545ba9267b79ef93b823d'),
            ('2m/chedar_1080_UV2m.sofa', '4d20e17919c507ad293581cf3ee759e5'),
            ('2m/chedar_1081_UV2m.sofa', 'ac44ac0ad7d9b519bc522f726822662b'),
            ('2m/chedar_1082_UV2m.sofa', 'fd370164e085159cce35fe1e6624dd39'),
            ('2m/chedar_1083_UV2m.sofa', '9499908b825164e66a90db710add7cd5'),
            ('2m/chedar_1084_UV2m.sofa', 'c5f8a7570acc01c55f9348b2b587a4cd'),
            ('2m/chedar_1085_UV2m.sofa', '31719d41df502578748fb87b43d5660b'),
            ('2m/chedar_1086_UV2m.sofa', 'a5fa2e4670adb919b8be1ca3f26e1779'),
            ('2m/chedar_1087_UV2m.sofa', '21aa0f5b82ff9a5646c4173dbb609f3e'),
            ('2m/chedar_1088_UV2m.sofa', '3bfb41f5ff48f3eef07abc115aa80b90'),
            ('2m/chedar_1089_UV2m.sofa', 'e1d6e2db6fe9215ec0d81e8bed97972a'),
            ('2m/chedar_1090_UV2m.sofa', 'f4ec283c87881f99d8d6f7bc7caf3f94'),
            ('2m/chedar_1091_UV2m.sofa', '6539d352d6c6e0fa1e83fc935bb070a2'),
            ('2m/chedar_1092_UV2m.sofa', '1d2dcb7abf1ae2f0f4c206639438870e'),
            ('2m/chedar_1093_UV2m.sofa', 'ed44d6406c0b23a3d6bcc5a89d9df32e'),
            ('2m/chedar_1094_UV2m.sofa', '082fc8e873d067eab358895c04e850ec'),
            ('2m/chedar_1095_UV2m.sofa', '8c3da35dd77b5e2a18b1eb0d8eda72b1'),
            ('2m/chedar_1096_UV2m.sofa', 'a6de79767eba806ee620efad506ce843'),
            ('2m/chedar_1097_UV2m.sofa', '1fcfbd191c7e8d1b17757cb52092a92b'),
            ('2m/chedar_1098_UV2m.sofa', '8e93ede6f5c311c8eece27c4a3a0e277'),
            ('2m/chedar_1099_UV2m.sofa', 'd9462c4fef494d7756ab3ece88798d05'),
            ('2m/chedar_1100_UV2m.sofa', 'f9af8071f74bf30d654dbb1730d6909a'),
            ('2m/chedar_1101_UV2m.sofa', '4c2f02ce5d2278ed54662ae01701893e'),
            ('2m/chedar_1102_UV2m.sofa', 'f3da3be72b762e7fc6ae3f45e93321a2'),
            ('2m/chedar_1103_UV2m.sofa', '08778c54883e4c6ea12038eca053bea7'),
            ('2m/chedar_1104_UV2m.sofa', 'bb37632ec074fc231e30d19e4a7fc9f8'),
            ('2m/chedar_1105_UV2m.sofa', 'd9bb3c1b8bb6a817baa275ff2debcc36'),
            ('2m/chedar_1106_UV2m.sofa', 'e90bb05d33c91cf3fa128f782dff73aa'),
            ('2m/chedar_1107_UV2m.sofa', 'a1ff9f058d1568ea030c97ade722abfb'),
            ('2m/chedar_1108_UV2m.sofa', '1bbe2868103e7eff7157c97de195bb77'),
            ('2m/chedar_1109_UV2m.sofa', '84ff036ade3925bd0d9bc08e3ae0e00a'),
            ('2m/chedar_1110_UV2m.sofa', 'b516218886b7f3050bb47504805c36f6'),
            ('2m/chedar_1111_UV2m.sofa', '8b376c6d39a08fbeee034b414dfd1b88'),
            ('2m/chedar_1112_UV2m.sofa', '5321be26ab9b57dade4d1545d8b12f98'),
            ('2m/chedar_1113_UV2m.sofa', 'b62a4153e0cc382a96a00b778e62c416'),
            ('2m/chedar_1114_UV2m.sofa', 'b03fff86f2c82c0ad06612036d4d1d90'),
            ('2m/chedar_1115_UV2m.sofa', 'bac0d797d1d756e41bbb989a5c1b61e7'),
            ('2m/chedar_1116_UV2m.sofa', 'fa0f84884648c0d0f0344b0150bf357a'),
            ('2m/chedar_1117_UV2m.sofa', 'd87f1f8d16b637a207d1d46838316ca1'),
            ('2m/chedar_1118_UV2m.sofa', 'e09f05c12ab92c68aaca045d0876398e'),
            ('2m/chedar_1119_UV2m.sofa', '1e1c882d9a3cfb6ddaab8674435628e1'),
            ('2m/chedar_1120_UV2m.sofa', '8739318136ad1f117b6271df19f5bf7f'),
            ('2m/chedar_1121_UV2m.sofa', '91310c29d5c4ee613b50e6f695915dbb'),
            ('2m/chedar_1122_UV2m.sofa', '5ca011fcdb4f06dcbc1030b3c997b73b'),
            ('2m/chedar_1123_UV2m.sofa', 'bc3b066d422fb0d8ac3b7fefccd8c84d'),
            ('2m/chedar_1124_UV2m.sofa', '7b4123722191c138895adfa96b75159e'),
            ('2m/chedar_1125_UV2m.sofa', 'a45d87c5dcffcab763b6d2d57a87cd80'),
            ('2m/chedar_1126_UV2m.sofa', '42f59cd92957f799cdb87b1aec702760'),
            ('2m/chedar_1127_UV2m.sofa', 'be0b030c909a2f08a64a55c7c15aca49'),
            ('2m/chedar_1128_UV2m.sofa', '8f18dc27ee63467cbb0aa076db611352'),
            ('2m/chedar_1129_UV2m.sofa', 'd4b3796b4bc58c7042109166763cf74b'),
            ('2m/chedar_1130_UV2m.sofa', 'dd1c5950245666905f43c40074d32b42'),
            ('2m/chedar_1131_UV2m.sofa', 'bda3f420a844dc1c39191d7ff43c306d'),
            ('2m/chedar_1132_UV2m.sofa', 'd1e7eb49d593330d05147032c1f61d97'),
            ('2m/chedar_1133_UV2m.sofa', '8538265056c2cbde67937ed01542cbc9'),
            ('2m/chedar_1134_UV2m.sofa', '6bb3774151525187cf7b3b02cc3012af'),
            ('2m/chedar_1135_UV2m.sofa', '3e4797a8d5f4ec9330ffe8a75cb83879'),
            ('2m/chedar_1136_UV2m.sofa', '60dbe0fbb63bb896830e31f7d365f2ee'),
            ('2m/chedar_1137_UV2m.sofa', '791e7b283f27e02135e0f75d286cb484'),
            ('2m/chedar_1138_UV2m.sofa', '9006af51d2b9c33b4249f6fc2fa74e41'),
            ('2m/chedar_1139_UV2m.sofa', '32cfa5b58a3799d8223e3d1fe6ef6de4'),
            ('2m/chedar_1140_UV2m.sofa', 'fc0c0779a512c1fd7bd2cf9596a13cb5'),
            ('2m/chedar_1141_UV2m.sofa', '6a4787eefb29f9088658d707e8920d16'),
            ('2m/chedar_1142_UV2m.sofa', '3d0df20b43580e142733dcff17ddf2b9'),
            ('2m/chedar_1143_UV2m.sofa', 'ab842cc4f40166fa0ec005af7e9c3aba'),
            ('2m/chedar_1144_UV2m.sofa', 'a6bf295149511b5efa1e2591592198c6'),
            ('2m/chedar_1145_UV2m.sofa', 'da7b11ad853c67cd29fbf82d230a920c'),
            ('2m/chedar_1146_UV2m.sofa', 'e477f7c6b9da76f4b10911fb9620c554'),
            ('2m/chedar_1147_UV2m.sofa', '305effa40182ea7df854aaebb25eb7ef'),
            ('2m/chedar_1148_UV2m.sofa', 'd75fc611e80c3804d052ecf0a4c4da94'),
            ('2m/chedar_1149_UV2m.sofa', '6e87bd11c473a1090b90321511d5020e'),
            ('2m/chedar_1150_UV2m.sofa', '6afc392305960b52a68bfea25df434da'),
            ('2m/chedar_1151_UV2m.sofa', 'fe82aa66e8366f5da0344af5d0c17a92'),
            ('2m/chedar_1152_UV2m.sofa', '7f6d94c066df79b73eb07d2ea41ba237'),
            ('2m/chedar_1153_UV2m.sofa', '964535ffd5102a884464aee932576531'),
            ('2m/chedar_1154_UV2m.sofa', 'c98a79e60d1c71e63d1abd1886823600'),
            ('2m/chedar_1155_UV2m.sofa', 'fc5a1912e3f368d0cd0664bd53f80018'),
            ('2m/chedar_1156_UV2m.sofa', '6aa3c57a77b34b880babc3dc0818fa99'),
            ('2m/chedar_1157_UV2m.sofa', '32065c141a664147f454397d638658da'),
            ('2m/chedar_1158_UV2m.sofa', '6ed0b5d648b31eba13a71bc55b52c58b'),
            ('2m/chedar_1159_UV2m.sofa', '1d83ff8e000bff15edc86153900cb071'),
            ('2m/chedar_1160_UV2m.sofa', '0686bfdb8ccaba0f07da70ac94b59acb'),
            ('2m/chedar_1161_UV2m.sofa', '50da6661e86443b4a674d86a4d19391b'),
            ('2m/chedar_1162_UV2m.sofa', '203b55e8ab00032dadf8942c90ae76b1'),
            ('2m/chedar_1163_UV2m.sofa', '05120ba91ad555fa65939b18ec44640d'),
            ('2m/chedar_1164_UV2m.sofa', '8558b59b7d388710ac0c137d83d4bcbe'),
            ('2m/chedar_1165_UV2m.sofa', '35d1713d344f2515582c2ded9214f2ef'),
            ('2m/chedar_1166_UV2m.sofa', 'e77dd617e317d9f205f4344458f47275'),
            ('2m/chedar_1167_UV2m.sofa', '6e7d5d4c28b6c0cc734d9aaaba44b868'),
            ('2m/chedar_1168_UV2m.sofa', 'c2db29d0a9b346ff9cbee768e84388b9'),
            ('2m/chedar_1169_UV2m.sofa', 'b40ed02933239e0118a1f3143c793596'),
            ('2m/chedar_1170_UV2m.sofa', '4c436ed43fc875122703e8a7e2d4f8c4'),
            ('2m/chedar_1171_UV2m.sofa', '785c32e7fb520990a421d2291ec7594b'),
            ('2m/chedar_1172_UV2m.sofa', '15d648143d82e8e3f5f92ccb679306a2'),
            ('2m/chedar_1173_UV2m.sofa', 'f61a11c1b06905d923d618a6808769cf'),
            ('2m/chedar_1174_UV2m.sofa', '34541886d0445f39b78ac538e3adb2dd'),
            ('2m/chedar_1175_UV2m.sofa', 'cedbc53d7d70a3c853fc2b0b55c39f8f'),
            ('2m/chedar_1176_UV2m.sofa', '7138c3c19beb68772c8ccae988b0a97a'),
            ('2m/chedar_1177_UV2m.sofa', 'c15e11428dba9b06f1a833112a3e047d'),
            ('2m/chedar_1178_UV2m.sofa', '0db3f8906e857d4188c9d3c5c2710418'),
            ('2m/chedar_1179_UV2m.sofa', 'ac68cf0a5844937640d59975c17c73ed'),
            ('2m/chedar_1180_UV2m.sofa', 'e0f290304999165b6beaa8a6f2ff88b0'),
            ('2m/chedar_1181_UV2m.sofa', '151a9dc7fb48211fa7a2794ba0b980a2'),
            ('2m/chedar_1182_UV2m.sofa', '3f37ce96bdf80812070f9175a1e526f5'),
            ('2m/chedar_1183_UV2m.sofa', '1f3aa01e0bed5a201dbef9ba1eb00d5b'),
            ('2m/chedar_1184_UV2m.sofa', 'ab13847c79b070697288c037f8eb0002'),
            ('2m/chedar_1185_UV2m.sofa', '4ef594e6dbb3dc0a0ad4ee0b40a80240'),
            ('2m/chedar_1186_UV2m.sofa', '26f00863141c0186d7401ddf39a52544'),
            ('2m/chedar_1187_UV2m.sofa', '7c897f35b6b5975d57c97d97c7c6b0e3'),
            ('2m/chedar_1188_UV2m.sofa', '7007692f0e83e65c580d0ef3da530523'),
            ('2m/chedar_1189_UV2m.sofa', 'c1694ef375302d4a2e55f0e62e54d42c'),
            ('2m/chedar_1190_UV2m.sofa', 'd0e0d71c9e2c6969b4b2612b73949177'),
            ('2m/chedar_1191_UV2m.sofa', '37c0ecdee8208005cc5abb826433c65c'),
            ('2m/chedar_1192_UV2m.sofa', '6c832e849e655bbccc089a0d899d5f7d'),
            ('2m/chedar_1193_UV2m.sofa', '01a54e4d6d123842d750ed1bb6e4f1d1'),
            ('2m/chedar_1194_UV2m.sofa', '22e1b07044ed8ca363a434c8f83a7853'),
            ('2m/chedar_1195_UV2m.sofa', 'ba96a666be218615d41121a55e9dfb33'),
            ('2m/chedar_1196_UV2m.sofa', '4871f2d69d4c2a42a04073433ccd0395'),
            ('2m/chedar_1197_UV2m.sofa', '48c6088cf934b53435ec668c210f6826'),
            ('2m/chedar_1198_UV2m.sofa', '6cae6ae2d7ae22e70968a86fe714b713'),
            ('2m/chedar_1199_UV2m.sofa', 'da287c6fe948473aaa3dfb8aadb31854'),
            ('2m/chedar_1200_UV2m.sofa', 'b221a22586722bbd1cf160fa5b286206'),
            ('2m/chedar_1201_UV2m.sofa', '556e3d72d1f5eb1226d6fdc56d76a7a0'),
            ('2m/chedar_1202_UV2m.sofa', '1f5821b9bd243e6442a3a1f9354efcbf'),
            ('2m/chedar_1203_UV2m.sofa', '6f01a958dabad3c68812f681d1c70b91'),
            ('2m/chedar_1204_UV2m.sofa', '7f3401c5b2e1a048e7fa7740b71a1b0a'),
            ('2m/chedar_1205_UV2m.sofa', '55a6853cb3604910fcc0b9f397f4e33c'),
            ('2m/chedar_1206_UV2m.sofa', '34e5e821fa2bb69a18905e3c8ba4c970'),
            ('2m/chedar_1207_UV2m.sofa', '8b0b870d078423a212b18172561bb416'),
            ('2m/chedar_1208_UV2m.sofa', '2daeb290b0f15883fd01c7361c6e17cb'),
            ('2m/chedar_1209_UV2m.sofa', '96f7af28715d5a66d19aba404a1eba8f'),
            ('2m/chedar_1210_UV2m.sofa', '583c38cc6cc8202176ba756f0e480ca0'),
            ('2m/chedar_1211_UV2m.sofa', '72c023895d165b584776f788678b0efd'),
            ('2m/chedar_1212_UV2m.sofa', '8844914334337638d7120286c3b069f3'),
            ('2m/chedar_1213_UV2m.sofa', '95a7bc5d22d6e0b7152810b3dbc9f14c'),
            ('2m/chedar_1214_UV2m.sofa', '3e4dfbde8f9acbc478800db10100b8e5'),
            ('2m/chedar_1215_UV2m.sofa', '289d9fdac4a5a544d38d0aea0edbd874'),
            ('2m/chedar_1216_UV2m.sofa', 'd07849da32969a2047543589beb768ac'),
            ('2m/chedar_1217_UV2m.sofa', '2fd7fbe6d2fc9e9be890098fc0d73492'),
            ('2m/chedar_1218_UV2m.sofa', '6bbc33f399ae93a7d2b11d9adbff7b80'),
            ('2m/chedar_1219_UV2m.sofa', '438eeccca295de92a46559b196006bda'),
            ('2m/chedar_1220_UV2m.sofa', '2d32ef79d6eb6b9a2fa9e3e4cac571d4'),
            ('2m/chedar_1221_UV2m.sofa', '9934a52f01bb113f888af66be08708fe'),
            ('2m/chedar_1222_UV2m.sofa', '203c92d12f97ef17a20b38cd6971336a'),
            ('2m/chedar_1223_UV2m.sofa', 'a5e715d3ce74ebb81d1b4c4a5afdd3ca'),
            ('2m/chedar_1224_UV2m.sofa', 'a96dc1a90bd2e207c7331d8207be4232'),
            ('2m/chedar_1225_UV2m.sofa', '06477111844ece9d6b717532c8a6173b'),
            ('2m/chedar_1226_UV2m.sofa', '75ca7ad6bf99b32ecbaa6025e76d4c3f'),
            ('2m/chedar_1227_UV2m.sofa', 'd6d24f27f36948b53305c46b46eef9a0'),
            ('2m/chedar_1228_UV2m.sofa', '561c5e7bd63027c6c5e0295885a6be13'),
            ('2m/chedar_1229_UV2m.sofa', '9d19ab5eac838d9c86094c7c142119dd'),
            ('2m/chedar_1230_UV2m.sofa', '777ae0df6b91403d36ee1e59f661f9d5'),
            ('2m/chedar_1231_UV2m.sofa', '0c367041b70a6d83aa0f4c86c201a6f3'),
            ('2m/chedar_1232_UV2m.sofa', '8baff8b3831bc3ad84ec6c98a306fed4'),
            ('2m/chedar_1233_UV2m.sofa', 'ab49a3a5449ab70b199f3e5817a532df'),
            ('2m/chedar_1234_UV2m.sofa', '53489dc7c3743a9eb073ccf250c6f20e'),
            ('2m/chedar_1235_UV2m.sofa', '3fd319a4d7806f937a6a71b92360ef31'),
            ('2m/chedar_1236_UV2m.sofa', '362693d51d4b4e31fae26f7cd75290d2'),
            ('2m/chedar_1237_UV2m.sofa', '4f12c203b38f29e2d19ede347990d0b5'),
            ('2m/chedar_1238_UV2m.sofa', 'd60280833aec3b03c061a15f89c40980'),
            ('2m/chedar_1239_UV2m.sofa', 'b95f7dfe79040c96e15bbbc94765c9e7'),
            ('2m/chedar_1240_UV2m.sofa', 'a445064f6a5d5a916e6c672ba53c8844'),
            ('2m/chedar_1241_UV2m.sofa', 'b974a6cca67924141cf4b13f65307b9e'),
            ('2m/chedar_1242_UV2m.sofa', '5382ac8ba888ae60baa9465373dee186'),
            ('2m/chedar_1243_UV2m.sofa', 'b1a0d47af83dfe48dc26de3d935443e1'),
            ('2m/chedar_1244_UV2m.sofa', '7fbbab45cb7245323f2f60c3cec60bf3'),
            ('2m/chedar_1245_UV2m.sofa', 'ac5a813fd74da7a7c5babecd3ac40184'),
            ('2m/chedar_1246_UV2m.sofa', '1ca13813cb58f0f7f6c3dbb6bd3a7e44'),
            ('2m/chedar_1247_UV2m.sofa', 'a78d8d805a593923ce53c9d320ddc61e'),
            ('2m/chedar_1248_UV2m.sofa', '8447ba3018a277797a9df75e54a099d3'),
            ('2m/chedar_1249_UV2m.sofa', '819a71505b76215a6595d3fc406abecc'),
            ('2m/chedar_1250_UV2m.sofa', '488c3a57ea04c9a8e8c98cb1eee0f313'),
            ('2m/chedar_1251_UV2m.sofa', '2b775164277d956b890f6c046f96e8c3'),
            ('2m/chedar_1252_UV2m.sofa', '46028c62ec492e0dd9c944ef94f64950'),
            ('2m/chedar_1253_UV2m.sofa', '95e270e6bfb0439ee8370d24bd003233'),
        ],
    },
    'widespread': {
        'UV-02m': [
            ('UV/02m/UV02m_00001.sofa', 'a8e4a9cf667dce6ea9d20b62132527b8'),
            ('UV/02m/UV02m_00002.sofa', '5f5b7719481c8d92e3fada47fa889116'),
            ('UV/02m/UV02m_00003.sofa', '4b44cedc56d874f8079a87aa0b2db4ec'),
            ('UV/02m/UV02m_00004.sofa', '671b170512f3db1313d4362ae0cb64f2'),
            ('UV/02m/UV02m_00005.sofa', '2320af5e318d501b95a64e5c05e727aa'),
            ('UV/02m/UV02m_00007.sofa', '5e0ba2e50fff799d73104f43ea8e9b41'),
            ('UV/02m/UV02m_00009.sofa', '8d7c2338f2295105a121b90fffde4966'),
            ('UV/02m/UV02m_00010.sofa', '1e0beb5354a2962991c14fa7e98a5db3'),
            ('UV/02m/UV02m_00011.sofa', 'fba1d82a00040357f74693e574f6ce7c'),
            ('UV/02m/UV02m_00013.sofa', 'f21dd2d62cea6836ad767b344f8e98bd'),
            ('UV/02m/UV02m_00014.sofa', '555ba06c3ea3b335f7615fa8b5059d72'),
            ('UV/02m/UV02m_00015.sofa', 'f159164467fb5a9295b6e6b61c90e4a5'),
            ('UV/02m/UV02m_00016.sofa', 'b553e45eab152de0517608a76bb62909'),
            ('UV/02m/UV02m_00020.sofa', '24539d224d8d0283a152418b39ee4c4c'),
            ('UV/02m/UV02m_00021.sofa', '89ac1d7cc729b4c465319adaffd74cff'),
            ('UV/02m/UV02m_00022.sofa', 'e6c83220678a39fe46ab35555c1cffe4'),
            ('UV/02m/UV02m_00023.sofa', 'd4869fcfe7181f0dfb17ee313eeb8dc1'),
            ('UV/02m/UV02m_00024.sofa', 'ec66acd0bdae3fda9de5a2f3f7f29a59'),
            ('UV/02m/UV02m_00025.sofa', '157088aa210cb85724298c965f247770'),
            ('UV/02m/UV02m_00026.sofa', '6da6b92a15a652a63460fc7aaca0f9ed'),
            ('UV/02m/UV02m_00027.sofa', 'ce60fd3ff39ca365e515449cfd047607'),
            ('UV/02m/UV02m_00029.sofa', 'a991416a726bfe160e1ec36fe96c5c01'),
            ('UV/02m/UV02m_00030.sofa', '4a4e2a64b010f29ed4dc052b2f551471'),
            ('UV/02m/UV02m_00031.sofa', '020691fec4a0ae33ae4bc0ab885b3d73'),
            ('UV/02m/UV02m_00032.sofa', '33a562e9e9ea4b8c3d0680065c69efbf'),
            ('UV/02m/UV02m_00033.sofa', '5df3ad288e42fcf4e59b570aa6d136f7'),
            ('UV/02m/UV02m_00036.sofa', '8f8adf23f1139428bec50fb1fc6d550f'),
            ('UV/02m/UV02m_00038.sofa', '748884c9a4968d23c7d8dcb19a684c09'),
            ('UV/02m/UV02m_00039.sofa', '527198dd56d8867395ad9fed1198fb6c'),
            ('UV/02m/UV02m_00042.sofa', '786cf148cc77126da25010b75e7e2fb5'),
            ('UV/02m/UV02m_00043.sofa', '4053ae5ba4eb1cdad19088d5a54deb22'),
            ('UV/02m/UV02m_00044.sofa', '45a8a824f6f0d656978cd2b2ae4ca7b2'),
            ('UV/02m/UV02m_00045.sofa', '7cb68e12a56cdb16557e81b6e3c5715a'),
            ('UV/02m/UV02m_00048.sofa', 'ff04b3f8ed80953128ecd8c60e18a37d'),
            ('UV/02m/UV02m_00049.sofa', '3e3c5e25dd64b2e713b363b403eedf66'),
            ('UV/02m/UV02m_00054.sofa', 'e119460640175efa5177e82e201a34a0'),
            ('UV/02m/UV02m_00056.sofa', '26cf4c037cf0421334c3c11d35f0b44b'),
            ('UV/02m/UV02m_00057.sofa', 'ce3331d5cee8fe97e36f8874147e8b05'),
            ('UV/02m/UV02m_00058.sofa', '7a8cd03a91967f451bda08211c4b1c51'),
            ('UV/02m/UV02m_00059.sofa', '5f0dc584675f418b0cdfd0b4f10488a1'),
            ('UV/02m/UV02m_00061.sofa', '5cba41e5d78a89de5f1866c150247c70'),
            ('UV/02m/UV02m_00062.sofa', '1e4a8faf3051ba3db243749af38fc120'),
            ('UV/02m/UV02m_00063.sofa', 'f817ff655f606de79bb3722a1b7e81b7'),
            ('UV/02m/UV02m_00064.sofa', 'baa253e5461cd7705f60a30e957e9063'),
            ('UV/02m/UV02m_00065.sofa', '88a5fbac512541d02276392107c7454c'),
            ('UV/02m/UV02m_00068.sofa', '8758dc059655d643f5a26d3fc221bf8f'),
            ('UV/02m/UV02m_00069.sofa', 'd1bc2fc3950ccd001bbb9416715a6096'),
            ('UV/02m/UV02m_00071.sofa', '6ce8c0229991103e71c45644bcca5372'),
            ('UV/02m/UV02m_00072.sofa', '0e7efa12aa2f85a0275e3abafabb371d'),
            ('UV/02m/UV02m_00074.sofa', 'ebb727c854a74f3dbc7dbefcfdfae2d5'),
            ('UV/02m/UV02m_00076.sofa', '015434aeb5003d1b1203d65077829c13'),
            ('UV/02m/UV02m_00078.sofa', '86dd3553db6b0522a42cc1007a525157'),
            ('UV/02m/UV02m_00079.sofa', '91bd3e1f786aa501aefbeb745765af98'),
            ('UV/02m/UV02m_00082.sofa', '954eb72d2677db5b91be5496e2d1f9f1'),
            ('UV/02m/UV02m_00083.sofa', 'fdb577b54e1de6388f31e8ce4278d58e'),
            ('UV/02m/UV02m_00085.sofa', '185980aece8a7e9fb8a4e31550e03b1c'),
            ('UV/02m/UV02m_00086.sofa', '0ba72ecbddcfc23788a25ccc45024941'),
            ('UV/02m/UV02m_00087.sofa', '972cda0e7d4a993d8f538917d4e0bc0a'),
            ('UV/02m/UV02m_00089.sofa', 'aeb3e82e0c01cc515be905af1d5209f1'),
            ('UV/02m/UV02m_00090.sofa', '97d9fdd3da56905984c5dd4219b1cb0b'),
            ('UV/02m/UV02m_00092.sofa', '34b17feb16d5693321b19eee006d02a1'),
            ('UV/02m/UV02m_00095.sofa', '08b9f5a90eadc58f75d6cbdbb2abd035'),
            ('UV/02m/UV02m_00097.sofa', '578efff0add48266423e2978fec6f08a'),
            ('UV/02m/UV02m_00099.sofa', '632695e1e1e2ce4712f1e79474c59b05'),
            ('UV/02m/UV02m_00100.sofa', '90127911ffcf1b6009a9185284eab245'),
            ('UV/02m/UV02m_00101.sofa', 'de9b84a242df1d9820649151e4ee4771'),
            ('UV/02m/UV02m_00103.sofa', '6e775f4a471e021683d27b9c997df322'),
            ('UV/02m/UV02m_00104.sofa', '9373c0d8a29a1829a2184a21dd6de582'),
            ('UV/02m/UV02m_00107.sofa', 'ecffdfda48ba5c2c7c049d25b81d1992'),
            ('UV/02m/UV02m_00108.sofa', 'bd9dc2539a0c3c15ac9e4a481803244e'),
            ('UV/02m/UV02m_00109.sofa', 'ae73eb9fc7a1ce291abf608cd2ee66e9'),
            ('UV/02m/UV02m_00110.sofa', '5b2822de94852543e7e90e48a0795ed4'),
            ('UV/02m/UV02m_00111.sofa', '39d3316026fe59f7e0f35e9f41e30b68'),
            ('UV/02m/UV02m_00112.sofa', '437f5e323897166394ac7f030e059953'),
            ('UV/02m/UV02m_00113.sofa', '3622fed47f523029885eb0b7e7d73202'),
            ('UV/02m/UV02m_00114.sofa', '1bf6d2088e50f5278e696117633964b8'),
            ('UV/02m/UV02m_00118.sofa', 'a9b748f6ab2262e0bef5d35c7ed99388'),
            ('UV/02m/UV02m_00119.sofa', '990a454eb2ef22c4ede1cd76bb255684'),
            ('UV/02m/UV02m_00120.sofa', '2fc5f20849da8de66febc36564f77b84'),
            ('UV/02m/UV02m_00121.sofa', '3933e7046bb283839380640b8a792777'),
            ('UV/02m/UV02m_00125.sofa', 'c312571344218d0482a373614770ae4f'),
            ('UV/02m/UV02m_00126.sofa', '6832ca186574db7b2c65966fe746010e'),
            ('UV/02m/UV02m_00127.sofa', 'ac5e262820e2b6228386d995fb960a00'),
            ('UV/02m/UV02m_00128.sofa', '85b34640484f5a2b4f852bd5706843ef'),
            ('UV/02m/UV02m_00130.sofa', 'eafe22ee4794ccef8497cd3dbb330a63'),
            ('UV/02m/UV02m_00131.sofa', '4e1aae61e6f36e7cd229e50ff70cdd79'),
            ('UV/02m/UV02m_00132.sofa', '4610f6ecf4479f39586fd17c58d165fc'),
            ('UV/02m/UV02m_00133.sofa', 'e0bfbefcc42f4d7cb5a9d73fea9bcd76'),
            ('UV/02m/UV02m_00136.sofa', '22f4a54b0485527a5fd2028c4a7ade79'),
            ('UV/02m/UV02m_00137.sofa', '57bd7bc6d019f27b1101a2d57f1b1dd7'),
            ('UV/02m/UV02m_00139.sofa', 'ffd76be69c308b3eda9f64a621637cca'),
            ('UV/02m/UV02m_00140.sofa', 'eaa44960e723973a9be78caadf82fc18'),
            ('UV/02m/UV02m_00142.sofa', 'fc5362a58fd65b60464c6e7de61d863f'),
            ('UV/02m/UV02m_00145.sofa', '637599fb7785fc308c0a7cf51044b839'),
            ('UV/02m/UV02m_00146.sofa', '57a53af14203692920ca6282e358b77f'),
            ('UV/02m/UV02m_00147.sofa', 'e31074b8ec70139feeee0eeaf9d1e844'),
            ('UV/02m/UV02m_00148.sofa', '05ececf1ba179a12fbac3367739c69ec'),
            ('UV/02m/UV02m_00149.sofa', '365fddb744e6f01e14e9b8f01907132c'),
            ('UV/02m/UV02m_00150.sofa', '8afadd1a393c763ae44b2b654cb85138'),
            ('UV/02m/UV02m_00152.sofa', 'ba2311de63494317b2a82bc98516cece'),
            ('UV/02m/UV02m_00153.sofa', '5bd14e5ed1c7cbca56d8fa6275372079'),
            ('UV/02m/UV02m_00154.sofa', 'e56919da5d6369f8a096d12ce34938c6'),
            ('UV/02m/UV02m_00155.sofa', 'fc68e6c3b5d1b3180ede743735a5a777'),
            ('UV/02m/UV02m_00156.sofa', 'ca04d2a288b36e22ab1134e3b29164c8'),
            ('UV/02m/UV02m_00157.sofa', '8600891c33f59b332ac0bb24266834f1'),
            ('UV/02m/UV02m_00158.sofa', '3638599dc185015646755821b7903330'),
            ('UV/02m/UV02m_00159.sofa', '62dc29abaa603ad9a10819efb7f7e7d7'),
            ('UV/02m/UV02m_00161.sofa', '0adcd394931b9a8fa8069e09580fd07a'),
            ('UV/02m/UV02m_00164.sofa', '591205455be9b6bbaacf73a8253fd712'),
            ('UV/02m/UV02m_00165.sofa', '9978fc040d6bfbca6f856902f5dc8786'),
            ('UV/02m/UV02m_00166.sofa', 'e7fbbf16abbe45d90644da6a395bd059'),
            ('UV/02m/UV02m_00168.sofa', 'e6f8c39e89a44eb6e258bd360af56aee'),
            ('UV/02m/UV02m_00169.sofa', 'fe23718687b34877c1648499753f743c'),
            ('UV/02m/UV02m_00170.sofa', 'b89cdfa8d6202defdd51bbc84fb5d628'),
            ('UV/02m/UV02m_00171.sofa', '28ac5551bfae9a0589e875fb43659997'),
            ('UV/02m/UV02m_00173.sofa', '968587b7a8a5b76abd77faf1ca663e8d'),
            ('UV/02m/UV02m_00175.sofa', 'aa4504055552a8e953ff97c65318e40d'),
            ('UV/02m/UV02m_00176.sofa', 'd4b8776ddd84d5912bcd3fdedf8bbf0e'),
            ('UV/02m/UV02m_00177.sofa', '88f414262046ac7a2b178b6123575618'),
            ('UV/02m/UV02m_00178.sofa', '2c211b5ce4c49bf0fdf9dc8c0c26f8dc'),
            ('UV/02m/UV02m_00179.sofa', '8889aa167306e4725ed5581118de4410'),
            ('UV/02m/UV02m_00183.sofa', '01867c62122843b6b802cdd1992143ce'),
            ('UV/02m/UV02m_00184.sofa', '21f8b7e9b41514997f41477cdd77a6b8'),
            ('UV/02m/UV02m_00185.sofa', 'e5b5b81e1d1dc9e2ab1b1756a858eb63'),
            ('UV/02m/UV02m_00186.sofa', 'fc1efdc6362717295ba499f9b4f1189a'),
            ('UV/02m/UV02m_00188.sofa', '683519f51ffe788226670e92167bf72e'),
            ('UV/02m/UV02m_00189.sofa', 'b4d404dd70c01daba607a5728bf35924'),
            ('UV/02m/UV02m_00190.sofa', 'fe6ff5dec0112a70349b8b809431fd49'),
            ('UV/02m/UV02m_00191.sofa', 'ae04642ac25a91557d6dfad22b9f3445'),
            ('UV/02m/UV02m_00194.sofa', 'a9fd22be469ee6bd995897ff08d47211'),
            ('UV/02m/UV02m_00195.sofa', '2d48cd42f5ade681403497267fdd0074'),
            ('UV/02m/UV02m_00196.sofa', 'cb67711dd641ea9173e6b6d48f9d7e93'),
            ('UV/02m/UV02m_00197.sofa', '26ab8b7fdad633bcb26ae8d3684f9425'),
            ('UV/02m/UV02m_00198.sofa', 'dd902a4f797f7d06125697dcb4fbd3ba'),
            ('UV/02m/UV02m_00201.sofa', '31b94ab325ca873e25a49e4edd2c037d'),
            ('UV/02m/UV02m_00203.sofa', 'ea39680540434569edaaaed2c99ddd92'),
            ('UV/02m/UV02m_00204.sofa', '35e5b38d3ad085e88853c52df6d1a6b2'),
            ('UV/02m/UV02m_00205.sofa', '744188e8806452fccf152f795f069669'),
            ('UV/02m/UV02m_00206.sofa', '4eaaafc2b6e976e4c717b88d99fd4eeb'),
            ('UV/02m/UV02m_00209.sofa', '371fbb049bfec3d9390466661cabf41c'),
            ('UV/02m/UV02m_00210.sofa', 'e3fcbcab35a8b2a6c2101e86528d9237'),
            ('UV/02m/UV02m_00211.sofa', 'a7a261d64833c2793d01aac40eea1875'),
            ('UV/02m/UV02m_00212.sofa', '0fc40822101a22129e6be62242b5b2eb'),
            ('UV/02m/UV02m_00213.sofa', '68f30a272aae5750fa49ddb0de597169'),
            ('UV/02m/UV02m_00214.sofa', 'fe0ced2a4856dc38ae1e58af4f0fcfe9'),
            ('UV/02m/UV02m_00215.sofa', '54f1d2a1f56e737d03b880b7464a9283'),
            ('UV/02m/UV02m_00216.sofa', 'cd07cbe70f5f8262e3758a5ee89276af'),
            ('UV/02m/UV02m_00217.sofa', '8c8cb271e3f1799283476e3628b9350a'),
            ('UV/02m/UV02m_00219.sofa', 'ed7811e0c9c7ae0ffa9d7e3a7efe658c'),
            ('UV/02m/UV02m_00220.sofa', 'bc91bbe53fc0af7f525f9dbffcdbe332'),
            ('UV/02m/UV02m_00221.sofa', '64afb1be74fd944b06f2f4b00a1a0a06'),
            ('UV/02m/UV02m_00222.sofa', 'c2899278b83776582de2b6cc1c07c167'),
            ('UV/02m/UV02m_00223.sofa', '3136d1b616ca9c317b7a4dd6952fc524'),
            ('UV/02m/UV02m_00224.sofa', '9b8d0ec9ee0f43fed525bf9a9feb2618'),
            ('UV/02m/UV02m_00225.sofa', '94aacf44a93b162e8c44ecfcb46953d4'),
            ('UV/02m/UV02m_00226.sofa', '4010d12c44dba7fd3e505428dfc867f1'),
            ('UV/02m/UV02m_00227.sofa', '9028d8c50cea34d281cc7a5625f5f601'),
            ('UV/02m/UV02m_00228.sofa', '5f4fe382119ad5d3732bfc32d8d63a24'),
            ('UV/02m/UV02m_00229.sofa', 'ea42dbe4aa400e1175c54045f650c21c'),
            ('UV/02m/UV02m_00230.sofa', '509fcf2f21b4cd48ae2b4d70fe618ff8'),
            ('UV/02m/UV02m_00231.sofa', 'dbd188e74c8607b9882087fd0529b3d2'),
            ('UV/02m/UV02m_00232.sofa', '062ed5ec261b18134d11f89916215dd4'),
            ('UV/02m/UV02m_00233.sofa', 'ebef967c5d56ff8443575033cccc6405'),
            ('UV/02m/UV02m_00234.sofa', '71e6562c2a9e705ff610c00d61c2611e'),
            ('UV/02m/UV02m_00235.sofa', 'b2cb49f7691a62b0e2e0116c9bad63d5'),
            ('UV/02m/UV02m_00236.sofa', 'c47b8b0b3cebbd2ae301dca4ade04377'),
            ('UV/02m/UV02m_00237.sofa', '6f0503e5fdca5cd1eb4a24e948ab7008'),
            ('UV/02m/UV02m_00238.sofa', '6cae0c0ec292a99f81f6c352f086de2a'),
            ('UV/02m/UV02m_00239.sofa', '238cc1b20584392b30b1b3a6b0c2ca4b'),
            ('UV/02m/UV02m_00240.sofa', 'c6ef057dc3ee9d94d5abbb2efd48be79'),
            ('UV/02m/UV02m_00241.sofa', 'fd7a39b741572fe2abe2bfbd31503e19'),
            ('UV/02m/UV02m_00244.sofa', '1a92c1d154df9f9c4937335193a67ff0'),
            ('UV/02m/UV02m_00245.sofa', 'ce4000b6124e831e09be02eddc54c4d2'),
            ('UV/02m/UV02m_00246.sofa', 'f0c288c42a533b279e189feb3e7f9abb'),
            ('UV/02m/UV02m_00247.sofa', '4b6546cc6344c85c2e1264fd38655c2e'),
            ('UV/02m/UV02m_00248.sofa', '0da77f04d5b35e27c97e6430c00b9262'),
            ('UV/02m/UV02m_00251.sofa', '180a158b9c579eae7797eb06f0b06d85'),
            ('UV/02m/UV02m_00252.sofa', 'f5bdafeb9538c7e8ed7f7b61d4c2ec7c'),
            ('UV/02m/UV02m_00253.sofa', 'd29d687fb3ec8626327cbcf2f86d5b95'),
            ('UV/02m/UV02m_00254.sofa', '8b2d0a0d23eab32b93f622c9dac94647'),
            ('UV/02m/UV02m_00256.sofa', '65be3a7ac1caa62a8a07c5ba2cbe623d'),
            ('UV/02m/UV02m_00258.sofa', '605d826545fe92920c3de976ce30f099'),
            ('UV/02m/UV02m_00259.sofa', 'f92d611334d00ff4e87d9cdeb57078e6'),
            ('UV/02m/UV02m_00261.sofa', '9895b828f7ad5967074d0f91634b1dde'),
            ('UV/02m/UV02m_00262.sofa', '61bdd2c2e39d209fd352ec8b51d14ca6'),
            ('UV/02m/UV02m_00263.sofa', 'b8cce304ee4920dbcbed459115f2794a'),
            ('UV/02m/UV02m_00264.sofa', '183e4cb44367a8e9c8d893325c8c5e57'),
            ('UV/02m/UV02m_00265.sofa', 'dab738632fb378f075ada82fd5b0f3bb'),
            ('UV/02m/UV02m_00268.sofa', 'c510920953f15bcd537034f9ffe2453b'),
            ('UV/02m/UV02m_00269.sofa', '9bf02f81fd63163d070e5d280fde7992'),
            ('UV/02m/UV02m_00270.sofa', '319eca634c64c38076c7a9f7825b9867'),
            ('UV/02m/UV02m_00271.sofa', 'c5b316b48f0fff1895c7c7aa6e4d0bcf'),
            ('UV/02m/UV02m_00272.sofa', 'a858d885f58dde9264e6bd6bf1d44598'),
            ('UV/02m/UV02m_00273.sofa', '098a4c12eb14848061c9bea4c40def55'),
            ('UV/02m/UV02m_00275.sofa', '5edabc370b37413916c9dfbb026c1297'),
            ('UV/02m/UV02m_00276.sofa', '52bfa96d6fb7e217eca4df920af48b6c'),
            ('UV/02m/UV02m_00277.sofa', '39b559165452a5a4fd01cbeeb3d4e2c7'),
            ('UV/02m/UV02m_00278.sofa', '916b42a9471e69442bcfe85e6c048e19'),
            ('UV/02m/UV02m_00279.sofa', '6ce9a33cc80e11a8b485ebaa52ae8fd0'),
            ('UV/02m/UV02m_00281.sofa', 'a531e3b260f4f1453baade803e75fcac'),
            ('UV/02m/UV02m_00283.sofa', '80fd250afd1112234e827103f2a58a09'),
            ('UV/02m/UV02m_00284.sofa', 'a576bbe9e5fe2aa83ff11ac58421501d'),
            ('UV/02m/UV02m_00285.sofa', '0829c0bb15ae18a1393215cbd40226fc'),
            ('UV/02m/UV02m_00286.sofa', 'f1f44e28ef855b6251194b68bcaf1c9b'),
            ('UV/02m/UV02m_00287.sofa', '41d59185da238245fca00d3a71b98d61'),
            ('UV/02m/UV02m_00288.sofa', '438a198c4db04d128d044d98f8a9f19f'),
            ('UV/02m/UV02m_00289.sofa', '9f2dcf068ae6b4a70e69a72028221c5e'),
            ('UV/02m/UV02m_00290.sofa', 'c741ba4168f05c01d6145f96e18fb492'),
            ('UV/02m/UV02m_00291.sofa', '0008199e4d25bc73fb889a68de5431cc'),
            ('UV/02m/UV02m_00293.sofa', '59d73a7bfa50e5cb52f31947e775be9e'),
            ('UV/02m/UV02m_00294.sofa', '392d591cd208473551b0b2b3adba7512'),
            ('UV/02m/UV02m_00295.sofa', '4cdef74b5f0d45cfab44392f2a872738'),
            ('UV/02m/UV02m_00296.sofa', 'e7cc1fe2096504b4258eacd8073fd68c'),
            ('UV/02m/UV02m_00297.sofa', '2a9aee56689affd821a472af0396e8d4'),
            ('UV/02m/UV02m_00298.sofa', 'e275f44d031c2b579b4fc28466d24f84'),
            ('UV/02m/UV02m_00301.sofa', 'e0336a2b0fc5cedfd68103286f775a95'),
            ('UV/02m/UV02m_00303.sofa', '4eeb0f774a2add22251f0fdef6dbff17'),
            ('UV/02m/UV02m_00305.sofa', '97c2d975fec9c08345a894deea9d6c6d'),
            ('UV/02m/UV02m_00306.sofa', '4967232fe1f9f748fce4942fdbd881e7'),
            ('UV/02m/UV02m_00307.sofa', '571fc06f4e220daf3bfd5a143209e5d5'),
            ('UV/02m/UV02m_00308.sofa', '44fa13131d5646ffc2c190d9a502d650'),
            ('UV/02m/UV02m_00309.sofa', '63dad8b7bf799ad439cb253672ae5ba9'),
            ('UV/02m/UV02m_00311.sofa', 'b18d118e3b0489e72a47a35c7e4df9c1'),
            ('UV/02m/UV02m_00315.sofa', '81b6e07c2fffea810a387ebe688ba1e6'),
            ('UV/02m/UV02m_00318.sofa', '5166817e7cff30dffd92802189e075d7'),
            ('UV/02m/UV02m_00319.sofa', '2a45ed787fe6d907464227325781a8da'),
            ('UV/02m/UV02m_00320.sofa', '28776fd565a26f552627644b01ec598a'),
            ('UV/02m/UV02m_00321.sofa', '163b00ec466c4fd2c7ece98644d7cd18'),
            ('UV/02m/UV02m_00322.sofa', '649153b841fd1ddead1e3732d92769c3'),
            ('UV/02m/UV02m_00323.sofa', '4c03b17f8d2d2b0bd824e4e8c51c4fd9'),
            ('UV/02m/UV02m_00326.sofa', '509edc50c80714c1d6000cb186b242a8'),
            ('UV/02m/UV02m_00328.sofa', '460ac7720c11a7417f70b5f0e79028b2'),
            ('UV/02m/UV02m_00329.sofa', 'f26a6c595c8fbbb6cb11882b3d56c2ce'),
            ('UV/02m/UV02m_00331.sofa', 'a93c70cc232921d8053d7e487ed64a59'),
            ('UV/02m/UV02m_00332.sofa', 'a22fe5f14dc27d6659d43290ecc2c7dd'),
            ('UV/02m/UV02m_00333.sofa', 'ad37b7dbfae103949192b10e6683ea19'),
            ('UV/02m/UV02m_00334.sofa', 'ad4cb8de85620a7b9f3565ebd49ab2ba'),
            ('UV/02m/UV02m_00335.sofa', 'a9792e00da5c8894e00f236dc5bd1a16'),
            ('UV/02m/UV02m_00336.sofa', 'cb4c13a4e4c1226e3837572d0040a9c2'),
            ('UV/02m/UV02m_00337.sofa', 'aa31fafbd30ff21807f22aaf9988f8d5'),
            ('UV/02m/UV02m_00338.sofa', 'd8c922caad0f397c72ed2cfededa9dcf'),
            ('UV/02m/UV02m_00340.sofa', '4e2abbb0a895f6cd636f22c0e8b3483a'),
            ('UV/02m/UV02m_00341.sofa', '1cb399d07d6479ab3c7c151aa0698dbe'),
            ('UV/02m/UV02m_00343.sofa', '65fefd9eab5b05ecdd88e0a37fd06ad6'),
            ('UV/02m/UV02m_00344.sofa', '3aaffbb394f063a32ba11f35b2d4f646'),
            ('UV/02m/UV02m_00345.sofa', '5079fd5a62cccfad3f67de6196c79eb7'),
            ('UV/02m/UV02m_00347.sofa', 'c3e8f740991b9caf418bec574805bf02'),
            ('UV/02m/UV02m_00348.sofa', '151e5c33bf56780b101fc03c3b6e2247'),
            ('UV/02m/UV02m_00349.sofa', '1a13d62956264e31e6d3d3627befe778'),
            ('UV/02m/UV02m_00350.sofa', '71cedb3ac6a1b3583dcb19265bd04caf'),
            ('UV/02m/UV02m_00351.sofa', '3cae3a9f357f1f2e02383118b9c43771'),
            ('UV/02m/UV02m_00352.sofa', 'd9156e9a27a836ed3007aba85179a510'),
            ('UV/02m/UV02m_00353.sofa', '765cc616122154671239974e63500d8d'),
            ('UV/02m/UV02m_00354.sofa', '075fc1b088f7c2e52c09ab59ab70d215'),
            ('UV/02m/UV02m_00355.sofa', 'a1100781e62fb43281f08a70a89c7788'),
            ('UV/02m/UV02m_00356.sofa', 'f0cc823d84fa3a4fb7b250694c910318'),
            ('UV/02m/UV02m_00358.sofa', 'a8ef81227d20feb22ed98a0b6edd9182'),
            ('UV/02m/UV02m_00359.sofa', '7a0392a5e8d781f5e6ce8b646dc718bf'),
            ('UV/02m/UV02m_00360.sofa', 'e1ee7eb67778f79155814de121072450'),
            ('UV/02m/UV02m_00361.sofa', 'ab6733afa2293f6d9a55ab637c333de5'),
            ('UV/02m/UV02m_00362.sofa', '5464435d249e182043c99305bf38eed1'),
            ('UV/02m/UV02m_00363.sofa', 'e7a1870f30f005c1bd962970b79bcac7'),
            ('UV/02m/UV02m_00364.sofa', 'eaccdde7cc552e92f9cb8c8b02ea9fed'),
            ('UV/02m/UV02m_00365.sofa', '30ba3fcc2f19b8455e742d3742d55d65'),
            ('UV/02m/UV02m_00366.sofa', '126b77c80edd107118ef5fa2a8911ee2'),
            ('UV/02m/UV02m_00367.sofa', '9cfcdf405bd0de9c094fb4e9eace24a6'),
            ('UV/02m/UV02m_00368.sofa', 'ba47eb629677c59cac6e47b04dc2e063'),
            ('UV/02m/UV02m_00370.sofa', '0c38bd0476f326496f8efc88625c8fc6'),
            ('UV/02m/UV02m_00371.sofa', 'b1afc546215597bcf702be57f80b9104'),
            ('UV/02m/UV02m_00372.sofa', '28cd7dba20f1b36106fe98fcf51e9426'),
            ('UV/02m/UV02m_00373.sofa', 'c2042d6dde85927bc88d3e59d7dc1d2f'),
            ('UV/02m/UV02m_00374.sofa', '83231ab4317c4e8e49dbeec39b302bbb'),
            ('UV/02m/UV02m_00375.sofa', '922e14ef4b3e0b8b44b901a482dfff2d'),
            ('UV/02m/UV02m_00376.sofa', '8c4e26469c57ddf4ef58e4d2a2ee5330'),
            ('UV/02m/UV02m_00378.sofa', '209dd82475860790ab22575408ccf443'),
            ('UV/02m/UV02m_00379.sofa', 'f0b9db81c2a4e7d773f77198399bff8b'),
            ('UV/02m/UV02m_00382.sofa', '15933f996fb480dc17118ae0ae781106'),
            ('UV/02m/UV02m_00383.sofa', '0295b0be9340edb1f9136684c3c29b48'),
            ('UV/02m/UV02m_00385.sofa', 'eafdb09fac7966981f44ba6397820edc'),
            ('UV/02m/UV02m_00386.sofa', 'bc10b9c5b39895383b6a117b51b8e9e5'),
            ('UV/02m/UV02m_00389.sofa', 'ac69e97cc60068e6df88573b0c26dd52'),
            ('UV/02m/UV02m_00391.sofa', '4a05c94996e5b26ab646a237841c5adb'),
            ('UV/02m/UV02m_00392.sofa', 'e8bf0a3a22778a5920a497602fd68fa2'),
            ('UV/02m/UV02m_00395.sofa', 'd4dc3172ec03ee7209f14626d102d317'),
            ('UV/02m/UV02m_00397.sofa', 'de5986d0b614e0b9b5e0ea6394c5232c'),
            ('UV/02m/UV02m_00398.sofa', '6e1bdc9ed48540dab1e282fa70413e9d'),
            ('UV/02m/UV02m_00399.sofa', '93cb6de868540e517215f34af980d706'),
            ('UV/02m/UV02m_00401.sofa', 'b4911010f181b41fb403b0a2d7886a53'),
            ('UV/02m/UV02m_00402.sofa', '2f747e2a14772f7d042323954894cd51'),
            ('UV/02m/UV02m_00403.sofa', '689319343713837e5cbccd390178dacd'),
            ('UV/02m/UV02m_00404.sofa', 'b5247ec7f51f3d7593ec01caadec35df'),
            ('UV/02m/UV02m_00405.sofa', 'dbf5f3ffb34cf9fd034957bd37645f3e'),
            ('UV/02m/UV02m_00406.sofa', 'fc034726de38d20de671da2640f073ee'),
            ('UV/02m/UV02m_00407.sofa', '6609063807b6407bb7b59a189d19ba7e'),
            ('UV/02m/UV02m_00408.sofa', 'b24c280177778966d41e683f5ac97e5f'),
            ('UV/02m/UV02m_00409.sofa', '87953c8b0f2fc4572ae553a3f6f22d0f'),
            ('UV/02m/UV02m_00410.sofa', '26a8eb29a5d8c999b7cdf131daa1baaf'),
            ('UV/02m/UV02m_00411.sofa', '95e1cd64312624584b3a9bddca0151ca'),
            ('UV/02m/UV02m_00412.sofa', '3f1a8fab1c708f189d1caa1bdfb328d8'),
            ('UV/02m/UV02m_00413.sofa', 'e47d63791dccd3737fb13b8ced1633a4'),
            ('UV/02m/UV02m_00414.sofa', 'fb2af74c3e13589c277b5ddf1116963d'),
            ('UV/02m/UV02m_00415.sofa', '32818757f7c9949897feebe099a5cf97'),
            ('UV/02m/UV02m_00416.sofa', '3c1fbbdb4785a52d1787180edc9519e3'),
            ('UV/02m/UV02m_00417.sofa', 'da32f7d2ac03eba0c789374f9fba2e15'),
            ('UV/02m/UV02m_00418.sofa', 'a71d65e30cf669b3f831246411e6b06c'),
            ('UV/02m/UV02m_00419.sofa', '9412d5d78cc7a006e5ec2c3885284e38'),
            ('UV/02m/UV02m_00420.sofa', 'dafca3c8304f48e2b25bcbd84f897df6'),
            ('UV/02m/UV02m_00421.sofa', '724f6dcd7ec5d08ac991368e9e50f449'),
            ('UV/02m/UV02m_00422.sofa', 'dc6bda9086558702f66df53e20366e3c'),
            ('UV/02m/UV02m_00423.sofa', '54ea2adeea405bbff6c17ccb0ebfdf84'),
            ('UV/02m/UV02m_00426.sofa', '3447ce0b8aca03591e1c40b06c906d0e'),
            ('UV/02m/UV02m_00427.sofa', 'd99cac7eb08812086db87bc5a7780f85'),
            ('UV/02m/UV02m_00428.sofa', '24f601c641a544828d2b127ed1e5cf7e'),
            ('UV/02m/UV02m_00430.sofa', '2f1a6b2f69a51f0286d2b05670eb3180'),
            ('UV/02m/UV02m_00432.sofa', '889733700a4fab34dd4e84950aeaea38'),
            ('UV/02m/UV02m_00433.sofa', '7e77c7294dacb4afb8833325d72b869d'),
            ('UV/02m/UV02m_00434.sofa', '8a3e11744bd5cff5963931bc9ce7716d'),
            ('UV/02m/UV02m_00441.sofa', '4474fa20b3fd8bb91e24310a1b836f91'),
            ('UV/02m/UV02m_00442.sofa', '3d0c8b8ba34199eaac1e03af38250d4c'),
            ('UV/02m/UV02m_00443.sofa', '41aea7957fc43a56873c60a947521411'),
            ('UV/02m/UV02m_00446.sofa', '0d8838b4fb50731da81089db8f036ba3'),
            ('UV/02m/UV02m_00448.sofa', '57583662e10d5ce1ca88f71e51e988f2'),
            ('UV/02m/UV02m_00449.sofa', 'f1a55ee585f0ece9024c8cf2855bc884'),
            ('UV/02m/UV02m_00450.sofa', '5e4339b92fb23f7935510d4c2821c722'),
            ('UV/02m/UV02m_00451.sofa', '1870d8a8b412330d81db6afa62c27d36'),
            ('UV/02m/UV02m_00452.sofa', 'c0629ad1882dd210327cfc45a44dba4b'),
            ('UV/02m/UV02m_00455.sofa', '980c49e6eb4c20170333d08377bf8684'),
            ('UV/02m/UV02m_00456.sofa', '7497cf892de3bf07228a71b26dafa086'),
            ('UV/02m/UV02m_00457.sofa', '4784f157bec7fdee444239f32c28d688'),
            ('UV/02m/UV02m_00459.sofa', '43bf46077e770ec984717beeaa9c23c0'),
            ('UV/02m/UV02m_00460.sofa', 'cb85b61e0fc5788ef6e96ae61350fa46'),
            ('UV/02m/UV02m_00461.sofa', '7e539ab62857c2a9901723ef763d63ec'),
            ('UV/02m/UV02m_00462.sofa', '337f6eae467948735bd273eb3d3b565d'),
            ('UV/02m/UV02m_00463.sofa', '5aa50e44aa00339db7b16eb462362acc'),
            ('UV/02m/UV02m_00464.sofa', 'c69e53ac1bdd7fa79b206ad4103be490'),
            ('UV/02m/UV02m_00466.sofa', 'b81feea196b0c555693c582eba288511'),
            ('UV/02m/UV02m_00467.sofa', 'fef285fc0acba20670fc43e50d719506'),
            ('UV/02m/UV02m_00468.sofa', 'eff072e341ff7082afd2423154fa52f4'),
            ('UV/02m/UV02m_00469.sofa', '19f4ae22046512259c9abd99401c758b'),
            ('UV/02m/UV02m_00470.sofa', '01fd8623063b22cca4019a90b778db3b'),
            ('UV/02m/UV02m_00471.sofa', '3f978dba37cd67835056b60e29168f89'),
            ('UV/02m/UV02m_00472.sofa', 'e759a005d72abd012ccd9c639fc654b1'),
            ('UV/02m/UV02m_00473.sofa', '9ff1252ed317208473891d8f12b04946'),
            ('UV/02m/UV02m_00474.sofa', '8f990ce37cd02f2aa4e40de292ac6507'),
            ('UV/02m/UV02m_00476.sofa', 'f5d37cfbf16b1c8c50db56ed291e0ecc'),
            ('UV/02m/UV02m_00477.sofa', 'ce67c748e2feb813495a6876777213ac'),
            ('UV/02m/UV02m_00478.sofa', 'a0347e75712fbf672875235c5c14031f'),
            ('UV/02m/UV02m_00480.sofa', '8515c5c1f95c60ad655337e70b2911f8'),
            ('UV/02m/UV02m_00481.sofa', '9b17c4fee0919fd5542e0152df1305b1'),
            ('UV/02m/UV02m_00482.sofa', '9b93d16f1b82aa768084ade00a26a139'),
            ('UV/02m/UV02m_00483.sofa', 'e5d1d73c2a1040cfd449038bbb9e8f94'),
            ('UV/02m/UV02m_00484.sofa', '3b988cb4f89f1281d196b2d41bf180d0'),
            ('UV/02m/UV02m_00486.sofa', '8dfed6b3e8b0dc5bd8c8b35c9ccc4370'),
            ('UV/02m/UV02m_00487.sofa', '177ed1ca4c4a8d9db4097c75fe4c067d'),
            ('UV/02m/UV02m_00489.sofa', '529a557621cc4e83a444484ed137bdde'),
            ('UV/02m/UV02m_00490.sofa', '1daa7c18cc188b1540b4f0283af72f2b'),
            ('UV/02m/UV02m_00491.sofa', 'c43b7bed86e4ff5a983a84eed6c55bae'),
            ('UV/02m/UV02m_00493.sofa', 'eb619fff687ce2ffcaded747d453ae36'),
            ('UV/02m/UV02m_00494.sofa', 'fd65ba868b0bbe2cd290e977675981b9'),
            ('UV/02m/UV02m_00497.sofa', 'e4a636198340d9ed38e21ad01d1e6678'),
            ('UV/02m/UV02m_00499.sofa', '80c7af1f0df8c155dab31168b8aef4c6'),
            ('UV/02m/UV02m_00500.sofa', 'e0d7585d3a31c82513fe52a7f0e73700'),
            ('UV/02m/UV02m_00501.sofa', '36478c11cbe3a07d3dde4f3dcc65dcc6'),
            ('UV/02m/UV02m_00502.sofa', 'f258e39847c16872ee058128a6f10412'),
            ('UV/02m/UV02m_00503.sofa', '3875044f059546679dc529a268dab00e'),
            ('UV/02m/UV02m_00505.sofa', '62d7157e66294b4be2264f82e127d586'),
            ('UV/02m/UV02m_00506.sofa', '5064b7e642f7be3a88f3b28a6a350850'),
            ('UV/02m/UV02m_00507.sofa', 'eea37bb9d24bf176562278398f8b70ca'),
            ('UV/02m/UV02m_00508.sofa', 'd5d7ebc9af114adef9c29dd26bb0425e'),
            ('UV/02m/UV02m_00509.sofa', '4712f5f31ec0d39e148ce39833f7a2bc'),
            ('UV/02m/UV02m_00511.sofa', '2f51d7c49b3b891fc8eb8ddeaebf30cd'),
            ('UV/02m/UV02m_00512.sofa', '69ec6d89e46e40e8ec9529caa03935e4'),
            ('UV/02m/UV02m_00513.sofa', 'fc035c9458f9e432f884a1abfeb7e90c'),
            ('UV/02m/UV02m_00514.sofa', 'c03c7bbd244d61a16cc12536f62275c3'),
            ('UV/02m/UV02m_00515.sofa', '7329414ba819345ed7af401f7e8fc7b4'),
            ('UV/02m/UV02m_00516.sofa', 'a6a1a03297b0067b89e281133c3d3d7a'),
            ('UV/02m/UV02m_00517.sofa', '2011de52eb5edb19014fd2f5a6535c98'),
            ('UV/02m/UV02m_00518.sofa', 'c0ae7ef198c8594bf85aa4c08f38dfff'),
            ('UV/02m/UV02m_00519.sofa', '6e89f36ec8365bbe8bdd20281890bd82'),
            ('UV/02m/UV02m_00520.sofa', 'dedc8fed1b870c2bde63a0bf8af4ad86'),
            ('UV/02m/UV02m_00521.sofa', '474132ad138f56bbd41cefe5664f89d8'),
            ('UV/02m/UV02m_00523.sofa', '7b8a34bc9c29cf1131b3dbf6ce7be752'),
            ('UV/02m/UV02m_00524.sofa', 'fb85bced248f9f268b0b9452d1360540'),
            ('UV/02m/UV02m_00525.sofa', '080b77c39935862400ef9677881d2176'),
            ('UV/02m/UV02m_00526.sofa', '0c01aed663a85b2d94b535b49a5b2c5f'),
            ('UV/02m/UV02m_00527.sofa', '452f7e1901a8fa3d7ef18bd8b91b243c'),
            ('UV/02m/UV02m_00528.sofa', '65501b662719b7965dada837d7349dbb'),
            ('UV/02m/UV02m_00529.sofa', 'd17feb915349425ee78a4971e2bd63d7'),
            ('UV/02m/UV02m_00530.sofa', '01b92cec5eab14b0ac7d87047deec94e'),
            ('UV/02m/UV02m_00532.sofa', '317df76fbc8de077b213f04430b339f8'),
            ('UV/02m/UV02m_00533.sofa', '195719d6e4b0b47e79fbf535d459dbb8'),
            ('UV/02m/UV02m_00534.sofa', 'a2a0ecdb603da57b18bce8d60388f12e'),
            ('UV/02m/UV02m_00536.sofa', '0e51aca4701cef1c12fff959338a1ce4'),
            ('UV/02m/UV02m_00538.sofa', 'c3aa6006395ea7bc5be589993da0696b'),
            ('UV/02m/UV02m_00539.sofa', '57972c32aec7de9ba136965fff9f74b2'),
            ('UV/02m/UV02m_00540.sofa', '7113a4e825f880903820d1161de000a5'),
            ('UV/02m/UV02m_00542.sofa', 'd1ace0c60304ec4dc740897935e33593'),
            ('UV/02m/UV02m_00543.sofa', '84d941e6eccbf7e8cf6ff0502090c376'),
            ('UV/02m/UV02m_00544.sofa', 'c0f92496975709f863e4bc3d0a190871'),
            ('UV/02m/UV02m_00545.sofa', '8d3c5d7653986f4ecbb45d0aba8d9b35'),
            ('UV/02m/UV02m_00546.sofa', 'cf97dc9a115a2534ca5d90cca65c681e'),
            ('UV/02m/UV02m_00547.sofa', '1757aa4cd733bf206b81c4276cad0e7d'),
            ('UV/02m/UV02m_00548.sofa', 'c81c90849c81d29443eb257f7e84ff1c'),
            ('UV/02m/UV02m_00549.sofa', '7a57cd7b5af1d1a1151c9da287f3e55e'),
            ('UV/02m/UV02m_00550.sofa', 'c81dc77891cfd260a7eaa534bfa6e207'),
            ('UV/02m/UV02m_00551.sofa', '40062570a45cf3ae3d89dbd3ce8406c2'),
            ('UV/02m/UV02m_00552.sofa', '85f6532c024d664327aa5abd8c4a1d4b'),
            ('UV/02m/UV02m_00553.sofa', 'df0e42dd204062baaab68134cf883a04'),
            ('UV/02m/UV02m_00555.sofa', 'a2aa01bb79ee831b69b76741e4948324'),
            ('UV/02m/UV02m_00557.sofa', '3fb8552afc8f997065f6fbf91340fddb'),
            ('UV/02m/UV02m_00558.sofa', '8679b9ea63d144ff205851f3b70562f6'),
            ('UV/02m/UV02m_00559.sofa', 'ec7b1358d889e1992492608574596f5c'),
            ('UV/02m/UV02m_00560.sofa', '2524236a27dd436a088946aeb2071db7'),
            ('UV/02m/UV02m_00561.sofa', 'bffb25a793817710ab486eec4c970461'),
            ('UV/02m/UV02m_00562.sofa', '94a50e3389d604526c10bf504c062c2b'),
            ('UV/02m/UV02m_00563.sofa', '44fdd45c9f1cb273daf89ac37980653c'),
            ('UV/02m/UV02m_00567.sofa', 'aafb84dda5e03e1ce0b3052856a79eb3'),
            ('UV/02m/UV02m_00568.sofa', '3c8ec7aee962bee90592fd8f1a46be38'),
            ('UV/02m/UV02m_00569.sofa', 'c022b97b46bcc11a94f3716569da3e63'),
            ('UV/02m/UV02m_00570.sofa', 'd4b13c73f521a87060b7e258032f0b4a'),
            ('UV/02m/UV02m_00571.sofa', '4706eb5ac1bb6027040da40e0d643795'),
            ('UV/02m/UV02m_00572.sofa', '9dd5d823f45486b45f665e96a86c0b5f'),
            ('UV/02m/UV02m_00573.sofa', '06c46e1f27e5f87efcba988e11fd767e'),
            ('UV/02m/UV02m_00576.sofa', '4edfedc67b877b9b04ddcf35eb1f08aa'),
            ('UV/02m/UV02m_00577.sofa', '691a8952e079bef396a3412b8ac11ce7'),
            ('UV/02m/UV02m_00580.sofa', '7ee783ef579f3c8f8c275ef1915d527b'),
            ('UV/02m/UV02m_00582.sofa', 'b83140c83a5189ac3b849b193ea84e5c'),
            ('UV/02m/UV02m_00583.sofa', 'c9c90f2b40f6b503835afcb628b6b80d'),
            ('UV/02m/UV02m_00585.sofa', 'b5becd9430d62eeca6b44b476f112efb'),
            ('UV/02m/UV02m_00588.sofa', 'eb70a58979c4a34795bd6dacf13a4b62'),
            ('UV/02m/UV02m_00590.sofa', '7ab33730d392593edbdc1fbedba37d18'),
            ('UV/02m/UV02m_00591.sofa', '75fbab157ed2b2d4e3adf89344072518'),
            ('UV/02m/UV02m_00592.sofa', '1dfbe6c9630028242b74a446e36b8ab9'),
            ('UV/02m/UV02m_00593.sofa', '0e5e3a78976fd124b480aa03e5ab8c3b'),
            ('UV/02m/UV02m_00594.sofa', '0cf0950356c73f1c42ca739565599db9'),
            ('UV/02m/UV02m_00595.sofa', 'c1a7eb5417cae0f6afd7efdc1de211fe'),
            ('UV/02m/UV02m_00596.sofa', '7421c36b73c85b66e7c6c61c0bef2518'),
            ('UV/02m/UV02m_00597.sofa', '8d266a71a036110c6e59008947a37c33'),
            ('UV/02m/UV02m_00598.sofa', '34c32f9b1d191f840e21dbad91f6612e'),
            ('UV/02m/UV02m_00599.sofa', '4725fd55c394fa4278f99a2bad80f22d'),
            ('UV/02m/UV02m_00600.sofa', '5878747e2c7d4967a02e0036842b6816'),
            ('UV/02m/UV02m_00601.sofa', 'c3e6acd0b299a1fa3dd452aec1372ec3'),
            ('UV/02m/UV02m_00604.sofa', '28bb84d94b44c9d3f1e9f7f929536bfc'),
            ('UV/02m/UV02m_00606.sofa', '417538c9d56e171056dd04e904bffb15'),
            ('UV/02m/UV02m_00608.sofa', 'ab9aef0461c6a77855d892cbf6f60323'),
            ('UV/02m/UV02m_00609.sofa', '86b05501ae79918a5a639b5dfc948c2e'),
            ('UV/02m/UV02m_00613.sofa', '4dc3dfbd9419ca943415ed68df7caeba'),
            ('UV/02m/UV02m_00616.sofa', '3179d3908f7532b8b6e0aeee5f9dc89b'),
            ('UV/02m/UV02m_00617.sofa', 'afde730a001e34cc271d22b64c5e2dc4'),
            ('UV/02m/UV02m_00618.sofa', 'a19ee2500be6a2434439bdd3893f5fe5'),
            ('UV/02m/UV02m_00619.sofa', '07988dcb36695f119a0a094985b9155a'),
            ('UV/02m/UV02m_00620.sofa', '483b2ff8c854b0a562d81ddc49b968f2'),
            ('UV/02m/UV02m_00621.sofa', '6df69bcf0ce9fa6efe76423a2414ac00'),
            ('UV/02m/UV02m_00622.sofa', '3e2be8cc7579823ebc20fefa003a6665'),
            ('UV/02m/UV02m_00623.sofa', '6fe9a718b4769e67b919f8dc9c261e63'),
            ('UV/02m/UV02m_00624.sofa', 'a131063991eb6074677de049808816da'),
            ('UV/02m/UV02m_00625.sofa', '84f892753120e870fb8b2e61e917cc8d'),
            ('UV/02m/UV02m_00626.sofa', '475675b2053e64c76da65959c189cae2'),
            ('UV/02m/UV02m_00628.sofa', '3d0a01a3eb696e9b746e91a81c2cb751'),
            ('UV/02m/UV02m_00629.sofa', 'f8bfd9f56e210651598b9baa44f31c60'),
            ('UV/02m/UV02m_00630.sofa', 'b5a8aef03d6c42e443c1fdc9f81a21cf'),
            ('UV/02m/UV02m_00631.sofa', '283ab83610ceb0e0d31921acc72ac8d3'),
            ('UV/02m/UV02m_00632.sofa', '36ec92ff0d481e33972ad4e9340b7d95'),
            ('UV/02m/UV02m_00633.sofa', 'b0173d163abd0aed4db0a72fae06173c'),
            ('UV/02m/UV02m_00634.sofa', '7214216835dba3441b3be191e822fbf6'),
            ('UV/02m/UV02m_00635.sofa', '0d4b3311602cebe2a74e7c040a34cfc7'),
            ('UV/02m/UV02m_00636.sofa', '2aeef50449ea5a4a5e9c18b1a4a2b337'),
            ('UV/02m/UV02m_00637.sofa', '39361bddf988399a83cedc80d9cd373e'),
            ('UV/02m/UV02m_00640.sofa', '3f4c4ffd520fa4005c7a49392eb27b71'),
            ('UV/02m/UV02m_00642.sofa', '07d623ff06bfb78c90ed4d0a064cdab1'),
            ('UV/02m/UV02m_00643.sofa', '8d8e91933c49c5f2f624e78091e18b68'),
            ('UV/02m/UV02m_00644.sofa', 'ddf5ed85d0227b7c2caa3b1b79990697'),
            ('UV/02m/UV02m_00645.sofa', 'ce6f3c8bbddb2acb0af9a48adf02778a'),
            ('UV/02m/UV02m_00646.sofa', 'd2d86e0ad6c5ae7ce2ea7ac25fbf8492'),
            ('UV/02m/UV02m_00647.sofa', '635735071d51a7028c7218a4ae15c5d2'),
            ('UV/02m/UV02m_00648.sofa', '5ccab5dfec8479a906d53aef52301beb'),
            ('UV/02m/UV02m_00649.sofa', '8efdf7f17af102524e1c8c5b34ecc0b4'),
            ('UV/02m/UV02m_00650.sofa', '64e62fcdf64d6b317c981b6561b20312'),
            ('UV/02m/UV02m_00651.sofa', '474243632e1cb0195eb72fb7d2a7b9bf'),
            ('UV/02m/UV02m_00654.sofa', '6fbf5cf1a379ebf0b41197cb50ead527'),
            ('UV/02m/UV02m_00655.sofa', '232a4869d03319e5b4936a55b2677004'),
            ('UV/02m/UV02m_00657.sofa', '5ef055eb238bf3f988aaed79cdab3793'),
            ('UV/02m/UV02m_00660.sofa', '14136976dd6e6cfc64c4dcb8ba171071'),
            ('UV/02m/UV02m_00661.sofa', '12706f1df6662c16235886283f53dfab'),
            ('UV/02m/UV02m_00662.sofa', '9bfd2db5b92f6faa7e0a1a833e41467c'),
            ('UV/02m/UV02m_00664.sofa', '1aaaa889f5107a4e0132df798f6e4261'),
            ('UV/02m/UV02m_00665.sofa', '023218f8512ae36f67202ef833002abb'),
            ('UV/02m/UV02m_00666.sofa', 'f64200d337f1c8224ff3617af379b40f'),
            ('UV/02m/UV02m_00667.sofa', 'f0f04307943c5d172daebbec8ed1d0ec'),
            ('UV/02m/UV02m_00668.sofa', '6ff22e05a34195c916dd2d439d533e25'),
            ('UV/02m/UV02m_00669.sofa', '8592d18989c1afd88002073f02890735'),
            ('UV/02m/UV02m_00670.sofa', 'd8f884999fee71e4b154813b19ddcd32'),
            ('UV/02m/UV02m_00671.sofa', 'c77934db202b7cfacafca9d4ada05399'),
            ('UV/02m/UV02m_00672.sofa', '37543c48866f07f07d806d424617ac6e'),
            ('UV/02m/UV02m_00673.sofa', '59ae2a6999bbdd9cd4c8450e31d1b7c8'),
            ('UV/02m/UV02m_00674.sofa', '7e316d6a7f410f965860835e5d208fbd'),
            ('UV/02m/UV02m_00675.sofa', '627380f451680d1f9be81c0e861cd3f3'),
            ('UV/02m/UV02m_00676.sofa', 'e454a1aad934ed9b77a9c8427835a903'),
            ('UV/02m/UV02m_00677.sofa', '1e440ab7ee196fb605bf16e14c2c7057'),
            ('UV/02m/UV02m_00678.sofa', '5f3158633fe1abb67e6490d8f6529246'),
            ('UV/02m/UV02m_00679.sofa', 'aa053b442bbedf993519c536d24de537'),
            ('UV/02m/UV02m_00680.sofa', 'f5c6587da0086d83f640ebfcb7591446'),
            ('UV/02m/UV02m_00681.sofa', '2e331934883ec54bbe91f670cffae76a'),
            ('UV/02m/UV02m_00682.sofa', '66744c14ad5c5057200531acbcff8326'),
            ('UV/02m/UV02m_00684.sofa', '93a385ca1a14324f541082f385c364fa'),
            ('UV/02m/UV02m_00685.sofa', '6704fd25feb35e0703fe71e1fcc209c3'),
            ('UV/02m/UV02m_00686.sofa', '4074f5d6297503cb50e8d1f9281828c5'),
            ('UV/02m/UV02m_00688.sofa', '285967e044e29c82de634875728a6df1'),
            ('UV/02m/UV02m_00689.sofa', '75d00ebff7a2d2d923da757596e31ce1'),
            ('UV/02m/UV02m_00690.sofa', 'fb7919525d1e468865e1fb7389a400a9'),
            ('UV/02m/UV02m_00693.sofa', '0edd48f28c15163881165451f634fc17'),
            ('UV/02m/UV02m_00695.sofa', 'eb10d0b655e65e781182649e5efb7fd4'),
            ('UV/02m/UV02m_00696.sofa', '2f54b62544b9283be4b212f17bba05d1'),
            ('UV/02m/UV02m_00697.sofa', '88afccf041f04b57a486baf029b637fd'),
            ('UV/02m/UV02m_00698.sofa', 'abe929135957a25eebd54586f5800632'),
            ('UV/02m/UV02m_00699.sofa', '499ffef5da8e2419e585ada7e44f1c18'),
            ('UV/02m/UV02m_00700.sofa', 'bbee40df1f569b7b8961fb85f42fb2b2'),
            ('UV/02m/UV02m_00701.sofa', 'ac53b51db9df20015c571e94226e0bcb'),
            ('UV/02m/UV02m_00702.sofa', '0526d80bcc939644ec865fee7ea1ce2e'),
            ('UV/02m/UV02m_00704.sofa', '018a7e70165553b6960abb6a97d76643'),
            ('UV/02m/UV02m_00705.sofa', '51edc6b573957648e3c0545f28db509e'),
            ('UV/02m/UV02m_00707.sofa', '41605624d31b085c0ac5b3df2a024bf8'),
            ('UV/02m/UV02m_00709.sofa', '1dd5390c6c266905eb78689692bc6d56'),
            ('UV/02m/UV02m_00710.sofa', '511f2e9bb88d51e0cd69ca491d8742b1'),
            ('UV/02m/UV02m_00711.sofa', '1ec5ae24865620f67a172c157a82d146'),
            ('UV/02m/UV02m_00712.sofa', '8746ba3b298d37238ce28f15d209cc1e'),
            ('UV/02m/UV02m_00713.sofa', '585868d78c458dd0cd9c73472f2f0b24'),
            ('UV/02m/UV02m_00714.sofa', '6b22098957fa740c030563444d5c9876'),
            ('UV/02m/UV02m_00717.sofa', 'd388077bb5ff9b540b59503722f220af'),
            ('UV/02m/UV02m_00718.sofa', 'a932b7be6ee601096a1ca7447b33d233'),
            ('UV/02m/UV02m_00719.sofa', 'af9082938a688ef130b9f015100a574e'),
            ('UV/02m/UV02m_00720.sofa', '4cffab8cbf2a1774e49c51ce4542eabc'),
            ('UV/02m/UV02m_00722.sofa', '8aaf50b6e41beba714130371cb1dc2b2'),
            ('UV/02m/UV02m_00723.sofa', 'dd9f2944af7f55479a84fa922498f47c'),
            ('UV/02m/UV02m_00724.sofa', '3fbe241695e165fd9c00f889a2127ea0'),
            ('UV/02m/UV02m_00725.sofa', 'd2bb12252a0cc4924611098d473c503c'),
            ('UV/02m/UV02m_00726.sofa', '12ac1facc6e2cdad295367030122f2aa'),
            ('UV/02m/UV02m_00727.sofa', '9a248deced8beb2a84876ab1452d9888'),
            ('UV/02m/UV02m_00729.sofa', '442d0041c7c704f4b8cb9eed070d707f'),
            ('UV/02m/UV02m_00730.sofa', '203ff825460740b55f84cb9632e08316'),
            ('UV/02m/UV02m_00732.sofa', 'b14f0afd5a64b2b88aac723f4c449b2a'),
            ('UV/02m/UV02m_00734.sofa', '93e64e72343e301ed6510d4cab65e402'),
            ('UV/02m/UV02m_00735.sofa', 'fc67f3f9283582d2d949b9547f4c8761'),
            ('UV/02m/UV02m_00736.sofa', 'dd0a3c2679249ef71151a47f0784abb5'),
            ('UV/02m/UV02m_00740.sofa', '78c1d75650a907c453fbdc371aa547ec'),
            ('UV/02m/UV02m_00742.sofa', 'd7b9dfa1abbb79b9a05bbf44e854f0bf'),
            ('UV/02m/UV02m_00744.sofa', 'fa1cca479bc5e64df2b76dc1cd8bc808'),
            ('UV/02m/UV02m_00745.sofa', '88e5715bcf16d0b9d580a31cd77c697a'),
            ('UV/02m/UV02m_00746.sofa', 'bd1b856a80b968e01b2428ad414773d5'),
            ('UV/02m/UV02m_00747.sofa', '8a9dcdc51140a8086e2d9ddeb7b99200'),
            ('UV/02m/UV02m_00748.sofa', 'b3eece212a790cf4f8ef4f510baefc53'),
            ('UV/02m/UV02m_00749.sofa', '2aa7c1836eb8f6335322dfd83d0ce09f'),
            ('UV/02m/UV02m_00750.sofa', 'fb7d38d3bdce0d1adb4c24c7ac8ab673'),
            ('UV/02m/UV02m_00751.sofa', 'cd8506e3f236b2a4027f27b610db1774'),
            ('UV/02m/UV02m_00753.sofa', '87d9fadc60f37b221ca26567a57421c1'),
            ('UV/02m/UV02m_00754.sofa', 'fc167c26608639e359332bdadc627697'),
            ('UV/02m/UV02m_00755.sofa', '63c485bf452f1feac330daf251e4cc00'),
            ('UV/02m/UV02m_00756.sofa', 'd9ed1142b66e4978b23fe6ca920ceca3'),
            ('UV/02m/UV02m_00757.sofa', '0b2932894b58d2c3b5bdc872a0bbdda9'),
            ('UV/02m/UV02m_00758.sofa', '512a140b9a767b19cacc35fec200f7ae'),
            ('UV/02m/UV02m_00760.sofa', '95cf4cb90fc2ac30e07653c903e8e989'),
            ('UV/02m/UV02m_00761.sofa', '683f4c158896d89cb9bf0308033ba8e2'),
            ('UV/02m/UV02m_00763.sofa', '8f08ca8a5e75730fc6bfd5fea2f8c1e0'),
            ('UV/02m/UV02m_00764.sofa', '60730eb1695f5fdd7dae898cf70b8dae'),
            ('UV/02m/UV02m_00766.sofa', '4fdae301fba4544f2038c7e7afa32716'),
            ('UV/02m/UV02m_00767.sofa', '4e97ea5a3a1ef9db6136364c4d06c64d'),
            ('UV/02m/UV02m_00768.sofa', 'c421fbf0e1e9b9f0e36ff6c94eb05bf0'),
            ('UV/02m/UV02m_00769.sofa', 'cd8796863a46d4a85e20efa22664b0e3'),
            ('UV/02m/UV02m_00770.sofa', '0abf546e85697b5cfb927d9b3a593d96'),
            ('UV/02m/UV02m_00771.sofa', '9deb17baece44a20630ade422a196795'),
            ('UV/02m/UV02m_00772.sofa', '610cc3909462512149457840fd7be51f'),
            ('UV/02m/UV02m_00773.sofa', 'b1e2c5463d616e6aa527b2023a52a620'),
            ('UV/02m/UV02m_00774.sofa', 'f6006ea7bbd1377e1e85cf795bf53f7b'),
            ('UV/02m/UV02m_00775.sofa', '724aafad1911e3fe77019591ee261d79'),
            ('UV/02m/UV02m_00778.sofa', '7a45b709bdc8a982560ba491aa5b04c7'),
            ('UV/02m/UV02m_00779.sofa', '8387ee442ff13845fa302a8a6905c9ad'),
            ('UV/02m/UV02m_00780.sofa', '5ab24eceaabee6ed315de6ece543ba3b'),
            ('UV/02m/UV02m_00782.sofa', '02e5d3815e268f18d2737bf287500431'),
            ('UV/02m/UV02m_00783.sofa', '2ae15aad21f4a75efda0e1c7d214d2e0'),
            ('UV/02m/UV02m_00787.sofa', '0953d2117e3ff91c64b1c65f70b1d416'),
            ('UV/02m/UV02m_00788.sofa', '3f9489d041d7abcc59064d2343499b26'),
            ('UV/02m/UV02m_00789.sofa', 'ad7afe4befcfe65d42ceb26acb19d84f'),
            ('UV/02m/UV02m_00791.sofa', 'ce0d4bd7f7decfa0b2d11f7ffcf636e1'),
            ('UV/02m/UV02m_00794.sofa', '5179cccfd613e748763e912a3836430e'),
            ('UV/02m/UV02m_00795.sofa', 'a4f7d21052a2927ce2d549ffb999c09f'),
            ('UV/02m/UV02m_00797.sofa', 'ca9eac34fd64ddeb95fa5cc2533ccf0b'),
            ('UV/02m/UV02m_00798.sofa', 'a8866c6c7a4d81f8892ed03fc8b6b920'),
            ('UV/02m/UV02m_00799.sofa', '9f25bf26389ef3fd5cbf384167ed892a'),
            ('UV/02m/UV02m_00800.sofa', 'db4a311d73f7351d19ca9fb3ba177969'),
            ('UV/02m/UV02m_00801.sofa', '392539f418f77a696187ee86491b18b0'),
            ('UV/02m/UV02m_00802.sofa', '225e9c1c8d247424b988346a6a17e080'),
            ('UV/02m/UV02m_00803.sofa', '60ffa6bfe818a3c7ccba04304a112056'),
            ('UV/02m/UV02m_00804.sofa', '2456c200194e9d5e17b7931ab71e297b'),
            ('UV/02m/UV02m_00805.sofa', 'f7d448d270b6c1e286a95816624f6ba2'),
            ('UV/02m/UV02m_00806.sofa', 'd825e2ccd324ef05b6e4dc60658fa4a5'),
            ('UV/02m/UV02m_00807.sofa', '0005ae6a2a4c559ddfe3492a90fc8709'),
            ('UV/02m/UV02m_00809.sofa', '1435753d9ddf0542e9c98af13b721d03'),
            ('UV/02m/UV02m_00810.sofa', '5df8dd3e2b418053f24042b44541bd2b'),
            ('UV/02m/UV02m_00811.sofa', '4901ad4612390508ea5e0379e2acb617'),
            ('UV/02m/UV02m_00812.sofa', 'f6b6d069b1d8575ac6b0256a67f87418'),
            ('UV/02m/UV02m_00815.sofa', '2da1e47f53a6892a4bd37bf3bb5f3b2d'),
            ('UV/02m/UV02m_00816.sofa', '89eb7a700830798db3a386dc95b6170d'),
            ('UV/02m/UV02m_00817.sofa', 'd43d66168643145f24384f0db5ea9421'),
            ('UV/02m/UV02m_00818.sofa', '8bdfb222fae1996b57d11c5e65de958c'),
            ('UV/02m/UV02m_00819.sofa', 'bf729a539421548446166f49fce193d9'),
            ('UV/02m/UV02m_00821.sofa', '3b017872d51ed2bc0fdff7e1e804e075'),
            ('UV/02m/UV02m_00822.sofa', 'a5eb112f9b9698b68ab39b697cfbc9ba'),
            ('UV/02m/UV02m_00823.sofa', 'c88744c47cb218d15e4c174db4981fba'),
            ('UV/02m/UV02m_00824.sofa', '4b2064e2fade631b9e56fb2c54ccd0cc'),
            ('UV/02m/UV02m_00825.sofa', '74039134280b3555caacd159c95138c4'),
            ('UV/02m/UV02m_00826.sofa', '5e9a13776fd63170278bc74d6ea8f678'),
            ('UV/02m/UV02m_00827.sofa', '814e78e287fbe09e7acc29119ea41eef'),
            ('UV/02m/UV02m_00829.sofa', 'b05675ff436467c837114dba3d3a5c4e'),
            ('UV/02m/UV02m_00830.sofa', '7d67f89e362e4e96069733971707bea0'),
            ('UV/02m/UV02m_00833.sofa', 'dac3826aae197b1bd3f8364119617f0d'),
            ('UV/02m/UV02m_00835.sofa', 'aa821c4686a5380b0d8f5bedbc910422'),
            ('UV/02m/UV02m_00836.sofa', 'ab7065461512de9162ca4518b5ca2968'),
            ('UV/02m/UV02m_00837.sofa', '7dad00616314d9107bb6ce0bebe2e451'),
            ('UV/02m/UV02m_00838.sofa', 'e81fbfe44cdc79d69abfef988bb8dd60'),
            ('UV/02m/UV02m_00839.sofa', '8877105e4802ab043b927bc200a08304'),
            ('UV/02m/UV02m_00840.sofa', 'e1f269cfb788625b6caa33495139cb32'),
            ('UV/02m/UV02m_00841.sofa', '202313cfa5adf0c1ae6444a867ae389a'),
            ('UV/02m/UV02m_00842.sofa', 'f365e62050dfcff7e94bd2ba4c63273b'),
            ('UV/02m/UV02m_00843.sofa', 'c6dbe5a5a093469835b469a4959ba7b8'),
            ('UV/02m/UV02m_00844.sofa', '5c6070f2b6595fa0f7d67d008aa21065'),
            ('UV/02m/UV02m_00845.sofa', '0566bcb7d1d2013954f986d844dc0596'),
            ('UV/02m/UV02m_00846.sofa', '8faced8f41915b8eb6fb396f16609258'),
            ('UV/02m/UV02m_00850.sofa', '5fd6d92ef1b55a41febd4adc96229a65'),
            ('UV/02m/UV02m_00852.sofa', '8c810193ff9432b0b1aed2f7067ad252'),
            ('UV/02m/UV02m_00853.sofa', '77e63baaaf6a99334b43a8538e5b21cf'),
            ('UV/02m/UV02m_00855.sofa', '1d2e34a992ecafad75a5f85755b3fda2'),
            ('UV/02m/UV02m_00857.sofa', 'bbf163235edfea63ee36b231d88c32dc'),
            ('UV/02m/UV02m_00858.sofa', '43ed802c63dff737b7cedadf1b5228b6'),
            ('UV/02m/UV02m_00859.sofa', '0b6da7afd9631ced8358006750b3eb20'),
            ('UV/02m/UV02m_00860.sofa', '5d681a92ff7b094a4bd29264701e41ba'),
            ('UV/02m/UV02m_00861.sofa', '926cb93c60a3c75073708019ef75b8ec'),
            ('UV/02m/UV02m_00863.sofa', '5b760fe54e1c3527f8777e3bd03ae5d9'),
            ('UV/02m/UV02m_00864.sofa', 'b09bf8541202ea15fafee8aba96cfe34'),
            ('UV/02m/UV02m_00865.sofa', '05793fe4c3202cc1c011de6340b6a26c'),
            ('UV/02m/UV02m_00866.sofa', '0bfcb9972d24de4ad369fa9aa69c9ae8'),
            ('UV/02m/UV02m_00867.sofa', '36a5f02b0f1c327a0dccb0f4692e74dd'),
            ('UV/02m/UV02m_00868.sofa', '85940f97485b352b43a9e885d94f77ac'),
            ('UV/02m/UV02m_00869.sofa', '8467c8a7273f0af62014452d09f6e4ef'),
            ('UV/02m/UV02m_00870.sofa', '7d61ae953e005cbd3537ffdbaacf9df6'),
            ('UV/02m/UV02m_00872.sofa', '9e5a2505fa0bbbc946b64de446d8b7c0'),
            ('UV/02m/UV02m_00875.sofa', '4552cf83adbfe7f8c2e724a1a847ff76'),
            ('UV/02m/UV02m_00877.sofa', '3868cd37a898af7eb02aa9cbc424b17c'),
            ('UV/02m/UV02m_00880.sofa', 'f7f1b56042723c0c590e3a2360493c9a'),
            ('UV/02m/UV02m_00882.sofa', '95cf2047c6313a459efd93f01a63c885'),
            ('UV/02m/UV02m_00883.sofa', 'c58287500cc985ecaac2ac2f82e22612'),
            ('UV/02m/UV02m_00884.sofa', '8be5005e21742c361a314498270d8bfe'),
            ('UV/02m/UV02m_00887.sofa', 'ae04918ae487ab87b00e7d1139f6b532'),
            ('UV/02m/UV02m_00889.sofa', '6b6514980359e033d9ccd92af751c5e8'),
            ('UV/02m/UV02m_00890.sofa', '3b5821257122c54ae4f154795ba60873'),
            ('UV/02m/UV02m_00891.sofa', 'eb449a0e02eac587bd00c306e02c07a3'),
            ('UV/02m/UV02m_00892.sofa', '16bfdb70bd605e2504f4c0eba234c292'),
            ('UV/02m/UV02m_00893.sofa', '36aa7afef9a1cd7051476836a72abdab'),
            ('UV/02m/UV02m_00894.sofa', '5d46da9e9765abf5aecaf2c1ea2f159c'),
            ('UV/02m/UV02m_00895.sofa', 'e4b219d72a9e53a0c434912019101c94'),
            ('UV/02m/UV02m_00896.sofa', '7b2e63854cee9054435de8d2d21be454'),
            ('UV/02m/UV02m_00897.sofa', 'd2abf776773a6a14378fe72531089472'),
            ('UV/02m/UV02m_00898.sofa', '5f9338e80885dcac656c714a24244d94'),
            ('UV/02m/UV02m_00899.sofa', '022aa4045a1ee1d949a436082ad36e09'),
            ('UV/02m/UV02m_00900.sofa', '7aa4ef03f2ccbd0bb51513ed33d3066e'),
            ('UV/02m/UV02m_00901.sofa', '2999ad10ea487133a425a286d14e2cfc'),
            ('UV/02m/UV02m_00902.sofa', 'c53ea77280fa3e5fc8e69237fe4bf9b0'),
            ('UV/02m/UV02m_00903.sofa', '18b2909dcd6ba45f9ecc10ce4b50bf9c'),
            ('UV/02m/UV02m_00904.sofa', 'ba9125440525d4fa923ea7eba5814d1d'),
            ('UV/02m/UV02m_00906.sofa', 'b2a81f2bfb102db4bca64a12cbd4d06d'),
            ('UV/02m/UV02m_00907.sofa', '9b920d376ce3a75f3fc8380f038ea593'),
            ('UV/02m/UV02m_00908.sofa', 'b6d06e6532681038b0ebf1dfa4e6b6ff'),
            ('UV/02m/UV02m_00910.sofa', 'd105f0b530f5684f258a2066795bc14a'),
            ('UV/02m/UV02m_00911.sofa', '07822443c7e2d13d86dae52624e6a539'),
            ('UV/02m/UV02m_00913.sofa', '18c5dde98583d1b1057eb4dcea4d8cba'),
            ('UV/02m/UV02m_00915.sofa', '601db1653da648ce36f7d17f982f5559'),
            ('UV/02m/UV02m_00918.sofa', '1f5d40e5179b4fa319d5f203f7358425'),
            ('UV/02m/UV02m_00919.sofa', '76669998a75347ae21fe94fd841a1f6b'),
            ('UV/02m/UV02m_00920.sofa', 'ab65b2a07f78e2be97cc860928858d42'),
            ('UV/02m/UV02m_00921.sofa', '40374570989275eef8fbb4064c5a50c6'),
            ('UV/02m/UV02m_00923.sofa', '008f78ca57c5605997ad16538ad2f451'),
            ('UV/02m/UV02m_00924.sofa', 'f70d78b387143fe4878c506c0a81e082'),
            ('UV/02m/UV02m_00925.sofa', '3e637faf276d42066887984629049e7d'),
            ('UV/02m/UV02m_00926.sofa', 'e63b863e94fdeb80d21d4ac20463b6ce'),
            ('UV/02m/UV02m_00927.sofa', 'a6e006c1508403de2b3c2b0ef41a13a0'),
            ('UV/02m/UV02m_00929.sofa', '8160e2620070475e0a531892d9adec56'),
            ('UV/02m/UV02m_00930.sofa', 'd5baeece5e72c750d5191ee99142de9a'),
            ('UV/02m/UV02m_00931.sofa', '55a04bf56f77cff0cc4cc1461df8926e'),
            ('UV/02m/UV02m_00932.sofa', '2edc661cc746405a7820c9c17a179107'),
            ('UV/02m/UV02m_00934.sofa', 'f3368bbd471d55426813ee1a559731b7'),
            ('UV/02m/UV02m_00936.sofa', '8a65cde39953cfcfd30756ca609c5513'),
            ('UV/02m/UV02m_00937.sofa', 'a881d4c4fcfb78d582564ebb4b71e025'),
            ('UV/02m/UV02m_00939.sofa', 'fd10f64ada03ebc5ee70a3e7f0f934e1'),
            ('UV/02m/UV02m_00940.sofa', 'a273c0ed57023bdeab4f8baf9f799b84'),
            ('UV/02m/UV02m_00942.sofa', 'e4da571b4c3f31456ad1edd5670dcf4a'),
            ('UV/02m/UV02m_00944.sofa', '5d0f7f927ffbdaf28a457ecd85778a51'),
            ('UV/02m/UV02m_00946.sofa', '82614342cf254f4c5ebbc82041c60b64'),
            ('UV/02m/UV02m_00947.sofa', 'ffc4800a3490fb5119b7b4df1cf3eae1'),
            ('UV/02m/UV02m_00951.sofa', '119812053536f88766db8a65fccb565e'),
            ('UV/02m/UV02m_00952.sofa', '500e37758b9a075d736da2e70af69509'),
            ('UV/02m/UV02m_00953.sofa', '1cb129650986b0a27261f390ace551a5'),
            ('UV/02m/UV02m_00954.sofa', 'fe0870aa78a5553fe528ef01b4d567b6'),
            ('UV/02m/UV02m_00955.sofa', '5042b009777c6ae6ff4fb7d7f681d362'),
            ('UV/02m/UV02m_00956.sofa', '1b39c7df55e8a24f6dee52fc27b4d3b4'),
            ('UV/02m/UV02m_00961.sofa', 'ca0c2e86e869e1d5e44cb82907932aff'),
            ('UV/02m/UV02m_00962.sofa', 'f155625d64502b934316b2c4101b7675'),
            ('UV/02m/UV02m_00963.sofa', 'ba589556743384eb67110248eac6b3ee'),
            ('UV/02m/UV02m_00965.sofa', '3d11cd8e93326457ba8c3f195f2f1940'),
            ('UV/02m/UV02m_00966.sofa', '756d33dfdabd3fc9a8b2cb8d9b22ff7a'),
            ('UV/02m/UV02m_00967.sofa', '7b46acbfd783200beaaf85f3b8acc776'),
            ('UV/02m/UV02m_00968.sofa', '1d6286103838849088fbd08fad6501c4'),
            ('UV/02m/UV02m_00969.sofa', '700b7bd3b66eb9f76bca4b1aebc2ba33'),
            ('UV/02m/UV02m_00971.sofa', '1904ee4f64774be297021479d55631fa'),
            ('UV/02m/UV02m_00972.sofa', 'e62e00c17c7e46c42c94d9d67b600f6d'),
            ('UV/02m/UV02m_00973.sofa', 'b823f91b42c6cae1b42dfdde754db0c3'),
            ('UV/02m/UV02m_00975.sofa', '2b3ccac5b1452fdfa2cc49e29a5febfb'),
            ('UV/02m/UV02m_00976.sofa', 'd84a18fda7e11c039b0337be57fbb597'),
            ('UV/02m/UV02m_00977.sofa', 'bc875b517f37e55354f8e5f7a193d0a9'),
            ('UV/02m/UV02m_00978.sofa', '529ca41407e3ed61f78a92b9456492ea'),
            ('UV/02m/UV02m_00979.sofa', '015db2a994a1fe5d26587d9a7d833810'),
            ('UV/02m/UV02m_00980.sofa', '288e22b6dec08782cb14433af21a10b0'),
            ('UV/02m/UV02m_00981.sofa', 'ec7e79f49e65ab064ee89dbc53dd9e17'),
            ('UV/02m/UV02m_00982.sofa', '2dd5e35d157f5998b8eca95faecd279d'),
            ('UV/02m/UV02m_00984.sofa', 'acc9a47df1aebf290be295cf66771015'),
            ('UV/02m/UV02m_00985.sofa', '07b73a459b76784774fa15828aa202ff'),
            ('UV/02m/UV02m_00986.sofa', '0643a7e0bccb128abfe6f57b571ff1f2'),
            ('UV/02m/UV02m_00987.sofa', '6b78682cfe7dd307f01e0cf9e6adc91c'),
            ('UV/02m/UV02m_00991.sofa', '915ecb8722cac715b29b03a91071b986'),
            ('UV/02m/UV02m_00993.sofa', 'b9200ea30c090a28a4ea1ada0ed8b553'),
            ('UV/02m/UV02m_00995.sofa', '81a67b99ba2bbdc96274de4b782165a8'),
            ('UV/02m/UV02m_00996.sofa', 'e9a331861487f7767143f7c1d0d5afb3'),
            ('UV/02m/UV02m_00997.sofa', 'd68164c552084a74b949684c0f887659'),
            ('UV/02m/UV02m_00998.sofa', '2fc06b5e8a0d878f4dd6d7c1f4445098'),
            ('UV/02m/UV02m_00999.sofa', 'bbbc28c13b0846042d7ceadcaee8d4b3'),
            ('UV/02m/UV02m_01000.sofa', 'a675945c4e9fd07e9e95f6261e4ac444'),
            ('UV/02m/UV02m_01002.sofa', '6a08873f687d68f743e0c3c6ef6af083'),
            ('UV/02m/UV02m_01003.sofa', 'b58f3157b47a5b2c70b95c877b79c26e'),
            ('UV/02m/UV02m_01004.sofa', '07c2446ed8a961a669d15e2d254ccf44'),
            ('UV/02m/UV02m_01005.sofa', 'cfd87eeed6bb1be04737dc2e601ea49b'),
            ('UV/02m/UV02m_01006.sofa', 'fd0d9b57964b080fde7077dc145f087d'),
            ('UV/02m/UV02m_01008.sofa', '8cb1b935717d987a4407f5e3a09b230b'),
            ('UV/02m/UV02m_01009.sofa', 'b38ea16df1d0d946a1a5a66f87bd9a2b'),
            ('UV/02m/UV02m_01010.sofa', 'fd521d0a73b94677a6c0998b5b575360'),
            ('UV/02m/UV02m_01011.sofa', '0194e325b35f0aa725abd0a065b5c418'),
            ('UV/02m/UV02m_01012.sofa', '1144340444ee0e5cb4e1baf9ee9c00c7'),
            ('UV/02m/UV02m_01013.sofa', 'd6113624c119ad6e005675b4b746685d'),
            ('UV/02m/UV02m_01016.sofa', 'abfb7b3458fc4e88a507db7a7689bfdf'),
            ('UV/02m/UV02m_01017.sofa', '1ab355e30b490c71ce486beb5073f8da'),
            ('UV/02m/UV02m_01018.sofa', '57d40e184e6c0abff06f500fc918969d'),
            ('UV/02m/UV02m_01019.sofa', 'e4cb79d8dc78adeeefab5f02ba27569a'),
            ('UV/02m/UV02m_01020.sofa', '9b2bccd0675a87d4d1fb9bef937043f9'),
            ('UV/02m/UV02m_01022.sofa', '135576055bcf0ea98f9f6cea89c599e5'),
            ('UV/02m/UV02m_01024.sofa', '14d013c94c79b88a53733f41a8cdc035'),
            ('UV/02m/UV02m_01027.sofa', '6cd106bfe99e735f3c29c328d7b82697'),
            ('UV/02m/UV02m_01028.sofa', '9f46189622fc4a9bb9c2224aadfa762d'),
            ('UV/02m/UV02m_01030.sofa', '27d02348ea0e46a447688accf65f381d'),
            ('UV/02m/UV02m_01031.sofa', '4c623258080a474a71686c7115e78c34'),
            ('UV/02m/UV02m_01032.sofa', '6ca50c2d989bdf6ab5e2e25de4804a90'),
            ('UV/02m/UV02m_01033.sofa', '96a9a0130c0c848849f9343ff7ee21c2'),
            ('UV/02m/UV02m_01035.sofa', '731e64c7c3aae51efc23e8bd19d56c2d'),
            ('UV/02m/UV02m_01036.sofa', 'ce8d32bd42c3c65cc6ac55ce1bc844f6'),
            ('UV/02m/UV02m_01037.sofa', '6ac16f71895f09932e77f62e1086b0f8'),
            ('UV/02m/UV02m_01038.sofa', 'a0fd6152b56a3f96584bf1fd3636e8eb'),
            ('UV/02m/UV02m_01039.sofa', 'ba4569cf3f6d875f353064af0332c89d'),
            ('UV/02m/UV02m_01040.sofa', '688f38ee70d1336fef3633b752685539'),
            ('UV/02m/UV02m_01042.sofa', '1819c0526ed09cfe5e47102698ead5db'),
            ('UV/02m/UV02m_01044.sofa', '70edc97ff16d447eb5963aa62b656796'),
            ('UV/02m/UV02m_01046.sofa', '9482e4cb7fe1420240d94553684f2d6c'),
            ('UV/02m/UV02m_01047.sofa', '12d85db5df5af0648aa881ee21129525'),
            ('UV/02m/UV02m_01048.sofa', 'df96c55961ba20adf4fcbcfa460d55f9'),
            ('UV/02m/UV02m_01049.sofa', '9afaedb02bb8d916e0d7bc76e359a176'),
            ('UV/02m/UV02m_01050.sofa', 'f1d4b274f3d17582f53780ef41b87d76'),
            ('UV/02m/UV02m_01052.sofa', '64886ecbbcffe668e0e8ff0b6d9fce9d'),
            ('UV/02m/UV02m_01053.sofa', 'a0760b6ba0c985293996eaf4e07cb202'),
            ('UV/02m/UV02m_01055.sofa', '7d931a697bfe6ee28f949a59d6d41a37'),
            ('UV/02m/UV02m_01057.sofa', 'bee69c4d9ba1ff8df32301c7b56bb5f4'),
            ('UV/02m/UV02m_01058.sofa', '5fc68865a88f37b7e80c121d37dd2e77'),
            ('UV/02m/UV02m_01060.sofa', 'c803b61c071e353be69eeaff7369bebf'),
            ('UV/02m/UV02m_01061.sofa', 'd66ba72569b35e01112b5119ced0077a'),
            ('UV/02m/UV02m_01062.sofa', '7f1472faff15726ec10c8949e751283e'),
            ('UV/02m/UV02m_01063.sofa', '6592a67f24226c6933a92cc529588242'),
            ('UV/02m/UV02m_01064.sofa', 'aa4a799f73da20f896bf4daac3e26871'),
            ('UV/02m/UV02m_01065.sofa', '07848109e72486a07f17b79d619ae7d9'),
            ('UV/02m/UV02m_01066.sofa', '9f96ab10f03f99886e5916f3b631bb80'),
            ('UV/02m/UV02m_01067.sofa', '0ae891a4f35ae5611af793dd88bc5442'),
            ('UV/02m/UV02m_01069.sofa', '2786fa4acefa30df02414cfa9f52f16c'),
            ('UV/02m/UV02m_01071.sofa', '3b626aa70e9377398a2da099f4755523'),
            ('UV/02m/UV02m_01073.sofa', '199bce8ffa2a6cc0d0cacbe1c3149bde'),
            ('UV/02m/UV02m_01075.sofa', '3edc1b5a01f765447fd1b84ee0341b4b'),
            ('UV/02m/UV02m_01077.sofa', '9bc4cf26db05aea91043ee843822da2c'),
            ('UV/02m/UV02m_01078.sofa', 'dfe7bfb488b0b2bc8a09577df2179a79'),
            ('UV/02m/UV02m_01079.sofa', '1518c816bde439a3c35244bfd440bbd1'),
            ('UV/02m/UV02m_01080.sofa', '2458baf5bb7a190b647e4f6df8561615'),
            ('UV/02m/UV02m_01082.sofa', 'ef7c3862dd63d3856ac2bac294aba02e'),
            ('UV/02m/UV02m_01083.sofa', 'd3b26a8345e6fb97fb52bfadc6cf0bcc'),
            ('UV/02m/UV02m_01085.sofa', '9930e56fd905ec9e95e51a9c7d5b6549'),
            ('UV/02m/UV02m_01086.sofa', '389a8f3114dc9177cd5ebd8236f494b0'),
            ('UV/02m/UV02m_01087.sofa', 'fa65be0db142f7e8f9c6394dab6d0c79'),
            ('UV/02m/UV02m_01088.sofa', '8d85357801b8138ef4f8e5aad2e6bf2b'),
            ('UV/02m/UV02m_01089.sofa', 'a961a4de96e7873d1b8be67c565f1a1e'),
            ('UV/02m/UV02m_01091.sofa', '1e8d31fbc550fc1dd40877f7e508f26a'),
            ('UV/02m/UV02m_01092.sofa', '471821d1b0d54bcb7e56cac25e9f266a'),
            ('UV/02m/UV02m_01093.sofa', 'f2c42454b511d42692ef30a44657d6e1'),
            ('UV/02m/UV02m_01094.sofa', '7c7756e18ae711ec4ee1fba0df9cad28'),
            ('UV/02m/UV02m_01097.sofa', 'd20243712cd9e59428253a8a77c2d8ab'),
            ('UV/02m/UV02m_01099.sofa', '70a9b68c8f81df09e050a7d75546ee7d'),
            ('UV/02m/UV02m_01100.sofa', '0ee15084a7b8d4d1f54950b67355814f'),
            ('UV/02m/UV02m_01101.sofa', 'fd9c25537f53782760078fca6d744380'),
            ('UV/02m/UV02m_01102.sofa', '43895eb5cb2b2384935ce5c077adee20'),
            ('UV/02m/UV02m_01103.sofa', '4617e36b208fede79954ff6a07e550b5'),
            ('UV/02m/UV02m_01104.sofa', '9819f800989af869700b1f752921ce34'),
            ('UV/02m/UV02m_01107.sofa', '5ae1a39835b0c14330f2063450db4b91'),
            ('UV/02m/UV02m_01108.sofa', 'bca3f78512aef3bacc9fb8d37e7882ff'),
            ('UV/02m/UV02m_01109.sofa', '4418fbd1fd012e8a2bc187b8b3ae8eff'),
            ('UV/02m/UV02m_01111.sofa', 'd8ab274a3163c541a260c88127357d7b'),
            ('UV/02m/UV02m_01112.sofa', '59881c53472abba2c842841bf53a1d6a'),
            ('UV/02m/UV02m_01114.sofa', 'a30d5b8fb77313ca29646758fff5b760'),
            ('UV/02m/UV02m_01115.sofa', 'b2c855e394228c1279acffedc9de8fc0'),
            ('UV/02m/UV02m_01116.sofa', '0980fc527a8bb724031545533104638a'),
            ('UV/02m/UV02m_01117.sofa', '2b8d4965e3fdc7a28311c21088732a5e'),
            ('UV/02m/UV02m_01120.sofa', '11daca44ebe79d2aa9b24bc658ab3523'),
            ('UV/02m/UV02m_01121.sofa', '7a95dd34f4ab7e5ea31e82c98a6db5cd'),
            ('UV/02m/UV02m_01122.sofa', 'ee8df2dc57754ed034d9afd8d1582957'),
            ('UV/02m/UV02m_01125.sofa', 'c7bccea3617711e5388062da7abbab69'),
            ('UV/02m/UV02m_01127.sofa', '53e319f9725d38091aa59914730a860b'),
            ('UV/02m/UV02m_01128.sofa', '45b76090c538d3c112e08d39c5464d6b'),
            ('UV/02m/UV02m_01129.sofa', '97ce28c6f6f30174354fc2a0c787a8a7'),
            ('UV/02m/UV02m_01130.sofa', 'e0b585094266b01fa9d875622641b3b2'),
            ('UV/02m/UV02m_01131.sofa', '3e73d1f54f3383bc3d8dd7281c9cc7f1'),
            ('UV/02m/UV02m_01132.sofa', 'c15b443b6378133a9583034d24b244d1'),
            ('UV/02m/UV02m_01134.sofa', '6bccd2e08a39c145e752fdfa6fa1d7c8'),
            ('UV/02m/UV02m_01135.sofa', 'c3f9e5cfb0523f66516911be40ad8594'),
            ('UV/02m/UV02m_01136.sofa', '8a72b38b6fa87147f2a8072cc4bb3d76'),
            ('UV/02m/UV02m_01137.sofa', 'e344dfbc1f75e769ea5a5f3b92a16994'),
            ('UV/02m/UV02m_01139.sofa', 'cab2e3b2e3bd6a401d53a707255a76e7'),
            ('UV/02m/UV02m_01140.sofa', 'e31d60e9202c521bcdc75d4cfce96c3f'),
            ('UV/02m/UV02m_01141.sofa', '7ea7e02c85ab5147c273471e1de20482'),
            ('UV/02m/UV02m_01142.sofa', '9569b995ab9f6c8b5c3919ca08ea7385'),
            ('UV/02m/UV02m_01143.sofa', 'b0731c0a98f357d17b2db546eb8dbd53'),
            ('UV/02m/UV02m_01144.sofa', 'a978d289b5a8efd81e344cc33122a1d9'),
            ('UV/02m/UV02m_01145.sofa', '49931086ddb83e921d56f70a3a450b7d'),
            ('UV/02m/UV02m_01146.sofa', '2355083c2269248762d70efd858ad290'),
            ('UV/02m/UV02m_01147.sofa', '286535175b55b0f7417f47b145f5a8ab'),
            ('UV/02m/UV02m_01148.sofa', 'b08f678b7dc40883f1a33a88f364482a'),
            ('UV/02m/UV02m_01149.sofa', 'e1433684fe5e9497d74084da6f2d93ce'),
            ('UV/02m/UV02m_01150.sofa', 'aba87df066578534c9cfbd47d74faab8'),
            ('UV/02m/UV02m_01151.sofa', '6a04bfc78b702ec3a7f8334656ab1e6b'),
            ('UV/02m/UV02m_01152.sofa', '451677dfd5c5d31905230446f68c60d3'),
            ('UV/02m/UV02m_01155.sofa', '0097b95b18f87b662657328a1e4df354'),
            ('UV/02m/UV02m_01157.sofa', 'b312c8a234c4e37123ae7a44f3b6d2d6'),
            ('UV/02m/UV02m_01160.sofa', 'be442feeb2bd3cef1620482d5eb9b0a3'),
            ('UV/02m/UV02m_01162.sofa', '0ff20e33ecf3c7bae3e8ec5c0564aacb'),
            ('UV/02m/UV02m_01163.sofa', 'cb13209ac21827491d3d93ff9283b1e1'),
            ('UV/02m/UV02m_01164.sofa', '8773ba805f7a721c340803933a1225c5'),
            ('UV/02m/UV02m_01165.sofa', '06d14bc903094889c60371839d806dc1'),
            ('UV/02m/UV02m_01166.sofa', 'dc0bf323257b08069482ffaee6edda14'),
            ('UV/02m/UV02m_01168.sofa', '8f41ab54c29f8da9196b42c1a9fd8d74'),
            ('UV/02m/UV02m_01171.sofa', 'a38d541c03142336dae271fb7a5f6f78'),
            ('UV/02m/UV02m_01172.sofa', 'db7875bbc6e533abe45700b9f9d317fc'),
            ('UV/02m/UV02m_01173.sofa', '40276fb36e43c8d8573daa705836b1d0'),
            ('UV/02m/UV02m_01174.sofa', '382e2aeab318245c496216f4c9b1fc17'),
            ('UV/02m/UV02m_01175.sofa', 'ec4d6b374995652a12aae87d35e70433'),
            ('UV/02m/UV02m_01176.sofa', '5088e045764795817e98e72a4d629cd0'),
            ('UV/02m/UV02m_01177.sofa', '0c9b0c72fd040df9075db31891a82c4c'),
            ('UV/02m/UV02m_01179.sofa', '0dfae59e31850e8c124950429f87f26d'),
            ('UV/02m/UV02m_01181.sofa', 'ab33f955806498fd8e3fe583f8563148'),
            ('UV/02m/UV02m_01185.sofa', '37333992b5b70eb82165abf189799122'),
            ('UV/02m/UV02m_01186.sofa', 'dd5ea965aa7af9b5b18a17ca07c237db'),
            ('UV/02m/UV02m_01189.sofa', 'bf6bbb979d47b33edf26416eae7fa79f'),
            ('UV/02m/UV02m_01190.sofa', '1179088399fcf534ed0b7dc2e8b39d17'),
            ('UV/02m/UV02m_01191.sofa', '2317b459a73edf2a6a124b1c8ac9df16'),
            ('UV/02m/UV02m_01192.sofa', 'aba0ff85236f0b36c4388256a0ec2ff0'),
            ('UV/02m/UV02m_01193.sofa', 'dc8bfc24540b91cc434b691b92b108ab'),
            ('UV/02m/UV02m_01194.sofa', '92bb40cee3195f296fd8b46e7a78a8f4'),
            ('UV/02m/UV02m_01195.sofa', 'd77f4c2ccc73d825e5a67e780674be64'),
            ('UV/02m/UV02m_01196.sofa', '69439b48aaff1fa84a44c3f95465d86d'),
            ('UV/02m/UV02m_01197.sofa', '0bec4ca90e8455e0f80145f2d93c4ae6'),
            ('UV/02m/UV02m_01200.sofa', 'da0a53a3051b02402866ac6071ac02b1'),
            ('UV/02m/UV02m_01201.sofa', '3fcab4a57ee4cdbbf09100537f442ef5'),
            ('UV/02m/UV02m_01202.sofa', 'fd77816a97246ee87018f2e01acb15fa'),
            ('UV/02m/UV02m_01203.sofa', '728c6f1058d5eaaf0b4609ef76466be5'),
            ('UV/02m/UV02m_01205.sofa', '9461418901d35decd7f36f7679c0b695'),
            ('UV/02m/UV02m_01206.sofa', '483f9b21c8323b9026b60738f7271c58'),
            ('UV/02m/UV02m_01207.sofa', '58cfeff43cae14b348bf009d7020cb31'),
            ('UV/02m/UV02m_01208.sofa', 'c9ab402278bba7f569f5a80280714eb8'),
            ('UV/02m/UV02m_01209.sofa', '9ebb7b1288170d53c74497ad5c581bdd'),
            ('UV/02m/UV02m_01210.sofa', 'd67dba362e5c1ab2ce00f195474307e6'),
            ('UV/02m/UV02m_01211.sofa', '3780c1a00cd01656b716c8d0d55fa821'),
            ('UV/02m/UV02m_01212.sofa', 'cf0ece2e8ac8ab96d61d01a913ac4c85'),
            ('UV/02m/UV02m_01213.sofa', 'cbe5c86f6d828d31e57dad8b5c177c14'),
            ('UV/02m/UV02m_01215.sofa', 'eadb33fa54a2395686b2fa4af6576cc6'),
            ('UV/02m/UV02m_01216.sofa', '9a44f6767b80baca5fc4100d127b0726'),
            ('UV/02m/UV02m_01217.sofa', 'b0d3a92bd26fed200c326ff21f5ddc84'),
            ('UV/02m/UV02m_01219.sofa', '3ea6dedda11882ce8d1acf7e18308039'),
            ('UV/02m/UV02m_01221.sofa', '7afd642cf27101b2ae40485f8ed2db11'),
            ('UV/02m/UV02m_01222.sofa', '13b45d0093a5f709db11569fc68abf22'),
            ('UV/02m/UV02m_01223.sofa', 'adba36a159d7f83892f440ce8224c6bf'),
            ('UV/02m/UV02m_01224.sofa', '4267478a699cf23f55736fa6e2d16bc0'),
            ('UV/02m/UV02m_01225.sofa', '3bba0740db9b23a7777d1cf7216df8d6'),
            ('UV/02m/UV02m_01228.sofa', '4513fdb4b06f77a7e73b38f37c918eb9'),
            ('UV/02m/UV02m_01230.sofa', '6554a389f017597099af26d227dbb414'),
            ('UV/02m/UV02m_01231.sofa', '04a8c3f1b7080aae0f7412bf03242f20'),
            ('UV/02m/UV02m_01232.sofa', '2d6ce34ce83d3fec5d5780b7fa8fc0e7'),
            ('UV/02m/UV02m_01233.sofa', '37bf33c74d5d4f730268bd21fd311a8c'),
            ('UV/02m/UV02m_01234.sofa', '43d5608647e878d708a8bb1d569d553b'),
            ('UV/02m/UV02m_01235.sofa', '974a97e46d9a9658bd320700776cd6c1'),
            ('UV/02m/UV02m_01237.sofa', 'bd38a1d7c7435769da9050e7fb1a3da5'),
            ('UV/02m/UV02m_01238.sofa', '37d529bbd7fb6796cc8b0216150f5d65'),
            ('UV/02m/UV02m_01239.sofa', 'aeb641593413d9fc2606b86f8c15f257'),
            ('UV/02m/UV02m_01240.sofa', 'abaa1ed1e3a5a3ce90430cbdba1f198e'),
            ('UV/02m/UV02m_01242.sofa', '05c36053594347c0c63ac802a6ee4d4c'),
            ('UV/02m/UV02m_01244.sofa', '74c99742542d0740449b4941d690ad1a'),
            ('UV/02m/UV02m_01245.sofa', 'fe969281e3f267625ccc8b5aea1e478f'),
            ('UV/02m/UV02m_01248.sofa', 'de6fd0e32e75a124bc51916ebef96944'),
            ('UV/02m/UV02m_01251.sofa', '1fe0d95fd5c76a04a89ebba04d9863ad'),
            ('UV/02m/UV02m_01252.sofa', '5d7ffff922df944a40aa2b2594feaf1f'),
            ('UV/02m/UV02m_01254.sofa', '75288f6df171925e506e19d7bc644da3'),
            ('UV/02m/UV02m_01256.sofa', '1900daf8384013af5d464a8ef9616d88'),
            ('UV/02m/UV02m_01258.sofa', '6ef2e9b55c8a5789c621fc2007beeaa6'),
            ('UV/02m/UV02m_01259.sofa', '8523316044ea3f938c7c238f730af483'),
            ('UV/02m/UV02m_01262.sofa', '7b02b49aef9e3d368d2d00e7605f7e31'),
            ('UV/02m/UV02m_01263.sofa', '17e2a34e2ff3de1e5b6f1a8d2016a901'),
            ('UV/02m/UV02m_01264.sofa', '469dd346c71fabc1b9ab8ce71f49a1fc'),
            ('UV/02m/UV02m_01265.sofa', '546fbf62d8d5602abfde710731221632'),
            ('UV/02m/UV02m_01266.sofa', '2e172d2c1b7b75b6bc907ca9d5d3d5fb'),
            ('UV/02m/UV02m_01268.sofa', '68c318edbef4e25a64c97a67161a3958'),
            ('UV/02m/UV02m_01270.sofa', '8a43fd4584c2f0abe2085fe968d8dd69'),
            ('UV/02m/UV02m_01271.sofa', '66fb823850ac3f54e2a58873fb01f231'),
            ('UV/02m/UV02m_01272.sofa', 'acf658dd1ec1d2ae3a710351c88e9c8c'),
            ('UV/02m/UV02m_01273.sofa', '9296deb4909c8eb7d01c7e4a52ad330f'),
            ('UV/02m/UV02m_01274.sofa', '47788771acd48865358c7fc2b2c542f0'),
            ('UV/02m/UV02m_01275.sofa', '45d0572c98cac6a3ea2e3c4421425104'),
            ('UV/02m/UV02m_01276.sofa', '03a027a9110d0fd794ce1ef4a6dae106'),
            ('UV/02m/UV02m_01277.sofa', '93386a9d674f78f9cd07ae5fb4596368'),
            ('UV/02m/UV02m_01278.sofa', '702a2d438f48b73af947ae1647fb12d3'),
            ('UV/02m/UV02m_01279.sofa', '0b4340c74ff0210350518f5521cf8393'),
            ('UV/02m/UV02m_01280.sofa', '241a26f8a074276999218afb1cf4726a'),
            ('UV/02m/UV02m_01282.sofa', 'cf067be69e6142d83ee6719c8569876b'),
            ('UV/02m/UV02m_01284.sofa', '7666833cc3f44617d5574a1e9e35ef95'),
            ('UV/02m/UV02m_01286.sofa', '41efd6263e06b704b4d55ece59bdffd9'),
            ('UV/02m/UV02m_01288.sofa', 'd1c0947361acb69c1ba668aa1d537301'),
            ('UV/02m/UV02m_01290.sofa', 'a126d16703697382364a7497c4c741c7'),
            ('UV/02m/UV02m_01291.sofa', '705df68500950b75281f35e4a7bde0f3'),
            ('UV/02m/UV02m_01292.sofa', '8b514f200ac756513bb8c9eac680bcaa'),
            ('UV/02m/UV02m_01293.sofa', '593720489025208ebf69ae4cc9ccd808'),
            ('UV/02m/UV02m_01294.sofa', '1db4f93a3e186c81e4ec4b2ea49033d2'),
            ('UV/02m/UV02m_01295.sofa', '6f34b89ce1d1123e5aebcc1b648c6d82'),
            ('UV/02m/UV02m_01296.sofa', '808a827278a9fed83cc16ecc777b0141'),
            ('UV/02m/UV02m_01298.sofa', '2b29bc2dd1a10e13ced8fc04bdbdc535'),
            ('UV/02m/UV02m_01299.sofa', '272bd2914a44f3b33c31e1f0c0a55403'),
            ('UV/02m/UV02m_01301.sofa', 'b5b671ee0646d94f64129facfc1e1c81'),
            ('UV/02m/UV02m_01302.sofa', '10d3438df7fabe92d53c9200f0fdffa0'),
            ('UV/02m/UV02m_01303.sofa', '504915e33a46d1ab79a55e7d0a3ad409'),
            ('UV/02m/UV02m_01304.sofa', '438e4fb12082f65b40f303d9af76bb04'),
            ('UV/02m/UV02m_01305.sofa', '17dbe72c06bfa192a553651f71af1e29'),
            ('UV/02m/UV02m_01308.sofa', 'ac2dd52506301e817ed87d4782544a79'),
            ('UV/02m/UV02m_01309.sofa', '1066a68c66ddee898d0b4f81266c7207'),
            ('UV/02m/UV02m_01310.sofa', '46aed5693a9b74744e4d9d131200055f'),
            ('UV/02m/UV02m_01311.sofa', '1102b62e0e7561d5f35dbbcd7dfb610f'),
            ('UV/02m/UV02m_01312.sofa', '5bc630e401bdb31a13c7f5b2f61010fa'),
            ('UV/02m/UV02m_01313.sofa', 'cfd154043e8666888e8590a518d916c5'),
            ('UV/02m/UV02m_01315.sofa', 'fc179869d4d5bd31f7de369253ce7ac6'),
            ('UV/02m/UV02m_01317.sofa', '89a146b2d9d5a1053ec0307f6b1d9b26'),
            ('UV/02m/UV02m_01318.sofa', 'e64a9b7d08c426e54b345990919e23cd'),
            ('UV/02m/UV02m_01319.sofa', 'c3bfb25e92d71cdf7dc34af032465374'),
            ('UV/02m/UV02m_01320.sofa', '5a32b4208e9f9fe15ff8dcc5b64d0eb9'),
            ('UV/02m/UV02m_01321.sofa', '017889b55670ff5ebf9f43a427438994'),
            ('UV/02m/UV02m_01324.sofa', '5ee6b4bd7f1b6e59bc96188b77af5681'),
            ('UV/02m/UV02m_01326.sofa', 'c9b8009c816b0da46db1b26a6bf0f07b'),
            ('UV/02m/UV02m_01327.sofa', '260e59a6d610a50016def020d070dfe2'),
            ('UV/02m/UV02m_01328.sofa', 'fe00964504950d31b7745f86aa31e7af'),
            ('UV/02m/UV02m_01329.sofa', '2cb513dbf0abd40a59ab792ba995726b'),
            ('UV/02m/UV02m_01330.sofa', 'dc871821ba7bea0d4aa87d620a05be2e'),
            ('UV/02m/UV02m_01331.sofa', '2bee286f01b63fc4a496d52ccfa5e5d8'),
            ('UV/02m/UV02m_01333.sofa', '54ab4eb18f517d31df66627e1c4970de'),
            ('UV/02m/UV02m_01334.sofa', '1680df7d71ab5321993144f72442061b'),
            ('UV/02m/UV02m_01335.sofa', '448083fdf020dd59ea42c950bb02c64d'),
            ('UV/02m/UV02m_01337.sofa', '5237c3ec07f43cefc9faafeab8580544'),
            ('UV/02m/UV02m_01338.sofa', 'd73e1a98653f11c45942ffb70be54ef7'),
            ('UV/02m/UV02m_01342.sofa', '8e6116afb8bacb586ba5d50c6e0e7023'),
            ('UV/02m/UV02m_01344.sofa', '5540d41b9acd759e62d5a92d23c01d97'),
            ('UV/02m/UV02m_01345.sofa', '3ef5192e9c3d348d8632bcb2b40be221'),
            ('UV/02m/UV02m_01346.sofa', '21eed7fdcd9dc52663c2a1fb5cbe3cc3'),
            ('UV/02m/UV02m_01347.sofa', '19af45ab8737f84a8642432e1efe331a'),
            ('UV/02m/UV02m_01349.sofa', '470ca6107d6f7500e363b3edc7e0ecab'),
            ('UV/02m/UV02m_01350.sofa', '1db449349e6eae2e29c25e37afb24818'),
            ('UV/02m/UV02m_01351.sofa', '1c327a813363a42e98054366a0b0624e'),
            ('UV/02m/UV02m_01352.sofa', '4f010ec08b0d159b8c4d092881d40e7e'),
            ('UV/02m/UV02m_01355.sofa', '42f1314ffa705ca979affc8c4eb9fa6b'),
            ('UV/02m/UV02m_01356.sofa', '48ba8d7fb65f69678654b26afb21eaf4'),
            ('UV/02m/UV02m_01357.sofa', '2e2f2704749d01d402101f8b54a41ae8'),
            ('UV/02m/UV02m_01359.sofa', '3f0e3273d27fd4c450b19e60655943ee'),
            ('UV/02m/UV02m_01360.sofa', '27cb6264d99abd294ef59e9a54963a4e'),
            ('UV/02m/UV02m_01362.sofa', '568127ad1e293ff264a6192fd57aad8a'),
            ('UV/02m/UV02m_01363.sofa', 'b91a72663cf768cd5bdcc6a9fb6c9090'),
            ('UV/02m/UV02m_01364.sofa', '1dd653ebf639db909fddc703a7ffa048'),
            ('UV/02m/UV02m_01365.sofa', '242cf9de4ad4c0e977b7c67c877f43f7'),
            ('UV/02m/UV02m_01366.sofa', 'f6ff7c31654c0c6d6e433f3bf99f4307'),
            ('UV/02m/UV02m_01367.sofa', '236f11fdf0eae819d940170843bcdb26'),
            ('UV/02m/UV02m_01370.sofa', 'd0be5c309d7b190de6a54017229a6c55'),
            ('UV/02m/UV02m_01371.sofa', '0824b192dcfb1b87eac67e0dca7ed366'),
            ('UV/02m/UV02m_01372.sofa', '18ff21903365537cfa0438199e7346bf'),
            ('UV/02m/UV02m_01373.sofa', 'b41e273ff0452d181e2e51fdc0e1654c'),
            ('UV/02m/UV02m_01374.sofa', '6352d82f898a3420815e36c9c3915e35'),
            ('UV/02m/UV02m_01375.sofa', 'c155042196187589eeda19286ba59d2f'),
            ('UV/02m/UV02m_01376.sofa', '03a8f86533d500175dddfa9f6755a2b2'),
        ],
        'UV-05m': [
            ('UV/05m/UV05m_00001.sofa', '99306abac6bab2d3c7938b4b67f945df'),
            ('UV/05m/UV05m_00002.sofa', '333d8d839af513dba5fce767da4b8eef'),
            ('UV/05m/UV05m_00003.sofa', '6f38e1d3fbcda78d692a490d6b9af1d8'),
            ('UV/05m/UV05m_00004.sofa', '9ecc322d52b28fae9c691c91a03a3906'),
            ('UV/05m/UV05m_00005.sofa', 'c76c92a4091b49abfe27fd849879eacd'),
            ('UV/05m/UV05m_00007.sofa', 'dd0541bbf65223d89b4fe53232219520'),
            ('UV/05m/UV05m_00009.sofa', '36120b4f440e0c59030dcd8dd96695d5'),
            ('UV/05m/UV05m_00010.sofa', 'a2ed0d241212b6705650e2adeae2998e'),
            ('UV/05m/UV05m_00011.sofa', 'b0d13445a15ab6437f7f110197957fe0'),
            ('UV/05m/UV05m_00013.sofa', '2474e5ff5d29186dcff09fe5fae37e59'),
            ('UV/05m/UV05m_00014.sofa', 'ad8c9ec30bbe4aa89399910e7d714db1'),
            ('UV/05m/UV05m_00015.sofa', 'abcd8d6d83d53f368f0ef3e8076cd967'),
            ('UV/05m/UV05m_00016.sofa', '8b845f12a5ff51301d1fa45a65e0cead'),
            ('UV/05m/UV05m_00020.sofa', '42217f51bf2cfefd667efb3599f3d2fb'),
            ('UV/05m/UV05m_00021.sofa', 'df577d9d8a119c99700bfffcab04d82c'),
            ('UV/05m/UV05m_00022.sofa', '69f28ccbdbce8119bd8b4a41a4a57139'),
            ('UV/05m/UV05m_00023.sofa', '41583d81bd4cbbb8e16292af5376a0a1'),
            ('UV/05m/UV05m_00024.sofa', '959f4dec1c066f02929d33c212456d85'),
            ('UV/05m/UV05m_00025.sofa', '3be0e7739bdf2326bbaa9daacfe37769'),
            ('UV/05m/UV05m_00026.sofa', 'e7ccfb9c0f5efc885da5a98f261aa775'),
            ('UV/05m/UV05m_00027.sofa', '85ff7f010572bb9130cfde1a933495a1'),
            ('UV/05m/UV05m_00029.sofa', 'adaf1a539bef2e692ed6d94bcb27a77e'),
            ('UV/05m/UV05m_00030.sofa', '39fb58c9db4a2d1383e5490d68d2628d'),
            ('UV/05m/UV05m_00031.sofa', 'a8909f3d324001ad70fa7a7f90530aa5'),
            ('UV/05m/UV05m_00032.sofa', '67ccb2ff5a545ea7d17ff15caae1446d'),
            ('UV/05m/UV05m_00033.sofa', '37bf011c152208cd7fec89cfcbc32001'),
            ('UV/05m/UV05m_00036.sofa', '50ebb66de9da030049e091a12a1ab671'),
            ('UV/05m/UV05m_00038.sofa', 'c27e8d2beb0ae71670fa98c81ac7d842'),
            ('UV/05m/UV05m_00039.sofa', 'b62254279563e4ab1e0b53d595f1162f'),
            ('UV/05m/UV05m_00042.sofa', 'a71334109c75f6c451b8e76bbacf7026'),
            ('UV/05m/UV05m_00043.sofa', '2174cb9d587726a24f67ff48623df43a'),
            ('UV/05m/UV05m_00044.sofa', '2efa23fcdcc1f25cdfacddeea6e580f3'),
            ('UV/05m/UV05m_00045.sofa', '4ec635bd23e9cd31f3aaba323bfd1340'),
            ('UV/05m/UV05m_00048.sofa', 'c0ecf0e331b7b54ec131785215eccc7b'),
            ('UV/05m/UV05m_00049.sofa', 'ec93e0ca84f13e1e4548f8043ec5196c'),
            ('UV/05m/UV05m_00054.sofa', 'cd83ecc48338a80bba9d9fee73d0decf'),
            ('UV/05m/UV05m_00056.sofa', 'f791f29873a58314b413e526d8bc45a3'),
            ('UV/05m/UV05m_00057.sofa', '23ad14fbc61c471ce8d19dfbc6100ffe'),
            ('UV/05m/UV05m_00058.sofa', '73f514fea99b1bb44bdefe2ec48ed49e'),
            ('UV/05m/UV05m_00059.sofa', 'aa92eda54701da2600f39c91714a5e1b'),
            ('UV/05m/UV05m_00061.sofa', '7cfc2a202a112be1363e3384d9b216cb'),
            ('UV/05m/UV05m_00062.sofa', 'f4e1b8d7137be6ac19b0d56057b31190'),
            ('UV/05m/UV05m_00063.sofa', 'b12eddfe246c8bb0757e9a7f015f9b7c'),
            ('UV/05m/UV05m_00064.sofa', '1963fecbde6b41da0068d643eefb4cf1'),
            ('UV/05m/UV05m_00065.sofa', '19391cdbb5060068fdb9ba9b54b44310'),
            ('UV/05m/UV05m_00068.sofa', 'ab303f5d4d0b92e4eeea83bb22c565e2'),
            ('UV/05m/UV05m_00069.sofa', '30c6d4070a232a5aaa7cb54962d66bd9'),
            ('UV/05m/UV05m_00071.sofa', 'a56c7e7150a17b35ee1d6ff700c43b61'),
            ('UV/05m/UV05m_00072.sofa', 'bc782737ab52cc4b44800a49874070a2'),
            ('UV/05m/UV05m_00074.sofa', '88ea03d769ee804705c7e9ff3ed966bc'),
            ('UV/05m/UV05m_00076.sofa', '119470b5e9efa94ba63d833f0fdcca44'),
            ('UV/05m/UV05m_00078.sofa', '5adf12f3eb2225a4ffcff57e0eb404cc'),
            ('UV/05m/UV05m_00079.sofa', '9c756f45a96086a6920f58ff0f8b1e97'),
            ('UV/05m/UV05m_00082.sofa', 'd5d143108030c5303bd88a7a9f976e2f'),
            ('UV/05m/UV05m_00083.sofa', '06c34a7f1b5c1a0f55120983bfb7f701'),
            ('UV/05m/UV05m_00085.sofa', '67762890fd36008736af0a0af2302ab3'),
            ('UV/05m/UV05m_00086.sofa', '7df66d5870980fb8d913662a8f2544e7'),
            ('UV/05m/UV05m_00087.sofa', '688388370f36969f364aa51f57aaeb80'),
            ('UV/05m/UV05m_00089.sofa', '7670780124a01edd3553d1982fd8c60b'),
            ('UV/05m/UV05m_00090.sofa', 'f24eecb92015cad4de754ab99e189d78'),
            ('UV/05m/UV05m_00092.sofa', '49d64af0b260ac32bd6e0d517905672b'),
            ('UV/05m/UV05m_00095.sofa', 'c34ad1ad97d3aaeffbf6bc2d7ead4347'),
            ('UV/05m/UV05m_00097.sofa', 'f5085b70a62589dc9ab4e53d96fba1e1'),
            ('UV/05m/UV05m_00099.sofa', 'd2eabdda5c7b0fd6b172d1adf7273dad'),
            ('UV/05m/UV05m_00100.sofa', 'ba72b7dbbd9555317e5aceb807195635'),
            ('UV/05m/UV05m_00101.sofa', '013876c3956429464f3c341f7f6ec7cd'),
            ('UV/05m/UV05m_00103.sofa', 'd45f93a37fa8c1d6ef0a998e93af5c64'),
            ('UV/05m/UV05m_00104.sofa', 'b77eb5c44ef4e6409c42de88afcd1d49'),
            ('UV/05m/UV05m_00107.sofa', '76fd211a8b2d580d238063b7e0e48ada'),
            ('UV/05m/UV05m_00108.sofa', 'b2024e657185d171d1ec7dd45f88e48e'),
            ('UV/05m/UV05m_00109.sofa', 'c7de2a85c4944fb69cd1ee4f4d2c3f7f'),
            ('UV/05m/UV05m_00110.sofa', 'dac221beddf84b71c3ebb571325d33ca'),
            ('UV/05m/UV05m_00111.sofa', '38c4a2f88ad0dcd531cb17b6411f0b53'),
            ('UV/05m/UV05m_00112.sofa', '293ed35edc395e9291a683fc6f0f2db3'),
            ('UV/05m/UV05m_00113.sofa', '558f5d47e47a644e81d8045c21503c7f'),
            ('UV/05m/UV05m_00114.sofa', '36443eeac25cf451dcdfb00bb3e703e7'),
            ('UV/05m/UV05m_00118.sofa', '611c5eb9e86c2f5d563f4e10e1400319'),
            ('UV/05m/UV05m_00119.sofa', 'f8d0b703b37865cef49c253e36dd48a4'),
            ('UV/05m/UV05m_00120.sofa', 'a9dd08944d3e538cd7a74442e8764c2f'),
            ('UV/05m/UV05m_00121.sofa', 'bfb62b036e673c49eca6d7af2576d70c'),
            ('UV/05m/UV05m_00125.sofa', '5574e95a473fa305a0d4ca0832892a9f'),
            ('UV/05m/UV05m_00126.sofa', '2737d6bb138295817b716ddf70344b0f'),
            ('UV/05m/UV05m_00127.sofa', 'c17b14bc80d937e3f7d137466433b74e'),
            ('UV/05m/UV05m_00128.sofa', 'c88fd25033ed5465c622eefcca63e183'),
            ('UV/05m/UV05m_00130.sofa', '69a72adba605f2ea2cbd498bb7d22b49'),
            ('UV/05m/UV05m_00131.sofa', '93f42fb9f831cabf871cb042c3804001'),
            ('UV/05m/UV05m_00132.sofa', '6e0ecaa3009d15d82fd36082e7031570'),
            ('UV/05m/UV05m_00133.sofa', '4b27f2c18dabc969cdcc8790265cd2ae'),
            ('UV/05m/UV05m_00136.sofa', '2b0c2cc55e8aa6d1622d661fd8bd6775'),
            ('UV/05m/UV05m_00137.sofa', '7a185ed8188758715a255a9a9e3cb714'),
            ('UV/05m/UV05m_00139.sofa', 'd9e312a90e6d448428f8699705d5c175'),
            ('UV/05m/UV05m_00140.sofa', '1aed81c195b6ecd05ca78e010a4071aa'),
            ('UV/05m/UV05m_00142.sofa', '509cdcc67a77be5d3aa458c47735ac61'),
            ('UV/05m/UV05m_00145.sofa', '0a62fbd985fb40c7b4f700cf337f146e'),
            ('UV/05m/UV05m_00146.sofa', '56ba81f0fdb157cdbecb891b48af0705'),
            ('UV/05m/UV05m_00147.sofa', '7adf75746d1479d1bcd14f1634fd11b2'),
            ('UV/05m/UV05m_00148.sofa', 'de03e48756481b7c3ac271c71e33452b'),
            ('UV/05m/UV05m_00149.sofa', 'e59bea1e3d989d937fe01c523c6d4633'),
            ('UV/05m/UV05m_00150.sofa', 'b125f50afa4ffdfd90c78207e327c4d6'),
            ('UV/05m/UV05m_00152.sofa', '4a561578484c774d745c74792c552612'),
            ('UV/05m/UV05m_00153.sofa', '8a8d6edd91d419cc180003559e208fe8'),
            ('UV/05m/UV05m_00154.sofa', '6917e3d83c5979701710f9bc070a4a8e'),
            ('UV/05m/UV05m_00155.sofa', '0303a60c224082a9d8b431b665f60a04'),
            ('UV/05m/UV05m_00156.sofa', 'a0dd207ad8b62b84461fff1f7de5a88a'),
            ('UV/05m/UV05m_00157.sofa', '4151c324e7b66c3253d3a606d29b73f5'),
            ('UV/05m/UV05m_00158.sofa', 'ff140e63e59b50d2229f307f17e6af1b'),
            ('UV/05m/UV05m_00159.sofa', '3834df9bda707514123a69a465aeaea2'),
            ('UV/05m/UV05m_00161.sofa', '38cfa5fd5821ea18aa7331b7c0014a8e'),
            ('UV/05m/UV05m_00164.sofa', '8a4728ed60376dc556edf3fd45718a9a'),
            ('UV/05m/UV05m_00165.sofa', '4bfa74109f4cd02949ac7297218f656d'),
            ('UV/05m/UV05m_00166.sofa', 'c5543fd877f7cd6adb4448c65b3bb06d'),
            ('UV/05m/UV05m_00168.sofa', '46b4b8c294399ca8d0ceec6047d77699'),
            ('UV/05m/UV05m_00169.sofa', '2d816014bc880d89c8e2680adb362b04'),
            ('UV/05m/UV05m_00170.sofa', 'b10c7f51b9beb18e8243e7311f42b0e1'),
            ('UV/05m/UV05m_00171.sofa', 'f3a7a9cef390e47b16bb75441c57a4ef'),
            ('UV/05m/UV05m_00173.sofa', '9157bb241a819dc39748d97bbdd4d43c'),
            ('UV/05m/UV05m_00175.sofa', 'd0f14a2e00754b88d49f2c14e8d59674'),
            ('UV/05m/UV05m_00176.sofa', '2ed88d2cb3aedf821149826d7fe9a7fb'),
            ('UV/05m/UV05m_00177.sofa', '0b3319ca0b006fbf3176a2e4755c9c58'),
            ('UV/05m/UV05m_00178.sofa', 'bb7584cd8c8dce5d8f15cc817de51374'),
            ('UV/05m/UV05m_00179.sofa', '703b604a27856be42ab068c8ba802f51'),
            ('UV/05m/UV05m_00183.sofa', '5a4155b8df0aeab28c03243d6910873f'),
            ('UV/05m/UV05m_00184.sofa', 'a917492301dbc6949f51d82b4d85e5af'),
            ('UV/05m/UV05m_00185.sofa', 'ad797be5fe046111edffebe2d49c182e'),
            ('UV/05m/UV05m_00186.sofa', '9bd1db7a1c8804759f06b0b31e123630'),
            ('UV/05m/UV05m_00188.sofa', '7cca8641b4c483ba88b391e1fd11b8ea'),
            ('UV/05m/UV05m_00189.sofa', '03eb774fff576f75708364feea98d523'),
            ('UV/05m/UV05m_00190.sofa', '8da35a270d328bdfc21970a2bfa51b7a'),
            ('UV/05m/UV05m_00191.sofa', '8db4838c94696904fcd2a2e10a2339e0'),
            ('UV/05m/UV05m_00194.sofa', '20c6f7f6559cb80294d7104285426555'),
            ('UV/05m/UV05m_00195.sofa', '898be4b55c78ecfd89d07963bdd1d91b'),
            ('UV/05m/UV05m_00196.sofa', 'eb36c634100fbed197ec878c7b4f8210'),
            ('UV/05m/UV05m_00197.sofa', 'ba7301e724b4e80cfe0d9dc365fbfbf3'),
            ('UV/05m/UV05m_00198.sofa', '024cbc63a8f79a43bd8e01c373fbe19e'),
            ('UV/05m/UV05m_00201.sofa', '17a24ff6f6e253b86729bcb0c3949ae2'),
            ('UV/05m/UV05m_00203.sofa', '466d21e223753202b83fcc54a0f38d2d'),
            ('UV/05m/UV05m_00204.sofa', 'bf87f332b495e7f5bf37b2d74c6be121'),
            ('UV/05m/UV05m_00205.sofa', '63fc5e86af415cf0315ac5b196b8c578'),
            ('UV/05m/UV05m_00206.sofa', '8ecfd48f82dac83679d0f7d502a97172'),
            ('UV/05m/UV05m_00209.sofa', '95f0e7b13a000f87014fe267c74c185d'),
            ('UV/05m/UV05m_00210.sofa', 'd8feb3be970aa1e3debc2475a721a7d7'),
            ('UV/05m/UV05m_00211.sofa', '53fd4868a7b165f6f61d50749d6376ef'),
            ('UV/05m/UV05m_00212.sofa', 'eee301d46edc519353a34e48a4c5e8e5'),
            ('UV/05m/UV05m_00213.sofa', '41f8c8afaf2cdcd383fabba9aa984ef7'),
            ('UV/05m/UV05m_00214.sofa', '063b124bebcbacbb0aaf279a6015cf1e'),
            ('UV/05m/UV05m_00215.sofa', '08ac6114f0774ce6b012e3346b430adc'),
            ('UV/05m/UV05m_00216.sofa', 'e35e8408b6e081466b5ca35ebf805573'),
            ('UV/05m/UV05m_00217.sofa', '3bc397238acfba140862da41914514d9'),
            ('UV/05m/UV05m_00219.sofa', 'aa6144b84de897bc92561b51a51f5b59'),
            ('UV/05m/UV05m_00220.sofa', '585cf5256ddc35d6ac6f70556b2713af'),
            ('UV/05m/UV05m_00221.sofa', '9d56b5761a924c447b0b85c18fecaba4'),
            ('UV/05m/UV05m_00222.sofa', '7e1341f62039904f7406e95ef25f3a1b'),
            ('UV/05m/UV05m_00223.sofa', 'c014670d12590711541d2a81579c7574'),
            ('UV/05m/UV05m_00224.sofa', '1470b42c327a524fdd6d9363257c698a'),
            ('UV/05m/UV05m_00225.sofa', '9ad6511305653ce63ea21f2e27d99a9d'),
            ('UV/05m/UV05m_00226.sofa', '75ba1eac1202a2847edbb6523b9cee94'),
            ('UV/05m/UV05m_00227.sofa', '922b7a130c0f62d281764c4ced93f975'),
            ('UV/05m/UV05m_00228.sofa', '7c7ad7d4bc15cdb5e4cb592957e070f1'),
            ('UV/05m/UV05m_00229.sofa', 'a6aeeb4c2dbb5a65876a6d1241161799'),
            ('UV/05m/UV05m_00230.sofa', 'cb2b08a05e5bf3368337237b5a620c3c'),
            ('UV/05m/UV05m_00231.sofa', 'ee9fe0740ab3e10b929f1ffdfa2f361b'),
            ('UV/05m/UV05m_00232.sofa', 'b42c53c0ec006c229b5d1fc2dca2b153'),
            ('UV/05m/UV05m_00233.sofa', '6679f61261b43701e4fb535027649b8c'),
            ('UV/05m/UV05m_00234.sofa', 'c659b620dd1eafcc7208d4c713e22461'),
            ('UV/05m/UV05m_00235.sofa', '3eaf9334721bf7220c98ef4114f6fa86'),
            ('UV/05m/UV05m_00236.sofa', '607e6eaef99c7c60b90e559fcc848835'),
            ('UV/05m/UV05m_00237.sofa', '32d25407575687811a8a58c94fedf86c'),
            ('UV/05m/UV05m_00238.sofa', 'e3154072d258a192cba634e61897f649'),
            ('UV/05m/UV05m_00239.sofa', '80f3643534d816f52ad66fdf4c74eb21'),
            ('UV/05m/UV05m_00240.sofa', '5ffd413df561e9204baeccfd95c5e5c5'),
            ('UV/05m/UV05m_00241.sofa', '45c5a1fb4ccf188a4c28ed4757691041'),
            ('UV/05m/UV05m_00244.sofa', '3cf65cef15e467378e8a8d9001732add'),
            ('UV/05m/UV05m_00245.sofa', '63434c0451f47fe223ff4f475c417103'),
            ('UV/05m/UV05m_00246.sofa', '61e2d1c4d556edceead623ab97ae7f34'),
            ('UV/05m/UV05m_00247.sofa', 'a027d5307e438e7b92bc2cc3537dc2df'),
            ('UV/05m/UV05m_00248.sofa', '19c94e076e2334a652170075e0275a5f'),
            ('UV/05m/UV05m_00251.sofa', '08dada0ef3742770b02f404f0a9e4ba7'),
            ('UV/05m/UV05m_00252.sofa', 'ccb6fd666319f60c6ce96863b4eff9e2'),
            ('UV/05m/UV05m_00253.sofa', 'd27229d12f073523e4327c83cbdfb945'),
            ('UV/05m/UV05m_00254.sofa', '792c2b701e2f34b600a7366a1de7fdec'),
            ('UV/05m/UV05m_00256.sofa', '5cad215bf5d89a231ca000dffafab68f'),
            ('UV/05m/UV05m_00258.sofa', '908d3db2f8b7a59a48a637a2edb6480b'),
            ('UV/05m/UV05m_00259.sofa', '390c2146c35360ab3ed664102d5d7c5a'),
            ('UV/05m/UV05m_00261.sofa', 'd73572ecc29a836394637f506aceb300'),
            ('UV/05m/UV05m_00262.sofa', '553f2ac959d4c1c971bef12a3546b528'),
            ('UV/05m/UV05m_00263.sofa', 'c90d3dcd1837f9541f70bc174c0649dc'),
            ('UV/05m/UV05m_00264.sofa', '1df3275418f660eab23d0ea5472921fd'),
            ('UV/05m/UV05m_00265.sofa', 'e1207dee0ee78c8dd990a0f856f3375e'),
            ('UV/05m/UV05m_00268.sofa', '5cd84256ebb739aac4495cf91b16f97b'),
            ('UV/05m/UV05m_00269.sofa', 'a0bdce1140812b7f2a18ebf0a9aff540'),
            ('UV/05m/UV05m_00270.sofa', 'e3e96d9a7465fb75c8fae4d1c543d89a'),
            ('UV/05m/UV05m_00271.sofa', '95de2175cb895ba957dd030ba47bcfdd'),
            ('UV/05m/UV05m_00272.sofa', '61147e99df6ff1aae4c597105a91b6af'),
            ('UV/05m/UV05m_00273.sofa', '2182cfee7ddb1266af1fcb2084cc89e8'),
            ('UV/05m/UV05m_00275.sofa', 'de4e595eed924c4e915125d42826f5f3'),
            ('UV/05m/UV05m_00276.sofa', '05acdff8f3f5c87ea34a34fbe644acdf'),
            ('UV/05m/UV05m_00277.sofa', 'c3f4ad5e48ba5fcf5538f9e0d0c8bcf6'),
            ('UV/05m/UV05m_00278.sofa', '2ee9990f8081f4882c2c66bf27698e63'),
            ('UV/05m/UV05m_00279.sofa', 'dc694fb13822b4f9936ad2616c20d12b'),
            ('UV/05m/UV05m_00281.sofa', 'f32a14b16c9762c5ce60649fe5211d2f'),
            ('UV/05m/UV05m_00283.sofa', '896c4be3cf0f01b0c218a1eca856d9ee'),
            ('UV/05m/UV05m_00284.sofa', '09153f8c9b674301425dc719bc10a616'),
            ('UV/05m/UV05m_00285.sofa', 'c659b33860dd5b30c42d9b56a6470329'),
            ('UV/05m/UV05m_00286.sofa', '8546ebb7f12763c6495a22c951d0d893'),
            ('UV/05m/UV05m_00287.sofa', '1b7615fbe38befccce337c4125096e80'),
            ('UV/05m/UV05m_00288.sofa', 'c68749ec2df2346c9c1c74098cd7e92a'),
            ('UV/05m/UV05m_00289.sofa', '19db4b62465326a740b98491d227fe3d'),
            ('UV/05m/UV05m_00290.sofa', '28ef24d6e8c675820e4cd699f3b7575e'),
            ('UV/05m/UV05m_00291.sofa', '013537687a064dd2abcae35f5eb9e65f'),
            ('UV/05m/UV05m_00293.sofa', '26b1115f6faee153c685be6b3af811ce'),
            ('UV/05m/UV05m_00294.sofa', '374c7d6b8d6561b16287df4f36f64245'),
            ('UV/05m/UV05m_00295.sofa', '99a9dc452358df4094fca689e755756a'),
            ('UV/05m/UV05m_00296.sofa', 'f4ba2e648b4f6c8d91b4a7f634b1dc78'),
            ('UV/05m/UV05m_00297.sofa', '8545d095444bdab8069bf14e138ab8a5'),
            ('UV/05m/UV05m_00298.sofa', '2997a531cc901daa3bcbbe3dc377601d'),
            ('UV/05m/UV05m_00301.sofa', '43db5230b81fee76a17a68ba9d3cbc3f'),
            ('UV/05m/UV05m_00303.sofa', '7094b57d3336999c8566eb93cc82c77b'),
            ('UV/05m/UV05m_00305.sofa', 'f14636946b8389151f545b827f8d0777'),
            ('UV/05m/UV05m_00306.sofa', 'b9abe9419e16e78a182cad9fa88f5ff0'),
            ('UV/05m/UV05m_00307.sofa', '826f672d199e0ebedf74a6e96a4656c0'),
            ('UV/05m/UV05m_00308.sofa', 'a4fbc96a5920081d25e1ee61c142808b'),
            ('UV/05m/UV05m_00309.sofa', '59cdf409397401acd71c866cbda37a7c'),
            ('UV/05m/UV05m_00311.sofa', '134e403d081ea835d4b5d8802de74306'),
            ('UV/05m/UV05m_00315.sofa', 'e307bdc8d02956c253cd4303df16517b'),
            ('UV/05m/UV05m_00318.sofa', '4130161c3606f3f70ae4262b85bef664'),
            ('UV/05m/UV05m_00319.sofa', 'bc49648278a110aab1d746a9095430f9'),
            ('UV/05m/UV05m_00320.sofa', '81734a7801ef62d717d034e1fcaf533e'),
            ('UV/05m/UV05m_00321.sofa', '8c48db59993a527fcf1b80583b26296a'),
            ('UV/05m/UV05m_00322.sofa', '45c74161d7cc21f6b9f934ad843b2b71'),
            ('UV/05m/UV05m_00323.sofa', '1174adf07cc17f80d1a160fe885cba0a'),
            ('UV/05m/UV05m_00326.sofa', '9801f5fcb539f728d30d19f1c4d7f2ab'),
            ('UV/05m/UV05m_00328.sofa', 'f245e22f7a3d585ced3ff59b8febb690'),
            ('UV/05m/UV05m_00329.sofa', '0ca8acbf4d25123b5da24b71c757ea24'),
            ('UV/05m/UV05m_00331.sofa', '15252ecb6d8c6cfe7a50827cce6cb465'),
            ('UV/05m/UV05m_00332.sofa', '445ac83857d753a6fadd50768912cf6c'),
            ('UV/05m/UV05m_00333.sofa', '7dd1aa527cc099d6292d1c5dab7bbe8a'),
            ('UV/05m/UV05m_00334.sofa', 'c3e996bd8f9b6b93596ea73d5748b94d'),
            ('UV/05m/UV05m_00335.sofa', '2403d0cfc60290c06e0b9b5a0c74ba32'),
            ('UV/05m/UV05m_00336.sofa', '0f3ae141f16065579cfe8ae365483f39'),
            ('UV/05m/UV05m_00337.sofa', 'e93afe2862e5796d2011a304585a1c00'),
            ('UV/05m/UV05m_00338.sofa', '79f2cb5020257f1d065281035522c7a8'),
            ('UV/05m/UV05m_00340.sofa', '97ff58e5fea0ef0758ed3c4e8ef7745b'),
            ('UV/05m/UV05m_00341.sofa', '724881dca5d50ca92708e144af64db97'),
            ('UV/05m/UV05m_00343.sofa', 'c7c9040360fe71fd1207efad57e8e5ed'),
            ('UV/05m/UV05m_00344.sofa', '7fcfe8aceb699e8c1c454b705387ac16'),
            ('UV/05m/UV05m_00345.sofa', 'a645482a6505a2bc0ff4c056dd563077'),
            ('UV/05m/UV05m_00347.sofa', '82d452387370a108351fa8832acdbe0d'),
            ('UV/05m/UV05m_00348.sofa', '5a9c4d5bedbf9fe016b43cbaa5cf7977'),
            ('UV/05m/UV05m_00349.sofa', '739b1c044183a46318acecc069b649cc'),
            ('UV/05m/UV05m_00350.sofa', 'b7b6559aba36c62b55df5c1d8b0da598'),
            ('UV/05m/UV05m_00351.sofa', 'b5f8fc8deac6ee963013d8cf33f70883'),
            ('UV/05m/UV05m_00352.sofa', 'b54999c7039ae93cbd3c76a1342fa59b'),
            ('UV/05m/UV05m_00353.sofa', '484dead82523f0ab885ef07f4923b3cf'),
            ('UV/05m/UV05m_00354.sofa', '5c4e59e689f226ddf3f41b3d7af6dda8'),
            ('UV/05m/UV05m_00355.sofa', '336b24bf057dc393f367e1afcd16f26e'),
            ('UV/05m/UV05m_00356.sofa', 'ff982825c90bee186701581e464e9da5'),
            ('UV/05m/UV05m_00358.sofa', '876bdf350eee6eae864bb3b4a07743ba'),
            ('UV/05m/UV05m_00359.sofa', '33fd439124986c243b465c0dd978b57f'),
            ('UV/05m/UV05m_00360.sofa', 'ef5621030c106b91d9aafe1ce4ddf962'),
            ('UV/05m/UV05m_00361.sofa', '8d6abd660b147eae904a17b6812b45de'),
            ('UV/05m/UV05m_00362.sofa', 'c5f224574846da099a1f04dc536bd243'),
            ('UV/05m/UV05m_00363.sofa', '1e6378b87f164839a30d0a23b917d4fb'),
            ('UV/05m/UV05m_00364.sofa', 'd270c2fe55070b36400763316415e14d'),
            ('UV/05m/UV05m_00365.sofa', '70a5bbbec5aa670b98b2d33b4385a48f'),
            ('UV/05m/UV05m_00366.sofa', '0279852f6812a8f6accc1b44ea1e4e13'),
            ('UV/05m/UV05m_00367.sofa', 'd9a0fec4ea42f291fd97b89339d4b2eb'),
            ('UV/05m/UV05m_00368.sofa', 'ea4738d556084f6901bfa5aaf0f6584b'),
            ('UV/05m/UV05m_00370.sofa', 'd350d10a430f3cb45ee63e2472b2f17b'),
            ('UV/05m/UV05m_00371.sofa', 'a18b2161ad50eed7639a0c162690ffff'),
            ('UV/05m/UV05m_00372.sofa', 'c2697ed1e49e9df807f7854b158a8cf7'),
            ('UV/05m/UV05m_00373.sofa', '38ccae445b9fb4e5c045995d211ebbb7'),
            ('UV/05m/UV05m_00374.sofa', '2d2f94c1fdec793497847f82af883cb5'),
            ('UV/05m/UV05m_00375.sofa', '9af14f27226f0583dc3023226de92f35'),
            ('UV/05m/UV05m_00376.sofa', '2805a6d326de182110bed28ffc480e07'),
            ('UV/05m/UV05m_00378.sofa', '2acb4071d5c38f4f5a4823b357ce825f'),
            ('UV/05m/UV05m_00379.sofa', '389b0220accbc5deb609e8ce5f6b9f8d'),
            ('UV/05m/UV05m_00382.sofa', '414b16a2d6e757ca2285165630ddc66e'),
            ('UV/05m/UV05m_00383.sofa', '4caaed55122c6ef6c76889b94e992249'),
            ('UV/05m/UV05m_00385.sofa', 'a90087a89d1385f6503fb63ade750c32'),
            ('UV/05m/UV05m_00386.sofa', '78115f7cb9e912b9af72e3dff22ada52'),
            ('UV/05m/UV05m_00389.sofa', 'fda7f9ecfddad4f4881c15179548a5c4'),
            ('UV/05m/UV05m_00391.sofa', '2e58ac84efadf9294db70de03b5afce5'),
            ('UV/05m/UV05m_00392.sofa', '168fed98971804ba5f7e36c00131a179'),
            ('UV/05m/UV05m_00395.sofa', '8b1c56db42690fea0249bb0374a5221c'),
            ('UV/05m/UV05m_00397.sofa', '1c87a4908a83e2cc04bc5699ba06338a'),
            ('UV/05m/UV05m_00398.sofa', '4dd96994e7bc3eb76f54b90fdaea2a6e'),
            ('UV/05m/UV05m_00399.sofa', 'db5cbf74ca37eb0644cb19b7710d0255'),
            ('UV/05m/UV05m_00401.sofa', '3b6ab2f1d3743590a39f01de745b048c'),
            ('UV/05m/UV05m_00402.sofa', '473c510c9d93b87fe8d82d6379598ad3'),
            ('UV/05m/UV05m_00403.sofa', '7f0d9f81138d65ff2c666cd9aa7ddc65'),
            ('UV/05m/UV05m_00404.sofa', '6d52cec43160ea9414a37a176451eaa5'),
            ('UV/05m/UV05m_00405.sofa', 'd6fe37a953226a593476e3164a188600'),
            ('UV/05m/UV05m_00406.sofa', 'e1af7b82e77853d507b36c1a01a5d433'),
            ('UV/05m/UV05m_00407.sofa', '144476fddc8e3a197724a488615589e4'),
            ('UV/05m/UV05m_00408.sofa', '56517f22e9d96491867c6038e0ac8b19'),
            ('UV/05m/UV05m_00409.sofa', 'f3bd5671f2a783abd94f2a2ad1bf30c8'),
            ('UV/05m/UV05m_00410.sofa', '87f2d4658e37f53e52dae9cd59d96308'),
            ('UV/05m/UV05m_00411.sofa', '2d6ab065f223cf0b7b41bdbcbaddeb37'),
            ('UV/05m/UV05m_00412.sofa', '66a83284ca5f136ca0579d7d57253e8b'),
            ('UV/05m/UV05m_00413.sofa', 'f844cbda6194692365967bc45911f510'),
            ('UV/05m/UV05m_00414.sofa', 'b33ebb26f78c555b54439aa02709b556'),
            ('UV/05m/UV05m_00415.sofa', '88a5d0cbac70ec5506499437c118a7e5'),
            ('UV/05m/UV05m_00416.sofa', '080eedc2daed9f2f21d8f0ae64d4ab03'),
            ('UV/05m/UV05m_00417.sofa', 'b622b14f84245dfbf21317535d61d163'),
            ('UV/05m/UV05m_00418.sofa', '67e52c30386b6030a78339b2fbeee404'),
            ('UV/05m/UV05m_00419.sofa', '3c7020a0f96c0ee0d941a1018127f1e7'),
            ('UV/05m/UV05m_00420.sofa', 'd082585930edc2ec7d39bc1fbdf76e70'),
            ('UV/05m/UV05m_00421.sofa', '733a1adbd8306f01dc7eb754d18a6fee'),
            ('UV/05m/UV05m_00422.sofa', 'a6fec125cd4276ff61377587c3a062cc'),
            ('UV/05m/UV05m_00423.sofa', '9ddaa8a1469426d722f4a11ab53f9b17'),
            ('UV/05m/UV05m_00426.sofa', 'b85e940c0c38b864919c53fe306fed2e'),
            ('UV/05m/UV05m_00427.sofa', 'd609c817995cd061f04a08485c94abc8'),
            ('UV/05m/UV05m_00428.sofa', '655ecc96d69e9f95586d417214195de8'),
            ('UV/05m/UV05m_00430.sofa', '538505996bd27d5ef681d8a9c6108b2b'),
            ('UV/05m/UV05m_00432.sofa', 'cb9991c9abe5aa428965bb6889efa2e1'),
            ('UV/05m/UV05m_00433.sofa', 'c133d8bdebaa69322767f868da81ee70'),
            ('UV/05m/UV05m_00434.sofa', '4e5f7569d51a7a980a56ba65f5a08333'),
            ('UV/05m/UV05m_00441.sofa', 'f15870727d0ce626891492fd83bd0bee'),
            ('UV/05m/UV05m_00442.sofa', '1b152b64f1c99e4f4b6a0cec3f6f329a'),
            ('UV/05m/UV05m_00443.sofa', '87692bace77c0dc44c76f2bb5daf3fbb'),
            ('UV/05m/UV05m_00446.sofa', '150a08f77523012455e3b266f5f04806'),
            ('UV/05m/UV05m_00448.sofa', '77b5d56c15e5a09481af5357487b3e9c'),
            ('UV/05m/UV05m_00449.sofa', '516b47a2e1182d0b6b14f3f45686cf2a'),
            ('UV/05m/UV05m_00450.sofa', 'b06a8d37b52e0fbfce0578914e0a88eb'),
            ('UV/05m/UV05m_00451.sofa', '0819bc72358f98fbcf8abca85e299aef'),
            ('UV/05m/UV05m_00452.sofa', '5ea718f2cf770474be02b9860510205f'),
            ('UV/05m/UV05m_00455.sofa', 'bead32da8006d6107f99e00f602e62b0'),
            ('UV/05m/UV05m_00456.sofa', '0241e694a840dcfaec8aab884f3f4b41'),
            ('UV/05m/UV05m_00457.sofa', 'b09aeb8f39718c628fc5a667baad945e'),
            ('UV/05m/UV05m_00459.sofa', 'ee5e4fae7fefe2bd077e50712cc72174'),
            ('UV/05m/UV05m_00460.sofa', '8780a072cffbc22e7361df60f7b9a5b2'),
            ('UV/05m/UV05m_00461.sofa', '69db752ffcc794cc60a51aebdceaf5c6'),
            ('UV/05m/UV05m_00462.sofa', 'a2424eeb88aa9e2617d4ec623e4d741b'),
            ('UV/05m/UV05m_00463.sofa', '51088ae676f45d9fd11e97374b9692ac'),
            ('UV/05m/UV05m_00464.sofa', 'c3b3a2227e71af18b19527eacc6dd1c2'),
            ('UV/05m/UV05m_00466.sofa', '2f20b2addc74eae4567779efbf6d0625'),
            ('UV/05m/UV05m_00467.sofa', 'e4dc8ed55fb1bd5ba52ab0474934c042'),
            ('UV/05m/UV05m_00468.sofa', '6e15d43874f047af22f4ceb94369d509'),
            ('UV/05m/UV05m_00469.sofa', 'f37682303d6c0addca29dee7b461bc13'),
            ('UV/05m/UV05m_00470.sofa', '2c95c50cb366857597047791dda2ea1e'),
            ('UV/05m/UV05m_00471.sofa', 'f081297e8c657710beaa5990b41e3f43'),
            ('UV/05m/UV05m_00472.sofa', 'a151e64fe470dc3c340fe9bbb9d1193b'),
            ('UV/05m/UV05m_00473.sofa', 'e96a9f573e78d56c42677483ca5c3442'),
            ('UV/05m/UV05m_00474.sofa', '7d73fffc7c75af9604667a169b377d2e'),
            ('UV/05m/UV05m_00476.sofa', '59832d90186382ce4edd8aa58422347b'),
            ('UV/05m/UV05m_00477.sofa', '6d61c04d22b6fafec42b8879fa0e477e'),
            ('UV/05m/UV05m_00478.sofa', 'c6437d6648fdc57890585c8820c200b1'),
            ('UV/05m/UV05m_00480.sofa', 'afa83e70bad320e4e1ec9c47dee83e87'),
            ('UV/05m/UV05m_00481.sofa', 'b5d1c4d0132f902dbcf5e9dbd9108012'),
            ('UV/05m/UV05m_00482.sofa', 'e27552167c4d76b88488333ad40086fd'),
            ('UV/05m/UV05m_00483.sofa', '23c7afcec1c001781d850d817b87fbc5'),
            ('UV/05m/UV05m_00484.sofa', 'cb5e582ee1fc6b6cc9b02b6782fb4f88'),
            ('UV/05m/UV05m_00486.sofa', '47d60be6460c8c7a7e627e02a4bb4457'),
            ('UV/05m/UV05m_00487.sofa', 'ea469f1995f30d7a00c22ea627b4b561'),
            ('UV/05m/UV05m_00489.sofa', 'd2a4df74da28647afe15c5ec7dae13fa'),
            ('UV/05m/UV05m_00490.sofa', 'ff91e20edfe9a3a13c9283d43670f7df'),
            ('UV/05m/UV05m_00491.sofa', '6b110d2e4b3b2b4fba55e47146958bf3'),
            ('UV/05m/UV05m_00493.sofa', '79eef56b3f1ceeebdf69e929311506d2'),
            ('UV/05m/UV05m_00494.sofa', 'b4c8a66603a7754dabed3cf0e5d473d3'),
            ('UV/05m/UV05m_00497.sofa', '27ffd92c98342ec372d57a90bfd7cd15'),
            ('UV/05m/UV05m_00499.sofa', 'c18d7803849fba317696de5fd2ac113e'),
            ('UV/05m/UV05m_00500.sofa', 'cba45f33ce2e5a5375aca097f24e954e'),
            ('UV/05m/UV05m_00501.sofa', 'b34160f78a64483cb2a83a73ed6b861d'),
            ('UV/05m/UV05m_00502.sofa', 'e39bdb3e3b567464664015142275e8da'),
            ('UV/05m/UV05m_00503.sofa', 'fc4996bd7f3b2a8b5c97a82dbe081572'),
            ('UV/05m/UV05m_00505.sofa', '1a56bf1a882044ec9d8a80a4b807d3bc'),
            ('UV/05m/UV05m_00506.sofa', 'ff67a764f5e20abad13a0a0dbd06345c'),
            ('UV/05m/UV05m_00507.sofa', '7d94db3352bb21aa7950b508d74451de'),
            ('UV/05m/UV05m_00508.sofa', '4f4308e03b5e891eb8baff551b46d0c8'),
            ('UV/05m/UV05m_00509.sofa', 'c68124d101857c7905c9b650cf7868ce'),
            ('UV/05m/UV05m_00511.sofa', '6bee2b9fee71586915479adaae9f89e1'),
            ('UV/05m/UV05m_00512.sofa', '583ff31ce8f9aa88eb43cf7a0a733d9a'),
            ('UV/05m/UV05m_00513.sofa', 'bf00a93580e3c82c189699aec8de2ab4'),
            ('UV/05m/UV05m_00514.sofa', '6d38e52b6e4116277f9a262be1343d5f'),
            ('UV/05m/UV05m_00515.sofa', 'da9ebe32a1cb138ca2dfb802a553e97a'),
            ('UV/05m/UV05m_00516.sofa', 'a92f1cf5b4598dc2ddb1be6a42be20d2'),
            ('UV/05m/UV05m_00517.sofa', 'c5ef684fa8470e094712c7b9f60fdc6a'),
            ('UV/05m/UV05m_00518.sofa', 'a80a4503cc7b1bb94687d8c0630706f2'),
            ('UV/05m/UV05m_00519.sofa', 'b92609b149d211a56b1cd0957ccfafcb'),
            ('UV/05m/UV05m_00520.sofa', '594e66d187a2f97e1f15ca5c09895464'),
            ('UV/05m/UV05m_00521.sofa', '9d1fbc011296577a69ccb944f81e9f5f'),
            ('UV/05m/UV05m_00523.sofa', 'da163fc1a04b0f57fa34af48e6bd1204'),
            ('UV/05m/UV05m_00524.sofa', '73a5c31bae43d1abe6628fecb0ae5a26'),
            ('UV/05m/UV05m_00525.sofa', 'd47ea109e8c2d9efdce0e05c9657db51'),
            ('UV/05m/UV05m_00526.sofa', 'df67fc1ff8d6b6cd0fb09ce3aafdb9a5'),
            ('UV/05m/UV05m_00527.sofa', '652018299ef2b0d05736aa14ce4486b5'),
            ('UV/05m/UV05m_00528.sofa', 'e570c9a70f0129edcb735f88f2fc8128'),
            ('UV/05m/UV05m_00529.sofa', 'b3838fd0b284f26b71e3b706237374f6'),
            ('UV/05m/UV05m_00530.sofa', '26bdc6a75208f038bb4c2c12bec1ec67'),
            ('UV/05m/UV05m_00532.sofa', 'ea942ab7290ca7b831e939748ce99ff3'),
            ('UV/05m/UV05m_00533.sofa', '575f58f6d66924ef1b8bb79023ef5b8b'),
            ('UV/05m/UV05m_00534.sofa', '6e43894b8c3fadcd4c1ab111b3f490b7'),
            ('UV/05m/UV05m_00536.sofa', '2717d6d4428fb8d0c9f5b264ebaeaa5a'),
            ('UV/05m/UV05m_00538.sofa', 'f575e2b4bb26de2e50ed04b540cb75e7'),
            ('UV/05m/UV05m_00539.sofa', '7125e51e894db012594d6dac76fbc589'),
            ('UV/05m/UV05m_00540.sofa', 'd1438f94b0aad837fea2f0b6f1587b97'),
            ('UV/05m/UV05m_00542.sofa', 'aba04c77bdff783cd31fea1ea870feea'),
            ('UV/05m/UV05m_00543.sofa', '4166706c29b971eb983a276dd3ea09e6'),
            ('UV/05m/UV05m_00544.sofa', 'cb7b2e916c021d62df82975e2e5cc6cf'),
            ('UV/05m/UV05m_00545.sofa', '8f0994c7264da3d3817d07f41d3655e0'),
            ('UV/05m/UV05m_00546.sofa', 'afbaadc414eb7a43fbdc8d0bcc12e2d1'),
            ('UV/05m/UV05m_00547.sofa', '51b30953cd14682f5ed0323b3d236c2d'),
            ('UV/05m/UV05m_00548.sofa', 'd8e5e01026b8778d0c89a89be52a5a10'),
            ('UV/05m/UV05m_00549.sofa', '30a8622faf3c4120c51f1e6de43cc3d6'),
            ('UV/05m/UV05m_00550.sofa', '5b17eb85941ca149069be53b3ab0b8d3'),
            ('UV/05m/UV05m_00551.sofa', 'f142cef86e0f13ee19f3cd4bf3aefb95'),
            ('UV/05m/UV05m_00552.sofa', 'ff97d46fa2c6b2de80864b5d736c58dc'),
            ('UV/05m/UV05m_00553.sofa', '29f2541dad59a0167d4172db06819378'),
            ('UV/05m/UV05m_00555.sofa', '96eb56c07917b8f09ecd2614dd18a152'),
            ('UV/05m/UV05m_00557.sofa', '0fd8221ee5e81e1bf931e000dc9a5b11'),
            ('UV/05m/UV05m_00558.sofa', '589f137bfc1ad48b613cef737335fdf7'),
            ('UV/05m/UV05m_00559.sofa', 'b0f2d5f4a53f790d7f051983b63baab4'),
            ('UV/05m/UV05m_00560.sofa', 'acc5ca4294d9d7d79fe85af27e54cbc5'),
            ('UV/05m/UV05m_00561.sofa', '29ad145d685d33b3bab45ba4fce8983b'),
            ('UV/05m/UV05m_00562.sofa', '32ef6b1c9b3042953e323e895ea85b8d'),
            ('UV/05m/UV05m_00563.sofa', '52c12dfe24099b6c6ff05f61a8c21b45'),
            ('UV/05m/UV05m_00567.sofa', '28c20814c211478e459a3f55a7c385b3'),
            ('UV/05m/UV05m_00568.sofa', '283086494bf228a451ad016852eb23ba'),
            ('UV/05m/UV05m_00569.sofa', 'ac243c6f9813ebc8362ed745e8371edb'),
            ('UV/05m/UV05m_00570.sofa', '2a9ae50cfe0d629158dfb486fbe1837a'),
            ('UV/05m/UV05m_00571.sofa', '5ada65aa1f883a89e94af03291ecbd8a'),
            ('UV/05m/UV05m_00572.sofa', '0cd75553c0a3a3b0e3559254146ef88f'),
            ('UV/05m/UV05m_00573.sofa', '8f0ec59841cd5ea646abda980302e648'),
            ('UV/05m/UV05m_00576.sofa', 'fe0bb68d4798489708cbdb58fbb0a77a'),
            ('UV/05m/UV05m_00577.sofa', '6e2b110a5b6d8825161a41a7b0d9192d'),
            ('UV/05m/UV05m_00580.sofa', '04b29bb79e039d6176d9e6565aa5dea6'),
            ('UV/05m/UV05m_00582.sofa', '8352854f0441f010cb991ad232cce268'),
            ('UV/05m/UV05m_00583.sofa', 'dc50a2df2209d3aca6acf9249b03c80a'),
            ('UV/05m/UV05m_00585.sofa', 'f3a24d617d38be286a2907260cd72be6'),
            ('UV/05m/UV05m_00588.sofa', '3b2bcaeb4571abf70762650e588d2fc6'),
            ('UV/05m/UV05m_00590.sofa', '45ce36dd63f7c472ce4a1371d947f77f'),
            ('UV/05m/UV05m_00591.sofa', 'ea470c880eb7c148ec8475c7d6fdbb06'),
            ('UV/05m/UV05m_00592.sofa', 'f7b10ff904355316b6384263629821c4'),
            ('UV/05m/UV05m_00593.sofa', '5a01670e8f69c38bf844eeb87c073f7f'),
            ('UV/05m/UV05m_00594.sofa', '13745369471df33bb9486f92c3d37a44'),
            ('UV/05m/UV05m_00595.sofa', '479a65b8ca80f595919fb210140300a5'),
            ('UV/05m/UV05m_00596.sofa', 'c2a839c744c15a8935f256bb47d57f10'),
            ('UV/05m/UV05m_00597.sofa', 'da585f60618f384fe936a21c805cbbd4'),
            ('UV/05m/UV05m_00598.sofa', 'a856f4eaa6b17e7b0a1b9478940dfaea'),
            ('UV/05m/UV05m_00599.sofa', '17947df1111c39d857667837846b5ec8'),
            ('UV/05m/UV05m_00600.sofa', 'd6b55f28c5e0e6c821fb44f3b0003dbc'),
            ('UV/05m/UV05m_00601.sofa', 'ed5c21e9584fd4879f29b3feaa5dceb7'),
            ('UV/05m/UV05m_00604.sofa', 'c9611b03929b4407e74e23c24ab7b020'),
            ('UV/05m/UV05m_00606.sofa', '87392d7201fdfabd8ef48ff6cec2048c'),
            ('UV/05m/UV05m_00608.sofa', 'b5d7573fb380ec2cf7e85b27f73557d9'),
            ('UV/05m/UV05m_00609.sofa', '5349bd12065fa5c96212361bb6c7bae6'),
            ('UV/05m/UV05m_00613.sofa', '53d7bfec659d1e25c09e6e5068d2ead3'),
            ('UV/05m/UV05m_00616.sofa', 'db9b0941e132c5c6f5cc292c8b5c2502'),
            ('UV/05m/UV05m_00617.sofa', '78f02ce8741106774854f589668de7a2'),
            ('UV/05m/UV05m_00618.sofa', '9f9a6474440f728a6daf709972768ee1'),
            ('UV/05m/UV05m_00619.sofa', 'cc79cd861595c40a4ae8a7eb39c6a809'),
            ('UV/05m/UV05m_00620.sofa', 'ae611e80865aa3a1de8e70a1e208ca31'),
            ('UV/05m/UV05m_00621.sofa', '8c3187cf182f21450f45df25a7cf61cc'),
            ('UV/05m/UV05m_00622.sofa', '4a7b4f755dcb426d70f728def32a404e'),
            ('UV/05m/UV05m_00623.sofa', 'c7b44b6a5453fa6fc1e25db05d265b9d'),
            ('UV/05m/UV05m_00624.sofa', 'fe1a301cbbf14832433229cf7348bcb1'),
            ('UV/05m/UV05m_00625.sofa', '49bb167cf754ae93730d13acaf99e641'),
            ('UV/05m/UV05m_00626.sofa', '33630659953432e7d15e0f52416f842e'),
            ('UV/05m/UV05m_00628.sofa', 'c51dd2d18678e85306b01c4e6e2082d3'),
            ('UV/05m/UV05m_00629.sofa', 'e2516110912dd7cb2d5273c7672e5d2d'),
            ('UV/05m/UV05m_00630.sofa', 'c7cadaae931f21d87673cc0efd625192'),
            ('UV/05m/UV05m_00631.sofa', 'd4cb7b0223816bc58b7ea7ae72264719'),
            ('UV/05m/UV05m_00632.sofa', '69f83f9fdabbd3dcd5d39a862be17aba'),
            ('UV/05m/UV05m_00633.sofa', '9b66b8e04ca563289732fe8daf008480'),
            ('UV/05m/UV05m_00634.sofa', '5b91de271b16a350cdbb19b57e7eb66e'),
            ('UV/05m/UV05m_00635.sofa', 'ceecaf7d099d2251b6ac894208ef83a8'),
            ('UV/05m/UV05m_00636.sofa', 'bf4e9f72817a360e8c0fbcb5a33ff5d2'),
            ('UV/05m/UV05m_00637.sofa', 'a06f77b02fcb366fba39126636a22165'),
            ('UV/05m/UV05m_00640.sofa', 'a30fef70610e321c02e178aae9c15549'),
            ('UV/05m/UV05m_00642.sofa', '1cab88a23af09a818c8a9e9f74c551c7'),
            ('UV/05m/UV05m_00643.sofa', 'bf9fa0d38c8fb9999fe0e41561d431e3'),
            ('UV/05m/UV05m_00644.sofa', '6a236003391a112048e431ec25149fb1'),
            ('UV/05m/UV05m_00645.sofa', '73ae9b4c3755d40b7662aecc2eae9c45'),
            ('UV/05m/UV05m_00646.sofa', '8864ccb4f320b11c3d063a9c7a94d169'),
            ('UV/05m/UV05m_00647.sofa', 'a11ab0fd1c9bb9bdd9e57c59d4415aac'),
            ('UV/05m/UV05m_00648.sofa', '162439c5390256bced1839d738c00028'),
            ('UV/05m/UV05m_00649.sofa', 'e35989346213768a310dfac055add7a0'),
            ('UV/05m/UV05m_00650.sofa', '7a00aec2468cb529e9ac9d62469e953c'),
            ('UV/05m/UV05m_00651.sofa', '9ba4c59c24976913e3a0553d85f5e0a8'),
            ('UV/05m/UV05m_00654.sofa', '652f131bb5a0bc54f48dcac4f8501983'),
            ('UV/05m/UV05m_00655.sofa', '2def91c3ed2f8284a6b2f38d673eca71'),
            ('UV/05m/UV05m_00657.sofa', '3539f15d9a9a8a305d325ceb483fd7fb'),
            ('UV/05m/UV05m_00660.sofa', '5a685987a25cf363dea9bd46a7e4e20b'),
            ('UV/05m/UV05m_00661.sofa', '536ced8ca50ea45e98d1c6d3ecf9db43'),
            ('UV/05m/UV05m_00662.sofa', 'd5c785fc5fa6a62ea90285882e25282e'),
            ('UV/05m/UV05m_00664.sofa', 'c2ad8bb74ffe77a2d7a42f3401776716'),
            ('UV/05m/UV05m_00665.sofa', '5a1cac3c4a173c3169bf062c39b12811'),
            ('UV/05m/UV05m_00666.sofa', '627b3c80a5caf7be3373c5551560d6d0'),
            ('UV/05m/UV05m_00667.sofa', 'ada3f817b2fcf14b6683c3042c46df6e'),
            ('UV/05m/UV05m_00668.sofa', '31e86b7c3218916a1a9668dcce38b87c'),
            ('UV/05m/UV05m_00669.sofa', 'fef988a101af1badf78342d5ece92d25'),
            ('UV/05m/UV05m_00670.sofa', '436d8320522e40d0ff6e51a9480949b5'),
            ('UV/05m/UV05m_00671.sofa', 'c4ddfe3e3bfb864a279fce2ec643c04e'),
            ('UV/05m/UV05m_00672.sofa', 'a4d38e4942ff333d1bef0b05c9eb95fe'),
            ('UV/05m/UV05m_00673.sofa', '208ded10f90cb83116c9e2c4594d03d6'),
            ('UV/05m/UV05m_00674.sofa', '98ebf1eb1a7f18c79eb08a75724444bb'),
            ('UV/05m/UV05m_00675.sofa', 'af49d9ce6e5509a2432e1fa894a4b6b1'),
            ('UV/05m/UV05m_00676.sofa', 'e6ccc1a07601220281ac84d563dfb8e4'),
            ('UV/05m/UV05m_00677.sofa', 'bf13ab3b06fa664c9be5bb498d8028cd'),
            ('UV/05m/UV05m_00678.sofa', 'b096765746e254f61ef2defd43bd02ef'),
            ('UV/05m/UV05m_00679.sofa', 'c2798f959f0dbea75613ed01b0fa834a'),
            ('UV/05m/UV05m_00680.sofa', '22d435b3effb44d4d9762934675c87b7'),
            ('UV/05m/UV05m_00681.sofa', '1847ca2bd805cac0698882cf7c632ca4'),
            ('UV/05m/UV05m_00682.sofa', 'fd97ef98bef96b79ba0d7101cc5af8d4'),
            ('UV/05m/UV05m_00684.sofa', '159220957d3eef3022a206329724a818'),
            ('UV/05m/UV05m_00685.sofa', '8dd86c34cf5025fc9fecd2a123ab4198'),
            ('UV/05m/UV05m_00686.sofa', 'a9a487a9e55f6d4ddd352507824505c3'),
            ('UV/05m/UV05m_00688.sofa', 'f2df4f7c0d754a297513d2fa56708cdb'),
            ('UV/05m/UV05m_00689.sofa', '6456e99a430dd64539f7160b085c9111'),
            ('UV/05m/UV05m_00690.sofa', 'e6469b7d6fa6df58df9ab6eda75bd7d0'),
            ('UV/05m/UV05m_00693.sofa', '99680fafbb04b96cb29a29eb06b70b97'),
            ('UV/05m/UV05m_00695.sofa', '98a84f4cc7d6a3b6ff4c44e5e98f97ae'),
            ('UV/05m/UV05m_00696.sofa', 'a7d1890dec513fd053edccae5dc084b6'),
            ('UV/05m/UV05m_00697.sofa', '40714f7356db960b9ffa654e5a89b78b'),
            ('UV/05m/UV05m_00698.sofa', '8d97c402c8428da81ce87716e9775a82'),
            ('UV/05m/UV05m_00699.sofa', '2c9e747ee00b472c324c9367f2924789'),
            ('UV/05m/UV05m_00700.sofa', '10959399122106e392f78ab1b7111433'),
            ('UV/05m/UV05m_00701.sofa', '30580c4cf4694265ac3a19be0495238f'),
            ('UV/05m/UV05m_00702.sofa', '9843dc4185fa8a463e0abd2a3bc0ac60'),
            ('UV/05m/UV05m_00704.sofa', 'dff0aced31400a8516543e43e762b616'),
            ('UV/05m/UV05m_00705.sofa', '447d00913d6550988b211c755bf890e3'),
            ('UV/05m/UV05m_00707.sofa', 'c00595967bf763f35add163d60a0e799'),
            ('UV/05m/UV05m_00709.sofa', '6315a882072589cccf529af90f18e173'),
            ('UV/05m/UV05m_00710.sofa', 'a0deb3f811b44940d3158ddaad8fd56d'),
            ('UV/05m/UV05m_00711.sofa', '2ac234f43655fedba7f03e6b9c706b46'),
            ('UV/05m/UV05m_00712.sofa', '6a31a74fbb1eb8170728c05a7cf4d30d'),
            ('UV/05m/UV05m_00713.sofa', '4e5de98aa7012f3bb7de8da9d9ee45ae'),
            ('UV/05m/UV05m_00714.sofa', '52e29d9083f660b07a8f5c1ad06e5f7f'),
            ('UV/05m/UV05m_00717.sofa', 'a89dc9709d87b5ab973db896ba9cc7d2'),
            ('UV/05m/UV05m_00718.sofa', '2fa329f3aceb8e06324678f84b3213e6'),
            ('UV/05m/UV05m_00719.sofa', 'a45fdffe1ddae2e1d548d191a1ee9e68'),
            ('UV/05m/UV05m_00720.sofa', '5c990b83da9f4ac9181188c4d406d134'),
            ('UV/05m/UV05m_00722.sofa', 'd6e28276ac74c9ca2a78b9089fc62d1d'),
            ('UV/05m/UV05m_00723.sofa', '178ad5c1ce8c72dcebe1ab68e1427590'),
            ('UV/05m/UV05m_00724.sofa', '2688f3aa6156d4d5750fc4e03925e6e6'),
            ('UV/05m/UV05m_00725.sofa', '352b328d7b81d5fab626e731d9609742'),
            ('UV/05m/UV05m_00726.sofa', '7bcb05b16a521e48e576b73a7c23b249'),
            ('UV/05m/UV05m_00727.sofa', '069830b5b0fad66191563c8ae7147717'),
            ('UV/05m/UV05m_00729.sofa', 'cfbd05db7606c1262db96222b2e1f2f8'),
            ('UV/05m/UV05m_00730.sofa', 'c254f80ad224f21ba10cc46057019718'),
            ('UV/05m/UV05m_00732.sofa', 'a9ed96a9c6cd78f509d5424337535728'),
            ('UV/05m/UV05m_00734.sofa', '75cee2961c39d53c24bf5658eb9b8130'),
            ('UV/05m/UV05m_00735.sofa', 'ff5564a194f6d22ce9db04d55a36f080'),
            ('UV/05m/UV05m_00736.sofa', 'b34e7a9d106be2019773e4c146136f82'),
            ('UV/05m/UV05m_00740.sofa', '177377666f956ccafe28f514475ec4dd'),
            ('UV/05m/UV05m_00742.sofa', 'e531ab58c3abf322cc838bcc9a8abc6f'),
            ('UV/05m/UV05m_00744.sofa', '66bd9752bdfb82eb9792296e09edea19'),
            ('UV/05m/UV05m_00745.sofa', '87b3f8710292cee75d10f3f9b7dbfaa3'),
            ('UV/05m/UV05m_00746.sofa', '7d838bc9492e7c74b269462bb494c53f'),
            ('UV/05m/UV05m_00747.sofa', 'fcde92b92b001e10494d75b1c45ca75a'),
            ('UV/05m/UV05m_00748.sofa', 'fb4bf65ab758854bea4ea62ee3af05d8'),
            ('UV/05m/UV05m_00749.sofa', '8e0e6b807b2c533df1293a303b0fe804'),
            ('UV/05m/UV05m_00750.sofa', '38a5ec8b7fc4b137495f7d283320d4c5'),
            ('UV/05m/UV05m_00751.sofa', 'bf214a39998e57a4a69f96d7c9e8b1a4'),
            ('UV/05m/UV05m_00753.sofa', 'bc4fd7a4187abd63a2e3f37ced5005ba'),
            ('UV/05m/UV05m_00754.sofa', 'b46bd1a6c33398ee40dd4db9da47742a'),
            ('UV/05m/UV05m_00755.sofa', 'e544e1ed8d71e8afe88d8e60d411c85e'),
            ('UV/05m/UV05m_00756.sofa', '88a602af5dfa579c59b45c2db10f6751'),
            ('UV/05m/UV05m_00757.sofa', 'f8a5362f374b045ef5901d037889b936'),
            ('UV/05m/UV05m_00758.sofa', '1602cefceab9adfb231ae328735ce529'),
            ('UV/05m/UV05m_00760.sofa', '4581a214fbb71b9cebf0aed75dadf6d1'),
            ('UV/05m/UV05m_00761.sofa', '095c67e804af659ea2e1f6da8aca8aa5'),
            ('UV/05m/UV05m_00763.sofa', '315b79efc3b4c97ef5e5fc45382dc4c8'),
            ('UV/05m/UV05m_00764.sofa', '2e9b04124fcfce6e957fdff50db166ba'),
            ('UV/05m/UV05m_00766.sofa', 'd6c2eadab41bc039758da63aa42ce3f0'),
            ('UV/05m/UV05m_00767.sofa', '162f8b45c2fc542b4e4875ed7ca22ded'),
            ('UV/05m/UV05m_00768.sofa', '084e65e1d5403ffb2fc128b54d0caf9c'),
            ('UV/05m/UV05m_00769.sofa', '7bbe736e4cc89cec08dcdcc13c753da6'),
            ('UV/05m/UV05m_00770.sofa', 'f74afcdc52700ffaa089f0047e7cccf3'),
            ('UV/05m/UV05m_00771.sofa', 'fae3bc89bd35ae4f4e2d3341f1777922'),
            ('UV/05m/UV05m_00772.sofa', '5cf17aa9ac1ca883235197063aa1e357'),
            ('UV/05m/UV05m_00773.sofa', '45ed6dfbb214d9dc7bb83cb41066bcba'),
            ('UV/05m/UV05m_00774.sofa', 'e4449a8a869a79e3059624c8ec111365'),
            ('UV/05m/UV05m_00775.sofa', '36fcaca81dabe05b47a89edbf1c0f3c8'),
            ('UV/05m/UV05m_00778.sofa', '99a311c91169bfbed6f9c184439adf52'),
            ('UV/05m/UV05m_00779.sofa', '844246482e1ec60f9e0c952c5acbbc89'),
            ('UV/05m/UV05m_00780.sofa', 'df71f086fc50d86c6ab0e8a53d7aa542'),
            ('UV/05m/UV05m_00782.sofa', '09d2ef79e537dd00a8da4e102f214fd4'),
            ('UV/05m/UV05m_00783.sofa', '120699783d8a8757e49ba4a82b7bf096'),
            ('UV/05m/UV05m_00787.sofa', '72e13e5bc569ea25501f34e18da5c9d9'),
            ('UV/05m/UV05m_00788.sofa', '363332fc7911670042bd406d72d741d1'),
            ('UV/05m/UV05m_00789.sofa', '70adf3a99259feec7d694cbbed7f40ec'),
            ('UV/05m/UV05m_00791.sofa', '4ce54925ac96843d3574836a8ac5a5aa'),
            ('UV/05m/UV05m_00794.sofa', 'd48e2b9cd375c9c76c8137982e6192b1'),
            ('UV/05m/UV05m_00795.sofa', 'e48da93ff8f97feadfd98a086ecbf8e8'),
            ('UV/05m/UV05m_00797.sofa', '5ca3da37bd94d53abda6929cbc51d9f6'),
            ('UV/05m/UV05m_00798.sofa', '31d5063ed85b6aad40b996d323962ca1'),
            ('UV/05m/UV05m_00799.sofa', '85a8688a493f581873e5e5431159cce8'),
            ('UV/05m/UV05m_00800.sofa', 'b9240791fa7350416e1b15981454cefa'),
            ('UV/05m/UV05m_00801.sofa', 'b017d7bc0ab1b53b231763f7e7ed1c48'),
            ('UV/05m/UV05m_00802.sofa', '9f60a93a2b0410eac9c784ddfc034dff'),
            ('UV/05m/UV05m_00803.sofa', '15ddef065c5258496683ecf0935c650b'),
            ('UV/05m/UV05m_00804.sofa', '48845859f244e7a5c9be079aaca935ad'),
            ('UV/05m/UV05m_00805.sofa', 'f6e848688eb955e69df33e67a3080e76'),
            ('UV/05m/UV05m_00806.sofa', '61c5564e109e9aba33d02b2546cd1950'),
            ('UV/05m/UV05m_00807.sofa', 'e73b171f3526276aca32b588c2aafd69'),
            ('UV/05m/UV05m_00809.sofa', '0a6b2511cc86b70e3e7d5dd5c1a50f92'),
            ('UV/05m/UV05m_00810.sofa', '41d58861494f91395f21710d2cc16a8d'),
            ('UV/05m/UV05m_00811.sofa', '72073d596fe9a4c43cd3508082c8a905'),
            ('UV/05m/UV05m_00812.sofa', '7ecf203cc01bc7ea49daf12c1225eb80'),
            ('UV/05m/UV05m_00815.sofa', '82a6dd07450a2cab187a950c12719c31'),
            ('UV/05m/UV05m_00816.sofa', '51881a12d84e041a61ffd38167dce1ea'),
            ('UV/05m/UV05m_00817.sofa', '0ed94b148590f14accc0b22d96526c22'),
            ('UV/05m/UV05m_00818.sofa', 'd75d432ec9edbb11557b1cbf9fa2cd41'),
            ('UV/05m/UV05m_00819.sofa', 'ddb77f5dbf992e5a623a34906a8a718b'),
            ('UV/05m/UV05m_00821.sofa', '91919ca3cbb494358eb3c2889021a30f'),
            ('UV/05m/UV05m_00822.sofa', 'd657f171620a66d45613c28f15fdc18d'),
            ('UV/05m/UV05m_00823.sofa', '29cdf5450ffd889c179fbe97755dcf04'),
            ('UV/05m/UV05m_00824.sofa', 'c6fdadfa23d0df424008162abc2aca8c'),
            ('UV/05m/UV05m_00825.sofa', '37bbbfaacb3b6bffdd7591620c978f62'),
            ('UV/05m/UV05m_00826.sofa', '91d39fa713e6239941c7a7793e6ccee9'),
            ('UV/05m/UV05m_00827.sofa', '7204a30ad72475f8c82fc42eb465a795'),
            ('UV/05m/UV05m_00829.sofa', '64ceff8d5a0396876e93a62f12b06c0a'),
            ('UV/05m/UV05m_00830.sofa', 'b866fe863542c08e357e26bc1a4b2650'),
            ('UV/05m/UV05m_00833.sofa', '3fc0afed8dd531a702ff3aed6979bf32'),
            ('UV/05m/UV05m_00835.sofa', '7e82a2b5068ee86db669ad4fa18ae039'),
            ('UV/05m/UV05m_00836.sofa', '1ee6d5e7828348f705452fde6d3931c1'),
            ('UV/05m/UV05m_00837.sofa', '3f78f5eb28e2603008415b982d7653b0'),
            ('UV/05m/UV05m_00838.sofa', '7e395c3d57a25f969ac431bf708793b5'),
            ('UV/05m/UV05m_00839.sofa', '9df2b4de1d7f76339e3bfa70ff4c9c59'),
            ('UV/05m/UV05m_00840.sofa', '74a45d7e010c60bdd307124d12375476'),
            ('UV/05m/UV05m_00841.sofa', '0a0d3d607c2157be62f13d05c6b866e8'),
            ('UV/05m/UV05m_00842.sofa', '6277973e32dc9f5975e2b578b2b4a0a1'),
            ('UV/05m/UV05m_00843.sofa', 'bc918edd1eb24a983b7c9b82843104eb'),
            ('UV/05m/UV05m_00844.sofa', '842c1fc0b6d68d04a5275afd9012f760'),
            ('UV/05m/UV05m_00845.sofa', '72807e4a15d513715937111a961fdd91'),
            ('UV/05m/UV05m_00846.sofa', '3612545dbe6a47c6e01672f775715093'),
            ('UV/05m/UV05m_00850.sofa', '02c481e42ea4885f852c34bbf8a17aac'),
            ('UV/05m/UV05m_00852.sofa', '096bc087b23b22d2001bfe1ff90c9795'),
            ('UV/05m/UV05m_00853.sofa', 'f3aabd880e768567279e56e3a8a29251'),
            ('UV/05m/UV05m_00855.sofa', 'cb34f9000956bfa02c9d8fb4abaa5c9f'),
            ('UV/05m/UV05m_00857.sofa', '4aed1a0a61704a107cd186c46b5422a8'),
            ('UV/05m/UV05m_00858.sofa', '497439061a7998503ccca59feeb7f034'),
            ('UV/05m/UV05m_00859.sofa', '9ab543946fa0b4d1d36c53e9bb49b87a'),
            ('UV/05m/UV05m_00860.sofa', '9d90d64e431143b0aada309528701ce3'),
            ('UV/05m/UV05m_00861.sofa', '6d2bef9f6789eb0214679ac0ffe5ea89'),
            ('UV/05m/UV05m_00863.sofa', '127c3c3ae3403045e1e7df62177b4486'),
            ('UV/05m/UV05m_00864.sofa', '679309141fd8b074f5595eba4f3e5270'),
            ('UV/05m/UV05m_00865.sofa', '5a71d6d559a5bc8a11fd668f1f1268ee'),
            ('UV/05m/UV05m_00866.sofa', '7ed79134911a576f60f2bd498fa88632'),
            ('UV/05m/UV05m_00867.sofa', '1ff4f82bf9aa84753b153ad695b4c33e'),
            ('UV/05m/UV05m_00868.sofa', '634af699268de3ba3ecb840754c03218'),
            ('UV/05m/UV05m_00869.sofa', 'eb3bc5eb9d64597a496983215e9b68d6'),
            ('UV/05m/UV05m_00870.sofa', '51b93c1a5e67225e3306dba9328b3df9'),
            ('UV/05m/UV05m_00872.sofa', '1984808ee8d6f6de1bc606098eb4d9c1'),
            ('UV/05m/UV05m_00875.sofa', '5a84db15f5b1577c48b87e4942250655'),
            ('UV/05m/UV05m_00877.sofa', 'cdccdd91df15582869d4d1446dc9054a'),
            ('UV/05m/UV05m_00880.sofa', 'be1ca3d2be790a3180c29e199dd651da'),
            ('UV/05m/UV05m_00882.sofa', '878e7c15ca45531096d491565d5e6b85'),
            ('UV/05m/UV05m_00883.sofa', 'eeb7f82b840a4e5bb91f245a655c3fe8'),
            ('UV/05m/UV05m_00884.sofa', '9448ea2772b6859e1f3c873004bc39d7'),
            ('UV/05m/UV05m_00887.sofa', '0f20c415777c244670208142f1444c98'),
            ('UV/05m/UV05m_00889.sofa', '4d4194aa5296176b3534ed6f5b7a562b'),
            ('UV/05m/UV05m_00890.sofa', '7e90e9616c9824e4009be1c501a478ce'),
            ('UV/05m/UV05m_00891.sofa', '83085665b5327ab0a3e995982aca9511'),
            ('UV/05m/UV05m_00892.sofa', '165f186afb3b45837dfc8980290f82e5'),
            ('UV/05m/UV05m_00893.sofa', '4a507c8c90a8a66d6a6c6b52f78276e9'),
            ('UV/05m/UV05m_00894.sofa', '349a5314469a68b8b14726e1dcdfa2b8'),
            ('UV/05m/UV05m_00895.sofa', 'cc6f7af39cf1b870963fe98d8ebf6bc8'),
            ('UV/05m/UV05m_00896.sofa', 'dd88611113f2f7c55500407ddf175a30'),
            ('UV/05m/UV05m_00897.sofa', 'a5c18f66bbab5b9e5a168b67b5811901'),
            ('UV/05m/UV05m_00898.sofa', 'cc7ca83761a52d7992c0c6f6229c75a8'),
            ('UV/05m/UV05m_00899.sofa', 'b4fa22a522c9e48e327a842a477af20d'),
            ('UV/05m/UV05m_00900.sofa', '644d070cc4bd07ab80e914e92868f866'),
            ('UV/05m/UV05m_00901.sofa', '0c7473db3b5d9d99696e0b2d155f3cc2'),
            ('UV/05m/UV05m_00902.sofa', 'eea992bfd4ba68d787662a0bde25a08e'),
            ('UV/05m/UV05m_00903.sofa', '750dd023f59563b7eee4f852b5ba4e73'),
            ('UV/05m/UV05m_00904.sofa', '315a336a085829aeffe9c6495a43dd9a'),
            ('UV/05m/UV05m_00906.sofa', 'd35cd580d35dda899895302ece441d01'),
            ('UV/05m/UV05m_00907.sofa', 'b1916d3ed294567ba0678cc2b941c7c8'),
            ('UV/05m/UV05m_00908.sofa', '8184fae0d7724c791b56ea7b47ba6c77'),
            ('UV/05m/UV05m_00910.sofa', 'c1fadca1bb8d65a077b99622389e63f8'),
            ('UV/05m/UV05m_00911.sofa', '853e77f00bf6c3688859dc55b1847421'),
            ('UV/05m/UV05m_00913.sofa', '630817733840ec120098d1b3ca15190f'),
            ('UV/05m/UV05m_00915.sofa', 'bd05723d0845484cb3a19b50de2e4ecb'),
            ('UV/05m/UV05m_00918.sofa', '25260895f86aa8017b20e7b5000bdf8c'),
            ('UV/05m/UV05m_00919.sofa', 'e9e2aa3872bda53a1ca328ea7cefe641'),
            ('UV/05m/UV05m_00920.sofa', 'c122cf1f6f55d7d012c3103811f168bc'),
            ('UV/05m/UV05m_00921.sofa', 'a706142cb6a0b356430a4480155fd6fc'),
            ('UV/05m/UV05m_00923.sofa', '658773a2e45440739d84c8f32183fb43'),
            ('UV/05m/UV05m_00924.sofa', 'aa237097a2e326367f86f9d0452de2ed'),
            ('UV/05m/UV05m_00925.sofa', '44edc93e190677934919a76c5c763260'),
            ('UV/05m/UV05m_00926.sofa', '86b217b05620f22d6ec9542902643412'),
            ('UV/05m/UV05m_00927.sofa', 'c6d1cedb4786925cc8b110a34a1f427d'),
            ('UV/05m/UV05m_00929.sofa', 'fda361b64d7305d109e57dc36950f845'),
            ('UV/05m/UV05m_00930.sofa', '3bdff2fd2710fcfb79b221aa12bfdca6'),
            ('UV/05m/UV05m_00931.sofa', '2eaf0eea617688b929064ffc681a21a5'),
            ('UV/05m/UV05m_00932.sofa', '5cea4ecccdf303b101636d630d26da9a'),
            ('UV/05m/UV05m_00934.sofa', '19b4eb43f20de96cff9fc60fbcc91d9b'),
            ('UV/05m/UV05m_00936.sofa', 'd348f7cfbef9b2a72f35c1595ef11436'),
            ('UV/05m/UV05m_00937.sofa', 'ccfd919db6e1ac4769853192bd636756'),
            ('UV/05m/UV05m_00939.sofa', '918181b32f3c751787c91da464b6967d'),
            ('UV/05m/UV05m_00940.sofa', '4ff27f764d6087f3d1e92ef442e0c4b7'),
            ('UV/05m/UV05m_00942.sofa', '7b01dab2268147002f3c1340e668aa4f'),
            ('UV/05m/UV05m_00944.sofa', 'cd2a0e87497c22b54d7721cb5d0ff711'),
            ('UV/05m/UV05m_00946.sofa', '13b32c6245afab9188876abebf2f0025'),
            ('UV/05m/UV05m_00947.sofa', 'b0454084fa9609c281f4bf9b29e8f160'),
            ('UV/05m/UV05m_00951.sofa', 'c9f367a3c639471d59a88eec579d327a'),
            ('UV/05m/UV05m_00952.sofa', 'c8f28c73f2ec4b6df546ca2a6463a89c'),
            ('UV/05m/UV05m_00953.sofa', 'f3c738375005bceb3c9f14b933122395'),
            ('UV/05m/UV05m_00954.sofa', 'ec6b878467bee8130c835e0626ad468f'),
            ('UV/05m/UV05m_00955.sofa', '68f43955a5658d3ffda41c63ffa930e3'),
            ('UV/05m/UV05m_00956.sofa', '6376ecb540a74724a4fe1b6f5bc95d5d'),
            ('UV/05m/UV05m_00961.sofa', 'd7a832be6a0bef07e52b3065592d965e'),
            ('UV/05m/UV05m_00962.sofa', 'a68d9be2c9f3a1d385c0f770dc9fafb8'),
            ('UV/05m/UV05m_00963.sofa', '793e384628994a2cf3e123362aa3c7e8'),
            ('UV/05m/UV05m_00965.sofa', '26f69fdb726f6eb324500c4f4583121f'),
            ('UV/05m/UV05m_00966.sofa', 'bfbd804807c98d9ff4218ff07d473567'),
            ('UV/05m/UV05m_00967.sofa', '36456a432ca7e0674d2e95d7b540852c'),
            ('UV/05m/UV05m_00968.sofa', 'd2b38670afb076ef67b64069b2e9961a'),
            ('UV/05m/UV05m_00969.sofa', '3c0c61b9764e92d9994cee74250b1f48'),
            ('UV/05m/UV05m_00971.sofa', 'c8aceca2d63a054b5cd4352bdc3f07bd'),
            ('UV/05m/UV05m_00972.sofa', '14b74333f4c3419ea0706b95f0f726fa'),
            ('UV/05m/UV05m_00973.sofa', '0ef73be5d39c0e8a4581b1d48f7f90ee'),
            ('UV/05m/UV05m_00975.sofa', 'd8f6cb9a7226d4559accb77deb6a64d3'),
            ('UV/05m/UV05m_00976.sofa', '1878014f952deeca01f742fbb1f0483e'),
            ('UV/05m/UV05m_00977.sofa', '1d7033e90d42964e453653f0e0980f6f'),
            ('UV/05m/UV05m_00978.sofa', '84fcb8a18ee907c82622252f9c12f028'),
            ('UV/05m/UV05m_00979.sofa', '6f97e1dfd781af328ad19e5b7ea1dd44'),
            ('UV/05m/UV05m_00980.sofa', 'ab244cdfabd7e17da699e5d939c25535'),
            ('UV/05m/UV05m_00981.sofa', '03e54866cbe7d2afe3cecf8517d3cd33'),
            ('UV/05m/UV05m_00982.sofa', '406ed7b9bb2ed6dcb35e4aa83c0a6084'),
            ('UV/05m/UV05m_00984.sofa', '5f3fa5a1662d35b031a713719cfc535e'),
            ('UV/05m/UV05m_00985.sofa', '998d097fe9b588911104bb95d567d8ee'),
            ('UV/05m/UV05m_00986.sofa', 'f6b08d5682d2570e88905094c8785e59'),
            ('UV/05m/UV05m_00987.sofa', '45cb889e801c24e1961c3867b680f3a4'),
            ('UV/05m/UV05m_00991.sofa', '941ef182cbbdfe0703916c9c9a569319'),
            ('UV/05m/UV05m_00993.sofa', '28efa513994ae353b868078b81cbc904'),
            ('UV/05m/UV05m_00995.sofa', 'd7874c2807318dad05a4cf443336043f'),
            ('UV/05m/UV05m_00996.sofa', '3ca5b1344150c70e5095a25b89ce544c'),
            ('UV/05m/UV05m_00997.sofa', '7dae6cd5d90c4c4fc6953e8ec05e1eb9'),
            ('UV/05m/UV05m_00998.sofa', 'd54f25f4647f1fd2f8ac4372229b01f4'),
            ('UV/05m/UV05m_00999.sofa', 'f99a098bf2c6d0f2b456695555b93688'),
            ('UV/05m/UV05m_01000.sofa', '3fac594fbb1101c4ae8dff33b9288003'),
            ('UV/05m/UV05m_01002.sofa', '362bc78b123aff6fe0cd6687a87c8f0b'),
            ('UV/05m/UV05m_01003.sofa', '08e496b6dc376625dea6bc32df691b30'),
            ('UV/05m/UV05m_01004.sofa', '47a4fb438e8b8f53736c038c8ae5e672'),
            ('UV/05m/UV05m_01005.sofa', '2597b8f7e1fcdc2d4c5110b18f3d0388'),
            ('UV/05m/UV05m_01006.sofa', '3439f9f38985bbc22194e75347fc6425'),
            ('UV/05m/UV05m_01008.sofa', '70924e2b7008945236ccb79d5b58005e'),
            ('UV/05m/UV05m_01009.sofa', '7310210d6260d532239f13d1db718988'),
            ('UV/05m/UV05m_01010.sofa', '47feff367ac75021b82578ade041d47b'),
            ('UV/05m/UV05m_01011.sofa', '335570d097ad97aa6183989df5969ea6'),
            ('UV/05m/UV05m_01012.sofa', '04738ab36b908fb01fdca2ccf920cc65'),
            ('UV/05m/UV05m_01013.sofa', '2b9e3bfa1e45de930c87515394218949'),
            ('UV/05m/UV05m_01016.sofa', '2e9516b7327fbb7da43228b7caae879b'),
            ('UV/05m/UV05m_01017.sofa', '3b8bf8077965526b0baa3cfcc0fe8f00'),
            ('UV/05m/UV05m_01018.sofa', 'd6ee20bef27d1bed5109e26136374cac'),
            ('UV/05m/UV05m_01019.sofa', '554e94d07cd31fcf2c43a488c441a067'),
            ('UV/05m/UV05m_01020.sofa', '7ed3ac03dbd7267e29522906f1732b4b'),
            ('UV/05m/UV05m_01022.sofa', 'bf750602c93270e6a2aa8637b8f35550'),
            ('UV/05m/UV05m_01024.sofa', 'a640f1a361a86d2dcbf273a7631314af'),
            ('UV/05m/UV05m_01027.sofa', '17bf1d3e9d992bc63c251bfaac949b6a'),
            ('UV/05m/UV05m_01028.sofa', '4e2e9c8d6e002b2bb63a6c4bee0da232'),
            ('UV/05m/UV05m_01030.sofa', 'e30b69152794809d3ea6c161531e7dba'),
            ('UV/05m/UV05m_01031.sofa', 'fd37e00fa9794f255153cffd34fef937'),
            ('UV/05m/UV05m_01032.sofa', 'e1cdf70b096bf6d7d5d802a5f5504c6d'),
            ('UV/05m/UV05m_01033.sofa', '8db862eb1e1260dd0855483f1fc6de04'),
            ('UV/05m/UV05m_01035.sofa', '754d34ae8d60cf0bb33b2683065d60d7'),
            ('UV/05m/UV05m_01036.sofa', 'dbea109d7c6d72146a276645930502d9'),
            ('UV/05m/UV05m_01037.sofa', 'ad7180baecfe85a7ca0269def39bd362'),
            ('UV/05m/UV05m_01038.sofa', 'e3d0e9833f43cb2dbaa02c2d20755837'),
            ('UV/05m/UV05m_01039.sofa', '04265baad3633763c3eabada537dc64c'),
            ('UV/05m/UV05m_01040.sofa', '097871c029113151b1e27c5d53411515'),
            ('UV/05m/UV05m_01042.sofa', '294077acaab260ab549475798f0ac35f'),
            ('UV/05m/UV05m_01044.sofa', '50c5aaa46c5fbef98d7595e83d446a3a'),
            ('UV/05m/UV05m_01046.sofa', 'fa178b40403454e2840901079128344a'),
            ('UV/05m/UV05m_01047.sofa', '4a5588f5caa357c2f3027fd637ed1e8f'),
            ('UV/05m/UV05m_01048.sofa', 'e09464b188863d7dbe3c9004de5a483a'),
            ('UV/05m/UV05m_01049.sofa', '7499cd176bf71d178b3d1b9253320cb9'),
            ('UV/05m/UV05m_01050.sofa', '78df9af79286ff20cd5823f54ede48b0'),
            ('UV/05m/UV05m_01052.sofa', '933d800a229a757ebe26022530e6564f'),
            ('UV/05m/UV05m_01053.sofa', '561b0e8f5d41ea4eb8f6c7db58c32f91'),
            ('UV/05m/UV05m_01055.sofa', '9fee2666e1cff3fdd6abe9e75f77318b'),
            ('UV/05m/UV05m_01057.sofa', 'f7d6dad2df8f96198ecfbaf433f73425'),
            ('UV/05m/UV05m_01058.sofa', '0c2acdcfa84acec1ec72580960fffad0'),
            ('UV/05m/UV05m_01060.sofa', 'b7e9a0e851beac73c3c3d71df85c1b44'),
            ('UV/05m/UV05m_01061.sofa', '55519ad2237a86a2c483174d819a82b4'),
            ('UV/05m/UV05m_01062.sofa', 'e06a634e5bbd89cec20d18c97f06bcfe'),
            ('UV/05m/UV05m_01063.sofa', '28386b495342c4c0ae5b3e6f5cca6284'),
            ('UV/05m/UV05m_01064.sofa', 'a0f1ac1b351fa1a634768a0537471199'),
            ('UV/05m/UV05m_01065.sofa', 'b27f90ea925bfc724207e6064616a260'),
            ('UV/05m/UV05m_01066.sofa', '7ba036f4f29ea38b66731cb56edd7dba'),
            ('UV/05m/UV05m_01067.sofa', '7c85167eb67c0cb6a8704ef19c2d1a80'),
            ('UV/05m/UV05m_01069.sofa', '02236b83457ee4236857cf6d9ea528a4'),
            ('UV/05m/UV05m_01071.sofa', '6263cc8cebac59374e5109d13662ae7a'),
            ('UV/05m/UV05m_01073.sofa', '2e913956e92f8cb3e3f70f909526443a'),
            ('UV/05m/UV05m_01075.sofa', '34392024d9a5955c61d682b71b7183d7'),
            ('UV/05m/UV05m_01077.sofa', 'cfb215a3c71089596250777a4df186f8'),
            ('UV/05m/UV05m_01078.sofa', '27f339d20b639ce26a3bedc9dd9e63ac'),
            ('UV/05m/UV05m_01079.sofa', 'a49ad5acc27b18f3a1c66475691659f1'),
            ('UV/05m/UV05m_01080.sofa', '52ef57dde645882f4df28da025efdb26'),
            ('UV/05m/UV05m_01082.sofa', '6c1fe6e029c95748e2ce334104407efc'),
            ('UV/05m/UV05m_01083.sofa', 'b973ae8b1e4f3951f9cfc8fb5a4c9771'),
            ('UV/05m/UV05m_01085.sofa', 'bad13508e47e02b60bd0b0f72a59c3f7'),
            ('UV/05m/UV05m_01086.sofa', '479eca42a9e6866443839c312c724ef7'),
            ('UV/05m/UV05m_01087.sofa', 'bf88116eebd4be2527b6bffe997c253a'),
            ('UV/05m/UV05m_01088.sofa', '36b4af711e511e9226881caecd883e68'),
            ('UV/05m/UV05m_01089.sofa', '723b90961f8033fddf14ae306ab772dd'),
            ('UV/05m/UV05m_01091.sofa', '1e4b8a50b05d4c21c31fe52e60ca3f86'),
            ('UV/05m/UV05m_01092.sofa', '7b7b4fa7c6e555a66fba6b0811355f05'),
            ('UV/05m/UV05m_01093.sofa', '046e5203a9b1ed82e1ff717676641f37'),
            ('UV/05m/UV05m_01094.sofa', '66a31a48621d4b418e2ecdf73f4c2466'),
            ('UV/05m/UV05m_01097.sofa', '9afeeaf563c0995314d3ff31c4cf0240'),
            ('UV/05m/UV05m_01099.sofa', '22e2bea08e796f03e1e9f31435fe72e7'),
            ('UV/05m/UV05m_01100.sofa', '5f4dae383004694dda97420f57bf2a83'),
            ('UV/05m/UV05m_01101.sofa', 'df8a24463c5ad6b44c69de4e5a911fb6'),
            ('UV/05m/UV05m_01102.sofa', 'bf8d37b88d8f8b13e0af90e069e41ffc'),
            ('UV/05m/UV05m_01103.sofa', '2b1bc431cc5788beb9ad5266fb0a997e'),
            ('UV/05m/UV05m_01104.sofa', '784972aa91ffbe0b1c1d0acbfe5270ea'),
            ('UV/05m/UV05m_01107.sofa', '8d7ac724b274ce259580940be406480d'),
            ('UV/05m/UV05m_01108.sofa', 'ed706bdd43d3cac15c70a35966ce092d'),
            ('UV/05m/UV05m_01109.sofa', 'a1544918f007c6da3444e91748b627a6'),
            ('UV/05m/UV05m_01111.sofa', '076b0ad439ff48fc9645c5023c42386c'),
            ('UV/05m/UV05m_01112.sofa', '66dd689f36d948462edd65e336913765'),
            ('UV/05m/UV05m_01114.sofa', 'dc6028636295d6f5fcbff9ea2c030257'),
            ('UV/05m/UV05m_01115.sofa', 'ced71ef48704139cceaddb1730070761'),
            ('UV/05m/UV05m_01116.sofa', '21edd2abf81520a01783bceff9b4adb4'),
            ('UV/05m/UV05m_01117.sofa', 'b25a7c94139ded63c54941e1f2910e21'),
            ('UV/05m/UV05m_01120.sofa', 'bee017e3823ccc154b4992b802583951'),
            ('UV/05m/UV05m_01121.sofa', 'cea7434dddc341ed1237612ccc7be638'),
            ('UV/05m/UV05m_01122.sofa', 'db5e0f2db7afd005949bb166ccf7fae5'),
            ('UV/05m/UV05m_01125.sofa', '7d1dddfc5b2bc5fb71860e6124948f48'),
            ('UV/05m/UV05m_01127.sofa', 'dab611c78e09ea75e25eed199d72bc39'),
            ('UV/05m/UV05m_01128.sofa', 'adf27f94729250105efa343b85eff004'),
            ('UV/05m/UV05m_01129.sofa', '311183e45a6800197b7702074ae6bf66'),
            ('UV/05m/UV05m_01130.sofa', '051c408c31c5138ba17574677e6ca266'),
            ('UV/05m/UV05m_01131.sofa', '9560ecaf5d24aef5f062fffe9642fca2'),
            ('UV/05m/UV05m_01132.sofa', 'd1539768c79b03b81dcb9ce574f15b23'),
            ('UV/05m/UV05m_01134.sofa', 'f8701a8cbc56cfb33ac7ecdd807d7a3c'),
            ('UV/05m/UV05m_01135.sofa', '8fbd9e61f414df37a06782c94d2a9c93'),
            ('UV/05m/UV05m_01136.sofa', '31fea132d1f250c492bc8258e2abb4a3'),
            ('UV/05m/UV05m_01137.sofa', '9ada66ea4d9e7103e5ff9d171d601046'),
            ('UV/05m/UV05m_01139.sofa', '7ded91909503482a847bfbcb7c29d8c1'),
            ('UV/05m/UV05m_01140.sofa', '4575fa8279cbb7cd2c7d6f5c883f76fd'),
            ('UV/05m/UV05m_01141.sofa', '1e0448385fb31c8df3a72a5e97b482ab'),
            ('UV/05m/UV05m_01142.sofa', '537541053d92a393767e2dd317d0bb22'),
            ('UV/05m/UV05m_01143.sofa', '51e908f81bd4c06c88999e1b93e843db'),
            ('UV/05m/UV05m_01144.sofa', '85ae88f41e851f4fb61d7535978e0510'),
            ('UV/05m/UV05m_01145.sofa', '94b6410c043247f3250c1c6c0c338b09'),
            ('UV/05m/UV05m_01146.sofa', '40dfadf06bdc9b244a1bc929a58c80ec'),
            ('UV/05m/UV05m_01147.sofa', '3ce98f444a01f18d5d675b2a9aabf96a'),
            ('UV/05m/UV05m_01148.sofa', 'cfacd7caceb597787a90191422cd901a'),
            ('UV/05m/UV05m_01149.sofa', '0ab5f30e96696c14f47d1fde17c5e3d5'),
            ('UV/05m/UV05m_01150.sofa', '1f14bb6d0c5b8294fc59db5e63692403'),
            ('UV/05m/UV05m_01151.sofa', '74361dc40590aafefcfc38554fd7e153'),
            ('UV/05m/UV05m_01152.sofa', '44ffbc5a2be1a5d9870537ee9d96771a'),
            ('UV/05m/UV05m_01155.sofa', '1505b48e3f9fa97da6031398c725a150'),
            ('UV/05m/UV05m_01157.sofa', '219fb36ae883220502d92d949ed0dfe4'),
            ('UV/05m/UV05m_01160.sofa', 'f1cd95ca185e36c15b9ba94445aea437'),
            ('UV/05m/UV05m_01162.sofa', 'fec6ac1d40635ebc30c00b41fb7d0220'),
            ('UV/05m/UV05m_01163.sofa', '3459e9c35d22a1e3d95a346787d36dfe'),
            ('UV/05m/UV05m_01164.sofa', 'ca8377d5fcab369ee66e50d0d616e6c5'),
            ('UV/05m/UV05m_01165.sofa', '5b491c04eeee99178c6b773f00fa15b3'),
            ('UV/05m/UV05m_01166.sofa', '8a7a3bdf4a6eaf4a4c74896a7544205e'),
            ('UV/05m/UV05m_01168.sofa', '86a5df57aa0d2af40e168aadc531f07d'),
            ('UV/05m/UV05m_01171.sofa', '95bf95ade5a366b6b26b04518e35b545'),
            ('UV/05m/UV05m_01172.sofa', '602d0e9b6dfe312cc05b1f067cb91710'),
            ('UV/05m/UV05m_01173.sofa', '66a2bc8aadb3b17fb99ff82e5557b8e7'),
            ('UV/05m/UV05m_01174.sofa', '98bf3a06c8d0634709e5b97a1401146a'),
            ('UV/05m/UV05m_01175.sofa', '4aa103926b75fbed88bc5a32e4f62d7e'),
            ('UV/05m/UV05m_01176.sofa', '337ee07f1bb57ccc18926a8ea2b11612'),
            ('UV/05m/UV05m_01177.sofa', '6b257d85076f1ab82918199dc3d2d0c1'),
            ('UV/05m/UV05m_01179.sofa', 'f790d29f1d1d2badd8d2a42836ddbf40'),
            ('UV/05m/UV05m_01181.sofa', 'b627f79b2270775900c329384425ad41'),
            ('UV/05m/UV05m_01185.sofa', '9562f6e3d8058032ea3e5a51a4cece94'),
            ('UV/05m/UV05m_01186.sofa', '05c87d2fd1e611d56d456163afd84dd1'),
            ('UV/05m/UV05m_01189.sofa', 'b700f670ec6e6a5419685986767dd9ea'),
            ('UV/05m/UV05m_01190.sofa', '52ac20b53d51115badbec73a78fb47f5'),
            ('UV/05m/UV05m_01191.sofa', 'ef0a6fe502c259ac63fc9072c5f9f6d8'),
            ('UV/05m/UV05m_01192.sofa', 'ba0717a1ed4c02c1462fb5314951e4f6'),
            ('UV/05m/UV05m_01193.sofa', 'eedf99d74602347fc8825aace30fde75'),
            ('UV/05m/UV05m_01194.sofa', 'cc6fd69130fecc23de18048ac5fbd18b'),
            ('UV/05m/UV05m_01195.sofa', 'c2c53d4340ebef538ac825e8fb5bcd6d'),
            ('UV/05m/UV05m_01196.sofa', '0800937167ceee055d8f388d1a6c57cc'),
            ('UV/05m/UV05m_01197.sofa', 'f99ad2fad8637ec682be49fc03864d4b'),
            ('UV/05m/UV05m_01200.sofa', '884195341138a6970da1365fe7c20005'),
            ('UV/05m/UV05m_01201.sofa', 'c927150861903fc244688936d1a351a8'),
            ('UV/05m/UV05m_01202.sofa', 'aec39a501df47e7e849ba0b6bd011616'),
            ('UV/05m/UV05m_01203.sofa', '42bba2e6cffc0a6d3820bfc3af83da88'),
            ('UV/05m/UV05m_01205.sofa', '1f4a2f8be8b348b220c0eec9fe0d2a3e'),
            ('UV/05m/UV05m_01206.sofa', 'd2c3384f78525da35c42b40cacb8aef8'),
            ('UV/05m/UV05m_01207.sofa', '30044dcce7ccb63c1edc18f62978c460'),
            ('UV/05m/UV05m_01208.sofa', 'eee6ffffb102f0b5422bcc8c424108ab'),
            ('UV/05m/UV05m_01209.sofa', '232e68cc4a7ca42d2a039a9b63069b02'),
            ('UV/05m/UV05m_01210.sofa', '85ca5116b8e845087a6395cc64c40c5e'),
            ('UV/05m/UV05m_01211.sofa', '58b55443eb821a34906b84d5593dd4fd'),
            ('UV/05m/UV05m_01212.sofa', 'e9952dff7d32ee8b61759affcb273966'),
            ('UV/05m/UV05m_01213.sofa', '927066163526ef93743fec0a263fb769'),
            ('UV/05m/UV05m_01215.sofa', '5bd3bd362a8803c3c49fafd1ed7952a5'),
            ('UV/05m/UV05m_01216.sofa', 'a0d29bac812bde1c11e38bb9f6ffa8b9'),
            ('UV/05m/UV05m_01217.sofa', 'fb27e569ff1697634a063ee62b987e3e'),
            ('UV/05m/UV05m_01219.sofa', '8e176cab83ba436b9e27f8fea365f80f'),
            ('UV/05m/UV05m_01221.sofa', 'da7216d8d5de08ce472b1799e0b23a04'),
            ('UV/05m/UV05m_01222.sofa', '2120b3ef68b8e075cf0ca82a127bb21e'),
            ('UV/05m/UV05m_01223.sofa', 'a1ed4324c5912021e6bf0c3d3f706fce'),
            ('UV/05m/UV05m_01224.sofa', '9933bce8b9ccf7d7863603b63a33e5ef'),
            ('UV/05m/UV05m_01225.sofa', 'a4bba1f5bb4232213fd3914802e4c2d0'),
            ('UV/05m/UV05m_01228.sofa', 'e9fcb0abb46ffae23d431b9fd317d118'),
            ('UV/05m/UV05m_01230.sofa', '06402c26970859c376f5c152bb88ec86'),
            ('UV/05m/UV05m_01231.sofa', '9626857a8483e23ce7cda70bb8862642'),
            ('UV/05m/UV05m_01232.sofa', 'f32223dc66eca0e11c28c6e20f2aa282'),
            ('UV/05m/UV05m_01233.sofa', 'c66c035508411cdc0d5d31cab3cfa8d6'),
            ('UV/05m/UV05m_01234.sofa', 'fca3d65752aae734cb332cd8acf80a72'),
            ('UV/05m/UV05m_01235.sofa', '3b7341baf02db86237cb6597130003f2'),
            ('UV/05m/UV05m_01237.sofa', '343dcaeff42ac4f76a2979417eaa72ab'),
            ('UV/05m/UV05m_01238.sofa', '04584b811cde82fb99df76b932855d90'),
            ('UV/05m/UV05m_01239.sofa', 'ab9c9161bd840a33eb7cd2021adeec81'),
            ('UV/05m/UV05m_01240.sofa', '0faa852d69b3954a52a2fd6eeadd044b'),
            ('UV/05m/UV05m_01242.sofa', '42c76ff8ea7fdec2cce8c4bb6e371d31'),
            ('UV/05m/UV05m_01244.sofa', '661518480f1b706bde71ebe7812432d7'),
            ('UV/05m/UV05m_01245.sofa', '1656ee5132c917fe753786daf69d82e5'),
            ('UV/05m/UV05m_01248.sofa', '48a0658f9fbf2968550417f66ceece8f'),
            ('UV/05m/UV05m_01251.sofa', '33e2dbf7a9c22a310108ea2a9c2afffc'),
            ('UV/05m/UV05m_01252.sofa', '08040712a2f48c4c12ed875a45c140b2'),
            ('UV/05m/UV05m_01254.sofa', '6f7a491d9e8acaba732dcf5322f79dd9'),
            ('UV/05m/UV05m_01256.sofa', '03d796c4d39c74244f128cbb81855887'),
            ('UV/05m/UV05m_01258.sofa', 'ed6a271e8abfeab040c166ac1b3305f2'),
            ('UV/05m/UV05m_01259.sofa', '1ef96a4e088ec1dff5256739fda24f3e'),
            ('UV/05m/UV05m_01262.sofa', 'eb9e2bccf69a8ffbb4e8a3d4f2a2dd38'),
            ('UV/05m/UV05m_01263.sofa', 'd41682d3d39dccadaf7688b555b0b7ca'),
            ('UV/05m/UV05m_01264.sofa', '36a39bafac8fdeb5a2f480f017aa1ec6'),
            ('UV/05m/UV05m_01265.sofa', 'b7cd0f6000906d5245b3d2aa1aaafa78'),
            ('UV/05m/UV05m_01266.sofa', '3f3ea3c3e611e26e4233a5c5555fd61b'),
            ('UV/05m/UV05m_01268.sofa', 'dd73babafe71172b06a75e30f8682a5a'),
            ('UV/05m/UV05m_01270.sofa', '3c804f5100d463ba6a51286fbd295c74'),
            ('UV/05m/UV05m_01271.sofa', '725b616275de0013442afa9e4ccb2e11'),
            ('UV/05m/UV05m_01272.sofa', 'e42a67b28d06e79c544be37782048363'),
            ('UV/05m/UV05m_01273.sofa', '0454c7ba6d300eb4ff748eb3c42f5334'),
            ('UV/05m/UV05m_01274.sofa', '33a40851028b161d69cc2e22e1ab508e'),
            ('UV/05m/UV05m_01275.sofa', '7fb1e58120f26f503cd4c94a7f397ac3'),
            ('UV/05m/UV05m_01276.sofa', 'd81fae2d8ba7bcba97a4228ed5d5fdd4'),
            ('UV/05m/UV05m_01277.sofa', '5b5fdf4b38fba5fd832deb5e0797958d'),
            ('UV/05m/UV05m_01278.sofa', '3934199f359d5f9ae93547fc70737473'),
            ('UV/05m/UV05m_01279.sofa', '51f28c4252eda555514bbead7bf1beae'),
            ('UV/05m/UV05m_01280.sofa', '489042e667be907c07827b4411eb9b99'),
            ('UV/05m/UV05m_01282.sofa', 'b9d56f23bafe44452b31e2b3dd25d34e'),
            ('UV/05m/UV05m_01284.sofa', '756d3ce1b6fedf945275518bfd2ee071'),
            ('UV/05m/UV05m_01286.sofa', '90e0538ff7e7320849571ae05f2bff37'),
            ('UV/05m/UV05m_01288.sofa', '6f14f4e3c8236669f3917fa9c02e638b'),
            ('UV/05m/UV05m_01290.sofa', 'd407602ea31e6b09e16bc9534613789d'),
            ('UV/05m/UV05m_01291.sofa', 'b0014977b24955471ba2ea89fc9b444c'),
            ('UV/05m/UV05m_01292.sofa', '83717fff0f5f963203c4c55f7664b204'),
            ('UV/05m/UV05m_01293.sofa', 'b21a453a94766a27ea29a6aa7b80864b'),
            ('UV/05m/UV05m_01294.sofa', '0e0b619fdfc0ba09a1dbe675e27dafab'),
            ('UV/05m/UV05m_01295.sofa', 'cc7bf7e9880979fc7cafb999c1aa13c1'),
            ('UV/05m/UV05m_01296.sofa', 'b4fd5959138b01396a2dbd0127ff4e45'),
            ('UV/05m/UV05m_01298.sofa', 'bdd37efd99ae72dcde3dad6bc3f9c273'),
            ('UV/05m/UV05m_01299.sofa', 'cd8282a1fa1f9d1f2334864fd3814b99'),
            ('UV/05m/UV05m_01301.sofa', '7ac46c682d846343090dd8d914aa30c3'),
            ('UV/05m/UV05m_01302.sofa', '4ee4f441a2c1bf1c1f3b27add0dcb29c'),
            ('UV/05m/UV05m_01303.sofa', '281fabd8c20883a8789d72f55b1deaca'),
            ('UV/05m/UV05m_01304.sofa', '7516e63c5ebe8cc3a879c6731183be98'),
            ('UV/05m/UV05m_01305.sofa', 'a94492537d9d66dcf6b017f297638011'),
            ('UV/05m/UV05m_01308.sofa', 'bfc99e10210ae737541dde406960eec4'),
            ('UV/05m/UV05m_01309.sofa', 'c2c65556d4e88254c66ac014902e93bc'),
            ('UV/05m/UV05m_01310.sofa', '9b8e618c1a2dc31ffa731ca29433fe60'),
            ('UV/05m/UV05m_01311.sofa', '949da22741f6b1e984a2ca1854ff73ae'),
            ('UV/05m/UV05m_01312.sofa', '520ee5144d781abfdf9be2b4f8a33750'),
            ('UV/05m/UV05m_01313.sofa', 'c34a88b530e6e3f31293d79e8a613b47'),
            ('UV/05m/UV05m_01315.sofa', 'fe77cd9913971f07b05718e6a42b88e2'),
            ('UV/05m/UV05m_01317.sofa', 'f720f8b13e86f5be5ce8f92cb5951295'),
            ('UV/05m/UV05m_01318.sofa', '3fc241c5a76caf14fc731fae9aa5ef9f'),
            ('UV/05m/UV05m_01319.sofa', '7f104414025130b738ebedac77e6883f'),
            ('UV/05m/UV05m_01320.sofa', '09d85e61d717949d2dad96b7202c9b15'),
            ('UV/05m/UV05m_01321.sofa', 'ddac82d533fd4963a37ba7c4de22912c'),
            ('UV/05m/UV05m_01324.sofa', 'a9d3257833b325ba653f7313e6f98c86'),
            ('UV/05m/UV05m_01326.sofa', '2426bcad9fed1b0cc4529a1a34afb3de'),
            ('UV/05m/UV05m_01327.sofa', '8f233aebbeebae06b1e6496ba11529ca'),
            ('UV/05m/UV05m_01328.sofa', 'c7ed9259dab26e445a1ae6f51ecda6ee'),
            ('UV/05m/UV05m_01329.sofa', '9e48212df9b32779f92cc6f724c8232d'),
            ('UV/05m/UV05m_01330.sofa', 'a9581dc02bb5568ef9ecd4b71e9939c5'),
            ('UV/05m/UV05m_01331.sofa', '49e8c9ac8b347e6ae0775fb52c890107'),
            ('UV/05m/UV05m_01333.sofa', '9e6a1bdfdc6d81b289e3317c9873d8c3'),
            ('UV/05m/UV05m_01334.sofa', '4f413d993c53f5e88f326281ce810b38'),
            ('UV/05m/UV05m_01335.sofa', '3e734a9ab34dfaa101889f7b32b4bb52'),
            ('UV/05m/UV05m_01337.sofa', '1d83f10eb2197262de780bc7bc8ef111'),
            ('UV/05m/UV05m_01338.sofa', '6fb7fddead8ab394eef19da025e37e31'),
            ('UV/05m/UV05m_01342.sofa', '9c200caec00377542a98f1c64638abe6'),
            ('UV/05m/UV05m_01344.sofa', 'f06ea24246da0b8c11cc694085416186'),
            ('UV/05m/UV05m_01345.sofa', 'c27f96a91e45be547712c92c6599e868'),
            ('UV/05m/UV05m_01346.sofa', 'dfedfe5fbb305afefd58cbb1862e97fa'),
            ('UV/05m/UV05m_01347.sofa', '5256bb222e5cdd4418cb0111711f10b0'),
            ('UV/05m/UV05m_01349.sofa', '643360bb3e6f06117ecd85de46b1a04b'),
            ('UV/05m/UV05m_01350.sofa', '439fd1024fbb0447d2c2d8f2f0d6ab9b'),
            ('UV/05m/UV05m_01351.sofa', '68247a7c77e851f7794d05645a1666a9'),
            ('UV/05m/UV05m_01352.sofa', '8ee840a43e61ef10541e3e2695aff9d7'),
            ('UV/05m/UV05m_01355.sofa', '91c3b3165affe2b76213eb17c097aea2'),
            ('UV/05m/UV05m_01356.sofa', 'e4ef73b4b99cafc2c15db6f0e23977ce'),
            ('UV/05m/UV05m_01357.sofa', 'e33234a909bad495bf5813284f5b4983'),
            ('UV/05m/UV05m_01359.sofa', 'dba0afe0521613e2ca464c8003a823f0'),
            ('UV/05m/UV05m_01360.sofa', 'f569854e5c0dbca04bfea3a45b4b356e'),
            ('UV/05m/UV05m_01362.sofa', '36977530b736b9d6b0000e44e3bf2251'),
            ('UV/05m/UV05m_01363.sofa', '63994bd565db57a8e419a0e6f512bd44'),
            ('UV/05m/UV05m_01364.sofa', '61f2199d06794ea71d33bab9e241dfb6'),
            ('UV/05m/UV05m_01365.sofa', '5fe7aedc527627ef5e8d38a8588f2549'),
            ('UV/05m/UV05m_01366.sofa', 'e885ad62de12d79036bab4d1307d691c'),
            ('UV/05m/UV05m_01367.sofa', '181ae379b2d9eb2b90764524425823cb'),
            ('UV/05m/UV05m_01370.sofa', 'f602290ab9df56c5d8f9599cc6532481'),
            ('UV/05m/UV05m_01371.sofa', 'd43e6ac0c19fd71ac2b5f6793d13080e'),
            ('UV/05m/UV05m_01372.sofa', '4ac40d12241d5f7b71179c0cad0606e2'),
            ('UV/05m/UV05m_01373.sofa', '81f93dfb4a83ff9ac85d988f82d80a52'),
            ('UV/05m/UV05m_01374.sofa', 'c0b0246b7bded336459ad0e7d765c21f'),
            ('UV/05m/UV05m_01375.sofa', '1f1450162588cbb1aacc8d91ce080f49'),
            ('UV/05m/UV05m_01376.sofa', 'eec4e4444f5afffe1a2a8ce48f427597'),
        ],
        'UV-1m': [
            ('UV/1m/UV1m_00001.sofa', '27504b8f910ad827aaaf46b8c9812109'),
            ('UV/1m/UV1m_00002.sofa', 'b89f34fb3fc7e7114f182a814f4ae50d'),
            ('UV/1m/UV1m_00003.sofa', 'a7f11d448952a2886fa8abb6390a169f'),
            ('UV/1m/UV1m_00004.sofa', 'e61daae4fc03cfb83c7f25df081e0d12'),
            ('UV/1m/UV1m_00005.sofa', '9a204d49c2d80328682756831ce889a8'),
            ('UV/1m/UV1m_00007.sofa', '8d2b4988a4c7bbdaaa339aeb0edc80b3'),
            ('UV/1m/UV1m_00009.sofa', 'dca4a0b2559753758d3b0d82d4374837'),
            ('UV/1m/UV1m_00010.sofa', '7fe4fd1ce8795eace36c02a29a162745'),
            ('UV/1m/UV1m_00011.sofa', '3d2e53088e91718f078f79fe8a0cc881'),
            ('UV/1m/UV1m_00013.sofa', '1bbdff0e217704ffc4c334922bb7bd0b'),
            ('UV/1m/UV1m_00014.sofa', 'e59bcf81f8d5f2a54aabd771668d7618'),
            ('UV/1m/UV1m_00015.sofa', '26690537919d7021f714c5e86d0571f6'),
            ('UV/1m/UV1m_00016.sofa', '39927fc7310146d44126b3562df319b3'),
            ('UV/1m/UV1m_00020.sofa', 'a34ef0511eba54ffcbcd1dc00603b375'),
            ('UV/1m/UV1m_00021.sofa', '420d0679824a87840f4848922351cc93'),
            ('UV/1m/UV1m_00022.sofa', '6930cb055e7d61f33773a0d276f9228b'),
            ('UV/1m/UV1m_00023.sofa', '19f71f0fe155a0be96eb8f43fd1bbfd9'),
            ('UV/1m/UV1m_00024.sofa', '7f737900ac90a13643777a31602f2dfb'),
            ('UV/1m/UV1m_00025.sofa', '2b6bc2893be35ff55b000d7797f0f633'),
            ('UV/1m/UV1m_00026.sofa', '573548fa530f55a0476eba189be56249'),
            ('UV/1m/UV1m_00027.sofa', '25be3c2dc8b83d5c355782a8cbca3051'),
            ('UV/1m/UV1m_00029.sofa', '841ff940e084a8483813a7a1476d0033'),
            ('UV/1m/UV1m_00030.sofa', '72193dca1e104650e564f3eb62a1bbb5'),
            ('UV/1m/UV1m_00031.sofa', 'e1f0e1dc456e7b91c0e72f4d95abb014'),
            ('UV/1m/UV1m_00032.sofa', '4298ea8405020991b9473f239d977b13'),
            ('UV/1m/UV1m_00033.sofa', 'a7f75f9e47df8d4fb82407f18cbf0c8b'),
            ('UV/1m/UV1m_00036.sofa', '8f12b7fdc936ab825c8b9c3f8749e73c'),
            ('UV/1m/UV1m_00038.sofa', 'cd2f7d79156c6acdb83638551f7d3449'),
            ('UV/1m/UV1m_00039.sofa', '453d47905838c4f1a16a84ed25f467c3'),
            ('UV/1m/UV1m_00042.sofa', 'f8970a3ba32632ce0f09279d32ada329'),
            ('UV/1m/UV1m_00043.sofa', 'cf33f99d5093062c40829dcb704cc860'),
            ('UV/1m/UV1m_00044.sofa', 'eb693a4438c0cdc34f367a00ac5ec5f0'),
            ('UV/1m/UV1m_00045.sofa', 'debb16b6a1a102c9ddf66d3b52c388b2'),
            ('UV/1m/UV1m_00048.sofa', '9528b3f0ac6f8f5087d0104db8ee801b'),
            ('UV/1m/UV1m_00049.sofa', '82d541f9fed3b46a1a3104bff07847e9'),
            ('UV/1m/UV1m_00054.sofa', '979b3d8417e15c18c486684f68123fb6'),
            ('UV/1m/UV1m_00056.sofa', 'a6ece73b7ad6cbdb4c850c177e6aa313'),
            ('UV/1m/UV1m_00057.sofa', '1543782dec808259095de2e9f8a7619d'),
            ('UV/1m/UV1m_00058.sofa', '5cc5a50868b5cead8af5090971dc3498'),
            ('UV/1m/UV1m_00059.sofa', 'c7c47d615fee58dde28288b3f20db566'),
            ('UV/1m/UV1m_00061.sofa', '6da1f79e7e88c511f1f914ff6c940a53'),
            ('UV/1m/UV1m_00062.sofa', '7b9fe07d8c8c827276a747a4bcf0f2ef'),
            ('UV/1m/UV1m_00063.sofa', 'a6306b38ed9a5f5facb1aa1c9f22598b'),
            ('UV/1m/UV1m_00064.sofa', '8692d7093fe64dfc81aac6a7bedfa8ec'),
            ('UV/1m/UV1m_00065.sofa', '6eafa23b77367d7eaeada79c99f81316'),
            ('UV/1m/UV1m_00068.sofa', 'a145431abaadf7b8cf2a1b04fb187dcb'),
            ('UV/1m/UV1m_00069.sofa', '2cd3cc00c05ed5ece62a35d11724b91b'),
            ('UV/1m/UV1m_00071.sofa', 'd89abb03d1444028d43d159d62788e33'),
            ('UV/1m/UV1m_00072.sofa', 'd219d8aea7f39d578356bbc42defaa31'),
            ('UV/1m/UV1m_00074.sofa', 'da572fd5d9a982cbc28e96cd0b8fdd74'),
            ('UV/1m/UV1m_00076.sofa', '4fb6d8559ab08221585d047fa8416a65'),
            ('UV/1m/UV1m_00078.sofa', '0b0749b96d3116e07db6b03ccaa72ff2'),
            ('UV/1m/UV1m_00079.sofa', '027f5a0655ecdc824f142a9e9ae96709'),
            ('UV/1m/UV1m_00082.sofa', '7c1399b9b83a6e1eb39482f18d617ca1'),
            ('UV/1m/UV1m_00083.sofa', '0b0fd68ee3b828eeefb3c635dc1a76fe'),
            ('UV/1m/UV1m_00085.sofa', 'a787d99c4a510ed4ab74b1bc9057e331'),
            ('UV/1m/UV1m_00086.sofa', 'e4d83293e32be52132953ee161d95278'),
            ('UV/1m/UV1m_00087.sofa', 'b7adf13d16b352f6482cdaded2c30c80'),
            ('UV/1m/UV1m_00089.sofa', 'd6d38481ee3eebf37885e8d27f06883c'),
            ('UV/1m/UV1m_00090.sofa', 'feab7f9a1935cc36aa726beac93df558'),
            ('UV/1m/UV1m_00092.sofa', 'ad4449944554a9a49c30ceb46d5e3338'),
            ('UV/1m/UV1m_00095.sofa', '85ad009e09c44a19cf3a2f66f0de8177'),
            ('UV/1m/UV1m_00097.sofa', '1e5af9eea4b0985969aa97d28a4acdd5'),
            ('UV/1m/UV1m_00099.sofa', 'a96a48e7867a1e1df56f6b2e2bb4491c'),
            ('UV/1m/UV1m_00100.sofa', '84ce345d0b793bc017a5f2d11edde81b'),
            ('UV/1m/UV1m_00101.sofa', 'bbecacb733024da38a8038d07f20ee89'),
            ('UV/1m/UV1m_00103.sofa', 'd3d35c32b769473c24a7ea872b74510a'),
            ('UV/1m/UV1m_00104.sofa', 'efa4001e0449391d6f08589cec0337f0'),
            ('UV/1m/UV1m_00107.sofa', 'eb717d7247ee7cd925337eb2e7a397df'),
            ('UV/1m/UV1m_00108.sofa', '30fa2d02e6a5aab9633e2c828aa4d1ce'),
            ('UV/1m/UV1m_00109.sofa', 'd8b296ead5e6947cadc10469cd84aba7'),
            ('UV/1m/UV1m_00110.sofa', '2da2c2afcf8b0e3cb2a0427d860ff004'),
            ('UV/1m/UV1m_00111.sofa', '2a51e802843cb3b762a5e7c6614f9a4d'),
            ('UV/1m/UV1m_00112.sofa', 'fd20081fc40d9b7132e70630773e89ac'),
            ('UV/1m/UV1m_00113.sofa', '2592f8e572fcac60e1ef8077d52f414c'),
            ('UV/1m/UV1m_00114.sofa', '8bfb5d43267d7290c4def2c2684e4404'),
            ('UV/1m/UV1m_00118.sofa', '205a3748878b65967d6b7183e588ebd8'),
            ('UV/1m/UV1m_00119.sofa', '7c27e9ae553a851f02295587b496f721'),
            ('UV/1m/UV1m_00120.sofa', 'fc6cededc766f15a1c08f8303b18c86b'),
            ('UV/1m/UV1m_00121.sofa', '784cb1c4094022effbd2d85f462215d8'),
            ('UV/1m/UV1m_00125.sofa', '24fb37ed28ba6acf1aad8b99301af158'),
            ('UV/1m/UV1m_00126.sofa', 'e3a9bec9c9730a500906fbb3f92fbf7e'),
            ('UV/1m/UV1m_00127.sofa', '344fd248fd2996429f802baf687af5bb'),
            ('UV/1m/UV1m_00128.sofa', 'e7100611ca1296d729b2dd48c8839162'),
            ('UV/1m/UV1m_00130.sofa', '6ad1a8d53fa02ffd9d76a62fc7acfd1f'),
            ('UV/1m/UV1m_00131.sofa', '1554a9c53448203ec56516373e79bbe1'),
            ('UV/1m/UV1m_00132.sofa', '013fcf03104af79054011ca070a1ab39'),
            ('UV/1m/UV1m_00133.sofa', 'a85f878004f3f1d7a13fc545880c566c'),
            ('UV/1m/UV1m_00136.sofa', '1ed763577bc3736fdc2cb1cc196912e8'),
            ('UV/1m/UV1m_00137.sofa', '20a9f1b6f45b654012aa837ad3daa357'),
            ('UV/1m/UV1m_00139.sofa', 'e5cbc8435dd8731ec1ec6ff885dc1efa'),
            ('UV/1m/UV1m_00140.sofa', '641fb5fbfda1f76d15ff6b55bcdb2a56'),
            ('UV/1m/UV1m_00142.sofa', '59ec68733477dea2280754d24302d72e'),
            ('UV/1m/UV1m_00145.sofa', '4cd8f956dcac0bd284fa16f05784ef4a'),
            ('UV/1m/UV1m_00146.sofa', '852537222a52229989f57bc8f0f741a6'),
            ('UV/1m/UV1m_00147.sofa', '8dacd70859c6ddebdc11f1d3eb496106'),
            ('UV/1m/UV1m_00148.sofa', 'de2eaeda14ba36f4b152b32ce0d3aa11'),
            ('UV/1m/UV1m_00149.sofa', 'f821c5dcdc1369b7a7837fe0ed5ff552'),
            ('UV/1m/UV1m_00150.sofa', '69ee72c6ba7a830da71cb72020226afb'),
            ('UV/1m/UV1m_00152.sofa', 'ca23c9a8ac37d4bdc1d4019b3bf334de'),
            ('UV/1m/UV1m_00153.sofa', '6505a825074fdd5b6fa35315dd125b8a'),
            ('UV/1m/UV1m_00154.sofa', '12c8cb88d42815fc5b1db1fb740fc975'),
            ('UV/1m/UV1m_00155.sofa', '34ad34a001feb9a936f2d1fb8286258b'),
            ('UV/1m/UV1m_00156.sofa', '60fc22331403c84fc2e54e8cb5e7b15e'),
            ('UV/1m/UV1m_00157.sofa', '162df6cf81425178ca4ac8283b521a5b'),
            ('UV/1m/UV1m_00158.sofa', '58439a6d95e89971879c3767b65fcf32'),
            ('UV/1m/UV1m_00159.sofa', '754d3e8afbab0227ebebb88ba00904e8'),
            ('UV/1m/UV1m_00161.sofa', '40c5984b39257e855d1ed95f246c808a'),
            ('UV/1m/UV1m_00164.sofa', '9daa775fb67e70420863c882d4145ec9'),
            ('UV/1m/UV1m_00165.sofa', '22e710123e5966cd6cda66aa686c8424'),
            ('UV/1m/UV1m_00166.sofa', 'bdd56ec8647d65da2df69194e870a330'),
            ('UV/1m/UV1m_00168.sofa', '9154331ad84beaac0b9e24b23f45e1f4'),
            ('UV/1m/UV1m_00169.sofa', 'dc7e68985e63a9e1e2863da5482975ee'),
            ('UV/1m/UV1m_00170.sofa', '2248fd2d8c96488609781cea668ad67b'),
            ('UV/1m/UV1m_00171.sofa', '6829b955312cc92cfb2860e20ae9d8e3'),
            ('UV/1m/UV1m_00173.sofa', 'd3f5461a20797ddffaa0b85a24ca1b75'),
            ('UV/1m/UV1m_00175.sofa', '6daa2f516e5a45d254701ab584a60f4d'),
            ('UV/1m/UV1m_00176.sofa', 'b387e3ea1ff4c55395be639c8245ba8e'),
            ('UV/1m/UV1m_00177.sofa', '7c086c090fe446a7a0c656c3ae7bf55f'),
            ('UV/1m/UV1m_00178.sofa', 'fa63f86cf1e848cfbc2db47c3226451e'),
            ('UV/1m/UV1m_00179.sofa', 'fcad0d0272d957ee1509d77e6c47b689'),
            ('UV/1m/UV1m_00183.sofa', '330b1c7d9652ff02fff2b9177f762288'),
            ('UV/1m/UV1m_00184.sofa', '52c3432d41a1519485aa622a8aeee19e'),
            ('UV/1m/UV1m_00185.sofa', '065805bf966f94bee17b4b1d89306989'),
            ('UV/1m/UV1m_00186.sofa', 'e8b7b8934f1d0282b996e5ec19e0e137'),
            ('UV/1m/UV1m_00188.sofa', 'd760aa6eef384a792206addec74c0554'),
            ('UV/1m/UV1m_00189.sofa', 'cd09c019271ccb18e2c2ef23e7c26513'),
            ('UV/1m/UV1m_00190.sofa', 'd5944b361b07dd77323b506cfbd8bff4'),
            ('UV/1m/UV1m_00191.sofa', '6d6f71760d5e1ae8d7a3d17e04835665'),
            ('UV/1m/UV1m_00194.sofa', 'b1820823f7904ef8664aa2ecaa89b5bf'),
            ('UV/1m/UV1m_00195.sofa', '25f4a8f6ce1e5c28588d4c5b57679045'),
            ('UV/1m/UV1m_00196.sofa', '51719a47f915814a4b37d1e70bd607ed'),
            ('UV/1m/UV1m_00197.sofa', '1d88d453f43f68735d3f08457f5adb6b'),
            ('UV/1m/UV1m_00198.sofa', 'eb982562be2a8104b696f4246bb4aa8b'),
            ('UV/1m/UV1m_00201.sofa', 'c34044d12872b2f6c55c5ec00ebe5ad3'),
            ('UV/1m/UV1m_00203.sofa', 'd58d522c14a69dfe603fa6d5faa9ed2e'),
            ('UV/1m/UV1m_00204.sofa', 'cb0aeb9389e5653b421827065ad1df02'),
            ('UV/1m/UV1m_00205.sofa', 'a5530907b5f93223fe737b2dc9b00539'),
            ('UV/1m/UV1m_00206.sofa', 'ab33462c474e4e90a34e5e55503d67c1'),
            ('UV/1m/UV1m_00209.sofa', '0bfd06b33aa7073a17bcdc9a7a76e546'),
            ('UV/1m/UV1m_00210.sofa', 'db405bd6a8172e622f8bd56c5f284ac3'),
            ('UV/1m/UV1m_00211.sofa', '9b35b878ef89caa1c309a707ef61a212'),
            ('UV/1m/UV1m_00212.sofa', '0d64e368504949b55f6c6e92d1ff1325'),
            ('UV/1m/UV1m_00213.sofa', '810e1430d11dd0a8a6057fa5929f1e65'),
            ('UV/1m/UV1m_00214.sofa', 'bf5bd64ce6c0e6f832ff08de2bcc5417'),
            ('UV/1m/UV1m_00215.sofa', 'f2f21041e9a470519a37a9c4c2a0bd20'),
            ('UV/1m/UV1m_00216.sofa', '28795635c6bb92a28b7517ae1e7aa6e2'),
            ('UV/1m/UV1m_00217.sofa', '1e74666f0b880da577a9df6364e31c99'),
            ('UV/1m/UV1m_00219.sofa', 'b7abddfe7edfb6519b3e9913e6652104'),
            ('UV/1m/UV1m_00220.sofa', '8b9d2a71c41d6c0b94d6bf7ccd938683'),
            ('UV/1m/UV1m_00221.sofa', 'ac150ce13da12742a0ddb55e8567d969'),
            ('UV/1m/UV1m_00222.sofa', '032bc74bad750580669e1d95221b2185'),
            ('UV/1m/UV1m_00223.sofa', 'ca3d1e05b7df9fbb65789c5d0d2a4d4c'),
            ('UV/1m/UV1m_00224.sofa', 'cb859162d9bf0fdf2ef72974190cf723'),
            ('UV/1m/UV1m_00225.sofa', '6ef1527d0f10b9cfee5115292fa4ee81'),
            ('UV/1m/UV1m_00226.sofa', 'a3d85cef30e48cb03cf58a7c8e192724'),
            ('UV/1m/UV1m_00227.sofa', '9fd155d5fb2fe37c4f1363f548c90d65'),
            ('UV/1m/UV1m_00228.sofa', '2c2c957dfcc5c8509ed5a56c25177600'),
            ('UV/1m/UV1m_00229.sofa', 'f55ed2eaf8be62e9c6764a1b487ccdb7'),
            ('UV/1m/UV1m_00230.sofa', '3841e41ef53997860a5f55b47c0af19d'),
            ('UV/1m/UV1m_00231.sofa', '31f41f4778c33182ef01f822c1fa975a'),
            ('UV/1m/UV1m_00232.sofa', 'e3eca5e81b3aedff079ea64559f8da13'),
            ('UV/1m/UV1m_00233.sofa', '3a85bd5b5dc751322d2a9a43c2b2383c'),
            ('UV/1m/UV1m_00234.sofa', '8c2237f54476c5d17fb194a872c23b6d'),
            ('UV/1m/UV1m_00235.sofa', '4dcdbe420590a22183a016b3f1dbe864'),
            ('UV/1m/UV1m_00236.sofa', '4f10e749d65cfba39fbbffb3cccccd7f'),
            ('UV/1m/UV1m_00237.sofa', '4a5b7acd88cb65644606b07454a29303'),
            ('UV/1m/UV1m_00238.sofa', 'fe3e066b5db2f601a9b8e1be6f356631'),
            ('UV/1m/UV1m_00239.sofa', 'a3bc6755c72ff0597aea55d6fa86cfa9'),
            ('UV/1m/UV1m_00240.sofa', '8de8909550ccd9d1234a2d3b7d204613'),
            ('UV/1m/UV1m_00241.sofa', 'b5caaa7bde56ed18cd641f7a34025e07'),
            ('UV/1m/UV1m_00244.sofa', '33450715b3bb87b5530ef03987c9b34d'),
            ('UV/1m/UV1m_00245.sofa', 'a4457a9c77a8ea0d5fc326ed93dd24f5'),
            ('UV/1m/UV1m_00246.sofa', '1955f3efef41e162d73876833fa361ad'),
            ('UV/1m/UV1m_00247.sofa', '118dbd9c437d9b2f2d75d0ef08008b1c'),
            ('UV/1m/UV1m_00248.sofa', 'da2738dfc31073eba119932be20d707f'),
            ('UV/1m/UV1m_00251.sofa', '233efcd6f42c75bde25a8f6d3eaf997a'),
            ('UV/1m/UV1m_00252.sofa', 'e885204a4b5d184c0c837ff527930697'),
            ('UV/1m/UV1m_00253.sofa', '4bcaa848c493da47fc9fcf30bf746f9a'),
            ('UV/1m/UV1m_00254.sofa', 'bbc99fcb91bc94483358306e1a65d838'),
            ('UV/1m/UV1m_00256.sofa', 'bcf25796ac6b981d7e13a16c56915b69'),
            ('UV/1m/UV1m_00258.sofa', '76f6e37d8a69ce9bb795ac57f550ca55'),
            ('UV/1m/UV1m_00259.sofa', '27fa52e7ec737a294a3500def551afaf'),
            ('UV/1m/UV1m_00261.sofa', '12fc65dadded1778e45541c574277002'),
            ('UV/1m/UV1m_00262.sofa', 'd3d987ddccefba639d27beaf91713b8b'),
            ('UV/1m/UV1m_00263.sofa', 'ba67d5413ce99dc845bdef1e9091843a'),
            ('UV/1m/UV1m_00264.sofa', '1e70ed81277d48b044b2e1eaeed688df'),
            ('UV/1m/UV1m_00265.sofa', '0babf6c8f0406a42194d8c4eea0c0380'),
            ('UV/1m/UV1m_00268.sofa', 'ead329819da8377cb69a16ec6e84c63f'),
            ('UV/1m/UV1m_00269.sofa', '11de24938ea1d552c773d07c0b079382'),
            ('UV/1m/UV1m_00270.sofa', '0dacaf2138f73b11202629b0aa09b63d'),
            ('UV/1m/UV1m_00271.sofa', '91a5b0077ccdede3e5d35f6704ef5383'),
            ('UV/1m/UV1m_00272.sofa', 'b5abc30fd3cd817d5ba356328a04c397'),
            ('UV/1m/UV1m_00273.sofa', '8e90809d1a4d6f610e2d932b5a614486'),
            ('UV/1m/UV1m_00275.sofa', '2306fd26e0f28790139191da794a8ba0'),
            ('UV/1m/UV1m_00276.sofa', 'e03bccfe103a5ede95f76d728609319e'),
            ('UV/1m/UV1m_00277.sofa', '50032c372b6633c39e7b607abe4bb90e'),
            ('UV/1m/UV1m_00278.sofa', '7f279fb8b8b95c9bd49c30d6186d475e'),
            ('UV/1m/UV1m_00279.sofa', '5283c03bb5fe780f8557bbf96ab92476'),
            ('UV/1m/UV1m_00281.sofa', 'b4837efcaa7d7a9ab52e14b588e2b233'),
            ('UV/1m/UV1m_00283.sofa', '9ba26129ec287c50838e04b43f3b71ef'),
            ('UV/1m/UV1m_00284.sofa', 'c1b001a6200248b2e7949d0b6216652d'),
            ('UV/1m/UV1m_00285.sofa', '56249572bb2cfeb5d345527560c390cb'),
            ('UV/1m/UV1m_00286.sofa', 'fa4ca50952a9341a33e976e144745482'),
            ('UV/1m/UV1m_00287.sofa', '7f766fe7cf3a376558058d575f5d638e'),
            ('UV/1m/UV1m_00288.sofa', '391d6ed05d5fb3d33812dc542c691a5e'),
            ('UV/1m/UV1m_00289.sofa', '2abf16037d06d0c840b692359a419dff'),
            ('UV/1m/UV1m_00290.sofa', 'b302dec5bba7dfd296c42006dc2db9a0'),
            ('UV/1m/UV1m_00291.sofa', '8cc01abae70fa6fc1e4c0dda458ef4a9'),
            ('UV/1m/UV1m_00293.sofa', '3181d8eed74708b680dc6ff7994e58d9'),
            ('UV/1m/UV1m_00294.sofa', '42c92b56bb7ea1cd59617080b2a3a541'),
            ('UV/1m/UV1m_00295.sofa', 'a5f1ae9d7e7b60a70f8fd5d108f79c34'),
            ('UV/1m/UV1m_00296.sofa', '0d09961df2ad2bd814292c3917632a0b'),
            ('UV/1m/UV1m_00297.sofa', 'c3a503c6231106b2a40358ac18ac354c'),
            ('UV/1m/UV1m_00298.sofa', 'eb61d6be6f58d90266299b5e554e75fe'),
            ('UV/1m/UV1m_00301.sofa', '6376cab37b0966d0d29be53989411105'),
            ('UV/1m/UV1m_00303.sofa', 'b6abe15577126fb9a2bb0b0eaa84edcc'),
            ('UV/1m/UV1m_00305.sofa', '9a9f1987b290c0ffa3d368fc65e7c902'),
            ('UV/1m/UV1m_00306.sofa', 'de06a59d756b0bc1289aab418f2fc4c2'),
            ('UV/1m/UV1m_00307.sofa', '8ce6f513ae401b4fe3d34ed4e0b632ba'),
            ('UV/1m/UV1m_00308.sofa', '10f4d92804b6d40be3a2110250c06333'),
            ('UV/1m/UV1m_00309.sofa', 'e2b872276685c12e6b21dab1b791124f'),
            ('UV/1m/UV1m_00311.sofa', '232cad822cebb2ec716a701f0a346c17'),
            ('UV/1m/UV1m_00315.sofa', 'e0acb823050cbfb4d330c23225dbc728'),
            ('UV/1m/UV1m_00318.sofa', 'e6acfd283815254dda9f069b987e333e'),
            ('UV/1m/UV1m_00319.sofa', '0ad2db630c3f2066536c8780a5bc1925'),
            ('UV/1m/UV1m_00320.sofa', 'b575fd7b2dcdc118cf54667767d3a75b'),
            ('UV/1m/UV1m_00321.sofa', '7b68ee609d3b38a765e5924b3bcfe53c'),
            ('UV/1m/UV1m_00322.sofa', 'f9a5edcd85f5f4c76fcd93bf36470142'),
            ('UV/1m/UV1m_00323.sofa', 'a0e7f42ba3fc0ca94535be91a561a04d'),
            ('UV/1m/UV1m_00326.sofa', '775232384c844ed8bd8b4966626bbf3c'),
            ('UV/1m/UV1m_00328.sofa', 'b0804d4aa8b676adb2c30f6be75bc9cd'),
            ('UV/1m/UV1m_00329.sofa', '7976186e466f7e6484f6e186cfa0f5b0'),
            ('UV/1m/UV1m_00331.sofa', 'bb64bc99b7cbdfa6cee43bff3bae7207'),
            ('UV/1m/UV1m_00332.sofa', '263198b1df41b8d895b6694a573374a8'),
            ('UV/1m/UV1m_00333.sofa', '580f2949361ef9988a2b163a66993e50'),
            ('UV/1m/UV1m_00334.sofa', '2ef417d20332741dd8e56244df1ad3f9'),
            ('UV/1m/UV1m_00335.sofa', '4e72b9396cfe27967001eb69332d934a'),
            ('UV/1m/UV1m_00336.sofa', '04f4ee97de0e26ca268440d93f38b3f6'),
            ('UV/1m/UV1m_00337.sofa', 'aef954fa7f803af6f3418188c332560f'),
            ('UV/1m/UV1m_00338.sofa', '5bf0198f12e8b7655f57c501e4b88cdb'),
            ('UV/1m/UV1m_00340.sofa', '9bb8d64fc09126a88d72cb7393dc3664'),
            ('UV/1m/UV1m_00341.sofa', 'e5d6def5b76eb054effb1eb3537da182'),
            ('UV/1m/UV1m_00343.sofa', 'c1a1f0ba1fcaced29565335710c97ba5'),
            ('UV/1m/UV1m_00344.sofa', 'a84b4b209bd7081e460c3a3745236027'),
            ('UV/1m/UV1m_00345.sofa', 'be848f057f2e561d9a8fcaed456edb91'),
            ('UV/1m/UV1m_00347.sofa', 'd518c5273f207783570f574bf105dbd1'),
            ('UV/1m/UV1m_00348.sofa', 'd08faf4d03dd77c29e589d08d1ff649d'),
            ('UV/1m/UV1m_00349.sofa', 'b0c22b7d354aa71cd9f57ad8d3357c02'),
            ('UV/1m/UV1m_00350.sofa', 'da625421ff51b68f5824cf9d38a6c5a4'),
            ('UV/1m/UV1m_00351.sofa', '7f5bb071822d041a27f2cdc0b6d9191b'),
            ('UV/1m/UV1m_00352.sofa', '0f8f526fe2727bc6c3e4b2626ffbff34'),
            ('UV/1m/UV1m_00353.sofa', '80d910277727f29487b69365999f2606'),
            ('UV/1m/UV1m_00354.sofa', 'a790b7e0c8611fceb9aa28cc200c04c1'),
            ('UV/1m/UV1m_00355.sofa', '2cc71942e91f1fb46142f3deae783479'),
            ('UV/1m/UV1m_00356.sofa', '7449f92b32efacca65dfde5058c47f82'),
            ('UV/1m/UV1m_00358.sofa', '44383b7850a1f4c83023a91d517c9048'),
            ('UV/1m/UV1m_00359.sofa', 'ab774331245bdb4d160a253d9e0cd419'),
            ('UV/1m/UV1m_00360.sofa', '8db655de2938ae7c71bd7aaf45044e56'),
            ('UV/1m/UV1m_00361.sofa', '6842d50015ef24658207440064da7700'),
            ('UV/1m/UV1m_00362.sofa', '8905e829057b645b6d8946ab84b5e46d'),
            ('UV/1m/UV1m_00363.sofa', 'bc3b049538d41f06852b740b49272299'),
            ('UV/1m/UV1m_00364.sofa', 'aeeb56cf97a890ea80f6d61be481b943'),
            ('UV/1m/UV1m_00365.sofa', 'e8c4906af05305f9534c050791a8b51c'),
            ('UV/1m/UV1m_00366.sofa', 'acdff61dfc691ac64115f6f5d64c96b3'),
            ('UV/1m/UV1m_00367.sofa', '9a9308e92d6b209005694221fc97bb85'),
            ('UV/1m/UV1m_00368.sofa', '5d745bfb2a75382c8d7fdaf154e9c5f4'),
            ('UV/1m/UV1m_00370.sofa', '077cddeb2d2db8336c63f995bcd6ed49'),
            ('UV/1m/UV1m_00371.sofa', '43b93d834596815fd5f9745becb9444d'),
            ('UV/1m/UV1m_00372.sofa', '4a62a4f3c1b9b8a146de7ee6cb402723'),
            ('UV/1m/UV1m_00373.sofa', '82a46069677bf290dd510e65d57cb976'),
            ('UV/1m/UV1m_00374.sofa', 'dfeb051d90a065e109248e4d0b4fb709'),
            ('UV/1m/UV1m_00375.sofa', '4a8b975ad9ae89ddd25dbf512c72a30c'),
            ('UV/1m/UV1m_00376.sofa', 'd86da501dba4d9292adea284de15c0bf'),
            ('UV/1m/UV1m_00378.sofa', 'abaca6f333111d045d535706c952f098'),
            ('UV/1m/UV1m_00379.sofa', '10a25d8746c7227e04fcb677b17e31db'),
            ('UV/1m/UV1m_00382.sofa', '5b61b04b03b1402b9c4f8e3dbaa6f951'),
            ('UV/1m/UV1m_00383.sofa', '6a9d519b977e1fc17e3f15591d0d22dc'),
            ('UV/1m/UV1m_00385.sofa', '51536a3b5ef8a96be140a56e7b08e058'),
            ('UV/1m/UV1m_00386.sofa', 'bbaca2566442eecde85eb2945838f8bc'),
            ('UV/1m/UV1m_00389.sofa', '2b6b1161cab1b38bcd07d5917f30a665'),
            ('UV/1m/UV1m_00391.sofa', 'd53bdf02218c12bed980cf00b345e05e'),
            ('UV/1m/UV1m_00392.sofa', '04acb9792e2cd88166a8a16a986fe25f'),
            ('UV/1m/UV1m_00395.sofa', '1751efe87bec6d961a0f425b9982d135'),
            ('UV/1m/UV1m_00397.sofa', '21aff82a96f1b8739ac3f305ae4631be'),
            ('UV/1m/UV1m_00398.sofa', 'd5cb31fbda2c45596e63c85139a76d3e'),
            ('UV/1m/UV1m_00399.sofa', '97cb055c73e48688a717b12a6455b0d4'),
            ('UV/1m/UV1m_00401.sofa', '9e6ae25ddef2de1fc71e9f1a747161a2'),
            ('UV/1m/UV1m_00402.sofa', 'c2718b96df265c8d26bb22b898f850c7'),
            ('UV/1m/UV1m_00403.sofa', '681fc03dffca386bd77550ac3582b0e6'),
            ('UV/1m/UV1m_00404.sofa', '76a74e26b2bdeda6df96dd75d44d6b44'),
            ('UV/1m/UV1m_00405.sofa', 'e3d1014717501fea6912ebcd969c0aeb'),
            ('UV/1m/UV1m_00406.sofa', '820a275043e9be42df6ebc735a29d242'),
            ('UV/1m/UV1m_00407.sofa', '5ea51246b3d75c0ab7de60a1bdf2ac4f'),
            ('UV/1m/UV1m_00408.sofa', '5fc7042c643714c62ca4221bc95d43e0'),
            ('UV/1m/UV1m_00409.sofa', '0c1591f36ac8ae074d38723b9f1f4cac'),
            ('UV/1m/UV1m_00410.sofa', '847a544a8e6a1a7bc831dbfb994d4066'),
            ('UV/1m/UV1m_00411.sofa', 'fbf5a1730b0f377315cb16807cdfdccd'),
            ('UV/1m/UV1m_00412.sofa', '7018f3feeb927544bc65bcda679d1c83'),
            ('UV/1m/UV1m_00413.sofa', '65bfe377a130f9b4e398468026ad509d'),
            ('UV/1m/UV1m_00414.sofa', '59a2bbf4bf1fbfb59cea406953aec957'),
            ('UV/1m/UV1m_00415.sofa', '6e31e1db7fb58c91d8bd172df9b2c2e8'),
            ('UV/1m/UV1m_00416.sofa', '59bc36bae0258bc8707ad1a25cb0e1e8'),
            ('UV/1m/UV1m_00417.sofa', 'e4086a082b53cffbc70223bf68aba9cb'),
            ('UV/1m/UV1m_00418.sofa', '713d77bfa9abc23c43d0c1233736ed26'),
            ('UV/1m/UV1m_00419.sofa', '5d056ccef9a4d0e39cde358f783b47c1'),
            ('UV/1m/UV1m_00420.sofa', 'cd7226c12976f0dec94db8ef40c2c8f2'),
            ('UV/1m/UV1m_00421.sofa', '01472e9171d368339beec266b6a38c55'),
            ('UV/1m/UV1m_00422.sofa', 'be1d10a71637d1a7572c35bc7ffbb453'),
            ('UV/1m/UV1m_00423.sofa', '63c61b8adcb35ca4be50aea4ad368d11'),
            ('UV/1m/UV1m_00426.sofa', '54ac545be4ab6243e5c9059dfb52e71e'),
            ('UV/1m/UV1m_00427.sofa', 'd2c92ccbedf130b7811f36a0af7fb9f9'),
            ('UV/1m/UV1m_00428.sofa', '480e52ebde7a34845cb42d6aee09fddd'),
            ('UV/1m/UV1m_00430.sofa', '6853ea27aad0cb27ddf67fab8bf0ac03'),
            ('UV/1m/UV1m_00432.sofa', '2e27102798c1d22fe4173448bbcf9b6b'),
            ('UV/1m/UV1m_00433.sofa', 'cdc488da913e420d7be24bb403b24102'),
            ('UV/1m/UV1m_00434.sofa', 'b5021c57871922ad281c70ed2e281ed7'),
            ('UV/1m/UV1m_00441.sofa', '50f802645bdb6aaa30287c0518c9c8b6'),
            ('UV/1m/UV1m_00442.sofa', '356e462805aa6691a60eb8273df62363'),
            ('UV/1m/UV1m_00443.sofa', '82a89096fb3cee78f8b70b8c1786f2f5'),
            ('UV/1m/UV1m_00446.sofa', 'c343c6bc2bb6e2272a6e3d4c8a091fd7'),
            ('UV/1m/UV1m_00448.sofa', 'ca6251935b95ee782e177ab935040d2a'),
            ('UV/1m/UV1m_00449.sofa', '2ea1d9b201e47c6c2b80a097d97bcef4'),
            ('UV/1m/UV1m_00450.sofa', 'cbbd5b9c1d3e6cc5dd1f5d5cd7444ceb'),
            ('UV/1m/UV1m_00451.sofa', 'b3415170de487e2b4dc3678aa072b9b2'),
            ('UV/1m/UV1m_00452.sofa', 'd60eb9420fd878bf3b76865afc0d43c8'),
            ('UV/1m/UV1m_00455.sofa', 'fa06a365aad8ce1aaa50e8f51aab852e'),
            ('UV/1m/UV1m_00456.sofa', '7094b95ba98317a1f392cf63262496b6'),
            ('UV/1m/UV1m_00457.sofa', '8d50e57d661cfe0b7b07a86ba901d64c'),
            ('UV/1m/UV1m_00459.sofa', '42b863c8649f9a75ecc39fcad4a8be81'),
            ('UV/1m/UV1m_00460.sofa', '6b2791b0451c39fe03ded425b3017e16'),
            ('UV/1m/UV1m_00461.sofa', '9dbcefb15cb09f2ef49874fd2dc69151'),
            ('UV/1m/UV1m_00462.sofa', '49d2e4628059553a75da19fe2ad63bf0'),
            ('UV/1m/UV1m_00463.sofa', '098c179b1efeef6815a5ccca5b9f5fc3'),
            ('UV/1m/UV1m_00464.sofa', 'ae49bc66c4fc6422719d72e1842f541e'),
            ('UV/1m/UV1m_00466.sofa', '765a00349b54a7d913d8d17cbcee1227'),
            ('UV/1m/UV1m_00467.sofa', '010ea37877aea5d08a0575d71da0d7ff'),
            ('UV/1m/UV1m_00468.sofa', '5d551be161397e5157fd160585aaf8ee'),
            ('UV/1m/UV1m_00469.sofa', 'd1f6d661ee22e4d7ff6e07416cb2e767'),
            ('UV/1m/UV1m_00470.sofa', '04b0e2e65198265f437d8c7ca3f2f572'),
            ('UV/1m/UV1m_00471.sofa', '1540433c5d5b159a31385d94aa21f956'),
            ('UV/1m/UV1m_00472.sofa', '8547400c3e05e7f5f96c44168d783879'),
            ('UV/1m/UV1m_00473.sofa', '4dae19cb8b48286d31c71cf36d4e2838'),
            ('UV/1m/UV1m_00474.sofa', '2c305239827a2c25fcb50c281d4d8aee'),
            ('UV/1m/UV1m_00476.sofa', '14e580f58d52dec0984bb8be86ce4c6b'),
            ('UV/1m/UV1m_00477.sofa', 'f13eb7b6f2e90e703b791241c2a5d11e'),
            ('UV/1m/UV1m_00478.sofa', 'dc36c2cbf9ecad60f7c32d711f73bae0'),
            ('UV/1m/UV1m_00480.sofa', 'd23d8003ab93ed979464c48b84865bef'),
            ('UV/1m/UV1m_00481.sofa', '736f70b2aaf56b4bbcd518fcd05996c6'),
            ('UV/1m/UV1m_00482.sofa', '9aa46a3ff65f7a06ecb4529520e16db9'),
            ('UV/1m/UV1m_00483.sofa', 'dce36af1fd1faae24c9e7938a3fe692a'),
            ('UV/1m/UV1m_00484.sofa', '1e4e0853dbbee6301e2b02c4a6dc2667'),
            ('UV/1m/UV1m_00486.sofa', '3dbb80c9dab36e6b08af78cc54173542'),
            ('UV/1m/UV1m_00487.sofa', '9ee12733829bce7ee8744f7fe66d965d'),
            ('UV/1m/UV1m_00489.sofa', '90e381a6c3e1ebe488d2f70e25e68758'),
            ('UV/1m/UV1m_00490.sofa', '280fdfff600fb18354cc7798975524c7'),
            ('UV/1m/UV1m_00491.sofa', '05e006c5b0025ea78a251f6e84e177f7'),
            ('UV/1m/UV1m_00493.sofa', '8c992e3fd07ee2246d7f0dcc45005d46'),
            ('UV/1m/UV1m_00494.sofa', '4feed3c69565d0b52204ceca2bb55302'),
            ('UV/1m/UV1m_00497.sofa', '2b6a00d5997da00ac537453ff04ab08c'),
            ('UV/1m/UV1m_00499.sofa', 'd3568ceee1215df666a47318c31b82ec'),
            ('UV/1m/UV1m_00500.sofa', '4e2d2e20079caabcf7d3478493fa4946'),
            ('UV/1m/UV1m_00501.sofa', '83002e43f06394b3062011e6e8a0bc68'),
            ('UV/1m/UV1m_00502.sofa', '32ee04ab9efed37d5ac177fd4fba8643'),
            ('UV/1m/UV1m_00503.sofa', 'fb6597dbe588a6e8bf61011086eaaa6a'),
            ('UV/1m/UV1m_00505.sofa', 'f2ebf2b0fbe599a75c97d4c346c8ea71'),
            ('UV/1m/UV1m_00506.sofa', 'd9c0a50ae7549aacb444bc4311bb7870'),
            ('UV/1m/UV1m_00507.sofa', '0eca4c6f093cf1b065fdf5d1514d69bf'),
            ('UV/1m/UV1m_00508.sofa', 'c2c73d4ecc7aea2d368786a527dcb16c'),
            ('UV/1m/UV1m_00509.sofa', 'e1716d9d6d8c5301e0cb8f8aa86a9642'),
            ('UV/1m/UV1m_00511.sofa', '013b38bc5bac4d238101bee6ffc7bc43'),
            ('UV/1m/UV1m_00512.sofa', '54c12fefc61e15e69bd890bd9fb2b9f5'),
            ('UV/1m/UV1m_00513.sofa', '1a79e3ad406aaa8adc2ad7ea53eda22e'),
            ('UV/1m/UV1m_00514.sofa', '9334e226552153241e47f7858610f154'),
            ('UV/1m/UV1m_00515.sofa', '5aefce3728bb20a761933746fa27db7b'),
            ('UV/1m/UV1m_00516.sofa', '745e39b2b4f4feb6948ea40c96a02dff'),
            ('UV/1m/UV1m_00517.sofa', 'b497a589ca9717d88ba363b63cccea7e'),
            ('UV/1m/UV1m_00518.sofa', 'eb84988403184ce82da386c96f051aac'),
            ('UV/1m/UV1m_00519.sofa', '9e5b23a1184ca1fdcb2d982c3f6b5240'),
            ('UV/1m/UV1m_00520.sofa', '1c0c3074cbe48b8e689858cd61381082'),
            ('UV/1m/UV1m_00521.sofa', 'b0ff0e990f458b1c1991dfd4647ef598'),
            ('UV/1m/UV1m_00523.sofa', '0df26ce0803d6d8f2bb55c6b4f64a92e'),
            ('UV/1m/UV1m_00524.sofa', 'da8d86faa5b94ec647cec190f5ea61ee'),
            ('UV/1m/UV1m_00525.sofa', 'a23ba67dbe4b2cfd04cfa18174f34938'),
            ('UV/1m/UV1m_00526.sofa', '27bf3d5bff3f0a6323366c800c2be586'),
            ('UV/1m/UV1m_00527.sofa', 'ff95fdb32bbf1a41bdf55b3aafc41216'),
            ('UV/1m/UV1m_00528.sofa', 'ded203db1007e37534bea308f3a37899'),
            ('UV/1m/UV1m_00529.sofa', '70faa2293958d37fe662566aa721c0a3'),
            ('UV/1m/UV1m_00530.sofa', 'b333535913a45582479247880679ca37'),
            ('UV/1m/UV1m_00532.sofa', 'cfdad5e995311ca19678302a0d91a120'),
            ('UV/1m/UV1m_00533.sofa', '1a39bda6742561bd001868598db52f97'),
            ('UV/1m/UV1m_00534.sofa', '09d82c6a766a150cea2f011c64a43d34'),
            ('UV/1m/UV1m_00536.sofa', '7644f2339101e7f9de3421bea253d198'),
            ('UV/1m/UV1m_00538.sofa', '86e52fb79469dcc876dc766d28d209cd'),
            ('UV/1m/UV1m_00539.sofa', '34ab21626ec416f82189354cbceccf5a'),
            ('UV/1m/UV1m_00540.sofa', '99d021bdcb72f7bd1b9e1e92c6fa65b8'),
            ('UV/1m/UV1m_00542.sofa', '541089139c81fb1e7f60ede9d1b40f9b'),
            ('UV/1m/UV1m_00543.sofa', '96ab735db145311e38eeeccaacd25f04'),
            ('UV/1m/UV1m_00544.sofa', '6ea05ae3186aace8da307ea6c69bf19d'),
            ('UV/1m/UV1m_00545.sofa', 'd4a7b79f7d1eab801c3eca8829eb7db7'),
            ('UV/1m/UV1m_00546.sofa', 'ce37233f5f113dee45a13de347d58df3'),
            ('UV/1m/UV1m_00547.sofa', '5e3a73849d1e93deda169a9e5624f4bf'),
            ('UV/1m/UV1m_00548.sofa', '4c7df080fa473f3b4eacf62aed1358c6'),
            ('UV/1m/UV1m_00549.sofa', 'cf4fc4fe06473e53305b394161997578'),
            ('UV/1m/UV1m_00550.sofa', '16aac89c293777bdc059772269e2c598'),
            ('UV/1m/UV1m_00551.sofa', '461ce02ffdb35aa66234b85c4664ab3c'),
            ('UV/1m/UV1m_00552.sofa', '465a1884ceef1d2655fd7954a14afd8a'),
            ('UV/1m/UV1m_00553.sofa', 'bdd3fcd5e9d1f818b4bdb9539171d55e'),
            ('UV/1m/UV1m_00555.sofa', 'df156d6097f32c2e828d83f99a3570be'),
            ('UV/1m/UV1m_00557.sofa', 'd6cd072fc3b049b12be3d03c25df4b89'),
            ('UV/1m/UV1m_00558.sofa', 'acc1c7cecf3f8c96d8bfb49b26129d25'),
            ('UV/1m/UV1m_00559.sofa', '4ff734a1fafa794653eecf37609db9bd'),
            ('UV/1m/UV1m_00560.sofa', '1bcb9a5bbd5e56462e01d0d54e9714c0'),
            ('UV/1m/UV1m_00561.sofa', 'd6f5d70b7dd6693baab9753dbcbb7540'),
            ('UV/1m/UV1m_00562.sofa', '367f869e64b0e09b17e8e1181ab17a78'),
            ('UV/1m/UV1m_00563.sofa', 'e389885d7684f567885fac7325125a8a'),
            ('UV/1m/UV1m_00567.sofa', '19e34e19af6558e17712ff26e8474219'),
            ('UV/1m/UV1m_00568.sofa', '30171ed6c8402e6cdfc2bacc9d0eacf8'),
            ('UV/1m/UV1m_00569.sofa', 'c5262fb8f44698d8ce8cb76c17190cbb'),
            ('UV/1m/UV1m_00570.sofa', '0b86c715f80566e78b3a9e7a4271e795'),
            ('UV/1m/UV1m_00571.sofa', 'a8ddfb2c00889f5ca007d8414421645e'),
            ('UV/1m/UV1m_00572.sofa', '2098e41e247ba53e864e314af132176c'),
            ('UV/1m/UV1m_00573.sofa', 'fd28bec01a923f7bd85166fb3e033e76'),
            ('UV/1m/UV1m_00576.sofa', '5fa9e79231c0edaf1940487dd30622b8'),
            ('UV/1m/UV1m_00577.sofa', 'f6c2817e0a4974fee35784d48a44976a'),
            ('UV/1m/UV1m_00580.sofa', '9f4a29fe80509ad6d01982a3428b87ec'),
            ('UV/1m/UV1m_00582.sofa', '0c8cdce9f0487b8c53f1cbd801d11172'),
            ('UV/1m/UV1m_00583.sofa', 'd783207a093c6d273aa790e015fe0512'),
            ('UV/1m/UV1m_00585.sofa', 'b8a91048ab6e64e7b6b26c12dea821c2'),
            ('UV/1m/UV1m_00588.sofa', '1a6a9eeb6b26bd9f60184ac7c439a13a'),
            ('UV/1m/UV1m_00590.sofa', '1c9560b0d3096f895c1fad494967e539'),
            ('UV/1m/UV1m_00591.sofa', 'ecf216f0634de2ed7a8ad74e5ae24648'),
            ('UV/1m/UV1m_00592.sofa', '49f896724131add6526e3195ef030b7e'),
            ('UV/1m/UV1m_00593.sofa', 'bc7f91ae405b33b728e57fa4a01487b7'),
            ('UV/1m/UV1m_00594.sofa', '14a8b98f1fde7b81eb81e6927c4bff00'),
            ('UV/1m/UV1m_00595.sofa', 'd8003517f1d68d389c25a29772978738'),
            ('UV/1m/UV1m_00596.sofa', '44ac3171ba541c793bcd41cfe86e4a7e'),
            ('UV/1m/UV1m_00597.sofa', '3c9d914d3d5df13f9f31bb2aff3c06c0'),
            ('UV/1m/UV1m_00598.sofa', '19d244d57bbbb4c6f77c82ee3d7780b5'),
            ('UV/1m/UV1m_00599.sofa', '923f4ba2bd114fa7455233f9c2a5831a'),
            ('UV/1m/UV1m_00600.sofa', '4aee6b41486b5b32ecabe33d8fbd34cd'),
            ('UV/1m/UV1m_00601.sofa', '2afd284667e88082aa6463fb9c6117ec'),
            ('UV/1m/UV1m_00604.sofa', 'c718b18bb1086a2435a5273aab4cc2f1'),
            ('UV/1m/UV1m_00606.sofa', 'aee774ab29f8a81c6562d6d2791ed938'),
            ('UV/1m/UV1m_00608.sofa', 'bfa269edfe4b7635daa71b62744b0b12'),
            ('UV/1m/UV1m_00609.sofa', 'a4ce5d06975ec4397b1b382dd143fb01'),
            ('UV/1m/UV1m_00613.sofa', '46d1c37b3d193e8176cbb214e0d1ab7e'),
            ('UV/1m/UV1m_00616.sofa', 'bc5989d480481b726cf99117574d33df'),
            ('UV/1m/UV1m_00617.sofa', 'b5d89cdaacc9549f0faf39a020290c2e'),
            ('UV/1m/UV1m_00618.sofa', '78f0f075d60ecabe397112fa57c419ea'),
            ('UV/1m/UV1m_00619.sofa', '1b000d1fc8a28176977dd955bfa7f9e7'),
            ('UV/1m/UV1m_00620.sofa', 'd4a681d1b6f0af2d37e3c48d70d92917'),
            ('UV/1m/UV1m_00621.sofa', '702b9ab9252861055f981da014d00c0b'),
            ('UV/1m/UV1m_00622.sofa', 'ca7e03db18e16f8630a9809ad6ba4e5b'),
            ('UV/1m/UV1m_00623.sofa', 'dc4283aa99db0660fff0d47c05b5b546'),
            ('UV/1m/UV1m_00624.sofa', '91620ea56805adaa0ba710d8ca9bf01b'),
            ('UV/1m/UV1m_00625.sofa', '11902c3e4a6748208ef144466d8b556a'),
            ('UV/1m/UV1m_00626.sofa', 'd5b4ed920bdaa12b559b15c755ccbee8'),
            ('UV/1m/UV1m_00628.sofa', 'b327cf35226c8f9268a4672c62b1fc96'),
            ('UV/1m/UV1m_00629.sofa', '2177f2f47ea274b7bde5c5bdf0b648cc'),
            ('UV/1m/UV1m_00630.sofa', '160cc829ba3c9d7e2cca343c4c51ee98'),
            ('UV/1m/UV1m_00631.sofa', '4c5c8236f0f5da53774194b3da0f9aaa'),
            ('UV/1m/UV1m_00632.sofa', '8b2e436b25af6a3ddcadc710a1e36ad3'),
            ('UV/1m/UV1m_00633.sofa', '4072f84d0b003353eba0317bd2667141'),
            ('UV/1m/UV1m_00634.sofa', 'e2becf87e21f6f8f213db3cedc582a81'),
            ('UV/1m/UV1m_00635.sofa', 'd93d667c49299cf662a00725764b1a54'),
            ('UV/1m/UV1m_00636.sofa', '1c31a3df99695f21a3386e2ed59252fc'),
            ('UV/1m/UV1m_00637.sofa', 'dfc9bbb10ef52ba973ffb8dcda2ae151'),
            ('UV/1m/UV1m_00640.sofa', '9d0af6ef9e82dbf9b1134dd15ca52cc9'),
            ('UV/1m/UV1m_00642.sofa', '249512e68cd84581d2be91ba39add54e'),
            ('UV/1m/UV1m_00643.sofa', '288716d3daffaaab139e96bf861e1f36'),
            ('UV/1m/UV1m_00644.sofa', 'e47870673802b49179af41f8d377d472'),
            ('UV/1m/UV1m_00645.sofa', 'd4dc85a019f370c48d851e89be3f5daa'),
            ('UV/1m/UV1m_00646.sofa', '7fe788f3c6e656bb7c1f0df6dec6a7f3'),
            ('UV/1m/UV1m_00647.sofa', 'f85d62f3a9084b363270706702f7f0d8'),
            ('UV/1m/UV1m_00648.sofa', '3d2057d8ae9fb0fc5063f680aea7cb7c'),
            ('UV/1m/UV1m_00649.sofa', '2855abcbaf542ae72c1f6a1de3bb12d5'),
            ('UV/1m/UV1m_00650.sofa', '78ccb7ab985f3b967cdb3f64f7875553'),
            ('UV/1m/UV1m_00651.sofa', 'd31833745eac97902f80e1760e082d29'),
            ('UV/1m/UV1m_00654.sofa', '09d377aafbc9cbc5f562537538666317'),
            ('UV/1m/UV1m_00655.sofa', 'a6fa3847569992c0f1cc4ea1b95cac00'),
            ('UV/1m/UV1m_00657.sofa', '1ee14a8a2651b65783350561fe06fac6'),
            ('UV/1m/UV1m_00660.sofa', '6a6aac4a6b947e55a9f144b7e641b99f'),
            ('UV/1m/UV1m_00661.sofa', '74a77449f5a313a68b766a3dee8990e3'),
            ('UV/1m/UV1m_00662.sofa', 'aef8f4fdbaee88edc7c78d7bd818e1d9'),
            ('UV/1m/UV1m_00664.sofa', '206d85ba33e42412842c8556b1ea0031'),
            ('UV/1m/UV1m_00665.sofa', '80078f75ae1be188605da6beebbf47c0'),
            ('UV/1m/UV1m_00666.sofa', '16011ef6961a4934c3cf42376ff3f259'),
            ('UV/1m/UV1m_00667.sofa', '9405102f702fbb6a6c2720ef3e8b243f'),
            ('UV/1m/UV1m_00668.sofa', '03c7118e4e9f7d0cb4329ed26f3fa647'),
            ('UV/1m/UV1m_00669.sofa', '53bb020665ca0b795c8ed4d192ee2e37'),
            ('UV/1m/UV1m_00670.sofa', '4d44e4be3ce809f3e8ac501a28d76f6c'),
            ('UV/1m/UV1m_00671.sofa', '30d7055be96a91e321e7135851b899ad'),
            ('UV/1m/UV1m_00672.sofa', 'c13e6aa696f2d777f7fa9e9987be4d1e'),
            ('UV/1m/UV1m_00673.sofa', 'ce69354f54d55165198e8f9bd6e354e6'),
            ('UV/1m/UV1m_00674.sofa', '87cebd2f11a49d2f84fe120a4935c654'),
            ('UV/1m/UV1m_00675.sofa', '3a615f6c94da9caf7aaf5349773a9159'),
            ('UV/1m/UV1m_00676.sofa', 'c5b9a84fa11f6c6addf84746a27043cd'),
            ('UV/1m/UV1m_00677.sofa', 'fa66f57392fc2e40e3d80112bab79d9b'),
            ('UV/1m/UV1m_00678.sofa', 'c7034fad7e13a05618fa28ed54ce5d56'),
            ('UV/1m/UV1m_00679.sofa', '1b0387f5f96be082c8cfa97c6c3574c8'),
            ('UV/1m/UV1m_00680.sofa', '136ca840d097d761d501515fe2e0d3a6'),
            ('UV/1m/UV1m_00681.sofa', '70f68cd96f46f2b93b416be1e507b11c'),
            ('UV/1m/UV1m_00682.sofa', '10ba861573342fb111c4c3f5c0731d32'),
            ('UV/1m/UV1m_00684.sofa', 'b98312bd3f890fc030c4f241f85e5068'),
            ('UV/1m/UV1m_00685.sofa', '857a46577bf755ea049baf98e71f88b4'),
            ('UV/1m/UV1m_00686.sofa', '6c5ab5eccd77eec9ca3c9a867e93bf48'),
            ('UV/1m/UV1m_00688.sofa', '70e846377d2b77ed34b0646a881380f3'),
            ('UV/1m/UV1m_00689.sofa', '256eb3f503098f4f6bba277c7a1d9154'),
            ('UV/1m/UV1m_00690.sofa', '2dd064909ced87e2dd99567160f492a4'),
            ('UV/1m/UV1m_00693.sofa', '7f85d6bcae1539ad015b25f12adafdd5'),
            ('UV/1m/UV1m_00695.sofa', 'eb8ebe6fab2b5ff987cf50df059126e1'),
            ('UV/1m/UV1m_00696.sofa', '7478a736dc04801d55045a5d684b1592'),
            ('UV/1m/UV1m_00697.sofa', 'b1af6eec1e357a7578a6bdf55ff50f08'),
            ('UV/1m/UV1m_00698.sofa', 'd35ec73b3f14227792faa93f2ede6c6c'),
            ('UV/1m/UV1m_00699.sofa', '2658462b44bf7e53975a6023a29237e6'),
            ('UV/1m/UV1m_00700.sofa', 'f1bae9a3770702710d07315388131042'),
            ('UV/1m/UV1m_00701.sofa', '731fb9f64223bad2bd7caa2907658559'),
            ('UV/1m/UV1m_00702.sofa', '3df018217b9b6ec14c12bab406c6e54b'),
            ('UV/1m/UV1m_00704.sofa', '27ee6b9fe292193588d2597ce15bac90'),
            ('UV/1m/UV1m_00705.sofa', 'd65f868a306c335389faa6f35f87793a'),
            ('UV/1m/UV1m_00707.sofa', '8275d0af507c88dbba07776b7667ace8'),
            ('UV/1m/UV1m_00709.sofa', '07e7e38a18856f46d79ca79db1f8a75a'),
            ('UV/1m/UV1m_00710.sofa', 'eb4c253b2c5d789703b56983dbac1d43'),
            ('UV/1m/UV1m_00711.sofa', 'a48a7f3af888b340e3995a09fa9fd7aa'),
            ('UV/1m/UV1m_00712.sofa', 'c0b28b75000c299e9757156ebd50d7fe'),
            ('UV/1m/UV1m_00713.sofa', 'ebc1bb568fe930ae8e923b3ae6653184'),
            ('UV/1m/UV1m_00714.sofa', '57f3548c230548bb900567bbbfb57da7'),
            ('UV/1m/UV1m_00717.sofa', 'ee1455d66ed0573d4f05c61f6e0fa22d'),
            ('UV/1m/UV1m_00718.sofa', '42a82e381b86a5c6ee69e22565b3b41e'),
            ('UV/1m/UV1m_00719.sofa', '87f9ab2b853515c811bcff041f6334da'),
            ('UV/1m/UV1m_00720.sofa', '0dda6a47f777255323d6b231860b26dc'),
            ('UV/1m/UV1m_00722.sofa', '16cea979ba0ee8be9052d0b7ffbbc122'),
            ('UV/1m/UV1m_00723.sofa', 'c4d5d87c90bb16148741ddec053aa7d4'),
            ('UV/1m/UV1m_00724.sofa', '5994602bfa91ec563114f4eddbbffed5'),
            ('UV/1m/UV1m_00725.sofa', 'ee4f7be4e1fa191ee9a8cca1def2218c'),
            ('UV/1m/UV1m_00726.sofa', '77c57da0c604dbf74d8fb93fd50631a9'),
            ('UV/1m/UV1m_00727.sofa', '71fb38c4ededa41d811ec75d494e5721'),
            ('UV/1m/UV1m_00729.sofa', '89ce681ee6e9a107911895dc7bed352a'),
            ('UV/1m/UV1m_00730.sofa', 'a0064a56bf46048de67562b307dee4f8'),
            ('UV/1m/UV1m_00732.sofa', 'bbd0314dc8d157694707d6d89bd6f91f'),
            ('UV/1m/UV1m_00734.sofa', '27a4905968c9fd9aa062195ef5d985ce'),
            ('UV/1m/UV1m_00735.sofa', 'a1baf705b0947c1432df5ea550558142'),
            ('UV/1m/UV1m_00736.sofa', '7748cff6ab2c7b80113e9c3a0390ce23'),
            ('UV/1m/UV1m_00740.sofa', '8ef82a4c36de06f71ba273b5a6834a4a'),
            ('UV/1m/UV1m_00742.sofa', '7687fada20bd6514b0540d9078b88669'),
            ('UV/1m/UV1m_00744.sofa', '39a778575381233205372eab431bf004'),
            ('UV/1m/UV1m_00745.sofa', 'd83abc8e79bdf476932753a2f152294b'),
            ('UV/1m/UV1m_00746.sofa', '076805be720fab6b06e3b4eecd718297'),
            ('UV/1m/UV1m_00747.sofa', 'cde367299c092530b84729762558b0b9'),
            ('UV/1m/UV1m_00748.sofa', 'ece896c5c3468bcb812d25c7ede288dc'),
            ('UV/1m/UV1m_00749.sofa', '2ffe9414f85a315c7f6695db608ea38c'),
            ('UV/1m/UV1m_00750.sofa', '2ac5350a426f3b56e9f63c1a66a27936'),
            ('UV/1m/UV1m_00751.sofa', '29bdffadc99b487bcfee6656eda4d478'),
            ('UV/1m/UV1m_00753.sofa', '1ec01c47a2785fe6603d20b5608c6a80'),
            ('UV/1m/UV1m_00754.sofa', '87cc0479e84570cd27469ae826e8bb8c'),
            ('UV/1m/UV1m_00755.sofa', '33ded3cce3ac512d2eba0b40efb1ceb7'),
            ('UV/1m/UV1m_00756.sofa', '0167e3ae6143f50b84bfb7d21a4ee44b'),
            ('UV/1m/UV1m_00757.sofa', 'e116487bbd171570b91902e7d78b0a41'),
            ('UV/1m/UV1m_00758.sofa', '74280f45289fa28f70fc349571d87470'),
            ('UV/1m/UV1m_00760.sofa', '79bc3fbf3cbf684ddb3af94efc37239f'),
            ('UV/1m/UV1m_00761.sofa', 'a7a713e579ced53bee7c7eb90fe4df6b'),
            ('UV/1m/UV1m_00763.sofa', 'bc9f9523320fa09f5c92cba5205f1426'),
            ('UV/1m/UV1m_00764.sofa', 'a7a343b190fd6fc12d69a2524a1c7196'),
            ('UV/1m/UV1m_00766.sofa', 'abe057337afceb5e0c9b7297dacc15c5'),
            ('UV/1m/UV1m_00767.sofa', 'e58d7fe08dd9da7f10405b8c722e6441'),
            ('UV/1m/UV1m_00768.sofa', 'c8edc918b917313d8d939fc73126532f'),
            ('UV/1m/UV1m_00769.sofa', '254fdf65a9359f36fe0ce0b339aa4ba8'),
            ('UV/1m/UV1m_00770.sofa', '3ea9ce477959ca769522a4611ef31e32'),
            ('UV/1m/UV1m_00771.sofa', 'e145f840721290f5e80df9b48bab09e6'),
            ('UV/1m/UV1m_00772.sofa', '2370ff653e5e808419b1dbdd471c0a7b'),
            ('UV/1m/UV1m_00773.sofa', 'e39b77100ee43cc4903837606113c253'),
            ('UV/1m/UV1m_00774.sofa', '75b51c4e96f7fc324ef9c42ec44151e4'),
            ('UV/1m/UV1m_00775.sofa', 'e137763fd9173c9935ad57b14ff26d71'),
            ('UV/1m/UV1m_00778.sofa', 'e30aa7f173f43eabad42ec94ffa80384'),
            ('UV/1m/UV1m_00779.sofa', 'bd70a1f6e5dcb4aba470fa6c4482fcd6'),
            ('UV/1m/UV1m_00780.sofa', 'c0aa46cc0aa9054906cb8f68afdc7d50'),
            ('UV/1m/UV1m_00782.sofa', 'bd029f21b0001af1a9dd04368df66be0'),
            ('UV/1m/UV1m_00783.sofa', '00525c9c0736b951bb18ba808354fa3c'),
            ('UV/1m/UV1m_00787.sofa', 'cace0976ee46afbbb085eb822143cbab'),
            ('UV/1m/UV1m_00788.sofa', 'd319972fa1bbf10020c9d3593b0f6325'),
            ('UV/1m/UV1m_00789.sofa', 'db896043146a2c617f66bf5324ae9946'),
            ('UV/1m/UV1m_00791.sofa', 'f13edc43f02657173768e38ef6f5c715'),
            ('UV/1m/UV1m_00794.sofa', 'e03a1a93dea843f77e23d90c293b132a'),
            ('UV/1m/UV1m_00795.sofa', 'f03eb134b76d62e16f177e840a0b33a4'),
            ('UV/1m/UV1m_00797.sofa', '6d7fbfd6fba4c1e80663a4b3aba31780'),
            ('UV/1m/UV1m_00798.sofa', '95dfc0bdb62543a4aa1bffdef513d6bd'),
            ('UV/1m/UV1m_00799.sofa', '21a0ea05ff43655756b8e7ca6900cab4'),
            ('UV/1m/UV1m_00800.sofa', '820c43407e8a7204a53eca7879ce4b15'),
            ('UV/1m/UV1m_00801.sofa', '4865cd8535248e843ab76a26182dda2d'),
            ('UV/1m/UV1m_00802.sofa', 'dadd59eb50c489023ce3528e307ecaca'),
            ('UV/1m/UV1m_00803.sofa', '40a914a923812861dc8d40f15d35c205'),
            ('UV/1m/UV1m_00804.sofa', '454ca382298575cb97b569bb0f093ffc'),
            ('UV/1m/UV1m_00805.sofa', '379a38835b7a8a823fed07a52de14738'),
            ('UV/1m/UV1m_00806.sofa', '223e0b3d0cbdc087dcca197d6f109a9f'),
            ('UV/1m/UV1m_00807.sofa', '003ef95474dc2d19e47fa76b37b868fd'),
            ('UV/1m/UV1m_00809.sofa', '2ab42c9ca9c1c0ae92c450876aa6cb99'),
            ('UV/1m/UV1m_00810.sofa', '91affa70c29ed4db88877a20f0b092d8'),
            ('UV/1m/UV1m_00811.sofa', '928818a5464d5923ac66d42d41c6902e'),
            ('UV/1m/UV1m_00812.sofa', 'f10baf15b84a31d5bd942d832f791392'),
            ('UV/1m/UV1m_00815.sofa', '7a9ba918e96a3bb896648e1c4a058a71'),
            ('UV/1m/UV1m_00816.sofa', 'dc23df012137d9e7eaf2217368794b80'),
            ('UV/1m/UV1m_00817.sofa', 'aced1d307aaacd540cc52e989313d78a'),
            ('UV/1m/UV1m_00818.sofa', '890cc6ad5e5b6c048d73bed4fc51b9b3'),
            ('UV/1m/UV1m_00819.sofa', '19f0ab39028477ae27772d7bce6014c0'),
            ('UV/1m/UV1m_00821.sofa', 'abe0ceb370ead0c3689a0a6c547a4d12'),
            ('UV/1m/UV1m_00822.sofa', 'ca48f6b6425e27a2c8ad876d615d18b5'),
            ('UV/1m/UV1m_00823.sofa', '519ecff88d6ee795fcb9e69824c78310'),
            ('UV/1m/UV1m_00824.sofa', '9dd8c5d4a037de6030caa859dfb60432'),
            ('UV/1m/UV1m_00825.sofa', '4790e73f17c1423638b85c86ff86042d'),
            ('UV/1m/UV1m_00826.sofa', '157cb5bbf39ca0810b121971b71a6c17'),
            ('UV/1m/UV1m_00827.sofa', 'f04cf0f388e938c893dd1c0c76abac20'),
            ('UV/1m/UV1m_00829.sofa', '9dee20228944a72df02d60ac5d9cebe4'),
            ('UV/1m/UV1m_00830.sofa', '08e0232003d036691389b4c2b2aa7f23'),
            ('UV/1m/UV1m_00833.sofa', 'aac7935d362259961cc4f01285f08d36'),
            ('UV/1m/UV1m_00835.sofa', 'bdedf27fdbf491f415dabfde4ee89b70'),
            ('UV/1m/UV1m_00836.sofa', '85df1d9f8439c360c8f4248bde68bab5'),
            ('UV/1m/UV1m_00837.sofa', 'ddde379ee4ad5930524f8a763bd0650a'),
            ('UV/1m/UV1m_00838.sofa', 'ccb9d700578612e669016d54aa3ff02e'),
            ('UV/1m/UV1m_00839.sofa', '2bcb47b4ad47e403a6f5fc5dcd602e0a'),
            ('UV/1m/UV1m_00840.sofa', '2481929013b92991d867a59f7e7e3010'),
            ('UV/1m/UV1m_00841.sofa', '99eb6b57d4a75f974e8255b639b69c50'),
            ('UV/1m/UV1m_00842.sofa', '97b1749b60c195387a51e8522dbb3458'),
            ('UV/1m/UV1m_00843.sofa', '001fa66498f8b0c8d6ccfc8b059ecf74'),
            ('UV/1m/UV1m_00844.sofa', 'e351da1aacee3a632a95703cee973c80'),
            ('UV/1m/UV1m_00845.sofa', 'e1de66307aef6112b64d47a4c0488d66'),
            ('UV/1m/UV1m_00846.sofa', 'f71b865437409bacbaf9c85f83e2e202'),
            ('UV/1m/UV1m_00850.sofa', 'a68f84ab07683bde18a543b4bab50234'),
            ('UV/1m/UV1m_00852.sofa', '5e614908cc45fa1d454acfd2e61f345c'),
            ('UV/1m/UV1m_00853.sofa', '7d3986f3685b1eb865df8a5d87d5cf84'),
            ('UV/1m/UV1m_00855.sofa', '3bac7b5aded3bb50344755b93be99be6'),
            ('UV/1m/UV1m_00857.sofa', 'aeaf57f0b9b364d9b146064357cae509'),
            ('UV/1m/UV1m_00858.sofa', 'e4d802c3d4a445db3fa69f79168282fc'),
            ('UV/1m/UV1m_00859.sofa', '69cd09f00e5af296e7aa01ed61efc78c'),
            ('UV/1m/UV1m_00860.sofa', '186cece304c8a60e83986dac10a9a9ba'),
            ('UV/1m/UV1m_00861.sofa', '11eef5a18963521e50c0c52a40ec7d32'),
            ('UV/1m/UV1m_00863.sofa', 'b01171c531e057bd8a63f39342f3a882'),
            ('UV/1m/UV1m_00864.sofa', '1f799b7f560d06093a1c49b543a132f2'),
            ('UV/1m/UV1m_00865.sofa', '3e87700b62b6e0621fb594815b2d8e49'),
            ('UV/1m/UV1m_00866.sofa', '08e4b17822162ba74358435f66c5037b'),
            ('UV/1m/UV1m_00867.sofa', '1b0fb4baa796b24838a4e296dd8b54ce'),
            ('UV/1m/UV1m_00868.sofa', 'c6e1bb6e16050233bb47f2344002be62'),
            ('UV/1m/UV1m_00869.sofa', '81e81300dc7b3268e92bbccd8f0f4d6e'),
            ('UV/1m/UV1m_00870.sofa', '2b7facbf2e1dc04c12d10e0291ec58ac'),
            ('UV/1m/UV1m_00872.sofa', 'c2023840aed9b84561dca7c144bc0b4f'),
            ('UV/1m/UV1m_00875.sofa', '5c8cd5e041115e6d41f14a98be3fb7ea'),
            ('UV/1m/UV1m_00877.sofa', '66b33fada0f4790ae1fc7eb752d295b1'),
            ('UV/1m/UV1m_00880.sofa', 'ac718da225ea15de1df70c042c51486d'),
            ('UV/1m/UV1m_00882.sofa', '5c1f0b5024fc4a4fe74cab65d8476dc5'),
            ('UV/1m/UV1m_00883.sofa', '32f63b6701d501afd6ee03c099db94a8'),
            ('UV/1m/UV1m_00884.sofa', '34c8b27240389d8a35f8c661840d3268'),
            ('UV/1m/UV1m_00887.sofa', 'e263cfaf0e7a402c893cb2e0dc8e104a'),
            ('UV/1m/UV1m_00889.sofa', 'fd2989b146c6a8e9ea7c589e16cfb319'),
            ('UV/1m/UV1m_00890.sofa', '9429c2142d6d428e541d87419f4d27ec'),
            ('UV/1m/UV1m_00891.sofa', '8b28d7336d4869a312f0f924c4de905c'),
            ('UV/1m/UV1m_00892.sofa', 'ef27e1331558596e7f1c334130f86398'),
            ('UV/1m/UV1m_00893.sofa', 'e8c25cdd77e68477dabb18c2d30d1986'),
            ('UV/1m/UV1m_00894.sofa', '73e4fdcd9e3cbbe270269c6900246617'),
            ('UV/1m/UV1m_00895.sofa', '83527e274c504fd2753e64af9679e42b'),
            ('UV/1m/UV1m_00896.sofa', '34c817acb3cea7d12a7d9c62213fb6a2'),
            ('UV/1m/UV1m_00897.sofa', '0932be2be7f35662150c99cf0c0ef393'),
            ('UV/1m/UV1m_00898.sofa', '215611eed42403fe23ebdc87eed1aced'),
            ('UV/1m/UV1m_00899.sofa', '94564b4074f8445c94dc352bdf81ea4a'),
            ('UV/1m/UV1m_00900.sofa', '3dce5d0fce919e28f3376d80b85d6cda'),
            ('UV/1m/UV1m_00901.sofa', 'e69f52ed6f1a61ce1b31f9c80fa2e9fa'),
            ('UV/1m/UV1m_00902.sofa', '227bd7a0229fefd21d0a80bed7d39892'),
            ('UV/1m/UV1m_00903.sofa', '6b259c066c69d9ac050a57a93e77756e'),
            ('UV/1m/UV1m_00904.sofa', 'c588ebbd7eab62c50609cb3cae980789'),
            ('UV/1m/UV1m_00906.sofa', 'e450c195b4ddfa4a98526164815c0e8e'),
            ('UV/1m/UV1m_00907.sofa', 'c9806e3322a11ee12a37a9bca9919c55'),
            ('UV/1m/UV1m_00908.sofa', 'b220aea872e81965262dfab9d14d3563'),
            ('UV/1m/UV1m_00910.sofa', 'cd04612a41f19731e515c07721067ff3'),
            ('UV/1m/UV1m_00911.sofa', '857f8316d60c97be2702d645edf6b540'),
            ('UV/1m/UV1m_00913.sofa', 'e967f81394b6aa99d0417fa951e980f7'),
            ('UV/1m/UV1m_00915.sofa', '932c5dedc750c823b0b40bd5ed360219'),
            ('UV/1m/UV1m_00918.sofa', '85d3108cb6145049619f74a4278c471b'),
            ('UV/1m/UV1m_00919.sofa', '228fcc0119ae462e3063659415604dea'),
            ('UV/1m/UV1m_00920.sofa', '730c64e1b23fd8ff4b75b9da17dbbd97'),
            ('UV/1m/UV1m_00921.sofa', 'a55eb563a4b34a37806a509f9ba56b77'),
            ('UV/1m/UV1m_00923.sofa', 'e320e0e3e765b56b2ae30c2d76954a88'),
            ('UV/1m/UV1m_00924.sofa', '3cb4257064c5455072c2825e517a6ff1'),
            ('UV/1m/UV1m_00925.sofa', 'f644dd67353304c6a61dbb697ce8e022'),
            ('UV/1m/UV1m_00926.sofa', '45da4ab32af6efcd16dadc50bb0a148d'),
            ('UV/1m/UV1m_00927.sofa', 'c328272ea5a4d197f44997d01740190b'),
            ('UV/1m/UV1m_00929.sofa', '313801f3f00300ee0b93a3cc56719693'),
            ('UV/1m/UV1m_00930.sofa', '2a2a02368b8bf448e18f67e7603e397a'),
            ('UV/1m/UV1m_00931.sofa', 'bd78c9a55299d70d3152dca3b4a5e58e'),
            ('UV/1m/UV1m_00932.sofa', '4d37af80c73a72ee41c2cc80eee8b5f0'),
            ('UV/1m/UV1m_00934.sofa', 'eef8ecb2c3e474d4cf38d1b23d50473a'),
            ('UV/1m/UV1m_00936.sofa', '072fd3b8cef659de2a9c275efc3b111e'),
            ('UV/1m/UV1m_00937.sofa', 'bdfbd9a95a8f71a91fd9c47b47a992a2'),
            ('UV/1m/UV1m_00939.sofa', '46d5e3cc39d81089cef163f987d5066f'),
            ('UV/1m/UV1m_00940.sofa', '1b729f3c9aa9df32636f3e4f28f8d575'),
            ('UV/1m/UV1m_00942.sofa', '3dd560c1a1d9bafad9a23dd683ae884c'),
            ('UV/1m/UV1m_00944.sofa', '8c3c4f10dcb8733233eadd8575709329'),
            ('UV/1m/UV1m_00946.sofa', '4f3a9ec05c889075145787cd0b826deb'),
            ('UV/1m/UV1m_00947.sofa', '509be8790223b5c78ba1a83c0a0ebc64'),
            ('UV/1m/UV1m_00951.sofa', '4030f437157673a0bb8c06f236533cae'),
            ('UV/1m/UV1m_00952.sofa', 'f58c17382ba80af59dd0bf53c99f0be4'),
            ('UV/1m/UV1m_00953.sofa', '51def43d897fbb1d81504ab1f5f447a2'),
            ('UV/1m/UV1m_00954.sofa', '20e0a72be37b76e83c43f83bb30874b7'),
            ('UV/1m/UV1m_00955.sofa', 'f30051fc1d0cf8ecef17e0df3ed5b507'),
            ('UV/1m/UV1m_00956.sofa', '78250a1a3f9e84565f6322f0ab984264'),
            ('UV/1m/UV1m_00961.sofa', 'e4d1d3ebdbd44db51a0964c63126a265'),
            ('UV/1m/UV1m_00962.sofa', 'e37e51d9860b20dda7e884a4abab6d6a'),
            ('UV/1m/UV1m_00963.sofa', '63e2bc825a8d2a5fcfd33d5738458662'),
            ('UV/1m/UV1m_00965.sofa', 'ae14a22f6516970ef00d908db5c7a800'),
            ('UV/1m/UV1m_00966.sofa', '78176265bcc590eab03eeab18aca5b31'),
            ('UV/1m/UV1m_00967.sofa', '4afb33eada5d20d55208b245c8a12fb7'),
            ('UV/1m/UV1m_00968.sofa', '0293854af72770f6d870a5edfcd91d76'),
            ('UV/1m/UV1m_00969.sofa', 'bc38f32ce9196479a48e7c4615faa57e'),
            ('UV/1m/UV1m_00971.sofa', '6cdf71a3f7d41f7f44d33d1d6c186d77'),
            ('UV/1m/UV1m_00972.sofa', '4b38f4de9c7acb9cf326e138c7be7ada'),
            ('UV/1m/UV1m_00973.sofa', '78e10d95ab0d1bfdc433fe06355bfdb3'),
            ('UV/1m/UV1m_00975.sofa', '46af004ac9456df28cdd88156b86e58d'),
            ('UV/1m/UV1m_00976.sofa', '122bfc2d87a250bf2fffc47fd4caa2ea'),
            ('UV/1m/UV1m_00977.sofa', '15a284580153c49b4e68039be96173b9'),
            ('UV/1m/UV1m_00978.sofa', 'a590c3114d84e22e709bc26e6be45bfb'),
            ('UV/1m/UV1m_00979.sofa', 'e19560021ccccdd5ed5c29e70abe9aa8'),
            ('UV/1m/UV1m_00980.sofa', 'd748eba1355b6a431bcec0007c53697b'),
            ('UV/1m/UV1m_00981.sofa', '94c7b758453d94907e83ea8df8fb064f'),
            ('UV/1m/UV1m_00982.sofa', 'd7304b1221bc3b48ec36fe834352426b'),
            ('UV/1m/UV1m_00984.sofa', '671a21c0284e551e9d0053e3340130db'),
            ('UV/1m/UV1m_00985.sofa', '4298f48884bb6fda4ab164f25cdfa24e'),
            ('UV/1m/UV1m_00986.sofa', 'a543f6e16b3616569bef0adaf44eb107'),
            ('UV/1m/UV1m_00987.sofa', '993abdc7c2c76aeeb5d6d607e194b34b'),
            ('UV/1m/UV1m_00991.sofa', 'd97dc7c0a09e0f8c70891ca8cb93a690'),
            ('UV/1m/UV1m_00993.sofa', '848bd306977a56e90bb959d2012cca91'),
            ('UV/1m/UV1m_00995.sofa', '5e498f33eaa290f252060edb2e34350c'),
            ('UV/1m/UV1m_00996.sofa', '62330434ecb6dd803e3b59c30a743262'),
            ('UV/1m/UV1m_00997.sofa', 'f8da9f3626677dfb098cabd32786fb7d'),
            ('UV/1m/UV1m_00998.sofa', '836783a377c4e472a83a234b22e2ea36'),
            ('UV/1m/UV1m_00999.sofa', '51cac3994904da04064bd8059c52bd75'),
            ('UV/1m/UV1m_01000.sofa', 'c27dfe7e7b50c51d2ac3eff4da87e08f'),
            ('UV/1m/UV1m_01002.sofa', 'd895e0e5daccf9512c2471715714a878'),
            ('UV/1m/UV1m_01003.sofa', 'ea859d4df08482c840b328d251cc9e88'),
            ('UV/1m/UV1m_01004.sofa', 'f5738a6a8993497e3bf23d95c19a4004'),
            ('UV/1m/UV1m_01005.sofa', '39abf09d69952431a81c683399d718a1'),
            ('UV/1m/UV1m_01006.sofa', '60eb9d5f2f416d300b2360a67a8d1892'),
            ('UV/1m/UV1m_01008.sofa', '35067f32f2640033307d3749b4832ba1'),
            ('UV/1m/UV1m_01009.sofa', '656fd3e04d2aee54386f15a7e2504339'),
            ('UV/1m/UV1m_01010.sofa', '4daec9d261d20da6f5020a7deab30f8e'),
            ('UV/1m/UV1m_01011.sofa', 'ff86e1843255668438b45ce25a86985d'),
            ('UV/1m/UV1m_01012.sofa', 'dcd1471eeb7b377b726d260ea4f8e9d6'),
            ('UV/1m/UV1m_01013.sofa', 'd81ca46a87b0991b607d0cfaae980dd0'),
            ('UV/1m/UV1m_01016.sofa', '0c7754247a6a1758314b8575819689b9'),
            ('UV/1m/UV1m_01017.sofa', '9c587a27ad7dbf885f9cb7961dc61a7d'),
            ('UV/1m/UV1m_01018.sofa', '48d40c9f2354929d6991796ba4549c83'),
            ('UV/1m/UV1m_01019.sofa', '4fd8905dd1808bba31655ba3fb0666b4'),
            ('UV/1m/UV1m_01020.sofa', '97ed22f7e3b201f42f1f9650259a5eea'),
            ('UV/1m/UV1m_01022.sofa', 'bd76ba8942cb2df449a80fd691a2849e'),
            ('UV/1m/UV1m_01024.sofa', '3e1bdfeb7ea85ecfff1749591a59c774'),
            ('UV/1m/UV1m_01027.sofa', '7ba7d7c83fc93ead63cca76724169339'),
            ('UV/1m/UV1m_01028.sofa', 'd4061e0d5a163ed9abaf29ef6ca5c4fe'),
            ('UV/1m/UV1m_01030.sofa', '5eafbc665b2f44ac0396edabf380ac50'),
            ('UV/1m/UV1m_01031.sofa', 'c273c7c41d654f3e80178b7d57d9dd64'),
            ('UV/1m/UV1m_01032.sofa', '27f830fb87b141689e53e11d29eeb7d2'),
            ('UV/1m/UV1m_01033.sofa', 'c54b655cfb7cac7b1acbd6f88e55591d'),
            ('UV/1m/UV1m_01035.sofa', 'a897c1eeae9ce149a6a010e607e441f5'),
            ('UV/1m/UV1m_01036.sofa', '1e6f6713bcabe4d634e31bcb2e70fdf9'),
            ('UV/1m/UV1m_01037.sofa', '9cf675ce96e2150d2127647fc798ad8c'),
            ('UV/1m/UV1m_01038.sofa', '1f0c86557934cd003d6c68199367e878'),
            ('UV/1m/UV1m_01039.sofa', 'e9321baf5f9b6dea24e953655a149449'),
            ('UV/1m/UV1m_01040.sofa', 'fc7fc9c24d89caac1dfc6f179b66fb89'),
            ('UV/1m/UV1m_01042.sofa', '4d9ef3e2fa43361999d4c2c04a933d81'),
            ('UV/1m/UV1m_01044.sofa', 'aa19e1fb391ba8c92ff5d4433b9592b2'),
            ('UV/1m/UV1m_01046.sofa', '55e4c4eee7609ae2b39331bb184a1a80'),
            ('UV/1m/UV1m_01047.sofa', 'c6315ce25a19d1c4ab1527f555074cf4'),
            ('UV/1m/UV1m_01048.sofa', '75575bfd3ea93f22aa578f0fed253079'),
            ('UV/1m/UV1m_01049.sofa', '2ab4fd6033202f8c694f6df9fb89e2ae'),
            ('UV/1m/UV1m_01050.sofa', 'c27b63cfc99c6293f3f79103d5a9fe7e'),
            ('UV/1m/UV1m_01052.sofa', '6483e00a450bc6f7d9a5a93adb2a483d'),
            ('UV/1m/UV1m_01053.sofa', '3640bd4d90347b9bb659f2d07ee8d29a'),
            ('UV/1m/UV1m_01055.sofa', 'cdafc2a2f6ea7a8ef9ec959497c42f98'),
            ('UV/1m/UV1m_01057.sofa', 'd0bd636066c98abb8fb86065b8f1d240'),
            ('UV/1m/UV1m_01058.sofa', '16c395cafb2f1e7b1a92bfb6a856b41e'),
            ('UV/1m/UV1m_01060.sofa', 'cd62e9ffb7c627194783ef2f4173d696'),
            ('UV/1m/UV1m_01061.sofa', 'a4c0286c89124efc702107d0386f0212'),
            ('UV/1m/UV1m_01062.sofa', '9901eb265410acccf06cf9f8c2cb618f'),
            ('UV/1m/UV1m_01063.sofa', '5d236b0d5419ee56d58bca8639ff1448'),
            ('UV/1m/UV1m_01064.sofa', 'dd940b084c72cbd9fadf0bb502a398d9'),
            ('UV/1m/UV1m_01065.sofa', '0b58ede35764a53df340ba1352c6de98'),
            ('UV/1m/UV1m_01066.sofa', 'd877d54cef9d018b5bcb273246d08f8b'),
            ('UV/1m/UV1m_01067.sofa', 'dbea7867d7e0d1453f2c94e825307c4c'),
            ('UV/1m/UV1m_01069.sofa', '33850054f69d59fdd2c60543182e4f93'),
            ('UV/1m/UV1m_01071.sofa', '73d393f95ebc4339c3cf404da18204e5'),
            ('UV/1m/UV1m_01073.sofa', 'fc46d639f335f97073b4051807bd0925'),
            ('UV/1m/UV1m_01075.sofa', '358137f6f54454fc2bd000e77f5c7638'),
            ('UV/1m/UV1m_01077.sofa', 'a03a3e136f51e577d20d29fdcc29c732'),
            ('UV/1m/UV1m_01078.sofa', '3e093c6eadea219d9a53b623ed080c70'),
            ('UV/1m/UV1m_01079.sofa', 'e06abfdfa533b0d59ab12de86615f80f'),
            ('UV/1m/UV1m_01080.sofa', '72fe84023812861a1bf2a6be7eea3ecb'),
            ('UV/1m/UV1m_01082.sofa', 'bea8f0eea8b0a94d81fd8a760dd6780e'),
            ('UV/1m/UV1m_01083.sofa', '40f6ff5e1995628cba1e189529848f5b'),
            ('UV/1m/UV1m_01085.sofa', '36ff6df6ebff8607cb3798ce9192d4ca'),
            ('UV/1m/UV1m_01086.sofa', 'aad74db9ba6591293ab078827c28e808'),
            ('UV/1m/UV1m_01087.sofa', 'aabb42b710814fdcc3e36522cd054e85'),
            ('UV/1m/UV1m_01088.sofa', '4d6d7e2ff9b9f37b08cd7dfed58e98e7'),
            ('UV/1m/UV1m_01089.sofa', 'a2318a76cc944df62ccd555f5adaff9d'),
            ('UV/1m/UV1m_01091.sofa', '6dca329d7173dc7333fade5bb8bd0e1d'),
            ('UV/1m/UV1m_01092.sofa', '60f796e8a25bff2cd124c1f92cc1030e'),
            ('UV/1m/UV1m_01093.sofa', '460f363d97916a24eb2c5135e5495232'),
            ('UV/1m/UV1m_01094.sofa', '78ca4fc512b5681c7c2a4b6175d239f1'),
            ('UV/1m/UV1m_01097.sofa', '536e7c6c56774f1efe8d5dbf8c12a7fd'),
            ('UV/1m/UV1m_01099.sofa', 'f2e3e693223f0dd391f40ce41019c972'),
            ('UV/1m/UV1m_01100.sofa', 'a21171f79dad3914e45479c5ec26e074'),
            ('UV/1m/UV1m_01101.sofa', 'cdba07aa4aadc95095f02a32673431f6'),
            ('UV/1m/UV1m_01102.sofa', 'f8eb037979a0e4a8026f265577772852'),
            ('UV/1m/UV1m_01103.sofa', 'd11b35f793c17d2da6db1c4bd151a28c'),
            ('UV/1m/UV1m_01104.sofa', '9961257f2b41136a77e9f05f63111af6'),
            ('UV/1m/UV1m_01107.sofa', '9233f3c9ebd3515f81150a61ef7eb6d6'),
            ('UV/1m/UV1m_01108.sofa', 'd648677c3e37eed94f52285ecd0de055'),
            ('UV/1m/UV1m_01109.sofa', '0c7b931370127b53e2f791dfaceed88e'),
            ('UV/1m/UV1m_01111.sofa', '587aef73e4a52ad39e8109eed2f0e9d2'),
            ('UV/1m/UV1m_01112.sofa', '12a6e892eaef03527002d0517d324830'),
            ('UV/1m/UV1m_01114.sofa', 'bbcd569e3797f11b33aba9c1a7d07c90'),
            ('UV/1m/UV1m_01115.sofa', '40dc8528a9c710c69de490b456cd322e'),
            ('UV/1m/UV1m_01116.sofa', 'd0e9711c1357dea25d88e48cb1e3b3a9'),
            ('UV/1m/UV1m_01117.sofa', '5dfeaa78f2b90950720961fbdbd3baec'),
            ('UV/1m/UV1m_01120.sofa', 'de860e68d7426c98b502d899402a5b99'),
            ('UV/1m/UV1m_01121.sofa', '0866ccb77a71a74ce91f77fa6f265114'),
            ('UV/1m/UV1m_01122.sofa', 'c4a55784efaaf96fa8c926ea458607e6'),
            ('UV/1m/UV1m_01125.sofa', '80aae92a8f69b093f84f61ed0bcc0619'),
            ('UV/1m/UV1m_01127.sofa', '1d26fb6cc3f096b094e9a6d385f4fcd5'),
            ('UV/1m/UV1m_01128.sofa', '40e5d393b187e93d2ed97bf5fb697d52'),
            ('UV/1m/UV1m_01129.sofa', '6cf6c5e16527822b5b6ce655808a5a44'),
            ('UV/1m/UV1m_01130.sofa', '42192457522dcfddaddc54e37240f1eb'),
            ('UV/1m/UV1m_01131.sofa', '9f9e97647279885e639b31530244dc42'),
            ('UV/1m/UV1m_01132.sofa', 'e3a7c7047211f8a458baae8d1ea5ba32'),
            ('UV/1m/UV1m_01134.sofa', '6ae9551627cea1c91d03a768129c0785'),
            ('UV/1m/UV1m_01135.sofa', '9ac2f884ea34a19f22c245bdae8771bd'),
            ('UV/1m/UV1m_01136.sofa', '09a365b6afffacbd4439e0cba665aaef'),
            ('UV/1m/UV1m_01137.sofa', 'e411dd16d74c1397dac25c8f8f52749c'),
            ('UV/1m/UV1m_01139.sofa', '43df505fc984802486cfcfe318f9912c'),
            ('UV/1m/UV1m_01140.sofa', '532f62eb297a351d32c37459b75ebc15'),
            ('UV/1m/UV1m_01141.sofa', '4e9cdf5fe6179a88e52570ea225520df'),
            ('UV/1m/UV1m_01142.sofa', 'ca5647d3cd0fadeb0a8ef16855adc9ab'),
            ('UV/1m/UV1m_01143.sofa', '825abe018f187005bace9de4be84eb38'),
            ('UV/1m/UV1m_01144.sofa', '412b58d724041a277c5a47341599bbd6'),
            ('UV/1m/UV1m_01145.sofa', '126c21000996c1cf8523d1f187fa20e7'),
            ('UV/1m/UV1m_01146.sofa', '9365dd5f349c0499e769abe299a4b7e8'),
            ('UV/1m/UV1m_01147.sofa', '8cfa6f7a001b4e56576f0d1d9bb44349'),
            ('UV/1m/UV1m_01148.sofa', '629024b18c96dee4db23c6414b96d38c'),
            ('UV/1m/UV1m_01149.sofa', 'c1c42ab46d055d46ddecfcf5dd7b9148'),
            ('UV/1m/UV1m_01150.sofa', '38f783379b0562b4b8484018e9ef1309'),
            ('UV/1m/UV1m_01151.sofa', '943f23781e5305b8c502fe53ab787cdf'),
            ('UV/1m/UV1m_01152.sofa', '2d945dee29c3e9bdaf3856e1fa0af98a'),
            ('UV/1m/UV1m_01155.sofa', 'df0889175c01154efdd5ce79e70c6f23'),
            ('UV/1m/UV1m_01157.sofa', 'd2056e01047807e37278fe679c788bcc'),
            ('UV/1m/UV1m_01160.sofa', '1029cf03fd812b1c1a28ea7ef50f6544'),
            ('UV/1m/UV1m_01162.sofa', '716b6e51936103518ca7002302f0c9fe'),
            ('UV/1m/UV1m_01163.sofa', '45c041ef0d8fd213ca86d10b1cad29d5'),
            ('UV/1m/UV1m_01164.sofa', '7e1644ecd9252c04157964f955dd484c'),
            ('UV/1m/UV1m_01165.sofa', 'e64f8ed9c52ab7ec0b0570307c27b101'),
            ('UV/1m/UV1m_01166.sofa', 'a1db50c19641fd03faa921ff3594df74'),
            ('UV/1m/UV1m_01168.sofa', '7d969ddbd7f4c7791f785f355fb5ee91'),
            ('UV/1m/UV1m_01171.sofa', '67c1de6068b4548f7da657daa2c9edc3'),
            ('UV/1m/UV1m_01172.sofa', '3431db9566a5fc386dc7bc0582aec420'),
            ('UV/1m/UV1m_01173.sofa', 'b684cc3bf52d0f2483c4657727ed01b2'),
            ('UV/1m/UV1m_01174.sofa', '844d6f751ec9dab4eca896f6515cfd8a'),
            ('UV/1m/UV1m_01175.sofa', '224dfbf87cc2cd7361f7bebf58abc584'),
            ('UV/1m/UV1m_01176.sofa', 'dcb1cccfa5da97531eee112e3e6999c4'),
            ('UV/1m/UV1m_01177.sofa', 'aca2a38dc89364e8cf39200b62ba8147'),
            ('UV/1m/UV1m_01179.sofa', 'd20c7f2d38786494b9bd7aed7d6c7ef1'),
            ('UV/1m/UV1m_01181.sofa', '85e57ecf66d90d05f46b1e64273b3800'),
            ('UV/1m/UV1m_01185.sofa', '00dbf8977cb5825a3753ec45f82666e0'),
            ('UV/1m/UV1m_01186.sofa', '10c13c5a6fb835ee684bb984649e2dc1'),
            ('UV/1m/UV1m_01189.sofa', 'c728c49e3d9c744d4fd0ea3aa2722096'),
            ('UV/1m/UV1m_01190.sofa', '4c716f7c54c6e5f5a59ff4b6fd348fb6'),
            ('UV/1m/UV1m_01191.sofa', '70275cbbeb0ac6a3f591d7d3905ef7aa'),
            ('UV/1m/UV1m_01192.sofa', '4a009951ead3b9d196e76d12b4d0f273'),
            ('UV/1m/UV1m_01193.sofa', '8e30a3863c28ebc7872ca4796303135e'),
            ('UV/1m/UV1m_01194.sofa', '107022f07e487c306b6e012036a49664'),
            ('UV/1m/UV1m_01195.sofa', '31c31e8a887f04969a333afc0a39069d'),
            ('UV/1m/UV1m_01196.sofa', 'a32b2a140c87f2fed0af77a2d9d509f3'),
            ('UV/1m/UV1m_01197.sofa', '44ac418fc9989164d289743975a576ff'),
            ('UV/1m/UV1m_01200.sofa', 'ab911cd16f883b4ff564e007a6dfb89a'),
            ('UV/1m/UV1m_01201.sofa', 'f7fcd81d2a54b2c7097e6c9c403bb507'),
            ('UV/1m/UV1m_01202.sofa', 'ece83f51b6c04c7c22bcff32dd2fcc39'),
            ('UV/1m/UV1m_01203.sofa', 'ef8dfb56c48b3de27025cd10b9851e7a'),
            ('UV/1m/UV1m_01205.sofa', '044b8c9042d810deb4831dd320c18c72'),
            ('UV/1m/UV1m_01206.sofa', '3a4c5bc191fc179ebbcf6e2925049999'),
            ('UV/1m/UV1m_01207.sofa', 'cec6e58b4f0510ce34c4a36993173910'),
            ('UV/1m/UV1m_01208.sofa', '4e23aad13befcef2cfd35597a4a471e2'),
            ('UV/1m/UV1m_01209.sofa', '9f6c9f993cbaa89e2223d24d9d70533a'),
            ('UV/1m/UV1m_01210.sofa', '72d603fe02a93f97222d8519d8e94ab5'),
            ('UV/1m/UV1m_01211.sofa', '71047a96202c13128b8cba2e753a8963'),
            ('UV/1m/UV1m_01212.sofa', 'bc7abfc5b6db81b88bc50e59ab40dd46'),
            ('UV/1m/UV1m_01213.sofa', 'f2b46fe124c3fbde21831a983ce00849'),
            ('UV/1m/UV1m_01215.sofa', '9e205ef163238e0ab103c7f570af1f48'),
            ('UV/1m/UV1m_01216.sofa', 'a3d7f0d85bdb1966fcf6b731650b3c21'),
            ('UV/1m/UV1m_01217.sofa', 'da5d8216abc4f80ce85002426532fd0b'),
            ('UV/1m/UV1m_01219.sofa', '80c2f90dd0c2318c1d2daafc35fb4312'),
            ('UV/1m/UV1m_01221.sofa', '2d6ad4e7f73456d735d0d30eeb545fa0'),
            ('UV/1m/UV1m_01222.sofa', 'f6020af71cee6f0af1a553502988d7f8'),
            ('UV/1m/UV1m_01223.sofa', '8a6eb13335823b587d535c7e843e23b8'),
            ('UV/1m/UV1m_01224.sofa', 'e03e986fb1949db1ca976c770f7acb86'),
            ('UV/1m/UV1m_01225.sofa', '73e2037e2d348358b45c5c675805ba49'),
            ('UV/1m/UV1m_01228.sofa', '87d43f70644a5b6c82d9b3fe5c006982'),
            ('UV/1m/UV1m_01230.sofa', '063f7b6af41d6346fef331618aff780d'),
            ('UV/1m/UV1m_01231.sofa', '60cfabada4f34812def7f0eeccfa5b09'),
            ('UV/1m/UV1m_01232.sofa', '89edaf2ed482a6f9ab71ae7854dfde91'),
            ('UV/1m/UV1m_01233.sofa', '7ab0abac47fa5c599b37e6c1f61ec728'),
            ('UV/1m/UV1m_01234.sofa', 'd3b7bbcf65548ba5b43a2001720a02fa'),
            ('UV/1m/UV1m_01235.sofa', '36d0d1ad9df9fe428960785db015f6fa'),
            ('UV/1m/UV1m_01237.sofa', 'd6635fd13935d712a53e88356be27813'),
            ('UV/1m/UV1m_01238.sofa', '1265f707bc75650b251a0daeb7f479ad'),
            ('UV/1m/UV1m_01239.sofa', '377a3b66bfc830e3c165ee10fe8ddce6'),
            ('UV/1m/UV1m_01240.sofa', 'b3e16cf84eb40aa880bf6b23657430b7'),
            ('UV/1m/UV1m_01242.sofa', 'df8bbc2f624f69b230ec77dfa6b139f7'),
            ('UV/1m/UV1m_01244.sofa', '81a5194ba8f4aed8d6c0f8bf22cfc7fc'),
            ('UV/1m/UV1m_01245.sofa', '2a39c996689f29bb02a32d3eef01f2f9'),
            ('UV/1m/UV1m_01248.sofa', 'f40ae077e181ad396d186932c43d6c15'),
            ('UV/1m/UV1m_01251.sofa', '97323a3f9e785847b49bf2c0075d8a26'),
            ('UV/1m/UV1m_01252.sofa', 'b5a49c473d289652da84b0220fbcbc1a'),
            ('UV/1m/UV1m_01254.sofa', '33e2908fa5f74355307224f0e94a16fa'),
            ('UV/1m/UV1m_01256.sofa', '66220b8aa7ccc8baf1e6bfe2f9a3e4a1'),
            ('UV/1m/UV1m_01258.sofa', '9c563e65757eb18f3c380e25b7d92ec6'),
            ('UV/1m/UV1m_01259.sofa', '68749d7aa6313c2bfa79b9b86a4413b6'),
            ('UV/1m/UV1m_01262.sofa', 'fddc482ae94eed9ebb9e70e782aa6ed1'),
            ('UV/1m/UV1m_01263.sofa', '424298986d7f87b64fc41d549eccd321'),
            ('UV/1m/UV1m_01264.sofa', 'edc6132f2ebe1576c3d7261bb9686366'),
            ('UV/1m/UV1m_01265.sofa', 'd2bf826ee8d334504f0c68a3928804d4'),
            ('UV/1m/UV1m_01266.sofa', '4ef2dd0bae24c607a3d4c058d698c300'),
            ('UV/1m/UV1m_01268.sofa', 'b3b2f058ecb76c678f5064c6abc41f59'),
            ('UV/1m/UV1m_01270.sofa', '89f6b894f0bdb1a42a675a771c6407e9'),
            ('UV/1m/UV1m_01271.sofa', '05a5ee8dc98b2ef24a91d90a558deb5e'),
            ('UV/1m/UV1m_01272.sofa', '02d83aee920aad31bdaa732e510344b6'),
            ('UV/1m/UV1m_01273.sofa', 'd34a5c382cecdf760ae61282e62689d8'),
            ('UV/1m/UV1m_01274.sofa', '5db60c1ba5be70039186d3a1dffe1ad6'),
            ('UV/1m/UV1m_01275.sofa', '3efd402c54c333854c68f6576bf619b9'),
            ('UV/1m/UV1m_01276.sofa', 'd96e0dae82e790e8a135238def1092d4'),
            ('UV/1m/UV1m_01277.sofa', '71ba8fb9599805c151386734e9424e5b'),
            ('UV/1m/UV1m_01278.sofa', '5299903c818312b8e8f9f7e10b7623b9'),
            ('UV/1m/UV1m_01279.sofa', '1975a0d5fbede742fad2114aa07557d4'),
            ('UV/1m/UV1m_01280.sofa', 'c644dbd182c4ac4bbd46fbfaa4b33263'),
            ('UV/1m/UV1m_01282.sofa', '562a476809ad915f0a1213d630f54f36'),
            ('UV/1m/UV1m_01284.sofa', '64dc71bbaa51c5755fd5501a602b5f18'),
            ('UV/1m/UV1m_01286.sofa', 'a6b6bceb6da41f7629cb517576660404'),
            ('UV/1m/UV1m_01288.sofa', 'e9a31173127c9f2ccfc8bd06df939663'),
            ('UV/1m/UV1m_01290.sofa', '66d0df0250e4c7a212e675d960908d6a'),
            ('UV/1m/UV1m_01291.sofa', '518595b5d6a97e9d91133ae40260c470'),
            ('UV/1m/UV1m_01292.sofa', '4af65b0b0c8e48ae75f259fccc82e162'),
            ('UV/1m/UV1m_01293.sofa', 'fc2d44c98b69e325800087aac9b5f024'),
            ('UV/1m/UV1m_01294.sofa', '27ee47a1cd243159ef62e568493c22c6'),
            ('UV/1m/UV1m_01295.sofa', '24847b64360d2dbba60c2a4786c9af71'),
            ('UV/1m/UV1m_01296.sofa', '44042b3b755ef95e227cdce81e252cba'),
            ('UV/1m/UV1m_01298.sofa', '4289c233aac99c59dca808d49c2a762c'),
            ('UV/1m/UV1m_01299.sofa', 'd441ebe71db936b1709e70811ab2092a'),
            ('UV/1m/UV1m_01301.sofa', '53ff94c6e5e6bdcab990066b4aa6a73d'),
            ('UV/1m/UV1m_01302.sofa', '3bc6f97816a247c05755bd685352f0a8'),
            ('UV/1m/UV1m_01303.sofa', '7518aa06a09681be5f66c8d7a317958d'),
            ('UV/1m/UV1m_01304.sofa', 'cb072106fc34cb2e523996bdb378a37a'),
            ('UV/1m/UV1m_01305.sofa', '690026b1cf0cfef3a02ff6b5154c3b7b'),
            ('UV/1m/UV1m_01308.sofa', '6ef2acb94f7c4ac98e8849a592edc3d2'),
            ('UV/1m/UV1m_01309.sofa', '06f5cf80bc6a18500897c16799c1eeee'),
            ('UV/1m/UV1m_01310.sofa', '7558d4e05fdfb2b3240d5ff7a86e96d4'),
            ('UV/1m/UV1m_01311.sofa', '75529de21eb10eb11808f771cdcd35f6'),
            ('UV/1m/UV1m_01312.sofa', 'bb6bae22b192cb2034b26e561283073e'),
            ('UV/1m/UV1m_01313.sofa', 'aca40faff81ec8de330c70b9145784dc'),
            ('UV/1m/UV1m_01315.sofa', '5d4678422b7888afd24c7d332da778cc'),
            ('UV/1m/UV1m_01317.sofa', '7f3d525636815c3c8be6bea6e0e9ecfa'),
            ('UV/1m/UV1m_01318.sofa', 'e83947e78d5cdcfde453547754274695'),
            ('UV/1m/UV1m_01319.sofa', 'acb94dc2b6eb90729b3f31ba53297f17'),
            ('UV/1m/UV1m_01320.sofa', 'fd5cd227ea7a5863c4febad1871e1044'),
            ('UV/1m/UV1m_01321.sofa', 'c817e46b94f5c77deca9fdcdac14165e'),
            ('UV/1m/UV1m_01324.sofa', 'c05fecf25b3ed55089fb032ec24187ed'),
            ('UV/1m/UV1m_01326.sofa', '9cdc27bd805a136733b1c3c8a474da11'),
            ('UV/1m/UV1m_01327.sofa', '879c7fbc947106190eff3963fca01700'),
            ('UV/1m/UV1m_01328.sofa', 'b8b08535b1342318aa316b2a1b975c18'),
            ('UV/1m/UV1m_01329.sofa', '3ba6e1bad95afd3fbb9122e1f41771df'),
            ('UV/1m/UV1m_01330.sofa', '426f4c3ed281ec830d84522214c9dda1'),
            ('UV/1m/UV1m_01331.sofa', '1efca69902e820cca5870b2b14a06457'),
            ('UV/1m/UV1m_01333.sofa', '8abc517605d89fc64e5e46116b7b31f2'),
            ('UV/1m/UV1m_01334.sofa', 'd0c8fce798b7abacf73820b01f8eef55'),
            ('UV/1m/UV1m_01335.sofa', '4d05687ace4894fa5f5a2ec74a529422'),
            ('UV/1m/UV1m_01337.sofa', 'fe1f5e1d1f36bfcc3455b18ff1a20caf'),
            ('UV/1m/UV1m_01338.sofa', '27a7da8110308dedf02b48a8058fb833'),
            ('UV/1m/UV1m_01342.sofa', '0410804a3df0ab0c2154b85bc3fc9667'),
            ('UV/1m/UV1m_01344.sofa', '14948a8565c2a3b4f65c1eaf99a8ef45'),
            ('UV/1m/UV1m_01345.sofa', '90d624a7c656d6df79c9a5338bde4427'),
            ('UV/1m/UV1m_01346.sofa', '616e7e2a9c11d922a45f76c79a7086a8'),
            ('UV/1m/UV1m_01347.sofa', 'e96b4209db98efc74e823de1b91e7c2d'),
            ('UV/1m/UV1m_01349.sofa', '707c3f3dd1f1d1ea17e3b36634b5652a'),
            ('UV/1m/UV1m_01350.sofa', 'f13efb589c412f12e488b0f80ae1ccc5'),
            ('UV/1m/UV1m_01351.sofa', 'ad0f9e4ea735c07fa8ff26c3de6920fc'),
            ('UV/1m/UV1m_01352.sofa', 'c34839014141acffa6f14e8d90df38ce'),
            ('UV/1m/UV1m_01355.sofa', '3229f00ea0621f6f45b74585132eeab2'),
            ('UV/1m/UV1m_01356.sofa', '9e3eb13efd4054a78cf9b061b2f86ab5'),
            ('UV/1m/UV1m_01357.sofa', 'b511993f97fd82e6ecc54ffd74f844b3'),
            ('UV/1m/UV1m_01359.sofa', '754fe01343ec8b74da8ef27ddd783e7b'),
            ('UV/1m/UV1m_01360.sofa', '2c99c63f9e79999296cf09e2dcdbb612'),
            ('UV/1m/UV1m_01362.sofa', '75630cf1a8cb29b4125d0e7e74dc5386'),
            ('UV/1m/UV1m_01363.sofa', '1e7e0b3fedcbcc2877bea89f9c78918f'),
            ('UV/1m/UV1m_01364.sofa', 'f873532f90c41c5a52b8ddbcfb1ae0b7'),
            ('UV/1m/UV1m_01365.sofa', 'a4521820799f165e58b276981788a871'),
            ('UV/1m/UV1m_01366.sofa', 'f2428acd2effddd2c26234b1b1b74fbf'),
            ('UV/1m/UV1m_01367.sofa', '05d601e1b2f4cb7d711f3e2d43c10828'),
            ('UV/1m/UV1m_01370.sofa', '9c9da4b45444a9c052bc2d1fb6e935cd'),
            ('UV/1m/UV1m_01371.sofa', 'ff2f695fc2faa4b0fa384101b3f8279c'),
            ('UV/1m/UV1m_01372.sofa', '4552bafe5b0a3852c1d80f5e5f15398b'),
            ('UV/1m/UV1m_01373.sofa', '356118bbc437dfea81dbca7c53e707ff'),
            ('UV/1m/UV1m_01374.sofa', '3096e2f9a3a88fb0e250185f1e39e173'),
            ('UV/1m/UV1m_01375.sofa', '8805059d42fbca74cb89a499ce19fb3d'),
            ('UV/1m/UV1m_01376.sofa', 'faf2d71c874b452d7d61c3db586db65f'),
        ],
        'UV-2m': [
            ('UV/2m/UV2m_00001.sofa', '2e11efb7749c2e18df31ac67222a3ad9'),
            ('UV/2m/UV2m_00002.sofa', 'acb132bfea17a24c77e94eb0e38cf51d'),
            ('UV/2m/UV2m_00003.sofa', 'd8efb599c7c712deacfcbb5c9da5680b'),
            ('UV/2m/UV2m_00004.sofa', '2a33d287bf9cc26590cc45a2fed567c8'),
            ('UV/2m/UV2m_00005.sofa', 'cb86bb2867c3297f7ba6dc6e5bc2e739'),
            ('UV/2m/UV2m_00007.sofa', '0c254fa7be39c05b8aa79b36df09b1d8'),
            ('UV/2m/UV2m_00009.sofa', 'c20da4adb70233df5b2f3680ffa0b0f4'),
            ('UV/2m/UV2m_00010.sofa', 'e707e99c681d97d057a74dbe6d0b2ebd'),
            ('UV/2m/UV2m_00011.sofa', '6e380dd183accba79480d2e25fc5e71d'),
            ('UV/2m/UV2m_00013.sofa', 'f401d68e5ef8acec363d3d3c2f680214'),
            ('UV/2m/UV2m_00014.sofa', '9b000ac29268d1a1c1cf9f1db231169c'),
            ('UV/2m/UV2m_00015.sofa', 'd9e8ed432570478ce10c57c3b5f32435'),
            ('UV/2m/UV2m_00016.sofa', '81c93cdf57bbc2937d9eddf756576ad9'),
            ('UV/2m/UV2m_00020.sofa', '2dd9b282c95398b51455d997179e5497'),
            ('UV/2m/UV2m_00021.sofa', '448f9b2933a613e47b9972389d742902'),
            ('UV/2m/UV2m_00022.sofa', 'd5052e0fdae34914f5bec0e779fdc77b'),
            ('UV/2m/UV2m_00023.sofa', '25f011c761aec05867f2a0351bdaea0b'),
            ('UV/2m/UV2m_00024.sofa', '8d18bc57f1b2c2310a3d3882bcb6e602'),
            ('UV/2m/UV2m_00025.sofa', '219c95c69b3e6aba0cfbb80784da8fa3'),
            ('UV/2m/UV2m_00026.sofa', 'd337754b2169e20d2c6988e3f4f19539'),
            ('UV/2m/UV2m_00027.sofa', 'dc9173d5d5005d075b1a12baf633c712'),
            ('UV/2m/UV2m_00029.sofa', '3e2b27e390751f7dbae6c73e68935d8f'),
            ('UV/2m/UV2m_00030.sofa', 'd14bf8d8f91422fcbf808696135511f0'),
            ('UV/2m/UV2m_00031.sofa', '1756c9bbcd474fcbea53413a0b45b054'),
            ('UV/2m/UV2m_00032.sofa', '32bfaf654a54e561d5f1d33aa1169e84'),
            ('UV/2m/UV2m_00033.sofa', '2d06af61f1c1940d145664d204bbae82'),
            ('UV/2m/UV2m_00036.sofa', '256a064ae5a7e87442724bb38d7d6480'),
            ('UV/2m/UV2m_00038.sofa', '0ff0de7205da53fd8aad5989b3d15b72'),
            ('UV/2m/UV2m_00039.sofa', '6dac2b2c57bebedb77a4609201ee9dc5'),
            ('UV/2m/UV2m_00042.sofa', '643ab76a8a608262d58cbc525cc25ffd'),
            ('UV/2m/UV2m_00043.sofa', 'aa5d26013c474376fcb378ed39818e86'),
            ('UV/2m/UV2m_00044.sofa', '736e88c33a9bec9ff79d182885c73905'),
            ('UV/2m/UV2m_00045.sofa', '8814638590cab9ff5b67cf36142a9469'),
            ('UV/2m/UV2m_00048.sofa', 'b0d4fb7b54d4cc49983958aea0acac88'),
            ('UV/2m/UV2m_00049.sofa', '5c6fd6e8b80031097772b00534145f29'),
            ('UV/2m/UV2m_00054.sofa', '4b52fe968b4cb31eee974794ef04173b'),
            ('UV/2m/UV2m_00056.sofa', 'f11f1003cdbae873cbe341cf4784b95f'),
            ('UV/2m/UV2m_00057.sofa', '6ccc450c774c7762caabf6e4de624f0d'),
            ('UV/2m/UV2m_00058.sofa', '4c23bfb9d0f3eb8c5f292115808fae3e'),
            ('UV/2m/UV2m_00059.sofa', 'd9d4e3336fed5e747de3c9f05bbe0d38'),
            ('UV/2m/UV2m_00061.sofa', '8645b6734d91d96eb2c0574e5cf4661b'),
            ('UV/2m/UV2m_00062.sofa', 'a9e1ba70bf172f44b957fcc348e27d98'),
            ('UV/2m/UV2m_00063.sofa', '84d70be7e3ab2822995264c5d425a9ec'),
            ('UV/2m/UV2m_00064.sofa', 'c27deb576369d5ed43c7350353908d30'),
            ('UV/2m/UV2m_00065.sofa', '910e671fdc98f650a610bcbcb87961e9'),
            ('UV/2m/UV2m_00068.sofa', 'cd87b59107e37b4630e4c2dfaf262322'),
            ('UV/2m/UV2m_00069.sofa', '8ec760bca0d6571016b1342559b5d768'),
            ('UV/2m/UV2m_00071.sofa', '94003b01316fccf23e01094b06fcf2fe'),
            ('UV/2m/UV2m_00072.sofa', 'd2372c9c92dbe23acafb92362a8ca534'),
            ('UV/2m/UV2m_00074.sofa', '0c0d71689706e327249cf9d712f9d771'),
            ('UV/2m/UV2m_00076.sofa', '0a86fda25ea862fc4b2cce69e319ec94'),
            ('UV/2m/UV2m_00078.sofa', '567c0d8c247ed237894e8d698f0a9100'),
            ('UV/2m/UV2m_00079.sofa', 'ae286bea88fee3b61b73493032ef40e3'),
            ('UV/2m/UV2m_00082.sofa', '2ac283c2baf5495332dfc1d4fcab5cf7'),
            ('UV/2m/UV2m_00083.sofa', 'a96ad92e89566d4d62f296d0f422b109'),
            ('UV/2m/UV2m_00085.sofa', '72ba797da5f3d70c61fe746ce2422007'),
            ('UV/2m/UV2m_00086.sofa', 'bd7d46f1dd4f888b2f6de3c5adb67319'),
            ('UV/2m/UV2m_00087.sofa', '62d6955c846e201b302b06a5018a86ca'),
            ('UV/2m/UV2m_00089.sofa', 'def4d40622f29308da81eaaf2531ba1c'),
            ('UV/2m/UV2m_00090.sofa', 'ec0faaf46c8c61fa4699dc82b4890d3c'),
            ('UV/2m/UV2m_00092.sofa', '8a61ff8a0b334d8566ae2edb8f7f8e78'),
            ('UV/2m/UV2m_00095.sofa', '73f312a3cb66b300ede8c7225d77689a'),
            ('UV/2m/UV2m_00097.sofa', '4120efe642096b1c3009d8986c3af55d'),
            ('UV/2m/UV2m_00099.sofa', 'bc9d2b261e498e29c22fdd247bc357ea'),
            ('UV/2m/UV2m_00100.sofa', '3892b509103146273b1825847eadc0ed'),
            ('UV/2m/UV2m_00101.sofa', 'dcd2454ea51ffa2174c3ce5f18877f64'),
            ('UV/2m/UV2m_00103.sofa', '73dbaca711c711d6d373125f7b1ad1e1'),
            ('UV/2m/UV2m_00104.sofa', 'e01478267dc672e36a11d6ba12555cfa'),
            ('UV/2m/UV2m_00107.sofa', '5fece5fc46658bb988251db9a57a95b2'),
            ('UV/2m/UV2m_00108.sofa', '68c8c632e413cabef0ab6376b4c12c63'),
            ('UV/2m/UV2m_00109.sofa', 'e0745f241b8261acb8a55f57b34ec0ec'),
            ('UV/2m/UV2m_00110.sofa', '8a63075bf31f4f2677f9a3d42803e3c2'),
            ('UV/2m/UV2m_00111.sofa', '9f28c5d5fa4f8d0004ff8df3d98c393f'),
            ('UV/2m/UV2m_00112.sofa', '78917d319b1613f72819114cd471d39a'),
            ('UV/2m/UV2m_00113.sofa', '3941439da5288148081b105ae36637cc'),
            ('UV/2m/UV2m_00114.sofa', '3993e88eb73f7fe633712420941cd640'),
            ('UV/2m/UV2m_00118.sofa', 'd8605f1ee43c2e7681432a5778a7284a'),
            ('UV/2m/UV2m_00119.sofa', '33cc5b3ec05ac8ee337a319923bde3ce'),
            ('UV/2m/UV2m_00120.sofa', '69f04d9bb46d23f2c503d818ead6625f'),
            ('UV/2m/UV2m_00121.sofa', 'ee2722e51211a7b5555f2754ec517825'),
            ('UV/2m/UV2m_00125.sofa', 'a7c160a1e9661ad00f93befbe6a55c1e'),
            ('UV/2m/UV2m_00126.sofa', '9666d665aca414f82786b44b8d7a9a21'),
            ('UV/2m/UV2m_00127.sofa', 'be27375053d0fd7377096c2b60dcc4cc'),
            ('UV/2m/UV2m_00128.sofa', 'c5519c8bcb1d9a43413e3cb85b824c71'),
            ('UV/2m/UV2m_00130.sofa', '435d715ded0ba858222e29917fe6265d'),
            ('UV/2m/UV2m_00131.sofa', '9441a6a5cd5abf39add909f3bb908c26'),
            ('UV/2m/UV2m_00132.sofa', 'f49e693f3a819db82cdb78da93a37b6b'),
            ('UV/2m/UV2m_00133.sofa', '9ffd0eadcbaa1f8e7206c0287222dac0'),
            ('UV/2m/UV2m_00136.sofa', '397d89b1bdf3fc76f50c235864bf5636'),
            ('UV/2m/UV2m_00137.sofa', 'd9b8b9db55523cbe35fa3849420338a4'),
            ('UV/2m/UV2m_00139.sofa', '5b5c63941d1ab18b3de29e7f8f56aa3a'),
            ('UV/2m/UV2m_00140.sofa', '05d576b3b0f468c77db99e3878bb5997'),
            ('UV/2m/UV2m_00142.sofa', '86d9c2ab7e33413e528023ee7c847e87'),
            ('UV/2m/UV2m_00145.sofa', '1e1d9b55b4513ffc496911d754875b7a'),
            ('UV/2m/UV2m_00146.sofa', 'ea452f96ef93b8d8aa0d990e569d3415'),
            ('UV/2m/UV2m_00147.sofa', 'cd16c0df24df4b426245b9f5944718b4'),
            ('UV/2m/UV2m_00148.sofa', '2b9193be3ccb54b16fb2bfbd353a87b0'),
            ('UV/2m/UV2m_00149.sofa', '83b726772f595df8729d9e0febe3ae5b'),
            ('UV/2m/UV2m_00150.sofa', 'd21c966770ec28482eb3611bb9bb8f66'),
            ('UV/2m/UV2m_00152.sofa', 'fccf4e0d2d0b356caff260786ed5fc20'),
            ('UV/2m/UV2m_00153.sofa', '64c004d3ee44f1dc2a7ec73cb22473bc'),
            ('UV/2m/UV2m_00154.sofa', 'f097ef9c62796ef1395dfb57faebb736'),
            ('UV/2m/UV2m_00155.sofa', 'de4f8c52ba472e5ae96a890ba7281291'),
            ('UV/2m/UV2m_00156.sofa', 'f368469fe3951dd1e88b0bf3c5c30357'),
            ('UV/2m/UV2m_00157.sofa', 'd4ecb311212faae3f37a15d48186c6d5'),
            ('UV/2m/UV2m_00158.sofa', 'c41f39fec046b8e1b5fc9320d111dd18'),
            ('UV/2m/UV2m_00159.sofa', '103e73b90ae264d68beee3dae591fd60'),
            ('UV/2m/UV2m_00161.sofa', '367b54372c7fc8efe6db83f8fc5ab25f'),
            ('UV/2m/UV2m_00164.sofa', '0719d1befb96b8c8c8b1ce65c0cb3f55'),
            ('UV/2m/UV2m_00165.sofa', '864c72b1a08275afb5c3ca50f658f709'),
            ('UV/2m/UV2m_00166.sofa', '4d21826b9366a105b8c2ffede5a715ba'),
            ('UV/2m/UV2m_00168.sofa', '7209852d47804857c148720363d211f7'),
            ('UV/2m/UV2m_00169.sofa', '18983d1a85abf0e3bb4eab653fd19a54'),
            ('UV/2m/UV2m_00170.sofa', '8661b263c8fcc04f42cb56bc900dae85'),
            ('UV/2m/UV2m_00171.sofa', '6b92729139be5a10d128438011078bef'),
            ('UV/2m/UV2m_00173.sofa', '05d59d0c0947c5d6af592e2434d91906'),
            ('UV/2m/UV2m_00175.sofa', 'a23930150812bfef728f7adb4474493c'),
            ('UV/2m/UV2m_00176.sofa', '6385b32a08f51682a0cbee67dc9ee87f'),
            ('UV/2m/UV2m_00177.sofa', '7be1704f6b9d8fcc23e938a3dc0b9ad9'),
            ('UV/2m/UV2m_00178.sofa', 'fc604f0506f87b24d3e4a51045d342ef'),
            ('UV/2m/UV2m_00179.sofa', '832e63b289c5730f39558259c4eaf929'),
            ('UV/2m/UV2m_00183.sofa', '0b8eaf0b7892c8ea3712bc5a661f3984'),
            ('UV/2m/UV2m_00184.sofa', '0cd82aa650bab8068452729a36df19b9'),
            ('UV/2m/UV2m_00185.sofa', 'b32e7499bf86f08a87a7df1518ff3abc'),
            ('UV/2m/UV2m_00186.sofa', '97d1704406ebc927d9c3a3e4b55c9c4f'),
            ('UV/2m/UV2m_00188.sofa', '8500c321ddc9f1bb8ec181941b08e8fc'),
            ('UV/2m/UV2m_00189.sofa', 'b9ba7fa466834d6c65e2bfffc4d887e4'),
            ('UV/2m/UV2m_00190.sofa', '9aa5634260be3e655f440d0fa86593eb'),
            ('UV/2m/UV2m_00191.sofa', 'bb56dfeb03a27f8ca2d20acb1b5b0c98'),
            ('UV/2m/UV2m_00194.sofa', 'a8ca2f7865a94e3cb280d0ee4a6370c3'),
            ('UV/2m/UV2m_00195.sofa', '5d5483dfd821e256b985c59a1eef4408'),
            ('UV/2m/UV2m_00196.sofa', '97c999a71c94b75efefba7c60da421ed'),
            ('UV/2m/UV2m_00197.sofa', '575a60b641fa2721f9618cc9582afe54'),
            ('UV/2m/UV2m_00198.sofa', '1bf7c0a1d2f51315d18c20c6a90dd3ac'),
            ('UV/2m/UV2m_00201.sofa', 'ed64fb5b6e845cefc45f047ad596f67a'),
            ('UV/2m/UV2m_00203.sofa', '0923f28131374eed5e599519d0af242a'),
            ('UV/2m/UV2m_00204.sofa', '139a5a11a850699bf6e3035dd3527a89'),
            ('UV/2m/UV2m_00205.sofa', '3428cc84b08bc067f4c7580ec6c973fd'),
            ('UV/2m/UV2m_00206.sofa', 'f1514b4a6b3e4ffdb0e952a36ca11d17'),
            ('UV/2m/UV2m_00209.sofa', '4cf3c022026361850eb71778f4f34352'),
            ('UV/2m/UV2m_00210.sofa', '3fd094c2dd48f62b38b1076ae46a3807'),
            ('UV/2m/UV2m_00211.sofa', '8412207c573cf750b3cf78124eb16027'),
            ('UV/2m/UV2m_00212.sofa', '709ce3bf4df5c37bb3f321e86d551dda'),
            ('UV/2m/UV2m_00213.sofa', 'e7034c72f05ed6273b5efe6d556888d5'),
            ('UV/2m/UV2m_00214.sofa', '915f3e30404e2d2e1fe9fa861533a5f6'),
            ('UV/2m/UV2m_00215.sofa', '7122df6453a0e8e9df611cfc3a47dedd'),
            ('UV/2m/UV2m_00216.sofa', '15d61927ec8f72bc78681330e6cedc7b'),
            ('UV/2m/UV2m_00217.sofa', '3d3e1998e9880f2119f71901dd115c61'),
            ('UV/2m/UV2m_00219.sofa', '5f101825d46075f8c9dcc70db27bfb1a'),
            ('UV/2m/UV2m_00220.sofa', 'b967ad5328b5c37f65dae54d72b7f495'),
            ('UV/2m/UV2m_00221.sofa', '649699404f6b2578a11d2ecfd153e16c'),
            ('UV/2m/UV2m_00222.sofa', '3614ea48d94474122d26da74d7d4aa51'),
            ('UV/2m/UV2m_00223.sofa', '13c25cb77c80f63756deea34b1128cee'),
            ('UV/2m/UV2m_00224.sofa', '51ecfabc05d9416280f85ef438ed054d'),
            ('UV/2m/UV2m_00225.sofa', '30132b52a3140dd37c1671d0750cbf75'),
            ('UV/2m/UV2m_00226.sofa', '743026e010aa3d1260d08859b18a58ca'),
            ('UV/2m/UV2m_00227.sofa', 'cbaf931b3ee4a5cccd6c1accfb10b6d9'),
            ('UV/2m/UV2m_00228.sofa', '22eb81b7691ac01cb860fd90a90254f2'),
            ('UV/2m/UV2m_00229.sofa', '9433facaf60e4bfa5283a1b0afe68d40'),
            ('UV/2m/UV2m_00230.sofa', 'd3dc0ed855f36f3daaf432229016d396'),
            ('UV/2m/UV2m_00231.sofa', '5cf92647cb01b3676070f112700ca6ff'),
            ('UV/2m/UV2m_00232.sofa', 'b316bdcbd2ede33bccb36070fb02755a'),
            ('UV/2m/UV2m_00233.sofa', 'ba71f2f0011a450c9001dadab262172a'),
            ('UV/2m/UV2m_00234.sofa', 'e561fa304c397dae933588c95929c45f'),
            ('UV/2m/UV2m_00235.sofa', 'be1cd2cecdecfdafd05e801e544d29fb'),
            ('UV/2m/UV2m_00236.sofa', 'c2f9c4164d48966c73a481039f2dafa4'),
            ('UV/2m/UV2m_00237.sofa', '0601cbfe2229eaa8a94892aa6a221e39'),
            ('UV/2m/UV2m_00238.sofa', '5c91c9234de53a654d351beb8ba6f49b'),
            ('UV/2m/UV2m_00239.sofa', '5257285f8633f5bfd9fd7dbf7440f349'),
            ('UV/2m/UV2m_00240.sofa', 'd3fe97a6afe3074491e3156b51b50ffc'),
            ('UV/2m/UV2m_00241.sofa', '01bc588877dd6494b7c87a2379f4aeee'),
            ('UV/2m/UV2m_00244.sofa', '357b67297d19aba5301648a796bc0f63'),
            ('UV/2m/UV2m_00245.sofa', 'f9119bf5f65676dcce22a7d4b0800633'),
            ('UV/2m/UV2m_00246.sofa', '2c16fb3c59d1c9013d901baad8be2b99'),
            ('UV/2m/UV2m_00247.sofa', '5ebf8d6c369d8c224e7bb62bf2bbe064'),
            ('UV/2m/UV2m_00248.sofa', '5268e2add3bc890278e8399e13c0f4d8'),
            ('UV/2m/UV2m_00251.sofa', '64b300cb6d10db9b881592529fa8d540'),
            ('UV/2m/UV2m_00252.sofa', 'ab4fa2d3c53697f160a0275c41842a63'),
            ('UV/2m/UV2m_00253.sofa', 'e5df69ab644ab388ad178659ab2280ff'),
            ('UV/2m/UV2m_00254.sofa', 'b55541282a6177fc047e036e18cbc2bc'),
            ('UV/2m/UV2m_00256.sofa', '8259a703a996f5407a03bdac7e02c778'),
            ('UV/2m/UV2m_00258.sofa', '787e09c661d893e59406f3e1566174b9'),
            ('UV/2m/UV2m_00259.sofa', 'e487fd28ae7b3358af8903365d71c292'),
            ('UV/2m/UV2m_00261.sofa', '606c4a814eaa8feeca9ecf05dfae05f0'),
            ('UV/2m/UV2m_00262.sofa', 'cc5978099db0eb26bbbfd0b6f9bdf415'),
            ('UV/2m/UV2m_00263.sofa', '5e7f8afae2f838025e3d123f70f23074'),
            ('UV/2m/UV2m_00264.sofa', 'f9c0512a1396847009b61c1d66e89372'),
            ('UV/2m/UV2m_00265.sofa', '826cf6ca7194480aabfd1ed22d0c424f'),
            ('UV/2m/UV2m_00268.sofa', 'dfc7fac91c123c4844dd7c548c51db17'),
            ('UV/2m/UV2m_00269.sofa', '804e3aedf558b127669438d5abf82b6f'),
            ('UV/2m/UV2m_00270.sofa', 'a47a7dd4439820ba8ee8982142b58d63'),
            ('UV/2m/UV2m_00271.sofa', '58c09b2a75f70e6b17bed5de2f2f03f3'),
            ('UV/2m/UV2m_00272.sofa', '561d12d7d7f887fa29ac13054ea7c62f'),
            ('UV/2m/UV2m_00273.sofa', 'e64966af42fb6ea85b9d4b06bced9a85'),
            ('UV/2m/UV2m_00275.sofa', '6cf9122a04ae8b341152ad516f23b048'),
            ('UV/2m/UV2m_00276.sofa', '7fb495253ec437f5b095e04c01a943bc'),
            ('UV/2m/UV2m_00277.sofa', '53790eb782a2dfbb42375094b8691d5d'),
            ('UV/2m/UV2m_00278.sofa', 'f5402d50d94a44c6a13ae206b5e5facc'),
            ('UV/2m/UV2m_00279.sofa', 'ceea35cbfd435c6fec9739bf8381bad4'),
            ('UV/2m/UV2m_00281.sofa', 'f077b7dd181bc9a75a4ecf1d41b1af27'),
            ('UV/2m/UV2m_00283.sofa', 'f935f7c5cf718188a0ffcabf743bb4e6'),
            ('UV/2m/UV2m_00284.sofa', '70f52e38c18253fbc772cf4628aa27d7'),
            ('UV/2m/UV2m_00285.sofa', 'c47606b0e0bc8dfb1ecaa61b46d70a3f'),
            ('UV/2m/UV2m_00286.sofa', '331e2d1aa32f11600634a9a3bff2a2c2'),
            ('UV/2m/UV2m_00287.sofa', '2ee5520463ba560f8a94ce82e57deb35'),
            ('UV/2m/UV2m_00288.sofa', 'f5a5f1815d927bfb1358a4f7e1fc0149'),
            ('UV/2m/UV2m_00289.sofa', 'bdbe28dd840e65b9ddcbebd7484fb1e7'),
            ('UV/2m/UV2m_00290.sofa', '909fec69039112977ff4081b5b79f50a'),
            ('UV/2m/UV2m_00291.sofa', '0580a3f87f9786142bdd59b032818829'),
            ('UV/2m/UV2m_00293.sofa', 'b6a2d15f51e97a5c48186c702af34aa5'),
            ('UV/2m/UV2m_00294.sofa', '6a0367fb27ef17f03e9236d62022e869'),
            ('UV/2m/UV2m_00295.sofa', '3700be0ead1665d60d1c147156a65374'),
            ('UV/2m/UV2m_00296.sofa', '339d423c5d988483c3312286c59c3611'),
            ('UV/2m/UV2m_00297.sofa', 'bf26624241e224e95fc2afb7d6aabb50'),
            ('UV/2m/UV2m_00298.sofa', '47b3b3313bd25183463447c76117d02b'),
            ('UV/2m/UV2m_00301.sofa', 'be9cea65828b7d4339bcd08c2bb454d7'),
            ('UV/2m/UV2m_00303.sofa', 'c3aa434cc654c7ce80a0a42e0db890b3'),
            ('UV/2m/UV2m_00305.sofa', '4ffc52741cce9f65de5e529a71914bd7'),
            ('UV/2m/UV2m_00306.sofa', '516b3a5cd1a92610088ef133a733bec4'),
            ('UV/2m/UV2m_00307.sofa', 'e6be3ece282010a0be78ce239cccdb2a'),
            ('UV/2m/UV2m_00308.sofa', '5ee95a42f2c3acb80ea9c0e8905b9cf2'),
            ('UV/2m/UV2m_00309.sofa', '71df4f1a5f4cf7903e56a8993c7537cc'),
            ('UV/2m/UV2m_00311.sofa', '9c37bbc6ca6344b8bcc94cdae85d5dca'),
            ('UV/2m/UV2m_00315.sofa', '492b61ca55d7d1ce5f7d4eb399bedbc3'),
            ('UV/2m/UV2m_00318.sofa', 'e06ad078df7566be1afbfe2337b6ae68'),
            ('UV/2m/UV2m_00319.sofa', 'cb4f373facc1af2a357580cf2323b7ce'),
            ('UV/2m/UV2m_00320.sofa', '9539b88a7a7c81ddac4eb79aee45fe27'),
            ('UV/2m/UV2m_00321.sofa', '1929792149a45147a3ae719a334eaa22'),
            ('UV/2m/UV2m_00322.sofa', 'f14dca769c5f0d3b81d8fac2f4d00278'),
            ('UV/2m/UV2m_00323.sofa', '697cc0d7229ab646a68604c8370a6c50'),
            ('UV/2m/UV2m_00326.sofa', '63ac7651b01de1f280d5894865c2b748'),
            ('UV/2m/UV2m_00328.sofa', '33e1842a866321481daa68d77691a5ac'),
            ('UV/2m/UV2m_00329.sofa', '470935d72c7e88504e01c864eff1edc5'),
            ('UV/2m/UV2m_00331.sofa', '820109da52de57a3f7bd9878efe0b12c'),
            ('UV/2m/UV2m_00332.sofa', 'dde0b0387e32efaefc1cc518b1483f8f'),
            ('UV/2m/UV2m_00333.sofa', '040b51f9d017d50539a79a8dc1316ee6'),
            ('UV/2m/UV2m_00334.sofa', '56004425b246c84e21098bed4ae7b2f5'),
            ('UV/2m/UV2m_00335.sofa', 'b3fccf7c5d558e5a8233f324934c5bce'),
            ('UV/2m/UV2m_00336.sofa', 'c1c59533633e1cc9ada580076412226d'),
            ('UV/2m/UV2m_00337.sofa', 'feb3970bf62f96e1d7683d0fd683045b'),
            ('UV/2m/UV2m_00338.sofa', '687a34ed8d9861e10b8b56e5b811c217'),
            ('UV/2m/UV2m_00340.sofa', '9aa5f5632e20f70ca098706b16d7ac8e'),
            ('UV/2m/UV2m_00341.sofa', 'd29554a12b5548e879cce7ba93682ee1'),
            ('UV/2m/UV2m_00343.sofa', '408041a3fac86e260df091d2b4effe54'),
            ('UV/2m/UV2m_00344.sofa', 'f78bfa4d1256245981bc95baa3efa167'),
            ('UV/2m/UV2m_00345.sofa', 'cbb0d7affefa8cdecd7deed67dce8280'),
            ('UV/2m/UV2m_00347.sofa', 'a4ffd94479d3b54f371202f0208044cf'),
            ('UV/2m/UV2m_00348.sofa', 'bb19d4afbf9f1250f15d5147bdac252b'),
            ('UV/2m/UV2m_00349.sofa', '9ce817c6f0e5c11b2b383bc704ba5d82'),
            ('UV/2m/UV2m_00350.sofa', 'e910cfc37010b49e6b50fdcf927aeb3e'),
            ('UV/2m/UV2m_00351.sofa', 'f0605557ad00bb6d6badf306a1bb2f03'),
            ('UV/2m/UV2m_00352.sofa', '2b08fe9351c0285350cbd7857737b33f'),
            ('UV/2m/UV2m_00353.sofa', '7715949c952aa8441c3199defe13149e'),
            ('UV/2m/UV2m_00354.sofa', '0629fef7806d8099b93c8f23b0282685'),
            ('UV/2m/UV2m_00355.sofa', 'bc846d7af9bda5f6ccbcbe93d6a34d84'),
            ('UV/2m/UV2m_00356.sofa', '20d8b61a0ee11b4313d27b379c803473'),
            ('UV/2m/UV2m_00358.sofa', 'f569c9e164915c23d200e7e48986cf27'),
            ('UV/2m/UV2m_00359.sofa', 'c98fc9dcd60e3b7e3c25dcb9ee34ad21'),
            ('UV/2m/UV2m_00360.sofa', '8820de47735e7694105021f1b7a20ddc'),
            ('UV/2m/UV2m_00361.sofa', '909bdb53c39f07a00aa815994a1eebc5'),
            ('UV/2m/UV2m_00362.sofa', 'ea7e23cc59a0493b8cb76e2e323941dd'),
            ('UV/2m/UV2m_00363.sofa', '1ba3395ffb0bef85a2066e7be92d4617'),
            ('UV/2m/UV2m_00364.sofa', 'e3d74cc37e4ed330d8534b042cef254c'),
            ('UV/2m/UV2m_00365.sofa', '1379ab2dff18bfd6f7c65e7cf5d8763d'),
            ('UV/2m/UV2m_00366.sofa', '0ff817728a439af505d259de021fcbdf'),
            ('UV/2m/UV2m_00367.sofa', '97b2b9203084d22a28b6cc0f10e09296'),
            ('UV/2m/UV2m_00368.sofa', '6d895f1fb33e2939c4332c5d30571358'),
            ('UV/2m/UV2m_00370.sofa', 'c40c0f7052c00e4e6e1e61852e28cb95'),
            ('UV/2m/UV2m_00371.sofa', 'fbec3db4d6cf74bdb83f0f6ae74a1ef7'),
            ('UV/2m/UV2m_00372.sofa', '9c0ae336adae8e9fbab9ca7cf84166af'),
            ('UV/2m/UV2m_00373.sofa', '656663c61ebb0a8a1515bfcc30d0053c'),
            ('UV/2m/UV2m_00374.sofa', '5471427f58783b0f64a7405ac58781d3'),
            ('UV/2m/UV2m_00375.sofa', 'd933d37a4cb0f7046fb3d44ba06fee03'),
            ('UV/2m/UV2m_00376.sofa', '634e175b9df68afbab515c32d5b4d2df'),
            ('UV/2m/UV2m_00378.sofa', '670e169381fd36a08d23e8228677d780'),
            ('UV/2m/UV2m_00379.sofa', '6e0c6bd5541f1e6d65ed474ed04a9ede'),
            ('UV/2m/UV2m_00382.sofa', '932b4f3b7cdb0d5fc9290c37fe428825'),
            ('UV/2m/UV2m_00383.sofa', 'd8cd96b9ceb410c3ef5f564adade3a65'),
            ('UV/2m/UV2m_00385.sofa', 'b12a7321b037dd99e6d353fda02c28d0'),
            ('UV/2m/UV2m_00386.sofa', '5f8eaabe87b1127db808a4dcfbb45ff3'),
            ('UV/2m/UV2m_00389.sofa', '79ed3095f912f56a56656498c859b7f6'),
            ('UV/2m/UV2m_00391.sofa', '1e7429050165a4c9ec4c212d0c45d276'),
            ('UV/2m/UV2m_00392.sofa', '8fa9b6a441234b311c609bc2640641b2'),
            ('UV/2m/UV2m_00395.sofa', '9090724d83c979725ba30fd58267a1ea'),
            ('UV/2m/UV2m_00397.sofa', '1bcf9ff4f8e0a0aff0d68dc6208a89cd'),
            ('UV/2m/UV2m_00398.sofa', 'b8d9bcd5a6fef2d975171f106ab4d3de'),
            ('UV/2m/UV2m_00399.sofa', 'a066eea5bc00adc19c85e235dae646bc'),
            ('UV/2m/UV2m_00401.sofa', '24123810bdf0fe566dac2753d13a5434'),
            ('UV/2m/UV2m_00402.sofa', 'e90b8ce5895c03dda8ff2a92796831ba'),
            ('UV/2m/UV2m_00403.sofa', '2683308d764dc1f150ec4639ba5a7277'),
            ('UV/2m/UV2m_00404.sofa', 'b7ebb83c339eb37577aed195e559b9d4'),
            ('UV/2m/UV2m_00405.sofa', 'aee538539db014b4211ea564b402cf1f'),
            ('UV/2m/UV2m_00406.sofa', 'c7d3f7ff0e7d0b4b854691a3aaa6be7a'),
            ('UV/2m/UV2m_00407.sofa', 'dd06785077f84523a84e0cbebacb78a8'),
            ('UV/2m/UV2m_00408.sofa', 'bcdc3090ef42ac9e8a30ebc1a0fe2134'),
            ('UV/2m/UV2m_00409.sofa', 'd6c30f835318e1dbe68c178161aa4c4a'),
            ('UV/2m/UV2m_00410.sofa', '25aa1cacbcaf8e87af8f5942c46c5352'),
            ('UV/2m/UV2m_00411.sofa', '6dfb6d5e38df370c80e01b0bff5da82d'),
            ('UV/2m/UV2m_00412.sofa', 'b54beee7e53b6b1da3befda08977ecad'),
            ('UV/2m/UV2m_00413.sofa', '01b57deb1d0ce7c640681d2809be226d'),
            ('UV/2m/UV2m_00414.sofa', 'e287b8c2f7bf0ddf3e94d97651b3824c'),
            ('UV/2m/UV2m_00415.sofa', '39849322a46d98e7b9740a1d44fac308'),
            ('UV/2m/UV2m_00416.sofa', 'c09910d223db91641f51546aa863ef3c'),
            ('UV/2m/UV2m_00417.sofa', '02c3bbc0485be72ae2a15d205023cbcc'),
            ('UV/2m/UV2m_00418.sofa', 'a93b97f7cc1f17896bbab9ba025b0298'),
            ('UV/2m/UV2m_00419.sofa', '95f713397a42d9b5cc7d2ada672b1bf0'),
            ('UV/2m/UV2m_00420.sofa', 'e9a0b213be3c92d96eac63e4ca2d96df'),
            ('UV/2m/UV2m_00421.sofa', '40edfd489e606dae07d64e55fa47bc7f'),
            ('UV/2m/UV2m_00422.sofa', 'ac37e0872853a37923192088f3da58a7'),
            ('UV/2m/UV2m_00423.sofa', '4b0340f39f8a13c3598a0433f48ffb6e'),
            ('UV/2m/UV2m_00426.sofa', '367c6e41275fc274c7c829c3d57970ac'),
            ('UV/2m/UV2m_00427.sofa', 'dc5d922dc1aef56247fcd02265d4b862'),
            ('UV/2m/UV2m_00428.sofa', 'ab78e65c8db001e7932b5f0bb514b0fe'),
            ('UV/2m/UV2m_00430.sofa', '24cc3ff415844e264579a22625e5a12c'),
            ('UV/2m/UV2m_00432.sofa', '20a343ddc81444bf03efaa6c3d47923e'),
            ('UV/2m/UV2m_00433.sofa', '74b5c0628edc2207708f03a513b93b99'),
            ('UV/2m/UV2m_00434.sofa', 'a34d97919aabf1d39af92409d468c043'),
            ('UV/2m/UV2m_00441.sofa', 'e5ef1ee8ea0528bca0f9f0a10864da71'),
            ('UV/2m/UV2m_00442.sofa', 'f1ea141108d474ffd4e62d653c06f930'),
            ('UV/2m/UV2m_00443.sofa', '224ae30128a6f3747346b26a07c78cb1'),
            ('UV/2m/UV2m_00446.sofa', '694018384b8d6b61140f3a0ad8beddb8'),
            ('UV/2m/UV2m_00448.sofa', '9d20b37c4167b9b737349cfb5f6333ce'),
            ('UV/2m/UV2m_00449.sofa', '5b8dd0402605c3f01bccbcb8e454323a'),
            ('UV/2m/UV2m_00450.sofa', 'c9c25c4e5c36a96b9baff152d11a40bc'),
            ('UV/2m/UV2m_00451.sofa', '2157130760dacf4f1b08394b7d44cd67'),
            ('UV/2m/UV2m_00452.sofa', 'fbafecdfd3122343d6c5cfab8450c864'),
            ('UV/2m/UV2m_00455.sofa', 'e2fb615346866f3c53159a7317a95ad3'),
            ('UV/2m/UV2m_00456.sofa', '2781d4411f5345850eb7d66c4fd6bca1'),
            ('UV/2m/UV2m_00457.sofa', '417f806b984d5760254954d0d041aa72'),
            ('UV/2m/UV2m_00459.sofa', 'da82defe928b7d55658583837e933744'),
            ('UV/2m/UV2m_00460.sofa', 'e5e256c33ec83152a5e078605cfeb6f5'),
            ('UV/2m/UV2m_00461.sofa', '74187ab38fdf3340d3b2bcc97ade3eac'),
            ('UV/2m/UV2m_00462.sofa', 'dbc37873a5015343ccea1f77a7031954'),
            ('UV/2m/UV2m_00463.sofa', '0e9c6fc51ca948d81b8428343d02b6dd'),
            ('UV/2m/UV2m_00464.sofa', '950b1571c04b357981a000e5a73ec5f3'),
            ('UV/2m/UV2m_00466.sofa', '26151848f6777538fc673d27596a5d77'),
            ('UV/2m/UV2m_00467.sofa', 'ac3d632fa707d2de937af4539ce5b69c'),
            ('UV/2m/UV2m_00468.sofa', 'a2eae874ee0f42b183528329e8972593'),
            ('UV/2m/UV2m_00469.sofa', 'fc13a8ac593e7909746270cbabb4c2de'),
            ('UV/2m/UV2m_00470.sofa', '6f8b950b81433d0db9da951d3969fdb1'),
            ('UV/2m/UV2m_00471.sofa', 'ecd0ad8c0af44c370a8960ef79900897'),
            ('UV/2m/UV2m_00472.sofa', '920aa99c10d6b829589d39309207bbc5'),
            ('UV/2m/UV2m_00473.sofa', 'c306ad56827bece266310a8e2d3dc1bb'),
            ('UV/2m/UV2m_00474.sofa', '7f0b80ae96ecf7aa2dfdb7bca363f432'),
            ('UV/2m/UV2m_00476.sofa', 'b09571c8bb3522f1daacdad8c817ddab'),
            ('UV/2m/UV2m_00477.sofa', '592ad0df5cc36e1fe01d83868fe756aa'),
            ('UV/2m/UV2m_00478.sofa', '156b38d0f469bbe91fe6bd0075585659'),
            ('UV/2m/UV2m_00480.sofa', '5db83fd414d1e6ea0abe1a5aeb4b60c0'),
            ('UV/2m/UV2m_00481.sofa', '91474cc220a7e85bd6ad7cff371aa517'),
            ('UV/2m/UV2m_00482.sofa', '0c27e5f9acf991c52b2ab98ed9b4c79f'),
            ('UV/2m/UV2m_00483.sofa', 'bb31ddfa9cf51753fb0c5815bbf7cd09'),
            ('UV/2m/UV2m_00484.sofa', '18ba3b5e18483bbddbf9c1494378f3d5'),
            ('UV/2m/UV2m_00486.sofa', 'f8cd60fd607d4653f01e7b9c2c1fb4bb'),
            ('UV/2m/UV2m_00487.sofa', 'f822e240787f0371415b5d71cd5ad1eb'),
            ('UV/2m/UV2m_00489.sofa', 'e7abd0d383122b431cc8478ad5e8a6a5'),
            ('UV/2m/UV2m_00490.sofa', '14a755f1965dd905f358900ac8fd0244'),
            ('UV/2m/UV2m_00491.sofa', 'ee3e86cc82f3c5844f060c4e6e4f794b'),
            ('UV/2m/UV2m_00493.sofa', 'd96bf95268fa63cce49b5c2c3931b21e'),
            ('UV/2m/UV2m_00494.sofa', '22c008d882397b7dc1697b6582b1eb04'),
            ('UV/2m/UV2m_00497.sofa', '186996ae65b9c6ad3d507e40cb7f1d8c'),
            ('UV/2m/UV2m_00499.sofa', '1b06e4d6097b07a581b92cb397f184e0'),
            ('UV/2m/UV2m_00500.sofa', '722ab051bac96ce87a694e5ffd09e04e'),
            ('UV/2m/UV2m_00501.sofa', '2f564091cb93a65b622a7108a7aeb05f'),
            ('UV/2m/UV2m_00502.sofa', '64fb66fb1e85701f77896d8ad8ea10e2'),
            ('UV/2m/UV2m_00503.sofa', '196ff12be5d4172d9dce4f6450cd5b34'),
            ('UV/2m/UV2m_00505.sofa', '0d11447d2604b60ca98b53d087cfbbab'),
            ('UV/2m/UV2m_00506.sofa', '471060f1a076fd21a05f3cbda5e5c9a5'),
            ('UV/2m/UV2m_00507.sofa', '62891e55678c8da96872f9b8d294d7ce'),
            ('UV/2m/UV2m_00508.sofa', 'e00ca50fb4625821d69183fe5f91655c'),
            ('UV/2m/UV2m_00509.sofa', '825546d0fce5c20bf88da6c3d6db846d'),
            ('UV/2m/UV2m_00511.sofa', '2c3b30c0ead8128527a4f4bc31c5ac3e'),
            ('UV/2m/UV2m_00512.sofa', '713f16a2c5f2fb1049a41c3a96fb44c5'),
            ('UV/2m/UV2m_00513.sofa', 'b5c9c31ed6803b79755ff43859de57fe'),
            ('UV/2m/UV2m_00514.sofa', '3dd1f7564d93363f21c63ec2c0753c88'),
            ('UV/2m/UV2m_00515.sofa', '88ca095b3621eedfec2b9cb8f3e29221'),
            ('UV/2m/UV2m_00516.sofa', 'ac8f113ff1329f5ba2c986119fc8ed33'),
            ('UV/2m/UV2m_00517.sofa', '2df2f6d841d2c863d7db66b685ac636a'),
            ('UV/2m/UV2m_00518.sofa', '7ef668f7056c7f3cb8deb405072c46cb'),
            ('UV/2m/UV2m_00519.sofa', '3c971e0b13e3a6356c28f158eb5d4c7e'),
            ('UV/2m/UV2m_00520.sofa', 'e6c5adce834e966bad04ac0ec799f98c'),
            ('UV/2m/UV2m_00521.sofa', 'b0155f9b8291bac6d6e96081d9550be2'),
            ('UV/2m/UV2m_00523.sofa', 'e45cc1070f609be53133648880f2f253'),
            ('UV/2m/UV2m_00524.sofa', '2712aabc56760ca9badd5fd69c0bb7e7'),
            ('UV/2m/UV2m_00525.sofa', '81614260303953d79bc4489909b3e878'),
            ('UV/2m/UV2m_00526.sofa', '821bfb44a021a45f0cc1892953d088b5'),
            ('UV/2m/UV2m_00527.sofa', '66bf7bbabe1d01811b95bfc1d9cf8ce2'),
            ('UV/2m/UV2m_00528.sofa', 'c0dd30660cae431b8ae71ac479a09cd3'),
            ('UV/2m/UV2m_00529.sofa', '94ee2596fdd9192a72fc0d4877dc356a'),
            ('UV/2m/UV2m_00530.sofa', 'f80a7ad9d4f9090a69720fb12801818e'),
            ('UV/2m/UV2m_00532.sofa', '6bc4515720ae16e1d6c959dcc5624432'),
            ('UV/2m/UV2m_00533.sofa', 'f4d1d66961e5a496f53d8b5e09cd62cd'),
            ('UV/2m/UV2m_00534.sofa', '879efd7d95895eb257d5035f6b299d3d'),
            ('UV/2m/UV2m_00536.sofa', 'ed30278ac7b803e4f5a7f85a4d0d18e7'),
            ('UV/2m/UV2m_00538.sofa', 'bd4eeea5fce42e6f0a5bb9639280b153'),
            ('UV/2m/UV2m_00539.sofa', '8e7578da2c7cac1b69a5599833ef0090'),
            ('UV/2m/UV2m_00540.sofa', '3d81dd3b2f54be3b9538bad697b7c076'),
            ('UV/2m/UV2m_00542.sofa', 'bd40d4138376ab931acb623ca37c72c4'),
            ('UV/2m/UV2m_00543.sofa', '57468297219481335ea4b968aa403cbf'),
            ('UV/2m/UV2m_00544.sofa', '5b867a593554a9503a62434742366a7e'),
            ('UV/2m/UV2m_00545.sofa', 'c73d61e62ab9b9f147d4dbc76317ef14'),
            ('UV/2m/UV2m_00546.sofa', '62fa3bb78807d11b07c18603742879ec'),
            ('UV/2m/UV2m_00547.sofa', 'ac80b19c543f63deda17bd9163e230f3'),
            ('UV/2m/UV2m_00548.sofa', '5723a33de102f04d09780314d1518b2d'),
            ('UV/2m/UV2m_00549.sofa', '0ce10e15fad2953c8f51e5fb99521dae'),
            ('UV/2m/UV2m_00550.sofa', 'e51ec2fbc64a2c58ab7e05ec2feb28cd'),
            ('UV/2m/UV2m_00551.sofa', '1231a238ebb20f7e74805374ccec00bb'),
            ('UV/2m/UV2m_00552.sofa', '7dd1a55572346bd3ec77ed34958be12b'),
            ('UV/2m/UV2m_00553.sofa', 'fca8d7bdce7c84fb76a42a3ccad6ec74'),
            ('UV/2m/UV2m_00555.sofa', '8440b5805a88ab65e1ec8b300b5bb0b6'),
            ('UV/2m/UV2m_00557.sofa', '923f694ca09df8372008defe2be436cd'),
            ('UV/2m/UV2m_00558.sofa', 'e4a00ad72303859577fe1fd0fcc541b3'),
            ('UV/2m/UV2m_00559.sofa', '1cdad5792d09cd36475234d4723200ca'),
            ('UV/2m/UV2m_00560.sofa', 'b316fd9818d618c2dd1c2a8e1e6109a4'),
            ('UV/2m/UV2m_00561.sofa', 'd85018bd01f6559fdbf2aa4cc830917b'),
            ('UV/2m/UV2m_00562.sofa', 'e79b8b88580720265a630f85a982287f'),
            ('UV/2m/UV2m_00563.sofa', '297d51ec76f98dd49a4366bcd181fb50'),
            ('UV/2m/UV2m_00567.sofa', 'bf4ec52323b2e05610db4c23dcb3c679'),
            ('UV/2m/UV2m_00568.sofa', '18b60718bf0ee077e0b981cfa9a004a7'),
            ('UV/2m/UV2m_00569.sofa', '38bd7d2df444eb03a2a418a98ad716b0'),
            ('UV/2m/UV2m_00570.sofa', 'b3072331cf4113754f387afd18cc45e2'),
            ('UV/2m/UV2m_00571.sofa', '6436e943ca3283c07cef14967f7ca213'),
            ('UV/2m/UV2m_00572.sofa', 'ab247165a0347a461f7cce1a69f9c4ae'),
            ('UV/2m/UV2m_00573.sofa', '9dde2377d4b682c5607c6c793173b240'),
            ('UV/2m/UV2m_00576.sofa', '8c4455fd8c5d086216cd34595d515690'),
            ('UV/2m/UV2m_00577.sofa', '78c8064fbbf011b2ed97bb10319d9e2a'),
            ('UV/2m/UV2m_00580.sofa', 'f2db33e481b8385f61d8cd27e44a1dc1'),
            ('UV/2m/UV2m_00582.sofa', '53c56ceab15cca7cd8da0e608ca6223c'),
            ('UV/2m/UV2m_00583.sofa', '4c60743cbfa9891a195273230e8db327'),
            ('UV/2m/UV2m_00585.sofa', '5552cc6c92b44e18f531c13981b9e67d'),
            ('UV/2m/UV2m_00588.sofa', '876e3e4913160eed3693fe59a813e8d4'),
            ('UV/2m/UV2m_00590.sofa', 'cab59bbbae35b3355e57ab0f957da304'),
            ('UV/2m/UV2m_00591.sofa', '2a552e2ecc62919feaf27860dc02c756'),
            ('UV/2m/UV2m_00592.sofa', 'd8c0b874fd7708f06d62203846dd2f44'),
            ('UV/2m/UV2m_00593.sofa', '7e9bb6e0cffd420baedf69f3aa8c3f22'),
            ('UV/2m/UV2m_00594.sofa', '536d9261ceb5e0fd5df960d572ecc1c1'),
            ('UV/2m/UV2m_00595.sofa', '912dcdc26267513f29f69af4a630e520'),
            ('UV/2m/UV2m_00596.sofa', 'ea41f1a653069e01ff83859353078f0b'),
            ('UV/2m/UV2m_00597.sofa', '9a126593f4282e41ca187cc21cd82f02'),
            ('UV/2m/UV2m_00598.sofa', '01d25310bf2ee614e11736cad3cd53a7'),
            ('UV/2m/UV2m_00599.sofa', 'a7532b7b6ebb2a2fd70cf5f552ca3d49'),
            ('UV/2m/UV2m_00600.sofa', 'a771bc3e908c26a903d245539130f665'),
            ('UV/2m/UV2m_00601.sofa', 'cce513d4f4381336ca90384deebf21d7'),
            ('UV/2m/UV2m_00604.sofa', '28cb46fa0f1ebdb58e4688baf6457e5d'),
            ('UV/2m/UV2m_00606.sofa', '0f4a5575b102d0238b6efaaf7e6db49f'),
            ('UV/2m/UV2m_00608.sofa', '2bad1141ce70a980a62df50265e1670e'),
            ('UV/2m/UV2m_00609.sofa', 'f9a1801a455814bf651a904df0a3f749'),
            ('UV/2m/UV2m_00613.sofa', '5785ddedf63a5a316472fa2ddad67fe2'),
            ('UV/2m/UV2m_00616.sofa', 'a14e0c7561f140011cc8937d9b5b1e08'),
            ('UV/2m/UV2m_00617.sofa', 'd06f2a673a197a01ee26e14c210a8ab6'),
            ('UV/2m/UV2m_00618.sofa', '5299f47e00f244169cf9bbde783be581'),
            ('UV/2m/UV2m_00619.sofa', '02c0daf6f63b01ae84b3122c8fab5905'),
            ('UV/2m/UV2m_00620.sofa', '000bdc3172afa76c0fbd1f745ab60414'),
            ('UV/2m/UV2m_00621.sofa', '215a47776a3cdd0f3e20bc056f05d063'),
            ('UV/2m/UV2m_00622.sofa', '5278205238c8e33d48919b35e2cfad31'),
            ('UV/2m/UV2m_00623.sofa', '014c7a98466240b5eeb7cb8d71d256bd'),
            ('UV/2m/UV2m_00624.sofa', '072ceb08cbe8ef1781b82c23e1538ab4'),
            ('UV/2m/UV2m_00625.sofa', '1c42cb668fa430fa3bf67503ad012484'),
            ('UV/2m/UV2m_00626.sofa', 'a686fc84f344ec8889b6b8d7cabb6616'),
            ('UV/2m/UV2m_00628.sofa', '7b312a721941c6dc39822216549fb4c8'),
            ('UV/2m/UV2m_00629.sofa', '7ff7b7765c7d7ae5fc1979d5fa305325'),
            ('UV/2m/UV2m_00630.sofa', '521e984094422e91033ea975fa7ef223'),
            ('UV/2m/UV2m_00631.sofa', '54555968bf66a07e64be92ff0646ee1f'),
            ('UV/2m/UV2m_00632.sofa', '2af73f74c7f76411cfad8e2d7a82d7f3'),
            ('UV/2m/UV2m_00633.sofa', 'f939e27e90f1533d4ff5ae51763c507b'),
            ('UV/2m/UV2m_00634.sofa', '1c1f406d6f0adb9e3bdab125147e7703'),
            ('UV/2m/UV2m_00635.sofa', '3164a8fe73ed5b897b00ff20ef5f09ae'),
            ('UV/2m/UV2m_00636.sofa', '423c15cec7bae992f3bfa6daaf0629e0'),
            ('UV/2m/UV2m_00637.sofa', '712ad9cf97476f5c6bc5a77af50651a9'),
            ('UV/2m/UV2m_00640.sofa', '5e4a722f2b450c45620bbb5288cd39eb'),
            ('UV/2m/UV2m_00642.sofa', '047bf14040e375b5b6ccf94f4c765c4e'),
            ('UV/2m/UV2m_00643.sofa', 'fc944dd40bb561ffa72d349329f4737c'),
            ('UV/2m/UV2m_00644.sofa', '5640887c7531de6c5369d4c81101275f'),
            ('UV/2m/UV2m_00645.sofa', 'eb61005e1d1bce44290f212575b5ca7a'),
            ('UV/2m/UV2m_00646.sofa', 'fd4b9c6d1df0a4963aad032faae6c945'),
            ('UV/2m/UV2m_00647.sofa', 'ab98a02e9846030a0a79c00b52bc4f69'),
            ('UV/2m/UV2m_00648.sofa', 'd80a7bb722094ddcc9356cecd1aef3ce'),
            ('UV/2m/UV2m_00649.sofa', 'db98d97e26974ba1649630fe885f01d9'),
            ('UV/2m/UV2m_00650.sofa', '9f5e3960e9fd7d87fe32d3f7867209b2'),
            ('UV/2m/UV2m_00651.sofa', 'f5a31316ba9ad5e05b1c35b8fc9dfd2c'),
            ('UV/2m/UV2m_00654.sofa', '74d14e4c9f9d653c5d9ee0686ab264da'),
            ('UV/2m/UV2m_00655.sofa', '73321511501b9e8e19896bb1b5b845b4'),
            ('UV/2m/UV2m_00657.sofa', 'b2549bc75bb2bb43696a0ef1476ec5e6'),
            ('UV/2m/UV2m_00660.sofa', 'e36201dd315ba026336ee57b710bff5f'),
            ('UV/2m/UV2m_00661.sofa', 'ba7144b21bbe84b1223c3f690dcb1b2d'),
            ('UV/2m/UV2m_00662.sofa', '565dfb4dbc9f24432c4cd1a21a3a7452'),
            ('UV/2m/UV2m_00664.sofa', '429f1b5da70bcaab821b3909e8ef15c9'),
            ('UV/2m/UV2m_00665.sofa', '97926c7c6aaf0c3061d5a045d34ec856'),
            ('UV/2m/UV2m_00666.sofa', '5dbd78d6db603a35b72d48725968f48e'),
            ('UV/2m/UV2m_00667.sofa', '49f5e424f9d1ed6a8915ac2ee035fa23'),
            ('UV/2m/UV2m_00668.sofa', 'dc4a5219d0076cfb38f0842d0979a99d'),
            ('UV/2m/UV2m_00669.sofa', 'bec11221a85ae94e3705f8f2a1367593'),
            ('UV/2m/UV2m_00670.sofa', '348e98405e263f6264b774b3b1f29f69'),
            ('UV/2m/UV2m_00671.sofa', '3cde3cc766d11ee0407523c86ee2f581'),
            ('UV/2m/UV2m_00672.sofa', '92a3bdf4a18c53b0b916c6562a57d9d0'),
            ('UV/2m/UV2m_00673.sofa', '99855b510549998dc033bcbdd0c9a005'),
            ('UV/2m/UV2m_00674.sofa', 'f901848b00aab6d6d0867d85fb434e76'),
            ('UV/2m/UV2m_00675.sofa', '70e8543eb9fb4880caf4cdb2f284e4b8'),
            ('UV/2m/UV2m_00676.sofa', '7ac53c20b58bf6ab706a66df63339cdd'),
            ('UV/2m/UV2m_00677.sofa', 'e3441cce5a784fd91bb70acdb7c0f19e'),
            ('UV/2m/UV2m_00678.sofa', '27230915933e4e9eb11244f1086345fd'),
            ('UV/2m/UV2m_00679.sofa', 'e1af4cac4c0da733d64b5142849d71a8'),
            ('UV/2m/UV2m_00680.sofa', '9eb0641d3072cb0e054c0c7067a3add8'),
            ('UV/2m/UV2m_00681.sofa', '6170bc7bc48791bff2fc55436b1a8d4b'),
            ('UV/2m/UV2m_00682.sofa', '1abae47eb0081e7010ee6cdddb1492a6'),
            ('UV/2m/UV2m_00684.sofa', '94b338a9eb495d0520a867d98b51878f'),
            ('UV/2m/UV2m_00685.sofa', '353251e41f311d0ef7e91d98fc165d96'),
            ('UV/2m/UV2m_00686.sofa', 'b0904f17d07931a03d9d5cac640595e7'),
            ('UV/2m/UV2m_00688.sofa', '78749d4834b69a5392d184f5a0fb4c9f'),
            ('UV/2m/UV2m_00689.sofa', '778c2218459416e90f452a1ea1b4153b'),
            ('UV/2m/UV2m_00690.sofa', '7e26248ef8863b8c7d76597a1c9d057f'),
            ('UV/2m/UV2m_00693.sofa', '94ff0d63e069f85d6e9df5b558ead55f'),
            ('UV/2m/UV2m_00695.sofa', '2bb438d8a5163a84e29777d60ccbeab1'),
            ('UV/2m/UV2m_00696.sofa', '9fea5ee3aa7fe82bdfce3339916b9fae'),
            ('UV/2m/UV2m_00697.sofa', '6825e319fc7a78a13c2a472ae0883fed'),
            ('UV/2m/UV2m_00698.sofa', 'd97f284718528e8ab0fda921dbb0ec9b'),
            ('UV/2m/UV2m_00699.sofa', '8d7251d96f704e5cbf90226ab695241c'),
            ('UV/2m/UV2m_00700.sofa', '2c2f18691be672a0ee728f6d1c947026'),
            ('UV/2m/UV2m_00701.sofa', 'cee3b68aa6420e76fd48a471b0c44aa4'),
            ('UV/2m/UV2m_00702.sofa', 'fd432c69211776e257d7ed784b61ae4e'),
            ('UV/2m/UV2m_00704.sofa', 'a3fedfbcf81c30937a5faa0d51c5b404'),
            ('UV/2m/UV2m_00705.sofa', '9a29578e5b3dc83327011d4a4fe7c262'),
            ('UV/2m/UV2m_00707.sofa', 'e5db28df9dd293697b95f41ed6c47733'),
            ('UV/2m/UV2m_00709.sofa', '1c35835400843cbb2b0bc258e59c2514'),
            ('UV/2m/UV2m_00710.sofa', 'eadb82c9ef6c9455005f81e90b340192'),
            ('UV/2m/UV2m_00711.sofa', 'dc945cc2185fe61fa020015dd499b963'),
            ('UV/2m/UV2m_00712.sofa', '7de475a425c9b68c6b35d0bf0a1f304b'),
            ('UV/2m/UV2m_00713.sofa', '73dececc1d18f8a2c56d93e55ba3cfae'),
            ('UV/2m/UV2m_00714.sofa', '41b00c7246ae125c35f7a6eddb46103a'),
            ('UV/2m/UV2m_00717.sofa', 'd4bb6ad69c4266830972451c9307334e'),
            ('UV/2m/UV2m_00718.sofa', '1c514f9d4e0c5a84b34c1de5fd405113'),
            ('UV/2m/UV2m_00719.sofa', '3616f1d992de87297e6bc3f38e36b26e'),
            ('UV/2m/UV2m_00720.sofa', '28b75c03185dee3a828d128b2edcb675'),
            ('UV/2m/UV2m_00722.sofa', '171b1913f99f63b3784e1afbca1f1006'),
            ('UV/2m/UV2m_00723.sofa', 'cc54de287fbbe7a69a9e498a99ee6dd7'),
            ('UV/2m/UV2m_00724.sofa', '568e2c5de847dd2268ae466727ba6fc8'),
            ('UV/2m/UV2m_00725.sofa', 'ccd4df868338022b053cc7cb207b847a'),
            ('UV/2m/UV2m_00726.sofa', '093a8594e67a7312903f023e64ebd334'),
            ('UV/2m/UV2m_00727.sofa', 'e4480ba6cc245c70706d9c3c3ae6ef76'),
            ('UV/2m/UV2m_00729.sofa', '8d14c8327fb1193f93f331fcff22fef8'),
            ('UV/2m/UV2m_00730.sofa', '5e06074bd60c3d451f750c67b8ae31a4'),
            ('UV/2m/UV2m_00732.sofa', '4946b8657be820ff1cea6e71e5ab9e93'),
            ('UV/2m/UV2m_00734.sofa', '05b3aeb6f03d6d5020b0499655a05d36'),
            ('UV/2m/UV2m_00735.sofa', 'e7779d4c2c958c9bc496cf1411831845'),
            ('UV/2m/UV2m_00736.sofa', '2576d64a9eca7203b70ac0156603ecc2'),
            ('UV/2m/UV2m_00740.sofa', '557db987fdec084993a6e6480fe45e7a'),
            ('UV/2m/UV2m_00742.sofa', '06be18467dbfc9162c4166a366cde22b'),
            ('UV/2m/UV2m_00744.sofa', 'bac47ce8b72bfc0592e816bab61ab49b'),
            ('UV/2m/UV2m_00745.sofa', 'a00a50d9082164dbeb3890a7989032ee'),
            ('UV/2m/UV2m_00746.sofa', '15e27001b4e226050aba9f6c1a8120d4'),
            ('UV/2m/UV2m_00747.sofa', 'f5c48ed52af4e03da4183807cecfd738'),
            ('UV/2m/UV2m_00748.sofa', '19dad1f45b9e468446b4830d2081c959'),
            ('UV/2m/UV2m_00749.sofa', 'b099581a1b467df06dd3779bb5d925f4'),
            ('UV/2m/UV2m_00750.sofa', '60f20af812e8e51b6650c6d496109622'),
            ('UV/2m/UV2m_00751.sofa', '765cf6bc863b678685bde3ddea32aed7'),
            ('UV/2m/UV2m_00753.sofa', '07ca3d6b298abd113d9de732f1a4b99a'),
            ('UV/2m/UV2m_00754.sofa', '4823e62dcd5b57f330fffb6c698d1922'),
            ('UV/2m/UV2m_00755.sofa', 'ba473dba13d6765aeb8621a28216cda1'),
            ('UV/2m/UV2m_00756.sofa', '978bbe8a93e4e46d967dcddd0aa31b4d'),
            ('UV/2m/UV2m_00757.sofa', '900e33726a57d29380724165d91c175f'),
            ('UV/2m/UV2m_00758.sofa', '9db383a996aaaafd25622b09a4819e5b'),
            ('UV/2m/UV2m_00760.sofa', '12a0fc7b230a4d366165dc1b83263d2b'),
            ('UV/2m/UV2m_00761.sofa', '732094d44e654259f52380b0795894af'),
            ('UV/2m/UV2m_00763.sofa', '20b606d03526150b0bb9a568f2df306a'),
            ('UV/2m/UV2m_00764.sofa', 'fa504ad0e96ea33bf677b67331ebaa03'),
            ('UV/2m/UV2m_00766.sofa', '5038940bad69847112c8fcab966722a9'),
            ('UV/2m/UV2m_00767.sofa', '19e55b4552f36b457023e9103d73f1f8'),
            ('UV/2m/UV2m_00768.sofa', '56bb5b1fb1736bad8fe972e48e4ba2ca'),
            ('UV/2m/UV2m_00769.sofa', '39a971bc7287f22cb32f5ea479c4333d'),
            ('UV/2m/UV2m_00770.sofa', '547955699843af9c9b5952c6236eaae6'),
            ('UV/2m/UV2m_00771.sofa', 'b69843dccbec02243325769e3685a52d'),
            ('UV/2m/UV2m_00772.sofa', '086ec787cbdd9c5fd72d4ea51bfb0016'),
            ('UV/2m/UV2m_00773.sofa', '8ac690d2fc3386ff0d41812155cc3a06'),
            ('UV/2m/UV2m_00774.sofa', '07e3b26e426bdc84e4bdd13289c5136c'),
            ('UV/2m/UV2m_00775.sofa', '18463c0ffe3c0776aaa615a47d973d62'),
            ('UV/2m/UV2m_00778.sofa', 'a7324884600dcb7eaf74094fc83a0d22'),
            ('UV/2m/UV2m_00779.sofa', '2ddd5043e13b0afa28798fd1e24c7395'),
            ('UV/2m/UV2m_00780.sofa', 'fcac140720c2d4d757063eead0a42cd2'),
            ('UV/2m/UV2m_00782.sofa', '5302ee8b27ed4094f0e34a9d5e36c36a'),
            ('UV/2m/UV2m_00783.sofa', 'a4d37e75a4a6c9f51bd4d829f3fd3586'),
            ('UV/2m/UV2m_00787.sofa', '6539b991dbac2795d644e2860bc579ad'),
            ('UV/2m/UV2m_00788.sofa', '71ded6a3e97624014b1f1ea0b13d939c'),
            ('UV/2m/UV2m_00789.sofa', '270b0648510702f90fd87fe8d126e8e0'),
            ('UV/2m/UV2m_00791.sofa', 'd8ceab14085a15937144bdbdde1f62f7'),
            ('UV/2m/UV2m_00794.sofa', '550a5406e6499f34af3993ae17ae76ac'),
            ('UV/2m/UV2m_00795.sofa', '3e5227d53a562242d53f72a80434729b'),
            ('UV/2m/UV2m_00797.sofa', 'a1ffa317d8a52c7bf92c0ee4df8fae7b'),
            ('UV/2m/UV2m_00798.sofa', '5eb05820138fe03ed21dfecbe94c4d45'),
            ('UV/2m/UV2m_00799.sofa', 'f706437762c690f09750579d08e6997f'),
            ('UV/2m/UV2m_00800.sofa', '14f9d920f5888134f4b60e54e42e964b'),
            ('UV/2m/UV2m_00801.sofa', '885cd2a241a53b6e8293d2bf4b1f1e04'),
            ('UV/2m/UV2m_00802.sofa', 'd7b6f12ae9975feec11485f2bd512193'),
            ('UV/2m/UV2m_00803.sofa', 'a296755b73938a5d288323e5c1160a80'),
            ('UV/2m/UV2m_00804.sofa', '8b3395efd2aeadaa0e068b9e66aafb06'),
            ('UV/2m/UV2m_00805.sofa', '0c7cdcd3d167e876eaaf44d3663ef53c'),
            ('UV/2m/UV2m_00806.sofa', '00d24dc3c0788dbc8acd64cf8e67aa87'),
            ('UV/2m/UV2m_00807.sofa', '8eca8ea14b65b364b483d0f1b849cd80'),
            ('UV/2m/UV2m_00809.sofa', '3dbdcd1dfe3a4a871761b1ec507cf3ce'),
            ('UV/2m/UV2m_00810.sofa', '5b8d0e660c4d5e43e102ef90d8ae1acc'),
            ('UV/2m/UV2m_00811.sofa', '43ded2a7005a89007685b018da32c5eb'),
            ('UV/2m/UV2m_00812.sofa', '8257f086b30738008903a19940bae004'),
            ('UV/2m/UV2m_00815.sofa', 'f1d1d1c452d09f5f4837fb32bb3d3129'),
            ('UV/2m/UV2m_00816.sofa', '6a545fc442d179ff420ee07a6f097f57'),
            ('UV/2m/UV2m_00817.sofa', 'e81017bbf254c794b261f3688ffb8bff'),
            ('UV/2m/UV2m_00818.sofa', 'd9a1f89523ffc62816053aa19c47d159'),
            ('UV/2m/UV2m_00819.sofa', 'c07307b1de5a9e7da9baedcdba41b4df'),
            ('UV/2m/UV2m_00821.sofa', 'e6ec7bab832e687c600710f5da27cafd'),
            ('UV/2m/UV2m_00822.sofa', '71cdcb580c34a97e8467a34faa2fbe7f'),
            ('UV/2m/UV2m_00823.sofa', 'a59e55230a07acc2b8887ecf4e10eb0b'),
            ('UV/2m/UV2m_00824.sofa', '8cbe1e9ce99f71471477cabe2ed44493'),
            ('UV/2m/UV2m_00825.sofa', '4cad4eed7083618c7596765e9c7fa32c'),
            ('UV/2m/UV2m_00826.sofa', '79d4413409d9fa5e5c35c1a23b21f9f0'),
            ('UV/2m/UV2m_00827.sofa', 'f63a0d5a2ae58775caedbd7478bf19aa'),
            ('UV/2m/UV2m_00829.sofa', 'c925ad1f4fab198eee14843f4f101bd6'),
            ('UV/2m/UV2m_00830.sofa', '5283ab9e89982ab15b9471b37dda7f9f'),
            ('UV/2m/UV2m_00833.sofa', '7c6e507761156f4ab9403d51fa949658'),
            ('UV/2m/UV2m_00835.sofa', '39df515e3998d20285fd3cfafca1c1fb'),
            ('UV/2m/UV2m_00836.sofa', '8133a0ca721d9609947f8f1e8109608d'),
            ('UV/2m/UV2m_00837.sofa', '6b7adec97e03cf69f209d7592857befe'),
            ('UV/2m/UV2m_00838.sofa', 'cab2fa0ec6e840a41d77ebb070eee015'),
            ('UV/2m/UV2m_00839.sofa', 'bdb9a640a2ade28ac71cb16f076ab294'),
            ('UV/2m/UV2m_00840.sofa', '86a38ad66fe76182a1fc49565537ddf2'),
            ('UV/2m/UV2m_00841.sofa', 'd733406329ddaf1d39fa074bc1f6bd3c'),
            ('UV/2m/UV2m_00842.sofa', '6ebfde849d519247dad6e50fe1d3f809'),
            ('UV/2m/UV2m_00843.sofa', '3939bbd3d558836274eb40defafc4c81'),
            ('UV/2m/UV2m_00844.sofa', 'b2ad72cca40ef8eaeb0c0efb27c1c628'),
            ('UV/2m/UV2m_00845.sofa', 'f07a68ce1d1f82c669418d63917eca71'),
            ('UV/2m/UV2m_00846.sofa', 'b998a28b541ba7b3047ead55df0fd7d4'),
            ('UV/2m/UV2m_00850.sofa', 'ba00b73070d4a3c6d829c08842986010'),
            ('UV/2m/UV2m_00852.sofa', '8256e9995158d9cb3d011e10615b7f53'),
            ('UV/2m/UV2m_00853.sofa', 'db3ad3847df96c3b56346be6a7d62a5b'),
            ('UV/2m/UV2m_00855.sofa', 'c980272724e50ac923810fef455abe18'),
            ('UV/2m/UV2m_00857.sofa', '64721067da8fd97b26b08821d5df504b'),
            ('UV/2m/UV2m_00858.sofa', '23d934ffccdb31de91468853acaa8a8b'),
            ('UV/2m/UV2m_00859.sofa', '26b12dd0b46b143152e7992a56ae3000'),
            ('UV/2m/UV2m_00860.sofa', '40cdff890d7868019c4f64bc5cf0352d'),
            ('UV/2m/UV2m_00861.sofa', 'e7aba315cbb422d61044b10082b49853'),
            ('UV/2m/UV2m_00863.sofa', '69c3803ddb903ba527b386b6b5504637'),
            ('UV/2m/UV2m_00864.sofa', 'ff95eabef67a326d79d1be9d967d851e'),
            ('UV/2m/UV2m_00865.sofa', 'd9cbb2ff8e1cc95c011f2c09cebb20bb'),
            ('UV/2m/UV2m_00866.sofa', '411d2d8a148e4b9726705a677a345286'),
            ('UV/2m/UV2m_00867.sofa', 'a5932c9c01364269c10bb03a4a7adf60'),
            ('UV/2m/UV2m_00868.sofa', 'ee8832095636e947b3c2665a0a71be27'),
            ('UV/2m/UV2m_00869.sofa', '081656a6124d6143e9add56419113138'),
            ('UV/2m/UV2m_00870.sofa', 'b9154f8761cc8bdb0f5f7d049a7d2b71'),
            ('UV/2m/UV2m_00872.sofa', '6963da7e966d5ec2b5f94bf40e47ec55'),
            ('UV/2m/UV2m_00875.sofa', '21e244184555a73a0efbf63dd21a0f96'),
            ('UV/2m/UV2m_00877.sofa', 'c852592a832c789842c172c38cdc5991'),
            ('UV/2m/UV2m_00880.sofa', 'b75a0bc5d41b6cbdb0b9f8695c4ac3c5'),
            ('UV/2m/UV2m_00882.sofa', 'c11c4b6bee3da02f5b94fbbd7df615bd'),
            ('UV/2m/UV2m_00883.sofa', 'cbbb87bdd27a6c5f0da5c959eb8ea45d'),
            ('UV/2m/UV2m_00884.sofa', 'ff9ff7ab13a0b3247389b50a7b5f6b0e'),
            ('UV/2m/UV2m_00887.sofa', 'ffe22221042b10fabd78ef1f9e66a847'),
            ('UV/2m/UV2m_00889.sofa', '2dcb895905ee02024a61d3526c0fdfbc'),
            ('UV/2m/UV2m_00890.sofa', '0642330a208bdf07e479cea268a83892'),
            ('UV/2m/UV2m_00891.sofa', '76ad69a16dd57402afb5c50a6a92cff1'),
            ('UV/2m/UV2m_00892.sofa', 'c83e1cfd1069287f3552a12c604c7791'),
            ('UV/2m/UV2m_00893.sofa', 'bd9c14ab603ccf5c165ecec52b6b87aa'),
            ('UV/2m/UV2m_00894.sofa', '04b86d4e7f597cc3096a9ceee815291c'),
            ('UV/2m/UV2m_00895.sofa', '7e27eb8057878d54abf19dd23012cf86'),
            ('UV/2m/UV2m_00896.sofa', 'd80191845ca2fdcb429627e78971ccf2'),
            ('UV/2m/UV2m_00897.sofa', '272f4746c8c72dc390db005189fb1918'),
            ('UV/2m/UV2m_00898.sofa', 'eb334d8aa8dd8650cbf1e0f57dae55d5'),
            ('UV/2m/UV2m_00899.sofa', 'fcd6989042a01a690eb54007c4591204'),
            ('UV/2m/UV2m_00900.sofa', 'f63c477a5f7b8cba30f7579e87cfce66'),
            ('UV/2m/UV2m_00901.sofa', 'ec238a07b6823830dda9a6fe8bcc62cb'),
            ('UV/2m/UV2m_00902.sofa', 'f4b62f0cda85469e67044a51c83384a5'),
            ('UV/2m/UV2m_00903.sofa', '70780d68a2a7d4c31b7ce82966ea8a55'),
            ('UV/2m/UV2m_00904.sofa', '32f34c4d828b8cd718b3cffeec9ea337'),
            ('UV/2m/UV2m_00906.sofa', '98253107df48f890bcd2c48a62b893c5'),
            ('UV/2m/UV2m_00907.sofa', '3f4e9db64deae580b5f017d93b8d5af5'),
            ('UV/2m/UV2m_00908.sofa', 'bd85755305b2385b2ed7df320aba1655'),
            ('UV/2m/UV2m_00910.sofa', '7d481ccc9ee46a3dfbfaabfbe2480295'),
            ('UV/2m/UV2m_00911.sofa', '0a23a3ae4138772ec80d44528edfb540'),
            ('UV/2m/UV2m_00913.sofa', '0f957cdb23fcd396951c01ac292c9e09'),
            ('UV/2m/UV2m_00915.sofa', '270b52181c151b7ccf6d6e17c58bad49'),
            ('UV/2m/UV2m_00918.sofa', '298e74adf4dfc10d126323e15f26dcbe'),
            ('UV/2m/UV2m_00919.sofa', '6334ab3be857bf87d367aab924945fb2'),
            ('UV/2m/UV2m_00920.sofa', 'c4c9c26db8fd9605b709e3137cc690c8'),
            ('UV/2m/UV2m_00921.sofa', 'c17653ae72013f79d1669ee714a59414'),
            ('UV/2m/UV2m_00923.sofa', '4ca1bba266fc51d2d36ebc3761cb0000'),
            ('UV/2m/UV2m_00924.sofa', '9305091bf8851d9abd106a8133267acb'),
            ('UV/2m/UV2m_00925.sofa', '6f3bb34a321841aadd864f963dd91f0e'),
            ('UV/2m/UV2m_00926.sofa', '041cf19614764bb56b59db88d96d1c20'),
            ('UV/2m/UV2m_00927.sofa', '49e06251bb337ac42197013d8a800263'),
            ('UV/2m/UV2m_00929.sofa', '4b532afa4b03ddc118f939b7f1f11628'),
            ('UV/2m/UV2m_00930.sofa', '5503c6ac7734094c46f89e15bf9af401'),
            ('UV/2m/UV2m_00931.sofa', '215ff1c3592cdcf2727324e13fda101c'),
            ('UV/2m/UV2m_00932.sofa', 'd234541b886a4143b74b318cbefe4f8b'),
            ('UV/2m/UV2m_00934.sofa', '4b3ae7d55e51a1e0460304d2cc2d3352'),
            ('UV/2m/UV2m_00936.sofa', 'e22a289f51f18d0fdcba06f8af712a1d'),
            ('UV/2m/UV2m_00937.sofa', '1c675a95982df86a1f5be2714b3332f6'),
            ('UV/2m/UV2m_00939.sofa', '4b2bcdc2a2fbfa138121451eeefe0f0f'),
            ('UV/2m/UV2m_00940.sofa', '39f86a82473ea696eb7afa624bc19754'),
            ('UV/2m/UV2m_00942.sofa', '6049d38b4bc03f6019fdb7b740c9bd55'),
            ('UV/2m/UV2m_00944.sofa', '5dd84a28a9eff47098f9c0f95a22000c'),
            ('UV/2m/UV2m_00946.sofa', 'af6998c20147b51fb5751c9ed5d4a374'),
            ('UV/2m/UV2m_00947.sofa', 'aee40095a03a3525de40eacc14500783'),
            ('UV/2m/UV2m_00951.sofa', 'd1256392dc922f034ef2cbfe8be72d2f'),
            ('UV/2m/UV2m_00952.sofa', '1f8d25f9ecddd175c70a3b072d37d757'),
            ('UV/2m/UV2m_00953.sofa', '88611bd26acd17859ce9649362339852'),
            ('UV/2m/UV2m_00954.sofa', '95edf6bf2f0670672094365600512e23'),
            ('UV/2m/UV2m_00955.sofa', '45301ce84a464781cbce77e2d9130401'),
            ('UV/2m/UV2m_00956.sofa', 'c385b8bfedbad3d3e03d6ba97d0e6827'),
            ('UV/2m/UV2m_00961.sofa', '1cc0eff75b61f137a2e4365101602d86'),
            ('UV/2m/UV2m_00962.sofa', '5f3069c530b5999d90a8476befaa380c'),
            ('UV/2m/UV2m_00963.sofa', '9d9a45400345317264b9f238e1a9d68a'),
            ('UV/2m/UV2m_00965.sofa', '45f0be9b046728edd41de7ce7055085a'),
            ('UV/2m/UV2m_00966.sofa', 'a1482c6a586bfd7d39cd74cbb534a261'),
            ('UV/2m/UV2m_00967.sofa', '1dda3159fbd6f6b0103d7813bba96ea1'),
            ('UV/2m/UV2m_00968.sofa', 'fbb9a3dc538ae24de1a26caf61806a14'),
            ('UV/2m/UV2m_00969.sofa', '036f74dc4a4a6c38c7aec48766f01c9e'),
            ('UV/2m/UV2m_00971.sofa', '78c94c85cc40989325c41952137b606c'),
            ('UV/2m/UV2m_00972.sofa', 'c2ecb1d5e0ac5ad9612a5baa250afeea'),
            ('UV/2m/UV2m_00973.sofa', 'e310b5412b9e9eb5b3445f59895cee38'),
            ('UV/2m/UV2m_00975.sofa', 'c10debd732245023db8409413741c402'),
            ('UV/2m/UV2m_00976.sofa', '5bfa5efd74fe28e2d1a4ecac47c29261'),
            ('UV/2m/UV2m_00977.sofa', '2887989329ed546d58220c1543dc68c6'),
            ('UV/2m/UV2m_00978.sofa', '442c681d4e8df353a2a3e828687c4ee2'),
            ('UV/2m/UV2m_00979.sofa', 'd8238e33080f00041d4bdd34e8d45600'),
            ('UV/2m/UV2m_00980.sofa', '8367be639d795eda53478b80e99cdbd8'),
            ('UV/2m/UV2m_00981.sofa', 'c7c91b1f6f5fea37f91215df9a1469a0'),
            ('UV/2m/UV2m_00982.sofa', 'e1f1453582f624091f2633f6fc30f8e6'),
            ('UV/2m/UV2m_00984.sofa', '1ce6398ce4af2392b5d8abbcbf6168fa'),
            ('UV/2m/UV2m_00985.sofa', '1e4f81b0662059b40cac49c2171990aa'),
            ('UV/2m/UV2m_00986.sofa', '1d03fc461b007954c35cb0d62f01b116'),
            ('UV/2m/UV2m_00987.sofa', '5f2955c09cfc35a862d3612874bf7227'),
            ('UV/2m/UV2m_00991.sofa', '4d3e4dffa761285e9fef66aefc269a93'),
            ('UV/2m/UV2m_00993.sofa', '538af20d27e5ce5995d1f826919eeeb3'),
            ('UV/2m/UV2m_00995.sofa', '8dd351016d0e97aeed97fa904aef3895'),
            ('UV/2m/UV2m_00996.sofa', '378b761dedea81a2d9b060f97f7f722e'),
            ('UV/2m/UV2m_00997.sofa', '4860b27f4bb9bccc1bb326258b95733f'),
            ('UV/2m/UV2m_00998.sofa', 'b60535c7604dcb28849a3de5e01b2ac6'),
            ('UV/2m/UV2m_00999.sofa', '3e2a65b13c89ef765ba4cea866b0a06a'),
            ('UV/2m/UV2m_01000.sofa', '41f79ba5ecb0d6d9839d0ccac182d933'),
            ('UV/2m/UV2m_01002.sofa', 'bac49cb7e598245466d3ea2e9b2b9886'),
            ('UV/2m/UV2m_01003.sofa', '8c235263076f211f80ecb13378843c63'),
            ('UV/2m/UV2m_01004.sofa', 'd13d528c2b82b0396e71b85d5eb13e58'),
            ('UV/2m/UV2m_01005.sofa', '46c137dc8700907e2846f587f59253cc'),
            ('UV/2m/UV2m_01006.sofa', '5ad6aa9dae7192ece3bb9d758724c117'),
            ('UV/2m/UV2m_01008.sofa', '48241a055c18c3143c43f1ad6669de89'),
            ('UV/2m/UV2m_01009.sofa', '308f59bbc7dcc96b2089bfa003fb0b34'),
            ('UV/2m/UV2m_01010.sofa', 'd12f1a2609c8535d788d98f437f1709d'),
            ('UV/2m/UV2m_01011.sofa', '649e4505f4899fb1be47b91841e02e54'),
            ('UV/2m/UV2m_01012.sofa', '161acb131fd916f90f0cac52ee3deda1'),
            ('UV/2m/UV2m_01013.sofa', '3d56ec2bbe9666c095b87f8d52f49be2'),
            ('UV/2m/UV2m_01016.sofa', '95f0fa3f9d54d41a3b11813ec822a9ea'),
            ('UV/2m/UV2m_01017.sofa', '0c2190a58938c29760a564ec53f81228'),
            ('UV/2m/UV2m_01018.sofa', '9855eb74b610006db50042ed544b73dc'),
            ('UV/2m/UV2m_01019.sofa', '6f29e5c38c5c4638ce227c1528d6be92'),
            ('UV/2m/UV2m_01020.sofa', 'dcee8b0e36c738fff88755f2f034d466'),
            ('UV/2m/UV2m_01022.sofa', 'd4feeca12f659b19934e1c66647c71f8'),
            ('UV/2m/UV2m_01024.sofa', 'afdc99c1183b061e241d935355ebc37e'),
            ('UV/2m/UV2m_01027.sofa', 'fb298e0ad4e1d5a860d61d9ce2381e84'),
            ('UV/2m/UV2m_01028.sofa', '59585e3ce5a7758125e6384c829f4e84'),
            ('UV/2m/UV2m_01030.sofa', '6d4d9eb6275a527dd23df7e1848c30cc'),
            ('UV/2m/UV2m_01031.sofa', '12a018945d42a0c9f214169b4689578b'),
            ('UV/2m/UV2m_01032.sofa', '13ecb893898f32bc17f777d64ebc751d'),
            ('UV/2m/UV2m_01033.sofa', 'f360dc5cc2d13bb8c2d484dbdddd9755'),
            ('UV/2m/UV2m_01035.sofa', 'b57a74e48ec010a44c727052226ff5c8'),
            ('UV/2m/UV2m_01036.sofa', '95394d560d7c21a4325edfab89f41eac'),
            ('UV/2m/UV2m_01037.sofa', '35534a14d547b917f826527b898d2bfc'),
            ('UV/2m/UV2m_01038.sofa', '77ef82e6b585d38d5f6e7ca13768e4df'),
            ('UV/2m/UV2m_01039.sofa', '10b816c43122130350cfb01974907ed8'),
            ('UV/2m/UV2m_01040.sofa', '01c9494afaef92bac267247c0d9985f7'),
            ('UV/2m/UV2m_01042.sofa', 'd091be3ff98175e712f46cb23820077c'),
            ('UV/2m/UV2m_01044.sofa', '15b8032b840319acfa9bfc157c2dfe57'),
            ('UV/2m/UV2m_01046.sofa', '3c23b5f18239f74894864d618f41fcfa'),
            ('UV/2m/UV2m_01047.sofa', '156cb61027ef37d1a23bd0449d13effc'),
            ('UV/2m/UV2m_01048.sofa', 'fc557a7eafcf0bc087d93f3a14d5023b'),
            ('UV/2m/UV2m_01049.sofa', 'f9dd12390c35f93a2e65b081f90fe0c7'),
            ('UV/2m/UV2m_01050.sofa', 'f5cd37b01d6799b9a0b331dc2c209d7b'),
            ('UV/2m/UV2m_01052.sofa', 'b198d57e78b6c21989ca41b317ae1142'),
            ('UV/2m/UV2m_01053.sofa', '195ec8d274f5d714222d1729e4915689'),
            ('UV/2m/UV2m_01055.sofa', '37948ad96fc8f19398f012b445284318'),
            ('UV/2m/UV2m_01057.sofa', 'fe8785ede2c5884647a55a6c3503c1fc'),
            ('UV/2m/UV2m_01058.sofa', '69b2c094a95d61181d6a5618bf206ac0'),
            ('UV/2m/UV2m_01060.sofa', '329bb8579dccbb4f58d105a6f347889e'),
            ('UV/2m/UV2m_01061.sofa', 'cbe089ea224f6a3f43d9464559b82af2'),
            ('UV/2m/UV2m_01062.sofa', '43a975d645fd68879afff735484371fe'),
            ('UV/2m/UV2m_01063.sofa', 'd37bad39a98135fa058127fe8459c0bd'),
            ('UV/2m/UV2m_01064.sofa', '7dfd32a1e1c3cf7881f4118f1d4e24cd'),
            ('UV/2m/UV2m_01065.sofa', '8b63421bd76a756b71e0ca07b7024a27'),
            ('UV/2m/UV2m_01066.sofa', 'e64389a2f4b2b21f086f1d3551ee946f'),
            ('UV/2m/UV2m_01067.sofa', '269e3591ecf8dfbc0e0608e31c17e844'),
            ('UV/2m/UV2m_01069.sofa', '312a3d08676b452ab3ff3d36ee741c08'),
            ('UV/2m/UV2m_01071.sofa', '8e5f39368b674d68d29b2f55ecd6e655'),
            ('UV/2m/UV2m_01073.sofa', '4d659de62c26c9180460a9ac44785d45'),
            ('UV/2m/UV2m_01075.sofa', '440eb0ae1dae6fc6810f979ee04b30a1'),
            ('UV/2m/UV2m_01077.sofa', '05d39b29fbcfc9b96d248c81bf9dd475'),
            ('UV/2m/UV2m_01078.sofa', '12bed51021e6d302553abe9dfee7b06c'),
            ('UV/2m/UV2m_01079.sofa', 'fad5a9b150770a6d12f759239b1be5cc'),
            ('UV/2m/UV2m_01080.sofa', 'f9f9c2d4d7ee9ae28cd689462ee8ec2f'),
            ('UV/2m/UV2m_01082.sofa', 'cc55368a456dfa185bac741c724bb54c'),
            ('UV/2m/UV2m_01083.sofa', '38f59909dced2fb21d830db645ad6dc0'),
            ('UV/2m/UV2m_01085.sofa', '324538541d3d4fe70e441a86b0761916'),
            ('UV/2m/UV2m_01086.sofa', '57996775def23a7716426684e92832e7'),
            ('UV/2m/UV2m_01087.sofa', 'c000a9a75661a2f504f6c1f183dd3f62'),
            ('UV/2m/UV2m_01088.sofa', '5599779f0adb1f82d135606a5d57107b'),
            ('UV/2m/UV2m_01089.sofa', '4264c7cc134c9f17a5ae29d65e662c2f'),
            ('UV/2m/UV2m_01091.sofa', '0e3140fe0989a0e34a5d4ac77cc6d84f'),
            ('UV/2m/UV2m_01092.sofa', 'bfa96f9f9ad60d61fb10e52287bb0ff3'),
            ('UV/2m/UV2m_01093.sofa', '28dcd86856bc42539afaa20998385566'),
            ('UV/2m/UV2m_01094.sofa', '1277d770df2ecd56b240c0075ec14568'),
            ('UV/2m/UV2m_01097.sofa', 'c54fb68b0e75cd95badd46efc29d3a6e'),
            ('UV/2m/UV2m_01099.sofa', '87b74c73827e0d24738ac6a79e1b0ec2'),
            ('UV/2m/UV2m_01100.sofa', '20dfc54ec866ab2d75de135d7111073e'),
            ('UV/2m/UV2m_01101.sofa', '60b33573961ce64e54a919b9b68c4b78'),
            ('UV/2m/UV2m_01102.sofa', '6afb7615255ea6f12ff1991f711e4f8f'),
            ('UV/2m/UV2m_01103.sofa', '827558658a766f048a25290c949a3bbb'),
            ('UV/2m/UV2m_01104.sofa', '5bf9f605239cb6bcc8ea4404578ad3e4'),
            ('UV/2m/UV2m_01107.sofa', '3f11750e9daf661c281a41aa9e0410f9'),
            ('UV/2m/UV2m_01108.sofa', 'f70328e29c93d43d1a8c8c58deb29097'),
            ('UV/2m/UV2m_01109.sofa', 'bd5a361f98e3b234d0be98e2033c404d'),
            ('UV/2m/UV2m_01111.sofa', '7598da05e164682a83e5e866e321f53e'),
            ('UV/2m/UV2m_01112.sofa', 'a5ad9b7514ba37a7ffbefc8452aaf223'),
            ('UV/2m/UV2m_01114.sofa', '185052c4e77b94ea6031722e60e03c69'),
            ('UV/2m/UV2m_01115.sofa', 'd748bd7810b04b3b9cc38252492c6372'),
            ('UV/2m/UV2m_01116.sofa', '07130c1788a3036360d4d0ec9df89ba0'),
            ('UV/2m/UV2m_01117.sofa', '26a65500b9e0feaa40b1c805fa9c5521'),
            ('UV/2m/UV2m_01120.sofa', '68c642150f532d1dd3fa08c1aa187784'),
            ('UV/2m/UV2m_01121.sofa', '0d6a19b147f007a5406760ee96879bf8'),
            ('UV/2m/UV2m_01122.sofa', '13fe1eff433bffa21db2adcc3af05ae8'),
            ('UV/2m/UV2m_01125.sofa', '98aa5c4aa1c9246d354ebd38f8f36f79'),
            ('UV/2m/UV2m_01127.sofa', '54859d448db0bc65cdfd88775ec9cec0'),
            ('UV/2m/UV2m_01128.sofa', '06991849ab9bef5107cecaff7db9e2a5'),
            ('UV/2m/UV2m_01129.sofa', '94d745cbbf6efacb11747d7a7b035797'),
            ('UV/2m/UV2m_01130.sofa', 'a257c05f3dc747da69c088f8ec51bc5a'),
            ('UV/2m/UV2m_01131.sofa', 'd9b3a0e24adb8e08a33a70079e3fd223'),
            ('UV/2m/UV2m_01132.sofa', '4e6a683bbd7def8f09afc90d67646ff7'),
            ('UV/2m/UV2m_01134.sofa', '580a0da6c811922d24e0552d5ee89949'),
            ('UV/2m/UV2m_01135.sofa', 'a8c062287ec63410fbe714c784eda235'),
            ('UV/2m/UV2m_01136.sofa', '4a48aae285ea4d962348d46e487875b4'),
            ('UV/2m/UV2m_01137.sofa', '0d35d9d81bdc42f43e48419c43506a25'),
            ('UV/2m/UV2m_01139.sofa', 'd7a272e23f8c539d2c5ea8ec9e13268e'),
            ('UV/2m/UV2m_01140.sofa', '198471911ce74302a183fb73a2c830a5'),
            ('UV/2m/UV2m_01141.sofa', '0fc7aaff012d2847c42b860194d4c8a6'),
            ('UV/2m/UV2m_01142.sofa', 'e3cf107348554114b0ef9f57c82df95a'),
            ('UV/2m/UV2m_01143.sofa', '20cce8c52b90a1261970798bff89450d'),
            ('UV/2m/UV2m_01144.sofa', '5dfec5f0544b32c7251e8721f453cff5'),
            ('UV/2m/UV2m_01145.sofa', 'efcaf2a2088850d3c768a7c837c69f72'),
            ('UV/2m/UV2m_01146.sofa', '5dac9d3a05e4e7d42df72c07bf0bc9cd'),
            ('UV/2m/UV2m_01147.sofa', 'eade1b13b84035c5494d47b3c6f68ad0'),
            ('UV/2m/UV2m_01148.sofa', '97ed7c7c15a7877e62acb47f72ba384a'),
            ('UV/2m/UV2m_01149.sofa', 'fd95ec4daa5cc6b1f7012b62b73d9420'),
            ('UV/2m/UV2m_01150.sofa', '9aac41eb7e8e8b57c1b9439b2410b58a'),
            ('UV/2m/UV2m_01151.sofa', '4647eed1f86fa2a82eeb749101f27406'),
            ('UV/2m/UV2m_01152.sofa', 'b7652bb87ac230d692ff2d82ba85f478'),
            ('UV/2m/UV2m_01155.sofa', '35bd29a8f7cf88e2019830fc97259c44'),
            ('UV/2m/UV2m_01157.sofa', '0f6ba4c0a4fcd1445d2466124079dfea'),
            ('UV/2m/UV2m_01160.sofa', '44c8daca8a7ac2400304793a2d09a73b'),
            ('UV/2m/UV2m_01162.sofa', '4b9ea716c9561b075401068b7fb160f4'),
            ('UV/2m/UV2m_01163.sofa', '3ecbee42718017ca9473dc722c3691cc'),
            ('UV/2m/UV2m_01164.sofa', 'ffd85eeda0924d21b96e9f752e6c5497'),
            ('UV/2m/UV2m_01165.sofa', 'ce7bb9fa3725b14aa1f179a0d5c10f63'),
            ('UV/2m/UV2m_01166.sofa', 'e600e00707c841fcdfdc41ad563ab549'),
            ('UV/2m/UV2m_01168.sofa', '656ab8c11f1e7b1571aeaa45e7ebfd76'),
            ('UV/2m/UV2m_01171.sofa', 'f181cde9b4c9ebdbc446c64721ecd329'),
            ('UV/2m/UV2m_01172.sofa', 'd7b93ea11bb043ed5fce88e182b19bc3'),
            ('UV/2m/UV2m_01173.sofa', '6d8be9f386de90183bed3b43ed975467'),
            ('UV/2m/UV2m_01174.sofa', '1ecc6e410ec49a3c89b9490ba007470a'),
            ('UV/2m/UV2m_01175.sofa', '96f54f25e6ed6cd0955255be7d03c773'),
            ('UV/2m/UV2m_01176.sofa', '783d6760cff20175f0bbe35a82641e5b'),
            ('UV/2m/UV2m_01177.sofa', 'a7b2cae4b11c88c4b98dc7ef5d859dc5'),
            ('UV/2m/UV2m_01179.sofa', '2a98b731229482ad68dfb9ee2bdc372e'),
            ('UV/2m/UV2m_01181.sofa', '5bc77e68c808f44ca5dfbf38abeaf9e8'),
            ('UV/2m/UV2m_01185.sofa', 'c2af9a3d8d4a65de79c8dc48dd021a38'),
            ('UV/2m/UV2m_01186.sofa', 'f156808d7b68ee2114549353ddadda96'),
            ('UV/2m/UV2m_01189.sofa', 'f03007d941f938fab2039428e7482146'),
            ('UV/2m/UV2m_01190.sofa', 'e6a0945c9b4fb2a5896e3580c84ef7e9'),
            ('UV/2m/UV2m_01191.sofa', '09b35a17969b0367f763da3dc5b0fa21'),
            ('UV/2m/UV2m_01192.sofa', '68808c7fae5d52d7493977744f7deb6a'),
            ('UV/2m/UV2m_01193.sofa', 'e66102e299083f5666dd42d65c863ac1'),
            ('UV/2m/UV2m_01194.sofa', '14ac575de19b3c9abd542831b3d1810b'),
            ('UV/2m/UV2m_01195.sofa', '391242f6d90aa8bffbf5bbcf8ebeec1a'),
            ('UV/2m/UV2m_01196.sofa', '229d74f894f109b72814692d658392ea'),
            ('UV/2m/UV2m_01197.sofa', '1097908beb4b81f4ced0bb5e380cff61'),
            ('UV/2m/UV2m_01200.sofa', '8d094441f4fd87376db52eca65b09490'),
            ('UV/2m/UV2m_01201.sofa', 'c157e09e739c8f850ab51eacb553835b'),
            ('UV/2m/UV2m_01202.sofa', '9165c5138a8e226f36bd27a05a62de67'),
            ('UV/2m/UV2m_01203.sofa', 'a61bc161bcdb32b6f2a8a42db21df3fd'),
            ('UV/2m/UV2m_01205.sofa', '481c81c1e3dc5d68bcbacdb505b90c20'),
            ('UV/2m/UV2m_01206.sofa', '7938f9bbcb140882494b74660805bee4'),
            ('UV/2m/UV2m_01207.sofa', '3c3cc42314ee6d0d9680ce785932ba31'),
            ('UV/2m/UV2m_01208.sofa', '71a0c21d2f95a723b45a7d24092580a4'),
            ('UV/2m/UV2m_01209.sofa', 'f269e84fc1833a419488081baa4c829f'),
            ('UV/2m/UV2m_01210.sofa', '3a6420073f65d00913c41002822b3be0'),
            ('UV/2m/UV2m_01211.sofa', '246277b07a6bc549400d7458cec22996'),
            ('UV/2m/UV2m_01212.sofa', '0e051607f42c07557849138ac8075ed9'),
            ('UV/2m/UV2m_01213.sofa', 'f313c593eb4fbcb97c444818d83f18d3'),
            ('UV/2m/UV2m_01215.sofa', '9456897533ef8d60d22fb910a1702231'),
            ('UV/2m/UV2m_01216.sofa', '4ac7ee0e5a092d767c6ae90e03c4c7fb'),
            ('UV/2m/UV2m_01217.sofa', '6bc5c67cabc6bd0afb6a98a49fbc2534'),
            ('UV/2m/UV2m_01219.sofa', 'd2174ea544194a55fc32444948a0dd03'),
            ('UV/2m/UV2m_01221.sofa', 'd3ab65af9d57a33daf7a05978ff15f89'),
            ('UV/2m/UV2m_01222.sofa', '87950e1d4e466fdffde1b8a2ff88f626'),
            ('UV/2m/UV2m_01223.sofa', '5d8b14425322de83f388bedd777748af'),
            ('UV/2m/UV2m_01224.sofa', '1c3314287e4eed5217b2b819b622f354'),
            ('UV/2m/UV2m_01225.sofa', '07999e7107989b56cd65c2587d71b65d'),
            ('UV/2m/UV2m_01228.sofa', '2b5539c0d835c91c97c94ccbb7a50bdf'),
            ('UV/2m/UV2m_01230.sofa', 'd1f1a56c52453ec35f50fd05b304a620'),
            ('UV/2m/UV2m_01231.sofa', 'ab6794e273ab7a156eee0a15bc7aa4e4'),
            ('UV/2m/UV2m_01232.sofa', '6bc7f054d3e2ff8a99cb45f1ae2eebdc'),
            ('UV/2m/UV2m_01233.sofa', 'e575c637aa128b820f89a76099de9dcc'),
            ('UV/2m/UV2m_01234.sofa', 'e4b4c4bea4f7fb704475c57b8bbd3f22'),
            ('UV/2m/UV2m_01235.sofa', 'eb7bb4e53c3ee7e127c2caabc6574ea7'),
            ('UV/2m/UV2m_01237.sofa', '3c4bdc6f6e838b9e212477748ad569d8'),
            ('UV/2m/UV2m_01238.sofa', '1fa2d14aac012b6a3761fc7d5e8328af'),
            ('UV/2m/UV2m_01239.sofa', 'b45e11b6072b46d6c246b469ff68548c'),
            ('UV/2m/UV2m_01240.sofa', '0fec746b06d6d2a7aa0b03fabef59970'),
            ('UV/2m/UV2m_01242.sofa', '3ae40a833e0ad8b55d7c346aceaed692'),
            ('UV/2m/UV2m_01244.sofa', '6c45b9743a35b7345c5d2616faaa9e76'),
            ('UV/2m/UV2m_01245.sofa', '408762ebec514d567df6efe8fff39c4e'),
            ('UV/2m/UV2m_01248.sofa', '82f9eb09543e0522b65a6684161e602f'),
            ('UV/2m/UV2m_01251.sofa', 'b317334c7ac400ae85c4e11f5bfe46aa'),
            ('UV/2m/UV2m_01252.sofa', '4c54c76c000f03d3878b5f9c5fad3047'),
            ('UV/2m/UV2m_01254.sofa', '2063ed07e78ef3a2eec0378b82367d90'),
            ('UV/2m/UV2m_01256.sofa', 'b7927bf58dde8d741c94ef3a351c4103'),
            ('UV/2m/UV2m_01258.sofa', 'f7abf09e786a090f3bee27c3c3a6a85e'),
            ('UV/2m/UV2m_01259.sofa', '32e978dd5af33881f08058cc69437ec5'),
            ('UV/2m/UV2m_01262.sofa', '49037f48a18609bcc3b0a31490c7609f'),
            ('UV/2m/UV2m_01263.sofa', 'e045df1d215f2f734c22992b9e599b59'),
            ('UV/2m/UV2m_01264.sofa', 'ea36c7a9c079e7f731b0151af6784e84'),
            ('UV/2m/UV2m_01265.sofa', 'f22ee5ce33eb749fc7ac41bad93ecce4'),
            ('UV/2m/UV2m_01266.sofa', '4ad574642f9cdfd0c248f43d8e721c07'),
            ('UV/2m/UV2m_01268.sofa', 'ae8ae20b66262e75570fed7a483486b4'),
            ('UV/2m/UV2m_01270.sofa', '9b67a81983397136b3d3a74295e0f091'),
            ('UV/2m/UV2m_01271.sofa', 'fc95488d0095927cf70b2ec5ed95fd56'),
            ('UV/2m/UV2m_01272.sofa', '3e29b9d0f60c00cb69f8c7491c158f5e'),
            ('UV/2m/UV2m_01273.sofa', 'b93036d6c5526862771fdb881f433474'),
            ('UV/2m/UV2m_01274.sofa', '25814cf450a05e3369247ed3405fe502'),
            ('UV/2m/UV2m_01275.sofa', 'bf540bfd5989c40770fca87411632907'),
            ('UV/2m/UV2m_01276.sofa', '231c241300156cd915f922f6c1eb69d0'),
            ('UV/2m/UV2m_01277.sofa', 'f8fabd7b7e722e9cdcc050c0bd75bc04'),
            ('UV/2m/UV2m_01278.sofa', '51ed4d30c379ce1c885729071947ba82'),
            ('UV/2m/UV2m_01279.sofa', 'f69326309c75bee1724aa1348da72a51'),
            ('UV/2m/UV2m_01280.sofa', '5e8ba8b706dd63480cfd595ef1491ac1'),
            ('UV/2m/UV2m_01282.sofa', '92fe7afd3c04d6bd1feafc56a2110550'),
            ('UV/2m/UV2m_01284.sofa', 'ff84a10a0275c051707fe296fe5e5927'),
            ('UV/2m/UV2m_01286.sofa', '32c081ba72209d7abe74baf741e1cac3'),
            ('UV/2m/UV2m_01288.sofa', 'a1bacf6e38db4b200beb344adcabe71e'),
            ('UV/2m/UV2m_01290.sofa', '3ce80cfcfc58542ac67d1fc50021d640'),
            ('UV/2m/UV2m_01291.sofa', '98ab2b7e69b427b2e775e8ba4312d85f'),
            ('UV/2m/UV2m_01292.sofa', '21cce6c75642e3757c6347aa736a8496'),
            ('UV/2m/UV2m_01293.sofa', '6e32400b0429357aace93a95ea878d60'),
            ('UV/2m/UV2m_01294.sofa', '9b45089a90d1bd92f41cacc7839eeb7c'),
            ('UV/2m/UV2m_01295.sofa', 'aaed7e711eaa3ee9e98db0d70097bfd0'),
            ('UV/2m/UV2m_01296.sofa', 'a79b6b065e8c850160c7cc4c02dbcbbc'),
            ('UV/2m/UV2m_01298.sofa', 'a39f5facd9120f21e39597b1047e0042'),
            ('UV/2m/UV2m_01299.sofa', 'a537d937a40f04a7e0cd17bf8e850db9'),
            ('UV/2m/UV2m_01301.sofa', '5a3f2431df518c1ba4dbe2cc46076275'),
            ('UV/2m/UV2m_01302.sofa', '4473969493c70aa0a293af9578ecc391'),
            ('UV/2m/UV2m_01303.sofa', 'eeac7f1bd18b3fddc19c90b339db6813'),
            ('UV/2m/UV2m_01304.sofa', 'caaa6c8c4ea599868fdbb154ceed20c7'),
            ('UV/2m/UV2m_01305.sofa', '55f8c5a00eac61127d6594003b8ff9a2'),
            ('UV/2m/UV2m_01308.sofa', '7688a00678f00cd4eee668b4287c76f9'),
            ('UV/2m/UV2m_01309.sofa', '3549065e1360bdd6b9cc08510b5d1b27'),
            ('UV/2m/UV2m_01310.sofa', 'cf91f28a7faf2bc4db703574c0380bdc'),
            ('UV/2m/UV2m_01311.sofa', 'aac26d2c0e89ca762a9fae022015acca'),
            ('UV/2m/UV2m_01312.sofa', '2b2fb2543764e8f9911cb25a76308411'),
            ('UV/2m/UV2m_01313.sofa', '07f8370bdc7c57b0e8dc49ae8f0b194d'),
            ('UV/2m/UV2m_01315.sofa', 'a10a256ed7fd8e771dfdee7bf8892325'),
            ('UV/2m/UV2m_01317.sofa', 'e87c39cce07b229249ddfe4df3d50dcc'),
            ('UV/2m/UV2m_01318.sofa', '885f2cf971ba8877b67845f12e9cbe57'),
            ('UV/2m/UV2m_01319.sofa', 'f4ae72eb86f7d0a12fbc218155a4d25d'),
            ('UV/2m/UV2m_01320.sofa', '0a6239a816b277271c91100134a39ea4'),
            ('UV/2m/UV2m_01321.sofa', '0b37ce3a56e9f71118537cf779a87c42'),
            ('UV/2m/UV2m_01324.sofa', '204573b9a29edfbda1bf733884c8c1ad'),
            ('UV/2m/UV2m_01326.sofa', '96893a8b12d5aa5d9739f6ecbc9de765'),
            ('UV/2m/UV2m_01327.sofa', 'f7f5380abf106d3f0327326caa575f6f'),
            ('UV/2m/UV2m_01328.sofa', '126bcf922d8508ee7080711781abe928'),
            ('UV/2m/UV2m_01329.sofa', 'ab9a331be544c20b7149b58cd7bb1e71'),
            ('UV/2m/UV2m_01330.sofa', '62d809b3efcf87220ad1713f938a53e0'),
            ('UV/2m/UV2m_01331.sofa', 'bbcaa41e23ad3f70c7a361a5e3aefe3b'),
            ('UV/2m/UV2m_01333.sofa', 'd029a6e08ded34de746192515b753b2c'),
            ('UV/2m/UV2m_01334.sofa', '416eb48e4bfc246ecb0cec20d4c6fb98'),
            ('UV/2m/UV2m_01335.sofa', 'dc611e6257488e6d6029f094f7f47b6e'),
            ('UV/2m/UV2m_01337.sofa', '9d7de568d5a5f33045979558c8fa593d'),
            ('UV/2m/UV2m_01338.sofa', '1ccbbf17f60c7098a0dc5bc0b2dd1ec8'),
            ('UV/2m/UV2m_01342.sofa', 'a40878ed8d29b1f15045c7b59ce7e5d9'),
            ('UV/2m/UV2m_01344.sofa', '964818b553ed0635ee6d43b3c5a5f27b'),
            ('UV/2m/UV2m_01345.sofa', 'bbca560747a30b76781048b83731d227'),
            ('UV/2m/UV2m_01346.sofa', '99bcbd4e2a65c5667e8f9945ce2a1d75'),
            ('UV/2m/UV2m_01347.sofa', 'a581edc4314f41ebe2e0a2c0f15e012f'),
            ('UV/2m/UV2m_01349.sofa', '4f6bac90a9dea9551028a1d4786d4b38'),
            ('UV/2m/UV2m_01350.sofa', 'a67d84b3ba5191eebe190d24129b0a26'),
            ('UV/2m/UV2m_01351.sofa', 'b4b08cab2cadf8d2ba8783e2c53d76e4'),
            ('UV/2m/UV2m_01352.sofa', '37880c568c60210e1aea3b08e84c6739'),
            ('UV/2m/UV2m_01355.sofa', 'e7ad1788a6e27759fd653eef7253b99c'),
            ('UV/2m/UV2m_01356.sofa', 'd79bf4e45ec1f9ecbe56e883283561bc'),
            ('UV/2m/UV2m_01357.sofa', '746d8aaf0380eb0bea88dbbb82230c0f'),
            ('UV/2m/UV2m_01359.sofa', 'fa7e33f12092cd591af1fb5612b374c4'),
            ('UV/2m/UV2m_01360.sofa', '7031593443c8ec87386f89fae9df2ab1'),
            ('UV/2m/UV2m_01362.sofa', '7eee97d836ce4c93007f49d249a76472'),
            ('UV/2m/UV2m_01363.sofa', '227a965be8c4ea021d5fd31b9a310c1d'),
            ('UV/2m/UV2m_01364.sofa', '887c4cf18e385fdd42857dd40056e8f7'),
            ('UV/2m/UV2m_01365.sofa', '6969be9077e68dc7acb7d10b929c1af8'),
            ('UV/2m/UV2m_01366.sofa', 'ce1b51e18220f96f50602dc3e102ab06'),
            ('UV/2m/UV2m_01367.sofa', '98b03eba07ff85c9a10c43e4a1b2db69'),
            ('UV/2m/UV2m_01370.sofa', 'c345b05934e93ffe3463285d1de7a985'),
            ('UV/2m/UV2m_01371.sofa', '37377bf5563507d12348349495c25085'),
            ('UV/2m/UV2m_01372.sofa', '586f79c0922945ce6779fbbb1d103587'),
            ('UV/2m/UV2m_01373.sofa', '7774770b423f7f924e43d037dfccaf43'),
            ('UV/2m/UV2m_01374.sofa', '5127bb6b1a71d83bc5aa436ea21c15b4'),
            ('UV/2m/UV2m_01375.sofa', 'cf79c6093c5ff9049496322b0e5ccb85'),
            ('UV/2m/UV2m_01376.sofa', '138d3473ec37ba081152827a7683a064'),
        ],
        'ICO-1m': [
            ('ICO/1m/ICO1m_00001.sofa', '14981bde964ab02c1fb72e10f8cc8b21'),
            ('ICO/1m/ICO1m_00002.sofa', '90178fed40b8e963c8bad91f7a8a6477'),
            ('ICO/1m/ICO1m_00003.sofa', '73ea46fd56a05502898a6641285b844e'),
            ('ICO/1m/ICO1m_00004.sofa', '3e6aa5379547a0f319df7d99e1412529'),
            ('ICO/1m/ICO1m_00005.sofa', '44eb421c7ea5a1d48efe4952be3e5f46'),
            ('ICO/1m/ICO1m_00007.sofa', '2ff4a551f9a5b6260fce4c2e936cb6b5'),
            ('ICO/1m/ICO1m_00009.sofa', '15f189168466d1011d15c409615ea8c1'),
            ('ICO/1m/ICO1m_00010.sofa', 'fe9611a040d7d31c81b1dba40d014197'),
            ('ICO/1m/ICO1m_00011.sofa', 'b829f6331454b314a81de289cd1d51ce'),
            ('ICO/1m/ICO1m_00013.sofa', '897761e56b0523814a204e93f2485adc'),
            ('ICO/1m/ICO1m_00014.sofa', '63102f0ba2e60a15ee214db961a9bf85'),
            ('ICO/1m/ICO1m_00015.sofa', '28df33549184b9869685a7d41f489fd0'),
            ('ICO/1m/ICO1m_00016.sofa', '68a362aff03447b90381c53c08ca2759'),
            ('ICO/1m/ICO1m_00020.sofa', 'e65249cf76c9aba66a999aab418017c1'),
            ('ICO/1m/ICO1m_00021.sofa', 'd4adfeb2c991fa95ef2a4cb33596a5d1'),
            ('ICO/1m/ICO1m_00022.sofa', 'e2f97a55664e4228026592cc72862fe3'),
            ('ICO/1m/ICO1m_00023.sofa', 'dcc9f94f3116fdc69598d474bc4b0776'),
            ('ICO/1m/ICO1m_00024.sofa', '82ae3345d3587f75554bbafc15b02e1f'),
            ('ICO/1m/ICO1m_00025.sofa', '27b6c8083461f09996cbd21c73ab7fd7'),
            ('ICO/1m/ICO1m_00026.sofa', '12a2647ef171150f6f8eb248d73c5af2'),
            ('ICO/1m/ICO1m_00027.sofa', 'e384193c2a86d87559329205b6530bbf'),
            ('ICO/1m/ICO1m_00029.sofa', '08d00a839558ec199c0ee471bec563a5'),
            ('ICO/1m/ICO1m_00030.sofa', 'e61e925c71378807a6500d0ec86eef99'),
            ('ICO/1m/ICO1m_00031.sofa', '56b468b358a30659d01be6cd7b045917'),
            ('ICO/1m/ICO1m_00032.sofa', '873bc214a7a995ef4968eb812f37a6ce'),
            ('ICO/1m/ICO1m_00033.sofa', 'a11cf400cd507fc8b6e17253d03631af'),
            ('ICO/1m/ICO1m_00036.sofa', '5f9f2d5c4d55ad8eaca595ca1564c02e'),
            ('ICO/1m/ICO1m_00038.sofa', 'bd55f43e7b1f33f4cb1be3537a6a4018'),
            ('ICO/1m/ICO1m_00039.sofa', 'dd8cd30b70e39f4113793ac18560cc10'),
            ('ICO/1m/ICO1m_00042.sofa', '286838b79b49e9cc7862904f1c1c26c1'),
            ('ICO/1m/ICO1m_00043.sofa', 'ec43d1ec22697c7aadc07a944df31e35'),
            ('ICO/1m/ICO1m_00044.sofa', '28c9793f1750abfc40a1dac984066d83'),
            ('ICO/1m/ICO1m_00045.sofa', '4c3da07755aeb0d51edfcef3bacac3b7'),
            ('ICO/1m/ICO1m_00048.sofa', '8eacb564a443673f3c506ec8da8ac9ad'),
            ('ICO/1m/ICO1m_00049.sofa', 'b08fd3efd8f809d7865dd86c20ea227c'),
            ('ICO/1m/ICO1m_00054.sofa', '227943217fa4155eb6f06018139064a2'),
            ('ICO/1m/ICO1m_00056.sofa', 'c5b9e85ab5692ce6347f0701bbf137ae'),
            ('ICO/1m/ICO1m_00057.sofa', '4e90ff308ea1bcead5f30e828ef8f9bf'),
            ('ICO/1m/ICO1m_00058.sofa', '5c5aafdb059f453db14d05508ce04ddf'),
            ('ICO/1m/ICO1m_00059.sofa', '825961de92f3422786a52d0cd1d8f33a'),
            ('ICO/1m/ICO1m_00061.sofa', '2aa672b44d7c0527068e99c16108ce56'),
            ('ICO/1m/ICO1m_00062.sofa', '463ebbe3ba0182ee87440b8f6aeadcdc'),
            ('ICO/1m/ICO1m_00063.sofa', 'a37e672b577a84890ba07f9fc665a843'),
            ('ICO/1m/ICO1m_00064.sofa', '0bd1c7137f41f0b3feb2b488af12dbf0'),
            ('ICO/1m/ICO1m_00065.sofa', 'e42aa9f9d370135b5705cecf3d2e9d98'),
            ('ICO/1m/ICO1m_00068.sofa', '39262dfb77779dcf34d838417c454bd4'),
            ('ICO/1m/ICO1m_00069.sofa', '6b3def5533122ca9ec2931995baddd18'),
            ('ICO/1m/ICO1m_00071.sofa', 'fd11102309ff74dbe846dc1b95e675c7'),
            ('ICO/1m/ICO1m_00072.sofa', 'a445d17bc9d1b22cf00df7bd26e22f3b'),
            ('ICO/1m/ICO1m_00074.sofa', '99833d93fd08e1e0a59ee9dd27ffda9f'),
            ('ICO/1m/ICO1m_00076.sofa', '7a2d353e595adfca8046ae550806b156'),
            ('ICO/1m/ICO1m_00078.sofa', '99dd5e5b498ff116d6009f02d39708d5'),
            ('ICO/1m/ICO1m_00079.sofa', 'dd61ddb8bfe399fba15f95658a9430d1'),
            ('ICO/1m/ICO1m_00082.sofa', '77fe028c475c272d30ea6bdad2a93d77'),
            ('ICO/1m/ICO1m_00083.sofa', '618b484dc4a87698abd7cbeb20f116b3'),
            ('ICO/1m/ICO1m_00085.sofa', 'd987a2308ec97f1944f0ab9dabb055f4'),
            ('ICO/1m/ICO1m_00086.sofa', '2769184f2a7f2c568a1916f027c15a48'),
            ('ICO/1m/ICO1m_00087.sofa', 'c53675cc86b3d020bfd52d55eed56f0d'),
            ('ICO/1m/ICO1m_00089.sofa', 'e1447d17f9928d7ab789524700b317e9'),
            ('ICO/1m/ICO1m_00090.sofa', '2069bc0732ec75e8b5f76e63a6294f4b'),
            ('ICO/1m/ICO1m_00092.sofa', '4559ed8729487ce0c90d20ed61df4a06'),
            ('ICO/1m/ICO1m_00095.sofa', '820a9eee43e195af2f48beb9e60993b3'),
            ('ICO/1m/ICO1m_00097.sofa', 'a52b232923eef020d1f71d7771dc29f5'),
            ('ICO/1m/ICO1m_00099.sofa', 'cd19d5ea6ce8925da66845c9d60975f9'),
            ('ICO/1m/ICO1m_00100.sofa', 'd4170e377c08eaf78473b0d030b1edf1'),
            ('ICO/1m/ICO1m_00101.sofa', '52818a4b95843f993a97da41ed089034'),
            ('ICO/1m/ICO1m_00103.sofa', 'e2177955b60d42d53bc4e7110ef8f81f'),
            ('ICO/1m/ICO1m_00104.sofa', '1893960af0c4a6d587f9ddba2a6dd90f'),
            ('ICO/1m/ICO1m_00107.sofa', '9c014dbb0683da99d0790ee8dd1a17d4'),
            ('ICO/1m/ICO1m_00108.sofa', '1bea11c1da37d9f3eec1f18277fb3adf'),
            ('ICO/1m/ICO1m_00109.sofa', '36e71dce36cc612142c530459484c4f7'),
            ('ICO/1m/ICO1m_00110.sofa', 'a1bb860cd29ecb2d2bfa9378526810c4'),
            ('ICO/1m/ICO1m_00111.sofa', 'df8e177f19e5984be602a19aa3b9a08e'),
            ('ICO/1m/ICO1m_00112.sofa', 'b47da805b382df1fa171b9cd18b8ebb2'),
            ('ICO/1m/ICO1m_00113.sofa', '594013c7f05499881c6c7fa8b2585b28'),
            ('ICO/1m/ICO1m_00114.sofa', '3fee9f3aa6ba54c4f21696417f6d9584'),
            ('ICO/1m/ICO1m_00118.sofa', '8ee78cd677d3606c31f310d53869e003'),
            ('ICO/1m/ICO1m_00119.sofa', 'e0608ec8ac22a16fbfd3b0f34fff8f59'),
            ('ICO/1m/ICO1m_00120.sofa', '5add968747e783480e6b0c3f2da59a78'),
            ('ICO/1m/ICO1m_00121.sofa', '9339790158d7a52826404485df80d28a'),
            ('ICO/1m/ICO1m_00125.sofa', '38cbc22167ecebd5d0665466700a9cac'),
            ('ICO/1m/ICO1m_00126.sofa', 'd047ecde59427b4bedb27343271892c9'),
            ('ICO/1m/ICO1m_00127.sofa', '4318c2401766740cf0acf69f6c0e0b57'),
            ('ICO/1m/ICO1m_00128.sofa', 'b8375f87a5cd7ebd2058711ac5139eab'),
            ('ICO/1m/ICO1m_00130.sofa', '63404666d4a5f53fdc090d927afc3477'),
            ('ICO/1m/ICO1m_00131.sofa', '9ef0f931c970984cde5ef76e595d0d14'),
            ('ICO/1m/ICO1m_00132.sofa', '468e75996397a3687389bc89ab317b53'),
            ('ICO/1m/ICO1m_00133.sofa', '6f9d44976472aa48408cb9b011a21762'),
            ('ICO/1m/ICO1m_00136.sofa', '8f5e80fb6f9d61cd00fd2d355ff1c7e0'),
            ('ICO/1m/ICO1m_00137.sofa', 'f6f63ffa4b8b6950d79342e3da99d1da'),
            ('ICO/1m/ICO1m_00139.sofa', 'f055cf3a2b3b7a5b1e4f8a57eaf603fe'),
            ('ICO/1m/ICO1m_00140.sofa', 'a7de2132a1aa2e3690343008ad2b1499'),
            ('ICO/1m/ICO1m_00142.sofa', 'f4546a5e774bb15813ef45ea2472a045'),
            ('ICO/1m/ICO1m_00145.sofa', '021be38893d4a3213354a86ca0ea2982'),
            ('ICO/1m/ICO1m_00146.sofa', 'f15aaf1cccd156df21a000e8f600d3c8'),
            ('ICO/1m/ICO1m_00147.sofa', '0bc73a458f8aae0881c5a349254b913f'),
            ('ICO/1m/ICO1m_00148.sofa', '5e5f1b5b76cf679812e4689a82698f34'),
            ('ICO/1m/ICO1m_00149.sofa', 'ae82a5633af90977a4f491a01cd8a6b5'),
            ('ICO/1m/ICO1m_00150.sofa', 'bba92b84b48418ce9c722f07b05a2113'),
            ('ICO/1m/ICO1m_00152.sofa', '34ca6f6ba245b49e8cfc5b1f14eb99a1'),
            ('ICO/1m/ICO1m_00153.sofa', 'd3eabcf9957099dd4d525ae2f4cbe3bc'),
            ('ICO/1m/ICO1m_00154.sofa', 'b96b9c6268395923181741cb3b0443fc'),
            ('ICO/1m/ICO1m_00155.sofa', '19832d4ec415e5f89bd5189beae1ae8e'),
            ('ICO/1m/ICO1m_00156.sofa', 'f2a88f7e77f25fcdcb0eab8bfee2dbee'),
            ('ICO/1m/ICO1m_00157.sofa', '71dd33ad9c2780174dfc7d0d15c51619'),
            ('ICO/1m/ICO1m_00158.sofa', '5d3616235fe116396799ab2d1ce26df8'),
            ('ICO/1m/ICO1m_00159.sofa', '2603018a14999225fc7157743526ce6d'),
            ('ICO/1m/ICO1m_00161.sofa', '0dfb8cf0e18127f51dcff33f3532a186'),
            ('ICO/1m/ICO1m_00164.sofa', '082bc4d77724f1e145128f3beeca825d'),
            ('ICO/1m/ICO1m_00165.sofa', '6eab32438f8abacbbf6841425168054b'),
            ('ICO/1m/ICO1m_00166.sofa', '48348007bb1404ff4fe489530d416546'),
            ('ICO/1m/ICO1m_00168.sofa', '85b42b1b035d4e59d9ab92d0d7bedd40'),
            ('ICO/1m/ICO1m_00169.sofa', 'ba91c0d0db34d8b6474200b66cb414d9'),
            ('ICO/1m/ICO1m_00170.sofa', '97347a707fcb1cbaed9339a25c0bd647'),
            ('ICO/1m/ICO1m_00171.sofa', 'e0129c83f337697aecb8abd6dfbc38e6'),
            ('ICO/1m/ICO1m_00173.sofa', '0a786134f3331a3e8b702f31f983c035'),
            ('ICO/1m/ICO1m_00175.sofa', '719a7242ea03bba88c088807235457a5'),
            ('ICO/1m/ICO1m_00176.sofa', '1687f383f9011fdbb45b7f5995eaa861'),
            ('ICO/1m/ICO1m_00177.sofa', '7850220cde4492bf12ce33164d382fd3'),
            ('ICO/1m/ICO1m_00178.sofa', 'da7a6ebafb8e0c45a9940066a482862b'),
            ('ICO/1m/ICO1m_00179.sofa', '534696dd468d77d7e11295c3eeee0ebc'),
            ('ICO/1m/ICO1m_00183.sofa', '24896250ed5061c6d0fdcb18ee14502c'),
            ('ICO/1m/ICO1m_00184.sofa', 'bea6ec754bcc21fe7e71004072973968'),
            ('ICO/1m/ICO1m_00185.sofa', '63cb3a5ddc0a8fb9c37636f2bc529a68'),
            ('ICO/1m/ICO1m_00186.sofa', '5ac0bde4066db379bfa5a6bc8ac3f750'),
            ('ICO/1m/ICO1m_00188.sofa', 'c7efbc752c2cb7781e77972ea0f0e876'),
            ('ICO/1m/ICO1m_00189.sofa', '6d8d7a61f2ca764040d6bdc9b504b153'),
            ('ICO/1m/ICO1m_00190.sofa', '2fc6082aeaa8c12aa0b75ea2a67fad8b'),
            ('ICO/1m/ICO1m_00191.sofa', 'afb1b11e4fe5395ec089e9b12e503209'),
            ('ICO/1m/ICO1m_00194.sofa', 'be10e3975c5455d1ff70cb4e8b0f4e04'),
            ('ICO/1m/ICO1m_00195.sofa', '783947d0c9f8ab720748a5853a7d6763'),
            ('ICO/1m/ICO1m_00196.sofa', '682d8e923ef9ec77f11bbaae51886864'),
            ('ICO/1m/ICO1m_00197.sofa', 'b813642a1d49dfe9da304daccbdfa4a3'),
            ('ICO/1m/ICO1m_00198.sofa', '633f13564c62b1e02958d8eb51f5edba'),
            ('ICO/1m/ICO1m_00201.sofa', '70ee2ee04ebbdbd54c573beb15bce5d7'),
            ('ICO/1m/ICO1m_00203.sofa', '09257cfd9fbd51190dd9f44a2c4a7157'),
            ('ICO/1m/ICO1m_00204.sofa', '092b99a408ee86d1e0c9ce6ac177f8af'),
            ('ICO/1m/ICO1m_00205.sofa', 'fd444ceb5268b0066204738e96cfebc5'),
            ('ICO/1m/ICO1m_00206.sofa', '68ed2b33fe442915bb34d7e2e41047e8'),
            ('ICO/1m/ICO1m_00209.sofa', '938311d8de00242358172e37c8bd4899'),
            ('ICO/1m/ICO1m_00210.sofa', '94e78b502efc362b8fbfb82c5dee71f3'),
            ('ICO/1m/ICO1m_00211.sofa', '6a038dbee6fbc86348c19ea7edfab9f1'),
            ('ICO/1m/ICO1m_00212.sofa', 'a5145589f86ecf00422a7a8ca3e97f62'),
            ('ICO/1m/ICO1m_00213.sofa', '5ef0394fc4d6fed172c58f2b8cd6a45e'),
            ('ICO/1m/ICO1m_00214.sofa', 'e1267a27372017a23dfdab9783f47979'),
            ('ICO/1m/ICO1m_00215.sofa', 'da4fe6a96b9b2c05bfa4347ce6f073f2'),
            ('ICO/1m/ICO1m_00216.sofa', '7fc2856d662f39c7ec0fe7e7b1a90602'),
            ('ICO/1m/ICO1m_00217.sofa', 'c1531c2cab363f4fa71006328cf15d91'),
            ('ICO/1m/ICO1m_00219.sofa', '53fa7eb4f7fcd000997fd889ad74dc6e'),
            ('ICO/1m/ICO1m_00220.sofa', 'c25886c962c5c4e97081b06cc01149db'),
            ('ICO/1m/ICO1m_00221.sofa', '5abf099f2f5b03e33babc24f08ff2cc1'),
            ('ICO/1m/ICO1m_00222.sofa', '65aef9b85b48a547a33c09e8da877d49'),
            ('ICO/1m/ICO1m_00223.sofa', 'd4ee3233449dde27deb9f7a11eace2a4'),
            ('ICO/1m/ICO1m_00224.sofa', 'fc729a3f3e78183656d74fd9c007fb36'),
            ('ICO/1m/ICO1m_00225.sofa', '9a398bf7fc21f9531752fb12f7052679'),
            ('ICO/1m/ICO1m_00226.sofa', '59e5fe00fe1df3104e33c03dbf649a6b'),
            ('ICO/1m/ICO1m_00227.sofa', '2b82c36a941301da9633240b975b0ad9'),
            ('ICO/1m/ICO1m_00228.sofa', '611a898619934e151de0bc9a74a6fe6a'),
            ('ICO/1m/ICO1m_00229.sofa', '447bc2605ab93417c9c7234440c0fc0e'),
            ('ICO/1m/ICO1m_00230.sofa', 'a62d0ba5a23957c59b950863406cec94'),
            ('ICO/1m/ICO1m_00231.sofa', '4e71fa860193df95b942a36299fd0b7d'),
            ('ICO/1m/ICO1m_00232.sofa', 'bce824fb6689765319dec51438801449'),
            ('ICO/1m/ICO1m_00233.sofa', 'c32cec41a7c7548eccb783fae0e57e78'),
            ('ICO/1m/ICO1m_00234.sofa', 'daf4582b13bc7c4a164c8cdb12b8bc8d'),
            ('ICO/1m/ICO1m_00235.sofa', '512f12edbfc974f50dbf716552d9f89a'),
            ('ICO/1m/ICO1m_00236.sofa', '25654bb78e866b81cb5c6ad5b61d325d'),
            ('ICO/1m/ICO1m_00237.sofa', '97bfa7ec65f8ff3ba4646204e564ee38'),
            ('ICO/1m/ICO1m_00238.sofa', '6e77ca9ccbab8d05b08646b3097e8038'),
            ('ICO/1m/ICO1m_00239.sofa', 'ac2e4d687f86ffb47de4cd53960bf3c5'),
            ('ICO/1m/ICO1m_00240.sofa', '5d1daf505a7d15ea17c578bd42fa13b1'),
            ('ICO/1m/ICO1m_00241.sofa', 'e3970ba972e0388aef44b6413cf935dc'),
            ('ICO/1m/ICO1m_00244.sofa', '233799a0d1b05e4584750c5f7fdf8fb5'),
            ('ICO/1m/ICO1m_00245.sofa', '8c98fde7b4db78afddcb644c990f967d'),
            ('ICO/1m/ICO1m_00246.sofa', '0782b61e89ac29dd715d34d61f3d55db'),
            ('ICO/1m/ICO1m_00247.sofa', '4f797a78b78e575292bb4b93cfc7a721'),
            ('ICO/1m/ICO1m_00248.sofa', '692c87b6974fbd6b7d98047fe35056e3'),
            ('ICO/1m/ICO1m_00251.sofa', '65d94e149c1f6bc57be22c455d791079'),
            ('ICO/1m/ICO1m_00252.sofa', '303070737fdf6fdbf4a653fea6b8d6b9'),
            ('ICO/1m/ICO1m_00253.sofa', '36074f94e00f8f91ab3e7a1f4452cf82'),
            ('ICO/1m/ICO1m_00254.sofa', '5e1418f9f4e46e1929bc4e195ee96555'),
            ('ICO/1m/ICO1m_00256.sofa', '0483f3fd092544e78e9317931a30247c'),
            ('ICO/1m/ICO1m_00258.sofa', '8a5fba23044d3843801b9236885717f4'),
            ('ICO/1m/ICO1m_00259.sofa', 'ad753f9c5fc9c5ca493ae4b8d90c8cf4'),
            ('ICO/1m/ICO1m_00261.sofa', 'afb1a76d9a961edd8d980de48e63d2ed'),
            ('ICO/1m/ICO1m_00262.sofa', 'a9c58139d7eb48f910779a866162282d'),
            ('ICO/1m/ICO1m_00263.sofa', '5e31f934dbec68bf651872581ff401c8'),
            ('ICO/1m/ICO1m_00264.sofa', 'f2c986684848ae7ff7fd1a36205c6a0e'),
            ('ICO/1m/ICO1m_00265.sofa', 'e18736b84bc3c174f03e874ca55a232e'),
            ('ICO/1m/ICO1m_00268.sofa', 'aea14d05a00a0b8e33f725444b6293e5'),
            ('ICO/1m/ICO1m_00269.sofa', '278b7c0d5a0ebcad67a896f6f00b67bb'),
            ('ICO/1m/ICO1m_00270.sofa', 'c35efaffa06ac8bb108bccc088209019'),
            ('ICO/1m/ICO1m_00271.sofa', '1b9e4e40f3105202390d4faa5a9b7771'),
            ('ICO/1m/ICO1m_00272.sofa', '01fc96fb165d707e6f568c0cea1795f8'),
            ('ICO/1m/ICO1m_00273.sofa', '5400601de5e6f4dc798fbe69761d66c7'),
            ('ICO/1m/ICO1m_00275.sofa', '4319447f93879869d122cdb4cbac6dff'),
            ('ICO/1m/ICO1m_00276.sofa', '4dc3817a04bd15a6404abba02be9b77e'),
            ('ICO/1m/ICO1m_00277.sofa', '109aacfeae6079f7be524c7b3c214ea8'),
            ('ICO/1m/ICO1m_00278.sofa', '799cf13dc7a42a90318207602be27c28'),
            ('ICO/1m/ICO1m_00279.sofa', '480de7620c94acbf2b3cbba279890152'),
            ('ICO/1m/ICO1m_00281.sofa', '806fe9203c5cb6dd03c3265d1d7493bc'),
            ('ICO/1m/ICO1m_00283.sofa', 'b6c4855edbd8297d4b2f78fecfcec872'),
            ('ICO/1m/ICO1m_00284.sofa', '7e9db458a51f22c6004a17bd7bb96f6d'),
            ('ICO/1m/ICO1m_00285.sofa', 'c0d8aaeeadd7b09af4c699243c7c8b28'),
            ('ICO/1m/ICO1m_00286.sofa', 'c0d000ecc41ab6481526159b35380062'),
            ('ICO/1m/ICO1m_00287.sofa', 'cf844b53e7cf6f561a11a6ea7fea6d71'),
            ('ICO/1m/ICO1m_00288.sofa', '42cf4457e40981a3cda17ad8534e33a0'),
            ('ICO/1m/ICO1m_00289.sofa', '06f5b2b9f76236c90ebdf80589adc8b0'),
            ('ICO/1m/ICO1m_00290.sofa', '3d4286e7efacaea19fb64f645cd8431a'),
            ('ICO/1m/ICO1m_00291.sofa', 'c4b2e193d2e0acbb81f48411a2410c8a'),
            ('ICO/1m/ICO1m_00293.sofa', '55db19b2681ffcd5a93441aa59b09dc8'),
            ('ICO/1m/ICO1m_00294.sofa', 'd15b82734b1b9bb8fde049eaed8d22d4'),
            ('ICO/1m/ICO1m_00295.sofa', '306cc6e1aab77036116789d9c2639fda'),
            ('ICO/1m/ICO1m_00296.sofa', '27024949e58a992af60cdc44d3ee46e9'),
            ('ICO/1m/ICO1m_00297.sofa', '894c883d847301a1a40ea6d995ae53e1'),
            ('ICO/1m/ICO1m_00298.sofa', '4fb6d840422e8105888cde8dee3b444d'),
            ('ICO/1m/ICO1m_00301.sofa', '27a9f01df49463368459492e445ef262'),
            ('ICO/1m/ICO1m_00303.sofa', '77809b90aee7f3ffffde92830a86abe7'),
            ('ICO/1m/ICO1m_00305.sofa', '4c5dc9aae80ca3ff8935efe6ea1d431f'),
            ('ICO/1m/ICO1m_00306.sofa', 'be0841e39ecc8685b8c85abe754ca0e0'),
            ('ICO/1m/ICO1m_00307.sofa', 'dc37d6f5b1da7113727769c107e22cb2'),
            ('ICO/1m/ICO1m_00308.sofa', 'dfbb14bc06e9d8ec6c4391fb0e7787d5'),
            ('ICO/1m/ICO1m_00309.sofa', 'bee7dce54c4149a397cbb19b41bb4ce3'),
            ('ICO/1m/ICO1m_00311.sofa', 'efdc75b2f105712717f3aea804a28c30'),
            ('ICO/1m/ICO1m_00315.sofa', 'd2d86d8c31b9fe6e847d860955907b6c'),
            ('ICO/1m/ICO1m_00318.sofa', '702ccb1bc4f910d56b6d1bf200a3a8fb'),
            ('ICO/1m/ICO1m_00319.sofa', '7e3715d711be9c999de4af7d7ef86a30'),
            ('ICO/1m/ICO1m_00320.sofa', 'c2bd0039a87fd74f7e8e56333b694887'),
            ('ICO/1m/ICO1m_00321.sofa', 'dc804683ed37523ff1e81141d0867edc'),
            ('ICO/1m/ICO1m_00322.sofa', '249224395db979becc7a92a689eb76a1'),
            ('ICO/1m/ICO1m_00323.sofa', 'fa2c1ad2580db676fd8ade3bf0be385f'),
            ('ICO/1m/ICO1m_00326.sofa', '44f158c76ae4660dce950adb74375d5b'),
            ('ICO/1m/ICO1m_00328.sofa', '5cc516a556fe1bf93bf78abb08ce0189'),
            ('ICO/1m/ICO1m_00329.sofa', 'd55fc0a47d6c7ed6891bdf353c32b0bb'),
            ('ICO/1m/ICO1m_00331.sofa', '74b5d625f3730ebb04df8d142b499727'),
            ('ICO/1m/ICO1m_00332.sofa', '77e01bb7948a3b44884bd09b69314238'),
            ('ICO/1m/ICO1m_00333.sofa', '47e8008b2b90e1fa02de6d50ddc48e8c'),
            ('ICO/1m/ICO1m_00334.sofa', '8f2e68272ada667230a6d95601a3e901'),
            ('ICO/1m/ICO1m_00335.sofa', '36c4bcbc485dad3c60795f1373425cf7'),
            ('ICO/1m/ICO1m_00336.sofa', '066873ff6da277950378e070f578f6c3'),
            ('ICO/1m/ICO1m_00337.sofa', '7f2ca83d87abd8210d8bcd161a67f57b'),
            ('ICO/1m/ICO1m_00338.sofa', '400ed65a9b8926bafb83f562ab90a3cd'),
            ('ICO/1m/ICO1m_00340.sofa', 'bf88e4e047c428e9dc39738e8669b3f0'),
            ('ICO/1m/ICO1m_00341.sofa', '139b17d8fc6a489d0bb10a6a72c1cba0'),
            ('ICO/1m/ICO1m_00343.sofa', '97ce2eb05b8b73de550bcd689abe0048'),
            ('ICO/1m/ICO1m_00344.sofa', '56ef88c2a4733860d4e4add14cc6a69e'),
            ('ICO/1m/ICO1m_00345.sofa', '1e18678171d8312e487a38c6301a75a1'),
            ('ICO/1m/ICO1m_00347.sofa', 'd91d086a47ee27f247534abb1e8f8fda'),
            ('ICO/1m/ICO1m_00348.sofa', 'ce636d728dc19ab76bfd36acebe9afb3'),
            ('ICO/1m/ICO1m_00349.sofa', '620b2e4b05d908a314467487569df2a5'),
            ('ICO/1m/ICO1m_00350.sofa', 'd1ab88f94e35cd8b1bf2ac949747fb00'),
            ('ICO/1m/ICO1m_00351.sofa', 'bd97244a548215ea5ce38c1f1aeaae01'),
            ('ICO/1m/ICO1m_00352.sofa', 'd1bbf7b01ca2858e794531625fdc0ecf'),
            ('ICO/1m/ICO1m_00353.sofa', 'e66474a827292abf1bbadfdd1c728dd8'),
            ('ICO/1m/ICO1m_00354.sofa', 'efdf2fa4e7070c4cc23abcdc1a69c530'),
            ('ICO/1m/ICO1m_00355.sofa', '510ac31bab58928dc298e17a451f37dd'),
            ('ICO/1m/ICO1m_00356.sofa', '478717f1eb211edcfce567e17e9b7e86'),
            ('ICO/1m/ICO1m_00358.sofa', '639b1aeffbcf1702929536c607e4bdb9'),
            ('ICO/1m/ICO1m_00359.sofa', 'd12a835b17ed2b6f1a2a883039973c58'),
            ('ICO/1m/ICO1m_00360.sofa', 'e497024372597ee193b495bc9cd7c56b'),
            ('ICO/1m/ICO1m_00361.sofa', '936120c6b269b95595df0dac49c58fdc'),
            ('ICO/1m/ICO1m_00362.sofa', '087c9201b5396b9b24777e1b2a2fab22'),
            ('ICO/1m/ICO1m_00363.sofa', 'e8b46d6447f620d46226ee142a443504'),
            ('ICO/1m/ICO1m_00364.sofa', 'eeb629b0d581c2ba12a0eae576daaeec'),
            ('ICO/1m/ICO1m_00365.sofa', '61ae7e67055241702fb1ef69e804ba41'),
            ('ICO/1m/ICO1m_00366.sofa', '443d6899de1bd9559f31079e986b2aea'),
            ('ICO/1m/ICO1m_00367.sofa', 'caf967e30a1cb1211291418071d16e24'),
            ('ICO/1m/ICO1m_00368.sofa', 'd670993bd0ce46786e78f989340c900d'),
            ('ICO/1m/ICO1m_00370.sofa', '465f311d009597d0d9bdb98cfd0c3863'),
            ('ICO/1m/ICO1m_00371.sofa', 'c3ef43ee8a9524c19176ffe9e79c5b0e'),
            ('ICO/1m/ICO1m_00372.sofa', 'e9cbf7ae20c426cbe94afad659a67cce'),
            ('ICO/1m/ICO1m_00373.sofa', 'b44c1c0f76e532fd967ec300e22840e5'),
            ('ICO/1m/ICO1m_00374.sofa', 'b8d26156c10feb707d0a26e5f68b897d'),
            ('ICO/1m/ICO1m_00375.sofa', '77bc1ab7c55022d9050ae6c2446308bb'),
            ('ICO/1m/ICO1m_00376.sofa', 'aa554f6948b3cce12e033647ee49f757'),
            ('ICO/1m/ICO1m_00378.sofa', '489241648abba5a9b12c26ff8cb07b1b'),
            ('ICO/1m/ICO1m_00379.sofa', 'fe6d59610ad1972114a5abb869c608ee'),
            ('ICO/1m/ICO1m_00382.sofa', '88b4b0648431f8366d398e2be5f6b380'),
            ('ICO/1m/ICO1m_00383.sofa', 'c81e6542d322f1491e9b21c6d5a070b3'),
            ('ICO/1m/ICO1m_00385.sofa', '210a15b84b955fe3be439dc5e2646b2d'),
            ('ICO/1m/ICO1m_00386.sofa', '2b775d33e95911c7d7dfd2465c7030de'),
            ('ICO/1m/ICO1m_00389.sofa', 'f89b2bc82d372fd76d7bfad76dc6f9c0'),
            ('ICO/1m/ICO1m_00391.sofa', '0ca28443f248053cbf15476302c5555a'),
            ('ICO/1m/ICO1m_00392.sofa', '5b16410ff63f5190dd8df14a44a3b447'),
            ('ICO/1m/ICO1m_00395.sofa', '035782b488702e89d44dc117d7189c45'),
            ('ICO/1m/ICO1m_00397.sofa', '69c10d08cf4ee74f474878823e9c9e80'),
            ('ICO/1m/ICO1m_00398.sofa', '2a58236f89660975a55beec0ba9d4f37'),
            ('ICO/1m/ICO1m_00399.sofa', '30677976e128cd5f8a7de7ed460f211f'),
            ('ICO/1m/ICO1m_00401.sofa', '4af6c4a9ffbd9a92cb72ff197a139f64'),
            ('ICO/1m/ICO1m_00402.sofa', '79af2dc865d87fbb852b36d252905822'),
            ('ICO/1m/ICO1m_00403.sofa', '74f77afb5c4ce63b28cf75b10b3621fe'),
            ('ICO/1m/ICO1m_00404.sofa', 'a4610bae72b368236f85ed426f1d68f3'),
            ('ICO/1m/ICO1m_00405.sofa', '2547e89985cba93e184b06d2a4a9ed0c'),
            ('ICO/1m/ICO1m_00406.sofa', '214aa87aa01b4aecda959ab03c198086'),
            ('ICO/1m/ICO1m_00407.sofa', '6988afd3edef2f8889e613e7945da9ed'),
            ('ICO/1m/ICO1m_00408.sofa', '5b04d40ad66247ac10bedaefba8341ba'),
            ('ICO/1m/ICO1m_00409.sofa', '7e53214cedf117297c0464b6e98bb2e5'),
            ('ICO/1m/ICO1m_00410.sofa', '253b12e094c4387ad78dc5cf443e44aa'),
            ('ICO/1m/ICO1m_00411.sofa', '1e9d7efe20c7a6defcbcf5253c06f53b'),
            ('ICO/1m/ICO1m_00412.sofa', '6b0c210be5d5b1a6b7bc0c47909aca47'),
            ('ICO/1m/ICO1m_00413.sofa', 'faf89861768cb8a36e3bf526bf60cca5'),
            ('ICO/1m/ICO1m_00414.sofa', '80aabf5611111113bdaf883cc0c4d664'),
            ('ICO/1m/ICO1m_00415.sofa', '6efb8c61a1d0066f95e5cf11bea95f41'),
            ('ICO/1m/ICO1m_00416.sofa', 'fa73affdd64735fdd1d0d51d83146298'),
            ('ICO/1m/ICO1m_00417.sofa', '4c7da9d73fd1e3df1cfe7119a281cb5c'),
            ('ICO/1m/ICO1m_00418.sofa', '4540c8519d29a611430fe6994a12f068'),
            ('ICO/1m/ICO1m_00419.sofa', '2636a3cd54d81050fb88aee3ae87ac00'),
            ('ICO/1m/ICO1m_00420.sofa', '1e81bdab5b493836e6c5a43496394379'),
            ('ICO/1m/ICO1m_00421.sofa', 'd0b5b00a92bc0ecbc2831bdd78c8e23f'),
            ('ICO/1m/ICO1m_00422.sofa', 'a011dd5c4b2fe6a4f4161aa9b91f9a1a'),
            ('ICO/1m/ICO1m_00423.sofa', '0d0b7f9639ec2322e6f44ff68ee94052'),
            ('ICO/1m/ICO1m_00426.sofa', '791abdbba0aae7c3b8b5c6930eeaea4f'),
            ('ICO/1m/ICO1m_00427.sofa', '84199ceb4ae69cc11cfe5b288ef8261d'),
            ('ICO/1m/ICO1m_00428.sofa', 'a34af12b1a727c644b8b26afff0df4bd'),
            ('ICO/1m/ICO1m_00430.sofa', 'a031880a1f5d706140cc9365470a2177'),
            ('ICO/1m/ICO1m_00432.sofa', '53e6c7d766ef5d88c1834e3b5a30cf4f'),
            ('ICO/1m/ICO1m_00433.sofa', '1bd2d00020c0c66aa8877a3495f9b2e4'),
            ('ICO/1m/ICO1m_00434.sofa', 'ca0f325398c957bcbf25d238b5d6fb03'),
            ('ICO/1m/ICO1m_00441.sofa', 'f42c22a4da452a32ebe61573c3375282'),
            ('ICO/1m/ICO1m_00442.sofa', '08a89f218332f5c53cb0458302930a68'),
            ('ICO/1m/ICO1m_00443.sofa', '672f684e7f9c1ae9c2a6b4116d882b85'),
            ('ICO/1m/ICO1m_00446.sofa', 'b593dcf3ef41b20a16a98f94b4291178'),
            ('ICO/1m/ICO1m_00448.sofa', 'ddded52ba7c1bf2cf6815bdcaddc0bc0'),
            ('ICO/1m/ICO1m_00449.sofa', 'a8562a417e4266b4876cd54696635a40'),
            ('ICO/1m/ICO1m_00450.sofa', '86026d7fb62a06757d5f42ebed004f2e'),
            ('ICO/1m/ICO1m_00451.sofa', '8718b43a8d0e0c4a931d42bb09f34d40'),
            ('ICO/1m/ICO1m_00452.sofa', 'f9b2f7e4fc2e22bb3ebf2c699228aab3'),
            ('ICO/1m/ICO1m_00455.sofa', 'aae67f3600e896794dadf0338d3a9e6b'),
            ('ICO/1m/ICO1m_00456.sofa', '9031fb78544f18598179be7acfa06c8c'),
            ('ICO/1m/ICO1m_00457.sofa', '60321a35ef17ba388b0146694caa3103'),
            ('ICO/1m/ICO1m_00459.sofa', 'ca1fa8bd167a5e25e98d3b84337f4a68'),
            ('ICO/1m/ICO1m_00460.sofa', 'ca68ffbbe3ed92f32ee41d1d1eb0b00c'),
            ('ICO/1m/ICO1m_00461.sofa', 'd946915d74c4abc335aeafdee3226dc4'),
            ('ICO/1m/ICO1m_00462.sofa', 'c86d5426fef03c4a66ee3912ee68dc72'),
            ('ICO/1m/ICO1m_00463.sofa', '0b46f06b1fdbbe466a89d55b86a9adea'),
            ('ICO/1m/ICO1m_00464.sofa', '5291b00584559ea930861d71286332c6'),
            ('ICO/1m/ICO1m_00466.sofa', '31b9cd3f0a57c1957e2d98d045662194'),
            ('ICO/1m/ICO1m_00467.sofa', 'e0fde4e42001474549c5c57aea63af7a'),
            ('ICO/1m/ICO1m_00468.sofa', 'c0a87653b88f61f6e427ea09c6b8694a'),
            ('ICO/1m/ICO1m_00469.sofa', 'c7ec7c9fe6e3be991a8f41a0072f5bce'),
            ('ICO/1m/ICO1m_00470.sofa', 'a7c72c3009d230fe073ae54be6f24ef0'),
            ('ICO/1m/ICO1m_00471.sofa', '0f3e3aec837cbec57174c1ae3fb14554'),
            ('ICO/1m/ICO1m_00472.sofa', 'cf69eb47ab6e5499b15ce18dc3644331'),
            ('ICO/1m/ICO1m_00473.sofa', 'b2d793c2d2f71f346ae495124503ced9'),
            ('ICO/1m/ICO1m_00474.sofa', 'c00d174c5584e5318ab4700363c7eef1'),
            ('ICO/1m/ICO1m_00476.sofa', '18f17ea10557baf76604657f265a5130'),
            ('ICO/1m/ICO1m_00477.sofa', 'e9b193d139db7fbe5ca2e8b23cd9361e'),
            ('ICO/1m/ICO1m_00478.sofa', 'b6218b4ba2a80167409a0cfc1d29cc11'),
            ('ICO/1m/ICO1m_00480.sofa', '7a9c17b30eb6e65e9ee947ea27546736'),
            ('ICO/1m/ICO1m_00481.sofa', '3b3a8fc763d3b32a97d268b8653cbc1b'),
            ('ICO/1m/ICO1m_00482.sofa', '222bd1fdde91c35be53a1f2c96f534b4'),
            ('ICO/1m/ICO1m_00483.sofa', '62a9e023c1c2ff0bdcee090c7f6544f7'),
            ('ICO/1m/ICO1m_00484.sofa', 'f6514a1b0d6893eb8fe57b1a9812b274'),
            ('ICO/1m/ICO1m_00486.sofa', '044dad35125dede00ca6dde68e189ae3'),
            ('ICO/1m/ICO1m_00487.sofa', '524d276df41bed22c8601519ff819b8b'),
            ('ICO/1m/ICO1m_00489.sofa', '87a463975a0debb4b2d0a7faa14f89d8'),
            ('ICO/1m/ICO1m_00490.sofa', '09d892c52afe6e989f3485fa47a425b1'),
            ('ICO/1m/ICO1m_00491.sofa', '781f2146bba74fd2c8dc295a433d35a6'),
            ('ICO/1m/ICO1m_00493.sofa', '6ae64635a02695bbe207c2140496d0f3'),
            ('ICO/1m/ICO1m_00494.sofa', '244d0a71c043bff4384f20f0767e1baa'),
            ('ICO/1m/ICO1m_00497.sofa', 'b488bafd1953af4dab5984fabad9529b'),
            ('ICO/1m/ICO1m_00499.sofa', 'bd8a8aeb70549c8b499f5a0d2c0ebf15'),
            ('ICO/1m/ICO1m_00500.sofa', 'f46434dcaa1aaf7d3066e3af666db866'),
            ('ICO/1m/ICO1m_00501.sofa', 'ec2ead709657b5d80ccf8c06488be384'),
            ('ICO/1m/ICO1m_00502.sofa', '918d3305c9cc4d4edb2eb16bcb68684a'),
            ('ICO/1m/ICO1m_00503.sofa', '41035cb2584c365061235140a7551b30'),
            ('ICO/1m/ICO1m_00505.sofa', 'c703fe6b17b5da123358bee4f2f013e1'),
            ('ICO/1m/ICO1m_00506.sofa', '9c8bd54b62f81af59cc6d8cae77a5a2e'),
            ('ICO/1m/ICO1m_00507.sofa', '0455cfb4e9e2d4c163f6e190bd40f031'),
            ('ICO/1m/ICO1m_00508.sofa', '0ac2ab86af68ed379aa479b22d562ae2'),
            ('ICO/1m/ICO1m_00509.sofa', '813c849f502e9342a1d947e662862d91'),
            ('ICO/1m/ICO1m_00511.sofa', 'fe7f6d22f4a87dbb2e53a52e5ad2dc13'),
            ('ICO/1m/ICO1m_00512.sofa', '52bed2db4bd6d5a155a50dbf227c4852'),
            ('ICO/1m/ICO1m_00513.sofa', '14d9d5a085ea923c7713321dbdfa7b2d'),
            ('ICO/1m/ICO1m_00514.sofa', '7474760c45519b30563e8eb743e5d016'),
            ('ICO/1m/ICO1m_00515.sofa', '193003ff16772dd3f0989b181846ee01'),
            ('ICO/1m/ICO1m_00516.sofa', '23eacc7e5c74887d3dce6787763bde29'),
            ('ICO/1m/ICO1m_00517.sofa', 'ecc3e6e92eef6d138f72b834b14ba85d'),
            ('ICO/1m/ICO1m_00518.sofa', '049a63c84eb3ea0880a495c26ea6f38f'),
            ('ICO/1m/ICO1m_00519.sofa', 'ca92a15caf4f48d496b24ca61bc4565e'),
            ('ICO/1m/ICO1m_00520.sofa', '14881a54708cb5ce328cbd4da1f687d7'),
            ('ICO/1m/ICO1m_00521.sofa', 'cf2de6a3709a6682c95a66cb491f3869'),
            ('ICO/1m/ICO1m_00523.sofa', 'd4af269ca2922cb7928d94cdeeb2b7ff'),
            ('ICO/1m/ICO1m_00524.sofa', 'c7bb4e6ccb3c8d15b1be7df95927d328'),
            ('ICO/1m/ICO1m_00525.sofa', '5a2363ffa73e0c281c30ca86cdcd95b5'),
            ('ICO/1m/ICO1m_00526.sofa', '0ea2bc3f81aa0516444dd3a2b46ac48e'),
            ('ICO/1m/ICO1m_00527.sofa', 'd15c480c4dea9594bcd2ef1ad4be1967'),
            ('ICO/1m/ICO1m_00528.sofa', 'ce8c549156998e90a1ff557ac6d25661'),
            ('ICO/1m/ICO1m_00529.sofa', 'f0424a136083678c9982ea460989a038'),
            ('ICO/1m/ICO1m_00530.sofa', 'ff3c8f0051abedf4d691ef530620c9ed'),
            ('ICO/1m/ICO1m_00532.sofa', '061b513b2fb604650dc516923833c813'),
            ('ICO/1m/ICO1m_00533.sofa', '242e0ed3f3fa81430fce465cd108a30e'),
            ('ICO/1m/ICO1m_00534.sofa', '4edb556393a976f5dc9f72fe0e5546f5'),
            ('ICO/1m/ICO1m_00536.sofa', 'd163ed5590806d47168c53e59b54f921'),
            ('ICO/1m/ICO1m_00538.sofa', 'ab48371362271956e1cd11cdb806ba60'),
            ('ICO/1m/ICO1m_00539.sofa', 'f21d0a140a16a1777091960db34985f0'),
            ('ICO/1m/ICO1m_00540.sofa', '05e74bbf840af694f319e5b0ddb8d6eb'),
            ('ICO/1m/ICO1m_00542.sofa', '1069002adbd899a4597f60e1931d0125'),
            ('ICO/1m/ICO1m_00543.sofa', '833b0dba8e360b1baee78b26e4b63532'),
            ('ICO/1m/ICO1m_00544.sofa', '18eb2f9fbfc6131a5a8d27410a7c4b8b'),
            ('ICO/1m/ICO1m_00545.sofa', 'c3ec585914e19ea4a1c103f5449736e0'),
            ('ICO/1m/ICO1m_00546.sofa', '99c7d7cdfb179431b6192f3ea7006006'),
            ('ICO/1m/ICO1m_00547.sofa', '2411f41887d3bfc14a98618dabb08397'),
            ('ICO/1m/ICO1m_00548.sofa', '5d5dfcb763c5a9ad4869960fd2998971'),
            ('ICO/1m/ICO1m_00549.sofa', 'dc55a7984d8775755fccc29f72fe228a'),
            ('ICO/1m/ICO1m_00550.sofa', '614e683ddb4050ec1604fb8b6c3e34a6'),
            ('ICO/1m/ICO1m_00551.sofa', '61e35091874a5c69c5d3d1bb764f65b6'),
            ('ICO/1m/ICO1m_00552.sofa', '084f30b3dc96914256cd4769b2d480f0'),
            ('ICO/1m/ICO1m_00553.sofa', '6efd7fd54fff678793be542d605eb0e5'),
            ('ICO/1m/ICO1m_00555.sofa', '487f831ef450a6bf5ee97fc6accd7f64'),
            ('ICO/1m/ICO1m_00557.sofa', 'e6568beea17a1fc1f9e1db2f27f7e4f2'),
            ('ICO/1m/ICO1m_00558.sofa', '76513a2bffbd49677faa5a75c5323355'),
            ('ICO/1m/ICO1m_00559.sofa', '88256ca0d2564b16991955a15dffd054'),
            ('ICO/1m/ICO1m_00560.sofa', '90030cd3ec202bb5cbd1edb2a1305f69'),
            ('ICO/1m/ICO1m_00561.sofa', 'a493d871e9fb5e973c6fde96e4e6c642'),
            ('ICO/1m/ICO1m_00562.sofa', '831346b25283b03c89b96c8150d0865f'),
            ('ICO/1m/ICO1m_00563.sofa', 'ceb195b18cad4ed883a85b099498b63b'),
            ('ICO/1m/ICO1m_00567.sofa', '882c8d33efcd2676318c36be5ac081fb'),
            ('ICO/1m/ICO1m_00568.sofa', 'f9d501861adb3100d364bfbbcf3e4310'),
            ('ICO/1m/ICO1m_00569.sofa', '53de257a3748281a30edd801640c9a20'),
            ('ICO/1m/ICO1m_00570.sofa', 'fc3b9c4b7f7e7a471e09dd0301ed0d05'),
            ('ICO/1m/ICO1m_00571.sofa', '66d4e5898606b4f92972fda47de34877'),
            ('ICO/1m/ICO1m_00572.sofa', 'a166064995d61ed06c31b3f0f46493bf'),
            ('ICO/1m/ICO1m_00573.sofa', '4d7f8c5977419ad4d47dac962098e37e'),
            ('ICO/1m/ICO1m_00576.sofa', '05d01f81749867300f7e51ef00eec9a0'),
            ('ICO/1m/ICO1m_00577.sofa', '9c771bc0193b4d85baaac5bd6e6c6598'),
            ('ICO/1m/ICO1m_00580.sofa', '0e5defff3d41ded4f7946a023457bddc'),
            ('ICO/1m/ICO1m_00582.sofa', '068774222006017c55cd4262d13dd633'),
            ('ICO/1m/ICO1m_00583.sofa', 'a32b974866601406efeb12fe7e9c9e45'),
            ('ICO/1m/ICO1m_00585.sofa', '3a7916286bccdcf13352ed98b1bc09f4'),
            ('ICO/1m/ICO1m_00588.sofa', 'f358186a15a82cf563682b3173fd8157'),
            ('ICO/1m/ICO1m_00590.sofa', '1ca1a9a39ecf6d6504f2b127005d27bc'),
            ('ICO/1m/ICO1m_00591.sofa', 'd025309173fe13d3dae2b977c458a7bf'),
            ('ICO/1m/ICO1m_00592.sofa', 'aea76d485a38364e15709b19a1696b09'),
            ('ICO/1m/ICO1m_00593.sofa', 'ddb26f572bbf285efb2ecdb07dad2a72'),
            ('ICO/1m/ICO1m_00594.sofa', 'd1579dbeaff1a362327127103c11e6e7'),
            ('ICO/1m/ICO1m_00595.sofa', '9abefaa1a63db9e2eb0d2be708bc4115'),
            ('ICO/1m/ICO1m_00596.sofa', '864111223e69637373f0a473d5873ebe'),
            ('ICO/1m/ICO1m_00597.sofa', 'f9590742281742e33c2d5995471e581a'),
            ('ICO/1m/ICO1m_00598.sofa', 'ca9df6f3072aad2cad53b9a8b46a06f4'),
            ('ICO/1m/ICO1m_00599.sofa', '432ff2b8307b6fb14c9456603cf29c0d'),
            ('ICO/1m/ICO1m_00600.sofa', '425e6bdb31ee75c6850470db61a2ac84'),
            ('ICO/1m/ICO1m_00601.sofa', '2e6453a7790ea76b7db798b82700ea0a'),
            ('ICO/1m/ICO1m_00604.sofa', '431fcade16c2f9076c71039102acb948'),
            ('ICO/1m/ICO1m_00606.sofa', 'd6b2dcd4545db696a3f95a353df01dd6'),
            ('ICO/1m/ICO1m_00608.sofa', '114e04ecb65c4c58d9543db394e89a0c'),
            ('ICO/1m/ICO1m_00609.sofa', '2e5b261bd6c4120819ea8ede9e7b33fb'),
            ('ICO/1m/ICO1m_00613.sofa', '5be7adc7f570021e857d0a8d4c5d3700'),
            ('ICO/1m/ICO1m_00616.sofa', '3f835b870989d5355ffc609f7c592d0f'),
            ('ICO/1m/ICO1m_00617.sofa', '6b4bce3a9524ff13b7516429ec98c183'),
            ('ICO/1m/ICO1m_00618.sofa', 'b81b3944892eb544cf09b69de96b211e'),
            ('ICO/1m/ICO1m_00619.sofa', 'ac0eb141cf019aaa07c7ab793602e3bd'),
            ('ICO/1m/ICO1m_00620.sofa', 'c172896c57b98ec5b025be2779c3b129'),
            ('ICO/1m/ICO1m_00621.sofa', '0d166e76be0da59db9aad1c774db94a2'),
            ('ICO/1m/ICO1m_00622.sofa', 'd2be02d2b517ecade41dba1fb2e2a9ca'),
            ('ICO/1m/ICO1m_00623.sofa', '218f6adfd114a73d9c566f6657f803b8'),
            ('ICO/1m/ICO1m_00624.sofa', '36b357141b226a1ed2e09cebbe20cb6d'),
            ('ICO/1m/ICO1m_00625.sofa', '7669b7bd669aa9724068262b9a3e9dbc'),
            ('ICO/1m/ICO1m_00626.sofa', 'b01f4041057f75b27b1a117cae1c9115'),
            ('ICO/1m/ICO1m_00628.sofa', 'cdd2ceae7b999b5ddf8cf1b4ea29a03c'),
            ('ICO/1m/ICO1m_00629.sofa', 'dd0d2801777b49a06e3bea9a9af556b7'),
            ('ICO/1m/ICO1m_00630.sofa', 'a304d1879b73f805fb9d2287276b41ac'),
            ('ICO/1m/ICO1m_00631.sofa', '013012891e5eff8ab33d8d3c5f62a8b5'),
            ('ICO/1m/ICO1m_00632.sofa', 'd826f442c270eb2280a5c8c757c0e8e6'),
            ('ICO/1m/ICO1m_00633.sofa', '14934018cf6662a34fa540488fdbab28'),
            ('ICO/1m/ICO1m_00634.sofa', 'e4913f4d58f7021700cc33cba168a235'),
            ('ICO/1m/ICO1m_00635.sofa', 'ae6ad72ea29df3304ae87753c49f30d0'),
            ('ICO/1m/ICO1m_00636.sofa', 'b45d97d65a86a977aa7228c5380c9777'),
            ('ICO/1m/ICO1m_00637.sofa', '33d4e4f99297d7fbc74d1609e5733cd3'),
            ('ICO/1m/ICO1m_00640.sofa', '0e89015619b41f61d13e012d057618dd'),
            ('ICO/1m/ICO1m_00642.sofa', 'd37524868829eec53619115f4e292df9'),
            ('ICO/1m/ICO1m_00643.sofa', '38de11c749c04cc3db66b899e73df174'),
            ('ICO/1m/ICO1m_00644.sofa', '818e9cad0ed51f25c9f9125aed3b89e3'),
            ('ICO/1m/ICO1m_00645.sofa', '58d3e6a63c44ab47c22fe814a6b7ca7f'),
            ('ICO/1m/ICO1m_00646.sofa', 'cc005dee1891f377b5c244bbaa115682'),
            ('ICO/1m/ICO1m_00647.sofa', '1d2d3534239f44c94520dcae6752f46b'),
            ('ICO/1m/ICO1m_00648.sofa', 'a7de13fe90413468dc9c4ea836cdfa75'),
            ('ICO/1m/ICO1m_00649.sofa', '42290800c44b12b9cfa2bece6cc7b9c4'),
            ('ICO/1m/ICO1m_00650.sofa', '8ba8c7f49bc80724d9ef9e88a56a0e47'),
            ('ICO/1m/ICO1m_00651.sofa', '60b251617a75820139ea5b01ab30c89a'),
            ('ICO/1m/ICO1m_00654.sofa', '8635ba46b04371f75ed5a2d77d0842fb'),
            ('ICO/1m/ICO1m_00655.sofa', 'dbdf0e76af46da70a45ee2413dbe0ce5'),
            ('ICO/1m/ICO1m_00657.sofa', 'fe8830137fb75200227842faf854fddc'),
            ('ICO/1m/ICO1m_00660.sofa', '97865e2777dfa41e4f2faf1be184c74e'),
            ('ICO/1m/ICO1m_00661.sofa', 'a032ef8de9cc108dddf9056774874fc7'),
            ('ICO/1m/ICO1m_00662.sofa', '13f2c7936d17eda5c68695e5f6f8f59f'),
            ('ICO/1m/ICO1m_00664.sofa', '41047ef80a4e4fb512e83e7a0005dd27'),
            ('ICO/1m/ICO1m_00665.sofa', '2db6dfee99c2fd88f60e1e349a83b12f'),
            ('ICO/1m/ICO1m_00666.sofa', 'f8faebb9d3a13c510f15e2f64422c226'),
            ('ICO/1m/ICO1m_00667.sofa', '0f2e9a439ca29a7a74c96487c4d12a0b'),
            ('ICO/1m/ICO1m_00668.sofa', '133520a80c70feccf737d201f6f126a4'),
            ('ICO/1m/ICO1m_00669.sofa', '71384915fcd8ca240b2fb7a01f0cc752'),
            ('ICO/1m/ICO1m_00670.sofa', '6dd34677b05558c2b37ce652898d1901'),
            ('ICO/1m/ICO1m_00671.sofa', '981098e9ffb63dd644d71e76c6bba7ef'),
            ('ICO/1m/ICO1m_00672.sofa', '2f05d8ac191e4814961ca1894274dd4d'),
            ('ICO/1m/ICO1m_00673.sofa', 'cfbe5644005925227e892ed25428346a'),
            ('ICO/1m/ICO1m_00674.sofa', 'f1a4593599c4056e53b2041bd855c185'),
            ('ICO/1m/ICO1m_00675.sofa', '9527bb655d45d78189cf77e7e437e62b'),
            ('ICO/1m/ICO1m_00676.sofa', '97ed91bbb78bdcce62dcf17dd21d274d'),
            ('ICO/1m/ICO1m_00677.sofa', 'e4de98a651867e500fa926666ee97b95'),
            ('ICO/1m/ICO1m_00678.sofa', '983f8482ebc6819c0f2c41b92bebe08c'),
            ('ICO/1m/ICO1m_00679.sofa', '0b282411a7fe62f1687957eae7913898'),
            ('ICO/1m/ICO1m_00680.sofa', '62783481bcfabcbc4a808ad0908e0f29'),
            ('ICO/1m/ICO1m_00681.sofa', '51c9740bbb4aeada48bf0a278e036dbc'),
            ('ICO/1m/ICO1m_00682.sofa', '94613c3dae0d92972cd550b78edb31f2'),
            ('ICO/1m/ICO1m_00684.sofa', '07e5f3105533afbe9d6a96ca5fe403be'),
            ('ICO/1m/ICO1m_00685.sofa', '5927cf8383e9e6eb73f363726ad0dee3'),
            ('ICO/1m/ICO1m_00686.sofa', '6baa56fbeb11beb445a34e061b10c0a7'),
            ('ICO/1m/ICO1m_00688.sofa', 'ef82627160e07c838847c78769a99566'),
            ('ICO/1m/ICO1m_00689.sofa', '80e3134061b5c8ec5ca07e69023a0d60'),
            ('ICO/1m/ICO1m_00690.sofa', '0539c110e41321803d1645b029c1a986'),
            ('ICO/1m/ICO1m_00693.sofa', 'c9243397c8da34054d5d26240f78eb2a'),
            ('ICO/1m/ICO1m_00695.sofa', '38f5f5e0b75a37c4af849e570578aaa3'),
            ('ICO/1m/ICO1m_00696.sofa', '80d5a0a5c2f4ac09572991331ae66780'),
            ('ICO/1m/ICO1m_00697.sofa', '2474aa0a373401db004caea31dc6daee'),
            ('ICO/1m/ICO1m_00698.sofa', '4416d76a178a9bd918db96357d237cfb'),
            ('ICO/1m/ICO1m_00699.sofa', 'b5daeb356787e827fe6ec8a2d0539773'),
            ('ICO/1m/ICO1m_00700.sofa', 'df97c2e13bfeffe19e2889b5e2ef7c4c'),
            ('ICO/1m/ICO1m_00701.sofa', '5def4822fc440915600f6e8010d57576'),
            ('ICO/1m/ICO1m_00702.sofa', 'cd9e9150f74e0f83cc27754add533f0d'),
            ('ICO/1m/ICO1m_00704.sofa', 'ad6a6945cc38594f174c6a8d1c2e10df'),
            ('ICO/1m/ICO1m_00705.sofa', 'f0ae90672655b87298527170610ed505'),
            ('ICO/1m/ICO1m_00707.sofa', 'e1f5dd5b91afe1c445b3597125be4cbb'),
            ('ICO/1m/ICO1m_00709.sofa', '8464279cc392c735ec87e9ea28b61365'),
            ('ICO/1m/ICO1m_00710.sofa', '6903d5a1accbfb631bfb4640e719ed1c'),
            ('ICO/1m/ICO1m_00711.sofa', '30c49bbb2d880f72a94d06cbccd7aefe'),
            ('ICO/1m/ICO1m_00712.sofa', 'cbcd2b8805b0e0b3e90a9fbd56546036'),
            ('ICO/1m/ICO1m_00713.sofa', 'd2b9ebe3d3f0499c7822dad1a8a457d4'),
            ('ICO/1m/ICO1m_00714.sofa', 'f8bbb0d3180683073e019b6b95888491'),
            ('ICO/1m/ICO1m_00717.sofa', 'a910a460ebe0dae6f1766126ef90b774'),
            ('ICO/1m/ICO1m_00718.sofa', '04a2df4355e5df806b2f193d08fdb9a6'),
            ('ICO/1m/ICO1m_00719.sofa', '81e488a5e3cc2f971e4ddb99d5fdccc0'),
            ('ICO/1m/ICO1m_00720.sofa', '530c6600f6805a6cd8e257625ba65543'),
            ('ICO/1m/ICO1m_00722.sofa', '557e92a48ad2e566b386ab85f9459556'),
            ('ICO/1m/ICO1m_00723.sofa', '9d7ed3d995283a9eebb0b5a37f27d976'),
            ('ICO/1m/ICO1m_00724.sofa', 'e2bcfab4184289e3686f80b11d90a9fb'),
            ('ICO/1m/ICO1m_00725.sofa', '9d6abccf2af63c5d417d3fe305ac7c09'),
            ('ICO/1m/ICO1m_00726.sofa', 'a3e7066c7ca75d26f6fe243c75f55429'),
            ('ICO/1m/ICO1m_00727.sofa', '02a37333f83e86acdcc62ad8d8402d47'),
            ('ICO/1m/ICO1m_00729.sofa', 'bdb618f691991226c6975ea95e7c3aec'),
            ('ICO/1m/ICO1m_00730.sofa', '916bf0ab36c17a3aa9075e4edd1cdba0'),
            ('ICO/1m/ICO1m_00732.sofa', '66f7f7466f070b3098ae61c4294126a0'),
            ('ICO/1m/ICO1m_00734.sofa', '150de2e56856360b1528a5ec9402a0bd'),
            ('ICO/1m/ICO1m_00735.sofa', '025b3fe8098d1fb1443d95dd03d2a07b'),
            ('ICO/1m/ICO1m_00736.sofa', '4cfc0fee52496a37a7da35b979bca685'),
            ('ICO/1m/ICO1m_00740.sofa', '53ad94825c49781dbd217475dc803c70'),
            ('ICO/1m/ICO1m_00742.sofa', 'bea910a42ddd697a7bd65a2553dd8904'),
            ('ICO/1m/ICO1m_00744.sofa', '3bbe8bae92560b2d8d7aa0b43f9c4b1a'),
            ('ICO/1m/ICO1m_00745.sofa', '9c314a5fb381eb60681b8fecec5816ac'),
            ('ICO/1m/ICO1m_00746.sofa', '46e30f134c6e3d4671b1002d04cb11d6'),
            ('ICO/1m/ICO1m_00747.sofa', '34bde12f1e602f1df4a24e4f7e16f7cc'),
            ('ICO/1m/ICO1m_00748.sofa', '26cdd850538f63ad294fdfbf39d8de05'),
            ('ICO/1m/ICO1m_00749.sofa', '8876a5890398ebe046b5eaf0685de3c5'),
            ('ICO/1m/ICO1m_00750.sofa', 'a6e8bfae7bd3ce35b7efe9f1befc36e2'),
            ('ICO/1m/ICO1m_00751.sofa', 'a9680be7a0219d645cff2f6900d352c7'),
            ('ICO/1m/ICO1m_00753.sofa', 'caba14a4ec6e5d6b061a543c15d0f20b'),
            ('ICO/1m/ICO1m_00754.sofa', '52c7f90d6d6602cd08fd7ff6de4981e3'),
            ('ICO/1m/ICO1m_00755.sofa', 'c5f309e059571c8d25e18ad830063ce8'),
            ('ICO/1m/ICO1m_00756.sofa', '3f6aed460a0ac739779c39f0bb1ba2bc'),
            ('ICO/1m/ICO1m_00757.sofa', 'b861f0d049b39e19a3953e5870a28a8e'),
            ('ICO/1m/ICO1m_00758.sofa', 'f1cea11d030a686c066af05491acb382'),
            ('ICO/1m/ICO1m_00760.sofa', '59dda7d0eff5a14dc73d8d24ee9bec1b'),
            ('ICO/1m/ICO1m_00761.sofa', 'caabc6641751c186e758e8047125abfc'),
            ('ICO/1m/ICO1m_00763.sofa', '6524475a01c18528e7ad1335b00d29ef'),
            ('ICO/1m/ICO1m_00764.sofa', '512b4c2e99731ca838c49c8d8951137a'),
            ('ICO/1m/ICO1m_00766.sofa', 'ec2b4ed1546867f0739dc9720ead87d7'),
            ('ICO/1m/ICO1m_00767.sofa', 'f08a28d9f20e61bb76434bcc5e8f7560'),
            ('ICO/1m/ICO1m_00768.sofa', '0116e50742f033e8820fa7eb53d2a114'),
            ('ICO/1m/ICO1m_00769.sofa', '042a7a39354a4c57028a66877589c728'),
            ('ICO/1m/ICO1m_00770.sofa', 'a2d407436ae5fc1f649583a4f1d146f7'),
            ('ICO/1m/ICO1m_00771.sofa', '55fef6b1b666dfac1d94c6d6a584d8a1'),
            ('ICO/1m/ICO1m_00772.sofa', 'ac81310b648c600028f9f1443f8f4167'),
            ('ICO/1m/ICO1m_00773.sofa', '12398422b6d8e4f6cf0fd56625d6965d'),
            ('ICO/1m/ICO1m_00774.sofa', '611ad33893311ab43371486de3e9c64a'),
            ('ICO/1m/ICO1m_00775.sofa', 'b02d013d62ae0fed19ed981a6585838c'),
            ('ICO/1m/ICO1m_00778.sofa', 'b1da7f253df25897a1af847358c12564'),
            ('ICO/1m/ICO1m_00779.sofa', '2f4c705a3aa77089d63fb9823d0cf27d'),
            ('ICO/1m/ICO1m_00780.sofa', 'b9bc868d4c9dda8635dd5de8652807b2'),
            ('ICO/1m/ICO1m_00782.sofa', '0244c3c3aa9254130c65d417d955cf8a'),
            ('ICO/1m/ICO1m_00783.sofa', '9a02b3fcd3842cf74ff854bb9e026cdd'),
            ('ICO/1m/ICO1m_00787.sofa', '4670cf05a2088f44517540dc603a9db9'),
            ('ICO/1m/ICO1m_00788.sofa', 'fa69839733e4f66a43b720f13ae6e368'),
            ('ICO/1m/ICO1m_00789.sofa', '976d2b38937a8296b2aa8d84b14c7aac'),
            ('ICO/1m/ICO1m_00791.sofa', '9024534e573b9c8e74e76d2a0c7a61e0'),
            ('ICO/1m/ICO1m_00794.sofa', 'cbd4ed1596f76e940b75a58cdcc16377'),
            ('ICO/1m/ICO1m_00795.sofa', 'f71cd82f7f75c9d60e06c7ce174be078'),
            ('ICO/1m/ICO1m_00797.sofa', 'cefc8265c14ccc3b9b64beadb050ba3f'),
            ('ICO/1m/ICO1m_00798.sofa', 'c6173cae72618eca5a2a61e2add364ea'),
            ('ICO/1m/ICO1m_00799.sofa', 'df253a816ac30891d811b88e4bfef3d9'),
            ('ICO/1m/ICO1m_00800.sofa', '74135c12faf3dab44833b1e5f55c99c0'),
            ('ICO/1m/ICO1m_00801.sofa', '5c1fcc486eca422bcf765577c92b490b'),
            ('ICO/1m/ICO1m_00802.sofa', '382722dc766a85079d29606cd858a0fc'),
            ('ICO/1m/ICO1m_00803.sofa', '3b7154ddce94a765059536cf7323c992'),
            ('ICO/1m/ICO1m_00804.sofa', 'db03cacfc596b43e626bd45dd509982f'),
            ('ICO/1m/ICO1m_00805.sofa', 'db92b6dd38b349311d7b0b1875e40214'),
            ('ICO/1m/ICO1m_00806.sofa', '30c2a969ce0a13874774f27b45855814'),
            ('ICO/1m/ICO1m_00807.sofa', '7b4f7e081bf145feb0a59a5882d289f9'),
            ('ICO/1m/ICO1m_00809.sofa', 'ec3b27f52cb28d5f57aa5373938a1b00'),
            ('ICO/1m/ICO1m_00810.sofa', 'c4dbdc0fb0738b23840640b4db744e2d'),
            ('ICO/1m/ICO1m_00811.sofa', 'c58cfda4cdc86ce298d4de3c3375163c'),
            ('ICO/1m/ICO1m_00812.sofa', '6d92db35b515bdae7ece8fb05d127420'),
            ('ICO/1m/ICO1m_00815.sofa', '0fc6bf66b6e8a993d73a713439adb863'),
            ('ICO/1m/ICO1m_00816.sofa', '2f58f9515985cb2a2bff5d5ce53d434e'),
            ('ICO/1m/ICO1m_00817.sofa', 'e0b61bba834a8898257b0e6f6fb1da2d'),
            ('ICO/1m/ICO1m_00818.sofa', 'd6207243cec06a877271358cf4677b89'),
            ('ICO/1m/ICO1m_00819.sofa', '5b9e10ce0852c5899193b4c9f5394970'),
            ('ICO/1m/ICO1m_00821.sofa', 'c320a1da182da5d4f5965419c082d71f'),
            ('ICO/1m/ICO1m_00822.sofa', '9274271b25645e33c9f6929bd0b629ea'),
            ('ICO/1m/ICO1m_00823.sofa', 'f9a71b4009d78944aed1d04ef7d13d43'),
            ('ICO/1m/ICO1m_00824.sofa', '1b6ca2e518bb1b6221334eeb3b3c50cd'),
            ('ICO/1m/ICO1m_00825.sofa', 'dd4923017eb5335b786243a5887cd745'),
            ('ICO/1m/ICO1m_00826.sofa', 'e10764aada4eb6032c63f79a1f3ebeee'),
            ('ICO/1m/ICO1m_00827.sofa', '5454141105a282873892c80f05aff166'),
            ('ICO/1m/ICO1m_00829.sofa', 'b3b9b22c12a4f01879f3eefb3c3f2c85'),
            ('ICO/1m/ICO1m_00830.sofa', 'd6f839961aaa222b4b4ae691d27f3f1d'),
            ('ICO/1m/ICO1m_00833.sofa', '6e3ade2647c5d8f8dbcee285def12440'),
            ('ICO/1m/ICO1m_00835.sofa', '65da78a7021a675f509fcc08488b282a'),
            ('ICO/1m/ICO1m_00836.sofa', 'ee7b24c5aad47626c218d26678468479'),
            ('ICO/1m/ICO1m_00837.sofa', 'a65a8f69db1d5ac9a5584b3c715adedf'),
            ('ICO/1m/ICO1m_00838.sofa', '3585fd253bea3a51ccf248d42b3eb1f8'),
            ('ICO/1m/ICO1m_00839.sofa', 'b53c2cc6e046824fdc57f7f66a7e756f'),
            ('ICO/1m/ICO1m_00840.sofa', '34ae3084ad5d53ea146df447c7df80b0'),
            ('ICO/1m/ICO1m_00841.sofa', '62a1711a7906f0c32bfa865389d893e3'),
            ('ICO/1m/ICO1m_00842.sofa', 'cff6b645c2c2952f55774d1df84afa9f'),
            ('ICO/1m/ICO1m_00843.sofa', 'e2edac3d925df5fa3efa58acdbafe22b'),
            ('ICO/1m/ICO1m_00844.sofa', '17eedf80ec00b68d8a95e7451cc1fb9f'),
            ('ICO/1m/ICO1m_00845.sofa', '143cff3b7efce48a204f113307a9e81b'),
            ('ICO/1m/ICO1m_00846.sofa', '08d01137ff9bbb52ce9d20cfca36aac0'),
            ('ICO/1m/ICO1m_00850.sofa', '4caebd1646d8ecc43d8a2611a7558513'),
            ('ICO/1m/ICO1m_00852.sofa', '7f727cb5f2ad523420f195e95bd6e2e7'),
            ('ICO/1m/ICO1m_00853.sofa', '004941cc953b21761b1018e04702ae2d'),
            ('ICO/1m/ICO1m_00855.sofa', 'cb555a3eaecba62d5b6acb3ddb56acca'),
            ('ICO/1m/ICO1m_00857.sofa', '6df12bebf024aa7cdfc39ed9c07af53a'),
            ('ICO/1m/ICO1m_00858.sofa', 'bd9e10553613125c875723431e5edd42'),
            ('ICO/1m/ICO1m_00859.sofa', '9ef77ba6bcf14acfbc53bd30006df852'),
            ('ICO/1m/ICO1m_00860.sofa', 'a4ae61ad31264202c898fd08f83360d1'),
            ('ICO/1m/ICO1m_00861.sofa', '173ab33d2a78b8535b292b30ba333e17'),
            ('ICO/1m/ICO1m_00863.sofa', '0aaee50f1ef05611fadf699e2e32879b'),
            ('ICO/1m/ICO1m_00864.sofa', '3f85aac35ef6ba943d46a31e05fbc353'),
            ('ICO/1m/ICO1m_00865.sofa', '188a84e2dc0ce4929bf873f2aed35877'),
            ('ICO/1m/ICO1m_00866.sofa', 'f27e21d7276279868ce615b889eb117b'),
            ('ICO/1m/ICO1m_00867.sofa', 'c40c74e0c2333382f540789517965124'),
            ('ICO/1m/ICO1m_00868.sofa', '0a81a34e5a85eff967392126323b91c2'),
            ('ICO/1m/ICO1m_00869.sofa', '6601979cb307652adbc79009a093b18c'),
            ('ICO/1m/ICO1m_00870.sofa', '3df01c690d7e18036f1ede491fe43c2c'),
            ('ICO/1m/ICO1m_00872.sofa', '0077a1f1d73b4e13a4a53aac8a03b2aa'),
            ('ICO/1m/ICO1m_00875.sofa', '190bd5dbba4e94af7fff4b812a19b66d'),
            ('ICO/1m/ICO1m_00877.sofa', '516551445febaec8d60addab21562c3a'),
            ('ICO/1m/ICO1m_00880.sofa', 'ee9a34f67133de985ece9c58ce904dd2'),
            ('ICO/1m/ICO1m_00882.sofa', 'ec7a5186addfa7c2792206246e93b6ae'),
            ('ICO/1m/ICO1m_00883.sofa', 'f19cb29521dc6b7560a19a8062cd3a1d'),
            ('ICO/1m/ICO1m_00884.sofa', '700580a27c509c41d6712fc732489bbf'),
            ('ICO/1m/ICO1m_00887.sofa', 'ecae21069c958db015ee1cc1a7df6652'),
            ('ICO/1m/ICO1m_00889.sofa', 'ebc27674b6e3bc7670620ca1f388778f'),
            ('ICO/1m/ICO1m_00890.sofa', 'bcc01e889afe66e49f5860fee3445552'),
            ('ICO/1m/ICO1m_00891.sofa', '668ff91f473328cef13d7372c13dc6d3'),
            ('ICO/1m/ICO1m_00892.sofa', 'ac7a3bdd75101e9505c48b4e9b6cd7e2'),
            ('ICO/1m/ICO1m_00893.sofa', '3fbd7da5aa83ad14a32b91f48bbe0f4d'),
            ('ICO/1m/ICO1m_00894.sofa', '694d20b358e10f26a7c213cc11bdeb37'),
            ('ICO/1m/ICO1m_00895.sofa', '08a5c8d3af0d929008ba0789a64c84ea'),
            ('ICO/1m/ICO1m_00896.sofa', '23f62b5b45b00a011390a528f50b42c4'),
            ('ICO/1m/ICO1m_00897.sofa', '5f7eea0f2ace7dd9bb6a904df1116b03'),
            ('ICO/1m/ICO1m_00898.sofa', '00147cd324d214b86eb8b62f6131318c'),
            ('ICO/1m/ICO1m_00899.sofa', '8549248df84ff993cfd35027e5cb9147'),
            ('ICO/1m/ICO1m_00900.sofa', '2ee348ecfffc0c884a07430bdd1c6ea3'),
            ('ICO/1m/ICO1m_00901.sofa', 'a47a81a9084611ce336422963828ea0e'),
            ('ICO/1m/ICO1m_00902.sofa', '5d211c0d0bdd6e9b954091b18e77fa25'),
            ('ICO/1m/ICO1m_00903.sofa', '4889a4cc51610af6cb4d300eb4655fb7'),
            ('ICO/1m/ICO1m_00904.sofa', '615e15a56e89e0f6761059d6dc01e111'),
            ('ICO/1m/ICO1m_00906.sofa', 'e24126fe917738af5f1d55f3d0045d97'),
            ('ICO/1m/ICO1m_00907.sofa', '4268b8d1f50912ef34207ee642366806'),
            ('ICO/1m/ICO1m_00908.sofa', '394c7f50192e20d65e22e027f5ff4cb2'),
            ('ICO/1m/ICO1m_00910.sofa', '62b96724e70157014babaa114995794e'),
            ('ICO/1m/ICO1m_00911.sofa', '5eed3fe0c0833055c6acb0bbfb91db21'),
            ('ICO/1m/ICO1m_00913.sofa', '0a48a0d4a3c0392bfa6181cd308f71e9'),
            ('ICO/1m/ICO1m_00915.sofa', '0ae56b37dcfcd28ed3f8b9df54555769'),
            ('ICO/1m/ICO1m_00918.sofa', 'e5d16380240303478322691f3c6adaa3'),
            ('ICO/1m/ICO1m_00919.sofa', '101a6d7a6a1a729be2e2480ddf90f27c'),
            ('ICO/1m/ICO1m_00920.sofa', '1ab904a679919114d52ca30fd2301281'),
            ('ICO/1m/ICO1m_00921.sofa', '5090728b6d485f32093711514b8bab75'),
            ('ICO/1m/ICO1m_00923.sofa', 'e105f71ae0c27cb38c9d995889ab2d6f'),
            ('ICO/1m/ICO1m_00924.sofa', '7860af14b8fa12c3c9a0d28233f3733f'),
            ('ICO/1m/ICO1m_00925.sofa', '2978e66953ca13591a2b0f1ecd265e61'),
            ('ICO/1m/ICO1m_00926.sofa', '6e7ec1dae71a509ac2d98c896614e51c'),
            ('ICO/1m/ICO1m_00927.sofa', '8e42fa3d64e95d20f1caa30455c40159'),
            ('ICO/1m/ICO1m_00929.sofa', '0c3bf5c10c2256b7936c2e0b0b99281f'),
            ('ICO/1m/ICO1m_00930.sofa', '5dd0fcb1007fdccd17cf19c31d80f891'),
            ('ICO/1m/ICO1m_00931.sofa', 'c3ec748783e02138d911c721a1270347'),
            ('ICO/1m/ICO1m_00932.sofa', 'a4b7bba05b2c9a910db2f70a03b248c5'),
            ('ICO/1m/ICO1m_00934.sofa', 'ac6b9c7b5d48c9f7faeec89d2435649e'),
            ('ICO/1m/ICO1m_00936.sofa', '1a46b7073a88e1e4de5a0cfce1436b6a'),
            ('ICO/1m/ICO1m_00937.sofa', 'ae81d482e8f8b4808c1b4da7a9a3b5ec'),
            ('ICO/1m/ICO1m_00939.sofa', 'd68f85797f4f531a617ddf44e2ce70b2'),
            ('ICO/1m/ICO1m_00940.sofa', '63bada47457ba4d39e96ebe6da303348'),
            ('ICO/1m/ICO1m_00942.sofa', '7ccaf211014ed01f314918e982a6dd43'),
            ('ICO/1m/ICO1m_00944.sofa', 'cff9032e42d7b84b23bbc132b298ab1e'),
            ('ICO/1m/ICO1m_00946.sofa', '18701b9909c3ace09b2c854b29d9c54f'),
            ('ICO/1m/ICO1m_00947.sofa', '1de3045b642c43bd4180c901bc099a58'),
            ('ICO/1m/ICO1m_00951.sofa', '4273d5b1f7b8027304d889e2ad30f0d2'),
            ('ICO/1m/ICO1m_00952.sofa', 'd9eec703c317ee614e564450b1b3010c'),
            ('ICO/1m/ICO1m_00953.sofa', 'b2515e433197e4a5cf1df2949a4013b8'),
            ('ICO/1m/ICO1m_00954.sofa', 'a6e4b152de38c3528691aa606c95d2ad'),
            ('ICO/1m/ICO1m_00955.sofa', '3a1f83e2b3b4aa5c93a97cf25fe93e55'),
            ('ICO/1m/ICO1m_00956.sofa', '3544b1130417912e7054d52d2876656c'),
            ('ICO/1m/ICO1m_00961.sofa', 'e6f3b4c946033ba2357ae0e1ac1124f6'),
            ('ICO/1m/ICO1m_00962.sofa', '07bbcdfae324dcc41d570d2ea55898a4'),
            ('ICO/1m/ICO1m_00963.sofa', '1728235225ec32ccec37de28febf8b00'),
            ('ICO/1m/ICO1m_00965.sofa', '8475773c0937fedbfb5e03279dea4814'),
            ('ICO/1m/ICO1m_00966.sofa', '227452e10ca3b8011bcc1a4a62044404'),
            ('ICO/1m/ICO1m_00967.sofa', '442b2076f1c2cb49eebed6bf1252a4e7'),
            ('ICO/1m/ICO1m_00968.sofa', '1e4680dc69a098564d52b95eb3fe1e10'),
            ('ICO/1m/ICO1m_00969.sofa', '95d0998fdd2d9cc452231422ff8cabfb'),
            ('ICO/1m/ICO1m_00971.sofa', '534a93ce8c086febbd8ebd14b7ffb862'),
            ('ICO/1m/ICO1m_00972.sofa', '3d6b1c48fd2dd36c2a5d39eb219ce603'),
            ('ICO/1m/ICO1m_00973.sofa', '2aab093bf39511c1a35881f4c9e0fdae'),
            ('ICO/1m/ICO1m_00975.sofa', '99ebfa8d10515f2629dc55d71216f4c2'),
            ('ICO/1m/ICO1m_00976.sofa', '792917460e1c82a24b5e34725f4124a7'),
            ('ICO/1m/ICO1m_00977.sofa', '76249bce01179787224e5daa65c43a84'),
            ('ICO/1m/ICO1m_00978.sofa', 'bee40f10855c02465b83fa672c699743'),
            ('ICO/1m/ICO1m_00979.sofa', '3c0ad3fec99dcf489a996e8de1f6635d'),
            ('ICO/1m/ICO1m_00980.sofa', '03159f7d568d6e31a426d6529263b4da'),
            ('ICO/1m/ICO1m_00981.sofa', 'f033fe7de36faf6052ecb3370f941298'),
            ('ICO/1m/ICO1m_00982.sofa', '86224b6d431e0b34b2ba04b2aeb22927'),
            ('ICO/1m/ICO1m_00984.sofa', 'bda918c6088085d140987b7bf1dcdd99'),
            ('ICO/1m/ICO1m_00985.sofa', 'dbfaa4aff30a796b05ae179b261c4c3c'),
            ('ICO/1m/ICO1m_00986.sofa', 'bd6250e125117d50f2623d914d50623d'),
            ('ICO/1m/ICO1m_00987.sofa', '11d66c0ce8d964eed70612eb223168b7'),
            ('ICO/1m/ICO1m_00991.sofa', 'e37c16c8a914786b64b2c6ef1f9c886c'),
            ('ICO/1m/ICO1m_00993.sofa', '3933467e75b6908ee7d80f2feed19f3c'),
            ('ICO/1m/ICO1m_00995.sofa', '1c4eb43c53867cc1dbb0d59ddf719e93'),
            ('ICO/1m/ICO1m_00996.sofa', '666fa3b8b830d497b57de1c2666c3bc7'),
            ('ICO/1m/ICO1m_00997.sofa', '466953094570143f0f5237419e42fed4'),
            ('ICO/1m/ICO1m_00998.sofa', 'f9f17edd8ecf18747c6270ef81cfce92'),
            ('ICO/1m/ICO1m_00999.sofa', 'fc2aadf9c59a1f9ab39a0d9969428727'),
            ('ICO/1m/ICO1m_01000.sofa', '31a297f5a5e25198fab066199a196a43'),
            ('ICO/1m/ICO1m_01002.sofa', '535faedbb1ce822c85fd357ef6df7b3d'),
            ('ICO/1m/ICO1m_01003.sofa', '94f3e57d0f1da0d34df86e133a9e44de'),
            ('ICO/1m/ICO1m_01004.sofa', '3928de9194375dcc62e3e61f671ea9f4'),
            ('ICO/1m/ICO1m_01005.sofa', 'd21dc41e4455e8f42c13715cc6e5ad9b'),
            ('ICO/1m/ICO1m_01006.sofa', 'abf5aad710d24dc8fcba18fd34f24305'),
            ('ICO/1m/ICO1m_01008.sofa', 'b9b8ad16b336b8fd2b9a7cc591f4f21e'),
            ('ICO/1m/ICO1m_01009.sofa', 'c0da52e87556600262dfcc80bccf807f'),
            ('ICO/1m/ICO1m_01010.sofa', '72769d37cf9b39a75a08d45fe62a40ce'),
            ('ICO/1m/ICO1m_01011.sofa', 'a5ecbdacd1803ff08869e988ae077101'),
            ('ICO/1m/ICO1m_01012.sofa', '62a7fd745b2730dc7c6785da625ed324'),
            ('ICO/1m/ICO1m_01013.sofa', 'e97d568818715c280f08fe2da0630cb6'),
            ('ICO/1m/ICO1m_01016.sofa', '8ed3b39baf69c670b09e10bffe90d3a1'),
            ('ICO/1m/ICO1m_01017.sofa', '68bd7164d3eea241d97223a8870fc6dc'),
            ('ICO/1m/ICO1m_01018.sofa', 'ed7b71acac968c08cf618186cc068bd2'),
            ('ICO/1m/ICO1m_01019.sofa', 'f893db5ea5e98b006f1867430f8be858'),
            ('ICO/1m/ICO1m_01020.sofa', '50b3611e8be416ff910184a2da0549e2'),
            ('ICO/1m/ICO1m_01022.sofa', '130bb85721f50ce7f0d709aadcb4591c'),
            ('ICO/1m/ICO1m_01024.sofa', '37fdb7a016b22151e42a2dee14a9a7d1'),
            ('ICO/1m/ICO1m_01027.sofa', '07c0e725ca5a3ddf6a36896a3dcd992c'),
            ('ICO/1m/ICO1m_01028.sofa', '174cb7ae7b35dad3d7d1e3ec55e33484'),
            ('ICO/1m/ICO1m_01030.sofa', '9dc6ea37ce638b9ae1cb1267fd6f2a9e'),
            ('ICO/1m/ICO1m_01031.sofa', '5b984722ad3620ecf6c5e89685bc1af1'),
            ('ICO/1m/ICO1m_01032.sofa', '433e015d6eba8977d6cfb8c9ad795a27'),
            ('ICO/1m/ICO1m_01033.sofa', '29317b027b05d9b9441e673b70c82c60'),
            ('ICO/1m/ICO1m_01035.sofa', '636140554b5ca8b1c5d53e858712a4d9'),
            ('ICO/1m/ICO1m_01036.sofa', 'ab80a4cd5551a86b2d9e5bef6f5a9855'),
            ('ICO/1m/ICO1m_01037.sofa', 'e178cd5b6946ca84a2e2663a45a9edfc'),
            ('ICO/1m/ICO1m_01038.sofa', '7f908bfe1db8026439b76ac57fa071b3'),
            ('ICO/1m/ICO1m_01039.sofa', '97f41bedabed78dda32de2bc3f17a3ef'),
            ('ICO/1m/ICO1m_01040.sofa', 'f8b3a561e505f5a8b496dacf35aaeba1'),
            ('ICO/1m/ICO1m_01042.sofa', '856f3b63b00abf5f0504be4dd83d7b87'),
            ('ICO/1m/ICO1m_01044.sofa', '37fa327ffff27208a9056b01994e5975'),
            ('ICO/1m/ICO1m_01046.sofa', 'b0515f3348f52af84bcdb73ef248f6d9'),
            ('ICO/1m/ICO1m_01047.sofa', 'de17aba12cc9b16fead7eaae24a7dde6'),
            ('ICO/1m/ICO1m_01048.sofa', 'a83a095eac8600e19556bd3476b4bf6d'),
            ('ICO/1m/ICO1m_01049.sofa', '064069dff8139e9ae9dfee641b35c3c6'),
            ('ICO/1m/ICO1m_01050.sofa', '8c4f7b38e8358593ff39cae78c4d08a9'),
            ('ICO/1m/ICO1m_01052.sofa', '6ebb1347d07dc97cee70deb7cdfc86b5'),
            ('ICO/1m/ICO1m_01053.sofa', '7c9cfff060f5e6dc8d10b959edf2cdbf'),
            ('ICO/1m/ICO1m_01055.sofa', '27f4adfa49911c0208c9ee6dae3023dd'),
            ('ICO/1m/ICO1m_01057.sofa', '350a12ad340fce51dbbfd5f08a9bd552'),
            ('ICO/1m/ICO1m_01058.sofa', '110b4cb85f2ec6ba806471ba932d9ef7'),
            ('ICO/1m/ICO1m_01060.sofa', 'f1aad6680a477298fee8358985b26088'),
            ('ICO/1m/ICO1m_01061.sofa', 'f312f8004cbe1a385a02d771f4a75bb0'),
            ('ICO/1m/ICO1m_01062.sofa', '5304794b5bd431f7a0db5c39cc37a4ce'),
            ('ICO/1m/ICO1m_01063.sofa', '0eec1b9e92dff98476f9d2343ec67082'),
            ('ICO/1m/ICO1m_01064.sofa', '68acbe1d688f9d105a499a30748b193c'),
            ('ICO/1m/ICO1m_01065.sofa', '78f7fec4e11d6883254625b9c3d28c8d'),
            ('ICO/1m/ICO1m_01066.sofa', '58dc2d0d96b3bf34663e5cb70cd7aea1'),
            ('ICO/1m/ICO1m_01067.sofa', '378c8ea8c36cff0f5605750e370a1012'),
            ('ICO/1m/ICO1m_01069.sofa', 'e382137c38313ba103b36698c15a8172'),
            ('ICO/1m/ICO1m_01071.sofa', 'c55f4195897b66b309e1c24db6ef7421'),
            ('ICO/1m/ICO1m_01073.sofa', 'b51c6678f623c01c4dec85f047223b1f'),
            ('ICO/1m/ICO1m_01075.sofa', '398eda120eb2fd4741a1d3850966bc7d'),
            ('ICO/1m/ICO1m_01077.sofa', 'd4ee8aab266b3c935d22b200a4bc43b7'),
            ('ICO/1m/ICO1m_01078.sofa', '30271f3099aa82ad6c1577cd54fca95b'),
            ('ICO/1m/ICO1m_01079.sofa', '3b016538cdd17a6b4699b500bf0c0742'),
            ('ICO/1m/ICO1m_01080.sofa', 'dafdc6264120445cfe05fb2431dd4ad8'),
            ('ICO/1m/ICO1m_01082.sofa', '002e92e04becf6c438875982279f0a99'),
            ('ICO/1m/ICO1m_01083.sofa', 'c5482d570e8fd635a457ae930475fa20'),
            ('ICO/1m/ICO1m_01085.sofa', '153c7b7b7d6ac9350aa17b82247aa432'),
            ('ICO/1m/ICO1m_01086.sofa', '11d88975f53d7f573b882ad0a7b5da7e'),
            ('ICO/1m/ICO1m_01087.sofa', '33067cd9c3210d37d38f47c2b08ccd62'),
            ('ICO/1m/ICO1m_01088.sofa', 'b86a67a558d20cf0f1d7807bfc68fd93'),
            ('ICO/1m/ICO1m_01089.sofa', 'f683956654cd68dc674073f1ddb70f91'),
            ('ICO/1m/ICO1m_01091.sofa', '64b457bd9efe8a0192bbc18f218d408b'),
            ('ICO/1m/ICO1m_01092.sofa', '7c51fa245aebc7a76ad136409adfb9db'),
            ('ICO/1m/ICO1m_01093.sofa', 'cc3c155695963cc3d6071079052d2da7'),
            ('ICO/1m/ICO1m_01094.sofa', '4f99f1b02cd97dfec924f15ecbc14a63'),
            ('ICO/1m/ICO1m_01097.sofa', '839b5f70ae875aaabc67d13e0ca66dab'),
            ('ICO/1m/ICO1m_01099.sofa', '3b280bf07a177fdcdf9a69055eb0937b'),
            ('ICO/1m/ICO1m_01100.sofa', '5a68915723a3648bcd483b8fb4810d83'),
            ('ICO/1m/ICO1m_01101.sofa', '3a097c2d12472fe6ff4a214dde423ad2'),
            ('ICO/1m/ICO1m_01102.sofa', '24f7f141452d4810d53c2cd612ff4f29'),
            ('ICO/1m/ICO1m_01103.sofa', '1ce374de7f33032ab6a6b77adb7b467b'),
            ('ICO/1m/ICO1m_01104.sofa', 'e6c2646d9cd40993fb1304a99551ae08'),
            ('ICO/1m/ICO1m_01107.sofa', '3522ee841add7fe973286d5e82384c64'),
            ('ICO/1m/ICO1m_01108.sofa', 'cd3f6d414743016d6de53de332e41004'),
            ('ICO/1m/ICO1m_01109.sofa', 'beffdcadaa109fb9a61f42ffaeebb905'),
            ('ICO/1m/ICO1m_01111.sofa', '7920b55cd6620832f41777ba16d97bc8'),
            ('ICO/1m/ICO1m_01112.sofa', '6c8def7ad1d1d8c6353abb62a4db9f06'),
            ('ICO/1m/ICO1m_01114.sofa', '72157f39e6a0b04c658b7173bc692fcb'),
            ('ICO/1m/ICO1m_01115.sofa', 'f450ddda67e7465187c52b831e42f12a'),
            ('ICO/1m/ICO1m_01116.sofa', '1450e76f2ec99b02cf6b417fd03696e5'),
            ('ICO/1m/ICO1m_01117.sofa', 'ee26c48a2d7664c429b504b9c3f102b0'),
            ('ICO/1m/ICO1m_01120.sofa', '663a1e52f94d10a44c6642f6cd21fad8'),
            ('ICO/1m/ICO1m_01121.sofa', '71414569a2df74ce236f2f336730a75c'),
            ('ICO/1m/ICO1m_01122.sofa', '71e98e96d30fab7a0b5e1adccb61a755'),
            ('ICO/1m/ICO1m_01125.sofa', '557ff2df39da54b680c0bdf0ff75671a'),
            ('ICO/1m/ICO1m_01127.sofa', 'f97b39464260c165c3fd3dac1e041c88'),
            ('ICO/1m/ICO1m_01128.sofa', '193a73ac5aba9f24ef0daa089de0210f'),
            ('ICO/1m/ICO1m_01129.sofa', '8596f0874ebe03cd9cb5546c3846ad2c'),
            ('ICO/1m/ICO1m_01130.sofa', 'b2fee6151d7c4a287b39ae60d1f8a937'),
            ('ICO/1m/ICO1m_01131.sofa', '74ce4706d450138f8ee1b88f9c40d477'),
            ('ICO/1m/ICO1m_01132.sofa', '42e0a03ebe9433c7871b81430c556612'),
            ('ICO/1m/ICO1m_01134.sofa', '673f52891c05f3e21afecaa2b09357d9'),
            ('ICO/1m/ICO1m_01135.sofa', '89736ebeed02933cfb71a55c2c24b0c6'),
            ('ICO/1m/ICO1m_01136.sofa', 'a9499559ee99582944716eeada441434'),
            ('ICO/1m/ICO1m_01137.sofa', 'f7533043315f1e539add1c8d8b969dc0'),
            ('ICO/1m/ICO1m_01139.sofa', '8807c8775db43b125f673bca5b52248b'),
            ('ICO/1m/ICO1m_01140.sofa', '81e7e6c371fffee119a627c5aa70276e'),
            ('ICO/1m/ICO1m_01141.sofa', '66db45914b46ca161da8b612070ef021'),
            ('ICO/1m/ICO1m_01142.sofa', 'ef21a7dc689e6a903722af8e57a912d1'),
            ('ICO/1m/ICO1m_01143.sofa', 'cc04c0e3d0b3068e7e887e37c2afc5dd'),
            ('ICO/1m/ICO1m_01144.sofa', '0f33a67ff8aad5bf80df05d9445fe430'),
            ('ICO/1m/ICO1m_01145.sofa', '27370c0a46434437c62354f502cf8a4f'),
            ('ICO/1m/ICO1m_01146.sofa', 'c7ccb6ada5bf91d3b089e4c4b2b8c24b'),
            ('ICO/1m/ICO1m_01147.sofa', '25662dfa45a254eac84cd80031baa7f7'),
            ('ICO/1m/ICO1m_01148.sofa', 'bc755a8fd7de4483347ea093f7fa6808'),
            ('ICO/1m/ICO1m_01149.sofa', 'f5c454f0e8cbd40f27aef7e537b8556d'),
            ('ICO/1m/ICO1m_01150.sofa', 'd74fdf1ab123d0cf31ec9cdb30b81f0f'),
            ('ICO/1m/ICO1m_01151.sofa', 'c9c89cf03476e79ca47deee900656b69'),
            ('ICO/1m/ICO1m_01152.sofa', '9a22a7e0d50db22de33690ff9bc263cd'),
            ('ICO/1m/ICO1m_01155.sofa', 'b704f3ab4f1a1573779abbc1e3dfc150'),
            ('ICO/1m/ICO1m_01157.sofa', 'b064b25816f2ac02e984d88d7b85717b'),
            ('ICO/1m/ICO1m_01160.sofa', '654036309cf12cb35c5c236271e7d95e'),
            ('ICO/1m/ICO1m_01162.sofa', 'e9d9954fb57d3390fab0971a0b8bdb29'),
            ('ICO/1m/ICO1m_01163.sofa', 'bd807f70d8b62aeb6ba7e6cd996646a3'),
            ('ICO/1m/ICO1m_01164.sofa', 'b33013d94f9767b166186d3604f9c2ee'),
            ('ICO/1m/ICO1m_01165.sofa', '454e48cddf3a8084f86c4c98e98f52b4'),
            ('ICO/1m/ICO1m_01166.sofa', 'b32929620be981caf01e35fce59a8a9a'),
            ('ICO/1m/ICO1m_01168.sofa', 'd2f8e45fbedf824454aa5378842c7c7d'),
            ('ICO/1m/ICO1m_01171.sofa', 'e91a38b55bd6100ef25ccdf9a5cd0ed2'),
            ('ICO/1m/ICO1m_01172.sofa', 'f2325c2043155176a2dc87dc87a0cc54'),
            ('ICO/1m/ICO1m_01173.sofa', 'b6fc072d43d4d5ca0b46aada578fb5cc'),
            ('ICO/1m/ICO1m_01174.sofa', 'd56cfe0e822e3fbc479024b3c3b5754c'),
            ('ICO/1m/ICO1m_01175.sofa', '22c3e9c55c569573bc05b99b703a62fb'),
            ('ICO/1m/ICO1m_01176.sofa', '64d0061547cf8fcfd1d5125b4fbbe01d'),
            ('ICO/1m/ICO1m_01177.sofa', '57dd3a7fad00637412e21f00c0a5cd66'),
            ('ICO/1m/ICO1m_01179.sofa', 'f388599f8b81f69ba65606e51e641005'),
            ('ICO/1m/ICO1m_01181.sofa', 'c39eef295257e42e65793c0463538e9f'),
            ('ICO/1m/ICO1m_01185.sofa', 'b0e8f0e625ec6ed3f63d15168964330a'),
            ('ICO/1m/ICO1m_01186.sofa', '73059e8612cdec3798f1533fc319fbc1'),
            ('ICO/1m/ICO1m_01189.sofa', '9b78e74ce952b6e8dce3012a9d02f10b'),
            ('ICO/1m/ICO1m_01190.sofa', '8ee27ee7efe18c97492215514edabc4f'),
            ('ICO/1m/ICO1m_01191.sofa', 'a8e14b29ad61b6283c5be696c024f9d9'),
            ('ICO/1m/ICO1m_01192.sofa', '010172cd9f2a448841483ee77a6392a9'),
            ('ICO/1m/ICO1m_01193.sofa', '3b97641ca2642d9e645878c20d1fdb4d'),
            ('ICO/1m/ICO1m_01194.sofa', 'f4b17546eba7f067d53b31cd54ab2310'),
            ('ICO/1m/ICO1m_01195.sofa', '277853fdccb39d08dbfbaacec0e16d5e'),
            ('ICO/1m/ICO1m_01196.sofa', '7c3578418605453c1daf47630d65aa53'),
            ('ICO/1m/ICO1m_01197.sofa', '0e50d2ddcb6b72015b727534eaf6f1d3'),
            ('ICO/1m/ICO1m_01200.sofa', 'f79ff0dc8e9918d0280170b03db33967'),
            ('ICO/1m/ICO1m_01201.sofa', 'f60f8bad7aa86cf01ea848ac712de856'),
            ('ICO/1m/ICO1m_01202.sofa', '7a60069fdecd9d6bcedb119fa9e12685'),
            ('ICO/1m/ICO1m_01203.sofa', '0a71ef076b0efb8a2f8cfd3994e7c5fb'),
            ('ICO/1m/ICO1m_01205.sofa', 'd7153ee75a459434e12657af31c8278b'),
            ('ICO/1m/ICO1m_01206.sofa', 'd41bf869652c43d62a6b9dd38650dc13'),
            ('ICO/1m/ICO1m_01207.sofa', 'cc37c30785bc086641d805e1208d86e5'),
            ('ICO/1m/ICO1m_01208.sofa', '59774434fb863d1ad9063cac53c9a1d6'),
            ('ICO/1m/ICO1m_01209.sofa', 'ad5e7828eb540a4b3ef3c96b9d7eabdf'),
            ('ICO/1m/ICO1m_01210.sofa', '27e5d80e5421d3122be5473bdadab42c'),
            ('ICO/1m/ICO1m_01211.sofa', '79868266f09d24c5217b02dfc5dd3e55'),
            ('ICO/1m/ICO1m_01212.sofa', 'e82a9ea7e5d845b8613015e71e933e15'),
            ('ICO/1m/ICO1m_01213.sofa', 'f14718150c2e514ec3691b6b6db6ad6c'),
            ('ICO/1m/ICO1m_01215.sofa', '3617c1642f5234ec5694d9652b6c419c'),
            ('ICO/1m/ICO1m_01216.sofa', '6468e15818938570caa2798e76563ce6'),
            ('ICO/1m/ICO1m_01217.sofa', '30c8d6f2491130942eda3b3f0b99f6d9'),
            ('ICO/1m/ICO1m_01219.sofa', 'b20d0c0fd1a53990d02f5ba02d8db561'),
            ('ICO/1m/ICO1m_01221.sofa', 'b23bc56e7c55a49f0396bc7d40a9f1df'),
            ('ICO/1m/ICO1m_01222.sofa', 'b6d91e9d6e6a3e85b6aa294e2037d7b6'),
            ('ICO/1m/ICO1m_01223.sofa', 'a13bef00c6422ce02e5ef2e8bd6f962a'),
            ('ICO/1m/ICO1m_01224.sofa', 'c109791bbafccb4b7c86a0f21ec07037'),
            ('ICO/1m/ICO1m_01225.sofa', 'd2c0c49bd69963c0c9ecc85c4e50992e'),
            ('ICO/1m/ICO1m_01228.sofa', '9d5b6002402e66aef80f59cf64b09ceb'),
            ('ICO/1m/ICO1m_01230.sofa', 'd9e9cdf40432a3705843f13a795c6625'),
            ('ICO/1m/ICO1m_01231.sofa', '733ff41242c9759752e9f92e69f817fd'),
            ('ICO/1m/ICO1m_01232.sofa', 'b206d12df96af3bff66fdf6bca159e1c'),
            ('ICO/1m/ICO1m_01233.sofa', '9944b1897f75b68d234afb7a17e1ff60'),
            ('ICO/1m/ICO1m_01234.sofa', '0916aa618324e5be05ed9c3df93949cf'),
            ('ICO/1m/ICO1m_01235.sofa', 'abfa2fcc4df513a4caeecf3ee54c3288'),
            ('ICO/1m/ICO1m_01237.sofa', '45efb8c63301d3609fe34672e88cded2'),
            ('ICO/1m/ICO1m_01238.sofa', 'e99c0fd97bf596a149ed8a32b6eb8756'),
            ('ICO/1m/ICO1m_01239.sofa', '9b2810ea538e426687baa2385e058871'),
            ('ICO/1m/ICO1m_01240.sofa', '31ef2d9fc4417f87f60659bf547ae145'),
            ('ICO/1m/ICO1m_01242.sofa', '068fe00c4e4a57949cd5ce5352ee18ba'),
            ('ICO/1m/ICO1m_01244.sofa', 'd2463e9c93a29e0cad00b1bf88a2e31a'),
            ('ICO/1m/ICO1m_01245.sofa', 'a7fb0ad871e1f8b804862f015ae08b45'),
            ('ICO/1m/ICO1m_01248.sofa', 'c9cffd85a159a3b667de33518dcca20b'),
            ('ICO/1m/ICO1m_01251.sofa', '5c8a7a23f003e3e0ae0a21eb476a31a3'),
            ('ICO/1m/ICO1m_01252.sofa', '4873fc28c207d0190e691e37f1be26e7'),
            ('ICO/1m/ICO1m_01254.sofa', '689397c77573ac5344c3e2a26bffeb1b'),
            ('ICO/1m/ICO1m_01256.sofa', '527c1111a7713250140b06ecc36c5fa1'),
            ('ICO/1m/ICO1m_01258.sofa', '5d6f0586db8560e582d6f79b8f3ad3f2'),
            ('ICO/1m/ICO1m_01259.sofa', 'ee256ba2272bf69422fdfe27df03d594'),
            ('ICO/1m/ICO1m_01262.sofa', '65c2f0ea127e5d1b897409214fc9d8f8'),
            ('ICO/1m/ICO1m_01263.sofa', 'd5e7907fd50918f6f1816df8248f035b'),
            ('ICO/1m/ICO1m_01264.sofa', 'ba260f96ebb815caf4fcfebd30b77c5a'),
            ('ICO/1m/ICO1m_01265.sofa', '7cebf19a1574bb61eb5e5443cb044c90'),
            ('ICO/1m/ICO1m_01266.sofa', 'b769208cfdb47ccdcebf5fd7bdb28ef5'),
            ('ICO/1m/ICO1m_01268.sofa', '4c0e7cddf22250d2698b96c8ef7435c7'),
            ('ICO/1m/ICO1m_01270.sofa', '525fc0e719fc9c16e562828953488ea1'),
            ('ICO/1m/ICO1m_01271.sofa', 'e78533d0b175ebdf65af3f25addfe664'),
            ('ICO/1m/ICO1m_01272.sofa', '519283fb0a96ffc68d0303507f60bb13'),
            ('ICO/1m/ICO1m_01273.sofa', '93060e10a2e63e7fd3bce14e4aaa7270'),
            ('ICO/1m/ICO1m_01274.sofa', '7d5bcef5e465c6b08c0dfcbc3c514d4c'),
            ('ICO/1m/ICO1m_01275.sofa', '71d1eab5cac64e8978517a22befe1660'),
            ('ICO/1m/ICO1m_01276.sofa', '48392cb1a32fb5b222f7211df5e6021d'),
            ('ICO/1m/ICO1m_01277.sofa', '8d138ea4b0589f86efe92325c7dd0837'),
            ('ICO/1m/ICO1m_01278.sofa', '725084afda88be796121d90a8bc6cfac'),
            ('ICO/1m/ICO1m_01279.sofa', 'e90586861ec2c42f0b4c8a85a2c29edf'),
            ('ICO/1m/ICO1m_01280.sofa', '8045ab25307ec79b0a08cb0b14e3bf9b'),
            ('ICO/1m/ICO1m_01282.sofa', 'acc3b5fb7faa1250746f8ff73e9d7a6c'),
            ('ICO/1m/ICO1m_01284.sofa', 'e19938f8cf18f3a9843f1286f5b60f9a'),
            ('ICO/1m/ICO1m_01286.sofa', 'eb48f96d8f3f60d292785e1382b32523'),
            ('ICO/1m/ICO1m_01288.sofa', '56cfb9522e0f332e77ff66d026ea732a'),
            ('ICO/1m/ICO1m_01290.sofa', '3612b268ecf513f3341f3774f4b929f9'),
            ('ICO/1m/ICO1m_01291.sofa', '320b6aad0c0c1dc76cc7c04108baff8c'),
            ('ICO/1m/ICO1m_01292.sofa', 'ee6b640c1ea3eedc39bd65aa8c00f481'),
            ('ICO/1m/ICO1m_01293.sofa', '868704209525a90cc76dbee55160cd68'),
            ('ICO/1m/ICO1m_01294.sofa', '48bace9570ce77cd783b22cf95f473ad'),
            ('ICO/1m/ICO1m_01295.sofa', 'ab7671583f5d585159e7c3ae4f3377c0'),
            ('ICO/1m/ICO1m_01296.sofa', '1c37eed69a87ba0856bca0c35a753947'),
            ('ICO/1m/ICO1m_01298.sofa', 'f6a9bd3cd23007fc7c4afd160c26e126'),
            ('ICO/1m/ICO1m_01299.sofa', '4eaa7079288b39c41024ef612178ffef'),
            ('ICO/1m/ICO1m_01301.sofa', 'fa5c00705346741469e3a0afe48701af'),
            ('ICO/1m/ICO1m_01302.sofa', 'c2205ca183f3b7f93470220f89c85712'),
            ('ICO/1m/ICO1m_01303.sofa', '6508a20fce974efdf8f3801cb0d12ef6'),
            ('ICO/1m/ICO1m_01304.sofa', '2110b7e56f6f1eebb5264f981caf03f6'),
            ('ICO/1m/ICO1m_01305.sofa', 'adc11551fbea7881c45a37013882e4d9'),
            ('ICO/1m/ICO1m_01308.sofa', '0fbf705e5073fbe4b3325043b38d813c'),
            ('ICO/1m/ICO1m_01309.sofa', 'dabd937ad4bfe88077d950f4bb2e55e9'),
            ('ICO/1m/ICO1m_01310.sofa', 'd9e67daf65426edb38360f14cc8de379'),
            ('ICO/1m/ICO1m_01311.sofa', '7126a8bb1144a1ca0a0fb0b22876f608'),
            ('ICO/1m/ICO1m_01312.sofa', 'aea0481f5e115497fc8721a5b713029b'),
            ('ICO/1m/ICO1m_01313.sofa', 'ea588447f1993dae4e8718b1e65d7c16'),
            ('ICO/1m/ICO1m_01315.sofa', '03b66ef0276b0e0b5deb7fcf2e60bf81'),
            ('ICO/1m/ICO1m_01317.sofa', '074716fa1a946a918f53282766d29876'),
            ('ICO/1m/ICO1m_01318.sofa', 'bc25ae0bbb4ab8610e025d7b25c7cecf'),
            ('ICO/1m/ICO1m_01319.sofa', '80dc18850afebc81c94d18ab5be2ef7a'),
            ('ICO/1m/ICO1m_01320.sofa', '94b1e12ff933bc32cb4930518d3e4f91'),
            ('ICO/1m/ICO1m_01321.sofa', '0cf7ead8438a0fea44c569f76f14f76f'),
            ('ICO/1m/ICO1m_01324.sofa', '4e604dae4a5e8da42b44afd1fc531d48'),
            ('ICO/1m/ICO1m_01326.sofa', '14bea29cd329b2bc35ac687863759b99'),
            ('ICO/1m/ICO1m_01327.sofa', '0ee08b38d3e19a83cf71ddccb3da74b0'),
            ('ICO/1m/ICO1m_01328.sofa', '4b24fe6d708fd471e23e70f398418c18'),
            ('ICO/1m/ICO1m_01329.sofa', '06e43dd495a5f70c44733d7c7de6cb2d'),
            ('ICO/1m/ICO1m_01330.sofa', 'e764ca2f16491f124f80e1ac94812f25'),
            ('ICO/1m/ICO1m_01331.sofa', 'a75883c7c65411dc9e077d03cab8a8b7'),
            ('ICO/1m/ICO1m_01333.sofa', '67191e714db2c7f8fd1d21ba21597689'),
            ('ICO/1m/ICO1m_01334.sofa', '0cb52ceb6ee3452d5ce9fb53806f81e9'),
            ('ICO/1m/ICO1m_01335.sofa', 'cca247a59736e23bcd139e15914d3182'),
            ('ICO/1m/ICO1m_01337.sofa', '6ff8e32a2ac19f3ef51af6ac033bdde0'),
            ('ICO/1m/ICO1m_01338.sofa', '12dc3e6babc48c4dfc3ca20e378c191e'),
            ('ICO/1m/ICO1m_01342.sofa', '299e479a058e79dd48043e49bc2e0425'),
            ('ICO/1m/ICO1m_01344.sofa', '47b52c98293cd9ba2415743f56cd1c7a'),
            ('ICO/1m/ICO1m_01345.sofa', 'c266805583c40bb4dcab01691e115daf'),
            ('ICO/1m/ICO1m_01346.sofa', '467d22ac68afdce9c46338f81675bb48'),
            ('ICO/1m/ICO1m_01347.sofa', 'bbdedce6a09cdc27853f59f1be6b064f'),
            ('ICO/1m/ICO1m_01349.sofa', 'ea2b7d9b3d705e57d5f4b90ab503a8f1'),
            ('ICO/1m/ICO1m_01350.sofa', '39581dceb0f0d687276c350a2d0aa858'),
            ('ICO/1m/ICO1m_01351.sofa', '91616293d8295589a70c36d6203880f4'),
            ('ICO/1m/ICO1m_01352.sofa', 'be550753968d5d3990104b3332cc5fea'),
            ('ICO/1m/ICO1m_01355.sofa', 'b8f76736d39fc9ed6182a7d46c0304cd'),
            ('ICO/1m/ICO1m_01356.sofa', '9b680f67b5d6b23c093f221d28af67ea'),
            ('ICO/1m/ICO1m_01357.sofa', '408641fe1b8d016ed94e00abe95e9005'),
            ('ICO/1m/ICO1m_01359.sofa', '427774adf8c2821eb2a8c4afc49f0087'),
            ('ICO/1m/ICO1m_01360.sofa', '37ad6b977abaa44c26a2aff0d1778f29'),
            ('ICO/1m/ICO1m_01362.sofa', 'ff01112877dadcd853324ef47be214f3'),
            ('ICO/1m/ICO1m_01363.sofa', 'fc751663d0aec39c0fdfc892a6fedd16'),
            ('ICO/1m/ICO1m_01364.sofa', '6f40f0beb892bb406808ebf9fb8ef960'),
            ('ICO/1m/ICO1m_01365.sofa', '803bbfafbdf79906ff24eb5df770ab51'),
            ('ICO/1m/ICO1m_01366.sofa', 'fd4a3efd5acaf88ec25b120b6c65efd5'),
            ('ICO/1m/ICO1m_01367.sofa', '28841319f3c382ec8d5d5c0c908965de'),
            ('ICO/1m/ICO1m_01370.sofa', 'b5dc9a0da019c13452f45f84fdc4105d'),
            ('ICO/1m/ICO1m_01371.sofa', '9e88947e7884404e5804de1d0741f0da'),
            ('ICO/1m/ICO1m_01372.sofa', 'b706e47f9465f690736e95c5a897fdaf'),
            ('ICO/1m/ICO1m_01373.sofa', '79a16ca999a14fdab4666b54844c5d37'),
            ('ICO/1m/ICO1m_01374.sofa', '6b2d6e789c584db262285561a0958dfe'),
            ('ICO/1m/ICO1m_01375.sofa', '938adc909df477d5bb4af5e20be25db4'),
            ('ICO/1m/ICO1m_01376.sofa', '071c27d26a97416035802505e6380f7c'),
        ],
        'ICO-2m': [
            ('ICO/2m/ICO2m_00001.sofa', 'd88491697868e4f31b5965caf84c21a0'),
            ('ICO/2m/ICO2m_00002.sofa', 'e22c009928eedccd91e1e2cd0792ce52'),
            ('ICO/2m/ICO2m_00003.sofa', '911b838450bd5c937e81358a3e15f9ee'),
            ('ICO/2m/ICO2m_00004.sofa', '5b8f2bf3261a87680eb1774593e90065'),
            ('ICO/2m/ICO2m_00005.sofa', '2372e72690e9e0efe6d60f06cc854866'),
            ('ICO/2m/ICO2m_00007.sofa', 'b9f5fba93c2e94eef9fc228e48f7392e'),
            ('ICO/2m/ICO2m_00009.sofa', 'e3b3dbe5082ab96cbabc2deb61d850de'),
            ('ICO/2m/ICO2m_00010.sofa', 'f20353ace87dadf9e7880851ad56af2c'),
            ('ICO/2m/ICO2m_00011.sofa', '6e6dd814bd685f1ac77d5d13d754ea9f'),
            ('ICO/2m/ICO2m_00013.sofa', 'fddee61a899209d6131473c0dffcadee'),
            ('ICO/2m/ICO2m_00014.sofa', '2eeae44ff4816b700978396958fe631b'),
            ('ICO/2m/ICO2m_00015.sofa', 'c4eeb69300680c6e586316f991a8fede'),
            ('ICO/2m/ICO2m_00016.sofa', '4114d8de4111b4abaae05131f5a30c8f'),
            ('ICO/2m/ICO2m_00020.sofa', '72877707dc0c1e9c327c18f6ee0ecfd1'),
            ('ICO/2m/ICO2m_00021.sofa', 'ccda693e20f36ac24b540752e8508f0b'),
            ('ICO/2m/ICO2m_00022.sofa', 'b5816f55dc4234d38049c98f85a4364c'),
            ('ICO/2m/ICO2m_00023.sofa', '07c431838917dbef5c3fcfe900cc20ee'),
            ('ICO/2m/ICO2m_00024.sofa', 'd8b1ff76deb0ab547382a4304558d78a'),
            ('ICO/2m/ICO2m_00025.sofa', '7382d26fdcb6a5157939b8e4e2ab8a35'),
            ('ICO/2m/ICO2m_00026.sofa', '4d9756ce6c55359418269a059fa9da36'),
            ('ICO/2m/ICO2m_00027.sofa', 'd86bc9cfc434a78d7dd280218381fc9f'),
            ('ICO/2m/ICO2m_00029.sofa', 'd9f29e744bf253667f3d58e167e1f49a'),
            ('ICO/2m/ICO2m_00030.sofa', '7aa0e7ca1df73a501ea0888f9fd6c1bf'),
            ('ICO/2m/ICO2m_00031.sofa', '1369ba4c60959fe84c9e6d4e3d91c7c6'),
            ('ICO/2m/ICO2m_00032.sofa', 'c6f6debfa298db882056272d4010c45b'),
            ('ICO/2m/ICO2m_00033.sofa', '13c6d33d72360e93e0456e85cc402f40'),
            ('ICO/2m/ICO2m_00036.sofa', '4bf3e00cfa93a0ed5fa14f61fa0f1a3f'),
            ('ICO/2m/ICO2m_00038.sofa', 'eccbe26f0ae8f808ae2dc0ae7ae137f6'),
            ('ICO/2m/ICO2m_00039.sofa', 'a43ad4746c9961bccc85cc4ab40fe9ea'),
            ('ICO/2m/ICO2m_00042.sofa', '043f22184d5e178a8a35df41a748d95d'),
            ('ICO/2m/ICO2m_00043.sofa', '6be92a22bb2e2b98971b7eae3cb8d818'),
            ('ICO/2m/ICO2m_00044.sofa', '21274f7720a318ac081da5aa9a97ca68'),
            ('ICO/2m/ICO2m_00045.sofa', '34d3eac9584531e30ef79f0a11921af3'),
            ('ICO/2m/ICO2m_00048.sofa', '3a86f834ddd7f4d3ee50c9b5292811bb'),
            ('ICO/2m/ICO2m_00049.sofa', 'b4594f119f70ffbb742537ba46534ba5'),
            ('ICO/2m/ICO2m_00054.sofa', '1627fdab0aba4d34cbedad12f6eaa78d'),
            ('ICO/2m/ICO2m_00056.sofa', '3bc915ffbfdb72ed357abd3c543c5442'),
            ('ICO/2m/ICO2m_00057.sofa', 'e05891ae3c212c4e76615b50d0d65eb3'),
            ('ICO/2m/ICO2m_00058.sofa', '82ec90cb99c985a16c8c31c24b7ecd6b'),
            ('ICO/2m/ICO2m_00059.sofa', '141f2faf63447eae013d2e42fff18b6b'),
            ('ICO/2m/ICO2m_00061.sofa', '43baf3dff3713639b024cb96aeb5057b'),
            ('ICO/2m/ICO2m_00062.sofa', '533252cf7319d48b184ce2c9f648d160'),
            ('ICO/2m/ICO2m_00063.sofa', 'f480514c3a2ef5cfcd5d41d4211213bf'),
            ('ICO/2m/ICO2m_00064.sofa', 'd14e421a7b27dc4e395acf5b85599822'),
            ('ICO/2m/ICO2m_00065.sofa', 'c6cfa4207b47cd684b8e7a87eb1b5ff4'),
            ('ICO/2m/ICO2m_00068.sofa', '9612f55c826fc7566f174d45540ecc64'),
            ('ICO/2m/ICO2m_00069.sofa', 'b9872bfd2347c804e635d7a5cc0f8658'),
            ('ICO/2m/ICO2m_00071.sofa', '6cc77b72f942a5c75408b4f447dc5ad5'),
            ('ICO/2m/ICO2m_00072.sofa', 'ece4a9298e20ea8a7d0760032b77ae44'),
            ('ICO/2m/ICO2m_00074.sofa', 'f9788e41ee016a4c96854f598f4b7805'),
            ('ICO/2m/ICO2m_00076.sofa', '00e214295fe29e3a65f4724ce5811fbf'),
            ('ICO/2m/ICO2m_00078.sofa', '2f75c12779bf41931bfd537c610b2b2b'),
            ('ICO/2m/ICO2m_00079.sofa', '78bf2c10ed5e1bc9fc9f89fff2930156'),
            ('ICO/2m/ICO2m_00082.sofa', '9791312c8ebf0f85f0d0b5f2280a0300'),
            ('ICO/2m/ICO2m_00083.sofa', 'b49b8d35dcf52529398110a7965b444c'),
            ('ICO/2m/ICO2m_00085.sofa', '17f449a8b874954dc6bd6926734a880f'),
            ('ICO/2m/ICO2m_00086.sofa', '51f9f16367561dd3d18c885e2cc49502'),
            ('ICO/2m/ICO2m_00087.sofa', '9294766e1e54ec9b48bf72123adf535f'),
            ('ICO/2m/ICO2m_00089.sofa', 'f6fd159d36439c6079f563733f4041e5'),
            ('ICO/2m/ICO2m_00090.sofa', '78431f6bc737ee38e15adb52cfd840dc'),
            ('ICO/2m/ICO2m_00092.sofa', '56dfbb1c40377ae4981843318d52ce90'),
            ('ICO/2m/ICO2m_00095.sofa', '45045dd6243756a7b6c3a73978bb362a'),
            ('ICO/2m/ICO2m_00097.sofa', 'a90aac8c02342af20c578b6cbe78ae5c'),
            ('ICO/2m/ICO2m_00099.sofa', '4e02a17045d50454d06a7e731293840d'),
            ('ICO/2m/ICO2m_00100.sofa', 'ef5e5ce4484ebc5fd86c8e668557c306'),
            ('ICO/2m/ICO2m_00101.sofa', '131e86bbfe4974fc4172cae01e0f1155'),
            ('ICO/2m/ICO2m_00103.sofa', '8b6257762b9260e060c08627ceef8278'),
            ('ICO/2m/ICO2m_00104.sofa', '571534d98aca34f71608da662fe1c0c0'),
            ('ICO/2m/ICO2m_00107.sofa', '57a863675aa526b020802954e3e9ca82'),
            ('ICO/2m/ICO2m_00108.sofa', '2bb94e846896cc113b4ab8ddd2b0d646'),
            ('ICO/2m/ICO2m_00109.sofa', 'b57e21649668871ebcbf805b9de61e22'),
            ('ICO/2m/ICO2m_00110.sofa', '338eac8c856019311f35b540be1c1b81'),
            ('ICO/2m/ICO2m_00111.sofa', '704ea1f630fb4efe7856f785bf56b81b'),
            ('ICO/2m/ICO2m_00112.sofa', '9082a85fed39fb2e9fbcc1c1215b78cb'),
            ('ICO/2m/ICO2m_00113.sofa', '2ed67c1c797dd4dd7613285f16364857'),
            ('ICO/2m/ICO2m_00114.sofa', '1d12255bb9fea1b2940cbad1e5a31c4c'),
            ('ICO/2m/ICO2m_00118.sofa', 'f55d8d3e2e64d37c706f606cf8fd205a'),
            ('ICO/2m/ICO2m_00119.sofa', '674663a865c6843f402006320110cbf8'),
            ('ICO/2m/ICO2m_00120.sofa', 'b8bc878f50ed320a695be1b13d176921'),
            ('ICO/2m/ICO2m_00121.sofa', 'cedd62a4dbc8b5c3ab18c4097806c7aa'),
            ('ICO/2m/ICO2m_00125.sofa', '0154a3feee19461aa1ae7fba0b7c7edf'),
            ('ICO/2m/ICO2m_00126.sofa', '6ea1fa04dcaadb49a14d78d610046cc5'),
            ('ICO/2m/ICO2m_00127.sofa', '11cb89a995c7b57f29fd771fcbb4ba04'),
            ('ICO/2m/ICO2m_00128.sofa', '1b75875d58c553e4703a78951859ce4e'),
            ('ICO/2m/ICO2m_00130.sofa', '7f961f384ce225cb5cd21bd43da5dc6b'),
            ('ICO/2m/ICO2m_00131.sofa', '26e3ef129997ec2b0a762d991195b749'),
            ('ICO/2m/ICO2m_00132.sofa', '3777a68d374fb75ee6881a5f3816ffbc'),
            ('ICO/2m/ICO2m_00133.sofa', 'fb0b8dcc24ab3446986f20d7468a2727'),
            ('ICO/2m/ICO2m_00136.sofa', '2f545c1f4116fc149722114805ca5f0c'),
            ('ICO/2m/ICO2m_00137.sofa', '0437df025cdffd59be3cac7ffbef0dcb'),
            ('ICO/2m/ICO2m_00139.sofa', 'c50058116df09d3714e7adea14e80037'),
            ('ICO/2m/ICO2m_00140.sofa', 'e02e2009bcc6103d4e6bd8210b69d012'),
            ('ICO/2m/ICO2m_00142.sofa', '441263a9879ee607555132ae672ef8d6'),
            ('ICO/2m/ICO2m_00145.sofa', 'c6960132ebc26650a005e7115a3e3b1a'),
            ('ICO/2m/ICO2m_00146.sofa', '187c4ef10e15b7919a13cbb25f989bbe'),
            ('ICO/2m/ICO2m_00147.sofa', '925081ced15866d10b78b880273c6c69'),
            ('ICO/2m/ICO2m_00148.sofa', 'dbc528ec44599a7f5ea02df97352f371'),
            ('ICO/2m/ICO2m_00149.sofa', '8feef6b90442537c9fd0e0eae36631d3'),
            ('ICO/2m/ICO2m_00150.sofa', 'dde049c298d6c7c85345571687548b9e'),
            ('ICO/2m/ICO2m_00152.sofa', 'eadd11dd8a029934d3a12c8d2e252adc'),
            ('ICO/2m/ICO2m_00153.sofa', '5ad3046060ed03973323cd7947207b66'),
            ('ICO/2m/ICO2m_00154.sofa', 'a962a489efc2ccb58a1492ed0276df6d'),
            ('ICO/2m/ICO2m_00155.sofa', '9f97d4830e53e9c8683be2805a684eb2'),
            ('ICO/2m/ICO2m_00156.sofa', '0f6f5562ecb86168c5fe2a2ec8d2a7e8'),
            ('ICO/2m/ICO2m_00157.sofa', '628949ac6b8ae28d66389d50c2ba4995'),
            ('ICO/2m/ICO2m_00158.sofa', '6417c9e320f3257f1ff6b1623f141f99'),
            ('ICO/2m/ICO2m_00159.sofa', '706d7ca8fe31592db2cbb6059385b916'),
            ('ICO/2m/ICO2m_00161.sofa', '1a507aedef0b41f260f8c5dbafca41cb'),
            ('ICO/2m/ICO2m_00164.sofa', '4f9ae7da6166d02d5ed0ffd8d618b740'),
            ('ICO/2m/ICO2m_00165.sofa', '6f0c680365a34f634391c47ee1d4987f'),
            ('ICO/2m/ICO2m_00166.sofa', '9e2679d0666b68ed718851a9c5a98aba'),
            ('ICO/2m/ICO2m_00168.sofa', 'd39e789f2dbcc201eaef3fc6bbb21acd'),
            ('ICO/2m/ICO2m_00169.sofa', 'aa3a83675c0c58e80154de202f229f3a'),
            ('ICO/2m/ICO2m_00170.sofa', '774733c373138425b41a2d3ed4055d24'),
            ('ICO/2m/ICO2m_00171.sofa', 'd434e1aa81952e0f04da66ffe6d8fd43'),
            ('ICO/2m/ICO2m_00173.sofa', '98482131c7e904b59c29a0327d316651'),
            ('ICO/2m/ICO2m_00175.sofa', '5d989964d0900a36d7b2d34d0ae8a65b'),
            ('ICO/2m/ICO2m_00176.sofa', '4259ea1ebf3738c7fb5285dd7cf92833'),
            ('ICO/2m/ICO2m_00177.sofa', '95b9e1dd736013acba4c783ff8236d43'),
            ('ICO/2m/ICO2m_00178.sofa', '1f63d12658c76bd612709b789e9ab5cd'),
            ('ICO/2m/ICO2m_00179.sofa', '0414fc5a8d75a41478fb08bf4a3502ae'),
            ('ICO/2m/ICO2m_00183.sofa', 'd30c3f52e1f1c6c8213a12adc36554e1'),
            ('ICO/2m/ICO2m_00184.sofa', 'bf0a5860991c8727ca8dd741d0a7ce7e'),
            ('ICO/2m/ICO2m_00185.sofa', 'c732fe26889e6f5f7cee0a4cdc9afe1d'),
            ('ICO/2m/ICO2m_00186.sofa', '05112d0586125cea097647a3bdc2bf9c'),
            ('ICO/2m/ICO2m_00188.sofa', '9e83947e823350927bd503e32f0e5baf'),
            ('ICO/2m/ICO2m_00189.sofa', 'e49d80b223a3dd344730059fe335e29d'),
            ('ICO/2m/ICO2m_00190.sofa', 'b927588d229bb8c3200ae4ac376924b3'),
            ('ICO/2m/ICO2m_00191.sofa', 'b932e17d0e07fe5095a5363648165497'),
            ('ICO/2m/ICO2m_00194.sofa', '3497669f9071e8cce1806b4abd0ef9bb'),
            ('ICO/2m/ICO2m_00195.sofa', '87958875c19368ce4a602e0b79e90298'),
            ('ICO/2m/ICO2m_00196.sofa', '2982d3ecca54b755bd798d9c91ff2285'),
            ('ICO/2m/ICO2m_00197.sofa', '1f6a62da632518a1e8288963df05e2ff'),
            ('ICO/2m/ICO2m_00198.sofa', '628e023b915cb312e24fda96b94028d2'),
            ('ICO/2m/ICO2m_00201.sofa', '5854750b8a397e78f593c32ff7d8c6a8'),
            ('ICO/2m/ICO2m_00203.sofa', 'c5b5fb13639a30a39e6d02537d09203a'),
            ('ICO/2m/ICO2m_00204.sofa', 'c8c828b3f3b17ce6ab4cb3534acddf20'),
            ('ICO/2m/ICO2m_00205.sofa', '3ddfdf65937cf5d55ab646c4c45681fc'),
            ('ICO/2m/ICO2m_00206.sofa', '4b5217af14a8416d0ca34addaeaea2c8'),
            ('ICO/2m/ICO2m_00209.sofa', '3f2c03029474dc4f8d29080789bebb30'),
            ('ICO/2m/ICO2m_00210.sofa', '3dd1fab179d1b9ed46d496b98e7c2943'),
            ('ICO/2m/ICO2m_00211.sofa', '944b8031c47428411f0f6e852ec3d76e'),
            ('ICO/2m/ICO2m_00212.sofa', '69f98f59363debdb65065dd19ec4c876'),
            ('ICO/2m/ICO2m_00213.sofa', '17a96154d47368dd487c5398b28ff990'),
            ('ICO/2m/ICO2m_00214.sofa', '1d4d6a14e1116410de249adb0997b87e'),
            ('ICO/2m/ICO2m_00215.sofa', 'e732d45cb0bd2a3eb4134e9aa8d1d14c'),
            ('ICO/2m/ICO2m_00216.sofa', '25380f1f8c4bcd8ea28033a4170f3750'),
            ('ICO/2m/ICO2m_00217.sofa', 'ce2d6d21a2c8a3c26b8f4e671bbe97a0'),
            ('ICO/2m/ICO2m_00219.sofa', 'a7c6508515ae1c468da8b8f932af47de'),
            ('ICO/2m/ICO2m_00220.sofa', '9fa6cb2e3b062387840ca61e54a2794b'),
            ('ICO/2m/ICO2m_00221.sofa', '6e8c0cc4ab8a607fedbf8280ee44294c'),
            ('ICO/2m/ICO2m_00222.sofa', '0a6a33d60736f5ee6697e6add1be2acb'),
            ('ICO/2m/ICO2m_00223.sofa', 'a1c0e73c4e156e7f30b926ef5358896f'),
            ('ICO/2m/ICO2m_00224.sofa', '0ba338cbc01f5c20249cf7f18df8c9f3'),
            ('ICO/2m/ICO2m_00225.sofa', '04654eca7c0473324d1611ecb097e6e0'),
            ('ICO/2m/ICO2m_00226.sofa', 'cdcc314e89a3007d75744772a97518d5'),
            ('ICO/2m/ICO2m_00227.sofa', 'eed2896b58499733a30a1a0e126c4cd2'),
            ('ICO/2m/ICO2m_00228.sofa', 'e95fa2679ef97e6dee7bfe36cfbf3d33'),
            ('ICO/2m/ICO2m_00229.sofa', '8504c4d0af94aae6467a639189aa117d'),
            ('ICO/2m/ICO2m_00230.sofa', '7c0289dfdca53eb6d630d05ba219ac34'),
            ('ICO/2m/ICO2m_00231.sofa', '1d83f292bcad4f85fa8a0e569485c936'),
            ('ICO/2m/ICO2m_00232.sofa', 'b7725d830c16da638d0d5366aa830e47'),
            ('ICO/2m/ICO2m_00233.sofa', '2cd899613c9cc67aae23a57422050ca4'),
            ('ICO/2m/ICO2m_00234.sofa', 'f746416da85307b7535df83bdd20e08b'),
            ('ICO/2m/ICO2m_00235.sofa', 'eea8889042f17158b950fdf64a7d9d82'),
            ('ICO/2m/ICO2m_00236.sofa', 'f018248d44e8fd8c7f89631d84647abf'),
            ('ICO/2m/ICO2m_00237.sofa', 'a63ab2c2df78200ff71a8826e8beefaf'),
            ('ICO/2m/ICO2m_00238.sofa', '5f6b9f432dd6e178ac5064b40ee6edf1'),
            ('ICO/2m/ICO2m_00239.sofa', '41448f3caf69c735f04cda4d7b3f06d4'),
            ('ICO/2m/ICO2m_00240.sofa', '8bb3f2309d464152faf8a02910647d55'),
            ('ICO/2m/ICO2m_00241.sofa', '33011c10a8843c62e5ad4266744c1590'),
            ('ICO/2m/ICO2m_00244.sofa', '25894ff7dfa2c56b8e1e13f985c7dc77'),
            ('ICO/2m/ICO2m_00245.sofa', '99052ee5e7fd14ffb26ea4ac53300ba9'),
            ('ICO/2m/ICO2m_00246.sofa', 'a836f29e2d21662284625ce5ab8045a2'),
            ('ICO/2m/ICO2m_00247.sofa', '018c74389d82bc428cce0f650bd20f09'),
            ('ICO/2m/ICO2m_00248.sofa', 'd4f904a634d1845482ecbad3d715ddb0'),
            ('ICO/2m/ICO2m_00251.sofa', '93487025b4fa8f39829eea208670056f'),
            ('ICO/2m/ICO2m_00252.sofa', '8a68aaf9fc4d60f76dab31a7f89bafcb'),
            ('ICO/2m/ICO2m_00253.sofa', '1dd6f72a47da17e201e67a37166611da'),
            ('ICO/2m/ICO2m_00254.sofa', '84ad8dacaa2cdd08f7290ef98e731b49'),
            ('ICO/2m/ICO2m_00256.sofa', '908cfd205c0aca8e39e800a7cb382dc3'),
            ('ICO/2m/ICO2m_00258.sofa', '172cd3b7d25024aa64e2afb67a1c23fa'),
            ('ICO/2m/ICO2m_00259.sofa', '04b3e02216750a495ce30ec62acd541d'),
            ('ICO/2m/ICO2m_00261.sofa', 'd2d5323bab1de308d16d78033c6fab0f'),
            ('ICO/2m/ICO2m_00262.sofa', '5b3fed1ed6876f6cceba9a0ea23e9594'),
            ('ICO/2m/ICO2m_00263.sofa', '646801861de4b9897301e7d0cb40ab48'),
            ('ICO/2m/ICO2m_00264.sofa', 'bf5c96f7fa06de810c8e0b668acf6a81'),
            ('ICO/2m/ICO2m_00265.sofa', '663a7b6c09d4bf34dfb55bfc5d82c8bd'),
            ('ICO/2m/ICO2m_00268.sofa', 'abdcab75b00f20616ede23c1e25f0ca0'),
            ('ICO/2m/ICO2m_00269.sofa', '275d42fe8aead08197a58a700156d6ef'),
            ('ICO/2m/ICO2m_00270.sofa', '07b0f4061710011b08c26596dd3c7b46'),
            ('ICO/2m/ICO2m_00271.sofa', 'cc94d24f9fc126007f5aac45c1bc89bb'),
            ('ICO/2m/ICO2m_00272.sofa', 'ec169ed0ae40d1adccaa1a1a7edfae04'),
            ('ICO/2m/ICO2m_00273.sofa', 'c3a5f78b19e76b351ba7f8d2cd07f561'),
            ('ICO/2m/ICO2m_00275.sofa', '36f1bfe397cabae2a47c36c52e1afbbf'),
            ('ICO/2m/ICO2m_00276.sofa', '6ad31aa585781caad5dd44a4e463e904'),
            ('ICO/2m/ICO2m_00277.sofa', 'c08aeaba71445465546897ca3e3387a0'),
            ('ICO/2m/ICO2m_00278.sofa', 'f5c007ccbaeb6c6acda7b3630f1826d7'),
            ('ICO/2m/ICO2m_00279.sofa', '0195bcb28b04ee26dc1b35ce09ed0606'),
            ('ICO/2m/ICO2m_00281.sofa', '1ea2f3016de71a9b8c66c77b5bde6066'),
            ('ICO/2m/ICO2m_00283.sofa', '60c945608eb8a69ad444d66818de3036'),
            ('ICO/2m/ICO2m_00284.sofa', '240445810680e80651f1e26e7791d436'),
            ('ICO/2m/ICO2m_00285.sofa', '9cdfd6ed55910cef9588fa0c456a4dd8'),
            ('ICO/2m/ICO2m_00286.sofa', 'b6d34bc425b6cb45460e882521b2ffdb'),
            ('ICO/2m/ICO2m_00287.sofa', 'e8be5bb57581664758a6bf87f281ab2e'),
            ('ICO/2m/ICO2m_00288.sofa', '19722a55eb6404516f2a54ee56f5fa4f'),
            ('ICO/2m/ICO2m_00289.sofa', '2f14c3696a092ae3061757577404e90e'),
            ('ICO/2m/ICO2m_00290.sofa', '0691ddbbfbf396ce741e712f6a461e7b'),
            ('ICO/2m/ICO2m_00291.sofa', 'd31a9815a76a6c68c3f19f6ab0f19e04'),
            ('ICO/2m/ICO2m_00293.sofa', 'cbb84bba687db6a89c86c6682884441e'),
            ('ICO/2m/ICO2m_00294.sofa', '5d2d22dd999b39a49aab7fe73f2e2f65'),
            ('ICO/2m/ICO2m_00295.sofa', 'fdaab45943ae29fb3222a6b555c17e0b'),
            ('ICO/2m/ICO2m_00296.sofa', '26c187fbc25be13e5331a4835240b4ac'),
            ('ICO/2m/ICO2m_00297.sofa', '1a13adb74160c50958694c77b4056e95'),
            ('ICO/2m/ICO2m_00298.sofa', '557b9e2d7566aca7dcedf02c84b78c2c'),
            ('ICO/2m/ICO2m_00301.sofa', '4e8039dda627bb6e95c67a0f6027ccd3'),
            ('ICO/2m/ICO2m_00303.sofa', '9814afff08fb4889ebfa781d26e7aefe'),
            ('ICO/2m/ICO2m_00305.sofa', '23a251251f2ed4be1897a7071bc00ff9'),
            ('ICO/2m/ICO2m_00306.sofa', '366b04c19fa27502568ff35a05517e14'),
            ('ICO/2m/ICO2m_00307.sofa', '813e0c61965971f05bf3916406df3a79'),
            ('ICO/2m/ICO2m_00308.sofa', '2473d14f3160c55326e5ab23249898da'),
            ('ICO/2m/ICO2m_00309.sofa', '70b957489af35e942ccd0521780be29a'),
            ('ICO/2m/ICO2m_00311.sofa', 'dc8b04e9de6f5ac4b222bb36c5b2cbfb'),
            ('ICO/2m/ICO2m_00315.sofa', '6ba18fb0115a9fce375d2732810e9109'),
            ('ICO/2m/ICO2m_00318.sofa', 'b29b51568a835f2d03c88ffe62a6ad56'),
            ('ICO/2m/ICO2m_00319.sofa', '89d875d8df24f56bc236406d8de86d20'),
            ('ICO/2m/ICO2m_00320.sofa', '6a8cf19dd4f36deca6b507c3ba4e4b91'),
            ('ICO/2m/ICO2m_00321.sofa', '19b8a754df118cb177c3e015042e28e8'),
            ('ICO/2m/ICO2m_00322.sofa', '14e321765d3b20290d67547453eaa826'),
            ('ICO/2m/ICO2m_00323.sofa', '2a183406fea5ec2b6a5834825fef8167'),
            ('ICO/2m/ICO2m_00326.sofa', '66632a56a91cabc0c686f8456c896c62'),
            ('ICO/2m/ICO2m_00328.sofa', '5ecb6a3d2b754a02d953ffa066cafa59'),
            ('ICO/2m/ICO2m_00329.sofa', 'f35eca8b7e5216f5cee36809762e00b5'),
            ('ICO/2m/ICO2m_00331.sofa', '24f476ccd39d8116dc1e2a98a92a63aa'),
            ('ICO/2m/ICO2m_00332.sofa', 'a1e02569a71969618c391a2fdd0e0833'),
            ('ICO/2m/ICO2m_00333.sofa', '37bec4e95a4d403b42d804ce27fcba4d'),
            ('ICO/2m/ICO2m_00334.sofa', '97571637f70460acae35ed5538aef8ec'),
            ('ICO/2m/ICO2m_00335.sofa', '18a8f28c94dc5fa3c03b34eaf86f6250'),
            ('ICO/2m/ICO2m_00336.sofa', 'eeb352a0f441a8a4582ebd56679c1543'),
            ('ICO/2m/ICO2m_00337.sofa', 'd249c71238a23014594bdca2ee8d39fa'),
            ('ICO/2m/ICO2m_00338.sofa', '26c312af39fe741db72c1d0415050662'),
            ('ICO/2m/ICO2m_00340.sofa', '1d65ce79e2aec4c4c8e0f953a40ea403'),
            ('ICO/2m/ICO2m_00341.sofa', '79a0eaf71235e3649f7283f9863193c7'),
            ('ICO/2m/ICO2m_00343.sofa', '831b8dbf6d27f9c18073c6197b20ac94'),
            ('ICO/2m/ICO2m_00344.sofa', 'af41d4388fdffd5d8a45582d5ac53cd9'),
            ('ICO/2m/ICO2m_00345.sofa', 'efd4323d70ebb0e491e79ad8c9421628'),
            ('ICO/2m/ICO2m_00347.sofa', 'e248bc19cf9704bd8573cd9d26e14d11'),
            ('ICO/2m/ICO2m_00348.sofa', 'ace3e30f0728ed6e38b4df0cf0dd6040'),
            ('ICO/2m/ICO2m_00349.sofa', '4d07d4f17d644e222f83fd6b101e0c39'),
            ('ICO/2m/ICO2m_00350.sofa', '8d02dc35446ddc7a8c13cf9475c42cec'),
            ('ICO/2m/ICO2m_00351.sofa', '9dd4c7fbf1783671b3b03d590f82f19a'),
            ('ICO/2m/ICO2m_00352.sofa', '7cb420df8ea680adc4c6ee94e445e578'),
            ('ICO/2m/ICO2m_00353.sofa', 'b9aa6ae16d82dbad37b50d33f072b425'),
            ('ICO/2m/ICO2m_00354.sofa', '282f11c63152eb1917f12580692af019'),
            ('ICO/2m/ICO2m_00355.sofa', 'b66849f6f85e802363f4a9d89d7153de'),
            ('ICO/2m/ICO2m_00356.sofa', '7260b1a67ec0cdccd3b990c72d15939d'),
            ('ICO/2m/ICO2m_00358.sofa', '91f9e20394013fb47398a4dd6630e0c8'),
            ('ICO/2m/ICO2m_00359.sofa', '3bce0577cd1cc2416ab26fa6e523cb8c'),
            ('ICO/2m/ICO2m_00360.sofa', '9e4452cca9e808df954a66ace8107a05'),
            ('ICO/2m/ICO2m_00361.sofa', '1a9a8b6744d00530f5a47c2ee180515f'),
            ('ICO/2m/ICO2m_00362.sofa', '6db2a994651876bc86f321bfa3152ab2'),
            ('ICO/2m/ICO2m_00363.sofa', 'e600e5e8ff95e47bba4b654e103c2fe6'),
            ('ICO/2m/ICO2m_00364.sofa', '433f4f91f0fe7890650ae2db9edb4a42'),
            ('ICO/2m/ICO2m_00365.sofa', 'cbd033b238fdda445e112ab031830e1c'),
            ('ICO/2m/ICO2m_00366.sofa', '026db2b5f48e1dfa4efb72a2ca41e99e'),
            ('ICO/2m/ICO2m_00367.sofa', '476c1c541311e177386cfbf262c76025'),
            ('ICO/2m/ICO2m_00368.sofa', '3fc4f3b483b4634e7e57d53f46963832'),
            ('ICO/2m/ICO2m_00370.sofa', '9cdb8152d4c16a432112c58fa00ae9a8'),
            ('ICO/2m/ICO2m_00371.sofa', 'cb6f43473b5d85cfa7ee48d12ebe64de'),
            ('ICO/2m/ICO2m_00372.sofa', '271487f230bc43a59f3ea58485c00ba4'),
            ('ICO/2m/ICO2m_00373.sofa', '95b804072b99851edcca8eec94d28a86'),
            ('ICO/2m/ICO2m_00374.sofa', '303375b2e21a10a2a682531d17903f88'),
            ('ICO/2m/ICO2m_00375.sofa', '18bb5c86fdba883635ad189fc78d6666'),
            ('ICO/2m/ICO2m_00376.sofa', '46c3c04a0e3003236f55d9727d3a165d'),
            ('ICO/2m/ICO2m_00378.sofa', 'b4cc43d689ada91494b2a9663eca516c'),
            ('ICO/2m/ICO2m_00379.sofa', '28dabe3b5011d1cab79b9f25c3003c61'),
            ('ICO/2m/ICO2m_00382.sofa', '6d8fecc44c7cd8bb994082cccc91088e'),
            ('ICO/2m/ICO2m_00383.sofa', 'bb0096344f778b1cacb89fa0901df498'),
            ('ICO/2m/ICO2m_00385.sofa', 'a76cfc1ae692d2bda097117e518eade9'),
            ('ICO/2m/ICO2m_00386.sofa', 'd5ce905253daaacb43d3a55f89857d6f'),
            ('ICO/2m/ICO2m_00389.sofa', 'b30261578ea7f2f11e6098f6d926e7e4'),
            ('ICO/2m/ICO2m_00391.sofa', '69ba005f30905a92b7cd0489e4ca7fba'),
            ('ICO/2m/ICO2m_00392.sofa', '6ac0bdd0d634dbbe5e4e0f3d6e4d8252'),
            ('ICO/2m/ICO2m_00395.sofa', 'a1ec306a43424774684c35025bfe1f7c'),
            ('ICO/2m/ICO2m_00397.sofa', 'c449c1fc43eac0b3852ec9c7300eab26'),
            ('ICO/2m/ICO2m_00398.sofa', 'feee3f8f541697c44ace4efc59b07f92'),
            ('ICO/2m/ICO2m_00399.sofa', '23b4b547c0aa3cf7f6037db782de6748'),
            ('ICO/2m/ICO2m_00401.sofa', 'e609352ecb3e8f59032597f8e1654f82'),
            ('ICO/2m/ICO2m_00402.sofa', '2fcba1c554a5d36672622a6157469591'),
            ('ICO/2m/ICO2m_00403.sofa', '869eee6269090e5dfaa323ff91fbd662'),
            ('ICO/2m/ICO2m_00404.sofa', 'd60d16dcf9182108db223a434db87edc'),
            ('ICO/2m/ICO2m_00405.sofa', '918099abaebf745d226d67c4fa979799'),
            ('ICO/2m/ICO2m_00406.sofa', 'ba7b06d8448e301671fbf1075970eceb'),
            ('ICO/2m/ICO2m_00407.sofa', '9ed048280de8ce60375b3ee02116dca4'),
            ('ICO/2m/ICO2m_00408.sofa', 'a4acc1da4ccfa72f940591886464daa0'),
            ('ICO/2m/ICO2m_00409.sofa', '20c0c111ecf2b651019b24856c3b3ae4'),
            ('ICO/2m/ICO2m_00410.sofa', '033a2e69c3fc53c2101f8a7d69360c99'),
            ('ICO/2m/ICO2m_00411.sofa', 'fae18ea82cb334519294ad65ba41d23e'),
            ('ICO/2m/ICO2m_00412.sofa', '85eccaf7271682340794bbaffb5dbdbc'),
            ('ICO/2m/ICO2m_00413.sofa', 'ed8f16c7c83c44063df17f586dc0bd3a'),
            ('ICO/2m/ICO2m_00414.sofa', 'badaf9ae0750c69d52425ed8a02b494f'),
            ('ICO/2m/ICO2m_00415.sofa', 'a6e1a73124be329e2f9c090af8b25185'),
            ('ICO/2m/ICO2m_00416.sofa', '4fb27020fa7b896b58e03fad1e9cf5f8'),
            ('ICO/2m/ICO2m_00417.sofa', '65e45e35ed30dd4e4c81374192d9b2f7'),
            ('ICO/2m/ICO2m_00418.sofa', '6e1e318b3c445a440aa29e82d20e44f9'),
            ('ICO/2m/ICO2m_00419.sofa', 'ce5119d0c5479aab5e3ce199f13d1607'),
            ('ICO/2m/ICO2m_00420.sofa', '85c055c08dfeb0dd1667ad8343335eb7'),
            ('ICO/2m/ICO2m_00421.sofa', 'c99a3add197cea4dd565b08288f7b36a'),
            ('ICO/2m/ICO2m_00422.sofa', 'edccf39cd3eb9ed4322be9108b037855'),
            ('ICO/2m/ICO2m_00423.sofa', '12f24ff80082fa6ca5cfeabe268df985'),
            ('ICO/2m/ICO2m_00426.sofa', '246d2bac0f99c075e91b36ce6d83cd3f'),
            ('ICO/2m/ICO2m_00427.sofa', 'e9a10d1683b2f89ab7d0598947d04a57'),
            ('ICO/2m/ICO2m_00428.sofa', '4fb713c5b12341df98c460fa6bc28951'),
            ('ICO/2m/ICO2m_00430.sofa', 'ee49935fbddae173a744e59ad3d74982'),
            ('ICO/2m/ICO2m_00432.sofa', '989fce5f1853ddf5c3a836fcd015c770'),
            ('ICO/2m/ICO2m_00433.sofa', '5227fbb079c2c2077148fcff13fc8ff7'),
            ('ICO/2m/ICO2m_00434.sofa', 'cd01ad7583d9f6a62301e24700640419'),
            ('ICO/2m/ICO2m_00441.sofa', '75b8ebcc8dc80254360068f4864c18eb'),
            ('ICO/2m/ICO2m_00442.sofa', '1f384a2bbb6a20b3ff8baa3eb07df641'),
            ('ICO/2m/ICO2m_00443.sofa', 'c0d65bc4e472f04f1d38df3c5c17d58a'),
            ('ICO/2m/ICO2m_00446.sofa', '3c399d2025a2a257923f5f7dfd18cd0a'),
            ('ICO/2m/ICO2m_00448.sofa', '4e58066501c0efb80721c19c9d6dc6a3'),
            ('ICO/2m/ICO2m_00449.sofa', '373cac22fff7a806daac5f5e08f615f9'),
            ('ICO/2m/ICO2m_00450.sofa', '880a19b08a13b8422f3881a9de810cc0'),
            ('ICO/2m/ICO2m_00451.sofa', 'ff3e60c7e8c324581e2f1acf20a585fa'),
            ('ICO/2m/ICO2m_00452.sofa', '269249fb2b8bc00cdcaa9a9f1a184ecf'),
            ('ICO/2m/ICO2m_00455.sofa', '27032ccef287418c1c4b1eb78f1bcfbc'),
            ('ICO/2m/ICO2m_00456.sofa', '79b471fa44109ecc4dae3fecce7e1bc1'),
            ('ICO/2m/ICO2m_00457.sofa', 'd8c3bdc57038e13f060cad02b248790e'),
            ('ICO/2m/ICO2m_00459.sofa', '570ec64cab1c859ba55f46b74d94bc08'),
            ('ICO/2m/ICO2m_00460.sofa', 'ff7662ad5852455df9a82dffd1e353e9'),
            ('ICO/2m/ICO2m_00461.sofa', '3a09e030549207f02e3f9bf1f6467fc1'),
            ('ICO/2m/ICO2m_00462.sofa', '856c8e80d757e1c52a329a9e5d15ad39'),
            ('ICO/2m/ICO2m_00463.sofa', 'aa011223a0e3adacfb66013f3001753d'),
            ('ICO/2m/ICO2m_00464.sofa', '02215021bb408eb4fbbd4236e8de7e51'),
            ('ICO/2m/ICO2m_00466.sofa', '2fbe0b9cc22eb55dc6e3513f7862fb7f'),
            ('ICO/2m/ICO2m_00467.sofa', 'bc2d61b599dfe02ec5364bd3f415f2d4'),
            ('ICO/2m/ICO2m_00468.sofa', '3efe03dde40a57556e53f38fbc494e0d'),
            ('ICO/2m/ICO2m_00469.sofa', '15cbb9c45307bf47e89a7bbf817e4dda'),
            ('ICO/2m/ICO2m_00470.sofa', 'cec6eb726b150405221dafa385ea2b4a'),
            ('ICO/2m/ICO2m_00471.sofa', '8ad75c2f1f02ab7f26a73ba57ff97fcd'),
            ('ICO/2m/ICO2m_00472.sofa', '4e766250142178370295f1651e45682e'),
            ('ICO/2m/ICO2m_00473.sofa', '98c2c0a4e31c3b1736bfd2533b5ea100'),
            ('ICO/2m/ICO2m_00474.sofa', '2fc7de0811c392aaa457f9cc2fab3237'),
            ('ICO/2m/ICO2m_00476.sofa', '5d2bde737bf6ddf25880e879756407f2'),
            ('ICO/2m/ICO2m_00477.sofa', '514aec799258b6803f2d613c033c8997'),
            ('ICO/2m/ICO2m_00478.sofa', 'ffa8b91b5b095ee2b0f043f1ee0c66c6'),
            ('ICO/2m/ICO2m_00480.sofa', 'e4757b652105b2d1d55d9adcba55d0be'),
            ('ICO/2m/ICO2m_00481.sofa', 'dc7259bf2b352b38a81d911b4a548697'),
            ('ICO/2m/ICO2m_00482.sofa', '9c1a9bd027991dba1507a186cbe51bbc'),
            ('ICO/2m/ICO2m_00483.sofa', '0b340ce386d77c8b6aaf50a5e4bb6f58'),
            ('ICO/2m/ICO2m_00484.sofa', '50e569bd893fb992fc26e24426f37b61'),
            ('ICO/2m/ICO2m_00486.sofa', 'dd54f6b3329855d6b29980081978dc87'),
            ('ICO/2m/ICO2m_00487.sofa', 'bd81d463644f751d79cf0218f9ff9eae'),
            ('ICO/2m/ICO2m_00489.sofa', 'ec5f6e468dadb32d9051be1852119a13'),
            ('ICO/2m/ICO2m_00490.sofa', '04d6000fdbb184ca353acbcd1e844596'),
            ('ICO/2m/ICO2m_00491.sofa', 'c086604413aac4e6523b47a9808b8a19'),
            ('ICO/2m/ICO2m_00493.sofa', '399a227fe16f33867a0d7a400d600302'),
            ('ICO/2m/ICO2m_00494.sofa', 'ff9dcd695b5cb8614c402d4a2d3b0003'),
            ('ICO/2m/ICO2m_00497.sofa', '9aa615db50243558d9bb4e833d50a48b'),
            ('ICO/2m/ICO2m_00499.sofa', 'e19da68988a5f12afe54b1f6f1fa7347'),
            ('ICO/2m/ICO2m_00500.sofa', '07ec8adc79e6ed8263e7ea064a14b2f8'),
            ('ICO/2m/ICO2m_00501.sofa', '599fefafa2d1945369f418a72f4ed63b'),
            ('ICO/2m/ICO2m_00502.sofa', '41613792961dafd74c2c6a4e670b8367'),
            ('ICO/2m/ICO2m_00503.sofa', 'fa92b6feb3020fd0ef5464c73db219bb'),
            ('ICO/2m/ICO2m_00505.sofa', 'db558b19820085a0f37da586b4b9a031'),
            ('ICO/2m/ICO2m_00506.sofa', '8e7e74055d4a5ef38cc28129d3b3339e'),
            ('ICO/2m/ICO2m_00507.sofa', '7347dbdf587c2688ee71ec875850978c'),
            ('ICO/2m/ICO2m_00508.sofa', '9832bbaaabf0c0f270d0a44fec04dfd9'),
            ('ICO/2m/ICO2m_00509.sofa', 'f9d8512541de32ac9482cd9d64a91e7b'),
            ('ICO/2m/ICO2m_00511.sofa', 'c59a7030d3b5eb1a6609f69c17c23c7e'),
            ('ICO/2m/ICO2m_00512.sofa', 'eea97a052d92c70ec36e292658cf78a4'),
            ('ICO/2m/ICO2m_00513.sofa', '627016d6bdcf43f1b198b435ed249ef5'),
            ('ICO/2m/ICO2m_00514.sofa', 'b3e6c3e0d03cd0461a86d3e4667bacf4'),
            ('ICO/2m/ICO2m_00515.sofa', 'f93d56d525239db3363c54b584142e9c'),
            ('ICO/2m/ICO2m_00516.sofa', '57d315a41f3530c0e1fbcabf1efe9e90'),
            ('ICO/2m/ICO2m_00517.sofa', '81d0c351a7cb85120c1c827ef8b18c19'),
            ('ICO/2m/ICO2m_00518.sofa', '2a740e5d7d37d16f9b8fe3f3efe92333'),
            ('ICO/2m/ICO2m_00519.sofa', '7e541550365f5010402c852c57a238d8'),
            ('ICO/2m/ICO2m_00520.sofa', 'c8b72c94f4b547a55357dadd8f846c10'),
            ('ICO/2m/ICO2m_00521.sofa', 'ef5ba1cae8f3860377bc59ed410fb5b4'),
            ('ICO/2m/ICO2m_00523.sofa', 'fa8bb69049851192f362dc5a9c3ef560'),
            ('ICO/2m/ICO2m_00524.sofa', 'dc34e89408607cfeb48c1bc2e7317979'),
            ('ICO/2m/ICO2m_00525.sofa', 'c5891e42cdc35c537167d10921a076d9'),
            ('ICO/2m/ICO2m_00526.sofa', 'fce10595406850c1345ab329e506d474'),
            ('ICO/2m/ICO2m_00527.sofa', '36edd9829df4efacda9c76f6f83877fd'),
            ('ICO/2m/ICO2m_00528.sofa', '320e5c4128fc699b305c3fcca74c244d'),
            ('ICO/2m/ICO2m_00529.sofa', '0cafe6611a372af554216e33bc00756f'),
            ('ICO/2m/ICO2m_00530.sofa', 'ee3ed75d27105292ee06146362a5da3a'),
            ('ICO/2m/ICO2m_00532.sofa', 'e6d195a6a6771d54a2fc93dcc5ac18a4'),
            ('ICO/2m/ICO2m_00533.sofa', 'cc5bef2bf0d685dfb72f4f29311b0d3f'),
            ('ICO/2m/ICO2m_00534.sofa', 'bb98344ecd6077bc3eb99510d846a487'),
            ('ICO/2m/ICO2m_00536.sofa', '7be9ac4116a6e0f7af31fca0b04be65f'),
            ('ICO/2m/ICO2m_00538.sofa', '8daae2682b3ac409368a649e43ac5922'),
            ('ICO/2m/ICO2m_00539.sofa', '4e37470d41cabf18ffee1f5a69ff926a'),
            ('ICO/2m/ICO2m_00540.sofa', '98fc891fb33a91f44fefa1d477a6fd85'),
            ('ICO/2m/ICO2m_00542.sofa', 'debf780ba27b7ea870832b7dbf3aa332'),
            ('ICO/2m/ICO2m_00543.sofa', 'd6fdb42dd1334a8ed735590b290e8fd1'),
            ('ICO/2m/ICO2m_00544.sofa', '42b72266208337024a9ba442ccf40e36'),
            ('ICO/2m/ICO2m_00545.sofa', '5ab0345accdf5a3d37373ac054b014fc'),
            ('ICO/2m/ICO2m_00546.sofa', '13b26af464259484707ab2266a4a971a'),
            ('ICO/2m/ICO2m_00547.sofa', '004a0a0f3c7e99e8240dfb1002b1463c'),
            ('ICO/2m/ICO2m_00548.sofa', 'b84e5e16c3afbc5964b41add735b7c4c'),
            ('ICO/2m/ICO2m_00549.sofa', '9655ff76ae84c6043ec999dc01b3cf02'),
            ('ICO/2m/ICO2m_00550.sofa', 'da7c72cf513cab3c4681c748ca516cb9'),
            ('ICO/2m/ICO2m_00551.sofa', '69f6cc827dd83f69c0f309e7f2275271'),
            ('ICO/2m/ICO2m_00552.sofa', '711d6f322254d665f187e3d33e6930e6'),
            ('ICO/2m/ICO2m_00553.sofa', 'e4796ec73c057f2094253a411ffef7fa'),
            ('ICO/2m/ICO2m_00555.sofa', 'cf9f5fd56bc87764d6379f4898f390ce'),
            ('ICO/2m/ICO2m_00557.sofa', '914b51e40e1587b29dc4e79bda1b3c38'),
            ('ICO/2m/ICO2m_00558.sofa', 'dc304660c2b79a5cab71fc16c0c05d98'),
            ('ICO/2m/ICO2m_00559.sofa', 'd42c28244f29b475f8e78b5ff285923a'),
            ('ICO/2m/ICO2m_00560.sofa', 'a8674957f41595fe6e8d1ba532e26b35'),
            ('ICO/2m/ICO2m_00561.sofa', 'a7666a49b5da521c2a7a91705fffc52b'),
            ('ICO/2m/ICO2m_00562.sofa', '43cc03315b5f8f0200f6b6b07b39f3c4'),
            ('ICO/2m/ICO2m_00563.sofa', 'a62aa981e3b909d30d09e73cda5f3296'),
            ('ICO/2m/ICO2m_00567.sofa', '93f69d3da8f1d64aeed52ee36cb7c689'),
            ('ICO/2m/ICO2m_00568.sofa', '78a0e78bfc43f83bbb66e4a23c9c77f8'),
            ('ICO/2m/ICO2m_00569.sofa', '28ae0ea29277398a0ad466ed95ca67f9'),
            ('ICO/2m/ICO2m_00570.sofa', '054fd1123f3019c87869ab6307ff1255'),
            ('ICO/2m/ICO2m_00571.sofa', '62acae018a6c16961a3972561421720c'),
            ('ICO/2m/ICO2m_00572.sofa', '153b8d89af3ef928fb67580c614bbe22'),
            ('ICO/2m/ICO2m_00573.sofa', 'aac678015e0237b459a18c8d5cca9f45'),
            ('ICO/2m/ICO2m_00576.sofa', '39d483cf8eaa9f2802fca191439f4fab'),
            ('ICO/2m/ICO2m_00577.sofa', '0f44d10823f7c4d431003e04f9193551'),
            ('ICO/2m/ICO2m_00580.sofa', '0dbea0fc8de29a2379facbe750054770'),
            ('ICO/2m/ICO2m_00582.sofa', '379455b87914fcc7cc13dfa2fc05bf40'),
            ('ICO/2m/ICO2m_00583.sofa', 'edf96036710580a1b8b92a9a1025309b'),
            ('ICO/2m/ICO2m_00585.sofa', 'ed73dfb23e797fbf6a6e0b380b387d38'),
            ('ICO/2m/ICO2m_00588.sofa', '3b892317d266d1cf64db98743fa2a0a4'),
            ('ICO/2m/ICO2m_00590.sofa', 'a33b0a57a0fb4c02e223168b5ca12f7b'),
            ('ICO/2m/ICO2m_00591.sofa', 'd507f7c965ace3a29c5c677288a2ed68'),
            ('ICO/2m/ICO2m_00592.sofa', '559f7b976d3bcfc5cc64f63d876ae5e2'),
            ('ICO/2m/ICO2m_00593.sofa', '9a3f36c23ec317b500a037628ad2ef2e'),
            ('ICO/2m/ICO2m_00594.sofa', 'fd2b5fce7f2fb1508011332af719250d'),
            ('ICO/2m/ICO2m_00595.sofa', 'd825aec61065b76588bae3ea21b859ee'),
            ('ICO/2m/ICO2m_00596.sofa', 'a867af8538c847ddf481736738f6ff93'),
            ('ICO/2m/ICO2m_00597.sofa', '16e5fdd248ba8153a5c59eca848c03c3'),
            ('ICO/2m/ICO2m_00598.sofa', '8e5bd2ed1ff2c24698baac315b2717cb'),
            ('ICO/2m/ICO2m_00599.sofa', 'f4b99900645619a852e5758b78904f02'),
            ('ICO/2m/ICO2m_00600.sofa', 'cd5a88f03d69797a50c7503c4171426a'),
            ('ICO/2m/ICO2m_00601.sofa', 'a4cb364f081ca966956ff2d59ef5e116'),
            ('ICO/2m/ICO2m_00604.sofa', 'c1d601943a1de46c060029c4d80b84b8'),
            ('ICO/2m/ICO2m_00606.sofa', '7b26a46a6c3d860699446e8156a9caea'),
            ('ICO/2m/ICO2m_00608.sofa', '6649eee2c13e58143c81d17ddbb613e4'),
            ('ICO/2m/ICO2m_00609.sofa', '72e0ae886be51e041dde50f1f03d324b'),
            ('ICO/2m/ICO2m_00613.sofa', '07395b8af022dfb0afc164a86495aed6'),
            ('ICO/2m/ICO2m_00616.sofa', '88379f9099545e41b66b527b7e3a59c9'),
            ('ICO/2m/ICO2m_00617.sofa', 'bf5935a8d75fad3723ee7f8020329846'),
            ('ICO/2m/ICO2m_00618.sofa', '65d6772095adc3b849520f90d8818187'),
            ('ICO/2m/ICO2m_00619.sofa', 'a3955485e2a02925072f67795f98e400'),
            ('ICO/2m/ICO2m_00620.sofa', 'c196d64979e311cc6e69950a31143497'),
            ('ICO/2m/ICO2m_00621.sofa', 'cccbb733aee70d4f984e7e300d63f252'),
            ('ICO/2m/ICO2m_00622.sofa', 'cd2e9800910fe539acf56760359bc021'),
            ('ICO/2m/ICO2m_00623.sofa', 'c92b87f3418f593b19f692820454d9ad'),
            ('ICO/2m/ICO2m_00624.sofa', '6c0bb8bd3587ce050fc01387997ad6a0'),
            ('ICO/2m/ICO2m_00625.sofa', '5852741661d10d5706123b78e9d4e16c'),
            ('ICO/2m/ICO2m_00626.sofa', '013672ff2abbc416b611aed31ebfc9d0'),
            ('ICO/2m/ICO2m_00628.sofa', 'af618cc826a8a4d9732d6c3c3bf32a80'),
            ('ICO/2m/ICO2m_00629.sofa', '46be4f432b49d08b9014a7e9b0d53137'),
            ('ICO/2m/ICO2m_00630.sofa', 'aa06256abd044482267b4eb114b92136'),
            ('ICO/2m/ICO2m_00631.sofa', '951dde7c9795109ad1150e765ed661fa'),
            ('ICO/2m/ICO2m_00632.sofa', '811e8c2d5c52f4dd3467d548862dbc68'),
            ('ICO/2m/ICO2m_00633.sofa', '62603941e5719c8db3e5c6e90c42b5ea'),
            ('ICO/2m/ICO2m_00634.sofa', '47357df228778793d177ce5325e3d703'),
            ('ICO/2m/ICO2m_00635.sofa', '6956eae9db94e80977a45e19cb4867f7'),
            ('ICO/2m/ICO2m_00636.sofa', '934b71e288b0527c951cce90888c1c57'),
            ('ICO/2m/ICO2m_00637.sofa', 'b6355a25e4513e24efaec2113c533ff9'),
            ('ICO/2m/ICO2m_00640.sofa', '398947a6d5dd9d8249b73031efb0c4c3'),
            ('ICO/2m/ICO2m_00642.sofa', 'aa7d6121cedae1bb91f838a961d1164f'),
            ('ICO/2m/ICO2m_00643.sofa', '1736e18124f085e366637973ee75fce9'),
            ('ICO/2m/ICO2m_00644.sofa', '4bb7d735a72e5ea788cf905223b7e49d'),
            ('ICO/2m/ICO2m_00645.sofa', '3b12f50ce7eea990ea0b243133e93b96'),
            ('ICO/2m/ICO2m_00646.sofa', '8d6e3b7ff132948aec197d8326bcc55f'),
            ('ICO/2m/ICO2m_00647.sofa', 'f3ace454d8964e906fe71b31a1345845'),
            ('ICO/2m/ICO2m_00648.sofa', 'ade96ba686638be439a35c570ee82091'),
            ('ICO/2m/ICO2m_00649.sofa', '68af5efa7018dee2e438a936ec9b9f46'),
            ('ICO/2m/ICO2m_00650.sofa', '86b53ddc490b92f461ed0e71c13b6afc'),
            ('ICO/2m/ICO2m_00651.sofa', 'f2dc603c5d55dbb3733ecd0d1a83b92c'),
            ('ICO/2m/ICO2m_00654.sofa', '6406d5a49775a1879efa7f0fe735e88c'),
            ('ICO/2m/ICO2m_00655.sofa', '018db060ab3c74a4af51fa317b39aa1d'),
            ('ICO/2m/ICO2m_00657.sofa', 'ff29d07531d8b2f78a811b0c2634246d'),
            ('ICO/2m/ICO2m_00660.sofa', 'dd0aadda01aa0bfd1e41b4fa978b8082'),
            ('ICO/2m/ICO2m_00661.sofa', '090b9709cc4ca515cd19f2eab4c8c951'),
            ('ICO/2m/ICO2m_00662.sofa', 'e16f07e8a17dfb3c534389534fa22dd8'),
            ('ICO/2m/ICO2m_00664.sofa', 'a29c5db94d47c1ca3075a038113b8a7d'),
            ('ICO/2m/ICO2m_00665.sofa', 'bfea59ed84a6346988f37183517e916d'),
            ('ICO/2m/ICO2m_00666.sofa', '2e7d18d6563dd0a5ad98a4e721cdf277'),
            ('ICO/2m/ICO2m_00667.sofa', 'e911fd578c82930513c77d4bbfddaa30'),
            ('ICO/2m/ICO2m_00668.sofa', '34381e034991dd2c35ccbc5bd6b2c17f'),
            ('ICO/2m/ICO2m_00669.sofa', '8a8d53a86ecfb798e22506bbb630f150'),
            ('ICO/2m/ICO2m_00670.sofa', '30692d956a393f4906a5ab088e753b3e'),
            ('ICO/2m/ICO2m_00671.sofa', '11825374737df6d16ec250a500fd42d1'),
            ('ICO/2m/ICO2m_00672.sofa', '3ab5e7d09f66a3db413bdac52b104a1b'),
            ('ICO/2m/ICO2m_00673.sofa', 'e66b7c47bab342dd17509b63dd18e2bb'),
            ('ICO/2m/ICO2m_00674.sofa', '0c4151f7f38c3e1053f1322e5285e741'),
            ('ICO/2m/ICO2m_00675.sofa', 'a3e036eca87d174d35a026885e32c23f'),
            ('ICO/2m/ICO2m_00676.sofa', '677827630d3d69e28c57b775b24e2f18'),
            ('ICO/2m/ICO2m_00677.sofa', '1190088942122d5f0b0f4476f53da8ac'),
            ('ICO/2m/ICO2m_00678.sofa', '3efa6bdb0a407f77055d0322fbd49962'),
            ('ICO/2m/ICO2m_00679.sofa', '447c3113f3b507c4729b051c073f88c8'),
            ('ICO/2m/ICO2m_00680.sofa', 'a196b504e6b97d985bd3388f49869cbc'),
            ('ICO/2m/ICO2m_00681.sofa', 'e390cdb8e91220d851d15a32890fd595'),
            ('ICO/2m/ICO2m_00682.sofa', '40b02fec2f90626d6152082f20b7c70f'),
            ('ICO/2m/ICO2m_00684.sofa', 'c8ce3aa726424fb7e5835eadba362d2f'),
            ('ICO/2m/ICO2m_00685.sofa', 'd09ab86e01956f1ff3f062cfc07ea1f4'),
            ('ICO/2m/ICO2m_00686.sofa', '9c9fe508a8d222bde7d57a8fccd864d1'),
            ('ICO/2m/ICO2m_00688.sofa', '7d4e7869f22b2618f046c48e30fbbc27'),
            ('ICO/2m/ICO2m_00689.sofa', '10a77f81f3606d465e8d54ac20bfdd14'),
            ('ICO/2m/ICO2m_00690.sofa', '25718ca4ade3f1bf7134ec74474038a4'),
            ('ICO/2m/ICO2m_00693.sofa', '02d7fe1fc6a0cf79cba48beb3f1d3923'),
            ('ICO/2m/ICO2m_00695.sofa', '720ed9752ec713e697c99cafa01842be'),
            ('ICO/2m/ICO2m_00696.sofa', '55f15f2ff5718d20e70a488be56c0837'),
            ('ICO/2m/ICO2m_00697.sofa', 'cb476ce21f9a033a154f069e8f99a499'),
            ('ICO/2m/ICO2m_00698.sofa', '9e8815a3528f06f6f5280c4bd60313fd'),
            ('ICO/2m/ICO2m_00699.sofa', 'f3dc2be8143e6cb2f2e46b2a46683820'),
            ('ICO/2m/ICO2m_00700.sofa', '65c442efc38bcb62487199bbbde0d972'),
            ('ICO/2m/ICO2m_00701.sofa', '58dd455ad22d05c2cfd674197b6bf91f'),
            ('ICO/2m/ICO2m_00702.sofa', 'c9a71b97395f05b328cafecaac9d1e1e'),
            ('ICO/2m/ICO2m_00704.sofa', 'f615b18976881560c9a5a993d8497476'),
            ('ICO/2m/ICO2m_00705.sofa', '5f10f2e731e7c3f14efb0a4198821952'),
            ('ICO/2m/ICO2m_00707.sofa', 'cd73d788a6b7b70cf3e07e4084ceb5a2'),
            ('ICO/2m/ICO2m_00709.sofa', '3ed3235556eecd13256bd2aea0e70f5c'),
            ('ICO/2m/ICO2m_00710.sofa', '1c96ef2f7573869231ec626dc3ff1da3'),
            ('ICO/2m/ICO2m_00711.sofa', '9262fb72e71c98e70eff367e6a4f9d37'),
            ('ICO/2m/ICO2m_00712.sofa', '16dfe0ae914295ac6554c3bcf291a4d9'),
            ('ICO/2m/ICO2m_00713.sofa', '2577086111d3c255d4381087c284db47'),
            ('ICO/2m/ICO2m_00714.sofa', 'e1fc671d44ab1c2e38f10bdc361b8c56'),
            ('ICO/2m/ICO2m_00717.sofa', '5a607c583d2da29ef6871d63a75265ac'),
            ('ICO/2m/ICO2m_00718.sofa', 'eb0832e6babeb543c67a626c168634eb'),
            ('ICO/2m/ICO2m_00719.sofa', '4097d3c3121518f39db1dd91e743a8ce'),
            ('ICO/2m/ICO2m_00720.sofa', '0a73a89d7d64f6febddefd72eda6f356'),
            ('ICO/2m/ICO2m_00722.sofa', '74ba45c07eaef0838949cb7f69160cca'),
            ('ICO/2m/ICO2m_00723.sofa', '3981e485caff7f4cf3baac1bc7bffc59'),
            ('ICO/2m/ICO2m_00724.sofa', '141da26795f9978af7e33d43d3d9a816'),
            ('ICO/2m/ICO2m_00725.sofa', '1c37a2db2c97c9a0ea03ece47a9b37c9'),
            ('ICO/2m/ICO2m_00726.sofa', '454a7f81f9c9fd9880c5c6f0f8f5b337'),
            ('ICO/2m/ICO2m_00727.sofa', '068a068f357343f25ece3eca49c3c0ea'),
            ('ICO/2m/ICO2m_00729.sofa', '4cd8f4df513913f18a526d1cd6ae8695'),
            ('ICO/2m/ICO2m_00730.sofa', 'eac154a40566d468b578ed14d4e9184d'),
            ('ICO/2m/ICO2m_00732.sofa', '977fd4c3ed94e06c372406780ded133f'),
            ('ICO/2m/ICO2m_00734.sofa', 'ed4c1dffefee49e494e1617abe5e0a4f'),
            ('ICO/2m/ICO2m_00735.sofa', '3f4db679b610984cce6faf13ddc64e55'),
            ('ICO/2m/ICO2m_00736.sofa', 'e49515bb534168862e9be6a746542136'),
            ('ICO/2m/ICO2m_00740.sofa', 'e116b6ff44b8018195e6f64314eada96'),
            ('ICO/2m/ICO2m_00742.sofa', '0238b778692c9aefaa7a152d52c86bd9'),
            ('ICO/2m/ICO2m_00744.sofa', '72ec681f73346c21d91ddbe6c32f81b3'),
            ('ICO/2m/ICO2m_00745.sofa', '4184910c4fc47f8103f41bbbf8c84b53'),
            ('ICO/2m/ICO2m_00746.sofa', '69afe61f21aacd5494a996ded23c25ca'),
            ('ICO/2m/ICO2m_00747.sofa', '96123c03524d363fabb45c32721b780c'),
            ('ICO/2m/ICO2m_00748.sofa', 'd71a500d30de997373ff8fca2b51bfff'),
            ('ICO/2m/ICO2m_00749.sofa', '4df8926cc744ecf5872ebec73a715695'),
            ('ICO/2m/ICO2m_00750.sofa', '3efa4e75c1554774a42c1915de67fc71'),
            ('ICO/2m/ICO2m_00751.sofa', '17a38bee136b8f66100deb16553733bb'),
            ('ICO/2m/ICO2m_00753.sofa', 'f9d96da0157670816c335d01bb1ee893'),
            ('ICO/2m/ICO2m_00754.sofa', '75237e719d765348f3ff653d4be81018'),
            ('ICO/2m/ICO2m_00755.sofa', 'c01536f0db222c1be60a444d04475d10'),
            ('ICO/2m/ICO2m_00756.sofa', 'dc8ea6301025ec92a73eed13d23b4cfc'),
            ('ICO/2m/ICO2m_00757.sofa', 'f27992d56d9e47eade02ed6066d707d7'),
            ('ICO/2m/ICO2m_00758.sofa', '50cc12103241f90e74a016a9f8ba60be'),
            ('ICO/2m/ICO2m_00760.sofa', 'f5fd858f84c2c9873981a440b4f41343'),
            ('ICO/2m/ICO2m_00761.sofa', '3ef1dd508b7915f67367c425043f7aa2'),
            ('ICO/2m/ICO2m_00763.sofa', 'b7ee59e282da125e4d4f4ea79dcc2e3c'),
            ('ICO/2m/ICO2m_00764.sofa', 'b7511f9a35e4a874dbeaefc1fc779cd7'),
            ('ICO/2m/ICO2m_00766.sofa', 'e14cc80d66ba92e2aa308f3600c21cc4'),
            ('ICO/2m/ICO2m_00767.sofa', 'cd36909fbf79359c2973f7ab5e4455ae'),
            ('ICO/2m/ICO2m_00768.sofa', 'a0a7d3196a2c2b220ffc9a9c15dde64d'),
            ('ICO/2m/ICO2m_00769.sofa', '611d78aaedbcc3621d6c36c29860eae1'),
            ('ICO/2m/ICO2m_00770.sofa', '784c7d031fbf1d135ce9f4686139e676'),
            ('ICO/2m/ICO2m_00771.sofa', 'd4c2e6b36e1611e8163681079b0c4c4d'),
            ('ICO/2m/ICO2m_00772.sofa', '63fe2a238cec811510c64c88d384283b'),
            ('ICO/2m/ICO2m_00773.sofa', '7cd87bf9738e4f2a07eb288b5d0189c5'),
            ('ICO/2m/ICO2m_00774.sofa', 'bd78225fd3e01c81699966e535980f27'),
            ('ICO/2m/ICO2m_00775.sofa', 'fe6e8ecaae13afb107923d1507a565a2'),
            ('ICO/2m/ICO2m_00778.sofa', '35393f0e47ac550a36f1292a0fd99d20'),
            ('ICO/2m/ICO2m_00779.sofa', '6f6954d695296aa95282c6335971f019'),
            ('ICO/2m/ICO2m_00780.sofa', 'a2f275d000ffe3b227844ddf2d706b26'),
            ('ICO/2m/ICO2m_00782.sofa', '8030c23acb442db54043411f26d2f3e3'),
            ('ICO/2m/ICO2m_00783.sofa', '21b7aedeab0e661f9c0f9310967cea29'),
            ('ICO/2m/ICO2m_00787.sofa', '0bc4338c444342501114e50c750f241a'),
            ('ICO/2m/ICO2m_00788.sofa', 'ad9703533c5f5a66dd5f15e3193feec6'),
            ('ICO/2m/ICO2m_00789.sofa', '878f0c32268a99f9aabcecbca8a2c68c'),
            ('ICO/2m/ICO2m_00791.sofa', '046952c826274f55f0c8bb7b915228f3'),
            ('ICO/2m/ICO2m_00794.sofa', 'd8559ca81f85f6deb1940f9ca7ecf6a7'),
            ('ICO/2m/ICO2m_00795.sofa', '70d3f506753dd736c8b3b4c6fc46af8d'),
            ('ICO/2m/ICO2m_00797.sofa', 'da47a5814e7385e0d04d50b96ac70613'),
            ('ICO/2m/ICO2m_00798.sofa', 'b3012bafb246e0152488aa89fc5c7cad'),
            ('ICO/2m/ICO2m_00799.sofa', 'b1f9956c41f92c94e4413ff4b6709f98'),
            ('ICO/2m/ICO2m_00800.sofa', '901c53562ed08f4baaa9a5cc5a4e2114'),
            ('ICO/2m/ICO2m_00801.sofa', 'ee4b6e7bb76278103225f1cdff9ae2e3'),
            ('ICO/2m/ICO2m_00802.sofa', '846e452c3197756de578efac794afb8a'),
            ('ICO/2m/ICO2m_00803.sofa', 'bbb0777691e9bf63980590374cf941e1'),
            ('ICO/2m/ICO2m_00804.sofa', 'eb8c0972f45920c4e8ba76af53aba853'),
            ('ICO/2m/ICO2m_00805.sofa', '25c16420f9ca4ee9c8e230a4de8c4f92'),
            ('ICO/2m/ICO2m_00806.sofa', '5bea8421bf0401db9ed20606941229be'),
            ('ICO/2m/ICO2m_00807.sofa', 'faf5b235ef1eedfd63ea995945176c02'),
            ('ICO/2m/ICO2m_00809.sofa', '0516db549df2c867a4ab39930165349e'),
            ('ICO/2m/ICO2m_00810.sofa', '5d96c47cddb6e84ce353fe9d0f4eadef'),
            ('ICO/2m/ICO2m_00811.sofa', 'c159736d5cd8e80fe6e490307e83fd06'),
            ('ICO/2m/ICO2m_00812.sofa', '7aa760d6770081de9aae0a2ef879a31d'),
            ('ICO/2m/ICO2m_00815.sofa', 'fb072383865eaab9ec54b9dcb9937d1a'),
            ('ICO/2m/ICO2m_00816.sofa', '64b2691b70ba629a01200eae127d1ba0'),
            ('ICO/2m/ICO2m_00817.sofa', '1913ba9e957d123f42950ad83834b311'),
            ('ICO/2m/ICO2m_00818.sofa', 'a15c709d4d9ee0027a5d9cef04ea8c61'),
            ('ICO/2m/ICO2m_00819.sofa', '94a2552582245cdd5dbb2aeb8e4505db'),
            ('ICO/2m/ICO2m_00821.sofa', 'd757a8b4bed5f141caafc734c78e6168'),
            ('ICO/2m/ICO2m_00822.sofa', 'bd9dd20817e5ccb81279eb36c29bd28e'),
            ('ICO/2m/ICO2m_00823.sofa', '09eabac92cff883b8b362effec506bd3'),
            ('ICO/2m/ICO2m_00824.sofa', 'c1197d41f00a72fa68e82c2abbdbb4ce'),
            ('ICO/2m/ICO2m_00825.sofa', 'be61a6a67867b99716a504783e9a360d'),
            ('ICO/2m/ICO2m_00826.sofa', 'fcf915b94dbed3abdd8ac34bbda9e203'),
            ('ICO/2m/ICO2m_00827.sofa', '57b321e79ec59ad5f18a547ced694813'),
            ('ICO/2m/ICO2m_00829.sofa', '24eba8c8a5ae1c9eb37c0b7d62beb28a'),
            ('ICO/2m/ICO2m_00830.sofa', '02e165916efe8b4e6f313f060c93c508'),
            ('ICO/2m/ICO2m_00833.sofa', 'f780685891fbeb5f00970552bdc2872d'),
            ('ICO/2m/ICO2m_00835.sofa', 'c1798e746252a3ea3940fd66ef235637'),
            ('ICO/2m/ICO2m_00836.sofa', '204950f95ea6a95d2c10ef6645a9f687'),
            ('ICO/2m/ICO2m_00837.sofa', 'e4c1a0c2e0808d236559309c075d11fb'),
            ('ICO/2m/ICO2m_00838.sofa', '2b5ef0cedebdab34da0626b0d02129f4'),
            ('ICO/2m/ICO2m_00839.sofa', '051b3ad85af6561e19e8f78e89c9a702'),
            ('ICO/2m/ICO2m_00840.sofa', 'fe4040909c784a937deb97a5fad6bfa8'),
            ('ICO/2m/ICO2m_00841.sofa', '87c8b548c87d63bb6db1a081b9f107ac'),
            ('ICO/2m/ICO2m_00842.sofa', '76371f66136a03fa66b67f47e558ff05'),
            ('ICO/2m/ICO2m_00843.sofa', '39e056c64c09ee37917df9c45fac47a4'),
            ('ICO/2m/ICO2m_00844.sofa', '1d2a42112be5f28db7943fab208cfae9'),
            ('ICO/2m/ICO2m_00845.sofa', '78d29aced21556af24426609883dddda'),
            ('ICO/2m/ICO2m_00846.sofa', '74cb220ed3a97919d975b493895a2f43'),
            ('ICO/2m/ICO2m_00850.sofa', 'b74b173850e4d7a19f7cc595334b33b9'),
            ('ICO/2m/ICO2m_00852.sofa', '673456024f4bb38e52a5007c4fd95190'),
            ('ICO/2m/ICO2m_00853.sofa', '881dea098b86ca3a4ea1caf4912f12fb'),
            ('ICO/2m/ICO2m_00855.sofa', '76200565c3545c8a382a0405669eccea'),
            ('ICO/2m/ICO2m_00857.sofa', '9efa55fa116f2d5f4e953ead03f2f6bf'),
            ('ICO/2m/ICO2m_00858.sofa', '768fb81e1f1a25338cefef42a5a91c88'),
            ('ICO/2m/ICO2m_00859.sofa', 'd4c2ae67dd058414fa9219b89bbc4511'),
            ('ICO/2m/ICO2m_00860.sofa', 'dc3129c11d543396bcb8375d2f18f0ff'),
            ('ICO/2m/ICO2m_00861.sofa', 'dc908d6d4f793bdbd0acef2aa1f63043'),
            ('ICO/2m/ICO2m_00863.sofa', '5f020c118dd02b247c92ee78c7a9f653'),
            ('ICO/2m/ICO2m_00864.sofa', 'dfdd3f0f31b56dacc61a65c75c954c42'),
            ('ICO/2m/ICO2m_00865.sofa', 'fcbb7889f75376c81ca4f355b2d4e356'),
            ('ICO/2m/ICO2m_00866.sofa', 'acc5e8854ac89a80974c363bbf9b095b'),
            ('ICO/2m/ICO2m_00867.sofa', '1cd9dfaa68f2b68de0ce9f5630ea45d4'),
            ('ICO/2m/ICO2m_00868.sofa', '37291baf54e73440f3ba0a4ddcb99c30'),
            ('ICO/2m/ICO2m_00869.sofa', '883f95ee2f0aa03733e50bd7a47035cb'),
            ('ICO/2m/ICO2m_00870.sofa', 'ae9df26dea7e1d339ed22ad6010eaa6c'),
            ('ICO/2m/ICO2m_00872.sofa', '704c4c4bb8221270bca9787e951aadfc'),
            ('ICO/2m/ICO2m_00875.sofa', '7980d9ff590e142739ffe9aa0c8e21c0'),
            ('ICO/2m/ICO2m_00877.sofa', '055cf688987556319c20bd243c2da607'),
            ('ICO/2m/ICO2m_00880.sofa', '6cfa91c25d69d0df4218b99944f67b10'),
            ('ICO/2m/ICO2m_00882.sofa', 'cde56264cdd22b88b26b19b02056b59d'),
            ('ICO/2m/ICO2m_00883.sofa', 'c28b8f0037d91e404687a17a22ce54c3'),
            ('ICO/2m/ICO2m_00884.sofa', 'dc9c2c98543afaebd2e8099159192037'),
            ('ICO/2m/ICO2m_00887.sofa', '096b6e8da7dd0a4c58bdcb0bf734addd'),
            ('ICO/2m/ICO2m_00889.sofa', 'e5ed8a6c22b9034bfb27ab06bc4ae97f'),
            ('ICO/2m/ICO2m_00890.sofa', '5edd8c540512f9c4d3045a8e243877b0'),
            ('ICO/2m/ICO2m_00891.sofa', 'd396f54f2315120b71c8cd63782f133c'),
            ('ICO/2m/ICO2m_00892.sofa', '8e01521c6783c1a8d683e90c8705d9b7'),
            ('ICO/2m/ICO2m_00893.sofa', '883a8ca49fc9e75c3581bc4f195767e8'),
            ('ICO/2m/ICO2m_00894.sofa', '8a8996b1bf5cd008118fad52a3ce87e6'),
            ('ICO/2m/ICO2m_00895.sofa', 'bf9d90551448ffe83281f31ec717ea55'),
            ('ICO/2m/ICO2m_00896.sofa', '18a87608dccdb24b675c5e79933e36ff'),
            ('ICO/2m/ICO2m_00897.sofa', '36042288acca8c4c5c68dc149b7334a5'),
            ('ICO/2m/ICO2m_00898.sofa', '4fcf18ae4a2732e19efea533a89c5a6b'),
            ('ICO/2m/ICO2m_00899.sofa', 'e31457bf1a63da8f53ed8cda113b4a11'),
            ('ICO/2m/ICO2m_00900.sofa', '7f682ad0544b5cfcc94bc980adab9eba'),
            ('ICO/2m/ICO2m_00901.sofa', '4a1ebbc13038787c51684759d29b0c1f'),
            ('ICO/2m/ICO2m_00902.sofa', '410a2390e624789ab29ebc0ce2bea2d0'),
            ('ICO/2m/ICO2m_00903.sofa', '5afb62726907564d71c1f586ece43683'),
            ('ICO/2m/ICO2m_00904.sofa', '6d5aee96b0967820e3bed21f92defe79'),
            ('ICO/2m/ICO2m_00906.sofa', 'fb6c1dd777a230915e20d9faba94b80e'),
            ('ICO/2m/ICO2m_00907.sofa', '048a32c22850c8e6c3e98f6a318a6680'),
            ('ICO/2m/ICO2m_00908.sofa', '0326764e18945fed509a81550caf0383'),
            ('ICO/2m/ICO2m_00910.sofa', '92389d1f4fee422419828a48161afacc'),
            ('ICO/2m/ICO2m_00911.sofa', 'be9c90b9486552db3efc2d3bcde748e6'),
            ('ICO/2m/ICO2m_00913.sofa', 'c6be0e272ce42470461cdd1e12cec6dc'),
            ('ICO/2m/ICO2m_00915.sofa', '209928ef1ffc593dffbe534b1e552c81'),
            ('ICO/2m/ICO2m_00918.sofa', 'ad1c9ba503069ec8a2276273fe67ebb6'),
            ('ICO/2m/ICO2m_00919.sofa', 'a456ee987c93a7dabaae9f88d4fbda2e'),
            ('ICO/2m/ICO2m_00920.sofa', '0560ac9f885922339a5e11d2a8e1fcf8'),
            ('ICO/2m/ICO2m_00921.sofa', '0f8b19a5416076198e7db0267d94f040'),
            ('ICO/2m/ICO2m_00923.sofa', '8bf173fb506fc081e385de4759f7dc88'),
            ('ICO/2m/ICO2m_00924.sofa', '9ff55b8db376beb34630c6f71ac3d1e4'),
            ('ICO/2m/ICO2m_00925.sofa', '4e676cb815c3a4321237fea3bc04b224'),
            ('ICO/2m/ICO2m_00926.sofa', '198fd1aac9ed96c680a68b64f83081c9'),
            ('ICO/2m/ICO2m_00927.sofa', 'e1dafac99979fa0a8d86ffacecf931db'),
            ('ICO/2m/ICO2m_00929.sofa', '92c1fb752e767da138da7a146073aa2a'),
            ('ICO/2m/ICO2m_00930.sofa', 'a8a65f477e4747deca5ce412d57c993e'),
            ('ICO/2m/ICO2m_00931.sofa', '8755af14a5468764ee59ed78656e813a'),
            ('ICO/2m/ICO2m_00932.sofa', '7b4512d020ff4d570fe0278d759f8f2b'),
            ('ICO/2m/ICO2m_00934.sofa', 'c645c07d0c7881284c243eec57e4fe3f'),
            ('ICO/2m/ICO2m_00936.sofa', 'b9855ed61c9dd37fdad499b01d4d7c21'),
            ('ICO/2m/ICO2m_00937.sofa', '98272d56d039abe8933d6db423c3031d'),
            ('ICO/2m/ICO2m_00939.sofa', '2a3cf4f6ddea283ed7ea49adc684d2fe'),
            ('ICO/2m/ICO2m_00940.sofa', '71b7c75a6f9ce348eaebdd3917195b2b'),
            ('ICO/2m/ICO2m_00942.sofa', '7339c40dc8d5fad19258526e04685d0a'),
            ('ICO/2m/ICO2m_00944.sofa', '8bcfefcfc5d935b5c60be4adb1d482d8'),
            ('ICO/2m/ICO2m_00946.sofa', '89307b135e5ed8943935d87b1f3b1404'),
            ('ICO/2m/ICO2m_00947.sofa', '09f6415d5747e0405900cbc0a60afb51'),
            ('ICO/2m/ICO2m_00951.sofa', '8800bdc2ea7ba00b5c093189ac69a324'),
            ('ICO/2m/ICO2m_00952.sofa', '0fe7da6b32351c126925936051aa0bd5'),
            ('ICO/2m/ICO2m_00953.sofa', 'c2f36ce124b6046d6ed5eeb2ce5d6ce7'),
            ('ICO/2m/ICO2m_00954.sofa', 'd8f646031f72937cc200bc04bb64018d'),
            ('ICO/2m/ICO2m_00955.sofa', '2fd16b0d805858382b6a1506c2f67a2e'),
            ('ICO/2m/ICO2m_00956.sofa', '973a9b86682de11abaec28d9f9e55523'),
            ('ICO/2m/ICO2m_00961.sofa', '3c10073be71ad6e99012754d0f4a6127'),
            ('ICO/2m/ICO2m_00962.sofa', 'a2816be5a18b21f5f6c4bd40a89b7505'),
            ('ICO/2m/ICO2m_00963.sofa', 'e387e6ff9206e62d607115c6bb9073b5'),
            ('ICO/2m/ICO2m_00965.sofa', '2e34f6ec41b3936c2fc70f1de1c68b82'),
            ('ICO/2m/ICO2m_00966.sofa', 'd4761e5d75815ae4e3c16c619a004024'),
            ('ICO/2m/ICO2m_00967.sofa', 'c395189d34abd3918dbc460d55c3e7cf'),
            ('ICO/2m/ICO2m_00968.sofa', '4930eefa0bbc0b8ed2e2a9820adc1d36'),
            ('ICO/2m/ICO2m_00969.sofa', '917a7a2637c84311d065a96c9e2255d2'),
            ('ICO/2m/ICO2m_00971.sofa', '3db5848cbe7c1fae709fa748fe2ea1a4'),
            ('ICO/2m/ICO2m_00972.sofa', '1632865aed73616d7933243add8057c9'),
            ('ICO/2m/ICO2m_00973.sofa', 'df8c804bef2be316c9cbfa3886a9d608'),
            ('ICO/2m/ICO2m_00975.sofa', '51529c85f9971508a2900b024cec103b'),
            ('ICO/2m/ICO2m_00976.sofa', 'e7ce9982142d22783b5fa9b87c401053'),
            ('ICO/2m/ICO2m_00977.sofa', 'ee6f2e9f16756ce94f4726d2febe7be7'),
            ('ICO/2m/ICO2m_00978.sofa', 'b153add57ccf118a28aedada79c449dd'),
            ('ICO/2m/ICO2m_00979.sofa', 'f287ef3b42b43dbc62501ccee6a98c92'),
            ('ICO/2m/ICO2m_00980.sofa', 'bedd92748b758d76198aafa0b77a11ef'),
            ('ICO/2m/ICO2m_00981.sofa', 'ccc1e6323abd79ba0723fe370c7b369f'),
            ('ICO/2m/ICO2m_00982.sofa', 'f5bdb05b0fbe60d66fa75a04997c818c'),
            ('ICO/2m/ICO2m_00984.sofa', '2f324bdd957514a6261fc99ae1e160fd'),
            ('ICO/2m/ICO2m_00985.sofa', 'f60bb8c28247acca673fcb881b58f723'),
            ('ICO/2m/ICO2m_00986.sofa', 'ef8e0a0e2edcc4b01be6edb168ea54c8'),
            ('ICO/2m/ICO2m_00987.sofa', '97102e4303b7169d270eff4601017563'),
            ('ICO/2m/ICO2m_00991.sofa', '4dd9f64ee1542863f519b2948ece5789'),
            ('ICO/2m/ICO2m_00993.sofa', '1d2cc8f66ce44ef08a0c20e8f1f9d0f5'),
            ('ICO/2m/ICO2m_00995.sofa', '487782e13aaf35226af369f8f31e9a63'),
            ('ICO/2m/ICO2m_00996.sofa', '33d0ee918d93f01e6a3523a8f94e63c8'),
            ('ICO/2m/ICO2m_00997.sofa', 'ad34883da3eaa17bfdfab5f411e74778'),
            ('ICO/2m/ICO2m_00998.sofa', '48248aa2487c9d9508ddc5e98d093c7a'),
            ('ICO/2m/ICO2m_00999.sofa', '3ee84299c7dd282323258627b924d044'),
            ('ICO/2m/ICO2m_01000.sofa', 'ae0ad936daaf7d10998ff1c8906c0cbf'),
            ('ICO/2m/ICO2m_01002.sofa', 'f258f30c42ae5492fefc2badf19b3f8b'),
            ('ICO/2m/ICO2m_01003.sofa', 'd17630a9feb48b3912a799264cfbdb73'),
            ('ICO/2m/ICO2m_01004.sofa', '0c2dd0394eb4cf4d5c7f669016950ee3'),
            ('ICO/2m/ICO2m_01005.sofa', 'cbd65b26a571a48ce0cc1deaaa9e947c'),
            ('ICO/2m/ICO2m_01006.sofa', '323f6b2bfb8167d72a6caa9ba280eecf'),
            ('ICO/2m/ICO2m_01008.sofa', '7306b54f731565a2ea92e87866b25f97'),
            ('ICO/2m/ICO2m_01009.sofa', 'd790f97504110fa28d310e1a3186ec3a'),
            ('ICO/2m/ICO2m_01010.sofa', '23dddbf51d3ae6162cc697a9d9173d75'),
            ('ICO/2m/ICO2m_01011.sofa', '8ae1317452381913f70490eb96ff99f6'),
            ('ICO/2m/ICO2m_01012.sofa', '68f6457c8d9ca01e57736105574a4e23'),
            ('ICO/2m/ICO2m_01013.sofa', '3fb056930544614afcc1aa3177f89491'),
            ('ICO/2m/ICO2m_01016.sofa', 'b71721c1f3069ccc4686a30f2739c925'),
            ('ICO/2m/ICO2m_01017.sofa', 'a92a068bfba1f5e78dc4314fedfc52e9'),
            ('ICO/2m/ICO2m_01018.sofa', 'cf11d20966d2b0e0e66cd260cbce8c00'),
            ('ICO/2m/ICO2m_01019.sofa', 'd4cca37b640c8bd2b3e7791a8d11e0f5'),
            ('ICO/2m/ICO2m_01020.sofa', '3f68f96301628366829f8bec3c005544'),
            ('ICO/2m/ICO2m_01022.sofa', 'ddcb47d8b0de139e3980329beb184e94'),
            ('ICO/2m/ICO2m_01024.sofa', '0a156fb16e6a9669010ca267302549c8'),
            ('ICO/2m/ICO2m_01027.sofa', '57d9c23b24e30cc293f3db6a9a4be0bd'),
            ('ICO/2m/ICO2m_01028.sofa', '65a85649026def80b33cc7296f4b70eb'),
            ('ICO/2m/ICO2m_01030.sofa', 'f8d946f7e0a9b3eb15d32ce40912fd15'),
            ('ICO/2m/ICO2m_01031.sofa', '1019153eb1c205751f12428632c8e5a8'),
            ('ICO/2m/ICO2m_01032.sofa', '615962a079d4389fe7363e4ed95bb2d2'),
            ('ICO/2m/ICO2m_01033.sofa', 'd2137489d02f8ee106a21d0997fc6b56'),
            ('ICO/2m/ICO2m_01035.sofa', '76fe4da1c17451a0813b69142068bab3'),
            ('ICO/2m/ICO2m_01036.sofa', 'eb1e373f2d74e35d3768ce55ebe7fa89'),
            ('ICO/2m/ICO2m_01037.sofa', 'cc48b5e2ad6e1dfd7adee60015425e28'),
            ('ICO/2m/ICO2m_01038.sofa', '9c9d8a36e04bf5583c8e20c9f37f66c1'),
            ('ICO/2m/ICO2m_01039.sofa', 'f2dad7cce57a4ee86faede58c790470a'),
            ('ICO/2m/ICO2m_01040.sofa', 'f302f0b59fb0874241c9b9d8cc5f5080'),
            ('ICO/2m/ICO2m_01042.sofa', 'c52b2c9831b2a5d8bd20091c4505a138'),
            ('ICO/2m/ICO2m_01044.sofa', 'd3ed1ff390806cc87b9d2076c1da1cb8'),
            ('ICO/2m/ICO2m_01046.sofa', '1c1014cd4134304745457fc522f91c8b'),
            ('ICO/2m/ICO2m_01047.sofa', '00ac89195fa0678749f614328fbb7376'),
            ('ICO/2m/ICO2m_01048.sofa', '230aac13d977522377589f51112f5106'),
            ('ICO/2m/ICO2m_01049.sofa', '8c293936b5dba2f2a70aa73896ae19d4'),
            ('ICO/2m/ICO2m_01050.sofa', 'f9153547bad216951316f2a0d6c5d8c6'),
            ('ICO/2m/ICO2m_01052.sofa', '91fa306985e5fe2d7385b5ec77f6422c'),
            ('ICO/2m/ICO2m_01053.sofa', 'ccbc41d792e7a191d020e23fa58b0c95'),
            ('ICO/2m/ICO2m_01055.sofa', '17c68aaaa84f042bc9bb216314ee2d60'),
            ('ICO/2m/ICO2m_01057.sofa', '21e49b775685dbd621bec2489c028daf'),
            ('ICO/2m/ICO2m_01058.sofa', '26007d30c0492608e757d431e828dfd0'),
            ('ICO/2m/ICO2m_01060.sofa', '6c7726b4bb3a6b71c284eab7a36273b7'),
            ('ICO/2m/ICO2m_01061.sofa', '790e3656845c3a8c5c55fc9ad8f8b2b4'),
            ('ICO/2m/ICO2m_01062.sofa', '3489999321f7704fc60ede19fa0fd5fb'),
            ('ICO/2m/ICO2m_01063.sofa', 'c1d69b70fe1dbd5e18febf8875d8dfea'),
            ('ICO/2m/ICO2m_01064.sofa', 'e4971dcba4ab73a638962e0ef7066729'),
            ('ICO/2m/ICO2m_01065.sofa', '6f71d5e730a8bac38803f562c69ef251'),
            ('ICO/2m/ICO2m_01066.sofa', 'e65b66e78cf32fd292e05bb58b143dbd'),
            ('ICO/2m/ICO2m_01067.sofa', 'edbc4aaeda3f14a78426d15d979e575a'),
            ('ICO/2m/ICO2m_01069.sofa', '0b432ac94724159503d1c00963cd5984'),
            ('ICO/2m/ICO2m_01071.sofa', '61970ed1444c6c9b5d77f992368f4bb3'),
            ('ICO/2m/ICO2m_01073.sofa', '6a64b91afb6675640515395e7d97fc31'),
            ('ICO/2m/ICO2m_01075.sofa', 'be45728bd2ba4795e6613080962739eb'),
            ('ICO/2m/ICO2m_01077.sofa', '0ed06ee63c93d129a901d33ebb3bf1d2'),
            ('ICO/2m/ICO2m_01078.sofa', 'b9c8c66647a8fdf9953715848dc8d8fe'),
            ('ICO/2m/ICO2m_01079.sofa', '04cc952b7b8e7e5b2a420f884d83d7fd'),
            ('ICO/2m/ICO2m_01080.sofa', 'd05d0e84a15fef96f0e8f699fac5c6f7'),
            ('ICO/2m/ICO2m_01082.sofa', '147b5045aa4ea3706b0669a3c0eb29d3'),
            ('ICO/2m/ICO2m_01083.sofa', '19121b63e224085d5a09300e982b5dd4'),
            ('ICO/2m/ICO2m_01085.sofa', '43581dcfca2cd616376035692b204a40'),
            ('ICO/2m/ICO2m_01086.sofa', '1f2f77ea08378c7872576a28405e48d4'),
            ('ICO/2m/ICO2m_01087.sofa', '149569d1e40ff2060fa03c4feffaf454'),
            ('ICO/2m/ICO2m_01088.sofa', '16d9a2ca3e1f0f589dd5cc3c5df9ab58'),
            ('ICO/2m/ICO2m_01089.sofa', '91ca88411d4e4c585eb923fbf9cb5611'),
            ('ICO/2m/ICO2m_01091.sofa', '76d38758e49a17f6554ad46ff3d5e636'),
            ('ICO/2m/ICO2m_01092.sofa', '360686e1ea8d7c02aa681ea13636300d'),
            ('ICO/2m/ICO2m_01093.sofa', 'f6a307c59fb203b837d6cb4a3f86e0f7'),
            ('ICO/2m/ICO2m_01094.sofa', 'f876e29a1a691afba9f4f320018b9b44'),
            ('ICO/2m/ICO2m_01097.sofa', 'bf1b4d3f1af5595b103019034a2b20c5'),
            ('ICO/2m/ICO2m_01099.sofa', 'a88855a8f20e2c09d2bf2a0df15cbbe4'),
            ('ICO/2m/ICO2m_01100.sofa', '560a1e00319500b61def048183e4fc21'),
            ('ICO/2m/ICO2m_01101.sofa', 'ca29a1db9c708f2294135c62bd36589a'),
            ('ICO/2m/ICO2m_01102.sofa', '08907ffd9d5825f3ece210fd48d90dba'),
            ('ICO/2m/ICO2m_01103.sofa', '8ce716a7ef75c36964b7bb6f06ab952c'),
            ('ICO/2m/ICO2m_01104.sofa', '1f6740d51551e519e6ee6e4fb4dde7fc'),
            ('ICO/2m/ICO2m_01107.sofa', '1afd723944ba70ebd7b4c829bdf405be'),
            ('ICO/2m/ICO2m_01108.sofa', '857f5eeeaefe8d18a4b44b946399aea8'),
            ('ICO/2m/ICO2m_01109.sofa', '0910594af3702d7e6ed6ad84246b4d4a'),
            ('ICO/2m/ICO2m_01111.sofa', '31012050b366c37932b3e2ad4d6eff1d'),
            ('ICO/2m/ICO2m_01112.sofa', '668713e5e28db9d90d28a011d1e7e0cf'),
            ('ICO/2m/ICO2m_01114.sofa', '6fb4e5985f5fc3833f16a3f938e068cb'),
            ('ICO/2m/ICO2m_01115.sofa', '8b2eed26ea754c4cc8eb0dd797cd3837'),
            ('ICO/2m/ICO2m_01116.sofa', '5a4452b09dd9f624731c3e1ce079558c'),
            ('ICO/2m/ICO2m_01117.sofa', '419efc3b38b2d2bc9d954a0142fb1209'),
            ('ICO/2m/ICO2m_01120.sofa', '40de4b05aa295bc5b6ce5aeb07cd8eda'),
            ('ICO/2m/ICO2m_01121.sofa', '24ab1b0dc28fc6e1c504a0185c32aec4'),
            ('ICO/2m/ICO2m_01122.sofa', 'e2bcac6142e648970ea9c12a4de3f7b4'),
            ('ICO/2m/ICO2m_01125.sofa', 'd151b727471d3d2ccc5e574052b4c14c'),
            ('ICO/2m/ICO2m_01127.sofa', '5c5bd3467400d896f5e45d56974b331b'),
            ('ICO/2m/ICO2m_01128.sofa', '08afac4e576c68b1afcf6f1311534f68'),
            ('ICO/2m/ICO2m_01129.sofa', '262662c80e39f1f5aab7e92866096486'),
            ('ICO/2m/ICO2m_01130.sofa', '5323f6cd4a08eded968418b7500b4f0d'),
            ('ICO/2m/ICO2m_01131.sofa', '3f9d5a54d6925ddc292fb218287bc821'),
            ('ICO/2m/ICO2m_01132.sofa', 'c954b0fdfb640f767767acf1a8094565'),
            ('ICO/2m/ICO2m_01134.sofa', 'da9b8f08498b958bb9d97ac6d5644bcb'),
            ('ICO/2m/ICO2m_01135.sofa', 'aa37bd06b9a4f353b67165e5ac22bd68'),
            ('ICO/2m/ICO2m_01136.sofa', 'd7741897bb06143b09e25e8f97517b72'),
            ('ICO/2m/ICO2m_01137.sofa', '42093f486c545127a4cf8883f3b4f229'),
            ('ICO/2m/ICO2m_01139.sofa', '55902dd49c92ef4e2391dc277e7283f9'),
            ('ICO/2m/ICO2m_01140.sofa', '793ce6f35cff36e7d82ae819f4464cf2'),
            ('ICO/2m/ICO2m_01141.sofa', '889a9cc3f853bf33cebf9fca6d789e28'),
            ('ICO/2m/ICO2m_01142.sofa', '5f4766427e54b006158b4509e59357c4'),
            ('ICO/2m/ICO2m_01143.sofa', '6a197f1cd33c6bb149be13dd3e454d5c'),
            ('ICO/2m/ICO2m_01144.sofa', '2684b2b381f5feac280b189056f1ed10'),
            ('ICO/2m/ICO2m_01145.sofa', '042671cd498d4d30a7868dceaea096cf'),
            ('ICO/2m/ICO2m_01146.sofa', '2c037eb14be771948a9ef42be24ac18e'),
            ('ICO/2m/ICO2m_01147.sofa', '3c73d1ce15ba68011605443510a8d4f1'),
            ('ICO/2m/ICO2m_01148.sofa', 'd1f4e1398c2d845275c57aa10a240761'),
            ('ICO/2m/ICO2m_01149.sofa', '8c100c2837dd358dfebdf1e59a22b9b3'),
            ('ICO/2m/ICO2m_01150.sofa', '37319e5c2dc4fc29e3aba0b581d412c0'),
            ('ICO/2m/ICO2m_01151.sofa', 'f6049fe5835fbd60cd7b6cb0fd20debb'),
            ('ICO/2m/ICO2m_01152.sofa', '214faf932915c1df6494e71cd6e7c33f'),
            ('ICO/2m/ICO2m_01155.sofa', '1b4e1e404b424fa8917d98233668b440'),
            ('ICO/2m/ICO2m_01157.sofa', 'c82e8d389ec78edcfd965eaea1926c4a'),
            ('ICO/2m/ICO2m_01160.sofa', '83b9450d6f9afdd7d63df01a83d6cb77'),
            ('ICO/2m/ICO2m_01162.sofa', '59f2bf53b54a6e6a76b1ab088ec84158'),
            ('ICO/2m/ICO2m_01163.sofa', 'c915dc11d8994a5e0c5a609027702ebb'),
            ('ICO/2m/ICO2m_01164.sofa', '4d2a9a40ade847456c882205e8d2d1c6'),
            ('ICO/2m/ICO2m_01165.sofa', 'f06fdf2271935b023af6d253106399fd'),
            ('ICO/2m/ICO2m_01166.sofa', '985a9241c682590a01aa474ff87dbd40'),
            ('ICO/2m/ICO2m_01168.sofa', '8f8bdcbefc9b8cab9a7f1aa7e0c89742'),
            ('ICO/2m/ICO2m_01171.sofa', '896b8dc36103444c39e955ed12e8e81c'),
            ('ICO/2m/ICO2m_01172.sofa', '7a62d4f478bb199197ab85c4a17fc521'),
            ('ICO/2m/ICO2m_01173.sofa', 'a5043121bf55a2994e1d395ad193bf73'),
            ('ICO/2m/ICO2m_01174.sofa', 'abce96c17ba3cb686f2112a40555e98c'),
            ('ICO/2m/ICO2m_01175.sofa', '33ce2f86a7ded6122cbf2a00f6850f97'),
            ('ICO/2m/ICO2m_01176.sofa', '4e2aba7eab199140889b5c76d78c6aaa'),
            ('ICO/2m/ICO2m_01177.sofa', 'aff592759e205d807766271666eb7bd5'),
            ('ICO/2m/ICO2m_01179.sofa', '70b3e6506b6bca09b2f1051f36e2710d'),
            ('ICO/2m/ICO2m_01181.sofa', '5c83031074e0faf6b478f31e773dc7af'),
            ('ICO/2m/ICO2m_01185.sofa', '6b0b9ac133cdd0a6d9795dd065728b9c'),
            ('ICO/2m/ICO2m_01186.sofa', '0dffd2c0d61f89629d1fa6e4dc868f0c'),
            ('ICO/2m/ICO2m_01189.sofa', '83817d28d78a2f7f1ee78bc16d61cc7a'),
            ('ICO/2m/ICO2m_01190.sofa', 'ff51d36fed65b0443e532baea3ad7db4'),
            ('ICO/2m/ICO2m_01191.sofa', '70b59b72b6bf5331b4ddb67adb7390b9'),
            ('ICO/2m/ICO2m_01192.sofa', 'c5a05367a31dd2c5cc15a629371393b1'),
            ('ICO/2m/ICO2m_01193.sofa', '6703afce88dd8c70f3eb66cd1d4d5954'),
            ('ICO/2m/ICO2m_01194.sofa', '535aeb52d66a9a5c3d89e240f2278e54'),
            ('ICO/2m/ICO2m_01195.sofa', '3f18653d8635da071c4be0c276e256b4'),
            ('ICO/2m/ICO2m_01196.sofa', '31dd5a32dcf876113827506979b4b9ac'),
            ('ICO/2m/ICO2m_01197.sofa', '2158ff6f79071420d427c16aa5610a45'),
            ('ICO/2m/ICO2m_01200.sofa', '0e8444bda0a46f52e16004c8d76a6cd0'),
            ('ICO/2m/ICO2m_01201.sofa', 'e3c2ac395609f685c42d56ea44ad5709'),
            ('ICO/2m/ICO2m_01202.sofa', '8b4155704b664f57ec3d161d1182fef7'),
            ('ICO/2m/ICO2m_01203.sofa', 'e4aecb89e38cbae3ae06bec9a2007eac'),
            ('ICO/2m/ICO2m_01205.sofa', '339505659e6204280d7936105b536bec'),
            ('ICO/2m/ICO2m_01206.sofa', 'ee7decee9d47864d2798e4beec816e5a'),
            ('ICO/2m/ICO2m_01207.sofa', 'e55e37a11e06537e05aea8864da0b0de'),
            ('ICO/2m/ICO2m_01208.sofa', '9023cf4d0feb146c81a0e1777fd2f94d'),
            ('ICO/2m/ICO2m_01209.sofa', '895ac49b3ce3224e2668962f5160b71c'),
            ('ICO/2m/ICO2m_01210.sofa', 'c75158487517fb7cba833d8f5fce9f54'),
            ('ICO/2m/ICO2m_01211.sofa', 'e2be031977a28014beedfefca29c7958'),
            ('ICO/2m/ICO2m_01212.sofa', '50ff38cbeeb739c8f609af0ee667c7d0'),
            ('ICO/2m/ICO2m_01213.sofa', 'e755d423375fd2dd9ed108d16a1f9a7a'),
            ('ICO/2m/ICO2m_01215.sofa', '03ea6db30ad5ba5f5047ce8604496562'),
            ('ICO/2m/ICO2m_01216.sofa', '8fe3e2d117eba7f62b3be5f163ca832b'),
            ('ICO/2m/ICO2m_01217.sofa', '369e23897cccd332a7978ad2dfceb496'),
            ('ICO/2m/ICO2m_01219.sofa', 'dc565cc409a3e40899284a5c4d4de5df'),
            ('ICO/2m/ICO2m_01221.sofa', 'd66f60847cbe765844aa1c51fb98af18'),
            ('ICO/2m/ICO2m_01222.sofa', '7a1e606308b4b880a067da2fffedecec'),
            ('ICO/2m/ICO2m_01223.sofa', '73eca8fd995144f6d1706d390ab20a13'),
            ('ICO/2m/ICO2m_01224.sofa', '4c54db52d307a483de50bb6c1bcb4b72'),
            ('ICO/2m/ICO2m_01225.sofa', '755876c02856e436c4aae198d2b9ee9b'),
            ('ICO/2m/ICO2m_01228.sofa', '4148506941011592542e67b509158ea0'),
            ('ICO/2m/ICO2m_01230.sofa', '385727f09874c8df243f1721064dba57'),
            ('ICO/2m/ICO2m_01231.sofa', '3ce1732b934378551c243ceadce18964'),
            ('ICO/2m/ICO2m_01232.sofa', 'f3c39ae890ff3750cc79682e0e766880'),
            ('ICO/2m/ICO2m_01233.sofa', '98a5e389541029ae83c7c9edbc127551'),
            ('ICO/2m/ICO2m_01234.sofa', 'a23b31c0c7774cc6de648a7896306854'),
            ('ICO/2m/ICO2m_01235.sofa', 'ffa062940d188c24e9e26bd94f1f37eb'),
            ('ICO/2m/ICO2m_01237.sofa', 'aba557b9a3c1bd54411511d808fdaf01'),
            ('ICO/2m/ICO2m_01238.sofa', '017cbe9e52c721c7b0a19d2fdfd253f8'),
            ('ICO/2m/ICO2m_01239.sofa', 'bd253ea78f0a3b0f1f436e50346c16d4'),
            ('ICO/2m/ICO2m_01240.sofa', '3fd3308425e5aad29b599978e7f256ed'),
            ('ICO/2m/ICO2m_01242.sofa', '2931cd2eeb57c4448e53d9642ee54761'),
            ('ICO/2m/ICO2m_01244.sofa', '024b142509579afe24c76f556d20bba0'),
            ('ICO/2m/ICO2m_01245.sofa', 'ba80b625e9efde4318bb6a42bc10df38'),
            ('ICO/2m/ICO2m_01248.sofa', '27cf44aa35541c44cec5113e16afa0db'),
            ('ICO/2m/ICO2m_01251.sofa', 'f7bacc194363ff744b96e263c3bf2723'),
            ('ICO/2m/ICO2m_01252.sofa', 'f95ef7dae5effe0290b2186898a29c5f'),
            ('ICO/2m/ICO2m_01254.sofa', 'b45dbd89ec5f9310a20e1859fa749d3e'),
            ('ICO/2m/ICO2m_01256.sofa', '59bb6ce469377da486791d0556b67deb'),
            ('ICO/2m/ICO2m_01258.sofa', 'd0b196785871e5f8f330824328e26aac'),
            ('ICO/2m/ICO2m_01259.sofa', 'b73e0513cd0725b06282c3ecdbd04c70'),
            ('ICO/2m/ICO2m_01262.sofa', '1ce74e58443e02fdde1bcada3c58714f'),
            ('ICO/2m/ICO2m_01263.sofa', '20024a301cc4565c96e5ac32eb805350'),
            ('ICO/2m/ICO2m_01264.sofa', 'bab1c3e415d02474aa86059a95b7cd14'),
            ('ICO/2m/ICO2m_01265.sofa', '9efc022c25e5fa2c24b09a1aeb5fb73f'),
            ('ICO/2m/ICO2m_01266.sofa', '6d8e356f71e85284aec53556902854c1'),
            ('ICO/2m/ICO2m_01268.sofa', '7ea7fac75bdd368dcee634d1191d4e56'),
            ('ICO/2m/ICO2m_01270.sofa', '99cafd211ddc83800018596e2fad5a50'),
            ('ICO/2m/ICO2m_01271.sofa', 'b670789e6d4e045cc433bb24a9632cd6'),
            ('ICO/2m/ICO2m_01272.sofa', '264e05e0fef6ce9311824fff7721eb74'),
            ('ICO/2m/ICO2m_01273.sofa', '2fff7a16999e59f1e61cdebe5f0b0f6b'),
            ('ICO/2m/ICO2m_01274.sofa', 'd3526798564dcad1c48474c4a7bced56'),
            ('ICO/2m/ICO2m_01275.sofa', 'b26978e7d7dd2608feab771697c68fd9'),
            ('ICO/2m/ICO2m_01276.sofa', 'ab5c13c02e847bd5a4fd0516a548d357'),
            ('ICO/2m/ICO2m_01277.sofa', 'cd720c70c2c7e12f0737f2d15ee6694e'),
            ('ICO/2m/ICO2m_01278.sofa', '982fad0a40dccb24d0fa348e67a9d76e'),
            ('ICO/2m/ICO2m_01279.sofa', '01649cb25c7ba480045d041dabbf7f1b'),
            ('ICO/2m/ICO2m_01280.sofa', '2ea620782a583ce3f0ca4bf00d741a73'),
            ('ICO/2m/ICO2m_01282.sofa', '4a5fba7a900a36aa9aba049ef213d166'),
            ('ICO/2m/ICO2m_01284.sofa', '84803f6dadd1e7da539f7711fa275a0f'),
            ('ICO/2m/ICO2m_01286.sofa', 'ca15eda8e9fe3cc6d7f05dcadfdc3932'),
            ('ICO/2m/ICO2m_01288.sofa', '9e8a500d2f19c8639c773dc5726ef1ae'),
            ('ICO/2m/ICO2m_01290.sofa', 'b811b91b513cfba999c8398c0c2cb18e'),
            ('ICO/2m/ICO2m_01291.sofa', '29da0a3173feb8b9247cf4d8d91d3795'),
            ('ICO/2m/ICO2m_01292.sofa', '3e0871039ad8d60c9b9f2b42700831c0'),
            ('ICO/2m/ICO2m_01293.sofa', 'fe99c1cc277e43be6b47528a625c974a'),
            ('ICO/2m/ICO2m_01294.sofa', '77b02f6477c573273fc3bebda009bbfa'),
            ('ICO/2m/ICO2m_01295.sofa', '179e8027c3d679ffd104f9382f70017b'),
            ('ICO/2m/ICO2m_01296.sofa', '7505e08441ef72b04ad7f4de122d3234'),
            ('ICO/2m/ICO2m_01298.sofa', '4296f38399d9b8ff470457f37f5a96ac'),
            ('ICO/2m/ICO2m_01299.sofa', 'fa124220d26db9a34e7b5da54df5dbbd'),
            ('ICO/2m/ICO2m_01301.sofa', '277a81bc208beaaa6f22453c6b5c75ef'),
            ('ICO/2m/ICO2m_01302.sofa', '8fad3f6ba842cacb1a84a9c7a4554f64'),
            ('ICO/2m/ICO2m_01303.sofa', '6b1d438cfb32e0f10bfa76dd9f3842d7'),
            ('ICO/2m/ICO2m_01304.sofa', 'a317712cc7ae5f1114414a8d3ea0bac9'),
            ('ICO/2m/ICO2m_01305.sofa', '5ce18dd98d11cea0d8b5eab477ce25a2'),
            ('ICO/2m/ICO2m_01308.sofa', 'b44fe283fa04d90098b072dbc901aed8'),
            ('ICO/2m/ICO2m_01309.sofa', '811a13e2ed79ead2b2b6b6805bbc9211'),
            ('ICO/2m/ICO2m_01310.sofa', 'b1bae579065b38303d88d5994fe8941f'),
            ('ICO/2m/ICO2m_01311.sofa', '3d173ce4ff0f9bcae498576743a904be'),
            ('ICO/2m/ICO2m_01312.sofa', '9c138147d4f2c56d4dbf230831c93e41'),
            ('ICO/2m/ICO2m_01313.sofa', 'accbe0f760617443fd9e281a8914fe51'),
            ('ICO/2m/ICO2m_01315.sofa', 'aa016841184fca1cf36b60a379723f64'),
            ('ICO/2m/ICO2m_01317.sofa', '699dda857d9f7d417be9da09d570ab26'),
            ('ICO/2m/ICO2m_01318.sofa', '8450486869e17a7d9ea278d818b35c94'),
            ('ICO/2m/ICO2m_01319.sofa', '0b35c2942e334fdb3931db24358601ab'),
            ('ICO/2m/ICO2m_01320.sofa', '38321d22a50e7cd2a90257caab75a401'),
            ('ICO/2m/ICO2m_01321.sofa', '21ec065f8d4da0d3af35984965083654'),
            ('ICO/2m/ICO2m_01324.sofa', '1c1cc8e11c8dd5000380791c644d6cf8'),
            ('ICO/2m/ICO2m_01326.sofa', '28a94166e65148e790ade06340c546a9'),
            ('ICO/2m/ICO2m_01327.sofa', '5f566f75138b1b89495060b7ee890cad'),
            ('ICO/2m/ICO2m_01328.sofa', '43fc0b5293e96982b9ebf092ccd9f89b'),
            ('ICO/2m/ICO2m_01329.sofa', 'a105e2800370e138e729e1f13cd3cdc8'),
            ('ICO/2m/ICO2m_01330.sofa', '241f9382608e33dd0df43b462cb82b7b'),
            ('ICO/2m/ICO2m_01331.sofa', '85aac29376748919a1774c51d8feb75a'),
            ('ICO/2m/ICO2m_01333.sofa', 'a059548949ddbdeffddd48da741168cd'),
            ('ICO/2m/ICO2m_01334.sofa', '6057c10010ebe4a987cb5e86debb61c6'),
            ('ICO/2m/ICO2m_01335.sofa', 'fe3b28f90e03abd113fd57433ac236ab'),
            ('ICO/2m/ICO2m_01337.sofa', '9432fc2deddc29924cc4e189cac940de'),
            ('ICO/2m/ICO2m_01338.sofa', '15dd5521cd7a3e7265d04d0e30e1135c'),
            ('ICO/2m/ICO2m_01342.sofa', 'cb7c3b5d558e3534c0a39d81624d6a66'),
            ('ICO/2m/ICO2m_01344.sofa', 'b6ea8383f73593344b8b3be235a50bff'),
            ('ICO/2m/ICO2m_01345.sofa', '01519fb3af3275fc43ac3917f223e209'),
            ('ICO/2m/ICO2m_01346.sofa', 'e577954a51b628250658cdf9385dcc7c'),
            ('ICO/2m/ICO2m_01347.sofa', '57bf51bf075f57658cee98a5341145a9'),
            ('ICO/2m/ICO2m_01349.sofa', 'dc39dabc7b1d188625b8597de03d410e'),
            ('ICO/2m/ICO2m_01350.sofa', 'c0bcc8be87c04b2ba81ab5da93867656'),
            ('ICO/2m/ICO2m_01351.sofa', 'b3bbe30efeaaf9edb7720397938e98a2'),
            ('ICO/2m/ICO2m_01352.sofa', 'beb2727b24a7750d1499f72c559b94ba'),
            ('ICO/2m/ICO2m_01355.sofa', '9dea9e2ad0610255da90012ad288c000'),
            ('ICO/2m/ICO2m_01356.sofa', '4b45947612958f42aa1e23e198cdff84'),
            ('ICO/2m/ICO2m_01357.sofa', '07284c95eb3d10e37732277e264241c9'),
            ('ICO/2m/ICO2m_01359.sofa', 'e11f6bce5e37b8bb4a02c814b4543ec4'),
            ('ICO/2m/ICO2m_01360.sofa', 'a9766290a6767315d7405b26b5a92f4e'),
            ('ICO/2m/ICO2m_01362.sofa', 'd0e9ddc734d952d107581d702e7daa83'),
            ('ICO/2m/ICO2m_01363.sofa', 'a7c626b3b885f2dbb6954b6f42c35d09'),
            ('ICO/2m/ICO2m_01364.sofa', '86b058ba1e77140634ada4e468d8b54e'),
            ('ICO/2m/ICO2m_01365.sofa', 'f2d86107021fa3e79a44324e31e1122b'),
            ('ICO/2m/ICO2m_01366.sofa', '90470e82b6a09c71c6fe834cb721df22'),
            ('ICO/2m/ICO2m_01367.sofa', '88373cd3a9a04254c7f68729ce4eed86'),
            ('ICO/2m/ICO2m_01370.sofa', 'ce374a95206396893f0bad934a243fb4'),
            ('ICO/2m/ICO2m_01371.sofa', '61afe0a059f64585cc6c142513af9dcd'),
            ('ICO/2m/ICO2m_01372.sofa', '845bc1a1c0e57c68c40f8774284a62de'),
            ('ICO/2m/ICO2m_01373.sofa', '552e38ff18afaf5ca02646f1522b8292'),
            ('ICO/2m/ICO2m_01374.sofa', '1c06dcaac325d02cd771a5677c429a84'),
            ('ICO/2m/ICO2m_01375.sofa', '80d14421072dee5910d1d6464ed0047a'),
            ('ICO/2m/ICO2m_01376.sofa', '1fe4678c2d5cb1b7d1812646328db8b2'),
        ],
    },
    'sadie2': {
        '44100': [
            ('D1/D1_HRIR_SOFA/D1_44K_16bit_256tap_FIR_SOFA.sofa', 'fe305b98293b6582fcaed8afb172b680'),
            ('D2/D2_HRIR_SOFA/D2_44K_16bit_256tap_FIR_SOFA.sofa', 'f17830f469961511a578b7a80bd9dcaf'),
            ('H3/H3_HRIR_SOFA/H3_44K_16bit_256tap_FIR_SOFA.sofa', '556ea0dfa1d921f6b2490c8174fd91cf'),
            ('H4/H4_HRIR_SOFA/H4_44K_16bit_256tap_FIR_SOFA.sofa', '53ee14aba0e0f161af2d9b2c9bccaa3e'),
            ('H5/H5_HRIR_SOFA/H5_44K_16bit_256tap_FIR_SOFA.sofa', '6baba979f4a3cac9ed6dd98d82b32562'),
            ('H6/H6_HRIR_SOFA/H6_44K_16bit_256tap_FIR_SOFA.sofa', '6c1c2a3499c602f4f6c222c0b3414ccc'),
            ('H7/H7_HRIR_SOFA/H7_44K_16bit_256tap_FIR_SOFA.sofa', 'da35efcd748aa3359fe8f6d16e354e02'),
            ('H8/H8_HRIR_SOFA/H8_44K_16bit_256tap_FIR_SOFA.sofa', '5f67488697648e2881baf7b3667d70d6'),
            ('H9/H9_HRIR_SOFA/H9_44K_16bit_256tap_FIR_SOFA.sofa', '96b9827a70d142726fa449af12814e5d'),
            ('H10/H10_HRIR_SOFA/H10_44K_16bit_256tap_FIR_SOFA.sofa', 'f165431d577ca9ed6a78aa476d902883'),
            ('H11/H11_HRIR_SOFA/H11_44K_16bit_256tap_FIR_SOFA.sofa', '9adcf7e3171d16180ebb1fc73a22b71e'),
            ('H12/H12_HRIR_SOFA/H12_44K_16bit_256tap_FIR_SOFA.sofa', '8a189435e51c6ec28017696283138a2d'),
            ('H13/H13_HRIR_SOFA/H13_44K_16bit_256tap_FIR_SOFA.sofa', '625eaef0bbbb6492ad273d9b7a563531'),
            ('H14/H14_HRIR_SOFA/H14_44K_16bit_256tap_FIR_SOFA.sofa', '99f19e3df9324937a3017b6b331d3c1f'),
            ('H15/H15_HRIR_SOFA/H15_44K_16bit_256tap_FIR_SOFA.sofa', '9d2de3035f7195e19611c79c89df8de5'),
            ('H16/H16_HRIR_SOFA/H16_44K_16bit_256tap_FIR_SOFA.sofa', 'c877fd0ed38e2b74e4f255af4a1d032b'),
            ('H17/H17_HRIR_SOFA/H17_44K_16bit_256tap_FIR_SOFA.sofa', '1e7fc901cfafcb4b43fd28ad9d692875'),
            ('H18/H18_HRIR_SOFA/H18_44K_16bit_256tap_FIR_SOFA.sofa', 'f8b06f45f6d5137078e652ab22c4ffb6'),
            ('H19/H19_HRIR_SOFA/H19_44K_16bit_256tap_FIR_SOFA.sofa', '11070357a904428e59152dfa062e43a2'),
            ('H20/H20_HRIR_SOFA/H20_44K_16bit_256tap_FIR_SOFA.sofa', '5b7ce81818a83d5708af463bca21aaa1'),
        ],
        '48000': [
            ('D1/D1_HRIR_SOFA/D1_48K_24bit_256tap_FIR_SOFA.sofa', 'e21b9883828d47da6a2d74fe78a75acb'),
            ('D2/D2_HRIR_SOFA/D2_48K_24bit_256tap_FIR_SOFA.sofa', '4090fd8fa2ef8b3a205652038ba2e1e4'),
            ('H3/H3_HRIR_SOFA/H3_48K_24bit_256tap_FIR_SOFA.sofa', '931af86245a1e356fe96293e16b53511'),
            ('H4/H4_HRIR_SOFA/H4_48K_24bit_256tap_FIR_SOFA.sofa', '8ffd1d2369ddc63d9f2e69b37d0ea2c5'),
            ('H5/H5_HRIR_SOFA/H5_48K_24bit_256tap_FIR_SOFA.sofa', '907d3050fdfde123584570600265146d'),
            ('H6/H6_HRIR_SOFA/H6_48K_24bit_256tap_FIR_SOFA.sofa', '452a111ed787f2a0d0675b4f48822d3a'),
            ('H7/H7_HRIR_SOFA/H7_48K_24bit_256tap_FIR_SOFA.sofa', '7a2867bcbd7487b3d70044ef9878e23a'),
            ('H8/H8_HRIR_SOFA/H8_48K_24bit_256tap_FIR_SOFA.sofa', '75d0f80d68ca225d2bee5ceafa81214f'),
            ('H9/H9_HRIR_SOFA/H9_48K_24bit_256tap_FIR_SOFA.sofa', 'b8de7a1d8d0909d95a9f784a274c5c9d'),
            ('H10/H10_HRIR_SOFA/H10_48K_24bit_256tap_FIR_SOFA.sofa', 'f958ce9d65c7c29f1e0dac0456417369'),
            ('H11/H11_HRIR_SOFA/H11_48K_24bit_256tap_FIR_SOFA.sofa', '1848bf81344f681456b2930bdd8c841d'),
            ('H12/H12_HRIR_SOFA/H12_48K_24bit_256tap_FIR_SOFA.sofa', '7b34c5769a69bb7607f4038831216c7d'),
            ('H13/H13_HRIR_SOFA/H13_48K_24bit_256tap_FIR_SOFA.sofa', '104ac97719fb6924f30038bcb203b979'),
            ('H14/H14_HRIR_SOFA/H14_48K_24bit_256tap_FIR_SOFA.sofa', '75c234d56ca54159730d4589819d72a8'),
            ('H15/H15_HRIR_SOFA/H15_48K_24bit_256tap_FIR_SOFA.sofa', 'a7e7453af3c95bf3ca4164a105d213b1'),
            ('H16/H16_HRIR_SOFA/H16_48K_24bit_256tap_FIR_SOFA.sofa', 'f9bf5c2bd9da45162d8bacf1da02e1a0'),
            ('H17/H17_HRIR_SOFA/H17_48K_24bit_256tap_FIR_SOFA.sofa', 'cc8c2992135a2439124fa21f268202eb'),
            ('H18/H18_HRIR_SOFA/H18_48K_24bit_256tap_FIR_SOFA.sofa', 'c33e3469b58876d79d2bc3a3fd16f4d1'),
            ('H19/H19_HRIR_SOFA/H19_48K_24bit_256tap_FIR_SOFA.sofa', '34fa7242876357d46b749308276aa3b0'),
            ('H20/H20_HRIR_SOFA/H20_48K_24bit_256tap_FIR_SOFA.sofa', '5557edb3e505a7399cf057164a03c064'),
        ],
        '96000': [
            ('D1/D1_HRIR_SOFA/D1_96K_24bit_512tap_FIR_SOFA.sofa', '9a78e29d5f269249afea0600430e34ba'),
            ('D2/D2_HRIR_SOFA/D2_96K_24bit_512tap_FIR_SOFA.sofa', '732d5b37ada151dd9755b55ecd446974'),
            ('H3/H3_HRIR_SOFA/H3_96K_24bit_512tap_FIR_SOFA.sofa', '1203a41677d9c15ce4f9dc2287d5c89e'),
            ('H4/H4_HRIR_SOFA/H4_96K_24bit_512tap_FIR_SOFA.sofa', 'c8a8a94d228997af9e1d34b2a21b8655'),
            ('H5/H5_HRIR_SOFA/H5_96K_24bit_512tap_FIR_SOFA.sofa', 'beb17d474d910a4af8d9a011967f802d'),
            ('H6/H6_HRIR_SOFA/H6_96K_24bit_512tap_FIR_SOFA.sofa', '07643c34fcbb6820353a37442099903a'),
            ('H7/H7_HRIR_SOFA/H7_96K_24bit_512tap_FIR_SOFA.sofa', 'a0de83caa208765f7ba6f8a414c567a1'),
            ('H8/H8_HRIR_SOFA/H8_96K_24bit_512tap_FIR_SOFA.sofa', 'b0624c447623feb84cd35cdde34d6c19'),
            ('H9/H9_HRIR_SOFA/H9_96K_24bit_512tap_FIR_SOFA.sofa', '84a1bd64833ecadce2bc95876c65d9dc'),
            ('H10/H10_HRIR_SOFA/H10_96K_24bit_512tap_FIR_SOFA.sofa', '902f9e55b28364d57ea22968e3a680b1'),
            ('H11/H11_HRIR_SOFA/H11_96K_24bit_512tap_FIR_SOFA.sofa', '079b657feec701632cf91a931cb16241'),
            ('H12/H12_HRIR_SOFA/H12_96K_24bit_512tap_FIR_SOFA.sofa', '0aef60a90b5a962fb91526361eb0cfd5'),
            ('H13/H13_HRIR_SOFA/H13_96K_24bit_512tap_FIR_SOFA.sofa', '1a53d147acc0c8dde48073aad3fc270e'),
            ('H14/H14_HRIR_SOFA/H14_96K_24bit_512tap_FIR_SOFA.sofa', 'df1f7476db4a2849931e48cbd4118e9f'),
            ('H15/H15_HRIR_SOFA/H15_96K_24bit_512tap_FIR_SOFA.sofa', 'f4da3e8d0cc37967ac3fa94f06eb18fc'),
            ('H16/H16_HRIR_SOFA/H16_96K_24bit_512tap_FIR_SOFA.sofa', 'd9a3acd138405684c3402b9729ee1036'),
            ('H17/H17_HRIR_SOFA/H17_96K_24bit_512tap_FIR_SOFA.sofa', 'a17f515977adbcf58e1a69ebd6430a52'),
            ('H18/H18_HRIR_SOFA/H18_96K_24bit_512tap_FIR_SOFA.sofa', '1e7ef7b3f9321fd8f56e74a519522c28'),
            ('H19/H19_HRIR_SOFA/H19_96K_24bit_512tap_FIR_SOFA.sofa', '02d0d6050b19cf41ad54fcde43864861'),
            ('H20/H20_HRIR_SOFA/H20_96K_24bit_512tap_FIR_SOFA.sofa', 'ed21e5d0889b64944638101f26da4433'),
        ],
    },
    '3d3a': {
        'acoustic-raw': [
            ('Acoustic/Subject1/Subject1_BIRs.sofa', '2e7dd273dab32fa52429863ca052bae7'),
            ('Acoustic/Subject2/Subject2_BIRs.sofa', '1cbe2d45e6467561cec9867d095a93c5'),
            ('Acoustic/Subject4/Subject4_BIRs.sofa', '1fe72d932e6c978e8e4512941e7b362c'),
            ('Acoustic/Subject10/Subject10_BIRs.sofa', '3870889a84c62b2cf3f557664f90ee9a'),
            ('Acoustic/Subject11/Subject11_BIRs.sofa', 'b1af2178d5777de1eb45b6007463bf9d'),
            ('Acoustic/Subject12/Subject12_BIRs.sofa', 'ad7586945c359111cca61581b8105210'),
            ('Acoustic/Subject13/Subject13_BIRs.sofa', '9af15764c0b80155a1558b95ec203202'),
            ('Acoustic/Subject14/Subject14_BIRs.sofa', '8565de42c143f853d99f649f4b62c1a0'),
            ('Acoustic/Subject15/Subject15_BIRs.sofa', '7f05fa10e4d8b37cf73e212cbcf3a197'),
            ('Acoustic/Subject16/Subject16_BIRs.sofa', 'f04f00b80298f660f58f168de8e21876'),
            ('Acoustic/Subject17/Subject17_BIRs.sofa', 'cec2bf62c8259e1e1eebcb051745ac7f'),
            ('Acoustic/Subject18/Subject18_BIRs.sofa', '588045d307b95ad5808f4ae4440a6504'),
            ('Acoustic/Subject19/Subject19_BIRs.sofa', 'cf598e87a82d4624eefc6a37a1b6c2a5'),
            ('Acoustic/Subject20/Subject20_BIRs.sofa', '4614f7c6b528196bd15ab9a31b4a8b26'),
            ('Acoustic/Subject21/Subject21_BIRs.sofa', '44d0c834f86da03b0932cc2164377a0d'),
            ('Acoustic/Subject22/Subject22_BIRs.sofa', 'e56eb5c38043772178149a4b43001776'),
            ('Acoustic/Subject23/Subject23_BIRs.sofa', 'bf1673ae84a72b9d8992daf6a31d20be'),
            ('Acoustic/Subject24/Subject24_BIRs.sofa', '2b416b31af523d450d1c83a256adb51f'),
            ('Acoustic/Subject25/Subject25_BIRs.sofa', '13fa08dbc599f64f69a884bb351bc51c'),
            ('Acoustic/Subject26/Subject26_BIRs.sofa', '59ab020e27323bd564be4c1508a22b50'),
            ('Acoustic/Subject27/Subject27_BIRs.sofa', 'f837f19e490996ce502da73f89b9ab74'),
            ('Acoustic/Subject28/Subject28_BIRs.sofa', 'f5b5a2bc3317a536f2453f85144e0578'),
            ('Acoustic/Subject29/Subject29_BIRs.sofa', 'b0d8de73fc9585ecdf1ff90d76fa7e99'),
            ('Acoustic/Subject30/Subject30_BIRs.sofa', '03cadd3803a6e8d6f7e59e9a5789d6f0'),
            ('Acoustic/Subject31/Subject31_BIRs.sofa', '78308145ee97f86586531ed04e60e034'),
            ('Acoustic/Subject32/Subject32_BIRs.sofa', '020cb824ae3ec5fbb8d79f98a1c9b186'),
            ('Acoustic/Subject33/Subject33_BIRs.sofa', 'e638c752f41b6aa7f1cc28f85f514dfa'),
            ('Acoustic/Subject34/Subject34_BIRs.sofa', '8917dc296d0bed629ec49ad1e94f1a84'),
            ('Acoustic/Subject35/Subject35_BIRs.sofa', '2279134a829ba3fad64b65d95c6f729a'),
            ('Acoustic/Subject36/Subject36_BIRs.sofa', '0b218906e45cef752ba6af8cc3c345d7'),
            ('Acoustic/Subject37/Subject37_BIRs.sofa', '2820a147cb51d00428b5692f09e1e1eb'),
            ('Acoustic/Subject38/Subject38_BIRs.sofa', '7d7aa8d173b19460ecffc377202d2ce4'),
            ('Acoustic/Subject39/Subject39_BIRs.sofa', '5cbb602e6554fc4628ba546dee448fa1'),
            ('Acoustic/Subject40/Subject40_BIRs.sofa', '14157d4a2d8f900c20efad3e5bb5c853'),
            ('Acoustic/Subject41/Subject41_BIRs.sofa', '484dcfaac621dfcdc5a0fb6f62c12fba'),
            ('Acoustic/Subject42/Subject42_BIRs.sofa', 'ccc05baab776bdaaef184ddf8e42e50e'),
            ('Acoustic/Subject43/Subject43_BIRs.sofa', '5107bc51fc8377bab009073a56772e47'),
            ('Acoustic/Subject44/Subject44_BIRs.sofa', 'ecb3790ed14c0448f14295dcaf322758'),
        ],
        'acoustic-compensated': [
            ('Acoustic/Subject1/Subject1_HRIRs.sofa', '72e0d602b661fd49ce6c926c01520e3a'),
            ('Acoustic/Subject2/Subject2_HRIRs.sofa', '7452242615509749f818cd6591fdc376'),
            ('Acoustic/Subject4/Subject4_HRIRs.sofa', '5ee81c3b2a3f6131dac7051621d9e02a'),
            ('Acoustic/Subject10/Subject10_HRIRs.sofa', '58c04754c084431594e652ee3b269148'),
            ('Acoustic/Subject11/Subject11_HRIRs.sofa', '8fa5a329c9525816ca3a651c446a1fb5'),
            ('Acoustic/Subject12/Subject12_HRIRs.sofa', '6d80ab59836e2ebdefb23909a9a81ac8'),
            ('Acoustic/Subject13/Subject13_HRIRs.sofa', 'f2710793acea44888486642d30471458'),
            ('Acoustic/Subject14/Subject14_HRIRs.sofa', '118351fa520c996bb2f2a11d97e38131'),
            ('Acoustic/Subject15/Subject15_HRIRs.sofa', 'c481302b95c7daea4a833bf1e3ed1c8a'),
            ('Acoustic/Subject16/Subject16_HRIRs.sofa', 'a7051140f79a83c4e50583fcf2f19bd6'),
            ('Acoustic/Subject17/Subject17_HRIRs.sofa', '1d52c1a3921bc5506cca36c9e48769c9'),
            ('Acoustic/Subject18/Subject18_HRIRs.sofa', '1ff39eb2c67bd68a840dc36afe0dc397'),
            ('Acoustic/Subject19/Subject19_HRIRs.sofa', 'bd9d1b92164aabd08671ab9f138a418e'),
            ('Acoustic/Subject20/Subject20_HRIRs.sofa', '585306589eb9bd46b6806a704afd443b'),
            ('Acoustic/Subject21/Subject21_HRIRs.sofa', '1c6bd2a565cbfabbbb3e311559645385'),
            ('Acoustic/Subject22/Subject22_HRIRs.sofa', 'a3766106342bf6ec5486e61c6255eed4'),
            ('Acoustic/Subject23/Subject23_HRIRs.sofa', '32bbf37979a294c2cf05bff8a421626d'),
            ('Acoustic/Subject24/Subject24_HRIRs.sofa', 'c1e649696a03d77a11fa69feffa7bddf'),
            ('Acoustic/Subject25/Subject25_HRIRs.sofa', '6776ab29a48c4daa3972acffd3e85901'),
            ('Acoustic/Subject26/Subject26_HRIRs.sofa', '762cb406afe42f2d25fd8fb2148fe0f8'),
            ('Acoustic/Subject27/Subject27_HRIRs.sofa', 'b546cc7ab4ad8ec19c471bdb934edfcb'),
            ('Acoustic/Subject28/Subject28_HRIRs.sofa', '0b178350043c5295aaf310d56c0efaf4'),
            ('Acoustic/Subject29/Subject29_HRIRs.sofa', 'fb1b85519fac2c1495642d83f4ebbb99'),
            ('Acoustic/Subject30/Subject30_HRIRs.sofa', 'e52e5edaffc7f201d9316306e8fd4165'),
            ('Acoustic/Subject31/Subject31_HRIRs.sofa', '66bfc498f8d046b7e4792c520a9441d6'),
            ('Acoustic/Subject32/Subject32_HRIRs.sofa', '561dd1c6725db5f22ffdd3cddecbbee8'),
            ('Acoustic/Subject33/Subject33_HRIRs.sofa', '686a3909180733fbfe8224de90e0bf0e'),
            ('Acoustic/Subject34/Subject34_HRIRs.sofa', '5ab4fd351c943eb5a9d4a56eba9e6c36'),
            ('Acoustic/Subject35/Subject35_HRIRs.sofa', '9b824df294c71ae3b0f6e61dbd70e703'),
            ('Acoustic/Subject36/Subject36_HRIRs.sofa', '700dbbbe3327935d03ba45f358190a2d'),
            ('Acoustic/Subject37/Subject37_HRIRs.sofa', '9fba2dc1ac8d5d36d7f66b164dea8edd'),
            ('Acoustic/Subject38/Subject38_HRIRs.sofa', 'cc7437379c139122307076b8ac3073d2'),
            ('Acoustic/Subject39/Subject39_HRIRs.sofa', '5c5fd89cc21a8e14a96fc74b3242bfdc'),
            ('Acoustic/Subject40/Subject40_HRIRs.sofa', 'f66793a0608c908da4e4d3329addf818'),
            ('Acoustic/Subject41/Subject41_HRIRs.sofa', '82780e95b1060307baf596b345e3ffec'),
            ('Acoustic/Subject42/Subject42_HRIRs.sofa', 'cd1f089f20efc21403ee16c70041c0c7'),
            ('Acoustic/Subject43/Subject43_HRIRs.sofa', '2f84fc8e1338d6edc5944ad15f0118d3'),
            ('Acoustic/Subject44/Subject44_HRIRs.sofa', '9f7cd708cf2ef6ede805368c3005588f'),
        ],
        'acoustic-compensated-equalized': [
            ('Acoustic/Subject1/Subject1_HRIRs_dfeq.sofa', '29a1992e6b6d2bc9b95bc8f4cacee478'),
            ('Acoustic/Subject2/Subject2_HRIRs_dfeq.sofa', '0c07527944f895361c8fc4f3d32080a1'),
            ('Acoustic/Subject4/Subject4_HRIRs_dfeq.sofa', '41d35e60e2c93490bc1e7ed711f7ba06'),
            ('Acoustic/Subject10/Subject10_HRIRs_dfeq.sofa', '8a2fa42c502887d5dd61c3de058fe2a6'),
            ('Acoustic/Subject11/Subject11_HRIRs_dfeq.sofa', '890756e38a4434a6711285f7d33a1fb5'),
            ('Acoustic/Subject12/Subject12_HRIRs_dfeq.sofa', '31341cb56c07b56cfa32d07e15f54cf3'),
            ('Acoustic/Subject13/Subject13_HRIRs_dfeq.sofa', '9dedf63032aa2c222bac25b622e59d32'),
            ('Acoustic/Subject14/Subject14_HRIRs_dfeq.sofa', '9570c0ece889e169f3a7476778e8909a'),
            ('Acoustic/Subject15/Subject15_HRIRs_dfeq.sofa', '0d0facd028ad0033e6394130d5aa52db'),
            ('Acoustic/Subject16/Subject16_HRIRs_dfeq.sofa', '8fee2b2bb6ba93fa158ba486cecc2fb1'),
            ('Acoustic/Subject17/Subject17_HRIRs_dfeq.sofa', '847cd4a0c5dd98b9bd33c685fd38f5d4'),
            ('Acoustic/Subject18/Subject18_HRIRs_dfeq.sofa', '7dfd2158d9bc3d1c7a9d4266dcee0d33'),
            ('Acoustic/Subject19/Subject19_HRIRs_dfeq.sofa', '13632dd6373a084785b996bef66e6a8b'),
            ('Acoustic/Subject20/Subject20_HRIRs_dfeq.sofa', '13e74a1ffc6a6ba300b4229d9cbeafcb'),
            ('Acoustic/Subject21/Subject21_HRIRs_dfeq.sofa', 'e2c0e6012582375b2339ac51193288e5'),
            ('Acoustic/Subject22/Subject22_HRIRs_dfeq.sofa', '188488cefe045a9fa9b17e03d06a245f'),
            ('Acoustic/Subject23/Subject23_HRIRs_dfeq.sofa', '5c1641f92c5b27c1900a05cf770873c4'),
            ('Acoustic/Subject24/Subject24_HRIRs_dfeq.sofa', '7cb4ebc03078fc8f0feb65ce56c2b330'),
            ('Acoustic/Subject25/Subject25_HRIRs_dfeq.sofa', '10d4ad1ee6311a827ca6633936d9270e'),
            ('Acoustic/Subject26/Subject26_HRIRs_dfeq.sofa', '6284f8e77fd71c1b895c05f31486334a'),
            ('Acoustic/Subject27/Subject27_HRIRs_dfeq.sofa', 'e96d41f6f7d883b9d765f6986b0693b2'),
            ('Acoustic/Subject28/Subject28_HRIRs_dfeq.sofa', '66083d48044dfc6d1a4f241d4667c634'),
            ('Acoustic/Subject29/Subject29_HRIRs_dfeq.sofa', '71f222047964ee68179fe6079ec50b37'),
            ('Acoustic/Subject30/Subject30_HRIRs_dfeq.sofa', '13e55724499238300f82e896051d9c8a'),
            ('Acoustic/Subject31/Subject31_HRIRs_dfeq.sofa', '7e07b63738d15aa060405d017483d99d'),
            ('Acoustic/Subject32/Subject32_HRIRs_dfeq.sofa', '365031824f69093c2c36dad8accdfcd8'),
            ('Acoustic/Subject33/Subject33_HRIRs_dfeq.sofa', 'f9e06c8265b05b60d21e2890ccb49c5a'),
            ('Acoustic/Subject34/Subject34_HRIRs_dfeq.sofa', '760e4c2d63c3ccfd58aab309f2a684eb'),
            ('Acoustic/Subject35/Subject35_HRIRs_dfeq.sofa', 'ba7aa0a5fd3cfe5865f3c0ac0f23dbb3'),
            ('Acoustic/Subject36/Subject36_HRIRs_dfeq.sofa', '938dedf81afb74dc26ea9b480be3fa1e'),
            ('Acoustic/Subject37/Subject37_HRIRs_dfeq.sofa', '6327676e3a130d1d00afc2fc42c284ed'),
            ('Acoustic/Subject38/Subject38_HRIRs_dfeq.sofa', '1ce3e2c88cb3e92c00460d9d7c2f4c7e'),
            ('Acoustic/Subject39/Subject39_HRIRs_dfeq.sofa', '542f8786b695ba29b3d2a3ac17e77e5c'),
            ('Acoustic/Subject40/Subject40_HRIRs_dfeq.sofa', '048af102019b02e3e62d1d611ab42757'),
            ('Acoustic/Subject41/Subject41_HRIRs_dfeq.sofa', 'ca496ba10008daea8e6482360e6f07d5'),
            ('Acoustic/Subject42/Subject42_HRIRs_dfeq.sofa', '579e92fd78ac7550addf79451bdd2467'),
            ('Acoustic/Subject43/Subject43_HRIRs_dfeq.sofa', '24c7c9998db488196d4944e9b003c17e'),
            ('Acoustic/Subject44/Subject44_HRIRs_dfeq.sofa', 'db82275f0241d741f1d6781d79a8d07a'),
        ],
        'acoustic-compensated-lowfreqextended': [
            ('Acoustic/Subject1/Subject1_HRIRs_lfc.sofa', 'fa988edd36c2083cd7fe0d742b77610f'),
            ('Acoustic/Subject2/Subject2_HRIRs_lfc.sofa', 'a4ca2b3bd9087da170e0e764cc7002fa'),
            ('Acoustic/Subject4/Subject4_HRIRs_lfc.sofa', 'cf2726b75bf7c212f1eabffaf4284999'),
            ('Acoustic/Subject10/Subject10_HRIRs_lfc.sofa', '3f491c6342768b31d70aede53588337f'),
            ('Acoustic/Subject11/Subject11_HRIRs_lfc.sofa', 'e568bcb2fbde89846ea2a9106c77ace8'),
            ('Acoustic/Subject12/Subject12_HRIRs_lfc.sofa', '38f2d93b2105ea7a8fdf512ee36cf256'),
            ('Acoustic/Subject13/Subject13_HRIRs_lfc.sofa', '2f0c820f87cfa5f5650b0680edbf0c63'),
            ('Acoustic/Subject14/Subject14_HRIRs_lfc.sofa', 'aa9dabc99d2e017964b56c377d37bee9'),
            ('Acoustic/Subject15/Subject15_HRIRs_lfc.sofa', 'a857de9139f3528c03043ede14d376fd'),
            ('Acoustic/Subject16/Subject16_HRIRs_lfc.sofa', '5b1c5711ea399e3cf21a010512f6499d'),
            ('Acoustic/Subject17/Subject17_HRIRs_lfc.sofa', '00841a7e654f604322c44706f4d62afa'),
            ('Acoustic/Subject18/Subject18_HRIRs_lfc.sofa', 'd0516cff86f7ec03de8c5d6ff0dbbae7'),
            ('Acoustic/Subject19/Subject19_HRIRs_lfc.sofa', '3f4ed92219ad762e93bd092609402009'),
            ('Acoustic/Subject20/Subject20_HRIRs_lfc.sofa', 'cbb3c38fce4409fd61bf23bdef81fd1e'),
            ('Acoustic/Subject21/Subject21_HRIRs_lfc.sofa', '51f1e1a3b129f22b18f55605a66638bb'),
            ('Acoustic/Subject22/Subject22_HRIRs_lfc.sofa', '9690b626212f910082d78c5b13f55266'),
            ('Acoustic/Subject23/Subject23_HRIRs_lfc.sofa', '358bbbe926328fbe38a38741875f76d5'),
            ('Acoustic/Subject24/Subject24_HRIRs_lfc.sofa', 'c3e9614ecd40eb7dc05702a79588bcc8'),
            ('Acoustic/Subject25/Subject25_HRIRs_lfc.sofa', 'd5c531e540bdfd78487c011fa110d118'),
            ('Acoustic/Subject26/Subject26_HRIRs_lfc.sofa', '4298264a36be0a8a78d1a4b2d6562e84'),
            ('Acoustic/Subject27/Subject27_HRIRs_lfc.sofa', '5268ad0f2501445805fb70c0779dd5cb'),
            ('Acoustic/Subject28/Subject28_HRIRs_lfc.sofa', '6a825cf070db2d5504d9f2a9da375eab'),
            ('Acoustic/Subject29/Subject29_HRIRs_lfc.sofa', '4d468988bff52342a45afa2bd299e9ae'),
            ('Acoustic/Subject30/Subject30_HRIRs_lfc.sofa', '3ed946df6c16f20553f1733221010962'),
            ('Acoustic/Subject31/Subject31_HRIRs_lfc.sofa', 'e4adc19b73138bc95b1570ca614f2180'),
            ('Acoustic/Subject32/Subject32_HRIRs_lfc.sofa', 'bb3ae4c212d101410682bd8f02692cf0'),
            ('Acoustic/Subject33/Subject33_HRIRs_lfc.sofa', '166dfe5fd24f7974fbb21bb0f05d5514'),
            ('Acoustic/Subject34/Subject34_HRIRs_lfc.sofa', '7565a3528686c086f35b220192ac3f8a'),
            ('Acoustic/Subject35/Subject35_HRIRs_lfc.sofa', '18767ceb4892b61040787f49e9e429c0'),
            ('Acoustic/Subject36/Subject36_HRIRs_lfc.sofa', '31cc02de16869b9c11c8699f678f1074'),
            ('Acoustic/Subject37/Subject37_HRIRs_lfc.sofa', '9c79de9ace4800498f7b3ff533c4e957'),
            ('Acoustic/Subject38/Subject38_HRIRs_lfc.sofa', 'b7d05c014d8b5e7f0c12f6578a4e3bc8'),
            ('Acoustic/Subject39/Subject39_HRIRs_lfc.sofa', '37349c4dc8a1401eb96df62b8bd3a7dd'),
            ('Acoustic/Subject40/Subject40_HRIRs_lfc.sofa', 'b923c720b0f7a5ce03d3e12b1268bff5'),
            ('Acoustic/Subject41/Subject41_HRIRs_lfc.sofa', 'a89d1df74e7d706ad5b0e73429cdadd5'),
            ('Acoustic/Subject42/Subject42_HRIRs_lfc.sofa', '4154e8cea4326832ddf9b42adb4e381b'),
            ('Acoustic/Subject43/Subject43_HRIRs_lfc.sofa', '378755ebdc491cd2e74cf5508495ca47'),
            ('Acoustic/Subject44/Subject44_HRIRs_lfc.sofa', '273207677555e4478c3b374d26722083'),
        ],
        'simulated-head-compensated': [
            ('BEM/Head-Only/Subject1/Subject1_HRIRs.sofa', '88077ac71c806fe75496323b3b63c0ac'),
            ('BEM/Head-Only/Subject2/Subject2_HRIRs.sofa', 'fe959fecdb6bd73383d9c296d477604b'),
            ('BEM/Head-Only/Subject10/Subject10_HRIRs.sofa', '7dba4f59dcef0d6be5ee649fa39fee5e'),
            ('BEM/Head-Only/Subject11/Subject11_HRIRs.sofa', '991984c0470e873a667a3b1708a85bf0'),
            ('BEM/Head-Only/Subject12/Subject12_HRIRs.sofa', '5d156518001a4bf6315e7fa71a15253c'),
            ('BEM/Head-Only/Subject13/Subject13_HRIRs.sofa', '65c8408a473a3e9e9e680f740c5d7ae0'),
            ('BEM/Head-Only/Subject17/Subject17_HRIRs.sofa', '4df5af91793fe5f559bd289f41fbfb53'),
            ('BEM/Head-Only/Subject19/Subject19_HRIRs.sofa', '549b219b9ae171121a7b8dae1e15acb4'),
            ('BEM/Head-Only/Subject20/Subject20_HRIRs.sofa', 'a225afe1c3a78d2dc93395c86432ce79'),
            ('BEM/Head-Only/Subject21/Subject21_HRIRs.sofa', '3cf2ddd8894cd72a9f4f0f1e0e7fcc8a'),
            ('BEM/Head-Only/Subject22/Subject22_HRIRs.sofa', 'dd66c9be6df9b0ded1c5e0a640263d04'),
            ('BEM/Head-Only/Subject23/Subject23_HRIRs.sofa', '391a18376b5e4b789026a5ce34594d9d'),
            ('BEM/Head-Only/Subject24/Subject24_HRIRs.sofa', '50279e283b9f2cb396d0b80ab1593324'),
            ('BEM/Head-Only/Subject25/Subject25_HRIRs.sofa', '7bc6aa8230257ae2ed880189aaa0698b'),
            ('BEM/Head-Only/Subject26/Subject26_HRIRs.sofa', '6961738602015efa819fc05a41eb10bc'),
            ('BEM/Head-Only/Subject27/Subject27_HRIRs.sofa', 'e0d8cd3d5650aceedfe1ba4c781127bc'),
            ('BEM/Head-Only/Subject28/Subject28_HRIRs.sofa', '8887602e10f73f86202b3b9540e862f1'),
            ('BEM/Head-Only/Subject29/Subject29_HRIRs.sofa', '885a86dd684568b5102869516b0eb9a3'),
            ('BEM/Head-Only/Subject30/Subject30_HRIRs.sofa', '31b325f359f91f360c6c70249526cbb1'),
            ('BEM/Head-Only/Subject31/Subject31_HRIRs.sofa', 'dd2ba86ac27cce99e5ccfea5a83ed53b'),
            ('BEM/Head-Only/Subject32/Subject32_HRIRs.sofa', 'e406d89716eca56c06251200b5cb83c3'),
            ('BEM/Head-Only/Subject33/Subject33_HRIRs.sofa', 'c94711bd96f3b2e23c08d4f838b7842d'),
            ('BEM/Head-Only/Subject34/Subject34_HRIRs.sofa', '854310ba27dae00aa56b5e77edd6d48b'),
            ('BEM/Head-Only/Subject35/Subject35_HRIRs.sofa', '7a18b04f41bc3a78a815c4636cff655c'),
            ('BEM/Head-Only/Subject36/Subject36_HRIRs.sofa', '96d63f69c1c11ede07b2d2f55aed6029'),
            ('BEM/Head-Only/Subject37/Subject37_HRIRs.sofa', '61e1aad47357190c4c4b1b33e24dbd48'),
            ('BEM/Head-Only/Subject38/Subject38_HRIRs.sofa', '45f56f59462913d472893a11842e4aaa'),
            ('BEM/Head-Only/Subject39/Subject39_HRIRs.sofa', 'c9cfbfdeb032939cc5cf68c3711c5c44'),
            ('BEM/Head-Only/Subject40/Subject40_HRIRs.sofa', '3e4124d2334c1ca8d14cac057bcf20fc'),
            ('BEM/Head-Only/Subject41/Subject41_HRIRs.sofa', 'bcac892181da9e560a57a483db5fdbbc'),
            ('BEM/Head-Only/Subject42/Subject42_HRIRs.sofa', 'dcd856fa8c4f067da3b9f7688ada7063'),
            ('BEM/Head-Only/Subject44/Subject44_HRIRs.sofa', '6498a0ccd34e5c615bee7979d155395c'),
        ],
        'simulated-head-compensated-equalized': [
            ('BEM/Head-Only/Subject1/Subject1_HRIRs_dfeq.sofa', '18314697287e0c67d0a8560be53962da'),
            ('BEM/Head-Only/Subject2/Subject2_HRIRs_dfeq.sofa', 'cd073d62dd67f0e63d66c2e1db131efd'),
            ('BEM/Head-Only/Subject10/Subject10_HRIRs_dfeq.sofa', '1f4c2ba9f4a60fa75825a3e80fe5daba'),
            ('BEM/Head-Only/Subject11/Subject11_HRIRs_dfeq.sofa', 'f6a49300595899d48db6fb746a27f457'),
            ('BEM/Head-Only/Subject12/Subject12_HRIRs_dfeq.sofa', 'e843c406fef6c4348d1a83828d91ef9f'),
            ('BEM/Head-Only/Subject13/Subject13_HRIRs_dfeq.sofa', '4ea0fdadd1b9d4bd9e6c04dd00e5181c'),
            ('BEM/Head-Only/Subject17/Subject17_HRIRs_dfeq.sofa', '199014f81ee116249c4a43c1a8567ab7'),
            ('BEM/Head-Only/Subject19/Subject19_HRIRs_dfeq.sofa', '7cd11e5f45c9511981597130b622bfff'),
            ('BEM/Head-Only/Subject20/Subject20_HRIRs_dfeq.sofa', 'cb97d833b21f7b2e096037326a94de83'),
            ('BEM/Head-Only/Subject21/Subject21_HRIRs_dfeq.sofa', 'b9d7f45abecf5e4626e9e46dd0287403'),
            ('BEM/Head-Only/Subject22/Subject22_HRIRs_dfeq.sofa', 'cb0a574e54ec683d7458aa4a254a27d9'),
            ('BEM/Head-Only/Subject23/Subject23_HRIRs_dfeq.sofa', '871fd907abbd6ecae86f5f56c148551c'),
            ('BEM/Head-Only/Subject24/Subject24_HRIRs_dfeq.sofa', 'ecc8425446fe35c971fa12a283223da7'),
            ('BEM/Head-Only/Subject25/Subject25_HRIRs_dfeq.sofa', '0dc6306b5530e3db77dd46314070d1e8'),
            ('BEM/Head-Only/Subject26/Subject26_HRIRs_dfeq.sofa', '4b5a5d8342115ce4652dc65f12ed5e19'),
            ('BEM/Head-Only/Subject27/Subject27_HRIRs_dfeq.sofa', '6d7b13f42d6251519cee6b8d7c7e45a8'),
            ('BEM/Head-Only/Subject28/Subject28_HRIRs_dfeq.sofa', '959b297ec977439be4df7cf555cef3a7'),
            ('BEM/Head-Only/Subject29/Subject29_HRIRs_dfeq.sofa', 'fd1c1803d0c1e262b9ee985c19072ed2'),
            ('BEM/Head-Only/Subject30/Subject30_HRIRs_dfeq.sofa', '5329dd2939959f50823ca3e6f63dbbd3'),
            ('BEM/Head-Only/Subject31/Subject31_HRIRs_dfeq.sofa', '8f75933f54192202e0dddd6cf94dda01'),
            ('BEM/Head-Only/Subject32/Subject32_HRIRs_dfeq.sofa', '127fd703b316e8a540c0eea8a9fd2e40'),
            ('BEM/Head-Only/Subject33/Subject33_HRIRs_dfeq.sofa', '8dad67a3dac3bd5e40eb8a5667125254'),
            ('BEM/Head-Only/Subject34/Subject34_HRIRs_dfeq.sofa', 'e1fc998bee303524b591002e2403c237'),
            ('BEM/Head-Only/Subject35/Subject35_HRIRs_dfeq.sofa', 'd3432a06c72c5093ca17515b6a0f9e62'),
            ('BEM/Head-Only/Subject36/Subject36_HRIRs_dfeq.sofa', 'cdf27b5589a5a199d1dea7330f2c255d'),
            ('BEM/Head-Only/Subject37/Subject37_HRIRs_dfeq.sofa', '97fd5e0511d75e7c9eaba0304f35ff1f'),
            ('BEM/Head-Only/Subject38/Subject38_HRIRs_dfeq.sofa', 'dd9c2e3c74ccdda343ec314c2c43c83b'),
            ('BEM/Head-Only/Subject39/Subject39_HRIRs_dfeq.sofa', '22001cf1cf4d6a2f3079b50a710353f2'),
            ('BEM/Head-Only/Subject40/Subject40_HRIRs_dfeq.sofa', 'e10e4a1dd46dbbea4aea20c0722b6e16'),
            ('BEM/Head-Only/Subject41/Subject41_HRIRs_dfeq.sofa', '1c6cbb19f8ae9ea90b4be5604bebbda0'),
            ('BEM/Head-Only/Subject42/Subject42_HRIRs_dfeq.sofa', '8d7cc89aabbfb427a402c7bf1b8e2eda'),
            ('BEM/Head-Only/Subject44/Subject44_HRIRs_dfeq.sofa', '94e2ecaa4773d5fc07bdf88ca2f94899'),
        ],
        'simulated-head_ears-compensated': [
            ('BEM/Head-and-Ears/Subject1/Subject1_HRIRs.sofa', '6fbe15687514de2194ac3904bf7a7e71'),
            ('BEM/Head-and-Ears/Subject2/Subject2_HRIRs.sofa', '00149a95fcf39c8bee2df1b80eb319b4'),
            ('BEM/Head-and-Ears/Subject10/Subject10_HRIRs.sofa', '6a941b3e2ac477e6dfbc0d8439b3c3d7'),
            ('BEM/Head-and-Ears/Subject11/Subject11_HRIRs.sofa', 'b1600909e0a002a6ef2a79ef7c18c92a'),
            ('BEM/Head-and-Ears/Subject12/Subject12_HRIRs.sofa', 'a85bf1ab40fdbca8be366435ecfdd8f9'),
            ('BEM/Head-and-Ears/Subject13/Subject13_HRIRs.sofa', '5994c54c7f803c71c2a12a9fe7cdea08'),
            ('BEM/Head-and-Ears/Subject17/Subject17_HRIRs.sofa', 'd31333a0249d0307ad33b2071e492eb4'),
            ('BEM/Head-and-Ears/Subject19/Subject19_HRIRs.sofa', '501902cc23f3409ffe68a204bc3e8e1b'),
            ('BEM/Head-and-Ears/Subject20/Subject20_HRIRs.sofa', '924a21d0d03b6c47c7043d6fd12f8e2a'),
            ('BEM/Head-and-Ears/Subject21/Subject21_HRIRs.sofa', '1a1624baa3313d1de945eb707dd5f0c8'),
            ('BEM/Head-and-Ears/Subject22/Subject22_HRIRs.sofa', '3e1845d53ca65440f4520494c506dbf1'),
            ('BEM/Head-and-Ears/Subject23/Subject23_HRIRs.sofa', '96a72e7ad902eae134ef67040df075ef'),
            ('BEM/Head-and-Ears/Subject24/Subject24_HRIRs.sofa', '39968f780e8aa5640e65174279bd14f5'),
            ('BEM/Head-and-Ears/Subject25/Subject25_HRIRs.sofa', '340e6cb124fc1c14f1a1e7bb901b3dcb'),
            ('BEM/Head-and-Ears/Subject26/Subject26_HRIRs.sofa', '51e531663e476fc01f570257d5cd4da5'),
            ('BEM/Head-and-Ears/Subject27/Subject27_HRIRs.sofa', '333d3cae758ebeedb681c8a48e99ed12'),
            ('BEM/Head-and-Ears/Subject28/Subject28_HRIRs.sofa', '130f6de06dcb1f5cc62690ff505fe16e'),
            ('BEM/Head-and-Ears/Subject29/Subject29_HRIRs.sofa', '231d5280ddfe09b757210ff866ae8be0'),
            ('BEM/Head-and-Ears/Subject30/Subject30_HRIRs.sofa', '7ae9b0a74b530bca502233b407604cc2'),
            ('BEM/Head-and-Ears/Subject31/Subject31_HRIRs.sofa', '8db970b5cfb8995505f918fbf731a6ef'),
            ('BEM/Head-and-Ears/Subject32/Subject32_HRIRs.sofa', '3920fd054bb4a23bb52bdf323e9e1d8a'),
            ('BEM/Head-and-Ears/Subject33/Subject33_HRIRs.sofa', 'a6cee966ca215e546a2aaadba8c37793'),
            ('BEM/Head-and-Ears/Subject34/Subject34_HRIRs.sofa', 'd12a4fabd391ec015688dc1504f640d9'),
            ('BEM/Head-and-Ears/Subject35/Subject35_HRIRs.sofa', 'f3620695788d590ebc4d6f9d79e1ff61'),
            ('BEM/Head-and-Ears/Subject36/Subject36_HRIRs.sofa', '5e5b839c6488ab65c68b92f2fc0d4ab7'),
            ('BEM/Head-and-Ears/Subject37/Subject37_HRIRs.sofa', '05f9b6b34dbfbf873f9ae507886220db'),
            ('BEM/Head-and-Ears/Subject38/Subject38_HRIRs.sofa', '7e24ccb0d985a704c3613768b0cc9f00'),
            ('BEM/Head-and-Ears/Subject39/Subject39_HRIRs.sofa', 'bea4cb446caf3b0a57e540db966d15cd'),
            ('BEM/Head-and-Ears/Subject40/Subject40_HRIRs.sofa', 'd521888c110ab2d58ed50b35fbd32a47'),
            ('BEM/Head-and-Ears/Subject41/Subject41_HRIRs.sofa', '651dbd7064a36252ac92be567d675703'),
            ('BEM/Head-and-Ears/Subject42/Subject42_HRIRs.sofa', 'dc9cbf746e0b3aded2e77f5af32ea6a8'),
            ('BEM/Head-and-Ears/Subject44/Subject44_HRIRs.sofa', '3c080955acba60c916b3d80b380af66a'),
        ],
        'simulated-head_ears-compensated-equalized': [
            ('BEM/Head-and-Ears/Subject1/Subject1_HRIRs_dfeq.sofa', '7d58b5ba1e36cfa979e5b28f3270180c'),
            ('BEM/Head-and-Ears/Subject2/Subject2_HRIRs_dfeq.sofa', 'd1fc24471c913e5cd47f3728686da8dd'),
            ('BEM/Head-and-Ears/Subject10/Subject10_HRIRs_dfeq.sofa', 'a4c9902ec499b08fc0779bee7a3c9f29'),
            ('BEM/Head-and-Ears/Subject11/Subject11_HRIRs_dfeq.sofa', '02d3cea5263ef883e5d39c663b7d2e23'),
            ('BEM/Head-and-Ears/Subject12/Subject12_HRIRs_dfeq.sofa', 'c4cb25cc3708d8df3129299604c33b70'),
            ('BEM/Head-and-Ears/Subject13/Subject13_HRIRs_dfeq.sofa', '7e04c666d247465fd5b97cded46607be'),
            ('BEM/Head-and-Ears/Subject17/Subject17_HRIRs_dfeq.sofa', '2bf33c764fb6f87a99ca211e1f1f5793'),
            ('BEM/Head-and-Ears/Subject19/Subject19_HRIRs_dfeq.sofa', 'c147348e9d065421017d3a37cdd29f54'),
            ('BEM/Head-and-Ears/Subject20/Subject20_HRIRs_dfeq.sofa', '3b0db87243d1b0272782507631bf0f17'),
            ('BEM/Head-and-Ears/Subject21/Subject21_HRIRs_dfeq.sofa', 'd306dc9feaa7ba54e7553ccca0808bec'),
            ('BEM/Head-and-Ears/Subject22/Subject22_HRIRs_dfeq.sofa', 'c7ef1b88135b596b0ac23b875fcc3aa1'),
            ('BEM/Head-and-Ears/Subject23/Subject23_HRIRs_dfeq.sofa', '0496cfe0f7e11901132fe9f364b24944'),
            ('BEM/Head-and-Ears/Subject24/Subject24_HRIRs_dfeq.sofa', 'cc639b977b16b7841de0611493e50e59'),
            ('BEM/Head-and-Ears/Subject25/Subject25_HRIRs_dfeq.sofa', '338bf9296c0d9f7bc1d211c11466ff73'),
            ('BEM/Head-and-Ears/Subject26/Subject26_HRIRs_dfeq.sofa', '89d600c341fc97236e1a890b4785076c'),
            ('BEM/Head-and-Ears/Subject27/Subject27_HRIRs_dfeq.sofa', '88d2dc27fc9b522246622f647918a8fe'),
            ('BEM/Head-and-Ears/Subject28/Subject28_HRIRs_dfeq.sofa', 'a351c9e302c70e8798bd4f48dbdd1e63'),
            ('BEM/Head-and-Ears/Subject29/Subject29_HRIRs_dfeq.sofa', '588d4327b7c794a87069e8df9315f4a2'),
            ('BEM/Head-and-Ears/Subject30/Subject30_HRIRs_dfeq.sofa', '8bc806ef8871c7768bb994634cc5b91d'),
            ('BEM/Head-and-Ears/Subject31/Subject31_HRIRs_dfeq.sofa', '07e0d8c9db0605c675fc6364c2545db9'),
            ('BEM/Head-and-Ears/Subject32/Subject32_HRIRs_dfeq.sofa', '77f75c36e71cbfabc9960a3c39a018da'),
            ('BEM/Head-and-Ears/Subject33/Subject33_HRIRs_dfeq.sofa', '58eee2fe4a8375b4a181152462a0bf2c'),
            ('BEM/Head-and-Ears/Subject34/Subject34_HRIRs_dfeq.sofa', '9e9b829a507c0b1949d87a28cd9d78dc'),
            ('BEM/Head-and-Ears/Subject35/Subject35_HRIRs_dfeq.sofa', '447b43056a0b8de520cb90beb3070a10'),
            ('BEM/Head-and-Ears/Subject36/Subject36_HRIRs_dfeq.sofa', 'fcf63f2406c2234269956e757bc8f2df'),
            ('BEM/Head-and-Ears/Subject37/Subject37_HRIRs_dfeq.sofa', '7351605d86771d190eed099774f01993'),
            ('BEM/Head-and-Ears/Subject38/Subject38_HRIRs_dfeq.sofa', 'd169316434b6abab6e78587ce930561d'),
            ('BEM/Head-and-Ears/Subject39/Subject39_HRIRs_dfeq.sofa', 'cffedf9e59f30af4d4066f4041e55c1e'),
            ('BEM/Head-and-Ears/Subject40/Subject40_HRIRs_dfeq.sofa', '050b4f30b6427531ae6fd260d8d2c804'),
            ('BEM/Head-and-Ears/Subject41/Subject41_HRIRs_dfeq.sofa', 'f8d319778bf44d3f5c8d7d5d6c825e6a'),
            ('BEM/Head-and-Ears/Subject42/Subject42_HRIRs_dfeq.sofa', '2181857c464a209a43557b4f4c89941b'),
            ('BEM/Head-and-Ears/Subject44/Subject44_HRIRs_dfeq.sofa', '1a04a46503b9bfa5192a84579f88fef5'),
        ],
        'simulated-head_ears_torso-consumer_grade-compensated': [
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject1/Subject1_HRIRs.sofa', '36dfb1fd1662d0be60d94eeb0daa6156'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject2/Subject2_HRIRs.sofa', '2f5f4009cf65fe1adc1df8024c1ef37f'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject10/Subject10_HRIRs.sofa', '31c5db111d94229fc92448740040b333'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject11/Subject11_HRIRs.sofa', 'bfe44f4ee658f1a536386651eef86d70'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject12/Subject12_HRIRs.sofa', '6f6924f1d7d3c9b1f12991825ad25b49'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject13/Subject13_HRIRs.sofa', '5256585526e65520dc1c61dbbd063dd2'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject17/Subject17_HRIRs.sofa', 'f092858bd2f55e2a461e868ebf0d7f30'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject19/Subject19_HRIRs.sofa', 'baf36fc77f5eb04d627782c7b0b7edf2'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject20/Subject20_HRIRs.sofa', '639cf9d683c5a3b267cb155bb8dd35db'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject21/Subject21_HRIRs.sofa', '5523d736ef3e4d51bb9641ad280b53b7'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject22/Subject22_HRIRs.sofa', '04e78cce59878613496bb43141996f37'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject23/Subject23_HRIRs.sofa', '28c9694015e9d9296e72f858603c7ebc'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject24/Subject24_HRIRs.sofa', '9ae5b240268273e7154e12a3e2a4743d'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject25/Subject25_HRIRs.sofa', '6ab2c4f86570071d50a250b2dc37f4fc'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject26/Subject26_HRIRs.sofa', 'dfeb90371589cc39358678045766080c'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject27/Subject27_HRIRs.sofa', '8a3e4205a3015cb208f418ddaff34d6e'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject28/Subject28_HRIRs.sofa', '8301c02acbae9f7af7dbd0b2cba061d9'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject29/Subject29_HRIRs.sofa', 'c52021ab7d12fefaef5e3c5d90d61e43'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject30/Subject30_HRIRs.sofa', '6e1d1da1e0504371e6cef3a284833e87'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject31/Subject31_HRIRs.sofa', 'ea1547628cc8710c3bd902ada62cb9a4'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject32/Subject32_HRIRs.sofa', '27a0448242e4ef656328e515c9e2d29b'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject33/Subject33_HRIRs.sofa', 'ec8b4fd1cbf3a7addaa9d975e17c9a3a'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject34/Subject34_HRIRs.sofa', '6fa50a27c530f2f6712b3071b3689d43'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject35/Subject35_HRIRs.sofa', '93a3875da0e1613f6d0d62cfa815defb'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject36/Subject36_HRIRs.sofa', '3790f52864041cac0aed063b7f52ca71'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject37/Subject37_HRIRs.sofa', '1bbf46656a6278b227d5f9e90f293cce'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject38/Subject38_HRIRs.sofa', '1e346856806525e7b4041272f8500c9a'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject39/Subject39_HRIRs.sofa', 'ce05466332c67fadb9abfe0c0cc54a76'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject40/Subject40_HRIRs.sofa', 'ce48b6cff0ad8d0b38ba588081ede27f'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject41/Subject41_HRIRs.sofa', 'fb6f67b376c3bb3b43663673fda8138d'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject42/Subject42_HRIRs.sofa', '022d5509006834cf7f4d660a98148973'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject44/Subject44_HRIRs.sofa', '147a205b7fc6afa4c1c86f0e93b41873'),
        ],
        'simulated-head_ears_torso-consumer_grade-compensated-equalized': [
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject1/Subject1_HRIRs_dfeq.sofa', 'c85381508015bb7a2b9f27925054b559'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject2/Subject2_HRIRs_dfeq.sofa', 'd326bb399d5a34f5146fd70ebfdd2643'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject10/Subject10_HRIRs_dfeq.sofa', '5239644cfa2cc78ac169b468bb667b5a'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject11/Subject11_HRIRs_dfeq.sofa', '7eecfbfd682df2acd593dbf676bf8ed4'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject12/Subject12_HRIRs_dfeq.sofa', 'eae086984b0ac40e8f2bab55b90e73b8'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject13/Subject13_HRIRs_dfeq.sofa', 'fd0b7a53acda1f6e903586ab4b2488eb'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject17/Subject17_HRIRs_dfeq.sofa', '7158c5799bee0c8b989c22dd9e362c7b'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject19/Subject19_HRIRs_dfeq.sofa', '39ae1fbc4666e74284edb631be66a538'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject20/Subject20_HRIRs_dfeq.sofa', '951ad67ae1705139b60dcb89712cca19'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject21/Subject21_HRIRs_dfeq.sofa', '276b7cfa1032f8b34b5e93d35ea88634'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject22/Subject22_HRIRs_dfeq.sofa', '2e5ba27deb5aab908654c88b9c38aba3'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject23/Subject23_HRIRs_dfeq.sofa', 'bae2547a17ab36d463469c0cce1c13b1'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject24/Subject24_HRIRs_dfeq.sofa', 'f9c42765e2009a7fed338573defcc301'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject25/Subject25_HRIRs_dfeq.sofa', '8f06f5484bbaf82c4812a407af5d76fd'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject26/Subject26_HRIRs_dfeq.sofa', '27151b01680f67bbeb8b13e4f6feedcb'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject27/Subject27_HRIRs_dfeq.sofa', '85f1e5bff479e18cd48214b1499fdaeb'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject28/Subject28_HRIRs_dfeq.sofa', '4ae0057653064b7006de6661d0221b72'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject29/Subject29_HRIRs_dfeq.sofa', '0dc48d79b3bdfa76cfe6a588176635e6'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject30/Subject30_HRIRs_dfeq.sofa', 'd2f69e18abcbec136ba49d9c5ca9316c'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject31/Subject31_HRIRs_dfeq.sofa', '00fa8cf0e87b76dec19b10d1f271459b'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject32/Subject32_HRIRs_dfeq.sofa', '65d2a3b019a198303694c250ac7a758d'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject33/Subject33_HRIRs_dfeq.sofa', 'fcf88ac6c571489c1a90a22bb62a06b9'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject34/Subject34_HRIRs_dfeq.sofa', 'e8113247ffb304a28616ca5c192f4072'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject35/Subject35_HRIRs_dfeq.sofa', '1b0c52458075ee6a6330d2e942a00e86'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject36/Subject36_HRIRs_dfeq.sofa', 'beb2f5861787c9c877d310b20405e0a7'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject37/Subject37_HRIRs_dfeq.sofa', '30f9b93d14bdf3a56b237c3161c3d4f6'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject38/Subject38_HRIRs_dfeq.sofa', '1ecb869e876da86d41297ba836638a54'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject39/Subject39_HRIRs_dfeq.sofa', 'c217176b459ee9f6e807cdda0a65c8ab'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject40/Subject40_HRIRs_dfeq.sofa', '8df35bb6cd0e90ce8ff8a3e3f28dc264'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject41/Subject41_HRIRs_dfeq.sofa', 'f27d2d9f69df66ae52a6892b500c48a3'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject42/Subject42_HRIRs_dfeq.sofa', '8d6375ee0973e84a395ef61d9787eafd'),
            ('BEM/Head-Ears-and-Torso/Consumer-Grade/Subject44/Subject44_HRIRs_dfeq.sofa', '6f53607b35c7c6c0ce7ca427526753b1'),
        ],
        'simulated-head_ears_torso-reference_grade-compensated': [
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject1/Subject1_HRIRs.sofa', 'd5e27330e9872aa50b4398c91e68bffd'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject2/Subject2_HRIRs.sofa', '8503438b0dc47cd56c0a4cc69875bdd9'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject10/Subject10_HRIRs.sofa', 'f2ec41ce8ff45eaae2d0b386b0ae6200'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject11/Subject11_HRIRs.sofa', '6858b9dc68afa31e2286528aa1b0d9ce'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject12/Subject12_HRIRs.sofa', '929644fef56a476b8f8e880d67963830'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject13/Subject13_HRIRs.sofa', 'ad129cd99cf1ef4abd989b3a8360f78d'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject17/Subject17_HRIRs.sofa', '2c4a3b0bb177a3173987d3965e2cec31'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject19/Subject19_HRIRs.sofa', '3a0378fa72d4f7e6187d8c1b269cf350'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject20/Subject20_HRIRs.sofa', '094bfd5f226cbba02a0c1c8744020275'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject21/Subject21_HRIRs.sofa', 'e8f440c4d3b6c44e31a5815cb6085e3d'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject22/Subject22_HRIRs.sofa', '538f22e0f0fc72f694996bc1e8b312f2'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject23/Subject23_HRIRs.sofa', '4171568c4d0007505a831bc333d6a6c5'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject24/Subject24_HRIRs.sofa', '9265e700e980966e6230f8a10e9fb63c'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject25/Subject25_HRIRs.sofa', '9a2cd8e8f56b70898be864dc45744b0a'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject26/Subject26_HRIRs.sofa', '025b99faf4012b7ea3ddbb818121987d'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject27/Subject27_HRIRs.sofa', '768085aca0387bd305e2e541723457b4'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject28/Subject28_HRIRs.sofa', '6bf792ed847005f6a6b7bf58cfdfe9ce'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject29/Subject29_HRIRs.sofa', '5d32a01ced581ca0778aa69e122afb5a'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject30/Subject30_HRIRs.sofa', 'a4a8eb11ce1c18262f33e4766e0c34bc'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject31/Subject31_HRIRs.sofa', '4dfdae8010507b423c98d776f6a19e0b'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject32/Subject32_HRIRs.sofa', 'aecc123e2e03a897e048032b210a076f'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject33/Subject33_HRIRs.sofa', '65907b13d0d8c0a9c21440383942d78c'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject34/Subject34_HRIRs.sofa', '651e825fd01e06cb40900d4740c40852'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject35/Subject35_HRIRs.sofa', 'c5efa4e849a47c43b05d496de655ab83'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject36/Subject36_HRIRs.sofa', '0c1edf8e7b1a7e214e1a81bcfb0758aa'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject37/Subject37_HRIRs.sofa', '4a26bce1906c03216772f0aad94ab52a'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject38/Subject38_HRIRs.sofa', 'ef6511b5d51e828d84632dd613357910'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject39/Subject39_HRIRs.sofa', '9e84acbd483f18bd7f8d312b49b9ace5'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject40/Subject40_HRIRs.sofa', '4b8dbeccfa866ae82822dbc3ff065fa1'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject41/Subject41_HRIRs.sofa', '886f139709f3335631986ab722bce92d'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject42/Subject42_HRIRs.sofa', '71463b1a3852460c78d3ec480c3bf382'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject44/Subject44_HRIRs.sofa', '0ae1e80070f9239ba1a7de9b3d20604e'),
        ],
        'simulated-head_ears_torso-reference_grade-compensated-equalized': [
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject1/Subject1_HRIRs_dfeq.sofa', '55078524d21a929b9305eb836dcf17b7'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject2/Subject2_HRIRs_dfeq.sofa', '5b8693b02397c23fe1c882decc630b34'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject10/Subject10_HRIRs_dfeq.sofa', '714e118d7c67d90f64d907b1fde64633'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject11/Subject11_HRIRs_dfeq.sofa', 'b74796347858c70aa2b5b0f05960a45a'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject12/Subject12_HRIRs_dfeq.sofa', '3178a91c705b6dfdf2727be3672ac1d2'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject13/Subject13_HRIRs_dfeq.sofa', '2ce42a5aba8ded6e856d8d00411d5e5f'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject17/Subject17_HRIRs_dfeq.sofa', 'ec32511d9d66e7b4e503b35b43511101'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject19/Subject19_HRIRs_dfeq.sofa', 'a698ec48ce659da306635196d21cddca'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject20/Subject20_HRIRs_dfeq.sofa', '6b4a59f0e94b0b3029f3b2195156e928'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject21/Subject21_HRIRs_dfeq.sofa', '2f7929a7f54381722613fa2dbe4f2b74'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject22/Subject22_HRIRs_dfeq.sofa', 'c07f5ece5992869cdc1b36ca5fe25a1b'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject23/Subject23_HRIRs_dfeq.sofa', '416aec45e315836180dd329f8d2f7570'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject24/Subject24_HRIRs_dfeq.sofa', '357964267f94b2a9a280bb2bf691c74e'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject25/Subject25_HRIRs_dfeq.sofa', 'd1fdc8b3d5fac60203c1c8cd8d94eff4'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject26/Subject26_HRIRs_dfeq.sofa', 'db49c958e1d9ca6fa0eb74b8db2c87f0'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject27/Subject27_HRIRs_dfeq.sofa', '24b109fc994c5732efe3a54eeedb0c51'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject28/Subject28_HRIRs_dfeq.sofa', 'e32277ec40a553f3b09d62d33fe9a1c9'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject29/Subject29_HRIRs_dfeq.sofa', '0d9a6af9c0a1e9455785534d76a67f34'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject30/Subject30_HRIRs_dfeq.sofa', 'ce3fe81cb02c73c55a8808ff6fcd4635'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject31/Subject31_HRIRs_dfeq.sofa', '35b03d2c258d4cbc104ff6e743316011'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject32/Subject32_HRIRs_dfeq.sofa', 'e3ec8d6330c12f5b49c58766fc189331'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject33/Subject33_HRIRs_dfeq.sofa', '32dfe6c5c7c4ec4213de2e22721cbe79'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject34/Subject34_HRIRs_dfeq.sofa', 'b20b94a0e78eb5fbfd193c4a09d61d27'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject35/Subject35_HRIRs_dfeq.sofa', '70ce9dd2db31a0e37bd5e3100a70b2fb'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject36/Subject36_HRIRs_dfeq.sofa', '72513521570ab650b651ca7fd0838d11'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject37/Subject37_HRIRs_dfeq.sofa', '5af7dcf6e6a6f3b326611c6a1a113970'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject38/Subject38_HRIRs_dfeq.sofa', '3f9ce525b83f32bda7c3e17333fad4e8'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject39/Subject39_HRIRs_dfeq.sofa', '86a3d6811acb22ac33281a4804d775bc'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject40/Subject40_HRIRs_dfeq.sofa', 'f50ef81a7b863da321e1dec2e99a58a6'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject41/Subject41_HRIRs_dfeq.sofa', '737804e58824fa70c7564ceccc910b34'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject42/Subject42_HRIRs_dfeq.sofa', '94fdefc016ee1f589800a9f30565db48'),
            ('BEM/Head-Ears-and-Torso/Reference-Grade/Subject44/Subject44_HRIRs_dfeq.sofa', 'f1b9fe69a572d36f5528eef466652c26'),
        ],
    },
    'scut': {
        '': [
            ('SCUT_NF_subject0001_measured.sofa', '0e6bd0a790daee54886a31caeb7952d4'),
            ('SCUT_NF_subject0002_measured.sofa', '9189f98398e9fb539c1be9fbdb8f39df'),
            ('SCUT_NF_subject0003_measured.sofa', '3a789b30641cf1de5a0273d2064d28a2'),
            ('SCUT_NF_subject0004_measured.sofa', 'ab9744d0d59a767bc7930026f45427fd'),
            ('SCUT_NF_subject0005_measured.sofa', 'f99924114ef22736ed4bd0c2af6c80cf'),
            ('SCUT_NF_subject0006_measured.sofa', '267afbdd8831df17fc788bbb63763cef'),
            ('SCUT_NF_subject0007_measured.sofa', 'b0db33dfbf60ffa364a23411426d5492'),
            ('SCUT_NF_subject0008_measured.sofa', 'f2fdf0cb5f6912459c4226347df7f7d1'),
            ('SCUT_NF_subject0009_measured.sofa', '8fa53c1dfea9b30d761cd290c28e1777'),
            ('SCUT_NF_subject0010_measured.sofa', '2d42f96089b822a11139b6cac2757f3d'),
        ],
    },
    'sonicom': {
        'raw-44100': [
            ('P0001/HRTF/HRTF/44kHz/P0001_Raw_44kHz.sofa', 'be682e9404703fee558126edcdb59cea'),
            ('P0002/HRTF/HRTF/44kHz/P0002_Raw_44kHz.sofa', '70b0f7383d54b9297e6e6805ee10c217'),
            ('P0003/HRTF/HRTF/44kHz/P0003_Raw_44kHz.sofa', '397b99e15ff96c2b5a28252323497b06'),
            ('P0004/HRTF/HRTF/44kHz/P0004_Raw_44kHz.sofa', 'e90b3b9caaba5c7cd33e01b9f4435cf3'),
            ('P0005/HRTF/HRTF/44kHz/P0005_Raw_44kHz.sofa', '9fdccec2daa1d3f55d53e2072627f260'),
            ('P0006/HRTF/HRTF/44kHz/P0006_Raw_44kHz.sofa', 'dbde45508434285943b8c914cbcf621e'),
            ('P0007/HRTF/HRTF/44kHz/P0007_Raw_44kHz.sofa', '44844815c4a31277721edb1dc105deee'),
            ('P0008/HRTF/HRTF/44kHz/P0008_Raw_44kHz.sofa', 'b40e9de6fe29ae6f880992d94a0b119b'),
            ('P0009/HRTF/HRTF/44kHz/P0009_Raw_44kHz.sofa', 'c1de4dc36eb4d30195499ff87b085703'),
            ('P0010/HRTF/HRTF/44kHz/P0010_Raw_44kHz.sofa', 'af43581ff66ab1adf23c096dc293c7a6'),
            ('P0011/HRTF/HRTF/44kHz/P0011_Raw_44kHz.sofa', 'f06e0fa9a8e1c5bb25e524105470562a'),
            ('P0012/HRTF/HRTF/44kHz/P0012_Raw_44kHz.sofa', 'd7f67c27d44355ab3f7a7ac97d8b2c9a'),
            ('P0013/HRTF/HRTF/44kHz/P0013_Raw_44kHz.sofa', '40a5693a029b271fc31fe526fad1cffc'),
            ('P0014/HRTF/HRTF/44kHz/P0014_Raw_44kHz.sofa', 'f8efee6864f9367b77b2284db3dbcea7'),
            ('P0015/HRTF/HRTF/44kHz/P0015_Raw_44kHz.sofa', '258356a838d1480596a9d20fee63cd64'),
            ('P0016/HRTF/HRTF/44kHz/P0016_Raw_44kHz.sofa', '1572a62fe31f5993a55a86780c0c6b89'),
            ('P0017/HRTF/HRTF/44kHz/P0017_Raw_44kHz.sofa', '284a27ce781c00360919683b545a1d11'),
            ('P0018/HRTF/HRTF/44kHz/P0018_Raw_44kHz.sofa', 'b5f75f0b89a792e04dbe51a6e3271b5f'),
            ('P0019/HRTF/HRTF/44kHz/P0019_Raw_44kHz.sofa', '9eec4a84d7928102257abbb984ba8e7a'),
            ('P0020/HRTF/HRTF/44kHz/P0020_Raw_44kHz.sofa', '31bcb97760379eda22fec7905f0af249'),
            ('P0021/HRTF/HRTF/44kHz/P0021_Raw_44kHz.sofa', '13b62d3c263fd90254c205fdc0e92e7b'),
            ('P0022/HRTF/HRTF/44kHz/P0022_Raw_44kHz.sofa', '6243092cfce7b703f2a5a593dcba28a7'),
            ('P0023/HRTF/HRTF/44kHz/P0023_Raw_44kHz.sofa', '287a4847e1b76b16c736eef81d058ef2'),
            ('P0024/HRTF/HRTF/44kHz/P0024_Raw_44kHz.sofa', '15bfba3ec34e3a6429fb94ee9ea5b95a'),
            ('P0025/HRTF/HRTF/44kHz/P0025_Raw_44kHz.sofa', 'fb7311d92e0e4f2011c0806580ace1a4'),
            ('P0026/HRTF/HRTF/44kHz/P0026_Raw_44kHz.sofa', 'f42045083df78660d1f1d95169a601eb'),
            ('P0027/HRTF/HRTF/44kHz/P0027_Raw_44kHz.sofa', '18807e3396b83f00011fc6c2b9a24881'),
            ('P0028/HRTF/HRTF/44kHz/P0028_Raw_44kHz.sofa', '0af10915760c81f8e14ae80240e44319'),
            ('P0029/HRTF/HRTF/44kHz/P0029_Raw_44kHz.sofa', '8fc88feaeee12d6d66fafd0d283de0a8'),
            ('P0030/HRTF/HRTF/44kHz/P0030_Raw_44kHz.sofa', '50ba7417ccb592e47f96fc0bbeee4ba2'),
            ('P0031/HRTF/HRTF/44kHz/P0031_Raw_44kHz.sofa', '3e73bd0ed91391ce04e5e3c25cb02d7a'),
            ('P0032/HRTF/HRTF/44kHz/P0032_Raw_44kHz.sofa', '343a114345435dcbb96b58d9795cc63c'),
      