# py-scibec-openapi-client
scibec

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.8.6
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import py_scibec_openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import py_scibec_openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import py_scibec_openapi_client
from pprint import pprint
from py_scibec_openapi_client.apis.tags import access_account_controller_api
from py_scibec_openapi_client.model.access_account import AccessAccount
from py_scibec_openapi_client.model.access_account_filter import AccessAccountFilter
from py_scibec_openapi_client.model.access_account_filter1 import AccessAccountFilter1
from py_scibec_openapi_client.model.access_account_partial import AccessAccountPartial
from py_scibec_openapi_client.model.access_account_with_relations import AccessAccountWithRelations
from py_scibec_openapi_client.model.loopback_count import LoopbackCount
from py_scibec_openapi_client.model.new_access_account import NewAccessAccount
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = py_scibec_openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): jwt
configuration = py_scibec_openapi_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with py_scibec_openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = access_account_controller_api.AccessAccountControllerApi(api_client)
    where =  # {str: (bool, date, datetime, dict, float, int, list, str, none_type)} |  (optional)

    try:
        api_response = api_instance.access_account_controller_count(where=where)
        pprint(api_response)
    except py_scibec_openapi_client.ApiException as e:
        print("Exception when calling AccessAccountControllerApi->access_account_controller_count: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessAccountControllerApi* | [**access_account_controller_count**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_count) | **get** /access-accounts/count | 
*AccessAccountControllerApi* | [**access_account_controller_create**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_create) | **post** /access-accounts | 
*AccessAccountControllerApi* | [**access_account_controller_delete_by_id**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_delete_by_id) | **delete** /access-accounts/{id} | 
*AccessAccountControllerApi* | [**access_account_controller_find**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_find) | **get** /access-accounts | 
*AccessAccountControllerApi* | [**access_account_controller_find_by_id**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_find_by_id) | **get** /access-accounts/{id} | 
*AccessAccountControllerApi* | [**access_account_controller_update_all**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_update_all) | **patch** /access-accounts | 
*AccessAccountControllerApi* | [**access_account_controller_update_by_id**](docs/apis/tags/AccessAccountControllerApi.md#access_account_controller_update_by_id) | **patch** /access-accounts/{id} | 
*AccessConfigControllerApi* | [**access_config_controller_count**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_count) | **get** /access-configs/count | 
*AccessConfigControllerApi* | [**access_config_controller_create**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_create) | **post** /access-configs | 
*AccessConfigControllerApi* | [**access_config_controller_delete_by_id**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_delete_by_id) | **delete** /access-configs/{id} | 
*AccessConfigControllerApi* | [**access_config_controller_find**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_find) | **get** /access-configs | 
*AccessConfigControllerApi* | [**access_config_controller_find_by_id**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_find_by_id) | **get** /access-configs/{id} | 
*AccessConfigControllerApi* | [**access_config_controller_update_all**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_update_all) | **patch** /access-configs | 
*AccessConfigControllerApi* | [**access_config_controller_update_by_id**](docs/apis/tags/AccessConfigControllerApi.md#access_config_controller_update_by_id) | **patch** /access-configs/{id} | 
*BeamlineControllerApi* | [**beamline_controller_count**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_count) | **get** /beamlines/count | 
*BeamlineControllerApi* | [**beamline_controller_create**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_create) | **post** /beamlines | 
*BeamlineControllerApi* | [**beamline_controller_delete_by_id**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_delete_by_id) | **delete** /beamlines/{id} | 
*BeamlineControllerApi* | [**beamline_controller_find**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_find) | **get** /beamlines | 
*BeamlineControllerApi* | [**beamline_controller_find_by_id**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_find_by_id) | **get** /beamlines/{id} | 
*BeamlineControllerApi* | [**beamline_controller_update_all**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_update_all) | **patch** /beamlines | 
*BeamlineControllerApi* | [**beamline_controller_update_by_id**](docs/apis/tags/BeamlineControllerApi.md#beamline_controller_update_by_id) | **patch** /beamlines/{id} | 
*DatasetControllerApi* | [**dataset_controller_count**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_count) | **get** /datasets/count | 
*DatasetControllerApi* | [**dataset_controller_create**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_create) | **post** /datasets | 
*DatasetControllerApi* | [**dataset_controller_delete_by_id**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_delete_by_id) | **delete** /datasets/{id} | 
*DatasetControllerApi* | [**dataset_controller_find**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_find) | **get** /datasets | 
*DatasetControllerApi* | [**dataset_controller_find_by_id**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_find_by_id) | **get** /datasets/{id} | 
*DatasetControllerApi* | [**dataset_controller_update_all**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_update_all) | **patch** /datasets | 
*DatasetControllerApi* | [**dataset_controller_update_by_id**](docs/apis/tags/DatasetControllerApi.md#dataset_controller_update_by_id) | **patch** /datasets/{id} | 
*DeviceControllerApi* | [**device_controller_count**](docs/apis/tags/DeviceControllerApi.md#device_controller_count) | **get** /devices/count | 
*DeviceControllerApi* | [**device_controller_create**](docs/apis/tags/DeviceControllerApi.md#device_controller_create) | **post** /devices | 
*DeviceControllerApi* | [**device_controller_delete_by_id**](docs/apis/tags/DeviceControllerApi.md#device_controller_delete_by_id) | **delete** /devices/{id} | 
*DeviceControllerApi* | [**device_controller_find**](docs/apis/tags/DeviceControllerApi.md#device_controller_find) | **get** /devices | 
*DeviceControllerApi* | [**device_controller_find_by_id**](docs/apis/tags/DeviceControllerApi.md#device_controller_find_by_id) | **get** /devices/{id} | 
*DeviceControllerApi* | [**device_controller_update_all**](docs/apis/tags/DeviceControllerApi.md#device_controller_update_all) | **patch** /devices | 
*DeviceControllerApi* | [**device_controller_update_by_id**](docs/apis/tags/DeviceControllerApi.md#device_controller_update_by_id) | **patch** /devices/{id} | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_count**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_count) | **get** /experiment-accounts/count | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_create**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_create) | **post** /experiment-accounts | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_delete_by_id**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_delete_by_id) | **delete** /experiment-accounts/{id} | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_find**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_find) | **get** /experiment-accounts | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_find_by_id**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_find_by_id) | **get** /experiment-accounts/{id} | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_update_all**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_update_all) | **patch** /experiment-accounts | 
*ExperimentAccountControllerApi* | [**experiment_account_controller_update_by_id**](docs/apis/tags/ExperimentAccountControllerApi.md#experiment_account_controller_update_by_id) | **patch** /experiment-accounts/{id} | 
*ExperimentControllerApi* | [**experiment_controller_count**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_count) | **get** /experiments/count | 
*ExperimentControllerApi* | [**experiment_controller_create**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_create) | **post** /experiments | 
*ExperimentControllerApi* | [**experiment_controller_delete_by_id**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_delete_by_id) | **delete** /experiments/{id} | 
*ExperimentControllerApi* | [**experiment_controller_find**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_find) | **get** /experiments | 
*ExperimentControllerApi* | [**experiment_controller_find_by_id**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_find_by_id) | **get** /experiments/{id} | 
*ExperimentControllerApi* | [**experiment_controller_update_all**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_update_all) | **patch** /experiments | 
*ExperimentControllerApi* | [**experiment_controller_update_by_id**](docs/apis/tags/ExperimentControllerApi.md#experiment_controller_update_by_id) | **patch** /experiments/{id} | 
*FunctionalAccountControllerApi* | [**functional_account_controller_count**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_count) | **get** /functional-accounts/count | 
*FunctionalAccountControllerApi* | [**functional_account_controller_create**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_create) | **post** /functional-accounts | 
*FunctionalAccountControllerApi* | [**functional_account_controller_delete_by_id**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_delete_by_id) | **delete** /functional-accounts/{id} | 
*FunctionalAccountControllerApi* | [**functional_account_controller_find**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_find) | **get** /functional-accounts | 
*FunctionalAccountControllerApi* | [**functional_account_controller_find_by_id**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_find_by_id) | **get** /functional-accounts/{id} | 
*FunctionalAccountControllerApi* | [**functional_account_controller_update_all**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_update_all) | **patch** /functional-accounts | 
*FunctionalAccountControllerApi* | [**functional_account_controller_update_by_id**](docs/apis/tags/FunctionalAccountControllerApi.md#functional_account_controller_update_by_id) | **patch** /functional-accounts/{id} | 
*NXEntityControllerApi* | [**n_x_entity_controller_count**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_count) | **get** /nxentities/count | 
*NXEntityControllerApi* | [**n_x_entity_controller_create**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_create) | **post** /nxentities | 
*NXEntityControllerApi* | [**n_x_entity_controller_create_entry**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_create_entry) | **post** /nxentities/entry | 
*NXEntityControllerApi* | [**n_x_entity_controller_delete_by_id**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_delete_by_id) | **delete** /nxentities/{id} | 
*NXEntityControllerApi* | [**n_x_entity_controller_find**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_find) | **get** /nxentities | 
*NXEntityControllerApi* | [**n_x_entity_controller_find_by_id**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_find_by_id) | **get** /nxentities/{id} | 
*NXEntityControllerApi* | [**n_x_entity_controller_replace_by_id**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_replace_by_id) | **put** /nxentities/{id} | 
*NXEntityControllerApi* | [**n_x_entity_controller_update_all**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_update_all) | **patch** /nxentities | 
*NXEntityControllerApi* | [**n_x_entity_controller_update_by_id**](docs/apis/tags/NXEntityControllerApi.md#n_x_entity_controller_update_by_id) | **patch** /nxentities/{id} | 
*OIDCControllerApi* | [**o_idc_controller_login_to_third_party**](docs/apis/tags/OIDCControllerApi.md#o_idc_controller_login_to_third_party) | **get** /auth/login | 
*OIDCControllerApi* | [**o_idc_controller_logout**](docs/apis/tags/OIDCControllerApi.md#o_idc_controller_logout) | **get** /auth/logout | 
*OIDCControllerApi* | [**o_idc_controller_third_party_call_back**](docs/apis/tags/OIDCControllerApi.md#o_idc_controller_third_party_call_back) | **get** /auth/callback | 
*ScanControllerApi* | [**scan_controller_count**](docs/apis/tags/ScanControllerApi.md#scan_controller_count) | **get** /scans/count | 
*ScanControllerApi* | [**scan_controller_create**](docs/apis/tags/ScanControllerApi.md#scan_controller_create) | **post** /scans | 
*ScanControllerApi* | [**scan_controller_delete_by_id**](docs/apis/tags/ScanControllerApi.md#scan_controller_delete_by_id) | **delete** /scans/{id} | 
*ScanControllerApi* | [**scan_controller_find**](docs/apis/tags/ScanControllerApi.md#scan_controller_find) | **get** /scans | 
*ScanControllerApi* | [**scan_controller_find_by_id**](docs/apis/tags/ScanControllerApi.md#scan_controller_find_by_id) | **get** /scans/{id} | 
*ScanControllerApi* | [**scan_controller_update_all**](docs/apis/tags/ScanControllerApi.md#scan_controller_update_all) | **patch** /scans | 
*ScanControllerApi* | [**scan_controller_update_by_id**](docs/apis/tags/ScanControllerApi.md#scan_controller_update_by_id) | **patch** /scans/{id} | 
*ScanDataControllerApi* | [**scan_data_controller_count**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_count) | **get** /scan-data/count | 
*ScanDataControllerApi* | [**scan_data_controller_create**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_create) | **post** /scan-data | 
*ScanDataControllerApi* | [**scan_data_controller_delete_by_id**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_delete_by_id) | **delete** /scan-data/{id} | 
*ScanDataControllerApi* | [**scan_data_controller_find**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_find) | **get** /scan-data | 
*ScanDataControllerApi* | [**scan_data_controller_find_by_id**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_find_by_id) | **get** /scan-data/{id} | 
*ScanDataControllerApi* | [**scan_data_controller_replace_by_id**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_replace_by_id) | **put** /scan-data/{id} | 
*ScanDataControllerApi* | [**scan_data_controller_update_all**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_update_all) | **patch** /scan-data | 
*ScanDataControllerApi* | [**scan_data_controller_update_by_id**](docs/apis/tags/ScanDataControllerApi.md#scan_data_controller_update_by_id) | **patch** /scan-data/{id} | 
*SessionControllerApi* | [**session_controller_count**](docs/apis/tags/SessionControllerApi.md#session_controller_count) | **get** /sessions/count | 
*SessionControllerApi* | [**session_controller_create**](docs/apis/tags/SessionControllerApi.md#session_controller_create) | **post** /sessions | 
*SessionControllerApi* | [**session_controller_delete_by_id**](docs/apis/tags/SessionControllerApi.md#session_controller_delete_by_id) | **delete** /sessions/{id} | 
*SessionControllerApi* | [**session_controller_find**](docs/apis/tags/SessionControllerApi.md#session_controller_find) | **get** /sessions | 
*SessionControllerApi* | [**session_controller_find_by_id**](docs/apis/tags/SessionControllerApi.md#session_controller_find_by_id) | **get** /sessions/{id} | 
*SessionControllerApi* | [**session_controller_update_all**](docs/apis/tags/SessionControllerApi.md#session_controller_update_all) | **patch** /sessions | 
*SessionControllerApi* | [**session_controller_update_by_id**](docs/apis/tags/SessionControllerApi.md#session_controller_update_by_id) | **patch** /sessions/{id} | 
*UserControllerApi* | [**user_controller_create**](docs/apis/tags/UserControllerApi.md#user_controller_create) | **post** /users | 
*UserControllerApi* | [**user_controller_find_by_id**](docs/apis/tags/UserControllerApi.md#user_controller_find_by_id) | **get** /users/{userId} | 
*UserControllerApi* | [**user_controller_login**](docs/apis/tags/UserControllerApi.md#user_controller_login) | **post** /users/login | 
*UserControllerApi* | [**user_controller_print_current_user**](docs/apis/tags/UserControllerApi.md#user_controller_print_current_user) | **get** /users/me | 

## Documentation For Models

 - [AccessAccount](docs/models/AccessAccount.md)
 - [AccessAccountFilter](docs/models/AccessAccountFilter.md)
 - [AccessAccountFilter1](docs/models/AccessAccountFilter1.md)
 - [AccessAccountPartial](docs/models/AccessAccountPartial.md)
 - [AccessAccountWithRelations](docs/models/AccessAccountWithRelations.md)
 - [AccessConfig](docs/models/AccessConfig.md)
 - [AccessConfigFilter](docs/models/AccessConfigFilter.md)
 - [AccessConfigFilter1](docs/models/AccessConfigFilter1.md)
 - [AccessConfigIncludeFilterItems](docs/models/AccessConfigIncludeFilterItems.md)
 - [AccessConfigPartial](docs/models/AccessConfigPartial.md)
 - [AccessConfigScopeFilter](docs/models/AccessConfigScopeFilter.md)
 - [AccessConfigWithRelations](docs/models/AccessConfigWithRelations.md)
 - [Beamline](docs/models/Beamline.md)
 - [BeamlineFilter](docs/models/BeamlineFilter.md)
 - [BeamlineFilter1](docs/models/BeamlineFilter1.md)
 - [BeamlineIncludeFilterItems](docs/models/BeamlineIncludeFilterItems.md)
 - [BeamlinePartial](docs/models/BeamlinePartial.md)
 - [BeamlineScopeFilter](docs/models/BeamlineScopeFilter.md)
 - [BeamlineWithRelations](docs/models/BeamlineWithRelations.md)
 - [Dataset](docs/models/Dataset.md)
 - [DatasetFilter](docs/models/DatasetFilter.md)
 - [DatasetFilter1](docs/models/DatasetFilter1.md)
 - [DatasetIncludeFilterItems](docs/models/DatasetIncludeFilterItems.md)
 - [DatasetPartial](docs/models/DatasetPartial.md)
 - [DatasetScopeFilter](docs/models/DatasetScopeFilter.md)
 - [DatasetWithRelations](docs/models/DatasetWithRelations.md)
 - [Device](docs/models/Device.md)
 - [DeviceFilter](docs/models/DeviceFilter.md)
 - [DeviceFilter1](docs/models/DeviceFilter1.md)
 - [DeviceIncludeFilterItems](docs/models/DeviceIncludeFilterItems.md)
 - [DevicePartial](docs/models/DevicePartial.md)
 - [DeviceScopeFilter](docs/models/DeviceScopeFilter.md)
 - [DeviceWithRelations](docs/models/DeviceWithRelations.md)
 - [Experiment](docs/models/Experiment.md)
 - [ExperimentAccount](docs/models/ExperimentAccount.md)
 - [ExperimentAccountFilter](docs/models/ExperimentAccountFilter.md)
 - [ExperimentAccountFilter1](docs/models/ExperimentAccountFilter1.md)
 - [ExperimentAccountIncludeFilterItems](docs/models/ExperimentAccountIncludeFilterItems.md)
 - [ExperimentAccountPartial](docs/models/ExperimentAccountPartial.md)
 - [ExperimentAccountScopeFilter](docs/models/ExperimentAccountScopeFilter.md)
 - [ExperimentAccountWithRelations](docs/models/ExperimentAccountWithRelations.md)
 - [ExperimentFilter](docs/models/ExperimentFilter.md)
 - [ExperimentFilter1](docs/models/ExperimentFilter1.md)
 - [ExperimentIncludeFilterItems](docs/models/ExperimentIncludeFilterItems.md)
 - [ExperimentPartial](docs/models/ExperimentPartial.md)
 - [ExperimentScopeFilter](docs/models/ExperimentScopeFilter.md)
 - [ExperimentWithRelations](docs/models/ExperimentWithRelations.md)
 - [FunctionalAccount](docs/models/FunctionalAccount.md)
 - [FunctionalAccountFilter](docs/models/FunctionalAccountFilter.md)
 - [FunctionalAccountFilter1](docs/models/FunctionalAccountFilter1.md)
 - [FunctionalAccountIncludeFilterItems](docs/models/FunctionalAccountIncludeFilterItems.md)
 - [FunctionalAccountPartial](docs/models/FunctionalAccountPartial.md)
 - [FunctionalAccountScopeFilter](docs/models/FunctionalAccountScopeFilter.md)
 - [FunctionalAccountWithRelations](docs/models/FunctionalAccountWithRelations.md)
 - [LoopbackCount](docs/models/LoopbackCount.md)
 - [NXEntity](docs/models/NXEntity.md)
 - [NXEntityFilter](docs/models/NXEntityFilter.md)
 - [NXEntityFilter1](docs/models/NXEntityFilter1.md)
 - [NXEntityIncludeFilterItems](docs/models/NXEntityIncludeFilterItems.md)
 - [NXEntityNested](docs/models/NXEntityNested.md)
 - [NXEntityPartial](docs/models/NXEntityPartial.md)
 - [NXEntityScopeFilter](docs/models/NXEntityScopeFilter.md)
 - [NXEntityWithRelations](docs/models/NXEntityWithRelations.md)
 - [NewAccessAccount](docs/models/NewAccessAccount.md)
 - [NewAccessConfig](docs/models/NewAccessConfig.md)
 - [NewBeamline](docs/models/NewBeamline.md)
 - [NewDataset](docs/models/NewDataset.md)
 - [NewDevice](docs/models/NewDevice.md)
 - [NewExperiment](docs/models/NewExperiment.md)
 - [NewExperimentAccount](docs/models/NewExperimentAccount.md)
 - [NewFunctionalAccount](docs/models/NewFunctionalAccount.md)
 - [NewNXEntity](docs/models/NewNXEntity.md)
 - [NewNXEntityNested](docs/models/NewNXEntityNested.md)
 - [NewScan](docs/models/NewScan.md)
 - [NewScanData](docs/models/NewScanData.md)
 - [NewSession](docs/models/NewSession.md)
 - [NewUser](docs/models/NewUser.md)
 - [NewUserRequest](docs/models/NewUserRequest.md)
 - [Scan](docs/models/Scan.md)
 - [ScanData](docs/models/ScanData.md)
 - [ScanDataFilter](docs/models/ScanDataFilter.md)
 - [ScanDataFilter1](docs/models/ScanDataFilter1.md)
 - [ScanDataIncludeFilterItems](docs/models/ScanDataIncludeFilterItems.md)
 - [ScanDataPartial](docs/models/ScanDataPartial.md)
 - [ScanDataScopeFilter](docs/models/ScanDataScopeFilter.md)
 - [ScanDataWithRelations](docs/models/ScanDataWithRelations.md)
 - [ScanFilter](docs/models/ScanFilter.md)
 - [ScanFilter1](docs/models/ScanFilter1.md)
 - [ScanIncludeFilterItems](docs/models/ScanIncludeFilterItems.md)
 - [ScanPartial](docs/models/ScanPartial.md)
 - [ScanScopeFilter](docs/models/ScanScopeFilter.md)
 - [ScanWithRelations](docs/models/ScanWithRelations.md)
 - [Session](docs/models/Session.md)
 - [SessionFilter](docs/models/SessionFilter.md)
 - [SessionFilter1](docs/models/SessionFilter1.md)
 - [SessionIncludeFilterItems](docs/models/SessionIncludeFilterItems.md)
 - [SessionPartial](docs/models/SessionPartial.md)
 - [SessionScopeFilter](docs/models/SessionScopeFilter.md)
 - [SessionWithRelations](docs/models/SessionWithRelations.md)
 - [User](docs/models/User.md)

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="jwt"></a>
### jwt

- **Type**: Bearer authentication (JWT)


## Author

klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch
klaus.wakonig@psi.ch

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in py_scibec_openapi_client.apis and py_scibec_openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from py_scibec_openapi_client.apis.default_api import DefaultApi`
- `from py_scibec_openapi_client.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import py_scibec_openapi_client
from py_scibec_openapi_client.apis import *
from py_scibec_openapi_client.models import *
```
