from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

class namespace: pass

class vtkEventDataAction(int):
    Any:'vtkEventDataAction'
    NumberOfActions:'vtkEventDataAction'
    Press:'vtkEventDataAction'
    Release:'vtkEventDataAction'
    Touch:'vtkEventDataAction'
    Unknown:'vtkEventDataAction'
    Untouch:'vtkEventDataAction'

class vtkEventDataDevice(int):
    Any:'vtkEventDataDevice'
    GenericTracker:'vtkEventDataDevice'
    HeadMountedDisplay:'vtkEventDataDevice'
    LeftController:'vtkEventDataDevice'
    NumberOfDevices:'vtkEventDataDevice'
    RightController:'vtkEventDataDevice'
    Unknown:'vtkEventDataDevice'

class vtkEventDataDeviceInput(int):
    Any:'vtkEventDataDeviceInput'
    ApplicationMenu:'vtkEventDataDeviceInput'
    Grip:'vtkEventDataDeviceInput'
    Joystick:'vtkEventDataDeviceInput'
    NumberOfInputs:'vtkEventDataDeviceInput'
    TrackPad:'vtkEventDataDeviceInput'
    Trigger:'vtkEventDataDeviceInput'
    Unknown:'vtkEventDataDeviceInput'

VTK_ABSTRACT_ELECTRONIC_DATA:int
VTK_ANNOTATION:int
VTK_ANNOTATION_LAYERS:int
VTK_ARIAL:int
VTK_ARRAY_DATA:int
VTK_BIT:int
VTK_BIT_MAX:int
VTK_BIT_MIN:int
VTK_BSP_CUTS:int
VTK_BUILD_VERSION:int
VTK_CHAR:int
VTK_CHAR_MAX:int
VTK_CHAR_MIN:int
VTK_COLOR_MODE_DEFAULT:int
VTK_COLOR_MODE_DIRECT_SCALARS:int
VTK_COLOR_MODE_MAP_SCALARS:int
VTK_COMPILER_GCC_VERSION:int
VTK_COMPOSITE_DATA_SET:int
VTK_COURIER:int
VTK_CUBIC_INTERPOLATION:int
VTK_CXX_COMPILER:str
VTK_DATA_OBJECT:int
VTK_DATA_OBJECT_TREE:int
VTK_DATA_SET:int
VTK_DBL_EPSILON:float
VTK_DBL_MIN:float
VTK_DEPRECATION_LEVEL:int
VTK_DIRECTED_ACYCLIC_GRAPH:int
VTK_DIRECTED_GRAPH:int
VTK_DOUBLE:int
VTK_DOUBLE_MAX:float
VTK_DOUBLE_MIN:float
VTK_ENCODING_ISO_8859_1:int
VTK_ENCODING_ISO_8859_10:int
VTK_ENCODING_ISO_8859_11:int
VTK_ENCODING_ISO_8859_12:int
VTK_ENCODING_ISO_8859_13:int
VTK_ENCODING_ISO_8859_14:int
VTK_ENCODING_ISO_8859_15:int
VTK_ENCODING_ISO_8859_16:int
VTK_ENCODING_ISO_8859_2:int
VTK_ENCODING_ISO_8859_3:int
VTK_ENCODING_ISO_8859_4:int
VTK_ENCODING_ISO_8859_5:int
VTK_ENCODING_ISO_8859_6:int
VTK_ENCODING_ISO_8859_7:int
VTK_ENCODING_ISO_8859_8:int
VTK_ENCODING_ISO_8859_9:int
VTK_ENCODING_NONE:int
VTK_ENCODING_UNICODE:int
VTK_ENCODING_UNKNOWN:int
VTK_ENCODING_US_ASCII:int
VTK_ENCODING_UTF_8:int
VTK_ERROR:int
VTK_EXPLICIT_STRUCTURED_GRID:int
VTK_FLOAT:int
VTK_FLOAT_MAX:float
VTK_FLOAT_MIN:float
VTK_FONT_FILE:int
VTK_GENERIC_DATA_SET:int
VTK_GEO_JSON_FEATURE:int
VTK_GRAPH:int
VTK_HIERARCHICAL_BOX_DATA_SET:int
VTK_HIERARCHICAL_DATA_SET:int
VTK_HYPER_OCTREE:int
VTK_HYPER_TREE_GRID:int
VTK_ID_MAX:int
VTK_ID_MIN:int
VTK_ID_TYPE:int
VTK_ID_TYPE_IMPL:int
VTK_ID_TYPE_PRId:str
VTK_IMAGE_DATA:int
VTK_IMAGE_SLAB_MAX:int
VTK_IMAGE_SLAB_MEAN:int
VTK_IMAGE_SLAB_MIN:int
VTK_IMAGE_SLAB_SUM:int
VTK_IMAGE_STENCIL_DATA:int
VTK_INT:int
VTK_INT_MAX:int
VTK_INT_MIN:int
VTK_LINEAR_INTERPOLATION:int
VTK_LONG:int
VTK_LONG_LONG:int
VTK_LONG_LONG_MAX:int
VTK_LONG_LONG_MIN:int
VTK_LONG_MAX:int
VTK_LONG_MIN:int
VTK_LUMINANCE:int
VTK_LUMINANCE_ALPHA:int
VTK_MAJOR_VERSION:int
VTK_MAXPATH:int
VTK_MAX_THREADS:int
VTK_MAX_VRCOMP:int
VTK_MINIMUM_DEPRECATION_LEVEL:int
VTK_MINOR_VERSION:int
VTK_MOLECULE:int
VTK_MTIME_MAX:int
VTK_MTIME_MIN:int
VTK_MTIME_TYPE_IMPL:int
VTK_MULTIBLOCK_DATA_SET:int
VTK_MULTIGROUP_DATA_SET:int
VTK_MULTIPIECE_DATA_SET:int
VTK_NEAREST_INTERPOLATION:int
VTK_NON_OVERLAPPING_AMR:int
VTK_OBJECT:int
VTK_OK:int
VTK_OPAQUE:int
VTK_OPEN_QUBE_ELECTRONIC_DATA:int
VTK_OVERLAPPING_AMR:int
VTK_PARTITIONED_DATA_SET:int
VTK_PARTITIONED_DATA_SET_COLLECTION:int
VTK_PATH:int
VTK_PIECEWISE_FUNCTION:int
VTK_PISTON_DATA_OBJECT:int
VTK_POINT_SET:int
VTK_POLY_DATA:int
VTK_RAMP_LINEAR:int
VTK_RAMP_SCURVE:int
VTK_RAMP_SQRT:int
VTK_RECTILINEAR_GRID:int
VTK_REEB_GRAPH:int
VTK_RGB:int
VTK_RGBA:int
VTK_SCALE_LINEAR:int
VTK_SCALE_LOG10:int
VTK_SELECTION:int
VTK_SHORT:int
VTK_SHORT_MAX:int
VTK_SHORT_MIN:int
VTK_SIGNED_CHAR:int
VTK_SIGNED_CHAR_MAX:int
VTK_SIGNED_CHAR_MIN:int
VTK_SIZEOF_CHAR:int
VTK_SIZEOF_DOUBLE:int
VTK_SIZEOF_FLOAT:int
VTK_SIZEOF_ID_TYPE:int
VTK_SIZEOF_INT:int
VTK_SIZEOF_LONG:int
VTK_SIZEOF_LONG_LONG:int
VTK_SIZEOF_SHORT:int
VTK_SIZEOF_VOID_P:int
VTK_SMP_BACKEND:str
VTK_SMP_DEFAULT_IMPLEMENTATION_OPENMP:int
VTK_SMP_DEFAULT_IMPLEMENTATION_SEQUENTIAL:int
VTK_SMP_DEFAULT_IMPLEMENTATION_STDTHREAD:int
VTK_SMP_DEFAULT_IMPLEMENTATION_TBB:int
VTK_SMP_ENABLE_OPENMP:int
VTK_SMP_ENABLE_SEQUENTIAL:int
VTK_SMP_ENABLE_STDTHREAD:int
VTK_SMP_ENABLE_TBB:int
VTK_SOURCE_VERSION:str
VTK_STRING:int
VTK_STRUCTURED_GRID:int
VTK_STRUCTURED_POINTS:int
VTK_TABLE:int
VTK_TEMPORAL_DATA_SET:int
VTK_TEXT_BOTTOM:int
VTK_TEXT_CENTERED:int
VTK_TEXT_GLOBAL_ANTIALIASING_ALL:int
VTK_TEXT_GLOBAL_ANTIALIASING_NONE:int
VTK_TEXT_GLOBAL_ANTIALIASING_SOME:int
VTK_TEXT_LEFT:int
VTK_TEXT_RIGHT:int
VTK_TEXT_TOP:int
VTK_THREAD_RETURN_VALUE:None
VTK_TIMES:int
VTK_TREE:int
VTK_TYPE_CHAR_IS_SIGNED:int
VTK_TYPE_FLOAT32:int
VTK_TYPE_FLOAT64:int
VTK_TYPE_INT16:int
VTK_TYPE_INT16_MAX:int
VTK_TYPE_INT16_MIN:int
VTK_TYPE_INT32:int
VTK_TYPE_INT32_MAX:int
VTK_TYPE_INT32_MIN:int
VTK_TYPE_INT64:int
VTK_TYPE_INT64_MAX:int
VTK_TYPE_INT64_MIN:int
VTK_TYPE_INT8:int
VTK_TYPE_INT8_MAX:int
VTK_TYPE_INT8_MIN:int
VTK_TYPE_LONG_LONG_FORMAT:str
VTK_TYPE_UINT16:int
VTK_TYPE_UINT16_MAX:int
VTK_TYPE_UINT16_MIN:int
VTK_TYPE_UINT32:int
VTK_TYPE_UINT32_MAX:int
VTK_TYPE_UINT32_MIN:int
VTK_TYPE_UINT64:int
VTK_TYPE_UINT64_MAX:int
VTK_TYPE_UINT64_MIN:int
VTK_TYPE_UINT8:int
VTK_TYPE_UINT8_MAX:int
VTK_TYPE_UINT8_MIN:int
VTK_UNDIRECTED_GRAPH:int
VTK_UNIFORM_GRID:int
VTK_UNIFORM_GRID_AMR:int
VTK_UNIFORM_HYPER_TREE_GRID:int
VTK_UNKNOWN_FONT:int
VTK_UNSIGNED_CHAR:int
VTK_UNSIGNED_CHAR_MAX:int
VTK_UNSIGNED_CHAR_MIN:int
VTK_UNSIGNED_INT:int
VTK_UNSIGNED_INT_MAX:int
VTK_UNSIGNED_INT_MIN:int
VTK_UNSIGNED_LONG:int
VTK_UNSIGNED_LONG_LONG:int
VTK_UNSIGNED_LONG_LONG_MAX:int
VTK_UNSIGNED_LONG_LONG_MIN:int
VTK_UNSIGNED_LONG_MAX:int
VTK_UNSIGNED_LONG_MIN:int
VTK_UNSIGNED_SHORT:int
VTK_UNSIGNED_SHORT_MAX:int
VTK_UNSIGNED_SHORT_MIN:int
VTK_UNSTRUCTURED_GRID:int
VTK_UNSTRUCTURED_GRID_BASE:int
VTK_USE_FLOAT32:int
VTK_USE_FLOAT64:int
VTK_USE_FUTURE_CONST:int
VTK_USE_INT16:int
VTK_USE_INT32:int
VTK_USE_INT64:int
VTK_USE_INT8:int
VTK_USE_UINT16:int
VTK_USE_UINT32:int
VTK_USE_UINT64:int
VTK_USE_UINT8:int
VTK_VARIANT:int
VTK_VERSION:str
VTK_VERSION_FULL:str
VTK_VERSION_NUMBER:int
VTK_VOID:int
vtkArrayIteratorTemplate:Template
vtkDenseArray:Template
vtkEventDataNumberOfDevices:int
vtkEventDataNumberOfInputs:int
vtkGenericDataArray:Template
vtkSOADataArrayTemplate:Template
vtkSparseArray:Template
vtkTypedArray:Template

class reference(object):
    @overload
    def __init__(self, value:int) -> None: ...
    @overload
    def __init__(self, value:float) -> None: ...
    @overload
    def __init__(self, value:str) -> None: ...
    @overload
    def __init__(self, value:Sequence[int]) -> None: ...
    def __round__() -> int: ...
    def __trunc__() -> int: ...
    def get() -> object: ...
    def set(value:object) -> None: ...

class vtkObjectBase(object):
    def FastDelete(self) -> None: ...
    def GetAddressAsString(self, classname:str) -> str: ...
    def GetClassName(self) -> str: ...
    def GetIsInMemkind(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, name:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(name:str) -> int: ...
    def GetObjectDescription(self) -> str: ...
    def GetReferenceCount(self) -> int: ...
    @staticmethod
    def GetUsingMemkind() -> bool: ...
    def InitializeObjectBase(self) -> None: ...
    def IsA(self, name:str) -> int: ...
    @staticmethod
    def IsTypeOf(name:str) -> int: ...
    def Register(self, o:'vtkObjectBase'): ...
    @staticmethod
    def SetMemkindDirectory(directoryname:str) -> None: ...
    def SetReferenceCount(self, __a:int) -> None: ...
    def UnRegister(self, o:'vtkObjectBase'): ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkObject(vtkObjectBase):
    def AddObserver(self, event:int, command:Callback, priority:float=0.0) -> int: ...
    @staticmethod
    def BreakOnError() -> None: ...
    def DebugOff(self) -> None: ...
    def DebugOn(self) -> None: ...
    def GetCommand(self, tag:int) -> 'vtkCommand': ...
    def GetDebug(self) -> bool: ...
    @staticmethod
    def GetGlobalWarningDisplay() -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObjectDescription(self) -> str: ...
    def GetObjectName(self) -> str: ...
    @staticmethod
    def GlobalWarningDisplayOff() -> None: ...
    @staticmethod
    def GlobalWarningDisplayOn() -> None: ...
    @overload
    def HasObserver(self, event:int, __b:'vtkCommand') -> int: ...
    @overload
    def HasObserver(self, event:str, __b:'vtkCommand') -> int: ...
    @overload
    def HasObserver(self, event:int) -> int: ...
    @overload
    def HasObserver(self, event:str) -> int: ...
    @overload
    def InvokeEvent(self, event:int, callData:Any) -> int: ...
    @overload
    def InvokeEvent(self, event:str, callData:Any) -> int: ...
    @overload
    def InvokeEvent(self, event:int) -> int: ...
    @overload
    def InvokeEvent(self, event:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkObject': ...
    def RemoveAllObservers(self) -> None: ...
    @overload
    def RemoveObserver(self, __a:'vtkCommand') -> None: ...
    @overload
    def RemoveObserver(self, tag:int) -> None: ...
    @overload
    def RemoveObservers(self, event:int, __b:'vtkCommand') -> None: ...
    @overload
    def RemoveObservers(self, event:str, __b:'vtkCommand') -> None: ...
    @overload
    def RemoveObservers(self, event:int) -> None: ...
    @overload
    def RemoveObservers(self, event:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkObject': ...
    def SetDebug(self, debugFlag:bool) -> None: ...
    @staticmethod
    def SetGlobalWarningDisplay(val:int) -> None: ...
    def SetObjectName(self, objectName:str) -> None: ...

class vtkAbstractArray(vtkObject):
    class DeleteMethod(int): ...
    AbstractArray:int
    AoSDataArrayTemplate:int
    DataArray:int
    DataArrayTemplate:int
    MAX_DISCRETE_VALUES:int
    MappedDataArray:int
    ScaleSoADataArrayTemplate:int
    SoADataArrayTemplate:int
    TypedDataArray:int
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def Allocate(self, numValues:int, ext:int=1000) -> int: ...
    def ClearLookup(self) -> None: ...
    def CopyComponentNames(self, da:'vtkAbstractArray') -> int: ...
    def CopyInformation(self, infoFrom:'vtkInformation', deep:int=1) -> int: ...
    @staticmethod
    def CreateArray(dataType:int) -> 'vtkAbstractArray': ...
    @staticmethod
    def DISCRETE_VALUES() -> 'vtkInformationVariantVectorKey': ...
    @staticmethod
    def DISCRETE_VALUE_SAMPLE_PARAMETERS() -> 'vtkInformationDoubleVectorKey': ...
    def DataChanged(self) -> None: ...
    def DeepCopy(self, da:'vtkAbstractArray') -> None: ...
    def ExportToVoidPointer(self, out_ptr:Pointer) -> None: ...
    @staticmethod
    def GUI_HIDE() -> 'vtkInformationIntegerKey': ...
    def GetActualMemorySize(self) -> int: ...
    def GetArrayType(self) -> int: ...
    def GetArrayTypeAsString(self) -> str: ...
    def GetComponentName(self, component:int) -> str: ...
    def GetDataSize(self) -> int: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeAsString(self) -> str: ...
    @overload
    def GetDataTypeSize(self) -> int: ...
    @overload
    @staticmethod
    def GetDataTypeSize(type:int) -> int: ...
    def GetElementComponentSize(self) -> int: ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetMaxDiscreteValues(self) -> int: ...
    def GetMaxId(self) -> int: ...
    def GetName(self) -> str: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfComponentsMaxValue(self) -> int: ...
    def GetNumberOfComponentsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetProminentComponentValues(self, comp:int, values:'vtkVariantArray', uncertainty:float=1.e-6, minimumProminence:float=1.e-3) -> None: ...
    def GetSize(self) -> int: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasAComponentName(self) -> bool: ...
    def HasInformation(self) -> bool: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsNumeric(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkAbstractArray': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def PER_COMPONENT() -> 'vtkInformationInformationVectorKey': ...
    @staticmethod
    def PER_FINITE_COMPONENT() -> 'vtkInformationInformationVectorKey': ...
    def Reset(self) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractArray': ...
    def SetComponentName(self, component:int, name:str) -> None: ...
    def SetMaxDiscreteValues(self, _arg:int) -> None: ...
    def SetName(self, _arg:str) -> None: ...
    def SetNumberOfComponents(self, _arg:int) -> None: ...
    def SetNumberOfTuples(self, numTuples:int) -> None: ...
    def SetNumberOfValues(self, numValues:int) -> bool: ...
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, array:Pointer, size:int, save:int) -> None: ...
    @overload
    def SetVoidArray(self, array:Pointer, size:int, save:int, deleteMethod:int) -> None: ...
    def Squeeze(self) -> None: ...

class vtkAnimationCue(vtkObject):
    class PlayDirection(int):
        BACKWARD:'PlayDirection'
        FORWARD:'PlayDirection'
    class TimeCodes(int): ...
    TIMEMODE_NORMALIZED:'TimeCodes'
    TIMEMODE_RELATIVE:'TimeCodes'
    def Finalize(self) -> None: ...
    def GetAnimationTime(self) -> float: ...
    def GetClockTime(self) -> float: ...
    def GetDeltaTime(self) -> float: ...
    def GetDirection(self) -> 'PlayDirection': ...
    def GetEndTime(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStartTime(self) -> float: ...
    def GetTimeMode(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnimationCue': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnimationCue': ...
    def SetDirection(self, _arg:'PlayDirection') -> None: ...
    def SetEndTime(self, _arg:float) -> None: ...
    def SetStartTime(self, _arg:float) -> None: ...
    def SetTimeMode(self, mode:int) -> None: ...
    def SetTimeModeToNormalized(self) -> None: ...
    def SetTimeModeToRelative(self) -> None: ...
    def Tick(self, currenttime:float, deltatime:float, clocktime:float) -> None: ...

class vtkArchiver(vtkObject):
    def CloseArchive(self) -> None: ...
    def Contains(self, relativePath:str) -> bool: ...
    def GetArchiveName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InsertIntoArchive(self, relativePath:str, data:str, size:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArchiver': ...
    def OpenArchive(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArchiver': ...
    def SetArchiveName(self, _arg:str) -> None: ...

class vtkArray(vtkObject):
    DENSE:int
    SPARSE:int
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    @staticmethod
    def CreateArray(StorageType:int, ValueType:int) -> 'vtkArray': ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetDimensionLabel(self, i:int) -> str: ...
    def GetDimensions(self) -> int: ...
    def GetExtent(self, dimension:int) -> 'vtkArrayRange': ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetName(self) -> str: ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self) -> int: ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArray': ...
    @overload
    def Resize(self, i:int) -> None: ...
    @overload
    def Resize(self, i:int, j:int) -> None: ...
    @overload
    def Resize(self, i:int, j:int, k:int) -> None: ...
    @overload
    def Resize(self, i:'vtkArrayRange') -> None: ...
    @overload
    def Resize(self, i:'vtkArrayRange', j:'vtkArrayRange') -> None: ...
    @overload
    def Resize(self, i:'vtkArrayRange', j:'vtkArrayRange', k:'vtkArrayRange') -> None: ...
    @overload
    def Resize(self, extents:'vtkArrayExtents') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArray': ...
    def SetDimensionLabel(self, i:int, label:str) -> None: ...
    def SetName(self, name:str) -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkArrayCoordinates(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, i:int) -> None: ...
    @overload
    def __init__(self, i:int, j:int) -> None: ...
    @overload
    def __init__(self, i:int, j:int, k:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkArrayCoordinates') -> None: ...
    def GetCoordinate(self, i:int) -> int: ...
    def GetDimensions(self) -> int: ...
    def SetCoordinate(self, i:int, __b:int) -> None: ...
    def SetDimensions(self, dimensions:int) -> None: ...

class vtkArrayExtents(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, i:int) -> None: ...
    @overload
    def __init__(self, i:'vtkArrayRange') -> None: ...
    @overload
    def __init__(self, i:int, j:int) -> None: ...
    @overload
    def __init__(self, i:'vtkArrayRange', j:'vtkArrayRange') -> None: ...
    @overload
    def __init__(self, i:int, j:int, k:int) -> None: ...
    @overload
    def __init__(self, i:'vtkArrayRange', j:'vtkArrayRange', k:'vtkArrayRange') -> None: ...
    @overload
    def __init__(self, __a:'vtkArrayExtents') -> None: ...
    def Append(self, extent:'vtkArrayRange') -> None: ...
    def Contains(self, coordinates:'vtkArrayCoordinates') -> bool: ...
    def GetDimensions(self) -> int: ...
    def GetExtent(self, i:int) -> 'vtkArrayRange': ...
    def GetLeftToRightCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetRightToLeftCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetSize(self) -> int: ...
    def SameShape(self, rhs:'vtkArrayExtents') -> bool: ...
    def SetDimensions(self, dimensions:int) -> None: ...
    def SetExtent(self, i:int, __b:'vtkArrayRange') -> None: ...
    @staticmethod
    def Uniform(n:int, m:int) -> 'vtkArrayExtents': ...
    def ZeroBased(self) -> bool: ...

class vtkArrayExtentsList(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, i:'vtkArrayExtents') -> None: ...
    @overload
    def __init__(self, i:'vtkArrayExtents', j:'vtkArrayExtents') -> None: ...
    @overload
    def __init__(self, i:'vtkArrayExtents', j:'vtkArrayExtents', k:'vtkArrayExtents') -> None: ...
    @overload
    def __init__(self, i:'vtkArrayExtents', j:'vtkArrayExtents', k:'vtkArrayExtents', l:'vtkArrayExtents') -> None: ...
    @overload
    def __init__(self, __a:'vtkArrayExtentsList') -> None: ...
    def GetCount(self) -> int: ...
    def SetCount(self, count:int) -> None: ...

class vtkArrayIterator(vtkObject):
    def GetDataType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIterator': ...

class vtkArrayIteratorTemplate_I10vtkVariantE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetValue(self, id:int) -> 'vtkVariant': ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_I10vtkVariantE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_I10vtkVariantE': ...
    def SetValue(self, id:int, value:'vtkVariant') -> None: ...

class vtkArrayIteratorTemplate_I12vtkStdStringE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetValue(self, id:int) -> str: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_I12vtkStdStringE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_I12vtkStdStringE': ...
    def SetValue(self, id:int, value:str) -> None: ...

class vtkArrayIteratorTemplate_IaE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IaE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IaE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IcE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[str, str]: ...
    def GetValue(self, id:int) -> str: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IcE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IcE': ...
    def SetValue(self, id:int, value:str) -> None: ...

class vtkArrayIteratorTemplate_IdE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[float, float]: ...
    def GetValue(self, id:int) -> float: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IdE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IdE': ...
    def SetValue(self, id:int, value:float) -> None: ...

class vtkArrayIteratorTemplate_IfE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[float, float]: ...
    def GetValue(self, id:int) -> float: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IfE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IfE': ...
    def SetValue(self, id:int, value:float) -> None: ...

class vtkArrayIteratorTemplate_IhE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IhE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IhE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IiE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IiE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IiE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IjE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IjE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IjE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IlE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IlE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IlE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_ImE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_ImE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_ImE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IsE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IsE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IsE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_ItE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_ItE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_ItE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IxE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IxE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IxE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayIteratorTemplate_IyE(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayIteratorTemplate_IyE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayIteratorTemplate_IyE': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkArrayRange(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, begin:int, end:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkArrayRange') -> None: ...
    @overload
    def Contains(self, range:'vtkArrayRange') -> bool: ...
    @overload
    def Contains(self, coordinate:int) -> bool: ...
    def GetBegin(self) -> int: ...
    def GetEnd(self) -> int: ...
    def GetSize(self) -> int: ...

class vtkArraySort(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, i:int) -> None: ...
    @overload
    def __init__(self, i:int, j:int) -> None: ...
    @overload
    def __init__(self, i:int, j:int, k:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkArraySort') -> None: ...
    def GetDimensions(self) -> int: ...
    def SetDimensions(self, dimensions:int) -> None: ...

class vtkArrayWeights(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other:'vtkArrayWeights') -> None: ...
    @overload
    def __init__(self, i:float) -> None: ...
    @overload
    def __init__(self, i:float, j:float) -> None: ...
    @overload
    def __init__(self, i:float, j:float, k:float) -> None: ...
    @overload
    def __init__(self, i:float, j:float, k:float, l:float) -> None: ...
    def GetCount(self) -> int: ...
    def SetCount(self, count:int) -> None: ...

class vtkAtomicMutex(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other:'vtkAtomicMutex') -> None: ...
    def lock(self) -> None: ...
    def unlock(self) -> None: ...

class vtkDataArray(vtkAbstractArray):
    @staticmethod
    def COMPONENT_RANGE() -> 'vtkInformationDoubleVectorKey': ...
    def CopyComponent(self, dstComponent:int, src:'vtkDataArray', srcComponent:int) -> None: ...
    def CopyInformation(self, infoFrom:'vtkInformation', deep:int=1) -> int: ...
    @staticmethod
    def CreateDataArray(dataType:int) -> 'vtkDataArray': ...
    def CreateDefaultLookupTable(self) -> None: ...
    @overload
    def DeepCopy(self, aa:'vtkAbstractArray') -> None: ...
    @overload
    def DeepCopy(self, da:'vtkDataArray') -> None: ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkDataArray': ...
    def Fill(self, value:float) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetArrayType(self) -> int: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetData(self, tupleMin:int, tupleMax:int, compMin:int, compMax:int, data:'vtkDoubleArray') -> None: ...
    @overload
    def GetDataTypeMax(self) -> float: ...
    @overload
    @staticmethod
    def GetDataTypeMax(type:int) -> float: ...
    @overload
    def GetDataTypeMin(self) -> float: ...
    @overload
    @staticmethod
    def GetDataTypeMin(type:int) -> float: ...
    @overload
    def GetDataTypeRange(self, range:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GetDataTypeRange(type:int, range:MutableSequence[float]) -> None: ...
    def GetElementComponentSize(self) -> int: ...
    @overload
    def GetFiniteRange(self, range:MutableSequence[float], comp:int) -> None: ...
    @overload
    def GetFiniteRange(self, range:MutableSequence[float], comp:int, ghosts:Sequence[int], ghostsToSkip:int) -> None: ...
    @overload
    def GetFiniteRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetFiniteRange(self) -> Tuple[float, float]: ...
    @overload
    def GetFiniteRange(self, range:MutableSequence[float]) -> None: ...
    def GetLookupTable(self) -> 'vtkLookupTable': ...
    def GetMaxNorm(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetRange(self, range:MutableSequence[float], comp:int) -> None: ...
    @overload
    def GetRange(self, range:MutableSequence[float], comp:int, ghosts:Sequence[int], ghostsToSkip:int) -> None: ...
    @overload
    def GetRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetRange(self) -> Tuple[float, float]: ...
    @overload
    def GetRange(self, range:MutableSequence[float]) -> None: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    def GetTuple1(self, tupleIdx:int) -> float: ...
    def GetTuple2(self, tupleIdx:int) -> Tuple[float, float]: ...
    def GetTuple3(self, tupleIdx:int) -> Tuple[float, float, float]: ...
    def GetTuple4(self, tupleIdx:int) -> Tuple[float, float, float, float]: ...
    def GetTuple6(self, tupleIdx:int) -> Tuple[float, float, float, float, float, float]: ...
    def GetTuple9(self, tupleIdx:int) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTuple1(self, value:float) -> None: ...
    def InsertNextTuple2(self, val0:float, val1:float) -> None: ...
    def InsertNextTuple3(self, val0:float, val1:float, val2:float) -> None: ...
    def InsertNextTuple4(self, val0:float, val1:float, val2:float, val3:float) -> None: ...
    def InsertNextTuple6(self, val0:float, val1:float, val2:float, val3:float, val4:float, val5:float) -> None: ...
    def InsertNextTuple9(self, val0:float, val1:float, val2:float, val3:float, val4:float, val5:float, val6:float, val7:float, val8:float) -> None: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def InsertTuple1(self, tupleIdx:int, value:float) -> None: ...
    def InsertTuple2(self, tupleIdx:int, val0:float, val1:float) -> None: ...
    def InsertTuple3(self, tupleIdx:int, val0:float, val1:float, val2:float) -> None: ...
    def InsertTuple4(self, tupleIdx:int, val0:float, val1:float, val2:float, val3:float) -> None: ...
    def InsertTuple6(self, tupleIdx:int, val0:float, val1:float, val2:float, val3:float, val4:float, val5:float) -> None: ...
    def InsertTuple9(self, tupleIdx:int, val0:float, val1:float, val2:float, val3:float, val4:float, val5:float, val6:float, val7:float, val8:float) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsNumeric(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def L2_NORM_FINITE_RANGE() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def L2_NORM_RANGE() -> 'vtkInformationDoubleVectorKey': ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkDataArray': ...
    def RemoveFirstTuple(self) -> None: ...
    def RemoveLastTuple(self) -> None: ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataArray': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetLookupTable(self, lut:'vtkLookupTable') -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTuple1(self, tupleIdx:int, value:float) -> None: ...
    def SetTuple2(self, tupleIdx:int, val0:float, val1:float) -> None: ...
    def SetTuple3(self, tupleIdx:int, val0:float, val1:float, val2:float) -> None: ...
    def SetTuple4(self, tupleIdx:int, val0:float, val1:float, val2:float, val3:float) -> None: ...
    def SetTuple6(self, tupleIdx:int, val0:float, val1:float, val2:float, val3:float, val4:float, val5:float) -> None: ...
    def SetTuple9(self, tupleIdx:int, val0:float, val1:float, val2:float, val3:float, val4:float, val5:float, val6:float, val7:float, val8:float) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...
    @staticmethod
    def UNITS_LABEL() -> 'vtkInformationStringKey': ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkBitArray(vtkDataArray):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    @overload
    def DeepCopy(self, da:'vtkDataArray') -> None: ...
    @overload
    def DeepCopy(self, aa:'vtkAbstractArray') -> None: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    @overload
    def GetTuple(self, i:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, i:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    def GetVoidPointer(self, id:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, i:int, j:int, c:float) -> None: ...
    @overload
    def InsertNextTuple(self, j:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextValue(self, i:int) -> int: ...
    @overload
    def InsertTuple(self, i:int, j:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, i:int, tuple:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertValue(self, id:int, i:int) -> None: ...
    def InsertVariantValue(self, idx:int, value:'vtkVariant') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', ids:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:int) -> int: ...
    @overload
    def LookupValue(self, value:int, ids:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkBitArray': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveFirstTuple(self) -> None: ...
    def RemoveLastTuple(self) -> None: ...
    def RemoveTuple(self, id:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBitArray': ...
    def SetComponent(self, i:int, j:int, c:float) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    @overload
    def SetTuple(self, i:int, j:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, i:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def SetVariantValue(self, idx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, array:Pointer, size:int, save:int) -> None: ...
    @overload
    def SetVoidArray(self, array:Pointer, size:int, save:int, deleteMethod:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...
    def WriteVoidPointer(self, id:int, number:int) -> Pointer: ...

class vtkBitArrayIterator(vtkArrayIterator):
    def GetArray(self) -> 'vtkAbstractArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetTuple(self, id:int) -> Tuple[int, int]: ...
    def GetValue(self, id:int) -> int: ...
    def Initialize(self, array:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBitArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBitArrayIterator': ...
    def SetValue(self, id:int, value:int) -> None: ...

class vtkRandomSequence(vtkObject):
    def GetNextValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self) -> float: ...
    def Initialize(self, seed:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRandomSequence': ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRandomSequence': ...

class vtkGaussianRandomSequence(vtkRandomSequence):
    def GetNextScaledValue(self, mean:float, standardDeviation:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaledValue(self, mean:float, standardDeviation:float) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGaussianRandomSequence': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGaussianRandomSequence': ...

class vtkBoxMuellerRandomSequence(vtkGaussianRandomSequence):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniformSequence(self) -> 'vtkRandomSequence': ...
    def GetValue(self) -> float: ...
    def Initialize(self, seed:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBoxMuellerRandomSequence': ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoxMuellerRandomSequence': ...
    def SetUniformSequence(self, uniformSequence:'vtkRandomSequence') -> None: ...

class vtkBreakPoint(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkBreakPoint') -> None: ...
    @staticmethod
    def Break() -> None: ...

class vtkByteSwap(vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkByteSwap': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkByteSwap': ...
    @staticmethod
    def Swap2BE(p:Pointer) -> None: ...
    @staticmethod
    def Swap2BERange(p:Pointer, num:int) -> None: ...
    @staticmethod
    def Swap2LE(p:Pointer) -> None: ...
    @staticmethod
    def Swap2LERange(p:Pointer, num:int) -> None: ...
    @staticmethod
    def Swap4BE(p:Pointer) -> None: ...
    @staticmethod
    def Swap4BERange(p:Pointer, num:int) -> None: ...
    @staticmethod
    def Swap4LE(p:Pointer) -> None: ...
    @staticmethod
    def Swap4LERange(p:Pointer, num:int) -> None: ...
    @staticmethod
    def Swap8BE(p:Pointer) -> None: ...
    @staticmethod
    def Swap8BERange(p:Pointer, num:int) -> None: ...
    @staticmethod
    def Swap8LE(p:Pointer) -> None: ...
    @staticmethod
    def Swap8LERange(p:Pointer, num:int) -> None: ...
    @overload
    @staticmethod
    def SwapBE(p:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def SwapBE(p:str) -> None: ...
    @overload
    @staticmethod
    def SwapBE(p:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def SwapBERange(p:MutableSequence[float], num:int) -> None: ...
    @overload
    @staticmethod
    def SwapBERange(p:str, num:int) -> None: ...
    @overload
    @staticmethod
    def SwapBERange(p:MutableSequence[int], num:int) -> None: ...
    @overload
    @staticmethod
    def SwapLE(p:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def SwapLE(p:str) -> None: ...
    @overload
    @staticmethod
    def SwapLE(p:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def SwapLERange(p:MutableSequence[float], num:int) -> None: ...
    @overload
    @staticmethod
    def SwapLERange(p:str, num:int) -> None: ...
    @overload
    @staticmethod
    def SwapLERange(p:MutableSequence[int], num:int) -> None: ...
    @staticmethod
    def SwapVoidRange(buffer:Pointer, numWords:int, wordSize:int) -> None: ...

class vtkCommand(vtkObjectBase):
    class EventIds(int): ...
    AbortCheckEvent:'EventIds'
    ActiveCameraEvent:'EventIds'
    AnimationCueTickEvent:'EventIds'
    AnnotationChangedEvent:'EventIds'
    AnyEvent:'EventIds'
    Button3DEvent:'EventIds'
    CharEvent:'EventIds'
    Clip3DEvent:'EventIds'
    ComputeVisiblePropBoundsEvent:'EventIds'
    ConfigureEvent:'EventIds'
    ConnectionClosedEvent:'EventIds'
    ConnectionCreatedEvent:'EventIds'
    CreateCameraEvent:'EventIds'
    CreateTimerEvent:'EventIds'
    CurrentChangedEvent:'EventIds'
    CursorChangedEvent:'EventIds'
    DeleteEvent:'EventIds'
    DeletePointEvent:'EventIds'
    DestroyTimerEvent:'EventIds'
    DisableEvent:'EventIds'
    DomainModifiedEvent:'EventIds'
    DropFilesEvent:'EventIds'
    Elevation3DEvent:'EventIds'
    EnableEvent:'EventIds'
    EndAnimationCueEvent:'EventIds'
    EndEvent:'EventIds'
    EndInteractionEvent:'EventIds'
    EndPanEvent:'EventIds'
    EndPickEvent:'EventIds'
    EndPinchEvent:'EventIds'
    EndRotateEvent:'EventIds'
    EndSwipeEvent:'EventIds'
    EndWindowLevelEvent:'EventIds'
    EnterEvent:'EventIds'
    ErrorEvent:'EventIds'
    ExecuteInformationEvent:'EventIds'
    ExitEvent:'EventIds'
    ExposeEvent:'EventIds'
    FifthButtonPressEvent:'EventIds'
    FifthButtonReleaseEvent:'EventIds'
    FourthButtonPressEvent:'EventIds'
    FourthButtonReleaseEvent:'EventIds'
    HighlightEvent:'EventIds'
    HoverEvent:'EventIds'
    InteractionEvent:'EventIds'
    KeyPressEvent:'EventIds'
    KeyReleaseEvent:'EventIds'
    LeaveEvent:'EventIds'
    LeftButtonDoubleClickEvent:'EventIds'
    LeftButtonPressEvent:'EventIds'
    LeftButtonReleaseEvent:'EventIds'
    LoadStateEvent:'EventIds'
    LongTapEvent:'EventIds'
    Menu3DEvent:'EventIds'
    MessageEvent:'EventIds'
    MiddleButtonDoubleClickEvent:'EventIds'
    MiddleButtonPressEvent:'EventIds'
    MiddleButtonReleaseEvent:'EventIds'
    ModifiedEvent:'EventIds'
    MouseMoveEvent:'EventIds'
    MouseWheelBackwardEvent:'EventIds'
    MouseWheelForwardEvent:'EventIds'
    MouseWheelLeftEvent:'EventIds'
    MouseWheelRightEvent:'EventIds'
    Move3DEvent:'EventIds'
    NextPose3DEvent:'EventIds'
    NoEvent:'EventIds'
    PanEvent:'EventIds'
    Pick3DEvent:'EventIds'
    PickEvent:'EventIds'
    PinchEvent:'EventIds'
    PlacePointEvent:'EventIds'
    PlaceWidgetEvent:'EventIds'
    PositionProp3DEvent:'EventIds'
    ProgressEvent:'EventIds'
    PropertyModifiedEvent:'EventIds'
    RegisterEvent:'EventIds'
    RenderEvent:'EventIds'
    RenderWindowMessageEvent:'EventIds'
    ResetCameraClippingRangeEvent:'EventIds'
    ResetCameraEvent:'EventIds'
    ResetWindowLevelEvent:'EventIds'
    ResliceAxesChangedEvent:'EventIds'
    RightButtonDoubleClickEvent:'EventIds'
    RightButtonPressEvent:'EventIds'
    RightButtonReleaseEvent:'EventIds'
    RotateEvent:'EventIds'
    SaveStateEvent:'EventIds'
    Select3DEvent:'EventIds'
    SelectionChangedEvent:'EventIds'
    SetOutputEvent:'EventIds'
    StartAnimationCueEvent:'EventIds'
    StartEvent:'EventIds'
    StartInteractionEvent:'EventIds'
    StartPanEvent:'EventIds'
    StartPickEvent:'EventIds'
    StartPinchEvent:'EventIds'
    StartRotateEvent:'EventIds'
    StartSwipeEvent:'EventIds'
    StartWindowLevelEvent:'EventIds'
    StateChangedEvent:'EventIds'
    SwipeEvent:'EventIds'
    TDxButtonPressEvent:'EventIds'
    TDxButtonReleaseEvent:'EventIds'
    TDxMotionEvent:'EventIds'
    TapEvent:'EventIds'
    TextEvent:'EventIds'
    TimerEvent:'EventIds'
    UnRegisterEvent:'EventIds'
    UncheckedPropertyModifiedEvent:'EventIds'
    UpdateDataEvent:'EventIds'
    UpdateDropLocationEvent:'EventIds'
    UpdateEvent:'EventIds'
    UpdateInformationEvent:'EventIds'
    UpdatePropertyEvent:'EventIds'
    UpdateShaderEvent:'EventIds'
    UserEvent:'EventIds'
    ViewProgressEvent:'EventIds'
    ViewerMovement3DEvent:'EventIds'
    VolumeMapperComputeGradientsEndEvent:'EventIds'
    VolumeMapperComputeGradientsProgressEvent:'EventIds'
    VolumeMapperComputeGradientsStartEvent:'EventIds'
    VolumeMapperRenderEndEvent:'EventIds'
    VolumeMapperRenderProgressEvent:'EventIds'
    VolumeMapperRenderStartEvent:'EventIds'
    WarningEvent:'EventIds'
    WidgetActivateEvent:'EventIds'
    WidgetModifiedEvent:'EventIds'
    WidgetValueChangedEvent:'EventIds'
    WindowFrameEvent:'EventIds'
    WindowIsCurrentEvent:'EventIds'
    WindowIsDirectEvent:'EventIds'
    WindowLevelEvent:'EventIds'
    WindowMakeCurrentEvent:'EventIds'
    WindowResizeEvent:'EventIds'
    WindowStereoTypeChangedEvent:'EventIds'
    WindowSupportsOpenGLEvent:'EventIds'
    WrongTagEvent:'EventIds'
    def AbortFlagOff(self) -> None: ...
    def AbortFlagOn(self) -> None: ...
    @staticmethod
    def EventHasData(event:int) -> bool: ...
    def Execute(self, caller:'vtkObject', eventId:int, callData:Pointer) -> None: ...
    def GetAbortFlag(self) -> int: ...
    @staticmethod
    def GetEventIdFromString(event:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassiveObserver(self) -> int: ...
    @staticmethod
    def GetStringFromEventId(event:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCommand': ...
    def PassiveObserverOff(self) -> None: ...
    def PassiveObserverOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCommand': ...
    def SetAbortFlag(self, f:int) -> None: ...
    def SetPassiveObserver(self, f:int) -> None: ...

class vtkCallbackCommand(vtkCommand):
    def AbortFlagOnExecuteOff(self) -> None: ...
    def AbortFlagOnExecuteOn(self) -> None: ...
    def Execute(self, caller:'vtkObject', eid:int, callData:Pointer) -> None: ...
    def GetAbortFlagOnExecute(self) -> int: ...
    def GetClientData(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCallbackCommand': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCallbackCommand': ...
    def SetAbortFlagOnExecute(self, f:int) -> None: ...
    def SetClientData(self, cd:Pointer) -> None: ...

class vtkCharArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkCharArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkCharArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> str: ...
    @staticmethod
    def GetDataTypeValueMin() -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> str: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[str]) -> None: ...
    def GetValue(self, id:int) -> str: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[str, str]: ...
    @overload
    def GetValueRange(self) -> Tuple[str, str]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[str]) -> int: ...
    def InsertNextValue(self, f:str) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[str]) -> None: ...
    def InsertValue(self, id:int, f:str) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCharArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCharArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[str]) -> None: ...
    def SetValue(self, id:int, value:str) -> None: ...
    def WritePointer(self, id:int, number:int) -> str: ...

class vtkCollection(vtkObject):
    def AddItem(self, __a:'vtkObject') -> None: ...
    def GetItemAsObject(self, i:int) -> 'vtkObject': ...
    def GetNextItemAsObject(self) -> 'vtkObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfItems(self) -> int: ...
    def InitTraversal(self) -> None: ...
    def InsertItem(self, i:int, __b:'vtkObject') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsItemPresent(self, a:'vtkObject') -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollection': ...
    def NewIterator(self) -> 'vtkCollectionIterator': ...
    def RemoveAllItems(self) -> None: ...
    @overload
    def RemoveItem(self, i:int) -> None: ...
    @overload
    def RemoveItem(self, __a:'vtkObject') -> None: ...
    def ReplaceItem(self, i:int, __b:'vtkObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollection': ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkCollectionElement(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkCollectionElement') -> None: ...

class vtkCollectionIterator(vtkObject):
    def GetCollection(self) -> 'vtkCollection': ...
    def GetCurrentObject(self) -> 'vtkObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GoToFirstItem(self) -> None: ...
    def GoToNextItem(self) -> None: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollectionIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollectionIterator': ...
    def SetCollection(self, __a:'vtkCollection') -> None: ...

class vtkCommonInformationKeyManager(object):
    def __init__(self) -> None: ...

class vtkConditionVariable(vtkObject):
    def Broadcast(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConditionVariable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConditionVariable': ...
    def Signal(self) -> None: ...
    def Wait(self, mutex:'vtkMutexLock') -> int: ...

class vtkCriticalSection(vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Lock(self) -> None: ...
    def NewInstance(self) -> 'vtkCriticalSection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCriticalSection': ...
    def Unlock(self) -> None: ...

class vtkDataArrayCollection(vtkCollection):
    def AddItem(self, ds:'vtkDataArray') -> None: ...
    def GetItem(self, i:int) -> 'vtkDataArray': ...
    def GetNextItem(self) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataArrayCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataArrayCollection': ...

class vtkDataArrayCollectionIterator(vtkCollectionIterator):
    def GetDataArray(self) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataArrayCollectionIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataArrayCollectionIterator': ...
    @overload
    def SetCollection(self, __a:'vtkCollection') -> None: ...
    @overload
    def SetCollection(self, __a:'vtkDataArrayCollection') -> None: ...

class vtkDataArraySelection(vtkObject):
    def AddArray(self, name:str, state:bool=True) -> int: ...
    def ArrayExists(self, name:str) -> int: ...
    def ArrayIsEnabled(self, name:str) -> int: ...
    def CopySelections(self, selections:'vtkDataArraySelection') -> None: ...
    def DeepCopy(self, other:'vtkDataArraySelection') -> None: ...
    def DisableAllArrays(self) -> None: ...
    def DisableArray(self, name:str) -> None: ...
    def EnableAllArrays(self) -> None: ...
    def EnableArray(self, name:str) -> None: ...
    def GetArrayIndex(self, name:str) -> int: ...
    def GetArrayName(self, index:int) -> str: ...
    @overload
    def GetArraySetting(self, index:int) -> int: ...
    @overload
    def GetArraySetting(self, name:str) -> int: ...
    def GetEnabledArrayIndex(self, name:str) -> int: ...
    def GetNumberOfArrays(self) -> int: ...
    def GetNumberOfArraysEnabled(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUnknownArraySetting(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsEqual(self, other:'vtkDataArraySelection') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataArraySelection': ...
    def RemoveAllArrays(self) -> None: ...
    def RemoveArrayByIndex(self, index:int) -> None: ...
    def RemoveArrayByName(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataArraySelection': ...
    def SetArraySetting(self, name:str, setting:int) -> None: ...
    def SetUnknownArraySetting(self, _arg:int) -> None: ...
    @overload
    def Union(self, other:'vtkDataArraySelection') -> None: ...
    @overload
    def Union(self, other:'vtkDataArraySelection', skipModified:bool) -> None: ...

class vtkDebugLeaks(vtkObject):
    @overload
    @staticmethod
    def ConstructClass(object:'vtkObjectBase') -> None: ...
    @overload
    @staticmethod
    def ConstructClass(className:str) -> None: ...
    @overload
    @staticmethod
    def DestructClass(object:'vtkObjectBase') -> None: ...
    @overload
    @staticmethod
    def DestructClass(className:str) -> None: ...
    @staticmethod
    def GetExitError() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDebugLeaks': ...
    @staticmethod
    def PrintCurrentLeaks() -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDebugLeaks': ...
    @staticmethod
    def SetExitError(__a:int) -> None: ...

class vtkDebugLeaksManager(object):
    def __init__(self) -> None: ...

class vtkDebugLeaksObserver(object):
    def ConstructingObject(self, __a:'vtkObjectBase') -> None: ...
    def DestructingObject(self, __a:'vtkObjectBase') -> None: ...

class vtkTypedArray_I10vtkVariantE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    def GetValueN(self, n:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_I10vtkVariantE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_I10vtkVariantE': ...
    @overload
    def SetValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    def SetValueN(self, n:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_I10vtkVariantE(vtkTypedArray_I10vtkVariantE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:'vtkVariant') -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    def GetValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_I10vtkVariantE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_I10vtkVariantE': ...
    @overload
    def SetValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    def SetValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkTypedArray_I12vtkStdStringE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> str: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> str: ...
    def GetValueN(self, n:int) -> str: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_I12vtkStdStringE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_I12vtkStdStringE': ...
    @overload
    def SetValue(self, i:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def SetValueN(self, n:int, value:str) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_I12vtkStdStringE(vtkTypedArray_I12vtkStdStringE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:str) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> str: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> str: ...
    def GetValueN(self, n:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_I12vtkStdStringE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_I12vtkStdStringE': ...
    @overload
    def SetValue(self, i:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def SetValueN(self, n:int, value:str) -> None: ...

class vtkTypedArray_IaE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IaE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IaE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IaE(vtkTypedArray_IaE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IaE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IaE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IcE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> str: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> str: ...
    def GetValueN(self, n:int) -> str: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IcE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IcE': ...
    @overload
    def SetValue(self, i:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def SetValueN(self, n:int, value:str) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IcE(vtkTypedArray_IcE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:str) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> str: ...
    @overload
    def GetValue(self, i:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> str: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> str: ...
    def GetValueN(self, n:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IcE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IcE': ...
    @overload
    def SetValue(self, i:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def SetValueN(self, n:int, value:str) -> None: ...

class vtkTypedArray_IdE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> float: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> float: ...
    def GetValueN(self, n:int) -> float: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IdE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IdE': ...
    @overload
    def SetValue(self, i:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def SetValueN(self, n:int, value:float) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IdE(vtkTypedArray_IdE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:float) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> float: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> float: ...
    def GetValueN(self, n:int) -> float: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IdE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IdE': ...
    @overload
    def SetValue(self, i:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def SetValueN(self, n:int, value:float) -> None: ...

class vtkTypedArray_IfE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> float: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> float: ...
    def GetValueN(self, n:int) -> float: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IfE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IfE': ...
    @overload
    def SetValue(self, i:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def SetValueN(self, n:int, value:float) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IfE(vtkTypedArray_IfE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:float) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> float: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> float: ...
    def GetValueN(self, n:int) -> float: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IfE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IfE': ...
    @overload
    def SetValue(self, i:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def SetValueN(self, n:int, value:float) -> None: ...

class vtkTypedArray_IhE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IhE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IhE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IhE(vtkTypedArray_IhE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IhE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IhE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IiE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IiE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IiE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IiE(vtkTypedArray_IiE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IiE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IiE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IjE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IjE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IjE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IjE(vtkTypedArray_IjE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IjE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IjE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IlE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IlE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IlE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IlE(vtkTypedArray_IlE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IlE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IlE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_ImE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_ImE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_ImE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_ImE(vtkTypedArray_ImE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_ImE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_ImE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IsE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IsE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IsE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IsE(vtkTypedArray_IsE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IsE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IsE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_ItE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_ItE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_ItE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_ItE(vtkTypedArray_ItE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_ItE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_ItE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IxE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IxE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IxE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IxE(vtkTypedArray_IxE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IxE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IxE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkTypedArray_IyE(vtkArray):
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_index:int, target_coordinates:'vtkArrayCoordinates') -> None: ...
    @overload
    def CopyValue(self, source:'vtkArray', source_coordinates:'vtkArrayCoordinates', target_index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    @overload
    def GetVariantValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetVariantValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    def GetVariantValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypedArray_IyE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypedArray_IyE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    @overload
    def SetVariantValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVariantValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    def SetVariantValueN(self, n:int, value:'vtkVariant') -> None: ...

class vtkDenseArray_IyE(vtkTypedArray_IyE):
    def DeepCopy(self) -> 'vtkArray': ...
    def Fill(self, value:int) -> None: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStorage(self) -> Pointer: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDenseArray_IyE': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDenseArray_IyE': ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...

class vtkDoubleArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkDoubleArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkDoubleArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> float: ...
    @staticmethod
    def GetDataTypeValueMin() -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, id:int) -> float: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetValueRange(self) -> Tuple[float, float]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextValue(self, f:float) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[float]) -> None: ...
    def InsertValue(self, id:int, f:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDoubleArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDoubleArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, id:int, value:float) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkDynamicLoader(vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LastError() -> str: ...
    @staticmethod
    def LibExtension() -> str: ...
    @staticmethod
    def LibPrefix() -> str: ...
    def NewInstance(self) -> 'vtkDynamicLoader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDynamicLoader': ...

class vtkEventData(vtkObjectBase):
    def GetAsEventDataDevice3D(self) -> 'vtkEventDataDevice3D': ...
    def GetAsEventDataForDevice(self) -> 'vtkEventDataForDevice': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEventData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEventData': ...
    def SetType(self, val:int) -> None: ...

class vtkEventDataForDevice(vtkEventData):
    def DeviceMatches(self, val:'vtkEventDataDevice') -> bool: ...
    def GetAction(self) -> 'vtkEventDataAction': ...
    def GetAsEventDataForDevice(self) -> 'vtkEventDataForDevice': ...
    def GetDevice(self) -> 'vtkEventDataDevice': ...
    def GetInput(self) -> 'vtkEventDataDeviceInput': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEventDataForDevice': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEventDataForDevice': ...
    def SetAction(self, v:'vtkEventDataAction') -> None: ...
    def SetDevice(self, v:'vtkEventDataDevice') -> None: ...
    def SetInput(self, v:'vtkEventDataDeviceInput') -> None: ...

class vtkEventDataDevice3D(vtkEventDataForDevice):
    def GetAsEventDataDevice3D(self) -> 'vtkEventDataDevice3D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetTrackPadPosition(self, v:MutableSequence[float]) -> None: ...
    @overload
    def GetTrackPadPosition(self) -> Tuple[float, float]: ...
    @overload
    def GetWorldDirection(self, v:MutableSequence[float]) -> None: ...
    @overload
    def GetWorldDirection(self) -> Tuple[float, float, float]: ...
    @overload
    def GetWorldOrientation(self, v:MutableSequence[float]) -> None: ...
    @overload
    def GetWorldOrientation(self) -> Tuple[float, float, float, float]: ...
    @overload
    def GetWorldPosition(self, v:MutableSequence[float]) -> None: ...
    @overload
    def GetWorldPosition(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEventDataDevice3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEventDataDevice3D': ...
    @overload
    def SetTrackPadPosition(self, p:Sequence[float]) -> None: ...
    @overload
    def SetTrackPadPosition(self, x:float, y:float) -> None: ...
    def SetWorldDirection(self, p:Sequence[float]) -> None: ...
    def SetWorldOrientation(self, p:Sequence[float]) -> None: ...
    def SetWorldPosition(self, p:Sequence[float]) -> None: ...

class vtkEventForwarderCommand(vtkCommand):
    def Execute(self, caller:'vtkObject', eid:int, callData:Pointer) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTarget(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEventForwarderCommand': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEventForwarderCommand': ...
    def SetTarget(self, obj:'vtkObject') -> None: ...

class vtkOutputWindow(vtkObject):
    class DisplayModes(int): ...
    ALWAYS:'DisplayModes'
    ALWAYS_STDERR:'DisplayModes'
    DEFAULT:'DisplayModes'
    NEVER:'DisplayModes'
    def DisplayDebugText(self, __a:str) -> None: ...
    def DisplayErrorText(self, __a:str) -> None: ...
    def DisplayGenericWarningText(self, __a:str) -> None: ...
    def DisplayText(self, __a:str) -> None: ...
    def DisplayWarningText(self, __a:str) -> None: ...
    def GetDisplayMode(self) -> int: ...
    def GetDisplayModeMaxValue(self) -> int: ...
    def GetDisplayModeMinValue(self) -> int: ...
    @staticmethod
    def GetInstance() -> 'vtkOutputWindow': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOutputWindow': ...
    def PromptUserOff(self) -> None: ...
    def PromptUserOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOutputWindow': ...
    def SetDisplayMode(self, _arg:int) -> None: ...
    def SetDisplayModeToAlways(self) -> None: ...
    def SetDisplayModeToAlwaysStdErr(self) -> None: ...
    def SetDisplayModeToDefault(self) -> None: ...
    def SetDisplayModeToNever(self) -> None: ...
    @staticmethod
    def SetInstance(instance:'vtkOutputWindow') -> None: ...
    def SetPromptUser(self, _arg:bool) -> None: ...

class vtkFileOutputWindow(vtkOutputWindow):
    def AppendOff(self) -> None: ...
    def AppendOn(self) -> None: ...
    def DisplayText(self, __a:str) -> None: ...
    def FlushOff(self) -> None: ...
    def FlushOn(self) -> None: ...
    def GetAppend(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetFlush(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFileOutputWindow': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFileOutputWindow': ...
    def SetAppend(self, _arg:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetFlush(self, _arg:int) -> None: ...

class vtkFloatArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkFloatArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkFloatArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> float: ...
    @staticmethod
    def GetDataTypeValueMin() -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, id:int) -> float: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetValueRange(self) -> Tuple[float, float]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextValue(self, f:float) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[float]) -> None: ...
    def InsertValue(self, id:int, f:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFloatArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFloatArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, id:int, value:float) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkFloatingPointExceptions(object):
    @staticmethod
    def Disable() -> None: ...
    @staticmethod
    def Enable() -> None: ...

class vtkGarbageCollector(vtkObject):
    @overload
    @staticmethod
    def Collect() -> None: ...
    @overload
    @staticmethod
    def Collect(root:'vtkObjectBase') -> None: ...
    @staticmethod
    def DeferredCollectionPop() -> None: ...
    @staticmethod
    def DeferredCollectionPush() -> None: ...
    @staticmethod
    def GetGlobalDebugFlag() -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGarbageCollector': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGarbageCollector': ...
    @staticmethod
    def SetGlobalDebugFlag(flag:bool) -> None: ...

class vtkGarbageCollectorManager(object):
    def __init__(self) -> None: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:str) -> None: ...
    def FillValue(self, value:str) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[str], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[str], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[str, str]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[str, str]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[str]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> str: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> str: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[str]) -> None: ...
    def GetValue(self, valueIdx:int) -> str: ...
    @overload
    def GetValueRange(self, range:MutableSequence[str], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[str], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[str, str]: ...
    @overload
    def GetValueRange(self) -> Tuple[str, str]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[str]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[str]) -> int: ...
    def InsertNextValue(self, value:str) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:str) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[str]) -> None: ...
    def InsertValue(self, valueIdx:int, value:str) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:str, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:str) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[str]) -> None: ...
    def SetValue(self, valueIdx:int, value:str) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> str: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIdEdE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:float) -> None: ...
    def FillValue(self, value:float) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[float], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[float], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[float, float]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, valueIdx:int) -> float: ...
    @overload
    def GetValueRange(self, range:MutableSequence[float], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[float], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetValueRange(self) -> Tuple[float, float]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[float]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[float]) -> int: ...
    def InsertNextValue(self, value:float) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:float) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[float]) -> None: ...
    def InsertValue(self, valueIdx:int, value:float) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:float) -> int: ...
    @overload
    def LookupTypedValue(self, value:float, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIdEdE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIdEdE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, valueIdx:int, value:float) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIfEfE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:float) -> None: ...
    def FillValue(self, value:float) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[float], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[float], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[float, float]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, valueIdx:int) -> float: ...
    @overload
    def GetValueRange(self, range:MutableSequence[float], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[float], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[float, float]: ...
    @overload
    def GetValueRange(self) -> Tuple[float, float]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[float]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[float]) -> int: ...
    def InsertNextValue(self, value:float) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:float) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[float]) -> None: ...
    def InsertValue(self, valueIdx:int, value:float) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:float) -> int: ...
    @overload
    def LookupTypedValue(self, value:float, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIfEfE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIfEfE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, valueIdx:int, value:float) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIxExE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIxExE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIxExE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkGenericDataArray_I23vtkSOADataArrayTemplateIyEyE(vtkDataArray):
    VTK_DATA_TYPE:int
    def Allocate(self, size:int, ext:int=1000) -> int: ...
    def Capacity(self) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def FillComponent(self, compIdx:int, value:float) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def FillValue(self, value:int) -> None: ...
    def GetComponent(self, tupleIdx:int, compIdx:int) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetFiniteValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetFiniteValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def GetTuple(self, tupleIdx:int) -> Tuple[float, float]: ...
    @overload
    def GetTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuples(self, tupleIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int, ghosts:Sequence[int], ghostsToSkip:int=0xff) -> None: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int], comp:int) -> None: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self, range:MutableSequence[int]) -> None: ...
    def GetVariantValue(self, valueIdx:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    def HasStandardMemoryLayout(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InsertComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    @overload
    def InsertNextTuple(self, srcTupleIdx:int, source:'vtkAbstractArray') -> int: ...
    @overload
    def InsertNextTuple(self, tuple:Sequence[float]) -> int: ...
    def InsertNextTypedTuple(self, t:Sequence[int]) -> int: ...
    def InsertNextValue(self, value:int) -> int: ...
    @overload
    def InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuple(self, tupleIdx:int, source:Sequence[float]) -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int) -> None: ...
    def InsertTypedTuple(self, tupleIdx:int, t:Sequence[int]) -> None: ...
    def InsertValue(self, valueIdx:int, value:int) -> None: ...
    def InsertVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int, source1:'vtkAbstractArray', srcTupleIdx2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupTypedValue(self, value:int) -> int: ...
    @overload
    def LookupTypedValue(self, value:int, valueIds:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', valueIds:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIyEyE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def RemoveTuple(self, tupleIdx:int) -> None: ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataArray_I23vtkSOADataArrayTemplateIyEyE': ...
    def SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None: ...
    def SetNumberOfComponents(self, num:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    @overload
    def SetTuple(self, dstTupleIdx:int, srcTupleIdx:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def SetTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def SetVariantValue(self, valueIdx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None: ...
    @overload
    def SetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, valueIdx:int, numValues:int) -> Pointer: ...
    def WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer: ...

class vtkIdList(vtkObject):
    def Allocate(self, sz:int, strategy:int=0) -> int: ...
    def DeepCopy(self, ids:'vtkIdList') -> None: ...
    def DeleteId(self, vtkid:int) -> None: ...
    def Fill(self, value:int) -> None: ...
    def FindIdLocation(self, id:int) -> int: ...
    def GetId(self, i:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIds(self) -> int: ...
    def GetPointer(self, i:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    def InsertId(self, i:int, vtkid:int) -> None: ...
    def InsertNextId(self, vtkid:int) -> int: ...
    def InsertUniqueId(self, vtkid:int) -> int: ...
    def IntersectWith(self, otherIds:'vtkIdList') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsId(self, vtkid:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIdList': ...
    def Reset(self) -> None: ...
    def Resize(self, sz:int) -> Pointer: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIdList': ...
    def SetArray(self, array:MutableSequence[int], size:int, save:bool=True) -> None: ...
    def SetId(self, i:int, vtkid:int) -> None: ...
    def SetNumberOfIds(self, number:int) -> None: ...
    def Sort(self) -> None: ...
    def Squeeze(self) -> None: ...
    def WritePointer(self, i:int, number:int) -> Pointer: ...
    def begin(self) -> Pointer: ...
    def end(self) -> Pointer: ...

class vtkIdListCollection(vtkCollection):
    def AddItem(self, ds:'vtkIdList') -> None: ...
    def GetItem(self, i:int) -> 'vtkIdList': ...
    def GetNextItem(self) -> 'vtkIdList': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIdListCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIdListCollection': ...

class vtkIdTypeArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkIdTypeArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkIdTypeArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIdTypeArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIdTypeArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkIndent(object):
    @overload
    def __init__(self, ind:int=0) -> None: ...
    @overload
    def __init__(self, __a:'vtkIndent') -> None: ...
    def GetNextIndent(self) -> 'vtkIndent': ...

class vtkInformation(vtkObject):
    @overload
    def Append(self, from_:'vtkInformation', deep:int=0) -> None: ...
    @overload
    def Append(self, key:'vtkInformationIntegerVectorKey', value:int) -> None: ...
    @overload
    def Append(self, key:'vtkInformationStringVectorKey', value:str) -> None: ...
    @overload
    def Append(self, key:'vtkInformationDoubleVectorKey', value:float) -> None: ...
    @overload
    def Append(self, key:'vtkInformationVariantVectorKey', value:'vtkVariant') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationKey') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationDataObjectKey') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationDoubleKey') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationDoubleVectorKey') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationInformationKey') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationInformationVectorKey') -> None: ...
    @overload
    def Append(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationIntegerKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationDataObjectKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationDoubleKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationDoubleVectorKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationInformationKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationInformationVectorKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationIntegerKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationIntegerVectorKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationStringKey') -> None: ...
    @overload
    def AppendUnique(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationStringVectorKey') -> None: ...
    def Clear(self) -> None: ...
    def Copy(self, from_:'vtkInformation', deep:int=0) -> None: ...
    def CopyEntries(self, from_:'vtkInformation', key:'vtkInformationKeyVectorKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationDataObjectKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationDoubleVectorKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationVariantKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationVariantVectorKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationInformationKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationInformationVectorKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationIntegerKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationIntegerVectorKey', deep:int=0) -> None: ...
    @overload
    def CopyEntry(self, from_:'vtkInformation', key:'vtkInformationObjectBaseVectorKey', deep:int=0) -> None: ...
    @overload
    def Get(self, key:'vtkInformationIntegerKey') -> int: ...
    @overload
    def Get(self, key:'vtkInformationIdTypeKey') -> int: ...
    @overload
    def Get(self, key:'vtkInformationDoubleKey') -> float: ...
    @overload
    def Get(self, key:'vtkInformationVariantKey') -> 'vtkVariant': ...
    @overload
    def Get(self, key:'vtkInformationIntegerVectorKey') -> Tuple[int, int]: ...
    @overload
    def Get(self, key:'vtkInformationIntegerVectorKey', idx:int) -> int: ...
    @overload
    def Get(self, key:'vtkInformationIntegerVectorKey', value:MutableSequence[int]) -> None: ...
    @overload
    def Get(self, key:'vtkInformationStringVectorKey', idx:int=0) -> str: ...
    @overload
    def Get(self, key:'vtkInformationIntegerPointerKey') -> Pointer: ...
    @overload
    def Get(self, key:'vtkInformationIntegerPointerKey', value:MutableSequence[int]) -> None: ...
    @overload
    def Get(self, key:'vtkInformationUnsignedLongKey') -> int: ...
    @overload
    def Get(self, key:'vtkInformationDoubleVectorKey') -> Tuple[float, float]: ...
    @overload
    def Get(self, key:'vtkInformationDoubleVectorKey', idx:int) -> float: ...
    @overload
    def Get(self, key:'vtkInformationDoubleVectorKey', value:MutableSequence[float]) -> None: ...
    @overload
    def Get(self, key:'vtkInformationVariantVectorKey', idx:int) -> 'vtkVariant': ...
    @overload
    def Get(self, key:'vtkInformationKeyVectorKey', idx:int) -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationDataObjectKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationDoubleKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationDoubleVectorKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationInformationKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationInformationVectorKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationIntegerKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationIntegerVectorKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationRequestKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationStringKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationStringVectorKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationUnsignedLongKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationVariantKey') -> 'vtkInformationKey': ...
    @overload
    @staticmethod
    def GetKey(key:'vtkInformationVariantVectorKey') -> 'vtkInformationKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfKeys(self) -> int: ...
    def GetRequest(self) -> 'vtkInformationRequestKey': ...
    @overload
    def Has(self, key:'vtkInformationKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationRequestKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationIntegerKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationIdTypeKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationDoubleKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationVariantKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationIntegerVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationStringVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationIntegerPointerKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationUnsignedLongKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationDoubleVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationVariantVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationKeyVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationStringKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationInformationKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationInformationVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationObjectBaseKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationObjectBaseVectorKey') -> int: ...
    @overload
    def Has(self, key:'vtkInformationDataObjectKey') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def Length(self, key:'vtkInformationIntegerVectorKey') -> int: ...
    @overload
    def Length(self, key:'vtkInformationStringVectorKey') -> int: ...
    @overload
    def Length(self, key:'vtkInformationIntegerPointerKey') -> int: ...
    @overload
    def Length(self, key:'vtkInformationDoubleVectorKey') -> int: ...
    @overload
    def Length(self, key:'vtkInformationVariantVectorKey') -> int: ...
    @overload
    def Length(self, key:'vtkInformationKeyVectorKey') -> int: ...
    @overload
    def Length(self, key:'vtkInformationObjectBaseVectorKey') -> int: ...
    @overload
    def Modified(self) -> None: ...
    @overload
    def Modified(self, key:'vtkInformationKey') -> None: ...
    def NewInstance(self) -> 'vtkInformation': ...
    @overload
    def Remove(self, key:'vtkInformationKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationRequestKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationIntegerKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationIdTypeKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationDoubleKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationVariantKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationIntegerVectorKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationStringVectorKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationIntegerPointerKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationUnsignedLongKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationDoubleVectorKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationVariantVectorKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationKeyVectorKey', value:'vtkInformationKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationKeyVectorKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationStringKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationInformationKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationInformationVectorKey') -> None: ...
    @overload
    def Remove(self, key:'vtkInformationObjectBaseKey') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformation': ...
    @overload
    def Set(self, key:'vtkInformationRequestKey') -> None: ...
    @overload
    def Set(self, key:'vtkInformationIntegerKey', value:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationIdTypeKey', value:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationDoubleKey', value:float) -> None: ...
    @overload
    def Set(self, key:'vtkInformationVariantKey', value:'vtkVariant') -> None: ...
    @overload
    def Set(self, key:'vtkInformationIntegerVectorKey', value:Sequence[int], length:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationIntegerVectorKey', value1:int, value2:int, value3:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationIntegerVectorKey', value1:int, value2:int, value3:int, value4:int, value5:int, value6:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationStringVectorKey', value:str, idx:int=0) -> None: ...
    @overload
    def Set(self, key:'vtkInformationIntegerPointerKey', value:MutableSequence[int], length:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationUnsignedLongKey', value:int) -> None: ...
    @overload
    def Set(self, key:'vtkInformationDoubleVectorKey', value:Sequence[float], length:int) -> None: ...
    def SetRequest(self, request:'vtkInformationRequestKey') -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkInformationKey(vtkObjectBase):
    def CopyDefaultInformation(self, request:'vtkInformation', fromInfo:'vtkInformation', toInfo:'vtkInformation') -> None: ...
    def DeepCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...
    def GetLocation(self) -> str: ...
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Has(self, info:'vtkInformation') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NeedToExecute(self, pipelineInfo:'vtkInformation', dobjInfo:'vtkInformation') -> bool: ...
    def NewInstance(self) -> 'vtkInformationKey': ...
    def Print(self, info:'vtkInformation') -> None: ...
    def Remove(self, info:'vtkInformation') -> None: ...
    def Report(self, info:'vtkInformation', collector:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationKey': ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...
    def StoreMetaData(self, request:'vtkInformation', pipelineInfo:'vtkInformation', dobjInfo:'vtkInformation') -> None: ...

class vtkInformationDataObjectKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationDataObjectKey': ...
    def NewInstance(self) -> 'vtkInformationDataObjectKey': ...
    def Report(self, info:'vtkInformation', collector:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationDataObjectKey': ...
    def Set(self, info:'vtkInformation', __b:'vtkDataObject') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationDoubleKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationDoubleKey': ...
    def NewInstance(self) -> 'vtkInformationDoubleKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationDoubleKey': ...
    def Set(self, info:'vtkInformation', __b:float) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationDoubleVectorKey(vtkInformationKey):
    def Append(self, info:'vtkInformation', value:float) -> None: ...
    @overload
    def Get(self, info:'vtkInformation') -> Pointer: ...
    @overload
    def Get(self, info:'vtkInformation', idx:int) -> float: ...
    @overload
    def Get(self, info:'vtkInformation', value:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str, length:int=-1) -> 'vtkInformationDoubleVectorKey': ...
    def NewInstance(self) -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationDoubleVectorKey': ...
    def Set(self, info:'vtkInformation', value:Sequence[float], length:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationIdTypeKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationIdTypeKey': ...
    def NewInstance(self) -> 'vtkInformationIdTypeKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationIdTypeKey': ...
    def Set(self, info:'vtkInformation', __b:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationInformationKey(vtkInformationKey):
    def DeepCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...
    def Get(self, info:'vtkInformation') -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationInformationKey': ...
    def NewInstance(self) -> 'vtkInformationInformationKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationInformationKey': ...
    def Set(self, info:'vtkInformation', __b:'vtkInformation') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationInformationVectorKey(vtkInformationKey):
    def DeepCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...
    def Get(self, info:'vtkInformation') -> 'vtkInformationVector': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInformationInformationVectorKey': ...
    def Report(self, info:'vtkInformation', collector:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationInformationVectorKey': ...
    def Set(self, info:'vtkInformation', __b:'vtkInformationVector') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationIntegerKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationIntegerKey': ...
    def NewInstance(self) -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationIntegerKey': ...
    def Set(self, info:'vtkInformation', __b:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationIntegerPointerKey(vtkInformationKey):
    @overload
    def Get(self, info:'vtkInformation') -> Pointer: ...
    @overload
    def Get(self, info:'vtkInformation', value:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    def NewInstance(self) -> 'vtkInformationIntegerPointerKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationIntegerPointerKey': ...
    def Set(self, info:'vtkInformation', value:MutableSequence[int], length:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationIntegerVectorKey(vtkInformationKey):
    def Append(self, info:'vtkInformation', value:int) -> None: ...
    @overload
    def Get(self, info:'vtkInformation') -> Pointer: ...
    @overload
    def Get(self, info:'vtkInformation', idx:int) -> int: ...
    @overload
    def Get(self, info:'vtkInformation', value:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str, length:int=-1) -> 'vtkInformationIntegerVectorKey': ...
    def NewInstance(self) -> 'vtkInformationIntegerVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationIntegerVectorKey': ...
    @overload
    def Set(self, info:'vtkInformation', value:Sequence[int], length:int) -> None: ...
    @overload
    def Set(self, info:'vtkInformation') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationInternals(object):
    def __init__(self) -> None: ...

class vtkInformationIterator(vtkObject):
    def GetCurrentKey(self) -> 'vtkInformationKey': ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GoToFirstItem(self) -> None: ...
    def GoToNextItem(self) -> None: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInformationIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationIterator': ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    def SetInformationWeak(self, __a:'vtkInformation') -> None: ...

class vtkInformationKeyLookup(vtkObject):
    @staticmethod
    def Find(name:str, location:str) -> 'vtkInformationKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInformationKeyLookup': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationKeyLookup': ...

class vtkInformationKeyVectorKey(vtkInformationKey):
    def Append(self, info:'vtkInformation', value:'vtkInformationKey') -> None: ...
    def AppendUnique(self, info:'vtkInformation', value:'vtkInformationKey') -> None: ...
    def Get(self, info:'vtkInformation', idx:int) -> 'vtkInformationKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationKeyVectorKey': ...
    def NewInstance(self) -> 'vtkInformationKeyVectorKey': ...
    def RemoveItem(self, info:'vtkInformation', value:'vtkInformationKey') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationKeyVectorKey': ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationObjectBaseKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> 'vtkObjectBase': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str, requiredClass:str=...) -> 'vtkInformationObjectBaseKey': ...
    def NewInstance(self) -> 'vtkInformationObjectBaseKey': ...
    def Report(self, info:'vtkInformation', collector:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationObjectBaseKey': ...
    def Set(self, info:'vtkInformation', __b:'vtkObjectBase') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationObjectBaseVectorKey(vtkInformationKey):
    def Append(self, info:'vtkInformation', value:'vtkObjectBase') -> None: ...
    def Clear(self, info:'vtkInformation') -> None: ...
    def Get(self, info:'vtkInformation', idx:int) -> 'vtkObjectBase': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str, requiredClass:str=...) -> 'vtkInformationObjectBaseVectorKey': ...
    def NewInstance(self) -> 'vtkInformationObjectBaseVectorKey': ...
    @overload
    def Remove(self, info:'vtkInformation', val:'vtkObjectBase') -> None: ...
    @overload
    def Remove(self, info:'vtkInformation', idx:int) -> None: ...
    @overload
    def Remove(self, info:'vtkInformation') -> None: ...
    def Resize(self, info:'vtkInformation', size:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationObjectBaseVectorKey': ...
    def Set(self, info:'vtkInformation', value:'vtkObjectBase', i:int) -> None: ...
    def ShallowCopy(self, source:'vtkInformation', dest:'vtkInformation') -> None: ...
    def Size(self, info:'vtkInformation') -> int: ...

class vtkInformationRequestKey(vtkInformationKey):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Has(self, info:'vtkInformation') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationRequestKey': ...
    def NewInstance(self) -> 'vtkInformationRequestKey': ...
    def Remove(self, info:'vtkInformation') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationRequestKey': ...
    def Set(self, info:'vtkInformation') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationStringKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationStringKey': ...
    def NewInstance(self) -> 'vtkInformationStringKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationStringKey': ...
    def Set(self, info:'vtkInformation', str:str) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationStringVectorKey(vtkInformationKey):
    def Append(self, info:'vtkInformation', value:str) -> None: ...
    def Get(self, info:'vtkInformation', idx:int=0) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str, length:int=-1) -> 'vtkInformationStringVectorKey': ...
    def NewInstance(self) -> 'vtkInformationStringVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationStringVectorKey': ...
    def Set(self, info:'vtkInformation', value:str, idx:int=0) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationUnsignedLongKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationUnsignedLongKey': ...
    def NewInstance(self) -> 'vtkInformationUnsignedLongKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationUnsignedLongKey': ...
    def Set(self, info:'vtkInformation', __b:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationVariantKey(vtkInformationKey):
    def Get(self, info:'vtkInformation') -> 'vtkVariant': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationVariantKey': ...
    def NewInstance(self) -> 'vtkInformationVariantKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationVariantKey': ...
    def Set(self, info:'vtkInformation', __b:'vtkVariant') -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationVariantVectorKey(vtkInformationKey):
    def Append(self, info:'vtkInformation', value:'vtkVariant') -> None: ...
    def Get(self, info:'vtkInformation', idx:int) -> 'vtkVariant': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str, length:int=-1) -> 'vtkInformationVariantVectorKey': ...
    def NewInstance(self) -> 'vtkInformationVariantVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationVariantVectorKey': ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationVector(vtkObject):
    def Append(self, info:'vtkInformation') -> None: ...
    def Copy(self, from_:'vtkInformationVector', deep:int=0) -> None: ...
    def GetInformationObject(self, index:int) -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInformationObjects(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInformationVector': ...
    @overload
    def Remove(self, info:'vtkInformation') -> None: ...
    @overload
    def Remove(self, idx:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationVector': ...
    def SetInformationObject(self, index:int, info:'vtkInformation') -> None: ...
    def SetNumberOfInformationObjects(self, n:int) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkIntArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkIntArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkIntArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIntArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIntArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkLogger(vtkObjectBase):
    class FileMode(int): ...
    class Verbosity(int): ...
    APPEND:'FileMode'
    TRUNCATE:'FileMode'
    VERBOSITY_0:'Verbosity'
    VERBOSITY_1:'Verbosity'
    VERBOSITY_2:'Verbosity'
    VERBOSITY_3:'Verbosity'
    VERBOSITY_4:'Verbosity'
    VERBOSITY_5:'Verbosity'
    VERBOSITY_6:'Verbosity'
    VERBOSITY_7:'Verbosity'
    VERBOSITY_8:'Verbosity'
    VERBOSITY_9:'Verbosity'
    VERBOSITY_ERROR:'Verbosity'
    VERBOSITY_INFO:'Verbosity'
    VERBOSITY_INVALID:'Verbosity'
    VERBOSITY_MAX:'Verbosity'
    VERBOSITY_OFF:'Verbosity'
    VERBOSITY_TRACE:'Verbosity'
    VERBOSITY_WARNING:'Verbosity'
    @overload
    @staticmethod
    def ConvertToVerbosity(value:int) -> 'Verbosity': ...
    @overload
    @staticmethod
    def ConvertToVerbosity(text:str) -> 'Verbosity': ...
    @staticmethod
    def EndLogToFile(path:str) -> None: ...
    @staticmethod
    def EndScope(id:str) -> None: ...
    @staticmethod
    def GetCurrentVerbosityCutoff() -> 'Verbosity': ...
    @staticmethod
    def GetIdentifier(obj:'vtkObjectBase') -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetThreadName() -> str: ...
    @staticmethod
    def Init() -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsEnabled() -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def Log(verbosity:'Verbosity', fname:str, lineno:int, txt:str) -> None: ...
    @staticmethod
    def LogToFile(path:str, filemode:'FileMode', verbosity:'Verbosity') -> None: ...
    def NewInstance(self) -> 'vtkLogger': ...
    @staticmethod
    def RemoveCallback(id:str) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLogger': ...
    @staticmethod
    def SetInternalVerbosityLevel(level:'Verbosity') -> None: ...
    @staticmethod
    def SetStderrVerbosity(level:'Verbosity') -> None: ...
    @staticmethod
    def SetThreadName(name:str) -> None: ...
    @staticmethod
    def StartScope(verbosity:'Verbosity', id:str, fname:str, lineno:int) -> None: ...

class vtkLongArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkLongArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkLongArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLongArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLongArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkLongLongArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkLongLongArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkLongLongArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLongLongArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLongLongArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkScalarsToColors(vtkObject):
    class VectorModes(int): ...
    COMPONENT:'VectorModes'
    MAGNITUDE:'VectorModes'
    RGBCOLORS:'VectorModes'
    def Build(self) -> None: ...
    def DeepCopy(self, o:'vtkScalarsToColors') -> None: ...
    def GetAlpha(self) -> float: ...
    def GetAnnotatedValue(self, idx:int) -> 'vtkVariant': ...
    def GetAnnotatedValueIndex(self, val:'vtkVariant') -> int: ...
    def GetAnnotatedValueIndexInternal(self, val:'vtkVariant') -> int: ...
    def GetAnnotatedValues(self) -> 'vtkAbstractArray': ...
    def GetAnnotation(self, idx:int) -> str: ...
    def GetAnnotationColor(self, val:'vtkVariant', rgba:MutableSequence[float]) -> None: ...
    def GetAnnotations(self) -> 'vtkStringArray': ...
    @overload
    def GetColor(self, v:float, rgb:MutableSequence[float]) -> None: ...
    @overload
    def GetColor(self, v:float) -> Tuple[float, float, float]: ...
    def GetIndexedColor(self, i:int, rgba:MutableSequence[float]) -> None: ...
    def GetIndexedLookup(self) -> int: ...
    def GetLuminance(self, x:float) -> float: ...
    def GetNumberOfAnnotatedValues(self) -> int: ...
    def GetNumberOfAvailableColors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self, v:float) -> float: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetVectorComponent(self) -> int: ...
    def GetVectorMode(self) -> int: ...
    def GetVectorSize(self) -> int: ...
    def IndexedLookupOff(self) -> None: ...
    def IndexedLookupOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsOpaque(self) -> int: ...
    @overload
    def IsOpaque(self, scalars:'vtkAbstractArray', colorMode:int, component:int) -> int: ...
    @overload
    def IsOpaque(self, scalars:'vtkAbstractArray', colorMode:int, component:int, ghosts:'vtkUnsignedCharArray', ghostsToSkip:int=0xff) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def MapScalars(self, scalars:'vtkDataArray', colorMode:int, component:int, outputFormat:int=...) -> 'vtkUnsignedCharArray': ...
    @overload
    def MapScalars(self, scalars:'vtkAbstractArray', colorMode:int, component:int, outputFormat:int=...) -> 'vtkUnsignedCharArray': ...
    @overload
    def MapScalarsThroughTable(self, scalars:'vtkDataArray', output:MutableSequence[int], outputFormat:int) -> None: ...
    @overload
    def MapScalarsThroughTable(self, scalars:'vtkDataArray', output:MutableSequence[int]) -> None: ...
    @overload
    def MapScalarsThroughTable(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def MapValue(self, v:float) -> Pointer: ...
    @overload
    def MapVectorsThroughTable(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int, vectorComponent:int, vectorSize:int) -> None: ...
    @overload
    def MapVectorsThroughTable(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def NewInstance(self) -> 'vtkScalarsToColors': ...
    def RemoveAnnotation(self, value:'vtkVariant') -> bool: ...
    def ResetAnnotations(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScalarsToColors': ...
    def SetAlpha(self, alpha:float) -> None: ...
    @overload
    def SetAnnotation(self, value:'vtkVariant', annotation:str) -> int: ...
    @overload
    def SetAnnotation(self, value:str, annotation:str) -> int: ...
    def SetAnnotations(self, values:'vtkAbstractArray', annotations:'vtkStringArray') -> None: ...
    def SetIndexedLookup(self, _arg:int) -> None: ...
    @overload
    def SetRange(self, min:float, max:float) -> None: ...
    @overload
    def SetRange(self, rng:Sequence[float]) -> None: ...
    def SetVectorComponent(self, _arg:int) -> None: ...
    def SetVectorMode(self, _arg:int) -> None: ...
    def SetVectorModeToComponent(self) -> None: ...
    def SetVectorModeToMagnitude(self) -> None: ...
    def SetVectorModeToRGBColors(self) -> None: ...
    def SetVectorSize(self, _arg:int) -> None: ...
    def UsingLogScale(self) -> int: ...

class vtkLookupTable(vtkScalarsToColors):
    def Allocate(self, sz:int=256, ext:int=256) -> int: ...
    @staticmethod
    def ApplyLogScale(v:float, range:Sequence[float], log_range:Sequence[float]) -> float: ...
    def Build(self) -> None: ...
    def BuildSpecialColors(self) -> None: ...
    def DeepCopy(self, obj:'vtkScalarsToColors') -> None: ...
    def ForceBuild(self) -> None: ...
    def GetAboveRangeColor(self) -> Tuple[float, float, float, float]: ...
    def GetAlphaRange(self) -> Tuple[float, float]: ...
    def GetBelowRangeColor(self) -> Tuple[float, float, float, float]: ...
    def GetColor(self, v:float, rgb:MutableSequence[float]) -> None: ...
    @staticmethod
    def GetColorAsUnsignedChars(colorIn:Sequence[float], colorOut:MutableSequence[int]) -> None: ...
    def GetHueRange(self) -> Tuple[float, float]: ...
    def GetIndex(self, v:float) -> int: ...
    def GetIndexedColor(self, idx:int, rgba:MutableSequence[float]) -> None: ...
    @staticmethod
    def GetLogRange(range:Sequence[float], log_range:MutableSequence[float]) -> None: ...
    def GetNanColor(self) -> Tuple[float, float, float, float]: ...
    def GetNanColorAsUnsignedChars(self) -> Pointer: ...
    def GetNumberOfAvailableColors(self) -> int: ...
    def GetNumberOfColors(self) -> int: ...
    def GetNumberOfColorsMaxValue(self) -> int: ...
    def GetNumberOfColorsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTableValues(self) -> int: ...
    def GetOpacity(self, v:float) -> float: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetRamp(self) -> int: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetSaturationRange(self) -> Tuple[float, float]: ...
    def GetScale(self) -> int: ...
    def GetTable(self) -> 'vtkUnsignedCharArray': ...
    def GetTableRange(self) -> Tuple[float, float]: ...
    @overload
    def GetTableValue(self, indx:int) -> Tuple[float, float, float, float]: ...
    @overload
    def GetTableValue(self, indx:int, rgba:MutableSequence[float]) -> None: ...
    def GetUseAboveRangeColor(self) -> int: ...
    def GetUseBelowRangeColor(self) -> int: ...
    def GetValueRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsOpaque(self) -> int: ...
    @overload
    def IsOpaque(self, scalars:'vtkAbstractArray', colorMode:int, component:int) -> int: ...
    @overload
    def IsOpaque(self, scalars:'vtkAbstractArray', colorMode:int, component:int, ghosts:'vtkUnsignedCharArray', ghostsToSkip:int=0xff) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def MapValue(self, v:float) -> Pointer: ...
    def NewInstance(self) -> 'vtkLookupTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLookupTable': ...
    @overload
    def SetAboveRangeColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetAboveRangeColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAlphaRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetAlphaRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetBelowRangeColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetBelowRangeColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetHueRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetHueRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetNanColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetNanColor(self, _arg:Sequence[float]) -> None: ...
    def SetNumberOfColors(self, _arg:int) -> None: ...
    def SetNumberOfTableValues(self, number:int) -> None: ...
    def SetRamp(self, _arg:int) -> None: ...
    def SetRampToLinear(self) -> None: ...
    def SetRampToSCurve(self) -> None: ...
    def SetRampToSQRT(self) -> None: ...
    @overload
    def SetRange(self, min:float, max:float) -> None: ...
    @overload
    def SetRange(self, rng:Sequence[float]) -> None: ...
    @overload
    def SetSaturationRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetSaturationRange(self, _arg:Sequence[float]) -> None: ...
    def SetScale(self, scale:int) -> None: ...
    def SetScaleToLinear(self) -> None: ...
    def SetScaleToLog10(self) -> None: ...
    def SetTable(self, __a:'vtkUnsignedCharArray') -> None: ...
    @overload
    def SetTableRange(self, r:Sequence[float]) -> None: ...
    @overload
    def SetTableRange(self, min:float, max:float) -> None: ...
    @overload
    def SetTableValue(self, indx:int, rgba:Sequence[float]) -> None: ...
    @overload
    def SetTableValue(self, indx:int, r:float, g:float, b:float, a:float=1.0) -> None: ...
    def SetUseAboveRangeColor(self, _arg:int) -> None: ...
    def SetUseBelowRangeColor(self, _arg:int) -> None: ...
    @overload
    def SetValueRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetValueRange(self, _arg:Sequence[float]) -> None: ...
    def UseAboveRangeColorOff(self) -> None: ...
    def UseAboveRangeColorOn(self) -> None: ...
    def UseBelowRangeColorOff(self) -> None: ...
    def UseBelowRangeColorOn(self) -> None: ...
    def UsingLogScale(self) -> int: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkMath(vtkObject):
    class ConvolutionMode(int):
        FULL:'ConvolutionMode'
        SAME:'ConvolutionMode'
        VALID:'ConvolutionMode'
    @staticmethod
    def Add(a:Sequence[float], b:Sequence[float], c:MutableSequence[float]) -> None: ...
    @staticmethod
    def AngleBetweenVectors(v1:Sequence[float], v2:Sequence[float]) -> float: ...
    @staticmethod
    def AreBoundsInitialized(bounds:Sequence[float]) -> int: ...
    @staticmethod
    def Assign(a:Sequence[float], b:MutableSequence[float]) -> None: ...
    @staticmethod
    def BeginCombination(m:int, n:int) -> Pointer: ...
    @staticmethod
    def Binomial(m:int, n:int) -> int: ...
    @staticmethod
    def BoundsIsWithinOtherBounds(bounds1:Sequence[float], bounds2:Sequence[float], delta:Sequence[float]) -> int: ...
    @staticmethod
    def Ceil(x:float) -> int: ...
    @staticmethod
    def CeilLog2(x:int) -> int: ...
    @staticmethod
    def ClampAndNormalizeValue(value:float, range:Sequence[float]) -> float: ...
    @overload
    @staticmethod
    def ClampValue(value:MutableSequence[float], range:Sequence[float]) -> None: ...
    @overload
    @staticmethod
    def ClampValue(value:float, range:Sequence[float], clamped_value:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ClampValues(values:MutableSequence[float], nb_values:int, range:Sequence[float]) -> None: ...
    @overload
    @staticmethod
    def ClampValues(values:Sequence[float], nb_values:int, range:Sequence[float], clamped_values:MutableSequence[float]) -> None: ...
    @staticmethod
    def Cross(a:Sequence[float], b:Sequence[float], c:MutableSequence[float]) -> None: ...
    @staticmethod
    def DegreesFromRadians(radians:float) -> float: ...
    @overload
    @staticmethod
    def Determinant2x2(a:float, b:float, c:float, d:float) -> float: ...
    @overload
    @staticmethod
    def Determinant2x2(c1:Sequence[float], c2:Sequence[float]) -> float: ...
    @overload
    @staticmethod
    def Determinant3x3(A:Sequence[Sequence[float]]) -> float: ...
    @overload
    @staticmethod
    def Determinant3x3(c1:Sequence[float], c2:Sequence[float], c3:Sequence[float]) -> float: ...
    @overload
    @staticmethod
    def Determinant3x3(a1:float, a2:float, a3:float, b1:float, b2:float, b3:float, c1:float, c2:float, c3:float) -> float: ...
    @staticmethod
    def Diagonalize3x3(A:Sequence[Sequence[float]], w:MutableSequence[float], V:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def Distance2BetweenPoints(p1:Sequence[float], p2:Sequence[float]) -> float: ...
    @staticmethod
    def Dot(a:Sequence[float], b:Sequence[float]) -> float: ...
    @staticmethod
    def Dot2D(x:Sequence[float], y:Sequence[float]) -> float: ...
    @staticmethod
    def ExtentIsWithinOtherExtent(extent1:Sequence[int], extent2:Sequence[int]) -> int: ...
    @staticmethod
    def Factorial(N:int) -> int: ...
    @staticmethod
    def Floor(x:float) -> int: ...
    @staticmethod
    def FreeCombination(combination:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def Gaussian() -> float: ...
    @overload
    @staticmethod
    def Gaussian(mean:float, std:float) -> float: ...
    @overload
    @staticmethod
    def GaussianAmplitude(variance:float, distanceFromMean:float) -> float: ...
    @overload
    @staticmethod
    def GaussianAmplitude(mean:float, variance:float, position:float) -> float: ...
    @overload
    @staticmethod
    def GaussianWeight(variance:float, distanceFromMean:float) -> float: ...
    @overload
    @staticmethod
    def GaussianWeight(mean:float, variance:float, position:float) -> float: ...
    @staticmethod
    def GetAdjustedScalarRange(array:'vtkDataArray', comp:int, range:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetScalarTypeFittingRange(range_min:float, range_max:float, scale:float=1.0, shift:float=0.0) -> int: ...
    @staticmethod
    def GetSeed() -> int: ...
    @overload
    @staticmethod
    def HSVToRGB(hsv:Sequence[float], rgb:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def HSVToRGB(h:float, s:float, v:float, r:MutableSequence[float], g:MutableSequence[float], b:MutableSequence[float]) -> None: ...
    @staticmethod
    def Identity3x3(A:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def Inf() -> float: ...
    @staticmethod
    def Invert3x3(A:Sequence[Sequence[float]], AI:MutableSequence[MutableSequence[float]]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsFinite(x:float) -> bool: ...
    @staticmethod
    def IsInf(x:float) -> int: ...
    @staticmethod
    def IsNan(x:float) -> int: ...
    @staticmethod
    def IsPowerOfTwo(x:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LUFactor3x3(A:MutableSequence[MutableSequence[float]], index:MutableSequence[int]) -> None: ...
    @staticmethod
    def LUSolve3x3(A:Sequence[Sequence[float]], index:Sequence[int], x:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def LabToRGB(lab:Sequence[float], rgb:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def LabToRGB(L:float, a:float, b:float, red:MutableSequence[float], green:MutableSequence[float], blue:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def LabToXYZ(lab:Sequence[float], xyz:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def LabToXYZ(L:float, a:float, b:float, x:MutableSequence[float], y:MutableSequence[float], z:MutableSequence[float]) -> None: ...
    @staticmethod
    def LinearSolve3x3(A:Sequence[Sequence[float]], x:Sequence[float], y:MutableSequence[float]) -> None: ...
    @staticmethod
    def Matrix3x3ToQuaternion(A:Sequence[Sequence[float]], quat:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def Multiply3x3(A:Sequence[Sequence[float]], v:Sequence[float], u:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def Multiply3x3(A:Sequence[Sequence[float]], B:Sequence[Sequence[float]], C:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def MultiplyQuaternion(q1:Sequence[float], q2:Sequence[float], q:MutableSequence[float]) -> None: ...
    @staticmethod
    def MultiplyScalar(a:MutableSequence[float], s:float) -> None: ...
    @staticmethod
    def MultiplyScalar2D(a:MutableSequence[float], s:float) -> None: ...
    @staticmethod
    def Nan() -> float: ...
    @staticmethod
    def NearestPowerOfTwo(x:int) -> int: ...
    @staticmethod
    def NegInf() -> float: ...
    def NewInstance(self) -> 'vtkMath': ...
    @staticmethod
    def NextCombination(m:int, n:int, combination:MutableSequence[int]) -> int: ...
    @overload
    @staticmethod
    def Norm(x:Sequence[float], n:int) -> float: ...
    @overload
    @staticmethod
    def Norm(v:Sequence[float]) -> float: ...
    @staticmethod
    def Norm2D(x:Sequence[float]) -> float: ...
    @staticmethod
    def Normalize(v:MutableSequence[float]) -> float: ...
    @staticmethod
    def Normalize2D(v:MutableSequence[float]) -> float: ...
    @staticmethod
    def Orthogonalize3x3(A:Sequence[Sequence[float]], B:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def Outer(a:Sequence[float], b:Sequence[float], c:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def Outer2D(x:Sequence[float], y:Sequence[float], A:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def Perpendiculars(v1:Sequence[float], v2:MutableSequence[float], v3:MutableSequence[float], theta:float) -> None: ...
    @staticmethod
    def Pi() -> float: ...
    @staticmethod
    def PlaneIntersectsAABB(bounds:Sequence[float], normal:Sequence[float], point:Sequence[float]) -> int: ...
    @staticmethod
    def PointIsWithinBounds(point:Sequence[float], bounds:Sequence[float], delta:Sequence[float]) -> int: ...
    @staticmethod
    def ProjectVector(a:Sequence[float], b:Sequence[float], projection:MutableSequence[float]) -> bool: ...
    @staticmethod
    def ProjectVector2D(a:Sequence[float], b:Sequence[float], projection:MutableSequence[float]) -> bool: ...
    @staticmethod
    def QuadraticRoot(a:float, b:float, c:float, min:float, max:float, u:MutableSequence[float]) -> int: ...
    @staticmethod
    def QuaternionToMatrix3x3(quat:Sequence[float], A:MutableSequence[MutableSequence[float]]) -> None: ...
    @overload
    @staticmethod
    def RGBToHSV(rgb:Sequence[float], hsv:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def RGBToHSV(r:float, g:float, b:float, h:MutableSequence[float], s:MutableSequence[float], v:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def RGBToLab(rgb:Sequence[float], lab:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def RGBToLab(red:float, green:float, blue:float, L:MutableSequence[float], a:MutableSequence[float], b:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def RGBToXYZ(rgb:Sequence[float], xyz:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def RGBToXYZ(r:float, g:float, b:float, x:MutableSequence[float], y:MutableSequence[float], z:MutableSequence[float]) -> None: ...
    @staticmethod
    def RadiansFromDegrees(degrees:float) -> float: ...
    @overload
    @staticmethod
    def Random() -> float: ...
    @overload
    @staticmethod
    def Random(min:float, max:float) -> float: ...
    @staticmethod
    def RandomSeed(s:int) -> None: ...
    @staticmethod
    def RotateVectorByNormalizedQuaternion(v:Sequence[float], q:Sequence[float], r:MutableSequence[float]) -> None: ...
    @staticmethod
    def RotateVectorByWXYZ(v:Sequence[float], q:Sequence[float], r:MutableSequence[float]) -> None: ...
    @staticmethod
    def Round(f:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMath': ...
    @staticmethod
    def SignedAngleBetweenVectors(v1:Sequence[float], v2:Sequence[float], vn:Sequence[float]) -> float: ...
    @staticmethod
    def SingularValueDecomposition3x3(A:Sequence[Sequence[float]], U:MutableSequence[MutableSequence[float]], w:MutableSequence[float], VT:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def Solve3PointCircle(p1:Sequence[float], p2:Sequence[float], p3:Sequence[float], center:MutableSequence[float]) -> float: ...
    @staticmethod
    def SolveLinearSystemGEPP2x2(a00:float, a01:float, a10:float, a11:float, b0:float, b1:float, x0:float, x1:float) -> int: ...
    @staticmethod
    def Subtract(a:Sequence[float], b:Sequence[float], c:MutableSequence[float]) -> None: ...
    @staticmethod
    def Transpose3x3(A:Sequence[Sequence[float]], AT:MutableSequence[MutableSequence[float]]) -> None: ...
    @staticmethod
    def UninitializeBounds(bounds:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def XYZToLab(xyz:Sequence[float], lab:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def XYZToLab(x:float, y:float, z:float, L:MutableSequence[float], a:MutableSequence[float], b:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def XYZToRGB(xyz:Sequence[float], rgb:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def XYZToRGB(x:float, y:float, z:float, r:MutableSequence[float], g:MutableSequence[float], b:MutableSequence[float]) -> None: ...

class vtkMersenneTwister(vtkRandomSequence):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetValue(self, id:int) -> float: ...
    @overload
    def GetValue(self) -> float: ...
    def Initialize(self, seed:int) -> None: ...
    def InitializeNewSequence(self, seed:int, p:int=521) -> int: ...
    def InitializeSequence(self, id:int, seed:int, p:int=521) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMersenneTwister': ...
    @overload
    def Next(self, id:int) -> None: ...
    @overload
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMersenneTwister': ...

class vtkMinimalStandardRandomSequence(vtkRandomSequence):
    def GetNextRangeValue(self, rangeMin:float, rangeMax:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRangeValue(self, rangeMin:float, rangeMax:float) -> float: ...
    def GetSeed(self) -> int: ...
    def GetValue(self) -> float: ...
    def Initialize(self, seed:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMinimalStandardRandomSequence': ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMinimalStandardRandomSequence': ...
    def SetSeed(self, value:int) -> None: ...
    def SetSeedOnly(self, value:int) -> None: ...

class vtkMultiThreader(vtkObject):
    @staticmethod
    def GetGlobalDefaultNumberOfThreads() -> int: ...
    @staticmethod
    def GetGlobalMaximumNumberOfThreads() -> int: ...
    @staticmethod
    def GetGlobalStaticMaximumNumberOfThreads() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetNumberOfThreadsMaxValue(self) -> int: ...
    def GetNumberOfThreadsMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsThreadActive(self, threadId:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MultipleMethodExecute(self) -> None: ...
    def NewInstance(self) -> 'vtkMultiThreader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiThreader': ...
    @staticmethod
    def SetGlobalDefaultNumberOfThreads(val:int) -> None: ...
    @staticmethod
    def SetGlobalMaximumNumberOfThreads(val:int) -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SingleMethodExecute(self) -> None: ...
    def TerminateThread(self, threadId:int) -> None: ...

class vtkMutexLock(vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Lock(self) -> None: ...
    def NewInstance(self) -> 'vtkMutexLock': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMutexLock': ...
    def Unlock(self) -> None: ...

class vtkOStrStreamWrapper(object):
    def __init__(self) -> None: ...
    def str(self) -> str: ...
    @overload
    def freeze(self) -> None: ...
    @overload
    def freeze(self, __a:int) -> None: ...

class vtkObjectFactory(vtkObject):
    @staticmethod
    def CreateAllInstance(vtkclassname:str, retList:'vtkCollection') -> None: ...
    @staticmethod
    def CreateInstance(vtkclassname:str, isAbstract:bool=False) -> 'vtkObject': ...
    def Disable(self, className:str) -> None: ...
    def GetClassOverrideName(self, index:int) -> str: ...
    def GetClassOverrideWithName(self, index:int) -> str: ...
    def GetDescription(self) -> str: ...
    @overload
    def GetEnableFlag(self, index:int) -> int: ...
    @overload
    def GetEnableFlag(self, className:str, subclassName:str) -> int: ...
    def GetLibraryPath(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOverrides(self) -> int: ...
    def GetOverrideDescription(self, index:int) -> str: ...
    @staticmethod
    def GetOverrideInformation(name:str, __b:'vtkOverrideInformationCollection') -> None: ...
    @staticmethod
    def GetRegisteredFactories() -> 'vtkObjectFactoryCollection': ...
    def GetVTKSourceVersion(self) -> str: ...
    @overload
    def HasOverride(self, className:str) -> int: ...
    @overload
    def HasOverride(self, className:str, subclassName:str) -> int: ...
    @staticmethod
    def HasOverrideAny(className:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkObjectFactory': ...
    @staticmethod
    def ReHash() -> None: ...
    @staticmethod
    def RegisterFactory(__a:'vtkObjectFactory') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkObjectFactory': ...
    @overload
    @staticmethod
    def SetAllEnableFlags(flag:int, className:str) -> None: ...
    @overload
    @staticmethod
    def SetAllEnableFlags(flag:int, className:str, subclassName:str) -> None: ...
    def SetEnableFlag(self, flag:int, className:str, subclassName:str) -> None: ...
    @staticmethod
    def UnRegisterAllFactories() -> None: ...
    @staticmethod
    def UnRegisterFactory(__a:'vtkObjectFactory') -> None: ...

class vtkObjectFactoryCollection(vtkCollection):
    def AddItem(self, t:'vtkObjectFactory') -> None: ...
    def GetNextItem(self) -> 'vtkObjectFactory': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkObjectFactoryCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkObjectFactoryCollection': ...

class vtkObjectFactoryRegistryCleanup(object):
    def __init__(self) -> None: ...

class vtkOldStyleCallbackCommand(vtkCommand):
    def Execute(self, invoker:'vtkObject', eid:int, calldata:Pointer) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOldStyleCallbackCommand': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOldStyleCallbackCommand': ...
    def SetClientData(self, cd:Pointer) -> None: ...

class vtkOutputWindowCleanup(object):
    def __init__(self) -> None: ...

class vtkOverrideInformation(vtkObject):
    def GetClassOverrideName(self) -> str: ...
    def GetClassOverrideWithName(self) -> str: ...
    def GetDescription(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObjectFactory(self) -> 'vtkObjectFactory': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOverrideInformation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverrideInformation': ...
    def SetClassOverrideName(self, _arg:str) -> None: ...
    def SetClassOverrideWithName(self, _arg:str) -> None: ...
    def SetDescription(self, _arg:str) -> None: ...

class vtkOverrideInformationCollection(vtkCollection):
    def AddItem(self, __a:'vtkOverrideInformation') -> None: ...
    def GetNextItem(self) -> 'vtkOverrideInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOverrideInformationCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverrideInformationCollection': ...

class vtkPoints(vtkObject):
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def ComputeBounds(self) -> None: ...
    def DeepCopy(self, ad:'vtkPoints') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetData(self) -> 'vtkDataArray': ...
    def GetDataType(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetPoint(self, id:int) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint(self, id:int, x:MutableSequence[float]) -> None: ...
    def GetPoints(self, ptId:'vtkIdList', outPoints:'vtkPoints') -> None: ...
    def GetVoidPointer(self, id:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    @overload
    def InsertNextPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def InsertNextPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def InsertPoint(self, id:int, x:Sequence[float]) -> None: ...
    @overload
    def InsertPoint(self, id:int, x:float, y:float, z:float) -> None: ...
    @overload
    def InsertPoints(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkPoints') -> None: ...
    @overload
    def InsertPoints(self, dstStart:int, n:int, srcStart:int, source:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkPoints': ...
    def Reset(self) -> None: ...
    def Resize(self, numPoints:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPoints': ...
    def SetData(self, __a:'vtkDataArray') -> None: ...
    def SetDataType(self, dataType:int) -> None: ...
    def SetDataTypeToBit(self) -> None: ...
    def SetDataTypeToChar(self) -> None: ...
    def SetDataTypeToDouble(self) -> None: ...
    def SetDataTypeToFloat(self) -> None: ...
    def SetDataTypeToInt(self) -> None: ...
    def SetDataTypeToLong(self) -> None: ...
    def SetDataTypeToShort(self) -> None: ...
    def SetDataTypeToUnsignedChar(self) -> None: ...
    def SetDataTypeToUnsignedInt(self) -> None: ...
    def SetDataTypeToUnsignedLong(self) -> None: ...
    def SetDataTypeToUnsignedShort(self) -> None: ...
    def SetNumberOfPoints(self, numPoints:int) -> None: ...
    @overload
    def SetPoint(self, id:int, x:Sequence[float]) -> None: ...
    @overload
    def SetPoint(self, id:int, x:float, y:float, z:float) -> None: ...
    def ShallowCopy(self, ad:'vtkPoints') -> None: ...
    def Squeeze(self) -> None: ...

class vtkPoints2D(vtkObject):
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def ComputeBounds(self) -> None: ...
    def DeepCopy(self, ad:'vtkPoints2D') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetData(self) -> 'vtkDataArray': ...
    def GetDataType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetPoint(self, id:int) -> Tuple[float, float]: ...
    @overload
    def GetPoint(self, id:int, x:MutableSequence[float]) -> None: ...
    def GetPoints(self, ptId:'vtkIdList', fp:'vtkPoints2D') -> None: ...
    def GetVoidPointer(self, id:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    @overload
    def InsertNextPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def InsertNextPoint(self, x:float, y:float) -> int: ...
    @overload
    def InsertPoint(self, id:int, x:Sequence[float]) -> None: ...
    @overload
    def InsertPoint(self, id:int, x:float, y:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPoints2D': ...
    def RemovePoint(self, id:int) -> None: ...
    def Reset(self) -> None: ...
    def Resize(self, numPoints:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPoints2D': ...
    def SetData(self, __a:'vtkDataArray') -> None: ...
    def SetDataType(self, dataType:int) -> None: ...
    def SetDataTypeToBit(self) -> None: ...
    def SetDataTypeToChar(self) -> None: ...
    def SetDataTypeToDouble(self) -> None: ...
    def SetDataTypeToFloat(self) -> None: ...
    def SetDataTypeToInt(self) -> None: ...
    def SetDataTypeToLong(self) -> None: ...
    def SetDataTypeToShort(self) -> None: ...
    def SetDataTypeToUnsignedChar(self) -> None: ...
    def SetDataTypeToUnsignedInt(self) -> None: ...
    def SetDataTypeToUnsignedLong(self) -> None: ...
    def SetDataTypeToUnsignedShort(self) -> None: ...
    def SetNumberOfPoints(self, numPoints:int) -> None: ...
    @overload
    def SetPoint(self, id:int, x:Sequence[float]) -> None: ...
    @overload
    def SetPoint(self, id:int, x:float, y:float) -> None: ...
    def ShallowCopy(self, ad:'vtkPoints2D') -> None: ...
    def Squeeze(self) -> None: ...

class vtkPriorityQueue(vtkObject):
    def Allocate(self, sz:int, ext:int=1000) -> None: ...
    def DeleteId(self, id:int) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfItems(self) -> int: ...
    def GetPriority(self, id:int) -> float: ...
    def Insert(self, priority:float, id:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPriorityQueue': ...
    @overload
    def Peek(self, location:int, priority:float) -> int: ...
    @overload
    def Peek(self, location:int=0) -> int: ...
    @overload
    def Pop(self, location:int, priority:float) -> int: ...
    @overload
    def Pop(self, location:int=0) -> int: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPriorityQueue': ...

class vtkRandomPool(vtkObject):
    def GeneratePool(self) -> Pointer: ...
    def GetChunkSize(self) -> int: ...
    def GetChunkSizeMaxValue(self) -> int: ...
    def GetChunkSizeMinValue(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfComponentsMaxValue(self) -> int: ...
    def GetNumberOfComponentsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPool(self) -> Pointer: ...
    def GetSequence(self) -> 'vtkRandomSequence': ...
    def GetSize(self) -> int: ...
    def GetSizeMaxValue(self) -> int: ...
    def GetSizeMinValue(self) -> int: ...
    def GetTotalSize(self) -> int: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, compNum:int) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRandomPool': ...
    @overload
    def PopulateDataArray(self, da:'vtkDataArray', minRange:float, maxRange:float) -> None: ...
    @overload
    def PopulateDataArray(self, da:'vtkDataArray', compNumber:int, minRange:float, maxRange:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRandomPool': ...
    def SetChunkSize(self, _arg:int) -> None: ...
    def SetNumberOfComponents(self, _arg:int) -> None: ...
    def SetSequence(self, seq:'vtkRandomSequence') -> None: ...
    def SetSize(self, _arg:int) -> None: ...

class vtkReferenceCount(vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReferenceCount': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReferenceCount': ...

class vtkSMPTools(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkSMPTools') -> None: ...
    @staticmethod
    def GetBackend() -> str: ...
    @staticmethod
    def GetEstimatedNumberOfThreads() -> int: ...
    @staticmethod
    def GetNestedParallelism() -> bool: ...
    @staticmethod
    def Initialize(numThreads:int=0) -> None: ...
    @staticmethod
    def IsParallelScope() -> bool: ...
    @staticmethod
    def SetBackend(backend:str) -> bool: ...
    @staticmethod
    def SetNestedParallelism(isNested:bool) -> None: ...

class vtkSOADataArrayTemplate_IaE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IaE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IaE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IcE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:str) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> str: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[str]) -> None: ...
    def GetValue(self, valueIdx:int) -> str: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IcE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IcE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:str) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[str]) -> None: ...
    def SetValue(self, valueIdx:int, value:str) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IdE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIdEdE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:float) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> float: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, valueIdx:int) -> float: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IdE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IdE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:float) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, valueIdx:int, value:float) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IfE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIfEfE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:float) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> float: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[float]) -> None: ...
    def GetValue(self, valueIdx:int) -> float: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IfE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IfE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:float) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[float]) -> None: ...
    def SetValue(self, valueIdx:int, value:float) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IhE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IhE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IhE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IiE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IiE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IiE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IjE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IjE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IjE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IlE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IlE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IlE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_ImE(vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_ImE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_ImE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IsE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IsE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IsE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_ItE(vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_ItE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_ItE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IxE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIxExE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IxE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IxE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkSOADataArrayTemplate_IyE(vtkGenericDataArray_I23vtkSOADataArrayTemplateIyEyE):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def ExportToVoidPointer(self, ptr:Pointer) -> None: ...
    def FillTypedComponent(self, compIdx:int, value:int) -> None: ...
    def GetArrayType(self) -> int: ...
    def GetComponentArrayPointer(self, comp:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTypedComponent(self, tupleIdx:int, comp:int) -> int: ...
    def GetTypedTuple(self, tupleIdx:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, valueIdx:int) -> int: ...
    def GetVoidPointer(self, valueIdx:int) -> Pointer: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSOADataArrayTemplate_IyE': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSOADataArrayTemplate_IyE': ...
    def SetArray(self, comp:int, array:Buffer, size:int, updateMaxId:bool=False, save:bool=False, deleteMethod:int=...) -> None: ...
    def SetNumberOfComponents(self, numComps:int) -> None: ...
    def SetTypedComponent(self, tupleIdx:int, comp:int, value:int) -> None: ...
    def SetTypedTuple(self, tupleIdx:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, valueIdx:int, value:int) -> None: ...
    def ShallowCopy(self, other:'vtkDataArray') -> None: ...

class vtkShortArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkShortArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkShortArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShortArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShortArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkSignedCharArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkSignedCharArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkSignedCharArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSignedCharArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSignedCharArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkSimpleConditionVariable(object):
    def __init__(self) -> None: ...
    def Broadcast(self) -> None: ...
    def Signal(self) -> None: ...
    def Wait(self, mutex:'vtkSimpleMutexLock') -> int: ...

class vtkSimpleCriticalSection(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, isLocked:int) -> None: ...
    def Init(self) -> None: ...
    def Lock(self) -> None: ...
    def Unlock(self) -> None: ...

class vtkSimpleMutexLock(object):
    def __init__(self) -> None: ...
    def Lock(self) -> None: ...
    def Unlock(self) -> None: ...

class vtkSmartPointerBase(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, r:'vtkObjectBase') -> None: ...
    @overload
    def __init__(self, r:'vtkSmartPointerBase') -> None: ...
    def GetPointer(self) -> 'vtkObjectBase': ...
    def Report(self, collector:'vtkGarbageCollector', desc:str) -> None: ...

class vtkSortDataArray(vtkObject):
    @staticmethod
    def GenerateSortIndices(dataType:int, dataIn:Pointer, numKeys:int, numComp:int, k:int, idx:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def InitializeSortIndices(numKeys:int) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSortDataArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSortDataArray': ...
    @staticmethod
    def ShuffleArray(idx:MutableSequence[int], dataType:int, numKeys:int, numComp:int, arr:'vtkAbstractArray', dataIn:Pointer, dir:int) -> None: ...
    @staticmethod
    def ShuffleIdList(idx:MutableSequence[int], sze:int, arrayIn:'vtkIdList', dataIn:MutableSequence[int], dir:int) -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkIdList') -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkAbstractArray') -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkIdList', dir:int) -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkAbstractArray', dir:int) -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkAbstractArray', values:'vtkAbstractArray') -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkAbstractArray', values:'vtkIdList') -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkAbstractArray', values:'vtkAbstractArray', dir:int) -> None: ...
    @overload
    @staticmethod
    def Sort(keys:'vtkAbstractArray', values:'vtkIdList', dir:int) -> None: ...
    @overload
    @staticmethod
    def SortArrayByComponent(arr:'vtkAbstractArray', k:int) -> None: ...
    @overload
    @staticmethod
    def SortArrayByComponent(arr:'vtkAbstractArray', k:int, dir:int) -> None: ...

class vtkSparseArray_I10vtkVariantE(vtkTypedArray_I10vtkVariantE):
    @overload
    def AddValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> 'vtkVariant': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, i:int, j:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> 'vtkVariant': ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> 'vtkVariant': ...
    def GetValueN(self, n:int) -> 'vtkVariant': ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_I10vtkVariantE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_I10vtkVariantE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:'vtkVariant') -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:'vtkVariant') -> None: ...
    def SetValueN(self, n:int, value:'vtkVariant') -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_I12vtkStdStringE(vtkTypedArray_I12vtkStdStringE):
    @overload
    def AddValue(self, i:int, value:str) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> str: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> str: ...
    def GetValueN(self, n:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_I12vtkStdStringE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_I12vtkStdStringE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def SetValueN(self, n:int, value:str) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IaE(vtkTypedArray_IaE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IaE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IaE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IcE(vtkTypedArray_IcE):
    @overload
    def AddValue(self, i:int, value:str) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int) -> str: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> str: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> str: ...
    def GetValueN(self, n:int) -> str: ...
    def GetValueStorage(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IcE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IcE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:str) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:str) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:str) -> None: ...
    def SetValueN(self, n:int, value:str) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IdE(vtkTypedArray_IdE):
    @overload
    def AddValue(self, i:int, value:float) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> float: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> float: ...
    def GetValueN(self, n:int) -> float: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IdE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IdE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def SetValueN(self, n:int, value:float) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IfE(vtkTypedArray_IfE):
    @overload
    def AddValue(self, i:int, value:float) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int) -> float: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> float: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> float: ...
    def GetValueN(self, n:int) -> float: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IfE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IfE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:float) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:float) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:float) -> None: ...
    def SetValueN(self, n:int, value:float) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IhE(vtkTypedArray_IhE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IhE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IhE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IiE(vtkTypedArray_IiE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IiE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IiE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IjE(vtkTypedArray_IjE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IjE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IjE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IlE(vtkTypedArray_IlE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IlE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IlE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_ImE(vtkTypedArray_ImE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_ImE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_ImE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IsE(vtkTypedArray_IsE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IsE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IsE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_ItE(vtkTypedArray_ItE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_ItE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_ItE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IxE(vtkTypedArray_IxE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IxE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IxE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkSparseArray_IyE(vtkTypedArray_IyE):
    @overload
    def AddValue(self, i:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def AddValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def AddValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def Clear(self) -> None: ...
    def DeepCopy(self) -> 'vtkArray': ...
    def GetCoordinateStorage(self, dimension:int) -> Pointer: ...
    def GetCoordinatesN(self, n:int, coordinates:'vtkArrayCoordinates') -> None: ...
    def GetExtents(self) -> 'vtkArrayExtents': ...
    def GetNonNullSize(self) -> int: ...
    def GetNullValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUniqueCoordinates(self, dimension:int) -> Tuple[int, int]: ...
    @overload
    def GetValue(self, i:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int) -> int: ...
    @overload
    def GetValue(self, i:int, j:int, k:int) -> int: ...
    @overload
    def GetValue(self, coordinates:'vtkArrayCoordinates') -> int: ...
    def GetValueN(self, n:int) -> int: ...
    def GetValueStorage(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsDense(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArray_IyE': ...
    def ReserveStorage(self, value_count:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArray_IyE': ...
    def SetExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetExtentsFromContents(self) -> None: ...
    def SetNullValue(self, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, value:int) -> None: ...
    @overload
    def SetValue(self, i:int, j:int, k:int, value:int) -> None: ...
    @overload
    def SetValue(self, coordinates:'vtkArrayCoordinates', value:int) -> None: ...
    def SetValueN(self, n:int, value:int) -> None: ...
    def Sort(self, sort:'vtkArraySort') -> None: ...
    def Validate(self) -> bool: ...

class vtkStdString(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, s:str) -> None: ...
    @overload
    def __init__(self, __a:'vtkStdString') -> None: ...

class vtkStringArray(vtkAbstractArray):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def DataElementChanged(self, id:int) -> None: ...
    def DeepCopy(self, aa:'vtkAbstractArray') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkStringArray': ...
    def GetActualMemorySize(self) -> int: ...
    def GetDataSize(self) -> int: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetElementComponentSize(self) -> int: ...
    def GetNumberOfElementComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    @overload
    def GetTuples(self, ptIds:'vtkIdList', output:'vtkAbstractArray') -> None: ...
    @overload
    def GetTuples(self, p1:int, p2:int, output:'vtkAbstractArray') -> None: ...
    def GetValue(self, id:int) -> str: ...
    def GetVoidPointer(self, id:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    def InsertNextTuple(self, j:int, source:'vtkAbstractArray') -> int: ...
    def InsertNextValue(self, f:str) -> int: ...
    def InsertTuple(self, i:int, j:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertValue(self, id:int, f:str) -> None: ...
    def InsertVariantValue(self, idx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, i:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, i:int, id1:int, source1:'vtkAbstractArray', id2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsNumeric(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', ids:'vtkIdList') -> None: ...
    @overload
    def LookupValue(self, value:str) -> int: ...
    @overload
    def LookupValue(self, value:str, ids:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkStringArray': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStringArray': ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    def SetTuple(self, i:int, j:int, source:'vtkAbstractArray') -> None: ...
    def SetValue(self, id:int, value:str) -> None: ...
    def SetVariantValue(self, idx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, array:Pointer, size:int, save:int) -> None: ...
    @overload
    def SetVoidArray(self, array:Pointer, size:int, save:int, deleteMethod:int) -> None: ...
    def Squeeze(self) -> None: ...

class vtkStringOutputWindow(vtkOutputWindow):
    def DisplayText(self, __a:str) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStringOutputWindow': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStringOutputWindow': ...

class vtkTimePointUtility(vtkObject):
    ISO8601_DATE:int
    ISO8601_DATETIME:int
    ISO8601_DATETIME_MILLIS:int
    ISO8601_TIME:int
    ISO8601_TIME_MILLIS:int
    @staticmethod
    def DateTimeToTimePoint(year:int, month:int, day:int, hour:int, minute:int, sec:int, millis:int=0) -> int: ...
    @staticmethod
    def DateToTimePoint(year:int, month:int, day:int) -> int: ...
    @staticmethod
    def GetDate(time:int, year:int, month:int, day:int) -> None: ...
    @staticmethod
    def GetDateTime(time:int, year:int, month:int, day:int, hour:int, minute:int, second:int, millis:int) -> None: ...
    @staticmethod
    def GetDay(time:int) -> int: ...
    @staticmethod
    def GetHour(time:int) -> int: ...
    @staticmethod
    def GetMillisecond(time:int) -> int: ...
    @staticmethod
    def GetMinute(time:int) -> int: ...
    @staticmethod
    def GetMonth(time:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetSecond(time:int) -> int: ...
    @staticmethod
    def GetTime(time:int, hour:int, minute:int, second:int, millis:int) -> None: ...
    @staticmethod
    def GetYear(time:int) -> int: ...
    @staticmethod
    def ISO8601ToTimePoint(str:str, ok:MutableSequence[bool]=...) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTimePointUtility': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTimePointUtility': ...
    @staticmethod
    def TimePointToISO8601(__a:int, format:int=...) -> str: ...
    @staticmethod
    def TimeToTimePoint(hour:int, minute:int, second:int, millis:int=0) -> int: ...

class vtkTimeStamp(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkTimeStamp') -> None: ...
    def GetMTime(self) -> int: ...
    def Modified(self) -> None: ...

class vtkTypeFloat32Array(vtkFloatArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeFloat32Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeFloat32Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeFloat32Array': ...

class vtkTypeFloat64Array(vtkDoubleArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeFloat64Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeFloat64Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeFloat64Array': ...

class vtkTypeInt16Array(vtkShortArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeInt16Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeInt16Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeInt16Array': ...

class vtkTypeInt32Array(vtkIntArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeInt32Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeInt32Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeInt32Array': ...

class vtkTypeInt64Array(vtkLongLongArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeInt64Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeInt64Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeInt64Array': ...

class vtkTypeInt8Array(vtkSignedCharArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeInt8Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeInt8Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeInt8Array': ...

class vtkUnsignedShortArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkUnsignedShortArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkUnsignedShortArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnsignedShortArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnsignedShortArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkTypeUInt16Array(vtkUnsignedShortArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeUInt16Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeUInt16Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeUInt16Array': ...

class vtkUnsignedIntArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkUnsignedIntArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkUnsignedIntArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnsignedIntArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnsignedIntArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkTypeUInt32Array(vtkUnsignedIntArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeUInt32Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeUInt32Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeUInt32Array': ...

class vtkUnsignedLongLongArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkUnsignedLongLongArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkUnsignedLongLongArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnsignedLongLongArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnsignedLongLongArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkTypeUInt64Array(vtkUnsignedLongLongArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeUInt64Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeUInt64Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeUInt64Array': ...

class vtkUnsignedCharArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkUnsignedCharArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkUnsignedCharArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnsignedCharArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnsignedCharArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkTypeUInt8Array(vtkUnsignedCharArray):
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkTypeUInt8Array': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTypeUInt8Array': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTypeUInt8Array': ...

class vtkUnsignedLongArray(vtkDataArray):
    @staticmethod
    def ExtendedNew() -> 'vtkUnsignedLongArray': ...
    @staticmethod
    def FastDownCast(source:'vtkAbstractArray') -> 'vtkUnsignedLongArray': ...
    def GetDataType(self) -> int: ...
    @staticmethod
    def GetDataTypeValueMax() -> int: ...
    @staticmethod
    def GetDataTypeValueMin() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointer(self, id:int) -> Pointer: ...
    def GetTypedTuple(self, i:int, tuple:MutableSequence[int]) -> None: ...
    def GetValue(self, id:int) -> int: ...
    @overload
    def GetValueRange(self, comp:int) -> Tuple[int, int]: ...
    @overload
    def GetValueRange(self) -> Tuple[int, int]: ...
    def InsertNextTypedTuple(self, tuple:Sequence[int]) -> int: ...
    def InsertNextValue(self, f:int) -> int: ...
    def InsertTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def InsertValue(self, id:int, f:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnsignedLongArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnsignedLongArray': ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int) -> None: ...
    @overload
    def SetArray(self, array:Buffer, size:int, save:int, deleteMethod:int) -> None: ...
    def SetNumberOfValues(self, number:int) -> bool: ...
    def SetTypedTuple(self, i:int, tuple:Sequence[int]) -> None: ...
    def SetValue(self, id:int, value:int) -> None: ...
    def WritePointer(self, id:int, number:int) -> Pointer: ...

class vtkVariant(object):
    class StringFormatting(int): ...
    DEFAULT_FORMATTING:'StringFormatting'
    FIXED_FORMATTING:'StringFormatting'
    SCIENTIFIC_FORMATTING:'StringFormatting'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other:'vtkVariant') -> None: ...
    @overload
    def __init__(self, value:bool) -> None: ...
    @overload
    def __init__(self, value:str) -> None: ...
    @overload
    def __init__(self, value:int) -> None: ...
    @overload
    def __init__(self, value:float) -> None: ...
    @overload
    def __init__(self, value:'vtkObjectBase') -> None: ...
    @overload
    def __init__(self, other:'vtkVariant', type:int) -> None: ...
    def GetType(self) -> int: ...
    def GetTypeAsString(self) -> str: ...
    def IsArray(self) -> bool: ...
    def IsChar(self) -> bool: ...
    def IsDouble(self) -> bool: ...
    def IsEqual(self, other:'vtkVariant') -> bool: ...
    def IsFloat(self) -> bool: ...
    def IsInt(self) -> bool: ...
    def IsLong(self) -> bool: ...
    def IsLongLong(self) -> bool: ...
    def IsNumeric(self) -> bool: ...
    def IsShort(self) -> bool: ...
    def IsSignedChar(self) -> bool: ...
    def IsString(self) -> bool: ...
    def IsUnsignedChar(self) -> bool: ...
    def IsUnsignedInt(self) -> bool: ...
    def IsUnsignedLong(self) -> bool: ...
    def IsUnsignedLongLong(self) -> bool: ...
    def IsUnsignedShort(self) -> bool: ...
    def IsVTKObject(self) -> bool: ...
    def IsValid(self) -> bool: ...
    def ToArray(self) -> 'vtkAbstractArray': ...
    @overload
    def ToChar(self, valid:MutableSequence[bool]) -> str: ...
    @overload
    def ToChar(self) -> str: ...
    @overload
    def ToDouble(self, valid:MutableSequence[bool]) -> float: ...
    @overload
    def ToDouble(self) -> float: ...
    @overload
    def ToFloat(self, valid:MutableSequence[bool]) -> float: ...
    @overload
    def ToFloat(self) -> float: ...
    @overload
    def ToInt(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToInt(self) -> int: ...
    @overload
    def ToLong(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToLong(self) -> int: ...
    @overload
    def ToLongLong(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToLongLong(self) -> int: ...
    @overload
    def ToShort(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToShort(self) -> int: ...
    @overload
    def ToSignedChar(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToSignedChar(self) -> int: ...
    def ToString(self, formatting:int=..., precision:int=6) -> str: ...
    @overload
    def ToTypeInt64(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToTypeInt64(self) -> int: ...
    @overload
    def ToTypeUInt64(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToTypeUInt64(self) -> int: ...
    @overload
    def ToUnsignedChar(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToUnsignedChar(self) -> int: ...
    @overload
    def ToUnsignedInt(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToUnsignedInt(self) -> int: ...
    @overload
    def ToUnsignedLong(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToUnsignedLong(self) -> int: ...
    @overload
    def ToUnsignedLongLong(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToUnsignedLongLong(self) -> int: ...
    @overload
    def ToUnsignedShort(self, valid:MutableSequence[bool]) -> int: ...
    @overload
    def ToUnsignedShort(self) -> int: ...
    def ToVTKObject(self) -> 'vtkObjectBase': ...

class vtkVariantArray(vtkAbstractArray):
    class DeleteMethod(int): ...
    VTK_DATA_ARRAY_ALIGNED_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_DELETE:'DeleteMethod'
    VTK_DATA_ARRAY_FREE:'DeleteMethod'
    VTK_DATA_ARRAY_USER_DEFINED:'DeleteMethod'
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def ClearLookup(self) -> None: ...
    def DataChanged(self) -> None: ...
    def DataElementChanged(self, id:int) -> None: ...
    def DeepCopy(self, da:'vtkAbstractArray') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkVariantArray': ...
    def GetActualMemorySize(self) -> int: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetElementComponentSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetValue(self, id:int) -> 'vtkVariant': ...
    def GetVoidPointer(self, id:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    def InsertNextTuple(self, j:int, source:'vtkAbstractArray') -> int: ...
    def InsertNextValue(self, value:'vtkVariant') -> int: ...
    def InsertTuple(self, i:int, j:int, source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstIds:'vtkIdList', srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    @overload
    def InsertTuples(self, dstStart:int, n:int, srcStart:int, source:'vtkAbstractArray') -> None: ...
    def InsertTuplesStartingAt(self, dstStart:int, srcIds:'vtkIdList', source:'vtkAbstractArray') -> None: ...
    def InsertValue(self, id:int, value:'vtkVariant') -> None: ...
    def InsertVariantValue(self, idx:int, value:'vtkVariant') -> None: ...
    @overload
    def InterpolateTuple(self, i:int, ptIndices:'vtkIdList', source:'vtkAbstractArray', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, i:int, id1:int, source1:'vtkAbstractArray', id2:int, source2:'vtkAbstractArray', t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsNumeric(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant') -> int: ...
    @overload
    def LookupValue(self, value:'vtkVariant', ids:'vtkIdList') -> None: ...
    def NewInstance(self) -> 'vtkVariantArray': ...
    def NewIterator(self) -> 'vtkArrayIterator': ...
    def Resize(self, numTuples:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVariantArray': ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    def SetTuple(self, i:int, j:int, source:'vtkAbstractArray') -> None: ...
    def SetValue(self, id:int, value:'vtkVariant') -> None: ...
    def SetVariantValue(self, idx:int, value:'vtkVariant') -> None: ...
    @overload
    def SetVoidArray(self, arr:Pointer, size:int, save:int) -> None: ...
    @overload
    def SetVoidArray(self, arr:Pointer, size:int, save:int, deleteM:int) -> None: ...
    def Squeeze(self) -> None: ...

class vtkVariantEqual(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkVariantEqual') -> None: ...

class vtkVariantLessThan(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkVariantLessThan') -> None: ...

class vtkVariantStrictEquality(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkVariantStrictEquality') -> None: ...

class vtkVariantStrictWeakOrder(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkVariantStrictWeakOrder') -> None: ...

class vtkVersion(vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetVTKBuildVersion() -> int: ...
    @staticmethod
    def GetVTKMajorVersion() -> int: ...
    @staticmethod
    def GetVTKMinorVersion() -> int: ...
    @staticmethod
    def GetVTKSourceVersion() -> str: ...
    @staticmethod
    def GetVTKVersion() -> str: ...
    @staticmethod
    def GetVTKVersionFull() -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVersion': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVersion': ...

class vtkVoidArray(vtkObject):
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def DeepCopy(self, va:'vtkVoidArray') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkVoidArray': ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointers(self) -> int: ...
    def GetVoidPointer(self, id:int) -> Pointer: ...
    def Initialize(self) -> None: ...
    def InsertNextVoidPointer(self, tuple:Pointer) -> int: ...
    def InsertVoidPointer(self, i:int, ptr:Pointer) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoidArray': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoidArray': ...
    def SetNumberOfPointers(self, number:int) -> None: ...
    def SetVoidPointer(self, id:int, ptr:Pointer) -> None: ...
    def Squeeze(self) -> None: ...

class vtkWeakPointerBase(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, r:'vtkObjectBase') -> None: ...
    @overload
    def __init__(self, r:'vtkWeakPointerBase') -> None: ...
    def GetPointer(self) -> 'vtkObjectBase': ...

class vtkWeakReference(vtkObject):
    def Get(self) -> 'vtkObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWeakReference': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWeakReference': ...
    def Set(self, object:'vtkObject') -> None: ...

class vtkWindow(vtkObject):
    def DetectDPI(self) -> bool: ...
    def DoubleBufferOff(self) -> None: ...
    def DoubleBufferOn(self) -> None: ...
    def EraseOff(self) -> None: ...
    def EraseOn(self) -> None: ...
    def GetActualSize(self) -> Tuple[int, int]: ...
    def GetDPI(self) -> int: ...
    def GetDPIMaxValue(self) -> int: ...
    def GetDPIMinValue(self) -> int: ...
    def GetDoubleBuffer(self) -> int: ...
    def GetErase(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetMapped(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffScreenRendering(self) -> int: ...
    @overload
    def GetPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:int) -> Pointer: ...
    @overload
    def GetPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:'vtkUnsignedCharArray', __g:int) -> int: ...
    def GetPosition(self) -> Tuple[int, int]: ...
    def GetScreenSize(self) -> Tuple[int, int]: ...
    def GetShowWindow(self) -> bool: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetTileScale(self) -> Tuple[int, int]: ...
    def GetTileViewport(self) -> Tuple[float, float, float, float]: ...
    def GetUseOffScreenBuffers(self) -> bool: ...
    def GetWindowName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkWindow': ...
    def OffScreenRenderingOff(self) -> None: ...
    def OffScreenRenderingOn(self) -> None: ...
    def ReleaseCurrent(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWindow': ...
    def SetDPI(self, _arg:int) -> None: ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetDoubleBuffer(self, _arg:int) -> None: ...
    def SetErase(self, _arg:int) -> None: ...
    def SetIcon(self, __a:'vtkImageData') -> None: ...
    def SetOffScreenRendering(self, val:int) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, __a:str) -> None: ...
    @overload
    def SetPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    def SetShowWindow(self, _arg:bool) -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    @overload
    def SetTileScale(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetTileScale(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetTileScale(self, s:int) -> None: ...
    @overload
    def SetTileViewport(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetTileViewport(self, _arg:Sequence[float]) -> None: ...
    def SetUseOffScreenBuffers(self, _arg:bool) -> None: ...
    def SetWindowId(self, __a:Pointer) -> None: ...
    def SetWindowInfo(self, __a:str) -> None: ...
    def SetWindowName(self, _arg:str) -> None: ...
    def ShowWindowOff(self) -> None: ...
    def ShowWindowOn(self) -> None: ...
    def UseOffScreenBuffersOff(self) -> None: ...
    def UseOffScreenBuffersOn(self) -> None: ...

class vtkXMLFileOutputWindow(vtkFileOutputWindow):
    def DisplayDebugText(self, __a:str) -> None: ...
    def DisplayErrorText(self, __a:str) -> None: ...
    def DisplayGenericWarningText(self, __a:str) -> None: ...
    def DisplayTag(self, __a:str) -> None: ...
    def DisplayText(self, __a:str) -> None: ...
    def DisplayWarningText(self, __a:str) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkXMLFileOutputWindow': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXMLFileOutputWindow': ...

mutable = reference
