from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOXMLParser

VTK_LSDYNA_BADFILE:int

class vtkLSDynaReader(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def CanReadFile(self, fname:str) -> int: ...
    def DebugDump(self) -> None: ...
    def DeformedMeshOff(self) -> None: ...
    def DeformedMeshOn(self) -> None: ...
    def DeletedCellsAsGhostArrayOff(self) -> None: ...
    def DeletedCellsAsGhostArrayOn(self) -> None: ...
    def GetBeamArrayName(self, __a:int) -> str: ...
    @overload
    def GetBeamArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetBeamArrayStatus(self, arrName:str) -> int: ...
    def GetCellArrayName(self, cellType:int, arr:int) -> str: ...
    @overload
    def GetCellArrayStatus(self, cellType:int, arr:int) -> int: ...
    @overload
    def GetCellArrayStatus(self, cellType:int, arrName:str) -> int: ...
    def GetDatabaseDirectory(self) -> str: ...
    def GetDeformedMesh(self) -> int: ...
    def GetDeletedCellsAsGhostArray(self) -> int: ...
    def GetDimensionality(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetInputDeck(self) -> str: ...
    def GetNumberOfBeamArrays(self) -> int: ...
    def GetNumberOfBeamCells(self) -> int: ...
    def GetNumberOfCellArrays(self, cellType:int) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    @overload
    def GetNumberOfComponentsInBeamArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInBeamArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInCellArray(self, cellType:int, arr:int) -> int: ...
    @overload
    def GetNumberOfComponentsInCellArray(self, cellType:int, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInParticleArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInParticleArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInPointArray(self, arr:int) -> int: ...
    @overload
    def GetNumberOfComponentsInPointArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInRigidBodyArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInRigidBodyArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInRoadSurfaceArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInRoadSurfaceArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInShellArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInShellArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInSolidArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInSolidArray(self, arrName:str) -> int: ...
    @overload
    def GetNumberOfComponentsInThickShellArray(self, a:int) -> int: ...
    @overload
    def GetNumberOfComponentsInThickShellArray(self, arrName:str) -> int: ...
    def GetNumberOfContinuumCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def GetNumberOfPartArrays(self) -> int: ...
    def GetNumberOfParticleArrays(self) -> int: ...
    def GetNumberOfParticleCells(self) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetNumberOfRigidBodyArrays(self) -> int: ...
    def GetNumberOfRigidBodyCells(self) -> int: ...
    def GetNumberOfRoadSurfaceArrays(self) -> int: ...
    def GetNumberOfRoadSurfaceCells(self) -> int: ...
    def GetNumberOfShellArrays(self) -> int: ...
    def GetNumberOfShellCells(self) -> int: ...
    def GetNumberOfSolidArrays(self) -> int: ...
    def GetNumberOfSolidCells(self) -> int: ...
    def GetNumberOfThickShellArrays(self) -> int: ...
    def GetNumberOfThickShellCells(self) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetPartArrayName(self, __a:int) -> str: ...
    @overload
    def GetPartArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetPartArrayStatus(self, partName:str) -> int: ...
    def GetParticleArrayName(self, __a:int) -> str: ...
    @overload
    def GetParticleArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetParticleArrayStatus(self, arrName:str) -> int: ...
    def GetPointArrayName(self, __a:int) -> str: ...
    @overload
    def GetPointArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetPointArrayStatus(self, arrName:str) -> int: ...
    def GetRemoveDeletedCells(self) -> int: ...
    def GetRigidBodyArrayName(self, __a:int) -> str: ...
    @overload
    def GetRigidBodyArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetRigidBodyArrayStatus(self, arrName:str) -> int: ...
    def GetRoadSurfaceArrayName(self, __a:int) -> str: ...
    @overload
    def GetRoadSurfaceArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetRoadSurfaceArrayStatus(self, arrName:str) -> int: ...
    def GetShellArrayName(self, __a:int) -> str: ...
    @overload
    def GetShellArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetShellArrayStatus(self, arrName:str) -> int: ...
    def GetSolidArrayName(self, __a:int) -> str: ...
    @overload
    def GetSolidArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetSolidArrayStatus(self, arrName:str) -> int: ...
    def GetThickShellArrayName(self, __a:int) -> str: ...
    @overload
    def GetThickShellArrayStatus(self, arr:int) -> int: ...
    @overload
    def GetThickShellArrayStatus(self, arrName:str) -> int: ...
    def GetTimeStep(self) -> int: ...
    def GetTimeStepRange(self) -> Tuple[int, int]: ...
    def GetTimeValue(self, __a:int) -> float: ...
    def GetTitle(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsDatabaseValid(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLSDynaReader': ...
    def RemoveDeletedCellsOff(self) -> None: ...
    def RemoveDeletedCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLSDynaReader': ...
    @overload
    def SetBeamArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetBeamArrayStatus(self, arrName:str, status:int) -> None: ...
    @overload
    def SetCellArrayStatus(self, cellType:int, arr:int, status:int) -> None: ...
    @overload
    def SetCellArrayStatus(self, cellType:int, arrName:str, status:int) -> None: ...
    def SetDatabaseDirectory(self, __a:str) -> None: ...
    def SetDeformedMesh(self, __a:int) -> None: ...
    def SetDeletedCellsAsGhostArray(self, _arg:int) -> None: ...
    def SetFileName(self, __a:str) -> None: ...
    def SetInputDeck(self, _arg:str) -> None: ...
    @overload
    def SetPartArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetPartArrayStatus(self, partName:str, status:int) -> None: ...
    @overload
    def SetParticleArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetParticleArrayStatus(self, arrName:str, status:int) -> None: ...
    @overload
    def SetPointArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetPointArrayStatus(self, arrName:str, status:int) -> None: ...
    def SetRemoveDeletedCells(self, _arg:int) -> None: ...
    @overload
    def SetRigidBodyArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetRigidBodyArrayStatus(self, arrName:str, status:int) -> None: ...
    @overload
    def SetRoadSurfaceArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetRoadSurfaceArrayStatus(self, arrName:str, status:int) -> None: ...
    @overload
    def SetShellArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetShellArrayStatus(self, arrName:str, status:int) -> None: ...
    @overload
    def SetSolidArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetSolidArrayStatus(self, arrName:str, status:int) -> None: ...
    @overload
    def SetThickShellArrayStatus(self, arr:int, status:int) -> None: ...
    @overload
    def SetThickShellArrayStatus(self, arrName:str, status:int) -> None: ...
    def SetTimeStep(self, __a:int) -> None: ...
    @overload
    def SetTimeStepRange(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetTimeStepRange(self, _arg:Sequence[int]) -> None: ...

class vtkLSDynaSummaryParser(vtkmodules.vtkIOXMLParser.vtkXMLParser):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLSDynaSummaryParser': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLSDynaSummaryParser': ...

