"""
    FactSet ESG API

    FactSet ESG (powered by FactSet Truvalue Labs) applies machine learning to uncover risks and opportunities from companies' Environmental, Social and Governance (ESG) behavior, which are aggregated and categorized into continuously updated, material ESG scores. The service focuses on company ESG behavior from external sources and includes both positive and negative events that go beyond traditional sources of ESG risk data.<p> FactSet ESG extracts, analyzes, and generates scores from millions of documents each month collected from more than 100,000 data sources in over 30 languages. Sources include news, trade journals, NGOs, watchdog groups, trade blogs, industry reports and social media. Products deliver investable insights by revealing value and risk factors from unstructured data at the speed of current events.</p>   # noqa: E501

    The version of the OpenAPI document: 1.7.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.FactSetESG.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.FactSetESG.exceptions import ApiAttributeError



class SasbScoresAll(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'date': (date, none_type,),  # noqa: E501
            'fsym_id': (str, none_type,),  # noqa: E501
            'request_id': (str,),  # noqa: E501
            'score_type': (str, none_type,),  # noqa: E501
            'access_and_affordability': (float, none_type,),  # noqa: E501
            'air_quality': (float, none_type,),  # noqa: E501
            'all_categories': (float, none_type,),  # noqa: E501
            'business_ethics': (float, none_type,),  # noqa: E501
            'business_model_resilience': (float, none_type,),  # noqa: E501
            'competitive_behavior': (float, none_type,),  # noqa: E501
            'critical_incident_risk_management': (float, none_type,),  # noqa: E501
            'customer_privacy': (float, none_type,),  # noqa: E501
            'customer_welfare': (float, none_type,),  # noqa: E501
            'data_security': (float, none_type,),  # noqa: E501
            'ecological_impacts': (float, none_type,),  # noqa: E501
            'employee_engagement_diversityand_inclusion': (float, none_type,),  # noqa: E501
            'employee_health_and_safety': (float, none_type,),  # noqa: E501
            'energy_management': (float, none_type,),  # noqa: E501
            'g_hg_emissions': (float, none_type,),  # noqa: E501
            'human_rightsand_community_relations': (float, none_type,),  # noqa: E501
            'labor_practices': (float, none_type,),  # noqa: E501
            'management_of_the_legal_and_regulatory_environment': (float, none_type,),  # noqa: E501
            'materials_sourcing_and_efficiency': (float, none_type,),  # noqa: E501
            'materiality': (float, none_type,),  # noqa: E501
            'physical_impacts_of_climate_change': (float, none_type,),  # noqa: E501
            'product_quality_and_safety': (float, none_type,),  # noqa: E501
            'product_design_and_lifecycle_management': (float, none_type,),  # noqa: E501
            'selling_practices_and_product_labeling': (float, none_type,),  # noqa: E501
            'supply_chain_management': (float, none_type,),  # noqa: E501
            'systemic_risk_management': (float, none_type,),  # noqa: E501
            'waste_and_hazardous_materials_management': (float, none_type,),  # noqa: E501
            'water_and_wastewater_management': (float, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'date': 'date',  # noqa: E501
        'fsym_id': 'fsymId',  # noqa: E501
        'request_id': 'requestId',  # noqa: E501
        'score_type': 'scoreType',  # noqa: E501
        'access_and_affordability': 'accessAndAffordability',  # noqa: E501
        'air_quality': 'airQuality',  # noqa: E501
        'all_categories': 'allCategories',  # noqa: E501
        'business_ethics': 'businessEthics',  # noqa: E501
        'business_model_resilience': 'businessModelResilience',  # noqa: E501
        'competitive_behavior': 'competitiveBehavior',  # noqa: E501
        'critical_incident_risk_management': 'criticalIncidentRiskManagement',  # noqa: E501
        'customer_privacy': 'customerPrivacy',  # noqa: E501
        'customer_welfare': 'customerWelfare',  # noqa: E501
        'data_security': 'dataSecurity',  # noqa: E501
        'ecological_impacts': 'ecologicalImpacts',  # noqa: E501
        'employee_engagement_diversityand_inclusion': 'employeeEngagementDiversityandInclusion',  # noqa: E501
        'employee_health_and_safety': 'employeeHealthAndSafety',  # noqa: E501
        'energy_management': 'energyManagement',  # noqa: E501
        'g_hg_emissions': 'gHGEmissions',  # noqa: E501
        'human_rightsand_community_relations': 'humanRightsandCommunityRelations',  # noqa: E501
        'labor_practices': 'laborPractices',  # noqa: E501
        'management_of_the_legal_and_regulatory_environment': 'managementOfTheLegalAndRegulatoryEnvironment',  # noqa: E501
        'materials_sourcing_and_efficiency': 'materialsSourcingAndEfficiency',  # noqa: E501
        'materiality': 'materiality',  # noqa: E501
        'physical_impacts_of_climate_change': 'physicalImpactsOfClimateChange',  # noqa: E501
        'product_quality_and_safety': 'productQualityAndSafety',  # noqa: E501
        'product_design_and_lifecycle_management': 'productDesignAndLifecycleManagement',  # noqa: E501
        'selling_practices_and_product_labeling': 'sellingPracticesAndProductLabeling',  # noqa: E501
        'supply_chain_management': 'supplyChainManagement',  # noqa: E501
        'systemic_risk_management': 'systemicRiskManagement',  # noqa: E501
        'waste_and_hazardous_materials_management': 'wasteAndHazardousMaterialsManagement',  # noqa: E501
        'water_and_wastewater_management': 'waterAndWastewaterManagement',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """SasbScoresAll - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            date (date, none_type): Date for the period requested expressed in YYYY-MM-DD format.. [optional]  # noqa: E501
            fsym_id (str, none_type): FactSet Entity Identifier. Six alpha-numeric characters, excluding vowels, with a -E suffix (XXXXXX-E).. [optional]  # noqa: E501
            request_id (str): Identifier that was used for the request.. [optional]  # noqa: E501
            score_type (str, none_type): The name of the specific SASB Score type being shown in the response. This will be represented by the scoreTypes input: PULSE, INSIGHT, MOMENTUM, ART_VOL_TTM, CAT_VOL_TTM, or DYNAMIC_MAT.. [optional]  # noqa: E501
            access_and_affordability (float, none_type): The Access and Affordability SASB Category.. [optional]  # noqa: E501
            air_quality (float, none_type): The Air Quality SASB Category.. [optional]  # noqa: E501
            all_categories (float, none_type): The All Categories Category. This represents the overall SASB Score for the given 'scoreType'. When scoreType = ESG_RANK, the data type will be string, otherwise data type will be a number with double format.. [optional]  # noqa: E501
            business_ethics (float, none_type): The Business Ethics Category.. [optional]  # noqa: E501
            business_model_resilience (float, none_type): The Business Model Resilience Category.. [optional]  # noqa: E501
            competitive_behavior (float, none_type): The Competitive Behavior Category.. [optional]  # noqa: E501
            critical_incident_risk_management (float, none_type): The Critical Incident Risk Management Category.. [optional]  # noqa: E501
            customer_privacy (float, none_type): The Customer Privacy Category.. [optional]  # noqa: E501
            customer_welfare (float, none_type): The Customer Welfare Category.. [optional]  # noqa: E501
            data_security (float, none_type): The Data Security Category.. [optional]  # noqa: E501
            ecological_impacts (float, none_type): The Ecological Impacts Category.. [optional]  # noqa: E501
            employee_engagement_diversityand_inclusion (float, none_type): The Employee Engagement Diversity and Inclusion Category.. [optional]  # noqa: E501
            employee_health_and_safety (float, none_type): The Employee Health And Safety Category.. [optional]  # noqa: E501
            energy_management (float, none_type): The Energy Management Category.. [optional]  # noqa: E501
            g_hg_emissions (float, none_type): The Greenhouse Gases Emissions Category.. [optional]  # noqa: E501
            human_rightsand_community_relations (float, none_type): The Human Rights and Community Relations Category.. [optional]  # noqa: E501
            labor_practices (float, none_type): The Labor Practices Category.. [optional]  # noqa: E501
            management_of_the_legal_and_regulatory_environment (float, none_type): The Management of the Legal and Regulatory Environment Category.. [optional]  # noqa: E501
            materials_sourcing_and_efficiency (float, none_type): The Materials Sourcing and Efficiency Category.. [optional]  # noqa: E501
            materiality (float, none_type): The Materiality Category. When scoreType = ESG_RANK, the data type will be string, otherwise data type will be a number with double format.. [optional]  # noqa: E501
            physical_impacts_of_climate_change (float, none_type): The Physical Impacts of Climate Change Category.. [optional]  # noqa: E501
            product_quality_and_safety (float, none_type): The Product Quality and Safety Category.. [optional]  # noqa: E501
            product_design_and_lifecycle_management (float, none_type): The Product Design And Lifecycle Management Category.. [optional]  # noqa: E501
            selling_practices_and_product_labeling (float, none_type): The Selling Practices And Product Labeling Category.. [optional]  # noqa: E501
            supply_chain_management (float, none_type): The Supply Chain Management Category.. [optional]  # noqa: E501
            systemic_risk_management (float, none_type): The Systemic Risk Management Category.. [optional]  # noqa: E501
            waste_and_hazardous_materials_management (float, none_type): The Waste and Hazardous Materials Management Category.. [optional]  # noqa: E501
            water_and_wastewater_management (float, none_type): The Water and Wastewater Management Category.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SasbScoresAll - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            date (date, none_type): Date for the period requested expressed in YYYY-MM-DD format.. [optional]  # noqa: E501
            fsym_id (str, none_type): FactSet Entity Identifier. Six alpha-numeric characters, excluding vowels, with a -E suffix (XXXXXX-E).. [optional]  # noqa: E501
            request_id (str): Identifier that was used for the request.. [optional]  # noqa: E501
            score_type (str, none_type): The name of the specific SASB Score type being shown in the response. This will be represented by the scoreTypes input: PULSE, INSIGHT, MOMENTUM, ART_VOL_TTM, CAT_VOL_TTM, or DYNAMIC_MAT.. [optional]  # noqa: E501
            access_and_affordability (float, none_type): The Access and Affordability SASB Category.. [optional]  # noqa: E501
            air_quality (float, none_type): The Air Quality SASB Category.. [optional]  # noqa: E501
            all_categories (float, none_type): The All Categories Category. This represents the overall SASB Score for the given 'scoreType'. When scoreType = ESG_RANK, the data type will be string, otherwise data type will be a number with double format.. [optional]  # noqa: E501
            business_ethics (float, none_type): The Business Ethics Category.. [optional]  # noqa: E501
            business_model_resilience (float, none_type): The Business Model Resilience Category.. [optional]  # noqa: E501
            competitive_behavior (float, none_type): The Competitive Behavior Category.. [optional]  # noqa: E501
            critical_incident_risk_management (float, none_type): The Critical Incident Risk Management Category.. [optional]  # noqa: E501
            customer_privacy (float, none_type): The Customer Privacy Category.. [optional]  # noqa: E501
            customer_welfare (float, none_type): The Customer Welfare Category.. [optional]  # noqa: E501
            data_security (float, none_type): The Data Security Category.. [optional]  # noqa: E501
            ecological_impacts (float, none_type): The Ecological Impacts Category.. [optional]  # noqa: E501
            employee_engagement_diversityand_inclusion (float, none_type): The Employee Engagement Diversity and Inclusion Category.. [optional]  # noqa: E501
            employee_health_and_safety (float, none_type): The Employee Health And Safety Category.. [optional]  # noqa: E501
            energy_management (float, none_type): The Energy Management Category.. [optional]  # noqa: E501
            g_hg_emissions (float, none_type): The Greenhouse Gases Emissions Category.. [optional]  # noqa: E501
            human_rightsand_community_relations (float, none_type): The Human Rights and Community Relations Category.. [optional]  # noqa: E501
            labor_practices (float, none_type): The Labor Practices Category.. [optional]  # noqa: E501
            management_of_the_legal_and_regulatory_environment (float, none_type): The Management of the Legal and Regulatory Environment Category.. [optional]  # noqa: E501
            materials_sourcing_and_efficiency (float, none_type): The Materials Sourcing and Efficiency Category.. [optional]  # noqa: E501
            materiality (float, none_type): The Materiality Category. When scoreType = ESG_RANK, the data type will be string, otherwise data type will be a number with double format.. [optional]  # noqa: E501
            physical_impacts_of_climate_change (float, none_type): The Physical Impacts of Climate Change Category.. [optional]  # noqa: E501
            product_quality_and_safety (float, none_type): The Product Quality and Safety Category.. [optional]  # noqa: E501
            product_design_and_lifecycle_management (float, none_type): The Product Design And Lifecycle Management Category.. [optional]  # noqa: E501
            selling_practices_and_product_labeling (float, none_type): The Selling Practices And Product Labeling Category.. [optional]  # noqa: E501
            supply_chain_management (float, none_type): The Supply Chain Management Category.. [optional]  # noqa: E501
            systemic_risk_management (float, none_type): The Systemic Risk Management Category.. [optional]  # noqa: E501
            waste_and_hazardous_materials_management (float, none_type): The Waste and Hazardous Materials Management Category.. [optional]  # noqa: E501
            water_and_wastewater_management (float, none_type): The Water and Wastewater Management Category.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
