# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2.   # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from elabapi_python.api_client import ApiClient


class StepsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_step(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Delete a step.  # noqa: E501

        The step gets deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_step(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :param int subid: ID of the step (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_step_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_step_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
            return data

    def delete_step_with_http_info(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Delete a step.  # noqa: E501

        The step gets deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_step_with_http_info(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :param int subid: ID of the step (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'subid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_step" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `delete_step`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_step`")  # noqa: E501
        # verify the required parameter 'subid' is set
        if ('subid' not in params or
                params['subid'] is None):
            raise ValueError("Missing the required parameter `subid` when calling `delete_step`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subid' in params:
            path_params['subid'] = params['subid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/steps/{subid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_step(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Actions on a step.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_step(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :param int subid: ID of the step (required)
        :param StepsSubidBody body: Parameters for modifying a step
        :return: Step
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_step_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_step_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
            return data

    def patch_step_with_http_info(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Actions on a step.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_step_with_http_info(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :param int subid: ID of the step (required)
        :param StepsSubidBody body: Parameters for modifying a step
        :return: Step
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'subid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_step" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `patch_step`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_step`")  # noqa: E501
        # verify the required parameter 'subid' is set
        if ('subid' not in params or
                params['subid'] is None):
            raise ValueError("Missing the required parameter `subid` when calling `patch_step`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subid' in params:
            path_params['subid'] = params['subid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/steps/{subid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Step',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_step(self, entity_type, id, **kwargs):  # noqa: E501
        """Create a step.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_step(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :param IdStepsBody body: Parameters for creating a step.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_step_with_http_info(entity_type, id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_step_with_http_info(entity_type, id, **kwargs)  # noqa: E501
            return data

    def post_step_with_http_info(self, entity_type, id, **kwargs):  # noqa: E501
        """Create a step.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_step_with_http_info(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :param IdStepsBody body: Parameters for creating a step.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_step" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `post_step`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `post_step`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/steps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_steps(self, entity_type, id, **kwargs):  # noqa: E501
        """Read all steps of that entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_steps(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :return: list[Step]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_steps_with_http_info(entity_type, id, **kwargs)  # noqa: E501
        else:
            (data) = self.read_steps_with_http_info(entity_type, id, **kwargs)  # noqa: E501
            return data

    def read_steps_with_http_info(self, entity_type, id, **kwargs):  # noqa: E501
        """Read all steps of that entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_steps_with_http_info(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param int id: ID of the entity (required)
        :return: list[Step]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_steps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `read_steps`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `read_steps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/steps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Step]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
