"use strict";
// Copyright 2012-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2019-03-28T16:34:13.080Z","fingerprint":"g5Hh7xKYTlj0qsM43LFtKBENTFF/THX8btN/OwMxWfM="}
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/cdk");
/**
 * Determine whether the given properties match those of a `CfnBudgetProps`
 *
 * @param properties - the TypeScript properties of a `CfnBudgetProps`
 *
 * @returns the result of the validation.
 */
function CfnBudgetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('budget', cdk.requiredValidator)(properties.budget));
    errors.collect(cdk.propertyValidator('budget', CfnBudget_BudgetDataPropertyValidator)(properties.budget));
    errors.collect(cdk.propertyValidator('notificationsWithSubscribers', cdk.listValidator(CfnBudget_NotificationWithSubscribersPropertyValidator))(properties.notificationsWithSubscribers));
    return errors.wrap('supplied properties not correct for "CfnBudgetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget` resource
 *
 * @param properties - the TypeScript properties of a `CfnBudgetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget` resource.
 */
// @ts-ignore TS6133
function cfnBudgetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudgetPropsValidator(properties).assertSuccess();
    return {
        Budget: cfnBudgetBudgetDataPropertyToCloudFormation(properties.budget),
        NotificationsWithSubscribers: cdk.listMapper(cfnBudgetNotificationWithSubscribersPropertyToCloudFormation)(properties.notificationsWithSubscribers),
    };
}
/**
 * A CloudFormation `AWS::Budgets::Budget`
 *
 * @cloudformationResource AWS::Budgets::Budget
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
class CfnBudget extends cdk.CfnResource {
    /**
     * Create a new `AWS::Budgets::Budget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnBudget.resourceTypeName, properties: props });
        cdk.requireProperty(props, 'budget', this);
        this.budgetName = this.ref.toString();
    }
    get propertyOverrides() {
        return this.untypedPropertyOverrides;
    }
    renderProperties(properties) {
        return cfnBudgetPropsToCloudFormation(this.node.resolve(properties));
    }
}
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnBudget.resourceTypeName = "AWS::Budgets::Budget";
exports.CfnBudget = CfnBudget;
/**
 * Determine whether the given properties match those of a `BudgetDataProperty`
 *
 * @param properties - the TypeScript properties of a `BudgetDataProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_BudgetDataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('budgetLimit', CfnBudget_SpendPropertyValidator)(properties.budgetLimit));
    errors.collect(cdk.propertyValidator('budgetName', cdk.validateString)(properties.budgetName));
    errors.collect(cdk.propertyValidator('budgetType', cdk.requiredValidator)(properties.budgetType));
    errors.collect(cdk.propertyValidator('budgetType', cdk.validateString)(properties.budgetType));
    errors.collect(cdk.propertyValidator('costFilters', cdk.validateObject)(properties.costFilters));
    errors.collect(cdk.propertyValidator('costTypes', CfnBudget_CostTypesPropertyValidator)(properties.costTypes));
    errors.collect(cdk.propertyValidator('timePeriod', CfnBudget_TimePeriodPropertyValidator)(properties.timePeriod));
    errors.collect(cdk.propertyValidator('timeUnit', cdk.requiredValidator)(properties.timeUnit));
    errors.collect(cdk.propertyValidator('timeUnit', cdk.validateString)(properties.timeUnit));
    return errors.wrap('supplied properties not correct for "BudgetDataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.BudgetData` resource
 *
 * @param properties - the TypeScript properties of a `BudgetDataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.BudgetData` resource.
 */
// @ts-ignore TS6133
function cfnBudgetBudgetDataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_BudgetDataPropertyValidator(properties).assertSuccess();
    return {
        BudgetLimit: cfnBudgetSpendPropertyToCloudFormation(properties.budgetLimit),
        BudgetName: cdk.stringToCloudFormation(properties.budgetName),
        BudgetType: cdk.stringToCloudFormation(properties.budgetType),
        CostFilters: cdk.objectToCloudFormation(properties.costFilters),
        CostTypes: cfnBudgetCostTypesPropertyToCloudFormation(properties.costTypes),
        TimePeriod: cfnBudgetTimePeriodPropertyToCloudFormation(properties.timePeriod),
        TimeUnit: cdk.stringToCloudFormation(properties.timeUnit),
    };
}
/**
 * Determine whether the given properties match those of a `CostTypesProperty`
 *
 * @param properties - the TypeScript properties of a `CostTypesProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_CostTypesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('includeCredit', cdk.validateBoolean)(properties.includeCredit));
    errors.collect(cdk.propertyValidator('includeDiscount', cdk.validateBoolean)(properties.includeDiscount));
    errors.collect(cdk.propertyValidator('includeOtherSubscription', cdk.validateBoolean)(properties.includeOtherSubscription));
    errors.collect(cdk.propertyValidator('includeRecurring', cdk.validateBoolean)(properties.includeRecurring));
    errors.collect(cdk.propertyValidator('includeRefund', cdk.validateBoolean)(properties.includeRefund));
    errors.collect(cdk.propertyValidator('includeSubscription', cdk.validateBoolean)(properties.includeSubscription));
    errors.collect(cdk.propertyValidator('includeSupport', cdk.validateBoolean)(properties.includeSupport));
    errors.collect(cdk.propertyValidator('includeTax', cdk.validateBoolean)(properties.includeTax));
    errors.collect(cdk.propertyValidator('includeUpfront', cdk.validateBoolean)(properties.includeUpfront));
    errors.collect(cdk.propertyValidator('useAmortized', cdk.validateBoolean)(properties.useAmortized));
    errors.collect(cdk.propertyValidator('useBlended', cdk.validateBoolean)(properties.useBlended));
    return errors.wrap('supplied properties not correct for "CostTypesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.CostTypes` resource
 *
 * @param properties - the TypeScript properties of a `CostTypesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.CostTypes` resource.
 */
// @ts-ignore TS6133
function cfnBudgetCostTypesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_CostTypesPropertyValidator(properties).assertSuccess();
    return {
        IncludeCredit: cdk.booleanToCloudFormation(properties.includeCredit),
        IncludeDiscount: cdk.booleanToCloudFormation(properties.includeDiscount),
        IncludeOtherSubscription: cdk.booleanToCloudFormation(properties.includeOtherSubscription),
        IncludeRecurring: cdk.booleanToCloudFormation(properties.includeRecurring),
        IncludeRefund: cdk.booleanToCloudFormation(properties.includeRefund),
        IncludeSubscription: cdk.booleanToCloudFormation(properties.includeSubscription),
        IncludeSupport: cdk.booleanToCloudFormation(properties.includeSupport),
        IncludeTax: cdk.booleanToCloudFormation(properties.includeTax),
        IncludeUpfront: cdk.booleanToCloudFormation(properties.includeUpfront),
        UseAmortized: cdk.booleanToCloudFormation(properties.useAmortized),
        UseBlended: cdk.booleanToCloudFormation(properties.useBlended),
    };
}
/**
 * Determine whether the given properties match those of a `NotificationProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_NotificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.requiredValidator)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.validateString)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('notificationType', cdk.requiredValidator)(properties.notificationType));
    errors.collect(cdk.propertyValidator('notificationType', cdk.validateString)(properties.notificationType));
    errors.collect(cdk.propertyValidator('threshold', cdk.requiredValidator)(properties.threshold));
    errors.collect(cdk.propertyValidator('threshold', cdk.validateNumber)(properties.threshold));
    errors.collect(cdk.propertyValidator('thresholdType', cdk.validateString)(properties.thresholdType));
    return errors.wrap('supplied properties not correct for "NotificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.Notification` resource
 *
 * @param properties - the TypeScript properties of a `NotificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.Notification` resource.
 */
// @ts-ignore TS6133
function cfnBudgetNotificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_NotificationPropertyValidator(properties).assertSuccess();
    return {
        ComparisonOperator: cdk.stringToCloudFormation(properties.comparisonOperator),
        NotificationType: cdk.stringToCloudFormation(properties.notificationType),
        Threshold: cdk.numberToCloudFormation(properties.threshold),
        ThresholdType: cdk.stringToCloudFormation(properties.thresholdType),
    };
}
/**
 * Determine whether the given properties match those of a `NotificationWithSubscribersProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationWithSubscribersProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_NotificationWithSubscribersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('notification', cdk.requiredValidator)(properties.notification));
    errors.collect(cdk.propertyValidator('notification', CfnBudget_NotificationPropertyValidator)(properties.notification));
    errors.collect(cdk.propertyValidator('subscribers', cdk.requiredValidator)(properties.subscribers));
    errors.collect(cdk.propertyValidator('subscribers', cdk.listValidator(CfnBudget_SubscriberPropertyValidator))(properties.subscribers));
    return errors.wrap('supplied properties not correct for "NotificationWithSubscribersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.NotificationWithSubscribers` resource
 *
 * @param properties - the TypeScript properties of a `NotificationWithSubscribersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.NotificationWithSubscribers` resource.
 */
// @ts-ignore TS6133
function cfnBudgetNotificationWithSubscribersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_NotificationWithSubscribersPropertyValidator(properties).assertSuccess();
    return {
        Notification: cfnBudgetNotificationPropertyToCloudFormation(properties.notification),
        Subscribers: cdk.listMapper(cfnBudgetSubscriberPropertyToCloudFormation)(properties.subscribers),
    };
}
/**
 * Determine whether the given properties match those of a `SpendProperty`
 *
 * @param properties - the TypeScript properties of a `SpendProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_SpendPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('amount', cdk.requiredValidator)(properties.amount));
    errors.collect(cdk.propertyValidator('amount', cdk.validateNumber)(properties.amount));
    errors.collect(cdk.propertyValidator('unit', cdk.requiredValidator)(properties.unit));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "SpendProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.Spend` resource
 *
 * @param properties - the TypeScript properties of a `SpendProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.Spend` resource.
 */
// @ts-ignore TS6133
function cfnBudgetSpendPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_SpendPropertyValidator(properties).assertSuccess();
    return {
        Amount: cdk.numberToCloudFormation(properties.amount),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
/**
 * Determine whether the given properties match those of a `SubscriberProperty`
 *
 * @param properties - the TypeScript properties of a `SubscriberProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_SubscriberPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('address', cdk.requiredValidator)(properties.address));
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    errors.collect(cdk.propertyValidator('subscriptionType', cdk.requiredValidator)(properties.subscriptionType));
    errors.collect(cdk.propertyValidator('subscriptionType', cdk.validateString)(properties.subscriptionType));
    return errors.wrap('supplied properties not correct for "SubscriberProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.Subscriber` resource
 *
 * @param properties - the TypeScript properties of a `SubscriberProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.Subscriber` resource.
 */
// @ts-ignore TS6133
function cfnBudgetSubscriberPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_SubscriberPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
        SubscriptionType: cdk.stringToCloudFormation(properties.subscriptionType),
    };
}
/**
 * Determine whether the given properties match those of a `TimePeriodProperty`
 *
 * @param properties - the TypeScript properties of a `TimePeriodProperty`
 *
 * @returns the result of the validation.
 */
function CfnBudget_TimePeriodPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('end', cdk.validateString)(properties.end));
    errors.collect(cdk.propertyValidator('start', cdk.validateString)(properties.start));
    return errors.wrap('supplied properties not correct for "TimePeriodProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Budgets::Budget.TimePeriod` resource
 *
 * @param properties - the TypeScript properties of a `TimePeriodProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Budgets::Budget.TimePeriod` resource.
 */
// @ts-ignore TS6133
function cfnBudgetTimePeriodPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBudget_TimePeriodPropertyValidator(properties).assertSuccess();
    return {
        End: cdk.stringToCloudFormation(properties.end),
        Start: cdk.stringToCloudFormation(properties.start),
    };
}
//# sourceMappingURL=data:application/json;base64,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