"""
from [Kinzer & Gunn 1951](https://doi.org/10.1175/1520-0469(1951)008%3C0071:TETATR%3E2.0.CO;2)
Table1 represents factor 4*pi*radius(1 + F*radius/s_prim) for several drop diameters
and temperatures (0, 10, 20, 40 deg. Celsius).
Table2 contains factor D(rho_a - rho_b) for the same temperatures as in Table1
but for different relative humidities (from 10% to 100%).
"""

table1 = {
    "Diameter [cm]": (
        0.01,
        0.02,
        0.03,
        0.04,
        0.05,
        0.06,
        0.07,
        0.08,
        0.09,
        0.1,
        0.12,
        0.14,
        0.16,
        0.18,
        0.20,
        0.22,
        0.24,
        0.26,
        0.28,
        0.30,
        0.32,
        0.34,
        0.36,
        0.38,
        0.4,
        0.42,
        0.44,
    ),
    "0 [deg C]": (
        0.086,
        0.29,
        0.49,
        0.73,
        1.01,
        1.31,
        1.66,
        2.03,
        2.5,
        2.9,
        3.9,
        4.9,
        6.0,
        7.3,
        8.8,
        10.5,
        12.4,
        14.7,
        17.2,
        20.1,
        23.0,
        27.0,
        31.0,
        35.0,
        0.0,
        0.0,
        0.0,
    ),
    "10 [deg C]": (
        0.082,
        0.29,
        0.48,
        0.72,
        0.99,
        1.29,
        1.63,
        2.0,
        2.4,
        2.8,
        3.8,
        4.8,
        5.9,
        7.2,
        8.5,
        10.1,
        12.0,
        14.2,
        16.6,
        19.3,
        22.0,
        26.0,
        30.0,
        34.0,
        0.0,
        0.0,
        0.0,
    ),
    "20 [deg C]": (
        0.079,
        0.29,
        0.48,
        0.71,
        0.97,
        1.27,
        1.61,
        1.97,
        2.4,
        2.8,
        3.7,
        4.7,
        5.8,
        7.0,
        8.3,
        9.9,
        11.7,
        13.8,
        16.0,
        18.5,
        21,
        25,
        28,
        32,
        36,
        0,
        0,
    ),
    "30 [deg C]": (
        0.079,
        0.28,
        0.47,
        0.7,
        0.96,
        1.25,
        1.58,
        1.94,
        2.3,
        2.7,
        3.6,
        4.6,
        5.7,
        6.9,
        8.1,
        9.6,
        11.3,
        13.3,
        15.4,
        17.8,
        21,
        24,
        27,
        31,
        35,
        39,
        0,
    ),
    "40 [deg C]": (
        0.073,
        0.28,
        0.47,
        0.69,
        0.94,
        1.24,
        1.55,
        1.91,
        2.3,
        2.7,
        3.6,
        4.5,
        5.6,
        6.8,
        8.0,
        9.4,
        11.0,
        12.8,
        14.9,
        17.2,
        20,
        23,
        26,
        29,
        33,
        37,
        0,
    ),
}

table2 = {
    "relative humidity [percent]": (10, 20, 30, 40, 50, 60, 70, 80, 90, 100),
    "0 [deg C]": (0.61, 0.54, 0.48, 0.41, 0.34, 0.27, 0.2, 0.135, 0.067, 0),
    "20 [deg C]": (1.47, 1.29, 1.12, 0.95, 0.78, 0.63, 0.46, 0.31, 0.159, 0),
    "30 [deg C]": (2.06, 1.79, 1.55, 1.32, 1.09, 0.86, 0.64, 0.42, 0.21, 0),
    "40 [deg C]": (2.68, 2.36, 2.05, 1.75, 1.45, 1.15, 0.85, 0.56, 0.28, 0),
}
