﻿"""_820.py

ContactResultType
"""


from enum import Enum

from mastapy._internal.python_net import python_net_import

_CONTACT_RESULT_TYPE = python_net_import('SMT.MastaAPI.Gears.LTCA', 'ContactResultType')


__docformat__ = 'restructuredtext en'
__all__ = ('ContactResultType',)


class ContactResultType(Enum):
    """ContactResultType

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls):
        return _CONTACT_RESULT_TYPE

    MAX_PRESSURE = 0
    FORCE_PER_UNIT_LENGTH = 1
    HERTZIAN_CONTACT_HALF_WIDTH = 2
    MAX_SHEAR_STRESS = 3
    DEPTH_OF_MAX_SHEAR_STRESS = 4
    TOTAL_DEFLECTION_FOR_MESH = 5
    SLIDING_VELOCITY = 6
    PRESSURE_VELOCITY_PV = 7
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTR_1514412010 = 8
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTR_1514412010 = 9
    MICROPITTING_SAFETY_FACTOR_ISOTR_1514412010 = 10
    MICROPITTING_FLASH_TEMPERATURE_ISOTR_1514412010 = 11
    MICROPITTING_CONTACT_TEMPERATURE_ISOTR_1514412010 = 12
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTR_1514412014 = 13
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTR_1514412014 = 14
    MICROPITTING_SAFETY_FACTOR_ISOTR_1514412014 = 15
    MICROPITTING_FLASH_TEMPERATURE_ISOTR_1514412014 = 16
    MICROPITTING_CONTACT_TEMPERATURE_ISOTR_1514412014 = 17
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTS_6336222018 = 18
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTS_6336222018 = 19
    MICROPITTING_SAFETY_FACTOR_ISOTS_6336222018 = 20
    MICROPITTING_FLASH_TEMPERATURE_ISOTS_6336222018 = 21
    MICROPITTING_CONTACT_TEMPERATURE_ISOTS_6336222018 = 22
    COEFFICIENT_OF_FRICTION_BENEDICT_AND_KELLEY = 23
    SLIDING_POWER_LOSS = 24
    SCUFFING_FLASH_TEMPERATURE_ISOTR_1398912000 = 25
    SCUFFING_CONTACT_TEMPERATURE_ISOTR_1398912000 = 26
    SCUFFING_SAFETY_FACTOR_ISOTR_1398912000 = 27
    SCUFFING_FLASH_TEMPERATURE_ISOTS_6336202017 = 28
    SCUFFING_CONTACT_TEMPERATURE_ISOTS_6336202017 = 29
    SCUFFING_SAFETY_FACTOR_ISOTS_6336202017 = 30
    SCUFFING_FLASH_TEMPERATURE_ISOTS_6336202022 = 31
    SCUFFING_CONTACT_TEMPERATURE_ISOTS_6336202022 = 32
    SCUFFING_SAFETY_FACTOR_ISOTS_6336202022 = 33
    SCUFFING_FLASH_TEMPERATURE_AGMA_925A03 = 34
    SCUFFING_CONTACT_TEMPERATURE_AGMA_925A03 = 35
    SCUFFING_SAFETY_FACTOR_AGMA_925A03 = 36
    SCUFFING_FLASH_TEMPERATURE_AGMA_925B22 = 37
    SCUFFING_CONTACT_TEMPERATURE_AGMA_925B22 = 38
    SCUFFING_SAFETY_FACTOR_AGMA_925B22 = 39
    SCUFFING_FLASH_TEMPERATURE_DIN_399041987 = 40
    SCUFFING_CONTACT_TEMPERATURE_DIN_399041987 = 41
    SCUFFING_SAFETY_FACTOR_DIN_399041987 = 42
    GAP_BETWEEN_LOADED_FLANKS_TRANSVERSE = 43
    GAP_BETWEEN_UNLOADED_FLANKS_TRANSVERSE = 44
    GEAR_A_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 45
    GEAR_A_DEPTH_OF_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 46
    GEAR_B_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 47
    GEAR_B_DEPTH_OF_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 48


def __enum_setattr(self, attr, value):
    raise AttributeError('Cannot set the attributes of an Enum.') from None


def __enum_delattr(self, attr):
    raise AttributeError('Cannot delete the attributes of an Enum.') from None


ContactResultType.__setattr__ = __enum_setattr
ContactResultType.__delattr__ = __enum_delattr
