﻿"""_2357.py

MaterialPropertiesWithSelection
"""


from mastapy.nodal_analysis.dev_tools_analyses.full_fe_reporting import _212
from mastapy._internal import constructor
from mastapy import _0
from mastapy._internal.python_net import python_net_import

_MATERIAL_PROPERTIES_WITH_SELECTION = python_net_import('SMT.MastaAPI.SystemModel.FE', 'MaterialPropertiesWithSelection')


__docformat__ = 'restructuredtext en'
__all__ = ('MaterialPropertiesWithSelection',)


class MaterialPropertiesWithSelection(_0.APIBase):
    """MaterialPropertiesWithSelection

    This is a mastapy class.
    """

    TYPE = _MATERIAL_PROPERTIES_WITH_SELECTION

    def __init__(self, instance_to_wrap: 'MaterialPropertiesWithSelection.TYPE'):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def material_properties(self) -> '_212.MaterialPropertiesReporting':
        """MaterialPropertiesReporting: 'MaterialProperties' is the original name of this property.

        Note:
            This property is readonly.
        """

        temp = self.wrapped.MaterialProperties

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp) if temp is not None else None

    def select_nodes(self):
        """ 'SelectNodes' is the original name of this method."""

        self.wrapped.SelectNodes()
