# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.document_breakdown_age_validation import DocumentBreakdownAgeValidation
from onfido.models.document_breakdown_compromised_document import DocumentBreakdownCompromisedDocument
from onfido.models.document_breakdown_data_comparison import DocumentBreakdownDataComparison
from onfido.models.document_breakdown_data_consistency import DocumentBreakdownDataConsistency
from onfido.models.document_breakdown_data_validation import DocumentBreakdownDataValidation
from onfido.models.document_breakdown_image_integrity import DocumentBreakdownImageIntegrity
from onfido.models.document_breakdown_issuing_authority import DocumentBreakdownIssuingAuthority
from onfido.models.document_breakdown_police_record import DocumentBreakdownPoliceRecord
from onfido.models.document_breakdown_visual_authenticity import DocumentBreakdownVisualAuthenticity
from typing import Optional, Set
from typing_extensions import Self

class DocumentBreakdown(BaseModel):
    """
    DocumentBreakdown
    """ # noqa: E501
    data_comparison: Optional[DocumentBreakdownDataComparison] = None
    data_validation: Optional[DocumentBreakdownDataValidation] = None
    image_integrity: Optional[DocumentBreakdownImageIntegrity] = None
    visual_authenticity: Optional[DocumentBreakdownVisualAuthenticity] = None
    data_consistency: Optional[DocumentBreakdownDataConsistency] = None
    police_record: Optional[DocumentBreakdownPoliceRecord] = None
    compromised_document: Optional[DocumentBreakdownCompromisedDocument] = None
    age_validation: Optional[DocumentBreakdownAgeValidation] = None
    issuing_authority: Optional[DocumentBreakdownIssuingAuthority] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["data_comparison", "data_validation", "image_integrity", "visual_authenticity", "data_consistency", "police_record", "compromised_document", "age_validation", "issuing_authority"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_comparison
        if self.data_comparison:
            _dict['data_comparison'] = self.data_comparison.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_validation
        if self.data_validation:
            _dict['data_validation'] = self.data_validation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_integrity
        if self.image_integrity:
            _dict['image_integrity'] = self.image_integrity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of visual_authenticity
        if self.visual_authenticity:
            _dict['visual_authenticity'] = self.visual_authenticity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_consistency
        if self.data_consistency:
            _dict['data_consistency'] = self.data_consistency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of police_record
        if self.police_record:
            _dict['police_record'] = self.police_record.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compromised_document
        if self.compromised_document:
            _dict['compromised_document'] = self.compromised_document.to_dict()
        # override the default output from pydantic by calling `to_dict()` of age_validation
        if self.age_validation:
            _dict['age_validation'] = self.age_validation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issuing_authority
        if self.issuing_authority:
            _dict['issuing_authority'] = self.issuing_authority.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "data_comparison": DocumentBreakdownDataComparison.from_dict(obj["data_comparison"]) if obj.get("data_comparison") is not None else None,
            "data_validation": DocumentBreakdownDataValidation.from_dict(obj["data_validation"]) if obj.get("data_validation") is not None else None,
            "image_integrity": DocumentBreakdownImageIntegrity.from_dict(obj["image_integrity"]) if obj.get("image_integrity") is not None else None,
            "visual_authenticity": DocumentBreakdownVisualAuthenticity.from_dict(obj["visual_authenticity"]) if obj.get("visual_authenticity") is not None else None,
            "data_consistency": DocumentBreakdownDataConsistency.from_dict(obj["data_consistency"]) if obj.get("data_consistency") is not None else None,
            "police_record": DocumentBreakdownPoliceRecord.from_dict(obj["police_record"]) if obj.get("police_record") is not None else None,
            "compromised_document": DocumentBreakdownCompromisedDocument.from_dict(obj["compromised_document"]) if obj.get("compromised_document") is not None else None,
            "age_validation": DocumentBreakdownAgeValidation.from_dict(obj["age_validation"]) if obj.get("age_validation") is not None else None,
            "issuing_authority": DocumentBreakdownIssuingAuthority.from_dict(obj["issuing_authority"]) if obj.get("issuing_authority") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


