# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.document_breakdown_data_comparison_breakdown_issuing_country import DocumentBreakdownDataComparisonBreakdownIssuingCountry
from onfido.models.document_breakdown_data_validation_breakdown_document_expiration import DocumentBreakdownDataValidationBreakdownDocumentExpiration
from onfido.models.document_breakdown_data_validation_breakdown_expiry_date import DocumentBreakdownDataValidationBreakdownExpiryDate
from typing import Optional, Set
from typing_extensions import Self

class DocumentBreakdownDataValidationBreakdown(BaseModel):
    """
    DocumentBreakdownDataValidationBreakdown
    """ # noqa: E501
    gender: Optional[DocumentBreakdownDataComparisonBreakdownIssuingCountry] = None
    date_of_birth: Optional[DocumentBreakdownDataComparisonBreakdownIssuingCountry] = None
    document_numbers: Optional[DocumentBreakdownDataComparisonBreakdownIssuingCountry] = None
    document_expiration: Optional[DocumentBreakdownDataValidationBreakdownDocumentExpiration] = None
    expiry_date: Optional[DocumentBreakdownDataValidationBreakdownExpiryDate] = None
    mrz: Optional[DocumentBreakdownDataComparisonBreakdownIssuingCountry] = None
    barcode: Optional[DocumentBreakdownDataComparisonBreakdownIssuingCountry] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["gender", "date_of_birth", "document_numbers", "document_expiration", "expiry_date", "mrz", "barcode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentBreakdownDataValidationBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of gender
        if self.gender:
            _dict['gender'] = self.gender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of date_of_birth
        if self.date_of_birth:
            _dict['date_of_birth'] = self.date_of_birth.to_dict()
        # override the default output from pydantic by calling `to_dict()` of document_numbers
        if self.document_numbers:
            _dict['document_numbers'] = self.document_numbers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of document_expiration
        if self.document_expiration:
            _dict['document_expiration'] = self.document_expiration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expiry_date
        if self.expiry_date:
            _dict['expiry_date'] = self.expiry_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mrz
        if self.mrz:
            _dict['mrz'] = self.mrz.to_dict()
        # override the default output from pydantic by calling `to_dict()` of barcode
        if self.barcode:
            _dict['barcode'] = self.barcode.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentBreakdownDataValidationBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "gender": DocumentBreakdownDataComparisonBreakdownIssuingCountry.from_dict(obj["gender"]) if obj.get("gender") is not None else None,
            "date_of_birth": DocumentBreakdownDataComparisonBreakdownIssuingCountry.from_dict(obj["date_of_birth"]) if obj.get("date_of_birth") is not None else None,
            "document_numbers": DocumentBreakdownDataComparisonBreakdownIssuingCountry.from_dict(obj["document_numbers"]) if obj.get("document_numbers") is not None else None,
            "document_expiration": DocumentBreakdownDataValidationBreakdownDocumentExpiration.from_dict(obj["document_expiration"]) if obj.get("document_expiration") is not None else None,
            "expiry_date": DocumentBreakdownDataValidationBreakdownExpiryDate.from_dict(obj["expiry_date"]) if obj.get("expiry_date") is not None else None,
            "mrz": DocumentBreakdownDataComparisonBreakdownIssuingCountry.from_dict(obj["mrz"]) if obj.get("mrz") is not None else None,
            "barcode": DocumentBreakdownDataComparisonBreakdownIssuingCountry.from_dict(obj["barcode"]) if obj.get("barcode") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


