# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from onfido.models.repeat_attempts_list_repeat_attempts_inner import RepeatAttemptsListRepeatAttemptsInner
from typing import Optional, Set
from typing_extensions import Self

class RepeatAttemptsList(BaseModel):
    """
    RepeatAttemptsList
    """ # noqa: E501
    report_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the completed Document report.")
    repeat_attempts: List[RepeatAttemptsListRepeatAttemptsInner] = Field(description="An array of repeat attempt objects. If no repeat attempts were found, the array will be empty. The number of objects returned can increase over time if more matches are received. ")
    attempts_count: Optional[StrictInt] = Field(default=None, description="The total number of attempts using the same document, including the current report under assessment.")
    attempts_clear_rate: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, description="A number between 0 and 1 which indicates the proportion of attempts that have been cleared, including the current report under assessment.")
    unique_mismatches_count: Optional[StrictInt] = Field(default=None, description="The number of unique entries in the repeat_attempts field for which at least one of the fields is a mismatch.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["report_id", "repeat_attempts", "attempts_count", "attempts_clear_rate", "unique_mismatches_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepeatAttemptsList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in repeat_attempts (list)
        _items = []
        if self.repeat_attempts:
            for _item_repeat_attempts in self.repeat_attempts:
                if _item_repeat_attempts:
                    _items.append(_item_repeat_attempts.to_dict())
            _dict['repeat_attempts'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepeatAttemptsList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "report_id": obj.get("report_id"),
            "repeat_attempts": [RepeatAttemptsListRepeatAttemptsInner.from_dict(_item) for _item in obj["repeat_attempts"]] if obj.get("repeat_attempts") is not None else None,
            "attempts_count": obj.get("attempts_count"),
            "attempts_clear_rate": obj.get("attempts_clear_rate"),
            "unique_mismatches_count": obj.get("unique_mismatches_count")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


