# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WatchlistMonitor(BaseModel):
    """
    WatchlistMonitor
    """ # noqa: E501
    applicant_id: StrictStr = Field(description="The ID for the applicant associated with the monitor.")
    report_name: StrictStr = Field(description="The name of the report type the monitor creates.")
    tags: Optional[List[StrictStr]] = Field(default=None, description="A list of tags associated with this monitor. These tags will be applied to each check this monitor creates.")
    id: StrictStr = Field(description="The unique identifier for the monitor.")
    created_at: Optional[datetime] = Field(default=None, description="The date and time at which the monitor was created.")
    deleted_at: Optional[datetime] = Field(default=None, description="The date and time at which the monitor was deleted. If the monitor is still active, this field will be null.")
    is_sandbox: Optional[StrictBool] = Field(default=False, description="Indicates whether the object was created in the sandbox or not.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["applicant_id", "report_name", "tags", "id", "created_at", "deleted_at", "is_sandbox"]

    @field_validator('report_name')
    def report_name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['watchlist_standard', 'watchlist_aml', 'unknown_default_open_api']):
            raise ValueError("must be one of enum values ('watchlist_standard', 'watchlist_aml', 'unknown_default_open_api')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WatchlistMonitor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WatchlistMonitor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicant_id": obj.get("applicant_id"),
            "report_name": obj.get("report_name"),
            "tags": obj.get("tags"),
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "deleted_at": obj.get("deleted_at"),
            "is_sandbox": obj.get("is_sandbox") if obj.get("is_sandbox") is not None else False
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


