# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkflowRunLink(BaseModel):
    """
    WorkflowRunLink
    """ # noqa: E501
    url: Optional[StrictStr] = Field(default=None, description="Link to access the Workflow Run without the need to integrate with Onfido's SDKs.")
    completed_redirect_url: Optional[StrictStr] = Field(default=None, description="When the interactive section of the Workflow Run has completed successfully, the user will be redirected to this URL instead of seeing the default Onfido 'thank you' page.")
    expired_redirect_url: Optional[StrictStr] = Field(default=None, description="When the link has expired, the user will be immediately redirected to this URL instead of seeing the default Onfido error message.")
    expires_at: Optional[datetime] = Field(default=None, description="Date and time when the link will expire.")
    language: Optional[StrictStr] = Field(default=None, description="The code for the language when the workflow run is acessed using the link.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["url", "completed_redirect_url", "expired_redirect_url", "expires_at", "language"]

    @field_validator('language')
    def language_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['en_US', 'de_DE', 'es_ES', 'fr_FR', 'it_IT', 'pt_PT', 'nl_NL', 'unknown_default_open_api']):
            raise ValueError("must be one of enum values ('en_US', 'de_DE', 'es_ES', 'fr_FR', 'it_IT', 'pt_PT', 'nl_NL', 'unknown_default_open_api')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowRunLink from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if completed_redirect_url (nullable) is None
        # and model_fields_set contains the field
        if self.completed_redirect_url is None and "completed_redirect_url" in self.model_fields_set:
            _dict['completed_redirect_url'] = None

        # set to None if expired_redirect_url (nullable) is None
        # and model_fields_set contains the field
        if self.expired_redirect_url is None and "expired_redirect_url" in self.model_fields_set:
            _dict['expired_redirect_url'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expires_at'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowRunLink from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "completed_redirect_url": obj.get("completed_redirect_url"),
            "expired_redirect_url": obj.get("expired_redirect_url"),
            "expires_at": obj.get("expires_at"),
            "language": obj.get("language")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


