"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'outputs can be added to the stack'(test) {
        const stack = new lib_1.Stack();
        const res = new lib_1.CfnResource(stack, 'MyResource', { type: 'R' });
        const ref = res.ref;
        new lib_1.CfnOutput(stack, 'MyOutput', {
            exportName: 'ExportName',
            value: ref,
            description: 'CfnOutput properties',
        });
        test.deepEqual(util_1.toCloudFormation(stack), {
            Resources: { MyResource: { Type: 'R' } },
            Outputs: {
                MyOutput: {
                    Description: 'CfnOutput properties',
                    Export: { Name: 'ExportName' },
                    Value: { Ref: 'MyResource' },
                },
            },
        });
        test.done();
    },
    'No export is created by default'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        new lib_1.CfnOutput(stack, 'SomeOutput', { value: 'x' });
        // THEN
        test.deepEqual(util_1.toCloudFormation(stack), {
            Outputs: {
                SomeOutput: {
                    Value: 'x',
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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