"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const runtime_info_1 = require("../lib/private/runtime-info");
module.exports = {
    'version reporting includes @aws-solutions-konstruk libraries'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-konstruk-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/foo',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        test.deepEqual(runtimeInfo.libraries['@aws-solutions-konstruk/foo'], mockVersion);
        test.done();
    },
    'version reporting finds aws-rfdk package'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-rfdk'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: 'aws-rfdk',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        test.deepEqual(runtimeInfo.libraries['aws-rfdk'], mockVersion);
        test.done();
    },
    'version reporting finds no version with no associated package.json'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-find-npm-package-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is bar\';');
        fs.mkdirSync(path.join(pkgdir, 'bar'));
        fs.writeFileSync(path.join(pkgdir, 'bar', 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/bar',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const cwd = process.cwd();
        // Switch to `bar` where the package.json is, then resolve version.  Fails when module.resolve
        // is passed an empty string in the paths array.
        process.chdir(path.join(pkgdir, 'bar'));
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        process.chdir(cwd);
        test.equal(runtimeInfo.libraries['@aws-solutions-konstruk/bar'], undefined);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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