# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-07-07 13:33
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('daiquiri_metadata', '0005_more_fields'),
    ]

    operations = [
        migrations.AlterField(
            model_name='column',
            name='datatype',
            field=models.CharField(blank=True, help_text='The datatype of the column on the database server.', max_length=256, null=True, verbose_name='Datatype'),
        ),
        migrations.AlterField(
            model_name='column',
            name='description',
            field=models.TextField(blank=True, help_text='A brief description of the column to be displayed in the user interface.', null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='column',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups which have access to the column.', to='auth.Group', verbose_name='Groups'),
        ),
        migrations.AlterField(
            model_name='column',
            name='indexed',
            field=models.BooleanField(default=False, help_text='Designates whether the column is indexed.', verbose_name='Indexed'),
        ),
        migrations.AlterField(
            model_name='column',
            name='name',
            field=models.CharField(help_text='Identifier of the column on the database server.', max_length=256, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='column',
            name='order',
            field=models.IntegerField(blank=True, help_text='Position in lists.', null=True, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='column',
            name='principal',
            field=models.BooleanField(default=False, help_text='Designates whether the column is considered a core part of the content.', verbose_name='Principal'),
        ),
        migrations.AlterField(
            model_name='column',
            name='size',
            field=models.IntegerField(blank=True, help_text='The length of variable length datatypes, e.g. varchar(256).', null=True, verbose_name='Size'),
        ),
        migrations.AlterField(
            model_name='column',
            name='std',
            field=models.BooleanField(default=False, help_text='Designates whether the column is defined by some standard.', verbose_name='Standard'),
        ),
        migrations.AlterField(
            model_name='column',
            name='table',
            field=models.ForeignKey(help_text='Table the column belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='columns', to='daiquiri_metadata.Table'),
        ),
        migrations.AlterField(
            model_name='column',
            name='ucd',
            field=models.CharField(blank=True, max_length=256, null=True, verbose_name='IVOA UCDs'),
        ),
        migrations.AlterField(
            model_name='column',
            name='unit',
            field=models.CharField(blank=True, max_length=256, null=True, verbose_name='Unit'),
        ),
        migrations.AlterField(
            model_name='column',
            name='utype',
            field=models.CharField(blank=True, max_length=256, null=True, verbose_name='IVOA Utype'),
        ),
        migrations.AlterField(
            model_name='database',
            name='attribution',
            field=models.TextField(blank=True, help_text='The desired attribution for the database.', null=True, verbose_name='Attribution'),
        ),
        migrations.AlterField(
            model_name='database',
            name='description',
            field=models.TextField(blank=True, help_text='A brief description of the database to be displayed in the user interface.', null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='database',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups which have access to the database.', to='auth.Group', verbose_name='Groups'),
        ),
        migrations.AlterField(
            model_name='database',
            name='license',
            field=models.CharField(blank=True, choices=[(b'CC0', b'CC0 1.0 Universal (CC0 1.0)'), (b'PD', b'Public Domain Mark'), (b'BY', b'Attribution 4.0 International (CC BY 4.0)'), (b'BY_SA', b'Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)'), (b'BY_ND', b'Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)'), (b'BY_NC', b'Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)'), (b'BY_NC_SA', b'Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)'), (b'BY_NC_ND', b'Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0)')], max_length=8, null=True, verbose_name='License'),
        ),
        migrations.AlterField(
            model_name='database',
            name='long_description',
            field=models.TextField(blank=True, help_text='A more extensive description of the database to be displayed on the public database page.', null=True, verbose_name='Long description'),
        ),
        migrations.AlterField(
            model_name='database',
            name='name',
            field=models.CharField(help_text='Name of the database on the database server.', max_length=256, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='database',
            name='order',
            field=models.IntegerField(blank=True, default=0, help_text='Position in lists.', null=True, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='database',
            name='pid',
            field=models.URLField(blank=True, max_length=256, null=True, verbose_name='Persistent identifier'),
        ),
        migrations.AlterField(
            model_name='database',
            name='title',
            field=models.CharField(blank=True, help_text='Human readable title of the database.', max_length=256, null=True, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='database',
            name='utype',
            field=models.CharField(blank=True, max_length=256, null=True, verbose_name='IVOA Utype'),
        ),
        migrations.AlterField(
            model_name='function',
            name='description',
            field=models.TextField(blank=True, help_text='A brief description of the function to be displayed in the user interface.', null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='function',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups which have access to this function.', to='auth.Group', verbose_name='Groups'),
        ),
        migrations.AlterField(
            model_name='function',
            name='name',
            field=models.CharField(help_text='Identifier of the function on the server.', max_length=256, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='function',
            name='order',
            field=models.IntegerField(blank=True, help_text='Position in lists.', null=True, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='function',
            name='query_string',
            field=models.CharField(help_text='Prototype of this function in a SQL query.', max_length=256),
        ),
        migrations.AlterField(
            model_name='table',
            name='attribution',
            field=models.TextField(blank=True, help_text='The desired attribution for the table.', null=True, verbose_name='Attribution'),
        ),
        migrations.AlterField(
            model_name='table',
            name='database',
            field=models.ForeignKey(help_text='Database the table belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='tables', to='daiquiri_metadata.Database', verbose_name='Database'),
        ),
        migrations.AlterField(
            model_name='table',
            name='description',
            field=models.TextField(blank=True, help_text='A brief description of the table to be displayed in the user interface.', null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='table',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups which have access to the table.', to='auth.Group', verbose_name='Groups'),
        ),
        migrations.AlterField(
            model_name='table',
            name='license',
            field=models.CharField(blank=True, choices=[(b'CC0', b'CC0 1.0 Universal (CC0 1.0)'), (b'PD', b'Public Domain Mark'), (b'BY', b'Attribution 4.0 International (CC BY 4.0)'), (b'BY_SA', b'Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)'), (b'BY_ND', b'Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)'), (b'BY_NC', b'Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)'), (b'BY_NC_SA', b'Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)'), (b'BY_NC_ND', b'Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0)')], max_length=8, null=True, verbose_name='License'),
        ),
        migrations.AlterField(
            model_name='table',
            name='long_description',
            field=models.TextField(blank=True, help_text='A more extensive description of the table to be displayed on the public database page.', null=True, verbose_name='Long description'),
        ),
        migrations.AlterField(
            model_name='table',
            name='name',
            field=models.CharField(help_text='Identifier of the table on the database server.', max_length=256, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='table',
            name='order',
            field=models.IntegerField(blank=True, help_text='Position in lists.', null=True, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='table',
            name='pid',
            field=models.URLField(blank=True, max_length=256, null=True, verbose_name='Persistent identifier'),
        ),
        migrations.AlterField(
            model_name='table',
            name='title',
            field=models.CharField(blank=True, help_text='Human readable title of the table.', max_length=256, null=True, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='table',
            name='type',
            field=models.CharField(choices=[(b'table', 'Table'), (b'view', 'View')], max_length=8, verbose_name='Type of table'),
        ),
        migrations.AlterField(
            model_name='table',
            name='utype',
            field=models.CharField(blank=True, max_length=256, null=True, verbose_name='IVOA Utype'),
        ),
    ]
