# DO NOT EDIT this file, it is automatically generated.
# 
# This file is only used as a code completion helper
# for editors, it is not used at runtime.

from typing import TypeAlias, Annotated
from enum import Enum, IntFlag
from wayland.proxy import Proxy
new_id: TypeAlias = int
object: TypeAlias = int
uint: TypeAlias = int
string: TypeAlias = str
fd: TypeAlias = int
array: TypeAlias = list
fixed: TypeAlias = float

def get_package_root() -> str:
    # Returns the directory that this project is sitting in

    ...

def initialise(auto: bool = None) -> None or Proxy:
    # Initialise the wayland connection

    ...

def process_messages() -> None:
    # Process incoming messages

    ...

class wl_display:
    """
    core global object
    The core global object.  This is a special singleton object.  It
    is used for internal Wayland protocol features.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_object: int
        invalid_method: int
        no_memory: int
        implementation: int

    @staticmethod
    def sync() -> wl_callback:
        """
        asynchronous roundtrip
        The sync request asks the server to emit the 'done' event
        on the returned wl_callback object.  Since requests are
        handled in-order and events are delivered in-order, this can
        be used as a barrier to ensure all previous requests and the
        resulting events have been handled.
        The object returned by this request will be destroyed by the
        compositor after the callback is fired and as such the client must not
        attempt to use it after that point.
        The callback_data passed in the callback is undefined and should be ignored.
        """

        ...

    @staticmethod
    def get_registry() -> wl_registry:
        """
        get global registry object
        This request creates a registry object that allows the client
        to list and bind the global objects available from the
        compositor.
        It should be noted that the server side resources consumed in
        response to a get_registry request can only be released when the
        client disconnects, not when the client side proxy is destroyed.
        Therefore, clients should invoke get_registry as infrequently as
        possible to avoid wasting memory.
        """

        ...
    class events:
        @staticmethod
        def error(object_id: object, code: uint, message: string) -> None:
            """
            fatal error event
            The error event is sent out when a fatal (non-recoverable)
            error has occurred.  The object_id argument is the object
            where the error occurred, most often in response to a request
            to that object.  The code identifies the error and is defined
            by the object interface.  As such, each interface defines its
            own set of error codes.  The message is a brief description
            of the error, for (debugging) convenience.
            """

            ...

        @staticmethod
        def delete_id(id: uint) -> None:
            """
            acknowledge object ID deletion
            This event is used internally by the object ID management
            logic. When a client deletes an object that it had created,
            the server will send this event to acknowledge that it has
            seen the delete request. When the client receives this event,
            it will know that it can safely reuse the object ID.
            """

            ...
class wl_registry:
    """
    global registry object
    The singleton global registry object.  The server has a number of
    global objects that are available to all clients.  These objects
    typically represent an actual object in the server (for example,
    an input device) or they are singleton objects that provide
    extension functionality.
    When a client creates a registry object, the registry object
    will emit a global event for each global currently in the
    registry.  Globals come and go as a result of device or
    monitor hotplugs, reconfiguration or other events, and the
    registry will send out global and global_remove events to
    keep the client up to date with the changes.  To mark the end
    of the initial burst of events, the client can use the
    wl_display.sync request immediately after calling
    wl_display.get_registry.
    A client can bind to a global object by using the bind
    request.  This creates a client-side handle that lets the object
    emit events to the client and lets the client invoke requests on
    the object.
    """
    object_id = 0
    version = 1

    @staticmethod
    def bind(name: uint, interface: string, version: uint, id: new_id) -> None:
        """
        bind an object to the display
        Binds a new, client-created object to the server using the
        specified name as the identifier.
        """

        ...
    class events:
        @staticmethod
        def global_(name: uint, interface: string, version: uint) -> None:
            """
            announce global object
            Notify the client of global objects.
            The event notifies the client that a global object with
            the given name is now available, and it implements the
            given version of the given interface.
            """

            ...

        @staticmethod
        def global_remove(name: uint) -> None:
            """
            announce removal of global object
            Notify the client of removed global objects.
            This event notifies the client that the global identified
            by name is no longer available.  If the client bound to
            the global using the bind request, the client should now
            destroy that object.
            The object remains valid and requests to the object will be
            ignored until the client destroys it, to avoid races between
            the global going away and a client sending a request to it.
            """

            ...
class wl_compositor:
    """
    the compositor singleton
    A compositor.  This object is a singleton global.  The
    compositor is in charge of combining the contents of multiple
    surfaces into one displayable output.
    """
    object_id = 0
    version = 6

    @staticmethod
    def create_surface() -> wl_surface:
        """
        create new surface
        Ask the compositor to create a new surface.
        """

        ...

    @staticmethod
    def create_region() -> wl_region:
        """
        create new region
        Ask the compositor to create a new region.
        """

        ...
class wl_shm_pool:
    """
    a shared memory pool
    The wl_shm_pool object encapsulates a piece of memory shared
    between the compositor and client.  Through the wl_shm_pool
    object, the client can allocate shared memory wl_buffer objects.
    All objects created through the same pool share the same
    underlying mapped memory. Reusing the mapped memory avoids the
    setup/teardown overhead and is useful when interactively resizing
    a surface or for many small buffers.
    """
    object_id = 0
    version = 2

    @staticmethod
    def create_buffer(offset: int, width: int, height: int, stride: int, format: wl_shm_pool.wl_shm.format) -> wl_buffer:
        """
        create a buffer from the pool
        Create a wl_buffer object from the pool.
        The buffer is created offset bytes into the pool and has
        width and height as specified.  The stride argument specifies
        the number of bytes from the beginning of one row to the beginning
        of the next.  The format is the pixel format of the buffer and
        must be one of those advertised through the wl_shm.format event.
        A buffer will keep a reference to the pool it was created from
        so it is valid to destroy the pool immediately after creating
        a buffer from it.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the pool
        Destroy the shared memory pool.
        The mmapped memory will be released when all
        buffers that have been created from this pool
        are gone.
        """

        ...

    @staticmethod
    def resize(size: int) -> None:
        """
        change the size of the pool mapping
        This request will cause the server to remap the backing memory
        for the pool from the file descriptor passed when the pool was
        created, but using the new size.  This request can only be
        used to make the pool bigger.
        This request only changes the amount of bytes that are mmapped
        by the server and does not touch the file corresponding to the
        file descriptor passed at creation time. It is the client's
        responsibility to ensure that the file is at least as big as
        the new pool size.
        """

        ...
class wl_shm:
    """
    shared memory support
    A singleton global object that provides support for shared
    memory.
    Clients can create wl_shm_pool objects using the create_pool
    request.
    On binding the wl_shm object one or more format events
    are emitted to inform clients about the valid pixel formats
    that can be used for buffers.
    """
    object_id = 0
    version = 2

    class error(Enum):
        invalid_format: int
        invalid_stride: int
        invalid_fd: int


    class format(Enum):
        argb8888: int
        xrgb8888: int
        c8: int
        rgb332: int
        bgr233: int
        xrgb4444: int
        xbgr4444: int
        rgbx4444: int
        bgrx4444: int
        argb4444: int
        abgr4444: int
        rgba4444: int
        bgra4444: int
        xrgb1555: int
        xbgr1555: int
        rgbx5551: int
        bgrx5551: int
        argb1555: int
        abgr1555: int
        rgba5551: int
        bgra5551: int
        rgb565: int
        bgr565: int
        rgb888: int
        bgr888: int
        xbgr8888: int
        rgbx8888: int
        bgrx8888: int
        abgr8888: int
        rgba8888: int
        bgra8888: int
        xrgb2101010: int
        xbgr2101010: int
        rgbx1010102: int
        bgrx1010102: int
        argb2101010: int
        abgr2101010: int
        rgba1010102: int
        bgra1010102: int
        yuyv: int
        yvyu: int
        uyvy: int
        vyuy: int
        ayuv: int
        nv12: int
        nv21: int
        nv16: int
        nv61: int
        yuv410: int
        yvu410: int
        yuv411: int
        yvu411: int
        yuv420: int
        yvu420: int
        yuv422: int
        yvu422: int
        yuv444: int
        yvu444: int
        r8: int
        r16: int
        rg88: int
        gr88: int
        rg1616: int
        gr1616: int
        xrgb16161616f: int
        xbgr16161616f: int
        argb16161616f: int
        abgr16161616f: int
        xyuv8888: int
        vuy888: int
        vuy101010: int
        y210: int
        y212: int
        y216: int
        y410: int
        y412: int
        y416: int
        xvyu2101010: int
        xvyu12_16161616: int
        xvyu16161616: int
        y0l0: int
        x0l0: int
        y0l2: int
        x0l2: int
        yuv420_8bit: int
        yuv420_10bit: int
        xrgb8888_a8: int
        xbgr8888_a8: int
        rgbx8888_a8: int
        bgrx8888_a8: int
        rgb888_a8: int
        bgr888_a8: int
        rgb565_a8: int
        bgr565_a8: int
        nv24: int
        nv42: int
        p210: int
        p010: int
        p012: int
        p016: int
        axbxgxrx106106106106: int
        nv15: int
        q410: int
        q401: int
        xrgb16161616: int
        xbgr16161616: int
        argb16161616: int
        abgr16161616: int
        c1: int
        c2: int
        c4: int
        d1: int
        d2: int
        d4: int
        d8: int
        r1: int
        r2: int
        r4: int
        r10: int
        r12: int
        avuy8888: int
        xvuy8888: int
        p030: int

    @staticmethod
    def create_pool(fd: fd, size: int) -> wl_shm_pool:
        """
        create a shm pool
        Create a new wl_shm_pool object.
        The pool can be used to create shared memory based buffer
        objects.  The server will mmap size bytes of the passed file
        descriptor, to use as backing memory for the pool.
        """

        ...

    @staticmethod
    def release() -> None:
        """
        release the shm object
        Using this request a client can tell the server that it is not going to
        use the shm object anymore.
        Objects created via this interface remain unaffected.
        """

        ...
    class events:
        @staticmethod
        def format(format: wl_shm.format) -> None:
            """
            pixel format description
            Informs the client about a valid pixel format that
            can be used for buffers. Known formats include
            argb8888 and xrgb8888.
            """

            ...
class wl_buffer:
    """
    content for a wl_surface
    A buffer provides the content for a wl_surface. Buffers are
    created through factory interfaces such as wl_shm, wp_linux_buffer_params
    (from the linux-dmabuf protocol extension) or similar. It has a width and
    a height and can be attached to a wl_surface, but the mechanism by which a
    client provides and updates the contents is defined by the buffer factory
    interface.
    Color channels are assumed to be electrical rather than optical (in other
    words, encoded with a transfer function) unless otherwise specified. If
    the buffer uses a format that has an alpha channel, the alpha channel is
    assumed to be premultiplied into the electrical color channel values
    (after transfer function encoding) unless otherwise specified.
    Note, because wl_buffer objects are created from multiple independent
    factory interfaces, the wl_buffer interface is frozen at version 1.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy a buffer
        Destroy a buffer. If and how you need to release the backing
        storage is defined by the buffer factory interface.
        For possible side-effects to a surface, see wl_surface.attach.
        """

        ...
    class events:
        @staticmethod
        def release() -> None:
            """
            compositor releases buffer
            Sent when this wl_buffer is no longer used by the compositor.
            The client is now free to reuse or destroy this buffer and its
            backing storage.
            If a client receives a release event before the frame callback
            requested in the same wl_surface.commit that attaches this
            wl_buffer to a surface, then the client is immediately free to
            reuse the buffer and its backing storage, and does not need a
            second buffer for the next surface content update. Typically
            this is possible, when the compositor maintains a copy of the
            wl_surface contents, e.g. as a GL texture. This is an important
            optimization for GL(ES) compositors with wl_shm clients.
            """

            ...
class wl_data_offer:
    """
    offer to transfer data
    A wl_data_offer represents a piece of data offered for transfer
    by another client (the source client).  It is used by the
    copy-and-paste and drag-and-drop mechanisms.  The offer
    describes the different mime types that the data can be
    converted to and provides the mechanism for transferring the
    data directly from the source client.
    """
    object_id = 0
    version = 3

    class error(Enum):
        invalid_finish: int
        invalid_action_mask: int
        invalid_action: int
        invalid_offer: int

    @staticmethod
    def accept(serial: uint, mime_type: string) -> None:
        """
        accept one of the offered mime types
        Indicate that the client can accept the given mime type, or
        NULL for not accepted.
        For objects of version 2 or older, this request is used by the
        client to give feedback whether the client can receive the given
        mime type, or NULL if none is accepted; the feedback does not
        determine whether the drag-and-drop operation succeeds or not.
        For objects of version 3 or newer, this request determines the
        final result of the drag-and-drop operation. If the end result
        is that no mime types were accepted, the drag-and-drop operation
        will be cancelled and the corresponding drag source will receive
        wl_data_source.cancelled. Clients may still use this event in
        conjunction with wl_data_source.action for feedback.
        """

        ...

    @staticmethod
    def receive(mime_type: string, fd: fd) -> None:
        """
        request that the data is transferred
        To transfer the offered data, the client issues this request
        and indicates the mime type it wants to receive.  The transfer
        happens through the passed file descriptor (typically created
        with the pipe system call).  The source client writes the data
        in the mime type representation requested and then closes the
        file descriptor.
        The receiving client reads from the read end of the pipe until
        EOF and then closes its end, at which point the transfer is
        complete.
        This request may happen multiple times for different mime types,
        both before and after wl_data_device.drop. Drag-and-drop destination
        clients may preemptively fetch data or examine it more closely to
        determine acceptance.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy data offer
        Destroy the data offer.
        """

        ...

    @staticmethod
    def finish() -> None:
        """
        the offer will no longer be used
        Notifies the compositor that the drag destination successfully
        finished the drag-and-drop operation.
        Upon receiving this request, the compositor will emit
        wl_data_source.dnd_finished on the drag source client.
        It is a client error to perform other requests than
        wl_data_offer.destroy after this one. It is also an error to perform
        this request after a NULL mime type has been set in
        wl_data_offer.accept or no action was received through
        wl_data_offer.action.
        If wl_data_offer.finish request is received for a non drag and drop
        operation, the invalid_finish protocol error is raised.
        """

        ...

    @staticmethod
    def set_actions(dnd_actions: wl_data_offer.wl_data_device_manager.dnd_action, preferred_action: wl_data_offer.wl_data_device_manager.dnd_action) -> None:
        """
        set the available/preferred drag-and-drop actions
        Sets the actions that the destination side client supports for
        this operation. This request may trigger the emission of
        wl_data_source.action and wl_data_offer.action events if the compositor
        needs to change the selected action.
        This request can be called multiple times throughout the
        drag-and-drop operation, typically in response to wl_data_device.enter
        or wl_data_device.motion events.
        This request determines the final result of the drag-and-drop
        operation. If the end result is that no action is accepted,
        the drag source will receive wl_data_source.cancelled.
        The dnd_actions argument must contain only values expressed in the
        wl_data_device_manager.dnd_actions enum, and the preferred_action
        argument must only contain one of those values set, otherwise it
        will result in a protocol error.
        While managing an "ask" action, the destination drag-and-drop client
        may perform further wl_data_offer.receive requests, and is expected
        to perform one last wl_data_offer.set_actions request with a preferred
        action other than "ask" (and optionally wl_data_offer.accept) before
        requesting wl_data_offer.finish, in order to convey the action selected
        by the user. If the preferred action is not in the
        wl_data_offer.source_actions mask, an error will be raised.
        If the "ask" action is dismissed (e.g. user cancellation), the client
        is expected to perform wl_data_offer.destroy right away.
        This request can only be made on drag-and-drop offers, a protocol error
        will be raised otherwise.
        """

        ...
    class events:
        @staticmethod
        def offer(mime_type: string) -> None:
            """
            advertise offered mime type
            Sent immediately after creating the wl_data_offer object.  One
            event per offered mime type.
            """

            ...

        @staticmethod
        def source_actions(source_actions: wl_data_offer.wl_data_device_manager.dnd_action) -> None:
            """
            notify the source-side available actions
            This event indicates the actions offered by the data source. It
            will be sent immediately after creating the wl_data_offer object,
            or anytime the source side changes its offered actions through
            wl_data_source.set_actions.
            """

            ...

        @staticmethod
        def action(dnd_action: wl_data_offer.wl_data_device_manager.dnd_action) -> None:
            """
            notify the selected action
            This event indicates the action selected by the compositor after
            matching the source/destination side actions. Only one action (or
            none) will be offered here.
            This event can be emitted multiple times during the drag-and-drop
            operation in response to destination side action changes through
            wl_data_offer.set_actions.
            This event will no longer be emitted after wl_data_device.drop
            happened on the drag-and-drop destination, the client must
            honor the last action received, or the last preferred one set
            through wl_data_offer.set_actions when handling an "ask" action.
            Compositors may also change the selected action on the fly, mainly
            in response to keyboard modifier changes during the drag-and-drop
            operation.
            The most recent action received is always the valid one. Prior to
            receiving wl_data_device.drop, the chosen action may change (e.g.
            due to keyboard modifiers being pressed). At the time of receiving
            wl_data_device.drop the drag-and-drop destination must honor the
            last action received.
            Action changes may still happen after wl_data_device.drop,
            especially on "ask" actions, where the drag-and-drop destination
            may choose another action afterwards. Action changes happening
            at this stage are always the result of inter-client negotiation, the
            compositor shall no longer be able to induce a different action.
            Upon "ask" actions, it is expected that the drag-and-drop destination
            may potentially choose a different action and/or mime type,
            based on wl_data_offer.source_actions and finally chosen by the
            user (e.g. popping up a menu with the available options). The
            final wl_data_offer.set_actions and wl_data_offer.accept requests
            must happen before the call to wl_data_offer.finish.
            """

            ...
class wl_data_source:
    """
    offer to transfer data
    The wl_data_source object is the source side of a wl_data_offer.
    It is created by the source client in a data transfer and
    provides a way to describe the offered data and a way to respond
    to requests to transfer the data.
    """
    object_id = 0
    version = 3

    class error(Enum):
        invalid_action_mask: int
        invalid_source: int

    @staticmethod
    def offer(mime_type: string) -> None:
        """
        add an offered mime type
        This request adds a mime type to the set of mime types
        advertised to targets.  Can be called several times to offer
        multiple types.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the data source
        Destroy the data source.
        """

        ...

    @staticmethod
    def set_actions(dnd_actions: wl_data_source.wl_data_device_manager.dnd_action) -> None:
        """
        set the available drag-and-drop actions
        Sets the actions that the source side client supports for this
        operation. This request may trigger wl_data_source.action and
        wl_data_offer.action events if the compositor needs to change the
        selected action.
        The dnd_actions argument must contain only values expressed in the
        wl_data_device_manager.dnd_actions enum, otherwise it will result
        in a protocol error.
        This request must be made once only, and can only be made on sources
        used in drag-and-drop, so it must be performed before
        wl_data_device.start_drag. Attempting to use the source other than
        for drag-and-drop will raise a protocol error.
        """

        ...
    class events:
        @staticmethod
        def target(mime_type: string) -> None:
            """
            a target accepts an offered mime type
            Sent when a target accepts pointer_focus or motion events.  If
            a target does not accept any of the offered types, type is NULL.
            Used for feedback during drag-and-drop.
            """

            ...

        @staticmethod
        def send(mime_type: string, fd: fd) -> None:
            """
            send the data
            Request for data from the client.  Send the data as the
            specified mime type over the passed file descriptor, then
            close it.
            """

            ...

        @staticmethod
        def cancelled() -> None:
            """
            selection was cancelled
            This data source is no longer valid. There are several reasons why
            this could happen:
            - The data source has been replaced by another data source.
            - The drag-and-drop operation was performed, but the drop destination
            did not accept any of the mime types offered through
            wl_data_source.target.
            - The drag-and-drop operation was performed, but the drop destination
            did not select any of the actions present in the mask offered through
            wl_data_source.action.
            - The drag-and-drop operation was performed but didn't happen over a
            surface.
            - The compositor cancelled the drag-and-drop operation (e.g. compositor
            dependent timeouts to avoid stale drag-and-drop transfers).
            The client should clean up and destroy this data source.
            For objects of version 2 or older, wl_data_source.cancelled will
            only be emitted if the data source was replaced by another data
            source.
            """

            ...

        @staticmethod
        def dnd_drop_performed() -> None:
            """
            the drag-and-drop operation physically finished
            The user performed the drop action. This event does not indicate
            acceptance, wl_data_source.cancelled may still be emitted afterwards
            if the drop destination does not accept any mime type.
            However, this event might however not be received if the compositor
            cancelled the drag-and-drop operation before this event could happen.
            Note that the data_source may still be used in the future and should
            not be destroyed here.
            """

            ...

        @staticmethod
        def dnd_finished() -> None:
            """
            the drag-and-drop operation concluded
            The drop destination finished interoperating with this data
            source, so the client is now free to destroy this data source and
            free all associated data.
            If the action used to perform the operation was "move", the
            source can now delete the transferred data.
            """

            ...

        @staticmethod
        def action(dnd_action: wl_data_source.wl_data_device_manager.dnd_action) -> None:
            """
            notify the selected action
            This event indicates the action selected by the compositor after
            matching the source/destination side actions. Only one action (or
            none) will be offered here.
            This event can be emitted multiple times during the drag-and-drop
            operation, mainly in response to destination side changes through
            wl_data_offer.set_actions, and as the data device enters/leaves
            surfaces.
            It is only possible to receive this event after
            wl_data_source.dnd_drop_performed if the drag-and-drop operation
            ended in an "ask" action, in which case the final wl_data_source.action
            event will happen immediately before wl_data_source.dnd_finished.
            Compositors may also change the selected action on the fly, mainly
            in response to keyboard modifier changes during the drag-and-drop
            operation.
            The most recent action received is always the valid one. The chosen
            action may change alongside negotiation (e.g. an "ask" action can turn
            into a "move" operation), so the effects of the final action must
            always be applied in wl_data_offer.dnd_finished.
            Clients can trigger cursor surface changes from this point, so
            they reflect the current action.
            """

            ...
class wl_data_device:
    """
    data transfer device
    There is one wl_data_device per seat which can be obtained
    from the global wl_data_device_manager singleton.
    A wl_data_device provides access to inter-client data transfer
    mechanisms such as copy-and-paste and drag-and-drop.
    """
    object_id = 0
    version = 3

    class error(Enum):
        role: int
        used_source: int

    @staticmethod
    def start_drag(source: object, origin: object, icon: object, serial: uint) -> None:
        """
        start drag-and-drop operation
        This request asks the compositor to start a drag-and-drop
        operation on behalf of the client.
        The source argument is the data source that provides the data
        for the eventual data transfer. If source is NULL, enter, leave
        and motion events are sent only to the client that initiated the
        drag and the client is expected to handle the data passing
        internally. If source is destroyed, the drag-and-drop session will be
        cancelled.
        The origin surface is the surface where the drag originates and
        the client must have an active implicit grab that matches the
        serial.
        The icon surface is an optional (can be NULL) surface that
        provides an icon to be moved around with the cursor.  Initially,
        the top-left corner of the icon surface is placed at the cursor
        hotspot, but subsequent wl_surface.offset requests can move the
        relative position. Attach requests must be confirmed with
        wl_surface.commit as usual. The icon surface is given the role of
        a drag-and-drop icon. If the icon surface already has another role,
        it raises a protocol error.
        The input region is ignored for wl_surfaces with the role of a
        drag-and-drop icon.
        The given source may not be used in any further set_selection or
        start_drag requests. Attempting to reuse a previously-used source
        may send a used_source error.
        """

        ...

    @staticmethod
    def set_selection(source: object, serial: uint) -> None:
        """
        copy data to the selection
        This request asks the compositor to set the selection
        to the data from the source on behalf of the client.
        To unset the selection, set the source to NULL.
        The given source may not be used in any further set_selection or
        start_drag requests. Attempting to reuse a previously-used source
        may send a used_source error.
        """

        ...

    @staticmethod
    def release() -> None:
        """
        destroy data device
        This request destroys the data device.
        """

        ...
    class events:
        @staticmethod
        def data_offer(id: wl_data_offer) -> None:
            """
            introduce a new wl_data_offer
            The data_offer event introduces a new wl_data_offer object,
            which will subsequently be used in either the
            data_device.enter event (for drag-and-drop) or the
            data_device.selection event (for selections).  Immediately
            following the data_device.data_offer event, the new data_offer
            object will send out data_offer.offer events to describe the
            mime types it offers.
            """

            ...

        @staticmethod
        def enter(serial: uint, surface: object, x: fixed, y: fixed, id: object) -> None:
            """
            initiate drag-and-drop session
            This event is sent when an active drag-and-drop pointer enters
            a surface owned by the client.  The position of the pointer at
            enter time is provided by the x and y arguments, in surface-local
            coordinates.
            """

            ...

        @staticmethod
        def leave() -> None:
            """
            end drag-and-drop session
            This event is sent when the drag-and-drop pointer leaves the
            surface and the session ends.  The client must destroy the
            wl_data_offer introduced at enter time at this point.
            """

            ...

        @staticmethod
        def motion(time: uint, x: fixed, y: fixed) -> None:
            """
            drag-and-drop session motion
            This event is sent when the drag-and-drop pointer moves within
            the currently focused surface. The new position of the pointer
            is provided by the x and y arguments, in surface-local
            coordinates.
            """

            ...

        @staticmethod
        def drop() -> None:
            """
            end drag-and-drop session successfully
            The event is sent when a drag-and-drop operation is ended
            because the implicit grab is removed.
            The drag-and-drop destination is expected to honor the last action
            received through wl_data_offer.action, if the resulting action is
            "copy" or "move", the destination can still perform
            wl_data_offer.receive requests, and is expected to end all
            transfers with a wl_data_offer.finish request.
            If the resulting action is "ask", the action will not be considered
            final. The drag-and-drop destination is expected to perform one last
            wl_data_offer.set_actions request, or wl_data_offer.destroy in order
            to cancel the operation.
            """

            ...

        @staticmethod
        def selection(id: object) -> None:
            """
            advertise new selection
            The selection event is sent out to notify the client of a new
            wl_data_offer for the selection for this device.  The
            data_device.data_offer and the data_offer.offer events are
            sent out immediately before this event to introduce the data
            offer object.  The selection event is sent to a client
            immediately before receiving keyboard focus and when a new
            selection is set while the client has keyboard focus.  The
            data_offer is valid until a new data_offer or NULL is received
            or until the client loses keyboard focus.  Switching surface with
            keyboard focus within the same client doesn't mean a new selection
            will be sent.  The client must destroy the previous selection
            data_offer, if any, upon receiving this event.
            """

            ...
class wl_data_device_manager:
    """
    data transfer interface
    The wl_data_device_manager is a singleton global object that
    provides access to inter-client data transfer mechanisms such as
    copy-and-paste and drag-and-drop.  These mechanisms are tied to
    a wl_seat and this interface lets a client get a wl_data_device
    corresponding to a wl_seat.
    Depending on the version bound, the objects created from the bound
    wl_data_device_manager object will have different requirements for
    functioning properly. See wl_data_source.set_actions,
    wl_data_offer.accept and wl_data_offer.finish for details.
    """
    object_id = 0
    version = 3

    class dnd_action(IntFlag):
        none: int
        copy: int
        move: int
        ask: int

    @staticmethod
    def create_data_source() -> wl_data_source:
        """
        create a new data source
        Create a new data source.
        """

        ...

    @staticmethod
    def get_data_device(seat: object) -> wl_data_device:
        """
        create a new data device
        Create a new data device for a given seat.
        """

        ...
class wl_shell:
    """
    create desktop-style surfaces
    This interface is implemented by servers that provide
    desktop-style user interfaces.
    It allows clients to associate a wl_shell_surface with
    a basic surface.
    Note! This protocol is deprecated and not intended for production use.
    For desktop-style user interfaces, use xdg_shell. Compositors and clients
    should not implement this interface.
    """
    object_id = 0
    version = 1

    class error(Enum):
        role: int

    @staticmethod
    def get_shell_surface(surface: object) -> wl_shell_surface:
        """
        create a shell surface from a surface
        Create a shell surface for an existing surface. This gives
        the wl_surface the role of a shell surface. If the wl_surface
        already has another role, it raises a protocol error.
        Only one shell surface can be associated with a given surface.
        """

        ...
class wl_shell_surface:
    """
    desktop-style metadata interface
    An interface that may be implemented by a wl_surface, for
    implementations that provide a desktop-style user interface.
    It provides requests to treat surfaces like toplevel, fullscreen
    or popup windows, move, resize or maximize them, associate
    metadata like title and class, etc.
    On the server side the object is automatically destroyed when
    the related wl_surface is destroyed. On the client side,
    wl_shell_surface_destroy() must be called before destroying
    the wl_surface object.
    """
    object_id = 0
    version = 1

    class resize(IntFlag):
        none: int
        top: int
        bottom: int
        left: int
        top_left: int
        bottom_left: int
        right: int
        top_right: int
        bottom_right: int


    class transient(IntFlag):
        inactive: int


    class fullscreen_method(Enum):
        default: int
        scale: int
        driver: int
        fill: int

    @staticmethod
    def pong(serial: uint) -> None:
        """
        respond to a ping event
        A client must respond to a ping event with a pong request or
        the client may be deemed unresponsive.
        """

        ...

    @staticmethod
    def move(seat: object, serial: uint) -> None:
        """
        start an interactive move
        Start a pointer-driven move of the surface.
        This request must be used in response to a button press event.
        The server may ignore move requests depending on the state of
        the surface (e.g. fullscreen or maximized).
        """

        ...

    @staticmethod
    def resize(seat: object, serial: uint, edges: wl_shell_surface.resize) -> None:
        """
        start an interactive resize
        Start a pointer-driven resizing of the surface.
        This request must be used in response to a button press event.
        The server may ignore resize requests depending on the state of
        the surface (e.g. fullscreen or maximized).
        """

        ...

    @staticmethod
    def set_toplevel() -> None:
        """
        make the surface a toplevel surface
        Map the surface as a toplevel surface.
        A toplevel surface is not fullscreen, maximized or transient.
        """

        ...

    @staticmethod
    def set_transient(parent: object, x: int, y: int, flags: wl_shell_surface.transient) -> None:
        """
        make the surface a transient surface
        Map the surface relative to an existing surface.
        The x and y arguments specify the location of the upper left
        corner of the surface relative to the upper left corner of the
        parent surface, in surface-local coordinates.
        The flags argument controls details of the transient behaviour.
        """

        ...

    @staticmethod
    def set_fullscreen(method: wl_shell_surface.fullscreen_method, framerate: uint, output: object) -> None:
        """
        make the surface a fullscreen surface
        Map the surface as a fullscreen surface.
        If an output parameter is given then the surface will be made
        fullscreen on that output. If the client does not specify the
        output then the compositor will apply its policy - usually
        choosing the output on which the surface has the biggest surface
        area.
        The client may specify a method to resolve a size conflict
        between the output size and the surface size - this is provided
        through the method parameter.
        The framerate parameter is used only when the method is set
        to "driver", to indicate the preferred framerate. A value of 0
        indicates that the client does not care about framerate.  The
        framerate is specified in mHz, that is framerate of 60000 is 60Hz.
        A method of "scale" or "driver" implies a scaling operation of
        the surface, either via a direct scaling operation or a change of
        the output mode. This will override any kind of output scaling, so
        that mapping a surface with a buffer size equal to the mode can
        fill the screen independent of buffer_scale.
        A method of "fill" means we don't scale up the buffer, however
        any output scale is applied. This means that you may run into
        an edge case where the application maps a buffer with the same
        size of the output mode but buffer_scale 1 (thus making a
        surface larger than the output). In this case it is allowed to
        downscale the results to fit the screen.
        The compositor must reply to this request with a configure event
        with the dimensions for the output on which the surface will
        be made fullscreen.
        """

        ...

    @staticmethod
    def set_popup(seat: object, serial: uint, parent: object, x: int, y: int, flags: wl_shell_surface.transient) -> None:
        """
        make the surface a popup surface
        Map the surface as a popup.
        A popup surface is a transient surface with an added pointer
        grab.
        An existing implicit grab will be changed to owner-events mode,
        and the popup grab will continue after the implicit grab ends
        (i.e. releasing the mouse button does not cause the popup to
        be unmapped).
        The popup grab continues until the window is destroyed or a
        mouse button is pressed in any other client's window. A click
        in any of the client's surfaces is reported as normal, however,
        clicks in other clients' surfaces will be discarded and trigger
        the callback.
        The x and y arguments specify the location of the upper left
        corner of the surface relative to the upper left corner of the
        parent surface, in surface-local coordinates.
        """

        ...

    @staticmethod
    def set_maximized(output: object) -> None:
        """
        make the surface a maximized surface
        Map the surface as a maximized surface.
        If an output parameter is given then the surface will be
        maximized on that output. If the client does not specify the
        output then the compositor will apply its policy - usually
        choosing the output on which the surface has the biggest surface
        area.
        The compositor will reply with a configure event telling
        the expected new surface size. The operation is completed
        on the next buffer attach to this surface.
        A maximized surface typically fills the entire output it is
        bound to, except for desktop elements such as panels. This is
        the main difference between a maximized shell surface and a
        fullscreen shell surface.
        The details depend on the compositor implementation.
        """

        ...

    @staticmethod
    def set_title(title: string) -> None:
        """
        set surface title
        Set a short title for the surface.
        This string may be used to identify the surface in a task bar,
        window list, or other user interface elements provided by the
        compositor.
        The string must be encoded in UTF-8.
        """

        ...

    @staticmethod
    def set_class(class_: string) -> None:
        """
        set surface class
        Set a class for the surface.
        The surface class identifies the general class of applications
        to which the surface belongs. A common convention is to use the
        file name (or the full path if it is a non-standard location) of
        the application's .desktop file as the class.
        """

        ...
    class events:
        @staticmethod
        def ping(serial: uint) -> None:
            """
            ping client
            Ping a client to check if it is receiving events and sending
            requests. A client is expected to reply with a pong request.
            """

            ...

        @staticmethod
        def configure(edges: wl_shell_surface.resize, width: int, height: int) -> None:
            """
            suggest resize
            The configure event asks the client to resize its surface.
            The size is a hint, in the sense that the client is free to
            ignore it if it doesn't resize, pick a smaller size (to
            satisfy aspect ratio or resize in steps of NxM pixels).
            The edges parameter provides a hint about how the surface
            was resized. The client may use this information to decide
            how to adjust its content to the new size (e.g. a scrolling
            area might adjust its content position to leave the viewable
            content unmoved).
            The client is free to dismiss all but the last configure
            event it received.
            The width and height arguments specify the size of the window
            in surface-local coordinates.
            """

            ...

        @staticmethod
        def popup_done() -> None:
            """
            popup interaction is done
            The popup_done event is sent out when a popup grab is broken,
            that is, when the user clicks a surface that doesn't belong
            to the client owning the popup surface.
            """

            ...
class wl_surface:
    """
    an onscreen surface
    A surface is a rectangular area that may be displayed on zero
    or more outputs, and shown any number of times at the compositor's
    discretion. They can present wl_buffers, receive user input, and
    define a local coordinate system.
    The size of a surface (and relative positions on it) is described
    in surface-local coordinates, which may differ from the buffer
    coordinates of the pixel content, in case a buffer_transform
    or a buffer_scale is used.
    A surface without a "role" is fairly useless: a compositor does
    not know where, when or how to present it. The role is the
    purpose of a wl_surface. Examples of roles are a cursor for a
    pointer (as set by wl_pointer.set_cursor), a drag icon
    (wl_data_device.start_drag), a sub-surface
    (wl_subcompositor.get_subsurface), and a window as defined by a
    shell protocol (e.g. wl_shell.get_shell_surface).
    A surface can have only one role at a time. Initially a
    wl_surface does not have a role. Once a wl_surface is given a
    role, it is set permanently for the whole lifetime of the
    wl_surface object. Giving the current role again is allowed,
    unless explicitly forbidden by the relevant interface
    specification.
    Surface roles are given by requests in other interfaces such as
    wl_pointer.set_cursor. The request should explicitly mention
    that this request gives a role to a wl_surface. Often, this
    request also creates a new protocol object that represents the
    role and adds additional functionality to wl_surface. When a
    client wants to destroy a wl_surface, they must destroy this role
    object before the wl_surface, otherwise a defunct_role_object error is
    sent.
    Destroying the role object does not remove the role from the
    wl_surface, but it may stop the wl_surface from "playing the role".
    For instance, if a wl_subsurface object is destroyed, the wl_surface
    it was created for will be unmapped and forget its position and
    z-order. It is allowed to create a wl_subsurface for the same
    wl_surface again, but it is not allowed to use the wl_surface as
    a cursor (cursor is a different role than sub-surface, and role
    switching is not allowed).
    """
    object_id = 0
    version = 6

    class error(Enum):
        invalid_scale: int
        invalid_transform: int
        invalid_size: int
        invalid_offset: int
        defunct_role_object: int

    @staticmethod
    def destroy() -> None:
        """
        delete surface
        Deletes the surface and invalidates its object ID.
        """

        ...

    @staticmethod
    def attach(buffer: object, x: int, y: int) -> None:
        """
        set the surface contents
        Set a buffer as the content of this surface.
        The new size of the surface is calculated based on the buffer
        size transformed by the inverse buffer_transform and the
        inverse buffer_scale. This means that at commit time the supplied
        buffer size must be an integer multiple of the buffer_scale. If
        that's not the case, an invalid_size error is sent.
        The x and y arguments specify the location of the new pending
        buffer's upper left corner, relative to the current buffer's upper
        left corner, in surface-local coordinates. In other words, the
        x and y, combined with the new surface size define in which
        directions the surface's size changes. Setting anything other than 0
        as x and y arguments is discouraged, and should instead be replaced
        with using the separate wl_surface.offset request.
        When the bound wl_surface version is 5 or higher, passing any
        non-zero x or y is a protocol violation, and will result in an
        'invalid_offset' error being raised. The x and y arguments are ignored
        and do not change the pending state. To achieve equivalent semantics,
        use wl_surface.offset.
        Surface contents are double-buffered state, see wl_surface.commit.
        The initial surface contents are void; there is no content.
        wl_surface.attach assigns the given wl_buffer as the pending
        wl_buffer. wl_surface.commit makes the pending wl_buffer the new
        surface contents, and the size of the surface becomes the size
        calculated from the wl_buffer, as described above. After commit,
        there is no pending buffer until the next attach.
        Committing a pending wl_buffer allows the compositor to read the
        pixels in the wl_buffer. The compositor may access the pixels at
        any time after the wl_surface.commit request. When the compositor
        will not access the pixels anymore, it will send the
        wl_buffer.release event. Only after receiving wl_buffer.release,
        the client may reuse the wl_buffer. A wl_buffer that has been
        attached and then replaced by another attach instead of committed
        will not receive a release event, and is not used by the
        compositor.
        If a pending wl_buffer has been committed to more than one wl_surface,
        the delivery of wl_buffer.release events becomes undefined. A well
        behaved client should not rely on wl_buffer.release events in this
        case. Alternatively, a client could create multiple wl_buffer objects
        from the same backing storage or use wp_linux_buffer_release.
        Destroying the wl_buffer after wl_buffer.release does not change
        the surface contents. Destroying the wl_buffer before wl_buffer.release
        is allowed as long as the underlying buffer storage isn't re-used (this
        can happen e.g. on client process termination). However, if the client
        destroys the wl_buffer before receiving the wl_buffer.release event and
        mutates the underlying buffer storage, the surface contents become
        undefined immediately.
        If wl_surface.attach is sent with a NULL wl_buffer, the
        following wl_surface.commit will remove the surface content.
        If a pending wl_buffer has been destroyed, the result is not specified.
        Many compositors are known to remove the surface content on the following
        wl_surface.commit, but this behaviour is not universal. Clients seeking to
        maximise compatibility should not destroy pending buffers and should
        ensure that they explicitly remove content from surfaces, even after
        destroying buffers.
        """

        ...

    @staticmethod
    def damage(x: int, y: int, width: int, height: int) -> None:
        """
        mark part of the surface damaged
        This request is used to describe the regions where the pending
        buffer is different from the current surface contents, and where
        the surface therefore needs to be repainted. The compositor
        ignores the parts of the damage that fall outside of the surface.
        Damage is double-buffered state, see wl_surface.commit.
        The damage rectangle is specified in surface-local coordinates,
        where x and y specify the upper left corner of the damage rectangle.
        The initial value for pending damage is empty: no damage.
        wl_surface.damage adds pending damage: the new pending damage
        is the union of old pending damage and the given rectangle.
        wl_surface.commit assigns pending damage as the current damage,
        and clears pending damage. The server will clear the current
        damage as it repaints the surface.
        Note! New clients should not use this request. Instead damage can be
        posted with wl_surface.damage_buffer which uses buffer coordinates
        instead of surface coordinates.
        """

        ...

    @staticmethod
    def frame() -> wl_callback:
        """
        request a frame throttling hint
        Request a notification when it is a good time to start drawing a new
        frame, by creating a frame callback. This is useful for throttling
        redrawing operations, and driving animations.
        When a client is animating on a wl_surface, it can use the 'frame'
        request to get notified when it is a good time to draw and commit the
        next frame of animation. If the client commits an update earlier than
        that, it is likely that some updates will not make it to the display,
        and the client is wasting resources by drawing too often.
        The frame request will take effect on the next wl_surface.commit.
        The notification will only be posted for one frame unless
        requested again. For a wl_surface, the notifications are posted in
        the order the frame requests were committed.
        The server must send the notifications so that a client
        will not send excessive updates, while still allowing
        the highest possible update rate for clients that wait for the reply
        before drawing again. The server should give some time for the client
        to draw and commit after sending the frame callback events to let it
        hit the next output refresh.
        A server should avoid signaling the frame callbacks if the
        surface is not visible in any way, e.g. the surface is off-screen,
        or completely obscured by other opaque surfaces.
        The object returned by this request will be destroyed by the
        compositor after the callback is fired and as such the client must not
        attempt to use it after that point.
        The callback_data passed in the callback is the current time, in
        milliseconds, with an undefined base.
        """

        ...

    @staticmethod
    def set_opaque_region(region: object) -> None:
        """
        set opaque region
        This request sets the region of the surface that contains
        opaque content.
        The opaque region is an optimization hint for the compositor
        that lets it optimize the redrawing of content behind opaque
        regions.  Setting an opaque region is not required for correct
        behaviour, but marking transparent content as opaque will result
        in repaint artifacts.
        The opaque region is specified in surface-local coordinates.
        The compositor ignores the parts of the opaque region that fall
        outside of the surface.
        Opaque region is double-buffered state, see wl_surface.commit.
        wl_surface.set_opaque_region changes the pending opaque region.
        wl_surface.commit copies the pending region to the current region.
        Otherwise, the pending and current regions are never changed.
        The initial value for an opaque region is empty. Setting the pending
        opaque region has copy semantics, and the wl_region object can be
        destroyed immediately. A NULL wl_region causes the pending opaque
        region to be set to empty.
        """

        ...

    @staticmethod
    def set_input_region(region: object) -> None:
        """
        set input region
        This request sets the region of the surface that can receive
        pointer and touch events.
        Input events happening outside of this region will try the next
        surface in the server surface stack. The compositor ignores the
        parts of the input region that fall outside of the surface.
        The input region is specified in surface-local coordinates.
        Input region is double-buffered state, see wl_surface.commit.
        wl_surface.set_input_region changes the pending input region.
        wl_surface.commit copies the pending region to the current region.
        Otherwise the pending and current regions are never changed,
        except cursor and icon surfaces are special cases, see
        wl_pointer.set_cursor and wl_data_device.start_drag.
        The initial value for an input region is infinite. That means the
        whole surface will accept input. Setting the pending input region
        has copy semantics, and the wl_region object can be destroyed
        immediately. A NULL wl_region causes the input region to be set
        to infinite.
        """

        ...

    @staticmethod
    def commit() -> None:
        """
        commit pending surface state
        Surface state (input, opaque, and damage regions, attached buffers,
        etc.) is double-buffered. Protocol requests modify the pending state,
        as opposed to the active state in use by the compositor.
        A commit request atomically creates a content update from the pending
        state, even if the pending state has not been touched. The content
        update is placed in a queue until it becomes active. After commit, the
        new pending state is as documented for each related request.
        When the content update is applied, the wl_buffer is applied before all
        other state. This means that all coordinates in double-buffered state
        are relative to the newly attached wl_buffers, except for
        wl_surface.attach itself. If there is no newly attached wl_buffer, the
        coordinates are relative to the previous content update.
        All requests that need a commit to become effective are documented
        to affect double-buffered state.
        Other interfaces may add further double-buffered surface state.
        """

        ...

    @staticmethod
    def set_buffer_transform(transform: wl_surface.wl_output.transform) -> None:
        """
        sets the buffer transformation
        This request sets the transformation that the client has already applied
        to the content of the buffer. The accepted values for the transform
        parameter are the values for wl_output.transform.
        The compositor applies the inverse of this transformation whenever it
        uses the buffer contents.
        Buffer transform is double-buffered state, see wl_surface.commit.
        A newly created surface has its buffer transformation set to normal.
        wl_surface.set_buffer_transform changes the pending buffer
        transformation. wl_surface.commit copies the pending buffer
        transformation to the current one. Otherwise, the pending and current
        values are never changed.
        The purpose of this request is to allow clients to render content
        according to the output transform, thus permitting the compositor to
        use certain optimizations even if the display is rotated. Using
        hardware overlays and scanning out a client buffer for fullscreen
        surfaces are examples of such optimizations. Those optimizations are
        highly dependent on the compositor implementation, so the use of this
        request should be considered on a case-by-case basis.
        Note that if the transform value includes 90 or 270 degree rotation,
        the width of the buffer will become the surface height and the height
        of the buffer will become the surface width.
        If transform is not one of the values from the
        wl_output.transform enum the invalid_transform protocol error
        is raised.
        """

        ...

    @staticmethod
    def set_buffer_scale(scale: int) -> None:
        """
        sets the buffer scaling factor
        This request sets an optional scaling factor on how the compositor
        interprets the contents of the buffer attached to the window.
        Buffer scale is double-buffered state, see wl_surface.commit.
        A newly created surface has its buffer scale set to 1.
        wl_surface.set_buffer_scale changes the pending buffer scale.
        wl_surface.commit copies the pending buffer scale to the current one.
        Otherwise, the pending and current values are never changed.
        The purpose of this request is to allow clients to supply higher
        resolution buffer data for use on high resolution outputs. It is
        intended that you pick the same buffer scale as the scale of the
        output that the surface is displayed on. This means the compositor
        can avoid scaling when rendering the surface on that output.
        Note that if the scale is larger than 1, then you have to attach
        a buffer that is larger (by a factor of scale in each dimension)
        than the desired surface size.
        If scale is not greater than 0 the invalid_scale protocol error is
        raised.
        """

        ...

    @staticmethod
    def damage_buffer(x: int, y: int, width: int, height: int) -> None:
        """
        mark part of the surface damaged using buffer coordinates
        This request is used to describe the regions where the pending
        buffer is different from the current surface contents, and where
        the surface therefore needs to be repainted. The compositor
        ignores the parts of the damage that fall outside of the surface.
        Damage is double-buffered state, see wl_surface.commit.
        The damage rectangle is specified in buffer coordinates,
        where x and y specify the upper left corner of the damage rectangle.
        The initial value for pending damage is empty: no damage.
        wl_surface.damage_buffer adds pending damage: the new pending
        damage is the union of old pending damage and the given rectangle.
        wl_surface.commit assigns pending damage as the current damage,
        and clears pending damage. The server will clear the current
        damage as it repaints the surface.
        This request differs from wl_surface.damage in only one way - it
        takes damage in buffer coordinates instead of surface-local
        coordinates. While this generally is more intuitive than surface
        coordinates, it is especially desirable when using wp_viewport
        or when a drawing library (like EGL) is unaware of buffer scale
        and buffer transform.
        Note: Because buffer transformation changes and damage requests may
        be interleaved in the protocol stream, it is impossible to determine
        the actual mapping between surface and buffer damage until
        wl_surface.commit time. Therefore, compositors wishing to take both
        kinds of damage into account will have to accumulate damage from the
        two requests separately and only transform from one to the other
        after receiving the wl_surface.commit.
        """

        ...

    @staticmethod
    def offset(x: int, y: int) -> None:
        """
        set the surface contents offset
        The x and y arguments specify the location of the new pending
        buffer's upper left corner, relative to the current buffer's upper
        left corner, in surface-local coordinates. In other words, the
        x and y, combined with the new surface size define in which
        directions the surface's size changes.
        Surface location offset is double-buffered state, see
        wl_surface.commit.
        This request is semantically equivalent to and the replaces the x and y
        arguments in the wl_surface.attach request in wl_surface versions prior
        to 5. See wl_surface.attach for details.
        """

        ...
    class events:
        @staticmethod
        def enter(output: object) -> None:
            """
            surface enters an output
            This is emitted whenever a surface's creation, movement, or resizing
            results in some part of it being within the scanout region of an
            output.
            Note that a surface may be overlapping with zero or more outputs.
            """

            ...

        @staticmethod
        def leave(output: object) -> None:
            """
            surface leaves an output
            This is emitted whenever a surface's creation, movement, or resizing
            results in it no longer having any part of it within the scanout region
            of an output.
            Clients should not use the number of outputs the surface is on for frame
            throttling purposes. The surface might be hidden even if no leave event
            has been sent, and the compositor might expect new surface content
            updates even if no enter event has been sent. The frame event should be
            used instead.
            """

            ...

        @staticmethod
        def preferred_buffer_scale(factor: int) -> None:
            """
            preferred buffer scale for the surface
            This event indicates the preferred buffer scale for this surface. It is
            sent whenever the compositor's preference changes.
            Before receiving this event the preferred buffer scale for this surface
            is 1.
            It is intended that scaling aware clients use this event to scale their
            content and use wl_surface.set_buffer_scale to indicate the scale they
            have rendered with. This allows clients to supply a higher detail
            buffer.
            The compositor shall emit a scale value greater than 0.
            """

            ...

        @staticmethod
        def preferred_buffer_transform(transform: wl_surface.wl_output.transform) -> None:
            """
            preferred buffer transform for the surface
            This event indicates the preferred buffer transform for this surface.
            It is sent whenever the compositor's preference changes.
            Before receiving this event the preferred buffer transform for this
            surface is normal.
            Applying this transformation to the surface buffer contents and using
            wl_surface.set_buffer_transform might allow the compositor to use the
            surface buffer more efficiently.
            """

            ...
class wl_seat:
    """
    group of input devices
    A seat is a group of keyboards, pointer and touch devices. This
    object is published as a global during start up, or when such a
    device is hot plugged.  A seat typically has a pointer and
    maintains a keyboard focus and a pointer focus.
    """
    object_id = 0
    version = 9

    class capability(IntFlag):
        pointer: int
        keyboard: int
        touch: int


    class error(Enum):
        missing_capability: int

    @staticmethod
    def get_pointer() -> wl_pointer:
        """
        return pointer object
        The ID provided will be initialized to the wl_pointer interface
        for this seat.
        This request only takes effect if the seat has the pointer
        capability, or has had the pointer capability in the past.
        It is a protocol violation to issue this request on a seat that has
        never had the pointer capability. The missing_capability error will
        be sent in this case.
        """

        ...

    @staticmethod
    def get_keyboard() -> wl_keyboard:
        """
        return keyboard object
        The ID provided will be initialized to the wl_keyboard interface
        for this seat.
        This request only takes effect if the seat has the keyboard
        capability, or has had the keyboard capability in the past.
        It is a protocol violation to issue this request on a seat that has
        never had the keyboard capability. The missing_capability error will
        be sent in this case.
        """

        ...

    @staticmethod
    def get_touch() -> wl_touch:
        """
        return touch object
        The ID provided will be initialized to the wl_touch interface
        for this seat.
        This request only takes effect if the seat has the touch
        capability, or has had the touch capability in the past.
        It is a protocol violation to issue this request on a seat that has
        never had the touch capability. The missing_capability error will
        be sent in this case.
        """

        ...

    @staticmethod
    def release() -> None:
        """
        release the seat object
        Using this request a client can tell the server that it is not going to
        use the seat object anymore.
        """

        ...
    class events:
        @staticmethod
        def capabilities(capabilities: wl_seat.capability) -> None:
            """
            seat capabilities changed
            This is emitted whenever a seat gains or loses the pointer,
            keyboard or touch capabilities.  The argument is a capability
            enum containing the complete set of capabilities this seat has.
            When the pointer capability is added, a client may create a
            wl_pointer object using the wl_seat.get_pointer request. This object
            will receive pointer events until the capability is removed in the
            future.
            When the pointer capability is removed, a client should destroy the
            wl_pointer objects associated with the seat where the capability was
            removed, using the wl_pointer.release request. No further pointer
            events will be received on these objects.
            In some compositors, if a seat regains the pointer capability and a
            client has a previously obtained wl_pointer object of version 4 or
            less, that object may start sending pointer events again. This
            behavior is considered a misinterpretation of the intended behavior
            and must not be relied upon by the client. wl_pointer objects of
            version 5 or later must not send events if created before the most
            recent event notifying the client of an added pointer capability.
            The above behavior also applies to wl_keyboard and wl_touch with the
            keyboard and touch capabilities, respectively.
            """

            ...

        @staticmethod
        def name(name: string) -> None:
            """
            unique identifier for this seat
            In a multi-seat configuration the seat name can be used by clients to
            help identify which physical devices the seat represents.
            The seat name is a UTF-8 string with no convention defined for its
            contents. Each name is unique among all wl_seat globals. The name is
            only guaranteed to be unique for the current compositor instance.
            The same seat names are used for all clients. Thus, the name can be
            shared across processes to refer to a specific wl_seat global.
            The name event is sent after binding to the seat global. This event is
            only sent once per seat object, and the name does not change over the
            lifetime of the wl_seat global.
            Compositors may re-use the same seat name if the wl_seat global is
            destroyed and re-created later.
            """

            ...
class wl_pointer:
    """
    pointer input device
    The wl_pointer interface represents one or more input devices,
    such as mice, which control the pointer location and pointer_focus
    of a seat.
    The wl_pointer interface generates motion, enter and leave
    events for the surfaces that the pointer is located over,
    and button and axis events for button presses, button releases
    and scrolling.
    """
    object_id = 0
    version = 9

    class error(Enum):
        role: int


    class button_state(Enum):
        released: int
        pressed: int


    class axis(Enum):
        vertical_scroll: int
        horizontal_scroll: int


    class axis_source(Enum):
        wheel: int
        finger: int
        continuous: int
        wheel_tilt: int


    class axis_relative_direction(Enum):
        identical: int
        inverted: int

    @staticmethod
    def set_cursor(serial: uint, surface: object, hotspot_x: int, hotspot_y: int) -> None:
        """
        set the pointer surface
        Set the pointer surface, i.e., the surface that contains the
        pointer image (cursor). This request gives the surface the role
        of a cursor. If the surface already has another role, it raises
        a protocol error.
        The cursor actually changes only if the pointer
        focus for this device is one of the requesting client's surfaces
        or the surface parameter is the current pointer surface. If
        there was a previous surface set with this request it is
        replaced. If surface is NULL, the pointer image is hidden.
        The parameters hotspot_x and hotspot_y define the position of
        the pointer surface relative to the pointer location. Its
        top-left corner is always at (x, y) - (hotspot_x, hotspot_y),
        where (x, y) are the coordinates of the pointer location, in
        surface-local coordinates.
        On wl_surface.offset requests to the pointer surface, hotspot_x
        and hotspot_y are decremented by the x and y parameters
        passed to the request. The offset must be applied by
        wl_surface.commit as usual.
        The hotspot can also be updated by passing the currently set
        pointer surface to this request with new values for hotspot_x
        and hotspot_y.
        The input region is ignored for wl_surfaces with the role of
        a cursor. When the use as a cursor ends, the wl_surface is
        unmapped.
        The serial parameter must match the latest wl_pointer.enter
        serial number sent to the client. Otherwise the request will be
        ignored.
        """

        ...

    @staticmethod
    def release() -> None:
        """
        release the pointer object
        Using this request a client can tell the server that it is not going to
        use the pointer object anymore.
        This request destroys the pointer proxy object, so clients must not call
        wl_pointer_destroy() after using this request.
        """

        ...
    class events:
        @staticmethod
        def enter(serial: uint, surface: object, surface_x: fixed, surface_y: fixed) -> None:
            """
            enter event
            Notification that this seat's pointer is focused on a certain
            surface.
            When a seat's focus enters a surface, the pointer image
            is undefined and a client should respond to this event by setting
            an appropriate pointer image with the set_cursor request.
            """

            ...

        @staticmethod
        def leave(serial: uint, surface: object) -> None:
            """
            leave event
            Notification that this seat's pointer is no longer focused on
            a certain surface.
            The leave notification is sent before the enter notification
            for the new focus.
            """

            ...

        @staticmethod
        def motion(time: uint, surface_x: fixed, surface_y: fixed) -> None:
            """
            pointer motion event
            Notification of pointer location change. The arguments
            surface_x and surface_y are the location relative to the
            focused surface.
            """

            ...

        @staticmethod
        def button(serial: uint, time: uint, button: uint, state: wl_pointer.button_state) -> None:
            """
            pointer button event
            Mouse button click and release notifications.
            The location of the click is given by the last motion or
            enter event.
            The time argument is a timestamp with millisecond
            granularity, with an undefined base.
            The button is a button code as defined in the Linux kernel's
            linux/input-event-codes.h header file, e.g. BTN_LEFT.
            Any 16-bit button code value is reserved for future additions to the
            kernel's event code list. All other button codes above 0xFFFF are
            currently undefined but may be used in future versions of this
            protocol.
            """

            ...

        @staticmethod
        def axis(time: uint, axis: wl_pointer.axis, value: fixed) -> None:
            """
            axis event
            Scroll and other axis notifications.
            For scroll events (vertical and horizontal scroll axes), the
            value parameter is the length of a vector along the specified
            axis in a coordinate space identical to those of motion events,
            representing a relative movement along the specified axis.
            For devices that support movements non-parallel to axes multiple
            axis events will be emitted.
            When applicable, for example for touch pads, the server can
            choose to emit scroll events where the motion vector is
            equivalent to a motion event vector.
            When applicable, a client can transform its content relative to the
            scroll distance.
            """

            ...

        @staticmethod
        def frame() -> None:
            """
            end of a pointer event sequence
            Indicates the end of a set of events that logically belong together.
            A client is expected to accumulate the data in all events within the
            frame before proceeding.
            All wl_pointer events before a wl_pointer.frame event belong
            logically together. For example, in a diagonal scroll motion the
            compositor will send an optional wl_pointer.axis_source event, two
            wl_pointer.axis events (horizontal and vertical) and finally a
            wl_pointer.frame event. The client may use this information to
            calculate a diagonal vector for scrolling.
            When multiple wl_pointer.axis events occur within the same frame,
            the motion vector is the combined motion of all events.
            When a wl_pointer.axis and a wl_pointer.axis_stop event occur within
            the same frame, this indicates that axis movement in one axis has
            stopped but continues in the other axis.
            When multiple wl_pointer.axis_stop events occur within the same
            frame, this indicates that these axes stopped in the same instance.
            A wl_pointer.frame event is sent for every logical event group,
            even if the group only contains a single wl_pointer event.
            Specifically, a client may get a sequence: motion, frame, button,
            frame, axis, frame, axis_stop, frame.
            The wl_pointer.enter and wl_pointer.leave events are logical events
            generated by the compositor and not the hardware. These events are
            also grouped by a wl_pointer.frame. When a pointer moves from one
            surface to another, a compositor should group the
            wl_pointer.leave event within the same wl_pointer.frame.
            However, a client must not rely on wl_pointer.leave and
            wl_pointer.enter being in the same wl_pointer.frame.
            Compositor-specific policies may require the wl_pointer.leave and
            wl_pointer.enter event being split across multiple wl_pointer.frame
            groups.
            """

            ...

        @staticmethod
        def axis_source(axis_source: wl_pointer.axis_source) -> None:
            """
            axis source event
            Source information for scroll and other axes.
            This event does not occur on its own. It is sent before a
            wl_pointer.frame event and carries the source information for
            all events within that frame.
            The source specifies how this event was generated. If the source is
            wl_pointer.axis_source.finger, a wl_pointer.axis_stop event will be
            sent when the user lifts the finger off the device.
            If the source is wl_pointer.axis_source.wheel,
            wl_pointer.axis_source.wheel_tilt or
            wl_pointer.axis_source.continuous, a wl_pointer.axis_stop event may
            or may not be sent. Whether a compositor sends an axis_stop event
            for these sources is hardware-specific and implementation-dependent;
            clients must not rely on receiving an axis_stop event for these
            scroll sources and should treat scroll sequences from these scroll
            sources as unterminated by default.
            This event is optional. If the source is unknown for a particular
            axis event sequence, no event is sent.
            Only one wl_pointer.axis_source event is permitted per frame.
            The order of wl_pointer.axis_discrete and wl_pointer.axis_source is
            not guaranteed.
            """

            ...

        @staticmethod
        def axis_stop(time: uint, axis: wl_pointer.axis) -> None:
            """
            axis stop event
            Stop notification for scroll and other axes.
            For some wl_pointer.axis_source types, a wl_pointer.axis_stop event
            is sent to notify a client that the axis sequence has terminated.
            This enables the client to implement kinetic scrolling.
            See the wl_pointer.axis_source documentation for information on when
            this event may be generated.
            Any wl_pointer.axis events with the same axis_source after this
            event should be considered as the start of a new axis motion.
            The timestamp is to be interpreted identical to the timestamp in the
            wl_pointer.axis event. The timestamp value may be the same as a
            preceding wl_pointer.axis event.
            """

            ...

        @staticmethod
        def axis_discrete(axis: wl_pointer.axis, discrete: int) -> None:
            """
            axis click event
            Discrete step information for scroll and other axes.
            This event carries the axis value of the wl_pointer.axis event in
            discrete steps (e.g. mouse wheel clicks).
            This event is deprecated with wl_pointer version 8 - this event is not
            sent to clients supporting version 8 or later.
            This event does not occur on its own, it is coupled with a
            wl_pointer.axis event that represents this axis value on a
            continuous scale. The protocol guarantees that each axis_discrete
            event is always followed by exactly one axis event with the same
            axis number within the same wl_pointer.frame. Note that the protocol
            allows for other events to occur between the axis_discrete and
            its coupled axis event, including other axis_discrete or axis
            events. A wl_pointer.frame must not contain more than one axis_discrete
            event per axis type.
            This event is optional; continuous scrolling devices
            like two-finger scrolling on touchpads do not have discrete
            steps and do not generate this event.
            The discrete value carries the directional information. e.g. a value
            of -2 is two steps towards the negative direction of this axis.
            The axis number is identical to the axis number in the associated
            axis event.
            The order of wl_pointer.axis_discrete and wl_pointer.axis_source is
            not guaranteed.
            """

            ...

        @staticmethod
        def axis_value120(axis: wl_pointer.axis, value120: int) -> None:
            """
            axis high-resolution scroll event
            Discrete high-resolution scroll information.
            This event carries high-resolution wheel scroll information,
            with each multiple of 120 representing one logical scroll step
            (a wheel detent). For example, an axis_value120 of 30 is one quarter of
            a logical scroll step in the positive direction, a value120 of
            -240 are two logical scroll steps in the negative direction within the
            same hardware event.
            Clients that rely on discrete scrolling should accumulate the
            value120 to multiples of 120 before processing the event.
            The value120 must not be zero.
            This event replaces the wl_pointer.axis_discrete event in clients
            supporting wl_pointer version 8 or later.
            Where a wl_pointer.axis_source event occurs in the same
            wl_pointer.frame, the axis source applies to this event.
            The order of wl_pointer.axis_value120 and wl_pointer.axis_source is
            not guaranteed.
            """

            ...

        @staticmethod
        def axis_relative_direction(axis: wl_pointer.axis, direction: wl_pointer.axis_relative_direction) -> None:
            """
            axis relative physical direction event
            Relative directional information of the entity causing the axis
            motion.
            For a wl_pointer.axis event, the wl_pointer.axis_relative_direction
            event specifies the movement direction of the entity causing the
            wl_pointer.axis event. For example:
            - if a user's fingers on a touchpad move down and this
            causes a wl_pointer.axis vertical_scroll down event, the physical
            direction is 'identical'
            - if a user's fingers on a touchpad move down and this causes a
            wl_pointer.axis vertical_scroll up scroll up event ('natural
            scrolling'), the physical direction is 'inverted'.
            A client may use this information to adjust scroll motion of
            components. Specifically, enabling natural scrolling causes the
            content to change direction compared to traditional scrolling.
            Some widgets like volume control sliders should usually match the
            physical direction regardless of whether natural scrolling is
            active. This event enables clients to match the scroll direction of
            a widget to the physical direction.
            This event does not occur on its own, it is coupled with a
            wl_pointer.axis event that represents this axis value.
            The protocol guarantees that each axis_relative_direction event is
            always followed by exactly one axis event with the same
            axis number within the same wl_pointer.frame. Note that the protocol
            allows for other events to occur between the axis_relative_direction
            and its coupled axis event.
            The axis number is identical to the axis number in the associated
            axis event.
            The order of wl_pointer.axis_relative_direction,
            wl_pointer.axis_discrete and wl_pointer.axis_source is not
            guaranteed.
            """

            ...
class wl_keyboard:
    """
    keyboard input device
    The wl_keyboard interface represents one or more keyboards
    associated with a seat.
    Each wl_keyboard has the following logical state:
    - an active surface (possibly null),
    - the keys currently logically down,
    - the active modifiers,
    - the active group.
    By default, the active surface is null, the keys currently logically down
    are empty, the active modifiers and the active group are 0.
    """
    object_id = 0
    version = 9

    class keymap_format(Enum):
        no_keymap: int
        xkb_v1: int


    class key_state(Enum):
        released: int
        pressed: int

    @staticmethod
    def release() -> None:
        """
        release the keyboard object
        """

        ...
    class events:
        @staticmethod
        def keymap(format: wl_keyboard.keymap_format, fd: fd, size: uint) -> None:
            """
            keyboard mapping
            This event provides a file descriptor to the client which can be
            memory-mapped in read-only mode to provide a keyboard mapping
            description.
            From version 7 onwards, the fd must be mapped with MAP_PRIVATE by
            the recipient, as MAP_SHARED may fail.
            """

            ...

        @staticmethod
        def enter(serial: uint, surface: object, keys: array) -> None:
            """
            enter event
            Notification that this seat's keyboard focus is on a certain
            surface.
            The compositor must send the wl_keyboard.modifiers event after this
            event.
            In the wl_keyboard logical state, this event sets the active surface to
            the surface argument and the keys currently logically down to the keys
            in the keys argument. The compositor must not send this event if the
            wl_keyboard already had an active surface immediately before this event.
            """

            ...

        @staticmethod
        def leave(serial: uint, surface: object) -> None:
            """
            leave event
            Notification that this seat's keyboard focus is no longer on
            a certain surface.
            The leave notification is sent before the enter notification
            for the new focus.
            In the wl_keyboard logical state, this event resets all values to their
            defaults. The compositor must not send this event if the active surface
            of the wl_keyboard was not equal to the surface argument immediately
            before this event.
            """

            ...

        @staticmethod
        def key(serial: uint, time: uint, key: uint, state: wl_keyboard.key_state) -> None:
            """
            key event
            A key was pressed or released.
            The time argument is a timestamp with millisecond
            granularity, with an undefined base.
            The key is a platform-specific key code that can be interpreted
            by feeding it to the keyboard mapping (see the keymap event).
            If this event produces a change in modifiers, then the resulting
            wl_keyboard.modifiers event must be sent after this event.
            In the wl_keyboard logical state, this event adds the key to the keys
            currently logically down (if the state argument is pressed) or removes
            the key from the keys currently logically down (if the state argument is
            released). The compositor must not send this event if the wl_keyboard
            did not have an active surface immediately before this event. The
            compositor must not send this event if state is pressed (resp. released)
            and the key was already logically down (resp. was not logically down)
            immediately before this event.
            """

            ...

        @staticmethod
        def modifiers(serial: uint, mods_depressed: uint, mods_latched: uint, mods_locked: uint, group: uint) -> None:
            """
            modifier and group state
            Notifies clients that the modifier and/or group state has
            changed, and it should update its local state.
            The compositor may send this event without a surface of the client
            having keyboard focus, for example to tie modifier information to
            pointer focus instead. If a modifier event with pressed modifiers is sent
            without a prior enter event, the client can assume the modifier state is
            valid until it receives the next wl_keyboard.modifiers event. In order to
            reset the modifier state again, the compositor can send a
            wl_keyboard.modifiers event with no pressed modifiers.
            In the wl_keyboard logical state, this event updates the modifiers and
            group.
            """

            ...

        @staticmethod
        def repeat_info(rate: int, delay: int) -> None:
            """
            repeat rate and delay
            Informs the client about the keyboard's repeat rate and delay.
            This event is sent as soon as the wl_keyboard object has been created,
            and is guaranteed to be received by the client before any key press
            event.
            Negative values for either rate or delay are illegal. A rate of zero
            will disable any repeating (regardless of the value of delay).
            This event can be sent later on as well with a new value if necessary,
            so clients should continue listening for the event past the creation
            of wl_keyboard.
            """

            ...
class wl_touch:
    """
    touchscreen input device
    The wl_touch interface represents a touchscreen
    associated with a seat.
    Touch interactions can consist of one or more contacts.
    For each contact, a series of events is generated, starting
    with a down event, followed by zero or more motion events,
    and ending with an up event. Events relating to the same
    contact point can be identified by the ID of the sequence.
    """
    object_id = 0
    version = 9

    @staticmethod
    def release() -> None:
        """
        release the touch object
        """

        ...
    class events:
        @staticmethod
        def down(serial: uint, time: uint, surface: object, id: int, x: fixed, y: fixed) -> None:
            """
            touch down event and beginning of a touch sequence
            A new touch point has appeared on the surface. This touch point is
            assigned a unique ID. Future events from this touch point reference
            this ID. The ID ceases to be valid after a touch up event and may be
            reused in the future.
            """

            ...

        @staticmethod
        def up(serial: uint, time: uint, id: int) -> None:
            """
            end of a touch event sequence
            The touch point has disappeared. No further events will be sent for
            this touch point and the touch point's ID is released and may be
            reused in a future touch down event.
            """

            ...

        @staticmethod
        def motion(time: uint, id: int, x: fixed, y: fixed) -> None:
            """
            update of touch point coordinates
            A touch point has changed coordinates.
            """

            ...

        @staticmethod
        def frame() -> None:
            """
            end of touch frame event
            Indicates the end of a set of events that logically belong together.
            A client is expected to accumulate the data in all events within the
            frame before proceeding.
            A wl_touch.frame terminates at least one event but otherwise no
            guarantee is provided about the set of events within a frame. A client
            must assume that any state not updated in a frame is unchanged from the
            previously known state.
            """

            ...

        @staticmethod
        def cancel() -> None:
            """
            touch session cancelled
            Sent if the compositor decides the touch stream is a global
            gesture. No further events are sent to the clients from that
            particular gesture. Touch cancellation applies to all touch points
            currently active on this client's surface. The client is
            responsible for finalizing the touch points, future touch points on
            this surface may reuse the touch point ID.
            No frame event is required after the cancel event.
            """

            ...

        @staticmethod
        def shape(id: int, major: fixed, minor: fixed) -> None:
            """
            update shape of touch point
            Sent when a touchpoint has changed its shape.
            This event does not occur on its own. It is sent before a
            wl_touch.frame event and carries the new shape information for
            any previously reported, or new touch points of that frame.
            Other events describing the touch point such as wl_touch.down,
            wl_touch.motion or wl_touch.orientation may be sent within the
            same wl_touch.frame. A client should treat these events as a single
            logical touch point update. The order of wl_touch.shape,
            wl_touch.orientation and wl_touch.motion is not guaranteed.
            A wl_touch.down event is guaranteed to occur before the first
            wl_touch.shape event for this touch ID but both events may occur within
            the same wl_touch.frame.
            A touchpoint shape is approximated by an ellipse through the major and
            minor axis length. The major axis length describes the longer diameter
            of the ellipse, while the minor axis length describes the shorter
            diameter. Major and minor are orthogonal and both are specified in
            surface-local coordinates. The center of the ellipse is always at the
            touchpoint location as reported by wl_touch.down or wl_touch.move.
            This event is only sent by the compositor if the touch device supports
            shape reports. The client has to make reasonable assumptions about the
            shape if it did not receive this event.
            """

            ...

        @staticmethod
        def orientation(id: int, orientation: fixed) -> None:
            """
            update orientation of touch point
            Sent when a touchpoint has changed its orientation.
            This event does not occur on its own. It is sent before a
            wl_touch.frame event and carries the new shape information for
            any previously reported, or new touch points of that frame.
            Other events describing the touch point such as wl_touch.down,
            wl_touch.motion or wl_touch.shape may be sent within the
            same wl_touch.frame. A client should treat these events as a single
            logical touch point update. The order of wl_touch.shape,
            wl_touch.orientation and wl_touch.motion is not guaranteed.
            A wl_touch.down event is guaranteed to occur before the first
            wl_touch.orientation event for this touch ID but both events may occur
            within the same wl_touch.frame.
            The orientation describes the clockwise angle of a touchpoint's major
            axis to the positive surface y-axis and is normalized to the -180 to
            +180 degree range. The granularity of orientation depends on the touch
            device, some devices only support binary rotation values between 0 and
            90 degrees.
            This event is only sent by the compositor if the touch device supports
            orientation reports.
            """

            ...
class wl_output:
    """
    compositor output region
    An output describes part of the compositor geometry.  The
    compositor works in the 'compositor coordinate system' and an
    output corresponds to a rectangular area in that space that is
    actually visible.  This typically corresponds to a monitor that
    displays part of the compositor space.  This object is published
    as global during start up, or when a monitor is hotplugged.
    """
    object_id = 0
    version = 4

    class subpixel(Enum):
        unknown: int
        none: int
        horizontal_rgb: int
        horizontal_bgr: int
        vertical_rgb: int
        vertical_bgr: int


    class transform(Enum):
        normal: int
        transform_90: int
        transform_180: int
        transform_270: int
        flipped: int
        flipped_90: int
        flipped_180: int
        flipped_270: int


    class mode(IntFlag):
        current: int
        preferred: int

    @staticmethod
    def release() -> None:
        """
        release the output object
        Using this request a client can tell the server that it is not going to
        use the output object anymore.
        """

        ...
    class events:
        @staticmethod
        def geometry(x: int, y: int, physical_width: int, physical_height: int, subpixel: wl_output.subpixel, make: string, model: string, transform: wl_output.transform) -> None:
            """
            properties of the output
            The geometry event describes geometric properties of the output.
            The event is sent when binding to the output object and whenever
            any of the properties change.
            The physical size can be set to zero if it doesn't make sense for this
            output (e.g. for projectors or virtual outputs).
            The geometry event will be followed by a done event (starting from
            version 2).
            Clients should use wl_surface.preferred_buffer_transform instead of the
            transform advertised by this event to find the preferred buffer
            transform to use for a surface.
            Note: wl_output only advertises partial information about the output
            position and identification. Some compositors, for instance those not
            implementing a desktop-style output layout or those exposing virtual
            outputs, might fake this information. Instead of using x and y, clients
            should use xdg_output.logical_position. Instead of using make and model,
            clients should use name and description.
            """

            ...

        @staticmethod
        def mode(flags: wl_output.mode, width: int, height: int, refresh: int) -> None:
            """
            advertise available modes for the output
            The mode event describes an available mode for the output.
            The event is sent when binding to the output object and there
            will always be one mode, the current mode.  The event is sent
            again if an output changes mode, for the mode that is now
            current.  In other words, the current mode is always the last
            mode that was received with the current flag set.
            Non-current modes are deprecated. A compositor can decide to only
            advertise the current mode and never send other modes. Clients
            should not rely on non-current modes.
            The size of a mode is given in physical hardware units of
            the output device. This is not necessarily the same as
            the output size in the global compositor space. For instance,
            the output may be scaled, as described in wl_output.scale,
            or transformed, as described in wl_output.transform. Clients
            willing to retrieve the output size in the global compositor
            space should use xdg_output.logical_size instead.
            The vertical refresh rate can be set to zero if it doesn't make
            sense for this output (e.g. for virtual outputs).
            The mode event will be followed by a done event (starting from
            version 2).
            Clients should not use the refresh rate to schedule frames. Instead,
            they should use the wl_surface.frame event or the presentation-time
            protocol.
            Note: this information is not always meaningful for all outputs. Some
            compositors, such as those exposing virtual outputs, might fake the
            refresh rate or the size.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            sent all information about output
            This event is sent after all other properties have been
            sent after binding to the output object and after any
            other property changes done after that. This allows
            changes to the output properties to be seen as
            atomic, even if they happen via multiple events.
            """

            ...

        @staticmethod
        def scale(factor: int) -> None:
            """
            output scaling properties
            This event contains scaling geometry information
            that is not in the geometry event. It may be sent after
            binding the output object or if the output scale changes
            later. The compositor will emit a non-zero, positive
            value for scale. If it is not sent, the client should
            assume a scale of 1.
            A scale larger than 1 means that the compositor will
            automatically scale surface buffers by this amount
            when rendering. This is used for very high resolution
            displays where applications rendering at the native
            resolution would be too small to be legible.
            Clients should use wl_surface.preferred_buffer_scale
            instead of this event to find the preferred buffer
            scale to use for a surface.
            The scale event will be followed by a done event.
            """

            ...

        @staticmethod
        def name(name: string) -> None:
            """
            name of this output
            Many compositors will assign user-friendly names to their outputs, show
            them to the user, allow the user to refer to an output, etc. The client
            may wish to know this name as well to offer the user similar behaviors.
            The name is a UTF-8 string with no convention defined for its contents.
            Each name is unique among all wl_output globals. The name is only
            guaranteed to be unique for the compositor instance.
            The same output name is used for all clients for a given wl_output
            global. Thus, the name can be shared across processes to refer to a
            specific wl_output global.
            The name is not guaranteed to be persistent across sessions, thus cannot
            be used to reliably identify an output in e.g. configuration files.
            Examples of names include 'HDMI-A-1', 'WL-1', 'X11-1', etc. However, do
            not assume that the name is a reflection of an underlying DRM connector,
            X11 connection, etc.
            The name event is sent after binding the output object. This event is
            only sent once per output object, and the name does not change over the
            lifetime of the wl_output global.
            Compositors may re-use the same output name if the wl_output global is
            destroyed and re-created later. Compositors should avoid re-using the
            same name if possible.
            The name event will be followed by a done event.
            """

            ...

        @staticmethod
        def description(description: string) -> None:
            """
            human-readable description of this output
            Many compositors can produce human-readable descriptions of their
            outputs. The client may wish to know this description as well, e.g. for
            output selection purposes.
            The description is a UTF-8 string with no convention defined for its
            contents. The description is not guaranteed to be unique among all
            wl_output globals. Examples might include 'Foocorp 11" Display' or
            'Virtual X11 output via :1'.
            The description event is sent after binding the output object and
            whenever the description changes. The description is optional, and may
            not be sent at all.
            The description event will be followed by a done event.
            """

            ...
class wl_region:
    """
    region interface
    A region object describes an area.
    Region objects are used to describe the opaque and input
    regions of a surface.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy region
        Destroy the region.  This will invalidate the object ID.
        """

        ...

    @staticmethod
    def add(x: int, y: int, width: int, height: int) -> None:
        """
        add rectangle to region
        Add the specified rectangle to the region.
        """

        ...

    @staticmethod
    def subtract(x: int, y: int, width: int, height: int) -> None:
        """
        subtract rectangle from region
        Subtract the specified rectangle from the region.
        """

        ...
class wl_subcompositor:
    """
    sub-surface compositing
    The global interface exposing sub-surface compositing capabilities.
    A wl_surface, that has sub-surfaces associated, is called the
    parent surface. Sub-surfaces can be arbitrarily nested and create
    a tree of sub-surfaces.
    The root surface in a tree of sub-surfaces is the main
    surface. The main surface cannot be a sub-surface, because
    sub-surfaces must always have a parent.
    A main surface with its sub-surfaces forms a (compound) window.
    For window management purposes, this set of wl_surface objects is
    to be considered as a single window, and it should also behave as
    such.
    The aim of sub-surfaces is to offload some of the compositing work
    within a window from clients to the compositor. A prime example is
    a video player with decorations and video in separate wl_surface
    objects. This should allow the compositor to pass YUV video buffer
    processing to dedicated overlay hardware when possible.
    """
    object_id = 0
    version = 1

    class error(Enum):
        bad_surface: int
        bad_parent: int

    @staticmethod
    def destroy() -> None:
        """
        unbind from the subcompositor interface
        Informs the server that the client will not be using this
        protocol object anymore. This does not affect any other
        objects, wl_subsurface objects included.
        """

        ...

    @staticmethod
    def get_subsurface(surface: object, parent: object) -> wl_subsurface:
        """
        give a surface the role sub-surface
        Create a sub-surface interface for the given surface, and
        associate it with the given parent surface. This turns a
        plain wl_surface into a sub-surface.
        The to-be sub-surface must not already have another role, and it
        must not have an existing wl_subsurface object. Otherwise the
        bad_surface protocol error is raised.
        Adding sub-surfaces to a parent is a double-buffered operation on the
        parent (see wl_surface.commit). The effect of adding a sub-surface
        becomes visible on the next time the state of the parent surface is
        applied.
        The parent surface must not be one of the child surface's descendants,
        and the parent must be different from the child surface, otherwise the
        bad_parent protocol error is raised.
        This request modifies the behaviour of wl_surface.commit request on
        the sub-surface, see the documentation on wl_subsurface interface.
        """

        ...
class wl_subsurface:
    """
    sub-surface interface to a wl_surface
    An additional interface to a wl_surface object, which has been
    made a sub-surface. A sub-surface has one parent surface. A
    sub-surface's size and position are not limited to that of the parent.
    Particularly, a sub-surface is not automatically clipped to its
    parent's area.
    A sub-surface becomes mapped, when a non-NULL wl_buffer is applied
    and the parent surface is mapped. The order of which one happens
    first is irrelevant. A sub-surface is hidden if the parent becomes
    hidden, or if a NULL wl_buffer is applied. These rules apply
    recursively through the tree of surfaces.
    The behaviour of a wl_surface.commit request on a sub-surface
    depends on the sub-surface's mode. The possible modes are
    synchronized and desynchronized, see methods
    wl_subsurface.set_sync and wl_subsurface.set_desync. Synchronized
    mode caches the wl_surface state to be applied when the parent's
    state gets applied, and desynchronized mode applies the pending
    wl_surface state directly. A sub-surface is initially in the
    synchronized mode.
    Sub-surfaces also have another kind of state, which is managed by
    wl_subsurface requests, as opposed to wl_surface requests. This
    state includes the sub-surface position relative to the parent
    surface (wl_subsurface.set_position), and the stacking order of
    the parent and its sub-surfaces (wl_subsurface.place_above and
    .place_below). This state is applied when the parent surface's
    wl_surface state is applied, regardless of the sub-surface's mode.
    As the exception, set_sync and set_desync are effective immediately.
    The main surface can be thought to be always in desynchronized mode,
    since it does not have a parent in the sub-surfaces sense.
    Even if a sub-surface is in desynchronized mode, it will behave as
    in synchronized mode, if its parent surface behaves as in
    synchronized mode. This rule is applied recursively throughout the
    tree of surfaces. This means, that one can set a sub-surface into
    synchronized mode, and then assume that all its child and grand-child
    sub-surfaces are synchronized, too, without explicitly setting them.
    Destroying a sub-surface takes effect immediately. If you need to
    synchronize the removal of a sub-surface to the parent surface update,
    unmap the sub-surface first by attaching a NULL wl_buffer, update parent,
    and then destroy the sub-surface.
    If the parent wl_surface object is destroyed, the sub-surface is
    unmapped.
    A sub-surface never has the keyboard focus of any seat.
    The wl_surface.offset request is ignored: clients must use set_position
    instead to move the sub-surface.
    """
    object_id = 0
    version = 1

    class error(Enum):
        bad_surface: int

    @staticmethod
    def destroy() -> None:
        """
        remove sub-surface interface
        The sub-surface interface is removed from the wl_surface object
        that was turned into a sub-surface with a
        wl_subcompositor.get_subsurface request. The wl_surface's association
        to the parent is deleted. The wl_surface is unmapped immediately.
        """

        ...

    @staticmethod
    def set_position(x: int, y: int) -> None:
        """
        reposition the sub-surface
        This schedules a sub-surface position change.
        The sub-surface will be moved so that its origin (top left
        corner pixel) will be at the location x, y of the parent surface
        coordinate system. The coordinates are not restricted to the parent
        surface area. Negative values are allowed.
        The scheduled coordinates will take effect whenever the state of the
        parent surface is applied.
        If more than one set_position request is invoked by the client before
        the commit of the parent surface, the position of a new request always
        replaces the scheduled position from any previous request.
        The initial position is 0, 0.
        """

        ...

    @staticmethod
    def place_above(sibling: object) -> None:
        """
        restack the sub-surface
        This sub-surface is taken from the stack, and put back just
        above the reference surface, changing the z-order of the sub-surfaces.
        The reference surface must be one of the sibling surfaces, or the
        parent surface. Using any other surface, including this sub-surface,
        will cause a protocol error.
        The z-order is double-buffered. Requests are handled in order and
        applied immediately to a pending state. The final pending state is
        copied to the active state the next time the state of the parent
        surface is applied.
        A new sub-surface is initially added as the top-most in the stack
        of its siblings and parent.
        """

        ...

    @staticmethod
    def place_below(sibling: object) -> None:
        """
        restack the sub-surface
        The sub-surface is placed just below the reference surface.
        See wl_subsurface.place_above.
        """

        ...

    @staticmethod
    def set_sync() -> None:
        """
        set sub-surface to synchronized mode
        Change the commit behaviour of the sub-surface to synchronized
        mode, also described as the parent dependent mode.
        In synchronized mode, wl_surface.commit on a sub-surface will
        accumulate the committed state in a cache, but the state will
        not be applied and hence will not change the compositor output.
        The cached state is applied to the sub-surface immediately after
        the parent surface's state is applied. This ensures atomic
        updates of the parent and all its synchronized sub-surfaces.
        Applying the cached state will invalidate the cache, so further
        parent surface commits do not (re-)apply old state.
        See wl_subsurface for the recursive effect of this mode.
        """

        ...

    @staticmethod
    def set_desync() -> None:
        """
        set sub-surface to desynchronized mode
        Change the commit behaviour of the sub-surface to desynchronized
        mode, also described as independent or freely running mode.
        In desynchronized mode, wl_surface.commit on a sub-surface will
        apply the pending state directly, without caching, as happens
        normally with a wl_surface. Calling wl_surface.commit on the
        parent surface has no effect on the sub-surface's wl_surface
        state. This mode allows a sub-surface to be updated on its own.
        If cached state exists when wl_surface.commit is called in
        desynchronized mode, the pending state is added to the cached
        state, and applied as a whole. This invalidates the cache.
        Note: even if a sub-surface is set to desynchronized, a parent
        sub-surface may override it to behave as synchronized. For details,
        see wl_subsurface.
        If a surface's parent surface behaves as desynchronized, then
        the cached state is applied on set_desync.
        """

        ...
class wl_callback:
    """
    callback object
    Clients can handle the 'done' event to get notified when
    the related request is done.
    Note, because wl_callback objects are created from multiple independent
    factory interfaces, the wl_callback interface is frozen at version 1.
    """
    object_id = 0
    version = 1

    class events:
        @staticmethod
        def done(callback_data: uint) -> None:
            """
            done event
            Notify the client when the related request is done.
            """

            ...
class wp_commit_timing_manager_v1:
    """
    commit timing
    When a compositor latches on to new content updates it will check for
    any number of requirements of the available content updates (such as
    fences of all buffers being signalled) to consider the update ready.
    This protocol provides a method for adding a time constraint to surface
    content. This constraint indicates to the compositor that a content
    update should be presented as closely as possible to, but not before,
    a specified time.
    This protocol does not change the Wayland property that content
    updates are applied in the order they are received, even when some
    content updates contain timestamps and others do not.
    To provide timestamps, this global factory interface must be used to
    acquire a wp_commit_timing_v1 object for a surface, which may then be
    used to provide timestamp information for commits.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        commit_timer_exists: int

    @staticmethod
    def destroy() -> None:
        """
        unbind from the commit timing interface
        Informs the server that the client will no longer be using
        this protocol object. Existing objects created by this object
        are not affected.
        """

        ...

    @staticmethod
    def get_timer(surface: object) -> wp_commit_timer_v1:
        """
        request commit timer interface for surface
        Establish a timing controller for a surface.
        Only one commit timer can be created for a surface, or a
        commit_timer_exists protocol error will be generated.
        """

        ...
class wp_commit_timer_v1:
    """
    Surface commit timer
    An object to set a time constraint for a content update on a surface.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_timestamp: int
        timestamp_exists: int
        surface_destroyed: int

    @staticmethod
    def set_timestamp(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint) -> None:
        """
        Specify time the following commit takes effect
        Provide a timing constraint for a surface content update.
        A set_timestamp request may be made before a wl_surface.commit to
        tell the compositor that the content is intended to be presented
        as closely as possible to, but not before, the specified time.
        The time is in the domain of the compositor's presentation clock.
        An invalid_timestamp error will be generated for invalid tv_nsec.
        If a timestamp already exists on the surface, a timestamp_exists
        error is generated.
        Requesting set_timestamp after the commit_timer object's surface is
        destroyed will generate a "surface_destroyed" error.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        Destroy the timer
        Informs the server that the client will no longer be using
        this protocol object.
        Existing timing constraints are not affected by the destruction.
        """

        ...
class wp_single_pixel_buffer_manager_v1:
    """
    global factory for single-pixel buffers
    The wp_single_pixel_buffer_manager_v1 interface is a factory for
    single-pixel buffers.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        Destroy the wp_single_pixel_buffer_manager_v1 object.
        The child objects created via this interface are unaffected.
        """

        ...

    @staticmethod
    def create_u32_rgba_buffer(r: uint, g: uint, b: uint, a: uint) -> wl_buffer:
        """
        create a 1×1 buffer from 32-bit RGBA values
        Create a single-pixel buffer from four 32-bit RGBA values.
        Unless specified in another protocol extension, the RGBA values use
        pre-multiplied alpha.
        The width and height of the buffer are 1.
        """

        ...
class ext_transient_seat_manager_v1:
    """
    transient seat manager
    The transient seat manager creates short-lived seats.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create() -> ext_transient_seat_v1:
        """
        create a transient seat
        Create a new seat that is removed when the client side transient seat
        object is destroyed.
        The actual seat may be removed sooner, in which case the transient seat
        object shall become inert.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        Destroy the manager.
        All objects created by the manager will remain valid until they are
        destroyed themselves.
        """

        ...
class ext_transient_seat_v1:
    """
    transient seat handle
    When the transient seat handle is destroyed, the seat itself will also be
    destroyed.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy transient seat
        When the transient seat object is destroyed by the client, the
        associated seat created by the compositor is also destroyed.
        """

        ...
    class events:
        @staticmethod
        def ready(global_name: uint) -> None:
            """
            transient seat is ready
            This event advertises the global name for the wl_seat to be used with
            wl_registry_bind.
            It is sent exactly once, immediately after the transient seat is created
            and the new "wl_seat" global is advertised, if and only if the creation
            of the transient seat was allowed.
            """

            ...

        @staticmethod
        def denied() -> None:
            """
            transient seat creation denied
            The event informs the client that the compositor denied its request to
            create a transient seat.
            It is sent exactly once, immediately after the transient seat object is
            created, if and only if the creation of the transient seat was denied.
            After receiving this event, the client should destroy the object.
            """

            ...
class ext_image_capture_source_v1:
    """
    opaque image capture source object
    The image capture source object is an opaque descriptor for a capturable
    resource.  This resource may be any sort of entity from which an image
    may be derived.
    Note, because ext_image_capture_source_v1 objects are created from multiple
    independent factory interfaces, the ext_image_capture_source_v1 interface is
    frozen at version 1.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        delete this object
        Destroys the image capture source. This request may be sent at any time
        by the client.
        """

        ...
class ext_output_image_capture_source_manager_v1:
    """
    image capture source manager for outputs
    A manager for creating image capture source objects for wl_output objects.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_source(output: object) -> ext_image_capture_source_v1:
        """
        create source object for output
        Creates a source object for an output. Images captured from this source
        will show the same content as the output. Some elements may be omitted,
        such as cursors and overlays that have been marked as transparent to
        capturing.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        delete this object
        Destroys the manager. This request may be sent at any time by the client
        and objects created by the manager will remain valid after its
        destruction.
        """

        ...
class ext_foreign_toplevel_image_capture_source_manager_v1:
    """
    image capture source manager for foreign toplevels
    A manager for creating image capture source objects for
    ext_foreign_toplevel_handle_v1 objects.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_source(toplevel_handle: object) -> ext_image_capture_source_v1:
        """
        create source object for foreign toplevel
        Creates a source object for a foreign toplevel handle. Images captured
        from this source will show the same content as the toplevel.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        delete this object
        Destroys the manager. This request may be sent at any time by the client
        and objects created by the manager will remain valid after its
        destruction.
        """

        ...
class xdg_toplevel_drag_manager_v1:
    """
    Move a window during a drag
    This protocol enhances normal drag and drop with the ability to move a
    window at the same time. This allows having detachable parts of a window
    that when dragged out of it become a new window and can be dragged over
    an existing window to be reattached.
    A typical workflow would be when the user starts dragging on top of a
    detachable part of a window, the client would create a wl_data_source and
    a xdg_toplevel_drag_v1 object and start the drag as normal via
    wl_data_device.start_drag. Once the client determines that the detachable
    window contents should be detached from the originating window, it creates
    a new xdg_toplevel with these contents and issues a
    xdg_toplevel_drag_v1.attach request before mapping it. From now on the new
    window is moved by the compositor during the drag as if the client called
    xdg_toplevel.move.
    Dragging an existing window is similar. The client creates a
    xdg_toplevel_drag_v1 object and attaches the existing toplevel before
    starting the drag.
    Clients use the existing drag and drop mechanism to detect when a window
    can be docked or undocked. If the client wants to snap a window into a
    parent window it should delete or unmap the dragged top-level. If the
    contents should be detached again it attaches a new toplevel as described
    above. If a drag operation is cancelled without being dropped, clients
    should revert to the previous state, deleting any newly created windows
    as appropriate. When a drag operation ends as indicated by
    wl_data_source.dnd_drop_performed the dragged toplevel window's final
    position is determined as if a xdg_toplevel_move operation ended.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_source: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_toplevel_drag_manager_v1 object
        Destroy this xdg_toplevel_drag_manager_v1 object. Other objects,
        including xdg_toplevel_drag_v1 objects created by this factory, are not
        affected by this request.
        """

        ...

    @staticmethod
    def get_xdg_toplevel_drag(data_source: object) -> xdg_toplevel_drag_v1:
        """
        get an xdg_toplevel_drag for a wl_data_source
        Create an xdg_toplevel_drag for a drag and drop operation that is going
        to be started with data_source.
        This request can only be made on sources used in drag-and-drop, so it
        must be performed before wl_data_device.start_drag. Attempting to use
        the source other than for drag-and-drop such as in
        wl_data_device.set_selection will raise an invalid_source error.
        Destroying data_source while a toplevel is attached to the
        xdg_toplevel_drag is undefined.
        """

        ...
class xdg_toplevel_drag_v1:
    """
    Object representing a toplevel move during a drag
    """
    object_id = 0
    version = 1

    class error(Enum):
        toplevel_attached: int
        ongoing_drag: int

    @staticmethod
    def destroy() -> None:
        """
        destroy an xdg_toplevel_drag_v1 object
        Destroy this xdg_toplevel_drag_v1 object. This request must only be
        called after the underlying wl_data_source drag has ended, as indicated
        by the dnd_drop_performed or cancelled events. In any other case an
        ongoing_drag error is raised.
        """

        ...

    @staticmethod
    def attach(toplevel: object, x_offset: int, y_offset: int) -> None:
        """
        Move a toplevel with the drag operation
        Request that the window will be moved with the cursor during the drag
        operation. The offset is a hint to the compositor how the toplevel
        should be positioned relative to the cursor hotspot in surface local
        coordinates and relative to the geometry of the toplevel being attached.
        See xdg_surface.set_window_geometry. For example it might only
        be used when an unmapped window is attached. The attached window
        does not participate in the selection of the drag target.
        If the toplevel is unmapped while it is attached, it is automatically
        detached from the drag. In this case this request has to be called again
        if the window should be attached after it is remapped.
        This request can be called multiple times but issuing it while a
        toplevel with an active role is attached raises a toplevel_attached
        error.
        """

        ...
class xdg_wm_dialog_v1:
    """
    create dialogs related to other toplevels
    The xdg_wm_dialog_v1 interface is exposed as a global object allowing
    to register surfaces with a xdg_toplevel role as "dialogs" relative to
    another toplevel.
    The compositor may let this relation influence how the surface is
    placed, displayed or interacted with.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_used: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the dialog manager object
        Destroys the xdg_wm_dialog_v1 object. This does not affect
        the xdg_dialog_v1 objects generated through it.
        """

        ...

    @staticmethod
    def get_xdg_dialog(toplevel: object) -> xdg_dialog_v1:
        """
        create a dialog object
        Creates a xdg_dialog_v1 object for the given toplevel. See the interface
        description for more details.
        Compositors must raise an already_used error if clients attempt to
        create multiple xdg_dialog_v1 objects for the same xdg_toplevel.
        """

        ...
class xdg_dialog_v1:
    """
    dialog object
    A xdg_dialog_v1 object is an ancillary object tied to a xdg_toplevel. Its
    purpose is hinting the compositor that the toplevel is a "dialog" (e.g. a
    temporary window) relative to another toplevel (see
    xdg_toplevel.set_parent). If the xdg_toplevel is destroyed, the xdg_dialog_v1
    becomes inert.
    Through this object, the client may provide additional hints about
    the purpose of the secondary toplevel. This interface has no effect
    on toplevels that are not attached to a parent toplevel.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the dialog object
        Destroys the xdg_dialog_v1 object. If this object is destroyed
        before the related xdg_toplevel, the compositor should unapply its
        effects.
        """

        ...

    @staticmethod
    def set_modal() -> None:
        """
        mark dialog as modal
        Hints that the dialog has "modal" behavior. Modal dialogs typically
        require to be fully addressed by the user (i.e. closed) before resuming
        interaction with the parent toplevel, and may require a distinct
        presentation.
        Clients must implement the logic to filter events in the parent
        toplevel on their own.
        Compositors may choose any policy in event delivery to the parent
        toplevel, from delivering all events unfiltered to using them for
        internal consumption.
        """

        ...

    @staticmethod
    def unset_modal() -> None:
        """
        mark dialog as not modal
        Drops the hint that this dialog has "modal" behavior. See
        xdg_dialog_v1.set_modal for more details.
        """

        ...
class wp_content_type_manager_v1:
    """
    surface content type manager
    This interface allows a client to describe the kind of content a surface
    will display, to allow the compositor to optimize its behavior for it.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_constructed: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the content type manager object
        Destroy the content type manager. This doesn't destroy objects created
        with the manager.
        """

        ...

    @staticmethod
    def get_surface_content_type(surface: object) -> wp_content_type_v1:
        """
        create a new content type object
        Create a new content type object associated with the given surface.
        Creating a wp_content_type_v1 from a wl_surface which already has one
        attached is a client error: already_constructed.
        """

        ...
class wp_content_type_v1:
    """
    content type object for a surface
    The content type object allows the compositor to optimize for the kind
    of content shown on the surface. A compositor may for example use it to
    set relevant drm properties like "content type".
    The client may request to switch to another content type at any time.
    When the associated surface gets destroyed, this object becomes inert and
    the client should destroy it.
    """
    object_id = 0
    version = 1

    class type(Enum):
        none: int
        photo: int
        video: int
        game: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the content type object
        Switch back to not specifying the content type of this surface. This is
        equivalent to setting the content type to none, including double
        buffering semantics. See set_content_type for details.
        """

        ...

    @staticmethod
    def set_content_type(content_type: wp_content_type_v1.type) -> None:
        """
        specify the content type
        Set the surface content type. This informs the compositor that the
        client believes it is displaying buffers matching this content type.
        This is purely a hint for the compositor, which can be used to adjust
        its behavior or hardware settings to fit the presented content best.
        The content type is double-buffered state, see wl_surface.commit for
        details.
        """

        ...
class wp_fifo_manager_v1:
    """
    protocol for fifo constraints
    When a Wayland compositor considers applying a content update,
    it must ensure all the update's readiness constraints (fences, etc)
    are met.
    This protocol provides a way to use the completion of a display refresh
    cycle as an additional readiness constraint.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_exists: int

    @staticmethod
    def destroy() -> None:
        """
        unbind from the manager interface
        Informs the server that the client will no longer be using
        this protocol object. Existing objects created by this object
        are not affected.
        """

        ...

    @staticmethod
    def get_fifo(surface: object) -> wp_fifo_v1:
        """
        request fifo interface for surface
        Establish a fifo object for a surface that may be used to add
        display refresh constraints to content updates.
        Only one such object may exist for a surface and attempting
        to create more than one will result in an already_exists
        protocol error. If a surface is acted on by multiple software
        components, general best practice is that only the component
        performing wl_surface.attach operations should use this protocol.
        """

        ...
class wp_fifo_v1:
    """
    fifo interface
    A fifo object for a surface that may be used to add
    display refresh constraints to content updates.
    """
    object_id = 0
    version = 1

    class error(Enum):
        surface_destroyed: int

    @staticmethod
    def set_barrier() -> None:
        """
        sets the start point for a fifo constraint
        When the content update containing the "set_barrier" is applied,
        it sets a "fifo_barrier" condition on the surface associated with
        the fifo object. The condition is cleared immediately after the
        following latching deadline for non-tearing presentation.
        The compositor may clear the condition early if it must do so to
        ensure client forward progress assumptions.
        To wait for this condition to clear, use the "wait_barrier" request.
        "set_barrier" is double-buffered state, see wl_surface.commit.
        Requesting set_barrier after the fifo object's surface is
        destroyed will generate a "surface_destroyed" error.
        """

        ...

    @staticmethod
    def wait_barrier() -> None:
        """
        adds a fifo constraint to a content update
        Indicate that this content update is not ready while a
        "fifo_barrier" condition is present on the surface.
        This means that when the content update containing "set_barrier"
        was made active at a latching deadline, it will be active for
        at least one refresh cycle. A content update which is allowed to
        tear might become active after a latching deadline if no content
        update became active at the deadline.
        The constraint must be ignored if the surface is a subsurface in
        synchronized mode. If the surface is not being updated by the
        compositor (off-screen, occluded) the compositor may ignore the
        constraint. Clients must use an additional mechanism such as
        frame callbacks or timestamps to ensure throttling occurs under
        all conditions.
        "wait_barrier" is double-buffered state, see wl_surface.commit.
        Requesting "wait_barrier" after the fifo object's surface is
        destroyed will generate a "surface_destroyed" error.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the fifo interface
        Informs the server that the client will no longer be using
        this protocol object.
        Surface state changes previously made by this protocol are
        unaffected by this object's destruction.
        """

        ...
class xwayland_shell_v1:
    """
    context object for Xwayland shell
    xwayland_shell_v1 is a singleton global object that
    provides the ability to create a xwayland_surface_v1 object
    for a given wl_surface.
    This interface is intended to be bound by the Xwayland server.
    A compositor must not allow clients other than Xwayland to
    bind to this interface. A compositor should hide this global
    from other clients' wl_registry.
    A client the compositor does not consider to be an Xwayland
    server attempting to bind this interface will result in
    an implementation-defined error.
    An Xwayland server that has bound this interface must not
    set the `WL_SURFACE_ID` atom on a window.
    """
    object_id = 0
    version = 1

    class error(Enum):
        role: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the Xwayland shell object
        Destroy the xwayland_shell_v1 object.
        The child objects created via this interface are unaffected.
        """

        ...

    @staticmethod
    def get_xwayland_surface(surface: object) -> xwayland_surface_v1:
        """
        assign the xwayland_surface surface role
        Create an xwayland_surface_v1 interface for a given wl_surface
        object and gives it the xwayland_surface role.
        It is illegal to create an xwayland_surface_v1 for a wl_surface
        which already has an assigned role and this will result in the
        `role` protocol error.
        See the documentation of xwayland_surface_v1 for more details
        about what an xwayland_surface_v1 is and how it is used.
        """

        ...
class xwayland_surface_v1:
    """
    interface for associating Xwayland windows to wl_surfaces
    An Xwayland surface is a surface managed by an Xwayland server.
    It is used for associating surfaces to Xwayland windows.
    The Xwayland server associated with actions in this interface is
    determined by the Wayland client making the request.
    The client must call wl_surface.commit on the corresponding wl_surface
    for the xwayland_surface_v1 state to take effect.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_associated: int
        invalid_serial: int

    @staticmethod
    def set_serial(serial_lo: uint, serial_hi: uint) -> None:
        """
        associates a Xwayland window to a wl_surface
        Associates an Xwayland window to a wl_surface.
        The association state is double-buffered, see wl_surface.commit.
        The `serial_lo` and `serial_hi` parameters specify a non-zero
        monotonic serial number which is entirely unique and provided by the
        Xwayland server equal to the serial value provided by a client message
        with a message type of the `WL_SURFACE_SERIAL` atom on the X11 window
        for this surface to be associated to.
        The serial value in the `WL_SURFACE_SERIAL` client message is specified
        as having the lo-bits specified in `l[0]` and the hi-bits specified
        in `l[1]`.
        If the serial value provided by `serial_lo` and `serial_hi` is not
        valid, the `invalid_serial` protocol error will be raised.
        An X11 window may be associated with multiple surfaces throughout its
        lifespan. (eg. unmapping and remapping a window).
        For each wl_surface, this state must not be committed more than once,
        otherwise the `already_associated` protocol error will be raised.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the Xwayland surface object
        Destroy the xwayland_surface_v1 object.
        Any already existing associations are unaffected by this action.
        """

        ...
class ext_foreign_toplevel_list_v1:
    """
    list toplevels
    A toplevel is defined as a surface with a role similar to xdg_toplevel.
    XWayland surfaces may be treated like toplevels in this protocol.
    After a client binds the ext_foreign_toplevel_list_v1, each mapped
    toplevel window will be sent using the ext_foreign_toplevel_list_v1.toplevel
    event.
    Clients which only care about the current state can perform a roundtrip after
    binding this global.
    For each instance of ext_foreign_toplevel_list_v1, the compositor must
    create a new ext_foreign_toplevel_handle_v1 object for each mapped toplevel.
    If a compositor implementation sends the ext_foreign_toplevel_list_v1.finished
    event after the global is bound, the compositor must not send any
    ext_foreign_toplevel_list_v1.toplevel events.
    """
    object_id = 0
    version = 1

    @staticmethod
    def stop() -> None:
        """
        stop sending events
        This request indicates that the client no longer wishes to receive
        events for new toplevels.
        The Wayland protocol is asynchronous, meaning the compositor may send
        further toplevel events until the stop request is processed.
        The client should wait for a ext_foreign_toplevel_list_v1.finished
        event before destroying this object.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the ext_foreign_toplevel_list_v1 object
        This request should be called either when the client will no longer
        use the ext_foreign_toplevel_list_v1 or after the finished event
        has been received to allow destruction of the object.
        If a client wishes to destroy this object it should send a
        ext_foreign_toplevel_list_v1.stop request and wait for a ext_foreign_toplevel_list_v1.finished
        event, then destroy the handles and then this object.
        """

        ...
    class events:
        @staticmethod
        def toplevel(toplevel: ext_foreign_toplevel_handle_v1) -> None:
            """
            a toplevel has been created
            This event is emitted whenever a new toplevel window is created. It is
            emitted for all toplevels, regardless of the app that has created them.
            All initial properties of the toplevel (identifier, title, app_id) will be sent
            immediately after this event using the corresponding events for
            ext_foreign_toplevel_handle_v1. The compositor will use the
            ext_foreign_toplevel_handle_v1.done event to indicate when all data has
            been sent.
            """

            ...

        @staticmethod
        def finished() -> None:
            """
            the compositor has finished with the toplevel manager
            This event indicates that the compositor is done sending events
            to this object. The client should destroy the object.
            See ext_foreign_toplevel_list_v1.destroy for more information.
            The compositor must not send any more toplevel events after this event.
            """

            ...
class ext_foreign_toplevel_handle_v1:
    """
    a mapped toplevel
    A ext_foreign_toplevel_handle_v1 object represents a mapped toplevel
    window. A single app may have multiple mapped toplevels.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the ext_foreign_toplevel_handle_v1 object
        This request should be used when the client will no longer use the handle
        or after the closed event has been received to allow destruction of the
        object.
        When a handle is destroyed, a new handle may not be created by the server
        until the toplevel is unmapped and then remapped. Destroying a toplevel handle
        is not recommended unless the client is cleaning up child objects
        before destroying the ext_foreign_toplevel_list_v1 object, the toplevel
        was closed or the toplevel handle will not be used in the future.
        Other protocols which extend the ext_foreign_toplevel_handle_v1
        interface should require destructors for extension interfaces be
        called before allowing the toplevel handle to be destroyed.
        """

        ...
    class events:
        @staticmethod
        def closed() -> None:
            """
            the toplevel has been closed
            The server will emit no further events on the ext_foreign_toplevel_handle_v1
            after this event. Any requests received aside from the destroy request must
            be ignored. Upon receiving this event, the client should destroy the handle.
            Other protocols which extend the ext_foreign_toplevel_handle_v1
            interface must also ignore requests other than destructors.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all information about the toplevel has been sent
            This event is sent after all changes in the toplevel state have
            been sent.
            This allows changes to the ext_foreign_toplevel_handle_v1 properties
            to be atomically applied. Other protocols which extend the
            ext_foreign_toplevel_handle_v1 interface may use this event to also
            atomically apply any pending state.
            This event must not be sent after the ext_foreign_toplevel_handle_v1.closed
            event.
            """

            ...

        @staticmethod
        def title(title: string) -> None:
            """
            title change
            The title of the toplevel has changed.
            The configured state must not be applied immediately. See
            ext_foreign_toplevel_handle_v1.done for details.
            """

            ...

        @staticmethod
        def app_id(app_id: string) -> None:
            """
            app_id change
            The app id of the toplevel has changed.
            The configured state must not be applied immediately. See
            ext_foreign_toplevel_handle_v1.done for details.
            """

            ...

        @staticmethod
        def identifier(identifier: string) -> None:
            """
            a stable identifier for a toplevel
            This identifier is used to check if two or more toplevel handles belong
            to the same toplevel.
            The identifier is useful for command line tools or privileged clients
            which may need to reference an exact toplevel across processes or
            instances of the ext_foreign_toplevel_list_v1 global.
            The compositor must only send this event when the handle is created.
            The identifier must be unique per toplevel and it's handles. Two different
            toplevels must not have the same identifier. The identifier is only valid
            as long as the toplevel is mapped. If the toplevel is unmapped the identifier
            must not be reused. An identifier must not be reused by the compositor to
            ensure there are no races when sharing identifiers between processes.
            An identifier is a string that contains up to 32 printable ASCII bytes.
            An identifier must not be an empty string. It is recommended that a
            compositor includes an opaque generation value in identifiers. How the
            generation value is used when generating the identifier is implementation
            dependent.
            """

            ...
class wp_cursor_shape_manager_v1:
    """
    cursor shape manager
    This global offers an alternative, optional way to set cursor images. This
    new way uses enumerated cursors instead of a wl_surface like
    wl_pointer.set_cursor does.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        Destroy the cursor shape manager.
        """

        ...

    @staticmethod
    def get_pointer(pointer: object) -> wp_cursor_shape_device_v1:
        """
        manage the cursor shape of a pointer device
        Obtain a wp_cursor_shape_device_v1 for a wl_pointer object.
        When the pointer capability is removed from the wl_seat, the
        wp_cursor_shape_device_v1 object becomes inert.
        """

        ...

    @staticmethod
    def get_tablet_tool_v2(tablet_tool: object) -> wp_cursor_shape_device_v1:
        """
        manage the cursor shape of a tablet tool device
        Obtain a wp_cursor_shape_device_v1 for a zwp_tablet_tool_v2 object.
        When the zwp_tablet_tool_v2 is removed, the wp_cursor_shape_device_v1
        object becomes inert.
        """

        ...
class wp_cursor_shape_device_v1:
    """
    cursor shape for a device
    This interface allows clients to set the cursor shape.
    """
    object_id = 0
    version = 2

    class shape(Enum):
        default: int
        context_menu: int
        help: int
        pointer: int
        progress: int
        wait: int
        cell: int
        crosshair: int
        text: int
        vertical_text: int
        alias: int
        copy: int
        move: int
        no_drop: int
        not_allowed: int
        grab: int
        grabbing: int
        e_resize: int
        n_resize: int
        ne_resize: int
        nw_resize: int
        s_resize: int
        se_resize: int
        sw_resize: int
        w_resize: int
        ew_resize: int
        ns_resize: int
        nesw_resize: int
        nwse_resize: int
        col_resize: int
        row_resize: int
        all_scroll: int
        zoom_in: int
        zoom_out: int
        dnd_ask: int
        all_resize: int


    class error(Enum):
        invalid_shape: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the cursor shape device
        Destroy the cursor shape device.
        The device cursor shape remains unchanged.
        """

        ...

    @staticmethod
    def set_shape(serial: uint, shape: wp_cursor_shape_device_v1.shape) -> None:
        """
        set device cursor to the shape
        Sets the device cursor to the specified shape. The compositor will
        change the cursor image based on the specified shape.
        The cursor actually changes only if the input device focus is one of
        the requesting client's surfaces. If any, the previous cursor image
        (surface or shape) is replaced.
        The "shape" argument must be a valid enum entry, otherwise the
        invalid_shape protocol error is raised.
        This is similar to the wl_pointer.set_cursor and
        zwp_tablet_tool_v2.set_cursor requests, but this request accepts a
        shape instead of contents in the form of a surface. Clients can mix
        set_cursor and set_shape requests.
        The serial parameter must match the latest wl_pointer.enter or
        zwp_tablet_tool_v2.proximity_in serial number sent to the client.
        Otherwise the request will be ignored.
        """

        ...
class wp_color_manager_v1:
    """
    color manager singleton
    A singleton global interface used for getting color management extensions
    for wl_surface and wl_output objects, and for creating client defined
    image description objects. The extension interfaces allow
    getting the image description of outputs and setting the image
    description of surfaces.
    Compositors should never remove this global.
    """
    object_id = 0
    version = 1

    class error(Enum):
        unsupported_feature: int
        surface_exists: int


    class render_intent(Enum):
        perceptual: int
        relative: int
        saturation: int
        absolute: int
        relative_bpc: int


    class feature(Enum):
        icc_v2_v4: int
        parametric: int
        set_primaries: int
        set_tf_power: int
        set_luminances: int
        set_mastering_display_primaries: int
        extended_target_volume: int
        windows_scrgb: int


    class primaries(Enum):
        srgb: int
        pal_m: int
        pal: int
        ntsc: int
        generic_film: int
        bt2020: int
        cie1931_xyz: int
        dci_p3: int
        display_p3: int
        adobe_rgb: int


    class transfer_function(Enum):
        bt1886: int
        gamma22: int
        gamma28: int
        st240: int
        ext_linear: int
        log_100: int
        log_316: int
        xvycc: int
        srgb: int
        ext_srgb: int
        st2084_pq: int
        st428: int
        hlg: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the color manager
        Destroy the wp_color_manager_v1 object. This does not affect any other
        objects in any way.
        """

        ...

    @staticmethod
    def get_output(output: object) -> wp_color_management_output_v1:
        """
        create a color management interface for a wl_output
        This creates a new wp_color_management_output_v1 object for the
        given wl_output.
        See the wp_color_management_output_v1 interface for more details.
        """

        ...

    @staticmethod
    def get_surface(surface: object) -> wp_color_management_surface_v1:
        """
        create a color management interface for a wl_surface
        If a wp_color_management_surface_v1 object already exists for the given
        wl_surface, the protocol error surface_exists is raised.
        This creates a new color wp_color_management_surface_v1 object for the
        given wl_surface.
        See the wp_color_management_surface_v1 interface for more details.
        """

        ...

    @staticmethod
    def get_surface_feedback(surface: object) -> wp_color_management_surface_feedback_v1:
        """
        create a color management feedback interface
        This creates a new color wp_color_management_surface_feedback_v1 object
        for the given wl_surface.
        See the wp_color_management_surface_feedback_v1 interface for more
        details.
        """

        ...

    @staticmethod
    def create_icc_creator() -> wp_image_description_creator_icc_v1:
        """
        make a new ICC-based image description creator object
        Makes a new ICC-based image description creator object with all
        properties initially unset. The client can then use the object's
        interface to define all the required properties for an image description
        and finally create a wp_image_description_v1 object.
        This request can be used when the compositor advertises
        wp_color_manager_v1.feature.icc_v2_v4.
        Otherwise this request raises the protocol error unsupported_feature.
        """

        ...

    @staticmethod
    def create_parametric_creator() -> wp_image_description_creator_params_v1:
        """
        make a new parametric image description creator object
        Makes a new parametric image description creator object with all
        properties initially unset. The client can then use the object's
        interface to define all the required properties for an image description
        and finally create a wp_image_description_v1 object.
        This request can be used when the compositor advertises
        wp_color_manager_v1.feature.parametric.
        Otherwise this request raises the protocol error unsupported_feature.
        """

        ...

    @staticmethod
    def create_windows_scrgb() -> wp_image_description_v1:
        """
        create Windows-scRGB image description object
        This creates a pre-defined image description for the so-called
        Windows-scRGB stimulus encoding. This comes from the Windows 10 handling
        of its own definition of an scRGB color space for an HDR screen
        driven in BT.2100/PQ signalling mode.
        Windows-scRGB uses sRGB (BT.709) color primaries and white point.
        The transfer characteristic is extended linear.
        The nominal color channel value range is extended, meaning it includes
        negative and greater than 1.0 values. Negative values are used to
        escape the sRGB color gamut boundaries. To make use of the extended
        range, the client needs to use a pixel format that can represent those
        values, e.g. floating-point 16 bits per channel.
        Nominal color value R=G=B=0.0 corresponds to BT.2100/PQ system
        0 cd/m², and R=G=B=1.0 corresponds to BT.2100/PQ system 80 cd/m².
        The maximum is R=G=B=125.0 corresponding to 10k cd/m².
        Windows-scRGB is displayed by Windows 10 by converting it to
        BT.2100/PQ, maintaining the CIE 1931 chromaticity and mapping the
        luminance as above. No adjustment is made to the signal to account
        for the viewing conditions.
        The reference white level of Windows-scRGB is unknown. If a
        reference white level must be assumed for compositor processing, it
        should be R=G=B=2.5375 corresponding to 203 cd/m² of Report ITU-R
        BT.2408-7.
        The target color volume of Windows-scRGB is unknown. The color gamut
        may be anything between sRGB and BT.2100.
        Note: EGL_EXT_gl_colorspace_scrgb_linear definition differs from
        Windows-scRGB by using R=G=B=1.0 as the reference white level, while
        Windows-scRGB reference white level is unknown or varies. However,
        it seems probable that Windows implements both
        EGL_EXT_gl_colorspace_scrgb_linear and Vulkan
        VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT as Windows-scRGB.
        This request can be used when the compositor advertises
        wp_color_manager_v1.feature.windows_scrgb.
        Otherwise this request raises the protocol error unsupported_feature.
        The resulting image description object does not allow get_information
        request. The wp_image_description_v1.ready event shall be sent.
        """

        ...
    class events:
        @staticmethod
        def supported_intent(render_intent: wp_color_manager_v1.render_intent) -> None:
            """
            supported rendering intent
            When this object is created, it shall immediately send this event once
            for each rendering intent the compositor supports.
            """

            ...

        @staticmethod
        def supported_feature(feature: wp_color_manager_v1.feature) -> None:
            """
            supported features
            When this object is created, it shall immediately send this event once
            for each compositor supported feature listed in the enumeration.
            """

            ...

        @staticmethod
        def supported_tf_named(tf: wp_color_manager_v1.transfer_function) -> None:
            """
            supported named transfer characteristic
            When this object is created, it shall immediately send this event once
            for each named transfer function the compositor supports with the
            parametric image description creator.
            """

            ...

        @staticmethod
        def supported_primaries_named(primaries: wp_color_manager_v1.primaries) -> None:
            """
            supported named primaries
            When this object is created, it shall immediately send this event once
            for each named set of primaries the compositor supports with the
            parametric image description creator.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all features have been sent
            This event is sent when all supported rendering intents, features,
            transfer functions and named primaries have been sent.
            """

            ...
class wp_color_management_output_v1:
    """
    output color properties
    A wp_color_management_output_v1 describes the color properties of an
    output.
    The wp_color_management_output_v1 is associated with the wl_output global
    underlying the wl_output object. Therefore the client destroying the
    wl_output object has no impact, but the compositor removing the output
    global makes the wp_color_management_output_v1 object inert.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the color management output
        Destroy the color wp_color_management_output_v1 object. This does not
        affect any remaining protocol objects.
        """

        ...

    @staticmethod
    def get_image_description() -> wp_image_description_v1:
        """
        get the image description of the output
        This creates a new wp_image_description_v1 object for the current image
        description of the output. There always is exactly one image description
        active for an output so the client should destroy the image description
        created by earlier invocations of this request. This request is usually
        sent as a reaction to the image_description_changed event or when
        creating a wp_color_management_output_v1 object.
        The image description of an output represents the color encoding the
        output expects. There might be performance and power advantages, as well
        as improved color reproduction, if a content update matches the image
        description of the output it is being shown on. If a content update is
        shown on any other output than the one it matches the image description
        of, then the color reproduction on those outputs might be considerably
        worse.
        The created wp_image_description_v1 object preserves the image
        description of the output from the time the object was created.
        The resulting image description object allows get_information request.
        If this protocol object is inert, the resulting image description object
        shall immediately deliver the wp_image_description_v1.failed event with
        the no_output cause.
        If the interface version is inadequate for the output's image
        description, meaning that the client does not support all the events
        needed to deliver the crucial information, the resulting image
        description object shall immediately deliver the
        wp_image_description_v1.failed event with the low_version cause.
        Otherwise the object shall immediately deliver the ready event.
        """

        ...
    class events:
        @staticmethod
        def image_description_changed() -> None:
            """
            image description changed
            This event is sent whenever the image description of the output changed,
            followed by one wl_output.done event common to output events across all
            extensions.
            If the client wants to use the updated image description, it needs to do
            get_image_description again, because image description objects are
            immutable.
            """

            ...
class wp_color_management_surface_v1:
    """
    color management extension to a surface
    A wp_color_management_surface_v1 allows the client to set the color
    space and HDR properties of a surface.
    If the wl_surface associated with the wp_color_management_surface_v1 is
    destroyed, the wp_color_management_surface_v1 object becomes inert.
    """
    object_id = 0
    version = 1

    class error(Enum):
        render_intent: int
        image_description: int
        inert: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the color management interface for a surface
        Destroy the wp_color_management_surface_v1 object and do the same as
        unset_image_description.
        """

        ...

    @staticmethod
    def set_image_description(image_description: object, render_intent: wp_color_management_surface_v1.wp_color_manager_v1.render_intent) -> None:
        """
        set the surface image description
        If this protocol object is inert, the protocol error inert is raised.
        Set the image description of the underlying surface. The image
        description and rendering intent are double-buffered state, see
        wl_surface.commit.
        It is the client's responsibility to understand the image description
        it sets on a surface, and to provide content that matches that image
        description. Compositors might convert images to match their own or any
        other image descriptions.
        Image descriptions which are not ready (see wp_image_description_v1)
        are forbidden in this request, and in such case the protocol error
        image_description is raised.
        All image descriptions which are ready (see wp_image_description_v1)
        are allowed and must always be accepted by the compositor.
        A rendering intent provides the client's preference on how content
        colors should be mapped to each output. The render_intent value must
        be one advertised by the compositor with
        wp_color_manager_v1.render_intent event, otherwise the protocol error
        render_intent is raised.
        When an image description is set on a surface, the Transfer
        Characteristics of the image description defines the valid range of
        the nominal (real-valued) color channel values. The processing of
        out-of-range color channel values is undefined, but compositors are
        recommended to clamp the values to the valid range when possible.
        By default, a surface does not have an associated image description
        nor a rendering intent. The handling of color on such surfaces is
        compositor implementation defined. Compositors should handle such
        surfaces as sRGB, but may handle them differently if they have specific
        requirements.
        Setting the image description has copy semantics; after this request,
        the image description can be immediately destroyed without affecting
        the pending state of the surface.
        """

        ...

    @staticmethod
    def unset_image_description() -> None:
        """
        remove the surface image description
        If this protocol object is inert, the protocol error inert is raised.
        This request removes any image description from the surface. See
        set_image_description for how a compositor handles a surface without
        an image description. This is double-buffered state, see
        wl_surface.commit.
        """

        ...
class wp_color_management_surface_feedback_v1:
    """
    color management extension to a surface
    A wp_color_management_surface_feedback_v1 allows the client to get the
    preferred image description of a surface.
    If the wl_surface associated with this object is destroyed, the
    wp_color_management_surface_feedback_v1 object becomes inert.
    """
    object_id = 0
    version = 1

    class error(Enum):
        inert: int
        unsupported_feature: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the color management interface for a surface
        Destroy the wp_color_management_surface_feedback_v1 object.
        """

        ...

    @staticmethod
    def get_preferred() -> wp_image_description_v1:
        """
        get the preferred image description
        If this protocol object is inert, the protocol error inert is raised.
        The preferred image description represents the compositor's preferred
        color encoding for this wl_surface at the current time. There might be
        performance and power advantages, as well as improved color
        reproduction, if the image description of a content update matches the
        preferred image description.
        This creates a new wp_image_description_v1 object for the currently
        preferred image description for the wl_surface. The client should
        stop using and destroy the image descriptions created by earlier
        invocations of this request for the associated wl_surface.
        This request is usually sent as a reaction to the preferred_changed
        event or when creating a wp_color_management_surface_feedback_v1 object
        if the client is capable of adapting to image descriptions.
        The created wp_image_description_v1 object preserves the preferred image
        description of the wl_surface from the time the object was created.
        The resulting image description object allows get_information request.
        If the image description is parametric, the client should set it on its
        wl_surface only if the image description is an exact match with the
        client content. Particularly if everything else matches, but the target
        color volume is greater than what the client needs, the client should
        create its own parameric image description with its exact parameters.
        If the interface version is inadequate for the preferred image
        description, meaning that the client does not support all the
        events needed to deliver the crucial information, the resulting image
        description object shall immediately deliver the
        wp_image_description_v1.failed event with the low_version cause,
        otherwise the object shall immediately deliver the ready event.
        """

        ...

    @staticmethod
    def get_preferred_parametric() -> wp_image_description_v1:
        """
        get the preferred image description
        The same description as for get_preferred applies, except the returned
        image description is guaranteed to be parametric. This is meant for
        clients that can only deal with parametric image descriptions.
        If the compositor doesn't support parametric image descriptions, the
        unsupported_feature error is emitted.
        """

        ...
    class events:
        @staticmethod
        def preferred_changed(identity: uint) -> None:
            """
            the preferred image description changed
            The preferred image description is the one which likely has the most
            performance and/or quality benefits for the compositor if used by the
            client for its wl_surface contents. This event is sent whenever the
            compositor changes the wl_surface's preferred image description.
            This event sends the identity of the new preferred state as the argument,
            so clients who are aware of the image description already can reuse it.
            Otherwise, if the client client wants to know what the preferred image
            description is, it shall use the get_preferred request.
            The preferred image description is not automatically used for anything.
            It is only a hint, and clients may set any valid image description with
            set_image_description, but there might be performance and color accuracy
            improvements by providing the wl_surface contents in the preferred
            image description. Therefore clients that can, should render according
            to the preferred image description
            """

            ...
class wp_image_description_creator_icc_v1:
    """
    holder of image description ICC information
    This type of object is used for collecting all the information required
    to create a wp_image_description_v1 object from an ICC file. A complete
    set of required parameters consists of these properties:
    - ICC file
    Each required property must be set exactly once if the client is to create
    an image description. The set requests verify that a property was not
    already set. The create request verifies that all required properties are
    set. There may be several alternative requests for setting each property,
    and in that case the client must choose one of them.
    Once all properties have been set, the create request must be used to
    create the image description object, destroying the creator in the
    process.
    """
    object_id = 0
    version = 1

    class error(Enum):
        incomplete_set: int
        already_set: int
        bad_fd: int
        bad_size: int
        out_of_file: int

    @staticmethod
    def create() -> wp_image_description_v1:
        """
        Create the image description object from ICC data
        Create an image description object based on the ICC information
        previously set on this object. A compositor must parse the ICC data in
        some undefined but finite amount of time.
        The completeness of the parameter set is verified. If the set is not
        complete, the protocol error incomplete_set is raised. For the
        definition of a complete set, see the description of this interface.
        If the particular combination of the information is not supported
        by the compositor, the resulting image description object shall
        immediately deliver the wp_image_description_v1.failed event with the
        'unsupported' cause. If a valid image description was created from the
        information, the wp_image_description_v1.ready event will eventually
        be sent instead.
        This request destroys the wp_image_description_creator_icc_v1 object.
        The resulting image description object does not allow get_information
        request.
        """

        ...

    @staticmethod
    def set_icc_file(icc_profile: fd, offset: uint, length: uint) -> None:
        """
        set the ICC profile file
        Sets the ICC profile file to be used as the basis of the image
        description.
        The data shall be found through the given fd at the given offset, having
        the given length. The fd must be seekable and readable. Violating these
        requirements raises the bad_fd protocol error.
        If reading the data fails due to an error independent of the client, the
        compositor shall send the wp_image_description_v1.failed event on the
        created wp_image_description_v1 with the 'operating_system' cause.
        The maximum size of the ICC profile is 32 MB. If length is greater than
        that or zero, the protocol error bad_size is raised. If offset + length
        exceeds the file size, the protocol error out_of_file is raised.
        A compositor may read the file at any time starting from this request
        and only until whichever happens first:
        - If create request was issued, the wp_image_description_v1 object
        delivers either failed or ready event; or
        - if create request was not issued, this
        wp_image_description_creator_icc_v1 object is destroyed.
        A compositor shall not modify the contents of the file, and the fd may
        be sealed for writes and size changes. The client must ensure to its
        best ability that the data does not change while the compositor is
        reading it.
        The data must represent a valid ICC profile. The ICC profile version
        must be 2 or 4, it must be a 3 channel profile and the class must be
        Display or ColorSpace. Violating these requirements will not result in a
        protocol error, but will eventually send the
        wp_image_description_v1.failed event on the created
        wp_image_description_v1 with the 'unsupported' cause.
        See the International Color Consortium specification ICC.1:2022 for more
        details about ICC profiles.
        If ICC file has already been set on this object, the protocol error
        already_set is raised.
        """

        ...
class wp_image_description_creator_params_v1:
    """
    holder of image description parameters
    This type of object is used for collecting all the parameters required
    to create a wp_image_description_v1 object. A complete set of required
    parameters consists of these properties:
    - transfer characteristic function (tf)
    - chromaticities of primaries and white point (primary color volume)
    The following properties are optional and have a well-defined default
    if not explicitly set:
    - primary color volume luminance range
    - reference white luminance level
    - mastering display primaries and white point (target color volume)
    - mastering luminance range
    The following properties are optional and will be ignored
    if not explicitly set:
    - maximum content light level
    - maximum frame-average light level
    Each required property must be set exactly once if the client is to create
    an image description. The set requests verify that a property was not
    already set. The create request verifies that all required properties are
    set. There may be several alternative requests for setting each property,
    and in that case the client must choose one of them.
    Once all properties have been set, the create request must be used to
    create the image description object, destroying the creator in the
    process.
    """
    object_id = 0
    version = 1

    class error(Enum):
        incomplete_set: int
        already_set: int
        unsupported_feature: int
        invalid_tf: int
        invalid_primaries_named: int
        invalid_luminance: int

    @staticmethod
    def create() -> wp_image_description_v1:
        """
        Create the image description object using params
        Create an image description object based on the parameters previously
        set on this object.
        The completeness of the parameter set is verified. If the set is not
        complete, the protocol error incomplete_set is raised. For the
        definition of a complete set, see the description of this interface.
        The protocol error invalid_luminance is raised if any of the following
        requirements is not met:
        - When max_cll is set, it must be greater than min L and less or equal
        to max L of the mastering luminance range.
        - When max_fall is set, it must be greater than min L and less or equal
        to max L of the mastering luminance range.
        - When both max_cll and max_fall are set, max_fall must be less or equal
        to max_cll.
        If the particular combination of the parameter set is not supported
        by the compositor, the resulting image description object shall
        immediately deliver the wp_image_description_v1.failed event with the
        'unsupported' cause. If a valid image description was created from the
        parameter set, the wp_image_description_v1.ready event will eventually
        be sent instead.
        This request destroys the wp_image_description_creator_params_v1
        object.
        The resulting image description object does not allow get_information
        request.
        """

        ...

    @staticmethod
    def set_tf_named(tf: wp_image_description_creator_params_v1.wp_color_manager_v1.transfer_function) -> None:
        """
        named transfer characteristic
        Sets the transfer characteristic using explicitly enumerated named
        functions.
        When the resulting image description is attached to an image, the
        content should be encoded and decoded according to the industry standard
        practices for the transfer characteristic.
        Only names advertised with wp_color_manager_v1 event supported_tf_named
        are allowed. Other values shall raise the protocol error invalid_tf.
        If transfer characteristic has already been set on this object, the
        protocol error already_set is raised.
        """

        ...

    @staticmethod
    def set_tf_power(eexp: uint) -> None:
        """
        transfer characteristic as a power curve
        Sets the color component transfer characteristic to a power curve with
        the given exponent. Negative values are handled by mirroring the
        positive half of the curve through the origin. The valid domain and
        range of the curve are all finite real numbers. This curve represents
        the conversion from electrical to optical color channel values.
        When the resulting image description is attached to an image, the
        content should be encoded with the inverse of the power curve.
        The curve exponent shall be multiplied by 10000 to get the argument eexp
        value to carry the precision of 4 decimals.
        The curve exponent must be at least 1.0 and at most 10.0. Otherwise the
        protocol error invalid_tf is raised.
        If transfer characteristic has already been set on this object, the
        protocol error already_set is raised.
        This request can be used when the compositor advertises
        wp_color_manager_v1.feature.set_tf_power. Otherwise this request raises
        the protocol error unsupported_feature.
        """

        ...

    @staticmethod
    def set_primaries_named(primaries: wp_image_description_creator_params_v1.wp_color_manager_v1.primaries) -> None:
        """
        named primaries
        Sets the color primaries and white point using explicitly named sets.
        This describes the primary color volume which is the basis for color
        value encoding.
        Only names advertised with wp_color_manager_v1 event
        supported_primaries_named are allowed. Other values shall raise the
        protocol error invalid_primaries_named.
        If primaries have already been set on this object, the protocol error
        already_set is raised.
        """

        ...

    @staticmethod
    def set_primaries(r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
        """
        primaries as chromaticity coordinates
        Sets the color primaries and white point using CIE 1931 xy chromaticity
        coordinates. This describes the primary color volume which is the basis
        for color value encoding.
        Each coordinate value is multiplied by 1 million to get the argument
        value to carry precision of 6 decimals.
        If primaries have already been set on this object, the protocol error
        already_set is raised.
        This request can be used if the compositor advertises
        wp_color_manager_v1.feature.set_primaries. Otherwise this request raises
        the protocol error unsupported_feature.
        """

        ...

    @staticmethod
    def set_luminances(min_lum: uint, max_lum: uint, reference_lum: uint) -> None:
        """
        primary color volume luminance range and reference white
        Sets the primary color volume luminance range and the reference white
        luminance level. These values include the minimum display emission
        and ambient flare luminances, assumed to be optically additive and have
        the chromaticity of the primary color volume white point.
        The default luminances from
        https://www.color.org/chardata/rgb/srgb.xalter are
        - primary color volume minimum: 0.2 cd/m²
        - primary color volume maximum: 80 cd/m²
        - reference white: 80 cd/m²
        Setting a named transfer characteristic can imply other default
        luminances.
        The default luminances get overwritten when this request is used.
        With transfer_function.st2084_pq the given 'max_lum' value is ignored,
        and 'max_lum' is taken as 'min_lum' + 10000 cd/m².
        'min_lum' and 'max_lum' specify the minimum and maximum luminances of
        the primary color volume as reproduced by the targeted display.
        'reference_lum' specifies the luminance of the reference white as
        reproduced by the targeted display, and reflects the targeted viewing
        environment.
        Compositors should make sure that all content is anchored, meaning that
        an input signal level of 'reference_lum' on one image description and
        another input signal level of 'reference_lum' on another image
        description should produce the same output level, even though the
        'reference_lum' on both image representations can be different.
        'reference_lum' may be higher than 'max_lum'. In that case reaching
        the reference white output level in image content requires the
        'extended_target_volume' feature support.
        If 'max_lum' or 'reference_lum' are less than or equal to 'min_lum',
        the protocol error invalid_luminance is raised.
        The minimum luminance is multiplied by 10000 to get the argument
        'min_lum' value and carries precision of 4 decimals. The maximum
        luminance and reference white luminance values are unscaled.
        If the primary color volume luminance range and the reference white
        luminance level have already been set on this object, the protocol error
        already_set is raised.
        This request can be used if the compositor advertises
        wp_color_manager_v1.feature.set_luminances. Otherwise this request
        raises the protocol error unsupported_feature.
        """

        ...

    @staticmethod
    def set_mastering_display_primaries(r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
        """
        mastering display primaries as chromaticity coordinates
        Provides the color primaries and white point of the mastering display
        using CIE 1931 xy chromaticity coordinates. This is compatible with the
        SMPTE ST 2086 definition of HDR static metadata.
        The mastering display primaries and mastering display luminances define
        the target color volume.
        If mastering display primaries are not explicitly set, the target color
        volume is assumed to have the same primaries as the primary color volume.
        The target color volume is defined by all tristimulus values between 0.0
        and 1.0 (inclusive) of the color space defined by the given mastering
        display primaries and white point. The colorimetry is identical between
        the container color space and the mastering display color space,
        including that no chromatic adaptation is applied even if the white
        points differ.
        The target color volume can exceed the primary color volume to allow for
        a greater color volume with an existing color space definition (for
        example scRGB). It can be smaller than the primary color volume to
        minimize gamut and tone mapping distances for big color spaces (HDR
        metadata).
        To make use of the entire target color volume a suitable pixel format
        has to be chosen (e.g. floating point to exceed the primary color
        volume, or abusing limited quantization range as with xvYCC).
        Each coordinate value is multiplied by 1 million to get the argument
        value to carry precision of 6 decimals.
        If mastering display primaries have already been set on this object, the
        protocol error already_set is raised.
        This request can be used if the compositor advertises
        wp_color_manager_v1.feature.set_mastering_display_primaries. Otherwise
        this request raises the protocol error unsupported_feature. The
        advertisement implies support only for target color volumes fully
        contained within the primary color volume.
        If a compositor additionally supports target color volume exceeding the
        primary color volume, it must advertise
        wp_color_manager_v1.feature.extended_target_volume. If a client uses
        target color volume exceeding the primary color volume and the
        compositor does not support it, the result is implementation defined.
        Compositors are recommended to detect this case and fail the image
        description gracefully, but it may as well result in color artifacts.
        """

        ...

    @staticmethod
    def set_mastering_luminance(min_lum: uint, max_lum: uint) -> None:
        """
        display mastering luminance range
        Sets the luminance range that was used during the content mastering
        process as the minimum and maximum absolute luminance L. These values
        include the minimum display emission and ambient flare luminances,
        assumed to be optically additive and have the chromaticity of the
        primary color volume white point. This should be
        compatible with the SMPTE ST 2086 definition of HDR static metadata.
        The mastering display primaries and mastering display luminances define
        the target color volume.
        If mastering luminances are not explicitly set, the target color volume
        is assumed to have the same min and max luminances as the primary color
        volume.
        If max L is less than or equal to min L, the protocol error
        invalid_luminance is raised.
        Min L value is multiplied by 10000 to get the argument min_lum value
        and carry precision of 4 decimals. Max L value is unscaled for max_lum.
        This request can be used if the compositor advertises
        wp_color_manager_v1.feature.set_mastering_display_primaries. Otherwise
        this request raises the protocol error unsupported_feature. The
        advertisement implies support only for target color volumes fully
        contained within the primary color volume.
        If a compositor additionally supports target color volume exceeding the
        primary color volume, it must advertise
        wp_color_manager_v1.feature.extended_target_volume. If a client uses
        target color volume exceeding the primary color volume and the
        compositor does not support it, the result is implementation defined.
        Compositors are recommended to detect this case and fail the image
        description gracefully, but it may as well result in color artifacts.
        """

        ...

    @staticmethod
    def set_max_cll(max_cll: uint) -> None:
        """
        maximum content light level
        Sets the maximum content light level (max_cll) as defined by CTA-861-H.
        max_cll is undefined by default.
        """

        ...

    @staticmethod
    def set_max_fall(max_fall: uint) -> None:
        """
        maximum frame-average light level
        Sets the maximum frame-average light level (max_fall) as defined by
        CTA-861-H.
        max_fall is undefined by default.
        """

        ...
class wp_image_description_v1:
    """
    Colorimetric image description
    An image description carries information about the color encoding used on
    a surface when attached to a wl_surface via
    wp_color_management_surface_v1.set_image_description. A compositor can use
    this information to decode pixel values into colorimetrically meaningful
    quantities.
    Note, that the wp_image_description_v1 object is not ready to be used
    immediately after creation. The object eventually delivers either the
    'ready' or the 'failed' event, specified in all requests creating it. The
    object is deemed "ready" after receiving the 'ready' event.
    An object which is not ready is illegal to use, it can only be destroyed.
    Any other request in this interface shall result in the 'not_ready'
    protocol error. Attempts to use an object which is not ready through other
    interfaces shall raise protocol errors defined there.
    Once created and regardless of how it was created, a
    wp_image_description_v1 object always refers to one fixed image
    description. It cannot change after creation.
    """
    object_id = 0
    version = 1

    class error(Enum):
        not_ready: int
        no_information: int


    class cause(Enum):
        low_version: int
        unsupported: int
        operating_system: int
        no_output: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the image description
        Destroy this object. It is safe to destroy an object which is not ready.
        Destroying a wp_image_description_v1 object has no side-effects, not
        even if a wp_color_management_surface_v1.set_image_description has not
        yet been followed by a wl_surface.commit.
        """

        ...

    @staticmethod
    def get_information() -> wp_image_description_info_v1:
        """
        get information about the image description
        Creates a wp_image_description_info_v1 object which delivers the
        information that makes up the image description.
        Not all image description protocol objects allow get_information
        request. Whether it is allowed or not is defined by the request that
        created the object. If get_information is not allowed, the protocol
        error no_information is raised.
        """

        ...
    class events:
        @staticmethod
        def failed(cause: wp_image_description_v1.cause, msg: string) -> None:
            """
            graceful error on creating the image description
            If creating a wp_image_description_v1 object fails for a reason that is
            not defined as a protocol error, this event is sent.
            The requests that create image description objects define whether and
            when this can occur. Only such creation requests can trigger this event.
            This event cannot be triggered after the image description was
            successfully formed.
            Once this event has been sent, the wp_image_description_v1 object will
            never become ready and it can only be destroyed.
            """

            ...

        @staticmethod
        def ready(identity: uint) -> None:
            """
            indication that the object is ready to be used
            Once this event has been sent, the wp_image_description_v1 object is
            deemed "ready". Ready objects can be used to send requests and can be
            used through other interfaces.
            Every ready wp_image_description_v1 protocol object refers to an
            underlying image description record in the compositor. Multiple protocol
            objects may end up referring to the same record. Clients may identify
            these "copies" by comparing their id numbers: if the numbers from two
            protocol objects are identical, the protocol objects refer to the same
            image description record. Two different image description records
            cannot have the same id number simultaneously. The id number does not
            change during the lifetime of the image description record.
            The id number is valid only as long as the protocol object is alive. If
            all protocol objects referring to the same image description record are
            destroyed, the id number may be recycled for a different image
            description record.
            Image description id number is not a protocol object id. Zero is
            reserved as an invalid id number. It shall not be possible for a client
            to refer to an image description by its id number in protocol. The id
            numbers might not be portable between Wayland connections. A compositor
            shall not send an invalid id number.
            This identity allows clients to de-duplicate image description records
            and avoid get_information request if they already have the image
            description information.
            """

            ...
class wp_image_description_info_v1:
    """
    Colorimetric image description information
    Sends all matching events describing an image description object exactly
    once and finally sends the 'done' event.
    This means
    - if the image description is parametric, it must send
    - primaries
    - named_primaries, if applicable
    - at least one of tf_power and tf_named, as applicable
    - luminances
    - target_primaries
    - target_luminance
    - if the image description is parametric, it may send, if applicable,
    - target_max_cll
    - target_max_fall
    - if the image description contains an ICC profile, it must send the
    icc_file event
    Once a wp_image_description_info_v1 object has delivered a 'done' event it
    is automatically destroyed.
    Every wp_image_description_info_v1 created from the same
    wp_image_description_v1 shall always return the exact same data.
    """
    object_id = 0
    version = 1

    class events:
        @staticmethod
        def done() -> None:
            """
            end of information
            Signals the end of information events and destroys the object.
            """

            ...

        @staticmethod
        def icc_file(icc: fd, icc_size: uint) -> None:
            """
            ICC profile matching the image description
            The icc argument provides a file descriptor to the client which may be
            memory-mapped to provide the ICC profile matching the image description.
            The fd is read-only, and if mapped then it must be mapped with
            MAP_PRIVATE by the client.
            The ICC profile version and other details are determined by the
            compositor. There is no provision for a client to ask for a specific
            kind of a profile.
            """

            ...

        @staticmethod
        def primaries(r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
            """
            primaries as chromaticity coordinates
            Delivers the primary color volume primaries and white point using CIE
            1931 xy chromaticity coordinates.
            Each coordinate value is multiplied by 1 million to get the argument
            value to carry precision of 6 decimals.
            """

            ...

        @staticmethod
        def primaries_named(primaries: wp_image_description_info_v1.wp_color_manager_v1.primaries) -> None:
            """
            named primaries
            Delivers the primary color volume primaries and white point using an
            explicitly enumerated named set.
            """

            ...

        @staticmethod
        def tf_power(eexp: uint) -> None:
            """
            transfer characteristic as a power curve
            The color component transfer characteristic of this image description is
            a pure power curve. This event provides the exponent of the power
            function. This curve represents the conversion from electrical to
            optical pixel or color values.
            The curve exponent has been multiplied by 10000 to get the argument eexp
            value to carry the precision of 4 decimals.
            """

            ...

        @staticmethod
        def tf_named(tf: wp_image_description_info_v1.wp_color_manager_v1.transfer_function) -> None:
            """
            named transfer characteristic
            Delivers the transfer characteristic using an explicitly enumerated
            named function.
            """

            ...

        @staticmethod
        def luminances(min_lum: uint, max_lum: uint, reference_lum: uint) -> None:
            """
            primary color volume luminance range and reference white
            Delivers the primary color volume luminance range and the reference
            white luminance level. These values include the minimum display emission
            and ambient flare luminances, assumed to be optically additive and have
            the chromaticity of the primary color volume white point.
            The minimum luminance is multiplied by 10000 to get the argument
            'min_lum' value and carries precision of 4 decimals. The maximum
            luminance and reference white luminance values are unscaled.
            """

            ...

        @staticmethod
        def target_primaries(r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
            """
            target primaries as chromaticity coordinates
            Provides the color primaries and white point of the target color volume
            using CIE 1931 xy chromaticity coordinates. This is compatible with the
            SMPTE ST 2086 definition of HDR static metadata for mastering displays.
            While primary color volume is about how color is encoded, the target
            color volume is the actually displayable color volume. If target color
            volume is equal to the primary color volume, then this event is not
            sent.
            Each coordinate value is multiplied by 1 million to get the argument
            value to carry precision of 6 decimals.
            """

            ...

        @staticmethod
        def target_luminance(min_lum: uint, max_lum: uint) -> None:
            """
            target luminance range
            Provides the luminance range that the image description is targeting as
            the minimum and maximum absolute luminance L. These values include the
            minimum display emission and ambient flare luminances, assumed to be
            optically additive and have the chromaticity of the primary color
            volume white point. This should be compatible with the SMPTE ST 2086
            definition of HDR static metadata.
            This luminance range is only theoretical and may not correspond to the
            luminance of light emitted on an actual display.
            Min L value is multiplied by 10000 to get the argument min_lum value and
            carry precision of 4 decimals. Max L value is unscaled for max_lum.
            """

            ...

        @staticmethod
        def target_max_cll(max_cll: uint) -> None:
            """
            target maximum content light level
            Provides the targeted max_cll of the image description. max_cll is
            defined by CTA-861-H.
            This luminance is only theoretical and may not correspond to the
            luminance of light emitted on an actual display.
            """

            ...

        @staticmethod
        def target_max_fall(max_fall: uint) -> None:
            """
            target maximum frame-average light level
            Provides the targeted max_fall of the image description. max_fall is
            defined by CTA-861-H.
            This luminance is only theoretical and may not correspond to the
            luminance of light emitted on an actual display.
            """

            ...
class xdg_activation_v1:
    """
    interface for activating surfaces
    A global interface used for informing the compositor about applications
    being activated or started, or for applications to request to be
    activated.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_activation object
        Notify the compositor that the xdg_activation object will no longer be
        used.
        The child objects created via this interface are unaffected and should
        be destroyed separately.
        """

        ...

    @staticmethod
    def get_activation_token() -> xdg_activation_token_v1:
        """
        requests a token
        Creates an xdg_activation_token_v1 object that will provide
        the initiating client with a unique token for this activation. This
        token should be offered to the clients to be activated.
        """

        ...

    @staticmethod
    def activate(token: string, surface: object) -> None:
        """
        notify new interaction being available
        Requests surface activation. It's up to the compositor to display
        this information as desired, for example by placing the surface above
        the rest.
        The compositor may know who requested this by checking the activation
        token and might decide not to follow through with the activation if it's
        considered unwanted.
        Compositors can ignore unknown activation tokens when an invalid
        token is passed.
        """

        ...
class xdg_activation_token_v1:
    """
    an exported activation handle
    An object for setting up a token and receiving a token handle that can
    be passed as an activation token to another client.
    The object is created using the xdg_activation_v1.get_activation_token
    request. This object should then be populated with the app_id, surface
    and serial information and committed. The compositor shall then issue a
    done event with the token. In case the request's parameters are invalid,
    the compositor will provide an invalid token.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_used: int

    @staticmethod
    def set_serial(serial: uint, seat: object) -> None:
        """
        specifies the seat and serial of the activating event
        Provides information about the seat and serial event that requested the
        token.
        The serial can come from an input or focus event. For instance, if a
        click triggers the launch of a third-party client, the launcher client
        should send a set_serial request with the serial and seat from the
        wl_pointer.button event.
        Some compositors might refuse to activate toplevels when the token
        doesn't have a valid and recent enough event serial.
        Must be sent before commit. This information is optional.
        """

        ...

    @staticmethod
    def set_app_id(app_id: string) -> None:
        """
        specifies the application being activated
        The requesting client can specify an app_id to associate the token
        being created with it.
        Must be sent before commit. This information is optional.
        """

        ...

    @staticmethod
    def set_surface(surface: object) -> None:
        """
        specifies the surface requesting activation
        This request sets the surface requesting the activation. Note, this is
        different from the surface that will be activated.
        Some compositors might refuse to activate toplevels when the token
        doesn't have a requesting surface.
        Must be sent before commit. This information is optional.
        """

        ...

    @staticmethod
    def commit() -> None:
        """
        issues the token request
        Requests an activation token based on the different parameters that
        have been offered through set_serial, set_surface and set_app_id.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_activation_token_v1 object
        Notify the compositor that the xdg_activation_token_v1 object will no
        longer be used. The received token stays valid.
        """

        ...
    class events:
        @staticmethod
        def done(token: string) -> None:
            """
            the exported activation token
            The 'done' event contains the unique token of this activation request
            and notifies that the provider is done.
            """

            ...
class wp_fractional_scale_manager_v1:
    """
    fractional surface scale information
    A global interface for requesting surfaces to use fractional scales.
    """
    object_id = 0
    version = 1

    class error(Enum):
        fractional_scale_exists: int

    @staticmethod
    def destroy() -> None:
        """
        unbind the fractional surface scale interface
        Informs the server that the client will not be using this protocol
        object anymore. This does not affect any other objects,
        wp_fractional_scale_v1 objects included.
        """

        ...

    @staticmethod
    def get_fractional_scale(surface: object) -> wp_fractional_scale_v1:
        """
        extend surface interface for scale information
        Create an add-on object for the the wl_surface to let the compositor
        request fractional scales. If the given wl_surface already has a
        wp_fractional_scale_v1 object associated, the fractional_scale_exists
        protocol error is raised.
        """

        ...
class wp_fractional_scale_v1:
    """
    fractional scale interface to a wl_surface
    An additional interface to a wl_surface object which allows the compositor
    to inform the client of the preferred scale.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        remove surface scale information for surface
        Destroy the fractional scale object. When this object is destroyed,
        preferred_scale events will no longer be sent.
        """

        ...
    class events:
        @staticmethod
        def preferred_scale(scale: uint) -> None:
            """
            notify of new preferred scale
            Notification of a new preferred scale for this surface that the
            compositor suggests that the client should use.
            The sent scale is the numerator of a fraction with a denominator of 120.
            """

            ...
class ext_workspace_manager_v1:
    """
    list and control workspaces
    Workspaces, also called virtual desktops, are groups of surfaces. A
    compositor with a concept of workspaces may only show some such groups of
    surfaces (those of 'active' workspaces) at a time. 'Activating' a
    workspace is a request for the compositor to display that workspace's
    surfaces as normal, whereas the compositor may hide or otherwise
    de-emphasise surfaces that are associated only with 'inactive' workspaces.
    Workspaces are grouped by which sets of outputs they correspond to, and
    may contain surfaces only from those outputs. In this way, it is possible
    for each output to have its own set of workspaces, or for all outputs (or
    any other arbitrary grouping) to share workspaces. Compositors may
    optionally conceptually arrange each group of workspaces in an
    N-dimensional grid.
    The purpose of this protocol is to enable the creation of taskbars and
    docks by providing them with a list of workspaces and their properties,
    and allowing them to activate and deactivate workspaces.
    After a client binds the ext_workspace_manager_v1, each workspace will be
    sent via the workspace event.
    """
    object_id = 0
    version = 1

    @staticmethod
    def commit() -> None:
        """
        all requests about the workspaces have been sent
        The client must send this request after it has finished sending other
        requests. The compositor must process a series of requests preceding a
        commit request atomically.
        This allows changes to the workspace properties to be seen as atomic,
        even if they happen via multiple events, and even if they involve
        multiple ext_workspace_handle_v1 objects, for example, deactivating one
        workspace and activating another.
        """

        ...

    @staticmethod
    def stop() -> None:
        """
        stop sending events
        Indicates the client no longer wishes to receive events for new
        workspace groups. However the compositor may emit further workspace
        events, until the finished event is emitted. The compositor is expected
        to send the finished event eventually once the stop request has been processed.
        The client must not send any requests after this one, doing so will raise a wl_display
        invalid_object error.
        """

        ...
    class events:
        @staticmethod
        def workspace_group(workspace_group: ext_workspace_group_handle_v1) -> None:
            """
            a workspace group has been created
            This event is emitted whenever a new workspace group has been created.
            All initial details of the workspace group (outputs) will be
            sent immediately after this event via the corresponding events in
            ext_workspace_group_handle_v1 and ext_workspace_handle_v1.
            """

            ...

        @staticmethod
        def workspace(workspace: ext_workspace_handle_v1) -> None:
            """
            workspace has been created
            This event is emitted whenever a new workspace has been created.
            All initial details of the workspace (name, coordinates, state) will
            be sent immediately after this event via the corresponding events in
            ext_workspace_handle_v1.
            Workspaces start off unassigned to any workspace group.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all information about the workspaces and workspace groups has been sent
            This event is sent after all changes in all workspaces and workspace groups have been
            sent.
            This allows changes to one or more ext_workspace_group_handle_v1
            properties and ext_workspace_handle_v1 properties
            to be seen as atomic, even if they happen via multiple events.
            In particular, an output moving from one workspace group to
            another sends an output_enter event and an output_leave event to the two
            ext_workspace_group_handle_v1 objects in question. The compositor sends
            the done event only after updating the output information in both
            workspace groups.
            """

            ...

        @staticmethod
        def finished() -> None:
            """
            the compositor has finished with the workspace_manager
            This event indicates that the compositor is done sending events to the
            ext_workspace_manager_v1. The server will destroy the object
            immediately after sending this request.
            """

            ...
class ext_workspace_group_handle_v1:
    """
    a workspace group assigned to a set of outputs
    A ext_workspace_group_handle_v1 object represents a workspace group
    that is assigned a set of outputs and contains a number of workspaces.
    The set of outputs assigned to the workspace group is conveyed to the client via
    output_enter and output_leave events, and its workspaces are conveyed with
    workspace events.
    For example, a compositor which has a set of workspaces for each output may
    advertise a workspace group (and its workspaces) per output, whereas a compositor
    where a workspace spans all outputs may advertise a single workspace group for all
    outputs.
    """
    object_id = 0
    version = 1

    class group_capabilities(IntFlag):
        create_workspace: int

    @staticmethod
    def create_workspace(workspace: string) -> None:
        """
        create a new workspace
        Request that the compositor create a new workspace with the given name
        and assign it to this group.
        There is no guarantee that the compositor will create a new workspace,
        or that the created workspace will have the provided name.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the ext_workspace_group_handle_v1 object
        Destroys the ext_workspace_group_handle_v1 object.
        This request should be send either when the client does not want to
        use the workspace group object any more or after the removed event to finalize
        the destruction of the object.
        """

        ...
    class events:
        @staticmethod
        def capabilities(capabilities: ext_workspace_group_handle_v1.group_capabilities) -> None:
            """
            compositor capabilities
            This event advertises the capabilities supported by the compositor. If
            a capability isn't supported, clients should hide or disable the UI
            elements that expose this functionality. For instance, if the
            compositor doesn't advertise support for creating workspaces, a button
            triggering the create_workspace request should not be displayed.
            The compositor will ignore requests it doesn't support. For instance,
            a compositor which doesn't advertise support for creating workspaces will ignore
            create_workspace requests.
            Compositors must send this event once after creation of an
            ext_workspace_group_handle_v1. When the capabilities change, compositors
            must send this event again.
            """

            ...

        @staticmethod
        def output_enter(output: object) -> None:
            """
            output assigned to workspace group
            This event is emitted whenever an output is assigned to the workspace
            group or a new `wl_output` object is bound by the client, which was already
            assigned to this workspace_group.
            """

            ...

        @staticmethod
        def output_leave(output: object) -> None:
            """
            output removed from workspace group
            This event is emitted whenever an output is removed from the workspace
            group.
            """

            ...

        @staticmethod
        def workspace_enter(workspace: object) -> None:
            """
            workspace added to workspace group
            This event is emitted whenever a workspace is assigned to this group.
            A workspace may only ever be assigned to a single group at a single point
            in time, but can be re-assigned during it's lifetime.
            """

            ...

        @staticmethod
        def workspace_leave(workspace: object) -> None:
            """
            workspace removed from workspace group
            This event is emitted whenever a workspace is removed from this group.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            this workspace group has been removed
            This event is send when the group associated with the ext_workspace_group_handle_v1
            has been removed. After sending this request the compositor will immediately consider
            the object inert. Any requests will be ignored except the destroy request.
            It is guaranteed there won't be any more events referencing this
            ext_workspace_group_handle_v1.
            The compositor must remove all workspaces belonging to a workspace group
            via a workspace_leave event before removing the workspace group.
            """

            ...
class ext_workspace_handle_v1:
    """
    a workspace handing a group of surfaces
    A ext_workspace_handle_v1 object represents a workspace that handles a
    group of surfaces.
    Each workspace has:
    - a name, conveyed to the client with the name event
    - potentially an id conveyed with the id event
    - a list of states, conveyed to the client with the state event
    - and optionally a set of coordinates, conveyed to the client with the
    coordinates event
    The client may request that the compositor activate or deactivate the workspace.
    Each workspace can belong to only a single workspace group.
    Depepending on the compositor policy, there might be workspaces with
    the same name in different workspace groups, but these workspaces are still
    separate (e.g. one of them might be active while the other is not).
    """
    object_id = 0
    version = 1

    class state(IntFlag):
        active: int
        urgent: int
        hidden: int


    class workspace_capabilities(IntFlag):
        activate: int
        deactivate: int
        remove: int
        assign: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the ext_workspace_handle_v1 object
        Destroys the ext_workspace_handle_v1 object.
        This request should be made either when the client does not want to
        use the workspace object any more or after the remove event to finalize
        the destruction of the object.
        """

        ...

    @staticmethod
    def activate() -> None:
        """
        activate the workspace
        Request that this workspace be activated.
        There is no guarantee the workspace will be actually activated, and
        behaviour may be compositor-dependent. For example, activating a
        workspace may or may not deactivate all other workspaces in the same
        group.
        """

        ...

    @staticmethod
    def deactivate() -> None:
        """
        deactivate the workspace
        Request that this workspace be deactivated.
        There is no guarantee the workspace will be actually deactivated.
        """

        ...

    @staticmethod
    def assign(workspace_group: object) -> None:
        """
        assign workspace to group
        Requests that this workspace is assigned to the given workspace group.
        There is no guarantee the workspace will be assigned.
        """

        ...

    @staticmethod
    def remove() -> None:
        """
        remove the workspace
        Request that this workspace be removed.
        There is no guarantee the workspace will be actually removed.
        """

        ...
    class events:
        @staticmethod
        def id(id: string) -> None:
            """
            workspace id
            If this event is emitted, it will be send immediately after the
            ext_workspace_handle_v1 is created or when an id is assigned to
            a workspace (at most once during it's lifetime).
            An id will never change during the lifetime of the `ext_workspace_handle_v1`
            and is guaranteed to be unique during it's lifetime.
            Ids are not human-readable and shouldn't be displayed, use `name` for that purpose.
            Compositors are expected to only send ids for workspaces likely stable across multiple
            sessions and can be used by clients to store preferences for workspaces. Workspaces without
            ids should be considered temporary and any data associated with them should be deleted once
            the respective object is lost.
            """

            ...

        @staticmethod
        def name(name: string) -> None:
            """
            workspace name changed
            This event is emitted immediately after the ext_workspace_handle_v1 is
            created and whenever the name of the workspace changes.
            A name is meant to be human-readable and can be displayed to a user.
            Unlike the id it is neither stable nor unique.
            """

            ...

        @staticmethod
        def coordinates(coordinates: array) -> None:
            """
            workspace coordinates changed
            This event is used to organize workspaces into an N-dimensional grid
            within a workspace group, and if supported, is emitted immediately after
            the ext_workspace_handle_v1 is created and whenever the coordinates of
            the workspace change. Compositors may not send this event if they do not
            conceptually arrange workspaces in this way. If compositors simply
            number workspaces, without any geometric interpretation, they may send
            1D coordinates, which clients should not interpret as implying any
            geometry. Sending an empty array means that the compositor no longer
            orders the workspace geometrically.
            Coordinates have an arbitrary number of dimensions N with an uint32
            position along each dimension. By convention if N > 1, the first
            dimension is X, the second Y, the third Z, and so on. The compositor may
            chose to utilize these events for a more novel workspace layout
            convention, however. No guarantee is made about the grid being filled or
            bounded; there may be a workspace at coordinate 1 and another at
            coordinate 1000 and none in between. Within a workspace group, however,
            workspaces must have unique coordinates of equal dimensionality.
            """

            ...

        @staticmethod
        def state(state: ext_workspace_handle_v1.state) -> None:
            """
            the state of the workspace changed
            This event is emitted immediately after the ext_workspace_handle_v1 is
            created and each time the workspace state changes, either because of a
            compositor action or because of a request in this protocol.
            Missing states convey the opposite meaning, e.g. an unset active bit
            means the workspace is currently inactive.
            """

            ...

        @staticmethod
        def capabilities(capabilities: ext_workspace_handle_v1.workspace_capabilities) -> None:
            """
            compositor capabilities
            This event advertises the capabilities supported by the compositor. If
            a capability isn't supported, clients should hide or disable the UI
            elements that expose this functionality. For instance, if the
            compositor doesn't advertise support for removing workspaces, a button
            triggering the remove request should not be displayed.
            The compositor will ignore requests it doesn't support. For instance,
            a compositor which doesn't advertise support for remove will ignore
            remove requests.
            Compositors must send this event once after creation of an
            ext_workspace_handle_v1 . When the capabilities change, compositors
            must send this event again.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            this workspace has been removed
            This event is send when the workspace associated with the ext_workspace_handle_v1
            has been removed. After sending this request, the compositor will immediately consider
            the object inert. Any requests will be ignored except the destroy request.
            It is guaranteed there won't be any more events referencing this
            ext_workspace_handle_v1.
            The compositor must only remove a workspaces not currently belonging to any
            workspace_group.
            """

            ...
class ext_session_lock_manager_v1:
    """
    used to lock the session
    This interface is used to request that the session be locked.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the session lock manager object
        This informs the compositor that the session lock manager object will
        no longer be used. Existing objects created through this interface
        remain valid.
        """

        ...

    @staticmethod
    def lock() -> ext_session_lock_v1:
        """
        attempt to lock the session
        This request creates a session lock and asks the compositor to lock the
        session. The compositor will send either the ext_session_lock_v1.locked
        or ext_session_lock_v1.finished event on the created object in
        response to this request.
        """

        ...
class ext_session_lock_v1:
    """
    manage lock state and create lock surfaces
    In response to the creation of this object the compositor must send
    either the locked or finished event.
    The locked event indicates that the session is locked. This means
    that the compositor must stop rendering and providing input to normal
    clients. Instead the compositor must blank all outputs with an opaque
    color such that their normal content is fully hidden.
    The only surfaces that should be rendered while the session is locked
    are the lock surfaces created through this interface and optionally,
    at the compositor's discretion, special privileged surfaces such as
    input methods or portions of desktop shell UIs.
    The locked event must not be sent until a new "locked" frame (either
    from a session lock surface or the compositor blanking the output) has
    been presented on all outputs and no security sensitive normal/unlocked
    content is possibly visible.
    The finished event should be sent immediately on creation of this
    object if the compositor decides that the locked event will not be sent.
    The compositor may wait for the client to create and render session lock
    surfaces before sending the locked event to avoid displaying intermediate
    blank frames. However, it must impose a reasonable time limit if
    waiting and send the locked event as soon as the hard requirements
    described above can be met if the time limit expires. Clients should
    immediately create lock surfaces for all outputs on creation of this
    object to make this possible.
    This behavior of the locked event is required in order to prevent
    possible race conditions with clients that wish to suspend the system
    or similar after locking the session. Without these semantics, clients
    triggering a suspend after receiving the locked event would race with
    the first "locked" frame being presented and normal/unlocked frames
    might be briefly visible as the system is resumed if the suspend
    operation wins the race.
    If the client dies while the session is locked, the compositor must not
    unlock the session in response. It is acceptable for the session to be
    permanently locked if this happens. The compositor may choose to continue
    to display the lock surfaces the client had mapped before it died or
    alternatively fall back to a solid color, this is compositor policy.
    Compositors may also allow a secure way to recover the session, the
    details of this are compositor policy. Compositors may allow a new
    client to create a ext_session_lock_v1 object and take responsibility
    for unlocking the session, they may even start a new lock client
    instance automatically.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_destroy: int
        invalid_unlock: int
        role: int
        duplicate_output: int
        already_constructed: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the session lock
        This informs the compositor that the lock object will no longer be
        used. Existing objects created through this interface remain valid.
        After this request is made, lock surfaces created through this object
        should be destroyed by the client as they will no longer be used by
        the compositor.
        It is a protocol error to make this request if the locked event was
        sent, the unlock_and_destroy request must be used instead.
        """

        ...

    @staticmethod
    def get_lock_surface(surface: object, output: object) -> ext_session_lock_surface_v1:
        """
        create a lock surface for a given output
        The client is expected to create lock surfaces for all outputs
        currently present and any new outputs as they are advertised. These
        won't be displayed by the compositor unless the lock is successful
        and the locked event is sent.
        Providing a wl_surface which already has a role or already has a buffer
        attached or committed is a protocol error, as is attaching/committing
        a buffer before the first ext_session_lock_surface_v1.configure event.
        Attempting to create more than one lock surface for a given output
        is a duplicate_output protocol error.
        """

        ...

    @staticmethod
    def unlock_and_destroy() -> None:
        """
        unlock the session, destroying the object
        This request indicates that the session should be unlocked, for
        example because the user has entered their password and it has been
        verified by the client.
        This request also informs the compositor that the lock object will
        no longer be used and should be destroyed. Existing objects created
        through this interface remain valid.
        After this request is made, lock surfaces created through this object
        should be destroyed by the client as they will no longer be used by
        the compositor.
        It is a protocol error to make this request if the locked event has
        not been sent. In that case, the lock object must be destroyed using
        the destroy request.
        Note that a correct client that wishes to exit directly after unlocking
        the session must use the wl_display.sync request to ensure the server
        receives and processes the unlock_and_destroy request. Otherwise
        there is no guarantee that the server has unlocked the session due
        to the asynchronous nature of the Wayland protocol. For example,
        the server might terminate the client with a protocol error before
        it processes the unlock_and_destroy request.
        """

        ...
    class events:
        @staticmethod
        def locked() -> None:
            """
            session successfully locked
            This client is now responsible for displaying graphics while the
            session is locked and deciding when to unlock the session.
            The locked event must not be sent until a new "locked" frame has been
            presented on all outputs and no security sensitive normal/unlocked
            content is possibly visible.
            If this event is sent, making the destroy request is a protocol error,
            the lock object must be destroyed using the unlock_and_destroy request.
            """

            ...

        @staticmethod
        def finished() -> None:
            """
            the session lock object should be destroyed
            The compositor has decided that the session lock should be destroyed
            as it will no longer be used by the compositor. Exactly when this
            event is sent is compositor policy, but it must never be sent more
            than once for a given session lock object.
            This might be sent because there is already another ext_session_lock_v1
            object held by a client, or the compositor has decided to deny the
            request to lock the session for some other reason. This might also
            be sent because the compositor implements some alternative, secure
            way to authenticate and unlock the session.
            The finished event should be sent immediately on creation of this
            object if the compositor decides that the locked event will not
            be sent.
            If the locked event is sent on creation of this object the finished
            event may still be sent at some later time in this object's
            lifetime. This is compositor policy.
            Upon receiving this event, the client should make either the destroy
            request or the unlock_and_destroy request, depending on whether or
            not the locked event was received on this object.
            """

            ...
class ext_session_lock_surface_v1:
    """
    a surface displayed while the session is locked
    The client may use lock surfaces to display a screensaver, render a
    dialog to enter a password and unlock the session, or however else it
    sees fit.
    On binding this interface the compositor will immediately send the
    first configure event. After making the ack_configure request in
    response to this event the client should attach and commit the first
    buffer. Committing the surface before acking the first configure is a
    protocol error. Committing the surface with a null buffer at any time
    is a protocol error.
    The compositor is free to handle keyboard/pointer focus for lock
    surfaces however it chooses. A reasonable way to do this would be to
    give the first lock surface created keyboard focus and change keyboard
    focus if the user clicks on other surfaces.
    """
    object_id = 0
    version = 1

    class error(Enum):
        commit_before_first_ack: int
        null_buffer: int
        dimensions_mismatch: int
        invalid_serial: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the lock surface object
        This informs the compositor that the lock surface object will no
        longer be used.
        It is recommended for a lock client to destroy lock surfaces if
        their corresponding wl_output global is removed.
        If a lock surface on an active output is destroyed before the
        ext_session_lock_v1.unlock_and_destroy event is sent, the compositor
        must fall back to rendering a solid color.
        """

        ...

    @staticmethod
    def ack_configure(serial: uint) -> None:
        """
        ack a configure event
        When a configure event is received, if a client commits the surface
        in response to the configure event, then the client must make an
        ack_configure request sometime before the commit request, passing
        along the serial of the configure event.
        If the client receives multiple configure events before it can
        respond to one, it only has to ack the last configure event.
        A client is not required to commit immediately after sending an
        ack_configure request - it may even ack_configure several times
        before its next surface commit.
        A client may send multiple ack_configure requests before committing,
        but only the last request sent before a commit indicates which
        configure event the client really is responding to.
        Sending an ack_configure request consumes the configure event
        referenced by the given serial, as well as all older configure events
        sent on this object.
        It is a protocol error to issue multiple ack_configure requests
        referencing the same configure event or to issue an ack_configure
        request referencing a configure event older than the last configure
        event acked for a given lock surface.
        """

        ...
    class events:
        @staticmethod
        def configure(serial: uint, width: uint, height: uint) -> None:
            """
            the client should resize its surface
            This event is sent once on binding the interface and may be sent again
            at the compositor's discretion, for example if output geometry changes.
            The width and height are in surface-local coordinates and are exact
            requirements. Failing to match these surface dimensions in the next
            commit after acking a configure is a protocol error.
            """

            ...
class wp_linux_drm_syncobj_manager_v1:
    """
    global for providing explicit synchronization
    This global is a factory interface, allowing clients to request
    explicit synchronization for buffers on a per-surface basis.
    See wp_linux_drm_syncobj_surface_v1 for more information.
    """
    object_id = 0
    version = 1

    class error(Enum):
        surface_exists: int
        invalid_timeline: int

    @staticmethod
    def destroy() -> None:
        """
        destroy explicit synchronization factory object
        Destroy this explicit synchronization factory object. Other objects
        shall not be affected by this request.
        """

        ...

    @staticmethod
    def get_surface(surface: object) -> wp_linux_drm_syncobj_surface_v1:
        """
        extend surface interface for explicit synchronization
        Instantiate an interface extension for the given wl_surface to provide
        explicit synchronization.
        If the given wl_surface already has an explicit synchronization object
        associated, the surface_exists protocol error is raised.
        Graphics APIs, like EGL or Vulkan, that manage the buffer queue and
        commits of a wl_surface themselves, are likely to be using this
        extension internally. If a client is using such an API for a
        wl_surface, it should not directly use this extension on that surface,
        to avoid raising a surface_exists protocol error.
        """

        ...

    @staticmethod
    def import_timeline(fd: fd) -> wp_linux_drm_syncobj_timeline_v1:
        """
        import a DRM syncobj timeline
        Import a DRM synchronization object timeline.
        If the FD cannot be imported, the invalid_timeline error is raised.
        """

        ...
class wp_linux_drm_syncobj_timeline_v1:
    """
    synchronization object timeline
    This object represents an explicit synchronization object timeline
    imported by the client to the compositor.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the timeline
        Destroy the synchronization object timeline. Other objects are not
        affected by this request, in particular timeline points set by
        set_acquire_point and set_release_point are not unset.
        """

        ...
class wp_linux_drm_syncobj_surface_v1:
    """
    per-surface explicit synchronization
    This object is an add-on interface for wl_surface to enable explicit
    synchronization.
    Each surface can be associated with only one object of this interface at
    any time.
    Explicit synchronization is guaranteed to be supported for buffers
    created with any version of the linux-dmabuf protocol. Compositors are
    free to support explicit synchronization for additional buffer types.
    If at surface commit time the attached buffer does not support explicit
    synchronization, an unsupported_buffer error is raised.
    As long as the wp_linux_drm_syncobj_surface_v1 object is alive, the
    compositor may ignore implicit synchronization for buffers attached and
    committed to the wl_surface. The delivery of wl_buffer.release events
    for buffers attached to the surface becomes undefined.
    Clients must set both acquire and release points if and only if a
    non-null buffer is attached in the same surface commit. See the
    no_buffer, no_acquire_point and no_release_point protocol errors.
    If at surface commit time the acquire and release DRM syncobj timelines
    are identical, the acquire point value must be strictly less than the
    release point value, or else the conflicting_points protocol error is
    raised.
    """
    object_id = 0
    version = 1

    class error(Enum):
        no_surface: int
        unsupported_buffer: int
        no_buffer: int
        no_acquire_point: int
        no_release_point: int
        conflicting_points: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the surface synchronization object
        Destroy this surface synchronization object.
        Any timeline point set by this object with set_acquire_point or
        set_release_point since the last commit may be discarded by the
        compositor. Any timeline point set by this object before the last
        commit will not be affected.
        """

        ...

    @staticmethod
    def set_acquire_point(timeline: object, point_hi: uint, point_lo: uint) -> None:
        """
        set the acquire timeline point
        Set the timeline point that must be signalled before the compositor may
        sample from the buffer attached with wl_surface.attach.
        The 64-bit unsigned value combined from point_hi and point_lo is the
        point value.
        The acquire point is double-buffered state, and will be applied on the
        next wl_surface.commit request for the associated surface. Thus, it
        applies only to the buffer that is attached to the surface at commit
        time.
        If an acquire point has already been attached during the same commit
        cycle, the new point replaces the old one.
        If the associated wl_surface was destroyed, a no_surface error is
        raised.
        If at surface commit time there is a pending acquire timeline point set
        but no pending buffer attached, a no_buffer error is raised. If at
        surface commit time there is a pending buffer attached but no pending
        acquire timeline point set, the no_acquire_point protocol error is
        raised.
        """

        ...

    @staticmethod
    def set_release_point(timeline: object, point_hi: uint, point_lo: uint) -> None:
        """
        set the release timeline point
        Set the timeline point that must be signalled by the compositor when it
        has finished its usage of the buffer attached with wl_surface.attach
        for the relevant commit.
        Once the timeline point is signaled, and assuming the associated buffer
        is not pending release from other wl_surface.commit requests, no
        additional explicit or implicit synchronization with the compositor is
        required to safely re-use the buffer.
        Note that clients cannot rely on the release point being always
        signaled after the acquire point: compositors may release buffers
        without ever reading from them. In addition, the compositor may use
        different presentation paths for different commits, which may have
        different release behavior. As a result, the compositor may signal the
        release points in a different order than the client committed them.
        Because signaling a timeline point also signals every previous point,
        it is generally not safe to use the same timeline object for the
        release points of multiple buffers. The out-of-order signaling
        described above may lead to a release point being signaled before the
        compositor has finished reading. To avoid this, it is strongly
        recommended that each buffer should use a separate timeline for its
        release points.
        The 64-bit unsigned value combined from point_hi and point_lo is the
        point value.
        The release point is double-buffered state, and will be applied on the
        next wl_surface.commit request for the associated surface. Thus, it
        applies only to the buffer that is attached to the surface at commit
        time.
        If a release point has already been attached during the same commit
        cycle, the new point replaces the old one.
        If the associated wl_surface was destroyed, a no_surface error is
        raised.
        If at surface commit time there is a pending release timeline point set
        but no pending buffer attached, a no_buffer error is raised. If at
        surface commit time there is a pending buffer attached but no pending
        release timeline point set, the no_release_point protocol error is
        raised.
        """

        ...
class xdg_toplevel_icon_manager_v1:
    """
    interface to manage toplevel icons
    This interface allows clients to create toplevel window icons and set
    them on toplevel windows to be displayed to the user.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the toplevel icon manager
        Destroy the toplevel icon manager.
        This does not destroy objects created with the manager.
        """

        ...

    @staticmethod
    def create_icon() -> xdg_toplevel_icon_v1:
        """
        create a new icon instance
        Creates a new icon object. This icon can then be attached to a
        xdg_toplevel via the 'set_icon' request.
        """

        ...

    @staticmethod
    def set_icon(toplevel: object, icon: object) -> None:
        """
        set an icon on a toplevel window
        This request assigns the icon 'icon' to 'toplevel', or clears the
        toplevel icon if 'icon' was null.
        This state is double-buffered and is applied on the next
        wl_surface.commit of the toplevel.
        After making this call, the xdg_toplevel_icon_v1 provided as 'icon'
        can be destroyed by the client without 'toplevel' losing its icon.
        The xdg_toplevel_icon_v1 is immutable from this point, and any
        future attempts to change it must raise the
        'xdg_toplevel_icon_v1.immutable' protocol error.
        The compositor must set the toplevel icon from either the pixel data
        the icon provides, or by loading a stock icon using the icon name.
        See the description of 'xdg_toplevel_icon_v1' for details.
        If 'icon' is set to null, the icon of the respective toplevel is reset
        to its default icon (usually the icon of the application, derived from
        its desktop-entry file, or a placeholder icon).
        If this request is passed an icon with no pixel buffers or icon name
        assigned, the icon must be reset just like if 'icon' was null.
        """

        ...
    class events:
        @staticmethod
        def icon_size(size: int) -> None:
            """
            describes a supported & preferred icon size
            This event indicates an icon size the compositor prefers to be
            available if the client has scalable icons and can render to any size.
            When the 'xdg_toplevel_icon_manager_v1' object is created, the
            compositor may send one or more 'icon_size' events to describe the list
            of preferred icon sizes. If the compositor has no size preference, it
            may not send any 'icon_size' event, and it is up to the client to
            decide a suitable icon size.
            A sequence of 'icon_size' events must be finished with a 'done' event.
            If the compositor has no size preferences, it must still send the
            'done' event, without any preceding 'icon_size' events.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all information has been sent
            This event is sent after all 'icon_size' events have been sent.
            """

            ...
class xdg_toplevel_icon_v1:
    """
    a toplevel window icon
    This interface defines a toplevel icon.
    An icon can have a name, and multiple buffers.
    In order to be applied, the icon must have either a name, or at least
    one buffer assigned. Applying an empty icon (with no buffer or name) to
    a toplevel should reset its icon to the default icon.
    It is up to compositor policy whether to prefer using a buffer or loading
    an icon via its name. See 'set_name' and 'add_buffer' for details.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_buffer: int
        immutable: int
        no_buffer: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the icon object
        Destroys the 'xdg_toplevel_icon_v1' object.
        The icon must still remain set on every toplevel it was assigned to,
        until the toplevel icon is reset explicitly.
        """

        ...

    @staticmethod
    def set_name(icon_name: string) -> None:
        """
        set an icon name
        This request assigns an icon name to this icon.
        Any previously set name is overridden.
        The compositor must resolve 'icon_name' according to the lookup rules
        described in the XDG icon theme specification[1] using the
        environment's current icon theme.
        If the compositor does not support icon names or cannot resolve
        'icon_name' according to the XDG icon theme specification it must
        fall back to using pixel buffer data instead.
        If this request is made after the icon has been assigned to a toplevel
        via 'set_icon', a 'immutable' error must be raised.
        [1]: https://specifications.freedesktop.org/icon-theme-spec/icon-theme-spec-latest.html
        """

        ...

    @staticmethod
    def add_buffer(buffer: object, scale: int) -> None:
        """
        add icon data from a pixel buffer
        This request adds pixel data supplied as wl_buffer to the icon.
        The client should add pixel data for all icon sizes and scales that
        it can provide, or which are explicitly requested by the compositor
        via 'icon_size' events on xdg_toplevel_icon_manager_v1.
        The wl_buffer supplying pixel data as 'buffer' must be backed by wl_shm
        and must be a square (width and height being equal).
        If any of these buffer requirements are not fulfilled, a 'invalid_buffer'
        error must be raised.
        If this icon instance already has a buffer of the same size and scale
        from a previous 'add_buffer' request, data from the last request
        overrides the preexisting pixel data.
        The wl_buffer must be kept alive for as long as the xdg_toplevel_icon
        it is associated with is not destroyed, otherwise a 'no_buffer' error
        is raised. The buffer contents must not be modified after it was
        assigned to the icon. As a result, the region of the wl_shm_pool's
        backing storage used for the wl_buffer must not be modified after this
        request is sent. The wl_buffer.release event is unused.
        If this request is made after the icon has been assigned to a toplevel
        via 'set_icon', a 'immutable' error must be raised.
        """

        ...
class ext_idle_notifier_v1:
    """
    idle notification manager
    This interface allows clients to monitor user idle status.
    After binding to this global, clients can create ext_idle_notification_v1
    objects to get notified when the user is idle for a given amount of time.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        Destroy the manager object. All objects created via this interface
        remain valid.
        """

        ...

    @staticmethod
    def get_idle_notification(timeout: uint, seat: object) -> ext_idle_notification_v1:
        """
        create a notification object
        Create a new idle notification object.
        The notification object has a minimum timeout duration and is tied to a
        seat. The client will be notified if the seat is inactive for at least
        the provided timeout. See ext_idle_notification_v1 for more details.
        A zero timeout is valid and means the client wants to be notified as
        soon as possible when the seat is inactive.
        """

        ...

    @staticmethod
    def get_input_idle_notification(timeout: uint, seat: object) -> ext_idle_notification_v1:
        """
        create a notification object
        Create a new idle notification object to track input from the
        user, such as keyboard and mouse movement. Because this object is
        meant to track user input alone, it ignores idle inhibitors.
        The notification object has a minimum timeout duration and is tied to a
        seat. The client will be notified if the seat is inactive for at least
        the provided timeout. See ext_idle_notification_v1 for more details.
        A zero timeout is valid and means the client wants to be notified as
        soon as possible when the seat is inactive.
        """

        ...
class ext_idle_notification_v1:
    """
    idle notification
    This interface is used by the compositor to send idle notification events
    to clients.
    Initially the notification object is not idle. The notification object
    becomes idle when no user activity has happened for at least the timeout
    duration, starting from the creation of the notification object. User
    activity may include input events or a presence sensor, but is
    compositor-specific.
    How this notification responds to idle inhibitors depends on how
    it was constructed. If constructed from the
    get_idle_notification request, then if an idle inhibitor is
    active (e.g. another client has created a zwp_idle_inhibitor_v1
    on a visible surface), the compositor must not make the
    notification object idle. However, if constructed from the
    get_input_idle_notification request, then idle inhibitors are
    ignored, and only input from the user, e.g. from a keyboard or
    mouse, counts as activity.
    When the notification object becomes idle, an idled event is sent. When
    user activity starts again, the notification object stops being idle,
    a resumed event is sent and the timeout is restarted.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        destroy the notification object
        Destroy the notification object.
        """

        ...
    class events:
        @staticmethod
        def idled() -> None:
            """
            notification object is idle
            This event is sent when the notification object becomes idle.
            It's a compositor protocol error to send this event twice without a
            resumed event in-between.
            """

            ...

        @staticmethod
        def resumed() -> None:
            """
            notification object is no longer idle
            This event is sent when the notification object stops being idle.
            It's a compositor protocol error to send this event twice without an
            idled event in-between. It's a compositor protocol error to send this
            event prior to any idled event.
            """

            ...
class ext_data_control_manager_v1:
    """
    manager to control data devices
    This interface is a manager that allows creating per-seat data device
    controls.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_data_source() -> ext_data_control_source_v1:
        """
        create a new data source
        Create a new data source.
        """

        ...

    @staticmethod
    def get_data_device(seat: object) -> ext_data_control_device_v1:
        """
        get a data device for a seat
        Create a data device that can be used to manage a seat's selection.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        All objects created by the manager will still remain valid, until their
        appropriate destroy request has been called.
        """

        ...
class ext_data_control_device_v1:
    """
    manage a data device for a seat
    This interface allows a client to manage a seat's selection.
    When the seat is destroyed, this object becomes inert.
    """
    object_id = 0
    version = 1

    class error(Enum):
        used_source: int

    @staticmethod
    def set_selection(source: object) -> None:
        """
        copy data to the selection
        This request asks the compositor to set the selection to the data from
        the source on behalf of the client.
        The given source may not be used in any further set_selection or
        set_primary_selection requests. Attempting to use a previously used
        source triggers the used_source protocol error.
        To unset the selection, set the source to NULL.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy this data device
        Destroys the data device object.
        """

        ...

    @staticmethod
    def set_primary_selection(source: object) -> None:
        """
        copy data to the primary selection
        This request asks the compositor to set the primary selection to the
        data from the source on behalf of the client.
        The given source may not be used in any further set_selection or
        set_primary_selection requests. Attempting to use a previously used
        source triggers the used_source protocol error.
        To unset the primary selection, set the source to NULL.
        The compositor will ignore this request if it does not support primary
        selection.
        """

        ...
    class events:
        @staticmethod
        def data_offer(id: ext_data_control_offer_v1) -> None:
            """
            introduce a new ext_data_control_offer
            The data_offer event introduces a new ext_data_control_offer object,
            which will subsequently be used in either the
            ext_data_control_device.selection event (for the regular clipboard
            selections) or the ext_data_control_device.primary_selection event (for
            the primary clipboard selections). Immediately following the
            ext_data_control_device.data_offer event, the new data_offer object
            will send out ext_data_control_offer.offer events to describe the MIME
            types it offers.
            """

            ...

        @staticmethod
        def selection(id: object) -> None:
            """
            advertise new selection
            The selection event is sent out to notify the client of a new
            ext_data_control_offer for the selection for this device. The
            ext_data_control_device.data_offer and the ext_data_control_offer.offer
            events are sent out immediately before this event to introduce the data
            offer object. The selection event is sent to a client when a new
            selection is set. The ext_data_control_offer is valid until a new
            ext_data_control_offer or NULL is received. The client must destroy the
            previous selection ext_data_control_offer, if any, upon receiving this
            event. Regardless, the previous selection will be ignored once a new
            selection ext_data_control_offer is received.
            The first selection event is sent upon binding the
            ext_data_control_device object.
            """

            ...

        @staticmethod
        def finished() -> None:
            """
            this data control is no longer valid
            This data control object is no longer valid and should be destroyed by
            the client.
            """

            ...

        @staticmethod
        def primary_selection(id: object) -> None:
            """
            advertise new primary selection
            The primary_selection event is sent out to notify the client of a new
            ext_data_control_offer for the primary selection for this device. The
            ext_data_control_device.data_offer and the ext_data_control_offer.offer
            events are sent out immediately before this event to introduce the data
            offer object. The primary_selection event is sent to a client when a
            new primary selection is set. The ext_data_control_offer is valid until
            a new ext_data_control_offer or NULL is received. The client must
            destroy the previous primary selection ext_data_control_offer, if any,
            upon receiving this event. Regardless, the previous primary selection
            will be ignored once a new primary selection ext_data_control_offer is
            received.
            If the compositor supports primary selection, the first
            primary_selection event is sent upon binding the
            ext_data_control_device object.
            """

            ...
class ext_data_control_source_v1:
    """
    offer to transfer data
    The ext_data_control_source object is the source side of a
    ext_data_control_offer. It is created by the source client in a data
    transfer and provides a way to describe the offered data and a way to
    respond to requests to transfer the data.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_offer: int

    @staticmethod
    def offer(mime_type: string) -> None:
        """
        add an offered MIME type
        This request adds a MIME type to the set of MIME types advertised to
        targets. Can be called several times to offer multiple types.
        Calling this after ext_data_control_device.set_selection is a protocol
        error.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy this source
        Destroys the data source object.
        """

        ...
    class events:
        @staticmethod
        def send(mime_type: string, fd: fd) -> None:
            """
            send the data
            Request for data from the client. Send the data as the specified MIME
            type over the passed file descriptor, then close it.
            """

            ...

        @staticmethod
        def cancelled() -> None:
            """
            selection was cancelled
            This data source is no longer valid. The data source has been replaced
            by another data source.
            The client should clean up and destroy this data source.
            """

            ...
class ext_data_control_offer_v1:
    """
    offer to transfer data
    A ext_data_control_offer represents a piece of data offered for transfer
    by another client (the source client). The offer describes the different
    MIME types that the data can be converted to and provides the mechanism
    for transferring the data directly from the source client.
    """
    object_id = 0
    version = 1

    @staticmethod
    def receive(mime_type: string, fd: fd) -> None:
        """
        request that the data is transferred
        To transfer the offered data, the client issues this request and
        indicates the MIME type it wants to receive. The transfer happens
        through the passed file descriptor (typically created with the pipe
        system call). The source client writes the data in the MIME type
        representation requested and then closes the file descriptor.
        The receiving client reads from the read end of the pipe until EOF and
        then closes its end, at which point the transfer is complete.
        This request may happen multiple times for different MIME types.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy this offer
        Destroys the data offer object.
        """

        ...
    class events:
        @staticmethod
        def offer(mime_type: string) -> None:
            """
            advertise offered MIME type
            Sent immediately after creating the ext_data_control_offer object.
            One event per offered MIME type.
            """

            ...
class ext_image_copy_capture_manager_v1:
    """
    manager to inform clients and begin capturing
    This object is a manager which offers requests to start capturing from a
    source.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_option: int


    class options(IntFlag):
        paint_cursors: int

    @staticmethod
    def create_session(source: object, options: ext_image_copy_capture_manager_v1.options) -> ext_image_copy_capture_session_v1:
        """
        capture an image capture source
        Create a capturing session for an image capture source.
        If the paint_cursors option is set, cursors shall be composited onto
        the captured frame. The cursor must not be composited onto the frame
        if this flag is not set.
        If the options bitfield is invalid, the invalid_option protocol error
        is sent.
        """

        ...

    @staticmethod
    def create_pointer_cursor_session(source: object, pointer: object) -> ext_image_copy_capture_cursor_session_v1:
        """
        capture the pointer cursor of an image capture source
        Create a cursor capturing session for the pointer of an image capture
        source.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        Destroy the manager object.
        Other objects created via this interface are unaffected.
        """

        ...
class ext_image_copy_capture_session_v1:
    """
    image copy capture session
    This object represents an active image copy capture session.
    After a capture session is created, buffer constraint events will be
    emitted from the compositor to tell the client which buffer types and
    formats are supported for reading from the session. The compositor may
    re-send buffer constraint events whenever they change.
    To advertise buffer constraints, the compositor must send in no
    particular order: zero or more shm_format and dmabuf_format events, zero
    or one dmabuf_device event, and exactly one buffer_size event. Then the
    compositor must send a done event.
    When the client has received all the buffer constraints, it can create a
    buffer accordingly, attach it to the capture session using the
    attach_buffer request, set the buffer damage using the damage_buffer
    request and then send the capture request.
    """
    object_id = 0
    version = 1

    class error(Enum):
        duplicate_frame: int

    @staticmethod
    def create_frame() -> ext_image_copy_capture_frame_v1:
        """
        create a frame
        Create a capture frame for this session.
        At most one frame object can exist for a given session at any time. If
        a client sends a create_frame request before a previous frame object
        has been destroyed, the duplicate_frame protocol error is raised.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        delete this object
        Destroys the session. This request can be sent at any time by the
        client.
        This request doesn't affect ext_image_copy_capture_frame_v1 objects created by
        this object.
        """

        ...
    class events:
        @staticmethod
        def buffer_size(width: uint, height: uint) -> None:
            """
            image capture source dimensions
            Provides the dimensions of the source image in buffer pixel coordinates.
            The client must attach buffers that match this size.
            """

            ...

        @staticmethod
        def shm_format(format: ext_image_copy_capture_session_v1.wl_shm.format) -> None:
            """
            shm buffer format
            Provides the format that must be used for shared-memory buffers.
            This event may be emitted multiple times, in which case the client may
            choose any given format.
            """

            ...

        @staticmethod
        def dmabuf_device(device: array) -> None:
            """
            dma-buf device
            This event advertises the device buffers must be allocated on for
            dma-buf buffers.
            In general the device is a DRM node. The DRM node type (primary vs.
            render) is unspecified. Clients must not rely on the compositor sending
            a particular node type. Clients cannot check two devices for equality
            by comparing the dev_t value.
            """

            ...

        @staticmethod
        def dmabuf_format(format: uint, modifiers: array) -> None:
            """
            dma-buf format
            Provides the format that must be used for dma-buf buffers.
            The client may choose any of the modifiers advertised in the array of
            64-bit unsigned integers.
            This event may be emitted multiple times, in which case the client may
            choose any given format.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all constraints have been sent
            This event is sent once when all buffer constraint events have been
            sent.
            The compositor must always end a batch of buffer constraint events with
            this event, regardless of whether it sends the initial constraints or
            an update.
            """

            ...

        @staticmethod
        def stopped() -> None:
            """
            session is no longer available
            This event indicates that the capture session has stopped and is no
            longer available. This can happen in a number of cases, e.g. when the
            underlying source is destroyed, if the user decides to end the image
            capture, or if an unrecoverable runtime error has occurred.
            The client should destroy the session after receiving this event.
            """

            ...
class ext_image_copy_capture_frame_v1:
    """
    image capture frame
    This object represents an image capture frame.
    The client should attach a buffer, damage the buffer, and then send a
    capture request.
    If the capture is successful, the compositor must send the frame metadata
    (transform, damage, presentation_time in any order) followed by the ready
    event.
    If the capture fails, the compositor must send the failed event.
    """
    object_id = 0
    version = 1

    class error(Enum):
        no_buffer: int
        invalid_buffer_damage: int
        already_captured: int


    class failure_reason(Enum):
        unknown: int
        buffer_constraints: int
        stopped: int

    @staticmethod
    def destroy() -> None:
        """
        destroy this object
        Destroys the frame. This request can be sent at any time by the
        client.
        """

        ...

    @staticmethod
    def attach_buffer(buffer: object) -> None:
        """
        attach buffer to session
        Attach a buffer to the session.
        The wl_buffer.release request is unused.
        The new buffer replaces any previously attached buffer.
        This request must not be sent after capture, or else the
        already_captured protocol error is raised.
        """

        ...

    @staticmethod
    def damage_buffer(x: int, y: int, width: int, height: int) -> None:
        """
        damage buffer
        Apply damage to the buffer which is to be captured next. This request
        may be sent multiple times to describe a region.
        The client indicates the accumulated damage since this wl_buffer was
        last captured. During capture, the compositor will update the buffer
        with at least the union of the region passed by the client and the
        region advertised by ext_image_copy_capture_frame_v1.damage.
        When a wl_buffer is captured for the first time, or when the client
        doesn't track damage, the client must damage the whole buffer.
        This is for optimisation purposes. The compositor may use this
        information to reduce copying.
        These coordinates originate from the upper left corner of the buffer.
        If x or y are strictly negative, or if width or height are negative or
        zero, the invalid_buffer_damage protocol error is raised.
        This request must not be sent after capture, or else the
        already_captured protocol error is raised.
        """

        ...

    @staticmethod
    def capture() -> None:
        """
        capture a frame
        Capture a frame.
        Unless this is the first successful captured frame performed in this
        session, the compositor may wait an indefinite amount of time for the
        source content to change before performing the copy.
        This request may only be sent once, or else the already_captured
        protocol error is raised. A buffer must be attached before this request
        is sent, or else the no_buffer protocol error is raised.
        """

        ...
    class events:
        @staticmethod
        def transform(transform: ext_image_copy_capture_frame_v1.wl_output.transform) -> None:
            """
            buffer transform
            This event is sent before the ready event and holds the transform that
            the compositor has applied to the buffer contents.
            """

            ...

        @staticmethod
        def damage(x: int, y: int, width: int, height: int) -> None:
            """
            buffer damaged region
            This event is sent before the ready event. It may be generated multiple
            times to describe a region.
            The first captured frame in a session will always carry full damage.
            Subsequent frames' damaged regions describe which parts of the buffer
            have changed since the last ready event.
            These coordinates originate in the upper left corner of the buffer.
            """

            ...

        @staticmethod
        def presentation_time(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint) -> None:
            """
            presentation time of the frame
            This event indicates the time at which the frame is presented to the
            output in system monotonic time. This event is sent before the ready
            event.
            The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec triples,
            each component being an unsigned 32-bit value. Whole seconds are in
            tv_sec which is a 64-bit value combined from tv_sec_hi and tv_sec_lo,
            and the additional fractional part in tv_nsec as nanoseconds. Hence,
            for valid timestamps tv_nsec must be in [0, 999999999].
            """

            ...

        @staticmethod
        def ready() -> None:
            """
            frame is available for reading
            Called as soon as the frame is copied, indicating it is available
            for reading.
            The buffer may be re-used by the client after this event.
            After receiving this event, the client must destroy the object.
            """

            ...

        @staticmethod
        def failed(reason: ext_image_copy_capture_frame_v1.failure_reason) -> None:
            """
            capture failed
            This event indicates that the attempted frame copy has failed.
            After receiving this event, the client must destroy the object.
            """

            ...
class ext_image_copy_capture_cursor_session_v1:
    """
    cursor capture session
    This object represents a cursor capture session. It extends the base
    capture session with cursor-specific metadata.
    """
    object_id = 0
    version = 1

    class error(Enum):
        duplicate_session: int

    @staticmethod
    def destroy() -> None:
        """
        delete this object
        Destroys the session. This request can be sent at any time by the
        client.
        This request doesn't affect ext_image_copy_capture_frame_v1 objects created by
        this object.
        """

        ...

    @staticmethod
    def get_capture_session() -> ext_image_copy_capture_session_v1:
        """
        get image copy capturer session
        Gets the image copy capture session for this cursor session.
        The session will produce frames of the cursor image. The compositor may
        pause the session when the cursor leaves the captured area.
        This request must not be sent more than once, or else the
        duplicate_session protocol error is raised.
        """

        ...
    class events:
        @staticmethod
        def enter() -> None:
            """
            cursor entered captured area
            Sent when a cursor enters the captured area. It shall be generated
            before the "position" and "hotspot" events when and only when a cursor
            enters the area.
            The cursor enters the captured area when the cursor image intersects
            with the captured area. Note, this is different from e.g.
            wl_pointer.enter.
            """

            ...

        @staticmethod
        def leave() -> None:
            """
            cursor left captured area
            Sent when a cursor leaves the captured area. No "position" or "hotspot"
            event is generated for the cursor until the cursor enters the captured
            area again.
            """

            ...

        @staticmethod
        def position(x: int, y: int) -> None:
            """
            position changed
            Cursors outside the image capture source do not get captured and no
            event will be generated for them.
            The given position is the position of the cursor's hotspot and it is
            relative to the main buffer's top left corner in transformed buffer
            pixel coordinates. The coordinates may be negative or greater than the
            main buffer size.
            """

            ...

        @staticmethod
        def hotspot(x: int, y: int) -> None:
            """
            hotspot changed
            The hotspot describes the offset between the cursor image and the
            position of the input device.
            The given coordinates are the hotspot's offset from the origin in
            buffer coordinates.
            Clients should not apply the hotspot immediately: the hotspot becomes
            effective when the next ext_image_copy_capture_frame_v1.ready event is received.
            Compositors may delay this event until the client captures a new frame.
            """

            ...
class wp_alpha_modifier_v1:
    """
    surface alpha modifier manager
    This interface allows a client to set a factor for the alpha values on a
    surface, which can be used to offload such operations to the compositor,
    which can in turn for example offload them to KMS.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_constructed: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the alpha modifier manager object
        Destroy the alpha modifier manager. This doesn't destroy objects
        created with the manager.
        """

        ...

    @staticmethod
    def get_surface(surface: object) -> wp_alpha_modifier_surface_v1:
        """
        create a new alpha modifier surface object
        Create a new alpha modifier surface object associated with the
        given wl_surface. If there is already such an object associated with
        the wl_surface, the already_constructed error will be raised.
        """

        ...
class wp_alpha_modifier_surface_v1:
    """
    alpha modifier object for a surface
    This interface allows the client to set a factor for the alpha values on
    a surface, which can be used to offload such operations to the compositor.
    The default factor is UINT32_MAX.
    This object has to be destroyed before the associated wl_surface. Once the
    wl_surface is destroyed, all request on this object will raise the
    no_surface error.
    """
    object_id = 0
    version = 1

    class error(Enum):
        no_surface: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the alpha modifier object
        This destroys the object, and is equivalent to set_multiplier with
        a value of UINT32_MAX, with the same double-buffered semantics as
        set_multiplier.
        """

        ...

    @staticmethod
    def set_multiplier(factor: uint) -> None:
        """
        specify the alpha multiplier
        Sets the alpha multiplier for the surface. The alpha multiplier is
        double-buffered state, see wl_surface.commit for details.
        This factor is applied in the compositor's blending space, as an
        additional step after the processing of per-pixel alpha values for the
        wl_surface. The exact meaning of the factor is thus undefined, unless
        the blending space is specified in a different extension.
        This multiplier is applied even if the buffer attached to the
        wl_surface doesn't have an alpha channel; in that case an alpha value
        of one is used instead.
        Zero means completely transparent, UINT32_MAX means completely opaque.
        """

        ...
class wp_security_context_manager_v1:
    """
    client security context manager
    This interface allows a client to register a new Wayland connection to
    the compositor and attach a security context to it.
    This is intended to be used by sandboxes. Sandbox engines attach a
    security context to all connections coming from inside the sandbox. The
    compositor can then restrict the features that the sandboxed connections
    can use.
    Compositors should forbid nesting multiple security contexts by not
    exposing wp_security_context_manager_v1 global to clients with a security
    context attached, or by sending the nested protocol error. Nested
    security contexts are dangerous because they can potentially allow
    privilege escalation of a sandboxed client.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_listen_fd: int
        nested: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager object
        Destroy the manager. This doesn't destroy objects created with the
        manager.
        """

        ...

    @staticmethod
    def create_listener(listen_fd: fd, close_fd: fd) -> wp_security_context_v1:
        """
        create a new security context
        Creates a new security context with a socket listening FD.
        The compositor will accept new client connections on listen_fd.
        listen_fd must be ready to accept new connections when this request is
        sent by the client. In other words, the client must call bind(2) and
        listen(2) before sending the FD.
        close_fd is a FD that will signal hangup when the compositor should stop
        accepting new connections on listen_fd.
        The compositor must continue to accept connections on listen_fd when
        the Wayland client which created the security context disconnects.
        After sending this request, closing listen_fd and close_fd remains the
        only valid operation on them.
        """

        ...
class wp_security_context_v1:
    """
    client security context
    The security context allows a client to register a new client and attach
    security context metadata to the connections.
    When both are set, the combination of the application ID and the sandbox
    engine must uniquely identify an application. The same application ID
    will be used across instances (e.g. if the application is restarted, or
    if the application is started multiple times).
    When both are set, the combination of the instance ID and the sandbox
    engine must uniquely identify a running instance of an application.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_used: int
        already_set: int
        invalid_metadata: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the security context object
        Destroy the security context object.
        """

        ...

    @staticmethod
    def set_sandbox_engine(name: string) -> None:
        """
        set the sandbox engine
        Attach a unique sandbox engine name to the security context. The name
        should follow the reverse-DNS style (e.g. "org.flatpak").
        A list of well-known engines is maintained at:
        https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md
        It is a protocol error to call this request twice. The already_set
        error is sent in this case.
        """

        ...

    @staticmethod
    def set_app_id(app_id: string) -> None:
        """
        set the application ID
        Attach an application ID to the security context.
        The application ID is an opaque, sandbox-specific identifier for an
        application. See the well-known engines document for more details:
        https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md
        The compositor may use the application ID to group clients belonging to
        the same security context application.
        Whether this request is optional or not depends on the sandbox engine used.
        It is a protocol error to call this request twice. The already_set
        error is sent in this case.
        """

        ...

    @staticmethod
    def set_instance_id(instance_id: string) -> None:
        """
        set the instance ID
        Attach an instance ID to the security context.
        The instance ID is an opaque, sandbox-specific identifier for a running
        instance of an application. See the well-known engines document for
        more details:
        https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md
        Whether this request is optional or not depends on the sandbox engine used.
        It is a protocol error to call this request twice. The already_set
        error is sent in this case.
        """

        ...

    @staticmethod
    def commit() -> None:
        """
        register the security context
        Atomically register the new client and attach the security context
        metadata.
        If the provided metadata is inconsistent or does not match with out of
        band metadata (see
        https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md),
        the invalid_metadata error may be sent eventually.
        It's a protocol error to send any request other than "destroy" after
        this request. In this case, the already_used error is sent.
        """

        ...
class wp_tearing_control_manager_v1:
    """
    protocol for tearing control
    For some use cases like games or drawing tablets it can make sense to
    reduce latency by accepting tearing with the use of asynchronous page
    flips. This global is a factory interface, allowing clients to inform
    which type of presentation the content of their surfaces is suitable for.
    Graphics APIs like EGL or Vulkan, that manage the buffer queue and commits
    of a wl_surface themselves, are likely to be using this extension
    internally. If a client is using such an API for a wl_surface, it should
    not directly use this extension on that surface, to avoid raising a
    tearing_control_exists protocol error.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    class error(Enum):
        tearing_control_exists: int

    @staticmethod
    def destroy() -> None:
        """
        destroy tearing control factory object
        Destroy this tearing control factory object. Other objects, including
        wp_tearing_control_v1 objects created by this factory, are not affected
        by this request.
        """

        ...

    @staticmethod
    def get_tearing_control(surface: object) -> wp_tearing_control_v1:
        """
        extend surface interface for tearing control
        Instantiate an interface extension for the given wl_surface to request
        asynchronous page flips for presentation.
        If the given wl_surface already has a wp_tearing_control_v1 object
        associated, the tearing_control_exists protocol error is raised.
        """

        ...
class wp_tearing_control_v1:
    """
    per-surface tearing control interface
    An additional interface to a wl_surface object, which allows the client
    to hint to the compositor if the content on the surface is suitable for
    presentation with tearing.
    The default presentation hint is vsync. See presentation_hint for more
    details.
    If the associated wl_surface is destroyed, this object becomes inert and
    should be destroyed.
    """
    object_id = 0
    version = 1

    class presentation_hint(Enum):
        vsync: int
        async_: int

    @staticmethod
    def set_presentation_hint(hint: wp_tearing_control_v1.presentation_hint) -> None:
        """
        set presentation hint
        Set the presentation hint for the associated wl_surface. This state is
        double-buffered, see wl_surface.commit.
        The compositor is free to dynamically respect or ignore this hint based
        on various conditions like hardware capabilities, surface state and
        user preferences.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy tearing control object
        Destroy this surface tearing object and revert the presentation hint to
        vsync. The change will be applied on the next wl_surface.commit.
        """

        ...
class wp_drm_lease_device_v1:
    """
    lease device
    This protocol is used by Wayland compositors which act as Direct
    Rendering Manager (DRM) masters to lease DRM resources to Wayland
    clients.
    The compositor will advertise one wp_drm_lease_device_v1 global for each
    DRM node. Some time after a client binds to the wp_drm_lease_device_v1
    global, the compositor will send a drm_fd event followed by zero, one or
    more connector events. After all currently available connectors have been
    sent, the compositor will send a wp_drm_lease_device_v1.done event.
    When the list of connectors available for lease changes the compositor
    will send wp_drm_lease_device_v1.connector events for added connectors and
    wp_drm_lease_connector_v1.withdrawn events for removed connectors,
    followed by a wp_drm_lease_device_v1.done event.
    The compositor will indicate when a device is gone by removing the global
    via a wl_registry.global_remove event. Upon receiving this event, the
    client should destroy any matching wp_drm_lease_device_v1 object.
    To destroy a wp_drm_lease_device_v1 object, the client must first issue
    a release request. Upon receiving this request, the compositor will
    immediately send a released event and destroy the object. The client must
    continue to process and discard drm_fd and connector events until it
    receives the released event. Upon receiving the released event, the
    client can safely cleanup any client-side resources.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_lease_request() -> wp_drm_lease_request_v1:
        """
        create a lease request object
        Creates a lease request object.
        See the documentation for wp_drm_lease_request_v1 for details.
        """

        ...

    @staticmethod
    def release() -> None:
        """
        release this object
        Indicates the client no longer wishes to use this object. In response
        the compositor will immediately send the released event and destroy
        this object. It can however not guarantee that the client won't receive
        connector events before the released event. The client must not send any
        requests after this one, doing so will raise a wl_display error.
        Existing connectors, lease request and leases will not be affected.
        """

        ...
    class events:
        @staticmethod
        def drm_fd(fd: fd) -> None:
            """
            open a non-master fd for this DRM node
            The compositor will send this event when the wp_drm_lease_device_v1
            global is bound, although there are no guarantees as to how long this
            takes - the compositor might need to wait until regaining DRM master.
            The included fd is a non-master DRM file descriptor opened for this
            device and the compositor must not authenticate it.
            The purpose of this event is to give the client the ability to
            query DRM and discover information which may help them pick the
            appropriate DRM device or select the appropriate connectors therein.
            """

            ...

        @staticmethod
        def connector(id: wp_drm_lease_connector_v1) -> None:
            """
            advertise connectors available for leases
            The compositor will use this event to advertise connectors available for
            lease by clients. This object may be passed into a lease request to
            indicate the client would like to lease that connector, see
            wp_drm_lease_request_v1.request_connector for details. While the
            compositor will make a best effort to not send disconnected connectors,
            no guarantees can be made.
            The compositor must send the drm_fd event before sending connectors.
            After the drm_fd event it will send all available connectors but may
            send additional connectors at any time.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            signals grouping of connectors
            The compositor will send this event to indicate that it has sent all
            currently available connectors after the client binds to the global or
            when it updates the connector list, for example on hotplug, drm master
            change or when a leased connector becomes available again. It will
            similarly send this event to group wp_drm_lease_connector_v1.withdrawn
            events of connectors of this device.
            """

            ...

        @staticmethod
        def released() -> None:
            """
            the compositor has finished using the device
            This event is sent in response to the release request and indicates
            that the compositor is done sending connector events.
            The compositor will destroy this object immediately after sending the
            event and it will become invalid. The client should release any
            resources associated with this device after receiving this event.
            """

            ...
class wp_drm_lease_connector_v1:
    """
    a leasable DRM connector
    Represents a DRM connector which is available for lease. These objects are
    created via wp_drm_lease_device_v1.connector events, and should be passed
    to lease requests via wp_drm_lease_request_v1.request_connector.
    Immediately after the wp_drm_lease_connector_v1 object is created the
    compositor will send a name, a description, a connector_id and a done
    event. When the description is updated the compositor will send a
    description event followed by a done event.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy connector
        The client may send this request to indicate that it will not use this
        connector. Clients are encouraged to send this after receiving the
        "withdrawn" event so that the server can release the resources
        associated with this connector offer. Neither existing lease requests
        nor leases will be affected.
        """

        ...
    class events:
        @staticmethod
        def name(name: string) -> None:
            """
            name
            The compositor sends this event once the connector is created to
            indicate the name of this connector. This will not change for the
            duration of the Wayland session, but is not guaranteed to be consistent
            between sessions.
            If the compositor supports wl_output version 4 and this connector
            corresponds to a wl_output, the compositor should use the same name as
            for the wl_output.
            """

            ...

        @staticmethod
        def description(description: string) -> None:
            """
            description
            The compositor sends this event once the connector is created to provide
            a human-readable description for this connector, which may be presented
            to the user. The compositor may send this event multiple times over the
            lifetime of this object to reflect changes in the description.
            """

            ...

        @staticmethod
        def connector_id(connector_id: uint) -> None:
            """
            connector_id
            The compositor sends this event once the connector is created to
            indicate the DRM object ID which represents the underlying connector
            that is being offered. Note that the final lease may include additional
            object IDs, such as CRTCs and planes.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all properties have been sent
            This event is sent after all properties of a connector have been sent.
            This allows changes to the properties to be seen as atomic even if they
            happen via multiple events.
            """

            ...

        @staticmethod
        def withdrawn() -> None:
            """
            lease offer withdrawn
            Sent to indicate that the compositor will no longer honor requests for
            DRM leases which include this connector. The client may still issue a
            lease request including this connector, but the compositor will send
            wp_drm_lease_v1.finished without issuing a lease fd. Compositors are
            encouraged to send this event when they lose access to connector, for
            example when the connector is hot-unplugged, when the connector gets
            leased to a client or when the compositor loses DRM master.
            If a client holds a lease for the connector, the status of the lease
            remains the same. The client should destroy the object after receiving
            this event.
            """

            ...
class wp_drm_lease_request_v1:
    """
    DRM lease request
    A client that wishes to lease DRM resources will attach the list of
    connectors advertised with wp_drm_lease_device_v1.connector that they
    wish to lease, then use wp_drm_lease_request_v1.submit to submit the
    request.
    """
    object_id = 0
    version = 1

    class error(Enum):
        wrong_device: int
        duplicate_connector: int
        empty_lease: int

    @staticmethod
    def request_connector(connector: object) -> None:
        """
        request a connector for this lease
        Indicates that the client would like to lease the given connector.
        This is only used as a suggestion, the compositor may choose to
        include any resources in the lease it issues, or change the set of
        leased resources at any time. Compositors are however encouraged to
        include the requested connector and other resources necessary
        to drive the connected output in the lease.
        Requesting a connector that was created from a different lease device
        than this lease request raises the wrong_device error. Requesting a
        connector twice will raise the duplicate_connector error.
        """

        ...

    @staticmethod
    def submit() -> wp_drm_lease_v1:
        """
        submit the lease request
        Submits the lease request and creates a new wp_drm_lease_v1 object.
        After calling submit the compositor will immediately destroy this
        object, issuing any more requests will cause a wl_display error.
        The compositor doesn't make any guarantees about the events of the
        lease object, clients cannot expect an immediate response.
        Not requesting any connectors before submitting the lease request
        will raise the empty_lease error.
        """

        ...
class wp_drm_lease_v1:
    """
    a DRM lease
    A DRM lease object is used to transfer the DRM file descriptor to the
    client and manage the lifetime of the lease.
    Some time after the wp_drm_lease_v1 object is created, the compositor
    will reply with the lease request's result. If the lease request is
    granted, the compositor will send a lease_fd event. If the lease request
    is denied, the compositor will send a finished event without a lease_fd
    event.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroys the lease object
        The client should send this to indicate that it no longer wishes to use
        this lease. The compositor should use drmModeRevokeLease on the
        appropriate file descriptor, if necessary.
        Upon destruction, the compositor should advertise the connector for
        leasing again by sending the connector event through the
        wp_drm_lease_device_v1 interface.
        """

        ...
    class events:
        @staticmethod
        def lease_fd(leased_fd: fd) -> None:
            """
            shares the DRM file descriptor
            This event returns a file descriptor suitable for use with DRM-related
            ioctls. The client should use drmModeGetLease to enumerate the DRM
            objects which have been leased to them. The compositor guarantees it
            will not use the leased DRM objects itself until it sends the finished
            event. If the compositor cannot or will not grant a lease for the
            requested connectors, it will not send this event, instead sending the
            finished event.
            The compositor will send this event at most once during this objects
            lifetime.
            """

            ...

        @staticmethod
        def finished() -> None:
            """
            sent when the lease has been revoked
            The compositor uses this event to either reject a lease request, or if
            it previously sent a lease_fd, to notify the client that the lease has
            been revoked. If the client requires a new lease, they should destroy
            this object and submit a new lease request. The compositor will send
            no further events for this object after sending the finish event.
            Compositors should revoke the lease when any of the leased resources
            become unavailable, namely when a hot-unplug occurs or when the
            compositor loses DRM master. Compositors may advertise the connector
            for leasing again, if the resource is available, by sending the
            connector event through the wp_drm_lease_device_v1 interface.
            """

            ...
class xdg_system_bell_v1:
    """
    system bell
    This global interface enables clients to ring the system bell.
    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the system bell object
        Notify that the object will no longer be used.
        """

        ...

    @staticmethod
    def ring(surface: object) -> None:
        """
        ring the system bell
        This requests rings the system bell on behalf of a client. How ringing
        the bell is implemented is up to the compositor. It may be an audible
        sound, a visual feedback of some kind, or any other thing including
        nothing.
        The passed surface should correspond to a toplevel like surface role,
        or be null, meaning the client doesn't have a particular toplevel it
        wants to associate the bell ringing with. See the xdg-shell protocol
        extension for a toplevel like surface role.
        """

        ...
class wp_viewporter:
    """
    surface cropping and scaling
    The global interface exposing surface cropping and scaling
    capabilities is used to instantiate an interface extension for a
    wl_surface object. This extended interface will then allow
    cropping and scaling the surface contents, effectively
    disconnecting the direct relationship between the buffer and the
    surface size.
    """
    object_id = 0
    version = 1

    class error(Enum):
        viewport_exists: int

    @staticmethod
    def destroy() -> None:
        """
        unbind from the cropping and scaling interface
        Informs the server that the client will not be using this
        protocol object anymore. This does not affect any other objects,
        wp_viewport objects included.
        """

        ...

    @staticmethod
    def get_viewport(surface: object) -> wp_viewport:
        """
        extend surface interface for crop and scale
        Instantiate an interface extension for the given wl_surface to
        crop and scale its content. If the given wl_surface already has
        a wp_viewport object associated, the viewport_exists
        protocol error is raised.
        """

        ...
class wp_viewport:
    """
    crop and scale interface to a wl_surface
    An additional interface to a wl_surface object, which allows the
    client to specify the cropping and scaling of the surface
    contents.
    This interface works with two concepts: the source rectangle (src_x,
    src_y, src_width, src_height), and the destination size (dst_width,
    dst_height). The contents of the source rectangle are scaled to the
    destination size, and content outside the source rectangle is ignored.
    This state is double-buffered, see wl_surface.commit.
    The two parts of crop and scale state are independent: the source
    rectangle, and the destination size. Initially both are unset, that
    is, no scaling is applied. The whole of the current wl_buffer is
    used as the source, and the surface size is as defined in
    wl_surface.attach.
    If the destination size is set, it causes the surface size to become
    dst_width, dst_height. The source (rectangle) is scaled to exactly
    this size. This overrides whatever the attached wl_buffer size is,
    unless the wl_buffer is NULL. If the wl_buffer is NULL, the surface
    has no content and therefore no size. Otherwise, the size is always
    at least 1x1 in surface local coordinates.
    If the source rectangle is set, it defines what area of the wl_buffer is
    taken as the source. If the source rectangle is set and the destination
    size is not set, then src_width and src_height must be integers, and the
    surface size becomes the source rectangle size. This results in cropping
    without scaling. If src_width or src_height are not integers and
    destination size is not set, the bad_size protocol error is raised when
    the surface state is applied.
    The coordinate transformations from buffer pixel coordinates up to
    the surface-local coordinates happen in the following order:
    1. buffer_transform (wl_surface.set_buffer_transform)
    2. buffer_scale (wl_surface.set_buffer_scale)
    3. crop and scale (wp_viewport.set*)
    This means, that the source rectangle coordinates of crop and scale
    are given in the coordinates after the buffer transform and scale,
    i.e. in the coordinates that would be the surface-local coordinates
    if the crop and scale was not applied.
    If src_x or src_y are negative, the bad_value protocol error is raised.
    Otherwise, if the source rectangle is partially or completely outside of
    the non-NULL wl_buffer, then the out_of_buffer protocol error is raised
    when the surface state is applied. A NULL wl_buffer does not raise the
    out_of_buffer error.
    If the wl_surface associated with the wp_viewport is destroyed,
    all wp_viewport requests except 'destroy' raise the protocol error
    no_surface.
    If the wp_viewport object is destroyed, the crop and scale
    state is removed from the wl_surface. The change will be applied
    on the next wl_surface.commit.
    """
    object_id = 0
    version = 1

    class error(Enum):
        bad_value: int
        bad_size: int
        out_of_buffer: int
        no_surface: int

    @staticmethod
    def destroy() -> None:
        """
        remove scaling and cropping from the surface
        The associated wl_surface's crop and scale state is removed.
        The change is applied on the next wl_surface.commit.
        """

        ...

    @staticmethod
    def set_source(x: fixed, y: fixed, width: fixed, height: fixed) -> None:
        """
        set the source rectangle for cropping
        Set the source rectangle of the associated wl_surface. See
        wp_viewport for the description, and relation to the wl_buffer
        size.
        If all of x, y, width and height are -1.0, the source rectangle is
        unset instead. Any other set of values where width or height are zero
        or negative, or x or y are negative, raise the bad_value protocol
        error.
        The crop and scale state is double-buffered, see wl_surface.commit.
        """

        ...

    @staticmethod
    def set_destination(width: int, height: int) -> None:
        """
        set the surface size for scaling
        Set the destination size of the associated wl_surface. See
        wp_viewport for the description, and relation to the wl_buffer
        size.
        If width is -1 and height is -1, the destination size is unset
        instead. Any other pair of values for width and height that
        contains zero or negative values raises the bad_value protocol
        error.
        The crop and scale state is double-buffered, see wl_surface.commit.
        """

        ...
class zwp_linux_dmabuf_v1:
    """
    factory for creating dmabuf-based wl_buffers
    This interface offers ways to create generic dmabuf-based wl_buffers.
    For more information about dmabuf, see:
    https://www.kernel.org/doc/html/next/userspace-api/dma-buf-alloc-exchange.html
    Clients can use the get_surface_feedback request to get dmabuf feedback
    for a particular surface. If the client wants to retrieve feedback not
    tied to a surface, they can use the get_default_feedback request.
    The following are required from clients:
    - Clients must ensure that either all data in the dma-buf is
    coherent for all subsequent read access or that coherency is
    correctly handled by the underlying kernel-side dma-buf
    implementation.
    - Don't make any more attachments after sending the buffer to the
    compositor. Making more attachments later increases the risk of
    the compositor not being able to use (re-import) an existing
    dmabuf-based wl_buffer.
    The underlying graphics stack must ensure the following:
    - The dmabuf file descriptors relayed to the server will stay valid
    for the whole lifetime of the wl_buffer. This means the server may
    at any time use those fds to import the dmabuf into any kernel
    sub-system that might accept it.
    However, when the underlying graphics stack fails to deliver the
    promise, because of e.g. a device hot-unplug which raises internal
    errors, after the wl_buffer has been successfully created the
    compositor must not raise protocol errors to the client when dmabuf
    import later fails.
    To create a wl_buffer from one or more dmabufs, a client creates a
    zwp_linux_dmabuf_params_v1 object with a zwp_linux_dmabuf_v1.create_params
    request. All planes required by the intended format are added with
    the 'add' request. Finally, a 'create' or 'create_immed' request is
    issued, which has the following outcome depending on the import success.
    The 'create' request,
    - on success, triggers a 'created' event which provides the final
    wl_buffer to the client.
    - on failure, triggers a 'failed' event to convey that the server
    cannot use the dmabufs received from the client.
    For the 'create_immed' request,
    - on success, the server immediately imports the added dmabufs to
    create a wl_buffer. No event is sent from the server in this case.
    - on failure, the server can choose to either:
    - terminate the client by raising a fatal error.
    - mark the wl_buffer as failed, and send a 'failed' event to the
    client. If the client uses a failed wl_buffer as an argument to any
    request, the behaviour is compositor implementation-defined.
    For all DRM formats and unless specified in another protocol extension,
    pre-multiplied alpha is used for pixel values.
    Unless specified otherwise in another protocol extension, implicit
    synchronization is used. In other words, compositors and clients must
    wait and signal fences implicitly passed via the DMA-BUF's reservation
    mechanism.
    """
    object_id = 0
    version = 5

    @staticmethod
    def destroy() -> None:
        """
        unbind the factory
        Objects created through this interface, especially wl_buffers, will
        remain valid.
        """

        ...

    @staticmethod
    def create_params() -> zwp_linux_buffer_params_v1:
        """
        create a temporary object for buffer parameters
        This temporary object is used to collect multiple dmabuf handles into
        a single batch to create a wl_buffer. It can only be used once and
        should be destroyed after a 'created' or 'failed' event has been
        received.
        """

        ...

    @staticmethod
    def get_default_feedback() -> zwp_linux_dmabuf_feedback_v1:
        """
        get default feedback
        This request creates a new wp_linux_dmabuf_feedback object not bound
        to a particular surface. This object will deliver feedback about dmabuf
        parameters to use if the client doesn't support per-surface feedback
        (see get_surface_feedback).
        """

        ...

    @staticmethod
    def get_surface_feedback(surface: object) -> zwp_linux_dmabuf_feedback_v1:
        """
        get feedback for a surface
        This request creates a new wp_linux_dmabuf_feedback object for the
        specified wl_surface. This object will deliver feedback about dmabuf
        parameters to use for buffers attached to this surface.
        If the surface is destroyed before the wp_linux_dmabuf_feedback object,
        the feedback object becomes inert.
        """

        ...
    class events:
        @staticmethod
        def format(format: uint) -> None:
            """
            supported buffer format
            This event advertises one buffer format that the server supports.
            All the supported formats are advertised once when the client
            binds to this interface. A roundtrip after binding guarantees
            that the client has received all supported formats.
            For the definition of the format codes, see the
            zwp_linux_buffer_params_v1::create request.
            Starting version 4, the format event is deprecated and must not be
            sent by compositors. Instead, use get_default_feedback or
            get_surface_feedback.
            """

            ...

        @staticmethod
        def modifier(format: uint, modifier_hi: uint, modifier_lo: uint) -> None:
            """
            supported buffer format modifier
            This event advertises the formats that the server supports, along with
            the modifiers supported for each format. All the supported modifiers
            for all the supported formats are advertised once when the client
            binds to this interface. A roundtrip after binding guarantees that
            the client has received all supported format-modifier pairs.
            For legacy support, DRM_FORMAT_MOD_INVALID (that is, modifier_hi ==
            0x00ffffff and modifier_lo == 0xffffffff) is allowed in this event.
            It indicates that the server can support the format with an implicit
            modifier. When a plane has DRM_FORMAT_MOD_INVALID as its modifier, it
            is as if no explicit modifier is specified. The effective modifier
            will be derived from the dmabuf.
            A compositor that sends valid modifiers and DRM_FORMAT_MOD_INVALID for
            a given format supports both explicit modifiers and implicit modifiers.
            For the definition of the format and modifier codes, see the
            zwp_linux_buffer_params_v1::create and zwp_linux_buffer_params_v1::add
            requests.
            Starting version 4, the modifier event is deprecated and must not be
            sent by compositors. Instead, use get_default_feedback or
            get_surface_feedback.
            """

            ...
class zwp_linux_buffer_params_v1:
    """
    parameters for creating a dmabuf-based wl_buffer
    This temporary object is a collection of dmabufs and other
    parameters that together form a single logical buffer. The temporary
    object may eventually create one wl_buffer unless cancelled by
    destroying it before requesting 'create'.
    Single-planar formats only require one dmabuf, however
    multi-planar formats may require more than one dmabuf. For all
    formats, an 'add' request must be called once per plane (even if the
    underlying dmabuf fd is identical).
    You must use consecutive plane indices ('plane_idx' argument for 'add')
    from zero to the number of planes used by the drm_fourcc format code.
    All planes required by the format must be given exactly once, but can
    be given in any order. Each plane index can only be set once; subsequent
    calls with a plane index which has already been set will result in a
    plane_set error being generated.
    """
    object_id = 0
    version = 5

    class error(Enum):
        already_used: int
        plane_idx: int
        plane_set: int
        incomplete: int
        invalid_format: int
        invalid_dimensions: int
        out_of_bounds: int
        invalid_wl_buffer: int


    class flags(IntFlag):
        y_invert: int
        interlaced: int
        bottom_first: int

    @staticmethod
    def destroy() -> None:
        """
        delete this object, used or not
        Cleans up the temporary data sent to the server for dmabuf-based
        wl_buffer creation.
        """

        ...

    @staticmethod
    def add(fd: fd, plane_idx: uint, offset: uint, stride: uint, modifier_hi: uint, modifier_lo: uint) -> None:
        """
        add a dmabuf to the temporary set
        This request adds one dmabuf to the set in this
        zwp_linux_buffer_params_v1.
        The 64-bit unsigned value combined from modifier_hi and modifier_lo
        is the dmabuf layout modifier. DRM AddFB2 ioctl calls this the
        fb modifier, which is defined in drm_mode.h of Linux UAPI.
        This is an opaque token. Drivers use this token to express tiling,
        compression, etc. driver-specific modifications to the base format
        defined by the DRM fourcc code.
        Starting from version 4, the invalid_format protocol error is sent if
        the format + modifier pair was not advertised as supported.
        Starting from version 5, the invalid_format protocol error is sent if
        all planes don't use the same modifier.
        This request raises the PLANE_IDX error if plane_idx is too large.
        The error PLANE_SET is raised if attempting to set a plane that
        was already set.
        """

        ...

    @staticmethod
    def create(width: int, height: int, format: uint, flags: zwp_linux_buffer_params_v1.flags) -> None:
        """
        create a wl_buffer from the given dmabufs
        This asks for creation of a wl_buffer from the added dmabuf
        buffers. The wl_buffer is not created immediately but returned via
        the 'created' event if the dmabuf sharing succeeds. The sharing
        may fail at runtime for reasons a client cannot predict, in
        which case the 'failed' event is triggered.
        The 'format' argument is a DRM_FORMAT code, as defined by the
        libdrm's drm_fourcc.h. The Linux kernel's DRM sub-system is the
        authoritative source on how the format codes should work.
        The 'flags' is a bitfield of the flags defined in enum "flags".
        'y_invert' means the that the image needs to be y-flipped.
        Flag 'interlaced' means that the frame in the buffer is not
        progressive as usual, but interlaced. An interlaced buffer as
        supported here must always contain both top and bottom fields.
        The top field always begins on the first pixel row. The temporal
        ordering between the two fields is top field first, unless
        'bottom_first' is specified. It is undefined whether 'bottom_first'
        is ignored if 'interlaced' is not set.
        This protocol does not convey any information about field rate,
        duration, or timing, other than the relative ordering between the
        two fields in one buffer. A compositor may have to estimate the
        intended field rate from the incoming buffer rate. It is undefined
        whether the time of receiving wl_surface.commit with a new buffer
        attached, applying the wl_surface state, wl_surface.frame callback
        trigger, presentation, or any other point in the compositor cycle
        is used to measure the frame or field times. There is no support
        for detecting missed or late frames/fields/buffers either, and
        there is no support whatsoever for cooperating with interlaced
        compositor output.
        The composited image quality resulting from the use of interlaced
        buffers is explicitly undefined. A compositor may use elaborate
        hardware features or software to deinterlace and create progressive
        output frames from a sequence of interlaced input buffers, or it
        may produce substandard image quality. However, compositors that
        cannot guarantee reasonable image quality in all cases are recommended
        to just reject all interlaced buffers.
        Any argument errors, including non-positive width or height,
        mismatch between the number of planes and the format, bad
        format, bad offset or stride, may be indicated by fatal protocol
        errors: INCOMPLETE, INVALID_FORMAT, INVALID_DIMENSIONS,
        OUT_OF_BOUNDS.
        Dmabuf import errors in the server that are not obvious client
        bugs are returned via the 'failed' event as non-fatal. This
        allows attempting dmabuf sharing and falling back in the client
        if it fails.
        This request can be sent only once in the object's lifetime, after
        which the only legal request is destroy. This object should be
        destroyed after issuing a 'create' request. Attempting to use this
        object after issuing 'create' raises ALREADY_USED protocol error.
        It is not mandatory to issue 'create'. If a client wants to
        cancel the buffer creation, it can just destroy this object.
        """

        ...

    @staticmethod
    def create_immed(width: int, height: int, format: uint, flags: zwp_linux_buffer_params_v1.flags) -> wl_buffer:
        """
        immediately create a wl_buffer from the given                      dmabufs
        This asks for immediate creation of a wl_buffer by importing the
        added dmabufs.
        In case of import success, no event is sent from the server, and the
        wl_buffer is ready to be used by the client.
        Upon import failure, either of the following may happen, as seen fit
        by the implementation:
        - the client is terminated with one of the following fatal protocol
        errors:
        - INCOMPLETE, INVALID_FORMAT, INVALID_DIMENSIONS, OUT_OF_BOUNDS,
        in case of argument errors such as mismatch between the number
        of planes and the format, bad format, non-positive width or
        height, or bad offset or stride.
        - INVALID_WL_BUFFER, in case the cause for failure is unknown or
        platform specific.
        - the server creates an invalid wl_buffer, marks it as failed and
        sends a 'failed' event to the client. The result of using this
        invalid wl_buffer as an argument in any request by the client is
        defined by the compositor implementation.
        This takes the same arguments as a 'create' request, and obeys the
        same restrictions.
        """

        ...
    class events:
        @staticmethod
        def created(buffer: wl_buffer) -> None:
            """
            buffer creation succeeded
            This event indicates that the attempted buffer creation was
            successful. It provides the new wl_buffer referencing the dmabuf(s).
            Upon receiving this event, the client should destroy the
            zwp_linux_buffer_params_v1 object.
            """

            ...

        @staticmethod
        def failed() -> None:
            """
            buffer creation failed
            This event indicates that the attempted buffer creation has
            failed. It usually means that one of the dmabuf constraints
            has not been fulfilled.
            Upon receiving this event, the client should destroy the
            zwp_linux_buffer_params_v1 object.
            """

            ...
class zwp_linux_dmabuf_feedback_v1:
    """
    dmabuf feedback
    This object advertises dmabuf parameters feedback. This includes the
    preferred devices and the supported formats/modifiers.
    The parameters are sent once when this object is created and whenever they
    change. The done event is always sent once after all parameters have been
    sent. When a single parameter changes, all parameters are re-sent by the
    compositor.
    Compositors can re-send the parameters when the current client buffer
    allocations are sub-optimal. Compositors should not re-send the
    parameters if re-allocating the buffers would not result in a more optimal
    configuration. In particular, compositors should avoid sending the exact
    same parameters multiple times in a row.
    The tranche_target_device and tranche_formats events are grouped by
    tranches of preference. For each tranche, a tranche_target_device, one
    tranche_flags and one or more tranche_formats events are sent, followed
    by a tranche_done event finishing the list. The tranches are sent in
    descending order of preference. All formats and modifiers in the same
    tranche have the same preference.
    To send parameters, the compositor sends one main_device event, tranches
    (each consisting of one tranche_target_device event, one tranche_flags
    event, tranche_formats events and then a tranche_done event), then one
    done event.
    """
    object_id = 0
    version = 5

    class tranche_flags(IntFlag):
        scanout: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the feedback object
        Using this request a client can tell the server that it is not going to
        use the wp_linux_dmabuf_feedback object anymore.
        """

        ...
    class events:
        @staticmethod
        def done() -> None:
            """
            all feedback has been sent
            This event is sent after all parameters of a wp_linux_dmabuf_feedback
            object have been sent.
            This allows changes to the wp_linux_dmabuf_feedback parameters to be
            seen as atomic, even if they happen via multiple events.
            """

            ...

        @staticmethod
        def format_table(fd: fd, size: uint) -> None:
            """
            format and modifier table
            This event provides a file descriptor which can be memory-mapped to
            access the format and modifier table.
            The table contains a tightly packed array of consecutive format +
            modifier pairs. Each pair is 16 bytes wide. It contains a format as a
            32-bit unsigned integer, followed by 4 bytes of unused padding, and a
            modifier as a 64-bit unsigned integer. The native endianness is used.
            The client must map the file descriptor in read-only private mode.
            Compositors are not allowed to mutate the table file contents once this
            event has been sent. Instead, compositors must create a new, separate
            table file and re-send feedback parameters. Compositors are allowed to
            store duplicate format + modifier pairs in the table.
            """

            ...

        @staticmethod
        def main_device(device: array) -> None:
            """
            preferred main device
            This event advertises the main device that the server prefers to use
            when direct scan-out to the target device isn't possible. The
            advertised main device may be different for each
            wp_linux_dmabuf_feedback object, and may change over time.
            There is exactly one main device. The compositor must send at least
            one preference tranche with tranche_target_device equal to main_device.
            Clients need to create buffers that the main device can import and
            read from, otherwise creating the dmabuf wl_buffer will fail (see the
            wp_linux_buffer_params.create and create_immed requests for details).
            The main device will also likely be kept active by the compositor,
            so clients can use it instead of waking up another device for power
            savings.
            In general the device is a DRM node. The DRM node type (primary vs.
            render) is unspecified. Clients must not rely on the compositor sending
            a particular node type. Clients cannot check two devices for equality
            by comparing the dev_t value.
            If explicit modifiers are not supported and the client performs buffer
            allocations on a different device than the main device, then the client
            must force the buffer to have a linear layout.
            """

            ...

        @staticmethod
        def tranche_done() -> None:
            """
            a preference tranche has been sent
            This event splits tranche_target_device and tranche_formats events in
            preference tranches. It is sent after a set of tranche_target_device
            and tranche_formats events; it represents the end of a tranche. The
            next tranche will have a lower preference.
            """

            ...

        @staticmethod
        def tranche_target_device(device: array) -> None:
            """
            target device
            This event advertises the target device that the server prefers to use
            for a buffer created given this tranche. The advertised target device
            may be different for each preference tranche, and may change over time.
            There is exactly one target device per tranche.
            The target device may be a scan-out device, for example if the
            compositor prefers to directly scan-out a buffer created given this
            tranche. The target device may be a rendering device, for example if
            the compositor prefers to texture from said buffer.
            The client can use this hint to allocate the buffer in a way that makes
            it accessible from the target device, ideally directly. The buffer must
            still be accessible from the main device, either through direct import
            or through a potentially more expensive fallback path. If the buffer
            can't be directly imported from the main device then clients must be
            prepared for the compositor changing the tranche priority or making
            wl_buffer creation fail (see the wp_linux_buffer_params.create and
            create_immed requests for details).
            If the device is a DRM node, the DRM node type (primary vs. render) is
            unspecified. Clients must not rely on the compositor sending a
            particular node type. Clients cannot check two devices for equality by
            comparing the dev_t value.
            This event is tied to a preference tranche, see the tranche_done event.
            """

            ...

        @staticmethod
        def tranche_formats(indices: array) -> None:
            """
            supported buffer format modifier
            This event advertises the format + modifier combinations that the
            compositor supports.
            It carries an array of indices, each referring to a format + modifier
            pair in the last received format table (see the format_table event).
            Each index is a 16-bit unsigned integer in native endianness.
            For legacy support, DRM_FORMAT_MOD_INVALID is an allowed modifier.
            It indicates that the server can support the format with an implicit
            modifier. When a buffer has DRM_FORMAT_MOD_INVALID as its modifier, it
            is as if no explicit modifier is specified. The effective modifier
            will be derived from the dmabuf.
            A compositor that sends valid modifiers and DRM_FORMAT_MOD_INVALID for
            a given format supports both explicit modifiers and implicit modifiers.
            Compositors must not send duplicate format + modifier pairs within the
            same tranche or across two different tranches with the same target
            device and flags.
            This event is tied to a preference tranche, see the tranche_done event.
            For the definition of the format and modifier codes, see the
            wp_linux_buffer_params.create request.
            """

            ...

        @staticmethod
        def tranche_flags(flags: zwp_linux_dmabuf_feedback_v1.tranche_flags) -> None:
            """
            tranche flags
            This event sets tranche-specific flags.
            The scanout flag is a hint that direct scan-out may be attempted by the
            compositor on the target device if the client appropriately allocates a
            buffer. How to allocate a buffer that can be scanned out on the target
            device is implementation-defined.
            This event is tied to a preference tranche, see the tranche_done event.
            """

            ...
class zwp_tablet_manager_v2:
    """
    controller object for graphic tablet devices
    An object that provides access to the graphics tablets available on this
    system. All tablets are associated with a seat, to get access to the
    actual tablets, use wp_tablet_manager.get_tablet_seat.
    """
    object_id = 0
    version = 2

    @staticmethod
    def get_tablet_seat(seat: object) -> zwp_tablet_seat_v2:
        """
        get the tablet seat
        Get the wp_tablet_seat object for the given seat. This object
        provides access to all graphics tablets in this seat.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        release the memory for the tablet manager object
        Destroy the wp_tablet_manager object. Objects created from this
        object are unaffected and should be destroyed separately.
        """

        ...
class zwp_tablet_seat_v2:
    """
    controller object for graphic tablet devices of a seat
    An object that provides access to the graphics tablets available on this
    seat. After binding to this interface, the compositor sends a set of
    wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        release the memory for the tablet seat object
        Destroy the wp_tablet_seat object. Objects created from this
        object are unaffected and should be destroyed separately.
        """

        ...
    class events:
        @staticmethod
        def tablet_added(id: zwp_tablet_v2) -> None:
            """
            new device notification
            This event is sent whenever a new tablet becomes available on this
            seat. This event only provides the object id of the tablet, any
            static information about the tablet (device name, vid/pid, etc.) is
            sent through the wp_tablet interface.
            """

            ...

        @staticmethod
        def tool_added(id: zwp_tablet_tool_v2) -> None:
            """
            a new tool has been used with a tablet
            This event is sent whenever a tool that has not previously been used
            with a tablet comes into use. This event only provides the object id
            of the tool; any static information about the tool (capabilities,
            type, etc.) is sent through the wp_tablet_tool interface.
            """

            ...

        @staticmethod
        def pad_added(id: zwp_tablet_pad_v2) -> None:
            """
            new pad notification
            This event is sent whenever a new pad is known to the system. Typically,
            pads are physically attached to tablets and a pad_added event is
            sent immediately after the wp_tablet_seat.tablet_added.
            However, some standalone pad devices logically attach to tablets at
            runtime, and the client must wait for wp_tablet_pad.enter to know
            the tablet a pad is attached to.
            This event only provides the object id of the pad. All further
            features (buttons, strips, rings) are sent through the wp_tablet_pad
            interface.
            """

            ...
class zwp_tablet_tool_v2:
    """
    a physical tablet tool
    An object that represents a physical tool that has been, or is
    currently in use with a tablet in this seat. Each wp_tablet_tool
    object stays valid until the client destroys it; the compositor
    reuses the wp_tablet_tool object to indicate that the object's
    respective physical tool has come into proximity of a tablet again.
    A wp_tablet_tool object's relation to a physical tool depends on the
    tablet's ability to report serial numbers. If the tablet supports
    this capability, then the object represents a specific physical tool
    and can be identified even when used on multiple tablets.
    A tablet tool has a number of static characteristics, e.g. tool type,
    hardware_serial and capabilities. These capabilities are sent in an
    event sequence after the wp_tablet_seat.tool_added event before any
    actual events from this tool. This initial event sequence is
    terminated by a wp_tablet_tool.done event.
    Tablet tool events are grouped by wp_tablet_tool.frame events.
    Any events received before a wp_tablet_tool.frame event should be
    considered part of the same hardware state change.
    """
    object_id = 0
    version = 2

    class type(Enum):
        pen: int
        eraser: int
        brush: int
        pencil: int
        airbrush: int
        finger: int
        mouse: int
        lens: int


    class capability(Enum):
        tilt: int
        pressure: int
        distance: int
        rotation: int
        slider: int
        wheel: int


    class button_state(Enum):
        released: int
        pressed: int


    class error(Enum):
        role: int

    @staticmethod
    def set_cursor(serial: uint, surface: object, hotspot_x: int, hotspot_y: int) -> None:
        """
        set the tablet tool's surface
        Sets the surface of the cursor used for this tool on the given
        tablet. This request only takes effect if the tool is in proximity
        of one of the requesting client's surfaces or the surface parameter
        is the current pointer surface. If there was a previous surface set
        with this request it is replaced. If surface is NULL, the cursor
        image is hidden.
        The parameters hotspot_x and hotspot_y define the position of the
        pointer surface relative to the pointer location. Its top-left corner
        is always at (x, y) - (hotspot_x, hotspot_y), where (x, y) are the
        coordinates of the pointer location, in surface-local coordinates.
        On surface.attach requests to the pointer surface, hotspot_x and
        hotspot_y are decremented by the x and y parameters passed to the
        request. Attach must be confirmed by wl_surface.commit as usual.
        The hotspot can also be updated by passing the currently set pointer
        surface to this request with new values for hotspot_x and hotspot_y.
        The current and pending input regions of the wl_surface are cleared,
        and wl_surface.set_input_region is ignored until the wl_surface is no
        longer used as the cursor. When the use as a cursor ends, the current
        and pending input regions become undefined, and the wl_surface is
        unmapped.
        This request gives the surface the role of a wp_tablet_tool cursor. A
        surface may only ever be used as the cursor surface for one
        wp_tablet_tool. If the surface already has another role or has
        previously been used as cursor surface for a different tool, a
        protocol error is raised.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the tool object
        This destroys the client's resource for this tool object.
        """

        ...
    class events:
        @staticmethod
        def type(tool_type: zwp_tablet_tool_v2.type) -> None:
            """
            tool type
            The tool type is the high-level type of the tool and usually decides
            the interaction expected from this tool.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def hardware_serial(hardware_serial_hi: uint, hardware_serial_lo: uint) -> None:
            """
            unique hardware serial number of the tool
            If the physical tool can be identified by a unique 64-bit serial
            number, this event notifies the client of this serial number.
            If multiple tablets are available in the same seat and the tool is
            uniquely identifiable by the serial number, that tool may move
            between tablets.
            Otherwise, if the tool has no serial number and this event is
            missing, the tool is tied to the tablet it first comes into
            proximity with. Even if the physical tool is used on multiple
            tablets, separate wp_tablet_tool objects will be created, one per
            tablet.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def hardware_id_wacom(hardware_id_hi: uint, hardware_id_lo: uint) -> None:
            """
            hardware id notification in Wacom's format
            This event notifies the client of a hardware id available on this tool.
            The hardware id is a device-specific 64-bit id that provides extra
            information about the tool in use, beyond the wl_tool.type
            enumeration. The format of the id is specific to tablets made by
            Wacom Inc. For example, the hardware id of a Wacom Grip
            Pen (a stylus) is 0x802.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def capability(capability: zwp_tablet_tool_v2.capability) -> None:
            """
            tool capability notification
            This event notifies the client of any capabilities of this tool,
            beyond the main set of x/y axes and tip up/down detection.
            One event is sent for each extra capability available on this tool.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            tool description events sequence complete
            This event signals the end of the initial burst of descriptive
            events. A client may consider the static description of the tool to
            be complete and finalize initialization of the tool.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            tool removed
            This event is sent when the tool is removed from the system and will
            send no further events. Should the physical tool come back into
            proximity later, a new wp_tablet_tool object will be created.
            It is compositor-dependent when a tool is removed. A compositor may
            remove a tool on proximity out, tablet removal or any other reason.
            A compositor may also keep a tool alive until shutdown.
            If the tool is currently in proximity, a proximity_out event will be
            sent before the removed event. See wp_tablet_tool.proximity_out for
            the handling of any buttons logically down.
            When this event is received, the client must wp_tablet_tool.destroy
            the object.
            """

            ...

        @staticmethod
        def proximity_in(serial: uint, tablet: object, surface: object) -> None:
            """
            proximity in event
            Notification that this tool is focused on a certain surface.
            This event can be received when the tool has moved from one surface to
            another, or when the tool has come back into proximity above the
            surface.
            If any button is logically down when the tool comes into proximity,
            the respective button event is sent after the proximity_in event but
            within the same frame as the proximity_in event.
            """

            ...

        @staticmethod
        def proximity_out() -> None:
            """
            proximity out event
            Notification that this tool has either left proximity, or is no
            longer focused on a certain surface.
            When the tablet tool leaves proximity of the tablet, button release
            events are sent for each button that was held down at the time of
            leaving proximity. These events are sent before the proximity_out
            event but within the same wp_tablet.frame.
            If the tool stays within proximity of the tablet, but the focus
            changes from one surface to another, a button release event may not
            be sent until the button is actually released or the tool leaves the
            proximity of the tablet.
            """

            ...

        @staticmethod
        def down(serial: uint) -> None:
            """
            tablet tool is making contact
            Sent whenever the tablet tool comes in contact with the surface of the
            tablet.
            If the tool is already in contact with the tablet when entering the
            input region, the client owning said region will receive a
            wp_tablet.proximity_in event, followed by a wp_tablet.down
            event and a wp_tablet.frame event.
            Note that this event describes logical contact, not physical
            contact. On some devices, a compositor may not consider a tool in
            logical contact until a minimum physical pressure threshold is
            exceeded.
            """

            ...

        @staticmethod
        def up() -> None:
            """
            tablet tool is no longer making contact
            Sent whenever the tablet tool stops making contact with the surface of
            the tablet, or when the tablet tool moves out of the input region
            and the compositor grab (if any) is dismissed.
            If the tablet tool moves out of the input region while in contact
            with the surface of the tablet and the compositor does not have an
            ongoing grab on the surface, the client owning said region will
            receive a wp_tablet.up event, followed by a wp_tablet.proximity_out
            event and a wp_tablet.frame event. If the compositor has an ongoing
            grab on this device, this event sequence is sent whenever the grab
            is dismissed in the future.
            Note that this event describes logical contact, not physical
            contact. On some devices, a compositor may not consider a tool out
            of logical contact until physical pressure falls below a specific
            threshold.
            """

            ...

        @staticmethod
        def motion(x: fixed, y: fixed) -> None:
            """
            motion event
            Sent whenever a tablet tool moves.
            """

            ...

        @staticmethod
        def pressure(pressure: uint) -> None:
            """
            pressure change event
            Sent whenever the pressure axis on a tool changes. The value of this
            event is normalized to a value between 0 and 65535.
            Note that pressure may be nonzero even when a tool is not in logical
            contact. See the down and up events for more details.
            """

            ...

        @staticmethod
        def distance(distance: uint) -> None:
            """
            distance change event
            Sent whenever the distance axis on a tool changes. The value of this
            event is normalized to a value between 0 and 65535.
            Note that distance may be nonzero even when a tool is not in logical
            contact. See the down and up events for more details.
            """

            ...

        @staticmethod
        def tilt(tilt_x: fixed, tilt_y: fixed) -> None:
            """
            tilt change event
            Sent whenever one or both of the tilt axes on a tool change. Each tilt
            value is in degrees, relative to the z-axis of the tablet.
            The angle is positive when the top of a tool tilts along the
            positive x or y axis.
            """

            ...

        @staticmethod
        def rotation(degrees: fixed) -> None:
            """
            z-rotation change event
            Sent whenever the z-rotation axis on the tool changes. The
            rotation value is in degrees clockwise from the tool's
            logical neutral position.
            """

            ...

        @staticmethod
        def slider(position: int) -> None:
            """
            Slider position change event
            Sent whenever the slider position on the tool changes. The
            value is normalized between -65535 and 65535, with 0 as the logical
            neutral position of the slider.
            The slider is available on e.g. the Wacom Airbrush tool.
            """

            ...

        @staticmethod
        def wheel(degrees: fixed, clicks: int) -> None:
            """
            Wheel delta event
            Sent whenever the wheel on the tool emits an event. This event
            contains two values for the same axis change. The degrees value is
            in the same orientation as the wl_pointer.vertical_scroll axis. The
            clicks value is in discrete logical clicks of the mouse wheel. This
            value may be zero if the movement of the wheel was less
            than one logical click.
            Clients should choose either value and avoid mixing degrees and
            clicks. The compositor may accumulate values smaller than a logical
            click and emulate click events when a certain threshold is met.
            Thus, wl_tablet_tool.wheel events with non-zero clicks values may
            have different degrees values.
            """

            ...

        @staticmethod
        def button(serial: uint, button: uint, state: zwp_tablet_tool_v2.button_state) -> None:
            """
            button event
            Sent whenever a button on the tool is pressed or released.
            If a button is held down when the tool moves in or out of proximity,
            button events are generated by the compositor. See
            wp_tablet_tool.proximity_in and wp_tablet_tool.proximity_out for
            details.
            """

            ...

        @staticmethod
        def frame(time: uint) -> None:
            """
            frame event
            Marks the end of a series of axis and/or button updates from the
            tablet. The Wayland protocol requires axis updates to be sent
            sequentially, however all events within a frame should be considered
            one hardware event.
            """

            ...
class zwp_tablet_v2:
    """
    graphics tablet device
    The wp_tablet interface represents one graphics tablet device. The
    tablet interface itself does not generate events; all events are
    generated by wp_tablet_tool objects when in proximity above a tablet.
    A tablet has a number of static characteristics, e.g. device name and
    pid/vid. These capabilities are sent in an event sequence after the
    wp_tablet_seat.tablet_added event. This initial event sequence is
    terminated by a wp_tablet.done event.
    """
    object_id = 0
    version = 2

    class bustype(Enum):
        usb: int
        bluetooth: int
        virtual: int
        serial: int
        i2c: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the tablet object
        This destroys the client's resource for this tablet object.
        """

        ...
    class events:
        @staticmethod
        def name(name: string) -> None:
            """
            tablet device name
            A descriptive name for the tablet device.
            If the device has no descriptive name, this event is not sent.
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...

        @staticmethod
        def id(vid: uint, pid: uint) -> None:
            """
            tablet device vendor/product id
            The vendor and product IDs for the tablet device.
            The interpretation of the id depends on the wp_tablet.bustype.
            Prior to version v2 of this protocol, the id was implied to be a USB
            vendor and product ID. If no wp_tablet.bustype is sent, the ID
            is to be interpreted as USB vendor and product ID.
            If the device has no vendor/product ID, this event is not sent.
            This can happen for virtual devices or non-USB devices, for instance.
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...

        @staticmethod
        def path(path: string) -> None:
            """
            path to the device
            A system-specific device path that indicates which device is behind
            this wp_tablet. This information may be used to gather additional
            information about the device, e.g. through libwacom.
            A device may have more than one device path. If so, multiple
            wp_tablet.path events are sent. A device may be emulated and not
            have a device path, and in that case this event will not be sent.
            The format of the path is unspecified, it may be a device node, a
            sysfs path, or some other identifier. It is up to the client to
            identify the string provided.
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            tablet description events sequence complete
            This event is sent immediately to signal the end of the initial
            burst of descriptive events. A client may consider the static
            description of the tablet to be complete and finalize initialization
            of the tablet.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            tablet removed event
            Sent when the tablet has been removed from the system. When a tablet
            is removed, some tools may be removed.
            When this event is received, the client must wp_tablet.destroy
            the object.
            """

            ...

        @staticmethod
        def bustype(bustype: zwp_tablet_v2.bustype) -> None:
            """
            tablet device bus type
            The bustype argument is one of the BUS_ defines in the Linux kernel's
            linux/input.h
            If the device has no known bustype or the bustype cannot be
            queried, this event is not sent.
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...
class zwp_tablet_pad_ring_v2:
    """
    pad ring
    A circular interaction area, such as the touch ring on the Wacom Intuos
    Pro series tablets.
    Events on a ring are logically grouped by the wl_tablet_pad_ring.frame
    event.
    """
    object_id = 0
    version = 2

    class source(Enum):
        finger: int

    @staticmethod
    def set_feedback(description: string, serial: uint) -> None:
        """
        set compositor feedback
        Request that the compositor use the provided feedback string
        associated with this ring. This request should be issued immediately
        after a wp_tablet_pad_group.mode_switch event from the corresponding
        group is received, or whenever the ring is mapped to a different
        action. See wp_tablet_pad_group.mode_switch for more details.
        Clients are encouraged to provide context-aware descriptions for
        the actions associated with the ring; compositors may use this
        information to offer visual feedback about the button layout
        (eg. on-screen displays).
        The provided string 'description' is a UTF-8 encoded string to be
        associated with this ring, and is considered user-visible; general
        internationalization rules apply.
        The serial argument will be that of the last
        wp_tablet_pad_group.mode_switch event received for the group of this
        ring. Requests providing other serials than the most recent one will be
        ignored.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the ring object
        This destroys the client's resource for this ring object.
        """

        ...
    class events:
        @staticmethod
        def source(source: zwp_tablet_pad_ring_v2.source) -> None:
            """
            ring event source
            Source information for ring events.
            This event does not occur on its own. It is sent before a
            wp_tablet_pad_ring.frame event and carries the source information
            for all events within that frame.
            The source specifies how this event was generated. If the source is
            wp_tablet_pad_ring.source.finger, a wp_tablet_pad_ring.stop event
            will be sent when the user lifts the finger off the device.
            This event is optional. If the source is unknown for an interaction,
            no event is sent.
            """

            ...

        @staticmethod
        def angle(degrees: fixed) -> None:
            """
            angle changed
            Sent whenever the angle on a ring changes.
            The angle is provided in degrees clockwise from the logical
            north of the ring in the pad's current rotation.
            """

            ...

        @staticmethod
        def stop() -> None:
            """
            interaction stopped
            Stop notification for ring events.
            For some wp_tablet_pad_ring.source types, a wp_tablet_pad_ring.stop
            event is sent to notify a client that the interaction with the ring
            has terminated. This enables the client to implement kinetic scrolling.
            See the wp_tablet_pad_ring.source documentation for information on
            when this event may be generated.
            Any wp_tablet_pad_ring.angle events with the same source after this
            event should be considered as the start of a new interaction.
            """

            ...

        @staticmethod
        def frame(time: uint) -> None:
            """
            end of a ring event sequence
            Indicates the end of a set of ring events that logically belong
            together. A client is expected to accumulate the data in all events
            within the frame before proceeding.
            All wp_tablet_pad_ring events before a wp_tablet_pad_ring.frame event belong
            logically together. For example, on termination of a finger interaction
            on a ring the compositor will send a wp_tablet_pad_ring.source event,
            a wp_tablet_pad_ring.stop event and a wp_tablet_pad_ring.frame event.
            A wp_tablet_pad_ring.frame event is sent for every logical event
            group, even if the group only contains a single wp_tablet_pad_ring
            event. Specifically, a client may get a sequence: angle, frame,
            angle, frame, etc.
            """

            ...
class zwp_tablet_pad_strip_v2:
    """
    pad strip
    A linear interaction area, such as the strips found in Wacom Cintiq
    models.
    Events on a strip are logically grouped by the wl_tablet_pad_strip.frame
    event.
    """
    object_id = 0
    version = 2

    class source(Enum):
        finger: int

    @staticmethod
    def set_feedback(description: string, serial: uint) -> None:
        """
        set compositor feedback
        Requests the compositor to use the provided feedback string
        associated with this strip. This request should be issued immediately
        after a wp_tablet_pad_group.mode_switch event from the corresponding
        group is received, or whenever the strip is mapped to a different
        action. See wp_tablet_pad_group.mode_switch for more details.
        Clients are encouraged to provide context-aware descriptions for
        the actions associated with the strip, and compositors may use this
        information to offer visual feedback about the button layout
        (eg. on-screen displays).
        The provided string 'description' is a UTF-8 encoded string to be
        associated with this ring, and is considered user-visible; general
        internationalization rules apply.
        The serial argument will be that of the last
        wp_tablet_pad_group.mode_switch event received for the group of this
        strip. Requests providing other serials than the most recent one will be
        ignored.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the strip object
        This destroys the client's resource for this strip object.
        """

        ...
    class events:
        @staticmethod
        def source(source: zwp_tablet_pad_strip_v2.source) -> None:
            """
            strip event source
            Source information for strip events.
            This event does not occur on its own. It is sent before a
            wp_tablet_pad_strip.frame event and carries the source information
            for all events within that frame.
            The source specifies how this event was generated. If the source is
            wp_tablet_pad_strip.source.finger, a wp_tablet_pad_strip.stop event
            will be sent when the user lifts their finger off the device.
            This event is optional. If the source is unknown for an interaction,
            no event is sent.
            """

            ...

        @staticmethod
        def position(position: uint) -> None:
            """
            position changed
            Sent whenever the position on a strip changes.
            The position is normalized to a range of [0, 65535], the 0-value
            represents the top-most and/or left-most position of the strip in
            the pad's current rotation.
            """

            ...

        @staticmethod
        def stop() -> None:
            """
            interaction stopped
            Stop notification for strip events.
            For some wp_tablet_pad_strip.source types, a wp_tablet_pad_strip.stop
            event is sent to notify a client that the interaction with the strip
            has terminated. This enables the client to implement kinetic
            scrolling. See the wp_tablet_pad_strip.source documentation for
            information on when this event may be generated.
            Any wp_tablet_pad_strip.position events with the same source after this
            event should be considered as the start of a new interaction.
            """

            ...

        @staticmethod
        def frame(time: uint) -> None:
            """
            end of a strip event sequence
            Indicates the end of a set of events that represent one logical
            hardware strip event. A client is expected to accumulate the data
            in all events within the frame before proceeding.
            All wp_tablet_pad_strip events before a wp_tablet_pad_strip.frame event belong
            logically together. For example, on termination of a finger interaction
            on a strip the compositor will send a wp_tablet_pad_strip.source event,
            a wp_tablet_pad_strip.stop event and a wp_tablet_pad_strip.frame
            event.
            A wp_tablet_pad_strip.frame event is sent for every logical event
            group, even if the group only contains a single wp_tablet_pad_strip
            event. Specifically, a client may get a sequence: position, frame,
            position, frame, etc.
            """

            ...
class zwp_tablet_pad_group_v2:
    """
    a set of buttons, rings and strips
    A pad group describes a distinct (sub)set of buttons, rings and strips
    present in the tablet. The criteria of this grouping is usually positional,
    eg. if a tablet has buttons on the left and right side, 2 groups will be
    presented. The physical arrangement of groups is undisclosed and may
    change on the fly.
    Pad groups will announce their features during pad initialization. Between
    the corresponding wp_tablet_pad.group event and wp_tablet_pad_group.done, the
    pad group will announce the buttons, rings and strips contained in it,
    plus the number of supported modes.
    Modes are a mechanism to allow multiple groups of actions for every element
    in the pad group. The number of groups and available modes in each is
    persistent across device plugs. The current mode is user-switchable, it
    will be announced through the wp_tablet_pad_group.mode_switch event both
    whenever it is switched, and after wp_tablet_pad.enter.
    The current mode logically applies to all elements in the pad group,
    although it is at clients' discretion whether to actually perform different
    actions, and/or issue the respective .set_feedback requests to notify the
    compositor. See the wp_tablet_pad_group.mode_switch event for more details.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        destroy the pad object
        Destroy the wp_tablet_pad_group object. Objects created from this object
        are unaffected and should be destroyed separately.
        """

        ...
    class events:
        @staticmethod
        def buttons(buttons: array) -> None:
            """
            buttons announced
            Sent on wp_tablet_pad_group initialization to announce the available
            buttons in the group. Button indices start at 0, a button may only be
            in one group at a time.
            This event is first sent in the initial burst of events before the
            wp_tablet_pad_group.done event.
            Some buttons are reserved by the compositor. These buttons may not be
            assigned to any wp_tablet_pad_group. Compositors may broadcast this
            event in the case of changes to the mapping of these reserved buttons.
            If the compositor happens to reserve all buttons in a group, this event
            will be sent with an empty array.
            """

            ...

        @staticmethod
        def ring(ring: zwp_tablet_pad_ring_v2) -> None:
            """
            ring announced
            Sent on wp_tablet_pad_group initialization to announce available rings.
            One event is sent for each ring available on this pad group.
            This event is sent in the initial burst of events before the
            wp_tablet_pad_group.done event.
            """

            ...

        @staticmethod
        def strip(strip: zwp_tablet_pad_strip_v2) -> None:
            """
            strip announced
            Sent on wp_tablet_pad initialization to announce available strips.
            One event is sent for each strip available on this pad group.
            This event is sent in the initial burst of events before the
            wp_tablet_pad_group.done event.
            """

            ...

        @staticmethod
        def modes(modes: uint) -> None:
            """
            mode-switch ability announced
            Sent on wp_tablet_pad_group initialization to announce that the pad
            group may switch between modes. A client may use a mode to store a
            specific configuration for buttons, rings and strips and use the
            wl_tablet_pad_group.mode_switch event to toggle between these
            configurations. Mode indices start at 0.
            Switching modes is compositor-dependent. See the
            wp_tablet_pad_group.mode_switch event for more details.
            This event is sent in the initial burst of events before the
            wp_tablet_pad_group.done event. This event is only sent when more than
            more than one mode is available.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            tablet group description events sequence complete
            This event is sent immediately to signal the end of the initial
            burst of descriptive events. A client may consider the static
            description of the tablet to be complete and finalize initialization
            of the tablet group.
            """

            ...

        @staticmethod
        def mode_switch(time: uint, serial: uint, mode: uint) -> None:
            """
            mode switch event
            Notification that the mode was switched.
            A mode applies to all buttons, rings, strips and dials in a group
            simultaneously, but a client is not required to assign different actions
            for each mode. For example, a client may have mode-specific button
            mappings but map the ring to vertical scrolling in all modes. Mode
            indices start at 0.
            Switching modes is compositor-dependent. The compositor may provide
            visual cues to the user about the mode, e.g. by toggling LEDs on
            the tablet device. Mode-switching may be software-controlled or
            controlled by one or more physical buttons. For example, on a Wacom
            Intuos Pro, the button inside the ring may be assigned to switch
            between modes.
            The compositor will also send this event after wp_tablet_pad.enter on
            each group in order to notify of the current mode. Groups that only
            feature one mode will use mode=0 when emitting this event.
            If a button action in the new mode differs from the action in the
            previous mode, the client should immediately issue a
            wp_tablet_pad.set_feedback request for each changed button.
            If a ring, strip or dial action in the new mode differs from the action
            in the previous mode, the client should immediately issue a
            wp_tablet_ring.set_feedback, wp_tablet_strip.set_feedback or
            wp_tablet_dial.set_feedback request for each changed ring, strip or dial.
            """

            ...

        @staticmethod
        def dial(dial: zwp_tablet_pad_dial_v2) -> None:
            """
            dial announced
            Sent on wp_tablet_pad initialization to announce available dials.
            One event is sent for each dial available on this pad group.
            This event is sent in the initial burst of events before the
            wp_tablet_pad_group.done event.
            """

            ...
class zwp_tablet_pad_v2:
    """
    a set of buttons, rings, strips and dials
    A pad device is a set of buttons, rings, strips and dials
    usually physically present on the tablet device itself. Some
    exceptions exist where the pad device is physically detached, e.g. the
    Wacom ExpressKey Remote.
    Pad devices have no axes that control the cursor and are generally
    auxiliary devices to the tool devices used on the tablet surface.
    A pad device has a number of static characteristics, e.g. the number
    of rings. These capabilities are sent in an event sequence after the
    wp_tablet_seat.pad_added event before any actual events from this pad.
    This initial event sequence is terminated by a wp_tablet_pad.done
    event.
    All pad features (buttons, rings, strips and dials) are logically divided into
    groups and all pads have at least one group. The available groups are
    notified through the wp_tablet_pad.group event; the compositor will
    emit one event per group before emitting wp_tablet_pad.done.
    Groups may have multiple modes. Modes allow clients to map multiple
    actions to a single pad feature. Only one mode can be active per group,
    although different groups may have different active modes.
    """
    object_id = 0
    version = 2

    class button_state(Enum):
        released: int
        pressed: int

    @staticmethod
    def set_feedback(button: uint, description: string, serial: uint) -> None:
        """
        set compositor feedback
        Requests the compositor to use the provided feedback string
        associated with this button. This request should be issued immediately
        after a wp_tablet_pad_group.mode_switch event from the corresponding
        group is received, or whenever a button is mapped to a different
        action. See wp_tablet_pad_group.mode_switch for more details.
        Clients are encouraged to provide context-aware descriptions for
        the actions associated with each button, and compositors may use
        this information to offer visual feedback on the button layout
        (e.g. on-screen displays).
        Button indices start at 0. Setting the feedback string on a button
        that is reserved by the compositor (i.e. not belonging to any
        wp_tablet_pad_group) does not generate an error but the compositor
        is free to ignore the request.
        The provided string 'description' is a UTF-8 encoded string to be
        associated with this ring, and is considered user-visible; general
        internationalization rules apply.
        The serial argument will be that of the last
        wp_tablet_pad_group.mode_switch event received for the group of this
        button. Requests providing other serials than the most recent one will
        be ignored.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the pad object
        Destroy the wp_tablet_pad object. Objects created from this object
        are unaffected and should be destroyed separately.
        """

        ...
    class events:
        @staticmethod
        def group(pad_group: zwp_tablet_pad_group_v2) -> None:
            """
            group announced
            Sent on wp_tablet_pad initialization to announce available groups.
            One event is sent for each pad group available.
            This event is sent in the initial burst of events before the
            wp_tablet_pad.done event. At least one group will be announced.
            """

            ...

        @staticmethod
        def path(path: string) -> None:
            """
            path to the device
            A system-specific device path that indicates which device is behind
            this wp_tablet_pad. This information may be used to gather additional
            information about the device, e.g. through libwacom.
            The format of the path is unspecified, it may be a device node, a
            sysfs path, or some other identifier. It is up to the client to
            identify the string provided.
            This event is sent in the initial burst of events before the
            wp_tablet_pad.done event.
            """

            ...

        @staticmethod
        def buttons(buttons: uint) -> None:
            """
            buttons announced
            Sent on wp_tablet_pad initialization to announce the available
            buttons.
            This event is sent in the initial burst of events before the
            wp_tablet_pad.done event. This event is only sent when at least one
            button is available.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            pad description event sequence complete
            This event signals the end of the initial burst of descriptive
            events. A client may consider the static description of the pad to
            be complete and finalize initialization of the pad.
            """

            ...

        @staticmethod
        def button(time: uint, button: uint, state: zwp_tablet_pad_v2.button_state) -> None:
            """
            physical button state
            Sent whenever the physical state of a button changes.
            """

            ...

        @staticmethod
        def enter(serial: uint, tablet: object, surface: object) -> None:
            """
            enter event
            Notification that this pad is focused on the specified surface.
            """

            ...

        @staticmethod
        def leave(serial: uint, surface: object) -> None:
            """
            leave event
            Notification that this pad is no longer focused on the specified
            surface.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            pad removed event
            Sent when the pad has been removed from the system. When a tablet
            is removed its pad(s) will be removed too.
            When this event is received, the client must destroy all rings, strips
            and groups that were offered by this pad, and issue wp_tablet_pad.destroy
            the pad itself.
            """

            ...
class zwp_tablet_pad_dial_v2:
    """
    pad dial
    A rotary control, e.g. a dial or a wheel.
    Events on a dial are logically grouped by the wl_tablet_pad_dial.frame
    event.
    """
    object_id = 0
    version = 2

    @staticmethod
    def set_feedback(description: string, serial: uint) -> None:
        """
        set compositor feedback
        Requests the compositor to use the provided feedback string
        associated with this dial. This request should be issued immediately
        after a wp_tablet_pad_group.mode_switch event from the corresponding
        group is received, or whenever the dial is mapped to a different
        action. See wp_tablet_pad_group.mode_switch for more details.
        Clients are encouraged to provide context-aware descriptions for
        the actions associated with the dial, and compositors may use this
        information to offer visual feedback about the button layout
        (eg. on-screen displays).
        The provided string 'description' is a UTF-8 encoded string to be
        associated with this ring, and is considered user-visible; general
        internationalization rules apply.
        The serial argument will be that of the last
        wp_tablet_pad_group.mode_switch event received for the group of this
        dial. Requests providing other serials than the most recent one will be
        ignored.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the dial object
        This destroys the client's resource for this dial object.
        """

        ...
    class events:
        @staticmethod
        def delta(value120: int) -> None:
            """
            delta movement
            Sent whenever the position on a dial changes.
            This event carries the wheel delta as multiples or fractions
            of 120 with each multiple of 120 representing one logical wheel detent.
            For example, an axis_value120 of 30 is one quarter of
            a logical wheel step in the positive direction, a value120 of
            -240 are two logical wheel steps in the negative direction within the
            same hardware event. See the wl_pointer.axis_value120 for more details.
            The value120 must not be zero.
            """

            ...

        @staticmethod
        def frame(time: uint) -> None:
            """
            end of a dial event sequence
            Indicates the end of a set of events that represent one logical
            hardware dial event. A client is expected to accumulate the data
            in all events within the frame before proceeding.
            All wp_tablet_pad_dial events before a wp_tablet_pad_dial.frame event belong
            logically together.
            A wp_tablet_pad_dial.frame event is sent for every logical event
            group, even if the group only contains a single wp_tablet_pad_dial
            event. Specifically, a client may get a sequence: delta, frame,
            delta, frame, etc.
            """

            ...
class wp_presentation:
    """
    timed presentation related wl_surface requests
    """
    object_id = 0
    version = 2

    class error(Enum):
        invalid_timestamp: int
        invalid_flag: int

    @staticmethod
    def destroy() -> None:
        """
        unbind from the presentation interface
        Informs the server that the client will no longer be using
        this protocol object. Existing objects created by this object
        are not affected.
        """

        ...

    @staticmethod
    def feedback(surface: object) -> wp_presentation_feedback:
        """
        request presentation feedback information
        Request presentation feedback for the current content submission
        on the given surface. This creates a new presentation_feedback
        object, which will deliver the feedback information once. If
        multiple presentation_feedback objects are created for the same
        submission, they will all deliver the same information.
        For details on what information is returned, see the
        presentation_feedback interface.
        """

        ...
    class events:
        @staticmethod
        def clock_id(clk_id: uint) -> None:
            """
            clock ID for timestamps
            This event tells the client in which clock domain the
            compositor interprets the timestamps used by the presentation
            extension. This clock is called the presentation clock.
            The compositor sends this event when the client binds to the
            presentation interface. The presentation clock does not change
            during the lifetime of the client connection.
            The clock identifier is platform dependent. On POSIX platforms, the
            identifier value is one of the clockid_t values accepted by
            clock_gettime(). clock_gettime() is defined by POSIX.1-2001.
            Timestamps in this clock domain are expressed as tv_sec_hi,
            tv_sec_lo, tv_nsec triples, each component being an unsigned
            32-bit value. Whole seconds are in tv_sec which is a 64-bit
            value combined from tv_sec_hi and tv_sec_lo, and the
            additional fractional part in tv_nsec as nanoseconds. Hence,
            for valid timestamps tv_nsec must be in [0, 999999999].
            Note that clock_id applies only to the presentation clock,
            and implies nothing about e.g. the timestamps used in the
            Wayland core protocol input events.
            Compositors should prefer a clock which does not jump and is
            not slewed e.g. by NTP. The absolute value of the clock is
            irrelevant. Precision of one millisecond or better is
            recommended. Clients must be able to query the current clock
            value directly, not by asking the compositor.
            """

            ...
class wp_presentation_feedback:
    """
    presentation time feedback event
    A presentation_feedback object returns an indication that a
    wl_surface content update has become visible to the user.
    One object corresponds to one content update submission
    (wl_surface.commit). There are two possible outcomes: the
    content update is presented to the user, and a presentation
    timestamp delivered; or, the user did not see the content
    update because it was superseded or its surface destroyed,
    and the content update is discarded.
    Once a presentation_feedback object has delivered a 'presented'
    or 'discarded' event it is automatically destroyed.
    """
    object_id = 0
    version = 2

    class kind(IntFlag):
        vsync: int
        hw_clock: int
        hw_completion: int
        zero_copy: int

    class events:
        @staticmethod
        def sync_output(output: object) -> None:
            """
            presentation synchronized to this output
            As presentation can be synchronized to only one output at a
            time, this event tells which output it was. This event is only
            sent prior to the presented event.
            As clients may bind to the same global wl_output multiple
            times, this event is sent for each bound instance that matches
            the synchronized output. If a client has not bound to the
            right wl_output global at all, this event is not sent.
            """

            ...

        @staticmethod
        def presented(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint, refresh: uint, seq_hi: uint, seq_lo: uint, flags: wp_presentation_feedback.kind) -> None:
            """
            the content update was displayed
            The associated content update was displayed to the user at the
            indicated time (tv_sec_hi/lo, tv_nsec). For the interpretation of
            the timestamp, see presentation.clock_id event.
            The timestamp corresponds to the time when the content update
            turned into light the first time on the surface's main output.
            Compositors may approximate this from the framebuffer flip
            completion events from the system, and the latency of the
            physical display path if known.
            This event is preceded by all related sync_output events
            telling which output's refresh cycle the feedback corresponds
            to, i.e. the main output for the surface. Compositors are
            recommended to choose the output containing the largest part
            of the wl_surface, or keeping the output they previously
            chose. Having a stable presentation output association helps
            clients predict future output refreshes (vblank).
            The 'refresh' argument gives the compositor's prediction of how
            many nanoseconds after tv_sec, tv_nsec the very next output
            refresh may occur. This is to further aid clients in
            predicting future refreshes, i.e., estimating the timestamps
            targeting the next few vblanks. If such prediction cannot
            usefully be done, the argument is zero.
            For version 2 and later, if the output does not have a constant
            refresh rate, explicit video mode switches excluded, then the
            refresh argument must be either an appropriate rate picked by the
            compositor (e.g. fastest rate), or 0 if no such rate exists.
            For version 1, if the output does not have a constant refresh rate,
            the refresh argument must be zero.
            The 64-bit value combined from seq_hi and seq_lo is the value
            of the output's vertical retrace counter when the content
            update was first scanned out to the display. This value must
            be compatible with the definition of MSC in
            GLX_OML_sync_control specification. Note, that if the display
            path has a non-zero latency, the time instant specified by
            this counter may differ from the timestamp's.
            If the output does not have a concept of vertical retrace or a
            refresh cycle, or the output device is self-refreshing without
            a way to query the refresh count, then the arguments seq_hi
            and seq_lo must be zero.
            """

            ...

        @staticmethod
        def discarded() -> None:
            """
            the content update was not displayed
            The content update was never displayed to the user.
            """

            ...
class xdg_wm_base:
    """
    create desktop-style surfaces
    The xdg_wm_base interface is exposed as a global object enabling clients
    to turn their wl_surfaces into windows in a desktop environment. It
    defines the basic functionality needed for clients and the compositor to
    create windows that can be dragged, resized, maximized, etc, as well as
    creating transient windows such as popup menus.
    """
    object_id = 0
    version = 6

    class error(Enum):
        role: int
        defunct_surfaces: int
        not_the_topmost_popup: int
        invalid_popup_parent: int
        invalid_surface_state: int
        invalid_positioner: int
        unresponsive: int

    @staticmethod
    def destroy() -> None:
        """
        destroy xdg_wm_base
        Destroy this xdg_wm_base object.
        Destroying a bound xdg_wm_base object while there are surfaces
        still alive created by this xdg_wm_base object instance is illegal
        and will result in a defunct_surfaces error.
        """

        ...

    @staticmethod
    def create_positioner() -> xdg_positioner:
        """
        create a positioner object
        Create a positioner object. A positioner object is used to position
        surfaces relative to some parent surface. See the interface description
        and xdg_surface.get_popup for details.
        """

        ...

    @staticmethod
    def get_xdg_surface(surface: object) -> xdg_surface:
        """
        create a shell surface from a surface
        This creates an xdg_surface for the given surface. While xdg_surface
        itself is not a role, the corresponding surface may only be assigned
        a role extending xdg_surface, such as xdg_toplevel or xdg_popup. It is
        illegal to create an xdg_surface for a wl_surface which already has an
        assigned role and this will result in a role error.
        This creates an xdg_surface for the given surface. An xdg_surface is
        used as basis to define a role to a given surface, such as xdg_toplevel
        or xdg_popup. It also manages functionality shared between xdg_surface
        based surface roles.
        See the documentation of xdg_surface for more details about what an
        xdg_surface is and how it is used.
        """

        ...

    @staticmethod
    def pong(serial: uint) -> None:
        """
        respond to a ping event
        A client must respond to a ping event with a pong request or
        the client may be deemed unresponsive. See xdg_wm_base.ping
        and xdg_wm_base.error.unresponsive.
        """

        ...
    class events:
        @staticmethod
        def ping(serial: uint) -> None:
            """
            check if the client is alive
            The ping event asks the client if it's still alive. Pass the
            serial specified in the event back to the compositor by sending
            a "pong" request back with the specified serial. See xdg_wm_base.pong.
            Compositors can use this to determine if the client is still
            alive. It's unspecified what will happen if the client doesn't
            respond to the ping request, or in what timeframe. Clients should
            try to respond in a reasonable amount of time. The “unresponsive”
            error is provided for compositors that wish to disconnect unresponsive
            clients.
            A compositor is free to ping in any way it wants, but a client must
            always respond to any xdg_wm_base object it created.
            """

            ...
class xdg_positioner:
    """
    child surface positioner
    The xdg_positioner provides a collection of rules for the placement of a
    child surface relative to a parent surface. Rules can be defined to ensure
    the child surface remains within the visible area's borders, and to
    specify how the child surface changes its position, such as sliding along
    an axis, or flipping around a rectangle. These positioner-created rules are
    constrained by the requirement that a child surface must intersect with or
    be at least partially adjacent to its parent surface.
    See the various requests for details about possible rules.
    At the time of the request, the compositor makes a copy of the rules
    specified by the xdg_positioner. Thus, after the request is complete the
    xdg_positioner object can be destroyed or reused; further changes to the
    object will have no effect on previous usages.
    For an xdg_positioner object to be considered complete, it must have a
    non-zero size set by set_size, and a non-zero anchor rectangle set by
    set_anchor_rect. Passing an incomplete xdg_positioner object when
    positioning a surface raises an invalid_positioner error.
    """
    object_id = 0
    version = 6

    class error(Enum):
        invalid_input: int


    class anchor(Enum):
        none: int
        top: int
        bottom: int
        left: int
        right: int
        top_left: int
        bottom_left: int
        top_right: int
        bottom_right: int


    class gravity(Enum):
        none: int
        top: int
        bottom: int
        left: int
        right: int
        top_left: int
        bottom_left: int
        top_right: int
        bottom_right: int


    class constraint_adjustment(IntFlag):
        none: int
        slide_x: int
        slide_y: int
        flip_x: int
        flip_y: int
        resize_x: int
        resize_y: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_positioner object
        Notify the compositor that the xdg_positioner will no longer be used.
        """

        ...

    @staticmethod
    def set_size(width: int, height: int) -> None:
        """
        set the size of the to-be positioned rectangle
        Set the size of the surface that is to be positioned with the positioner
        object. The size is in surface-local coordinates and corresponds to the
        window geometry. See xdg_surface.set_window_geometry.
        If a zero or negative size is set the invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_anchor_rect(x: int, y: int, width: int, height: int) -> None:
        """
        set the anchor rectangle within the parent surface
        Specify the anchor rectangle within the parent surface that the child
        surface will be placed relative to. The rectangle is relative to the
        window geometry as defined by xdg_surface.set_window_geometry of the
        parent surface.
        When the xdg_positioner object is used to position a child surface, the
        anchor rectangle may not extend outside the window geometry of the
        positioned child's parent surface.
        If a negative size is set the invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_anchor(anchor: xdg_positioner.anchor) -> None:
        """
        set anchor rectangle anchor
        Defines the anchor point for the anchor rectangle. The specified anchor
        is used derive an anchor point that the child surface will be
        positioned relative to. If a corner anchor is set (e.g. 'top_left' or
        'bottom_right'), the anchor point will be at the specified corner;
        otherwise, the derived anchor point will be centered on the specified
        edge, or in the center of the anchor rectangle if no edge is specified.
        """

        ...

    @staticmethod
    def set_gravity(gravity: xdg_positioner.gravity) -> None:
        """
        set child surface gravity
        Defines in what direction a surface should be positioned, relative to
        the anchor point of the parent surface. If a corner gravity is
        specified (e.g. 'bottom_right' or 'top_left'), then the child surface
        will be placed towards the specified gravity; otherwise, the child
        surface will be centered over the anchor point on any axis that had no
        gravity specified. If the gravity is not in the ‘gravity’ enum, an
        invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_constraint_adjustment(constraint_adjustment: xdg_positioner.constraint_adjustment) -> None:
        """
        set the adjustment to be done when constrained
        Specify how the window should be positioned if the originally intended
        position caused the surface to be constrained, meaning at least
        partially outside positioning boundaries set by the compositor. The
        adjustment is set by constructing a bitmask describing the adjustment to
        be made when the surface is constrained on that axis.
        If no bit for one axis is set, the compositor will assume that the child
        surface should not change its position on that axis when constrained.
        If more than one bit for one axis is set, the order of how adjustments
        are applied is specified in the corresponding adjustment descriptions.
        The default adjustment is none.
        """

        ...

    @staticmethod
    def set_offset(x: int, y: int) -> None:
        """
        set surface position offset
        Specify the surface position offset relative to the position of the
        anchor on the anchor rectangle and the anchor on the surface. For
        example if the anchor of the anchor rectangle is at (x, y), the surface
        has the gravity bottom|right, and the offset is (ox, oy), the calculated
        surface position will be (x + ox, y + oy). The offset position of the
        surface is the one used for constraint testing. See
        set_constraint_adjustment.
        An example use case is placing a popup menu on top of a user interface
        element, while aligning the user interface element of the parent surface
        with some user interface element placed somewhere in the popup surface.
        """

        ...

    @staticmethod
    def set_reactive() -> None:
        """
        continuously reconstrain the surface
        When set reactive, the surface is reconstrained if the conditions used
        for constraining changed, e.g. the parent window moved.
        If the conditions changed and the popup was reconstrained, an
        xdg_popup.configure event is sent with updated geometry, followed by an
        xdg_surface.configure event.
        """

        ...

    @staticmethod
    def set_parent_size(parent_width: int, parent_height: int) -> None:
        """
        
        Set the parent window geometry the compositor should use when
        positioning the popup. The compositor may use this information to
        determine the future state the popup should be constrained using. If
        this doesn't match the dimension of the parent the popup is eventually
        positioned against, the behavior is undefined.
        The arguments are given in the surface-local coordinate space.
        """

        ...

    @staticmethod
    def set_parent_configure(serial: uint) -> None:
        """
        set parent configure this is a response to
        Set the serial of an xdg_surface.configure event this positioner will be
        used in response to. The compositor may use this information together
        with set_parent_size to determine what future state the popup should be
        constrained using.
        """

        ...
class xdg_surface:
    """
    desktop user interface surface base interface
    An interface that may be implemented by a wl_surface, for
    implementations that provide a desktop-style user interface.
    It provides a base set of functionality required to construct user
    interface elements requiring management by the compositor, such as
    toplevel windows, menus, etc. The types of functionality are split into
    xdg_surface roles.
    Creating an xdg_surface does not set the role for a wl_surface. In order
    to map an xdg_surface, the client must create a role-specific object
    using, e.g., get_toplevel, get_popup. The wl_surface for any given
    xdg_surface can have at most one role, and may not be assigned any role
    not based on xdg_surface.
    A role must be assigned before any other requests are made to the
    xdg_surface object.
    The client must call wl_surface.commit on the corresponding wl_surface
    for the xdg_surface state to take effect.
    Creating an xdg_surface from a wl_surface which has a buffer attached or
    committed is a client error, and any attempts by a client to attach or
    manipulate a buffer prior to the first xdg_surface.configure call must
    also be treated as errors.
    After creating a role-specific object and setting it up (e.g. by sending
    the title, app ID, size constraints, parent, etc), the client must
    perform an initial commit without any buffer attached. The compositor
    will reply with initial wl_surface state such as
    wl_surface.preferred_buffer_scale followed by an xdg_surface.configure
    event. The client must acknowledge it and is then allowed to attach a
    buffer to map the surface.
    Mapping an xdg_surface-based role surface is defined as making it
    possible for the surface to be shown by the compositor. Note that
    a mapped surface is not guaranteed to be visible once it is mapped.
    For an xdg_surface to be mapped by the compositor, the following
    conditions must be met:
    (1) the client has assigned an xdg_surface-based role to the surface
    (2) the client has set and committed the xdg_surface state and the
    role-dependent state to the surface
    (3) the client has committed a buffer to the surface
    A newly-unmapped surface is considered to have met condition (1) out
    of the 3 required conditions for mapping a surface if its role surface
    has not been destroyed, i.e. the client must perform the initial commit
    again before attaching a buffer.
    """
    object_id = 0
    version = 6

    class error(Enum):
        not_constructed: int
        already_constructed: int
        unconfigured_buffer: int
        invalid_serial: int
        invalid_size: int
        defunct_role_object: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_surface
        Destroy the xdg_surface object. An xdg_surface must only be destroyed
        after its role object has been destroyed, otherwise
        a defunct_role_object error is raised.
        """

        ...

    @staticmethod
    def get_toplevel() -> xdg_toplevel:
        """
        assign the xdg_toplevel surface role
        This creates an xdg_toplevel object for the given xdg_surface and gives
        the associated wl_surface the xdg_toplevel role.
        See the documentation of xdg_toplevel for more details about what an
        xdg_toplevel is and how it is used.
        """

        ...

    @staticmethod
    def get_popup(parent: object, positioner: object) -> xdg_popup:
        """
        assign the xdg_popup surface role
        This creates an xdg_popup object for the given xdg_surface and gives
        the associated wl_surface the xdg_popup role.
        If null is passed as a parent, a parent surface must be specified using
        some other protocol, before committing the initial state.
        See the documentation of xdg_popup for more details about what an
        xdg_popup is and how it is used.
        """

        ...

    @staticmethod
    def set_window_geometry(x: int, y: int, width: int, height: int) -> None:
        """
        set the new window geometry
        The window geometry of a surface is its "visible bounds" from the
        user's perspective. Client-side decorations often have invisible
        portions like drop-shadows which should be ignored for the
        purposes of aligning, placing and constraining windows.
        The window geometry is double-buffered state, see wl_surface.commit.
        When maintaining a position, the compositor should treat the (x, y)
        coordinate of the window geometry as the top left corner of the window.
        A client changing the (x, y) window geometry coordinate should in
        general not alter the position of the window.
        Once the window geometry of the surface is set, it is not possible to
        unset it, and it will remain the same until set_window_geometry is
        called again, even if a new subsurface or buffer is attached.
        If never set, the value is the full bounds of the surface,
        including any subsurfaces. This updates dynamically on every
        commit. This unset is meant for extremely simple clients.
        The arguments are given in the surface-local coordinate space of
        the wl_surface associated with this xdg_surface, and may extend outside
        of the wl_surface itself to mark parts of the subsurface tree as part of
        the window geometry.
        When applied, the effective window geometry will be the set window
        geometry clamped to the bounding rectangle of the combined
        geometry of the surface of the xdg_surface and the associated
        subsurfaces.
        The effective geometry will not be recalculated unless a new call to
        set_window_geometry is done and the new pending surface state is
        subsequently applied.
        The width and height of the effective window geometry must be
        greater than zero. Setting an invalid size will raise an
        invalid_size error.
        """

        ...

    @staticmethod
    def ack_configure(serial: uint) -> None:
        """
        ack a configure event
        When a configure event is received, if a client commits the
        surface in response to the configure event, then the client
        must make an ack_configure request sometime before the commit
        request, passing along the serial of the configure event.
        For instance, for toplevel surfaces the compositor might use this
        information to move a surface to the top left only when the client has
        drawn itself for the maximized or fullscreen state.
        If the client receives multiple configure events before it
        can respond to one, it only has to ack the last configure event.
        Acking a configure event that was never sent raises an invalid_serial
        error.
        A client is not required to commit immediately after sending
        an ack_configure request - it may even ack_configure several times
        before its next surface commit.
        A client may send multiple ack_configure requests before committing, but
        only the last request sent before a commit indicates which configure
        event the client really is responding to.
        Sending an ack_configure request consumes the serial number sent with
        the request, as well as serial numbers sent by all configure events
        sent on this xdg_surface prior to the configure event referenced by
        the committed serial.
        It is an error to issue multiple ack_configure requests referencing a
        serial from the same configure event, or to issue an ack_configure
        request referencing a serial from a configure event issued before the
        event identified by the last ack_configure request for the same
        xdg_surface. Doing so will raise an invalid_serial error.
        """

        ...
    class events:
        @staticmethod
        def configure(serial: uint) -> None:
            """
            suggest a surface change
            The configure event marks the end of a configure sequence. A configure
            sequence is a set of one or more events configuring the state of the
            xdg_surface, including the final xdg_surface.configure event.
            Where applicable, xdg_surface surface roles will during a configure
            sequence extend this event as a latched state sent as events before the
            xdg_surface.configure event. Such events should be considered to make up
            a set of atomically applied configuration states, where the
            xdg_surface.configure commits the accumulated state.
            Clients should arrange their surface for the new states, and then send
            an ack_configure request with the serial sent in this configure event at
            some point before committing the new surface.
            If the client receives multiple configure events before it can respond
            to one, it is free to discard all but the last event it received.
            """

            ...
class xdg_toplevel:
    """
    toplevel surface
    This interface defines an xdg_surface role which allows a surface to,
    among other things, set window-like properties such as maximize,
    fullscreen, and minimize, set application-specific metadata like title and
    id, and well as trigger user interactive operations such as interactive
    resize and move.
    A xdg_toplevel by default is responsible for providing the full intended
    visual representation of the toplevel, which depending on the window
    state, may mean things like a title bar, window controls and drop shadow.
    Unmapping an xdg_toplevel means that the surface cannot be shown
    by the compositor until it is explicitly mapped again.
    All active operations (e.g., move, resize) are canceled and all
    attributes (e.g. title, state, stacking, ...) are discarded for
    an xdg_toplevel surface when it is unmapped. The xdg_toplevel returns to
    the state it had right after xdg_surface.get_toplevel. The client
    can re-map the toplevel by performing a commit without any buffer
    attached, waiting for a configure event and handling it as usual (see
    xdg_surface description).
    Attaching a null buffer to a toplevel unmaps the surface.
    """
    object_id = 0
    version = 6

    class error(Enum):
        invalid_resize_edge: int
        invalid_parent: int
        invalid_size: int


    class resize_edge(Enum):
        none: int
        top: int
        bottom: int
        left: int
        top_left: int
        bottom_left: int
        right: int
        top_right: int
        bottom_right: int


    class state(Enum):
        maximized: int
        fullscreen: int
        resizing: int
        activated: int
        tiled_left: int
        tiled_right: int
        tiled_top: int
        tiled_bottom: int
        suspended: int


    class wm_capabilities(Enum):
        window_menu: int
        maximize: int
        fullscreen: int
        minimize: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_toplevel
        This request destroys the role surface and unmaps the surface;
        see "Unmapping" behavior in interface section for details.
        """

        ...

    @staticmethod
    def set_parent(parent: object) -> None:
        """
        set the parent of this surface
        Set the "parent" of this surface. This surface should be stacked
        above the parent surface and all other ancestor surfaces.
        Parent surfaces should be set on dialogs, toolboxes, or other
        "auxiliary" surfaces, so that the parent is raised when the dialog
        is raised.
        Setting a null parent for a child surface unsets its parent. Setting
        a null parent for a surface which currently has no parent is a no-op.
        Only mapped surfaces can have child surfaces. Setting a parent which
        is not mapped is equivalent to setting a null parent. If a surface
        becomes unmapped, its children's parent is set to the parent of
        the now-unmapped surface. If the now-unmapped surface has no parent,
        its children's parent is unset. If the now-unmapped surface becomes
        mapped again, its parent-child relationship is not restored.
        The parent toplevel must not be one of the child toplevel's
        descendants, and the parent must be different from the child toplevel,
        otherwise the invalid_parent protocol error is raised.
        """

        ...

    @staticmethod
    def set_title(title: string) -> None:
        """
        set surface title
        Set a short title for the surface.
        This string may be used to identify the surface in a task bar,
        window list, or other user interface elements provided by the
        compositor.
        The string must be encoded in UTF-8.
        """

        ...

    @staticmethod
    def set_app_id(app_id: string) -> None:
        """
        set application ID
        Set an application identifier for the surface.
        The app ID identifies the general class of applications to which
        the surface belongs. The compositor can use this to group multiple
        surfaces together, or to determine how to launch a new application.
        For D-Bus activatable applications, the app ID is used as the D-Bus
        service name.
        The compositor shell will try to group application surfaces together
        by their app ID. As a best practice, it is suggested to select app
        ID's that match the basename of the application's .desktop file.
        For example, "org.freedesktop.FooViewer" where the .desktop file is
        "org.freedesktop.FooViewer.desktop".
        Like other properties, a set_app_id request can be sent after the
        xdg_toplevel has been mapped to update the property.
        See the desktop-entry specification [0] for more details on
        application identifiers and how they relate to well-known D-Bus
        names and .desktop files.
        [0] https://standards.freedesktop.org/desktop-entry-spec/
        """

        ...

    @staticmethod
    def show_window_menu(seat: object, serial: uint, x: int, y: int) -> None:
        """
        show the window menu
        Clients implementing client-side decorations might want to show
        a context menu when right-clicking on the decorations, giving the
        user a menu that they can use to maximize or minimize the window.
        This request asks the compositor to pop up such a window menu at
        the given position, relative to the local surface coordinates of
        the parent surface. There are no guarantees as to what menu items
        the window menu contains, or even if a window menu will be drawn
        at all.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event.
        """

        ...

    @staticmethod
    def move(seat: object, serial: uint) -> None:
        """
        start an interactive move
        Start an interactive, user-driven move of the surface.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event. The passed
        serial is used to determine the type of interactive move (touch,
        pointer, etc).
        The server may ignore move requests depending on the state of
        the surface (e.g. fullscreen or maximized), or if the passed serial
        is no longer valid.
        If triggered, the surface will lose the focus of the device
        (wl_pointer, wl_touch, etc) used for the move. It is up to the
        compositor to visually indicate that the move is taking place, such as
        updating a pointer cursor, during the move. There is no guarantee
        that the device focus will return when the move is completed.
        """

        ...

    @staticmethod
    def resize(seat: object, serial: uint, edges: xdg_toplevel.resize_edge) -> None:
        """
        start an interactive resize
        Start a user-driven, interactive resize of the surface.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event. The passed
        serial is used to determine the type of interactive resize (touch,
        pointer, etc).
        The server may ignore resize requests depending on the state of
        the surface (e.g. fullscreen or maximized).
        If triggered, the client will receive configure events with the
        "resize" state enum value and the expected sizes. See the "resize"
        enum value for more details about what is required. The client
        must also acknowledge configure events using "ack_configure". After
        the resize is completed, the client will receive another "configure"
        event without the resize state.
        If triggered, the surface also will lose the focus of the device
        (wl_pointer, wl_touch, etc) used for the resize. It is up to the
        compositor to visually indicate that the resize is taking place,
        such as updating a pointer cursor, during the resize. There is no
        guarantee that the device focus will return when the resize is
        completed.
        The edges parameter specifies how the surface should be resized, and
        is one of the values of the resize_edge enum. Values not matching
        a variant of the enum will cause the invalid_resize_edge protocol error.
        The compositor may use this information to update the surface position
        for example when dragging the top left corner. The compositor may also
        use this information to adapt its behavior, e.g. choose an appropriate
        cursor image.
        """

        ...

    @staticmethod
    def set_max_size(width: int, height: int) -> None:
        """
        set the maximum size
        Set a maximum size for the window.
        The client can specify a maximum size so that the compositor does
        not try to configure the window beyond this size.
        The width and height arguments are in window geometry coordinates.
        See xdg_surface.set_window_geometry.
        Values set in this way are double-buffered, see wl_surface.commit.
        The compositor can use this information to allow or disallow
        different states like maximize or fullscreen and draw accurate
        animations.
        Similarly, a tiling window manager may use this information to
        place and resize client windows in a more effective way.
        The client should not rely on the compositor to obey the maximum
        size. The compositor may decide to ignore the values set by the
        client and request a larger size.
        If never set, or a value of zero in the request, means that the
        client has no expected maximum size in the given dimension.
        As a result, a client wishing to reset the maximum size
        to an unspecified state can use zero for width and height in the
        request.
        Requesting a maximum size to be smaller than the minimum size of
        a surface is illegal and will result in an invalid_size error.
        The width and height must be greater than or equal to zero. Using
        strictly negative values for width or height will result in a
        invalid_size error.
        """

        ...

    @staticmethod
    def set_min_size(width: int, height: int) -> None:
        """
        set the minimum size
        Set a minimum size for the window.
        The client can specify a minimum size so that the compositor does
        not try to configure the window below this size.
        The width and height arguments are in window geometry coordinates.
        See xdg_surface.set_window_geometry.
        Values set in this way are double-buffered, see wl_surface.commit.
        The compositor can use this information to allow or disallow
        different states like maximize or fullscreen and draw accurate
        animations.
        Similarly, a tiling window manager may use this information to
        place and resize client windows in a more effective way.
        The client should not rely on the compositor to obey the minimum
        size. The compositor may decide to ignore the values set by the
        client and request a smaller size.
        If never set, or a value of zero in the request, means that the
        client has no expected minimum size in the given dimension.
        As a result, a client wishing to reset the minimum size
        to an unspecified state can use zero for width and height in the
        request.
        Requesting a minimum size to be larger than the maximum size of
        a surface is illegal and will result in an invalid_size error.
        The width and height must be greater than or equal to zero. Using
        strictly negative values for width and height will result in a
        invalid_size error.
        """

        ...

    @staticmethod
    def set_maximized() -> None:
        """
        maximize the window
        Maximize the surface.
        After requesting that the surface should be maximized, the compositor
        will respond by emitting a configure event. Whether this configure
        actually sets the window maximized is subject to compositor policies.
        The client must then update its content, drawing in the configured
        state. The client must also acknowledge the configure when committing
        the new content (see ack_configure).
        It is up to the compositor to decide how and where to maximize the
        surface, for example which output and what region of the screen should
        be used.
        If the surface was already maximized, the compositor will still emit
        a configure event with the "maximized" state.
        If the surface is in a fullscreen state, this request has no direct
        effect. It may alter the state the surface is returned to when
        unmaximized unless overridden by the compositor.
        """

        ...

    @staticmethod
    def unset_maximized() -> None:
        """
        unmaximize the window
        Unmaximize the surface.
        After requesting that the surface should be unmaximized, the compositor
        will respond by emitting a configure event. Whether this actually
        un-maximizes the window is subject to compositor policies.
        If available and applicable, the compositor will include the window
        geometry dimensions the window had prior to being maximized in the
        configure event. The client must then update its content, drawing it in
        the configured state. The client must also acknowledge the configure
        when committing the new content (see ack_configure).
        It is up to the compositor to position the surface after it was
        unmaximized; usually the position the surface had before maximizing, if
        applicable.
        If the surface was already not maximized, the compositor will still
        emit a configure event without the "maximized" state.
        If the surface is in a fullscreen state, this request has no direct
        effect. It may alter the state the surface is returned to when
        unmaximized unless overridden by the compositor.
        """

        ...

    @staticmethod
    def set_fullscreen(output: object) -> None:
        """
        set the window as fullscreen on an output
        Make the surface fullscreen.
        After requesting that the surface should be fullscreened, the
        compositor will respond by emitting a configure event. Whether the
        client is actually put into a fullscreen state is subject to compositor
        policies. The client must also acknowledge the configure when
        committing the new content (see ack_configure).
        The output passed by the request indicates the client's preference as
        to which display it should be set fullscreen on. If this value is NULL,
        it's up to the compositor to choose which display will be used to map
        this surface.
        If the surface doesn't cover the whole output, the compositor will
        position the surface in the center of the output and compensate with
        with border fill covering the rest of the output. The content of the
        border fill is undefined, but should be assumed to be in some way that
        attempts to blend into the surrounding area (e.g. solid black).
        If the fullscreened surface is not opaque, the compositor must make
        sure that other screen content not part of the same surface tree (made
        up of subsurfaces, popups or similarly coupled surfaces) are not
        visible below the fullscreened surface.
        """

        ...

    @staticmethod
    def unset_fullscreen() -> None:
        """
        unset the window as fullscreen
        Make the surface no longer fullscreen.
        After requesting that the surface should be unfullscreened, the
        compositor will respond by emitting a configure event.
        Whether this actually removes the fullscreen state of the client is
        subject to compositor policies.
        Making a surface unfullscreen sets states for the surface based on the following:
        * the state(s) it may have had before becoming fullscreen
        * any state(s) decided by the compositor
        * any state(s) requested by the client while the surface was fullscreen
        The compositor may include the previous window geometry dimensions in
        the configure event, if applicable.
        The client must also acknowledge the configure when committing the new
        content (see ack_configure).
        """

        ...

    @staticmethod
    def set_minimized() -> None:
        """
        set the window as minimized
        Request that the compositor minimize your surface. There is no
        way to know if the surface is currently minimized, nor is there
        any way to unset minimization on this surface.
        If you are looking to throttle redrawing when minimized, please
        instead use the wl_surface.frame event for this, as this will
        also work with live previews on windows in Alt-Tab, Expose or
        similar compositor features.
        """

        ...
    class events:
        @staticmethod
        def configure(width: int, height: int, states: array) -> None:
            """
            suggest a surface change
            This configure event asks the client to resize its toplevel surface or
            to change its state. The configured state should not be applied
            immediately. See xdg_surface.configure for details.
            The width and height arguments specify a hint to the window
            about how its surface should be resized in window geometry
            coordinates. See set_window_geometry.
            If the width or height arguments are zero, it means the client
            should decide its own window dimension. This may happen when the
            compositor needs to configure the state of the surface but doesn't
            have any information about any previous or expected dimension.
            The states listed in the event specify how the width/height
            arguments should be interpreted, and possibly how it should be
            drawn.
            Clients must send an ack_configure in response to this event. See
            xdg_surface.configure and xdg_surface.ack_configure for details.
            """

            ...

        @staticmethod
        def close() -> None:
            """
            surface wants to be closed
            The close event is sent by the compositor when the user
            wants the surface to be closed. This should be equivalent to
            the user clicking the close button in client-side decorations,
            if your application has any.
            This is only a request that the user intends to close the
            window. The client may choose to ignore this request, or show
            a dialog to ask the user to save their data, etc.
            """

            ...

        @staticmethod
        def configure_bounds(width: int, height: int) -> None:
            """
            recommended window geometry bounds
            The configure_bounds event may be sent prior to a xdg_toplevel.configure
            event to communicate the bounds a window geometry size is recommended
            to constrain to.
            The passed width and height are in surface coordinate space. If width
            and height are 0, it means bounds is unknown and equivalent to as if no
            configure_bounds event was ever sent for this surface.
            The bounds can for example correspond to the size of a monitor excluding
            any panels or other shell components, so that a surface isn't created in
            a way that it cannot fit.
            The bounds may change at any point, and in such a case, a new
            xdg_toplevel.configure_bounds will be sent, followed by
            xdg_toplevel.configure and xdg_surface.configure.
            """

            ...

        @staticmethod
        def wm_capabilities(capabilities: array) -> None:
            """
            compositor capabilities
            This event advertises the capabilities supported by the compositor. If
            a capability isn't supported, clients should hide or disable the UI
            elements that expose this functionality. For instance, if the
            compositor doesn't advertise support for minimized toplevels, a button
            triggering the set_minimized request should not be displayed.
            The compositor will ignore requests it doesn't support. For instance,
            a compositor which doesn't advertise support for minimized will ignore
            set_minimized requests.
            Compositors must send this event once before the first
            xdg_surface.configure event. When the capabilities change, compositors
            must send this event again and then send an xdg_surface.configure
            event.
            The configured state should not be applied immediately. See
            xdg_surface.configure for details.
            The capabilities are sent as an array of 32-bit unsigned integers in
            native endianness.
            """

            ...
class xdg_popup:
    """
    short-lived, popup surfaces for menus
    A popup surface is a short-lived, temporary surface. It can be used to
    implement for example menus, popovers, tooltips and other similar user
    interface concepts.
    A popup can be made to take an explicit grab. See xdg_popup.grab for
    details.
    When the popup is dismissed, a popup_done event will be sent out, and at
    the same time the surface will be unmapped. See the xdg_popup.popup_done
    event for details.
    Explicitly destroying the xdg_popup object will also dismiss the popup and
    unmap the surface. Clients that want to dismiss the popup when another
    surface of their own is clicked should dismiss the popup using the destroy
    request.
    A newly created xdg_popup will be stacked on top of all previously created
    xdg_popup surfaces associated with the same xdg_toplevel.
    The parent of an xdg_popup must be mapped (see the xdg_surface
    description) before the xdg_popup itself.
    The client must call wl_surface.commit on the corresponding wl_surface
    for the xdg_popup state to take effect.
    """
    object_id = 0
    version = 6

    class error(Enum):
        invalid_grab: int

    @staticmethod
    def destroy() -> None:
        """
        remove xdg_popup interface
        This destroys the popup. Explicitly destroying the xdg_popup
        object will also dismiss the popup, and unmap the surface.
        If this xdg_popup is not the "topmost" popup, the
        xdg_wm_base.not_the_topmost_popup protocol error will be sent.
        """

        ...

    @staticmethod
    def grab(seat: object, serial: uint) -> None:
        """
        make the popup take an explicit grab
        This request makes the created popup take an explicit grab. An explicit
        grab will be dismissed when the user dismisses the popup, or when the
        client destroys the xdg_popup. This can be done by the user clicking
        outside the surface, using the keyboard, or even locking the screen
        through closing the lid or a timeout.
        If the compositor denies the grab, the popup will be immediately
        dismissed.
        This request must be used in response to some sort of user action like a
        button press, key press, or touch down event. The serial number of the
        event should be passed as 'serial'.
        The parent of a grabbing popup must either be an xdg_toplevel surface or
        another xdg_popup with an explicit grab. If the parent is another
        xdg_popup it means that the popups are nested, with this popup now being
        the topmost popup.
        Nested popups must be destroyed in the reverse order they were created
        in, e.g. the only popup you are allowed to destroy at all times is the
        topmost one.
        When compositors choose to dismiss a popup, they may dismiss every
        nested grabbing popup as well. When a compositor dismisses popups, it
        will follow the same dismissing order as required from the client.
        If the topmost grabbing popup is destroyed, the grab will be returned to
        the parent of the popup, if that parent previously had an explicit grab.
        If the parent is a grabbing popup which has already been dismissed, this
        popup will be immediately dismissed. If the parent is a popup that did
        not take an explicit grab, an error will be raised.
        During a popup grab, the client owning the grab will receive pointer
        and touch events for all their surfaces as normal (similar to an
        "owner-events" grab in X11 parlance), while the top most grabbing popup
        will always have keyboard focus.
        """

        ...

    @staticmethod
    def reposition(positioner: object, token: uint) -> None:
        """
        recalculate the popup's location
        Reposition an already-mapped popup. The popup will be placed given the
        details in the passed xdg_positioner object, and a
        xdg_popup.repositioned followed by xdg_popup.configure and
        xdg_surface.configure will be emitted in response. Any parameters set
        by the previous positioner will be discarded.
        The passed token will be sent in the corresponding
        xdg_popup.repositioned event. The new popup position will not take
        effect until the corresponding configure event is acknowledged by the
        client. See xdg_popup.repositioned for details. The token itself is
        opaque, and has no other special meaning.
        If multiple reposition requests are sent, the compositor may skip all
        but the last one.
        If the popup is repositioned in response to a configure event for its
        parent, the client should send an xdg_positioner.set_parent_configure
        and possibly an xdg_positioner.set_parent_size request to allow the
        compositor to properly constrain the popup.
        If the popup is repositioned together with a parent that is being
        resized, but not in response to a configure event, the client should
        send an xdg_positioner.set_parent_size request.
        """

        ...
    class events:
        @staticmethod
        def configure(x: int, y: int, width: int, height: int) -> None:
            """
            configure the popup surface
            This event asks the popup surface to configure itself given the
            configuration. The configured state should not be applied immediately.
            See xdg_surface.configure for details.
            The x and y arguments represent the position the popup was placed at
            given the xdg_positioner rule, relative to the upper left corner of the
            window geometry of the parent surface.
            For version 2 or older, the configure event for an xdg_popup is only
            ever sent once for the initial configuration. Starting with version 3,
            it may be sent again if the popup is setup with an xdg_positioner with
            set_reactive requested, or in response to xdg_popup.reposition requests.
            """

            ...

        @staticmethod
        def popup_done() -> None:
            """
            popup interaction is done
            The popup_done event is sent out when a popup is dismissed by the
            compositor. The client should destroy the xdg_popup object at this
            point.
            """

            ...

        @staticmethod
        def repositioned(token: uint) -> None:
            """
            signal the completion of a repositioned request
            The repositioned event is sent as part of a popup configuration
            sequence, together with xdg_popup.configure and lastly
            xdg_surface.configure to notify the completion of a reposition request.
            The repositioned event is to notify about the completion of a
            xdg_popup.reposition request. The token argument is the token passed
            in the xdg_popup.reposition request.
            Immediately after this event is emitted, xdg_popup.configure and
            xdg_surface.configure will be sent with the updated size and position,
            as well as a new configure serial.
            The client should optionally update the content of the popup, but must
            acknowledge the new popup configuration for the new position to take
            effect. See xdg_surface.ack_configure for details.
            """

            ...
class zwp_pointer_constraints_v1:
    """
    constrain the movement of a pointer
    The global interface exposing pointer constraining functionality. It
    exposes two requests: lock_pointer for locking the pointer to its
    position, and confine_pointer for locking the pointer to a region.
    The lock_pointer and confine_pointer requests create the objects
    wp_locked_pointer and wp_confined_pointer respectively, and the client can
    use these objects to interact with the lock.
    For any surface, only one lock or confinement may be active across all
    wl_pointer objects of the same seat. If a lock or confinement is requested
    when another lock or confinement is active or requested on the same surface
    and with any of the wl_pointer objects of the same seat, an
    'already_constrained' error will be raised.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_constrained: int


    class lifetime(Enum):
        oneshot: int
        persistent: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the pointer constraints manager object
        Used by the client to notify the server that it will no longer use this
        pointer constraints object.
        """

        ...

    @staticmethod
    def lock_pointer(surface: object, pointer: object, region: object, lifetime: zwp_pointer_constraints_v1.lifetime) -> zwp_locked_pointer_v1:
        """
        lock pointer to a position
        The lock_pointer request lets the client request to disable movements of
        the virtual pointer (i.e. the cursor), effectively locking the pointer
        to a position. This request may not take effect immediately; in the
        future, when the compositor deems implementation-specific constraints
        are satisfied, the pointer lock will be activated and the compositor
        sends a locked event.
        The protocol provides no guarantee that the constraints are ever
        satisfied, and does not require the compositor to send an error if the
        constraints cannot ever be satisfied. It is thus possible to request a
        lock that will never activate.
        There may not be another pointer constraint of any kind requested or
        active on the surface for any of the wl_pointer objects of the seat of
        the passed pointer when requesting a lock. If there is, an error will be
        raised. See general pointer lock documentation for more details.
        The intersection of the region passed with this request and the input
        region of the surface is used to determine where the pointer must be
        in order for the lock to activate. It is up to the compositor whether to
        warp the pointer or require some kind of user interaction for the lock
        to activate. If the region is null the surface input region is used.
        A surface may receive pointer focus without the lock being activated.
        The request creates a new object wp_locked_pointer which is used to
        interact with the lock as well as receive updates about its state. See
        the the description of wp_locked_pointer for further information.
        Note that while a pointer is locked, the wl_pointer objects of the
        corresponding seat will not emit any wl_pointer.motion events, but
        relative motion events will still be emitted via wp_relative_pointer
        objects of the same seat. wl_pointer.axis and wl_pointer.button events
        are unaffected.
        """

        ...

    @staticmethod
    def confine_pointer(surface: object, pointer: object, region: object, lifetime: zwp_pointer_constraints_v1.lifetime) -> zwp_confined_pointer_v1:
        """
        confine pointer to a region
        The confine_pointer request lets the client request to confine the
        pointer cursor to a given region. This request may not take effect
        immediately; in the future, when the compositor deems implementation-
        specific constraints are satisfied, the pointer confinement will be
        activated and the compositor sends a confined event.
        The intersection of the region passed with this request and the input
        region of the surface is used to determine where the pointer must be
        in order for the confinement to activate. It is up to the compositor
        whether to warp the pointer or require some kind of user interaction for
        the confinement to activate. If the region is null the surface input
        region is used.
        The request will create a new object wp_confined_pointer which is used
        to interact with the confinement as well as receive updates about its
        state. See the the description of wp_confined_pointer for further
        information.
        """

        ...
class zwp_locked_pointer_v1:
    """
    receive relative pointer motion events
    The wp_locked_pointer interface represents a locked pointer state.
    While the lock of this object is active, the wl_pointer objects of the
    associated seat will not emit any wl_pointer.motion events.
    This object will send the event 'locked' when the lock is activated.
    Whenever the lock is activated, it is guaranteed that the locked surface
    will already have received pointer focus and that the pointer will be
    within the region passed to the request creating this object.
    To unlock the pointer, send the destroy request. This will also destroy
    the wp_locked_pointer object.
    If the compositor decides to unlock the pointer the unlocked event is
    sent. See wp_locked_pointer.unlock for details.
    When unlocking, the compositor may warp the cursor position to the set
    cursor position hint. If it does, it will not result in any relative
    motion events emitted via wp_relative_pointer.
    If the surface the lock was requested on is destroyed and the lock is not
    yet activated, the wp_locked_pointer object is now defunct and must be
    destroyed.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the locked pointer object
        Destroy the locked pointer object. If applicable, the compositor will
        unlock the pointer.
        """

        ...

    @staticmethod
    def set_cursor_position_hint(surface_x: fixed, surface_y: fixed) -> None:
        """
        set the pointer cursor position hint
        Set the cursor position hint relative to the top left corner of the
        surface.
        If the client is drawing its own cursor, it should update the position
        hint to the position of its own cursor. A compositor may use this
        information to warp the pointer upon unlock in order to avoid pointer
        jumps.
        The cursor position hint is double-buffered state, see
        wl_surface.commit.
        """

        ...

    @staticmethod
    def set_region(region: object) -> None:
        """
        set a new lock region
        Set a new region used to lock the pointer.
        The new lock region is double-buffered, see wl_surface.commit.
        For details about the lock region, see wp_locked_pointer.
        """

        ...
    class events:
        @staticmethod
        def locked() -> None:
            """
            lock activation event
            Notification that the pointer lock of the seat's pointer is activated.
            """

            ...

        @staticmethod
        def unlocked() -> None:
            """
            lock deactivation event
            Notification that the pointer lock of the seat's pointer is no longer
            active. If this is a oneshot pointer lock (see
            wp_pointer_constraints.lifetime) this object is now defunct and should
            be destroyed. If this is a persistent pointer lock (see
            wp_pointer_constraints.lifetime) this pointer lock may again
            reactivate in the future.
            """

            ...
class zwp_confined_pointer_v1:
    """
    confined pointer object
    The wp_confined_pointer interface represents a confined pointer state.
    This object will send the event 'confined' when the confinement is
    activated. Whenever the confinement is activated, it is guaranteed that
    the surface the pointer is confined to will already have received pointer
    focus and that the pointer will be within the region passed to the request
    creating this object. It is up to the compositor to decide whether this
    requires some user interaction and if the pointer will warp to within the
    passed region if outside.
    To unconfine the pointer, send the destroy request. This will also destroy
    the wp_confined_pointer object.
    If the compositor decides to unconfine the pointer the unconfined event is
    sent. The wp_confined_pointer object is at this point defunct and should
    be destroyed.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the confined pointer object
        Destroy the confined pointer object. If applicable, the compositor will
        unconfine the pointer.
        """

        ...

    @staticmethod
    def set_region(region: object) -> None:
        """
        set a new confine region
        Set a new region used to confine the pointer.
        The new confine region is double-buffered, see wl_surface.commit.
        If the confinement is active when the new confinement region is applied
        and the pointer ends up outside of newly applied region, the pointer may
        warped to a position within the new confinement region. If warped, a
        wl_pointer.motion event will be emitted, but no
        wp_relative_pointer.relative_motion event.
        The compositor may also, instead of using the new region, unconfine the
        pointer.
        For details about the confine region, see wp_confined_pointer.
        """

        ...
    class events:
        @staticmethod
        def confined() -> None:
            """
            pointer confined
            Notification that the pointer confinement of the seat's pointer is
            activated.
            """

            ...

        @staticmethod
        def unconfined() -> None:
            """
            pointer unconfined
            Notification that the pointer confinement of the seat's pointer is no
            longer active. If this is a oneshot pointer confinement (see
            wp_pointer_constraints.lifetime) this object is now defunct and should
            be destroyed. If this is a persistent pointer confinement (see
            wp_pointer_constraints.lifetime) this pointer confinement may again
            reactivate in the future.
            """

            ...
class zxdg_exporter_v2:
    """
    interface for exporting surfaces
    A global interface used for exporting surfaces that can later be imported
    using xdg_importer.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_surface: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_exporter object
        Notify the compositor that the xdg_exporter object will no longer be
        used.
        """

        ...

    @staticmethod
    def export_toplevel(surface: object) -> zxdg_exported_v2:
        """
        export a toplevel surface
        The export_toplevel request exports the passed surface so that it can later be
        imported via xdg_importer. When called, a new xdg_exported object will
        be created and xdg_exported.handle will be sent immediately. See the
        corresponding interface and event for details.
        A surface may be exported multiple times, and each exported handle may
        be used to create an xdg_imported multiple times. Only xdg_toplevel
        equivalent surfaces may be exported, otherwise an invalid_surface
        protocol error is sent.
        """

        ...
class zxdg_importer_v2:
    """
    interface for importing surfaces
    A global interface used for importing surfaces exported by xdg_exporter.
    With this interface, a client can create a reference to a surface of
    another client.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_importer object
        Notify the compositor that the xdg_importer object will no longer be
        used.
        """

        ...

    @staticmethod
    def import_toplevel(handle: string) -> zxdg_imported_v2:
        """
        import a toplevel surface
        The import_toplevel request imports a surface from any client given a handle
        retrieved by exporting said surface using xdg_exporter.export_toplevel.
        When called, a new xdg_imported object will be created. This new object
        represents the imported surface, and the importing client can
        manipulate its relationship using it. See xdg_imported for details.
        """

        ...
class zxdg_exported_v2:
    """
    an exported surface handle
    An xdg_exported object represents an exported reference to a surface. The
    exported surface may be referenced as long as the xdg_exported object not
    destroyed. Destroying the xdg_exported invalidates any relationship the
    importer may have established using xdg_imported.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        unexport the exported surface
        Revoke the previously exported surface. This invalidates any
        relationship the importer may have set up using the xdg_imported created
        given the handle sent via xdg_exported.handle.
        """

        ...
    class events:
        @staticmethod
        def handle(handle: string) -> None:
            """
            the exported surface handle
            The handle event contains the unique handle of this exported surface
            reference. It may be shared with any client, which then can use it to
            import the surface by calling xdg_importer.import_toplevel. A handle
            may be used to import the surface multiple times.
            """

            ...
class zxdg_imported_v2:
    """
    an imported surface handle
    An xdg_imported object represents an imported reference to surface exported
    by some client. A client can use this interface to manipulate
    relationships between its own surfaces and the imported surface.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_surface: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_imported object
        Notify the compositor that it will no longer use the xdg_imported
        object. Any relationship that may have been set up will at this point
        be invalidated.
        """

        ...

    @staticmethod
    def set_parent_of(surface: object) -> None:
        """
        set as the parent of some surface
        Set the imported surface as the parent of some surface of the client.
        The passed surface must be an xdg_toplevel equivalent, otherwise an
        invalid_surface protocol error is sent. Calling this function sets up
        a surface to surface relation with the same stacking and positioning
        semantics as xdg_toplevel.set_parent.
        """

        ...
    class events:
        @staticmethod
        def destroyed() -> None:
            """
            the imported surface handle has been destroyed
            The imported surface handle has been destroyed and any relationship set
            up has been invalidated. This may happen for various reasons, for
            example if the exported surface or the exported surface handle has been
            destroyed, if the handle used for importing was invalid.
            """

            ...
class zxdg_exporter_v1:
    """
    interface for exporting surfaces
    A global interface used for exporting surfaces that can later be imported
    using xdg_importer.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_exporter object
        Notify the compositor that the xdg_exporter object will no longer be
        used.
        """

        ...

    @staticmethod
    def export(surface: object) -> zxdg_exported_v1:
        """
        export a surface
        The export request exports the passed surface so that it can later be
        imported via xdg_importer. When called, a new xdg_exported object will
        be created and xdg_exported.handle will be sent immediately. See the
        corresponding interface and event for details.
        A surface may be exported multiple times, and each exported handle may
        be used to create an xdg_imported multiple times. Only xdg_surface
        surfaces may be exported.
        """

        ...
class zxdg_importer_v1:
    """
    interface for importing surfaces
    A global interface used for importing surfaces exported by xdg_exporter.
    With this interface, a client can create a reference to a surface of
    another client.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_importer object
        Notify the compositor that the xdg_importer object will no longer be
        used.
        """

        ...

    @staticmethod
    def import_(handle: string) -> zxdg_imported_v1:
        """
        import a surface
        The import request imports a surface from any client given a handle
        retrieved by exporting said surface using xdg_exporter.export. When
        called, a new xdg_imported object will be created. This new object
        represents the imported surface, and the importing client can
        manipulate its relationship using it. See xdg_imported for details.
        """

        ...
class zxdg_exported_v1:
    """
    an exported surface handle
    An xdg_exported object represents an exported reference to a surface. The
    exported surface may be referenced as long as the xdg_exported object not
    destroyed. Destroying the xdg_exported invalidates any relationship the
    importer may have established using xdg_imported.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        unexport the exported surface
        Revoke the previously exported surface. This invalidates any
        relationship the importer may have set up using the xdg_imported created
        given the handle sent via xdg_exported.handle.
        """

        ...
    class events:
        @staticmethod
        def handle(handle: string) -> None:
            """
            the exported surface handle
            The handle event contains the unique handle of this exported surface
            reference. It may be shared with any client, which then can use it to
            import the surface by calling xdg_importer.import. A handle may be
            used to import the surface multiple times.
            """

            ...
class zxdg_imported_v1:
    """
    an imported surface handle
    An xdg_imported object represents an imported reference to surface exported
    by some client. A client can use this interface to manipulate
    relationships between its own surfaces and the imported surface.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_imported object
        Notify the compositor that it will no longer use the xdg_imported
        object. Any relationship that may have been set up will at this point
        be invalidated.
        """

        ...

    @staticmethod
    def set_parent_of(surface: object) -> None:
        """
        set as the parent of some surface
        Set the imported surface as the parent of some surface of the client.
        The passed surface must be a toplevel xdg_surface. Calling this function
        sets up a surface to surface relation with the same stacking and positioning
        semantics as xdg_surface.set_parent.
        """

        ...
    class events:
        @staticmethod
        def destroyed() -> None:
            """
            the imported surface handle has been destroyed
            The imported surface handle has been destroyed and any relationship set
            up has been invalidated. This may happen for various reasons, for
            example if the exported surface or the exported surface handle has been
            destroyed, if the handle used for importing was invalid.
            """

            ...
class zwp_primary_selection_device_manager_v1:
    """
    X primary selection emulation
    The primary selection device manager is a singleton global object that
    provides access to the primary selection. It allows to create
    wp_primary_selection_source objects, as well as retrieving the per-seat
    wp_primary_selection_device objects.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_source() -> zwp_primary_selection_source_v1:
        """
        create a new primary selection source
        Create a new primary selection source.
        """

        ...

    @staticmethod
    def get_device(seat: object) -> zwp_primary_selection_device_v1:
        """
        create a new primary selection device
        Create a new data device for a given seat.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the primary selection device manager
        Destroy the primary selection device manager.
        """

        ...
class zwp_primary_selection_device_v1:
    """

    """
    object_id = 0
    version = 1

    @staticmethod
    def set_selection(source: object, serial: uint) -> None:
        """
        set the primary selection
        Replaces the current selection. The previous owner of the primary
        selection will receive a wp_primary_selection_source.cancelled event.
        To unset the selection, set the source to NULL.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the primary selection device
        Destroy the primary selection device.
        """

        ...
    class events:
        @staticmethod
        def data_offer(offer: zwp_primary_selection_offer_v1) -> None:
            """
            introduce a new wp_primary_selection_offer
            Introduces a new wp_primary_selection_offer object that may be used
            to receive the current primary selection. Immediately following this
            event, the new wp_primary_selection_offer object will send
            wp_primary_selection_offer.offer events to describe the offered mime
            types.
            """

            ...

        @staticmethod
        def selection(id: object) -> None:
            """
            advertise a new primary selection
            The wp_primary_selection_device.selection event is sent to notify the
            client of a new primary selection. This event is sent after the
            wp_primary_selection.data_offer event introducing this object, and after
            the offer has announced its mimetypes through
            wp_primary_selection_offer.offer.
            The data_offer is valid until a new offer or NULL is received
            or until the client loses keyboard focus. The client must destroy the
            previous selection data_offer, if any, upon receiving this event.
            """

            ...
class zwp_primary_selection_offer_v1:
    """
    offer to transfer primary selection contents
    A wp_primary_selection_offer represents an offer to transfer the contents
    of the primary selection clipboard to the client. Similar to
    wl_data_offer, the offer also describes the mime types that the data can
    be converted to and provides the mechanisms for transferring the data
    directly to the client.
    """
    object_id = 0
    version = 1

    @staticmethod
    def receive(mime_type: string, fd: fd) -> None:
        """
        request that the data is transferred
        To transfer the contents of the primary selection clipboard, the client
        issues this request and indicates the mime type that it wants to
        receive. The transfer happens through the passed file descriptor
        (typically created with the pipe system call). The source client writes
        the data in the mime type representation requested and then closes the
        file descriptor.
        The receiving client reads from the read end of the pipe until EOF and
        closes its end, at which point the transfer is complete.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the primary selection offer
        Destroy the primary selection offer.
        """

        ...
    class events:
        @staticmethod
        def offer(mime_type: string) -> None:
            """
            advertise offered mime type
            Sent immediately after creating announcing the
            wp_primary_selection_offer through
            wp_primary_selection_device.data_offer. One event is sent per offered
            mime type.
            """

            ...
class zwp_primary_selection_source_v1:
    """
    offer to replace the contents of the primary selection
    The source side of a wp_primary_selection_offer, it provides a way to
    describe the offered data and respond to requests to transfer the
    requested contents of the primary selection clipboard.
    """
    object_id = 0
    version = 1

    @staticmethod
    def offer(mime_type: string) -> None:
        """
        add an offered mime type
        This request adds a mime type to the set of mime types advertised to
        targets. Can be called several times to offer multiple types.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the primary selection source
        Destroy the primary selection source.
        """

        ...
    class events:
        @staticmethod
        def send(mime_type: string, fd: fd) -> None:
            """
            send the primary selection contents
            Request for the current primary selection contents from the client.
            Send the specified mime type over the passed file descriptor, then
            close it.
            """

            ...

        @staticmethod
        def cancelled() -> None:
            """
            request for primary selection contents was canceled
            This primary selection source is no longer valid. The client should
            clean up and destroy this primary selection source.
            """

            ...
class zwp_relative_pointer_manager_v1:
    """
    get relative pointer objects
    A global interface used for getting the relative pointer object for a
    given pointer.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the relative pointer manager object
        Used by the client to notify the server that it will no longer use this
        relative pointer manager object.
        """

        ...

    @staticmethod
    def get_relative_pointer(pointer: object) -> zwp_relative_pointer_v1:
        """
        get a relative pointer object
        Create a relative pointer interface given a wl_pointer object. See the
        wp_relative_pointer interface for more details.
        """

        ...
class zwp_relative_pointer_v1:
    """
    relative pointer object
    A wp_relative_pointer object is an extension to the wl_pointer interface
    used for emitting relative pointer events. It shares the same focus as
    wl_pointer objects of the same seat and will only emit events when it has
    focus.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        release the relative pointer object
        """

        ...
    class events:
        @staticmethod
        def relative_motion(utime_hi: uint, utime_lo: uint, dx: fixed, dy: fixed, dx_unaccel: fixed, dy_unaccel: fixed) -> None:
            """
            relative pointer motion
            Relative x/y pointer motion from the pointer of the seat associated with
            this object.
            A relative motion is in the same dimension as regular wl_pointer motion
            events, except they do not represent an absolute position. For example,
            moving a pointer from (x, y) to (x', y') would have the equivalent
            relative motion (x' - x, y' - y). If a pointer motion caused the
            absolute pointer position to be clipped by for example the edge of the
            monitor, the relative motion is unaffected by the clipping and will
            represent the unclipped motion.
            This event also contains non-accelerated motion deltas. The
            non-accelerated delta is, when applicable, the regular pointer motion
            delta as it was before having applied motion acceleration and other
            transformations such as normalization.
            Note that the non-accelerated delta does not represent 'raw' events as
            they were read from some device. Pointer motion acceleration is device-
            and configuration-specific and non-accelerated deltas and accelerated
            deltas may have the same value on some devices.
            Relative motions are not coupled to wl_pointer.motion events, and can be
            sent in combination with such events, but also independently. There may
            also be scenarios where wl_pointer.motion is sent, but there is no
            relative motion. The order of an absolute and relative motion event
            originating from the same physical motion is not guaranteed.
            If the client needs button events or focus state, it can receive them
            from a wl_pointer object of the same seat that the wp_relative_pointer
            object is associated with.
            """

            ...
class zxdg_output_manager_v1:
    """
    manage xdg_output objects
    A global factory interface for xdg_output objects.
    """
    object_id = 0
    version = 3

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_output_manager object
        Using this request a client can tell the server that it is not
        going to use the xdg_output_manager object anymore.
        Any objects already created through this instance are not affected.
        """

        ...

    @staticmethod
    def get_xdg_output(output: object) -> zxdg_output_v1:
        """
        create an xdg output from a wl_output
        This creates a new xdg_output object for the given wl_output.
        """

        ...
class zxdg_output_v1:
    """
    compositor logical output region
    An xdg_output describes part of the compositor geometry.
    This typically corresponds to a monitor that displays part of the
    compositor space.
    For objects version 3 onwards, after all xdg_output properties have been
    sent (when the object is created and when properties are updated), a
    wl_output.done event is sent. This allows changes to the output
    properties to be seen as atomic, even if they happen via multiple events.
    """
    object_id = 0
    version = 3

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_output object
        Using this request a client can tell the server that it is not
        going to use the xdg_output object anymore.
        """

        ...
    class events:
        @staticmethod
        def logical_position(x: int, y: int) -> None:
            """
            position of the output within the global compositor space
            The position event describes the location of the wl_output within
            the global compositor space.
            The logical_position event is sent after creating an xdg_output
            (see xdg_output_manager.get_xdg_output) and whenever the location
            of the output changes within the global compositor space.
            """

            ...

        @staticmethod
        def logical_size(width: int, height: int) -> None:
            """
            size of the output in the global compositor space
            The logical_size event describes the size of the output in the
            global compositor space.
            Most regular Wayland clients should not pay attention to the
            logical size and would rather rely on xdg_shell interfaces.
            Some clients such as Xwayland, however, need this to configure
            their surfaces in the global compositor space as the compositor
            may apply a different scale from what is advertised by the output
            scaling property (to achieve fractional scaling, for example).
            For example, for a wl_output mode 3840×2160 and a scale factor 2:
            - A compositor not scaling the monitor viewport in its compositing space
            will advertise a logical size of 3840×2160,
            - A compositor scaling the monitor viewport with scale factor 2 will
            advertise a logical size of 1920×1080,
            - A compositor scaling the monitor viewport using a fractional scale of
            1.5 will advertise a logical size of 2560×1440.
            For example, for a wl_output mode 1920×1080 and a 90 degree rotation,
            the compositor will advertise a logical size of 1080x1920.
            The logical_size event is sent after creating an xdg_output
            (see xdg_output_manager.get_xdg_output) and whenever the logical
            size of the output changes, either as a result of a change in the
            applied scale or because of a change in the corresponding output
            mode(see wl_output.mode) or transform (see wl_output.transform).
            """

            ...

        @staticmethod
        def done() -> None:
            """
            all information about the output have been sent
            This event is sent after all other properties of an xdg_output
            have been sent.
            This allows changes to the xdg_output properties to be seen as
            atomic, even if they happen via multiple events.
            For objects version 3 onwards, this event is deprecated. Compositors
            are not required to send it anymore and must send wl_output.done
            instead.
            """

            ...

        @staticmethod
        def name(name: string) -> None:
            """
            name of this output
            Many compositors will assign names to their outputs, show them to the
            user, allow them to be configured by name, etc. The client may wish to
            know this name as well to offer the user similar behaviors.
            The naming convention is compositor defined, but limited to
            alphanumeric characters and dashes (-). Each name is unique among all
            wl_output globals, but if a wl_output global is destroyed the same name
            may be reused later. The names will also remain consistent across
            sessions with the same hardware and software configuration.
            Examples of names include 'HDMI-A-1', 'WL-1', 'X11-1', etc. However, do
            not assume that the name is a reflection of an underlying DRM
            connector, X11 connection, etc.
            The name event is sent after creating an xdg_output (see
            xdg_output_manager.get_xdg_output). This event is only sent once per
            xdg_output, and the name does not change over the lifetime of the
            wl_output global.
            This event is deprecated, instead clients should use wl_output.name.
            Compositors must still support this event.
            """

            ...

        @staticmethod
        def description(description: string) -> None:
            """
            human-readable description of this output
            Many compositors can produce human-readable descriptions of their
            outputs.  The client may wish to know this description as well, to
            communicate the user for various purposes.
            The description is a UTF-8 string with no convention defined for its
            contents. Examples might include 'Foocorp 11" Display' or 'Virtual X11
            output via :1'.
            The description event is sent after creating an xdg_output (see
            xdg_output_manager.get_xdg_output) and whenever the description
            changes. The description is optional, and may not be sent at all.
            For objects of version 2 and lower, this event is only sent once per
            xdg_output, and the description does not change over the lifetime of
            the wl_output global.
            This event is deprecated, instead clients should use
            wl_output.description. Compositors must still support this event.
            """

            ...
class zxdg_decoration_manager_v1:
    """
    window decoration manager
    This interface allows a compositor to announce support for server-side
    decorations.
    A window decoration is a set of window controls as deemed appropriate by
    the party managing them, such as user interface components used to move,
    resize and change a window's state.
    A client can use this protocol to request being decorated by a supporting
    compositor.
    If compositor and client do not negotiate the use of a server-side
    decoration using this protocol, clients continue to self-decorate as they
    see fit.
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the decoration manager object
        Destroy the decoration manager. This doesn't destroy objects created
        with the manager.
        """

        ...

    @staticmethod
    def get_toplevel_decoration(toplevel: object) -> zxdg_toplevel_decoration_v1:
        """
        create a new toplevel decoration object
        Create a new decoration object associated with the given toplevel.
        Creating an xdg_toplevel_decoration from an xdg_toplevel which has a
        buffer attached or committed is a client error, and any attempts by a
        client to attach or manipulate a buffer prior to the first
        xdg_toplevel_decoration.configure event must also be treated as
        errors.
        """

        ...
class zxdg_toplevel_decoration_v1:
    """
    decoration object for a toplevel surface
    The decoration object allows the compositor to toggle server-side window
    decorations for a toplevel surface. The client can request to switch to
    another mode.
    The xdg_toplevel_decoration object must be destroyed before its
    xdg_toplevel.
    """
    object_id = 0
    version = 1

    class error(Enum):
        unconfigured_buffer: int
        already_constructed: int
        orphaned: int
        invalid_mode: int


    class mode(Enum):
        client_side: int
        server_side: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the decoration object
        Switch back to a mode without any server-side decorations at the next
        commit.
        """

        ...

    @staticmethod
    def set_mode(mode: zxdg_toplevel_decoration_v1.mode) -> None:
        """
        set the decoration mode
        Set the toplevel surface decoration mode. This informs the compositor
        that the client prefers the provided decoration mode.
        After requesting a decoration mode, the compositor will respond by
        emitting an xdg_surface.configure event. The client should then update
        its content, drawing it without decorations if the received mode is
        server-side decorations. The client must also acknowledge the configure
        when committing the new content (see xdg_surface.ack_configure).
        The compositor can decide not to use the client's mode and enforce a
        different mode instead.
        Clients whose decoration mode depend on the xdg_toplevel state may send
        a set_mode request in response to an xdg_surface.configure event and wait
        for the next xdg_surface.configure event to prevent unwanted state.
        Such clients are responsible for preventing configure loops and must
        make sure not to send multiple successive set_mode requests with the
        same decoration mode.
        If an invalid mode is supplied by the client, the invalid_mode protocol
        error is raised by the compositor.
        """

        ...

    @staticmethod
    def unset_mode() -> None:
        """
        unset the decoration mode
        Unset the toplevel surface decoration mode. This informs the compositor
        that the client doesn't prefer a particular decoration mode.
        This request has the same semantics as set_mode.
        """

        ...
    class events:
        @staticmethod
        def configure(mode: zxdg_toplevel_decoration_v1.mode) -> None:
            """
            notify a decoration mode change
            The configure event configures the effective decoration mode. The
            configured state should not be applied immediately. Clients must send an
            ack_configure in response to this event. See xdg_surface.configure and
            xdg_surface.ack_configure for details.
            A configure event can be sent at any time. The specified mode must be
            obeyed by the client.
            """

            ...
class zwp_fullscreen_shell_v1:
    """
    displays a single surface per output
    Displays a single surface per output.
    This interface provides a mechanism for a single client to display
    simple full-screen surfaces.  While there technically may be multiple
    clients bound to this interface, only one of those clients should be
    shown at a time.
    To present a surface, the client uses either the present_surface or
    present_surface_for_mode requests.  Presenting a surface takes effect
    on the next wl_surface.commit.  See the individual requests for
    details about scaling and mode switches.
    The client can have at most one surface per output at any time.
    Requesting a surface to be presented on an output that already has a
    surface replaces the previously presented surface.  Presenting a null
    surface removes its content and effectively disables the output.
    Exactly what happens when an output is "disabled" is
    compositor-specific.  The same surface may be presented on multiple
    outputs simultaneously.
    Once a surface is presented on an output, it stays on that output
    until either the client removes it or the compositor destroys the
    output.  This way, the client can update the output's contents by
    simply attaching a new buffer.
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 1

    class capability(Enum):
        arbitrary_modes: int
        cursor_plane: int


    class present_method(Enum):
        default: int
        center: int
        zoom: int
        zoom_crop: int
        stretch: int


    class error(Enum):
        invalid_method: int
        role: int

    @staticmethod
    def release() -> None:
        """
        release the wl_fullscreen_shell interface
        Release the binding from the wl_fullscreen_shell interface.
        This destroys the server-side object and frees this binding.  If
        the client binds to wl_fullscreen_shell multiple times, it may wish
        to free some of those bindings.
        """

        ...

    @staticmethod
    def present_surface(surface: object, method: zwp_fullscreen_shell_v1.present_method, output: object) -> None:
        """
        present surface for display
        Present a surface on the given output.
        If the output is null, the compositor will present the surface on
        whatever display (or displays) it thinks best.  In particular, this
        may replace any or all surfaces currently presented so it should
        not be used in combination with placing surfaces on specific
        outputs.
        The method parameter is a hint to the compositor for how the surface
        is to be presented.  In particular, it tells the compositor how to
        handle a size mismatch between the presented surface and the
        output.  The compositor is free to ignore this parameter.
        The "zoom", "zoom_crop", and "stretch" methods imply a scaling
        operation on the surface.  This will override any kind of output
        scaling, so the buffer_scale property of the surface is effectively
        ignored.
        This request gives the surface the role of a fullscreen shell surface.
        If the surface already has another role, it raises a role protocol
        error.
        """

        ...

    @staticmethod
    def present_surface_for_mode(surface: object, output: object, framerate: int) -> zwp_fullscreen_shell_mode_feedback_v1:
        """
        present surface for display at a particular mode
        Presents a surface on the given output for a particular mode.
        If the current size of the output differs from that of the surface,
        the compositor will attempt to change the size of the output to
        match the surface.  The result of the mode-switch operation will be
        returned via the provided wl_fullscreen_shell_mode_feedback object.
        If the current output mode matches the one requested or if the
        compositor successfully switches the mode to match the surface,
        then the mode_successful event will be sent and the output will
        contain the contents of the given surface.  If the compositor
        cannot match the output size to the surface size, the mode_failed
        will be sent and the output will contain the contents of the
        previously presented surface (if any).  If another surface is
        presented on the given output before either of these has a chance
        to happen, the present_cancelled event will be sent.
        Due to race conditions and other issues unknown to the client, no
        mode-switch operation is guaranteed to succeed.  However, if the
        mode is one advertised by wl_output.mode or if the compositor
        advertises the ARBITRARY_MODES capability, then the client should
        expect that the mode-switch operation will usually succeed.
        If the size of the presented surface changes, the resulting output
        is undefined.  The compositor may attempt to change the output mode
        to compensate.  However, there is no guarantee that a suitable mode
        will be found and the client has no way to be notified of success
        or failure.
        The framerate parameter specifies the desired framerate for the
        output in mHz.  The compositor is free to ignore this parameter.  A
        value of 0 indicates that the client has no preference.
        If the value of wl_output.scale differs from wl_surface.buffer_scale,
        then the compositor may choose a mode that matches either the buffer
        size or the surface size.  In either case, the surface will fill the
        output.
        This request gives the surface the role of a fullscreen shell surface.
        If the surface already has another role, it raises a role protocol
        error.
        """

        ...
    class events:
        @staticmethod
        def capability(capability: zwp_fullscreen_shell_v1.capability) -> None:
            """
            advertises a capability of the compositor
            Advertises a single capability of the compositor.
            When the wl_fullscreen_shell interface is bound, this event is emitted
            once for each capability advertised.  Valid capabilities are given by
            the wl_fullscreen_shell.capability enum.  If clients want to take
            advantage of any of these capabilities, they should use a
            wl_display.sync request immediately after binding to ensure that they
            receive all the capability events.
            """

            ...
class zwp_fullscreen_shell_mode_feedback_v1:
    """

    """
    object_id = 0
    version = 1

    class events:
        @staticmethod
        def mode_successful() -> None:
            """
            mode switch succeeded
            This event indicates that the attempted mode switch operation was
            successful.  A surface of the size requested in the mode switch
            will fill the output without scaling.
            Upon receiving this event, the client should destroy the
            wl_fullscreen_shell_mode_feedback object.
            """

            ...

        @staticmethod
        def mode_failed() -> None:
            """
            mode switch failed
            This event indicates that the attempted mode switch operation
            failed.  This may be because the requested output mode is not
            possible or it may mean that the compositor does not want to allow it.
            Upon receiving this event, the client should destroy the
            wl_fullscreen_shell_mode_feedback object.
            """

            ...

        @staticmethod
        def present_cancelled() -> None:
            """
            mode switch cancelled
            This event indicates that the attempted mode switch operation was
            cancelled.  Most likely this is because the client requested a
            second mode switch before the first one completed.
            Upon receiving this event, the client should destroy the
            wl_fullscreen_shell_mode_feedback object.
            """

            ...
class zwp_input_method_context_v1:
    """
    input method context
    Corresponds to a text input on the input method side. An input method context
    is created on text input activation on the input method side. It allows
    receiving information about the text input from the application via events.
    Input method contexts do not keep state after deactivation and should be
    destroyed after deactivation is handled.
    Text is generally UTF-8 encoded, indices and lengths are in bytes.
    Serials are used to synchronize the state between the text input and
    an input method. New serials are sent by the text input in the
    commit_state request and are used by the input method to indicate
    the known text input state in events like preedit_string, commit_string,
    and keysym. The text input can then ignore events from the input method
    which are based on an outdated state (for example after a reset).
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """

        """

        ...

    @staticmethod
    def commit_string(serial: uint, text: string) -> None:
        """
        commit string
        Send the commit string text for insertion to the application.
        The text to commit could be either just a single character after a key
        press or the result of some composing (pre-edit). It could be also an
        empty text when some text should be removed (see
        delete_surrounding_text) or when the input cursor should be moved (see
        cursor_position).
        Any previously set composing text will be removed.
        """

        ...

    @staticmethod
    def preedit_string(serial: uint, text: string, commit: string) -> None:
        """
        pre-edit string
        Send the pre-edit string text to the application text input.
        The commit text can be used to replace the pre-edit text on reset (for
        example on unfocus).
        Previously sent preedit_style and preedit_cursor requests are also
        processed by the text_input.
        """

        ...

    @staticmethod
    def preedit_styling(index: uint, length: uint, style: uint) -> None:
        """
        pre-edit styling
        Set the styling information on composing text. The style is applied for
        length in bytes from index relative to the beginning of
        the composing text (as byte offset). Multiple styles can
        be applied to a composing text.
        This request should be sent before sending a preedit_string request.
        """

        ...

    @staticmethod
    def preedit_cursor(index: int) -> None:
        """
        pre-edit cursor
        Set the cursor position inside the composing text (as byte offset)
        relative to the start of the composing text.
        When index is negative no cursor should be displayed.
        This request should be sent before sending a preedit_string request.
        """

        ...

    @staticmethod
    def delete_surrounding_text(index: int, length: uint) -> None:
        """
        delete text
        Remove the surrounding text.
        This request will be handled on the text_input side directly following
        a commit_string request.
        """

        ...

    @staticmethod
    def cursor_position(index: int, anchor: int) -> None:
        """
        set cursor to a new position
        Set the cursor and anchor to a new position. Index is the new cursor
        position in bytes (when >= 0 this is relative to the end of the inserted text,
        otherwise it is relative to the beginning of the inserted text). Anchor is
        the new anchor position in bytes (when >= 0 this is relative to the end of the
        inserted text, otherwise it is relative to the beginning of the inserted
        text). When there should be no selected text, anchor should be the same
        as index.
        This request will be handled on the text_input side directly following
        a commit_string request.
        """

        ...

    @staticmethod
    def modifiers_map(map: array) -> None:
        """

        """

        ...

    @staticmethod
    def keysym(serial: uint, time: uint, sym: uint, state: uint, modifiers: uint) -> None:
        """
        keysym
        Notify when a key event was sent. Key events should not be used for
        normal text input operations, which should be done with commit_string,
        delete_surrounding_text, etc. The key event follows the wl_keyboard key
        event convention. Sym is an XKB keysym, state is a wl_keyboard key_state.
        """

        ...

    @staticmethod
    def grab_keyboard() -> wl_keyboard:
        """
        grab hardware keyboard
        Allow an input method to receive hardware keyboard input and process
        key events to generate text events (with pre-edit) over the wire. This
        allows input methods which compose multiple key events for inputting
        text like it is done for CJK languages.
        """

        ...

    @staticmethod
    def key(serial: uint, time: uint, key: uint, state: uint) -> None:
        """
        forward key event
        Forward a wl_keyboard::key event to the client that was not processed
        by the input method itself. Should be used when filtering key events
        with grab_keyboard.  The arguments should be the ones from the
        wl_keyboard::key event.
        For generating custom key events use the keysym request instead.
        """

        ...

    @staticmethod
    def modifiers(serial: uint, mods_depressed: uint, mods_latched: uint, mods_locked: uint, group: uint) -> None:
        """
        forward modifiers event
        Forward a wl_keyboard::modifiers event to the client that was not
        processed by the input method itself.  Should be used when filtering
        key events with grab_keyboard. The arguments should be the ones
        from the wl_keyboard::modifiers event.
        """

        ...

    @staticmethod
    def language(serial: uint, language: string) -> None:
        """

        """

        ...

    @staticmethod
    def text_direction(serial: uint, direction: uint) -> None:
        """

        """

        ...
    class events:
        @staticmethod
        def surrounding_text(text: string, cursor: uint, anchor: uint) -> None:
            """
            surrounding text event
            The plain surrounding text around the input position. Cursor is the
            position in bytes within the surrounding text relative to the beginning
            of the text. Anchor is the position in bytes of the selection anchor
            within the surrounding text relative to the beginning of the text. If
            there is no selected text then anchor is the same as cursor.
            """

            ...

        @staticmethod
        def reset() -> None:
            """

            """

            ...

        @staticmethod
        def content_type(hint: uint, purpose: uint) -> None:
            """

            """

            ...

        @staticmethod
        def invoke_action(button: uint, index: uint) -> None:
            """

            """

            ...

        @staticmethod
        def commit_state(serial: uint) -> None:
            """

            """

            ...

        @staticmethod
        def preferred_language(language: string) -> None:
            """

            """

            ...
class zwp_input_panel_v1:
    """
    interface for implementing keyboards
    Only one client can bind this interface at a time.
    """
    object_id = 0
    version = 1

    @staticmethod
    def get_input_panel_surface(surface: object) -> zwp_input_panel_surface_v1:
        """

        """

        ...
class zwp_input_panel_surface_v1:
    """

    """
    object_id = 0
    version = 1

    class position(Enum):
        center_bottom: int

    @staticmethod
    def set_toplevel(output: object, position: uint) -> None:
        """
        set the surface type as a keyboard
        Set the input_panel_surface type to keyboard.
        A keyboard surface is only shown when a text input is active.
        """

        ...

    @staticmethod
    def set_overlay_panel() -> None:
        """
        set the surface type as an overlay panel
        Set the input_panel_surface to be an overlay panel.
        This is shown near the input cursor above the application window when
        a text input is active.
        """

        ...
class zwp_input_method_v1:
    """
    input method
    An input method object is responsible for composing text in response to
    input from hardware or virtual keyboards. There is one input method
    object per seat. On activate there is a new input method context object
    created which allows the input method to communicate with the text input.
    """
    object_id = 0
    version = 1

    class events:
        @staticmethod
        def activate(id: zwp_input_method_context_v1) -> None:
            """
            activate event
            A text input was activated. Creates an input method context object
            which allows communication with the text input.
            """

            ...

        @staticmethod
        def deactivate(context: object) -> None:
            """
            deactivate event
            The text input corresponding to the context argument was deactivated.
            The input method context should be destroyed after deactivation is
            handled.
            """

            ...
class zwp_keyboard_shortcuts_inhibit_manager_v1:
    """
    context object for keyboard grab_manager
    A global interface used for inhibiting the compositor keyboard shortcuts.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_inhibited: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the keyboard shortcuts inhibitor object
        Destroy the keyboard shortcuts inhibitor manager.
        """

        ...

    @staticmethod
    def inhibit_shortcuts(surface: object, seat: object) -> zwp_keyboard_shortcuts_inhibitor_v1:
        """
        create a new keyboard shortcuts inhibitor object
        Create a new keyboard shortcuts inhibitor object associated with
        the given surface for the given seat.
        If shortcuts are already inhibited for the specified seat and surface,
        a protocol error "already_inhibited" is raised by the compositor.
        """

        ...
class zwp_keyboard_shortcuts_inhibitor_v1:
    """
    context object for keyboard shortcuts inhibitor
    A keyboard shortcuts inhibitor instructs the compositor to ignore
    its own keyboard shortcuts when the associated surface has keyboard
    focus. As a result, when the surface has keyboard focus on the given
    seat, it will receive all key events originating from the specified
    seat, even those which would normally be caught by the compositor for
    its own shortcuts.
    The Wayland compositor is however under no obligation to disable
    all of its shortcuts, and may keep some special key combo for its own
    use, including but not limited to one allowing the user to forcibly
    restore normal keyboard events routing in the case of an unwilling
    client. The compositor may also use the same key combo to reactivate
    an existing shortcut inhibitor that was previously deactivated on
    user request.
    When the compositor restores its own keyboard shortcuts, an
    "inactive" event is emitted to notify the client that the keyboard
    shortcuts inhibitor is not effectively active for the surface and
    seat any more, and the client should not expect to receive all
    keyboard events.
    When the keyboard shortcuts inhibitor is inactive, the client has
    no way to forcibly reactivate the keyboard shortcuts inhibitor.
    The user can chose to re-enable a previously deactivated keyboard
    shortcuts inhibitor using any mechanism the compositor may offer,
    in which case the compositor will send an "active" event to notify
    the client.
    If the surface is destroyed, unmapped, or loses the seat's keyboard
    focus, the keyboard shortcuts inhibitor becomes irrelevant and the
    compositor will restore its own keyboard shortcuts but no "inactive"
    event is emitted in this case.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the keyboard shortcuts inhibitor object
        Remove the keyboard shortcuts inhibitor from the associated wl_surface.
        """

        ...
    class events:
        @staticmethod
        def active() -> None:
            """
            shortcuts are inhibited
            This event indicates that the shortcut inhibitor is active.
            The compositor sends this event every time compositor shortcuts
            are inhibited on behalf of the surface. When active, the client
            may receive input events normally reserved by the compositor
            (see zwp_keyboard_shortcuts_inhibitor_v1).
            This occurs typically when the initial request "inhibit_shortcuts"
            first becomes active or when the user instructs the compositor to
            re-enable and existing shortcuts inhibitor using any mechanism
            offered by the compositor.
            """

            ...

        @staticmethod
        def inactive() -> None:
            """
            shortcuts are restored
            This event indicates that the shortcuts inhibitor is inactive,
            normal shortcuts processing is restored by the compositor.
            """

            ...
class zwp_idle_inhibit_manager_v1:
    """
    control behavior when display idles
    This interface permits inhibiting the idle behavior such as screen
    blanking, locking, and screensaving.  The client binds the idle manager
    globally, then creates idle-inhibitor objects for each surface.
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the idle inhibitor object
        Destroy the inhibit manager.
        """

        ...

    @staticmethod
    def create_inhibitor(surface: object) -> zwp_idle_inhibitor_v1:
        """
        create a new inhibitor object
        Create a new inhibitor object associated with the given surface.
        """

        ...
class zwp_idle_inhibitor_v1:
    """
    context object for inhibiting idle behavior
    An idle inhibitor prevents the output that the associated surface is
    visible on from being set to a state where it is not visually usable due
    to lack of user interaction (e.g. blanked, dimmed, locked, set to power
    save, etc.)  Any screensaver processes are also blocked from displaying.
    If the surface is destroyed, unmapped, becomes occluded, loses
    visibility, or otherwise becomes not visually relevant for the user, the
    idle inhibitor will not be honored by the compositor; if the surface
    subsequently regains visibility the inhibitor takes effect once again.
    Likewise, the inhibitor isn't honored if the system was already idled at
    the time the inhibitor was established, although if the system later
    de-idles and re-idles the inhibitor will take effect.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the idle inhibitor object
        Remove the inhibitor effect from the associated wl_surface.
        """

        ...
class zwp_pointer_gestures_v1:
    """
    touchpad gestures
    A global interface to provide semantic touchpad gestures for a given
    pointer.
    Three gestures are currently supported: swipe, pinch, and hold.
    Pinch and swipe gestures follow a three-stage cycle: begin, update,
    end. Hold gestures follow a two-stage cycle: begin and end. All
    gestures are identified by a unique id.
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 3

    @staticmethod
    def get_swipe_gesture(pointer: object) -> zwp_pointer_gesture_swipe_v1:
        """
        get swipe gesture
        Create a swipe gesture object. See the
        wl_pointer_gesture_swipe interface for details.
        """

        ...

    @staticmethod
    def get_pinch_gesture(pointer: object) -> zwp_pointer_gesture_pinch_v1:
        """
        get pinch gesture
        Create a pinch gesture object. See the
        wl_pointer_gesture_pinch interface for details.
        """

        ...

    @staticmethod
    def release() -> None:
        """
        destroy the pointer gesture object
        Destroy the pointer gesture object. Swipe, pinch and hold objects
        created via this gesture object remain valid.
        """

        ...

    @staticmethod
    def get_hold_gesture(pointer: object) -> zwp_pointer_gesture_hold_v1:
        """
        get hold gesture
        Create a hold gesture object. See the
        wl_pointer_gesture_hold interface for details.
        """

        ...
class zwp_pointer_gesture_swipe_v1:
    """
    a swipe gesture object
    A swipe gesture object notifies a client about a multi-finger swipe
    gesture detected on an indirect input device such as a touchpad.
    The gesture is usually initiated by multiple fingers moving in the
    same direction but once initiated the direction may change.
    The precise conditions of when such a gesture is detected are
    implementation-dependent.
    A gesture consists of three stages: begin, update (optional) and end.
    There cannot be multiple simultaneous hold, pinch or swipe gestures on a
    same pointer/seat, how compositors prevent these situations is
    implementation-dependent.
    A gesture may be cancelled by the compositor or the hardware.
    Clients should not consider performing permanent or irreversible
    actions until the end of a gesture has been received.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        destroy the pointer swipe gesture object
        """

        ...
    class events:
        @staticmethod
        def begin(serial: uint, time: uint, surface: object, fingers: uint) -> None:
            """
            multi-finger swipe begin
            This event is sent when a multi-finger swipe gesture is detected
            on the device.
            """

            ...

        @staticmethod
        def update(time: uint, dx: fixed, dy: fixed) -> None:
            """
            multi-finger swipe motion
            This event is sent when a multi-finger swipe gesture changes the
            position of the logical center.
            The dx and dy coordinates are relative coordinates of the logical
            center of the gesture compared to the previous event.
            """

            ...

        @staticmethod
        def end(serial: uint, time: uint, cancelled: int) -> None:
            """
            multi-finger swipe end
            This event is sent when a multi-finger swipe gesture ceases to
            be valid. This may happen when one or more fingers are lifted or
            the gesture is cancelled.
            When a gesture is cancelled, the client should undo state changes
            caused by this gesture. What causes a gesture to be cancelled is
            implementation-dependent.
            """

            ...
class zwp_pointer_gesture_pinch_v1:
    """
    a pinch gesture object
    A pinch gesture object notifies a client about a multi-finger pinch
    gesture detected on an indirect input device such as a touchpad.
    The gesture is usually initiated by multiple fingers moving towards
    each other or away from each other, or by two or more fingers rotating
    around a logical center of gravity. The precise conditions of when
    such a gesture is detected are implementation-dependent.
    A gesture consists of three stages: begin, update (optional) and end.
    There cannot be multiple simultaneous hold, pinch or swipe gestures on a
    same pointer/seat, how compositors prevent these situations is
    implementation-dependent.
    A gesture may be cancelled by the compositor or the hardware.
    Clients should not consider performing permanent or irreversible
    actions until the end of a gesture has been received.
    """
    object_id = 0
    version = 2

    @staticmethod
    def destroy() -> None:
        """
        destroy the pinch gesture object
        """

        ...
    class events:
        @staticmethod
        def begin(serial: uint, time: uint, surface: object, fingers: uint) -> None:
            """
            multi-finger pinch begin
            This event is sent when a multi-finger pinch gesture is detected
            on the device.
            """

            ...

        @staticmethod
        def update(time: uint, dx: fixed, dy: fixed, scale: fixed, rotation: fixed) -> None:
            """
            multi-finger pinch motion
            This event is sent when a multi-finger pinch gesture changes the
            position of the logical center, the rotation or the relative scale.
            The dx and dy coordinates are relative coordinates in the
            surface coordinate space of the logical center of the gesture.
            The scale factor is an absolute scale compared to the
            pointer_gesture_pinch.begin event, e.g. a scale of 2 means the fingers
            are now twice as far apart as on pointer_gesture_pinch.begin.
            The rotation is the relative angle in degrees clockwise compared to the previous
            pointer_gesture_pinch.begin or pointer_gesture_pinch.update event.
            """

            ...

        @staticmethod
        def end(serial: uint, time: uint, cancelled: int) -> None:
            """
            multi-finger pinch end
            This event is sent when a multi-finger pinch gesture ceases to
            be valid. This may happen when one or more fingers are lifted or
            the gesture is cancelled.
            When a gesture is cancelled, the client should undo state changes
            caused by this gesture. What causes a gesture to be cancelled is
            implementation-dependent.
            """

            ...
class zwp_pointer_gesture_hold_v1:
    """
    a hold gesture object
    A hold gesture object notifies a client about a single- or
    multi-finger hold gesture detected on an indirect input device such as
    a touchpad. The gesture is usually initiated by one or more fingers
    being held down without significant movement. The precise conditions
    of when such a gesture is detected are implementation-dependent.
    In particular, this gesture may be used to cancel kinetic scrolling.
    A hold gesture consists of two stages: begin and end. Unlike pinch and
    swipe there is no update stage.
    There cannot be multiple simultaneous hold, pinch or swipe gestures on a
    same pointer/seat, how compositors prevent these situations is
    implementation-dependent.
    A gesture may be cancelled by the compositor or the hardware.
    Clients should not consider performing permanent or irreversible
    actions until the end of a gesture has been received.
    """
    object_id = 0
    version = 3

    @staticmethod
    def destroy() -> None:
        """
        destroy the hold gesture object
        """

        ...
    class events:
        @staticmethod
        def begin(serial: uint, time: uint, surface: object, fingers: uint) -> None:
            """
            multi-finger hold begin
            This event is sent when a hold gesture is detected on the device.
            """

            ...

        @staticmethod
        def end(serial: uint, time: uint, cancelled: int) -> None:
            """
            multi-finger hold end
            This event is sent when a hold gesture ceases to
            be valid. This may happen when the holding fingers are lifted or
            the gesture is cancelled, for example if the fingers move past an
            implementation-defined threshold, the finger count changes or the hold
            gesture changes into a different type of gesture.
            When a gesture is cancelled, the client may need to undo state changes
            caused by this gesture. What causes a gesture to be cancelled is
            implementation-dependent.
            """

            ...
class zwp_input_timestamps_manager_v1:
    """
    context object for high-resolution input timestamps
    A global interface used for requesting high-resolution timestamps
    for input events.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the input timestamps manager object
        Informs the server that the client will no longer be using this
        protocol object. Existing objects created by this object are not
        affected.
        """

        ...

    @staticmethod
    def get_keyboard_timestamps(keyboard: object) -> zwp_input_timestamps_v1:
        """
        subscribe to high-resolution keyboard timestamp events
        Creates a new input timestamps object that represents a subscription
        to high-resolution timestamp events for all wl_keyboard events that
        carry a timestamp.
        If the associated wl_keyboard object is invalidated, either through
        client action (e.g. release) or server-side changes, the input
        timestamps object becomes inert and the client should destroy it
        by calling zwp_input_timestamps_v1.destroy.
        """

        ...

    @staticmethod
    def get_pointer_timestamps(pointer: object) -> zwp_input_timestamps_v1:
        """
        subscribe to high-resolution pointer timestamp events
        Creates a new input timestamps object that represents a subscription
        to high-resolution timestamp events for all wl_pointer events that
        carry a timestamp.
        If the associated wl_pointer object is invalidated, either through
        client action (e.g. release) or server-side changes, the input
        timestamps object becomes inert and the client should destroy it
        by calling zwp_input_timestamps_v1.destroy.
        """

        ...

    @staticmethod
    def get_touch_timestamps(touch: object) -> zwp_input_timestamps_v1:
        """
        subscribe to high-resolution touch timestamp events
        Creates a new input timestamps object that represents a subscription
        to high-resolution timestamp events for all wl_touch events that
        carry a timestamp.
        If the associated wl_touch object becomes invalid, either through
        client action (e.g. release) or server-side changes, the input
        timestamps object becomes inert and the client should destroy it
        by calling zwp_input_timestamps_v1.destroy.
        """

        ...
class zwp_input_timestamps_v1:
    """
    context object for input timestamps
    Provides high-resolution timestamp events for a set of subscribed input
    events. The set of subscribed input events is determined by the
    zwp_input_timestamps_manager_v1 request used to create this object.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the input timestamps object
        Informs the server that the client will no longer be using this
        protocol object. After the server processes the request, no more
        timestamp events will be emitted.
        """

        ...
    class events:
        @staticmethod
        def timestamp(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint) -> None:
            """
            high-resolution timestamp event
            The timestamp event is associated with the first subsequent input event
            carrying a timestamp which belongs to the set of input events this
            object is subscribed to.
            The timestamp provided by this event is a high-resolution version of
            the timestamp argument of the associated input event. The provided
            timestamp is in the same clock domain and is at least as accurate as
            the associated input event timestamp.
            The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec triples,
            each component being an unsigned 32-bit value. Whole seconds are in
            tv_sec which is a 64-bit value combined from tv_sec_hi and tv_sec_lo,
            and the additional fractional part in tv_nsec as nanoseconds. Hence,
            for valid timestamps tv_nsec must be in [0, 999999999].
            """

            ...
class zwp_xwayland_keyboard_grab_manager_v1:
    """
    context object for keyboard grab manager
    A global interface used for grabbing the keyboard.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the keyboard grab manager
        Destroy the keyboard grab manager.
        """

        ...

    @staticmethod
    def grab_keyboard(surface: object, seat: object) -> zwp_xwayland_keyboard_grab_v1:
        """
        grab the keyboard to a surface
        The grab_keyboard request asks for a grab of the keyboard, forcing
        the keyboard focus for the given seat upon the given surface.
        The protocol provides no guarantee that the grab is ever satisfied,
        and does not require the compositor to send an error if the grab
        cannot ever be satisfied. It is thus possible to request a keyboard
        grab that will never be effective.
        The protocol:
        * does not guarantee that the grab itself is applied for a surface,
        the grab request may be silently ignored by the compositor,
        * does not guarantee that any events are sent to this client even
        if the grab is applied to a surface,
        * does not guarantee that events sent to this client are exhaustive,
        a compositor may filter some events for its own consumption,
        * does not guarantee that events sent to this client are continuous,
        a compositor may change and reroute keyboard events while the grab
        is nominally active.
        """

        ...
class zwp_xwayland_keyboard_grab_v1:
    """
    interface for grabbing the keyboard
    A global interface used for grabbing the keyboard.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the grabbed keyboard object
        Destroy the grabbed keyboard object. If applicable, the compositor
        will ungrab the keyboard.
        """

        ...
class zwp_linux_explicit_synchronization_v1:
    """
    protocol for providing explicit synchronization
    This global is a factory interface, allowing clients to request
    explicit synchronization for buffers on a per-surface basis.
    See zwp_linux_surface_synchronization_v1 for more information.
    This interface is derived from Chromium's
    zcr_linux_explicit_synchronization_v1.
    Note: this protocol is superseded by linux-drm-syncobj.
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 2

    class error(Enum):
        synchronization_exists: int

    @staticmethod
    def destroy() -> None:
        """
        destroy explicit synchronization factory object
        Destroy this explicit synchronization factory object. Other objects,
        including zwp_linux_surface_synchronization_v1 objects created by this
        factory, shall not be affected by this request.
        """

        ...

    @staticmethod
    def get_synchronization(surface: object) -> zwp_linux_surface_synchronization_v1:
        """
        extend surface interface for explicit synchronization
        Instantiate an interface extension for the given wl_surface to provide
        explicit synchronization.
        If the given wl_surface already has an explicit synchronization object
        associated, the synchronization_exists protocol error is raised.
        Graphics APIs, like EGL or Vulkan, that manage the buffer queue and
        commits of a wl_surface themselves, are likely to be using this
        extension internally. If a client is using such an API for a
        wl_surface, it should not directly use this extension on that surface,
        to avoid raising a synchronization_exists protocol error.
        """

        ...
class zwp_linux_surface_synchronization_v1:
    """
    per-surface explicit synchronization support
    This object implements per-surface explicit synchronization.
    Synchronization refers to co-ordination of pipelined operations performed
    on buffers. Most GPU clients will schedule an asynchronous operation to
    render to the buffer, then immediately send the buffer to the compositor
    to be attached to a surface.
    In implicit synchronization, ensuring that the rendering operation is
    complete before the compositor displays the buffer is an implementation
    detail handled by either the kernel or userspace graphics driver.
    By contrast, in explicit synchronization, dma_fence objects mark when the
    asynchronous operations are complete. When submitting a buffer, the
    client provides an acquire fence which will be waited on before the
    compositor accesses the buffer. The Wayland server, through a
    zwp_linux_buffer_release_v1 object, will inform the client with an event
    which may be accompanied by a release fence, when the compositor will no
    longer access the buffer contents due to the specific commit that
    requested the release event.
    Each surface can be associated with only one object of this interface at
    any time.
    In version 1 of this interface, explicit synchronization is only
    guaranteed to be supported for buffers created with any version of the
    wp_linux_dmabuf buffer factory. Version 2 additionally guarantees
    explicit synchronization support for opaque EGL buffers, which is a type
    of platform specific buffers described in the EGL_WL_bind_wayland_display
    extension. Compositors are free to support explicit synchronization for
    additional buffer types.
    """
    object_id = 0
    version = 2

    class error(Enum):
        invalid_fence: int
        duplicate_fence: int
        duplicate_release: int
        no_surface: int
        unsupported_buffer: int
        no_buffer: int

    @staticmethod
    def destroy() -> None:
        """
        destroy synchronization object
        Destroy this explicit synchronization object.
        Any fence set by this object with set_acquire_fence since the last
        commit will be discarded by the server. Any fences set by this object
        before the last commit are not affected.
        zwp_linux_buffer_release_v1 objects created by this object are not
        affected by this request.
        """

        ...

    @staticmethod
    def set_acquire_fence(fd: fd) -> None:
        """
        set the acquire fence
        Set the acquire fence that must be signaled before the compositor
        may sample from the buffer attached with wl_surface.attach. The fence
        is a dma_fence kernel object.
        The acquire fence is double-buffered state, and will be applied on the
        next wl_surface.commit request for the associated surface. Thus, it
        applies only to the buffer that is attached to the surface at commit
        time.
        If the provided fd is not a valid dma_fence fd, then an INVALID_FENCE
        error is raised.
        If a fence has already been attached during the same commit cycle, a
        DUPLICATE_FENCE error is raised.
        If the associated wl_surface was destroyed, a NO_SURFACE error is
        raised.
        If at surface commit time the attached buffer does not support explicit
        synchronization, an UNSUPPORTED_BUFFER error is raised.
        If at surface commit time there is no buffer attached, a NO_BUFFER
        error is raised.
        """

        ...

    @staticmethod
    def get_release() -> zwp_linux_buffer_release_v1:
        """
        release fence for last-attached buffer
        Create a listener for the release of the buffer attached by the
        client with wl_surface.attach. See zwp_linux_buffer_release_v1
        documentation for more information.
        The release object is double-buffered state, and will be associated
        with the buffer that is attached to the surface at wl_surface.commit
        time.
        If a zwp_linux_buffer_release_v1 object has already been requested for
        the surface in the same commit cycle, a DUPLICATE_RELEASE error is
        raised.
        If the associated wl_surface was destroyed, a NO_SURFACE error
        is raised.
        If at surface commit time there is no buffer attached, a NO_BUFFER
        error is raised.
        """

        ...
class zwp_linux_buffer_release_v1:
    """
    buffer release explicit synchronization
    This object is instantiated in response to a
    zwp_linux_surface_synchronization_v1.get_release request.
    It provides an alternative to wl_buffer.release events, providing a
    unique release from a single wl_surface.commit request. The release event
    also supports explicit synchronization, providing a fence FD for the
    client to synchronize against.
    Exactly one event, either a fenced_release or an immediate_release, will
    be emitted for the wl_surface.commit request. The compositor can choose
    release by release which event it uses.
    This event does not replace wl_buffer.release events; servers are still
    required to send those events.
    Once a buffer release object has delivered a 'fenced_release' or an
    'immediate_release' event it is automatically destroyed.
    """
    object_id = 0
    version = 1

    class events:
        @staticmethod
        def fenced_release(fence: fd) -> None:
            """
            release buffer with fence
            Sent when the compositor has finalised its usage of the associated
            buffer for the relevant commit, providing a dma_fence which will be
            signaled when all operations by the compositor on that buffer for that
            commit have finished.
            Once the fence has signaled, and assuming the associated buffer is not
            pending release from other wl_surface.commit requests, no additional
            explicit or implicit synchronization is required to safely reuse or
            destroy the buffer.
            This event destroys the zwp_linux_buffer_release_v1 object.
            """

            ...

        @staticmethod
        def immediate_release() -> None:
            """
            release buffer immediately
            Sent when the compositor has finalised its usage of the associated
            buffer for the relevant commit, and either performed no operations
            using it, or has a guarantee that all its operations on that buffer for
            that commit have finished.
            Once this event is received, and assuming the associated buffer is not
            pending release from other wl_surface.commit requests, no additional
            explicit or implicit synchronization is required to safely reuse or
            destroy the buffer.
            This event destroys the zwp_linux_buffer_release_v1 object.
            """

            ...
class zwp_tablet_manager_v1:
    """
    controller object for graphic tablet devices
    An object that provides access to the graphics tablets available on this
    system. All tablets are associated with a seat, to get access to the
    actual tablets, use wp_tablet_manager.get_tablet_seat.
    """
    object_id = 0
    version = 1

    @staticmethod
    def get_tablet_seat(seat: object) -> zwp_tablet_seat_v1:
        """
        get the tablet seat
        Get the wp_tablet_seat object for the given seat. This object
        provides access to all graphics tablets in this seat.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        release the memory for the tablet manager object
        Destroy the wp_tablet_manager object. Objects created from this
        object are unaffected and should be destroyed separately.
        """

        ...
class zwp_tablet_seat_v1:
    """
    controller object for graphic tablet devices of a seat
    An object that provides access to the graphics tablets available on this
    seat. After binding to this interface, the compositor sends a set of
    wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        release the memory for the tablet seat object
        Destroy the wp_tablet_seat object. Objects created from this
        object are unaffected and should be destroyed separately.
        """

        ...
    class events:
        @staticmethod
        def tablet_added(id: zwp_tablet_v1) -> None:
            """
            new device notification
            This event is sent whenever a new tablet becomes available on this
            seat. This event only provides the object id of the tablet, any
            static information about the tablet (device name, vid/pid, etc.) is
            sent through the wp_tablet interface.
            """

            ...

        @staticmethod
        def tool_added(id: zwp_tablet_tool_v1) -> None:
            """
            a new tool has been used with a tablet
            This event is sent whenever a tool that has not previously been used
            with a tablet comes into use. This event only provides the object id
            of the tool; any static information about the tool (capabilities,
            type, etc.) is sent through the wp_tablet_tool interface.
            """

            ...
class zwp_tablet_tool_v1:
    """
    a physical tablet tool
    An object that represents a physical tool that has been, or is
    currently in use with a tablet in this seat. Each wp_tablet_tool
    object stays valid until the client destroys it; the compositor
    reuses the wp_tablet_tool object to indicate that the object's
    respective physical tool has come into proximity of a tablet again.
    A wp_tablet_tool object's relation to a physical tool depends on the
    tablet's ability to report serial numbers. If the tablet supports
    this capability, then the object represents a specific physical tool
    and can be identified even when used on multiple tablets.
    A tablet tool has a number of static characteristics, e.g. tool type,
    hardware_serial and capabilities. These capabilities are sent in an
    event sequence after the wp_tablet_seat.tool_added event before any
    actual events from this tool. This initial event sequence is
    terminated by a wp_tablet_tool.done event.
    Tablet tool events are grouped by wp_tablet_tool.frame events.
    Any events received before a wp_tablet_tool.frame event should be
    considered part of the same hardware state change.
    """
    object_id = 0
    version = 1

    class type(Enum):
        pen: int
        eraser: int
        brush: int
        pencil: int
        airbrush: int
        finger: int
        mouse: int
        lens: int


    class capability(Enum):
        tilt: int
        pressure: int
        distance: int
        rotation: int
        slider: int
        wheel: int


    class button_state(Enum):
        released: int
        pressed: int


    class error(Enum):
        role: int

    @staticmethod
    def set_cursor(serial: uint, surface: object, hotspot_x: int, hotspot_y: int) -> None:
        """
        set the tablet tool's surface
        Sets the surface of the cursor used for this tool on the given
        tablet. This request only takes effect if the tool is in proximity
        of one of the requesting client's surfaces or the surface parameter
        is the current pointer surface. If there was a previous surface set
        with this request it is replaced. If surface is NULL, the cursor
        image is hidden.
        The parameters hotspot_x and hotspot_y define the position of the
        pointer surface relative to the pointer location. Its top-left corner
        is always at (x, y) - (hotspot_x, hotspot_y), where (x, y) are the
        coordinates of the pointer location, in surface-local coordinates.
        On surface.attach requests to the pointer surface, hotspot_x and
        hotspot_y are decremented by the x and y parameters passed to the
        request. Attach must be confirmed by wl_surface.commit as usual.
        The hotspot can also be updated by passing the currently set pointer
        surface to this request with new values for hotspot_x and hotspot_y.
        The current and pending input regions of the wl_surface are cleared,
        and wl_surface.set_input_region is ignored until the wl_surface is no
        longer used as the cursor. When the use as a cursor ends, the current
        and pending input regions become undefined, and the wl_surface is
        unmapped.
        This request gives the surface the role of a cursor. The role
        assigned by this request is the same as assigned by
        wl_pointer.set_cursor meaning the same surface can be
        used both as a wl_pointer cursor and a wp_tablet cursor. If the
        surface already has another role, it raises a protocol error.
        The surface may be used on multiple tablets and across multiple
        seats.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the tool object
        This destroys the client's resource for this tool object.
        """

        ...
    class events:
        @staticmethod
        def type(tool_type: zwp_tablet_tool_v1.type) -> None:
            """
            tool type
            The tool type is the high-level type of the tool and usually decides
            the interaction expected from this tool.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def hardware_serial(hardware_serial_hi: uint, hardware_serial_lo: uint) -> None:
            """
            unique hardware serial number of the tool
            If the physical tool can be identified by a unique 64-bit serial
            number, this event notifies the client of this serial number.
            If multiple tablets are available in the same seat and the tool is
            uniquely identifiable by the serial number, that tool may move
            between tablets.
            Otherwise, if the tool has no serial number and this event is
            missing, the tool is tied to the tablet it first comes into
            proximity with. Even if the physical tool is used on multiple
            tablets, separate wp_tablet_tool objects will be created, one per
            tablet.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def hardware_id_wacom(hardware_id_hi: uint, hardware_id_lo: uint) -> None:
            """
            hardware id notification in Wacom's format
            This event notifies the client of a hardware id available on this tool.
            The hardware id is a device-specific 64-bit id that provides extra
            information about the tool in use, beyond the wl_tool.type
            enumeration. The format of the id is specific to tablets made by
            Wacom Inc. For example, the hardware id of a Wacom Grip
            Pen (a stylus) is 0x802.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def capability(capability: zwp_tablet_tool_v1.capability) -> None:
            """
            tool capability notification
            This event notifies the client of any capabilities of this tool,
            beyond the main set of x/y axes and tip up/down detection.
            One event is sent for each extra capability available on this tool.
            This event is sent in the initial burst of events before the
            wp_tablet_tool.done event.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            tool description events sequence complete
            This event signals the end of the initial burst of descriptive
            events. A client may consider the static description of the tool to
            be complete and finalize initialization of the tool.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            tool removed
            This event is sent when the tool is removed from the system and will
            send no further events. Should the physical tool come back into
            proximity later, a new wp_tablet_tool object will be created.
            It is compositor-dependent when a tool is removed. A compositor may
            remove a tool on proximity out, tablet removal or any other reason.
            A compositor may also keep a tool alive until shutdown.
            If the tool is currently in proximity, a proximity_out event will be
            sent before the removed event. See wp_tablet_tool.proximity_out for
            the handling of any buttons logically down.
            When this event is received, the client must wp_tablet_tool.destroy
            the object.
            """

            ...

        @staticmethod
        def proximity_in(serial: uint, tablet: object, surface: object) -> None:
            """
            proximity in event
            Notification that this tool is focused on a certain surface.
            This event can be received when the tool has moved from one surface to
            another, or when the tool has come back into proximity above the
            surface.
            If any button is logically down when the tool comes into proximity,
            the respective button event is sent after the proximity_in event but
            within the same frame as the proximity_in event.
            """

            ...

        @staticmethod
        def proximity_out() -> None:
            """
            proximity out event
            Notification that this tool has either left proximity, or is no
            longer focused on a certain surface.
            When the tablet tool leaves proximity of the tablet, button release
            events are sent for each button that was held down at the time of
            leaving proximity. These events are sent before the proximity_out
            event but within the same wp_tablet.frame.
            If the tool stays within proximity of the tablet, but the focus
            changes from one surface to another, a button release event may not
            be sent until the button is actually released or the tool leaves the
            proximity of the tablet.
            """

            ...

        @staticmethod
        def down(serial: uint) -> None:
            """
            tablet tool is making contact
            Sent whenever the tablet tool comes in contact with the surface of the
            tablet.
            If the tool is already in contact with the tablet when entering the
            input region, the client owning said region will receive a
            wp_tablet.proximity_in event, followed by a wp_tablet.down
            event and a wp_tablet.frame event.
            Note that this event describes logical contact, not physical
            contact. On some devices, a compositor may not consider a tool in
            logical contact until a minimum physical pressure threshold is
            exceeded.
            """

            ...

        @staticmethod
        def up() -> None:
            """
            tablet tool is no longer making contact
            Sent whenever the tablet tool stops making contact with the surface of
            the tablet, or when the tablet tool moves out of the input region
            and the compositor grab (if any) is dismissed.
            If the tablet tool moves out of the input region while in contact
            with the surface of the tablet and the compositor does not have an
            ongoing grab on the surface, the client owning said region will
            receive a wp_tablet.up event, followed by a wp_tablet.proximity_out
            event and a wp_tablet.frame event. If the compositor has an ongoing
            grab on this device, this event sequence is sent whenever the grab
            is dismissed in the future.
            Note that this event describes logical contact, not physical
            contact. On some devices, a compositor may not consider a tool out
            of logical contact until physical pressure falls below a specific
            threshold.
            """

            ...

        @staticmethod
        def motion(x: fixed, y: fixed) -> None:
            """
            motion event
            Sent whenever a tablet tool moves.
            """

            ...

        @staticmethod
        def pressure(pressure: uint) -> None:
            """
            pressure change event
            Sent whenever the pressure axis on a tool changes. The value of this
            event is normalized to a value between 0 and 65535.
            Note that pressure may be nonzero even when a tool is not in logical
            contact. See the down and up events for more details.
            """

            ...

        @staticmethod
        def distance(distance: uint) -> None:
            """
            distance change event
            Sent whenever the distance axis on a tool changes. The value of this
            event is normalized to a value between 0 and 65535.
            Note that distance may be nonzero even when a tool is not in logical
            contact. See the down and up events for more details.
            """

            ...

        @staticmethod
        def tilt(tilt_x: int, tilt_y: int) -> None:
            """
            tilt change event
            Sent whenever one or both of the tilt axes on a tool change. Each tilt
            value is in 0.01 of a degree, relative to the z-axis of the tablet.
            The angle is positive when the top of a tool tilts along the
            positive x or y axis.
            """

            ...

        @staticmethod
        def rotation(degrees: int) -> None:
            """
            z-rotation change event
            Sent whenever the z-rotation axis on the tool changes. The
            rotation value is in 0.01 of a degree clockwise from the tool's
            logical neutral position.
            """

            ...

        @staticmethod
        def slider(position: int) -> None:
            """
            Slider position change event
            Sent whenever the slider position on the tool changes. The
            value is normalized between -65535 and 65535, with 0 as the logical
            neutral position of the slider.
            The slider is available on e.g. the Wacom Airbrush tool.
            """

            ...

        @staticmethod
        def wheel(degrees: int, clicks: int) -> None:
            """
            Wheel delta event
            Sent whenever the wheel on the tool emits an event. This event
            contains two values for the same axis change. The degrees value is
            in 0.01 of a degree in the same orientation as the
            wl_pointer.vertical_scroll axis. The clicks value is in discrete
            logical clicks of the mouse wheel. This value may be zero if the
            movement of the wheel was less than one logical click.
            Clients should choose either value and avoid mixing degrees and
            clicks. The compositor may accumulate values smaller than a logical
            click and emulate click events when a certain threshold is met.
            Thus, wl_tablet_tool.wheel events with non-zero clicks values may
            have different degrees values.
            """

            ...

        @staticmethod
        def button(serial: uint, button: uint, state: zwp_tablet_tool_v1.button_state) -> None:
            """
            button event
            Sent whenever a button on the tool is pressed or released.
            If a button is held down when the tool moves in or out of proximity,
            button events are generated by the compositor. See
            wp_tablet_tool.proximity_in and wp_tablet_tool.proximity_out for
            details.
            """

            ...

        @staticmethod
        def frame(time: uint) -> None:
            """
            frame event
            Marks the end of a series of axis and/or button updates from the
            tablet. The Wayland protocol requires axis updates to be sent
            sequentially, however all events within a frame should be considered
            one hardware event.
            """

            ...
class zwp_tablet_v1:
    """
    graphics tablet device
    The wp_tablet interface represents one graphics tablet device. The
    tablet interface itself does not generate events; all events are
    generated by wp_tablet_tool objects when in proximity above a tablet.
    A tablet has a number of static characteristics, e.g. device name and
    pid/vid. These capabilities are sent in an event sequence after the
    wp_tablet_seat.tablet_added event. This initial event sequence is
    terminated by a wp_tablet.done event.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the tablet object
        This destroys the client's resource for this tablet object.
        """

        ...
    class events:
        @staticmethod
        def name(name: string) -> None:
            """
            tablet device name
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...

        @staticmethod
        def id(vid: uint, pid: uint) -> None:
            """
            tablet device USB vendor/product id
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...

        @staticmethod
        def path(path: string) -> None:
            """
            path to the device
            A system-specific device path that indicates which device is behind
            this wp_tablet. This information may be used to gather additional
            information about the device, e.g. through libwacom.
            A device may have more than one device path. If so, multiple
            wp_tablet.path events are sent. A device may be emulated and not
            have a device path, and in that case this event will not be sent.
            The format of the path is unspecified, it may be a device node, a
            sysfs path, or some other identifier. It is up to the client to
            identify the string provided.
            This event is sent in the initial burst of events before the
            wp_tablet.done event.
            """

            ...

        @staticmethod
        def done() -> None:
            """
            tablet description events sequence complete
            This event is sent immediately to signal the end of the initial
            burst of descriptive events. A client may consider the static
            description of the tablet to be complete and finalize initialization
            of the tablet.
            """

            ...

        @staticmethod
        def removed() -> None:
            """
            tablet removed event
            Sent when the tablet has been removed from the system. When a tablet
            is removed, some tools may be removed.
            When this event is received, the client must wp_tablet.destroy
            the object.
            """

            ...
class zwp_text_input_v1:
    """
    text input
    An object used for text input. Adds support for text input and input
    methods to applications. A text_input object is created from a
    wl_text_input_manager and corresponds typically to a text entry in an
    application.
    Requests are used to activate/deactivate the text_input object and set
    state information like surrounding and selected text or the content type.
    The information about entered text is sent to the text_input object via
    the pre-edit and commit events. Using this interface removes the need
    for applications to directly process hardware key events and compose text
    out of them.
    Text is generally UTF-8 encoded, indices and lengths are in bytes.
    Serials are used to synchronize the state between the text input and
    an input method. New serials are sent by the text input in the
    commit_state request and are used by the input method to indicate
    the known text input state in events like preedit_string, commit_string,
    and keysym. The text input can then ignore events from the input method
    which are based on an outdated state (for example after a reset).
    Warning! The protocol described in this file is experimental and
    backward incompatible changes may be made. Backward compatible changes
    may be added together with the corresponding interface version bump.
    Backward incompatible changes are done by bumping the version number in
    the protocol and interface names and resetting the interface version.
    Once the protocol is to be declared stable, the 'z' prefix and the
    version number in the protocol and interface names are removed and the
    interface version number is reset.
    """
    object_id = 0
    version = 1

    class content_hint(IntFlag):
        none: int
        default: int
        password: int
        auto_completion: int
        auto_correction: int
        auto_capitalization: int
        lowercase: int
        uppercase: int
        titlecase: int
        hidden_text: int
        sensitive_data: int
        latin: int
        multiline: int


    class content_purpose(Enum):
        normal: int
        alpha: int
        digits: int
        number: int
        phone: int
        url: int
        email: int
        name: int
        password: int
        date: int
        time: int
        datetime: int
        terminal: int


    class preedit_style(Enum):
        default: int
        none: int
        active: int
        inactive: int
        highlight: int
        underline: int
        selection: int
        incorrect: int


    class text_direction(Enum):
        auto: int
        ltr: int
        rtl: int

    @staticmethod
    def activate(seat: object, surface: object) -> None:
        """
        request activation
        Requests the text_input object to be activated (typically when the
        text entry gets focus).
        The seat argument is a wl_seat which maintains the focus for this
        activation. The surface argument is a wl_surface assigned to the
        text_input object and tracked for focus lost. The enter event
        is emitted on successful activation.
        """

        ...

    @staticmethod
    def deactivate(seat: object) -> None:
        """
        request deactivation
        Requests the text_input object to be deactivated (typically when the
        text entry lost focus). The seat argument is a wl_seat which was used
        for activation.
        """

        ...

    @staticmethod
    def show_input_panel() -> None:
        """
        show input panels
        Requests input panels (virtual keyboard) to show.
        """

        ...

    @staticmethod
    def hide_input_panel() -> None:
        """
        hide input panels
        Requests input panels (virtual keyboard) to hide.
        """

        ...

    @staticmethod
    def reset() -> None:
        """
        reset
        Should be called by an editor widget when the input state should be
        reset, for example after the text was changed outside of the normal
        input method flow.
        """

        ...

    @staticmethod
    def set_surrounding_text(text: string, cursor: uint, anchor: uint) -> None:
        """
        sets the surrounding text
        Sets the plain surrounding text around the input position. Text is
        UTF-8 encoded. Cursor is the byte offset within the
        surrounding text. Anchor is the byte offset of the
        selection anchor within the surrounding text. If there is no selected
        text anchor, then it is the same as cursor.
        """

        ...

    @staticmethod
    def set_content_type(hint: zwp_text_input_v1.content_hint, purpose: zwp_text_input_v1.content_purpose) -> None:
        """
        set content purpose and hint
        Sets the content purpose and content hint. While the purpose is the
        basic purpose of an input field, the hint flags allow to modify some
        of the behavior.
        When no content type is explicitly set, a normal content purpose with
        default hints (auto completion, auto correction, auto capitalization)
        should be assumed.
        """

        ...

    @staticmethod
    def set_cursor_rectangle(x: int, y: int, width: int, height: int) -> None:
        """

        """

        ...

    @staticmethod
    def set_preferred_language(language: string) -> None:
        """
        sets preferred language
        Sets a specific language. This allows for example a virtual keyboard to
        show a language specific layout. The "language" argument is an RFC-3066
        format language tag.
        It could be used for example in a word processor to indicate the
        language of the currently edited document or in an instant message
        application which tracks languages of contacts.
        """

        ...

    @staticmethod
    def commit_state(serial: uint) -> None:
        """

        """

        ...

    @staticmethod
    def invoke_action(button: uint, index: uint) -> None:
        """

        """

        ...
    class events:
        @staticmethod
        def enter(surface: object) -> None:
            """
            enter event
            Notify the text_input object when it received focus. Typically in
            response to an activate request.
            """

            ...

        @staticmethod
        def leave() -> None:
            """
            leave event
            Notify the text_input object when it lost focus. Either in response
            to a deactivate request or when the assigned surface lost focus or was
            destroyed.
            """

            ...

        @staticmethod
        def modifiers_map(map: array) -> None:
            """
            modifiers map
            Transfer an array of 0-terminated modifier names. The position in
            the array is the index of the modifier as used in the modifiers
            bitmask in the keysym event.
            """

            ...

        @staticmethod
        def input_panel_state(state: uint) -> None:
            """
            state of the input panel
            Notify when the visibility state of the input panel changed.
            """

            ...

        @staticmethod
        def preedit_string(serial: uint, text: string, commit: string) -> None:
            """
            pre-edit
            Notify when a new composing text (pre-edit) should be set around the
            current cursor position. Any previously set composing text should
            be removed.
            The commit text can be used to replace the preedit text on reset
            (for example on unfocus).
            The text input should also handle all preedit_style and preedit_cursor
            events occurring directly before preedit_string.
            """

            ...

        @staticmethod
        def preedit_styling(index: uint, length: uint, style: zwp_text_input_v1.preedit_style) -> None:
            """
            pre-edit styling
            Sets styling information on composing text. The style is applied for
            length bytes from index relative to the beginning of the composing
            text (as byte offset). Multiple styles can
            be applied to a composing text by sending multiple preedit_styling
            events.
            This event is handled as part of a following preedit_string event.
            """

            ...

        @staticmethod
        def preedit_cursor(index: int) -> None:
            """
            pre-edit cursor
            Sets the cursor position inside the composing text (as byte
            offset) relative to the start of the composing text. When index is a
            negative number no cursor is shown.
            This event is handled as part of a following preedit_string event.
            """

            ...

        @staticmethod
        def commit_string(serial: uint, text: string) -> None:
            """
            commit
            Notify when text should be inserted into the editor widget. The text to
            commit could be either just a single character after a key press or the
            result of some composing (pre-edit). It could also be an empty text
            when some text should be removed (see delete_surrounding_text) or when
            the input cursor should be moved (see cursor_position).
            Any previously set composing text should be removed.
            """

            ...

        @staticmethod
        def cursor_position(index: int, anchor: int) -> None:
            """
            set cursor to new position
            Notify when the cursor or anchor position should be modified.
            This event should be handled as part of a following commit_string
            event.
            """

            ...

        @staticmethod
        def delete_surrounding_text(index: int, length: uint) -> None:
            """
            delete surrounding text
            Notify when the text around the current cursor position should be
            deleted.
            Index is relative to the current cursor (in bytes).
            Length is the length of deleted text (in bytes).
            This event should be handled as part of a following commit_string
            event.
            """

            ...

        @staticmethod
        def keysym(serial: uint, time: uint, sym: uint, state: uint, modifiers: uint) -> None:
            """
            keysym
            Notify when a key event was sent. Key events should not be used
            for normal text input operations, which should be done with
            commit_string, delete_surrounding_text, etc. The key event follows
            the wl_keyboard key event convention. Sym is an XKB keysym, state a
            wl_keyboard key_state. Modifiers are a mask for effective modifiers
            (where the modifier indices are set by the modifiers_map event)
            """

            ...

        @staticmethod
        def language(serial: uint, language: string) -> None:
            """
            language
            Sets the language of the input text. The "language" argument is an
            RFC-3066 format language tag.
            """

            ...

        @staticmethod
        def text_direction(serial: uint, direction: zwp_text_input_v1.text_direction) -> None:
            """
            text direction
            Sets the text direction of input text.
            It is mainly needed for showing an input cursor on the correct side of
            the editor when there is no input done yet and making sure neutral
            direction text is laid out properly.
            """

            ...
class zwp_text_input_manager_v1:
    """
    text input manager
    A factory for text_input objects. This object is a global singleton.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_text_input() -> zwp_text_input_v1:
        """
        create text input
        Creates a new text_input object.
        """

        ...
class zwp_text_input_v3:
    """
    text input
    The zwp_text_input_v3 interface represents text input and input methods
    associated with a seat. It provides enter/leave events to follow the
    text input focus for a seat.
    Requests are used to enable/disable the text-input object and set
    state information like surrounding and selected text or the content type.
    The information about the entered text is sent to the text-input object
    via the preedit_string and commit_string events.
    Text is valid UTF-8 encoded, indices and lengths are in bytes. Indices
    must not point to middle bytes inside a code point: they must either
    point to the first byte of a code point or to the end of the buffer.
    Lengths must be measured between two valid indices.
    Focus moving throughout surfaces will result in the emission of
    zwp_text_input_v3.enter and zwp_text_input_v3.leave events. The focused
    surface must commit zwp_text_input_v3.enable and
    zwp_text_input_v3.disable requests as the keyboard focus moves across
    editable and non-editable elements of the UI. Those two requests are not
    expected to be paired with each other, the compositor must be able to
    handle consecutive series of the same request.
    State is sent by the state requests (set_surrounding_text,
    set_content_type and set_cursor_rectangle) and a commit request. After an
    enter event or disable request all state information is invalidated and
    needs to be resent by the client.
    """
    object_id = 0
    version = 1

    class change_cause(Enum):
        input_method: int
        other: int


    class content_hint(IntFlag):
        none: int
        completion: int
        spellcheck: int
        auto_capitalization: int
        lowercase: int
        uppercase: int
        titlecase: int
        hidden_text: int
        sensitive_data: int
        latin: int
        multiline: int


    class content_purpose(Enum):
        normal: int
        alpha: int
        digits: int
        number: int
        phone: int
        url: int
        email: int
        name: int
        password: int
        pin: int
        date: int
        time: int
        datetime: int
        terminal: int

    @staticmethod
    def destroy() -> None:
        """
        Destroy the wp_text_input
        Destroy the wp_text_input object. Also disables all surfaces enabled
        through this wp_text_input object.
        """

        ...

    @staticmethod
    def enable() -> None:
        """
        Request text input to be enabled
        Requests text input on the surface previously obtained from the enter
        event.
        This request must be issued every time the active text input changes
        to a new one, including within the current surface. Use
        zwp_text_input_v3.disable when there is no longer any input focus on
        the current surface.
        Clients must not enable more than one text input on the single seat
        and should disable the current text input before enabling the new one.
        At most one instance of text input may be in enabled state per instance,
        Requests to enable the another text input when some text input is active
        must be ignored by compositor.
        This request resets all state associated with previous enable, disable,
        set_surrounding_text, set_text_change_cause, set_content_type, and
        set_cursor_rectangle requests, as well as the state associated with
        preedit_string, commit_string, and delete_surrounding_text events.
        The set_surrounding_text, set_content_type and set_cursor_rectangle
        requests must follow if the text input supports the necessary
        functionality.
        State set with this request is double-buffered. It will get applied on
        the next zwp_text_input_v3.commit request, and stay valid until the
        next committed enable or disable request.
        The changes must be applied by the compositor after issuing a
        zwp_text_input_v3.commit request.
        """

        ...

    @staticmethod
    def disable() -> None:
        """
        Disable text input on a surface
        Explicitly disable text input on the current surface (typically when
        there is no focus on any text entry inside the surface).
        State set with this request is double-buffered. It will get applied on
        the next zwp_text_input_v3.commit request.
        """

        ...

    @staticmethod
    def set_surrounding_text(text: string, cursor: int, anchor: int) -> None:
        """
        sets the surrounding text
        Sets the surrounding plain text around the input, excluding the preedit
        text.
        The client should notify the compositor of any changes in any of the
        values carried with this request, including changes caused by handling
        incoming text-input events as well as changes caused by other
        mechanisms like keyboard typing.
        If the client is unaware of the text around the cursor, it should not
        issue this request, to signify lack of support to the compositor.
        Text is UTF-8 encoded, and should include the cursor position, the
        complete selection and additional characters before and after them.
        There is a maximum length of wayland messages, so text can not be
        longer than 4000 bytes.
        Cursor is the byte offset of the cursor within text buffer.
        Anchor is the byte offset of the selection anchor within text buffer.
        If there is no selected text, anchor is the same as cursor.
        If any preedit text is present, it is replaced with a cursor for the
        purpose of this event.
        Values set with this request are double-buffered. They will get applied
        on the next zwp_text_input_v3.commit request, and stay valid until the
        next committed enable or disable request.
        The initial state for affected fields is empty, meaning that the text
        input does not support sending surrounding text. If the empty values
        get applied, subsequent attempts to change them may have no effect.
        """

        ...

    @staticmethod
    def set_text_change_cause(cause: zwp_text_input_v3.change_cause) -> None:
        """
        indicates the cause of surrounding text change
        Tells the compositor why the text surrounding the cursor changed.
        Whenever the client detects an external change in text, cursor, or
        anchor posision, it must issue this request to the compositor. This
        request is intended to give the input method a chance to update the
        preedit text in an appropriate way, e.g. by removing it when the user
        starts typing with a keyboard.
        cause describes the source of the change.
        The value set with this request is double-buffered. It must be applied
        and reset to initial at the next zwp_text_input_v3.commit request.
        The initial value of cause is input_method.
        """

        ...

    @staticmethod
    def set_content_type(hint: zwp_text_input_v3.content_hint, purpose: zwp_text_input_v3.content_purpose) -> None:
        """
        set content purpose and hint
        Sets the content purpose and content hint. While the purpose is the
        basic purpose of an input field, the hint flags allow to modify some of
        the behavior.
        Values set with this request are double-buffered. They will get applied
        on the next zwp_text_input_v3.commit request.
        Subsequent attempts to update them may have no effect. The values
        remain valid until the next committed enable or disable request.
        The initial value for hint is none, and the initial value for purpose
        is normal.
        """

        ...

    @staticmethod
    def set_cursor_rectangle(x: int, y: int, width: int, height: int) -> None:
        """
        set cursor position
        Marks an area around the cursor as a x, y, width, height rectangle in
        surface local coordinates.
        Allows the compositor to put a window with word suggestions near the
        cursor, without obstructing the text being input.
        If the client is unaware of the position of edited text, it should not
        issue this request, to signify lack of support to the compositor.
        Values set with this request are double-buffered. They will get applied
        on the next zwp_text_input_v3.commit request, and stay valid until the
        next committed enable or disable request.
        The initial values describing a cursor rectangle are empty. That means
        the text input does not support describing the cursor area. If the
        empty values get applied, subsequent attempts to change them may have
        no effect.
        """

        ...

    @staticmethod
    def commit() -> None:
        """
        commit state
        Atomically applies state changes recently sent to the compositor.
        The commit request establishes and updates the state of the client, and
        must be issued after any changes to apply them.
        Text input state (enabled status, content purpose, content hint,
        surrounding text and change cause, cursor rectangle) is conceptually
        double-buffered within the context of a text input, i.e. between a
        committed enable request and the following committed enable or disable
        request.
        Protocol requests modify the pending state, as opposed to the current
        state in use by the input method. A commit request atomically applies
        all pending state, replacing the current state. After commit, the new
        pending state is as documented for each related request.
        Requests are applied in the order of arrival.
        Neither current nor pending state are modified unless noted otherwise.
        The compositor must count the number of commit requests coming from
        each zwp_text_input_v3 object and use the count as the serial in done
        events.
        """

        ...
    class events:
        @staticmethod
        def enter(surface: object) -> None:
            """
            enter event
            Notification that this seat's text-input focus is on a certain surface.
            If client has created multiple text input objects, compositor must send
            this event to all of them.
            When the seat has the keyboard capability the text-input focus follows
            the keyboard focus. This event sets the current surface for the
            text-input object.
            """

            ...

        @staticmethod
        def leave(surface: object) -> None:
            """
            leave event
            Notification that this seat's text-input focus is no longer on a
            certain surface. The client should reset any preedit string previously
            set.
            The leave notification clears the current surface. It is sent before
            the enter notification for the new focus. After leave event, compositor
            must ignore requests from any text input instances until next enter
            event.
            When the seat has the keyboard capability the text-input focus follows
            the keyboard focus.
            """

            ...

        @staticmethod
        def preedit_string(text: string, cursor_begin: int, cursor_end: int) -> None:
            """
            pre-edit
            Notify when a new composing text (pre-edit) should be set at the
            current cursor position. Any previously set composing text must be
            removed. Any previously existing selected text must be removed.
            The argument text contains the pre-edit string buffer.
            The parameters cursor_begin and cursor_end are counted in bytes
            relative to the beginning of the submitted text buffer. Cursor should
            be hidden when both are equal to -1.
            They could be represented by the client as a line if both values are
            the same, or as a text highlight otherwise.
            Values set with this event are double-buffered. They must be applied
            and reset to initial on the next zwp_text_input_v3.done event.
            The initial value of text is an empty string, and cursor_begin,
            cursor_end and cursor_hidden are all 0.
            """

            ...

        @staticmethod
        def commit_string(text: string) -> None:
            """
            text commit
            Notify when text should be inserted into the editor widget. The text to
            commit could be either just a single character after a key press or the
            result of some composing (pre-edit).
            Values set with this event are double-buffered. They must be applied
            and reset to initial on the next zwp_text_input_v3.done event.
            The initial value of text is an empty string.
            """

            ...

        @staticmethod
        def delete_surrounding_text(before_length: uint, after_length: uint) -> None:
            """
            delete surrounding text
            Notify when the text around the current cursor position should be
            deleted.
            Before_length and after_length are the number of bytes before and after
            the current cursor index (excluding the selection) to delete.
            If a preedit text is present, in effect before_length is counted from
            the beginning of it, and after_length from its end (see done event
            sequence).
            Values set with this event are double-buffered. They must be applied
            and reset to initial on the next zwp_text_input_v3.done event.
            The initial values of both before_length and after_length are 0.
            """

            ...

        @staticmethod
        def done(serial: uint) -> None:
            """
            apply changes
            Instruct the application to apply changes to state requested by the
            preedit_string, commit_string and delete_surrounding_text events. The
            state relating to these events is double-buffered, and each one
            modifies the pending state. This event replaces the current state with
            the pending state.
            The application must proceed by evaluating the changes in the following
            order:
            1. Replace existing preedit string with the cursor.
            2. Delete requested surrounding text.
            3. Insert commit string with the cursor at its end.
            4. Calculate surrounding text to send.
            5. Insert new preedit text in cursor position.
            6. Place cursor inside preedit text.
            The serial number reflects the last state of the zwp_text_input_v3
            object known to the compositor. The value of the serial argument must
            be equal to the number of commit requests already issued on that object.
            When the client receives a done event with a serial different than the
            number of past commit requests, it must proceed with evaluating and
            applying the changes as normal, except it should not change the current
            state of the zwp_text_input_v3 object. All pending state requests
            (set_surrounding_text, set_content_type and set_cursor_rectangle) on
            the zwp_text_input_v3 object should be sent and committed after
            receiving a zwp_text_input_v3.done event with a matching serial.
            """

            ...
class zwp_text_input_manager_v3:
    """
    text input manager
    A factory for text-input objects. This object is a global singleton.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        Destroy the wp_text_input_manager
        Destroy the wp_text_input_manager object.
        """

        ...

    @staticmethod
    def get_text_input(seat: object) -> zwp_text_input_v3:
        """
        create a new text input object
        Creates a new text-input object for a given seat.
        """

        ...
class zxdg_shell_v6:
    """
    create desktop-style surfaces
    xdg_shell allows clients to turn a wl_surface into a "real window"
    which can be dragged, resized, stacked, and moved around by the
    user. Everything about this interface is suited towards traditional
    desktop environments.
    """
    object_id = 0
    version = 1

    class error(Enum):
        role: int
        defunct_surfaces: int
        not_the_topmost_popup: int
        invalid_popup_parent: int
        invalid_surface_state: int
        invalid_positioner: int

    @staticmethod
    def destroy() -> None:
        """
        destroy xdg_shell
        Destroy this xdg_shell object.
        Destroying a bound xdg_shell object while there are surfaces
        still alive created by this xdg_shell object instance is illegal
        and will result in a protocol error.
        """

        ...

    @staticmethod
    def create_positioner() -> zxdg_positioner_v6:
        """
        create a positioner object
        Create a positioner object. A positioner object is used to position
        surfaces relative to some parent surface. See the interface description
        and xdg_surface.get_popup for details.
        """

        ...

    @staticmethod
    def get_xdg_surface(surface: object) -> zxdg_surface_v6:
        """
        create a shell surface from a surface
        This creates an xdg_surface for the given surface. While xdg_surface
        itself is not a role, the corresponding surface may only be assigned
        a role extending xdg_surface, such as xdg_toplevel or xdg_popup.
        This creates an xdg_surface for the given surface. An xdg_surface is
        used as basis to define a role to a given surface, such as xdg_toplevel
        or xdg_popup. It also manages functionality shared between xdg_surface
        based surface roles.
        See the documentation of xdg_surface for more details about what an
        xdg_surface is and how it is used.
        """

        ...

    @staticmethod
    def pong(serial: uint) -> None:
        """
        respond to a ping event
        A client must respond to a ping event with a pong request or
        the client may be deemed unresponsive. See xdg_shell.ping.
        """

        ...
    class events:
        @staticmethod
        def ping(serial: uint) -> None:
            """
            check if the client is alive
            The ping event asks the client if it's still alive. Pass the
            serial specified in the event back to the compositor by sending
            a "pong" request back with the specified serial. See xdg_shell.ping.
            Compositors can use this to determine if the client is still
            alive. It's unspecified what will happen if the client doesn't
            respond to the ping request, or in what timeframe. Clients should
            try to respond in a reasonable amount of time.
            A compositor is free to ping in any way it wants, but a client must
            always respond to any xdg_shell object it created.
            """

            ...
class zxdg_positioner_v6:
    """
    child surface positioner
    The xdg_positioner provides a collection of rules for the placement of a
    child surface relative to a parent surface. Rules can be defined to ensure
    the child surface remains within the visible area's borders, and to
    specify how the child surface changes its position, such as sliding along
    an axis, or flipping around a rectangle. These positioner-created rules are
    constrained by the requirement that a child surface must intersect with or
    be at least partially adjacent to its parent surface.
    See the various requests for details about possible rules.
    At the time of the request, the compositor makes a copy of the rules
    specified by the xdg_positioner. Thus, after the request is complete the
    xdg_positioner object can be destroyed or reused; further changes to the
    object will have no effect on previous usages.
    For an xdg_positioner object to be considered complete, it must have a
    non-zero size set by set_size, and a non-zero anchor rectangle set by
    set_anchor_rect. Passing an incomplete xdg_positioner object when
    positioning a surface raises an error.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_input: int


    class anchor(IntFlag):
        none: int
        top: int
        bottom: int
        left: int
        right: int


    class gravity(IntFlag):
        none: int
        top: int
        bottom: int
        left: int
        right: int


    class constraint_adjustment(IntFlag):
        none: int
        slide_x: int
        slide_y: int
        flip_x: int
        flip_y: int
        resize_x: int
        resize_y: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_positioner object
        Notify the compositor that the xdg_positioner will no longer be used.
        """

        ...

    @staticmethod
    def set_size(width: int, height: int) -> None:
        """
        set the size of the to-be positioned rectangle
        Set the size of the surface that is to be positioned with the positioner
        object. The size is in surface-local coordinates and corresponds to the
        window geometry. See xdg_surface.set_window_geometry.
        If a zero or negative size is set the invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_anchor_rect(x: int, y: int, width: int, height: int) -> None:
        """
        set the anchor rectangle within the parent surface
        Specify the anchor rectangle within the parent surface that the child
        surface will be placed relative to. The rectangle is relative to the
        window geometry as defined by xdg_surface.set_window_geometry of the
        parent surface. The rectangle must be at least 1x1 large.
        When the xdg_positioner object is used to position a child surface, the
        anchor rectangle may not extend outside the window geometry of the
        positioned child's parent surface.
        If a zero or negative size is set the invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_anchor(anchor: zxdg_positioner_v6.anchor) -> None:
        """
        set anchor rectangle anchor edges
        Defines a set of edges for the anchor rectangle. These are used to
        derive an anchor point that the child surface will be positioned
        relative to. If two orthogonal edges are specified (e.g. 'top' and
        'left'), then the anchor point will be the intersection of the edges
        (e.g. the top left position of the rectangle); otherwise, the derived
        anchor point will be centered on the specified edge, or in the center of
        the anchor rectangle if no edge is specified.
        If two parallel anchor edges are specified (e.g. 'left' and 'right'),
        the invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_gravity(gravity: zxdg_positioner_v6.gravity) -> None:
        """
        set child surface gravity
        Defines in what direction a surface should be positioned, relative to
        the anchor point of the parent surface. If two orthogonal gravities are
        specified (e.g. 'bottom' and 'right'), then the child surface will be
        placed in the specified direction; otherwise, the child surface will be
        centered over the anchor point on any axis that had no gravity
        specified.
        If two parallel gravities are specified (e.g. 'left' and 'right'), the
        invalid_input error is raised.
        """

        ...

    @staticmethod
    def set_constraint_adjustment(constraint_adjustment: uint) -> None:
        """
        set the adjustment to be done when constrained
        Specify how the window should be positioned if the originally intended
        position caused the surface to be constrained, meaning at least
        partially outside positioning boundaries set by the compositor. The
        adjustment is set by constructing a bitmask describing the adjustment to
        be made when the surface is constrained on that axis.
        If no bit for one axis is set, the compositor will assume that the child
        surface should not change its position on that axis when constrained.
        If more than one bit for one axis is set, the order of how adjustments
        are applied is specified in the corresponding adjustment descriptions.
        The default adjustment is none.
        """

        ...

    @staticmethod
    def set_offset(x: int, y: int) -> None:
        """
        set surface position offset
        Specify the surface position offset relative to the position of the
        anchor on the anchor rectangle and the anchor on the surface. For
        example if the anchor of the anchor rectangle is at (x, y), the surface
        has the gravity bottom|right, and the offset is (ox, oy), the calculated
        surface position will be (x + ox, y + oy). The offset position of the
        surface is the one used for constraint testing. See
        set_constraint_adjustment.
        An example use case is placing a popup menu on top of a user interface
        element, while aligning the user interface element of the parent surface
        with some user interface element placed somewhere in the popup surface.
        """

        ...
class zxdg_surface_v6:
    """
    desktop user interface surface base interface
    An interface that may be implemented by a wl_surface, for
    implementations that provide a desktop-style user interface.
    It provides a base set of functionality required to construct user
    interface elements requiring management by the compositor, such as
    toplevel windows, menus, etc. The types of functionality are split into
    xdg_surface roles.
    Creating an xdg_surface does not set the role for a wl_surface. In order
    to map an xdg_surface, the client must create a role-specific object
    using, e.g., get_toplevel, get_popup. The wl_surface for any given
    xdg_surface can have at most one role, and may not be assigned any role
    not based on xdg_surface.
    A role must be assigned before any other requests are made to the
    xdg_surface object.
    The client must call wl_surface.commit on the corresponding wl_surface
    for the xdg_surface state to take effect.
    Creating an xdg_surface from a wl_surface which has a buffer attached or
    committed is a client error, and any attempts by a client to attach or
    manipulate a buffer prior to the first xdg_surface.configure call must
    also be treated as errors.
    For a surface to be mapped by the compositor, the following conditions
    must be met: (1) the client has assigned an xdg_surface based role to the
    surface, (2) the client has set and committed the xdg_surface state and
    the role dependent state to the surface and (3) the client has committed a
    buffer to the surface.
    """
    object_id = 0
    version = 1

    class error(Enum):
        not_constructed: int
        already_constructed: int
        unconfigured_buffer: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_surface
        Destroy the xdg_surface object. An xdg_surface must only be destroyed
        after its role object has been destroyed. If the role object still
        exists when this request is issued, the zxdg_shell_v6.defunct_surfaces
        is raised.
        """

        ...

    @staticmethod
    def get_toplevel() -> zxdg_toplevel_v6:
        """
        assign the xdg_toplevel surface role
        This creates an xdg_toplevel object for the given xdg_surface and gives
        the associated wl_surface the xdg_toplevel role. If the surface already
        had a role, the zxdg_shell_v6.role error is raised.
        See the documentation of xdg_toplevel for more details about what an
        xdg_toplevel is and how it is used.
        """

        ...

    @staticmethod
    def get_popup(parent: object, positioner: object) -> zxdg_popup_v6:
        """
        assign the xdg_popup surface role
        This creates an xdg_popup object for the given xdg_surface and gives the
        associated wl_surface the xdg_popup role. If the surface already
        had a role, the zxdg_shell_v6.role error is raised.
        See the documentation of xdg_popup for more details about what an
        xdg_popup is and how it is used.
        """

        ...

    @staticmethod
    def set_window_geometry(x: int, y: int, width: int, height: int) -> None:
        """
        set the new window geometry
        The window geometry of a surface is its "visible bounds" from the
        user's perspective. Client-side decorations often have invisible
        portions like drop-shadows which should be ignored for the
        purposes of aligning, placing and constraining windows.
        The window geometry is double-buffered state, see wl_surface.commit.
        Once the window geometry of the surface is set, it is not possible to
        unset it, and it will remain the same until set_window_geometry is
        called again, even if a new subsurface or buffer is attached.
        If never set, the value is the full bounds of the surface,
        including any subsurfaces. This updates dynamically on every
        commit. This unset is meant for extremely simple clients.
        The arguments are given in the surface-local coordinate space of
        the wl_surface associated with this xdg_surface.
        The width and height must be greater than zero. Setting an invalid size
        will raise an error. When applied, the effective window geometry will be
        the set window geometry clamped to the bounding rectangle of the
        combined geometry of the surface of the xdg_surface and the associated
        subsurfaces.
        """

        ...

    @staticmethod
    def ack_configure(serial: uint) -> None:
        """
        ack a configure event
        When a configure event is received, if a client commits the
        surface in response to the configure event, then the client
        must make an ack_configure request sometime before the commit
        request, passing along the serial of the configure event.
        For instance, for toplevel surfaces the compositor might use this
        information to move a surface to the top left only when the client has
        drawn itself for the maximized or fullscreen state.
        If the client receives multiple configure events before it
        can respond to one, it only has to ack the last configure event.
        A client is not required to commit immediately after sending
        an ack_configure request - it may even ack_configure several times
        before its next surface commit.
        A client may send multiple ack_configure requests before committing, but
        only the last request sent before a commit indicates which configure
        event the client really is responding to.
        If an invalid serial is used, the zxdg_shell_v6.invalid_surface_state
        error is raised.
        """

        ...
    class events:
        @staticmethod
        def configure(serial: uint) -> None:
            """
            suggest a surface change
            The configure event marks the end of a configure sequence. A configure
            sequence is a set of one or more events configuring the state of the
            xdg_surface, including the final xdg_surface.configure event.
            Where applicable, xdg_surface surface roles will during a configure
            sequence extend this event as a latched state sent as events before the
            xdg_surface.configure event. Such events should be considered to make up
            a set of atomically applied configuration states, where the
            xdg_surface.configure commits the accumulated state.
            Clients should arrange their surface for the new states, and then send
            an ack_configure request with the serial sent in this configure event at
            some point before committing the new surface.
            If the client receives multiple configure events before it can respond
            to one, it is free to discard all but the last event it received.
            """

            ...
class zxdg_toplevel_v6:
    """
    toplevel surface
    This interface defines an xdg_surface role which allows a surface to,
    among other things, set window-like properties such as maximize,
    fullscreen, and minimize, set application-specific metadata like title and
    id, and well as trigger user interactive operations such as interactive
    resize and move.
    """
    object_id = 0
    version = 1

    class resize_edge(Enum):
        none: int
        top: int
        bottom: int
        left: int
        top_left: int
        bottom_left: int
        right: int
        top_right: int
        bottom_right: int


    class state(Enum):
        maximized: int
        fullscreen: int
        resizing: int
        activated: int

    @staticmethod
    def destroy() -> None:
        """
        destroy the xdg_toplevel
        Unmap and destroy the window. The window will be effectively
        hidden from the user's point of view, and all state like
        maximization, fullscreen, and so on, will be lost.
        """

        ...

    @staticmethod
    def set_parent(parent: object) -> None:
        """
        set the parent of this surface
        Set the "parent" of this surface. This window should be stacked
        above a parent. The parent surface must be mapped as long as this
        surface is mapped.
        Parent windows should be set on dialogs, toolboxes, or other
        "auxiliary" surfaces, so that the parent is raised when the dialog
        is raised.
        """

        ...

    @staticmethod
    def set_title(title: string) -> None:
        """
        set surface title
        Set a short title for the surface.
        This string may be used to identify the surface in a task bar,
        window list, or other user interface elements provided by the
        compositor.
        The string must be encoded in UTF-8.
        """

        ...

    @staticmethod
    def set_app_id(app_id: string) -> None:
        """
        set application ID
        Set an application identifier for the surface.
        The app ID identifies the general class of applications to which
        the surface belongs. The compositor can use this to group multiple
        surfaces together, or to determine how to launch a new application.
        For D-Bus activatable applications, the app ID is used as the D-Bus
        service name.
        The compositor shell will try to group application surfaces together
        by their app ID. As a best practice, it is suggested to select app
        ID's that match the basename of the application's .desktop file.
        For example, "org.freedesktop.FooViewer" where the .desktop file is
        "org.freedesktop.FooViewer.desktop".
        See the desktop-entry specification [0] for more details on
        application identifiers and how they relate to well-known D-Bus
        names and .desktop files.
        [0] http://standards.freedesktop.org/desktop-entry-spec/
        """

        ...

    @staticmethod
    def show_window_menu(seat: object, serial: uint, x: int, y: int) -> None:
        """
        show the window menu
        Clients implementing client-side decorations might want to show
        a context menu when right-clicking on the decorations, giving the
        user a menu that they can use to maximize or minimize the window.
        This request asks the compositor to pop up such a window menu at
        the given position, relative to the local surface coordinates of
        the parent surface. There are no guarantees as to what menu items
        the window menu contains.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event.
        """

        ...

    @staticmethod
    def move(seat: object, serial: uint) -> None:
        """
        start an interactive move
        Start an interactive, user-driven move of the surface.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event. The passed
        serial is used to determine the type of interactive move (touch,
        pointer, etc).
        The server may ignore move requests depending on the state of
        the surface (e.g. fullscreen or maximized), or if the passed serial
        is no longer valid.
        If triggered, the surface will lose the focus of the device
        (wl_pointer, wl_touch, etc) used for the move. It is up to the
        compositor to visually indicate that the move is taking place, such as
        updating a pointer cursor, during the move. There is no guarantee
        that the device focus will return when the move is completed.
        """

        ...

    @staticmethod
    def resize(seat: object, serial: uint, edges: uint) -> None:
        """
        start an interactive resize
        Start a user-driven, interactive resize of the surface.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event. The passed
        serial is used to determine the type of interactive resize (touch,
        pointer, etc).
        The server may ignore resize requests depending on the state of
        the surface (e.g. fullscreen or maximized).
        If triggered, the client will receive configure events with the
        "resize" state enum value and the expected sizes. See the "resize"
        enum value for more details about what is required. The client
        must also acknowledge configure events using "ack_configure". After
        the resize is completed, the client will receive another "configure"
        event without the resize state.
        If triggered, the surface also will lose the focus of the device
        (wl_pointer, wl_touch, etc) used for the resize. It is up to the
        compositor to visually indicate that the resize is taking place,
        such as updating a pointer cursor, during the resize. There is no
        guarantee that the device focus will return when the resize is
        completed.
        The edges parameter specifies how the surface should be resized,
        and is one of the values of the resize_edge enum. The compositor
        may use this information to update the surface position for
        example when dragging the top left corner. The compositor may also
        use this information to adapt its behavior, e.g. choose an
        appropriate cursor image.
        """

        ...

    @staticmethod
    def set_max_size(width: int, height: int) -> None:
        """
        set the maximum size
        Set a maximum size for the window.
        The client can specify a maximum size so that the compositor does
        not try to configure the window beyond this size.
        The width and height arguments are in window geometry coordinates.
        See xdg_surface.set_window_geometry.
        Values set in this way are double-buffered, see wl_surface.commit.
        The compositor can use this information to allow or disallow
        different states like maximize or fullscreen and draw accurate
        animations.
        Similarly, a tiling window manager may use this information to
        place and resize client windows in a more effective way.
        The client should not rely on the compositor to obey the maximum
        size. The compositor may decide to ignore the values set by the
        client and request a larger size.
        If never set, or a value of zero in the request, means that the
        client has no expected maximum size in the given dimension.
        As a result, a client wishing to reset the maximum size
        to an unspecified state can use zero for width and height in the
        request.
        Requesting a maximum size to be smaller than the minimum size of
        a surface is illegal and will result in a protocol error.
        The width and height must be greater than or equal to zero. Using
        strictly negative values for width and height will result in the
        zxdg_shell_v6.invalid_surface_state error being raised.
        """

        ...

    @staticmethod
    def set_min_size(width: int, height: int) -> None:
        """
        set the minimum size
        Set a minimum size for the window.
        The client can specify a minimum size so that the compositor does
        not try to configure the window below this size.
        The width and height arguments are in window geometry coordinates.
        See xdg_surface.set_window_geometry.
        Values set in this way are double-buffered, see wl_surface.commit.
        The compositor can use this information to allow or disallow
        different states like maximize or fullscreen and draw accurate
        animations.
        Similarly, a tiling window manager may use this information to
        place and resize client windows in a more effective way.
        The client should not rely on the compositor to obey the minimum
        size. The compositor may decide to ignore the values set by the
        client and request a smaller size.
        If never set, or a value of zero in the request, means that the
        client has no expected minimum size in the given dimension.
        As a result, a client wishing to reset the minimum size
        to an unspecified state can use zero for width and height in the
        request.
        Requesting a minimum size to be larger than the maximum size of
        a surface is illegal and will result in a protocol error.
        The width and height must be greater than or equal to zero. Using
        strictly negative values for width and height will result in the
        zxdg_shell_v6.invalid_surface_state error being raised.
        """

        ...

    @staticmethod
    def set_maximized() -> None:
        """
        maximize the window
        Maximize the surface.
        After requesting that the surface should be maximized, the compositor
        will respond by emitting a configure event with the "maximized" state
        and the required window geometry. The client should then update its
        content, drawing it in a maximized state, i.e. without shadow or other
        decoration outside of the window geometry. The client must also
        acknowledge the configure when committing the new content (see
        ack_configure).
        It is up to the compositor to decide how and where to maximize the
        surface, for example which output and what region of the screen should
        be used.
        If the surface was already maximized, the compositor will still emit
        a configure event with the "maximized" state.
        Note that unrelated compositor side state changes may cause
        configure events to be emitted at any time, meaning trying to
        match this request to a specific future configure event is
        futile.
        """

        ...

    @staticmethod
    def unset_maximized() -> None:
        """
        unmaximize the window
        Unmaximize the surface.
        After requesting that the surface should be unmaximized, the compositor
        will respond by emitting a configure event without the "maximized"
        state. If available, the compositor will include the window geometry
        dimensions the window had prior to being maximized in the configure
        request. The client must then update its content, drawing it in a
        regular state, i.e. potentially with shadow, etc. The client must also
        acknowledge the configure when committing the new content (see
        ack_configure).
        It is up to the compositor to position the surface after it was
        unmaximized; usually the position the surface had before maximizing, if
        applicable.
        If the surface was already not maximized, the compositor will still
        emit a configure event without the "maximized" state.
        Note that unrelated changes in the state of compositor may cause
        configure events to be emitted by the compositor between processing
        this request and emitting corresponding configure event, so trying
        to match the request with the event is futile.
        """

        ...

    @staticmethod
    def set_fullscreen(output: object) -> None:
        """
        set the window as fullscreen on a monitor
        Make the surface fullscreen.
        You can specify an output that you would prefer to be fullscreen.
        If this value is NULL, it's up to the compositor to choose which
        display will be used to map this surface.
        If the surface doesn't cover the whole output, the compositor will
        position the surface in the center of the output and compensate with
        black borders filling the rest of the output.
        """

        ...

    @staticmethod
    def unset_fullscreen() -> None:
        """

        """

        ...

    @staticmethod
    def set_minimized() -> None:
        """
        set the window as minimized
        Request that the compositor minimize your surface. There is no
        way to know if the surface is currently minimized, nor is there
        any way to unset minimization on this surface.
        If you are looking to throttle redrawing when minimized, please
        instead use the wl_surface.frame event for this, as this will
        also work with live previews on windows in Alt-Tab, Expose or
        similar compositor features.
        """

        ...
    class events:
        @staticmethod
        def configure(width: int, height: int, states: array) -> None:
            """
            suggest a surface change
            This configure event asks the client to resize its toplevel surface or
            to change its state. The configured state should not be applied
            immediately. See xdg_surface.configure for details.
            The width and height arguments specify a hint to the window
            about how its surface should be resized in window geometry
            coordinates. See set_window_geometry.
            If the width or height arguments are zero, it means the client
            should decide its own window dimension. This may happen when the
            compositor needs to configure the state of the surface but doesn't
            have any information about any previous or expected dimension.
            The states listed in the event specify how the width/height
            arguments should be interpreted, and possibly how it should be
            drawn.
            Clients must send an ack_configure in response to this event. See
            xdg_surface.configure and xdg_surface.ack_configure for details.
            """

            ...

        @staticmethod
        def close() -> None:
            """
            surface wants to be closed
            The close event is sent by the compositor when the user
            wants the surface to be closed. This should be equivalent to
            the user clicking the close button in client-side decorations,
            if your application has any.
            This is only a request that the user intends to close the
            window. The client may choose to ignore this request, or show
            a dialog to ask the user to save their data, etc.
            """

            ...
class zxdg_popup_v6:
    """
    short-lived, popup surfaces for menus
    A popup surface is a short-lived, temporary surface. It can be used to
    implement for example menus, popovers, tooltips and other similar user
    interface concepts.
    A popup can be made to take an explicit grab. See xdg_popup.grab for
    details.
    When the popup is dismissed, a popup_done event will be sent out, and at
    the same time the surface will be unmapped. See the xdg_popup.popup_done
    event for details.
    Explicitly destroying the xdg_popup object will also dismiss the popup and
    unmap the surface. Clients that want to dismiss the popup when another
    surface of their own is clicked should dismiss the popup using the destroy
    request.
    The parent surface must have either the xdg_toplevel or xdg_popup surface
    role.
    A newly created xdg_popup will be stacked on top of all previously created
    xdg_popup surfaces associated with the same xdg_toplevel.
    The parent of an xdg_popup must be mapped (see the xdg_surface
    description) before the xdg_popup itself.
    The x and y arguments passed when creating the popup object specify
    where the top left of the popup should be placed, relative to the
    local surface coordinates of the parent surface. See
    xdg_surface.get_popup. An xdg_popup must intersect with or be at least
    partially adjacent to its parent surface.
    The client must call wl_surface.commit on the corresponding wl_surface
    for the xdg_popup state to take effect.
    """
    object_id = 0
    version = 1

    class error(Enum):
        invalid_grab: int

    @staticmethod
    def destroy() -> None:
        """
        remove xdg_popup interface
        This destroys the popup. Explicitly destroying the xdg_popup
        object will also dismiss the popup, and unmap the surface.
        If this xdg_popup is not the "topmost" popup, a protocol error
        will be sent.
        """

        ...

    @staticmethod
    def grab(seat: object, serial: uint) -> None:
        """
        make the popup take an explicit grab
        This request makes the created popup take an explicit grab. An explicit
        grab will be dismissed when the user dismisses the popup, or when the
        client destroys the xdg_popup. This can be done by the user clicking
        outside the surface, using the keyboard, or even locking the screen
        through closing the lid or a timeout.
        If the compositor denies the grab, the popup will be immediately
        dismissed.
        This request must be used in response to some sort of user action like a
        button press, key press, or touch down event. The serial number of the
        event should be passed as 'serial'.
        The parent of a grabbing popup must either be an xdg_toplevel surface or
        another xdg_popup with an explicit grab. If the parent is another
        xdg_popup it means that the popups are nested, with this popup now being
        the topmost popup.
        Nested popups must be destroyed in the reverse order they were created
        in, e.g. the only popup you are allowed to destroy at all times is the
        topmost one.
        When compositors choose to dismiss a popup, they may dismiss every
        nested grabbing popup as well. When a compositor dismisses popups, it
        will follow the same dismissing order as required from the client.
        The parent of a grabbing popup must either be another xdg_popup with an
        active explicit grab, or an xdg_popup or xdg_toplevel, if there are no
        explicit grabs already taken.
        If the topmost grabbing popup is destroyed, the grab will be returned to
        the parent of the popup, if that parent previously had an explicit grab.
        If the parent is a grabbing popup which has already been dismissed, this
        popup will be immediately dismissed. If the parent is a popup that did
        not take an explicit grab, an error will be raised.
        During a popup grab, the client owning the grab will receive pointer
        and touch events for all their surfaces as normal (similar to an
        "owner-events" grab in X11 parlance), while the top most grabbing popup
        will always have keyboard focus.
        """

        ...
    class events:
        @staticmethod
        def configure(x: int, y: int, width: int, height: int) -> None:
            """
            configure the popup surface
            This event asks the popup surface to configure itself given the
            configuration. The configured state should not be applied immediately.
            See xdg_surface.configure for details.
            The x and y arguments represent the position the popup was placed at
            given the xdg_positioner rule, relative to the upper left corner of the
            window geometry of the parent surface.
            """

            ...

        @staticmethod
        def popup_done() -> None:
            """
            popup interaction is done
            The popup_done event is sent out when a popup is dismissed by the
            compositor. The client should destroy the xdg_popup object at this
            point.
            """

            ...
class xdg_shell:
    """
    create desktop-style surfaces
    xdg_shell allows clients to turn a wl_surface into a "real window"
    which can be dragged, resized, stacked, and moved around by the
    user. Everything about this interface is suited towards traditional
    desktop environments.
    """
    object_id = 0
    version = 1

    class version(Enum):
        current: int


    class error(Enum):
        role: int
        defunct_surfaces: int
        not_the_topmost_popup: int
        invalid_popup_parent: int

    @staticmethod
    def destroy() -> None:
        """
        destroy xdg_shell
        Destroy this xdg_shell object.
        Destroying a bound xdg_shell object while there are surfaces
        still alive created by this xdg_shell object instance is illegal
        and will result in a protocol error.
        """

        ...

    @staticmethod
    def use_unstable_version(version: int) -> None:
        """
        enable use of this unstable version
        Negotiate the unstable version of the interface.  This
        mechanism is in place to ensure client and server agree on the
        unstable versions of the protocol that they speak or exit
        cleanly if they don't agree.  This request will go away once
        the xdg-shell protocol is stable.
        """

        ...

    @staticmethod
    def get_xdg_surface(surface: object) -> xdg_surface:
        """
        create a shell surface from a surface
        This creates an xdg_surface for the given surface and gives it the
        xdg_surface role. A wl_surface can only be given an xdg_surface role
        once. If get_xdg_surface is called with a wl_surface that already has
        an active xdg_surface associated with it, or if it had any other role,
        an error is raised.
        See the documentation of xdg_surface for more details about what an
        xdg_surface is and how it is used.
        """

        ...

    @staticmethod
    def get_xdg_popup(surface: object, parent: object, seat: object, serial: uint, x: int, y: int) -> xdg_popup:
        """
        create a popup for a surface
        This creates an xdg_popup for the given surface and gives it the
        xdg_popup role. A wl_surface can only be given an xdg_popup role
        once. If get_xdg_popup is called with a wl_surface that already has
        an active xdg_popup associated with it, or if it had any other role,
        an error is raised.
        This request must be used in response to some sort of user action
        like a button press, key press, or touch down event.
        See the documentation of xdg_popup for more details about what an
        xdg_popup is and how it is used.
        """

        ...

    @staticmethod
    def pong(serial: uint) -> None:
        """
        respond to a ping event
        A client must respond to a ping event with a pong request or
        the client may be deemed unresponsive.
        """

        ...
    class events:
        @staticmethod
        def ping(serial: uint) -> None:
            """
            check if the client is alive
            The ping event asks the client if it's still alive. Pass the
            serial specified in the event back to the compositor by sending
            a "pong" request back with the specified serial.
            Compositors can use this to determine if the client is still
            alive. It's unspecified what will happen if the client doesn't
            respond to the ping request, or in what timeframe. Clients should
            try to respond in a reasonable amount of time.
            A compositor is free to ping in any way it wants, but a client must
            always respond to any xdg_shell object it created.
            """

            ...
class hyprland_lock_notifier_v1:
    """
    lock notification manager
    This interface allows clients to monitor whether the wayland session is
    locked or unlocked.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        Destroy the manager object. All objects created via this interface
        remain valid.
        """

        ...

    @staticmethod
    def get_lock_notification() -> hyprland_lock_notification_v1:
        """
        create a notification object
        Create a new lock notification object.
        If the session is already locked when calling this method,
        the locked event shall be sent immediately.
        """

        ...
class hyprland_lock_notification_v1:
    """
    lock notification
    This interface is used by the compositor to send lock notification events
    to clients.
    Typically the "locked" and "unlocked" events are emitted when a client
    locks/unlocks the session via ext-session-lock, but the compositor may
    choose to send notifications for any other locking mechanisms.
    The compositor must notfiy after possible transition periods
    between locked and unlocked states of the session.
    In the context of ext-session-lock, that means the "locked" event is
    expected to be sent after the session-lock client has presented
    a lock screen frame on every output, which corresponds to the "locked"
    event of ext-session-lock.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        destroy the notification object
        Destroy the notification object.
        """

        ...
    class events:
        @staticmethod
        def locked() -> None:
            """
            session is locked
            This event is sent when the wayland session is locked.
            It's a compositor protocol error to send this event twice without an
            unlock event in-between.
            """

            ...

        @staticmethod
        def unlocked() -> None:
            """
            session is no longer locked
            This event is sent when the wayland session is unlocked.
            It's a compositor protocol error to send this event twice without an
            locked event in-between. It's a compositor protocol error to send this
            event prior to any locked event.
            """

            ...
class hyprland_ctm_control_manager_v1:
    """
    manager to control CTMs
    This object is a manager which offers requests to control CTMs.
    If any changes are done, once this object is destroyed, CTMs are reset back to
    an identity matrix.
    """
    object_id = 0
    version = 2

    class error(Enum):
        invalid_matrix: int

    @staticmethod
    def set_ctm_for_output(output: object, mat0: fixed, mat1: fixed, mat2: fixed, mat3: fixed, mat4: fixed, mat5: fixed, mat6: fixed, mat7: fixed, mat8: fixed) -> None:
        """
        set the CTM of an output
        Set a CTM for a wl_output.
        This state is not applied immediately; clients must call .commit to
        apply any pending changes.
        The provided values describe a 3x3 Row-Major CTM with values in the range of [0, ∞)
        Passing values outside of the range will raise an invalid_matrix error.
        The default value of the CTM is an identity matrix.
        If an output doesn't get a CTM set with set_ctm_for_output and commit is called,
        that output will get its CTM reset to an identity matrix.
        """

        ...

    @staticmethod
    def commit() -> None:
        """
        commit the pending state
        Commits the pending state(s) set by set_ctm_for_output.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        All objects created by the manager will still remain valid, until their
        appropriate destroy request has been called.
        The CTMs of all outputs will be reset to an identity matrix.
        """

        ...
    class events:
        @staticmethod
        def blocked() -> None:
            """
            
            This event is sent if another manager was bound by any client
            at the time the current manager was bound.
            Any set_ctm_for_output requests from a blocked manager will be
            silently ignored by the compositor.
            The client should destroy the manager after receiving this event.
            """

            ...
class hyprland_global_shortcuts_manager_v1:
    """
    manager to register global shortcuts
    This object is a manager which offers requests to create global shortcuts.
    """
    object_id = 0
    version = 1

    class error(Enum):
        already_taken: int

    @staticmethod
    def register_shortcut(id: string, app_id: string, description: string, trigger_description: string) -> hyprland_global_shortcut_v1:
        """
        register a shortcut
        Register a new global shortcut.
        A global shortcut is anonymous, meaning the app does not know what key(s) trigger it.
        The shortcut's keybinding shall be dealt with by the compositor.
        In the case of a duplicate app_id + id combination, the already_taken protocol error is raised.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        All objects created by the manager will still remain valid, until their
        appropriate destroy request has been called.
        """

        ...
class hyprland_global_shortcut_v1:
    """
    a shortcut
    This object represents a single shortcut.
    """
    object_id = 0
    version = 1

    @staticmethod
    def destroy() -> None:
        """
        delete this object, used or not
        Destroys the shortcut. Can be sent at any time by the client.
        """

        ...
    class events:
        @staticmethod
        def pressed(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint) -> None:
            """
            keystroke pressed
            The keystroke was pressed.
            tv_ values hold the timestamp of the occurrence.
            """

            ...

        @staticmethod
        def released(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint) -> None:
            """
            keystroke released
            The keystroke was released.
            tv_ values hold the timestamp of the occurrence.
            """

            ...
class hyprland_surface_manager_v1:
    """
    manager for hyprland surface objects
    This interface allows a client to create hyprland surface objects.
    """
    object_id = 0
    version = 2

    class error(Enum):
        already_constructed: int

    @staticmethod
    def get_hyprland_surface(surface: object) -> hyprland_surface_v1:
        """
        create a hyprland surface object
        Create a hyprland surface object for the given wayland surface.
        If the wl_surface already has an associated hyprland_surface_v1 object,
        even from a different manager, creation is a protocol error.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the hyprland surface manager
        Destroy the surface manager.
        This does not destroy existing surface objects.
        """

        ...
class hyprland_surface_v1:
    """
    hyprland-specific wl_surface properties
    This interface allows access to hyprland-specific properties of a wl_surface.
    Once the wl_surface has been destroyed, the hyprland surface object must be
    destroyed as well. All other operations are a protocol error.
    """
    object_id = 0
    version = 2

    class error(Enum):
        no_surface: int
        out_of_range: int

    @staticmethod
    def set_opacity(opacity: fixed) -> None:
        """
        set the overall opacity of the surface
        Sets a multiplier for the overall opacity of the surface.
        This multiplier applies to visual effects such as blur behind the surface
        in addition to the surface's content.
        The default value is 1.0.
        Setting a value outside of the range 0.0 - 1.0 (inclusive) is a protocol error.
        Does not take effect until wl_surface.commit is called.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the hyprland surface interface
        Destroy the hyprland surface object, resetting properties provided
        by this interface to their default values on the next wl_surface.commit.
        """

        ...

    @staticmethod
    def set_visible_region(region: object) -> None:
        """
        set the visible region of the surface
        This request sets the region of the surface that contains visible content.
        Visible content refers to content that has an alpha value greater than zero.
        The visible region is an optimization hint for the compositor that lets it
        avoid drawing parts of the surface that are not visible. Setting a visible region
        that does not contain all content in the surface may result in missing content
        not being drawn.
        The visible region is specified in buffer-local coordinates.
        The compositor ignores the parts of the visible region that fall outside of the surface.
        When all parts of the region fall outside of the buffer geometry, the compositor may
        avoid rendering the surface entirely.
        The initial value for the visible region is empty. Setting the
        visible region has copy semantics, and the wl_region object can be destroyed immediately.
        A NULL wl_region causes the visible region to be set to empty.
        Does not take effect until wl_surface.commit is called.
        """

        ...
class hyprland_toplevel_export_manager_v1:
    """
    manager to inform clients and begin capturing
    This object is a manager which offers requests to start capturing from a
    source.
    """
    object_id = 0
    version = 2

    @staticmethod
    def capture_toplevel(overlay_cursor: int, handle: uint) -> hyprland_toplevel_export_frame_v1:
        """
        capture a toplevel
        Capture the next frame of a toplevel. (window)
        The captured frame will not contain any server-side decorations and will
        ignore the compositor-set geometry, like e.g. rounded corners.
        It will contain all the subsurfaces and popups, however the latter will be clipped
        to the geometry of the base surface.
        The handle parameter refers to the address of the window as seen in `hyprctl clients`.
        For example, for d161e7b0 it would be 3512854448.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the manager
        All objects created by the manager will still remain valid, until their
        appropriate destroy request has been called.
        """

        ...

    @staticmethod
    def capture_toplevel_with_wlr_toplevel_handle(overlay_cursor: int, handle: object) -> hyprland_toplevel_export_frame_v1:
        """
        capture a toplevel
        Same as capture_toplevel, but with a zwlr_foreign_toplevel_handle_v1 handle.
        """

        ...
class hyprland_toplevel_export_frame_v1:
    """
    a frame ready for copy
    This object represents a single frame.
    When created, a series of buffer events will be sent, each representing a
    supported buffer type. The "buffer_done" event is sent afterwards to
    indicate that all supported buffer types have been enumerated. The client
    will then be able to send a "copy" request. If the capture is successful,
    the compositor will send a "flags" followed by a "ready" event.
    wl_shm buffers are always supported, ie. the "buffer" event is guaranteed to be sent.
    If the capture failed, the "failed" event is sent. This can happen anytime
    before the "ready" event.
    Once either a "ready" or a "failed" event is received, the client should
    destroy the frame.
    """
    object_id = 0
    version = 2

    class error(Enum):
        already_used: int
        invalid_buffer: int


    class flags(IntFlag):
        y_invert: int

    @staticmethod
    def copy(buffer: object, ignore_damage: int) -> None:
        """
        copy the frame
        Copy the frame to the supplied buffer. The buffer must have the
        correct size, see hyprland_toplevel_export_frame_v1.buffer and
        hyprland_toplevel_export_frame_v1.linux_dmabuf. The buffer needs to have a
        supported format.
        If the frame is successfully copied, a "flags" and a "ready" event is
        sent. Otherwise, a "failed" event is sent.
        This event will wait for appropriate damage to be copied, unless the ignore_damage
        arg is set to a non-zero value.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        delete this object, used or not
        Destroys the frame. This request can be sent at any time by the client.
        """

        ...
    class events:
        @staticmethod
        def buffer(format: hyprland_toplevel_export_frame_v1.wl_shm.format, width: uint, height: uint, stride: uint) -> None:
            """
            wl_shm buffer information
            Provides information about wl_shm buffer parameters that need to be
            used for this frame. This event is sent once after the frame is created
            if wl_shm buffers are supported.
            """

            ...

        @staticmethod
        def damage(x: uint, y: uint, width: uint, height: uint) -> None:
            """
            carries the coordinates of the damaged region
            This event is sent right before the ready event when ignore_damage was
            not set. It may be generated multiple times for each copy
            request.
            The arguments describe a box around an area that has changed since the
            last copy request that was derived from the current screencopy manager
            instance.
            The union of all regions received between the call to copy
            and a ready event is the total damage since the prior ready event.
            """

            ...

        @staticmethod
        def flags(flags: hyprland_toplevel_export_frame_v1.flags) -> None:
            """
            frame flags
            Provides flags about the frame. This event is sent once before the
            "ready" event.
            """

            ...

        @staticmethod
        def ready(tv_sec_hi: uint, tv_sec_lo: uint, tv_nsec: uint) -> None:
            """
            indicates frame is available for reading
            Called as soon as the frame is copied, indicating it is available
            for reading. This event includes the time at which presentation happened
            at.
            The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec triples,
            each component being an unsigned 32-bit value. Whole seconds are in
            tv_sec which is a 64-bit value combined from tv_sec_hi and tv_sec_lo,
            and the additional fractional part in tv_nsec as nanoseconds. Hence,
            for valid timestamps tv_nsec must be in [0, 999999999]. The seconds part
            may have an arbitrary offset at start.
            After receiving this event, the client should destroy the object.
            """

            ...

        @staticmethod
        def failed() -> None:
            """
            frame copy failed
            This event indicates that the attempted frame copy has failed.
            After receiving this event, the client should destroy the object.
            """

            ...

        @staticmethod
        def linux_dmabuf(format: uint, width: uint, height: uint) -> None:
            """
            linux-dmabuf buffer information
            Provides information about linux-dmabuf buffer parameters that need to
            be used for this frame. This event is sent once after the frame is
            created if linux-dmabuf buffers are supported.
            """

            ...

        @staticmethod
        def buffer_done() -> None:
            """
            all buffer types reported
            This event is sent once after all buffer events have been sent.
            The client should proceed to create a buffer of one of the supported
            types, and send a "copy" request.
            """

            ...
class hyprland_focus_grab_manager_v1:
    """
    manager for focus grab objects
    This interface allows a client to create surface grab objects.
    """
    object_id = 0
    version = 1

    @staticmethod
    def create_grab() -> hyprland_focus_grab_v1:
        """
        create a focus grab object
        Create a surface grab object.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the focus grab manager
        Destroy the focus grab manager.
        This doesn't destroy existing focus grab objects.
        """

        ...
class hyprland_focus_grab_v1:
    """
    input focus limiter
    This interface restricts input focus to a specified whitelist of
    surfaces as long as the focus grab object exists and has at least
    one comitted surface.
    Mouse and touch events inside a whitelisted surface will be passed
    to the surface normally, while events outside of a whitelisted surface
    will clear the grab object. Keyboard events will be passed to the client
    and a compositor-picked surface in the whitelist will receive a
    wl_keyboard::enter event if a whitelisted surface is not already entered.
    Upon meeting implementation-defined criteria usually meaning a mouse or
    touch input outside of any whitelisted surfaces, the compositor will
    clear the whitelist, rendering the grab inert and sending the cleared
    event. The same will happen if another focus grab or similar action
    is started at the compositor's discretion.
    """
    object_id = 0
    version = 1

    @staticmethod
    def add_surface(surface: object) -> None:
        """
        add a surface to the focus whitelist
        Add a surface to the whitelist. Destroying the surface is treated the
        same as an explicit call to remove_surface and duplicate additions are
        ignored.
        Does not take effect until commit is called.
        """

        ...

    @staticmethod
    def remove_surface(surface: object) -> None:
        """
        remove a surface from the focus whitelist
        Remove a surface from the whitelist. Destroying the surface is treated
        the same as an explicit call to this function.
        If the grab was active and the removed surface was entered by the
        keyboard, another surface will be entered on commit.
        Does not take effect until commit is called.
        """

        ...

    @staticmethod
    def commit() -> None:
        """
        commit the focus whitelist
        Commit pending changes to the surface whitelist.
        If the list previously had no entries and now has at least one, the grab
        will start. If it previously had entries and now has none, the grab will
        become inert.
        """

        ...

    @staticmethod
    def destroy() -> None:
        """
        destroy the focus grab
        Destroy the grab object and remove the grab if active.
        """

        ...
    class events:
        @staticmethod
        def cleared() -> None:
            """
            the focus grab was cleared
            Sent when an active grab is cancelled by the compositor,
            regardless of cause.
            """

            ...
