"""Screener Helpers """

# pylint: disable=too-many-lines

from typing import Dict, Literal

MARKET_CAP_MAP = {
    "all": "Any",
    "mega": "Mega ($200bln and more)",
    "large": "Large ($10bln to $200bln)",
    "large_over": "+Large (over $10bln)",
    "large_under": "-Large (under $200bln)",
    "mid": "Mid ($2bl to $10bln)",
    "mid_over": "+Mid (over $2bln)",
    "mid_under": "-Mid (under $10bln)",
    "small": "Small ($300mln to $2bln)",
    "small_over": "+Small (over $300mln)",
    "small_under": "-Small (under $2bln)",
    "micro": "Micro ($50mln to $300mln)",
    "micro_over": "+Micro (over $50mln)",
    "micro_under": "-Micro (under $300mln)",
    "nano": "Nano (under $50mln)",
}

MarketCap = Literal[
    "all",
    "mega",
    "large",
    "large_over",
    "large_under",
    "mid",
    "mid_over",
    "mid_under",
    "small",
    "small_over",
    "small_under",
    "micro",
    "micro_over",
    "micro_under",
    "nano",
]

INDUSTRY_MAP = {
    "all": "Any",
    "stocks_only": "Stocks only (ex-Funds)",
    "etf": "Exchange Traded Fund",
    "advertising_agencies": "Advertising Agencies",
    "aerospace_defense": "Aerospace & Defense",
    "agricultural_inputs": "Agricultural Inputs",
    "airlines": "Airlines",
    "airports_airservices": "Airports & Air Services",
    "aluminum": "Aluminum",
    "apparel_manufacturing": "Apparel Manufacturing",
    "apparel_retail": "Apparel Retail",
    "asset_management": "Asset Management",
    "auto_manufacturers": "Auto Manufacturers",
    "auto_parts": "Auto Parts",
    "auto_dealerships": "Auto & Truck Dealerships",
    "banks_diversified": "Banks - Diversified",
    "banks_regional": "Banks - Regional",
    "beverages_brewers": "Beverages - Brewers",
    "beverages_nonalcoholic": "Beverages - Non-Alcoholic",
    "beverages_wineries_distilleries": "Beverages - Wineries & Distilleries",
    "biotechnology": "Biotechnology",
    "broadcasting": "Broadcasting",
    "building_materials": "Building Materials",
    "building_products_equipment": "Building Products & Equipment",
    "business_equipment_supplies": "Business Equipment & Supplies",
    "capital_markets": "Capital Markets",
    "chemicals": "Chemicals",
    "closed_end_fund_debt": "Closed-End Fund - Debt",
    "closed_end_fund_equity": "Closed-End Fund - Equity",
    "closed_end_fund_foreign": "Closed-End Fund - Foreign",
    "coking_coal": "Coking Coal",
    "communication_equipment": "Communication Equipment",
    "computer_hardware": "Computer Hardware",
    "confectioners": "Confectioners",
    "conglomerates": "Conglomerates",
    "consulting_services": "Consulting Services",
    "consumer_electronics": "Consumer Electronics",
    "copper": "Copper",
    "credit_services": "Credit Services",
    "department_stores": "Department Stores",
    "diagnostics_research": "Diagnostics & Research",
    "discount_stores": "Discount Stores",
    "drug_manufacturers_general": "Drug Manufacturers - General",
    "drug_manufacturers_specialty_generic": "Drug Manufacturers - Specialty & Generic",
    "education_training_services": "Education & Training Services",
    "electrical_equipment_parts": "Electrical Equipment & Parts",
    "electronic_components": "Electronic Components",
    "electronic_gaming_multimedia": "Electronic Gaming & Multimedia",
    "electronics_computer_distribution": "Electronics & Computer Distribution",
    "engineering_construction": "Engineering & Construction",
    "entertainment": "Entertainment",
    "farm_heavy_construction_machinery": "Farm & Heavy Construction Machinery",
    "farm_products": "Farm Products",
    "financial_conglomerates": "Financial Conglomerates",
    "financial_data_stock_exchanges": "Financial Data & Stock Exchanges",
    "food_distribution": "Food Distribution",
    "footwear_accessories": "Footwear & Accessories",
    "furnishings_fixtures_appliances": "Furnishings, Fixtures & Appliances",
    "gambling": "Gambling",
    "gold": "Gold",
    "grocery_stores": "Grocery Stores",
    "health_care_plans": "Healthcare Plans",
    "health_information_services": "Health Information Services",
    "home_improvement_retail": "Home Improvement Retail",
    "household_personal_products": "Household & Personal Products",
    "industrial_distribution": "Industrial Distribution",
    "information_technology_services": "Information Technology Services",
    "infrastructure_operations": "Infrastructure Operations",
    "insurance_brokers": "Insurance Brokers",
    "insurance_diversified": "Insurance - Diversified",
    "insurance_life": "Insurance - Life",
    "insurance_property_casualty": "Insurance - Property & Casualty",
    "insurance_reinsurance": "Insurance - Reinsurance",
    "insurance_specialty": "Insurance - Specialty",
    "integrated_freight_logistics": "Integrated Freight & Logistics",
    "internet_content_information": "Internet Content & Information",
    "internet_retail": "Internet Retail",
    "leisure": "Leisure",
    "lodging": "Lodging",
    "lumber_wood_production": "Lumber & Wood Production",
    "luxury_goods": "Luxury Goods",
    "marine_shipping": "Marine Shipping",
    "medical_care_facilities": "Medical Care Facilities",
    "medical_devices": "Medical Devices",
    "medical_distribution": "Medical Distribution",
    "medical_instruments_supplies": "Medical Instruments & Supplies",
    "metal_fabrication": "Metal Fabrication",
    "mortgage_finance": "Mortgage Finance",
    "oil_gas_drilling": "Oil & Gas Drilling",
    "oil_gas_ep": "Oil & Gas E&P",
    "oil_gas_equipment_services": "Oil & Gas Equipment & Services",
    "oil_gas_integrated": "Oil & Gas Integrated",
    "oil_gas_midstream": "Oil & Gas Midstream",
    "oil_gas_refining_marketing": "Oil & Gas Refining & Marketing",
    "other_industrial_metals_mining": "Other Industrial Metals & Mining",
    "other_precious_metals_mining": "Other Precious Metals & Mining",
    "packaged_foods": "Packaged Foods",
    "packaging_containers": "Packaging & Containers",
    "paper_paper_products": "Paper & Paper Products",
    "personal_services": "Personal Services",
    "pharmaceutical_retailers": "Pharmaceutical Retailers",
    "pollution_treatment_controls": "Pollution & Treatment Controls",
    "publishing": "Publishing",
    "railroads": "Railroads",
    "real_estate_development": "Real Estate - Development",
    "real_estate_diversified": "Real Estate - Diversified",
    "real_estate_services": "Real Estate Services",
    "recreational_vehicles": "Recreational Vehicles",
    "reit_diversified": "REIT - Diversified",
    "reit_health_care_facilities": "REIT - Healthcare Facilities",
    "reit_hotel_motel": "REIT - Hotel & Motel",
    "reit_industrial": "REIT - Industrial",
    "reit_mortgage": "REIT - Mortgage",
    "reit_office": "REIT - Office",
    "reit_residential": "REIT - Residential",
    "reit_retail": "REIT - Retail",
    "reit_specialty": "REIT - Specialty",
    "rental_leasing_services": "Rental & Leasing Services",
    "residential_construction": "Residential Construction",
    "resorts_casinos": "Resorts & Casinos",
    "restaurants": "Restaurants",
    "scientific_technical_instruments": "Scientific & Technical Instruments",
    "security_protection_services": "Security & Protection Services",
    "semiconductor_equipment_materials": "Semiconductor Equipment & Materials",
    "semiconductors": "Semiconductors",
    "shell_companies": "Shell Companies",
    "silver": "Silver",
    "software_application": "Software - Application",
    "software_infrastructure": "Software - Infrastructure",
    "solar": "Solar",
    "specialty_business_services": "Specialty Business Services",
    "specialty_chemicals": "Specialty Chemicals",
    "specialty_industrial_machinery": "Specialty Industrial Machinery",
    "specialty_retail": "Specialty Retail",
    "staffing_employment_services": "Staffing & Employment Services",
    "steel": "Steel",
    "telecom_services": "Telecom Services",
    "textile_manufacturing": "Textile Manufacturing",
    "thermal_coal": "Thermal Coal",
    "tobacco": "Tobacco",
    "tools_accessories": "Tools & Accessories",
    "travel_services": "Travel Services",
    "trucking": "Trucking",
    "uranium": "Uranium",
    "utilities_diversified": "Utilities - Diversified",
    "utilities_independent_power_producers": "Utilities - Independent Power Producers",
    "utilities_regulated_electric": "Utilities - Regulated Electric",
    "utilities_regulated_gas": "Utilities - Regulated Gas",
    "utilities_regulated_water": "Utilities - Regulated Water",
    "utilities_renewable": "Utilities - Renewable",
    "waste_management": "Waste Management",
}

d_signals = {
    "top_gainers": "Top Gainers",
    "top_losers": "Top Losers",
    "new_high": "New High",
    "new_low": "New Low",
    "most_volatile": "Most Volatile",
    "most_active": "Most Active",
    "unusual_volume": "Unusual Volume",
    "overbought": "Overbought",
    "oversold": "Oversold",
    "downgrades": "Downgrades",
    "upgrades": "Upgrades",
    "earnings_before": "Earnings Before",
    "earnings_after": "Earnings After",
    "recent_insider_buying": "Recent Insider Buying",
    "recent_insider_selling": "Recent Insider Selling",
    "major_news": "Major News",
    "horizontal_sr": "Horizontal S/R",
    "tl_resistance": "TL Resistance",
    "tl_support": "TL Support",
    "wedge_up": "Wedge Up",
    "wedge_down": "Wedge Down",
    "wedge": "Wedge",
    "triangle_ascending": "Triangle Ascending",
    "triangle_descending": "Triangle Descending",
    "channel_up": "Channel Up",
    "channel_down": "Channel Down",
    "channel": "Channel",
    "double_top": "Double Top",
    "double_bottom": "Double Bottom",
    "multiple_top": "Multiple Top",
    "multiple_bottom": "Multiple Bottom",
    "head_shoulders": "Head & Shoulders",
    "head_shoulders_inverse": "Head & Shoulders Inverse",
}


d_signals_desc = {
    "top_gainers": "stocks with the highest price gain percent today",
    "top_losers": "stocks with the highest price percent loss today",
    "new_high": "stocks making 52-week high today",
    "new_low": "stocks making 52-week low today",
    "most_volatile": "stocks with the highest widest high/low trading range today",
    "most_active": "stocks with the highest trading volume today",
    "unusual_volume": "stocks with unusually high volume today - the highest relative volume ratio",
    "overbought": "stock is becoming overvalued and may experience a pullback.",
    "oversold": "oversold stocks may represent a buying opportunity for investors",
    "downgrades": "stocks downgraded by analysts today",
    "upgrades": "stocks upgraded by analysts today",
    "earnings_before": "companies reporting earnings today, before market open",
    "earnings_after": "companies reporting earnings today, after market close",
    "recent_insider_buying": "stocks with recent insider buying activity",
    "recent_insider_selling": "stocks with recent insider selling activity",
    "major_news": "stocks with the highest news coverage today",
    "horizontal_sr": "horizontal channel of price range between support and resistance trendlines",
    "tl_resistance": "once a rising trendline is broken",
    "tl_support": "once a falling trendline is broken",
    "wedge_up": "upward trendline support and upward trendline resistance (reversal)",
    "wedge_down": "downward trendline support and downward trendline resistance (reversal)",
    "wedge": "upward trendline support, downward trendline resistance (contiunation)",
    "triangle_ascending": "upward trendline support and horizontal trendline resistance",
    "triangle_descending": "horizontal trendline support and downward trendline resistance",
    "channel_up": "both support and resistance trendlines slope upward",
    "channel_down": "both support and resistance trendlines slope downward",
    "channel": "both support and resistance trendlines are horizontal",
    "double_top": "stock with 'M' shape that indicates a bearish reversal in trend",
    "double_bottom": "stock with 'W' shape that indicates a bullish reversal in trend",
    "multiple_top": "same as double_top hitting more highs",
    "multiple_bottom": "same as double_bottom hitting more lows",
    "head_shoulders": "chart formation that predicts a bullish-to-bearish trend reversal",
    "head_shoulders_inverse": "chart formation that predicts a bearish-to-bullish trend reversal",
}

Recommendation = Literal[
    "all",
    "strong_buy",
    "buy+",
    "buy",
    "hold+",
    "hold",
    "hold-",
    "sell",
    "sell-",
    "strong_sell",
]

RECOMMENDATION_MAP = {
    "all": "Any",
    "strong_buy": "Strong Buy (1)",
    "buy+": "Buy or better",
    "buy": "Buy",
    "hold+": "Hold or better",
    "hold": "Hold",
    "hold-": "Hold or worse",
    "sell": "Sell",
    "sell-": "Sell or worse",
    "strong_sell": "Strong Sell (5)",
}

d_check_screener = {
    "Order": [
        "Any",
        "Signal",
        "Ticker",
        "Company",
        "Sector",
        "Industry",
        "Country",
        "Market Cap.",
        "Price/Earnings",
        "Forward Price/Earnings",
        "PEG (Price/Earnings/Growth)",
        "Price/Sales",
        "Price/Book",
        "Price/Cash",
        "Price/Free Cash Flow",
        "Dividend Yield",
        "Payout Ratio",
        "EPS(ttm)",
        "EPS growth this year",
        "EPS growth next year",
        "EPS growth past 5 years",
        "EPS growth next 5 years",
        "Sales growth past 5 years",
        "EPS growth qtr over qtr",
        "Sales growth qtr over qtr",
        "Shares Outstanding",
        "Shares Float",
        "Insider Ownership",
        "Insider Transactions",
        "Institutional Ownership",
        "Institutional Transactions",
        "Short Interest Share",
        "Short Interest Ratio",
        "Earnings Date",
        "Return on Assets",
        "Return on Equity",
        "Return on Investment",
        "Current Ratio",
        "Quick Ratio",
        "LT Debt/Equity",
        "Total Debt/Equity",
        "Gross Margin",
        "Operating Margin",
        "Net Profit Margin",
        "Analyst Recommendation",
        "Performance (Week)",
        "Performance (Month)",
        "Performance (Quarter)",
        "Performance (Half Year)",
        "Performance (Year)",
        "Performance (Year To Date)",
        "Beta",
        "Average True Range",
        "Volatility (Week)",
        "Volatility (Month)",
        "20-Day SMA (Relative)",
        "50-Day SMA (Relative)",
        "200-Day SMA (Relative)",
        "50-Day High (Relative)",
        "50-Day Low (Relative)",
        "52-Week High (Relative)",
        "52-Week Low (Relative)",
        "Relative Strength Index (14)",
        "Average Volume (3 Month)",
        "Relative Volume",
        "Change",
        "Change from Open",
        "Gap",
        "Volume",
        "Price",
        "Target Price",
        "IPO Date",
    ],
    "Ascend": ["true", "false"],
    "Signal": [
        "Any",
        "Top Gainers",
        "Top Losers",
        "New High",
        "New Low",
        "Most Volatile",
        "Most Active",
        "Unusual Volume",
        "Overbought",
        "Oversold",
        "Downgrades",
        "Upgrades",
        "Earnings Before",
        "Earnings After",
        "Recent Insider Buying",
        "Recent Insider Selling",
        "Major News",
        "Horizontal S/R",
        "TL Resistance",
        "TL Support",
        "Wedge Up",
        "Wedge Down",
        "Triangle Ascending",
        "Triangle Descending",
        "Wedge",
        "Channel Up",
        "Channel Down",
        "Channel",
        "Double Top",
        "Double Bottom",
        "Multiple Top",
        "Multiple Bottom",
        "Head & Shoulders",
        "Head & Shoulders Inverse",
    ],
    "Exchange": ["Any", "AMEX", "NASDAQ", "NYSE"],
    "Market Cap.": [
        "Any",
        "Mega ($200bln and more)",
        "Large ($10bln to $200bln)",
        "Mid ($2bln to $10bln)",
        "Small ($300mln to $2bln)",
        "Micro ($50mln to $300mln)",
        "Nano (under $50mln)",
        "+Large (over $10bln)",
        "+Mid (over $2bln)",
        "+Small (over $300mln)",
        "+Micro (over $50mln)",
        "-Large (under $200bln)",
        "-Mid (under $10bln)",
        "-Small (under $2bln)",
        "-Micro (under $300mln)",
    ],
    "Earnings Date": [
        "Any",
        "Today",
        "Today Before Market Open",
        "Today Before Market Close",
        "Tomorrow",
        "Tomorrow Before Market Open",
        "Tomorrow Before Market Close",
        "Yesterday",
        "Yesterday Before Market Open",
        "Yesterday Before Market Close",
        "Next 5 Days",
        "Previous 5 Days",
        "This Week",
        "Next Week",
        "Previous Week",
        "This Month",
    ],
    "Target Price": [
        "Any",
        "50% Above Price",
        "40% Above Price",
        "30% Above Price",
        "20% Above Price",
        "10% Above Price",
        "5% Above Price",
        "Above Price",
        "Below Price",
        "5% Below Price",
        "10% Below Price",
        "20% Below Price",
        "30% Below Price",
        "40% Below Price",
        "50% Below Price",
    ],
    "Index": ["Any", "S&P 500", "DJIA", "NASDAQ 100", "Russell 2000"],
    "Dividend Yield": [
        "Any",
        "None (0%)",
        "Positive (>0%)",
        "High (>5%)",
        "Very High (>10%)",
        "Over 1%",
        "Over 2%",
        "Over 3%",
        "Over 4%",
        "Over 5%",
        "Over 6%",
        "Over 7%",
        "Over 8%",
        "Over 9%",
        "Over 10%",
    ],
    "Average Volume": [
        "Any",
        "Under 50K",
        "Under 100K",
        "Under 500K",
        "Under 750K",
        "Under 1M",
        "Over 50K",
        "Over 100K",
        "Over 200K",
        "Over 300K",
        "Over 400K",
        "Over 500K",
        "Over 750K",
        "Over 1M",
        "Over 2M",
        "100K to 500K",
        "100K to 1M",
        "500K to 1M",
        "500K to 10M",
    ],
    "IPO Date": [
        "Any",
        "Today",
        "Yesterday",
        "In the last week",
        "In the last month",
        "In the last quarter",
        "In the last year",
        "In the last 2 years",
        "In the last 3 years",
        "In the last 5 years",
        "More than a year ago",
        "More that 5 years ago",
        "More than 10 years ago",
        "More than 15 years ago",
        "More than 20 years ago",
        "More than 25 years ago",
    ],
    "Sector": [
        "Any",
        "Basic Materials",
        "Communication Services",
        "Consumer Cyclical",
        "Consumer Defensive",
        "Energy",
        "Financial",
        "Healthcare",
        "Industrials",
        "Real Estate",
        "Technology",
        "Utilities",
    ],
    "Float Short": [
        "Any",
        "Low (<5%)",
        "High(>20%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Relative Volume": [
        "Any",
        "Over 10",
        "Over 5",
        "Over 3",
        "Over 2",
        "Over 1.5",
        "Over 1",
        "Over 0.75",
        "Over 0.5",
        "Over 0.25",
        "Under 2",
        "Under 1",
        "Under 1.5",
        "Under 1",
        "Under 0.75",
        "Under 0.5",
        "Under 0.25",
        "Under 0.1",
    ],
    "Shares Outstanding": [
        "Any",
        "Under 1M",
        "Under 5M",
        "Under 10M",
        "Under 20M",
        "Under 50M",
        "Under 100M",
        "Over 1M",
        "Over 2M",
        "Over 5M",
        "Over 10M",
        "Over 20M",
        "Over 50M",
        "Over 100M",
        "Over 200M",
        "Over 500M",
        "Over 1000M",
    ],
    "Industry": list(INDUSTRY_MAP.values()),
    "Analyst Recom.": [
        "Any",
        "Strong Buy (1)",
        "Buy or better",
        "Buy",
        "Hold or better",
        "Hold",
        "Hold or worse",
        "Sell",
        "Sell or worse",
        "Strong Sell (5)",
    ],
    "Current Volume": [
        "Any",
        "Under 100K",
        "Under 500K",
        "Under 750K",
        "Under 1M",
        "Over 0",
        "Over 50K",
        "Over 100K",
        "Over 200K",
        "Over 300K",
        "Over 400K",
        "Over 500K",
        "Over 750K",
        "Over 1M",
        "Over 2M",
        "Over 5M",
        "Over 10M",
        "Over 20M",
    ],
    "Float": [
        "Any",
        "Under 1M",
        "Under 5M",
        "Under 10M",
        "Under 20M",
        "Under 50M",
        "Under 100M",
        "Over 1M",
        "Over 2M",
        "Over 5M",
        "Over 10M",
        "Over 20M",
        "Over 50M",
        "Over 100M",
        "Over 200M",
        "Over 500M",
        "Over 1000M",
    ],
    "Country": [
        "Any",
        "Asia",
        "Europe",
        "Latin America",
        "BRIC",
        "Argentina",
        "Australia",
        "Bahamas",
        "Belgium",
        "BeNeLux",
        "Bermuda",
        "Brazil",
        "Canada",
        "Cayman Islands",
        "Chile",
        "China",
        "China & Hong Kong",
        "Colombia",
        "Cyprus",
        "Denmark",
        "Finland",
        "France",
        "Germany",
        "Greece",
        "Hong Kong",
        "Hungary",
        "Iceland",
        "Iceland",
        "India",
        "Indonesia",
        "Ireland",
        "Israel",
        "Italy",
        "Japan",
        "Kazakhstan",
        "Luxembourg",
        "Malaysia",
        "Malta",
        "Mexico",
        "Monaco",
        "Netherlands",
        "New Zealand",
        "Norway",
        "Panama",
        "Peru",
        "Philippines",
        "Portugal",
        "Russia",
        "Singapore",
        "South Africa",
        "South Korea",
        "Spain",
        "Sweden",
        "Switzerland",
        "Taiwan",
        "Turkey",
        "United Arab Emirates",
        "United Kingdom",
        "Uruguay",
        "USA",
        "Foreign (ex-USA)",
    ],
    "Option/Short": ["Any", "Optionable", "Shortable", "Optionable and shortable"],
    "Price": [
        "Any",
        "Under $1",
        "Under $2",
        "Under $3",
        "Under $4",
        "Under $5",
        "Under $7",
        "Under $10",
        "Under $15",
        "Under $20",
        "Under $30",
        "Under $40",
        "Under $50",
        "Over $1",
        "Over $2",
        "Over $3",
        "Over $4",
        "Over $5",
        "Over $7",
        "Over $10",
        "Over $15",
        "Over $20",
        "Over $30",
        "Over $40",
        "Over $50",
        "Over $60",
        "Over $70",
        "Over $80",
        "Over $90",
        "Over $100",
        "$1 to $5",
        "$1 to $10",
        "$1 to $20",
        "$5 to %10",
        "$5 to $20",
        "$5 to $50",
        "$10 to $20",
        "$10 to $50",
        "$20 to $50",
        "$50 to $100",
    ],
    "P/E": [
        "Any",
        "Low (<15)",
        "Profitable (>0)",
        "High (>50)",
        "Under 5",
        "Under 10",
        "Under 15",
        "Under 20",
        "Under 25",
        "Under 30",
        "Under 35",
        "Under 40",
        "Under 45",
        "Under 50",
        "Over 5",
        "Over 10",
        "Over 15",
        "Over 25",
        "Over 30",
        "Over 35",
        "Over 40",
        "Over 45",
        "Over 50",
    ],
    "Price/Cash": [
        "Any",
        "Low (<3)",
        "High (>50)",
        "Under 1",
        "Under 2",
        "Under 3",
        "Under 4",
        "Under 5",
        "Under 6",
        "Under 7",
        "Under 8",
        "Under 9",
        "Under 10",
        "Over 1",
        "Over 2",
        "Over 3",
        "Over 4",
        "Over 5",
        "Over 6",
        "Over 7",
        "Over 8",
        "Over 9",
        "Over 10",
        "Over 20",
        "Over 30",
        "Over 40",
        "Over 50",
    ],
    "EPS growthnext 5 years": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (<10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Return on Equity": [
        "Any",
        "Positive (>0%)",
        "Negative (<0%)",
        "Very Positive (>30%)",
        "Very Negative (<-15%)",
        "Under -50%",
        "Under -40%",
        "Under -35%",
        "Under -30%",
        "Under -25%",
        "Under -20%",
        "Under -15%",
        "Under -10%",
        "Under -5%",
        "Over +50%",
        "Over +45%",
        "Over +40%",
        "Over +35%",
        "Over +30%",
        "Over +25%",
        "Over +20%",
        "Over +15%",
        "Over +10%",
        "Over +5%",
    ],
    "Debt/Equity": [
        "Any",
        "High (>0.5)",
        "Low (<0.1)",
        "Under 1",
        "Under 0.9",
        "Under 0.8",
        "Under 0.7",
        "Under 0.6",
        "Under 0.5",
        "Under 0.4",
        "Under 0.3",
        "Under 0.2",
        "Under 0.1",
        "Over 0.1",
        "Over 0.2",
        "Over 0.3",
        "Over 0.4",
        "Over 0.5",
        "Over 0.6",
        "Over 0.7",
        "Over 0.8",
        "Over 0.9",
        "Over 1",
    ],
    "InsiderOwnership": [
        "Any",
        "Low (<5%)",
        "High (>30%)",
        "Very High (>50%)",
        "Over 10%",
        "Over 20%",
        "Over 30%",
        "Over 40%",
        "Over 50%",
        "Over 60%",
        "Over 70%",
        "Over 80%",
        "Over 90%",
    ],
    "Forward P/E": [
        "Any",
        "Low (<15)",
        "Profitable (>0)",
        "High (>50)",
        "Under 5",
        "Under 10",
        "Under 15",
        "Under 20",
        "Under 25",
        "Under 30",
        "Under 35",
        "Under 40",
        "Under 45",
        "Under 50",
        "Over 5",
        "Over 10",
        "Over 15",
        "Over 20",
        "Over 25",
        "Over 30",
        "Over 35",
        "Over 40",
        "Over 45",
        "Over 50",
    ],
    "Price/Free Cash Flow": [
        "Any",
        "Low (<15)",
        "High (>50)",
        "Under 5",
        "Under 10",
        "Under 15",
        "Under 20",
        "Under 25",
        "Under 30",
        "Under 35",
        "Under 40",
        "Under 45",
        "Under 50",
        "Under 60",
        "Under 70",
        "Under 80",
        "Under 90",
        "Under 100",
        "Over 5",
        "Over 10",
        "Over 15",
        "Over 20",
        "Over 25",
        "Over 30",
        "Over 35",
        "Over 40",
        "Over 45",
        "Over 50",
        "Over 60",
        "Over 70",
        "Over 80",
        "Over 90",
        "Over 100",
    ],
    "Sales growthpast 5 years": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (0-10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Return on Investment": [
        "Any",
        "Positive (>0%)",
        "Negative (<0%)",
        "Very Positive (>25%)",
        "Very Negative (<-10%)",
        "Under -50%",
        "Under -45%",
        "Under -40%",
        "Under -35%",
        "Under -30%",
        "Under -25%",
        "Under -20%",
        "Under -15%",
        "Under -10%",
        "Under -5%",
        "Over +5%",
        "Over +10%",
        "Over +15%",
        "Over +20%",
        "Over +25%",
        "Over +30%",
        "Over +35%",
        "Over +40%",
        "Over +45%",
        "Over +50%",
    ],
    "Gross Margin": [
        "Any",
        "Positive (>0%)",
        "Negative (<0%)",
        "High (>50%)",
        "Under 90%",
        "Under 80%",
        "Under 70%",
        "Under 60%",
        "Under 50%",
        "Under 45%",
        "Under 40%",
        "Under 35%",
        "Under 30%",
        "Under 25%",
        "Under 20%",
        "Under 15%",
        "Under 10%",
        "Under 5%",
        "Under 0%",
        "Under -10%",
        "Under -20%",
        "Under -30%",
        "Under -50%",
        "Under -70%",
        "Under -100%",
        "Over 0%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
        "Over 40%",
        "Over 45%",
        "Over 50%",
        "Over 60%",
        "Over 70%",
        "Over 80%",
        "Over 90%",
    ],
    "InsiderTransactions": [
        "Any",
        "Very Negative (<20%)",
        "Negative (<0%)",
        "Positive (>0%)",
        "Very Positive (>20%)",
        "Under -90%",
        "Under 80%",
        "Under 70%",
        "Under -60%",
        "Under -50%",
        "Under -45%",
        "Under 40%",
        "Under -35%",
        "Under -30%",
        "Under -25%",
        "Under -20%",
        "Under -15%",
        "Under -10%",
        "Under -5%",
        "Over +5%",
        "Over +10%",
        "Over +15%",
        "Over +20%",
        "Over +25%",
        "Over +30%",
        "Over +35%",
        "Over +40%",
        "Over +45%",
        "Over +50%",
        "Over +60%",
        "Over +70%",
        "Over +80%",
        "Over +90%",
    ],
    "PEG": [
        "Any",
        "Low (<1)",
        "High (>2)",
        "Under 1",
        "Under 2",
        "Under 3",
        "Over 1",
        "Over 2",
        "Over 3",
    ],
    "EPS growththis year": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (0-10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "EPS growthqtr over qtr": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (0-10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Current Ratio": [
        "Any",
        "High (>3)",
        "Low (<1)",
        "Under 1",
        "Under 0.5",
        "Over 0.5",
        "Over 1",
        "Over 1.5",
        "Over 2",
        "Over 3",
        "Over 4",
        "Over 5",
        "Over 10",
    ],
    "Operating Margin": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Very Negative (<-20%)",
        "High (>25%)",
        "Under 90%",
        "Under 80%",
        "Under 70%",
        "Under 60%",
        "Under 50%",
        "Under 45%",
        "Under 40%",
        "Under 35%",
        "Under 30%",
        "Under 25%",
        "Under 20%",
        "Under 15%",
        "Under 10%",
        "Under 5%",
        "Under 0%",
        "Under -10%",
        "Under -20%",
        "Under -30%",
        "Under -50%",
        "Under -70%",
        "Under -100%",
        "Over 0%",
        "Over 10%",
        "Under 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
        "Over 35%",
        "Over 40%",
        "Over 45%",
        "Over 50%",
        "Over 60%",
        "Over 70%",
        "Over 80%",
        "Over 90%",
    ],
    "InstitutionalOwnership": [
        "Any",
        "Low (<5%)",
        "High (>90%)",
        "Under 90%",
        "Under 80%",
        "Under 70%",
        "Under 60%",
        "Under 50%",
        "Under 40%",
        "Under 30%",
        "Under 20%",
        "Under 10%",
        "Over 10%",
        "Over 20%",
        "Over 30%",
        "Over 40%",
        "Over 50%",
        "Over 60%",
        "Over 70%",
        "Over 80%",
        "Over 90%",
    ],
    "P/S": [
        "Any",
        "Low (<1)",
        "High (>10)",
        "Under 1",
        "Under 2",
        "Under 3",
        "Under 4",
        "Under 5",
        "Under 6",
        "Under 7",
        "Under 8",
        "Under 9",
        "Under 10",
        "Over 1",
        "Over 2",
        "Over 3",
        "Over 4",
        "Over 5",
        "Over 6",
        "Over 6",
        "Over 7",
        "Over 8",
        "Over 9",
        "Over 10",
    ],
    "EPS growthnext year": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (0-10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Sales growthqtr over qtr": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (0-10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Quick Ratio": [
        "Any",
        "High (>3)",
        "Low (<0.5)",
        "Under 1",
        "Under 0.5",
        "Over 0.5",
        "Over 1",
        "Over 1.5",
        "Over 2",
        "Over 3",
        "Over 4",
        "Over 5",
        "Over 10",
    ],
    "Net Profit Margin": [
        "Any",
        "Positive (>0%)",
        "Negative (<0%)",
        "Very Negative (<-20%)",
        "High (>20%)",
        "Under 90%",
        "Under 80%",
        "Under 70%",
        "Under 60%",
        "Under 50%",
        "Under 45%",
        "Under 40%",
        "Under 35%",
        "Under 30%",
        "Under 25%",
        "Under 20%",
        "Under 15%",
        "Under 10%",
        "Under 5%",
        "Under 0%",
        "Under -10%",
        "Under -20%",
        "Under -30%",
        "Under -50%",
        "Under -70%",
        "Under -100%",
        "Over 0%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
        "Over 35%",
        "Over 40%",
        "Over 45%",
        "Over 50%",
        "Over 60%",
        "Over 70%",
        "Over 80%",
        "Over 90%",
    ],
    "InstitutionalTransactions": [
        "Any",
        "Very Negative (<20%)",
        "Negative (<0%)",
        "Positive (>0%)",
        "Very Positive (>20%)",
        "Under -50%",
        "Under -45%",
        "Under -40%",
        "Under -35%",
        "Under -30%",
        "Under -25%",
        "Under -20%",
        "Under -15%",
        "Under -10%",
        "Under -5%",
        "Over +5%",
        "Over +10%",
        "Over +15%",
        "Over +20%",
        "Over +25%",
        "Over +30%",
        "Over +35%",
        "Over +40%",
        "Over +45%",
        "Over +50%",
    ],
    "P/B": [
        "Any",
        "Low (<1)",
        "High (>5)",
        "Under 1",
        "Under 2",
        "Under 3",
        "Under 4",
        "Under 5",
        "Under 6",
        "Under 7",
        "Under 8",
        "Under 9",
        "Under 10",
        "Over 1",
        "Over 2",
        "Over 3",
        "Over 4",
        "Over 5",
        "Over 6",
        "Over 7",
        "Over 8",
        "Over 9",
        "Over 10",
    ],
    "EPS growthpast 5 years": [
        "Any",
        "Negative (<0%)",
        "Positive (>0%)",
        "Positive Low (0-10%)",
        "High (>25%)",
        "Under 5%",
        "Under 10%",
        "Under 15%",
        "Under 20%",
        "Under 25%",
        "Under 30%",
        "Over 5%",
        "Over 10%",
        "Over 15%",
        "Over 20%",
        "Over 25%",
        "Over 30%",
    ],
    "Return on Assets": [
        "Any",
        "Positive (>0%)",
        "Negative (<0%)",
        "Very Positive (>15%)",
        "Very Negative (<-15%)",
        "Under -50%",
        "Under -45%",
        "Under -40%",
        "Under -35%",
        "Under -30%",
        "Under -25%",
        "Under -20%",
        "Under -15%",
        "Under -10%",
        "Under -5%",
        "Over +5%",
        "Over +10%",
        "Over +15%",
        "Over +20%",
        "Over +25%",
        "Over +30%",
        "Over +35%",
        "Over +40%",
        "Over +45%",
        "Over +50%",
    ],
    "LT Debt/Equity": [
        "Any",
        "High (>0.5)",
        "Low (<0.1)",
        "Under 1",
        "Under 0.9",
        "Under 0.8",
        "Under 0.7",
        "Under 0.6",
        "Under 0.5",
        "Under 0.4",
        "Under 0.3",
        "Under 0.2",
        "Under 0.1",
        "Over 0.1",
        "Over 0.2",
        "Over 0.3",
        "Over 0.4",
        "Over.5",
        "Over 0.6",
        "Over 0.7",
        "Over 0.8",
        "Over 0.9",
        "Over 1",
    ],
    "Payout Ratio": [
        "Any",
        "None (0%)",
        "Positive (>0%)",
        "Low (<20%)",
        "High (>50%)",
        "Over 0%",
        "Over 10%",
        "Over 20%",
        "Over 30%",
        "Over 40%",
        "Over 50%",
        "Over 60%",
        "Over 70%",
        "Over 80%",
        "Over 90%",
        "Over 100%",
        "Under 10%",
        "Under 20%",
        "Under 30%",
        "Under 40%",
        "Under 50%",
        "Under 60%",
        "Under 70%",
        "Under 80%",
        "Under 90%",
        "Under 100%",
    ],
    "Performance": [
        "Any",
        "Today Up",
        "Today Down",
        "Today -15%",
        "Today -10%",
        "Today -5%",
        "Today +5%",
        "Today +10%",
        "Today +15%",
        "Week -30%",
        "Week -20%",
        "Week -10%",
        "Week Down",
        "Week Up",
        "Week +10%",
        "Week +20%",
        "Week +30%",
        "Month -50%",
        "Month -30%",
        "Month -20%",
        "Month -10%",
        "Month Down",
        "Month Up",
        "Month +10%",
        "Month +20%",
        "Month +30%",
        "Month +50%",
        "Quarter -50%",
        "Quarter -30%",
        "Quarter -20%",
        "Quarter -10%",
        "Quarter Down",
        "Quarter Up",
        "Quarter +10%",
        "Quarter +20%",
        "Quarter +30%",
        "Quarter +50%",
        "Half -75%",
        "Half -50%",
        "Half -30%",
        "Half -20%",
        "Half -10%",
        "Half Down",
        "Half Up",
        "Half +10%",
        "Half +20%",
        "Half +30%",
        "Half +50%",
        "Half +100%",
        "Year -75%",
        "Year -50%",
        "Year -30%",
        "Year -20%",
        "Year -10%",
        "Year Down",
        "Year Up",
        "Year +10%",
        "Year +20%",
        "Year +30%",
        "Year +50%",
        "Year +100%",
        "Year +200%",
        "Year +300%",
        "Year +500%",
        "YTD -75%",
        "YTD -50%",
        "YTD -30%",
        "YTD -20%",
        "YTD -10%",
        "YTD -5%",
        "YTD Down",
        "YTD Up",
        "YTD +5%",
        "YTD +10%",
        "YTD +20%",
        "YTD +30",
        "YTD +50%",
        "YTD +100%",
    ],
    "20-Day Simple Moving Average": [
        "Any",
        "Price below SMA20",
        "Price 10% below SMA20",
        "Price 20% below SMA20",
        "Price 30% below SMA20",
        "Price 40% below SMA20",
        "Price 50% below SMA20",
        "Price above SMA20",
        "Price 10% above SMA20",
        "Price 20% above SMA20",
        "Price 30% above SMA20",
        "Price 40% above SMA20",
        "Price 50% above SMA20",
        "Price crossed SMA20",
        "Price crossed SMA20 above",
        "Price crossed SMA20 below",
        "SMA20 crossed SMA50",
        "SMA20 crossed SMA50 above",
        "SMA20 crossed SMA50 below",
        "SMA20 cross SMA200",
        "SMA20 crossed SMA200 below",
        "SMA20 crossed SMA200 above",
        "SMA20 above SMA50",
        "SMA20 below SMA50",
        "SMA20 above SMA200",
        "SMA20 below SMA200",
    ],
    "20-Day High/Low": [
        "Any",
        "New High",
        "New Low",
        "5% or more below High",
        "10% or more below High",
        "15% or more below High",
        "20% or more below High",
        "30% or more below High",
        "40% or more below High",
        "50% or more below High",
        "0-3% below High",
        "0-5% below High",
        "0-10% below High",
        "5% or more above Low",
        "10% or more above Low",
        "15% or more above Low",
        "20% or more above Low",
        "30% or more above Low",
        "40% or more above Low",
        "50% or more above Low",
        "0-3% above Low",
        "0-5% above Low",
        "0-10% above Low",
    ],
    "Beta": [
        "Any",
        "Under 0",
        "Under 0.5",
        "Under 1",
        "Under 1.5",
        "Under 2",
        "Over 0",
        "Over 0.5",
        "Over 1",
        "Over 1.5",
        "Over 2",
        "Over 2.5",
        "Over 3",
        "Over 4",
        "0 to 0.5",
        "0 to 1",
        "0.5 to 1",
        "0.5 to 1.5",
        "1 to 1.5",
        "1 to 2",
    ],
    "Performance 2": [
        "Any",
        "Today Up",
        "Today Down",
        "Today -15%",
        "Today -10%",
        "Today -5%",
        "Today +5%",
        "Today +10%",
        "Today +15%",
        "Week -30%",
        "Week -20%",
        "Week -10%",
        "Week Down",
        "Week Up",
        "Week +10%",
        "Week +20%",
        "Week +30%",
        "Month -50%",
        "Month -30%",
        "Month -20%",
        "Month -10%",
        "Month Down",
        "Month Up",
        "Month +10%",
        "Month +20%",
        "Month +30%",
        "Month +50%",
        "Quarter -50%",
        "Quarter -30%",
        "Quarter -20%",
        "Quarter -10%",
        "Quarter Down",
        "Quarter Up",
        "Quarter +10%",
        "Quarter +20%",
        "Quarter +30%",
        "Quarter +50%",
        "Half -75%",
        "Half -50%",
        "Half -30%",
        "Half -20%",
        "Half -10%",
        "Half Down",
        "Half Up",
        "Half +10%",
        "Half +20%",
        "Half +30%",
        "Half +50%",
        "Half +100%",
        "Year -75%",
        "Year -50%",
        "Year -30%",
        "Year -20%",
        "Year -10%",
        "Year Down",
        "Year Up",
        "Year +10%",
        "Year +20%",
        "Year +30%",
        "Year +50%",
        "Year +100%",
        "Year +200%",
        "Year +300%",
        "Year +500%",
        "YTD -75%",
        "YTD -50%",
        "YTD -30%",
        "YTD -20%",
        "YTD -10%",
        "YTD -5%",
        "YTD Down",
        "YTD Up",
        "YTD +5%",
        "YTD +10%",
        "YTD +20%",
        "YTD +30",
        "YTD +50%",
        "YTD +100%",
    ],
    "50-Day Simple Moving Average": [
        "Any",
        "Price below SMA50",
        "Price 10% below SMA50",
        "Price 20% below SMA50",
        "Price 30% below SMA50",
        "Price 40% below SMA50",
        "Price 50% below SMA50",
        "Price above SMA50",
        "Price 10% above SMA50",
        "Price 20% above SMA50",
        "Price 30% above SMA50",
        "Price 40% above SMA50",
        "Price 50% above SMA50",
        "Price crossed SMA50",
        "Price crossed SMA50 above",
        "Price crossed SMA50 below",
        "SMA50 crossed SMA20",
        "SMA50 crossed SMA20 above",
        "SMA50 crossed SMA20 below",
        "SMA50 cross SMA200",
        "SMA50 crossed SMA200 below",
        "SMA50 crossed SMA200 above",
        "SMA50 above SMA20",
        "SMA50 below SMA20",
        "SMA50 above SMA200",
        "SMA50 below SMA200",
    ],
    "50-Day High/Low": [
        "Any",
        "New High",
        "New Low",
        "5% or more below High",
        "10% or more below High",
        "15% or more below High",
        "20% or more below High",
        "30% or more below High",
        "40% or more below High",
        "50% or more below High",
        "0-3% below High",
        "0-5% below High",
        "0-10% below High",
        "5% or more above Low",
        "10% or more above Low",
        "15% or more above Low",
        "20% or more above Low",
        "30% or more above Low",
        "40% or more above Low",
        "50% or more above Low",
        "0-3% above Low",
        "0-5% above Low",
        "0-10% above Low",
    ],
    "Average True Range": [
        "Any",
        "Over 0.25",
        "Over 0.5",
        "Over 0.75",
        "Over 1",
        "Over 1.5",
        "Over 2. Over 2.5",
        "Over 3",
        "Over 3.5",
        "Over 4",
        "Over 4.5",
        "Over 5",
        "Under 0.25",
        "Under 0.5",
        "Under 0.75",
        "Under 1",
        "Under 1.5",
        "Under 2",
        "Under 2.5",
        "Under 3",
        "Under 3.5",
        "Under 4",
        "Under 4.5",
        "Under 5",
    ],
    "Volatility": [
        "Any",
        "Week - Over 3%",
        "Week - Over 4%",
        "Week - Over 5%",
        "Week - 6%",
        "Week - 7%",
        "Week - 8%",
        "Week - 9%",
        "Week - 10%",
        "Week - 12%",
        "Week - 15%",
        "Month - 2%",
        "Month - 3%",
        "Month - 4%",
        "Month 5%",
        "Month 5%",
        "Month 6%",
        "Month 7%",
        "Month 8%",
        "Month 9%",
        "Month 10%",
        "Month 12%",
        "Month 15%",
    ],
    "200-Day Simple Moving Average": [
        "Any",
        "Price below SMA200",
        "Price 10% below SMA200",
        "Price 20% below SMA200",
        "Price 30% below SMA200",
        "Price 40% below SMA200",
        "Price 50% below SMA200",
        "Price above SMA200",
        "Price 10% above SMA200",
        "Price 20% above SMA200",
        "Price 30% above SMA200",
        "Price 40% above SMA200",
        "Price 50% above SMA200",
        "Price crossed SMA200",
        "Price crossed SMA200 above",
        "Price crossed SMA200 below",
        "SMA200 crossed SMA20",
        "SMA20 crossed SMA20 above",
        "SMA20 crossed SMA20 below",
        "SMA200 cross SMA50",
        "SMA200 crossed SMA50 below",
        "SMA200 crossed SMA50 above",
        "SMA200 above SMA20",
        "SMA200 below SMA20",
        "SMA200 above SMA50",
        "SMA200 below SMA50",
    ],
    "52-Week High/Low": [
        "Any",
        "New High",
        "New Low",
        "5% or more below High",
        "10% or more below High",
        "15% or more below High",
        "20% or more below High",
        "30% or more below High",
        "40% or more below High",
        "50% or more below High",
        "0-3% below High",
        "0-5% below High",
        "0-10% below High",
        "5% or more above Low",
        "10% or more above Low",
        "15% or more above Low",
        "20% or more above Low",
        "30% or more above Low",
        "40% or more above Low",
        "50% or more above Low",
        "0-3% above Low",
        "0-5% above Low",
        "0-10% above Low",
    ],
    "RSI (14)": [
        "Any",
        "Overbought (90)",
        "Overbought (80)",
        "Overbought (70)",
        "Overbought (6)",
        "Oversold (40)",
        "Oversold (30)",
        "Oversold (20)",
        "Oversold (10)",
        "Not Overbought (<60)",
        "Not Overbought (<50)",
        "Not Oversold (>50)",
        "Not Oversold (>40)",
    ],
    "Change": [
        "Any",
        "Up",
        "Up 1%",
        "Up 2%",
        "Up 3%",
        "Up 4%",
        "Up 5%",
        "Up 6%",
        "Up 7%",
        "Up 8%",
        "Up 9%",
        "Up 10%",
        "Up 15%",
        "Up 20%",
        "Down",
        "Down 1%",
        "Down 2%",
        "Down 3%",
        "Down 4%",
        "Down 5%",
        "Down 6%",
        "Down 7%",
        "Down 8%",
        "Down 9%",
        "Down 10%",
        "Down 15%",
        "Down 20%",
    ],
    "Pattern": [
        "Any",
        "Horizontal S/R",
        "Horizontal S/R (Strong)",
        "TL Resistance",
        "TL Resistance (Strong)",
        "TL Support",
        "TL Support (Strong)",
        "Wedge Up",
        "Wedge Up (Strong)",
        "Wedge Down",
        "Wedge Down (Strong)",
        "Triangle Ascending",
        "Triangle Ascending (Strong)",
        "Triangle Descending",
        "Triangle Descending (Strong)",
        "Wedge",
        "Wedge (Strong)",
        "Channel Up",
        "Channel Up (Strong)",
        "Channel Down",
        "Channel Down (Strong)",
        "Channel",
        "Channel (Strong)",
        "Double Top",
        "Double Bottom",
        "Multiple Top",
        "Multiple Bottom",
        "Head & Shoulders",
        "Head & Shoulders Inverse",
    ],
    "Gap": [
        "Any",
        "Up",
        "Up 1%",
        "Up 2%",
        "Up 3%",
        "Up 4%",
        "Up 5%",
        "Up 6%",
        "Up 7%",
        "Up 8%",
        "Up 9%",
        "Up 10%",
        "Up 15%",
        "Up 20%",
        "Down",
        "Down 1%",
        "Down 2%",
        "Down 3%",
        "Down 4%",
        "Down 5%",
        "Down 6%",
        "Down 7%",
        "Down 8%",
        "Down 9%",
        "Down 10%",
        "Down 15%",
        "Down 20%",
    ],
    "Change from Open": [
        "Any",
        "Up",
        "Up 1%",
        "Up 2%",
        "Up 3%",
        "Up 4%",
        "Up 5%",
        "Up 6%",
        "Up 7%",
        "Up 8%",
        "Up 9%",
        "Up 10%",
        "Up 15%",
        "Up 20%",
        "Down",
        "Down 1%",
        "Down 2%",
        "Down 3%",
        "Down 4%",
        "Down 5%",
        "Down 6%",
        "Down 7%",
        "Down 8%",
        "Down 9%",
        "Down 10%",
        "Down 15%",
        "Down 20%",
    ],
    "Candlestick": [
        "Any",
        "Long Lower Shadow",
        "Long Upper Shadow",
        "Hammer",
        "Inverted Hammer",
        "Spinning Top White",
        "Spinning Top Black",
        "Doji",
        "Dragonfly Doji",
        "Gravestone Doji",
        "Marubozu White",
        "Marubozu Black",
    ],
}

SIGNALS = sorted(list(d_signals))

SIGNALS_DESC_STR = ""
for k, v in sorted(d_signals_desc.items()):
    SIGNALS_DESC_STR += f"\n        {k}: {v}"


SECTOR_MAP = {
    "all": "Any",
    "energy": "Energy",
    "materials": "Basic Materials",
    "industrials": "Industrials",
    "consumer_cyclical": "Consumer Cyclical",
    "consumer_defensive": "Consumer Defensive",
    "financial": "Financial",
    "healthcare": "Healthcare",
    "technology": "Technology",
    "communication_services": "Communication Services",
    "utilities": "Utilities",
    "real_estate": "Real Estate",
}

Sectors = Literal[
    "all",
    "energy",
    "materials",
    "industrials",
    "consumer_cyclical",
    "consumer_defensive",
    "financial",
    "healthcare",
    "technology",
    "communication_services",
    "utilities",
    "real_estate",
]

EXCHANGE_MAP = {
    "all": "Any",
    "amex": "AMEX",
    "nasdaq": "NASDAQ",
    "nyse": "NYSE",
}

INDEX_MAP = {
    "all": "Any",
    "dow": "DJIA",
    "sp500": "S&P 500",
    "nasdaq": "NASDAQ 100",
    "russell": "RUSSELL 2000",
}


def get_preset_choices(user_data_path) -> Dict:
    """Get a combined map of default and user screener presets."""
    # pylint: disable=import-outside-toplevel
    import shutil
    from pathlib import Path
    from warnings import warn

    PRESETS_PATH = Path(user_data_path) / "presets" / "finviz"
    PRESETS_PATH_DEFAULT = Path(__file__).parent.resolve() / "presets"
    preset_choices: Dict = {}

    if PRESETS_PATH_DEFAULT.exists():
        preset_choices.update(
            {
                filepath.name.replace(".ini", ""): filepath
                for filepath in PRESETS_PATH_DEFAULT.iterdir()
                if filepath.suffix == ".ini"
            }
        )

    try:
        # Create the user presets directory if it doesn't exist.
        if not PRESETS_PATH.exists():
            PRESETS_PATH.mkdir(parents=True, exist_ok=True)

        # Copy any missing default presets to the user presets directory.
        for filepath in PRESETS_PATH_DEFAULT.iterdir():
            if filepath.suffix == ".ini":
                target_path = PRESETS_PATH / filepath.name
                if not target_path.exists():
                    shutil.copy(filepath, target_path)

        # Override any default paths to the user path, if they exist.
        if PRESETS_PATH.exists():
            preset_choices.update(
                {
                    filepath.name.replace(".ini", ""): filepath
                    for filepath in PRESETS_PATH.iterdir()
                    if filepath.suffix == ".ini"
                }
            )
    except Exception as e:
        warn(f"Error loading user presets: {e}")

    preset_choices = {
        k: v for k, v in sorted(preset_choices.items()) if k != "screener_template"
    }

    return preset_choices
