import { IPrincipal, ServicePrincipalOpts } from './principals';
/**
 * Represents a statement in an IAM policy document.
 */
export declare class PolicyStatement {
    /**
     * Creates a new PolicyStatement based on the object provided.
     * This will accept an object created from the `.toJSON()` call
     * @param obj the PolicyStatement in object form.
     */
    static fromJson(obj: any): PolicyStatement;
    /**
     * Statement ID for this statement
     */
    sid?: string;
    effect: Effect;
    private readonly action;
    private readonly notAction;
    private readonly principal;
    private readonly notPrincipal;
    private readonly resource;
    private readonly notResource;
    private readonly condition;
    constructor(props?: PolicyStatementProps);
    addActions(...actions: string[]): void;
    addNotActions(...notActions: string[]): void;
    /**
     * Indicates if this permission has a "Principal" section.
     */
    get hasPrincipal(): boolean;
    addPrincipals(...principals: IPrincipal[]): void;
    addNotPrincipals(...notPrincipals: IPrincipal[]): void;
    addAwsAccountPrincipal(accountId: string): void;
    addArnPrincipal(arn: string): void;
    /**
     * Adds a service principal to this policy statement.
     *
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`).
     * @param opts    options for adding the service principal (such as specifying a principal in a different region)
     */
    addServicePrincipal(service: string, opts?: ServicePrincipalOpts): void;
    addFederatedPrincipal(federated: any, conditions: {
        [key: string]: any;
    }): void;
    addAccountRootPrincipal(): void;
    addCanonicalUserPrincipal(canonicalUserId: string): void;
    addAnyPrincipal(): void;
    addResources(...arns: string[]): void;
    addNotResources(...arns: string[]): void;
    /**
     * Adds a ``"*"`` resource to this statement.
     */
    addAllResources(): void;
    /**
     * Indicates if this permission as at least one resource associated with it.
     */
    get hasResource(): boolean;
    /**
     * Add a condition to the Policy
     */
    addCondition(key: string, value: any): void;
    /**
     * Add multiple conditions to the Policy
     */
    addConditions(conditions: {
        [key: string]: any;
    }): void;
    /**
     * Add a condition that limits to a given account
     */
    addAccountCondition(accountId: string): void;
    toStatementJson(): any;
    toString(): string;
    /**
     * JSON-ify the statement
     *
     * Used when JSON.stringify() is called
     */
    toJSON(): any;
}
export declare enum Effect {
    ALLOW = "Allow",
    DENY = "Deny"
}
/**
 * Interface for creating a policy statement
 */
export interface PolicyStatementProps {
    /**
     * The Sid (statement ID) is an optional identifier that you provide for the
     * policy statement. You can assign a Sid value to each statement in a
     * statement array. In services that let you specify an ID element, such as
     * SQS and SNS, the Sid value is just a sub-ID of the policy document's ID. In
     * IAM, the Sid value must be unique within a JSON policy.
     *
     * @default - no sid
     */
    readonly sid?: string;
    /**
     * List of actions to add to the statement
     *
     * @default - no actions
     */
    readonly actions?: string[];
    /**
     * List of not actions to add to the statement
     *
     * @default - no not-actions
     */
    readonly notActions?: string[];
    /**
     * List of principals to add to the statement
     *
     * @default - no principals
     */
    readonly principals?: IPrincipal[];
    /**
     * List of not principals to add to the statement
     *
     * @default - no not principals
     */
    readonly notPrincipals?: IPrincipal[];
    /**
     * Resource ARNs to add to the statement
     *
     * @default - no resources
     */
    readonly resources?: string[];
    /**
     * NotResource ARNs to add to the statement
     *
     * @default - no not-resources
     */
    readonly notResources?: string[];
    /**
     * Conditions to add to the statement
     *
     * @default - no condition
     */
    readonly conditions?: {
        [key: string]: any;
    };
    /**
     * Whether to allow or deny the actions in this statement
     *
     * @default - allow
     */
    readonly effect?: Effect;
}
