# coding: utf-8

"""
    Swagger Petstore - OpenAPI 3.0

    This is a sample Pet Store Server based on the OpenAPI 3.0 specification.  You can find out more about Swagger at [http://swagger.io](http://swagger.io). In the third iteration of the pet store, we've switched to the design first approach! You can now help us improve the API whether it's by making changes to the definition itself or to the code. That way, with time, we can improve the API in general, and expose some of the new features in OAS3.  Some useful links: - [The Pet Store repository](https://github.com/swagger-api/swagger-petstore) - [The source API definition for the Pet Store](https://github.com/swagger-api/swagger-petstore/blob/master/src/main/resources/openapi.yaml)

    The version of the OpenAPI document: 1.0.19
    Contact: apiteam@swagger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from petstore_trilogy.models.user import User

from petstore_trilogy.api_client import ApiClient, RequestSerialized
from petstore_trilogy.api_response import ApiResponse
from petstore_trilogy.rest import RESTResponseType


class UserApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_user(
        self,
        user: Annotated[Optional[User], Field(description="Created user object")] = None,
    ) -> User:
        """Create user

        This can only be done by the logged in user.

        :param user: Created user object
        :type user: User
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_serialize(
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_user_with_http_info(
        self,
        user: Annotated[Optional[User], Field(description="Created user object")] = None,
    ) -> ApiResponse[User]:
        """Create user

        This can only be done by the logged in user.

        :param user: Created user object
        :type user: User
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_serialize(
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_user_without_preload_content(
        self,
        user: Annotated[Optional[User], Field(description="Created user object")] = None,
    ) -> RESTResponseType:
        """Create user

        This can only be done by the logged in user.

        :param user: Created user object
        :type user: User
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_serialize(
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _create_user_serialize(
        self,
        user,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user is not None:
            _body_params = user


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/xml'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/xml', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_users_with_list_input(
        self,
        user: Optional[List[User]] = None,
    ) -> User:
        """Creates list of users with given input array

        Creates list of users with given input array

        :param user:
        :type user: List[User]
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_users_with_list_input_serialize(
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_users_with_list_input_with_http_info(
        self,
        user: Optional[List[User]] = None,
    ) -> ApiResponse[User]:
        """Creates list of users with given input array

        Creates list of users with given input array

        :param user:
        :type user: List[User]
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_users_with_list_input_serialize(
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_users_with_list_input_without_preload_content(
        self,
        user: Optional[List[User]] = None,
    ) -> RESTResponseType:
        """Creates list of users with given input array

        Creates list of users with given input array

        :param user:
        :type user: List[User]
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_users_with_list_input_serialize(
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _create_users_with_list_input_serialize(
        self,
        user,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'User': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user is not None:
            _body_params = user


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user/createWithList',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_user(
        self,
        username: Annotated[StrictStr, Field(description="The name that needs to be deleted")],
    ) -> None:
        """Delete user

        This can only be done by the logged in user.

        :param username: The name that needs to be deleted (required)
        :type username: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_serialize(
            username=username,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_user_with_http_info(
        self,
        username: Annotated[StrictStr, Field(description="The name that needs to be deleted")],
    ) -> ApiResponse[None]:
        """Delete user

        This can only be done by the logged in user.

        :param username: The name that needs to be deleted (required)
        :type username: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_serialize(
            username=username,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_user_without_preload_content(
        self,
        username: Annotated[StrictStr, Field(description="The name that needs to be deleted")],
    ) -> RESTResponseType:
        """Delete user

        This can only be done by the logged in user.

        :param username: The name that needs to be deleted (required)
        :type username: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_serialize(
            username=username,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _delete_user_serialize(
        self,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user/{username}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_user_by_name(
        self,
        username: Annotated[StrictStr, Field(description="The name that needs to be fetched. Use user1 for testing. ")],
    ) -> User:
        """Get user by user name

        

        :param username: The name that needs to be fetched. Use user1 for testing.  (required)
        :type username: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_name_serialize(
            username=username,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_user_by_name_with_http_info(
        self,
        username: Annotated[StrictStr, Field(description="The name that needs to be fetched. Use user1 for testing. ")],
    ) -> ApiResponse[User]:
        """Get user by user name

        

        :param username: The name that needs to be fetched. Use user1 for testing.  (required)
        :type username: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_name_serialize(
            username=username,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_user_by_name_without_preload_content(
        self,
        username: Annotated[StrictStr, Field(description="The name that needs to be fetched. Use user1 for testing. ")],
    ) -> RESTResponseType:
        """Get user by user name

        

        :param username: The name that needs to be fetched. Use user1 for testing.  (required)
        :type username: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_name_serialize(
            username=username,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _get_user_by_name_serialize(
        self,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user/{username}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def login_user(
        self,
        username: Annotated[Optional[StrictStr], Field(description="The user name for login")] = None,
        password: Annotated[Optional[StrictStr], Field(description="The password for login in clear text")] = None,
    ) -> str:
        """Logs user into the system

        

        :param username: The user name for login
        :type username: str
        :param password: The password for login in clear text
        :type password: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._login_user_serialize(
            username=username,
            password=password,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def login_user_with_http_info(
        self,
        username: Annotated[Optional[StrictStr], Field(description="The user name for login")] = None,
        password: Annotated[Optional[StrictStr], Field(description="The password for login in clear text")] = None,
    ) -> ApiResponse[str]:
        """Logs user into the system

        

        :param username: The user name for login
        :type username: str
        :param password: The password for login in clear text
        :type password: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._login_user_serialize(
            username=username,
            password=password,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def login_user_without_preload_content(
        self,
        username: Annotated[Optional[StrictStr], Field(description="The user name for login")] = None,
        password: Annotated[Optional[StrictStr], Field(description="The password for login in clear text")] = None,
    ) -> RESTResponseType:
        """Logs user into the system

        

        :param username: The user name for login
        :type username: str
        :param password: The password for login in clear text
        :type password: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._login_user_serialize(
            username=username,
            password=password,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _login_user_serialize(
        self,
        username,
        password,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if username is not None:
            
            _query_params.append(('username', username))
            
        if password is not None:
            
            _query_params.append(('password', password))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user/login',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def logout_user(
        self,
    ) -> None:
        """Logs out current logged in user session

        

        :return: Returns the result object.
        """ # noqa: E501

        _param = self._logout_user_serialize(
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def logout_user_with_http_info(
        self,
    ) -> ApiResponse[None]:
        """Logs out current logged in user session

        

        :return: Returns the result object.
        """ # noqa: E501

        _param = self._logout_user_serialize(
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def logout_user_without_preload_content(
        self,
    ) -> RESTResponseType:
        """Logs out current logged in user session

        

        :return: Returns the result object.
        """ # noqa: E501

        _param = self._logout_user_serialize(
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _logout_user_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user/logout',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_user(
        self,
        username: Annotated[StrictStr, Field(description="name that needs to be updated")],
        user: Annotated[Optional[User], Field(description="Update an existent user in the store")] = None,
    ) -> None:
        """Update user

        This can only be done by the logged in user.

        :param username: name that needs to be updated (required)
        :type username: str
        :param user: Update an existent user in the store
        :type user: User
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_user_serialize(
            username=username,
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_user_with_http_info(
        self,
        username: Annotated[StrictStr, Field(description="name that needs to be updated")],
        user: Annotated[Optional[User], Field(description="Update an existent user in the store")] = None,
    ) -> ApiResponse[None]:
        """Update user

        This can only be done by the logged in user.

        :param username: name that needs to be updated (required)
        :type username: str
        :param user: Update an existent user in the store
        :type user: User
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_user_serialize(
            username=username,
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_user_without_preload_content(
        self,
        username: Annotated[StrictStr, Field(description="name that needs to be updated")],
        user: Annotated[Optional[User], Field(description="Update an existent user in the store")] = None,
    ) -> RESTResponseType:
        """Update user

        This can only be done by the logged in user.

        :param username: name that needs to be updated (required)
        :type username: str
        :param user: Update an existent user in the store
        :type user: User
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_user_serialize(
            username=username,
            user=user,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None
        )
        return response_data.response


    def _update_user_serialize(
        self,
        username,
        user,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user is not None:
            _body_params = user



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/xml', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/user/{username}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


