# SPDX-FileCopyrightText: 2024 Justin Myers
#
# SPDX-License-Identifier: MIT
"""
Board stub for CrowPanel 4.2 EPaper
 - port: espressif
 - board_id: elecrow_crowpanel_4_2_epaper
 - NVM size: 8192
 - Included modules: _asyncio, _bleio, _bleio (native), _eve, _pixelmap, adafruit_bus_device, adafruit_pixelbuf, aesio, alarm, analogbufio, analogio, array, atexit, audiobusio, audiocore, audiomixer, audiomp3, binascii, bitbangio, bitmapfilter, bitmaptools, board, builtins, builtins.pow3, busdisplay, busio, busio.SPI, busio.UART, canio, codeop, collections, countio, digitalio, displayio, epaperdisplay, errno, espcamera, espidf, espnow, espulp, fontio, fourwire, framebufferio, frequencyio, getpass, gifio, hashlib, i2cdisplaybus, io, ipaddress, jpegio, json, keypad, keypad.KeyMatrix, keypad.Keys, keypad.ShiftRegisterKeys, keypad_demux, keypad_demux.DemuxKeyMatrix, locale, lvfontio, math, max3421e, mdns, memorymap, microcontroller, msgpack, neopixel_write, nvm, onewireio, os, os.getenv, paralleldisplaybus, ps2io, pulseio, pwmio, qrio, rainbowio, random, re, rgbmatrix, rotaryio, rtc, sdcardio, sdioio, select, sharpdisplay, socketpool, socketpool.socketpool.AF_INET6, ssl, storage, struct, supervisor, synthio, sys, terminalio, tilepalettemapper, time, touchio, traceback, ulab, usb, vectorio, warnings, watchdog, wifi, zlib
 - Frozen libraries: 
"""

# Imports
import busio
import displayio
import microcontroller


# Board Info:
board_id: str


# Pins:
BUTTON_BOOT: microcontroller.Pin  # GPIO0
BUTTON_EXIT: microcontroller.Pin  # GPIO1
BUTTON_MENU: microcontroller.Pin  # GPIO2
ROCKER_DOWN: microcontroller.Pin  # GPIO4
ROCKER_CLICK: microcontroller.Pin  # GPIO5
ROCKER_UP: microcontroller.Pin  # GPIO6
LED: microcontroller.Pin  # GPIO41
EPD_ENABLE: microcontroller.Pin  # GPIO7
TF_ENABLE: microcontroller.Pin  # GPIO42
EPD_BUSY: microcontroller.Pin  # GPIO48
EPD_RES: microcontroller.Pin  # GPIO47
EPD_DC: microcontroller.Pin  # GPIO46
EPD_CS: microcontroller.Pin  # GPIO45
EPD_CLK: microcontroller.Pin  # GPIO12
EPD_MOSI: microcontroller.Pin  # GPIO11
TF_CS: microcontroller.Pin  # GPIO10
TF_MOSI: microcontroller.Pin  # GPIO40
TF_CLK: microcontroller.Pin  # GPIO39
TF_MISO: microcontroller.Pin  # GPIO13
IO3: microcontroller.Pin  # GPIO3
IO8: microcontroller.Pin  # GPIO8
IO9: microcontroller.Pin  # GPIO9
IO14: microcontroller.Pin  # GPIO14
IO15: microcontroller.Pin  # GPIO15
IO16: microcontroller.Pin  # GPIO16
IO17: microcontroller.Pin  # GPIO17
IO18: microcontroller.Pin  # GPIO18
IO19: microcontroller.Pin  # GPIO19
IO20: microcontroller.Pin  # GPIO20
IO21: microcontroller.Pin  # GPIO21
IO38: microcontroller.Pin  # GPIO38
TX: microcontroller.Pin  # GPIO43
RX: microcontroller.Pin  # GPIO44


# Members:
def UART() -> busio.UART:
    """Returns the `busio.UART` object for the board's designated UART bus(es).
    The object created is a singleton, and uses the default parameter values for `busio.UART`.
    """

"""Returns the `displayio.Display` object for the board's built in display.
The object created is a singleton, and uses the default parameter values for `displayio.Display`.
"""
DISPLAY: displayio.Display


# Unmapped:
#   none
