
import logging

logger = logging.getLogger("SoIdea-update-python.events")


class UpdateEvent:
    """
    升级事件钩子管理类，支持注册/执行 pre/post/fail 钩子。
    """
    def __init__(self):
        self.pre_update_hooks = []
        self.post_update_hooks = []
        self.fail_update_hooks = []

    def register_pre_update(self, func):
        self.pre_update_hooks.append(func)

    def register_post_update(self, func):
        self.post_update_hooks.append(func)

    def register_fail_update(self, func):
        self.fail_update_hooks.append(func)

    def run_pre_update(self, *args, **kwargs):
        for hook in self.pre_update_hooks:
            try:
                hook(*args, **kwargs)
            except Exception as e:
                logger.error(f"pre_update hook error: {e}")

    def run_post_update(self, *args, **kwargs):
        for hook in self.post_update_hooks:
            try:
                hook(*args, **kwargs)
            except Exception as e:
                logger.error(f"post_update hook error: {e}")

    def run_fail_update(self, *args, **kwargs):
        for hook in self.fail_update_hooks:
            try:
                hook(*args, **kwargs)
            except Exception as e:
                logger.error(f"fail_update hook error: {e}")
