
"""
SoIdea-update-python Git 工具模块
支持自动初始化仓库、提交、打 tag
"""

import os
import subprocess


def ensure_git_repo(repo_dir, logger):
    """
    检查并自动初始化 git 仓库。
    :param repo_dir: 仓库目录
    :param logger: 日志对象
    :return: 是否成功
    """
    git_dir = os.path.join(repo_dir, '.git')
    if not os.path.exists(git_dir):
        logger.info('未检测到 git 仓库，自动初始化...')
        try:
            subprocess.run(['git', 'init'], cwd=repo_dir, check=True)
            logger.info('已初始化 git 仓库')
        except Exception as e:
            logger.warning(f'git init 失败: {e}')
            return False
    return True

def git_commit_all(repo_dir, msg, logger):
    """
    提交所有更改到 git。
    :param repo_dir: 仓库目录
    :param msg: 提交信息
    :param logger: 日志对象
    """
    try:
        subprocess.run(['git', 'add', '.'], cwd=repo_dir, check=True)
        subprocess.run(['git', 'commit', '-m', msg], cwd=repo_dir, check=True)
        logger.info(f'已提交 git commit: {msg}')
    except Exception as e:
        logger.warning(f'git commit 失败: {e}')

def git_tag(repo_dir, tag, logger):
    """
    打 git tag。
    :param repo_dir: 仓库目录
    :param tag: tag 名称
    :param logger: 日志对象
    """
    try:
        subprocess.run(['git', 'tag', tag], cwd=repo_dir, check=True)
        logger.info(f'已打 git tag: {tag}')
    except Exception as e:
        logger.warning(f'git tag 失败: {e}')
