"""
参数优先级控制工具：支持命令行/配置文件/默认参数三层优先级，并可通过常量开关控制。
"""
from .constants import ENABLE_CMD_ARGS, ENABLE_DEFAULT_ARGS


def get_param(cmd_value, config_value, default_value):
    """
    参数优先级控制：命令行 > 配置文件 > 默认参数
    受 ENABLE_CMD_ARGS 和 ENABLE_DEFAULT_ARGS 控制
    """
    if ENABLE_CMD_ARGS and cmd_value is not None:
        return cmd_value
    if config_value is not None:
        return config_value
    if ENABLE_DEFAULT_ARGS:
        return default_value
    return None
