# pylint: disable=invalid-name
# Generated by Django 3.2.16 on 2023-02-17 11:32

import uuid

import django.core.serializers.json
import django.db.models.deletion
import nautobot.extras.models.mixins
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("dcim", "0019_device_redundancy_group_data_migration"),
    ]

    operations = [
        migrations.CreateModel(
            name="DeviceResource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("cpu", models.CharField(blank=True, max_length=200)),
                ("cpu_cores", models.CharField(blank=True, max_length=20)),
                ("gpu", models.CharField(blank=True, max_length=200)),
                ("ram", models.IntegerField(blank=True, null=True)),
                ("disks", models.CharField(blank=True, max_length=200)),
                (
                    "device",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE, related_name="resources", to="dcim.device"
                    ),
                ),
            ],
            options={
                "ordering": ["device"],
                "verbose_name": "Device Resource",
                "verbose_name_plural": "Device Resources",
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
    ]
