# pylint: disable=invalid-name
# Generated by Django 3.2.16 on 2023-02-17 11:33

from django.db import migrations


def create_device_resources(apps, schema_editor):
    """Create DeviceResource instance for all existing Devices"""
    Device = apps.get_model("dcim", "Device")
    DeviceResource = apps.get_model("nautobot_device_resources", "DeviceResource")

    db_alias = schema_editor.connection.alias

    for device in Device.objects.using(db_alias).all():
        resource = DeviceResource(device=device)
        resource.save()


def clear_device_resources(apps, schema_editor):
    """Clear all DeviceResource instances in DB"""
    DeviceResource = apps.get_model("nautobot_device_resources", "DeviceResource")

    db_alias = schema_editor.connection.alias

    for resource in DeviceResource.objects.using(db_alias).all():
        resource.delete()


class Migration(migrations.Migration):
    dependencies = [
        ("nautobot_device_resources", "0002_cpu_separate_model"),
    ]

    operations = [migrations.RunPython(create_device_resources, clear_device_resources)]
