// Generated by paddle/phi/api/generator/tensor_operants_gen.py

#pragma once

#include "paddle/phi/api/include/tensor.h"
#include "paddle/phi/common/scalar.h"
#include "paddle/phi/common/int_array.h"


namespace paddle {

namespace operants {

using Tensor = paddle::Tensor;
using Scalar = paddle::experimental::Scalar;
using IntArray = paddle::experimental::IntArray;

class TensorOperantsBase {
 public:
  virtual ~TensorOperantsBase() = default;

  virtual Tensor add(const Tensor& x, const Scalar& y) = 0;

  virtual Tensor divide(const Tensor& x, const Scalar& y) = 0;

  virtual Tensor multiply(const Tensor& x, const Scalar& y) = 0;

  virtual Tensor subtract(const Tensor& x, const Scalar& y) = 0;

  virtual Tensor add(const Scalar& x, const Tensor& y) = 0;

  virtual Tensor divide(const Scalar& x, const Tensor& y) = 0;

  virtual Tensor multiply(const Scalar& x, const Tensor& y) = 0;

  virtual Tensor subtract(const Scalar& x, const Tensor& y) = 0;

  virtual Tensor pow(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor pow(const Tensor& x, const Scalar& y) = 0;

  virtual Tensor abs(const Tensor& x) = 0;

  virtual Tensor bitwise_and(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor bitwise_not(const Tensor& x) = 0;

  virtual Tensor bitwise_or(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor bitwise_xor(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor exp(const Tensor& x) = 0;

  virtual Tensor expand(const Tensor& x, const IntArray& shape = {}) = 0;

  virtual Tensor floor(const Tensor& x) = 0;

  virtual Tensor gather_nd(const Tensor& x, const Tensor& index) = 0;

  virtual Tensor log(const Tensor& x) = 0;

  virtual Tensor max(const Tensor& x, const IntArray& axis = {}, bool keepdim = false) = 0;

  virtual Tensor roll(const Tensor& x, const IntArray& shifts = {}, const std::vector<int64_t>& axis = {}) = 0;

  virtual Tensor scale(const Tensor& x, const Scalar& scale = 1.0, const Scalar& bias = 0.0, bool bias_after_scale = true) = 0;

  virtual Tensor scatter(const Tensor& x, const Tensor& index, const Tensor& updates, bool overwrite = true) = 0;

  virtual Tensor scatter_nd_add(const Tensor& x, const Tensor& index, const Tensor& updates) = 0;

  virtual Tensor sum(const Tensor& x, const IntArray& axis = {}, DataType dtype = DataType::UNDEFINED, bool keepdim = false) = 0;

  virtual Tensor add(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor assign(const Tensor& x) = 0;

  virtual Tensor divide(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor elementwise_pow(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor equal(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor greater_equal(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor greater_than(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor less_equal(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor less_than(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor matmul(const Tensor& x, const Tensor& y, bool transpose_x = false, bool transpose_y = false) = 0;

  virtual Tensor maximum(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor minimum(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor multiply(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor not_equal(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor subtract(const Tensor& x, const Tensor& y) = 0;

  virtual Tensor tile(const Tensor& x, const IntArray& repeat_times = {}) = 0;
};

}  // namespace operants
}  // namespace paddle

