MRA_V2_LEEF_MAPPING = (
    # General
    ("change_type", "changeType"),
    ("created_time", "createdTime"),
    ("enterprise_guid", "lookoutEnterpriseGuid"),
    ("id", "lookoutId"),
    ("type", "eventType"),
    ("target.guid", "targetGuid"),
    ("target.type", "targetType"),
    ("actor.guid", "actorGuid"),
    ("actor.type", "actorType"),
    # Audit Event
    ("audit.attribute_changes", "attributeChanges"),
    ("audit.type", "auditType"),
    # Device Event
    ("device.guid", "lookoutDeviceGuid"),
    ("device.platform", "devicePlatform"),
    ("device.profile_type", "deviceProfileType"),
    ("device.client.lookout_sdk_version", "lookoutClientSDKVersion"),
    ("device.client.ota_version", "lookoutClientOTAVersion"),
    (
        "device.client.package_name",
        "device.client.package_version",
        "lookoutClientPackageDetails",
        lambda name, version: f"{name}-{version}",
    ),
    ("device.hardware.manufacturer", "deviceManufacturer"),
    ("device.hardware.model", "deviceModel"),
    ("device.info.customer_device_id", "customerDeviceId"),
    ("device.info.device_group_guids", "lookoutDeviceGroupGuids"),
    ("device.info.email", "deviceEmail"),
    ("device.info.external_id", "externalId"),
    ("device.info.mdm_connector_id", "LookoutMdmConnectorId"),
    ("device.info.mdm_type", "mdmType"),
    ("device.info.previous_device_group_guids", "previousDeviceGroupGuids"),
    ("device.parent_status.activation_status", "parentActivationStatus"),
    ("device.parent_status.parent_device_guid", "parentDeviceGuid"),
    ("device.parent_status.protection_status", "parentProtectionStatus"),
    ("device.parent_status.security_status", "parentSecurityStatus"),
    ("device.software.latest_os_version", "latestOSVersion"),
    ("device.software.latest_security_patch_level", "latestSecurityPatch"),
    ("device.software.os_version", "OSVersion"),
    ("device.software.os_version_date", "OSVersionDate"),
    ("device.software.os_version_rsr", "OSVersionRSR"),
    ("device.software.sdk_version", "SDKVersion"),
    ("device.software.security_patch_level", "securityPatch"),
    ("device.status.activation_status", "activationStatus"),
    ("device.status.checkin_time", "checkinTime"),
    ("device.status.protection_status", "protectionStatus"),
    ("device.status.security_status", "securityStatus"),
    # Threat Event
    ("threat.guid", "lookoutThreatGuid"),
    ("threat.severity", "threatSeverity"),  # TODO: map this to 1-10 to match QRadar `sev` field
    ("threat.type", "threatType"),
    ("threat.classifications", "threatClassifications"),
    ("threat.assessments", "threatAssessments"),
    ("threat.details.dns_ip_addresses", "dnsIpAddresses"),
    ("threat.details.file_name", "fileName"),
    ("threat.details.latest_agent_config", "latestAgentConfig"),
    ("threat.details.latest_os_version", "latestOSVersion"),
    ("threat.details.mac_address", "threatMacAddress"),
    ("threat.details.minimum_os_version", "threatMinOSVersion"),
    ("threat.details.network_ssid", "networkSSID"),
    ("threat.details.os_version", "OSVersion"),  # shared with device.software.os_version
    (
        "threat.details.application_name",
        "threat.details.package_name",
        "threatAppPackageDetails",
        lambda app, pack: f"{app}, {pack}",
    ),
    ("threat.details.package_sha", "threatAppPackageSHA"),
    ("threat.details.path", "path"),
    ("threat.details.proxy_address", "proxyAddress"),
    ("threat.details.proxy_port", "proxyPort"),
    ("threat.details.proxy_protocol", "proxyProtocol"),
    ("threat.details.reason", "threatReason"),
    ("threat.details.response", "threatResponse"),
    ("threat.details.trusted_signing_identity", "trustedSigningId"),
    ("threat.details.url", "url"),
    ("threat.details.user_response", "threatUserResponse"),
    ("threat.details.version_type", "threatVersionType"),
    ("threat.details.vpn_local_address", "vpnLocalAddress"),
    (
        "threat.details.vpn_present",
        "vpnPresent",
        lambda present: 1 if present else 0,
    ),
    ("threat.details.network.access_point_hostname", "accessPointHostname"),
    (
        "threat.details.network.connected",
        "networkConnected",
        lambda connected: 1 if connected else 0,
    ),
    ("threat.details.network.dns_ip_address", "dnsIpAddress"),
    ("threat.details.network.network_name", "networkName"),
    ("threat.details.network.network_type", "networkType"),
    ("threat.details.network.proxy_config", "proxyConfig"),
    ("threat.details.network.vpn_configuration", "vpnConfiguration"),
    ("threat.details.network.wifi_bssid", "wifiBSsid"),
)
