import os
svg_by_type={
    'git':'<svg t="1595640565871" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2073" width="16" height="16"><path d="M110.933333 451.84L357.546667 204.8l72.106666 72.533333c-10.24 36.266667 6.4 75.946667 39.68 95.146667v236.373333c-25.6 14.506667-42.666667 42.24-42.666666 73.813334a85.333333 85.333333 0 0 0 85.333333 85.333333 85.333333 85.333333 0 0 0 85.333333-85.333333c0-31.573333-17.066667-59.306667-42.666666-73.813334V401.493333l88.32 89.173334c-2.986667 6.4-2.986667 13.653333-2.986667 21.333333a85.333333 85.333333 0 0 0 85.333333 85.333333 85.333333 85.333333 0 0 0 85.333334-85.333333 85.333333 85.333333 0 0 0-85.333334-85.333333c-7.68 0-14.933333 0-21.333333 2.986666L594.346667 320a84.48 84.48 0 0 0-49.066667-99.84c-18.346667-6.826667-37.546667-8.533333-54.613333-3.84L418.133333 144.213333l33.706667-33.28c33.28-33.706667 87.04-33.706667 120.32 0l340.906667 340.906667c33.706667 33.28 33.706667 87.04 0 120.32l-340.906667 340.906667c-33.28 33.706667-87.04 33.706667-120.32 0L110.933333 572.16c-33.706667-33.28-33.706667-87.04 0-120.32z" fill="#E64A19" p-id="2074"></path></svg>',
    'jquery':'<svg t="1595640977216" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="9448" width="16" height="16"><path d="M65.44 250.624c-90.592 130.144-79.36 299.392-10.112 437.6 1.568 3.36 3.328 6.56 5.024 9.76 0.992 2.208 2.08 4.256 3.296 6.368 0.544 1.184 1.312 2.432 2.016 3.552 1.12 2.208 2.304 4.352 3.456 6.496l6.688 11.296c1.248 2.08 2.432 4.128 3.84 6.24 2.336 4 5.12 7.968 7.552 12 1.12 1.664 2.144 3.328 3.36 4.992 4.736 7.424 9.088 13.6 13.696 19.584l-0.48-0.64c3.328 4.576 6.656 8.992 10.24 13.44 1.152 1.632 2.432 3.232 3.616 4.864l9.44 11.488c1.152 1.312 2.304 2.848 3.552 4.224 4.192 5.024 8.608 9.952 13.056 14.88 0 0.096 0.128 0.16 0.224 0.288 5.504 6.944 11.456 13.088 17.92 18.624l0.192 0.16c3.424 3.488 6.816 7.008 10.464 10.4l4.32 4.128c4.736 4.448 9.472 8.864 14.464 13.152 0.096 0 0.128 0.096 0.224 0.128l2.432 2.144c4.352 3.808 8.736 7.584 13.216 11.104l5.344 4.48c3.616 2.912 7.392 5.664 11.104 8.544l5.792 4.448c3.968 2.976 8.192 5.92 12.256 8.832 1.504 1.056 2.976 2.144 4.512 3.104l1.248 0.992 12 7.904 5.12 3.424c6.272 4 12.512 7.808 18.688 11.552 1.792 0.896 3.584 1.888 5.248 2.912 4.608 2.656 9.376 5.344 14.048 7.808 2.56 1.44 5.216 2.688 7.84 4 3.2 1.792 6.528 3.552 9.952 5.344a12.384 12.384 0 0 1 2.464 1.024l-0.064-0.032c1.408 0.64 2.72 1.312 4.096 2.016 5.12 2.56 10.464 4.992 16 7.424 1.024 0.416 2.144 0.864 3.232 1.44 6.144 2.688 12.288 5.248 18.656 7.776 1.44 0.416 2.976 1.152 4.48 1.696 5.76 2.176 11.68 4.384 17.536 6.496l2.144 0.768c6.528 2.208 12.96 4.352 19.584 6.4 1.536 0.416 3.104 0.992 4.736 1.408 6.784 2.048 13.344 4.48 20.192 5.792 437.76 79.776 564.992-263.2 564.992-263.2-106.88 139.168-296.544 175.872-476.16 135.04-6.656-1.536-13.312-3.68-20-5.632a468.48 468.48 0 0 1-28.224-8.96l4.032 1.248-2.656-1.024c-5.792-1.952-11.392-4.128-17.056-6.304a55.616 55.616 0 0 0-4.224-1.6l-0.48-0.128c-6.272-2.528-12.384-5.12-18.432-7.808-1.312-0.416-2.432-1.024-3.744-1.536a529.28 529.28 0 0 1-21.28-9.856l5.888 2.592c-1.568-0.672-2.976-1.408-4.512-2.208a320.704 320.704 0 0 1-11.936-6.048 135.2 135.2 0 0 1-8.832-4.544l0.864 0.448c-4.832-2.56-9.632-5.344-14.464-7.968-1.44-1.024-3.104-1.888-4.768-2.816a573.696 573.696 0 0 1-21.376-13.088l2.688 1.6a93.6 93.6 0 0 1-5.28-3.552l0.256 0.192a245.472 245.472 0 0 1-14.08-9.312l0.768 0.544c-1.504-0.992-2.848-2.048-4.384-3.104-5.44-3.776-9.536-6.752-13.568-9.792l1.024 0.736c-1.792-1.44-3.712-2.816-5.632-4.256-3.744-2.944-7.552-5.76-11.296-8.864l-5.024-4c-5.568-4.48-10.208-8.416-14.752-12.416l0.512 0.416A11.392 11.392 0 0 0 280.672 736l-0.032-0.032-14.816-13.472-4.256-4c-3.488-3.552-7.072-6.944-10.656-10.464l-4.128-4.256a394.56 394.56 0 0 1-12.928-13.472l-0.256-0.288-0.64-0.672a761.216 761.216 0 0 1-13.344-15.104c-1.152-1.312-2.208-2.72-3.424-4.128l-9.632-11.808a654.816 654.816 0 0 1-12.8-16.704l-1.728-2.4C92.416 503.168 56.352 315.456 136.096 161.472z" fill="#0769AD" p-id="9449"></path><path d="M346.496 141.024c-65.664 94.24-61.952 220.288-10.848 319.968 9.472 18.688 19.072 34.496 29.696 49.504l-0.8-1.216c9.824 14.08 20.64 30.72 33.792 42.08a284.8 284.8 0 0 0 14.688 15.328l3.84 3.84c4.864 4.704 9.856 9.312 14.944 13.856l0.64 0.544c5.12 4.512 10.88 9.28 16.768 13.92l0.896 0.672c1.44 0.992 2.688 2.144 4.096 3.104 5.984 4.608 12 9.056 18.208 13.44l0.64 0.384c2.656 1.92 5.472 3.68 8.448 5.536 1.184 0.768 2.56 1.792 3.84 2.56 4.512 2.912 8.96 5.632 13.536 8.416 0.736 0.288 1.376 0.672 2.048 0.992 3.84 2.336 8.032 4.608 12.032 6.688 1.408 0.864 2.784 1.504 4.224 2.304 2.848 1.408 5.664 2.912 8.416 4.352l1.376 0.608c5.76 2.816 11.648 5.472 17.408 8.096a448.192 448.192 0 0 0 18.24 7.488c2.144 0.736 4.128 1.568 6.144 2.208 4.352 1.632 8.928 3.104 13.216 4.608l5.984 1.92c6.24 1.92 12.544 4.448 19.104 5.504 337.92 56.032 416.16-204.256 416.16-204.256-70.432 101.376-206.752 149.664-352.032 111.968a315.2 315.2 0 0 1-21.536-6.24l2.432 0.704c-2.048-0.544-3.84-1.184-5.792-1.792-4.448-1.536-8.992-3.04-13.312-4.64l-6.144-2.304c-4.768-1.92-9.632-3.712-14.304-5.76-1.44-0.64-2.784-1.056-3.872-1.696-5.984-2.688-12-5.344-17.792-8.192l-8.8-4.576-5.088-2.56c-3.936-2.048-7.552-4.192-11.296-6.4a30.464 30.464 0 0 1-2.752-1.504l0.096 0.064c-4.512-2.816-9.216-5.536-13.536-8.448-1.44-0.8-2.784-1.792-4.128-2.656l-8.864-5.792c-6.144-4.256-12.16-8.864-18.208-13.312-1.376-1.248-2.688-2.272-4-3.36-63.872-50.208-114.272-118.88-138.144-196.608-25.184-80.8-19.616-171.424 23.84-244.992z" fill="#0769AD" p-id="9450"></path><path d="M582.816 59.04c-38.752 56.832-42.464 127.392-15.776 190.08 28.32 66.56 86.272 118.816 153.76 143.584 2.784 1.056 5.472 1.952 8.32 2.976l3.744 1.152c3.936 1.248 7.904 2.688 11.936 3.584 186.72 36 237.216-95.872 250.848-115.232-44.448 63.84-119.008 79.136-210.432 56.928a202.144 202.144 0 0 1-23.424-7.296l1.408 0.48a262.4 262.4 0 0 1-27.936-11.552l1.6 0.704a278.272 278.272 0 0 1-46.784-28.672l0.672 0.512c-81.92-62.048-132.64-180.48-79.232-276.96z" fill="#0769AD" p-id="9451"></path></svg>',
    'bootstrap':'<svg t="1595640997568" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="10272" width="16" height="16"><path d="M853.344 0H170.688A171.104 171.104 0 0 0 0.032 170.656v682.656c0 93.856 76.8 170.656 170.656 170.656h682.656c93.856 0 170.656-76.8 170.656-170.656V170.656C1024 76.8 947.2 0 853.344 0z m-93.312 719.136a132.896 132.896 0 0 1-39.392 52.64c-17.92 14.496-40.608 26.464-68.576 34.976-27.904 8.672-61.088 13.024-99.552 13.024H278.08V222.432h290.208c53.664 0 96.672 12.064 128.864 36.704 32.416 24.736 48.544 61.6 48.544 111.36 0 30.08-7.328 55.904-22.112 77.216-14.688 21.216-35.84 37.792-63.136 49.312v1.952c36.448 7.68 64.64 24.96 83.2 51.84s28.064 60.832 28.064 101.856c0 22.944-4.448 44.8-12.8 65.184z m-118.464-147.2c-17.504-16-42.08-23.808-73.824-23.808h-184.416v186.368h184.928c31.584 0 56.32-8.192 73.824-24.736 17.504-16.416 26.464-39.84 26.464-69.984-0.288-29.44-8.96-52.224-26.464-67.84z m-25.6-120.448c16.896-14.336 25.184-34.848 25.184-61.6 0-30.048-7.456-51.36-22.624-63.584-15.008-12.16-36.704-18.464-65.184-18.464h-170.656v164.832h170.656c24.864 0 46.08-7.264 62.624-21.152z" fill="#563D7C" p-id="10273"></path></svg>',
    'folder':'<svg t="1628147172432" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1494" width="16" height="16"><path d="M739.82 290.16H64.21V234.1c0-58.59 47.5-106.09 106.09-106.09h393.16c43.85 0 84.74 22.11 108.75 58.81l67.61 103.34z" fill="#FFBA53" p-id="1495"></path><path d="M960.19 396.82v357.49c0 78.06-63.28 141.33-141.33 141.33H205.54c-78.06 0-141.33-63.28-141.33-141.33V255.49h754.64c78.06 0 141.34 63.28 141.34 141.33z" fill="#FFDC53" p-id="1496"></path></svg>',
    'unknown':'<svg t="1628147502897" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2556" width="16" height="16"><path d="M659.72 64.19H270.4c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.69c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.017 120.017 0 0 0-84.85-35.15z" fill="#C7DADD" p-id="2557"></path><path d="M862.07 216.84l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81H894a119.975 119.975 0 0 0-31.93-57.29zM512.53 295.92c-82.1 0-148.9 66.8-148.9 148.9 0 12.53 10.15 22.68 22.68 22.68s22.68-10.15 22.68-22.68c0-57.09 46.45-103.54 103.54-103.54 27.63 0 53.62 10.78 73.19 30.35s30.35 45.57 30.35 73.19c0 21.11-6.31 41.41-18.24 58.71-11.68 16.92-27.89 29.89-46.9 37.48-37.11 14.83-61.08 49.9-61.08 89.33V632c0 12.53 10.15 22.68 22.68 22.68s22.68-10.15 22.68-22.68v-1.66c0-20.78 12.78-39.31 32.56-47.21 27.33-10.92 50.63-29.54 67.4-53.84 17.18-24.9 26.26-54.11 26.26-84.47 0-39.74-15.5-77.13-43.64-105.27-28.13-28.13-65.52-43.63-105.26-43.63z" fill="#9DC0C9" p-id="2558"></path><path d="M500.973351 750.25961a30.24 30.24 0 1 0 23.144694-55.876234 30.24 30.24 0 1 0-23.144694 55.876234Z" fill="#9DC0C9" p-id="2559"></path><path d="M618.4 327.31c-28.14-28.14-65.52-43.64-105.26-43.64-82.1 0-148.9 66.8-148.9 148.9 0 12.53 10.15 22.68 22.68 22.68s22.68-10.15 22.68-22.68c0-57.09 46.45-103.54 103.54-103.54 27.63 0 53.62 10.78 73.19 30.35s30.35 45.57 30.35 73.19c0 21.11-6.31 41.41-18.24 58.71-11.68 16.92-27.89 29.89-46.9 37.48-37.11 14.83-61.08 49.9-61.08 89.33v1.66c0 12.53 10.15 22.68 22.68 22.68s22.68-10.15 22.68-22.68v-1.66c0-20.78 12.78-39.31 32.56-47.21 27.33-10.92 50.63-29.54 67.4-53.84 17.18-24.9 26.26-54.11 26.26-84.47 0-39.74-15.5-77.12-43.64-105.26z" fill="#FFFFFF" p-id="2560"></path><path d="M513.14 710.09m-30.24 0a30.24 30.24 0 1 0 60.48 0 30.24 30.24 0 1 0-60.48 0Z" fill="#FFFFFF" p-id="2561"></path></svg>'
}
svg_by_suffix={
    'ppt':'<svg t="1628147039673" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="863" width="16" height="16"><path d="M658.58 63.94H269.26c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.44c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.017 120.017 0 0 0-84.85-35.15z" fill="#F98950" p-id="864"></path><path d="M860.93 216.59l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a119.93 119.93 0 0 0-31.93-57.29zM556.02 348.38H380.37c-13.25 0-24 10.75-24 24v302.74c0 13.25 10.75 24 24 24s24-10.75 24-24V595.6h151.65c68.16 0 123.61-55.45 123.61-123.61s-55.45-123.61-123.61-123.61z m0 199.22H404.37V396.38h151.65c41.69 0 75.61 33.92 75.61 75.61s-33.92 75.61-75.61 75.61z" fill="#F26C38" p-id="865"></path><path d="M556.02 336.38H380.37c-13.25 0-24 10.75-24 24v302.74c0 13.25 10.75 24 24 24s24-10.75 24-24V583.6h151.65c68.16 0 123.61-55.45 123.61-123.61s-55.45-123.61-123.61-123.61z m0 199.22H404.37V384.38h151.65c41.69 0 75.61 33.92 75.61 75.61s-33.92 75.61-75.61 75.61z" fill="#FFFFFF" p-id="866"></path></svg>',
    'pptx':'<svg t="1628147039673" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="863" width="16" height="16"><path d="M658.58 63.94H269.26c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.44c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.017 120.017 0 0 0-84.85-35.15z" fill="#F98950" p-id="864"></path><path d="M860.93 216.59l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a119.93 119.93 0 0 0-31.93-57.29zM556.02 348.38H380.37c-13.25 0-24 10.75-24 24v302.74c0 13.25 10.75 24 24 24s24-10.75 24-24V595.6h151.65c68.16 0 123.61-55.45 123.61-123.61s-55.45-123.61-123.61-123.61z m0 199.22H404.37V396.38h151.65c41.69 0 75.61 33.92 75.61 75.61s-33.92 75.61-75.61 75.61z" fill="#F26C38" p-id="865"></path><path d="M556.02 336.38H380.37c-13.25 0-24 10.75-24 24v302.74c0 13.25 10.75 24 24 24s24-10.75 24-24V583.6h151.65c68.16 0 123.61-55.45 123.61-123.61s-55.45-123.61-123.61-123.61z m0 199.22H404.37V384.38h151.65c41.69 0 75.61 33.92 75.61 75.61s-33.92 75.61-75.61 75.61z" fill="#FFFFFF" p-id="866"></path></svg>',
    'md':'<svg t="1595641304764" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="14626" width="16" height="16"><path d="M133.529661 0.00041A49.70492 49.70492 0 0 0 97.40297 15.360397 54.149077 54.149077 0 0 0 81.920102 51.200369v921.599262a48.926681 48.926681 0 0 0 15.482868 35.839972A51.199959 51.199959 0 0 0 133.529661 1023.99959h756.940195a49.70492 49.70492 0 0 0 36.126691-15.359987A50.3398 50.3398 0 0 0 942.079414 972.799631V290.140337L649.625248 0.00041z" fill="#2287E1" p-id="14627"></path><path d="M942.079414 293.785775H700.128888a53.247957 53.247957 0 0 1-51.834839-51.855319V0.00041z" fill="#85B7E4" p-id="14628"></path><path d="M291.491775 716.697436v-188.190569l77.823937 188.190569h36.597731l77.823938-188.190569v188.190569h45.752283V441.630776h-50.339799l-91.504567 217.087827-91.525047-217.087827h-50.38076v275.06666z" fill="#FFFFFF" p-id="14629"></path><path d="M711.884398 658.370443l27.463658-28.671977a21.463023 21.463023 0 0 1 32.030695 0 23.859181 23.859181 0 0 1 0 33.484773l-64.061389 66.969546a21.463023 21.463023 0 0 1-32.030694 0l-64.061389-66.969546a23.859181 23.859181 0 0 1 0-33.484773 21.463023 21.463023 0 0 1 32.030694 0l27.463658 28.671977V433.541183a22.896622 22.896622 0 1 1 45.752284 0v224.82926z" fill="#FFFFFF" p-id="14630"></path></svg>',
    'py':'<svg t="1595641322434" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="15458" width="16" height="16"><path d="M420.693333 85.333333C353.28 85.333333 298.666667 139.946667 298.666667 207.36v71.68h183.04c16.64 0 30.293333 24.32 30.293333 40.96H207.36C139.946667 320 85.333333 374.613333 85.333333 442.026667v161.322666c0 67.413333 54.613333 122.026667 122.026667 122.026667h50.346667v-114.346667c0-67.413333 54.186667-122.026667 121.6-122.026666h224c67.413333 0 122.026667-54.229333 122.026666-121.642667V207.36C725.333333 139.946667 670.72 85.333333 603.306667 85.333333z m-30.72 68.693334c17.066667 0 30.72 5.12 30.72 30.293333s-13.653333 38.016-30.72 38.016c-16.64 0-30.293333-12.8-30.293333-37.973333s13.653333-30.336 30.293333-30.336z" fill="#3C78AA" p-id="15459"></path><path d="M766.250667 298.666667v114.346666a121.6 121.6 0 0 1-121.6 121.984H420.693333A121.6 121.6 0 0 0 298.666667 656.597333v160a122.026667 122.026667 0 0 0 122.026666 122.026667h182.613334A122.026667 122.026667 0 0 0 725.333333 816.64v-71.68h-183.082666c-16.64 0-30.250667-24.32-30.250667-40.96h304.64A122.026667 122.026667 0 0 0 938.666667 581.973333v-161.28a122.026667 122.026667 0 0 0-122.026667-122.026666zM354.986667 491.221333l-0.170667 0.170667c0.512-0.085333 1.066667-0.042667 1.621333-0.170667z m279.04 310.442667c16.64 0 30.293333 12.8 30.293333 37.973333a30.293333 30.293333 0 0 1-30.293333 30.293334c-17.066667 0-30.72-5.12-30.72-30.293334s13.653333-37.973333 30.72-37.973333z" fill="#FDD835" p-id="15460"></path></svg>',
    'pyc':'<svg t="1595641322434" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="15458" width="16" height="16"><path d="M420.693333 85.333333C353.28 85.333333 298.666667 139.946667 298.666667 207.36v71.68h183.04c16.64 0 30.293333 24.32 30.293333 40.96H207.36C139.946667 320 85.333333 374.613333 85.333333 442.026667v161.322666c0 67.413333 54.613333 122.026667 122.026667 122.026667h50.346667v-114.346667c0-67.413333 54.186667-122.026667 121.6-122.026666h224c67.413333 0 122.026667-54.229333 122.026666-121.642667V207.36C725.333333 139.946667 670.72 85.333333 603.306667 85.333333z m-30.72 68.693334c17.066667 0 30.72 5.12 30.72 30.293333s-13.653333 38.016-30.72 38.016c-16.64 0-30.293333-12.8-30.293333-37.973333s13.653333-30.336 30.293333-30.336z" fill="#3C78AA" p-id="15459"></path><path d="M766.250667 298.666667v114.346666a121.6 121.6 0 0 1-121.6 121.984H420.693333A121.6 121.6 0 0 0 298.666667 656.597333v160a122.026667 122.026667 0 0 0 122.026666 122.026667h182.613334A122.026667 122.026667 0 0 0 725.333333 816.64v-71.68h-183.082666c-16.64 0-30.250667-24.32-30.250667-40.96h304.64A122.026667 122.026667 0 0 0 938.666667 581.973333v-161.28a122.026667 122.026667 0 0 0-122.026667-122.026666zM354.986667 491.221333l-0.170667 0.170667c0.512-0.085333 1.066667-0.042667 1.621333-0.170667z m279.04 310.442667c16.64 0 30.293333 12.8 30.293333 37.973333a30.293333 30.293333 0 0 1-30.293333 30.293334c-17.066667 0-30.72-5.12-30.72-30.293334s13.653333-37.973333 30.72-37.973333z" fill="#FDD835" p-id="15460"></path></svg>',
    'xls':'<svg t="1628147101188" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1072" width="16" height="16"><path d="M658.68 63.95H269.36c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.44c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#53D39C" p-id="1073"></path><path d="M655.49 388.82c-9.37-9.37-24.57-9.37-33.94 0L510.8 499.57 400.05 388.82c-9.37-9.37-24.57-9.37-33.94 0-9.37 9.37-9.37 24.57 0 33.94l110.75 110.75L366.1 644.26c-9.37 9.37-9.37 24.57 0 33.94 4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03L510.8 567.45 621.54 678.2c4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03c9.37-9.37 9.37-24.57 0-33.94L544.74 533.51l110.75-110.75c9.37-9.37 9.37-24.57 0-33.94zM861.03 216.59l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a120.058 120.058 0 0 0-31.93-57.29z" fill="#25BF79" p-id="1074"></path><path d="M544.74 521.51l110.75-110.75c9.37-9.37 9.37-24.57 0-33.94-9.37-9.37-24.57-9.37-33.94 0L510.8 487.57 400.05 376.82c-9.37-9.37-24.57-9.37-33.94 0-9.37 9.37-9.37 24.57 0 33.94l110.75 110.75L366.1 632.26c-9.37 9.37-9.37 24.57 0 33.94 4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03L510.8 555.45 621.54 666.2c4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03c9.37-9.37 9.37-24.57 0-33.94L544.74 521.51z" fill="#FFFFFF" p-id="1075"></path></svg>',
    'xlsx':'<svg t="1628147101188" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1072" width="16" height="16"><path d="M658.68 63.95H269.36c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.44c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#53D39C" p-id="1073"></path><path d="M655.49 388.82c-9.37-9.37-24.57-9.37-33.94 0L510.8 499.57 400.05 388.82c-9.37-9.37-24.57-9.37-33.94 0-9.37 9.37-9.37 24.57 0 33.94l110.75 110.75L366.1 644.26c-9.37 9.37-9.37 24.57 0 33.94 4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03L510.8 567.45 621.54 678.2c4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03c9.37-9.37 9.37-24.57 0-33.94L544.74 533.51l110.75-110.75c9.37-9.37 9.37-24.57 0-33.94zM861.03 216.59l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a120.058 120.058 0 0 0-31.93-57.29z" fill="#25BF79" p-id="1074"></path><path d="M544.74 521.51l110.75-110.75c9.37-9.37 9.37-24.57 0-33.94-9.37-9.37-24.57-9.37-33.94 0L510.8 487.57 400.05 376.82c-9.37-9.37-24.57-9.37-33.94 0-9.37 9.37-9.37 24.57 0 33.94l110.75 110.75L366.1 632.26c-9.37 9.37-9.37 24.57 0 33.94 4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03L510.8 555.45 621.54 666.2c4.69 4.69 10.83 7.03 16.97 7.03s12.28-2.34 16.97-7.03c9.37-9.37 9.37-24.57 0-33.94L544.74 521.51z" fill="#FFFFFF" p-id="1075"></path></svg>',
    'doc':'<svg t="1628147137057" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1285" width="16" height="16"><path d="M658.78 64.39H269.46c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.88c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#53B7F4" p-id="1286"></path><path d="M647.85 360.65c-13.25 0-24 10.75-24 24v226.26l-94.35-93.29c-9.33-9.22-24.34-9.25-33.69-0.05l-95.26 93.6V383.99c0-13.25-10.75-24-24-24s-24 10.75-24 24V668.4c0 9.67 5.8 18.39 14.72 22.13a24.002 24.002 0 0 0 26.1-5.01L512.58 568.4l118.4 117.07a23.993 23.993 0 0 0 16.88 6.93c3.11 0 6.25-0.61 9.24-1.85a24 24 0 0 0 14.75-22.15V384.65c0-13.25-10.74-24-24-24zM861.13 217.03l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a119.975 119.975 0 0 0-31.93-57.29z" fill="#29A3D3" p-id="1287"></path><path d="M647.86 680.4c-6.2 0-12.3-2.4-16.88-6.93L512.58 556.4 393.37 673.52a23.99 23.99 0 0 1-26.1 5.01 23.992 23.992 0 0 1-14.72-22.13V371.99c0-13.25 10.75-24 24-24s24 10.75 24 24v227.19l95.26-93.6c9.36-9.19 24.37-9.17 33.69 0.05l94.35 93.29V372.65c0-13.25 10.75-24 24-24s24 10.75 24 24V656.4c0 9.68-5.82 18.42-14.75 22.15a24.112 24.112 0 0 1-9.24 1.85z" fill="#FFFFFF" p-id="1288"></path></svg>',
    'docx':'<svg t="1628147137057" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1285" width="16" height="16"><path d="M658.78 64.39H269.46c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.88c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#53B7F4" p-id="1286"></path><path d="M647.85 360.65c-13.25 0-24 10.75-24 24v226.26l-94.35-93.29c-9.33-9.22-24.34-9.25-33.69-0.05l-95.26 93.6V383.99c0-13.25-10.75-24-24-24s-24 10.75-24 24V668.4c0 9.67 5.8 18.39 14.72 22.13a24.002 24.002 0 0 0 26.1-5.01L512.58 568.4l118.4 117.07a23.993 23.993 0 0 0 16.88 6.93c3.11 0 6.25-0.61 9.24-1.85a24 24 0 0 0 14.75-22.15V384.65c0-13.25-10.74-24-24-24zM861.13 217.03l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a119.975 119.975 0 0 0-31.93-57.29z" fill="#29A3D3" p-id="1287"></path><path d="M647.86 680.4c-6.2 0-12.3-2.4-16.88-6.93L512.58 556.4 393.37 673.52a23.99 23.99 0 0 1-26.1 5.01 23.992 23.992 0 0 1-14.72-22.13V371.99c0-13.25 10.75-24 24-24s24 10.75 24 24v227.19l95.26-93.6c9.36-9.19 24.37-9.17 33.69 0.05l94.35 93.29V372.65c0-13.25 10.75-24 24-24s24 10.75 24 24V656.4c0 9.68-5.82 18.42-14.75 22.15a24.112 24.112 0 0 1-9.24 1.85z" fill="#FFFFFF" p-id="1288"></path></svg>',
    'js':'<svg t="1595641386057" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="17889" width="16" height="16"><path d="M676.297 0H145.61c-14.775 0-26.752 11.977-26.752 35.218v970.496c0 6.309 11.977 18.286 26.752 18.286h732.782c14.775 0 26.752-11.977 26.752-18.286V237.312c0-12.727-1.7-16.823-4.7-19.84L687.671 4.699A16.165 16.165 0 0 0 676.297 0z" fill="#E9E9E0" p-id="17890"></path><path d="M685.714 2.761V219.43h216.668z" fill="#D9D7CA" p-id="17891"></path><path d="M878.39 1024H145.61a26.752 26.752 0 0 1-26.753-26.752V713.143h786.286v284.105c0 14.775-11.977 26.752-26.752 26.752z" fill="#EEAF4B" p-id="17892"></path><path d="M475.813 781.147v143.507c0 8.667-1.591 15.963-4.755 21.87a39.333 39.333 0 0 1-12.745 14.244c-5.34 3.584-11.465 6.09-18.377 7.497s-14.062 2.121-21.376 2.121c-3.675 0-7.973-0.384-12.873-1.133s-10.002-1.902-15.25-3.493-10.295-3.383-15.123-5.376a55.26 55.26 0 0 1-12.251-6.747l12.745-20.243c1.664 1.152 4.041 2.377 7.131 3.62s6.455 2.415 10.13 3.493c3.658 1.098 7.498 2.03 11.502 2.871s7.754 1.244 11.246 1.244c8.814 0 15.872-1.72 21.12-5.12s8.028-9.216 8.375-17.372v-141h30.5z m149.266 137.49c0 6.657-1.372 13.13-4.133 19.384s-6.62 11.757-11.63 16.493-11.172 8.54-18.505 11.374a68.955 68.955 0 0 1-24.996 4.242c-4.005 0-8.119-0.22-12.38-0.621s-8.557-1.134-12.873-2.122c-4.333-1.005-8.466-2.377-12.38-4.132s-7.295-3.877-10.13-6.382l5.249-21.504c2.322 1.335 5.284 2.633 8.868 3.877s7.278 2.413 11.118 3.492a112.158 112.158 0 0 0 11.502 2.633c3.821 0.659 7.405 1.006 10.752 1.006 10.166 0 17.956-2.377 23.369-7.131s8.119-11.795 8.119-21.12c0-5.669-1.92-10.496-5.742-14.5-3.84-4.005-8.631-7.626-14.373-10.88s-11.959-6.492-18.633-9.747a112.878 112.878 0 0 1-18.743-11.502 59.685 59.685 0 0 1-14.5-15.616c-3.84-5.998-5.742-13.495-5.742-22.491 0-8.156 1.5-15.415 4.498-21.742s7.04-11.721 12.124-16.128 11.008-7.79 17.755-10.13 13.879-3.493 21.376-3.493c7.662 0 15.415 0.713 23.241 2.121 7.827 1.408 14.153 3.712 19 6.876a243.383 243.383 0 0 1-3.493 7.131l-3.749 7.241a294.202 294.202 0 0 1-2.999 5.632 23.095 23.095 0 0 1-1.5 2.505c-1.005-0.493-2.12-1.152-3.382-1.993s-3.054-1.664-5.376-2.505a38.528 38.528 0 0 0-9.253-1.755 87.424 87.424 0 0 0-14.756 0.256c-3.347 0.347-6.492 1.28-9.509 2.87s-5.687 3.53-8.009 5.87a26.441 26.441 0 0 0-5.504 7.881 20.114 20.114 0 0 0-1.993 8.375c0 6.656 1.902 12.032 5.742 16.128 3.821 4.096 8.576 7.662 14.244 10.752 5.669 3.09 11.813 6.09 18.505 8.997 6.656 2.907 12.873 6.473 18.633 10.624s10.533 9.38 14.373 15.616c3.877 6.254 5.815 14.281 5.815 24.119z" fill="#FFFFFF" p-id="17893"></path><path d="M356.571 347.429v-73.143c0-10.076 8.192-18.286 18.286-18.286a18.286 18.286 0 1 0 0-36.571c-30.244 0-54.857 24.612-54.857 54.857v73.143C320 367.598 303.598 384 283.429 384a18.286 18.286 0 1 0 0 36.571c20.169 0 36.571 16.403 36.571 36.572v73.143c0 30.244 24.613 54.857 54.857 54.857a18.286 18.286 0 1 0 0-36.572c-10.094 0-18.286-8.21-18.286-18.285v-73.143c0-21.943-9.91-41.436-25.27-54.857a72.686 72.686 0 0 0 25.27-54.857zM475.429 338.286a27.429 27.429 0 1 0 54.857 0 27.429 27.429 0 1 0-54.857 0zM722.286 384c-20.17 0-36.572-16.402-36.572-36.571v-73.143c0-30.245-24.612-54.857-54.857-54.857a18.286 18.286 0 1 0 0 36.571c10.094 0 18.286 8.21 18.286 18.286v73.143c0 21.942 9.91 41.435 25.27 54.857a72.686 72.686 0 0 0-25.27 54.857v73.143c0 10.075-8.192 18.285-18.286 18.285a18.286 18.286 0 1 0 0 36.572c30.245 0 54.857-24.613 54.857-54.857v-73.143c0-20.17 16.403-36.572 36.572-36.572a18.286 18.286 0 1 0 0-36.571z m-219.429 54.857a18.286 18.286 0 0 0-18.286 18.286V512a18.286 18.286 0 1 0 36.572 0v-54.857a18.286 18.286 0 0 0-18.286-18.286z" fill="#EEAF4B" p-id="17894"></path></svg>',
    'html':'<svg t="1595641411708" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="18832" width="16" height="16"><path d="M919.415066 901.492615l-81.669546 0 0 20.418409c0 56.367563-45.69075 102.088976-102.086932 102.088976L102.713477 1024c-56.366541 0-102.086932-45.720391-102.086932-102.088976L0.626545 105.208413c0-56.397204 45.720391-102.087954 102.086932-102.087954l408.351817 0 37.693872 0 0-3.120459 2.873111 3.120459 0.268811 0 0 0.308673 282.763835 305.954167 3.081619 0 0 3.349408 1.405382 1.505547-1.405382 0 0 240.154704 81.669546 0c56.398226 0 102.088976 45.691772 102.088976 102.089998l0 142.922727C1021.504042 855.774269 975.813292 901.492615 919.415066 901.492615M551.900066 76.396553l0 130.898792c0 56.367563 45.719369 102.087954 102.088976 102.087954l117.728065 0L551.900066 76.396553zM796.911769 350.220116 613.153247 350.220116c-56.367563 0-102.087954-45.720391-102.087954-102.087954L511.065293 43.956253 143.549272 43.956253c-56.367563 0-102.086932 45.69075-102.086932 102.087954l0 735.031021c0 56.366541 45.719369 102.088976 102.086932 102.088976l551.273521 0c49.370295 0 90.574045-35.061976 100.023321-81.670568L245.636204 901.493637c-56.367563 0-102.087954-45.718347-102.087954-102.08591L143.54825 656.483978c0-56.398226 45.720391-102.089998 102.087954-102.089998l551.274544 0L796.910747 350.220116zM661.255122 827.988593l34.095073 0 34.81565-138.057551 0 138.057551 32.899221 0L763.065066 652.605125l-53.1081 0L678.49379 772.247575l-31.834197-119.64245-53.006912 0 0 175.383469 32.918641 0L626.571322 689.931042 661.255122 827.988593zM565.189356 682.274523l0-29.668376L425.825567 652.606147l0 29.668376 52.02059 0 0 145.714071 35.402333 0L513.24849 682.274523 565.189356 682.274523zM290.81795 721.634411l0-69.029286-35.402333 0 0 175.383469 35.402333 0 0-76.684784 69.397241 0 0 76.684784 35.411532 0L395.626723 652.605125l-35.411532 0L360.215191 721.634411 290.81795 721.634411zM928.786662 798.437758l-88.041291 0L840.745371 654.048324l-35.420731 0 0 173.940269 123.462022 0L928.786662 798.437758zM288.225915 125.765826l29.061251 0-50.516065 384.873253-28.502164 0L288.225915 125.765826zM475.62412 350.967268 337.127068 462.147787l0-71.850271 96.644272-70.075913-96.644272-69.268457 0-71.341267L475.62412 290.023782 475.62412 350.967268zM80.073032 289.514778l138.326362-110.422124 0 72.337811-96.495046 68.031721 96.495046 70.584916 0 71.810409L80.073032 350.967268 80.073032 289.514778z" p-id="18833"></path></svg>',
    'htm':'<svg t="1595641411708" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="18832" width="16" height="16"><path d="M919.415066 901.492615l-81.669546 0 0 20.418409c0 56.367563-45.69075 102.088976-102.086932 102.088976L102.713477 1024c-56.366541 0-102.086932-45.720391-102.086932-102.088976L0.626545 105.208413c0-56.397204 45.720391-102.087954 102.086932-102.087954l408.351817 0 37.693872 0 0-3.120459 2.873111 3.120459 0.268811 0 0 0.308673 282.763835 305.954167 3.081619 0 0 3.349408 1.405382 1.505547-1.405382 0 0 240.154704 81.669546 0c56.398226 0 102.088976 45.691772 102.088976 102.089998l0 142.922727C1021.504042 855.774269 975.813292 901.492615 919.415066 901.492615M551.900066 76.396553l0 130.898792c0 56.367563 45.719369 102.087954 102.088976 102.087954l117.728065 0L551.900066 76.396553zM796.911769 350.220116 613.153247 350.220116c-56.367563 0-102.087954-45.720391-102.087954-102.087954L511.065293 43.956253 143.549272 43.956253c-56.367563 0-102.086932 45.69075-102.086932 102.087954l0 735.031021c0 56.366541 45.719369 102.088976 102.086932 102.088976l551.273521 0c49.370295 0 90.574045-35.061976 100.023321-81.670568L245.636204 901.493637c-56.367563 0-102.087954-45.718347-102.087954-102.08591L143.54825 656.483978c0-56.398226 45.720391-102.089998 102.087954-102.089998l551.274544 0L796.910747 350.220116zM661.255122 827.988593l34.095073 0 34.81565-138.057551 0 138.057551 32.899221 0L763.065066 652.605125l-53.1081 0L678.49379 772.247575l-31.834197-119.64245-53.006912 0 0 175.383469 32.918641 0L626.571322 689.931042 661.255122 827.988593zM565.189356 682.274523l0-29.668376L425.825567 652.606147l0 29.668376 52.02059 0 0 145.714071 35.402333 0L513.24849 682.274523 565.189356 682.274523zM290.81795 721.634411l0-69.029286-35.402333 0 0 175.383469 35.402333 0 0-76.684784 69.397241 0 0 76.684784 35.411532 0L395.626723 652.605125l-35.411532 0L360.215191 721.634411 290.81795 721.634411zM928.786662 798.437758l-88.041291 0L840.745371 654.048324l-35.420731 0 0 173.940269 123.462022 0L928.786662 798.437758zM288.225915 125.765826l29.061251 0-50.516065 384.873253-28.502164 0L288.225915 125.765826zM475.62412 350.967268 337.127068 462.147787l0-71.850271 96.644272-70.075913-96.644272-69.268457 0-71.341267L475.62412 290.023782 475.62412 350.967268zM80.073032 289.514778l138.326362-110.422124 0 72.337811-96.495046 68.031721 96.495046 70.584916 0 71.810409L80.073032 350.967268 80.073032 289.514778z" p-id="18833"></path></svg>',
    'svg':'<svg t="1595641629014" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="25608" width="16" height="16"><path d="M332.799002 686.081014m-332.799002 0a332.799002 332.799002 0 1 0 665.598003 0 332.799002 332.799002 0 1 0-665.598003 0Z" fill="#DFDFF2" p-id="25609"></path><path d="M290.559128 595.969284l20.991937-25.599923a87.551737 87.551737 0 0 0 60.15982 25.599923c27.391918 0 42.751872-12.799962 42.751872-31.999904s-15.359954-27.135919-36.351891-36.351891l-31.231907-13.567959a65.023805 65.023805 0 0 1-46.079861-59.135823 67.071799 67.071799 0 0 1 74.239777-62.207813 96.76771 96.76771 0 0 1 68.351795 28.671914l-18.687944 22.783932a71.935784 71.935784 0 0 0-49.663851-20.22394c-23.039931 0-38.143886 11.007967-38.143886 29.183913s18.175945 25.599923 36.60789 34.047897l30.975908 13.311961A62.975811 62.975811 0 0 1 450.302649 563.201382c0 36.351891-29.95191 65.791803-79.615761 65.791803a112.639662 112.639662 0 0 1-80.12776-33.023901zM462.846611 399.105875h37.887887l33.535899 116.991649c7.679977 25.599923 12.543962 47.871856 20.479939 73.983778h1.535995c7.679977-25.599923 13.31196-48.127856 20.479939-73.983778l33.535899-116.991649h36.351891l-70.655788 226.047322h-42.239873zM659.96602 512.001536c0-73.727779 45.567863-118.015646 105.215684-118.015646a90.11173 90.11173 0 0 1 67.327798 28.671914l-19.455941 22.783932a61.183816 61.183816 0 0 0-46.59186-20.22394c-41.983874 0-70.14379 32.511902-70.14379 85.759743s25.599923 86.52774 71.423786 86.52774a56.063832 56.063832 0 0 0 35.583893-11.007966v-52.479843h-44.543866v-29.183913h76.799769v98.047706a102.399693 102.399693 0 0 1-71.423785 25.599924c-60.15982 0.767998-104.191687-41.727875-104.191688-116.479651z" fill="#434260" p-id="25610"></path><path d="M883.19735 1024h-639.99808A141.055577 141.055577 0 0 1 102.399693 883.200422v-742.397772A141.055577 141.055577 0 0 1 243.19927 0.003072h516.350451a89.087733 89.087733 0 0 1 63.231811 25.599923l189.695431 189.695431A38.399885 38.399885 0 0 1 1023.996928 243.202342v639.99808a141.055577 141.055577 0 0 1-140.799578 140.799578zM243.19927 76.802842A63.999808 63.999808 0 0 0 179.199462 140.80265v742.397772A63.999808 63.999808 0 0 0 243.19927 947.20023h639.99808a63.999808 63.999808 0 0 0 63.999808-63.999808V259.074295l-179.199462-179.199463a12.799962 12.799962 0 0 0-8.447975-3.07199z" fill="#434260" p-id="25611"></path></svg>',
    'jpg':'<svg t="1628147400655" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2128" width="16" height="16"><path d="M788.14 928.23h-550c-77.32 0-140-62.68-140-140v-550c0-77.32 62.68-140 140-140h550c77.32 0 140 62.68 140 140v550c0 77.32-62.68 140-140 140z" fill="#FFC757" p-id="2129"></path><path d="M770.19 644.92l-67.56-117.01c-15.4-26.68-53.91-26.68-69.31 0l-64.01 110.88L450.3 432.65c-15.4-26.67-53.89-26.67-69.29 0L258.45 644.94c-15.4 26.67 3.85 60.01 34.65 60.01h442.44c30.8-0.01 50.05-33.35 34.65-60.03z" fill="#EF9F2B" p-id="2130"></path><path d="M595.103921 388.209544a55.27 55.27 0 1 0 100.661393-45.676862 55.27 55.27 0 1 0-100.661393 45.676862Z" fill="#EF9F2B" p-id="2131"></path><path d="M770.19 632.92l-67.56-117.01c-15.4-26.68-53.91-26.68-69.31 0l-64.01 110.88L450.3 420.65c-15.4-26.67-53.89-26.67-69.29 0L258.45 632.94c-15.4 26.67 3.85 60.01 34.65 60.01h442.44c30.8-0.01 50.05-33.35 34.65-60.03z" fill="#FFFFFF" p-id="2132"></path><path d="M595.104335 376.209454a55.27 55.27 0 1 0 100.661392-45.676862 55.27 55.27 0 1 0-100.661392 45.676862Z" fill="#FFFFFF" p-id="2133"></path></svg>',
    'jpeg':'<svg t="1628147400655" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2128" width="16" height="16"><path d="M788.14 928.23h-550c-77.32 0-140-62.68-140-140v-550c0-77.32 62.68-140 140-140h550c77.32 0 140 62.68 140 140v550c0 77.32-62.68 140-140 140z" fill="#FFC757" p-id="2129"></path><path d="M770.19 644.92l-67.56-117.01c-15.4-26.68-53.91-26.68-69.31 0l-64.01 110.88L450.3 432.65c-15.4-26.67-53.89-26.67-69.29 0L258.45 644.94c-15.4 26.67 3.85 60.01 34.65 60.01h442.44c30.8-0.01 50.05-33.35 34.65-60.03z" fill="#EF9F2B" p-id="2130"></path><path d="M595.103921 388.209544a55.27 55.27 0 1 0 100.661393-45.676862 55.27 55.27 0 1 0-100.661393 45.676862Z" fill="#EF9F2B" p-id="2131"></path><path d="M770.19 632.92l-67.56-117.01c-15.4-26.68-53.91-26.68-69.31 0l-64.01 110.88L450.3 420.65c-15.4-26.67-53.89-26.67-69.29 0L258.45 632.94c-15.4 26.67 3.85 60.01 34.65 60.01h442.44c30.8-0.01 50.05-33.35 34.65-60.03z" fill="#FFFFFF" p-id="2132"></path><path d="M595.104335 376.209454a55.27 55.27 0 1 0 100.661392-45.676862 55.27 55.27 0 1 0-100.661392 45.676862Z" fill="#FFFFFF" p-id="2133"></path></svg>',
    'png':'<svg t="1628147400655" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2128" width="16" height="16"><path d="M788.14 928.23h-550c-77.32 0-140-62.68-140-140v-550c0-77.32 62.68-140 140-140h550c77.32 0 140 62.68 140 140v550c0 77.32-62.68 140-140 140z" fill="#FFC757" p-id="2129"></path><path d="M770.19 644.92l-67.56-117.01c-15.4-26.68-53.91-26.68-69.31 0l-64.01 110.88L450.3 432.65c-15.4-26.67-53.89-26.67-69.29 0L258.45 644.94c-15.4 26.67 3.85 60.01 34.65 60.01h442.44c30.8-0.01 50.05-33.35 34.65-60.03z" fill="#EF9F2B" p-id="2130"></path><path d="M595.103921 388.209544a55.27 55.27 0 1 0 100.661393-45.676862 55.27 55.27 0 1 0-100.661393 45.676862Z" fill="#EF9F2B" p-id="2131"></path><path d="M770.19 632.92l-67.56-117.01c-15.4-26.68-53.91-26.68-69.31 0l-64.01 110.88L450.3 420.65c-15.4-26.67-53.89-26.67-69.29 0L258.45 632.94c-15.4 26.67 3.85 60.01 34.65 60.01h442.44c30.8-0.01 50.05-33.35 34.65-60.03z" fill="#FFFFFF" p-id="2132"></path><path d="M595.104335 376.209454a55.27 55.27 0 1 0 100.661392-45.676862 55.27 55.27 0 1 0-100.661392 45.676862Z" fill="#FFFFFF" p-id="2133"></path></svg>',
    'mp3':'<svg t="1628147207860" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1702" width="16" height="16"><path d="M788.14 928.23h-550c-77.32 0-140-62.68-140-140v-550c0-77.32 62.68-140 140-140h550c77.32 0 140 62.68 140 140v550c0 77.32-62.68 140-140 140z" fill="#FF7878" p-id="1703"></path><path d="M682.2 326.8a27.8 27.8 0 0 0-10.04-21.39 27.807 27.807 0 0 0-22.87-5.93l-261.58 49.04c-13.15 2.46-22.67 13.94-22.67 27.32l0.18 250.12a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74 0 35.76 28.99 64.74 64.74 64.74s64.74-28.99 64.74-64.74V450.77l232.29-43.55v169.7a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74s28.99 64.74 64.74 64.74 64.74-28.99 64.74-64.74c-0.01-1.19-0.01-310.88-0.01-310.88z" fill="#EF5252" p-id="1704"></path><path d="M682.2 314.8a27.8 27.8 0 0 0-10.04-21.39 27.807 27.807 0 0 0-22.87-5.93l-261.58 49.04c-13.15 2.46-22.67 13.94-22.67 27.32l0.18 250.12a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74 0 35.76 28.99 64.74 64.74 64.74s64.74-28.99 64.74-64.74V438.77l232.29-43.55v169.7a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74s28.99 64.74 64.74 64.74 64.74-28.99 64.74-64.74c-0.01-1.19-0.01-310.88-0.01-310.88z" fill="#FFFFFF" p-id="1705"></path></svg>',
    'avi':'<svg t="1628147207860" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1702" width="16" height="16"><path d="M788.14 928.23h-550c-77.32 0-140-62.68-140-140v-550c0-77.32 62.68-140 140-140h550c77.32 0 140 62.68 140 140v550c0 77.32-62.68 140-140 140z" fill="#FF7878" p-id="1703"></path><path d="M682.2 326.8a27.8 27.8 0 0 0-10.04-21.39 27.807 27.807 0 0 0-22.87-5.93l-261.58 49.04c-13.15 2.46-22.67 13.94-22.67 27.32l0.18 250.12a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74 0 35.76 28.99 64.74 64.74 64.74s64.74-28.99 64.74-64.74V450.77l232.29-43.55v169.7a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74s28.99 64.74 64.74 64.74 64.74-28.99 64.74-64.74c-0.01-1.19-0.01-310.88-0.01-310.88z" fill="#EF5252" p-id="1704"></path><path d="M682.2 314.8a27.8 27.8 0 0 0-10.04-21.39 27.807 27.807 0 0 0-22.87-5.93l-261.58 49.04c-13.15 2.46-22.67 13.94-22.67 27.32l0.18 250.12a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74 0 35.76 28.99 64.74 64.74 64.74s64.74-28.99 64.74-64.74V438.77l232.29-43.55v169.7a64.668 64.668 0 0 0-22.39-3.98c-35.76 0-64.74 28.99-64.74 64.74s28.99 64.74 64.74 64.74 64.74-28.99 64.74-64.74c-0.01-1.19-0.01-310.88-0.01-310.88z" fill="#FFFFFF" p-id="1705"></path></svg>',
    'mp4':'<svg t="1628147353936" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1915" width="16" height="16"><path d="M65.3 755.4V269.9c0-78.1 63.3-141.3 141.3-141.3h612.9c78.1 0 141.3 63.3 141.3 141.3v485.5c0 78.1-63.3 141.3-141.3 141.3H206.7c-78.1 0-141.4-63.3-141.4-141.3z" fill="#8B72F7" p-id="1916"></path><path d="M557.3 406.6H308c-22.1 0-40 17.9-40 40v155.9c0 22.1 17.9 40 40 40h249.3c22.1 0 40-17.9 40-40V446.6c0-22-17.9-40-40-40zM738.8 412.7L655 491c-19.5 18.2-19.5 49 0 67.2l83.8 78.3c14.2 13.3 37.5 3.2 37.5-16.2V428.9c0-19.4-23.3-29.5-37.5-16.2z" fill="#7463EA" p-id="1917"></path><path d="M557.3 394.6H308c-22.1 0-40 17.9-40 40v155.9c0 22.1 17.9 40 40 40h249.3c22.1 0 40-17.9 40-40V434.6c0-22-17.9-40-40-40zM738.8 400.7L655 479c-19.5 18.2-19.5 49 0 67.2l83.8 78.3c14.2 13.3 37.5 3.2 37.5-16.2V416.9c0-19.4-23.3-29.5-37.5-16.2z" fill="#FFFFFF" p-id="1918"></path></svg>',
    'wmv':'<svg t="1628147353936" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1915" width="16" height="16"><path d="M65.3 755.4V269.9c0-78.1 63.3-141.3 141.3-141.3h612.9c78.1 0 141.3 63.3 141.3 141.3v485.5c0 78.1-63.3 141.3-141.3 141.3H206.7c-78.1 0-141.4-63.3-141.4-141.3z" fill="#8B72F7" p-id="1916"></path><path d="M557.3 406.6H308c-22.1 0-40 17.9-40 40v155.9c0 22.1 17.9 40 40 40h249.3c22.1 0 40-17.9 40-40V446.6c0-22-17.9-40-40-40zM738.8 412.7L655 491c-19.5 18.2-19.5 49 0 67.2l83.8 78.3c14.2 13.3 37.5 3.2 37.5-16.2V428.9c0-19.4-23.3-29.5-37.5-16.2z" fill="#7463EA" p-id="1917"></path><path d="M557.3 394.6H308c-22.1 0-40 17.9-40 40v155.9c0 22.1 17.9 40 40 40h249.3c22.1 0 40-17.9 40-40V434.6c0-22-17.9-40-40-40zM738.8 400.7L655 479c-19.5 18.2-19.5 49 0 67.2l83.8 78.3c14.2 13.3 37.5 3.2 37.5-16.2V416.9c0-19.4-23.3-29.5-37.5-16.2z" fill="#FFFFFF" p-id="1918"></path></svg>',
    'css':'<svg t="1595648386628" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="28352" width="16" height="16"><path d="M88.064 27.648l77.824 871.424L512 996.352l346.112-97.28 77.824-871.424z" fill="#2196F3" p-id="28353"></path><path d="M771.072 312.32l-10.24 109.568-29.696 328.704L512 811.008l-220.16-60.416-14.336-172.032h107.52l7.168 89.088L512 700.416l119.808-32.768 16.384-148.48-375.808 1.024-11.264-101.376 395.264-4.096 8.192-108.544-413.696 1.024-7.168-101.376h536.576z" fill="#FAFAFA" p-id="28354"></path></svg>',
    'txt':'<svg t="1628147567204" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="3040" width="16" height="16"><path d="M659.72 64.19H270.4c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.69c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.017 120.017 0 0 0-84.85-35.15z" fill="#4FD397" p-id="3041"></path><path d="M862.07 216.84l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81H894a119.975 119.975 0 0 0-31.93-57.29zM670.25 381.88H517.97a24.052 24.052 0 0 0-9.66 0H356.03c-13.25 0-24 10.75-24 24s10.75 24 24 24h133.11v258.73c0 13.25 10.75 24 24 24s24-10.75 24-24V429.88h133.11c13.25 0 24-10.75 24-24s-10.75-24-24-24z" fill="#19BC6E" p-id="3042"></path><path d="M670.25 369.88H517.97a24.052 24.052 0 0 0-9.66 0H356.03c-13.25 0-24 10.75-24 24s10.75 24 24 24h133.11v258.73c0 13.25 10.75 24 24 24s24-10.75 24-24V417.88h133.11c13.25 0 24-10.75 24-24s-10.75-24-24-24z" fill="#FFFFFF" p-id="3043"></path></svg>',
    'zip':'<svg t="1628147464924" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2343" width="16" height="16"><path d="M659.72 64.81H270.4c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V302.3c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#FFC757" p-id="2344"></path><path d="M304.85 196.81h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 196.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM304.85 396.81h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 396.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM455.65 552.02H321.52c-17.07 0-30.91 13.84-30.91 30.91v155.48c0 17.07 13.84 30.91 30.91 30.91h134.13c17.07 0 30.91-13.84 30.91-30.91V582.93c0-17.07-13.84-30.91-30.91-30.91z m-4.93 164.59c0 13.72-11.12 24.84-24.84 24.84h-74.6c-13.72 0-24.84-11.12-24.84-24.84v-27.36c0-13.72 11.12-24.84 24.84-24.84h74.6c13.72 0 24.84 11.12 24.84 24.84v27.36zM862.07 217.45l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81H894a120.021 120.021 0 0 0-31.93-57.29z" fill="#F79F2B" p-id="2345"></path><path d="M304.85 184.81h71.52c7.86 0 14.24-6.38 14.24-14.24V99.05c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 184.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM304.85 384.81h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 384.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM455.65 540.02H321.52c-17.07 0-30.91 13.84-30.91 30.91v155.48c0 17.07 13.84 30.91 30.91 30.91h134.13c17.07 0 30.91-13.84 30.91-30.91V570.93c0-17.07-13.84-30.91-30.91-30.91z m-4.93 164.59c0 13.72-11.12 24.84-24.84 24.84h-74.6c-13.72 0-24.84-11.12-24.84-24.84v-27.36c0-13.72 11.12-24.84 24.84-24.84h74.6c13.72 0 24.84 11.12 24.84 24.84v27.36z" fill="#FFFFFF" p-id="2346"></path></svg>',
    'rar':'<svg t="1628147464924" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2343" width="16" height="16"><path d="M659.72 64.81H270.4c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V302.3c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#FFC757" p-id="2344"></path><path d="M304.85 196.81h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 196.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM304.85 396.81h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 396.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM455.65 552.02H321.52c-17.07 0-30.91 13.84-30.91 30.91v155.48c0 17.07 13.84 30.91 30.91 30.91h134.13c17.07 0 30.91-13.84 30.91-30.91V582.93c0-17.07-13.84-30.91-30.91-30.91z m-4.93 164.59c0 13.72-11.12 24.84-24.84 24.84h-74.6c-13.72 0-24.84-11.12-24.84-24.84v-27.36c0-13.72 11.12-24.84 24.84-24.84h74.6c13.72 0 24.84 11.12 24.84 24.84v27.36zM862.07 217.45l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81H894a120.021 120.021 0 0 0-31.93-57.29z" fill="#F79F2B" p-id="2345"></path><path d="M304.85 184.81h71.52c7.86 0 14.24-6.38 14.24-14.24V99.05c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 184.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM304.85 384.81h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.87-6.38-14.24-14.24-14.24h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.86 6.38 14.24 14.24 14.24zM476.37 384.81h-71.52c-7.86 0-14.24 6.38-14.24 14.24v71.52c0 7.87 6.38 14.24 14.24 14.24h71.52c7.86 0 14.24-6.38 14.24-14.24v-71.52c0-7.86-6.38-14.24-14.24-14.24zM455.65 540.02H321.52c-17.07 0-30.91 13.84-30.91 30.91v155.48c0 17.07 13.84 30.91 30.91 30.91h134.13c17.07 0 30.91-13.84 30.91-30.91V570.93c0-17.07-13.84-30.91-30.91-30.91z m-4.93 164.59c0 13.72-11.12 24.84-24.84 24.84h-74.6c-13.72 0-24.84-11.12-24.84-24.84v-27.36c0-13.72 11.12-24.84 24.84-24.84h74.6c13.72 0 24.84 11.12 24.84 24.84v27.36z" fill="#FFFFFF" p-id="2346"></path></svg>',
    'pdf':'<svg t="1628147523409" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2771" width="16" height="16"><path d="M658.68 63.95H269.36c-78.06 0-141.33 63.28-141.33 141.33v612.95c0 78.06 63.28 141.33 141.33 141.33h485.49c78.06 0 141.33-63.28 141.33-141.33V301.44c0-31.83-12.64-62.35-35.15-84.85l-117.5-117.5a120.008 120.008 0 0 0-84.85-35.14z" fill="#FF7878" p-id="2772"></path><path d="M861.03 216.59l-117.5-117.5a120.001 120.001 0 0 0-61.75-32.9v131.88c0 41.87 33.94 75.81 75.81 75.81h135.37a120.058 120.058 0 0 0-31.93-57.29zM649.24 554.59c-22.79 0-45.38 3.31-68.16 7.6-26.87-24.76-49.66-54-66.99-86.56 18.5-60.63 19.47-101.76 5.45-121.26-6.43-8.58-17.14-14.04-28.04-14.04-14.02-0.97-27.07 5.46-33.5 17.35-19.47 32.56 8.76 96.5 21.81 122.43-15 46.59-33.5 91.04-57.25 134.32-102.82 44.45-104.97 71.54-104.97 81.29 0 11.89 6.43 23.78 18.31 29.24 4.28 3.12 10.71 4.29 16.16 4.29 27.07 0 58.42-30.41 91.92-90.06 42.26-17.35 84.32-31.39 128.73-41.13 22.79 19.49 50.83 30.41 80.04 32.56 18.5 0 54.14 0 53.75-37.04 1.17-14.04-6.43-37.82-57.26-38.99zM353.53 696.45l-3.26 1.17c9.6-14.06 22.26-25 38.38-31.64-8.44 14.26-20.15 25-35.12 30.47z m132.59-322.36c1.02-1.16 3.17-2.35 4.4-2.35l3.57 1.19c5.52 18.41 5.52 37.8-1.23 56.02-7.96-17.26-11.23-36.64-6.74-54.86zM542.26 584c-23.61 5.5-49.55 13.17-73.16 21.81l-2.45 0.96 0.32-1.94c11.81-23.97 22.64-49.13 32.32-74.28l1.16-2.45 1.17 1.47c12 18.47 27.2 37.51 43.46 53.82l-2.82 0.61z m111.17 13.58c-10.87-0.95-21.54-3.04-32.4-8.35 9.7-2.09 18.24-2.09 27.94-2.09 21.54 0 25.81 5.32 26 8.35-6.41 2.09-13.98 3.23-21.54 2.09z" fill="#F25555" p-id="2773"></path><path d="M648.96 575.14c-9.7 0-18.24 0-27.94 2.09 10.87 5.32 21.54 7.4 32.4 8.35 7.57 1.14 15.14 0 21.54-2.09-0.19-3.03-4.46-8.35-26-8.35z m-147.34-57.57l-1.17-1.47-1.16 2.45c-9.68 25.15-20.52 50.31-32.32 74.28l-0.32 1.94 2.45-0.96c23.61-8.65 49.55-16.31 73.16-21.81l2.81-0.61c-16.25-16.32-31.45-35.35-43.45-53.82z m-7.52-156.65l-3.57-1.19c-1.23 0-3.38 1.19-4.4 2.35-4.5 18.22-1.23 37.6 6.75 54.85 6.74-18.21 6.74-37.59 1.22-56.01z m-143.83 324.7l3.26-1.17c14.97-5.47 26.68-16.21 35.12-30.47-16.12 6.64-28.78 17.58-38.38 31.64z m302.48-67c-29.21-2.14-57.25-13.06-80.04-32.56-44.4 9.75-86.47 23.78-128.73 41.13-33.5 59.65-64.85 90.06-91.92 90.06-5.45 0-11.88-1.17-16.16-4.29-11.88-5.46-18.31-17.35-18.31-29.24 0-9.75 2.14-36.84 104.97-81.29 23.76-43.28 42.26-87.73 57.25-134.32-13.05-25.93-41.29-89.87-21.81-122.43 6.43-11.89 19.47-18.32 33.5-17.35 10.91 0 21.62 5.46 28.04 14.04 14.02 19.49 13.05 60.63-5.45 121.26 17.33 32.56 40.12 61.8 66.99 86.56 22.79-4.29 45.38-7.6 68.16-7.6 50.83 1.17 58.42 24.95 57.25 38.99 0.4 37.04-35.24 37.04-53.74 37.04z" fill="#FFFFFF" p-id="2774"></path></svg>',
    'ini':'<svg t="1628147596605" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="3309" width="16" height="16"><path d="M659.8 64.2H270.4c-78.1 0-141.3 63.3-141.3 141.3v612.9c0 78.1 63.3 141.3 141.3 141.3h485.5c78.1 0 141.3-63.3 141.3-141.3V301.7c0-31.8-12.6-62.3-35.1-84.9L744.6 99.3c-22.5-22.5-53-35.1-84.8-35.1z" fill="#8B72F7" p-id="3310"></path><path d="M861.7 216.8L744.2 99.3c-17-17-38.5-28.3-61.7-32.9v131.9c0 41.9 33.9 75.8 75.8 75.8h135.4c-5.2-21.6-16.1-41.5-32-57.3zM585.6 350.4H440.8c-17.2 0-33.1 9.2-41.7 24.1l-72.4 125.4c-8.6 14.9-8.6 33.3 0 48.2l72.4 125.4c8.6 14.9 24.5 24.1 41.7 24.1h144.8c17.2 0 33.1-9.2 41.7-24.1l72.4-125.4c8.6-14.9 8.6-33.3 0-48.2l-72.4-125.4c-8.6-14.9-24.5-24.1-41.7-24.1z m-71 247.7c-42 0.8-76.2-33.4-75.5-75.5 0.7-39.6 33.1-71.9 72.7-72.7 42-0.8 76.2 33.4 75.5 75.5-0.8 39.6-33.1 71.9-72.7 72.7z" fill="#7463EA" p-id="3311"></path><path d="M585.6 338.4H440.8c-17.2 0-33.1 9.2-41.7 24.1l-72.4 125.4c-8.6 14.9-8.6 33.3 0 48.2l72.4 125.4c8.6 14.9 24.5 24.1 41.7 24.1h144.8c17.2 0 33.1-9.2 41.7-24.1l72.4-125.4c8.6-14.9 8.6-33.3 0-48.2l-72.4-125.4c-8.6-14.9-24.5-24.1-41.7-24.1z m-71 247.7c-42 0.8-76.2-33.4-75.5-75.5 0.7-39.6 33.1-71.9 72.7-72.7 42-0.8 76.2 33.4 75.5 75.5-0.8 39.6-33.1 71.9-72.7 72.7z" fill="#FFFFFF" p-id="3312"></path></svg>',
    'exe':'<svg t="1628149388921" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4419" width="16" height="16"><path d="M901.191108 74.070502a49.380335 49.380335 0 0 1 49.380334 49.380335v214.804455a49.380335 49.380335 0 0 1-49.380334 49.380335H686.386652a49.380335 49.380335 0 0 1-49.380335-49.380335V123.450837a49.380335 49.380335 0 0 1 49.380335-49.380335h214.804456m0-74.070502H686.386652a123.450837 123.450837 0 0 0-123.450837 123.450837v214.804455a123.450837 123.450837 0 0 0 123.450837 123.450837h214.804456a123.450837 123.450837 0 0 0 123.450836-123.450837V123.450837A123.450837 123.450837 0 0 0 901.191108 0z" fill="#3764F8" p-id="4420"></path><path d="M0 0m123.450837 0l214.804455 0q123.450837 0 123.450837 123.450837l0 214.804455q0 123.450837-123.450837 123.450837l-214.804455 0q-123.450837 0-123.450837-123.450837l0-214.804455q0-123.450837 123.450837-123.450837Z" fill="#3764F8" p-id="4421"></path><path d="M0 562.293871m123.450837 0l214.804455 0q123.450837 0 123.450837 123.450837l0 214.804455q0 123.450837-123.450837 123.450837l-214.804455 0q-123.450837 0-123.450837-123.450837l0-214.804455q0-123.450837 123.450837-123.450837Z" fill="#3764F8" p-id="4422"></path><path d="M562.985196 562.293871m123.450836 0l214.804456 0q123.450837 0 123.450837 123.450837l0 214.804455q0 123.450837-123.450837 123.450837l-214.804456 0q-123.450837 0-123.450836-123.450837l0-214.804455q0-123.450837 123.450836-123.450837Z" fill="#3764F8" p-id="4423"></path></svg>',
    'json':'<svg t="1629365965704" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2298" width="16" height="16"><path d="M909.696 1003.2H194.496a31.808 31.808 0 0 1-31.488-32V51.2c0-17.6 14.144-32 31.488-32h545.408l201.216 224v728a31.36 31.36 0 0 1-31.424 32z" fill="#FFFFFF" p-id="2299"></path><path d="M746.24 4.8H194.496A46.08 46.08 0 0 0 148.864 51.2v920c0 25.6 20.48 46.4 45.632 46.4h715.2a46.08 46.08 0 0 0 45.568-46.4V237.568L746.24 4.864z m-7.872 32.832L915.2 234.432h-159.552a17.6 17.6 0 0 1-17.28-17.6v-179.2z m171.328 951.936H194.496a17.6 17.6 0 0 1-17.28-17.536V51.2c0-9.6 7.808-17.6 17.28-17.6h515.584v182.4c0 25.6 20.416 46.4 45.568 46.4h172.16v709.632a18.304 18.304 0 0 1-18.112 17.536z" fill="#C0C0C0" p-id="2300"></path><path d="M575.68 223.168a31.872 31.872 0 0 1 33.792 32v560c0 19.2-15.744 34.432-34.56 32L97.728 800a31.872 31.872 0 0 1-28.288-32V305.6a32 32 0 0 1 29.056-32zM281.792 374.4h-21.568c-33.408 0-60.864 25.408-60.864 57.536v44.288c0 16.832-14.208 25.6-31.552 27.264-6.144 0.64-14.208 7.808-14.208 16.896 0 8.64 8.576 17.024 14.272 17.6 17.408 1.792 31.872 10.176 31.872 26.944v44.352c0 32.064 27.136 61.056 60.48 61.056h18.88c14.464 0 17.6-9.28 17.6-16.96 0-7.68-3.008-17.28-17.6-17.28h-18.88c-15.168 0-24.96-12.16-24.96-26.752v-44.352c0-14.08-7.808-27.072-18.24-37.12a9.984 9.984 0 0 1 0-14.464c10.368-10.112 18.176-23.104 18.176-37.12v-44.352c0-14.912 10.368-23.04 24.96-23.04h21.632c6.848 0 14.72-6.4 14.72-17.28 0-10.432-7.872-17.28-14.72-17.28z m123.52-1.92H386.56c-14.464 0-17.6 9.216-17.6 16.896 0 7.68 3.008 17.28 17.6 17.28h18.88c15.168 0 24.96 12.16 24.96 26.752v44.352c0 14.08 7.808 27.072 18.24 37.12a9.984 9.984 0 0 1 0 14.464c-10.368 10.112-18.176 23.04-18.176 37.12v44.352c0 14.912-10.368 23.04-24.96 23.04h-21.632c-6.848 0-14.72 6.4-14.72 17.28 0 10.432 7.872 17.28 14.72 17.28h21.568c33.408 0 60.864-25.472 60.864-57.6v-44.288c0-16.832 14.208-25.6 31.552-27.264 6.144-0.64 14.208-7.872 14.208-16.896 0-8.64-8.576-17.024-14.272-17.6-17.408-1.792-31.872-10.176-31.872-26.944v-44.352c0-32.064-27.136-61.056-60.48-61.056zM332.544 485.76a17.664 17.664 0 0 0-17.92 17.408v104c0 9.6 8.128 17.408 17.92 17.408 9.856 0 17.92-7.808 17.92-17.408V503.232a17.664 17.664 0 0 0-17.92-17.408z m0-52.224a17.664 17.664 0 0 0-17.92 17.344c0 9.6 8.128 17.408 17.92 17.408 9.856 0 17.92-7.808 17.92-17.408a17.664 17.664 0 0 0-17.92-17.344z" fill="#36B2C0" p-id="2301"></path></svg>',
    'java':'<svg t="1629366002257" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1250" width="16" height="16"><path d="M558.08 472.064c48.128 53.248-13.312 103.424-13.312 103.424s119.808-61.44 65.536-139.264c-51.2-71.68-91.136-107.52 122.88-232.448 0 1.024-335.872 86.016-175.104 268.288" fill="#FF0000" p-id="1251"></path><path d="M610.304 5.12s101.376 101.376-96.256 258.048C356.352 389.12 478.208 460.8 514.048 543.744 420.864 459.776 354.304 386.048 399.36 317.44 463.872 216.064 651.264 166.912 610.304 5.12" fill="#FF0000" p-id="1252"></path><path d="M720.896 757.76c183.296-95.232 98.304-188.416 39.936-175.104-15.36 3.072-21.504 5.12-21.504 5.12s5.12-8.192 16.384-11.264c117.76-40.96 207.872 120.832-37.888 186.368-1.024 0 2.048-3.072 3.072-5.12m-337.92 38.912s-37.888 21.504 26.624 29.696c76.8 8.192 117.76 8.192 202.752-8.192 0 0 23.552 15.36 53.248 26.624-191.488 80.896-433.152-5.12-282.624-48.128m-23.552-106.496s-43.008 31.744 23.552 37.888c82.944 8.192 149.504 10.24 261.12-13.312 0 0 16.384 16.384 40.96 24.576-231.424 68.608-490.496 5.12-325.632-49.152" fill="#396397" p-id="1253"></path><path d="M811.008 876.544s27.648 23.552-31.744 40.96c-111.616 34.816-460.8 45.056-558.08 2.048-34.816-15.36 31.744-35.84 51.2-40.96 21.504-5.12 34.816-3.072 34.816-3.072-38.912-28.672-251.904 52.224-107.52 75.776 390.144 62.464 712.704-28.672 611.328-74.752M400.384 578.56s-178.176 43.008-63.488 56.32c49.152 6.144 146.432 5.12 235.52-3.072 73.728-6.144 147.456-19.456 147.456-19.456s-26.624 11.264-45.056 24.576c-181.248 48.128-530.432 26.624-430.08-23.552 88.064-39.936 155.648-34.816 155.648-34.816" fill="#396397" p-id="1254"></path><path d="M418.816 1015.808c176.128 11.264 446.464-6.144 453.632-90.112 0 0-13.312 31.744-146.432 56.32-150.528 27.648-336.896 24.576-446.464 6.144 2.048 1.024 24.576 20.48 139.264 27.648" fill="#396397" p-id="1255"></path></svg>'
}
def get_suffix(name):
    if not '.' in name:
        return ""
    return name.split(".")[-1]

def get_svg(path):
    path_split=path.replace("\\","/").split("/")
    last_name=path_split[-1]
    if not last_name:#应对path后面还加了一个斜杠的情况。
        if len(path_split)<2:
            return svg_by_type["unknown"]
        else:
            last_name=path_split[-2]
    del path_split
    if not os.path.exists("./%s"%path):
        return svg_by_type["unknown"]
    if os.path.isdir("./%s"%path):
        if last_name==".git":
            return svg_by_type["git"]
        return svg_by_type["folder"]
    elif os.path.isfile("./%s"%path):
        if last_name.find(".git")==0:
            return svg_by_type["git"]
        if last_name.find("jquery")==0:
            return svg_by_type["jquery"]
        if last_name.find("bootstrap")==0:
            return svg_by_type["bootstrap"]
        suffix=get_suffix(last_name)
        return svg_by_suffix.get(suffix,svg_by_type["unknown"])
